
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/structures/str_vector.psl.c
   ----- CREATED   : by f-hataza@icot22, on Thu May 17 19:55:11 1990
   ----- LAST SAVED: by kawai@icot22, on Wed Oct 16 17:54:08 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : STRUCTURES
   ----- ABSTRACT  : $B%Y%/%?$NA`:n(B

  0.  $B%Y%/%?$N%G!<%?9=B$(B
  1.  $B%Y%/%?%?%$%W$N@_Dj(B
  2.  $B%Y%/%?%5%$%:$N<h$j=P$7(B
  3.  $B%Y%/%?$N3d$jIU$1(B
  4.  $B%Y%/%?$N2s<}(B
  5.  $B%Y%/%?MWAG$X$NCM$N=q$-9~$_(B/$BFI$_$@$7(B
    5.1  $BB(CM$K$h$kMWAG%*%U%;%C%H;XDj(B
    5.2  $B%l%8%9%?$K$h$kMWAG%*%U%;%C%H;XDj(B
    5.3  $B%l%8%9%?$K$h$kMWAG0LCV;XDj(B
  6.  $B%Y%/%?MWAG$N%3%T!<(B
    6.1  $BA4MWAG$N%3%T!<(B
    6.2  $B:FMxMQMWAG$N%3%T!<(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
  0.  $B%Y%/%?$N%G!<%?9=B$(B

       written by f-hataza@icot22      on Thu May 17 20:02:29 1990

 (1) NullVector ($BMWAG?t(B:0)
    +------------+
    |VECT0!    0 |   ($BCMIt$N(B0$B$O!"J]>Z$7$J$$(B)
    +------------+

 (2) ShortVector ($BMWAG?t(B:1~8)
    +------------+                     +-----------------+
    |VECTn!    --+-------------------> |$B%Y%/%?$NBh(B 0 $BMWAG(B|
    +------------+                     +-----------------+
         (n=1~8)                       |$B%Y%/%?$NBh(B 1 $BMWAG(B|
                                       +-----------------+
                                       /                 /
                                       /                 /
                                       +-----------------+ 
                                       |$B%Y%/%?$NBh(Bn-1$BMWAG(B|
                                       +-----------------+

 (3) LongVector ($BMWAG?t(B:9$B0J>e(B)
                                       +-----------------+
                                       | INT !    $BMWAG?t(B |
    +------------+                     +-----------------+
    |VECT!     --+-------------------> |$B%Y%/%?$NBh(B 0 $BMWAG(B|
    +------------+                     +-----------------+
                                       |$B%Y%/%?$NBh(B 1 $BMWAG(B|
                                       +-----------------+
                                       /                 /
                                       /                 /
                                       +-----------------+ 
                                       |$B%Y%/%?$NBh(Bn-1$BMWAG(B|
                                       +-----------------+

********************************************************************* PSL **/

#CONST_define _VECT_TYPE_BASE       VECT0       /* VECT0$B$H(B VECT1... $B$,(B
                                                 * $BO"B3$G$"$k;~(B
                                                 */

#CONST_define _SIZE_OF_VECT1 		1	/* 1 word in 1 word cell */
#CONST_define _SIZE_OF_VECT2 		2	/* 2 words in 2 word cell */
#CONST_define _SIZE_OF_VECT3 		3	/* 3 words in 4 word cell */
#CONST_define _SIZE_OF_VECT4 		4	/* 4 words in 4 word cell */
#CONST_define _SIZE_OF_VECT5 		5	/* 5 words in 8 word cell */
#CONST_define _SIZE_OF_VECT6 		6	/* 6 words in 8 word cell */
#CONST_define _SIZE_OF_VECT7 		7	/* 7 words in 8 word cell */
#CONST_define _SIZE_OF_VECT8 		8	/* 8 words in 8 word cell */

/* $B%7%g!<%H%Y%/%?$r(B8$BMWAG$^$G$H$9$k$+$O!"=hM}7O$K0MB8$9$k!#(B */
#CONST_define _MAX_SIZE_OF_SVECT	_SIZE_OF_VECT8

/* $B$I$NBg$-$5$N%Y%/%?$,:FMxMQ$G$-$k$+$O!"=hM}7O$K0MB8$9$k!#(B */
#CONST_define _MIN_SIZE_OF_REUSE_VECT	_SIZE_OF_VECT1
#CONST_define _MAX_SIZE_OF_REUSE_VECT	_SIZE_OF_VECT8

#ADDR_define _VECT_SIZE_OFST_LVECT	-1

#ADDR_define _ELEM1_OFST_VECT		0
#ADDR_define _ELEM2_OFST_VECT		1
#ADDR_define _ELEM3_OFST_VECT		2
#ADDR_define _ELEM4_OFST_VECT		3
#ADDR_define _ELEM5_OFST_VECT		4
#ADDR_define _ELEM6_OFST_VECT		5
#ADDR_define _ELEM7_OFST_VECT		6
#ADDR_define _ELEM8_OFST_VECT		7

/******************************************************************** PSL **
  1.  $B%Y%/%?%?%$%W$N@_Dj(B
     s_SetShortVectTypeMRBoff (size_reg, vect_reg)

       written by f-hataza@icot22      on Thu May 17 22:00:01 1990
<Arguments>
    size_reg : $B%Y%/%?%5%$%:$r;}$D%l%8%9%?(B
    vect_reg : $B%?%$%W$r@_Dj$9$k%l%8%9%?(B ($B%7%g!<%H%Y%/%?$X$N%]%$%s%?(B)

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B%l%8%9%?(Bvect_reg$B$N%?%$%W$K!"(Bsize_reg $B$K$h$C$F(BVECT1~VECT8$B$r@_Dj$9$k!#(B
<Examples>
    klb_reuse.psl.c
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_SetShortVectTypeMRBoff (size_reg, vect_reg)
{
  ValueSwitch(size_reg) {
    case _SIZE_OF_VECT1: b_SetImmTypeMRBoff(VECT1,vect_reg); break;
    case _SIZE_OF_VECT2: b_SetImmTypeMRBoff(VECT2,vect_reg); break;
    case _SIZE_OF_VECT3: b_SetImmTypeMRBoff(VECT3,vect_reg); break;
    case _SIZE_OF_VECT4: b_SetImmTypeMRBoff(VECT4,vect_reg); break;
    case _SIZE_OF_VECT5: b_SetImmTypeMRBoff(VECT5,vect_reg); break;
    case _SIZE_OF_VECT6: b_SetImmTypeMRBoff(VECT6,vect_reg); break;
    case _SIZE_OF_VECT7: b_SetImmTypeMRBoff(VECT7,vect_reg); break;
    case _SIZE_OF_VECT8: b_SetImmTypeMRBoff(VECT8,vect_reg); break;
    default: 
      @DEBUG{OUT_OF_SPEC("s_SetShortVectTypeMRBoff","Illegal_svect_size");};
  } /* end of ValueSwitch */
}

/******************************************************************** PSL **
  2.  $B%Y%/%?%5%$%:$N<h$j=P$7(B

       written by goto@icot22      Tue Jan 10 13:29:09 1989

<Arguments>
  vect_ptr_reg : $B%Y%/%?$X$N%]%$%s%?$r;}$D%l%8%9%?(B
  dst_size_reg : $B%Y%/%?$NMWAG?t(B($B%5%$%:(B)$B$r=q$-9~$`%l%8%9%?(B
<Temporally Used Variables> none
<Level> structures
<PreCondition>
<Function>
    vect_ptr_reg $B$,;X$9%Y%/%?$NMWAG?t$r(B dst_size_reg $B$KJV$9(B.
      s_GetSizeVectType (vect_ptr_reg, dst_size_reg) 
        $B%Y%/%?A4HLMQ(B ($B%7%g!<%H%Y%/%?(B $B$+(B $B%m%s%0%Y%/%?(B $B$+$,!"$O$C$-$j$7$F$$$l$P(B
        $B<!$N(B2$B$D$N$$$:$l$+$r;H$&$3$H(B)
      s_GetSizeShortVect(vect_ptr_reg, dst_size_reg)
        $B%7%g!<%H%Y%/%?MQ(B
      s_GetSizeLongVect (vect_ptr_reg, dst_size_reg)
        $B%m%s%0%Y%/%?MQ(B
<Examples>
<Test>
<Explanation>
  PIM $B<B5!8~$1$N<BAu$G$O(B, VECT0 .. VECT8 $B$N%?%0$NFCDj$N%S%C%H%U%#!<%k%I$K(B
  $B%Y%/%?$NMWAG?t$,$"$k$3$H$rMxMQ$7$?A`:n$H$9$k(B.
  	(==> $B<B5!8~$1(B $BMW8!F$(B !!!! )
<ETC>
********************************************************************* PSL **/

#PSL_define s_GetSizeVectType (vect_ptr_reg, dst_size_reg)
{
  @PROBE {s_CountType(vect_ptr_reg); };
  @DEBUG {b_WarningIfSameRegNum(vect_ptr_reg, dst_size_reg); };
  TypeSwitch(vect_ptr_reg) {
    case ShortVectorGrp():
	s_GetSizeShortVect(vect_ptr_reg, dst_size_reg);
	break;
    case LongVectorGrp() :
	s_GetSizeLongVect(vect_ptr_reg, dst_size_reg);
	break;
    case NullVectorGrp() :
	b_MoveWithImmTypeMRBoff(D_NULL, INT, dst_size_reg);
	break;
    default:
	@DEBUG{ VPIM_ERROR("s_GetVectSizeType", "Illegal Type"); };
	break;
  }
}

#PSL_define s_GetSizeShortVect(vect_ptr_reg, dst_size_reg)
{
  @DEBUG {
    b_WarningIfSameRegNum (vect_ptr_reg, dst_size_reg);
    s_IfNotShortVectors (vect_ptr_reg) {
      VPIM_ERROR ("s_GetSizeShortVect", "Illegal_Type");
    }
  };
  p_MoveTypeToValue(vect_ptr_reg, dst_size_reg);
  b_SubtractImmediateWithDNTC(dst_size_reg, _VECT_TYPE_BASE, dst_size_reg);
  b_SetImmTypeMRBoff(INT, dst_size_reg);
}
  
#PSL_define s_GetSizeLongVect (vect_ptr_reg, dst_size_reg)
{
  @DEBUG {
    b_WarningIfSameRegNum (vect_ptr_reg, dst_size_reg);
    s_IfNotVECT (vect_ptr_reg) {
      VPIM_ERROR ("s_GetSizeLongVect", "Illegal_Type");
    }
  };
  p_ReadWithOffset (vect_ptr_reg, _VECT_SIZE_OFST_LVECT, dst_size_reg);
    /* $B%G%#%9%/%j%W%?$N%?%$%W$O(BINT$B$J$N$G!"@_Dj$NI,MW$O$J$$(B */
}

/******************************************************************** PSL **
  3.  $B%Y%/%?$N3d$jIU$1(B

       written by goto@icot22             Fri Nov 11 17:18:20 1988
       revised by nakagosh@icot21      on Fri May 19 16:52:15 1989

<Arguments>
  dst_reg : $B%Y%/%?$r3d$jIU$1$k%l%8%9%?(B
<Temporally Used Variables> none
<Level>
<PreCondition>
<Function>
  s_AllocVect0(dst_reg): $B%J%k%Y%/%?(B"{}"$B$r(Bdst_reg$B$K3d$jIU$1$k!#(B
  s_AllocVect1(dst_reg): 1$BMWAG%Y%/%?(B"{X}"$B$r(Bdst_reg$B$K3d$jIU$1$k!#(B(MRB$B$O(BOFF)
  s_AllocVect2(dst_reg): 2$BMWAG%Y%/%?(B"{X,Y}"$B$r(Bdst_reg$B$K3d$jIU$1$k!#(B(MRB$B$O(BOFF)
  :
  s_AllocVect8(dst_reg): 8$BMWAG%Y%/%?(B"{X1,..., X8}"$B$r(Bdst_reg$B$K3d$jIU$1$k!#(B
                                                                  (MRB$B$O(BOFF)
  s_AllocLongVect_Sub (size_reg, dst_reg)
  	$BMWAG?t(B size_reg $B$N%Y%/%?$r(Bdst_reg$B$K3d$jIU$1$k!#(B(MRB$B$O(BOFF)
        $B!&%R!<%WNN0h$,B-$j$J$$>l9g!"(Bdst_reg $B$K(BD_NULL$B$,JV$k!#(B
          $B$3$N>l9g!"$3$N%k!<%A%s$r8F$S=P$7$?B&$G!"(B D-Code$B$r:n$j(B
          $B%(%s%-%e!<$9$k=hM}$r=q$/I,MW$,$"$k!#(B
<Examples>
<Test>
<Explanation>
  $B%Y%/%?$r%-%c%C%7%e%V%m%C%/6-3&$KCV$/$?$a$K(B, VECT3 $B$K$O(B4word$BNN0h$r(B, VECT5$B$+$i(B
  VECT8 $B$K$O(B 8 word$BNN0h$r3d$jIU$1$k!#(B
<ETC>
<Revised Memo on "May 19">
********************************************************************* PSL **/

/**** Allocate Null Vector ****/
#PSL_define s_AllocVect0(dst_reg)
{ 
  b_MoveWithImmTypeMRBoff(D_NULL, VECT0, dst_reg);
}

/**** Allocate Short Vector ****/
#PSL_define s_AllocVect1(dst_reg)
{
  b_Alloc1(dst_reg, VECT1);
}

#PSL_define s_AllocVect2(dst_reg)
{
  b_Alloc2(dst_reg, VECT2);
}

#PSL_define s_AllocVect3(dst_reg)
{
  b_Alloc4(dst_reg, VECT3);
}

#PSL_define s_AllocVect4(dst_reg)
{
  b_Alloc4(dst_reg, VECT4);
}

#PSL_define s_AllocVect5(dst_reg)
{
  b_Alloc8(dst_reg, VECT5);
}

#PSL_define s_AllocVect6(dst_reg)
{
  b_Alloc8(dst_reg, VECT6);
}

#PSL_define s_AllocVect7(dst_reg)
{
  b_Alloc8(dst_reg, VECT7);
}

#PSL_define s_AllocVect8(dst_reg)
{
  b_Alloc8(dst_reg, VECT8);
}

#PSL_define s_AllocShortVector(size_reg, src_reg)
{ 
  ValueSwitch(size_reg) {
  case 1: b_Alloc1(src_reg, VECT1) ; break;
  case 2: b_Alloc2(src_reg, VECT2) ; break;
  case 3: b_Alloc4(src_reg, VECT3) ; break;
  case 4: b_Alloc4(src_reg, VECT4) ; break;
  case 5: b_Alloc8(src_reg, VECT5) ; break;
  case 6: b_Alloc8(src_reg, VECT6) ; break;
  case 7: b_Alloc8(src_reg, VECT7) ; break;
  case 8: b_Alloc8(src_reg, VECT8) ; break;
  default:
    @DEBUG{ VPIM_ERROR("s_AllocShortVector","Illegal-size");};
  }
}

/**** Allocate Long Vector ****/

#SUBARG_define 	A_LongVectSize	SRC
#SUBARG_define 	A_DestVector	DST

#SUBROUTINE s_AllocLongVect_Sub (A_LongVectSize, A_DestVector)
{
  @DEBUG { 
    b_IfLessEqImm (A_LongVectSize, _MAX_SIZE_OF_SVECT) {
      VPIM_ERROR ("s_AllocLongVect_Sub", "Too small size");
    }
  };
  b_IfLessImm (A_LongVectSize, _SIZE_OF_FL16) {
    b_AllocN (A_DestVector, D_Free_16_PtrReg, _SIZE_OF_FL16, VECT);
  } else {
    b_IfLessImm (A_LongVectSize, _SIZE_OF_FL32) {
      b_AllocN (A_DestVector, D_Free_32_PtrReg, _SIZE_OF_FL32, VECT);
    } else {
      b_IfLessImm (A_LongVectSize, _SIZE_OF_FL64) {
	b_AllocN (A_DestVector, D_Free_64_PtrReg, _SIZE_OF_FL64, VECT);
      } else {
	b_IfLessImm (A_LongVectSize, _SIZE_OF_FL128) {
	  b_AllocN (A_DestVector, D_Free_128_PtrReg, _SIZE_OF_FL128, VECT);
	} else {
	  b_IfLessImm (A_LongVectSize, _SIZE_OF_HEAP_PAGE) {
	    b_AllocOneHeapPage(A_DestVector);
            b_IncrementAddrReg(A_DestVector);   /* $B%]%$%s%?$r(B2$B%o!<%IL\$K(B */
	    b_SetImmTypeMRBoff(VECT, A_DestVector);
	  } else {
	    b_IncrementReg(A_LongVectSize);
	    b_AllocMultipleHeapPage (A_LongVectSize, A_DestVector);
	    b_DecrementReg(A_LongVectSize);
            b_IfWordEq(A_DestVector, D_NULL) {
              goto End;
            }
	    /* $B%R!<%WNN0h$,B-$j$J$$>l9g!"(BA_DestVector$B$K(BD_NULL$B$,JV$k!#(B
	     * $B$3$N>l9g!"$3$N%k!<%A%s$r8F$S=P$7$?B&$G!"(B
	     * D-Code$B$r:n$j%(%s%-%e!<$9$k=hM}$r=q$/I,MW$,$"$k!#(B
	     */
            b_IncrementAddrReg(A_DestVector);   /* $B%]%$%s%?$r(B2$B%o!<%IL\$K(B */
	    b_SetImmTypeMRBoff(VECT, A_DestVector);
	  }
	}
      }
    }
  }
  b_WriteImmTagWithOffset( _MRB_OFF, INT,
			  A_LongVectSize, A_DestVector, _VECT_SIZE_OFST_LVECT);
      /*  $B%Y%/%?$N%5%$%:$r%?%0(B INT $B$G=q$-9~$`!#(B*/

End:
  $RETURN ();
}

/******************************************************************** PSL **
  4.  $B%Y%/%?$N2s<}(B

       written by goto@icot22      Tue Jan 10 13:32:21 1989

<Arguments>
  src_reg  : $B2s<}$9$k%Y%/%?$X$N%]%$%s%?$r;}$D%l%8%9%?(B
  size_reg : $B2s<}$9$k%Y%/%?$N%5%$%:$r;}$D%l%8%9%?(B 
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B!&(Bs_ReclaimVect1(src_reg) .. s_ReclaimVect8(src_reg) 
	src_reg $B$G;X$5$l$F$$$k%Y%/%?$r%U%j!<%j%9%H$K2s<}$9$k(B.
  $B!&(Bs_ReclaimShortVector(src_reg)
	src_reg $B$G;X$5$l$F$$$k%7%g!<%H%Y%/%?$r%U%j!<%j%9%H$K2s<}$9$k!#(B
  $B!&(Bs_ReclaimLongVector(size_reg, src_reg) 
	src_reg $B$G;X$5$l$F$$$k%m%s%0%Y%/%?$r%U%j!<%j%9%H$K2s<}$9$k!#(B
        $BC"$7!"%Z!<%8C10L0J>e$N%Y%/%?$N2s<}$O!"%/%i%9%?$G6&M-$N%U%j!<%j%9%H(B
	$B$K2s<}$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_ReclaimVect1(src_reg)
{
  b_Reclaim1(src_reg);
}

#PSL_define s_ReclaimVect2(src_reg)
{
  b_Reclaim2(src_reg);
}

#PSL_define s_ReclaimVect3(src_reg)
{
  b_Reclaim4(src_reg);
}

#PSL_define s_ReclaimVect4(src_reg)
{
  b_Reclaim4(src_reg);
}

#PSL_define s_ReclaimVect5(src_reg)
{
  b_Reclaim8(src_reg);
}

#PSL_define s_ReclaimVect6(src_reg)
{
  b_Reclaim8(src_reg);
}

#PSL_define s_ReclaimVect7(src_reg)
{
  b_Reclaim8(src_reg);
}

#PSL_define s_ReclaimVect8(src_reg)
{
  b_Reclaim8(src_reg);
}

#PSL_define s_ReclaimShortVector(src_reg)
{ 
  TypeSwitch(src_reg) {
  case VECT1: s_ReclaimVect1(src_reg) ; break;
  case VECT2: s_ReclaimVect2(src_reg) ; break;
  case VECT3: s_ReclaimVect3(src_reg) ; break;
  case VECT4: s_ReclaimVect4(src_reg) ; break;
  case VECT5: s_ReclaimVect5(src_reg) ; break;
  case VECT6: s_ReclaimVect6(src_reg) ; break;
  case VECT7: s_ReclaimVect7(src_reg) ; break;
  case VECT8: s_ReclaimVect8(src_reg) ; break;
  default:
    @DEBUG{ VPIM_ERROR("s_ReclaimShortVector","Illegal-type");};
  }
}

#PSL_define s_ReclaimLongVector (size_reg, src_reg)
{
  @DEBUG { 
    b_IfLessImm (size_reg, _MAX_SIZE_OF_SVECT) {
      VPIM_ERROR ("s_ReclaimLongVector", "Too small size");
    }
  };

  b_IfLessImm (size_reg, _SIZE_OF_FL16) {
      b_ReclaimN (src_reg, D_Free_16_PtrReg, _SIZE_OF_FL16);
  } else {
      b_IfLessImm (size_reg, _SIZE_OF_FL32) {
	  b_ReclaimN (src_reg, D_Free_32_PtrReg, _SIZE_OF_FL32);
      } else {
	  b_IfLessImm (size_reg, _SIZE_OF_FL64) {
	      b_ReclaimN (src_reg, D_Free_64_PtrReg, _SIZE_OF_FL64);
	  } else {
	      b_IfLessImm (size_reg, _SIZE_OF_FL128) {
		b_ReclaimN (src_reg, D_Free_128_PtrReg, _SIZE_OF_FL128);
	  } else {
	    /* $B%Z!<%8%5%$%:0J>e(B */
	    $USE(D_WorkVectorSize);
	    b_BitwiseAndImmediateWithDNTC(size_reg,_MASK_FOR_PAGE_SIZE,
					  D_WorkVectorSize);
	    b_AddImmediateWithDNTC(D_WorkVectorSize,_SIZE_OF_HEAP_PAGE,
				   D_WorkVectorSize);
	    $USE(D_WorkPagePtr);
	    b_AddImmediateWithTag(src_reg,_VECT_SIZE_OFST_LVECT,D_WorkPagePtr);
	    b_ReclaimMultipleHeapPage(D_WorkVectorSize,D_WorkPagePtr);
	    $RELEASE(D_WorkPagePtr);
	    $RELEASE(D_WorkVectorSize);
	  }
	}
      }
  }
}

/******************************************************************** PSL **
  5.  $B%Y%/%?MWAG$X$NCM$N=q$-9~$_(B/$BFI$_$@$7(B
    5.1  $BB(CM$K$h$kMWAG%*%U%;%C%H;XDj(B

       written by goto@icot22      Tue Jan 10 13:33:25 1989

<Arguments>
  vect_ptr_reg : $B%Y%/%?$X$N%]%$%s%?$r;}$D%l%8%9%?(B
  imm_ofst     : $BB(CM$N%"%I%l%9$N%*%U%;%C%H(B ($BMWAGHV9f$G$O$J$$$3$H$KCm0U(B)
  src_reg      : $B=q$-9~$`CM$r;}$D%l%8%9%?(B
<Temporally Used Variables>
<Level> structures
<PreCondition>
<Function>
  s_PutVectElementImmOfst(vect_ptr_reg,imm_ofst,src_reg)
   $B!&(Bvect_ptr_reg$B$N;X$9%Y%/%?$N!"%*%U%;%C%H(Bimm_ofst$B$NMWAG$K!"(Bsrc_reg$B$NFbMF$r(B
     $B=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
<ETC>
  s_GetVectElementImmPos(vect_ptr_reg,imm_pos,dst_reg)$B$O!":o=|$5$l$?!#(B(89.8.22)
********************************************************************* PSL **/
#DATA_define D_WorkCheckVectSize	XXX 	/* DEBUG $B$N$_(B */

#PSL_define s_PutVectElementImmOfst(vect_ptr_reg, imm_ofst, src_reg)
{
  @DEBUG{
    b_WarningIfSameRegNum (vect_ptr_reg, src_reg);
    s_IfNotVectors(vect_ptr_reg) {
      VPIM_ERROR ("s_PutVectElementImmOfst", "Illegal_type");
    }
    $USE(D_WorkCheckVectSize);
    s_GetSizeVectType(vect_ptr_reg, D_WorkCheckVectSize);
    b_ExchangeElmposToOffset(D_WorkCheckVectSize, D_WorkCheckVectSize);
    b_IfLessEqImm (D_WorkCheckVectSize, imm_ofst){
      VPIM_ERROR ("s_PutVectElementImmOfst", "VectElement Overflow");
    }
    $RELEASE(D_WorkCheckVectSize);
  };
  p_WriteWithOffset(src_reg, vect_ptr_reg, imm_ofst);
}

#PSL_define s_GetVectElementImmOfst(vect_ptr_reg, imm_ofst, dst_reg)
{
  @DEBUG{
    b_WarningIfSameRegNum (vect_ptr_reg, dst_reg);
    s_IfNotVectors(vect_ptr_reg) {
      VPIM_ERROR ("s_PutVectElementImmOfst", "Illegal_type");
    }
    $USE(D_WorkCheckVectSize);
    s_GetSizeVectType(vect_ptr_reg, D_WorkCheckVectSize);
    b_ExchangeElmposToOffset(D_WorkCheckVectSize, D_WorkCheckVectSize);
    b_IfLessEqImm (D_WorkCheckVectSize, imm_ofst){
      VPIM_ERROR ("s_PutVectElementImmOfst", "VectElement Overflow");
    }
    $RELEASE(D_WorkCheckVectSize);
  };
  p_ReadWithOffset(vect_ptr_reg, imm_ofst, dst_reg);
}

/******************************************************************** PSL **
    5.2  $B%l%8%9%?$K$h$kMWAG%*%U%;%C%H;XDj(B

       written by goto@icot22      Tue Jan 10 13:33:25 1989

<Arguments>
  vect_ptr_reg : $B%Y%/%?$X$N%]%$%s%?$r;}$D%l%8%9%?(B
  ofst_reg     : $B%"%I%l%9$N%*%U%;%C%H;}$D%l%8%9%?(B ($BMWAGHV9f$G$O$J$$$3$H$KCm0U(B)
  src_reg      : $B=q$-9~$`CM$r;}$D%l%8%9%?(B
<Temporally Used Variables>
<Level> structures
<PreCondition>
<Function>
  s_PutVectElementOffsetReg(vect_ptr_reg,ofst_reg,src_reg)
   $B!&(Bvect_ptr_reg$B$N;X$9%Y%/%?$N!"%*%U%;%C%H(Bofst_reg$B$NMWAG$K!"(Bsrc_reg$B$NFbMF$r(B
     $B=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#PSL_define s_PutVectElementOffsetReg(vect_ptr_reg, ofst_reg, src_reg)
{
  @DEBUG{
    b_WarningIfSameRegNum (vect_ptr_reg, src_reg);
    s_IfNotVectors(vect_ptr_reg) {
      VPIM_ERROR ("s_PutVectElementOffsetReg", "Illegal_type");
    }
    $USE(D_WorkCheckVectSize);
    s_GetSizeVectType(vect_ptr_reg, D_WorkCheckVectSize);
    b_ExchangeElmposToOffset(D_WorkCheckVectSize, D_WorkCheckVectSize);
    b_IfLessEq (D_WorkCheckVectSize, ofst_reg){
      VPIM_ERROR ("s_PutVectElementOffsetReg", "VectElement Overflow");
    }
    $RELEASE(D_WorkCheckVectSize);
  };
  $USE(D_WorkElemAddr);
  b_AddWithDNTC(vect_ptr_reg, ofst_reg, D_WorkElemAddr);
  p_Write(src_reg, D_WorkElemAddr);
  $RELEASE(D_WorkElemAddr);
}

/******************************************************************** PSL **
    5.3  $B%l%8%9%?$K$h$kMWAG0LCV;XDj(B

       written by goto@icot22      Tue Jan 10 13:33:25 1989

<Arguments>
  vect_ptr_reg : $B%Y%/%?$X$N%]%$%s%?$r;}$D%l%8%9%?(B
  elm_pos_reg  : $B%l%8%9%?$K$h$kMWAG0LCV;XDj(B
  		($B0LCVHV9f$G$"$j(B, $B%"%I%l%9$G$J$$$3$H$KCm0U(B)
  src_reg      : $B=q$-9~$_$K$*$1$kCM$r;}$D%l%8%9%?(B
  dst_reg      : $BFI$_$@$7$?CM$r=q$-9~$`%l%8%9%?(B
<Temporally Used Variables>
  DEBUG $B$K$*$$$F$N$_(B D_WorkCheckVectSize
<Level> structures
<PreCondition>
<Function>
  s_PutVectElementPosReg(vect_ptr_reg, elm_pos_reg, src_reg)
   $B!&(Bvect_ptr_reg$B$N;X$9%Y%/%?$N!"(Belm_pos_reg$BHVL\$NMWAG$K!"(Bsrc_reg$B$NFbMF$r(B
     $B=q$-9~$`!#(B
  s_GetVectElementPosReg(vect_ptr_reg, elm_pos_reg, dst_reg)
   $B!&(Bvect_ptr_reg$B$N;X$9%Y%/%?$N!"(Belm_pos_reg$BHVL\$NMWAG$r!"(Bdst_reg$B$KFI$_=P$9!#(B
<Examples> f_GetVectorElement
<Test>
<Explanation>
  s_GetVectElementPosReg$B$G$O(B, vect_ptr_reg$B$N(BMRB$B$,(Bdst_reg$B$KB-$79~$^$l$k!#(B
<ETC>
********************************************************************* PSL **/

#PSL_define s_PutVectElementPosReg(vect_ptr_reg, elm_pos_reg, src_reg)
{
  @DEBUG{
    b_WarningIfSameRegNum (vect_ptr_reg, src_reg); 
    s_IfNotVectors(vect_ptr_reg) {
      VPIM_ERROR ("s_PutVectElementPosReg", "Illegal_type");
    }
    $USE(D_WorkCheckVectSize);
    s_GetSizeVectType(vect_ptr_reg, D_WorkCheckVectSize);
    b_IfLessEq (D_WorkCheckVectSize, elm_pos_reg){
      VPIM_ERROR ("s_PutVectElementPosReg", "VectElement Overflow");
    }
    $RELEASE(D_WorkCheckVectSize);
  };

  $USE(D_WorkElemAddr);
  s_GetStructElemAddrPosReg (vect_ptr_reg, elm_pos_reg, D_WorkElemAddr); 
  p_Write(src_reg, D_WorkElemAddr);
  $RELEASE(D_WorkElemAddr);
}

#PSL_define s_GetVectElementPosReg(vect_ptr_reg, elm_pos_reg, dst_reg)
{
  @DEBUG{
    b_WarningIfSameRegNum (vect_ptr_reg, dst_reg);
    s_IfNotVectors(vect_ptr_reg) {
      VPIM_ERROR ("s_GetVectElementPosReg", "Illegal_type");
    }
    $USE(D_WorkCheckVectSize);
    s_GetSizeVectType(vect_ptr_reg, D_WorkCheckVectSize);
    b_IfLessEq (D_WorkCheckVectSize, elm_pos_reg){
      VPIM_ERROR ("s_GetVectElementPosReg", "VectElement Overflow");
    }
    $RELEASE(D_WorkCheckVectSize);
  };

  $USE(D_WorkElemAddr);
  s_GetStructElemAddrPosReg (vect_ptr_reg, elm_pos_reg, D_WorkElemAddr);
  s_ReadWithMRBor(D_WorkElemAddr, dst_reg);
  $RELEASE(D_WorkElemAddr);
}

/******************************************************************** PSL **
  6.  $B%Y%/%?MWAG$N%3%T!<(B
    6.1  $BA4MWAG$N%3%T!<(B

       written by f-hataza@icot22      on Fri May 18 11:50:36 1990
<Arguments>
    A_SrcVect : $B%3%T!<85%Y%/%?$X$N%]%$%s%?$r;}$D%l%8%9%?(B
    A_DstVect : $B%3%T!<@h%Y%/%?$X$N%]%$%s%?$r;}$D%l%8%9%?(B
    A_CopySize: $B%3%T!<$9$k%Y%/%?$N%5%$%:$r;}$D%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
    $B%3%T!<@h$N%Y%/%?$O!"$9$G$K3d$jIU$1$i$l$F$$$k$b$N$H$9$k!#(B
<Function>
    s_CopyElemShortVect_Sub(A_SrcVect, A_DstVect)
      $B%7%g!<%H%Y%/%?$NA4MWAG$r%3%T!<$9$k!#(B
    s_CopyElemLongVect_Sub(A_SrcVect, A_CopySize, A_DstVect)
      $B%m%s%0%Y%/%?$NA4MWAG$r%3%T!<$9$k!#(B
<Examples>
<Test>
<Explanation>
    s_CopyStructElementWithOffset    : defined in str_small_struct.psl.c
    s_CopyStructElementWithRegOffset : defined in str_small_struct.psl.c
<ETC>
********************************************************************* PSL **/

#SUBARG_define	A_SrcVect	SRC
#SUBARG_define	A_DstVect	SRC

#SUBROUTINE s_CopyElemShortVect_Sub(A_SrcVect, A_DstVect)
{
   TypeSwitch(A_SrcVect) {
     case VECT8:
        s_CopyStructElementWithOffset(A_SrcVect,_ELEM8_OFST_VECT,A_DstVect);
     case VECT7:
        s_CopyStructElementWithOffset(A_SrcVect,_ELEM7_OFST_VECT,A_DstVect);
     case VECT6:
        s_CopyStructElementWithOffset(A_SrcVect,_ELEM6_OFST_VECT,A_DstVect);
     case VECT5:
        s_CopyStructElementWithOffset(A_SrcVect,_ELEM5_OFST_VECT,A_DstVect);
     case VECT4:
        s_CopyStructElementWithOffset(A_SrcVect,_ELEM4_OFST_VECT,A_DstVect);
     case VECT3:
        s_CopyStructElementWithOffset(A_SrcVect,_ELEM3_OFST_VECT,A_DstVect);
     case VECT2:
        s_CopyStructElementWithOffset(A_SrcVect,_ELEM2_OFST_VECT,A_DstVect);
     case VECT1:
        s_CopyStructElementWithOffset(A_SrcVect,_ELEM1_OFST_VECT,A_DstVect);
        break;
     default:
        @DEBUG{ VPIM_ERROR("s_CopyElemShortVect_Sub", "Illegal Type"); };
   }
   $RETURN();
}


#SUBARG_define	A_SrcVect	SRC
#SUBARG_define	A_CopySize	SRC
#SUBARG_define	A_DstVect	SRC

#SUBROUTINE s_CopyElemLongVect_Sub(A_SrcVect, A_CopySize, A_DstVect)
{
  $USE(D_WorkElemOfst);
  b_ExchangeElmposToOffset(A_CopySize, D_WorkElemOfst);
  b_DecrementAddrReg(D_WorkElemOfst);
  LOOP() {
    b_IfLess(D_WorkElemOfst, D_NULL) { break; }
    s_CopyStructElementWithRegOffset(A_SrcVect, D_WorkElemOfst, A_DstVect);
    b_DecrementAddrReg(D_WorkElemOfst);
  }
  $RELEASE(D_WorkElemOfst);   
  $RETURN();
}

/******************************************************************** PSL **
    6.2  $B:FMxMQMWAG$N%3%T!<(B

       written by f-hataza@icot22      on Fri May 18 12:14:42 1990
<Arguments>
    A_SrcPtr   : $B%3%T!<85$N%Y%/%?$^$?$O%j%9%H$X$N%]%$%s%?$r;}$D%l%8%9%?(B
    A_DstVect  : $B%3%T!<@h$N%Y%/%?$X$N%]%$%s%?$r;}$D%l%8%9%?(B
    A_CopySize : $B%3%T!<$9$k%Y%/%?$N%5%$%:;}$D%l%8%9%?(B
    A_Flag     : $B%3%T!<%U%i%0(B
<Temporally Used Variables>
<Level>
<PreCondition>
    $B%3%T!<@h$N%Y%/%?$O!"$9$G$K3d$jIU$1$i$l$F$$$k$b$N$H$9$k!#(B
<Function>
    $B%3%T!<%U%i%0$r8+$F!":FMxMQ$9$kMWAG$r%3%T!<$9$k!#(B
<Examples>
    klb_reuse.psl.c
<Test>
<Explanation>
   s_CopyStructElementWithRegOffset : defined in str_small_struct.psl.c
<ETC>
********************************************************************* PSL **/
#DATA_define    D_WorkCopyFlag1 XXX

#SUBARG_define	A_SrcPtr	SRC
#SUBARG_define	A_DstVect	SRC
#SUBARG_define	A_CopySize      MODIFY   /* $BK\Mh!"(BSRC$B$@$,GK2u$5$l$k(B */
#SUBARG_define	A_Flag		SRC

#SUBROUTINE s_CopyReuseElemVect_Sub (A_SrcPtr, A_DstVect, A_CopySize, A_Flag)
{
  LOOP(){
    b_IfLessEq(A_CopySize, D_NULL){ break; }
    b_DecrementReg(A_CopySize);
                    /* A_CopySize$B$OGK2u$9$k$,8F$S$@$785$G$O%F%s%]%i%j$G$"$k$?$a(B
		       $BLdBj$O$J$$!#(B*/
    $USE(D_WorkCopyFlag1);
    b_ShiftRightWithDNTC(A_Flag, A_CopySize, D_WorkCopyFlag1);
    b_BitwiseAndImmediateWithDNTC(D_WorkCopyFlag1, _ONE, D_WorkCopyFlag1);
    b_IfNotZero(D_WorkCopyFlag1) {
      $USE(D_WorkElemOfst);
      b_ExchangeElmposToOffset(A_CopySize, D_WorkElemOfst);
      s_CopyStructElementWithRegOffset(A_SrcPtr,D_WorkElemOfst,A_DstVect);
      $RELEASE(D_WorkElemOfst);
    }
    $RELEASE(D_WorkCopyFlag1);    
  } /* end of LOOP */
  $RETURN();
}
