
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/structures/str_trade_init.psl.c
   ----- CREATED   : by nakase@icot22, on Sat Jun  2 16:40:18 1990
   ----- LAST SAVED: by ttakagi@icot22, on Wed May  6 14:55:10 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : STRUCTURES
   ----- ABSTRACT  : $B%/%i%9%?4V%G!<%?;2>HMQ$NNN0h$H4XO"%G!<%?$N=i4|2=(B

1. $BDj?t5Z$S%0%m!<%P%k%l%8%9%?Dj5A(B

2. $B%/%i%9%?4V%G!<%?;2>H%F!<%V%k=i4|2=%k!<%A%s(B

3. $BM"=PI=%(%j%"$N=i4|2=(B

4. $BGrM"F~I=%(%j%"$N=i4|2=(B


$B!c%/%i%9%?4V%G!<%?;2>HMQNN0h$N%a%b%j%^%C%W!d(B


 _TRADE_AREA_BASE                     |                                     |
 _EXP_REC_BASE                        +-------------------------------------+
                                      |                                     |
                                      |    $BM"=PI=%(%j%"(B                     |
                                      |                                     | 
                                      |                                     |
                                     //                                    //
                                      |                                     |
 _WIMP_REC_BASE                       +-------------------------------------+
                                      |                                     |
                                      |    $BGrM"F~%l%3!<%I%(%j%"(B             |
                                      |                                     | 
                                      |                                     |
                                     //                                    //
                                      |                                     |
 _BEXP_HASH_TBL_BASE                  +-------------------------------------+
                                      |                                     |
                                      |    $B9uM"=P%O%C%7%eI=%(%j%"(B           |
                                      |                                     | 
                                      |                                     |
                                     //                                    //
                                      |                                     |
 _BIMP_HASH_TBL_BASE                  +-------------------------------------+
                                      |                                     |
                                      |    $B9uM"F~%O%C%7%eI=%(%j%"(B           |
                                      |                                     | 
                                      |                                     |
                                     //                                    //
                                      |                                     |
 _STR_ADDR_HASH_TBL_BASE              +-------------------------------------+
                                      |                                     |
                                      |    $B9=B$BN%"%I%l%9%O%C%7%eI=%(%j%"(B   |
                                      |                                     | 
                                      |                                     |
                                     //                                    //
                                      |                                     |
 _STR_ID_HASH_TBL_BASE                +-------------------------------------+
                                      |                                     |
                                      |    $B9=B$BN#I#D%O%C%7%eI=%(%j%"(B       |
                                      |                                     | 
                                      |                                     |
                                     //                                    //
                                      |                                     |
                                      +-------------------------------------+


 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
1. $BDj?t5Z$S%0%m!<%P%k%l%8%9%?Dj5A(B

       written by nakase@icot22      on Mon Jun  4 10:23:32 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#ADDR_define _EXP_REC_BASE   ( _TRADE_AREA_BASE + 0)

#CONST_define _EXP_REC_ENTRY_NUM   0x6000	/* 6000$B%(%s%H%j(B */

#ADDR_define  _NEXT_EXP_REC_OFST 1	/* $B0l$D$N%l%3!<%I$NBg$-$5$O#1%o!<%I(B */

#ADDR_define _EXP_REC_SIZE   (_EXP_REC_ENTRY_NUM * _NEXT_EXP_REC_OFST)

#ADDR_define _WIMP_REC_BASE  ( _EXP_REC_BASE + _EXP_REC_SIZE )

#CONST_define _WIMP_REC_ENTRY_NUM  0x2000 

#ADDR_define  _NEXT_WIMP_REC_OFST 1	/* $B0l$D$N%l%3!<%I$NBg$-$5$O#1%o!<%I(B */

#ADDR_define _WIMP_REC_SIZE   (_WIMP_REC_ENTRY_NUM  * _NEXT_WIMP_REC_OFST)

#ADDR_define _BEXP_HASH_TBL_BASE  ( _WIMP_REC_BASE + _WIMP_REC_SIZE )

#ADDR_define _BEXP_HASH_TBL_SIZE   0x1000

#CONST_define _BEXP_HASH_TBL_MASK  0x0fff

#ADDR_define _BIMP_HASH_TBL_BASE  ( _BEXP_HASH_TBL_BASE + _BEXP_HASH_TBL_SIZE )
 
#ADDR_define _BIMP_HASH_TBL_SIZE   0x1000

#CONST_define _BIMP_HASH_TBL_MASK  0x0fff

#ADDR_define _STR_ADDR_HASH_TBL_BASE  ( _BIMP_HASH_TBL_BASE + _BIMP_HASH_TBL_SIZE )

#ADDR_define _STR_ADDR_HASH_TBL_SIZE   0x1000

#CONST_define _STR_ADDR_HASH_TBL_MASK  0x0fff

#ADDR_define _STR_ID_HASH_TBL_BASE  ( _STR_ADDR_HASH_TBL_BASE + _STR_ADDR_HASH_TBL_SIZE)

#ADDR_define _STR_ID_HASH_TBL_SIZE   0x1000

#CONST_define _STR_ID_HASH_TBL_MASK  0x0fff

/******************************************************************** PSL **
2. $B%/%i%9%?4V%G!<%?;2>H%F!<%V%k=i4|2=%k!<%A%s(B

       written by nakase@icot22      on Mon Jun  4 16:00:26 1990

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_InitAllTradeAreas()
{
  s_InitExpArea();
  s_InitWImpRecTable();
  s_InitHashArea(_BEXP_HASH_TBL_BASE, _BEXP_HASH_TBL_SIZE);
                 /* $B9uM"=P%O%C%7%eI=%(%j%"$N=i4|2=(B */
  s_InitHashArea(_BIMP_HASH_TBL_BASE, _BIMP_HASH_TBL_SIZE);
                 /* $B9uM"F~%O%C%7%eI=%(%j%"$N=i4|2=(B */
  s_InitHashArea(_STR_ADDR_HASH_TBL_BASE, _STR_ADDR_HASH_TBL_SIZE);
                 /* $B9=B$BN%"%I%l%9%O%C%7%eI=%(%j%"$N=i4|2=(B */
  s_InitHashArea(_STR_ID_HASH_TBL_BASE, _STR_ID_HASH_TBL_SIZE);
                 /* $B9=B$BN#I#D%O%C%7%eI=%(%j%"$N=i4|2=(B */
}

/******************************************************************** PSL **
3. $BM"=PI=%(%j%"$N=i4|2=(B

       written by nakase@icot22      on Sat Jun  2 17:40:17 1990

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
$B!NM"=PI=%(%j%"=i4|2=8e$N>uBV!O(B

                                    |                             |   
                   _EXP_REC_BASE    +=============================+
                        offset(0)   |        $B#E#O#L(B               | 
                                    +-----------------------------+
                        offset(1)   |FLCo !           0           | 
                                    +-----------------------------+
                        offset(2)   |FLCo !           1           | 
                                    +-----------------------------+
                        offset(3)   |FLCo !           2           | 
                                    +-----------------------------+
_MEM_MANAGE_AREA_BASE+              |                             | 
_EXP_TABLE_ENTRY_TOP_OFST           //                           //
[                          ]--+     |                             | 
                              +---> +-----------------------------+
           offset(_EXP_REC_SIZE-1)  |FLCo !                       | 
                                    +=============================+
                                    |                             | 

<ETC>
********************************************************************* PSL **/

#PSL_define s_InitExpArea()
{
  $USE(D_WorkPtr);
  $USE(D_WorkCounter);
  b_MoveWithImmTypeMRBoff(D_NULL, FLC, D_WorkPtr);
                  /* D_WorkPtr$B$,(B
		     $BM"=P%l%3!<%I$N%*%U%;%C%H#0$r;X$9$h$&$K$9$k(B */
  b_SetImmValueDNTC(_EXP_REC_ENTRY_NUM,D_WorkCounter);
                  /* D_WorkCounter$B$KM"=P%l%3!<%I$N%(%s%H%j?t$,F~$l$i$l$k(B */
  b_WriteSharedArea
    (D_EOL, _MEM_MANAGE_AREA_BASE, _EXP_TABLE_ENTRY_FREE_TOP_OFST);
  LOOP(){
    s_ReclaimEntryOfExpTableforInit(D_WorkPtr);
    p_AddImmediate(D_WorkPtr, _NEXT_EXP_REC_OFST, D_WorkPtr);
    b_DecrementReg(D_WorkCounter);
    p_IfLE() { break;}
  }
  $RELEASE(D_WorkCounter);
  $RELEASE(D_WorkPtr);
}

/******************************************************************** PSL **
4. $BGrM"F~I=%(%j%"$N=i4|2=(B

       written by nakase@icot22      on Mon Jun  4 12:22:55 1990

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>

$B!NGrM"F~I=%(%j%"=i4|2=8e$N>uBV!O(B

                                    |                             |   
                   _WIMP_REC_BASE   +=============================+
                                    |        $B#E#O#L(B               | 
                                    +-----------------------------+ 
                                    |FLCo !                       | 
                                    +-----------------------------+
                                    |FLCo !                       | 
                                    +-----------------------------+
                                    |FLCo !                       | 
                                    +-----------------------------+
_MEM_MANAGE_AREA_BASE +             |                             | 
_WIMP_REC_FREE_TOP_OFST             //                           //
[                   ]  -------+     |                             | 
                              +---> +-----------------------------+
                                    |FLCo !                       | 
                                    +=============================+
                                    |                             | 

<ETC>
********************************************************************* PSL **/

#PSL_define s_InitWImpRecTable()
{
  $USE(D_WorkPtr); 
  $USE(D_WorkCounter);
  b_SetImmTypeValueMRBoff(FLC, _WIMP_REC_BASE, D_WorkPtr);
  b_SetImmValueDNTC(_WIMP_REC_ENTRY_NUM, D_WorkCounter);
  b_WriteSharedArea(D_EOL,_MEM_MANAGE_AREA_BASE,_WIMP_REC_FREE_TOP_OFST);
  LOOP(){
    s_ReclaimWImpRec(D_WorkPtr);
    p_AddImmediate(D_WorkPtr, _NEXT_WIMP_REC_OFST, D_WorkPtr);
    b_DecrementReg(D_WorkCounter);
    p_IfLE() { break; }
  }
  $RELEASE(D_WorkPtr); $RELEASE(D_WorkCounter);
}

/******************************************************************** PSL **
5. $B%O%C%7%eI=%(%j%"$N=i4|2=(B

       written by nakase@icot22      on Mon Jun  4 14:55:12 1990

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  imm_tbl_base $B$+$i(B imm_tbl_base + imm_size $B$N4V$NItJ,$r(BEOL$B$G=i4|2=$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_InitHashArea( imm_tbl_base, imm_size)
{
  s_InitAllEOL(imm_tbl_base, imm_size);
}

#DATA_define D_WorkTblBase XXX

#PSL_define s_InitAllEOL(imm_tbl_base, imm_size)
{
  $USE(D_WorkTblBase);
  $USE(D_WorkCounter);
  b_SetImmValueDNTC(imm_tbl_base, D_WorkTblBase);
  b_SetImmValueDNTC(imm_size, D_WorkCounter);
  LOOP(){
    p_Write(D_EOL, D_WorkTblBase);
    b_IncrementAddrReg(D_WorkTblBase);
    b_DecrementAddrReg(D_WorkCounter);
	/* 1991.08.15 by A. Imai for byte addressing VPIM */
	/* b_DecrementReg $B$G$J$$$N$O(B imm_size $B$,(B #ADDR_define $B$5$l$F$$$k$?$a(B */
    p_IfLE(){break;}
  }
  $RELEASE(D_WorkCounter);
  $RELEASE(D_WorkTblBase);
}

/******************************************************************** PSL **
6. $B3F<o%U%i%0$N%Q%?!<%s%l%8%9%?$N=i4|2=(B

       written by nakase@icot22      on Mon Jun  4 16:11:30 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  WEX$B7O$G$O(Bstruct_flag$B$OI,MWL5$$!#(B
  BEX$B7O$G$O(Bunify_flag$B$OI,MWL5$$!#(B
   --> $B<BAu;~$O#1$D$N%U%i%0$K$9$k$N$,NI$$!#(B

<ETC>
********************************************************************* PSL **/

#DATA_define D_WEXREF_SAFE_STRUCToff_UNIFYoff_CLnum 		XXX
#DATA_define D_WEXREF_UNSAFE_STRUCToff_UNIFYoff_CLnum 		XXX

#DATA_define D_BEXREF_SAFE_STRUCToff_UNIFYoff_CLnum 		XXX
#DATA_define D_BEXREF_UNSAFE_STRUCToff_UNIFYoff_CLnum      	XXX

#DATA_define D_WEXVAL_SAFE_STRUCToff_UNIFYoff_CLnum 		XXX

#DATA_define D_BEXVAL_SAFE_STRUCToff_UNIFYoff_CLnum 		XXX
#DATA_define D_BEXVAL_SAFE_STRUCTon_UNIFYoff_CLnum 		XXX

#CONST_define _SAFE_STR_OFF_UNIFY_OFF     0x00000000
#CONST_define _SAFE_STR_OFF_UNIFY_ON      0x00200000
#CONST_define _SAFE_STR_ON_UNIFY_OFF      0x00400000
#CONST_define _SAFE_STR_ON_UNIFY_ON       0x00600000
#CONST_define _UNSAFE_STR_OFF_UNIFY_OFF   0x00800000
#CONST_define _UNSAFE_STR_OFF_UNIFY_ON    0x00A00000
#CONST_define _UNSAFE_STR_ON_UNIFY_OFF    0x00C00000
#CONST_define _UNSAFE_STR_ON_UNIFY_ON     0x00E00000



#PSL_define s_InitInitExRefIdFlags()
{
  $USE(D_WorkCLNum);
  b_ShiftLeftImmediate(D_CL_Number, _EXREF_ID_CLUSTER_NUM_OFST, D_WorkCLNum);
  p_BitwiseAndImmediate(D_WorkCLNum,_CL_NUM_MASK,D_WorkCLNum);

  /* WEXREF $B%?%0$N@_Dj(B */
  b_BitwiseOrImmediateWithDNTC(D_WorkCLNum,_SAFE_STR_OFF_UNIFY_OFF,
		       D_WEXREF_SAFE_STRUCToff_UNIFYoff_CLnum);
  b_SetImmTypeMRBoff(WEXREF, D_WEXREF_SAFE_STRUCToff_UNIFYoff_CLnum);

  b_BitwiseOrImmediateWithDNTC(D_WorkCLNum,_UNSAFE_STR_OFF_UNIFY_OFF,
		       D_WEXREF_UNSAFE_STRUCToff_UNIFYoff_CLnum);
  b_SetImmTypeMRBoff(WEXREF, D_WEXREF_UNSAFE_STRUCToff_UNIFYoff_CLnum);

  /* WEXVAL $B%?%0$N@_Dj(B */
  b_BitwiseOrImmediateWithDNTC(D_WorkCLNum,_SAFE_STR_OFF_UNIFY_OFF,
		       D_WEXVAL_SAFE_STRUCToff_UNIFYoff_CLnum);
  b_SetImmTypeMRBoff(WEXVAL, D_WEXVAL_SAFE_STRUCToff_UNIFYoff_CLnum);

  /* BEXREF $B%?%0$N@_Dj(B */
  b_BitwiseOrImmediateWithDNTC(D_WorkCLNum,_SAFE_STR_OFF_UNIFY_OFF,
		       D_BEXREF_SAFE_STRUCToff_UNIFYoff_CLnum);
  b_SetImmTypeMRBoff(BEXREF, D_BEXREF_SAFE_STRUCToff_UNIFYoff_CLnum);

  b_BitwiseOrImmediateWithDNTC(D_WorkCLNum,_UNSAFE_STR_OFF_UNIFY_OFF,
		       D_BEXREF_UNSAFE_STRUCToff_UNIFYoff_CLnum);
  b_SetImmTypeMRBoff(BEXREF, D_BEXREF_UNSAFE_STRUCToff_UNIFYoff_CLnum);

  /* BEXVAL $B%?%0$N@_Dj(B */
  b_BitwiseOrImmediateWithDNTC(D_WorkCLNum,_SAFE_STR_OFF_UNIFY_OFF,
		       D_BEXVAL_SAFE_STRUCToff_UNIFYoff_CLnum);
  b_SetImmTypeMRBoff(BEXVAL, D_BEXVAL_SAFE_STRUCToff_UNIFYoff_CLnum);

  b_BitwiseOrImmediateWithDNTC(D_WorkCLNum,_SAFE_STR_ON_UNIFY_OFF,
		       D_BEXVAL_SAFE_STRUCTon_UNIFYoff_CLnum);
  b_SetImmTypeMRBoff(BEXVAL, D_BEXVAL_SAFE_STRUCTon_UNIFYoff_CLnum);

  $RELEASE(D_WorkCLNum);
}

/******************************************************************** PSL **

7. $BM"=PF~=hM}MQDj?t%l%8%9%?$N=i4|2=(B

       written by nakase@icot22      on Mon Jun  4 20:21:45 1990

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/


#CONST_define _EXPORT_WEC_UNIT 		0x01000000

#CONST_define _SHOEN_WTC_UNIT           0x00000001

#CONST_define _SUPPLY_WTC_UNIT          0x01000000 /* */

/* #CONST_define _SUPPLY_WTC_UNIT          0x01000 /* */
/* for test of less WTC ( 91.02.04 REKI )
 * see also f_shoen_control.psl.c
 * #CONST_define _SUPPLY_WTC_UNIT       0x010
 */

#DATA_define D_EXPORT_WEC_UNIT 		XXX
#DATA_define D_EXPORT_WEC_UNIT_NEG_L 	XXX
#DATA_define D_EXPORT_WEC_UNIT_NEG_H 	XXX
#DATA_define D_WEC_ZERO 		XXX
#DATA_define D_SHOEN_WTC_UNIT           XXX
#DATA_define D_SUPPLY_WTC_UNIT          XXX
#DATA_define D_EOM_REG                  XXX

#PSL_define s_InitTradeMisc()
{
  b_SetImmTypeValueMRBoff(INT,_ZERO           , D_WEC_ZERO       );
  b_SetImmTypeValueMRBoff(INT,_EXPORT_WEC_UNIT, D_EXPORT_WEC_UNIT);

  b_SubtractImmediateWithDNTC
    (D_NULL, _EXPORT_WEC_UNIT, D_EXPORT_WEC_UNIT_NEG_L);
  b_SetImmTypeMRBoff(INT,D_EXPORT_WEC_UNIT_NEG_L);

  p_MoveWord(D_ALL1, D_EXPORT_WEC_UNIT_NEG_H);
  b_SetImmTypeMRBoff(INT,D_EXPORT_WEC_UNIT_NEG_H);

  b_SetImmTypeValueMRBoff(INT,_SHOEN_WTC_UNIT, D_SHOEN_WTC_UNIT);  
  b_SetImmTypeValueMRBoff(INT,_SUPPLY_WTC_UNIT, D_SUPPLY_WTC_UNIT);  

  b_SetImmTypeValueMRBon(FLC, _VALUE_OF_EOM, D_EOM_REG);
}


/******************************************************************** PSL **
PROBE $B$N=i4|2=(B

       written by nakase@icot22      on Sat Sep 22 14:22:11 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_InitTradeProbes()
{
  p_MoveWord(D_NULL,    D_ALLOC_WEXP_COUNT      );
  p_MoveWord(D_NULL,    D_ALLOC_BEXP_COUNT      );
  p_MoveWord(D_NULL,    D_ALLOC_WIMP_COUNT      );
  p_MoveWord(D_NULL,    D_ALLOC_BIMP_COUNT      );
  
  p_MoveWord(D_NULL,    D_RECLAIM_WEXP_COUNT    );
  p_MoveWord(D_NULL,    D_RECLAIM_BEXP_COUNT    );
  p_MoveWord(D_NULL,    D_RECLAIM_WIMP_COUNT    );
  p_MoveWord(D_NULL,    D_RECLAIM_BIMP_COUNT    );
  p_MoveWord(D_NULL,    D_RECLAIM_BIMP_ANSVAL_COUNT);
  p_MoveWord(D_NULL,     D_RECLAIM_BIMP_GC_COUNT);

  p_MoveWord(D_NULL,    D_TOTAL_BEXP_COUNT      );
  p_MoveWord(D_NULL,    D_TOTAL_BIMP_COUNT      );
  p_MoveWord(D_NULL,    D_REFIND_BEXP_COUNT     );
  p_MoveWord(D_NULL,    D_REFIND_BIMP_COUNT     );
  p_MoveWord(D_NULL,    D_TOTAL_REL_BEXP_COUNT      );

  p_MoveWord(D_NULL,    D_BIMP_SEP_WEC_COUNT    );

  p_MoveWord(D_NULL,    D_CURRENT_WEXP_COUNT    );
  p_MoveWord(D_NULL,    D_CURRENT_BEXP_COUNT    );
  p_MoveWord(D_NULL,    D_CURRENT_WIMP_COUNT    );
  p_MoveWord(D_NULL,    D_CURRENT_BIMP_COUNT    );

  p_MoveWord(D_NULL,    D_USE_BIMP_ONCE_COUNT    );
  p_MoveWord(D_NULL,    D_USE_BIMP_OVER_ONCE_COUNT    );

  p_MoveWord(D_NULL,    D_BIMP_SLOCK_SUC_COUNT  );
  p_MoveWord(D_NULL,    D_BIMP_SLOCK_FAIL_COUNT );

  p_MoveWord(D_NULL,    D_BIMPHS_SLOCK_SUC_COUNT  );
  p_MoveWord(D_NULL,    D_BIMPHS_SLOCK_FAIL_COUNT );

  p_MoveWord(D_NULL,    D_BIMP_SLOCK_SUC_COUNT_FP  );
  p_MoveWord(D_NULL,    D_BIMP_SLOCK_FAIL_COUNT_FP );

  p_MoveWord(D_NULL,    D_BIMPHS_SLOCK_SUC_COUNT_FP  );
  p_MoveWord(D_NULL,    D_BIMPHS_SLOCK_FAIL_COUNT_FP );

  p_MoveWord(D_NULL,    D_BEXP_SLOCK_SUC_COUNT  );
  p_MoveWord(D_NULL,    D_BEXP_SLOCK_FAIL_COUNT );

  p_MoveWord(D_NULL,    D_BEXPHS_SLOCK_SUC_COUNT  );
  p_MoveWord(D_NULL,    D_BEXPHS_SLOCK_FAIL_COUNT );

  p_MoveWord(D_NULL,    D_EX_SLOCK_SUC_COUNT );
  p_MoveWord(D_NULL,    D_EX_SLOCK_FAIL_COUNT);

  p_MoveWord(D_NULL,    D_USE_BEXP_ONCE_COUNT);
  p_MoveWord(D_NULL,    D_USE_BEXP_TWICE_COUNT);
  p_MoveWord(D_NULL,    D_USE_BEXP_OVER_TWICE_COUNT);

  p_MoveWord(D_NULL,    D_BEXP_REL_RESERVE_FAIL_COUNT);
  p_MoveWord(D_NULL,    D_BIMP_REL_RESERVE_FAIL_COUNT);

  p_MoveWord(D_NULL,    D_BEXP_SLOCK_SUC_COUNT_SH);
  p_MoveWord(D_NULL,    D_BEXP_SLOCK_FAIL_COUNT_SH);

  p_MoveWord(D_NULL,    D_BEXPHS_SLOCK_SUC_COUNT_SH);
  p_MoveWord(D_NULL,    D_BEXPHS_SLOCK_FAIL_COUNT_SH);

  p_MoveWord(D_NULL,    D_SHOEN_SLOCK_SUC_COUNT);
  p_MoveWord(D_NULL,    D_SHOEN_SLOCK_FAIL_COUNT);

  p_MoveWord(D_NULL,    D_FP_SLOCK_SUC_COUNT);
  p_MoveWord(D_NULL,    D_FP_SLOCK_FAIL_COUNT);

  p_MoveWord(D_NULL,    D_NOGC_WEXP_COUNT    );
  p_MoveWord(D_NULL,    D_NOGC_BEXP_COUNT    );
  p_MoveWord(D_NULL,    D_NOGC_WIMP_COUNT    );
  p_MoveWord(D_NULL,    D_NOGC_BIMP_COUNT    );

}
