
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V05/structures/str_suspend_stack.psl.c
   ----- CREATED   : by hirata@icot22, on Tue Jun 12 09:25:22 1990
   ----- LAST SAVED: by f-hataza@icot22, on Mon Jul  2 15:33:10 1990
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 

A. $B9`L\(B
  1. Definition of "SuspendStack" and related registers.
  2. $B%5%9%Z%s%I%9%?%C%/$N=i4|3d$jEv$F(B
  3. $B%5%9%Z%s%I4X78$N%U%i%0A`:n(B
  4. $B%5%9%Z%s%I%9%?%C%/$N%j%;%C%H(B
  5. $B%5%9%Z%s%I%9%?%C%/$X$N%W%C%7%e(B
  6. $B%5%9%Z%s%I%9%?%C%/$+$i$N%]%C%W(B
  7. $B%5%9%Z%s%I%9%?%C%/Fb$N=EJ#$N=|5n(B

B. $B%5%9%Z%s%IMW0x$rJ];}$9$k%5%9%Z%s%I%9%?%C%/(B, $B$*$h$S4XO"$9$k%l%8%9%?(B, $BA`:n(B
   $B$rDj5A$9$k!#(B

  $B!&%5%9%Z%s%I%9%?%C%/$O%5%9%Z%s%IMW0xJQ?t$X$N%]%$%s%?$r3JG<$9$k%9%?%C%/$G$"$k(B.
    $B$?$@$7(B, $B:G=i$NMW0x$N$_%l%8%9%?(B (D_SuspendStackCache) $B$K%-%c%C%7%e$9$k!#(B
    $B$3$l$K$h$j(B,  $BC10lBT$A$N%5%9%Z%s%I=hM}$N8zN($r>e$2$k!#(B

  $B!&%5%9%Z%s%I%9%?%C%/$O8GDjD9$G$"$j(B, $B=i4|2=(B(i_init_vpim.psl.c) $B$K$*$$$F(B,
    $B3FMWAG%W%m%;%C%5Kh$KMQ0U$9$k!#(B
	--> $B%5%9%Z%s%I%9%?%C%/$N0n$l$O(BKL1$B$N%3%s%Q%$%k;~$K%A%'%C%/$7$?J}$,NI$$!#(B

<DEBUG AID>
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
1. Definition of "SuspendStack" and related registers.

       written by goto@icot22      Tue Oct 18 09:15:55 1988

<Arguments>
<Temporally Used Variables>
<Level>	structures
<PreCondition>
<Function>

suspendstack	$B%5%9%Z%s%IMW0xJQ?t$X$N%]%$%s%?$r3JG<$9$k%9%?%C%/(B

#DATA_define	D_SuspendStackBase
	$B%5%9%Z%s%I%9%?%C%/$NDl$r;X$9%]%$%s%?%l%8%9%?(B.
#DATA_define	D_SuspendStackLimit
	$B%5%9%Z%s%I%9%?%C%/$N>e8B$r;X$9%]%$%s%?%l%8%9%?(B.
#DATA_define	D_SuspendStackPtr
	$B%5%9%Z%s%I%9%?%C%/$N%H%C%W$r;X$9%]%$%s%?%l%8%9%?(B.
#DATA_define	D_SuspendStackCache
	$B:G=i$N%5%9%Z%s%IMW0xJQ?t$rCV$/%l%8%9%?(B. 
        $B35G0E*$K$O(B, $B%9%?%C%/$NDl$N%-%c%C%7%e(B. 
        $B%5%9%Z%s%I$NB?$/$OC10lBT$A$G$"$k$H9M$($i$l$k(B.
#CONST_define	_SIZE_OF_SUSPEND_STACK


	D_SuspendStackCache (register/memory)
	+---------------+
	|		|
	+---------------+

	+---------------+ <---	D_SuspendStackLimit (memory)
	|		|	
	|		|
	|		|
	|		|
	|		|
	|		| <---	D_SuspendStackPtr (register/memory)
	|		|
	|		|
	+---------------+ <---	D_SuspendStackBase (memory)

<Examples>
<Test>
<Explanation>
	Suspend stacks keep the pointers to unbound variables which may
	cause the suspension of the goal.

	Each processor has a fixed size suspend stack in memory allocated as a
	static data structure.
	Three registers "D_SuspendStackBase", "D_SuspendStackLimit" and
	"D_SuspendStackPtr" are used to access it.
	In addition, one register "D_SuspendStackCache" is used to keep the
	first pointer to a variable.

	We can expect there are only few multiple-suspensions, so that
	"D_SuspendStackBase" and "D_SuspendStackLimit" are allocated in
	memory.
<ETC>
********************************************************************* PSL **/

/* #CONST_define _SIZE_OF_SUSPEND_STACK	 defined in bsc_mem_map */

#DATA_define D_SuspendStackLimit	XXX	/* $B8GDj(B in memory */
#DATA_define D_SuspendStackBase		XXX  	/* $B8GDj(B in memory */
#DATA_define D_SuspendStackPtr		XXX	/* register or memory */
#DATA_define D_SuspendStackCache	XXX	/* register or memory */

/******************************************************************** PSL **
2.  $B%5%9%Z%s%I%9%?%C%/$N=i4|3d$jEv$F(B

       written by goto@icot22      Tue Oct 18 09:55:08 1988

<Arguments>
  addr_base_reg : Local Area $B$N@hF,%"%I%l%9$r<($9%l%8%9%?(B
  addr_ofst_reg : $B%5%9%Z%s%I%9%?%C%/$N@hF,$r<($9(B addr_base_reg $B$+$i$N(B
		  $B%*%U%;%C%H$r;}$D%l%8%9%?(B
		( $B<B9T8e$O(B _SIZE_OF_SUSPEND_STACK $B$@$199?7$5$l$k!#(B)
<Temporally Used Variables> none
<Level>		structures
<PreCondition>	None
<Function>
	Initially allocate a suspend stack area and set the value of 
	"D_SuspendStackBase" and "D_SuspendStackLimit".
<Examples>
<Test>		Not yet.
<Explanation>
	$B%7%9%F%`$N=i4|2=$K$*$$$F(B, $B%5%9%Z%s%I%9%?%C%/(B(suspendstack)$BNN0h$r(B
	$B3d$jEv$F(B, $B%5%9%Z%s%I%9%?%C%/4XO"$N%l%8%9%?$r=i4|2=$9$k!#(B

<ETC>
********************************************************************* PSL **/

#PSL_define s_InitializeSuspendStack()
{ 
  b_SetImmValueDNTC(_LOCAL_MEM_SUSPEND_STACK_AREA_BASE, D_SuspendStackBase);
  b_SetImmValueDNTC(_LOCAL_MEM_SUSPEND_STACK_AREA_LIMIT,D_SuspendStackLimit);
  b_ConvertLocalMemAddrToGlobalMemAddr(D_SuspendStackBase,D_SuspendStackBase);
  b_ConvertLocalMemAddrToGlobalMemAddr(D_SuspendStackLimit,D_SuspendStackLimit);
  b_SetImmTypeMRBoff(REF,D_SuspendStackBase);
  b_SetImmTypeMRBoff(REF,D_SuspendStackLimit);
  s_ResetSuspendStack ();
}

/******************************************************************** PSL **
3. $B%5%9%Z%s%I4X78$N%U%i%0A`:n(B

       written by goto@icot22      Tue Oct 18 11:13:00 1988

<Arguments>	None
<Temporally Used Variables>
<Level>		structures
<PreCondition>	
<Function>
  s_SetValidSuspendStack ()	$B:G=i$N%5%9%Z%s%IMW0x$r(B D_SuspendCache $B$K(B
				$B%;%C%H$7$?;~%U%i%0$r%;%C%H(B

  s_IfValidSuspendStack ()	1$B8D0J>e$N%5%9%Z%s%IMW0x$,$"$k$H$-$K(BTRUE
  s_IfInvalidSuspendStack ()	$B%5%9%Z%s%IMW0x$,$^$C$?$/$J$$;~$K(BTRUE

  s_IfEmptySuspendStack ()	$B%5%9%Z%s%IMW0x$,$"$C$?$H$7$F$b9b!9(B1$B8D$N;~(BTRUE
  s_IfNotEmptySuspendStack ()	($B=EJ#$b4^$a$F(B) $BJ#?t8D$N%5%9%Z%s%IMW0x$,$"$k;~$K(B
				TRUE
<Examples>
<Test>	Not yet.
<Explanation>
  $B%5%9%Z%s%I%9%?%C%/%-%c%C%7%e$NM-8z(B/$BL58z%U%i%0$r(B 
  	D_SuspendStackPtr 
  $B$N%?%0It$HCM$G<($9$3$H$K$9$k!#$D$^$j(B, D_SuspendStackPtr $B$NFbMF$,(B
  	D_SuspendStackPtr = EOL!0 (== D_NULL) : $BL58z(B
  			  = REF! xxx : $BM-8z(B
  $B$H$9$k!#(B
<ETC>
********************************************************************* PSL **/

#PSL_define s_SetValidSuspendStack ()
{
  p_MoveWord (D_SuspendStackBase, D_SuspendStackPtr);
}
 
#CTRL_define s_IfValidSuspendStack ()
{
  s_IfREF (D_SuspendStackPtr)
}

#CTRL_define s_IfInvalidSuspendStack ()
{
  s_IfNotREF (D_SuspendStackPtr)
}

#CTRL_define s_IfEmptySuspendStack()
{
  @DEBUG{
    b_IfLess(D_SuspendStackPtr, D_SuspendStackBase){
      VPIM_ERROR ("s_IfEmptySuspendStack", "D_SuspendStackPtr underflow");
    }
  };
  b_IfEqual (D_SuspendStackPtr, D_SuspendStackBase)
}

#CTRL_define s_IfNotEmptySuspendStack()
{ 
  @DEBUG{
    b_IfLess(D_SuspendStackPtr, D_SuspendStackBase){
      VPIM_ERROR ("s_IfNotEmptySuspendStack", "D_SuspendStackPtr underflow");
    }
  };
  b_IfGreater(D_SuspendStackPtr, D_SuspendStackBase)
}

/******************************************************************** PSL **
4. $B%5%9%Z%s%I%9%?%C%/$N%j%;%C%H(B

       written by goto@icot22      Tue Oct 18 09:59:44 1988

<Arguments> none
<Temporally Used Variables> none
<Level>	structures
<PreCondition>
<Function>
  $B<!$N%4!<%k%j%@%/%7%g%s$r3+;O$9$kA0$K%5%9%Z%s%I%9%?%C%/$r=i4|2=$9$k(B.
<Examples>
<Test>
<Explanation>
  D_SuspendStackPtr $B$r(B D_NULL $B$H$9$k!#(B
<ETC>
********************************************************************* PSL **/

#PSL_define s_ResetSuspendStack()
{
  p_MoveWord (D_NULL, D_SuspendStackPtr);
}

/******************************************************************** PSL **
5. $B%5%9%Z%s%I%9%?%C%/$X$N%W%C%7%e(B

       written by goto@icot22      Tue Oct 18 11:21:35 1988

<Arguments>
	ptr_reg: a register pointing to an unbound variable.
<Temporally Used Variables>
<Level>	structures
<PreCondition>
	"reg" has a pointer to an unbound variable.
	Typeof(reg) = REF
	MRBof(reg) = ON or OFF
<Function>
	Push "ptr_reg" into the suspension stack.
	When the suspension stack is empty 
	it is saved in "D_SuspendStackCache".
	Otherwise, is written where "D_SuspendStackPtr" indicates, then
	"D_SuspendStackPtr" is incremented.
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_PushSuspendStack (ptr_reg)
{
  @PROBE2{ probe_increment_counter(D_PROBE_COUNTER_SUSPEND_STACK_PUSH);};
  @DEBUG{
    s_IfNotREF(ptr_reg) {VPIM_ERROR ("s_PushSuspendStack", "IllegalType");}
  };

  s_IfValidSuspendStack() {
    @DEBUG{
      b_IfGreaterEq(D_SuspendStackPtr, D_SuspendStackLimit){
	OUT_OF_SPEC ("s_PushSuspendStack", "SuspendStack Overflow");
      }
    };
    b_PushWordStack(D_SuspendStackPtr, ptr_reg);
  } else {
    p_MoveWord (ptr_reg, D_SuspendStackCache);
    s_SetValidSuspendStack();
  }
}

/******************************************************************** PSL **
6. $B%5%9%Z%s%I%9%?%C%/$+$i$N%]%C%W(B

       written by goto@icot22      Tue Oct 18 12:13:08 1988

<Arguments>
	reg: a register pointing to an unbound variable.
<Temporally Used Variables>
<Level>
	structures
<PreCondition>
	The contents of "reg" are VOID.
	$B%a%b%j$K3d$jEv$F$?%5%9%Z%s%I%9%?%C%/$O6u$G$O$J$$(B.
<Function>
	$B%a%b%j$K3d$jEv$F$?%5%9%Z%s%I%9%?%C%/$+$i(B"reg"$B$X%]%C%W$9$k!#(B
<Examples>
<Test>	Not yet.
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_PopSuspendStack(reg)
{
  @DEBUG{
    s_IfEmptySuspendStack() {
       VPIM_ERROR ("s_PopSuspendStack", "SuspendStack_Underflow");
    }
  };
  b_PopWordStack(D_SuspendStackPtr, reg);
  @DEBUG{
    s_IfNotREF(reg) {VPIM_ERROR ("s_PopSuspendStack", "IllegalType");}
  };
}

/******************************************************************** PSL **
7. $B%5%9%Z%s%I%9%?%C%/Fb$N=EJ#$N=|5n(B

       written by goto@icot22      Fri Oct 28 16:01:40 1988
<Arguments>        None
<Temporally Used Variables>
	D_WorkStackPtrReg
	D_WorkStackDataReg
<Level>	structure
<PreCondition>
<Function>
  $B%5%9%Z%s%I=hM}$K$*$$$F(B, s_IfValidSuspendStack() $B$H(B s_IfNotEmptySuspendStack()
  $B$N>r7o$,(BTRUE$B$N;~(B, D_SuspendStackCache $B$NFbMF$,%a%b%jB&$N(Bsuspendstack $B$N(B
  $BFbMF$H=EJ#$7$F$$$k$+$I$&$+D4$Y$k(B.
  $B$b$7=EJ#$7$F$$$?>l9g$O(B, suspendstack $B$+$i(B D_SuspendStackCache $B$X%]%C%W$7(B
  ($B$=$l$^$G$N(BD_SuspendStackCache$B$O<N$F$k(B), $B$=$l$K$D$$$F=EJ#$NM-L5$rD4$Y$k(B.
  $B=EJ#$,$J$/$J$C$?>l9g(B, $B$^$?$O(B suspendstack $B$,6u$K$J$C$?>l9g$K=*N;(B.

	D_WorkStackDataReg
	+---------------+
	|		|
	+---------------+

	+---------------+ 
	|		|
	|		|
	|		| <---	D_WorkStackPtrReg
	|		|
	|		|
	|		| <---	D_WorkStackSweepReg
	|		|
	|		|
	+---------------+ <---	D_SuspendStackBase

  marking phase$B$G$O!"(B
  D_WorkStackSweepReg$B$O!"(BStackPtrReg$B$+$i(BStackBase$B$K8~$+$C$F(Bsweep$B$9$k!#(B
  1$B2s(Bsweep$B$r$9$k$H!"(BD_WorkStackPtrReg$B$,0l$D(B($B0J>e(B)decrement$B$5$l$k!#(B
  compaction phase$B$G$O!"(B
  $B:G=i$K(BD_WorkStackPtrReg$B$O(BStackBase$B$r;X$7$F$$$k!#(B
  D_WorkStackSweepReg$B$,!"(BStackBase$B$+$i(BSuspendStackPtr$B$K8~$+$C$F(Bsweep$B$9$k!#(B
  unique$B$JMWAG$,8+$D$+$k$H(BD_WorkStackPtrReg$B$N@h$K=q$-9~$^$l(Bincrement$B$5$l$k!#(B

<Examples>
<Test>	Not yet.
<Explanation>
  $B=EJ#%A%'%C%/$O(Bsuspendstack$B$NMWAG?t(B N $B$KBP$7$F(B O(N^2)$B$N%3%9%H$,$+$+$k!#(B
  $BK\%^%/%m$r<B9T8e(B, s_IfEmptySuspendStack() $B$,(BTRUE$B$G$"$l$P%5%9%Z%s%I$O(B
  $BC10lBT$A(B, FALSE$B$G$"$l$PB?=EBT$A$H$J$k(B.

  $B<B9T=*N;8e(B " D_SuspendStackPtr - D_SuspendStackBase + 1 " $B$,=EJ#$N$J$$(B
  $BMW0x?t$H$J$k!#(B
<ETC>
  !! $BL$<BAu!"MW8!F$(B !!	   90/05/22	imai@icot22
  REFo --> VOID $B$O!"$3$N;~E@$G>C5n$9$k$3$H$G!"(BOR $BBT$AMW0x$+$i(B
  $B:o=|$9$k$3$H$,$G$-$k(B

********************************************************************* PSL **/

#DATA_define D_WorkStackDataReg XXX
#DATA_define D_WorkStackPtrReg 	XXX
#DATA_define D_WorkStackSweepReg 	XXX

#PSL_define s_GetUniqSuspendStack(){
  @DEBUG{
    s_IfInvalidSuspendStack() {
      VPIM_ERROR ("s_GetUniqSuspendStack", "Illegal call");
    }
  };

  $USE(D_WorkStackPtrReg);
  $USE(D_WorkStackSweepReg);
  $USE(D_WorkStackDataReg);

  /* MARKING $B%U%'!<%:(B */
				/* cache$BCf$N%G!<%?$r(Bstack$BK\BN$K=q$-La$9(B	*/
  b_PushWordStack(D_SuspendStackPtr, D_SuspendStackCache);
			/* stack$B$N(Btop$B$r(BD_WorkStackPtrReg$B$KBeF~$9$k(B	*/
  p_MoveWord(D_SuspendStackPtr, D_WorkStackPtrReg);
  LOOP () {
    LOOP () {		/* stack bottom$B$^$GMh$?$i(Bcompaction phase$B$X(B	*/
      b_IfEqual(D_WorkStackPtrReg, D_SuspendStackBase)
	{ goto Compaction_Phase; }
     /* WorkStackPtrReg$B$N;X$7$F$$$k@h$r(Bpop$B$7$F(BSuspendStackCache$B$KF~$l$k(B */
      b_PopWordStack(D_WorkStackPtrReg, D_SuspendStackCache);
		/* mark$B$5$l$F$$$k=j(B(D_NULL$B$,F~$C$F$$$k=j(B)$B$OHt$P$9(B	*/
      b_IfNotEqual(D_SuspendStackCache, D_NULL) { break; }
    }
    p_MoveWord(D_WorkStackPtrReg, D_WorkStackSweepReg);
    LOOP () {
      b_IfLessEq(D_WorkStackSweepReg, D_SuspendStackBase) { 
	break;	/* $B<!$NMWAG$K$D$$$FF1$8$b$N$,$"$k$+$r%A%'%C%/$7$K9T$/(B	*/
      } else {		/* D_WorkStackSweepReg > D_SuspendStackBase	*/
	b_PopWordStack(D_WorkStackSweepReg, D_WorkStackDataReg);
	b_IfEqual(D_WorkStackDataReg, D_SuspendStackCache) {
	/* $BF1$8$b$N$,8+$D$+$C$?$N$G!"$=$3$r(Bmark$B$9$k(B(D_NULL$B$rBeF~$9$k(B)	*/
	  p_Write(D_NULL, D_WorkStackSweepReg);
	} 
      } 
    } /* end of inner LOOP */
  } /* end of outer LOOP */

 Compaction_Phase:
  @DEBUG{
    b_IfNotEqual(D_WorkStackPtrReg, D_SuspendStackBase) {
      VPIM_ERROR ("s_GetUniqSuspendStack","Illegal_D_WorkStackPtrReg");
    }
    b_IfNotEqual(D_WorkStackSweepReg, D_SuspendStackBase) {
      VPIM_ERROR ("s_GetUniqSuspendStack","Illegal_D_WorkStackSweepReg");
    }
  };
  LOOP () {
    b_IfEqual(D_WorkStackSweepReg, D_SuspendStackPtr) { break;}
    p_Read(D_WorkStackSweepReg, D_WorkStackDataReg);
    b_IfNotEqual(D_WorkStackDataReg, D_NULL) {
      p_Write(D_WorkStackDataReg, D_WorkStackPtrReg);
      b_IncrementAddrReg(D_WorkStackPtrReg);      
    }
    b_IncrementAddrReg(D_WorkStackSweepReg);
  } /* end of LOOP */
			/* $BK\Ev$N(Bstack top$B$r(BSuspendStackPtr$B$K=q$-9~$`(B	*/
  p_MoveWord(D_WorkStackPtrReg,D_SuspendStackPtr);
					/* SuspendStackCache$B$r85$KLa$9(B	*/
  b_PopWordStack(D_SuspendStackPtr, D_SuspendStackCache);

  $RELEASE (D_WorkStackPtrReg);
  $RELEASE (D_WorkStackSweepReg);
  $RELEASE (D_WorkStackDataReg);
}

