
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/structures/str_suspend_record.psl.c
   ----- CREATED   : by f-hataza@icot22, on Mon May 21 18:37:02 1990
   ----- LAST SAVED: by imai@icot22, on Fri Feb 21 12:51:33 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : STRUCTURES
   ----- ABSTRACT  : $B%5%9%Z%s%I%l%3!<%I(B, $B%5%9%Z%s%I%U%i%0$H4pK\A`:n(B

A. $B9`L\(B
  1.  $B%5%9%Z%s%I%l%3!<%I$H%5%9%Z%s%I%U%i%0$NDj5A(B
  2.  $B%5%9%Z%s%I%l%3!<%I(B/$B%5%9%Z%s%I%U%i%0$N3d$jEv$F$H2s<}(B
  3.  $B%5%9%Z%s%I%l%3!<%I$N%9%m%C%H$X$N%"%/%;%9(B
  4.  $B%5%9%Z%s%I%U%i%0$N%9%m%C%H$X$N%"%/%;%9(B
  5.  $B%5%9%Z%s%I%U%i%0$N;2>H%+%&%s%H$NA`:n(B ($BGSB>%"%/%;%9IU$-(B)

B. $B%5%9%Z%s%I%l%3!<%I(B, $B%5%9%Z%s%I%U%i%0$NA`:n(B, $B3d$jEv$F(B, $B2s<}(B,
   $B$rDj5A$9$k!#(B

  (1) $B%7%s%0%kBT$A$N%5%9%Z%s%I%-%e!<(B

			Goalrecord	Goalrecord
	+-------+	+-------+	+-------+
	|HOOK!	+------>|HOOK!	+------>|EOL ! 0|
	+-------+	|	|	|	|
			|	|	|	|
			+-------+	+-------+

  (2) $BB?=EBT$A$H%7%s%0%kBT$A$N:.:_(B

			Goalrecord	Suspendrecord
	+-------+	+-------+	+-------+
	|HOOK!	+------>|MHOOK!	+------>|EOL ! 0|
	+-------+	|	|	|-------|
			|	|	|DREF!	|
			+-------+	+---|---+
					    V		Goalrecord
			    Suspendflag	+-------+	+-------+
					|HOOK!	+------>|EOL ! 0|
					|-------|	|	|
					|INT! 2	|	|	|
					+-------+	+-------+
			Suspendrecord	    ^
	+-------+	+-------+	    |
	|HOOK!	+------>|EOL ! 0|	    |
	+-------+	|-------|	    |
			|DREF!	+-----------+
			+-------+

  (3) $BB?=EBT$A(B

                        Suspendrecord
        +-------+       +-------+
        |MHOOK! +------>|EOL!  0|
        +-------+       |-------|
                        |DREF!  +-----------+
                        +-------+           |
                                            |
                                            V           Goalrecord
                            Suspendflag +-------+       +-------+
                                        |HOOK!  +------>|EOL!  0|
                                        |-------|       |       |
                                        |INT! 2 |       |       |
                                        +-------+       +-------+
                        Suspendrecord       ^
        +-------+       +-------+           |
        |MHOOK! +------>|EOL!  0|           |
        +-------+       |-------|           |
                        |DREF!  +-----------+
                        +-------+

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
1.  $B%5%9%Z%s%I%l%3!<%I$H%5%9%Z%s%I%U%i%0$NDj5A(B

       written by goto@icot22      Thu Dec 15 16:05:48 1988

<Function>
	typedef struct {
		word	pointer_to_next_goalrecord/suspend_record;
		word	pointer_to_suspendflag;
	      } suspend_record;

	typedef struct {
		word	pointer_to_next_goalrecord
		word	reference counts;
			(number of pointers from suspendrecord)
	      } suspend_flag;

<Examples>
<Test>
<Explanation>
  $B%5%9%Z%s%I%l%3!<%I(B (suspendrecord) $B$O(B MHOOK $B%?%$%W$N%]%$%s%?$K$h$C$F$N$_(B
  $B;X$5$l$k!#(B(HOOK $B$OD>@\%4!<%k%l%3!<%I$r;X$9!#(B)

  $B%5%9%Z%s%I%U%i%0(B (suspendflag)$B$O(B, $B%5%9%Z%s%I%l%3!<%I$+$i$N$_;X$5$l(B,
  $B$=$N%]%$%s%?$N%?%$%W$O(B DREF $B$H$9$k!#(BDREF $B$O(B $B%G%l%U%!%l%s%9IU$-$N0l3g(BGC$B$K$*(B
  $B$$$F%G%l%U%!%l%s%9$NBP>]$H$J$i$J$$$3$H$r0UL#$9$k%?%0$G$"$k!#(B
  $B%5%9%Z%s%I%U%i%0$N;2>H%+%&%s%?$O(B INT $B7?$H$9$k!#(B

<ETC>
********************************************************************* PSL **/

				/* $B%5%9%Z%s%I%l%3!<%I(B */
#ADDR_define _SIZE_OF_SR			2  /* word */

#ADDR_define _NEXT_PTR_OFST_SR			0
#ADDR_define _PTR_TO_FLAG_OFST_SR		1

				/* $B%5%9%Z%s%I%U%i%0(B */
#ADDR_define _SIZE_OF_SF			2

#ADDR_define _GR_PTR_OFST_SF			0
#ADDR_define _REF_CNT_OFST_SF			1

/******************************************************************** PSL **
2.  $B%5%9%Z%s%I%l%3!<%I(B/$B%5%9%Z%s%I%U%i%0$N3d$jEv$F$H2s<}(B

       written by goto@icot22      Thu Dec 15 16:26:29 1988

<Arguments>
 ptr_to_sr: pointer to a suspendrecord
 ptr_to_sf: pointer to a suspendflag

<Temporally Used Variables> none
<Level>
<PreCondition>
<Function>
    s_AllocSuspendRecord(ptr_to_sr) :
      $B!&%5%9%Z%s%I%l%3!<%I$r(B ptr_to_sr $B$K3d$jEv$F$k!#(B
    s_AllocSuspendFlag(ptr_to_sf) :
      $B!&%5%9%Z%s%I%U%i%0$r(B  ptr_to_sf $B$K3d$jEv$F$k!#(B
    s_ReclaimSuspendRecord(ptr_to_sr) :
      $B!&(Bptr_to_sr $B$N;X$9%5%9%Z%s%I%l%3!<%I$r2s<}$9$k!#(B
    s_ReclaimSuspendFlag(ptr_to_sf) :
      $B!&(Bptr_to_sf $B$N;X$9%5%9%Z%s%I%U%i%0$r2s<}$9$k!#(B
<Examples>
<Test>
<Explanation>
  ptr_to_sr / ptr_to_sf $B$N%?%0$O(B MHOOK / DREF$B$K$9$k(B.
<ETC>
********************************************************************* PSL **/

#PSL_define s_AllocSuspendRecord( ptr_to_sr )
{
  b_Alloc2( ptr_to_sr, MHOOK );
}

#PSL_define s_AllocSuspendFlag( ptr_to_sf )
{
  b_Alloc2( ptr_to_sf, DREF );
}

#PSL_define s_ReclaimSuspendRecord( ptr_to_sr )
{
  b_Reclaim2( ptr_to_sr );
}

#PSL_define s_ReclaimSuspendFlag( ptr_to_sf )
{
  b_Reclaim2( ptr_to_sf );
}

/******************************************************************** PSL **
3.  $B%5%9%Z%s%I%l%3!<%I$N%9%m%C%H$X$N%"%/%;%9(B

       written by goto@icot22      Thu Dec 15 16:32:36 1988

<Arguments>
	ptr_to_sr: pointer to a suspendrecord.
                   $B%?%0$O(B _MRB_OFF $B$N(B MHOOK $B$G$"$k$O$:(B.
	reg: register

<Temporally Used Variables>
<Level> structures
<PreCondition>
<Function>
    s_PutNextPtrSuspendRecord(ptr_to_sr, reg) :
     $B!&(Bptr_to_sr$B$N;X$9%5%9%Z%s%I%l%3!<%I$N!"<!%4!<%k$X$N%]%$%s%?$K!"(Breg$B$N(B
       $BFbMF$r=q$-9~$`!#(B
    s_PutNextEOLSuspendRecord(ptr_to_sr) :
     $B!&(Bptr_to_sr$B$N;X$9%5%9%Z%s%I%l%3!<%I$N!"<!%4!<%k$X$N%]%$%s%?$K!"(BEOL$B$r(B
       $B=q$-9~$`!#(B
    s_PutPtrToFlagSuspendRecord(ptr_to_sr, reg) :
     $B!&(Bptr_to_sr$B$N;X$9%5%9%Z%s%I%l%3!<%I$N!"%5%9%Z%s%I%U%i%0$X$N%]%$%s%?$K!"(B
       reg$B$NFbMF$r=q$-9~$`!#(B
    s_GetNextPtrSuspendRecord(ptr_to_sr, reg) :
     $B!&(Bptr_to_sr$B$N;X$9%5%9%Z%s%I%l%3!<%I$N!"<!%4!<%k$X$N%]%$%s%?$r!"(Breg$B$K(B
       $BFI$_=P$9!#(B
    s_GetPtrToFlagSuspendRecord(ptr_to_sr, reg) :
     $B!&(Bptr_to_sr$B$N;X$9%5%9%Z%s%I%l%3!<%I$N!"%5%9%Z%s%I%U%i%0$X$N%]%$%s%?$r!"(B
       reg$B$KFI$_=P$9!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_PutNextPtrSuspendRecord( ptr_to_sr, reg )
{
  @DEBUG {
    b_WarningIfSameRegNum( ptr_to_sr, reg );
    s_IfNotMHOOK( ptr_to_sr ) {
      s_IfNotEMHOK( ptr_to_sr ) {
	VPIM_ERROR( "s_PutNextPtrSuspendRecord", "Not-GR" );
      }
    }
  };
  p_WriteWithOffset( reg, ptr_to_sr, _NEXT_PTR_OFST_SR );
}

#PSL_define s_PutNextEOLSuspendRecord( ptr_to_sr )
{
  @DEBUG {
    s_IfNotMHOOK( ptr_to_sr ) {
      s_IfNotEMHOK( ptr_to_sr ) {
	VPIM_ERROR( "s_PutNextEOLSuspendRecord", "Not-GR" );
      }
    }
  };
  p_WriteWithOffset( D_EOL, ptr_to_sr, _NEXT_PTR_OFST_SR );
}

#PSL_define s_PutPtrToFlagSuspendRecord( ptr_to_sr, reg )
{
  @DEBUG {
    b_WarningIfSameRegNum( ptr_to_sr, reg );
    s_IfNotMHOOK( ptr_to_sr ) {
      VPIM_ERROR( "s_PutPtrToFlagSuspendRecord", "Not-GR" );
    }
  };
  p_WriteWithOffset( reg, ptr_to_sr, _PTR_TO_FLAG_OFST_SR );
}

#PSL_define s_GetNextPtrSuspendRecord( ptr_to_sr, reg )
{
  @DEBUG {
    s_IfNotMHOOK( ptr_to_sr ) {
      s_IfNotEMHOK( ptr_to_sr ) {
	VPIM_ERROR( "s_GetNextPtrSuspendRecord", "Not-GR" );
      }
    }
  };
  p_ReadWithOffset( ptr_to_sr, _NEXT_PTR_OFST_SR, reg );
}

#PSL_define s_GetPtrToFlagSuspendRecord( ptr_to_sr, reg )
{
  @DEBUG {
    s_IfNotMHOOK( ptr_to_sr ) {
      s_IfNotEMHOK( ptr_to_sr ) {
	VPIM_ERROR( "s_GetPtrToFlagSuspendRecord", "Not-GR" );
      }
    }
  };
  p_ReadWithOffset( ptr_to_sr, _PTR_TO_FLAG_OFST_SR, reg );
}

/******************************************************************** PSL **
4. $B%5%9%Z%s%I%U%i%0$N%9%m%C%H$X$N%"%/%;%9(B

       written by goto@icot22      Thu Dec 15 16:32:36 1988

<Arguments>
	ptr_to_sf: pointer to a suspendflag.
                   $B%?%0$O(B DREF $B$G$"$k$O$:(B.
	reg: register
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    s_PutGoalRecPtrSuspendFlag(ptr_to_sf, reg) :
     $B!&(Bptr_to_sf$B$N;X$9%5%9%Z%s%I%U%i%0$N!"%4!<%k$X$N%]%$%s%?$K!"(Breg$B$N(B
       $BFbMF$r=q$-9~$`!#(B
    s_PutRefCntSuspendFlag(ptr_to_sf, reg) :
     $B!&(Bptr_to_sf$B$N;X$9%5%9%Z%s%I%U%i%0$N!";2>H?t%+%&%s%?$K!"(Breg$B$NFbMF$r(B
       $B=q$-9~$`!#(B
    s_GetGoalRecPtrSuspendFlag(ptr_to_sf, reg) :
     $B!&(Bptr_to_sf$B$N;X$9%5%9%Z%s%I%U%i%0$N!"%4!<%k$X$N%]%$%s%?$r!"(Breg$B$K(B
       $BFI$_=P$9!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_PutGoalRecPtrSuspendFlag( ptr_to_sf, reg )
{
  @DEBUG {
    b_WarningIfSameRegNum( ptr_to_sf, reg );
    s_IfNotDREF( ptr_to_sf ) {
      VPIM_ERROR( "s_PutGoalRecPtrSuspendFlag", "Not-SuspFlag" );
    }
  };
  p_WriteWithOffset( reg, ptr_to_sf, _GR_PTR_OFST_SF );
}

#PSL_define s_PutRefCntSuspendFlag( ptr_to_sf, reg )
{
  @DEBUG {
    b_WarningIfSameRegNum( ptr_to_sf, reg );
    s_IfNotDREF( ptr_to_sf ) {
      VPIM_ERROR( "s_PutRefCntSuspendFlag", "Not-SuspFlag" );
    }
  };
  b_WriteImmTagWithOffset(_MRB_OFF, INT, reg, ptr_to_sf, _REF_CNT_OFST_SF );
}

#PSL_define s_GetGoalRecPtrSuspendFlag( ptr_to_sf, reg )
{
  @DEBUG {
    s_IfNotDREF( ptr_to_sf ) {
      VPIM_ERROR( "s_GetGoalRecPtrSuspendFlag", "Not-SuspFlag" );
    }
  };
  p_ReadWithOffset( ptr_to_sf, _GR_PTR_OFST_SF, reg );
  @DEBUG {
    s_IfNotHOOK( reg ) {
      b_IfNotEOL( reg ) {
	VPIM_ERROR( "s_GetGoalRecPtrSuspendFlag", "Not HOOK nor EOL" );
      }
    }
  };
}

/******************************************************************** PSL **
5.  $B%5%9%Z%s%I%U%i%0$N;2>H%+%&%s%H$NA`:n(B ($BGSB>%"%/%;%9IU$-(B)

       written by goto@icot22      Fri Jan  6 11:57:43 1989

<Arguments>
  ptr_to_sf : $B%5%9%Z%s%I%U%i%0$X$N%]%$%s%?(B
              $B%?%0$O(B DREF $B$G$"$k$O$:(B.
  num_reg : $B8:;;$9$kCM$r;}$D%l%8%9%?(B
<Temporally Used Variables> 
  D_WorkRefCnt : $B8:;;$7$?7k2L$H$7$F$($i$l$?CM(B
<Level> structure
<PreCondition>
<Function>
    s_SubRefCntSFandReclaimIfZeroX(ptr_to_sf, num_reg)
    s_DecrRefCntSFandReclaimIfZeroX(ptr_to_sf)
    $B!&(B"ptr_to_sf" $B$,;X$9%5%9%Z%s%I%U%i%0$N;2>H%+%&%s%H$r(B "num_reg" ($B$^$?$O(B 1)
      $B$@$18:;;$77k2L$r%5%9%Z%s%I%U%i%0$K=q$-La$7(B, $B$b$7%<%m$K$J$l$P(B ptr_to_sf $B$,(B
      $B;X$9%5%9%Z%s%I%U%i%0$r2s<}$9$k(B.
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkRefCnt	XXX

#PSL_define s_SubRefCntSFandReclaimIfZeroX( ptr_to_sf, num_reg )
{
  @DEBUG {
    b_ErrorIfSameRegNum( ptr_to_sf, num_reg );
    s_IfNotDREF( ptr_to_sf ) {
      VPIM_ERROR( "s_SubRefCntSFandReclaimIfZeroX", "Not-SuspFlag" );
    }
  };
  $USE( D_WorkRefCnt );
  b_SubtractValueWithLockX(ptr_to_sf, _REF_CNT_OFST_SF, num_reg, D_WorkRefCnt);
  p_Compare(D_WorkRefCnt, D_NULL);
  $RELEASE( D_WorkRefCnt );
  @DEBUG{
    p_IfLT() {
      VPIM_ERROR( "s_SubRefCntDFandReclaimIfZeroX", "sf-cnt-under-flow");
    }
  };
  p_IfEQ() { s_ReclaimSuspendFlag( ptr_to_sf ); }
  /* $B;2>H%+%&%s%H$,(B $B%<%m$K$J$C$?$i%5%9%Z%s%I%U%i%0$r2s<}$9$k!#(B */
}

#PSL_define s_DecrRefCntSFandReclaimIfZeroX( ptr_to_sf )
{
  @DEBUG {
    s_IfNotDREF( ptr_to_sf ) {
      VPIM_ERROR( "s_DecrRefCntSFandReclaimIfZeroX", "Not-SuspFlag" );
    }
  };
  $USE( D_WorkRefCnt );
  b_SubtractValueWithLockX(ptr_to_sf, _REF_CNT_OFST_SF, D_ONE, D_WorkRefCnt);
  p_Compare(D_WorkRefCnt, D_NULL);
  $RELEASE( D_WorkRefCnt );
  @DEBUG{
    p_IfLT() {
      VPIM_ERROR( "s_DecrRefCntDFandReclaimIfZeroX", "sf-cnt-under-flow" );
    }
  };
  p_IfEQ() { s_ReclaimSuspendFlag( ptr_to_sf ); }
}
