
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/structures/str_struct_rec.psl.c
   ----- CREATEDS   : by goto@icot22, on Mon Jun  4 11:35:16 1990
   ----- LAST SAVED: by ttakagi@icot22, on Wed May 27 12:55:39 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : $B9=B$BNI=4XO"$N%^%/%m(B

  A. $B35MW(B

  (1) $B9=B$BN4IM}$5$l$F$$$k9=B$BN$N%]%$%s%?$rM"F~$7$?;~(B

					|
$B9=B$BNI=(B					$B9=B$BNI=(B
+-------+				|	+-------+
|	+---+					|	+---+
|	|   |				|	|	|   |
+-------+   |   				+-------+   |
	    |				|		    |
    +-------+		$B9uM"F~I=(B		$B9uM"=PI=(B    |	$BBg$-$$9=B$BN(B
    |	+-------+	+-------+	|	+-------+   |	+-------+
    +-->|BEXVAL	+------>|	| - - - - - - - |	+---+-->|	|
	+-------+	|	|	|	|	|	|	|
			+-------+		+-------+	+-------+


  (2) $B9=B$BN4IM}$5$l$F$$$k9=B$BN$NK\BN$rM"F~$7$?;~(B

					|
$B9=B$BNI=(B	$BM"F~$5$l$?9=B$BN$NK\BN(B		$B9=B$BNI=(B
+-------+	+-------+		|	+-------+
|	+------>|	|			|	+---+
|	|   	|	|		|	|	|   |
+-------+      	+-------+			+-------+   |
	    				|		    |
			$B9uM"F~I=(B		$B9uM"=PI=(B    |	$BBg$-$$9=B$BN(B
    	+-------+	+-------+	|	+-------+   |	+-------+
    	|BEXVAL	+------>| $B2s<}(B	| - - - - - - - | $B2s<}(B	+---+-->|	|
	+-------+	|	|  %release-->	|	|	|	|
			+-------+		+-------+	+-------+


  B. $B9`L\(B
  1. $B9=B$BN(B(ID$B%O%C%7%eI=(B, $B%"%I%l%9%O%C%7%eI=(B)$BI=$N=i4|2=(B 
  2. $B9=B$BN%l%3!<%I(B
  3. $B9=B$BN#I#D%O%C%7%eI=$+$i$N9=B$BN%l%3!<%I$X$N%"%/%;%9(B
    3.1  $B9=B$BN#I#D%O%C%7%eI=%(%s%H%j$KBP$9$k%=%U%H%m%C%/(B
    3.2  $B9=B$BN%l%3!<%I$r#I#D%O%C%7%e%A%'!<%s$+$i8!:w$9$k(B
    3.3  $B9=B$BN%l%3!<%I$r9=B$BN#I#D%O%C%7%e%A%'!<%s$N@hF,$K(BPush/$B$+$i(BPop$B$9$k!#(B
  4. $B9=B$BN%"%I%l%9%O%C%7%eI=$+$i$N9=B$BN%l%3!<%I$X$N%"%/%;%9(B
    4.1  $B9=B$BN#I#D%O%C%7%eI=%(%s%H%j$KBP$9$k%=%U%H%m%C%/(B
    4.2  $B9=B$BN%l%3!<%I$r%"%I%l%9%O%C%7%e%A%'!<%s$+$i8!:w$9$k(B
    4.3  $B9=B$BN%l%3!<%I$r%"%I%l%9%O%C%7%e%A%'!<%s$N@hF,$K(BPush/$B$+$i(BPop$B$9$k!#(B
    4.4  $B9=B$BN%"%I%l%9%O%C%7%e%A%'!<%s$+$i9=B$BN%l%3!<%I$r:o=|$9$k(B
  5. $B9=B$BN#I#D$NH/@8(B
  6. $B9=B$BNI=$NA`:n(B ($BB>$N%U%!%$%kFb$N%^%/%m$+$iMxMQ$G$-$k$b$N(B)
    6.1  $B9=B$BN%"%I%l%9$+$i9=B$BN#I#D$rF@$k(B
    6.2  $B9=B$BN(BID$B$+$i9=B$BN$X$N%]%$%s%?$rF@$k(B
    6.3  $B9=B$BNI=$N%"%I%l%9%O%C%7%eI=$r%j%O%C%7%e$9$k(B
  7. $B9=B$BNI=$KBP$9$k=i4|A`:n(B

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */
/******************************************************************** PSL **
1. $B9=B$BN(B(ID$B%O%C%7%eI=(B, $B%"%I%l%9%O%C%7%eI=(B)$BI=$N=i4|2=(B 

       written by goto@icot22      on Mon Jun  4 11:47:26 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#ADDR_define _STR_ID_HASH_TBL_LIMIT 
                    (_STR_ID_HASH_TBL_BASE + _STR_ID_HASH_TBL_SIZE)
#ADDR_define _STR_ADDR_HASH_TBL_LIMIT 
                    (_STR_ADDR_HASH_TBL_BASE + _STR_ADDR_HASH_TBL_SIZE)

/* for @DEBUG */
#PSL_define s_CheckStrIdHashEntry (hash_entry_ptr)
{
  b_IfRangeOverImm(hash_entry_ptr, _STR_ID_HASH_TBL_LIMIT){
    @DEBUG{ VPIM_ERROR("s_CheckStrIdHashEntry","Ptr overflow"); };
  } else {
    b_IfRangeUnderImm(hash_entry_ptr, _STR_ID_HASH_TBL_BASE) {
      @DEBUG{ VPIM_ERROR("s_CheckStrIdHashEntry","Ptr underflow"); };
    }
  }
}

/* for @DEBUG */
#PSL_define s_CheckStrAddrHashEntry (hash_entry_ptr)
{
  b_IfRangeOverImm(hash_entry_ptr, _STR_ADDR_HASH_TBL_LIMIT){
    @DEBUG{ VPIM_ERROR("s_CheckStrAddrHashEntry","Ptr overflow"); };
  } else {
    b_IfRangeUnderImm(hash_entry_ptr, _STR_ADDR_HASH_TBL_BASE) {
      @DEBUG{ VPIM_ERROR("s_CheckStrAddrHashEntry","Ptr underflow"); };
    }
  }
}

/******************************************************************** PSL **
2. $B9=B$BN%l%3!<%I(B
       written by goto@icot22      on Mon Jun  4 11:36:00 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
$B!N9=B$BN%l%3!<%I$N?^!O(B

   +--------------------------------------------+
   | VECT4         ! $B#I#D%O%C%7%e%A%'!<%s(B       |
   |   or EOL      !			        |
   +--------------------------------------------+
   | VECT4         ! $B%"%I%l%9%O%C%7%e%A%'!<%s(B   |
   |   or EOL      ! 			        |
   +--------------------------------------------+
   | INT ??        ! $B9=B$BN#I#D(B                 |
   +--------------------------------------------+
   | $B9=B$BN$N%?%0(B  | $B9=B$BN$X$N%]%$%s%?(B         |
   | or REFx	   | BEXVAL$B%;%k$X$N%]%$%s%?(B     |
   +--------------------------------------------+
<ETC>
********************************************************************* PSL **/

#CONST_define _SIZE_OF_STR_REC 		4  

#ADDR_define _ID_HASH_CHAIN_OFST_STR_REC 	0
#ADDR_define _ADDR_HASH_CHAIN_OFST_STR_REC 	1
#ADDR_define _ID_OFST_STR_REC	 		2
#ADDR_define _ADDR_OFST_STR_REC	 	        3
#ADDR_define _SLOCK_OFST_STR_REC 		_ID_OFST_STR_REC

#CONST_define _TYPE_OF_STR_ID_HASH_CHAIN   VECT4   /* $B%?%$%W$NCV$-49$((B */
#CONST_define _TYPE_OF_STR_ADDR_HASH_CHAIN VECT4   /* $B%?%$%W$NCV$-49$((B */

#PSL_define s_AllocEntryOfStructRec(ptr_to_str_rec)
{
  b_Alloc4(ptr_to_str_rec, _TYPE_OF_STR_ID_HASH_CHAIN);
}

#PSL_define s_PutIdStructRec(ptr_to_str_rec, struct_id)
{
  p_WriteWithOffset(struct_id, ptr_to_str_rec, _ID_OFST_STR_REC);
}

#PSL_define s_PutAddrStructRec(ptr_to_str_rec, struct_addr)
{
  p_WriteWithOffset(struct_addr, ptr_to_str_rec, _ADDR_OFST_STR_REC);
}

#PSL_define s_PutIdChainStructRec(ptr_to_str_rec, id_hash_chain)
{
  p_WriteWithOffset(id_hash_chain,ptr_to_str_rec,_ID_HASH_CHAIN_OFST_STR_REC);
}

#PSL_define s_PutAddrChainStructRec(ptr_to_str_rec, addr_hash_chain)
{
  p_WriteWithOffset(addr_hash_chain, ptr_to_str_rec, _ADDR_HASH_CHAIN_OFST_STR_REC);
}

#PSL_define s_GetIdStructRec(ptr_to_str_rec, struct_id)
{
  p_ReadWithOffset(ptr_to_str_rec, _ID_OFST_STR_REC, struct_id);
}

#PSL_define s_GetAddrStructRec(ptr_to_str_rec, struct_addr)
{
  p_ReadWithOffset(ptr_to_str_rec, _ADDR_OFST_STR_REC, struct_addr);
}

#PSL_define s_GetIdChainStructRec(ptr_to_str_rec, id_hash_chain)
{
  p_ReadWithOffset(ptr_to_str_rec, _ID_HASH_CHAIN_OFST_STR_REC, id_hash_chain);
}

#PSL_define s_GetAddrChainStructRec(ptr_to_str_rec, addr_hash_chain)
{
  p_ReadWithOffset(ptr_to_str_rec, _ADDR_HASH_CHAIN_OFST_STR_REC, addr_hash_chain);
}

/******************************************************************** PSL **
3.  $B9=B$BN#I#D%O%C%7%eI=$+$i$N9=B$BN%l%3!<%I$X$N%"%/%;%9(B

3.1 $B9=B$BN#I#D%O%C%7%eI=%(%s%H%j$KBP$9$k%=%U%H%m%C%/(B

       written by goto@icot22      on Mon Jun  4 11:48:34 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_HashStrIdGetEntryAddr(struct_id_reg, hash_entry_addr)
{
  s_HashAddress(struct_id_reg, _STR_ID_HASH_TBL_BASE, _STR_ID_HASH_TBL_SIZE,
		hash_entry_addr, _STR_ID_HASH_TBL_MASK);
}  

#PSL_define s_SoftLockEntryOfStrIdHashTBL
			(struct_id_reg,hash_entry_addr,org_data_reg)
{
  s_HashStrIdGetEntryAddr(struct_id_reg,hash_entry_addr);
  @DEBUG{ s_CheckStrIdHashEntry (hash_entry_addr); };
  b_SoftLockWithOrgData(hash_entry_addr, _ZERO, org_data_reg);
}

#PSL_define s_SoftUnlockEntryOfStrIdHashTBL(hash_entry_addr, org_data_reg)
{
  @DEBUG{ s_CheckStrIdHashEntry (hash_entry_addr); };
  b_SoftUnlockWithOrgData(hash_entry_addr, _ZERO, org_data_reg);
}

/******************************************************************** PSL **
3.2  $B9=B$BN%l%3!<%I$r#I#D%O%C%7%e%A%'!<%s$+$i8!:w$9$k(B

       written by goto@icot22      on Mon Jun  4 13:59:29 1990
<Arguments>
  str_rec_link 	: $B9=B$BN%l%3!<%I$N%j%s%/(B 
		$B!J%=%U%H%m%C%/A0$N9=B$BN%O%C%7%e%(%s%H%j$NFbMF!K(B
  id_reg:          $B9=B$BN#I#D(B
  struct_rec:      $B9=B$BN%l%3!<%I$r;X$9%]%$%s%?!J=PNO!K(B
<Temporally Used Variables>
<Level>
<PreCondition>
  ID$B%O%C%7%eI=$N%(%s%H%j$O%m%C%/:Q$_(B
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkStructId 	XXX

#PSL_define s_SearchStrIdHashChain (str_rec_link, id_reg, struct_rec)
{
  $USE(D_WorkStructId);
  p_MoveWord(str_rec_link, struct_rec);
  LOOP(){
    b_IfEOL(struct_rec){
      break;
    }
    s_GetIdStructRec(struct_rec, D_WorkStructId);
    b_IfEqual(D_WorkStructId, id_reg){
      break;
    }
    s_GetIdChainStructRec(struct_rec, struct_rec);
  }
  $RELEASE(D_WorkStructId);
}

/******************************************************************** PSL **
3.3  $B9=B$BN%l%3!<%I$r9=B$BN#I#D%O%C%7%e%A%'!<%s$N@hF,$K(BPush/$B$+$i(BPop$B$9$k!#(B

       written by goto@icot22      on Mon Jun  4 14:00:25 1990

<Arguments>
  str_rec_link:      $B9=B$BN%l%3!<%I$N%O%C%7%e%j%s%/(B
  struct_rec:      $B9=B$BN%l%3!<%I$r;X$9%]%$%s%?!J=PNO!K(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $B9=B$BN%l%3!<%I$O!"$3$N%^%/%m$,8F$P$l$kA0$K%"%m%1!<%H$5$l$FFbMF$bF~$l$i$l$F$$$k!#(B
<ETC>
********************************************************************* PSL **/

#PSL_define s_PushStrIdHashChain(struct_rec, str_rec_link)
{
  b_PushLink(struct_rec, str_rec_link, _ID_HASH_CHAIN_OFST_STR_REC);
}

#PSL_define s_PopStrIdHashChain(struct_rec, str_rec_link)
{
  b_PopLink(struct_rec, str_rec_link, _ID_HASH_CHAIN_OFST_STR_REC);
}

/******************************************************************** PSL **
4.  $B9=B$BN%"%I%l%9%O%C%7%eI=$+$i$N9=B$BN%l%3!<%I$X$N%"%/%;%9(B

4.1 $B9=B$BN#I#D%O%C%7%eI=%(%s%H%j$KBP$9$k%=%U%H%m%C%/(B

       written by goto@icot22      on Mon Jun  4 14:01:22 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_HashStrAddrGetEntryAddr (struct_addr, hash_entry_addr)
{
  s_HashAddress(struct_addr,_STR_ADDR_HASH_TBL_BASE,_STR_ADDR_HASH_TBL_SIZE,
		hash_entry_addr, _STR_ADDR_HASH_TBL_MASK);
}  

#PSL_define s_SoftLockEntryOfStrAddrHashTBL
			(struct_addr,hash_entry_addr,org_data_reg)
{
  s_HashStrAddrGetEntryAddr (struct_addr,hash_entry_addr);
  @DEBUG{ s_CheckStrAddrHashEntry (hash_entry_addr); };
  b_SoftLockWithOrgData(hash_entry_addr, _ZERO, org_data_reg);
}

#PSL_define s_SoftUnlockEntryOfStrAddrHashTBL (hash_entry_addr,org_data_reg)
{
  @DEBUG{ s_CheckStrAddrHashEntry (hash_entry_addr); };
  b_SoftUnlockWithOrgData(hash_entry_addr, _ZERO, org_data_reg);
}

/******************************************************************** PSL **
4.2  $B9=B$BN%l%3!<%I$r%"%I%l%9%O%C%7%e%A%'!<%s$+$i8!:w$9$k(B

       written by goto@icot22      on Mon Jun  4 14:01:50 1990
<Arguments>
  hash_entry:  $B9=B$BN%"%I%l%9%O%C%7%e%(%s%H%j$NFbMF(B
               $B!J%=%U%H%m%C%/$5$l$kA0$N%3%T!<!K(B
  struct_addr: $B8!:w$9$k9=B$BN$N%"%I%l%9(B
  struct_rec:  $B8!:w$5$l$?9=B$BN%l%3!<%I$r;X$9%l%8%9%?!J=PNO!K(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkStrAddr XXX

#PSL_define s_SearchStrAddrHashChain(hash_entry, struct_addr, struct_rec)
{
  $USE(D_WorkStrAddr);
  p_MoveWord(hash_entry, struct_rec);
  LOOP(){
    b_IfEOL(struct_rec){
      break;
    }
    s_GetAddrStructRec(struct_rec, D_WorkStrAddr);
    b_IfEqual(D_WorkStrAddr, struct_addr){
      break;
    }
    s_GetAddrChainStructRec(struct_rec, struct_rec);
  }
  $RELEASE(D_WorkStrAddr);
}

/******************************************************************** PSL **
4.3  $B9=B$BN%l%3!<%I$r%"%I%l%9%O%C%7%e%A%'!<%s$N@hF,$K(BPush/$B$+$i(BPop$B$9$k!#(B

       written by goto@icot22      on Mon Jun  4 14:02:14 1990
<Arguments>
  str_hash_link: $B9=B$BN%l%3!<%I$N%O%C%7%e%j%s%/(B
  struct_rec: $BA^F~$5$l$k9=B$BN%l%3!<%I$r;X$9%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_PushStrAddrHashChain(struct_rec, str_hash_link)
{
  b_PushLink(struct_rec, str_hash_link, _ADDR_HASH_CHAIN_OFST_STR_REC);
}

#PSL_define s_PopStrAddrHashChain(struct_rec, str_hash_link)
{
  b_PopLink(struct_rec, str_hash_link, _ADDR_HASH_CHAIN_OFST_STR_REC);
}

/******************************************************************** PSL **
4.4 $B9=B$BN%"%I%l%9%O%C%7%e%A%'!<%s$+$i9=B$BN%l%3!<%I$r:o=|$9$k(B

       written by goto@icot22      on Mon Jun  4 14:02:41 1990
<Arguments>
  hash_entry: $B9=B$BN%"%I%l%9%O%C%7%e%(%s%H%j$NFbMF!J%=%U%H%m%C%/$5$l$kA0$N%3%T!<!K(B
  struct_rec: $B:o=|$5$l$k9=B$BN%l%3!<%I$r;X$9%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $B$3$N%^%/%mFb$G!"(BPop$B$7$?%l%3!<%I$r2s<}$9$k$3$H$O$7$J$$!#(B
<ETC>
********************************************************************* PSL **/

#DATA_define	D_WorkStructRec	XXX

#PSL_define s_DeleteEntryOfStrAddrHashChain
                                  (hash_entry_ptr, hash_entry, struct_rec)
{
  $USE(D_WorkStructRec);
  b_IfEqual(hash_entry, struct_rec){
    s_GetAddrChainStructRec(hash_entry, D_WorkStructRec);
    p_Write(D_WorkStructRec, hash_entry_ptr);
  } else {
    $USE(D_WorkPre);
    p_MoveWord(hash_entry, D_WorkPre);
    s_GetAddrChainStructRec(D_WorkPre, D_WorkStructRec);
    LOOP(){
      @DEBUG{
	b_IfEOL(D_WorkStructRec){
	  VPIM_ERROR("s_DeleteEntryOfStrAddrHashChain","Pop not exist cell");
	}
      };
      b_IfEqual(struct_rec, D_WorkStructRec){
	s_PopStrAddrHashChain(struct_rec, D_WorkStructRec);
	s_PutAddrChainStructRec(D_WorkPre, D_WorkStructRec);
	break;
      }
      p_MoveWord(D_WorkStructRec, D_WorkPre);
      s_GetAddrChainStructRec(D_WorkStructRec, D_WorkStructRec);
    }
    $RELEASE(D_WorkPre);
  }
  $RELEASE(D_WorkStructRec);
}

/******************************************************************** PSL **
5. $B9=B$BN#I#D$NH/@8(B

       written by goto@icot22      on Mon Jun  4 14:03:11 1990
<Arguments>
  key_reg: $B9=B$BN#I#D=PNO(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CONST_define 	_STRUCT_ID_MAX 			0x1000000
#ADDR_define 	_STRUCT_ID_CLUSTER_NUM_OFST 	24

#PSL_define s_GenerateStructID(key_reg)
{
  $USE(D_WorkStructId);
  b_GetStructIDCounterX(D_WorkStructId);
  b_SetImmTypeMRBoff(INT,D_WorkStructId);
  b_IfGreaterEqImm(D_WorkStructId, _STRUCT_ID_MAX){
    @DEBUG{ VPIM_ERROR("s_GenerateStructID","structID counter overflow"); };
  }
  b_ShiftLeftImmediate(D_CL_Number, _STRUCT_ID_CLUSTER_NUM_OFST, key_reg);
  b_BitwiseOrWithTag(D_WorkStructId, key_reg, key_reg);
  $RELEASE(D_WorkStructId);
}

#PSL_define s_InitStructIDCounter()
{
  b_WriteSharedArea(D_NULL,_MEM_MANAGE_AREA_BASE,_STR_ID_COUNTER_OFST);
  /* bsc_mem_global.psl.c $B$r8+$h(B */
}


/******************************************************************** PSL **
6. $B9=B$BNI=$NA`:n(B
       written by goto@icot22      on Mon Jun  4 11:50:58 1990
<Explanation>

(1) $B9=B$BN%"%I%l%9$+$i9=B$BN#I#D$rF@$k(B
		                       +          -
	s_GetStructIdStrRec_Sub(A_PtrToStruct, A_StructID)

(2) $B9=B$BN(BID$B$+$i9=B$BN$X$N%]%$%s%?$rF@$k(B
					+	  +	   + -	       -
      	s_GetStructPtrStrRec_Sub (A_StructId, A_ExrefId, A_Wec, A_PtrToStruct)

(3) $B9=B$BNI=$N%"%I%l%9%O%C%7%eI=$r$j%O%C%7%e$9$k(B
				+	     +
	s_RehashStrAddrHash (ptr_to_old, ptr_to_new)
<ETC>
********************************************************************* PSL **/

/******************************************************************** PSL **
6.1  $B9=B$BN%"%I%l%9$+$i9=B$BN#I#D$rF@$k(B

       written by goto@icot22      on Mon Jun  4 11:50:08 1990
<Arguments>
  A_PtrToStruct: $B9=B$BN%"%I%l%9(B
  A_StructId:     $B9=B$BN#I#D(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
 $B!&9=B$BN%"%I%l%9$+$i!"9=B$BN#I#D$rF@$k!#(B
 $B!&9=B$BN%"%I%l%9%O%C%7%e%A%'!<%s$KL$EPO?$@$C$?>l9g$O!"9=B$BN%l%3!<%I$r@8@.(B
   $B$7$F!"%A%'!<%s$K$D$J$2$k!#(B
<Examples>
<Test>
<Explanation>
 $B!&9=B$BN%"%I%l%9%O%C%7%eI=$K%m%C%/$r$+$1$k!#(B
 $B!&(Bptr_to_struct $B$r%-!<$K$7$F!"9=B$BN%"%I%l%9%O%C%7%eI=$r8!:w$9$k!#(B
 $B!&(B[$B9=B$BN%l%3!<%I$,8+$D$+$C$?>l9g(B]
   $B!&9=B$BN%l%3!<%I$r%"%m%1!<%H$9$k!#(B
   $B!&9=B$BN#I#D$r@8@.$9$k!#(B
   $B!&9=B$BN%l%3!<%I$K9=B$BN#I#D$rF~$l$k!#(B
   $B!&9=B$BN%l%3!<%I$K9=B$BN%"%I%l%9$rF~$l$k!#(B
   $B!&9=B$BN%l%3!<%I$r9=B$BN%"%I%l%9%O%C%7%eI=$KEPO?$9$k!#(B
   $B!&9=B$BN#I#D%O%C%7%eI=$K%m%C%/$r$+$1$k!#(B
   $B!&9=B$BN%l%3!<%I$r9=B$BN#I#D%O%C%7%eI=$KEPO?$9$k!#(B
   $B!&9=B$BN#I#D%O%C%7%eI=$N%m%C%/$r30$9!#(B
 $B!&(B[$B9=B$BN%l%3!<%I$,8+$D$+$C$?>l9g(B]
   $B!&9=B$BN%l%3!<%I$+$i!"9=B$BN#I#D$rF@$k!#(B
 $B!&9=B$BN%"%I%l%9%O%C%7%eI=$N%m%C%/$r30$9!#(B

<ETC>
********************************************************************* PSL **/

#DATA_define	D_WorkStrAddrHashEntry		XXX
#DATA_define	D_WorkStrAddrHashEntryPtr	XXX

#SUBARG_define	A_PtrToStruct	SRC
#SUBARG_define	A_StructId	DST

#SUBROUTINE s_GetStructIdStrRec_Sub(A_PtrToStruct, A_StructId)
{
  $USE(D_WorkStrAddrHashEntryPtr);
  $USE(D_WorkStrAddrHashEntry);
  s_SoftLockStructTableFlag();
  s_HashStrAddrGetEntryAddr(A_PtrToStruct, D_WorkStrAddrHashEntryPtr);
  p_Read(D_WorkStrAddrHashEntryPtr, D_WorkStrAddrHashEntry);

  $USE(D_WorkStructRec);
  s_SearchStrAddrHashChain(D_WorkStrAddrHashEntry, A_PtrToStruct, D_WorkStructRec);
  b_IfEOL(D_WorkStructRec){ /* $B9=B$BN%l%3!<%I$,L5$+$C$?>l9g(B */
    s_AllocEntryOfStructRec(D_WorkStructRec);
    s_GenerateStructID(A_StructId);
    s_PutIdStructRec(D_WorkStructRec, A_StructId);
    s_PutAddrStructRec(D_WorkStructRec, A_PtrToStruct);
    s_PushStrAddrHashChain(D_WorkStructRec, D_WorkStrAddrHashEntry);
    p_Write(D_WorkStrAddrHashEntry, D_WorkStrAddrHashEntryPtr);
    $USE(D_WorkHashEntryPtr);
    $USE(D_WorkHashEntry);
    s_HashStrIdGetEntryAddr(A_StructId, D_WorkHashEntryPtr);
    p_Read(D_WorkHashEntryPtr, D_WorkHashEntry);
    s_PushStrIdHashChain(D_WorkStructRec, D_WorkHashEntry);
    p_Write(D_WorkHashEntry, D_WorkHashEntryPtr);
    $RELEASE(D_WorkStructRec);
    $RELEASE(D_WorkHashEntry);
    $RELEASE(D_WorkHashEntryPtr);
  } else { /* $B9=B$BN%l%3!<%I$,8+$D$+$C$?>l9g(B */
    s_GetIdStructRec(D_WorkStructRec, A_StructId);
    $RELEASE(D_WorkStructRec);
  }
  s_SoftUnlockStructTableFlag();
  $RELEASE(D_WorkStrAddrHashEntry);
  $RELEASE(D_WorkStrAddrHashEntryPtr);
  $RETURN();
}

/******************************************************************** PSL **
6.2  $B9=B$BN(BID$B$+$i9=B$BN$X$N%]%$%s%?$rF@$k(B

       written by goto@icot22      on Mon Jun  4 11:52:00 1990
<Arguments>
  A_StructId	: ($BF~NO(B) $B9=B$BN(BID 
  A_ExrefId 	: ($BF~NO(B) $B30It;2>H(BID
  A_Wec		: ($BF~NO(B) $B30It;2>H(BID$B$KIU?o$7$F$-$?(BWEC 
  		  ($B=PNO(B) $B%j%j!<%9$9$Y$-(BWEC
  A_PtrToStruct	: ($B=PNO(B) $B9=B$BN$X$N%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B!&9=B$BN$,4{$KB8:_$7$F$$$k>l9g(B:
  	A_PtrToStruct$B$K$O!"9=B$BNK\BN$X$N%]%$%s%?$,F~$k!#(B
	A_Wec $B$OITJQ(B ($BJV5Q$9$Y$-(BWEC$B$r0UL#$9$k(B)
  $B!&9=B$BN$,B8:_$7$J$$>l9g(B:
	A_ExrefId$B$H(BA_Wec$B$KBP1~$7$?9uM"F~%l%3!<%I$H(B BEXVAL$B%;%k$r3d$jEv$F!"(B
	A_PtrToStruct$B$N;X$9@h$r(BBEXVAL$B%;%k$H$9$k!#(B
	A_Wec $B$O%<%m$K$J$k!#(B($B$D$^$j!"(BWEC$B$NJV5Q$,ITMW$G$"$k$3$H$r0UL#$9$k(B)
<Examples>
  $B!&%b%8%e!<%k$NM"F~(B
   {
     receive struct_id, exref_id, wec;
     .....
     $CALL( s_GetStructPtrStrRec_Sub(struct_id, exref_id, wec, struct_ptr));
     b_IfNotZero(wec) {
       send_release_wec (wec);
     }
     .....
   }
<Test>
<Explanation>

$B!N9=B$BN$,4{$KB8:_$7$F$$$k>l9g!O(B
  	A_PtrToStruct$B$K$O!"<B:]$N%b%8%e!<%k$X$N%]%$%s%?$,F~$k!#(B

A_PtrToStruct ---+---> +---------------------+
                 |     |                     |
   $B9=B$BNI=(B      |     |                     |
 +------+------+ |     |                     |
 |      |      | |     |                     |
 | ID   |     -+-+     |  $B9=B$BN$NK\BN(B       |
 |      |      |       |                     |
 |      |      |       |                     |
 +------+------+       |                     |
                       +---------------------+

$B!N9=B$BN$,B8:_$7$J$$>l9g!O(B

A_PtrToStruct$B$N;X$9@h$O(BBEXVAL$B%;%k$H$J$j!"(BBEXVAL$B%;%k$N;X$9@h$O9uM"F~I=$H$J$k!#(B
$B9uM"F~I=$G$O!"9=B$BN$N30It;2>H#I#D$r;}$D!#(B
                                                    $B9uM"F~%l%3!<%I(B
	                                      +------------------+
		       +----------+           |                  |
A_PtrToStruct ---+---->|BEXVAL   -+---------> |  $B30It;2>H#I#D(B   -+------>
                 |     +----------+           |                  |
   $B9=B$BNI=(B      |                            +------------------+
 +------+------+ |
 |      |      | |
 |      |     -+-+
 |      |      |
 |      |      |
 +------+------+

$B$3$N>l9g9=B$BNI=$rA`:n$9$k$N$G!"0J2<$NGSB><j=g$,I,MW$G$"$k!#(B
$B!N=hM}<j=g!O(B	
$B!&(BA_StructId$B$G<($5$l$k9=B$BN$,9=B$BNI=$KEPO?$5$l$F$$$?>l9g(B
  (1) A_StructId$B$r%-!<$H$7$F9=B$BN(BID$B%O%C%7%eI=$N%(%s%H%j$K%=%U%H%m%C%/$r3]$1$k(B
  (2) $B9=B$BN(BID$B%A%'!<%s$+$i(BA_StructId$B$r;}$D9=B$BN%l%3!<%I$rC5$9(B
  (3) $BL\E*$N9=B$BN(BID$B$,H/8+$5$l$k$N$G!"9=B$BN$X$N%"%I%l%9$,F@$i$l$k!#(B
  (4) $B9=B$BN$X$N%"%I%l%9$,(BD_NULL$B$G$"$C$?$i!"(B(3)$B$KLa$k!#(B
  (5) $B9=B$BN(BID$B%O%C%7%eI=$N%(%s%H%j3]$1$?%=%U%H%m%C%/$r30$9!#(B

  (6) $BAw$i$l$F$-$?(BWEC$B$r(B%Release$B%a%C%;!<%8$N7A$GJV$9!#(B

$B!&(BA_StructId$B$G<($5$l$k9=B$BN$,9=B$BNI=$KEPO?$5$l$F$$$J$+$C$?>l9g(B
  (1) A_StructId$B$r%-!<$H$7$F9=B$BN(BID$B%O%C%7%eI=$N%(%s%H%j$K%=%U%H%m%C%/$r3]$1$k(B
  (2) $B9=B$BN(BID$B%A%'!<%s$+$i(BA_StructId$B$r;}$D9=B$BN%l%3!<%I$rC5$9(B
  (3) $BL\E*$N9=B$BN(BID$B$OH/8+$5$l$J$$$N$G!"%b%8%e!<%k$N30It;2>H(BID$B$r9uM"F~I=$K(B
      $BEPO?$9$k!#(B($B9uM"F~%l%3!<%I$H(BBEXVAL$B%;%k$,3d$jIU$1$i$l$k(B)
  (4) $B9=B$BN%l%3!<%I$r3d$jIU$1!"9=B$BN$X$N%"%I%l%9$O(BD_NULL$B$H$9$k!#(B
  (5) $B9=B$BN(BID$B%O%C%7%eI=$N%(%s%H%j3]$1$?%=%U%H%m%C%/$r30$9!#(B
  (6) (3)$B$G3d$jIU$1$i$l$?(BBEXVAL$B%;%k$N%"%I%l%9$r%-!<$H$7$F!"9=B$BN%"%I%l%9(B
      $B%O%C%7%eI=%(%s%H%j$K%=%U%H%m%C%/$r3]$1$k!#(B
  (7) $B9=B$BN(B(BEXVAL$B%;%k(B)$B$X$N%]%$%s%?$r9=B$BN%l%3!<%I$KF~$l$k!#(B
  (8) $B9=B$BN(BID$B%O%C%7%eI=$K3]$1$?%=%U%H%m%C%/$r30$9!#(B

<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkStrHashEntryPtr XXX
#DATA_define D_WorkStrHashEntry    XXX
#DATA_define D_WorkVOIDFlag        XXX

#SUBARG_define	A_StructId	SRC
#SUBARG_define	A_ExrefId	SRC
#SUBARG_define	A_Wec		MODIFY
#SUBARG_define	A_PtrToStruct	DST
#SUBARG_define  A_FlagReg       DST

#SUBROUTINE s_GetStructPtrStrRec_Sub (A_StructId, A_ExrefId, A_Wec, A_PtrToStruct, A_FlagReg)
{
  $USE(D_WorkStrHashEntryPtr);
  $USE(D_WorkStrHashEntry);
  s_SoftLockStructTableFlag();
  s_HashStrIdGetEntryAddr(A_StructId, D_WorkStrHashEntryPtr);
  p_Read(D_WorkStrHashEntryPtr, D_WorkStrHashEntry);

  $USE(D_WorkStructRec);
  s_SearchStrIdHashChain(D_WorkStrHashEntry, A_StructId, D_WorkStructRec);
    /* $B9=B$BN#I#D%O%C%7%eI=$K%=%U%H%m%C%/$7$F!"M"F~$7$F$-$?9=B$BN#I#D$,(B
       $B4{$KEPO?$5$l$F$$$k$+$I$&$+C5$9!#(B */
  b_IfNotEOL(D_WorkStructRec){ 
    /* $B%b%8%e!<%k$,4{$KB8:_$7$?;~!#(BD_WorkStructRec$B$O9=B$BN%l%3!<%I$r;X$9!#(B */
    s_GetAddrStructRec(D_WorkStructRec, A_PtrToStruct);
             /* A_PtrToStruct$B$K%b%8%e!<%k$X$N%]%$%s%?$r%;%C%H$9$k!#(B*/
    b_SetRegFlagOn(A_FlagReg);
  } else { 
    /* $B%b%8%e!<%k$,B8:_$7$J$$;~!#(BD_WorkStructRec$B$O(BD_NULL$B$H$J$k!#(B*/ 

    @DEBUG{WARNING("Struct_ID_Table_Search","Struct not found");};
    $USE(D_WorkReturnWEC);
    $CALL( s_GetPtrToExCellAllocBImpRecWithWec_Sub
	   	(A_ExrefId, A_Wec, A_PtrToStruct, D_WorkReturnWEC) );

    @DEBUG{b_IfNotEqual(D_NULL, D_WorkReturnWEC){
           VPIM_ERROR("s_GetStructPtrStrRec_Sub","Invalid WEC in bimp rec");}};

    $RELEASE(D_WorkReturnWEC);
    p_MoveWord(D_NULL, A_Wec);
    b_SetImmTypeMRBon(REF, A_PtrToStruct);
        /* A_PtrToStruct$B$O!"30It;2>H%;%k$X$N%]%$%s%?!#(B
	   D-Code$B$H9=B$BNI=$+$i$5$5$l$k$N$G!"(BMRB$B$O9u$K$7$F$*$/(B
         */

    s_AllocEntryOfStructRec(D_WorkStructRec);
    s_PutIdStructRec(D_WorkStructRec, A_StructId);
    s_PushStrIdHashChain(D_WorkStructRec, D_WorkStrHashEntry);
        /* $B9=B$BN(BID$B%A%'!<%s$K9=B$BNI=$r7R$0!#(B*/
    p_Write(D_WorkStrHashEntry, D_WorkStrHashEntryPtr);
    s_HashStrAddrGetEntryAddr(A_PtrToStruct, D_WorkStrHashEntryPtr);
    p_Read(D_WorkStrHashEntryPtr, D_WorkStrHashEntry);
    s_PushStrAddrHashChain (D_WorkStructRec, D_WorkStrHashEntry);
    p_Write(D_WorkStrHashEntry, D_WorkStrHashEntryPtr);
    s_PutAddrStructRec(D_WorkStructRec, A_PtrToStruct);
        /* $B9=B$BN%"%I%l%9%A%'!<%s$K9=B$BNI=$r7R$.!"(B
	   $B9=B$BN(B(BEXVAL$B%;%k(B)$B$X$N%]%$%s%?$r9=B$BN%l%3!<%I$KF~$l!#(B*/
    b_SetRegFlagOff(A_FlagReg);
  } /* end of  "b_IfNotEOL(D_WorkStructRec)" */

  s_SoftUnlockStructTableFlag();
  $RELEASE(D_WorkStructRec);
  $RELEASE(D_WorkStrHashEntryPtr);
  $RELEASE(D_WorkStrHashEntry);
  $RETURN();
}

#SUBARG_define	A_StructId	SRC
#SUBARG_define	A_NewStructPtr	SRC
#SUBARG_define	A_OldStructPtr	DST

#SUBROUTINE s_GetOldStructPtrStrRec_SupplyBEXID_Sub
                                 (A_StructId, A_NewStructPtr, A_OldStructPtr)
{
  $USE(D_WorkStrHashEntryPtr);
  $USE(D_WorkStrHashEntry);
  s_SoftLockStructTableFlag();
  s_HashStrIdGetEntryAddr(A_StructId, D_WorkStrHashEntryPtr);
  p_Read(D_WorkStrHashEntryPtr, D_WorkStrHashEntry);

  $USE(D_WorkStructRec);
  s_SearchStrIdHashChain(D_WorkStrHashEntry, A_StructId, D_WorkStructRec);
    /* $B9=B$BN#I#D%O%C%7%eI=$K%=%U%H%m%C%/$7$F!"M"F~$7$F$-$?9=B$BN#I#D$,(B
       $B4{$KEPO?$5$l$F$$$k$+$I$&$+C5$9!#(B */
  b_IfNotEOL(D_WorkStructRec){ 
    /* $B%b%8%e!<%k$,4{$KB8:_$7$?;~!#(BD_WorkStructRec$B$O9=B$BN%l%3!<%I$r;X$9!#(B */
    s_GetAddrStructRec(D_WorkStructRec, A_OldStructPtr);
             /* A_PtrToStruct$B$K%b%8%e!<%k$X$N%]%$%s%?$r%;%C%H$9$k!#(B*/
  } else { 
    /* $B%b%8%e!<%k$,B8:_$7$J$$;~!#(BA_NewStructPtr$B$r9=B$BNI=$KEPO?$9$k!#(B*/ 
    s_MRBonReg(A_NewStructPtr);
              /* D-Code$B$H9=B$BNI=$+$i$5$5$l$k$N$G!"(BMRB$B$O9u$K$7$F$*$/(B */
    s_AllocEntryOfStructRec(D_WorkStructRec);
    s_PutIdStructRec(D_WorkStructRec, A_StructId);
    s_PushStrIdHashChain(D_WorkStructRec, D_WorkStrHashEntry);
        /* $B9=B$BN(BID$B%A%'!<%s$K9=B$BNI=$r7R$0!#(B*/
    p_Write(D_WorkStrHashEntry, D_WorkStrHashEntryPtr);
    s_HashStrAddrGetEntryAddr(A_NewStructPtr, D_WorkStrHashEntryPtr);
    p_Read(D_WorkStrHashEntryPtr, D_WorkStrHashEntry);
    s_PushStrAddrHashChain(D_WorkStructRec, D_WorkStrHashEntry);
    p_Write(D_WorkStrHashEntry, D_WorkStrHashEntryPtr);
    s_PutAddrStructRec(D_WorkStructRec, A_NewStructPtr);
    b_SetIllegalPointer(A_OldStructPtr);
    /* A_OldStructPtr$B$O8+$D$+$i$J$+$C$?$N$G(B D_NULL $B$rJV$9!#(B */
  }

  s_SoftUnlockStructTableFlag();
  $RELEASE(D_WorkStructRec);
  $RELEASE(D_WorkStrHashEntryPtr);
  $RELEASE(D_WorkStrHashEntry);
  $RETURN();
}

/******************************************************************** PSL **
6.3  $B9=B$BNI=$N%"%I%l%9%O%C%7%eI=$r$j%O%C%7%e$9$k(B

       written by goto@icot22      on Mon Jun  4 14:44:13 1990
<Arguments>
  ptr_to_old : $B9=B$BN$N5l%"%I%l%9(B ($BDL>o(B $B30It;2>H%;%k%X$N%]%$%s%?(B)
  ptr_to_new : $B9=B$BN$N?7%"%I%l%9(B ($BDL>o(B $BM"F~$7$?9=B$BNK\BN$X$N%]%$%s%?(B)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
  $B!&9=B$BN4IM}$5$l$F$$$k%b%8%e!<%kEy$NK\BN$rM"F~$7$?;~!"2>$K3d$jEv$F$i$l$?30It(B
    $B;2>H%;%k$r9=B$BNK\BN$HCV$-49$($k!#$3$N;~!"9=B$BNI=$N%"%I%l%9%O%C%7%eI=$r(B
    $B%j%O%C%7%e$9$k!#(B
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define	D_WorkNewHashEntryPtr	XXX
#DATA_define	D_WorkNewHashEntry	XXX
#DATA_define	D_WorkRehashStructRec	XXX

#PSL_define s_RehashStrAddrHash(ptr_to_old, ptr_to_new)
{
  $USE(D_WorkStrHashEntryPtr);
  $USE(D_WorkNewHashEntryPtr);

  s_SoftLockStructTableFlag();
  s_HashStrAddrGetEntryAddr(ptr_to_old, D_WorkStrHashEntryPtr);
  s_HashStrAddrGetEntryAddr(ptr_to_new, D_WorkNewHashEntryPtr);
         /* $B9=B$BN$N?75l%O%C%7%e%"%I%l%9$r5a$a$k(B */

  b_IfEqual(D_WorkStrHashEntryPtr, D_WorkNewHashEntryPtr){
    @DEBUG{ WARNING("s_RehashStrAddrHash","Rehash same address"); };

    /* $B9=B$BN$N?75l%O%C%7%e%"%I%l%9$,F1$8$J$i!"$j%O%C%7%e$NI,MW$O$J$$!#(B */
    /* $B$,!"?7%"%I%l%9$r9=B$BNI=$K=q$-9~$`I,MW$,$"$k!#(B */

    $USE(D_WorkRehashStructRec);
    $USE(D_WorkNewHashEntry);
    s_HashStrAddrGetEntryAddr(ptr_to_new, D_WorkNewHashEntryPtr);
    p_Read(D_WorkNewHashEntryPtr, D_WorkNewHashEntry);
    s_SearchStrAddrHashChain(D_WorkNewHashEntry, ptr_to_old, 
			     D_WorkRehashStructRec);
    @DEBUG{
      b_IfEOL(D_WorkRehashStructRec){
	VPIM_ERROR("s_RehashStrAddrHash","cannot_find_struct_rec");};
    };

    s_PutAddrStructRec(D_WorkRehashStructRec, ptr_to_new);
    /* $B<u?.$7$?%G!<%?!J9=B$BN!K$N%"%I%l%9$r9=B$BN%l%3!<%I$KEPO?$9$k(B */
   
    $RELEASE(D_WorkNewHashEntry);
    $RELEASE(D_WorkRehashStructRec);
  } else {
    $USE(D_WorkStrHashEntry);
    $USE(D_WorkNewHashEntry);
    p_Read(D_WorkStrHashEntryPtr, D_WorkStrHashEntry);
    p_Read(D_WorkNewHashEntryPtr, D_WorkNewHashEntry);
    $USE(D_WorkRehashStructRec);
    s_SearchStrAddrHashChain
               (D_WorkStrHashEntry, ptr_to_old, D_WorkRehashStructRec);
    @DEBUG{
      b_IfEOL(D_WorkRehashStructRec){
	VPIM_ERROR("s_RehashStrAddrHash","cannot_find_struct_rec");
      }
    };
    s_DeleteEntryOfStrAddrHashChain
            (D_WorkStrHashEntryPtr, D_WorkStrHashEntry, D_WorkRehashStructRec);
    s_PushStrAddrHashChain(D_WorkRehashStructRec, D_WorkNewHashEntry);
    p_Write(D_WorkNewHashEntry, D_WorkNewHashEntryPtr);
    s_PutAddrStructRec(D_WorkRehashStructRec, ptr_to_new);
    /* $B<u?.$7$?%G!<%?!J9=B$BN!K$N%"%I%l%9$r9=B$BN%l%3!<%I$KEPO?$9$k(B */
    $RELEASE(D_WorkStrHashEntry);
    $RELEASE(D_WorkNewHashEntry);
    $RELEASE(D_WorkRehashStructRec);
  }
  s_SoftUnlockStructTableFlag();
  $RELEASE(D_WorkStrHashEntryPtr);
  $RELEASE(D_WorkNewHashEntryPtr);
}

/******************************************************************** PSL **
$B9=B$BN(BID$B%O%C%7%e%A%'%$%s$N:G8e$N%(%s%H%j$rC5$9(B

       written by imai@icot22      on Wed Aug 29 14:30:21 1990

<Arguments>
  ptr_to_top : (src) $B:G=i$N9=B$BN%l%3!<%I$X$N%]%$%s%?(B ($BJQ99$5$l$J$$(B)
  ptr_to_tail: (dst) $B:G8e$N9=B$BN%l%3!<%I$X$N%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  GC$B8e$N%a%s%F%J%s%9$K;H$&(B
<ETC>
********************************************************************* PSL **/


#PSL_define s_GetTailOfStrIdHashChain(ptr_to_top,ptr_to_tail)
{
  @DEBUG{ b_IfEOL(ptr_to_top) {
    VPIM_ERROR("s_GetTailOfStrIdHashChain","EOL is illegal type");
  }};
  $USE(D_WorkPtr);
  p_MoveWord(ptr_to_top,ptr_to_tail);
  s_GetIdChainStructRec(ptr_to_top,D_WorkPtr);
  LOOP() {
    b_IfEOL(D_WorkPtr) {
      break;
    }
    p_MoveWord(D_WorkPtr,ptr_to_tail);
    s_GetIdChainStructRec(ptr_to_tail,D_WorkPtr);
  }
  $RELEASE(D_WorkPtr);
}

/******************************************************************** PSL **
7. $B9=B$BNI=$K4X$9$k=i4|A`:n(B
       written by imai@icot22      on Mon Sep 17 13:55:54 1990
<Arguments>
  $B$J$7(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  D-Code $B$N%b%8%e!<%k$O!"(Bdcode_apply/3 $B$,B>$N%/%i%9%?$KEj$2$i$l$?>l9g$K(B
  $B%R!<%W$K(B D-Code $B%b%8%e!<%k$,3d$jIU$1$i$l$k$3$H$rKI$0$?$a!"=i4|2=$N;~E@$G(B
  $B%/%i%9%?#0$,$3$N%b%8%e!<%k$rEPO?$7$F$$$?$3$H$K$9$k!#(B
<Examples>
<Test>
<Explanation>
  D-Code $B$N%b%8%e!<%k$N(B ID $B$O!"(B0xffffffff $B$H$9$k!#0n$l$J$$8B$j;H$o$J$$(B
  $BHV9f$G$"$k$+$i(B
<ETC>
  dcode_apply $B$O!"(Benqueue_cluster $B$N%/%i%9%?HV9f$,L$Dj5A$@$C$?>l9g$K(B
  $B$3$l$,6qBN2=$7$?;~$KEj$2$i$l$k!#>\$7$/$O(B klb_fork.psl.c $B$r;2>H$N$3$H(B
********************************************************************* PSL **/

#PSL_define s_InitialExportDCodeModule()
{
  /* $B9=B$BN%l%3!<%I$N3dIU$1$H!"%9%m%C%H$N=i4|2=(B */
  $USE(D_WorkStructRec);
  s_AllocEntryOfStructRec(D_WorkStructRec);

  $USE(D_WorkStructID);  $USE(D_WorkDcodeaddr);

  b_SetImmTypeValueMRBoff(INT,_ALL1,D_WorkStructID);
  s_PutIdStructRec(D_WorkStructRec,D_WorkStructID);

/*  b_SetImmTypeValueMRBoff(MOD,_SYSTEM_CODE_AREA_BASE,D_WorkDcodeaddr); */
  s_GetBuiltinModulePtr(D_WorkDcodeaddr);
  s_PutAddrStructRec(D_WorkStructRec,D_WorkDcodeaddr);

  $USE(D_WorkStrHashEntryPtr); $USE(D_WorkStrHashEntry);

  s_PutAddrChainStructRec(D_WorkStructRec,D_NULL); /* $BB?J,$J$/$F$bBg>fIW(B */

  s_SoftLockStructTableFlag();

  /* ID$B%A%'!<%s$K%W%C%7%e(B */
  s_HashStrIdGetEntryAddr(D_WorkStructID, D_WorkStrHashEntryPtr);
  p_Read(D_WorkStrHashEntryPtr, D_WorkStrHashEntry);
  s_PushStrIdHashChain(D_WorkStructRec,D_WorkStrHashEntry);
  p_Write(D_WorkStrHashEntry, D_WorkStrHashEntryPtr);

  /* $B%"%I%l%9%A%'!<%s$K%W%C%7%e(B */
  s_HashStrAddrGetEntryAddr(D_WorkDcodeaddr, D_WorkStrHashEntryPtr);
  p_Read(D_WorkStrHashEntryPtr, D_WorkStrHashEntry);
  s_PushStrAddrHashChain(D_WorkStructRec,D_WorkStrHashEntry);
  p_Write(D_WorkStrHashEntry, D_WorkStrHashEntryPtr);

  s_SoftUnlockStructTableFlag();
  $RELEASE(D_WorkDcodeaddr);
  $RELEASE(D_WorkStructID);
  $RELEASE(D_WorkStructRec);
  $RELEASE(D_WorkStrHashEntryPtr); $RELEASE(D_WorkStrHashEntry);
}

/******************************************************************** PSL **
s_GetStructID_IfStructFlagOn

       written by ttakagi@icot22      on Wed Nov 14 17:01:43 1990
<Arguments>
 ptr_to_bimp_rec: $B9uM"F~%l%3!<%I$X$N%]%$%s%?(B
 exref_id:        $B30It;2>H#I#D(B
 struct_id:       $B9=B$BN#I#D(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B9=B$BN%U%i%0$,(Bon$B$G$"$l$P9=B$BN(BID$B$rF@$k!#(B

<Explanation>
  $B30It;2>H%;%k$rM"=P$9$k;~$K8F$P$l$k!#(B
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkExRefId XXX

#PSL_define s_GetStructID_IfStructFlagOn(ptr_to_bimp_rec, exref_id, struct_id)
{
  s_IfStructFlagOn(exref_id) {
    $USE(D_WorkPtrToExCell);
    s_GetExcellBImpRec(ptr_to_bimp_rec, D_WorkPtrToExCell);
    $CALL( s_GetStructIdStrRec_Sub(D_WorkPtrToExCell, struct_id) );
    $RELEASE(D_WorkPtrToExCell);
  } else {
    p_MoveWord(D_ALL1, struct_id);
  }
}

/******************************************************************** PSL **
$B9=B$BNI=$N%m%C%/!&%"%s%m%C%/A`:n(B

       written by ttakagi@icot22      on Thu Nov 15 20:51:18 1990

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
$B!&%/%i%9%?Kh$N6&M-%(%j%"$K%m%C%/MQ$N%U%i%0$r@_$1$F!"9=B$BN4IM}4X78$N(B
  $B=hM}$r9T$J$&>l9g$K$O!"%U%i%0$N%?%$%W$r(B SLOCK $B$K$9$k!#(B
$B!&=hM}$,=*N;$7$?$i!"%U%i%0$N%?%$%W$r(B INT $B$KLa$9!#(B

<ETC>
********************************************************************* PSL **/

#PSL_define s_SoftLockStructTableFlag ()
{
  $USE(D_WorkSlock);
  b_SoftLockSharedAreaX
      (_MEM_MANAGE_AREA_BASE, _STR_TABLE_LOCK_FLAG_OFST, D_WorkSlock);
  $RELEASE(D_WorkSlock);
}

#PSL_define s_SoftUnlockStructTableFlag ()
{
  $USE(D_WorkSlock);
  b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkSlock);
  b_SoftUnlockWithOrgTagSharedAreaX
      (D_WorkSlock,_MEM_MANAGE_AREA_BASE,_STR_TABLE_LOCK_FLAG_OFST);
  $RELEASE(D_WorkSlock);
}


