
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V10/structures/str_string.psl.c
   ----- CREATED   : by f-hataza@icot22, on Fri May 18 17:01:32 1990
   ----- LAST SAVED: by kawai@icot22, on Thu Sep 26 12:17:28 1991
   ----- LEVEL     : STRUCTURES
   ----- ABSTRACT  : $B%9%H%j%s%0$NA`:n(B

  0.  $B%9%H%j%s%0$N%G!<%?9=B$(B
  1.  $B%9%H%j%s%0$N%G%#%9%/%j%W%?A`:n(B
    1.1  $B%G%#%9%/%j%W%?$N@_Dj(B/$B=q$-9~$_(B/$BFI$_$@$7(B
    1.2  $B%9%H%j%s%0%?%$%W$NFI$_$@$7(B
    1.3  $B%o!<%I?t$NFI$_$@$7(B
    1.4  $BMWAG?t$NFI$_$@$7(B
  2.  $B%9%H%j%s%0$N3d$jIU$1(B
  3.  $B%9%H%j%s%0$N2s<}(B
  4.  $B%9%H%j%s%0MWAG$N%o!<%IC10L$N=q$-9~$_(B/$BFI$_$@$7(B
  5.  $B%9%H%j%s%0MWAG$N=q$-9~$_(B/$BFI$_$@$7(B
  6.  $B%9%H%j%s%0MWAG$N%o!<%IC10L$N%3%T!<(B
  7.  $B%9%H%j%s%0MWAG$N%o!<%IC10L%5!<%A(B
    7.1  $B%9%H%j%s%0MWAG$N%o!<%IC10L%5!<%A(B($B=gJ}8~(B)
    7.2  $B%9%H%j%s%0MWAG$N%o!<%IC10L%5!<%A(B($B5UJ}8~(B)
    7.3  $B%F!<%V%k$rMQ$$$?%9%H%j%s%0MWAG$N%o!<%IC10L%5!<%A(B($B=gJ}8~(B)
    7.4  $B%F!<%V%k$rMQ$$$?%9%H%j%s%0MWAG$N%o!<%IC10L%5!<%A(B($B5UJ}8~(B)
    7.5  $B%9%H%j%s%0MWAG$N%o!<%IC10L%5!<%A$N$?$a$NItIJ%^%/%m(B
  8. $B%9%H%j%s%0%*%Z%l!<%7%g%s(B
    8.1 $B%9%H%j%s%0%*%Z%l!<%7%g%s(B($B=gJ}8~(B)
    8.2 $B%9%H%j%s%0%*%Z%l!<%7%g%s(B($B5UJ}8~(B)
    8.3 $B%9%H%j%s%0%*%Z%l!<%7%g%sMQ$NItIJ%^%/%m(B
  9. $B%9%H%j%s%0$NBg>.Hf3S(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/****************************************************************************
  0. VPIM $B$K$*$1$k%9%H%j%s%0$N%G!<%?9=B$(B (1989.09.20 $B2~(B)
     ----------------------------------- (1989.10.12 $B0lIt2~(B)
                                         (1990.09.11 $B0lIt2~(B)

  $B!&MWAG%5%$%:$H$7$F$O!"(B1, 8, 16, 32 $B%S%C%H$r%5%]!<%H$9$k!#(B

  $B!&%G!<%?9=B$$O!"(B

     +----+----------+              +-----+----+----+----+----+
     |STRG|         -+------------->|CDESC|type|   word size  |
     +----+----------+              +-----+----+----+----+----+
                                    |DNTC |      $BMW(B    $BAG(B     | ($B%?%$%WJQ99(B
                                    +-----+-------------------+    1990.03.01)
                                    |     |                   |

  $B!&%9%H%j%s%0$NBh0l%o!<%I$O!"%G%#%9%/%j%W%?$H$7%G!<%?%?%$%W$O(BCDESC$B$H$9$k!#(B
    $B%G%#%9%/%j%W%?$K$O!"(Btype(8$B%S%C%H(B) $B$H(B word size(24$B%S%C%H(B)$B$r3JG<$9$k!#(B

  $B!&(Btype $B$N(B8$B%S%C%H$K$h$C$F!"(B
        000XXXXX :  1$B%S%C%H%9%H%j%s%0(B
        001XXXXX :  8$B%S%C%H%9%H%j%s%0(B
        010XXXXX : 16$B%S%C%H%9%H%j%s%0(B
        011XXXXX : 32$B%S%C%H%9%H%j%s%0(B
       (1------- : Module Top       )
    $B$rI=$7!"(BXXXXX $B$O:G=*%o!<%ICf$NL$;HMQMWAG?t(B(0-31)$B$rI=$9!#(B

  $B!&(Bword size $B$O!"%9%H%j%s%0$NMWAG$r3JG<$9$k$N$KI,MW$J%o!<%I?t(B
   ($B%G%#%9%/%j%W%?$NJ,$O=|$/(B) $B$r(B24$B%S%C%H$GI=$9!#(B

  $B!&MWAG$O!"(B1$B%S%C%H%9%H%j%s%0$G$O(B 1$B%o!<%I$K(B32$BMWAG!"(B
            8$B%S%C%H%9%H%j%s%0$G$O(B           4$BMWAG!"(B
           16$B%S%C%H%9%H%j%s%0$G$O(B           2$BMWAG!"(B
           32$B%S%C%H%9%H%j%s%0$G$O(B           1$BMWAG$:$D$r!"(B
    $B3F%o!<%I$N>e0L%S%C%HB&$+$i5M$a$F3JG<$9$k!#(B($BJQ99(B 1989.10.12)
    $B:G=*%o!<%I$NL$;HMQNN0h$K$O!"(B0$B$r5M$a$k!#(B($BJQ99(B 1990.09.11)
                               ^^^^^^^^^^^

  $B!&(BKL1$B%W%m%0%i%`>e$NDj?t$O!"(B8$B%S%C%H(B(ascii)$B%9%H%j%s%0$H$7$F07$&!#(B

  <<$BCm0U(B>>
   $B$3$3$K5-=R$7$?%9%H%j%s%0$N%G!<%?9=B$$K!"D>@\4X78$9$kItJ,$O(B

      1.  $B%"%;%s%V%i(B
      2.  VPIM$BMQ(B $B%3%s%=!<%k=PNO%k!<%A%s(B
      3.  str_string.psl.c ($BEv%U%!%$%k(B)

   $B$G$"$k!#JQ99;~$K$OCm0U$5$l$?$$!#(B
   $B$^$?!"%9%H%j%s%0$N9=B$$K$D$$$F$O!"3F<R$N<B5!$4$H$K0[$J$k$H;W$o$l$k$,!"(B
   $BEv%U%!%$%k$N3F%^%/%m$H%$%s%?%U%'!<%9$r0lCW$5$;$F$*$1$P!"(Binterpreter,
   functions $B%l%Y%k$N%^%/%m$rJQ99$9$kI,MW$O$J$$!#(B
***************************************************************************/
/* $B%9%H%j%s%0(B1$B%o!<%I$N%S%C%H?t$NDj5A(B */
#CONST_define _WORD_SIZE_OF_STRG           32

/* $B%G%#%9%/%j%W%?Cf$N%S%C%H0LCV$NDj5A(B */
#CONST_define _BIT_POS_UNUSE_STRG_DESC     24
#CONST_define _BIT_POS_ELEM_SIZE_STRG_DESC 29

/* $B%G%#%9%/%j%W%?Cf$N%U%#!<%k%I$r<h$j=P$9$?$a$N%^%9%/%Q%?%s(B */
#CONST_define _MASK_UNUSE_STRG_DESC       0x1f000000
#CONST_define _MASK_WORD_SIZE_STRG_DESC   0x00ffffff

/* $B%G%#%9%/%j%W%?$N%?%$%W$NDj5A(B */
#CONST_define _DESC_TYPE_STRG1     0x00000000
#CONST_define _DESC_TYPE_STRG8     0x20000000
#CONST_define _DESC_TYPE_STRG16    0x40000000
#CONST_define _DESC_TYPE_STRG32    0x60000000

/* $BMWAG%5%$%:$NDj5A(B */
#CONST_define _ELEM_SIZE_OF_STRG1           1
#CONST_define _ELEM_SIZE_OF_STRG8           8
#CONST_define _ELEM_SIZE_OF_STRG16         16
#CONST_define _ELEM_SIZE_OF_STRG32         32

/* 1$B%o!<%ICf$NMWAG?t$NDj5A(B */
#CONST_define _NUM_OF_ELEM_STRG1           32
#CONST_define _NUM_OF_ELEM_STRG8            4
#CONST_define _NUM_OF_ELEM_STRG16           2
#CONST_define _NUM_OF_ELEM_STRG32           1

/* $B%9%H%j%s%0$NMWAG$r<h$j=P$9$?$a$N%^%9%/(B */
#CONST_define _MASK_ELEM_STRG1     0x00000001
#CONST_define _MASK_ELEM_STRG8     0x000000ff
#CONST_define _MASK_ELEM_STRG16    0x0000ffff
#CONST_define _MASK_ELEM_STRG32    0xffffffff

/* $B%9%H%j%s%0$N%G%#%9%/%j%W%?$r=|$/%o!<%I?t$N:GBgCM(B */
#CONST_define _MAX_WORD_SIZE_OF_STRG  0x00ffffff

/******************************************************************** PSL **
  1.  $B%9%H%j%s%0$N%G%#%9%/%j%W%?A`:n(B
    1.1  $B%G%#%9%/%j%W%?$N@_Dj(B/$B=q$-9~$_(B/$BFI$_$@$7(B/$BJQ99(B

       written by f-hataza@icot22      on Fri May 18 17:37:15 1990
<Arguments>
  string_ptr :    $B%9%H%j%s%0$X$N%]%$%s%?$r;}$D%l%8%9%?(B
  length_reg :    $B%9%H%j%s%0$NMWAG?t$r3JG<$9$k%l%8%9%?(B
  elm_size_reg :  $B%9%H%j%s%0$NMWAG%5%$%:$r3JG<$9$k%l%8%9%?(B
  desc_reg :      $B%9%H%j%s%0$N%G%#%9%/%j%W%?$r3JG<$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  s_SetStringDescOnReg(length_reg, elm_size_reg, desc_reg)
       $BMWAG?t(B length_reg $B!"MWAG%5%$%:(B elm_size_reg $B$N%9%H%j%s%0$N(B
       $B%G%#%9%/%j%W%?$r(B $B%l%8%9%?(Bdesc_reg $B>e$K@_Dj$9$k!#(B
  s_PutStringDesc(desc_reg, string_ptr)
       desc_reg$B>e$N%9%H%j%s%0$N%G%#%9%/%j%W%?$r(Bstring_ptr$B$N@h$K=q$-9~$`!#(B
  s_GetStringDesc(string_ptr, desc_reg)
       string_ptr $B$,;X$9%9%H%j%s%0$N%G%#%9%/%j%W%?$r(B desc_reg $B$KJV$9!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#DATA_define D_WorkElemInWord    XXX
#DATA_define D_WorkUnUse         XXX
#DATA_define D_WorkStrgSize      XXX

#PSL_define s_SetStringDescOnReg(length_reg, elm_size_reg, desc_reg)
{
  $USE(D_WorkElemInWord);

      /* $BMWAG%5%$%:$N@_Dj(B */
  ValueSwitch(elm_size_reg) {
    case  1:  p_SetImmediateValue(_DESC_TYPE_STRG1, desc_reg);
              p_SetImmediateValue(_NUM_OF_ELEM_STRG1, D_WorkElemInWord);
              break;
    case  8:  p_SetImmediateValue(_DESC_TYPE_STRG8, desc_reg);
              p_SetImmediateValue(_NUM_OF_ELEM_STRG8, D_WorkElemInWord);
              break;
    case 16:  p_SetImmediateValue(_DESC_TYPE_STRG16, desc_reg);
              p_SetImmediateValue(_NUM_OF_ELEM_STRG16, D_WorkElemInWord);
              break;
    case 32:  p_SetImmediateValue(_DESC_TYPE_STRG32, desc_reg);
              p_SetImmediateValue(_NUM_OF_ELEM_STRG32, D_WorkElemInWord);
              break;
    default:  @DEBUG{
	        VPIM_ERROR("s_SetStringDescOnReg","Illegal Element Size");
              };
  }
      /* $BL$;HMQMWAG?t$N@_Dj(B */
  $USE(D_WorkUnUse);
  b_ModuloWithDNTC(length_reg, D_WorkElemInWord, D_WorkUnUse);
  b_IfNotEqual(D_WorkUnUse, D_NULL) {
         /* $BL$;HMQMWAG?t$,(B0$B0J30$N;~$O!"%G%#%9%/%j%W%?$K@_Dj$9$k(B */
    b_SubtractWithDNTC(D_WorkElemInWord, D_WorkUnUse, D_WorkUnUse);
    b_ShiftLeftImmediateWithDNTC(D_WorkUnUse, _BIT_POS_UNUSE_STRG_DESC,
				                                D_WorkUnUse);
    b_BitwiseOrWithDNTC(desc_reg, D_WorkUnUse, desc_reg);
  }
  $RELEASE(D_WorkUnUse);

      /* $B%o!<%I?t$r@_Dj(B */
  $USE(D_WorkStrgSize);
  b_IfNotEqual(length_reg, D_NULL) {
         /* $B%o!<%I?t$,(B0$B0J30$N;~$O!"%G%#%9%/%j%W%?$K@_Dj$9$k(B */
    b_SubtractImmediateWithDNTC(length_reg, _ONE, D_WorkStrgSize);
    b_DivideWithDNTC(D_WorkStrgSize, D_WorkElemInWord, D_WorkStrgSize);
    b_IncrementReg(D_WorkStrgSize);
    @DEBUG{
      b_IfGreaterImm(D_WorkStrgSize, _MAX_WORD_SIZE_OF_STRG) {
        OUT_OF_SPEC("s_SetStringDesc", "Too Large String");
      }
    };
    b_BitwiseOrWithDNTC(desc_reg, D_WorkStrgSize, desc_reg);
  }
  b_SetImmTypeMRBoff(CDESC, desc_reg);
  $RELEASE(D_WorkStrgSize);
  $RELEASE(D_WorkElemInWord);
}

#PSL_define  s_PutStringDesc(desc_reg, string_ptr)
{
  p_Write(desc_reg, string_ptr);
}

#PSL_define s_GetStringDesc(string_ptr, desc_reg)
{
  @DEBUG {
    s_IfNotStrings(string_ptr){VPIM_ERROR ("s_GetStringDesc","Illegal Type");}
  };
  p_Read(string_ptr, desc_reg);
}


/* $BMWAG%5%$%:$NJQ99(B */
#DATA_define  D_WorkStrBitLength  XXX

#PSL_define  s_GetConvertedStrDesc(string, new_elm_size, new_str_desc)
{
  $USE(D_WorkStrLength);
  $USE(D_WorkStrElmSize);
  $USE(D_WorkStrBitLength);
  $USE(D_WorkStrElmLength);
  s_GetStringType(string, D_WorkStrLength, D_WorkStrElmSize);
  b_MultiplyWithDNTC(D_WorkStrLength, D_WorkStrElmSize, D_WorkStrBitLength);
  b_ModuloWithDNTC(D_WorkStrBitLength, new_elm_size, D_WorkStrElmLength);
  b_IfEqual(D_WorkStrElmLength, D_NULL)
    { /* $BMWAG6-3&$,0lCW$9$k;~(B */
      b_DivideWithDNTC(D_WorkStrBitLength, new_elm_size, D_WorkStrElmLength);
    }
  else
    { /* $BMWAG6-3&$,0lCW$7$J$$;~(B */
      b_DivideWithDNTC(D_WorkStrBitLength, new_elm_size, D_WorkStrElmLength);
      /* $BMWAG?t$rDI2C$9$k!#KvHx$KL58zNN0h$,M-$C$F$b%<%m5M$a$5$l$F$$$kH&(B */
      b_IncrementReg(D_WorkStrElmLength);
    }

  s_SetStringDescOnReg(D_WorkStrElmLength, new_elm_size, new_str_desc);

  $RELEASE(D_WorkStrLength);
  $RELEASE(D_WorkStrElmSize);
  $RELEASE(D_WorkStrBitLength);
  $RELEASE(D_WorkStrElmLength);
}

/******************************************************************** PSL **
    1.2  $B%9%H%j%s%0%?%$%W$NFI$_$@$7(B

       written by f-hataza@icot22      on Fri May 18 18:25:40 1990
<Arguments>
  string_ptr :    $B%9%H%j%s%0$X$N%]%$%s%?$r;}$D%l%8%9%?(B
  length_reg :    $B%9%H%j%s%0$NMWAG?t$r3JG<$9$k%l%8%9%?(B
  elm_size_reg :  $B%9%H%j%s%0$NMWAG%5%$%:$r3JG<$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  s_GetStringType(string_ptr, length_reg, elm_size_reg)
       string_ptr $B$,;X$9%9%H%j%s%0$NMWAG?t$r(B length_reg $B$K!"(B
       $BMWAG%5%$%:$r(B elm_size_reg $B$KJV$9!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#DATA_define D_WorkStringType  XXX
#DATA_define D_WorkDesc        XXX

#PSL_define s_GetStringType(string_ptr, length_reg, elm_size_reg)
{
  @DEBUG {
    b_WarningIfSameRegNum (string_ptr, length_reg);
    b_WarningIfSameRegNum (string_ptr, elm_size_reg);
    s_IfNotStrings(string_ptr) {
      VPIM_ERROR ("s_GetStringType", "Illegal Type");
    }
  };
      /* $B%G%#%9%/%j%W%?$NFI$_9~$_(B */
  $USE(D_WorkDesc);
  s_GetStringDesc(string_ptr, D_WorkDesc);
      /* $BMWAG%5%$%:$N<h$j$@$7(B */
  $USE(D_WorkStringType); $USE(D_WorkElemInWord);
  b_ShiftRightImmediate (D_WorkDesc,
			 _BIT_POS_ELEM_SIZE_STRG_DESC, D_WorkStringType);
  ValueSwitch(D_WorkStringType) {
    case 0: p_SetImmediateWord(INT,_MRB_OFF,_ELEM_SIZE_OF_STRG1,elm_size_reg);
            p_SetImmediateValue(_NUM_OF_ELEM_STRG1, D_WorkElemInWord);
            break;
    case 1: p_SetImmediateWord(INT,_MRB_OFF,_ELEM_SIZE_OF_STRG8,elm_size_reg);
            p_SetImmediateValue(_NUM_OF_ELEM_STRG8, D_WorkElemInWord);
            break;
    case 2: p_SetImmediateWord(INT,_MRB_OFF,_ELEM_SIZE_OF_STRG16,elm_size_reg);
            p_SetImmediateValue(_NUM_OF_ELEM_STRG16, D_WorkElemInWord);
            break;
    case 3: p_SetImmediateWord(INT,_MRB_OFF,_ELEM_SIZE_OF_STRG32,elm_size_reg);
            p_SetImmediateValue(_NUM_OF_ELEM_STRG32, D_WorkElemInWord);
            break;
    default:   @DEBUG{ VPIM_ERROR("s_GetStringType", "Illegal Type"); };
  }
  $RELEASE(D_WorkStringType);
      /* $BL$;HMQMWAG?t$NFI$_$@$7(B */
  $USE(D_WorkUnUse);
  b_BitwiseAndImmediateWithDNTC(D_WorkDesc, _MASK_UNUSE_STRG_DESC,
				                               D_WorkUnUse);
  b_ShiftRightImmediateWithDNTC(D_WorkUnUse, _BIT_POS_UNUSE_STRG_DESC,
				                               D_WorkUnUse);
      /* $BMWAG?t$r@_Dj(B */
  b_BitwiseAndImmediateWithDNTC(D_WorkDesc, _MASK_WORD_SIZE_STRG_DESC,
				                                length_reg);
  b_MultiplyWithDNTC(length_reg, D_WorkElemInWord, length_reg);
  b_SubtractWithDNTC(length_reg, D_WorkUnUse, length_reg);
  b_SetImmTypeMRBoff(INT, length_reg);
  $RELEASE(D_WorkElemInWord); $RELEASE(D_WorkUnUse); $RELEASE(D_WorkDesc);
}

/******************************************************************** PSL **
    1.3  $B%o!<%I?t$NFI$_$@$7(B

       written by f-hataza@icot22      on Fri May 18 18:59:03 1990
<Arguments>
  string_ptr :    $B%9%H%j%s%0$X$N%]%$%s%?(B($B%l%8%9%?(B)
  desc_reg :      $B%9%H%j%s%0$N%G%#%9%/%j%W%?$r3JG<$9$k%l%8%9%?(B
  word_size_reg : $B%9%H%j%s%0$NMWAG$N%o!<%I?t(B($B%G%#%9%/%j%W%?$r4^$^$J$$(B)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  s_GetStringSizeWithDesc(desc_reg, word_size_reg)
       $B%9%H%j%s%0$N%G%#%9%/%j%W%?(B desc_reg $B$+$iMWAG$N%o!<%I?t$rFI$_=P$9!#(B
  s_GetStringSize(string_ptr, word_size_reg)
       string_ptr $B$,;X$9%9%H%j%s%0$NMWAG$N%o!<%I?t(B($B%G%#%9%/%j%W%?$r4^$^$J$$(B)$B$r(B
       word_size_reg $B$KJV$9!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_GetStringSizeWithDesc(desc_reg, word_size_reg)
{
  b_BitwiseAndImmediateWithDNTC(desc_reg, _MASK_WORD_SIZE_STRG_DESC,
				                             word_size_reg);
  b_SetImmTypeMRBoff(INT, word_size_reg);
}

#PSL_define s_GetStringSize(string_ptr, word_size_reg)
{
  @DEBUG {
    s_IfNotStrings(string_ptr) {
      VPIM_ERROR ("s_GetStringSize", "Illegal Type");
    }
  };
      /* $B%G%#%9%/%j%W%?$NFI$_9~$_(B */
  s_GetStringDesc(string_ptr, word_size_reg);
      /* $B%o!<%I?t$r@_Dj(B */
  b_BitwiseAndImmediateWithDNTC(word_size_reg, _MASK_WORD_SIZE_STRG_DESC,
				                             word_size_reg);
  b_SetImmTypeMRBoff(INT, word_size_reg);
}

/******************************************************************** PSL **
    1.4  $BMWAG?t$NFI$_$@$7(B

       written by f-hataza@icot22      on Mon Aug 20 10:48:27 1990
<Arguments>
  string_ptr :    $B%9%H%j%s%0$X$N%]%$%s%?$r;}$D%l%8%9%?(B
  length_reg :    $B%9%H%j%s%0$NMWAG?t$r3JG<$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  s_GetStringLength(string_ptr, length_reg)
       string_ptr $B$,;X$9%9%H%j%s%0$NMWAG?t$r(B length_reg $B$KJV$9!#(B
<Examples>
<Test>
<Explanation>
<ETC>
  $BF2A0;a$NMW@A$K$h$j:n@.(B (90.08.20)
********************************************************************* PSL **/

#PSL_define s_GetStringLength(string_ptr, length_reg)
{
  @DEBUG {
    s_IfNotStrings(string_ptr) {
      VPIM_ERROR ("s_GetStringLength", "Illegal Type");
    }
  };

  s_GetStringType(string_ptr, length_reg, D_VOID);
}



/******************************************************************** PSL **
  2.  $B%9%H%j%s%0$N3d$jIU$1(B

       written by f-hataza@icot21      on Tue Sep  5 14:11:37 1989

<Arguments>
  A_DstReg   : $B3d$jIU$1$?%9%H%j%s%0$X$N%]%$%s%?$r3JG<$9$k%l%8%9%?(B
  A_StrgDesc : $B%9%H%j%s%0$N%G%#%9%/%j%W%?$r;}$D%l%8%9%?(B

<Temporally Used Variables>
<Level> structures
<PreCondition>
  $B!&$"$i$+$8$aMWAG?t!"MWAG%5%$%:$+$i%G%#%9%/%j%W%?$r(BA_StrgDesc$B$K@_Dj$7$F$*$/!#(B
<Function>
  $B!&%G%#%9%/%j%W%?(BA_StrgDesc$B$K9g$C$?%9%H%j%s%0$rE,Ev$J%U%j!<%j%9%H$+$i3d$jIU$1(B,
  A_DstReg $B$K!"%]%$%s%?$r=q$-9~$`!#(B
  $B!&%R!<%WNN0h$,B-$j$J$$>l9g!"(BA_DstReg $B$K(BD_NULL$B$,JV$k!#(B
  $B$3$N>l9g!"$3$N%k!<%A%s$r8F$S=P$7$?B&$G!"(B D-Code$B$r:n$j(B
  $B%(%s%-%e!<$9$k=hM}$r=q$/I,MW$,$"$k!#(B
<Examples>
  f_AllocString, f_CopyString
<Test>
<Explanation>
  $B%9%H%j%s%0$r3d$jIU$1$k$N$KI,MW$J%;%k$NBg$-$5$O!"(B
      $B%o!<%I?t(B(*) = ($BMWAG?t(B - 1)/(1$B%o!<%I$KF~$kMWAG?t(B) + 1
         (*) $BC"$7!"<B:]$K$O%G%#%9%/%j%W%?$NJ,$,$b$&(B1$B%o!<%II,MW!#(B
  $B$H$7$F!"%o!<%I?t$rI=$9(B2$B?J?t$N0lHV:8$K$"$k(B"1"$B$N0LCV$K$h$C$F6hJL$9$k!#(B

<ETC>
  16$B%o!<%I0J>e$N%;%k$G$O!"%U%j!<%j%9%H$N%j%s%/0LCV$O(B2$B%o!<%IL\$G$"$k$3$H$KCm0U(B!
     ($B%9%H%j%s%0$N%]%$%s%?$O(B1$B%o!<%IL\$r;X$9(B)
********************************************************************* PSL **/
#DATA_define D_WorkAllocCount           XXX

#SUBARG_define	A_DstReg	DST
#SUBARG_define	A_StrgDesc	SRC

#SUBROUTINE s_AllocStrgMRBoffWithDesc_Sub(A_DstReg, A_StrgDesc)
{
  $USE(D_WorkStrgSize);
  s_GetStringSizeWithDesc(A_StrgDesc, D_WorkStrgSize);

  $USE(D_WorkAllocCount);
  b_CountLeftMostZeros(D_WorkStrgSize, D_WorkAllocCount);
  b_SubtractImmediateWithDNTC
            (D_WorkAllocCount, _WORD_SIZE_OF_STRG, D_WorkAllocCount);
  b_SubtractWithDNTC(D_NULL, D_WorkAllocCount, D_WorkAllocCount);
      /* D_WorkStrgSize    --->  D_WorkAllocCount ----> allocate
       *              0                   0              1 word
       *              1                   1              2 words
       *          2 - 3                   2              4
       *          4 - 7                   3              8
       *          8 -15                   4             16
       */
  @DEBUG{
    b_IfLess(D_WorkAllocCount, D_NULL){
      VPIM_ERROR("s_AllocStrgMRBoffWithDesc", "Illegal Allocate Count");
    }
  };
  ValueSwitch(D_WorkAllocCount){
    case 0: b_Alloc1(A_DstReg, STRG); break;
    case 1: b_Alloc2(A_DstReg, STRG); break;
    case 2: b_Alloc4(A_DstReg, STRG); break;
    case 3: b_Alloc8(A_DstReg, STRG); break;
    case 4: b_AllocN(A_DstReg, D_Free_16_PtrReg, _SIZE_OF_FL16, STRG);
            b_DecrementAddrReg(A_DstReg);       /* $B%]%$%s%?$r(B1$B%o!<%IL\$K(B */
            break;
    case 5: b_AllocN(A_DstReg, D_Free_32_PtrReg, _SIZE_OF_FL32, STRG);
            b_DecrementAddrReg(A_DstReg);       /* $B%]%$%s%?$r(B1$B%o!<%IL\$K(B */
            break;
    case 6: b_AllocN(A_DstReg, D_Free_64_PtrReg, _SIZE_OF_FL64, STRG);
            b_DecrementAddrReg(A_DstReg);       /* $B%]%$%s%?$r(B1$B%o!<%IL\$K(B */
            break;
    case 7: b_AllocN(A_DstReg, D_Free_128_PtrReg, _SIZE_OF_FL128, STRG);
            b_DecrementAddrReg(A_DstReg);       /* $B%]%$%s%?$r(B1$B%o!<%IL\$K(B */
            break;
    case 8: b_AllocOneHeapPage(A_DstReg);
            b_SetImmTypeMRBoff (STRG, A_DstReg);
            break;
    default: b_IncrementReg(D_WorkStrgSize);
             b_AllocMultipleHeapPage (D_WorkStrgSize, A_DstReg);
      	     b_DecrementReg(D_WorkStrgSize);
             b_IfWordEq(A_DstReg, D_NULL) {
               $RELEASE(D_WorkAllocCount);   $RELEASE(D_WorkStrgSize);
               goto End;
             }
	        /* $B%R!<%WNN0h$,B-$j$J$$>l9g!"(BA_DstReg $B$K(BD_NULL$B$,JV$k!#(B
	         * $B$3$N>l9g!"$3$N%k!<%A%s$r8F$S=P$7$?B&$G!"(B
	         * D-Code$B$r:n$j%(%s%-%e!<$9$k=hM}$r=q$/I,MW$,$"$k!#(B
	         */
             b_SetImmTypeMRBoff (STRG, A_DstReg);
  } /* end of ValueSwitch */
  $RELEASE(D_WorkAllocCount);
  s_PutStringDesc(A_StrgDesc, A_DstReg);  /* $B%G%#%9%/%j%W%?$r=q$-9~$`(B */
  b_IfNotZero(D_WorkStrgSize){
    b_DecrementReg(D_WorkStrgSize);
    s_PutStringWordPosReg(A_DstReg,D_WorkStrgSize,D_NULL);
                                 /* clear unused field */
  }
  $RELEASE(D_WorkStrgSize);
End: ;
  $RETURN();
}

/******************************************************************** PSL **
  3.  $B%9%H%j%s%0$N2s<}(B

       written by f-hataza@icot21      on Fri Sep  8 15:31:43 1989
<Arguments>
  src_reg : $B2s<}$9$k%9%H%j%s%0$X$N%]%$%s%?$r;}$D%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  src_reg $B$G;X$5$l$?%9%H%j%s%0$r!"%U%j!<%j%9%H$K2s<}$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
  16$B%o!<%I0J>e$N%;%k$G$O!"%U%j!<%j%9%H$N%j%s%/0LCV$O(B2$B%o!<%IL\$G$"$k$3$H$KCm0U(B!
     ($B%9%H%j%s%0$N%]%$%s%?$O(B1$B%o!<%IL\$r;X$7$F$$$k(B)

********************************************************************* PSL **/
#PSL_define s_ReclaimString(src_reg)
{
  $USE(D_WorkStrgSize);
  s_GetStringSize(src_reg, D_WorkStrgSize);
  $USE(D_WorkAllocCount);
  b_CountLeftMostZeros(D_WorkStrgSize, D_WorkAllocCount);
  b_SubtractImmediateWithDNTC
            (D_WorkAllocCount, _WORD_SIZE_OF_STRG, D_WorkAllocCount);
  b_SubtractWithDNTC(D_NULL, D_WorkAllocCount, D_WorkAllocCount);
      /* D_WorkStrgSize    ---> D_WorkAllocCount ---->  reclaim
       *              0                   0              1 word
       *              1                   1              2 words
       *          2 - 3                   2              4
       *          4 - 7                   3              8
       *          8 -15                   4             16
       */
  @DEBUG{
    b_IfLess(D_WorkAllocCount, D_NULL){
      VPIM_ERROR("s_ReclaimString", "Illegal Size");
    }
  };
  ValueSwitch(D_WorkAllocCount){
    case 0: b_Reclaim1(src_reg); break;
    case 1: b_Reclaim2(src_reg); break;
    case 2: b_Reclaim4(src_reg); break;
    case 3: b_Reclaim8(src_reg); break;
    case 4: b_IncrementAddrReg(src_reg);    /* $B%]%$%s%?$r(B2$B%o!<%IL\$K(B */
            b_ReclaimN(src_reg, D_Free_16_PtrReg, _SIZE_OF_FL16); break;
    case 5: b_IncrementAddrReg(src_reg);    /* $B%]%$%s%?$r(B2$B%o!<%IL\$K(B */
            b_ReclaimN(src_reg, D_Free_32_PtrReg, _SIZE_OF_FL32); break;
    case 6: b_IncrementAddrReg(src_reg);    /* $B%]%$%s%?$r(B2$B%o!<%IL\$K(B */
            b_ReclaimN(src_reg, D_Free_64_PtrReg, _SIZE_OF_FL64); break;
    case 7: b_IncrementAddrReg(src_reg);    /* $B%]%$%s%?$r(B2$B%o!<%IL\$K(B */
            b_ReclaimN(src_reg, D_Free_128_PtrReg, _SIZE_OF_FL128); break;
    default:
	    /* $B%Z!<%8%5%$%:0J>e(B */
              /* $B%G%#%9%/%j%W%?$NJ,$b4^$a$F%Z!<%8C10L$K@Z$j>e$2$k(B */
	    b_BitwiseAndImmediateWithDNTC(D_WorkStrgSize, _MASK_FOR_PAGE_SIZE,
					                       D_WorkStrgSize);
	    b_AddImmediateWithDNTC(D_WorkStrgSize, _SIZE_OF_HEAP_PAGE,
				                               D_WorkStrgSize);
	    b_ReclaimMultipleHeapPage(D_WorkStrgSize, src_reg);
            break;
  }
  $RELEASE(D_WorkAllocCount); $RELEASE(D_WorkStrgSize);
}

/******************************************************************** PSL **
  4.  $B%9%H%j%s%0MWAG$N%o!<%IC10L$N=q$-9~$_(B/$BFI$_$@$7(B

       written by f-hataza@icot21      on Wed Sep  6 16:41:10 1989

<Arguments>
  string_ptr :     $B%9%H%j%s%0$X$N%]%$%s%?(B($B%l%8%9%?(B)
  pos_reg :        $B%o!<%I0LCV(B ($B%9%H%j%s%0$NK\BN$K$D$$$F(B0$B%*%j%8%s(B)($B%l%8%9%?(B)
  dst_word_reg :   $BFI$_=P$7$?CM$r=q$-9~$`%l%8%9%?(B
  src_word_reg :   $B=q$-9~$`CM$r;}$D%l%8%9%?(B

<Temporally Used Variables>
<Level> structures
<PreCondition>
<Function>
  s_GetStringWordPosReg(string_ptr, pos_reg, dst_word_reg)
             $B%9%H%j%s%0$NMWAG%o!<%I$NFI$_$@$7(B($B%l%8%9%?$K$h$k0LCV;XDj(B)
  s_PutStringWordPosReg(string_ptr, pos_reg, src_word_reg)
             $B%9%H%j%s%0$NMWAG%o!<%I$N=q$-9~$_(B($B%l%8%9%?$K$h$k0LCV;XDj(B)

<Examples>
<Test>
<Explanation>
<ETC>
 $B!&(B $B%9%H%j%s%0$NMWAG$N%"%/%;%9J}K!$O!"<B5!$K$h$j3F<RKh$K8!F$$5$l$?$$!#(B
 $B!&(B $B%o!<%IKh$K$^$H$a$F%"%/%;%9$G$-$k$N$O!"=i4|2=!"%3%T!<$N;~$G$"$k!#(B
   ($BHf3S$N;~$b!":G=*%o!<%I0J30$NHf3S$O%o!<%IKh$GNI$$(B)

 $B!&(B pos_reg $B$N?t$(J}$rK\BN$K$D$$$F(B0$B%*%j%8%s$KJQ99$7$?!#(B(1990.10.23)
      pos_reg = -1           : DESC
      pos_reg = 0 $B!A(B size-1  : $B%9%H%j%s%0K\BN(B
********************************************************************* PSL **/
#DATA_define D_WorkCheckStrgSize  XXX

#PSL_define s_PutStringWordPosReg(string_ptr, pos_reg, src_word_reg)
{
  @DEBUG{
    s_IfNotStrings(string_ptr) {
      VPIM_ERROR ("s_PutStringWordPosReg", "Arg Not String");
    }
    $USE(D_WorkCheckStrgSize);
    s_GetStringSize(string_ptr, D_WorkCheckStrgSize);
    b_IfLessEq (D_WorkCheckStrgSize, pos_reg){
      VPIM_ERROR ("s_PutStringWordPosReg", "String Word Position Overflow");
    }
    $RELEASE(D_WorkCheckStrgSize);
  };

  $USE(D_WorkElemAddr);
  s_GetStructElemAddrPosReg(string_ptr, pos_reg, D_WorkElemAddr);
  b_IncrementAddrReg(D_WorkElemAddr);      /* $B%G%#%9%/%j%W%?$NJ,(B */
  p_Write(src_word_reg, D_WorkElemAddr);
  $RELEASE(D_WorkElemAddr);
}

#PSL_define s_GetStringWordPosReg(string_ptr, pos_reg, dst_word_reg)
{
  @DEBUG{
    s_IfNotStrings(string_ptr) {
      VPIM_ERROR ("s_GetStringWordPosReg", "Arg Not String");
    }
    $USE(D_WorkCheckStrgSize);
    s_GetStringSize(string_ptr, D_WorkCheckStrgSize);
    b_IfLessEq (D_WorkCheckStrgSize, pos_reg){
      VPIM_ERROR ("s_GetStringWordPosReg", "String Word Position Overflow");
    }
    $RELEASE(D_WorkCheckStrgSize);
  };

  $USE(D_WorkElemAddr);
  s_GetStructElemAddrPosReg(string_ptr, pos_reg, D_WorkElemAddr);
  b_IncrementAddrReg(D_WorkElemAddr);      /* $B%G%#%9%/%j%W%?$NJ,(B */
  s_ReadWithMRBor(D_WorkElemAddr, dst_word_reg);
  $RELEASE(D_WorkElemAddr);
}

/******************************************************************** PSL **
  5.  $B%9%H%j%s%0MWAG$N=q$-9~$_(B/$BFI$_$@$7(B

       written by f-hataza@icot21      on Wed Sep  6 16:41:10 1989

<Arguments>
  src_string_ptr : $B%9%H%j%s%0$X$N%]%$%s%?(B($B%l%8%9%?(B)
  pos_reg :        $BMWAGHV9f(B(0$B%*%j%8%s(B)($B%l%8%9%?(B)
  elem_size_reg :  $BMWAG%5%$%:(B($B%l%8%9%?(B)
  dst_elem_reg :   $BFI$_=P$7$?CM$r=q$-9~$`%l%8%9%?(B
  src_elem_reg :   $B=q$-9~$`CM$r;}$D%l%8%9%?(B

<Temporally Used Variables>
<Level> structures
<PreCondition>
<Function>
  s_GetStringElementPosReg(src_string_ptr,pos_reg,elem_size_reg,dst_elem_reg)
             $B%9%H%j%s%0MWAG$NFI$_$@$7(B($B%l%8%9%?$K$h$k0LCV;XDj(B)(*)
  s_PutStringElementPosReg(src_string_ptr,pos_reg,elem_size_reg,src_elem_reg)
             $B%9%H%j%s%0MWAG$N=q$-9~$_(B($B%l%8%9%?$K$h$k0LCV;XDj(B)
  (*) $BMWAG$rFI$`;~$K$O!"(BINT $B$N%?%0$r%l%8%9%?$K@_Dj$7$FJV$9!#(B
<Examples>
<Test>
<Explanation>
 $B!&(Bs_Get(Put)StringElementPosReg $B$N<B:]$N=hM}$O!"(Bs_Get(Put)StringElement$B$G(B
   $B9T$&$,!"0z?t$N%A%'%C%/$r$9$k$?$aD>@\8e<T$r8F$V$3$H$O$7$J$$$h$&$K$9$k!#(B
<ETC>
 $B!&%*%Z%i%s%I%U%#!<%k%I$K$h$k0LCV;XDj$O;H$o$J$$$h$&$J$N$G:o=|$9$k(B(1989.10.06)
     s_GetStringElementOprPos
     s_PutStringElementOprPos
 $B!&%9%H%j%s%0$NMWAG$N%"%/%;%9J}K!$O!"<B5!$K$h$j3F<RKh$K8!F$$5$l$?$$!#(B
   $B$3$3$K=q$$$?J}K!$O!"=hM}B.EY$,CY$$$b$N$H;W$o$l$k!#(B
********************************************************************* PSL **/
#DATA_define D_WorkCheckLength     XXX
#DATA_define D_WorkDmyElemSize     XXX

#PSL_define s_GetStringElementPosReg
            (src_string_ptr, pos_reg, elem_size_reg, dst_elem_reg)
{
  @DEBUG{
    s_IfStrings(src_string_ptr) {
      $USE(D_WorkCheckLength); $USE(D_WorkDmyElemSize);
      s_GetStringType(src_string_ptr, D_WorkCheckLength, D_WorkDmyElemSize);
      $RELEASE(D_WorkDmyElemSize);
      b_IfLessEq(D_WorkCheckLength, pos_reg){
        VPIM_ERROR ("s_GetStringElementPosReg", "StringElement Overflow");
      }
      $RELEASE(D_WorkCheckLength);
    }else{
      VPIM_ERROR ("s_GetStringElementPosReg", "Illegal Type");
    }
  };
  s_GetStringElement(src_string_ptr, pos_reg, elem_size_reg, dst_elem_reg);
}

#DATA_define D_WorkElemMask     XXX
#DATA_define D_WorkWordPos      XXX
#DATA_define D_WorkWordAddr     XXX
#DATA_define D_WorkElemShift    XXX

#PSL_define s_GetStringElement(src_reg, pos_reg, size_reg, dst_reg)
{
  $USE(D_WorkElemInWord); $USE(D_WorkElemMask);
  ValueSwitch(size_reg) {
    case  1:      p_SetImmediateValue(_NUM_OF_ELEM_STRG1,  D_WorkElemInWord);
                  p_SetImmediateValue(_MASK_ELEM_STRG1,  D_WorkElemMask);
                  break;
    case  8:      p_SetImmediateValue(_NUM_OF_ELEM_STRG8,  D_WorkElemInWord);
                  p_SetImmediateValue(_MASK_ELEM_STRG8,  D_WorkElemMask);
                  break;
    case 16:      p_SetImmediateValue(_NUM_OF_ELEM_STRG16, D_WorkElemInWord);
                  p_SetImmediateValue(_MASK_ELEM_STRG16, D_WorkElemMask);
                  break;
    case 32:      p_SetImmediateValue(_NUM_OF_ELEM_STRG32, D_WorkElemInWord);
                  p_SetImmediateValue(_MASK_ELEM_STRG32, D_WorkElemMask);
                  break;
    default:      @DEBUG{
                    VPIM_ERROR("s_GetStringElement", "Illegal Element Size");
		  };
  }

    /* $B0J2<$N=hM}$O!"%?%$%WKh$KJ,$1$?$[$&$,$-$l$$$K$J$k!#(B
           $B$7$+$7!"(BPIM/p (1word=64bits) $BEy$H$NBP1~$b4^$a!"MW8!F$(B */

    /* $BL\E*$NMWAG$r4^$`%o!<%I$NFI$_$@$7(B */
  $USE(D_WorkWordPos); $USE(D_WorkWordAddr);
  b_DivideWithDNTC(pos_reg, D_WorkElemInWord, D_WorkWordPos);
  b_IncrementReg(D_WorkWordPos);     /* $B%G%#%9%/%j%W%?$NJ,(B */
  s_GetStructElemAddrPosReg(src_reg, D_WorkWordPos, D_WorkWordAddr);
  p_Read(D_WorkWordAddr, dst_reg);
  $RELEASE(D_WorkWordPos); $RELEASE(D_WorkWordAddr);

    /* $BMWAGFI$_=P$7$N0Y$N%7%U%H(B */
  $USE(D_WorkElemShift);
  b_ModuloWithDNTC(pos_reg, D_WorkElemInWord, D_WorkElemShift);
  b_SubtractWithDNTC(D_WorkElemInWord, D_WorkElemShift, D_WorkElemShift);
  b_DecrementReg(D_WorkElemShift);
  b_MultiplyWithDNTC(D_WorkElemShift, size_reg, D_WorkElemShift);
  b_ShiftRightWithDNTC(dst_reg, D_WorkElemShift, dst_reg);
  $RELEASE(D_WorkElemShift);

    /* $B%^%9%/(B */
  b_BitwiseAndWithDNTC(dst_reg, D_WorkElemMask, dst_reg);
  b_SetImmTypeMRBoff(INT, dst_reg);
  $RELEASE(D_WorkElemInWord); $RELEASE(D_WorkElemMask);
}

#PSL_define s_PutStringElementPosReg
            (src_string_ptr, pos_reg, elem_size_reg, src_elem_reg)
{
  @DEBUG{
    s_IfStrings(src_string_ptr) {
      $USE(D_WorkCheckLength); $USE(D_WorkDmyElemSize);
      s_GetStringType(src_string_ptr, D_WorkCheckLength, D_WorkDmyElemSize);
      $RELEASE(D_WorkDmyElemSize);
      b_IfLessEq(D_WorkCheckLength, pos_reg){
        VPIM_ERROR ("s_PutStringElementPosReg", "StringElement Overflow");
      }
      $RELEASE(D_WorkCheckLength);
    }else{
      VPIM_ERROR ("s_PutStringElementPosReg", "Illegal Type");
    }
  };
  s_PutStringElement(src_string_ptr, pos_reg, elem_size_reg, src_elem_reg);
}

#DATA_define D_WorkStringWord   XXX
#DATA_define D_WorkStringElem   XXX

#PSL_define s_PutStringElement(src_reg, pos_reg, size_reg, elem_reg)
{
  $USE(D_WorkElemInWord); $USE(D_WorkElemMask);
  ValueSwitch(size_reg) {
    case  1:      p_SetImmediateValue(_NUM_OF_ELEM_STRG1,  D_WorkElemInWord);
                  p_SetImmediateValue(_MASK_ELEM_STRG1,  D_WorkElemMask);
                  break;
    case  8:      p_SetImmediateValue(_NUM_OF_ELEM_STRG8,  D_WorkElemInWord);
                  p_SetImmediateValue(_MASK_ELEM_STRG8,  D_WorkElemMask);
                  break;
    case 16:      p_SetImmediateValue(_NUM_OF_ELEM_STRG16, D_WorkElemInWord);
                  p_SetImmediateValue(_MASK_ELEM_STRG16, D_WorkElemMask);
                  break;
    case 32:      p_SetImmediateValue(_NUM_OF_ELEM_STRG32, D_WorkElemInWord);
                  p_SetImmediateValue(_MASK_ELEM_STRG32, D_WorkElemMask);
                  break;
    default:      @DEBUG{
                    VPIM_ERROR("s_PutStringElement", "Illegal Element Size");
		  };
  }

    /* $B0J2<$N=hM}$O!"%?%$%WKh$KJ,$1$?$[$&$,$-$l$$$K$J$k!#(B
           $B$7$+$7!"(BPIM/p (1word=64bits) $BEy$H$NBP1~$b4^$a!"MW8!F$(B */

    /* $BL\E*$NMWAG$r4^$`%o!<%I$NFI$_$@$7(B */
  $USE(D_WorkWordAddr); $USE(D_WorkStringWord);
  $USE(D_WorkWordPos);
  b_DivideWithDNTC(pos_reg, D_WorkElemInWord, D_WorkWordPos);
  b_IncrementReg(D_WorkWordPos);     /* $B%G%#%9%/%j%W%?$NJ,(B */
  s_GetStructElemAddrPosReg(src_reg, D_WorkWordPos, D_WorkWordAddr);
  p_Read(D_WorkWordAddr, D_WorkStringWord);
  $RELEASE(D_WorkWordPos);

    /* $B=q$-9~$`MWAG$N%7%U%H(B */
  $USE(D_WorkStringElem);
  $USE(D_WorkElemShift);
  b_ModuloWithDNTC(pos_reg, D_WorkElemInWord, D_WorkElemShift);
  b_SubtractWithDNTC(D_WorkElemInWord, D_WorkElemShift, D_WorkElemShift);
  b_DecrementReg(D_WorkElemShift);
  b_MultiplyWithDNTC(D_WorkElemShift, size_reg, D_WorkElemShift);
  b_ShiftLeftWithDNTC(elem_reg, D_WorkElemShift, D_WorkStringElem);
  b_ShiftLeftWithDNTC(D_WorkElemMask, D_WorkElemShift, D_WorkElemMask);
  b_BitwiseAndWithDNTC(D_WorkStringElem, D_WorkElemMask, D_WorkStringElem);
       /* $B=q$-9~$`CM$,MWAG$N%S%C%HI}$r1[$($F$J$1$l$P!"$3$N%^%9%/A`:n$OITMW(B */ 
  $RELEASE(D_WorkElemShift);

    /* $BMWAG$N=q$-9~$_(B */
  b_BitwiseComplementWithDNTC(D_WorkElemMask, D_WorkElemMask);
  b_BitwiseAndWithDNTC(D_WorkStringWord, D_WorkElemMask, D_WorkStringWord);
  b_BitwiseOrWithDNTC(D_WorkStringWord, D_WorkStringElem, D_WorkStringWord);
  b_WriteImmTagWithOffset(_MRB_OFF,DNTC,D_WorkStringWord,D_WorkWordAddr,_ZERO);
       /* $BMWAG$rFI$`;~$K$O!"%?%0$r8+$F$$$J$$$N$G<B:]$K$OCM$@$1=q$-9~$a$PNI$$(B */
  $RELEASE(D_WorkStringElem);
  $RELEASE(D_WorkWordAddr); $RELEASE(D_WorkStringWord);
  $RELEASE(D_WorkElemInWord); $RELEASE(D_WorkElemMask);
}

/******************************************************************** PSL **
  6.  $B%9%H%j%s%0MWAG$N%o!<%IC10L$N%3%T!<(B

       written by f-hataza@icot22      on Fri May 18 21:30:44 1990
<Arguments>
    A_Src : $B%3%T!<85$N%9%H%j%s%0$X$N%]%$%s%?$r;}$D%l%8%9%?(B
    A_Dst : $B%3%T!<@h$N%9%H%j%s%0$X$N%]%$%s%?$r;}$D%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
    $B%3%T!<@h$N%9%H%j%s%0$O!"$9$G$K3d$jIU$1$i$l$F$$$k$b$N$H$9$k!#(B
<Function>
    $B%o!<%IC10L$G%9%H%j%s%0$NMWAG$N%3%T!<$r9T$J$&!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define	A_Src		SRC
#SUBARG_define	A_Dst		SRC

#SUBROUTINE s_CopyWordString_Sub(A_Src, A_Dst)
{
  @DEBUG {
    s_IfNotStrings(A_Src) {VPIM_ERROR("s_CopyWordString_Sub","Illegal Type"); }
  };
  $USE(D_WorkStrgSize);
  s_GetStringSize(A_Src, D_WorkStrgSize);
  $USE(D_WorkElemOfst);
  b_ExchangeElmposToOffset(D_WorkStrgSize, D_WorkElemOfst);
  $RELEASE(D_WorkStrgSize);
  LOOP() {                           /* for(i=size; i>0; i--) */
    b_IfLessEq(D_WorkElemOfst, D_NULL) { break;}
    s_CopyStructElementWithRegOffset(A_Src, D_WorkElemOfst, A_Dst);
    b_DecrementAddrReg(D_WorkElemOfst);
  }	  
  $RELEASE(D_WorkElemOfst);
  $RETURN();
}

/******************************************************************** PSL **
  7.  $B%9%H%j%s%0MWAG$N%o!<%IC10L%5!<%A(B
       written by kawai@icot22      on Wed Jul 17 14:31:41 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
 $B!&(B1$B%9%H%j%s%0%o!<%ICf$G8!:wBP>]J8;z$rC5$9!#(B
     s_SearchCharForwardInWord : $B%9%H%j%s%0MWAG0LCV$N>.$5$$J}$+$iC5$9(B
     s_SearchCharBackwardInWord : $B%9%H%j%s%0MWAG0LCV$NBg$-$$J}$+$iC5$9(B
 $B!&(B1$B%9%H%j%s%0%o!<%ICf$G8!:w%F!<%V%k$rMQ$$$FBP>]J8;z$rC5$9!#(B
     s_SearchCharForwardInWordWithTable : $B%9%H%j%s%0MWAG0LCV$N>.$5$$J}$+$iC5$9(B
     s_SearchCharBackwardInWordWithTable : $B%9%H%j%s%0MWAG0LCV$NBg$-$$J}$+$iC5$9(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

/******************************************************************** PSL **
  7.1  $B%9%H%j%s%0MWAG$N%o!<%IC10L%5!<%A(B($B=gJ}8~(B)
  s_SearchCharForwardInWord(target_str_word, target_char,
			    elm_size, elms_cnt_in_word,
			    skip_elms_cnt, elms_cnt_to_search, 
			    mask_pattern, found_position)

       written by kawai@icot22      on Wed Sep 11 22:23:32 1991
<Arguments>
  target_str_word : $B%9%H%j%s%0%o!<%I(B
  target_char : $B8!:wBP>]J8;z%3!<%I(B
  elm_size : $B%9%H%j%s%0MWAG%5%$%:(B
  elms_cnt_in_word : 1$B%9%H%j%s%0%o!<%ICf$NMWAG?t(B
  skip_elms_cnt : 1$B%9%H%j%s%0%o!<%ICf$G8!:wBP>]$K$J$i$J$$MWAG?t(B
                  ($B@hF,%o!<%I0J30$G$O(B elms_cnt_in_word $B$KEy$7$$(B)
  elms_cnt_to_search : 1$B%9%H%j%s%0%o!<%ICf$G8!:wBP>]$K$J$kMWAG?t(B
                       ($B:G=*%o!<%I0J30$G$O(B elms_cnt_in_word $B$KEy$7$$(B)
  mask_pattern : $BMWAG<h$j$@$7MQ$N%^%9%/%Q%?%s(B
  found_position : 1$B%9%H%j%s%0%o!<%ICf$NH/8+MWAG0LCV(B
<Temporally Used Variables>
  D_WorkStrMatchingElm : $B%9%H%j%s%0MWAG(B
  D_WorkStrShiftCount : $B%7%U%H%+%&%s%H(B
<Level>
<PreCondition>
<Function>
  1$B%9%H%j%s%0%o!<%ICf$r=gJ}8~(B($B:8$+$i1&(B)$B$KMWAG$r8!:w$9$k!#(B
<Examples>
<Test>
<Explanation>
  $BCm0U(B:
    $B%7%U%H2s?t$r8:$i$9$?$a!"%^%9%/%Q%?%s$r%7%U%H$;$:$K%9%H%j%s%0%o!<%I$r1&%7%U(B
  $B%H$9$k!#$3$N$?$a!"<B:]$N=hM}$H$7$F$O%9%H%j%s%0%o!<%ICf$r1&$+$i:8J}8~(B($B5UJ}8~(B)
  $B$K%5!<%A$9$k$3$H$K$J$k$,!"I,$::8C<$NMWAG$^$GD4$Y$F$+$iH/8+MWAG0LCV$r7h$a$k(B
  $B$3$H$K$h$C$F=gJ}8~%5!<%A$rJ]>Z$7$F$$$k!#(B
<ETC>
********************************************************************* PSL **/

#CONST_define  _CHARACTER_NOT_FOUND  -1

#DATA_define  D_WorkStrShiftCount  XXX
#DATA_define  D_WorkStrMatchingElm  XXX

#PSL_define  s_SearchCharForwardInWord(target_str_word, target_char,
				       elm_size, elms_cnt_in_word,
				       skip_elms_cnt, elms_cnt_to_search, 
				       mask_pattern, found_position)
{
  $USE(D_WorkStrShiftCount);

  /* target_str_word$BCf$NC5:wHO0O$r1&$K%7%U%H$7$F!":G>.%S%C%H0LCV(B($B1&C<(B)$B$K(B
     $B9g$o$;$k(B */
  b_SubtractWithDNTC(elms_cnt_in_word, elms_cnt_to_search,
		                                      D_WorkStrShiftCount);
  b_MultiplyWithDNTC(D_WorkStrShiftCount, elm_size, D_WorkStrShiftCount);
  b_ShiftRightWithDNTC(target_str_word, D_WorkStrShiftCount, target_str_word);

  $USE(D_WorkStrMatchingElm);
  LOOP()
    {
      b_BitwiseAndWithDNTC(target_str_word, mask_pattern,
			                              D_WorkStrMatchingElm);
      b_IfEqual(D_WorkStrMatchingElm, target_char)
	{ /* $B8+$D$1$?$i$=$N>l=j$r3P$($F$*$/(B */
	  p_MoveValue(elms_cnt_to_search, found_position);
	}

      b_DecrementReg(elms_cnt_to_search);

      b_IfLessEq(elms_cnt_to_search, skip_elms_cnt)
	{ /* target_str_word$BCf$N%9%-%C%W0LCV$^$GC5$7$F8+$D$+$i$J$1$l$PH4$1$k(B */
	  break;
	}
      /* target_str_word$BCf$NC5:wHO0O$r(B 1$B%(%l%a%s%HJ,(B $B1&$K%7%U%H$9$k(B */
      b_ShiftRightWithDNTC(target_str_word, elm_size, target_str_word);
    }

  b_IfNotEqualImm(found_position, _CHARACTER_NOT_FOUND)
    { /* $B8+$D$+$C$F$$$?$i!"(BPosition$B$r@5$7$/7W;;$9$k(B */
      b_DecrementReg(found_position);
    }
      /* $B8+$D$+$C$F$$$J$+$C$?$i!"(Bfound_position = -1 $B$N$^$^$N$O$:(B */

  $RELEASE(D_WorkStrMatchingElm);
  $RELEASE(D_WorkStrShiftCount);
}

/******************************************************************** PSL **
  7.2  $B%9%H%j%s%0MWAG$N%o!<%IC10L%5!<%A(B($B5UJ}8~(B)
  s_SearchCharBackwardInWord(target_str_word, target_char,
			     elm_size, elms_cnt_in_word,
			     skip_elms_cnt, valid_elms_cnt,
			     mask_pattern, found_position)

       written by kawai@icot22      on Wed Sep 11 22:23:32 1991
<Arguments>
  target_str_word : $B%9%H%j%s%0%o!<%I(B
  target_char : $B8!:wBP>]J8;z%3!<%I(B
  elm_size : $B%9%H%j%s%0MWAG%5%$%:(B
  elms_cnt_in_word : 1$B%9%H%j%s%0%o!<%ICf$NMWAG?t(B
  skip_elms_cnt : 1$B%9%H%j%s%0%o!<%ICf$G8!:wBP>]$K$J$i$J$$MWAG?t(B
                  ($B@hF,%o!<%I0J30$G$O(B elms_cnt_in_word $B$KEy$7$$(B)
  valid_elms_cnt : 1$B%9%H%j%s%0%o!<%ICf$G8!:wBP>]$K$J$kMWAG?t(B
                  ($B:G=*%o!<%I0J30$G$O(B elms_cnt_in_word $B$KEy$7$$(B)
  mask_pattern : $BMWAG<h$j$@$7MQ$N%^%9%/%Q%?%s(B
  found_position : 1$B%9%H%j%s%0%o!<%ICf$NH/8+MWAG0LCV(B
<Temporally Used Variables>
  D_WorkStrMatchingElm : $B%9%H%j%s%0MWAG(B
  D_WorkStrShiftCount : $B%7%U%H%+%&%s%H(B
  D_WorkStrShiftElmCount : $B%7%U%H$9$kMWAG?t(B
  D_WorkStrSearchLoopCount : $B%k!<%W%+%&%s%?(B
<Level>
<PreCondition>
<Function>
  1$B%9%H%j%s%0%o!<%ICf$r5UJ}8~(B($B1&$+$i:8(B)$B$KMWAG$r8!:w$9$k!#(B
<Examples>
<Test>
<Explanation>
  $BCm0U(B:
    $B%7%U%H2s?t$r8:$i$9$?$a!"%^%9%/%Q%?%s$r%7%U%H$;$:$K%9%H%j%s%0%o!<%I$r1&%7%U(B
  $B%H$9$k!#(B
<ETC>
********************************************************************* PSL **/

#DATA_define  D_WorkStrShiftElmCount  XXX
#DATA_define  D_WorkStrSearchLoopCount  XXX

#PSL_define  s_SearchCharBackwardInWord(target_str_word, target_char,
				       elm_size, elms_cnt_in_word,
				       skip_elms_cnt, valid_elms_cnt, 
				       mask_pattern, found_position)
{
  $USE(D_WorkStrShiftCount);
  $USE(D_WorkStrShiftElmCount);

  /* target_str_word$BCf$NC5:wHO0O$r1&$K%7%U%H$7$F!":G>.%S%C%H0LCV(B($B1&C<(B)$B$K(B
     $B9g$o$;$k(B */
  b_SubtractWithDNTC(elms_cnt_in_word, valid_elms_cnt, D_WorkStrShiftElmCount);
  b_MultiplyWithDNTC(D_WorkStrShiftElmCount, elm_size, D_WorkStrShiftCount);
  b_ShiftRightWithDNTC(target_str_word, D_WorkStrShiftCount, target_str_word);

  /* $B%7%U%H$7$?J,$O!"%k!<%W$r2s$C$?$b$N$H$9$k(B */
  $USE(D_WorkStrSearchLoopCount);
  p_MoveValue(D_WorkStrShiftElmCount, D_WorkStrSearchLoopCount);

  $USE(D_WorkStrMatchingElm);
  LOOP()
    {
      b_BitwiseAndWithDNTC(target_str_word, mask_pattern,
			                               D_WorkStrMatchingElm);
      b_IfEqual(D_WorkStrMatchingElm, target_char)
	{ /* target_char $B$,8+$D$+$C$?$i(B */
	  b_SubtractWithDNTC(elms_cnt_in_word, D_WorkStrSearchLoopCount,
		                                             found_position);
	  b_DecrementReg(found_position);
	  break;
	}

      b_IncrementReg(D_WorkStrSearchLoopCount);

      b_AddWithDNTC(D_WorkStrSearchLoopCount, skip_elms_cnt,
		                                   D_WorkStrSearchLoopCount);
      b_IfGreaterEq(D_WorkStrSearchLoopCount, elms_cnt_in_word)
	{ /* $BC5:wMWAG?tJ,2s$C$F!"8+$D$+$i$J$1$l$PH4$1$k(B */
	  break;
	}
      else
	{
	  b_SubtractWithDNTC(D_WorkStrSearchLoopCount, skip_elms_cnt,
		                               D_WorkStrSearchLoopCount);
	}

      /* target_str_word$BCf$NC5:wHO0O$r(B 1$B%(%l%a%s%HJ,(B $B1&$K%7%U%H$9$k(B */
      b_ShiftRightWithDNTC(target_str_word, elm_size, target_str_word);
    }
  $RELEASE(D_WorkStrMatchingElm);
  $RELEASE(D_WorkStrShiftCount);
  $RELEASE(D_WorkStrShiftElmCount);
  $RELEASE(D_WorkStrSearchLoopCount);
}

/******************************************************************** PSL **
  7.3  $B%F!<%V%k$rMQ$$$?%9%H%j%s%0MWAG$N%o!<%IC10L%5!<%A(B($B=gJ}8~(B)
  s_SearchCharForwardInWordWithTable(target_str_word,
				     target_char_table, table_mask,
				     elm_size, elms_cnt_in_word,
				     skip_elms_cnt,
				     elms_cnt_to_search, 
				     mask_pattern, found_position)

       written by kawai@icot22      on Wed Sep 11 22:23:32 1991
<Arguments>
  target_str_word : $B%9%H%j%s%0%o!<%I(B
  target_char_table : $B8!:wMQ%F!<%V%k(B(8$B%S%C%H%9%H%j%s%0(B)
  table_mask : $B%F!<%V%kMQ%^%9%/(B
  elm_size : $B%9%H%j%s%0MWAG%5%$%:(B
  elms_cnt_in_word : 1$B%9%H%j%s%0%o!<%ICf$NMWAG?t(B
  skip_elms_cnt : 1$B%9%H%j%s%0%o!<%ICf$G8!:wBP>]$K$J$i$J$$MWAG?t(B
                  ($B@hF,%o!<%I0J30$G$O(B elms_cnt_in_word $B$KEy$7$$(B)
  elms_cnt_to_search : 1$B%9%H%j%s%0%o!<%ICf$G8!:wBP>]$K$J$kMWAG?t(B
                       ($B:G=*%o!<%I0J30$G$O(B elms_cnt_in_word $B$KEy$7$$(B)
  mask_pattern : $BMWAG<h$j$@$7MQ$N%^%9%/%Q%?%s(B
  found_position : 1$B%9%H%j%s%0%o!<%ICf$NH/8+MWAG0LCV(B
<Temporally Used Variables>
  D_WorkStrMatchingElm : $B%9%H%j%s%0MWAG(B
  D_WorkStrShiftCount : $B%7%U%H%+%&%s%H(B
  D_WorkSearchCharTableElmSize : $B8!:wMQ%F!<%V%k$NMWAG%5%$%:(B
<Level>
<PreCondition>
<Function>
  1$B%9%H%j%s%0%o!<%ICf$r=gJ}8~(B($B:8$+$i1&(B)$B$KMWAG$r8!:w$9$k!#(B
  $B8!:w$O!"(B
    (1) $B%9%H%j%s%0%o!<%I$+$i(B1$BMWAG$r<h$j=P$9!#(B
    (2) $B$=$NMWAG$NCM$r8!:w%F!<%V%k$NMWAG0LCV$H$7$F8!:w%F!<%V%k$+$iBP1~$9$k(B
        $BMWAG$r<h$j=P$9!#(B
    (3) $B8!:w%F!<%V%k$+$i<h$j=P$7$?MWAG$NCM$H%F!<%V%kMQ%^%9%/$NCM$N(BAND$B$r<h$j!"(B
        $B$=$N7k2L$,(B 0 $B$G$J$$$b$N$r!VEv$?$j!W$H$9$k!#(B
   $B$H$$$&<j=g$G9T$&!#(B
<Examples>
<Test>
<Explanation>
  $BCm0U(B:
    $B%7%U%H2s?t$r8:$i$9$?$a!"%^%9%/%Q%?%s$r%7%U%H$;$:$K%9%H%j%s%0%o!<%I$r1&%7%U(B
  $B%H$9$k!#$3$N$?$a!"<B:]$N=hM}$H$7$F$O%9%H%j%s%0%o!<%ICf$r1&$+$i:8J}8~(B($B5UJ}8~(B)
  $B$K%5!<%A$9$k$3$H$K$J$k$,!"I,$::8C<$NMWAG$^$GD4$Y$F$+$iH/8+MWAG0LCV$r7h$a$k(B
  $B$3$H$K$h$C$F=gJ}8~%5!<%A$rJ]>Z$7$F$$$k!#(B
<ETC>
********************************************************************* PSL **/

#CONST_define  _SEARCH_CHAR_TBL_ELM_SIZE  8

#DATA_define  D_WorkSearchCharTableElmSize  XXX

#PSL_define  s_SearchCharForwardInWordWithTable(target_str_word,
						target_char_table, table_mask,
						elm_size, elms_cnt_in_word,
						skip_elms_cnt,
						elms_cnt_to_search, 
						mask_pattern, found_position)
{
  $USE(D_WorkStrShiftCount);

  /* target_str_word$BCf$NC5:wHO0O$r1&$K%7%U%H$7$F!":G>.%S%C%H0LCV(B($B1&C<(B)$B$K(B
     $B9g$o$;$k(B */
  b_SubtractWithDNTC(elms_cnt_in_word, elms_cnt_to_search,
		                                        D_WorkStrShiftCount);
  b_MultiplyWithDNTC(D_WorkStrShiftCount, elm_size, D_WorkStrShiftCount);
  b_ShiftRightWithDNTC(target_str_word, D_WorkStrShiftCount, target_str_word);

  $USE(D_WorkStrMatchingElm);
  $USE(D_WorkSearchCharTableElmSize);
  p_SetImmediateValue(_SEARCH_CHAR_TBL_ELM_SIZE, D_WorkSearchCharTableElmSize);
  LOOP()
    {
      b_BitwiseAndWithDNTC(target_str_word, mask_pattern,
			                               D_WorkStrMatchingElm);

      s_IfTargetTableElement(target_char_table, D_WorkStrMatchingElm,
			           D_WorkSearchCharTableElmSize, table_mask)
	{ /* $B8+$D$1$?$i$=$N>l=j$r3P$($F$*$/(B */
	  p_MoveValue(elms_cnt_to_search, found_position);
	}

      b_DecrementReg(elms_cnt_to_search);

      b_IfLessEq(elms_cnt_to_search, skip_elms_cnt)
	{ /* target_str_word$BCf$N%9%-%C%W0LCV$^$GC5$7$F8+$D$+$i$J$1$l$PH4$1$k(B */
	  break;
	}
      /* target_str_word$BCf$NC5:wHO0O$r(B 1$B%(%l%a%s%HJ,(B $B1&$K%7%U%H$9$k(B */
      b_ShiftRightWithDNTC(target_str_word, elm_size, target_str_word);
    }

  b_IfNotEqualImm(found_position, _CHARACTER_NOT_FOUND)
    { /* $B8+$D$+$C$F$$$?$i!"(BPosition$B$r@5$7$/7W;;$9$k(B */
      b_DecrementReg(found_position);
    }
      /* $B8+$D$+$C$F$$$J$+$C$?$i!"(Bfound_position = -1 $B$N$^$^$N$O$:(B */

  $RELEASE(D_WorkStrMatchingElm);
  $RELEASE(D_WorkStrShiftCount);
  $RELEASE(D_WorkSearchCharTableElmSize);
}

/******************************************************************** PSL **
  7.4  $B%F!<%V%k$rMQ$$$?%9%H%j%s%0MWAG$N%o!<%IC10L%5!<%A(B($B5UJ}8~(B)
  s_SearchCharBackwardInWordWithTable(target_str_word,
				      target_char_table, table_mask,
				      elm_size, elms_cnt_in_word,
				      skip_elms_cnt,
				      valid_elms_cnt, 
				      mask_pattern, found_position)

       written by kawai@icot22      on Wed Sep 11 22:23:32 1991
<Arguments>
  target_str_word : $B%9%H%j%s%0%o!<%I(B
  target_char_table : $B8!:wMQ%F!<%V%k(B(8$B%S%C%H%9%H%j%s%0(B)
  table_mask : $B%F!<%V%kMQ%^%9%/(B
  elm_size : $B%9%H%j%s%0MWAG%5%$%:(B
  elms_cnt_in_word : 1$B%9%H%j%s%0%o!<%ICf$NMWAG?t(B
  skip_elms_cnt : 1$B%9%H%j%s%0%o!<%ICf$G8!:wBP>]$K$J$i$J$$MWAG?t(B
                  ($B@hF,%o!<%I0J30$G$O(B elms_cnt_in_word $B$KEy$7$$(B)
  valid_elms_cnt : 1$B%9%H%j%s%0%o!<%ICf$G8!:wBP>]$K$J$kMWAG?t(B
                   ($B:G=*%o!<%I0J30$G$O(B elms_cnt_in_word $B$KEy$7$$(B)
  mask_pattern : $BMWAG<h$j$@$7MQ$N%^%9%/%Q%?%s(B
  found_position : 1$B%9%H%j%s%0%o!<%ICf$NH/8+MWAG0LCV(B
<Temporally Used Variables>
  D_WorkStrMatchingElm : $B%9%H%j%s%0MWAG(B
  D_WorkStrShiftCount : $B%7%U%H%+%&%s%H(B
  D_WorkSearchCharTableElmSize : $B8!:wMQ%F!<%V%k$NMWAG%5%$%:(B
  D_WorkStrShiftElmCount : $B%7%U%H$9$kMWAG?t(B
  D_WorkStrSearchLoopCount : $B%k!<%W%+%&%s%?(B
<Level>
<PreCondition>
<Function>
  1$B%9%H%j%s%0%o!<%ICf$r5UJ}8~(B($B1&$+$i:8(B)$B$KMWAG$r8!:w$9$k!#(B
  $B8!:w$O!"(B
    (1) $B%9%H%j%s%0%o!<%I$+$i(B1$BMWAG$r<h$j=P$9!#(B
    (2) $B$=$NMWAG$NCM$r8!:w%F!<%V%k$NMWAG0LCV$H$7$F8!:w%F!<%V%k$+$iBP1~$9$k(B
        $BMWAG$r<h$j=P$9!#(B
    (3) $B8!:w%F!<%V%k$+$i<h$j=P$7$?MWAG$NCM$H%F!<%V%kMQ%^%9%/$NCM$N(BAND$B$r<h$j!"(B
        $B$=$N7k2L$,(B 0 $B$G$J$$$b$N$r!VEv$?$j!W$H$9$k!#(B
   $B$H$$$&<j=g$G9T$&!#(B
<Examples>
<Test>
<Explanation>
  $BCm0U(B:
    $B%7%U%H2s?t$r8:$i$9$?$a!"%^%9%/%Q%?%s$r%7%U%H$;$:$K%9%H%j%s%0%o!<%I$r1&%7%U(B
  $B%H$9$k!#(B
<ETC>
********************************************************************* PSL **/

#PSL_define  s_SearchCharBackwardInWordWithTable(target_str_word,
						 target_char_table, table_mask,
						 elm_size, elms_cnt_in_word,
						 skip_elms_cnt,
						 valid_elms_cnt, 
						 mask_pattern, found_position)
{
  $USE(D_WorkStrShiftCount);
  $USE(D_WorkStrShiftElmCount);

  /* target_str_word$BCf$NC5:wHO0O$r1&$K%7%U%H$7$F!":G>.%S%C%H0LCV(B($B1&C<(B)$B$K(B
     $B9g$o$;$k(B */
  b_SubtractWithDNTC(elms_cnt_in_word, valid_elms_cnt, D_WorkStrShiftElmCount);
  b_MultiplyWithDNTC(D_WorkStrShiftElmCount, elm_size, D_WorkStrShiftCount);
  b_ShiftRightWithDNTC(target_str_word, D_WorkStrShiftCount, target_str_word);

  /* $B%7%U%H$7$?J,$O!"%k!<%W$r2s$C$?$b$N$H$9$k(B */
  $USE(D_WorkStrSearchLoopCount);
  p_MoveValue(D_WorkStrShiftElmCount, D_WorkStrSearchLoopCount);

  $USE(D_WorkStrMatchingElm);
  $USE(D_WorkSearchCharTableElmSize);
  p_SetImmediateValue(_SEARCH_CHAR_TBL_ELM_SIZE, D_WorkSearchCharTableElmSize);
  LOOP()
    {
      b_BitwiseAndWithDNTC(target_str_word, mask_pattern,
			                               D_WorkStrMatchingElm);

      s_IfTargetTableElement(target_char_table, D_WorkStrMatchingElm,
			           D_WorkSearchCharTableElmSize, table_mask)
	{ /* target_char $B$,8+$D$+$C$?$i(B */
	  b_SubtractWithDNTC(elms_cnt_in_word, D_WorkStrSearchLoopCount,
		                                             found_position);
	  b_DecrementReg(found_position);
	  break;
	}

      b_IncrementReg(D_WorkStrSearchLoopCount);

      b_AddWithDNTC(D_WorkStrSearchLoopCount, skip_elms_cnt,
		                                   D_WorkStrSearchLoopCount);
      b_IfGreaterEq(D_WorkStrSearchLoopCount, elms_cnt_in_word)
	{ /* $BC5:wMWAG?tJ,2s$C$F!"8+$D$+$i$J$1$l$PH4$1$k(B */
	  break;
	}
      else
	{
	  b_SubtractWithDNTC(D_WorkStrSearchLoopCount, skip_elms_cnt,
		                               D_WorkStrSearchLoopCount);
	}

      /* target_str_word$BCf$NC5:wHO0O$r(B 1$B%(%l%a%s%HJ,(B $B1&$K%7%U%H$9$k(B */
      b_ShiftRightWithDNTC(target_str_word, elm_size, target_str_word);
    }
  $RELEASE(D_WorkStrMatchingElm);
  $RELEASE(D_WorkStrShiftCount);
  $RELEASE(D_WorkStrShiftElmCount);
  $RELEASE(D_WorkStrSearchLoopCount);
  $RELEASE(D_WorkSearchCharTableElmSize);
}

/******************************************************************** PSL **
  7.5  $B%9%H%j%s%0MWAG$N%o!<%IC10L%5!<%A$N$?$a$NItIJ%^%/%m(B
       written by kawai@icot22      on Wed Jul 17 14:33:37 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  s_GetElmCountInWordAndMask(elm_size, elms_cnt_in_word, elm_mask)
					
{
  ValueSwitch(elm_size) {
    case  1:      p_SetImmediateValue(_NUM_OF_ELEM_STRG1,  elms_cnt_in_word);
                  p_SetImmediateValue(_MASK_ELEM_STRG1,  elm_mask);
                  break;
    case  8:      p_SetImmediateValue(_NUM_OF_ELEM_STRG8,  elms_cnt_in_word);
                  p_SetImmediateValue(_MASK_ELEM_STRG8,  elm_mask);
                  break;
    case 16:      p_SetImmediateValue(_NUM_OF_ELEM_STRG16, elms_cnt_in_word);
                  p_SetImmediateValue(_MASK_ELEM_STRG16, elm_mask);
                  break;
    case 32:      p_SetImmediateValue(_NUM_OF_ELEM_STRG32, elms_cnt_in_word);
                  p_SetImmediateValue(_MASK_ELEM_STRG32, elm_mask);
                  break;
    default:      @DEBUG{
                    VPIM_ERROR("s_GetElmCountInWordAndMask",
			       "Illegal Element Size");
		  };
    }
}



#PSL_define  s_DecideSearchRegion(start_pos, end_pos, elms_in_word,
				  start_word_pos, skip_elms_in_start,
				  end_word_pos, elms_in_end_word)
{
  b_DivideWithDNTC(start_pos, elms_in_word, start_word_pos);
  b_DivideWithDNTC(end_pos, elms_in_word, end_word_pos);
  b_ModuloWithDNTC(start_pos, elms_in_word, skip_elms_in_start);
  b_ModuloWithDNTC(end_pos, elms_in_word, elms_in_end_word);
  b_IncrementReg(elms_in_end_word);
}



#DATA_define  D_WorkTargetTableElement  XXX

#CTRL_define  s_IfTargetTableElement(table, table_pos, elm_size, mask)
{
  $USE(D_WorkTargetTableElement);
  s_GetStringElement(table, table_pos, elm_size, D_WorkTargetTableElement);
  b_BitwiseAndWithDNTC(D_WorkTargetTableElement, mask,
		                                 D_WorkTargetTableElement);
  p_Compare(D_WorkTargetTableElement, D_NULL);
  $RELEASE(D_WorkTargetTableElement);
  p_IfNE()
}

/******************************************************************** PSL **
  8. $B%9%H%j%s%0%*%Z%l!<%7%g%s(B
       written by kawai@icot22      on Wed Jul 17 14:35:51 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B0z?t$GEO$5$l$?%9%H%j%s%0$N;XDj$5$l$?HO0OFb$NMWAGF1;N$G%S%C%H%o%$%:$N1i;;$r(B
$B9T$$!"$=$N1i;;7k2L$G85$N%9%H%j%s%0MWAG$rCV$-49$($k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

/******************************************************************** PSL **
  8.1 $B%9%H%j%s%0%*%Z%l!<%7%g%s(B($B=gJ}8~(B)
  s_GeneralStringOpeForward(string1, word_pos1, elm_position1,
			    string2, word_pos2, elm_position2,
			    operation, mask_pattern,
			    target_length, elm_size,
			    elms_cnt_in_word)

       written by kawai@icot22      on Thu Sep 12 12:26:24 1991
<Arguments>
  string1 : $B%9%H%j%s%0(B1($BCV$-49$((B)
  word_pos1 : $B%9%H%j%s%0(B1$B$N1i;;BP>]MWAG$NF~$C$F$$$k%9%H%j%s%0%o!<%I0LCV(B
  elm_position1 : $B%9%H%j%s%0(B1$B$N1i;;BP>]MWAG$N0LCV(B
  string2 : $B%9%H%j%s%0(B2($BFI$_9~$_(B)
  word_pos2 : $B%9%H%j%s%0(B2$B$N1i;;BP>]MWAG$NF~$C$F$$$k%9%H%j%s%0%o!<%I0LCV(B
  elm_position2 : $B%9%H%j%s%0(B2$B$N1i;;BP>]MWAG$N0LCV(B
  operation : $B1i;;<oJL(B(0$B!A(B15)
  mask_pattern : $BMWAG<h$j=P$7MQ%^%9%/%Q%?%s(B
  target_length : $B1i;;BP>]MWAG?t(B
  elm_size : $BMWAG%5%$%:(B
  elms_cnt_in_word : 1$B%9%H%j%s%0%o!<%ICf$NMWAG?t(B
<Temporally Used Variables>
  D_WorkStrShiftMask1 : $B%9%H%j%s%0(B1$B$+$i$NMWAG<h$j=P$7MQ%^%9%/%Q%?%s(B
  D_WorkStrShiftMask2 : $B%9%H%j%s%0(B2$B$+$i$NMWAG<h$j=P$7MQ%^%9%/%Q%?%s(B
  D_WorkStrElmReg1 : $B%9%H%j%s%0(B1$B$+$i<h$j=P$7$?MWAG(B
  D_WorkStrElmReg2 : $B%9%H%j%s%0(B2$B$+$i<h$j=P$7$?MWAG(B
  D_WorkInitTargetStrWord : $B%9%H%j%s%0(B1$B$N1i;;BP>]MWAG$NF~$C$F$$$k%9%H%j%s%0(B
                            $B%o!<%I(B
  D_WorkInitTargetStrWord1 : $B%9%H%j%s%0(B2$B$N1i;;BP>]MWAG$NF~$C$F$$$k%9%H%j%s%0(B
                             $B%o!<%I(B
<Level>
<PreCondition>
<Function>
  $B%9%H%j%s%0(B1(string1)$B$N%9%H%j%s%0%o!<%I(B(word_pos1)$B$NMWAG0LCV(B(elm_position1)$B$N(B
$BMWAG$H!"(B  $B%9%H%j%s%0(B2(string2)$B$N%9%H%j%s%0%o!<%I(B(word_pos2)$B$NMWAG0LCV(B(elm_
position2)$B$NMWAG$H$N4V$G;XDj$5$l$?%S%C%H%o%$%:1i;;(B(operation)$B$r9T$$!"$=$N7k2L(B
$B$G%9%H%j%s%0(B1(string1)$B$N%9%H%j%s%0%o!<%I(B(word_pos1)$B$NMWAG0LCV(B(elm_position1)$B$N(B
$BMWAG$rCV$-49$($k!#(B
  $B$J$*!"=hM}$NJ}8~$O=gJ}8~(B($BMWAG0LCV(B $B>.(B -> $BBg(B)$B$G$"$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define  D_WorkStrShiftMask1  XXX
#DATA_define  D_WorkStrShiftMask2  XXX
#DATA_define  D_WorkStrElmReg1     XXX
#DATA_define  D_WorkStrElmReg2     XXX
#DATA_define  D_WorkInitTargetStrWord     XXX
#DATA_define  D_WorkInitTargetStrWord1     XXX

#PSL_define  s_GeneralStringOpeForward(string1, word_pos1, elm_position1,
				       string2, word_pos2, elm_position2,
				       operation, mask_pattern,
				       target_length, elm_size,
				       elms_cnt_in_word)
{
  $USE(D_WorkStrShiftMask1);
  $USE(D_WorkStrShiftMask2);
  $USE(D_WorkStrElmReg1);
  $USE(D_WorkStrElmReg2);
  $USE(D_WorkInitTargetStrWord);
  $USE(D_WorkInitTargetStrWord1);

  /* $B%9%H%j%s%0%o!<%I(B1$BCf$NMWAG0LCV$K1~$8$F!"%^%9%/$r%7%U%H$9$k(B */
  s_ShiftMaskByElmPos(mask_pattern, elm_position1, elm_size, elms_cnt_in_word,
		                                       D_WorkStrShiftMask1);
  /* $B%9%H%j%s%0%o!<%I(B2$BCf$NMWAG0LCV$K1~$8$F!"%^%9%/$r%7%U%H$9$k(B */
  s_ShiftMaskByElmPos(mask_pattern, elm_position2, elm_size, elms_cnt_in_word,
		                                       D_WorkStrShiftMask2);
  LOOP()
    { /* $BA`:nBP>]%(%l%a%s%H?tJ,$@$12s$k(B */
      b_IfLessEq(target_length, D_NULL){break;}

      /* string1$B$NA`:nBP>]HO0O$N@hF,$+$i(B1$B%(%l%a%s%H<h$j=P$9(B */
      /* $B$3$N%^%/%m$O8F$S=P$5$l$k$4$H$K(Bstring$B$NA`:nBP>]HO0O$N@hF,$+$i=g<!(B
         1$B%(%l%a%s%H$E$D<h$j=P$9(B */
      s_GetStringWordPosReg(string1, word_pos1, D_WorkInitTargetStrWord);
      s_GetTargetElementSequentiallyForward(string1, D_WorkInitTargetStrWord, 
				     word_pos1, elm_position1,
				     elm_size, elms_cnt_in_word,
				     mask_pattern, D_WorkStrShiftMask1,
				     D_WorkStrElmReg1);

      /* string2$B$NA`:nBP>]HO0O$N@hF,$+$i(B1$B%(%l%a%s%H<h$j=P$9(B */
      /* $B$3$N%^%/%m$O8F$S=P$5$l$k$4$H$K(Bstring$B$NA`:nBP>]HO0O$N@hF,$+$i=g<!(B
         1$B%(%l%a%s%H$E$D<h$j=P$9(B */
      s_GetStringWordPosReg(string2, word_pos2, D_WorkInitTargetStrWord1);
      s_GetTargetElementSequentiallyForward(string2, D_WorkInitTargetStrWord1,
				     word_pos2, elm_position2,
				     elm_size, elms_cnt_in_word,
				     mask_pattern, D_WorkStrShiftMask2,
				     D_WorkStrElmReg2);
				     
      /* $BFs$D$N%9%H%j%s%0%(%l%a%s%H4V$G(B operation $B$r9T$&(B */
      s_BitwiseOperationToElements(D_WorkStrElmReg1, D_WorkStrElmReg2,
				   operation, mask_pattern, D_WorkStrElmReg1);

      /* operation$B7k2L$N%(%l%a%s%H$G(B string1 $B$r99?7$9$k(B  */
      s_SetTargetElement(string1, word_pos1, elm_position1,
			 elm_size, elms_cnt_in_word, D_WorkStrShiftMask1,
			 D_WorkStrElmReg1);

      /* $B%^%9%/$r(B1$B%(%l%a%s%HJ,1&$K%7%U%H$9$k(B */
      b_ShiftRightWithDNTC(D_WorkStrShiftMask1, elm_size, D_WorkStrShiftMask1);
      b_ShiftRightWithDNTC(D_WorkStrShiftMask2, elm_size, D_WorkStrShiftMask2);

      /* $B%9%H%j%s%0%o!<%ICf$NMWAG0LCV$r?J$a$k(B */
      b_IncrementReg(elm_position1);
      b_IncrementReg(elm_position2);

      b_DecrementReg(target_length);
    }

  $RELEASE(D_WorkStrShiftMask1);
  $RELEASE(D_WorkStrShiftMask2);
  $RELEASE(D_WorkStrElmReg1);
  $RELEASE(D_WorkStrElmReg2);
  $RELEASE(D_WorkInitTargetStrWord);
  $RELEASE(D_WorkInitTargetStrWord1);
}

/******************************************************************** PSL **
  8.2 $B%9%H%j%s%0%*%Z%l!<%7%g%s(B($B5UJ}8~(B)
  s_GeneralStringOpeBackward(string1, word_pos1, elm_position1,
			     string2, word_pos2, elm_position2,
			     operation, mask_pattern,
			     target_length, elm_size,
			     elms_cnt_in_word)

       written by kawai@icot22      on Thu Sep 12 12:26:24 1991
<Arguments>
  string1 : $B%9%H%j%s%0(B1($BCV$-49$((B)
  word_pos1 : $B%9%H%j%s%0(B1$B$N1i;;BP>]MWAG$NF~$C$F$$$k%9%H%j%s%0%o!<%I0LCV(B
  elm_position1 : $B%9%H%j%s%0(B1$B$N1i;;BP>]MWAG$N0LCV(B
  string2 : $B%9%H%j%s%0(B2($BFI$_9~$_(B)
  word_pos2 : $B%9%H%j%s%0(B2$B$N1i;;BP>]MWAG$NF~$C$F$$$k%9%H%j%s%0%o!<%I0LCV(B
  elm_position2 : $B%9%H%j%s%0(B2$B$N1i;;BP>]MWAG$N0LCV(B
  operation : $B1i;;<oJL(B(0$B!A(B15)
  mask_pattern : $BMWAG<h$j=P$7MQ%^%9%/%Q%?%s(B
  target_length : $B1i;;BP>]MWAG?t(B
  elm_size : $BMWAG%5%$%:(B
  elms_cnt_in_word : 1$B%9%H%j%s%0%o!<%ICf$NMWAG?t(B
<Temporally Used Variables>
  D_WorkStrShiftMask1 : $B%9%H%j%s%0(B1$B$+$i$NMWAG<h$j=P$7MQ%^%9%/%Q%?%s(B
  D_WorkStrShiftMask2 : $B%9%H%j%s%0(B2$B$+$i$NMWAG<h$j=P$7MQ%^%9%/%Q%?%s(B
  D_WorkStrElmReg1 : $B%9%H%j%s%0(B1$B$+$i<h$j=P$7$?MWAG(B
  D_WorkStrElmReg2 : $B%9%H%j%s%0(B2$B$+$i<h$j=P$7$?MWAG(B
  D_WorkInitTargetStrWord : $B%9%H%j%s%0(B1$B$N1i;;BP>]MWAG$NF~$C$F$$$k%9%H%j%s%0(B
                            $B%o!<%I(B
  D_WorkInitTargetStrWord1 : $B%9%H%j%s%0(B2$B$N1i;;BP>]MWAG$NF~$C$F$$$k%9%H%j%s%0(B
                             $B%o!<%I(B
<Level>
<PreCondition>
<Function>
  $B%9%H%j%s%0(B1(string1)$B$N%9%H%j%s%0%o!<%I(B(word_pos1)$B$NMWAG0LCV(B(elm_position1)$B$N(B
$BMWAG$H!"(B  $B%9%H%j%s%0(B2(string2)$B$N%9%H%j%s%0%o!<%I(B(word_pos2)$B$NMWAG0LCV(B(elm_
position2)$B$NMWAG$H$N4V$G;XDj$5$l$?%S%C%H%o%$%:1i;;(B(operation)$B$r9T$$!"$=$N7k2L(B
$B$G%9%H%j%s%0(B1(string1)$B$N%9%H%j%s%0%o!<%I(B(word_pos1)$B$NMWAG0LCV(B(elm_position1)$B$N(B
$BMWAG$rCV$-49$($k!#(B
  $B$J$*!"=hM}$NJ}8~$O5UJ}8~(B($BMWAG0LCV(B $BBg(B -> $B>.(B)$B$G$"$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  s_GeneralStringOpeBackward(string1, word_pos1, elm_position1,
					string2, word_pos2, elm_position2,
					operation, mask_pattern,
					target_length, elm_size,
					elms_cnt_in_word)
{
  $USE(D_WorkStrShiftMask1);
  $USE(D_WorkStrShiftMask2);
  $USE(D_WorkStrElmReg1);
  $USE(D_WorkStrElmReg2);
  $USE(D_WorkInitTargetStrWord);
  $USE(D_WorkInitTargetStrWord1);

  /* $B%9%H%j%s%0%o!<%I(B1$BCf$NMWAG0LCV$K1~$8$F!"%^%9%/$r%7%U%H$9$k(B */
  s_ShiftMaskByElmPos(mask_pattern, elm_position1, elm_size, elms_cnt_in_word,
		                                       D_WorkStrShiftMask1);
  /* $B%9%H%j%s%0%o!<%I(B2$BCf$NMWAG0LCV$K1~$8$F!"%^%9%/$r%7%U%H$9$k(B */
  s_ShiftMaskByElmPos(mask_pattern, elm_position2, elm_size, elms_cnt_in_word,
		                                       D_WorkStrShiftMask2);
  LOOP()
    { /* $BA`:nBP>]%(%l%a%s%H?tJ,$@$12s$k(B */
      b_IfLessEq(target_length, D_NULL){break;}

      /* string1$B$NA`:nBP>]HO0O$NKvHx$+$i(B1$B%(%l%a%s%H<h$j=P$9(B */
      /* $B$3$N%^%/%m$O8F$S=P$5$l$k$4$H$K(Bstring$B$NA`:nBP>]HO0O$NKvHx$+$i=g<!(B
         1$B%(%l%a%s%H$E$D<h$j=P$9(B */
      s_GetStringWordPosReg(string1, word_pos1, D_WorkInitTargetStrWord);
      s_GetTargetElementSequentiallyBackward(string1, D_WorkInitTargetStrWord, 
				     word_pos1, elm_position1,
				     elm_size, elms_cnt_in_word,
				     mask_pattern, D_WorkStrShiftMask1,
				     D_WorkStrElmReg1);

      /* string2$B$NA`:nBP>]HO0O$NKvHx$+$i(B1$B%(%l%a%s%H<h$j=P$9(B */
      /* $B$3$N%^%/%m$O8F$S=P$5$l$k$4$H$K(Bstring$B$NA`:nBP>]HO0O$NKvHx$+$i=g<!(B
         1$B%(%l%a%s%H$E$D<h$j=P$9(B */
      s_GetStringWordPosReg(string2, word_pos2, D_WorkInitTargetStrWord1);
      s_GetTargetElementSequentiallyBackward(string2, D_WorkInitTargetStrWord1,
				     word_pos2, elm_position2,
				     elm_size, elms_cnt_in_word,
				     mask_pattern, D_WorkStrShiftMask2,
				     D_WorkStrElmReg2);
				     
      /* $BFs$D$N%9%H%j%s%0%(%l%a%s%H4V$G(B operation $B$r9T$&(B */
      s_BitwiseOperationToElements(D_WorkStrElmReg1, D_WorkStrElmReg2,
				   operation, mask_pattern, D_WorkStrElmReg1);

      /* operation$B7k2L$N%(%l%a%s%H$G(B string1 $B$r99?7$9$k(B  */
      s_SetTargetElement(string1, word_pos1, elm_position1,
			 elm_size, elms_cnt_in_word, D_WorkStrShiftMask1,
			 D_WorkStrElmReg1);

      /* $B%^%9%/$r(B1$B%(%l%a%s%HJ,:8$K%7%U%H$9$k(B */
      b_ShiftLeftWithDNTC(D_WorkStrShiftMask1, elm_size, D_WorkStrShiftMask1);
      b_ShiftLeftWithDNTC(D_WorkStrShiftMask2, elm_size, D_WorkStrShiftMask2);

      /* $B%9%H%j%s%0%o!<%ICf$NMWAG0LCV$rLa$9(B */
      b_DecrementReg(elm_position1);
      b_DecrementReg(elm_position2);

      b_DecrementReg(target_length);
    }

  $RELEASE(D_WorkStrShiftMask1);
  $RELEASE(D_WorkStrShiftMask2);
  $RELEASE(D_WorkStrElmReg1);
  $RELEASE(D_WorkStrElmReg2);
  $RELEASE(D_WorkInitTargetStrWord);
  $RELEASE(D_WorkInitTargetStrWord1);
}

/******************************************************************** PSL **
  8.3 $B%9%H%j%s%0%*%Z%l!<%7%g%sMQ$NItIJ%^%/%m(B

       written by kawai@icot22      on Thu Sep 12 14:28:23 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/


/* $B%9%H%j%s%0$+$iMWAG$rC`;zE*$K<h$j=P$9(B($B=gJ}8~(B) */
#DATA_define  D_WorkMaskShiftCnt  XXX

#PSL_define  s_GetTargetElementSequentiallyForward(string, word, word_pos,
						   elm_pos, elm_size,
						   elms_cnt_in_word,
						   mask_init, mask, elm)
{
  $USE(D_WorkMaskShiftCnt);
  b_SubtractWithDNTC(elms_cnt_in_word, elm_pos, D_WorkMaskShiftCnt);
  b_DecrementReg(D_WorkMaskShiftCnt);
  b_IfLess(D_WorkMaskShiftCnt, D_NULL)
    { /* elm_pos $B$,(B 1$B%o!<%I$r30$l$?$i%o!<%I%]%8%7%g%s$rLa$7!"(B
         $B$=$N%o!<%I%]%8%7%g%s$N%9%H%j%s%0%o!<%I$rFI$_9~$`(B */
      b_IncrementReg(word_pos);
      s_GetStringWordPosReg(string, word_pos, word);
      /* $B%o!<%IFb$N%(%l%a%s%H0LCV$N=i4|2=(B */
      p_MoveValue(D_NULL, elm_pos);
      /* $B%^%9%/0LCV$N=i4|2=(B */
      s_ShiftMaskByElmPos(mask_init, elm_pos, elm_size,
			                      elms_cnt_in_word, mask);
      /* $B%7%U%H$9$k%(%l%a%s%H?t$N99?7(B */
      p_MoveValue(elms_cnt_in_word, D_WorkMaskShiftCnt);
      b_DecrementReg(D_WorkMaskShiftCnt);
    }
  /* $B%(%l%a%s%H$N<h$j=P$7(B */
  b_BitwiseAndWithDNTC(word, mask, elm);
  b_MultiplyWithDNTC(D_WorkMaskShiftCnt, elm_size, D_WorkMaskShiftCnt);
  b_ShiftRightWithDNTC(elm, D_WorkMaskShiftCnt, elm);
  $RELEASE(D_WorkMaskShiftCnt);
}



/* $B%9%H%j%s%0$+$iMWAG$rC`;zE*$K<h$j=P$9(B($B5UJ}8~(B) */
#PSL_define  s_GetTargetElementSequentiallyBackward(string, word, word_pos,
						    elm_pos, elm_size,
						    elms_cnt_in_word,
						    mask_init, mask, elm)
{
  b_IfLess(elm_pos, D_NULL)
    { /* elm_pos $B$,(B 1$B%o!<%I$r30$l$?$i%o!<%I%]%8%7%g%s$rLa$7!"(B
         $B$=$N%o!<%I%]%8%7%g%s$N%9%H%j%s%0%o!<%I$rFI$_9~$`(B */
      b_DecrementReg(word_pos);
      s_GetStringWordPosReg(string, word_pos, word);
      /* $B%o!<%IFb$N%(%l%a%s%H0LCV$N=i4|2=(B */
      p_MoveValue(elms_cnt_in_word, elm_pos);
      b_DecrementReg(elm_pos);
      /* $B%^%9%/0LCV$N=i4|2=(B */
      p_MoveValue(mask_init, mask);
    }

  /* $B%(%l%a%s%H$N<h$j=P$7(B */
  $USE(D_WorkMaskShiftCnt);
  b_BitwiseAndWithDNTC(word, mask, elm);
  b_SubtractWithDNTC(elms_cnt_in_word, elm_pos, D_WorkMaskShiftCnt);
  b_DecrementReg(D_WorkMaskShiftCnt);
  b_MultiplyWithDNTC(D_WorkMaskShiftCnt, elm_size, D_WorkMaskShiftCnt);
  b_ShiftRightWithDNTC(elm, D_WorkMaskShiftCnt, elm);
  $RELEASE(D_WorkMaskShiftCnt);
}


/* $B%^%9%/%Q%?%s$rMWAG0LCV$K1~$8$F%7%U%H$9$k(B */
#DATA_define  D_WorkMaskShiftCnt1  XXX

#PSL_define  s_ShiftMaskByElmPos(mask, elm_pos, elm_size, elms_cnt_in_word, 
				                                   shift_mask)
{
  $USE(D_WorkMaskShiftCnt1);
  b_SubtractWithDNTC(elms_cnt_in_word, elm_pos, D_WorkMaskShiftCnt1);
  b_DecrementReg(D_WorkMaskShiftCnt1);
  b_MultiplyWithDNTC(D_WorkMaskShiftCnt1, elm_size, D_WorkMaskShiftCnt1);
  b_ShiftLeftWithDNTC(mask, D_WorkMaskShiftCnt1, shift_mask);
  $RELEASE(D_WorkMaskShiftCnt1);
}


/* $BMWAG$r%9%H%j%s%0$K%;%C%H$9$k(B */
/* $B%9%H%j%s%0%o!<%I0l$N7W;;$r>J$1$kJ,!"0lHL$N(B set_string_element $B$h$jB.$$H&(B */
#DATA_define  D_WorkStrReverseShiftMask  XXX
#DATA_define  D_WorkTargetStrWord  XXX

#PSL_define  s_SetTargetElement(string, word_pos, elm_pos, elm_size,
				elms_cnt_in_word, mask, target_elm)
{
  $USE(D_WorkMaskShiftCnt);
  $USE(D_WorkStrReverseShiftMask);
  $USE(D_WorkTargetStrWord);
  b_SubtractWithDNTC(elms_cnt_in_word, elm_pos, D_WorkMaskShiftCnt);
  b_DecrementReg(D_WorkMaskShiftCnt);
  b_MultiplyWithDNTC(D_WorkMaskShiftCnt, elm_size, D_WorkMaskShiftCnt);
  b_ShiftLeftWithDNTC(target_elm, D_WorkMaskShiftCnt, target_elm);
  b_BitwiseComplementWithDNTC(mask, D_WorkStrReverseShiftMask);
  s_GetStringWordPosReg(string, word_pos, D_WorkTargetStrWord);
  b_BitwiseAndWithDNTC(D_WorkTargetStrWord, D_WorkStrReverseShiftMask,
		       D_WorkTargetStrWord);
  b_BitwiseOrWithDNTC(D_WorkTargetStrWord, target_elm, D_WorkTargetStrWord);
  s_PutStringWordPosReg(string, word_pos, D_WorkTargetStrWord);
  $RELEASE(D_WorkTargetStrWord);
  $RELEASE(D_WorkMaskShiftCnt);
  $RELEASE(D_WorkStrReverseShiftMask);
}


/* $BMWAGF1;N$N1i;;(B */
#PSL_define  s_BitwiseOperationToElements(elm1, elm2, operation, mask, result)
{
  ValueSwitch(operation)
    {
    case 0:  /* Always return 0 */
      p_MoveValue(D_NULL, result);
      break;
    case 1:  /* elm2 AND elm1 */
      b_BitwiseAndWithDNTC(elm2, elm1, result);
      break;
    case 2:  /* elm2 AND (not elm1) */
      b_BitwiseComplementWithDNTC(elm1, elm1);
      b_BitwiseAndWithDNTC(elm2, elm1, result);
      break;
    case 3:  /* Always return elm2 */
      p_MoveValue(elm2, result);
      break;
    case 4:  /* (not elm2) AND elm1 */
      b_BitwiseComplementWithDNTC(elm2, elm2);
      b_BitwiseAndWithDNTC(elm2, elm1, result);
      break;
    case 5:  /* Always return elm1 */
      p_MoveValue(elm1, result);
      break;
    case 6:  /* elm2 XOR elm1 */
      b_BitwiseEorWithDNTC(elm2, elm1, result);
      break;
    case 7:  /* elm2 OR elm1 */
      b_BitwiseOrWithDNTC(elm2, elm1, result);
      break;
    case 8:  /* elm2 NOR elm1 */
      b_BitwiseOrWithDNTC(elm2, elm1, result);
      b_BitwiseComplementWithDNTC(result, result);
      break;
    case 9:  /* elm2 not XOR elm1 = not(elm2 XOR elm1) */
      b_BitwiseEorWithDNTC(elm2, elm1, result);
      b_BitwiseComplementWithDNTC(result, result);
      break;
    case 10: /* not elm1 */
      b_BitwiseComplementWithDNTC(elm1, result);
      break;
    case 11: /* elm2 OR (not elm1) */
      b_BitwiseComplementWithDNTC(elm1, elm1);
      b_BitwiseOrWithDNTC(elm2, elm1, result);
      break;
    case 12: /* not elm2 */
      b_BitwiseComplementWithDNTC(elm2, result);
      break;
    case 13: /* (not elm2) OR elm1 */
      b_BitwiseComplementWithDNTC(elm2, elm2);
      b_BitwiseOrWithDNTC(elm2, elm1, result);
      break;
    case 14: /* elm2 NAND elm1 */
      b_BitwiseAndWithDNTC(elm2, elm1, result);
      b_BitwiseComplementWithDNTC(result, result);
      break;
    case 15: /* Always return 1 */
      p_MoveValue(D_ALL1, result);
      break;
    default:
      @DEBUG{VPIM_ERROR("s_BitwiseOperationForElements",
			"Illegal String Operation"); };
    }
  b_BitwiseAndWithDNTC(result, mask, result);
}

/******************************************************************** PSL **
  9. $B%9%H%j%s%0$NBg>.Hf3S(B
  s_WhichIsLessString(string1, string2, result)

       written by kawai@icot22      on Thu Sep 12 14:37:39 1991
<Arguments>
  string1 : $B%9%H%j%s%0(B1
  string2 : $B%9%H%j%s%0(B2
  result : $BHf3S7k2L(B
             _ARG_STR_NO1:string1 > string2$B!"(B
	     _ARG_STR_NO2:string1 < string2$B!"(B
             _ARG_STR_EQ:string1 = string2
<Temporally Used Variables>
  D_WorkStrWordLength : $B%9%H%j%s%0(B1$B$N%9%H%j%s%0%o!<%IC10L$ND9$5(B
  D_WorkStrWordLength1 : $B%9%H%j%s%0(B2$B$N%9%H%j%s%0%o!<%IC10L$ND9$5(B
  D_WorkStrSearchFirstWordPos : $B%9%H%j%s%0(B1$B$N%9%H%j%s%0%o!<%I0LCV(B
  D_WorkStrSearchFirstWordPos1 : $B%9%H%j%s%0(B2$B$N%9%H%j%s%0%o!<%I0LCV(B
  D_WorkTargetStrWord : $B%9%H%j%s%0(B1$B$N%9%H%j%s%0%o!<%I(B
  D_WorkTargetStrWord1 : $B%9%H%j%s%0(B2$B$N%9%H%j%s%0%o!<%I(B
  D_WorkStrEachElmSize : $B%9%H%j%s%0(B1$B$NMWAG%5%$%:(B
  D_WorkStrEachElmSize1 : $B%9%H%j%s%0(B2$B$NMWAG%5%$%:(B
  D_WorkStrElmLength : $B%9%H%j%s%0(B1$B$N%(%l%a%s%HC10L$ND9$5(B
  D_WorkStrElmLength1 : $B%9%H%j%s%0(B2$B$N%(%l%a%s%HC10L$ND9$5(B
<Level>
<PreCondition>
<Function>
  $B0z?t$GM?$($i$l$?(Bstring1$B$H(Bstring2$B$NBg>.H=Dj$r9T$&!#H=Dj7k2L$O(B
       _ARG_STR_NO1:string1 < string2$B!"(B
       _ARG_STR_NO2:string1 > string2$B!"(B
       _ARG_STR_EQ:string1 = string2
  $B$N$$$:$l$+$N%3%s%9%?%s%H$,JV$k!#(B
<Examples>
<Test>
<Explanation>
  $BBg>.H=Dj$O(B
    (1) $BMWAG%5%$%:$NBg$-$$J}$,Bg(B
    (2) $B0lJ}$N%9%H%j%s%0$N=*$o$j$^$GHf3S$7$FMWAG$,A4$FEy$7$/!"B>J}$N%9%H%j%s%0(B
        $B$,$^$@=*$o$C$F$$$J$$;~$OD9$$J}$,Bg(B
    (3) $B40A4$K0lCW$7$F$$$l$PEy$7$$!#(B

$BHf3S$O%9%H%j%s%0%o!<%I$rId9fIU$-@0?t$H8+$J$7$F$=$NBg>.H=Dj$G9T$&!#(B
      $B%9%H%j%s%0%o!<%I(B1($B@5(B)$B!"%9%H%j%s%0%o!<%I(B2($B@5(B) -> $B>.$5$$J}$,>.(B
      $B%9%H%j%s%0%o!<%I(B1($BIi(B)$B!"%9%H%j%s%0%o!<%I(B2($B@5(B) -> $BBg$-$$J}$,>.(B
      $B%9%H%j%s%0%o!<%I(B1($B@5(B)$B!"%9%H%j%s%0%o!<%I(B2($BIi(B) -> $BBg$-$$J}$,>.(B
      $B%9%H%j%s%0%o!<%I(B1($BIi(B)$B!"%9%H%j%s%0%o!<%I(B2($BIi(B) -> $B>.$5$$J}$,>.(B
<ETC>
********************************************************************* PSL **/

#CONST_define  _ARG_STR_EQ    _ZERO
#CONST_define  _ARG_STR_NO1   _ONE
#CONST_define  _ARG_STR_NO2   _TWO

#DATA_define  D_WorkStrWordLength    XXX
#DATA_define  D_WorkStrWordLength1   XXX
#DATA_define  D_WorkStrElmLength     XXX
#DATA_define  D_WorkStrElmLength1    XXX
#DATA_define  D_WorkStrEachElmSize   XXX
#DATA_define  D_WorkStrEachElmSize1  XXX
#DATA_define  D_WorkTargetStrWord1   XXX

#PSL_define  s_WhichIsLessString(string1, string2, result)
{
  $USE(D_WorkStrElmLength);
  $USE(D_WorkStrEachElmSize);
  s_GetStringType(string1, D_WorkStrElmLength, D_WorkStrEachElmSize);

  $USE(D_WorkStrElmLength1);
  $USE(D_WorkStrEachElmSize1);
  s_GetStringType(string2, D_WorkStrElmLength1, D_WorkStrEachElmSize1);

  b_IfNotEqual(D_WorkStrEachElmSize, D_WorkStrEachElmSize1)
    { /* string1$B$H(Bstring2$B$NMWAG$N%5%$%:$,0c$&;~(B */
      b_IfLess(D_WorkStrEachElmSize, D_WorkStrEachElmSize1)
	{ /* string1$B$NMWAG%5%$%:(B < string2$B$NMWAG%5%$%:$J$i(B */ 
	  p_SetImmediateValue(_ARG_STR_NO1, result);     
	}
      else
	{ /* string1$B$NMWAG%5%$%:(B > string2$B$NMWAG%5%$%:$J$i(B */
	  p_SetImmediateValue(_ARG_STR_NO2, result);     
	}
      goto end_label;
    }

  $USE(D_WorkStrWordLength);
  $USE(D_WorkStrWordLength1);
  s_GetStringSize(string1, D_WorkStrWordLength);
  s_GetStringSize(string2, D_WorkStrWordLength1);

  $USE(D_WorkStrSearchFirstWordPos);
  $USE(D_WorkStrSearchFirstWordPos1);

  p_MoveValue(D_NULL, D_WorkStrSearchFirstWordPos);
  p_MoveValue(D_NULL, D_WorkStrSearchFirstWordPos1);
  p_MoveValue(D_NULL, result);

  $USE(D_WorkTargetStrWord);
  $USE(D_WorkTargetStrWord1);

  LOOP()
    { 
      b_IfNotEqual(result, D_NULL) {break;} /* $BBg>.Hf3S$N7k2L$,=P$F$$$?$i(B */

      b_IfGreaterEq(D_WorkStrSearchFirstWordPos, D_WorkStrWordLength)
	{ /* string1 $B$N:G8e$^$GHf3S$7$?$i(B */
	  b_IfGreaterEq(D_WorkStrSearchFirstWordPos1, D_WorkStrWordLength1)
	    { /* string2 $B$bF1;~$K:G8e$K$J$C$F$$$?$i!"N>J}$H$bF1$8%o!<%ID9$G(B
		 $BMWAG$bF1$8(B */
	      b_IfLess(D_WorkStrElmLength, D_WorkStrElmLength1)
		{ /* string1$B$NMWAG?t(B < string2$B$NMWAG?t(B */
		  p_SetImmediateValue(_ARG_STR_NO1, result);
		}
	      else
		{
		  b_IfEqual(D_WorkStrElmLength, D_WorkStrElmLength1)
		    { /* string1$B$NMWAG?t(B = string2$B$NMWAG?t(B */
		      p_SetImmediateValue(_ARG_STR_EQ, result);
		    }
		  else
		    { /* string1$B$NMWAG?t(B > string2$B$NMWAG?t(B */
		      p_SetImmediateValue(_ARG_STR_NO2, result);
		    }
		}
	    }
	  else
	    { /* string2 $B$,$^$@:G8e$K$J$C$F$J$+$C$?$i(B */
	      p_SetImmediateValue(_ARG_STR_NO1, result);
	    }
	  break;
	}

      b_IfGreaterEq(D_WorkStrSearchFirstWordPos1, D_WorkStrWordLength1)
	{ /* string2 $B$N:G8e$^$GHf3S$7$?$i(B(string1$B$O$^$@:G8e$G$O$J$$H&(B) */
	  p_SetImmediateValue(_ARG_STR_NO2, result);
	  break;
	}

      s_GetStringWordPosReg(string1, D_WorkStrSearchFirstWordPos,
			                               D_WorkTargetStrWord);
      s_GetStringWordPosReg(string2, D_WorkStrSearchFirstWordPos1,
			                               D_WorkTargetStrWord1);

      b_IfGreaterEq(D_WorkTargetStrWord, D_NULL)
	{ /* string1(+) */
	  b_IfGreaterEq(D_WorkTargetStrWord1, D_NULL)
	    { /* string1(+) & string2(+) */
	      b_IfLess(D_WorkTargetStrWord, D_WorkTargetStrWord1)
		{ /* string1 < string2 */
		  /* $BN>J}$N%9%H%j%s%0%o!<%I$,F1$8Id9f$J$i!">.$5$$J}$,>.$5$$(B */
		  p_SetImmediateValue(_ARG_STR_NO1, result);
		}
	      else
		{ /* equal$B$N;~$O!"<!$N%9%H%j%s%0%o!<%I$N%A%'%C%/$N$?$a(B
                     $B$J$K$b$7$J$$(B */
		  b_IfGreater(D_WorkTargetStrWord, D_WorkTargetStrWord1)
		    { /* string1 > string2 */
		      p_SetImmediateValue(_ARG_STR_NO2, result);
		    }
		}
	    }
	  else
	    { /* string1(+) & string2(-) */
	      p_SetImmediateValue(_ARG_STR_NO1, result);
	    }
	}
      else
	{ /* string1(-) */
	  b_IfLess(D_WorkTargetStrWord1, D_NULL)
	    { /* string1(-) & string2(-) */
	      b_IfLess(D_WorkTargetStrWord, D_WorkTargetStrWord1)
		{ /* string1 < string2 */
		  p_SetImmediateValue(_ARG_STR_NO1, result);
		}
	      else
		{ /* equal$B$N;~$O!"<!$N%9%H%j%s%0%o!<%I$N%A%'%C%/$N$?$a(B
                     $B$J$K$b$7$J$$(B */
		  b_IfGreater(D_WorkTargetStrWord, D_WorkTargetStrWord1)
		    { /* string1 > string2 */
		      p_SetImmediateValue(_ARG_STR_NO2, result);
		    }
		}
	    }
	  else
	    { /* string1(-) & string2(+) */
	      p_SetImmediateValue(_ARG_STR_NO2, result);
	    }
	}

      b_IncrementReg(D_WorkStrSearchFirstWordPos);
      b_IncrementReg(D_WorkStrSearchFirstWordPos1);      
    }
  
  $RELEASE(D_WorkStrWordLength);
  $RELEASE(D_WorkStrWordLength1);
  $RELEASE(D_WorkStrSearchFirstWordPos);
  $RELEASE(D_WorkStrSearchFirstWordPos1);
  $RELEASE(D_WorkTargetStrWord);
  $RELEASE(D_WorkTargetStrWord1);
 end_label:
  $RELEASE(D_WorkStrEachElmSize);
  $RELEASE(D_WorkStrEachElmSize1);
  $RELEASE(D_WorkStrElmLength);
  $RELEASE(D_WorkStrElmLength1);
}
