
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/structures/str_small_struct.psl.c
   ----- CREATED   : by f-hataza@icot22, on Mon May 21 14:23:27 1990
   ----- LAST SAVED: by ttakagi@icot22, on Mon Apr 20 12:31:06 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : STRUCTURES
   ----- ABSTRACT  : $BJQ?t%;%k!"%j%9%H%;%k$NA`:n!"9=B$BN6&DLA`:n(B

  1.  $BJQ?t%;%k$H%U%j!<%j%9%H$NA`:n(B
  2.  $B%j%9%H%;%k$H%U%j!<%j%9%HA`:n(B
  3.  $B9=B$BN6&DLA`:n(B
   3.1  $BMWAG$N%"%I%l%97W;;(B
   3.2  $B9=B$BNMWAG$N%3%T!<(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
  1.  $BJQ?t%;%k$H%U%j!<%j%9%H$NA`:n(B

       written by goto@icot22      Fri Nov 11 16:48:11 1988
       revised by imai@icot22      on Thu Dec 14 11:55:50 1989

<Arguments>
  src_reg : $B2s<}$9$kJQ?t%;%k$r;X$9%]%$%s%?(B
  dst_reg : $B3d$jEv$F$kJQ?t%;%k$r;X$9%]%$%s%?(B
<Temporally Used Variables> none
<Level>	structures
<PreCondition>
<Function>
  s_AllocVoid(dst_reg) :
        dst_reg$B$K(BVOID$BJQ?t%;%k$r3d$jEv$F$k(B.
  	dst_reg$B$N%?%0$O(B [_MRB_OFF, REF] $B$H$J$k(B.
  	$B3d$jEv$F$?JQ?t%;%k$N%?%0$O(B [_MRB_OFF, VOID], $BCM$O(B "0" $B$H$J$k(B.
  s_AllocVariable(dst_reg) :
        dst_reg$B$K(BUNDF$BJQ?t%;%k$r3d$jEv$F$k(B.
  	dst_reg$B$N%?%0$O(B [_MRB_OFF, REF] $B$H$J$k(B.
  	$B3d$jEv$F$?JQ?t%;%k$N%?%0$O(B [_MRB_OFF, UNDF], $BCM$O(B "0" $B$H$J$k(B.
  s_AllocMghok(src_addr_reg,dst_reg) :
	dst_reg$B$K%^!<%8%c$K%U%C%/$7$?JQ?t%;%k$r3d$jEv$F$k(B.
  	dst_reg$B$N%?%0$O(B [_MRB_OFF, REF] $B$H$J$k(B.
  	$B3d$jEv$F$?JQ?t%;%k$N%?%0$O(B [_MRB_OFF, MGHOK],
	$BCM$O(B src_addr_reg $B$NCMIt$H$J$k(B.
  s_ReclaimVariable(src_reg) :
        src_reg $B$G;X$5$l$k(B1$B%o!<%I$N(B($BJQ?t(B)$B%;%k$r%U%j!<%j%9%H$K2s<}$9$k(B.
<Examples>
<Test>
<Explanation>
  $B:GE,2=$H$7$F(B, $B2s<};~$K(BUNDEF$B%?%0$r@_Dj$7$F$*$/$3$H$,9M$($i$l$k!#$?$@$7(B, $B8=;EMM(B
  $B$G$O(B, $B%U%j!<%j%9%H$N:G8e$r(B, D_Free_1_PtrReg $B$N%?%0$b4^$a$F(BD_EOL$B$HEy$7$$$+$I$&(B
  $B$+$GD4$Y$k$?$a(B, $B:GE,2=$O:NMQ$5$l$F$$$J$$!#(B
<ETC>
<Revised Memo on "Dec 14">
  s_AllocMghok $B$rDI2C$7$?!#(B
********************************************************************* PSL **/
#CONST_define _SIZE_OF_VARIABLE 	1	/* word */

#PSL_define s_AllocVoid		(dst_reg)
{
  b_Alloc1(dst_reg, REF);
  b_WriteImmTagWithOffset (_MRB_OFF, VOID, D_NULL, dst_reg, _ZERO);
  @DEBUG{
    b_IfRangeUnderImm(dst_reg, _HEAP_AREA_BASE) {
      VPIM_ERROR("s_AllocVoid","ttakagi check point");
    }
  };    
/*
 * VOID $BJQ?t$NI=8=$H$7$F(B, VOID $B%?%0$NBe$o$j$K(B, MRB$B$,(BON$B$G$"$k(BUNDF$BJQ?t$rMQ$$$k(B
 * $B$3$H$b2DG=$G$"$k!#(B(UNDF$BJQ?t%;%k$K$*$$$F$O(BMRB$B%S%C%H$N0UL#$,$J$$$?$a(B.)
 * $B$3$N>l9g(B, VOID$BJQ?t%;%k$N%?%0$O0J2<$N$h$&$K$K%;%C%H$9$k(B.
  b_WriteImmTagWithOffset (_MRB_ON , UNDF, D_NULL, dst_reg, _ZERO);
*/
}

#PSL_define s_AllocVariable	(dst_reg)
{
  b_Alloc1(dst_reg, REF);
  b_WriteImmTagWithOffset (_MRB_OFF, UNDF, D_NULL, dst_reg, _ZERO);
}

#PSL_define s_AllocMghok	(src_addr_reg, dst_reg)
{
  b_Alloc1(dst_reg, REF);
  b_WriteImmTagWithOffset (_MRB_OFF, MGHOK, src_addr_reg, dst_reg, _ZERO);
}
 
#PSL_define s_ReclaimVariable	(src_reg)
{
  @DEBUG{
    s_IfNotREF(src_reg){
      WARNING("s_ReclaimVariable","Not variable by ttakagi check");
      ttakagi_check_point();
    }
  };
  b_Reclaim1(src_reg);
}

/******************************************************************** PSL **
  2.  $B%j%9%H%;%k$H%U%j!<%j%9%HA`:n(B

       written by goto@icot22      Fri Nov 11 15:28:13 1988

<Arguments>
  src_reg : $B2s<}$9$kJQ?t%;%k$r;X$9%]%$%s%?(B
  dst_reg : $B3d$jEv$F$kJQ?t%;%k$r;X$9%]%$%s%?(B
  list_ptr_reg : $B%j%9%H%;%k$X$N%]%$%s%?$r;}$D%l%8%9%?(B
<Temporally Used Variables>
<Level>	structures
<PreCondition>
<Function>
  s_AllocList (dst_reg):
        dst_reg $B$K%j%9%H%;%k$r3d$jEv$F$k(B.
  	dst_reg$B$N%?%0$O(B [_MRB_OFF, LIST] $B$H$9$k(B.
  s_ReclaimList (src_reg):
        src_reg$B$,;X$9%j%9%H%;%k$r%U%j!<%j%9%H$K2s<}$9$k(B.
  s_GetCarList (list_ptr_reg, dst_reg):
        list_ptr_reg$B$,;X$9%j%9%H%;%k$N(BCAR$B$r(Bdst_reg$B$KFI$_=P$9!#(B
  s_GetCdrList (list_ptr_reg, dst_reg):
        list_ptr_reg$B$,;X$9%j%9%H%;%k$N(BCDR$B$r(Bdst_reg$B$KFI$_=P$9!#(B
  s_PutCarList (list_ptr_reg, src_reg):
        list_ptr_reg$B$,;X$9%j%9%H%;%k$N(BCAR$B$K(Bsrc_reg$B$NFbMF$r=q$-9~$`(B
  s_PutCdrList (list_ptr_reg, src_reg):
        list_ptr_reg$B$,;X$9%j%9%H%;%k$N(BCDR$B$K(Bsrc_reg$B$NFbMF$r=q$-9~$`(B
  s_CopyCarList(src_list_ptr, dst_list_ptr):
        src_list_ptr, dst_list_ptr $B$N;X$9%j%9%H4V$G!"(BCAR$BIt$r%3%T!<$9$k!#(B
  s_CopyCdrList(src_list_ptr, dst_list_ptr):
        src_list_ptr, dst_list_ptr $B$N;X$9%j%9%H4V$G!"(BCDR$BIt$r%3%T!<$9$k!#(B
  s_CopyReuseElemList_Sub (A_SrcPtr, A_DstPtr, A_CopyFlag):
        A_SrcPtr$B$,;X$9%j%9%H$^$?$O(B2$BMWAG%Y%/%?$NMWAG$r!"%3%T!<%U%i%0(B A_CopyFlag
        $B$K=>$C$F!"(BA_DstPtr $B$N@h$K%3%T!<$9$k!#(B
<Examples>
<Test>
<Explanation>
  s_GetCarList, s_GetCdrList $B$K$*$$$F$O(B, list_ptr_reg$B$N(BMRB$B$,(Bdst_reg$B$KB-$79~$^(B
  $B$l$k!#(B
<ETC>
********************************************************************* PSL **/
#CONST_define _SIZE_OF_LIST 		2	/* word */
#ADDR_define _CAR_OFST_LIST		0
#ADDR_define _CDR_OFST_LIST		1

#PSL_define s_AllocList	(dst_reg)
{
  b_Alloc2 (dst_reg, LIST);
}
 
#PSL_define s_ReclaimList (src_reg)
{
  b_Reclaim2 (src_reg);
}

#PSL_define s_GetCarList (list_ptr_reg, dst_reg)
{
  @DEBUG{
    s_IfNotLIST (list_ptr_reg){ VPIM_ERROR("s_GetCarList", "Illegal Type");}
    b_WarningIfSameRegNum (list_ptr_reg, dst_reg);
  };
  s_ReadWithOffsetMRBor (list_ptr_reg, _CAR_OFST_LIST, dst_reg);
}

#PSL_define s_GetCdrList (list_ptr_reg, dst_reg)
{
  @DEBUG{
    s_IfNotLIST (list_ptr_reg) {VPIM_ERROR("s_GetCdrList", "Illegal Type");}
    b_WarningIfSameRegNum (list_ptr_reg, dst_reg);
  };
  s_ReadWithOffsetMRBor (list_ptr_reg, _CDR_OFST_LIST, dst_reg);
}

#PSL_define s_PutCarList (list_ptr_reg, src_reg)
{
  @DEBUG{
    s_IfNotLIST (list_ptr_reg) {VPIM_ERROR ("s_PutCarList", "Illegal Type");}
    b_WarningIfSameRegNum (list_ptr_reg, src_reg);
  };
  p_WriteWithOffset (src_reg, list_ptr_reg, _CAR_OFST_LIST);
}

#PSL_define s_PutCdrList (list_ptr_reg, src_reg)
{
  @DEBUG{
    s_IfNotLIST (list_ptr_reg){ VPIM_ERROR ("s_PutCdrList", "Illegal Type");}
    b_WarningIfSameRegNum (list_ptr_reg, src_reg);
  };
  p_WriteWithOffset (src_reg, list_ptr_reg, _CDR_OFST_LIST);
}

#PSL_define s_CopyCarList(src_list_ptr, dst_list_ptr)
{
  $USE(D_WorkStructElem);
  s_GetCarList(src_list_ptr,D_WorkStructElem);
  s_PutCarList(dst_list_ptr,D_WorkStructElem);
  $RELEASE(D_WorkStructElem);
}

#PSL_define s_CopyCdrList(src_list_ptr, dst_list_ptr)
{
  $USE(D_WorkStructElem);
  s_GetCdrList(src_list_ptr,D_WorkStructElem);
  s_PutCdrList(dst_list_ptr,D_WorkStructElem);
  $RELEASE(D_WorkStructElem);
}

#SUBARG_define A_SrcPtr      SRC
#SUBARG_define A_DstPtr      SRC
#SUBARG_define A_CopyFlag    SRC

#SUBROUTINE s_CopyReuseElemList_Sub (A_SrcPtr, A_DstPtr, A_CopyFlag)
{
  b_IfEqualImm(A_CopyFlag, _ONE){ /* copyflag == b"00000001" */
    s_CopyStructElementWithOffset(A_SrcPtr, _CAR_OFST_LIST, A_DstPtr);
  } else {
    b_IfEqualImm(A_CopyFlag, _TWO){ /* copyflag == b"00000010" */
      s_CopyStructElementWithOffset(A_SrcPtr, _CDR_OFST_LIST, A_DstPtr);
    } else {
      b_IfEqualImm(A_CopyFlag, _THREE){ /* copyflag == b"00000011" */
        s_CopyStructElementWithOffset(A_SrcPtr, _CAR_OFST_LIST, A_DstPtr);
        s_CopyStructElementWithOffset(A_SrcPtr, _CDR_OFST_LIST, A_DstPtr);
      } else {
        @DEBUG{ VPIM_ERROR("s_CopyReuseElemList_Sub","Illegal_Copy_Flag"); };
      }
    }
  }
  $RETURN();
}

/******************************************************************** PSL **
  3.  $B9=B$BN6&DLA`:n(B
   3.1  $BMWAG$N%"%I%l%97W;;(B

       written by goto@icot22      Tue Jan 10 13:33:25 1989

<Arguments>
  str_ptr_reg : $B9=B$BN$X$N%]%$%s%?$r;}$D%l%8%9%?(B
  elm_pos_reg : $B%l%8%9%?$K$h$kMWAG0LCV;XDj(B
  		($B0LCVHV9f$G$"$j(B, $B%"%I%l%9$G$J$$$3$H$KCm0U(B)
  elm_addr_reg: $BMWAG$N%"%I%l%9$rJV$9%l%8%9%?(B

<Temporally Used Variables>
<Level> structures
<PreCondition>
<Function>
  s_GetStructElemAddrPosReg(str_ptr_reg, elm_pos_reg, elm_addr_reg)
    $BMWAGHV9f$+$i!"MWAG$N%"%I%l%9$r5a$a$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_GetStructElemAddrPosReg (str_ptr_reg, elm_pos_reg, elm_addr_reg)
{
  /** word-addressing machine $B$G$OI,MW$J$$!#(B**/
  b_ExchangeElmposToOffset(elm_pos_reg, elm_addr_reg);
  b_AddWithTag (str_ptr_reg, elm_addr_reg, elm_addr_reg);
  /** str_ptr_reg $B$N%?%0$r(B elm_addr_reg $B$N%?%0$H$7$FJ]B8$9$k!#(B **/
}

/******************************************************************** PSL **
   3.2  $B9=B$BNMWAG$N%3%T!<(B

       written by f-hataza@icot21      on Thu Nov  2 10:54:52 1989

<Arguments>
  src_str_ptr : $B%3%T!<85$N9=B$BN$X$N%]%$%s%?$r;}$D%l%8%9%?(B
  offset_reg :  $B%3%T!<$9$kMWAG$N%"%I%l%9%*%U%;%C%H$K$h$k0LCV;XDj(B($B%l%8%9%?(B)
  imm_offset :  $B%3%T!<$9$kMWAG$N%"%I%l%9%*%U%;%C%H$K$h$k0LCV;XDj(B($BB(CM(B)
  dst_str_ptr : $B%3%T!<@h$N9=B$BN$X$N%]%$%s%?$r;}$D%l%8%9%?(B

<Temporally Used Variables>
<Level> structures
<PreCondition>
<Function>
  s_CopyStructElementWithOffset(src_str_ptr, imm_offset, dst_str_ptr)
  s_CopyStructElementWithRegOffset(src_str_ptr, offset_reg, dst_str_ptr)
    src_str_ptr $B$N;X$99=B$BN$N!"(Bimm_offset($BB(CM(B)$B$^$?$O(B offset_reg($B%l%8%9%?(B)
    $B$G%*%U%;%C%H%"%I%l%9$r;XDj$5$l$kMWAG$r!"(Bdst_str_ptr $B$N@h$NF1$8%*%U%;%C%H(B
    $B$G;XDj$5$l$k0LCV$K%3%T!<$9$k!#(B
<Examples>
<Test>
<Explanation>
    $BBP>]$H$J$k9=B$BN$O!"%j%9%H!"%Y%/%?!"%9%H%j%s%0(B($B%o!<%IC10L$G%"%/%;%9$9$k;~(B)
    $B$N$$$:$l$+$G$"$k!#:FMxMQ;~$N%3%T!<$N>l9g$K$O!"%j%9%H!"%Y%/%?4V$G%3%T!<$,(B
    $B9T$J$o$l$k$3$H$b$"$k!#(B
<ETC>
********************************************************************* PSL **/
#DATA_define D_WorkStructElem  XXX
#DATA_define D_WorkElemAddr    XXX

#PSL_define s_CopyStructElementWithOffset(src_str_ptr, imm_offset, dst_str_ptr)
{
  @DEBUG{
    b_WarningIfSameRegNum (src_str_ptr, dst_str_ptr); 
    s_IfNotVectors(src_str_ptr) {
      s_IfNotLIST(src_str_ptr) {
	s_IfNotStrings(src_str_ptr){
	  VPIM_ERROR ("s_CopyStructElementOffsetReg", "Illegal struct type");
        }
      }
    }
  };
  $USE(D_WorkStructElem);
  s_ReadWithOffsetMRBor(src_str_ptr, imm_offset, D_WorkStructElem);
  p_WriteWithOffset(D_WorkStructElem, dst_str_ptr, imm_offset);
  $RELEASE(D_WorkStructElem);
}

#PSL_define s_CopyStructElementWithRegOffset
                                (src_str_ptr, offset_reg, dst_str_ptr)
{
  @DEBUG{
    b_WarningIfSameRegNum (src_str_ptr, dst_str_ptr); 
    s_IfNotVectors(src_str_ptr) {
      s_IfNotLIST(src_str_ptr) {
	s_IfNotStrings(src_str_ptr){
	  VPIM_ERROR ("s_CopyStructElementOffsetReg", "Illegal struct type");
        }
      }
    }
  };
  $USE(D_WorkElemAddr);
  $USE(D_WorkStructElem);
  b_AddWithTag(src_str_ptr, offset_reg, D_WorkElemAddr);
  s_ReadWithMRBor(D_WorkElemAddr, D_WorkStructElem);

  /* Tag of D_WorkElemAddr will be preserved */
  p_Add(dst_str_ptr, offset_reg, D_WorkElemAddr);

  p_Write(D_WorkStructElem, D_WorkElemAddr);
  $RELEASE(D_WorkStructElem);
  $RELEASE(D_WorkElemAddr);
}
