
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/structures/str_shoen_record.psl.c
   ----- CREATED   : by kawai@icot22, on Tue May 15 22:32:11 1990
   ----- LAST SAVED: by kawai@icot22, on Tue Mar  3 18:22:39 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : $B$3$N%U%!%$%k$G$O!"Aq1`%l%3!<%I$N7A<0$*$h$SAq1`%l%3!<%I$N(B
                     $B3F%9%m%C%H$K%"%/%;%9$9$k$?$a$N%^%/%m$,Dj5A$5$l$F$$$k!#(B


1. $BAq1`%l%3!<%I$N7A<0(B
   $BAq1`%l%3!<%I$O(B38$B%o!<%I$+$i$J$k9=B$BN$G$"$j!"$=$N3F%o!<%I$K$O0J2<$N$h$&$J%G(B
   $B!<%?$,3JG<$5$l$k!#(B

word0   lock_flag                   $B%?%0It(B:$BAq1`%l%3!<%IA4BN$N%m%C%/%U%i%0(B
                                    $B%P%j%e!<It(B:$BAq1`%l%3!<%I$N2rJ|M=Ls%U%i%0(B
word1   shoen_id                    $BAq1`<1JL(BID
word2   ptr_to_fp_record            $B?FN$?F%l%3!<%I$X$N%]%$%s%?(B
word3   ptr_to_right_brother_shoen  $B7;DoAq1`$X$N1&J}8~$N%j%s%/(B
word4   ptr_to_left_brother_shoen   $B7;DoAq1`$X$N:8J}8~$N%j%s%/(B
!!!  $B0J2<JQ99(B(4$B%o!<%I:o=|(B)  !!!
word5   ptr_to_report_stream        $B%l%]!<%H%9%H%j!<%`JQ?t$X$N%]%$%s%?(B
word6   31($B%?%0$O(Bcdesc)             GC$B;~%9%-%C%WMQ(B($B0J2<$N%9%m%C%H$N%?%0$O(BDNTC)
        !! $B$3$N%o!<%I<+BN$O4^$a$J$$?t$rF~$l$k(B !!
word7   shoen_status                $BAq1`$N>uBV(B
word8   min_priority                $BAq1`$,<h$jF@$k:G>.$NM%@hEY(B
word9   max_priority                $BAq1`$,<h$jF@$k:GBg$NM%@hEY(B
word10  exception_mask              $B%(%/%;%W%7%g%s%^%9%/%Q%?!<%s(B
!!!  $B0J2<JQ99(B(14$B%o!<%IA^F~(B)  !!!
word11  fp_table_u                  $BN$?F%F!<%V%k(B(32$B!A(B64)
word12  fp_table_l                  $BN$?F%F!<%V%k(B(0$B!A(B31)
word13  rsc_req_fp_table_u          $B;q8;MW5aN$?F%F!<%V%k(B(32$B!A(B64)
word14  rsc_req_fp_table_l          $B;q8;MW5aN$?F%F!<%V%k(B(0$B!A(B31)
word15  ready_terminate_cnt_0       ready/terminate$BDI$$1[$7%+%&%s%?(B(0$B!A(B7)
word16  ready_terminate_cnt_1       ready/terminate$BDI$$1[$7%+%&%s%?(B(8$B!A(B15)
word17  ready_terminate_cnt_2       ready/terminate$BDI$$1[$7%+%&%s%?(B(16$B!A(B23)
word18  ready_terminate_cnt_3       ready/terminate$BDI$$1[$7%+%&%s%?(B(24$B!A(B31)
word19  ready_terminate_cnt_4       ready/terminate$BDI$$1[$7%+%&%s%?(B(32$B!A(B39)
word20  ready_terminate_cnt_5       ready/terminate$BDI$$1[$7%+%&%s%?(B(40$B!A(B47)
word21  ready_terminate_cnt_6       ready/terminate$BDI$$1[$7%+%&%s%?(B(48$B!A(B55)
word22  ready_terminate_cnt_7       ready/terminate$BDI$$1[$7%+%&%s%?(B(56$B!A(B63)
word23  start_stop_bit_table_u      start/stop$B%S%C%H%F!<%V%k(B(32$B!A(B64)
word24  start_stop_bit_table_l      start/stop$B%S%C%H%F!<%V%k(B(0$B!A(B31)

word25  stat_hook                   $BL$JVEz$NE}7W>pJsMW5a?t(B
word26  stat_count                  $BE}7W>pJs$,L$JVEz$N;RN$?F?t(B
word27  ask_profile_FP_count        $B%W%m%U%!%$%k>pJs$,L$JVEz$N;RN$?F?t(B
word28  reported_profile_count      $B4{$K%l%]!<%H$7$?%W%m%U%!%$%k>pJs?t(B
word29  SH_total_ans_profile_count  $B%l%]!<%H$9$Y$-A4%W%m%U%!%$%k>pJs?t(B

word30  resource_consumed_u         $BAq1`$N>CHq;q8;NL(B($B>e0L(B)
word31  resource_consumed_l         $BAq1`$N>CHq;q8;NL(B($B2<0L(B)
word32  last_resource_consumed_u    $BA02s;q8;Js9p;~$NAq1`$N>CHq;q8;NL(B($B>e0L(B)
word33  last_resource_consumed_l    $BA02s;q8;Js9p;~$NAq1`$N>CHq;q8;NL(B($B2<0L(B)
word34  resource_left_u             $B;q8;$N;DNL(B($B>e0L(B)
word35  resource_left_l             $B;q8;$N;DNL(B($B2<0L(B)
word36  resource_limit_left_u       $B;q8;%j%_%C%H$^$G$N;DNL(B($B>e0L(B)
word37  resource_limit_left_l       $B;q8;%j%_%C%H$^$G$N;DNL(B($B2<0L(B)

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **

(1) $BDj?t$NDj5A(B

       written by kawai@icot22      on Thu May 17 16:18:00 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

/* !! $BAq1`%l%3!<%I%5%$%:(B */
#CONST_define  _SIZE_OF_SH_REC                      64  /* !! 32 */
#CONST_define  _VALID_SIZE_OF_SH_REC                38  /* !! 28 */
/* !! s_GCShoenRecord$B$+$i;2>H$5$l$F$$$k(B !! */

#CONST_define  _SH_REC_GC_SKIP_SIZE                 31  /* !! 17 CDSC$B%o!<%I$r(B
                                                           $B4^$^$J$$CM(B */

/* !! $BAq1`%l%3!<%I$N3F%9%m%C%H$N%*%U%;%C%H(B(Old)
#ADDR_define   _SH_LOCK_FLAG_OFST                   0
#ADDR_define   _SH_ID_OFST                          1
#ADDR_define   _PTR_TO_PARENT_FP_REC_OFST           2
#ADDR_define   _RIGHT_BROTHER_SH_LINK_OFST          3
#ADDR_define   _LEFT_BROTHER_SH_LINK_OFST           4
#ADDR_define   _PTR_TO_FP_TBL_OFST                  5
#ADDR_define   _PTR_TO_RSC_REQ_FP_TBL_OFST          6
#ADDR_define   _PTR_TO_REP_STREAM_OFST              7
#ADDR_define   _PTR_TO_READY_TERMINATE_CNT_OFST     8

#ADDR_define   _PTR_TO_START_STOP_BIT_TBL_OFST      9 /!* start/stop$BDI1[BP:v(B *!/

#ADDR_define   _SH_CDESC_OFST                       10
#ADDR_define   _SH_STATUS_OFST                      11
#ADDR_define   _SH_MIN_PRIO_OFST                    12
#ADDR_define   _SH_MAX_PRIO_OFST                    13
#ADDR_define   _SH_EXCEPTION_MASK_OFST              14
#ADDR_define   _SH_STAT_HOOK_OFST                   15
#ADDR_define   _SH_STAT_CNT_OFST                    16
/!* $BAq1`%l%3!<%I$N3F%9%m%C%H$N%*%U%;%C%H(B ($BDI2C(B) *!/
#ADDR_define   _SH_ASK_PROF_FP_CNT_OFST             17
#ADDR_define   _SH_REPTED_PROF_CNT_OFST             18
#ADDR_define   _SH_TOTAL_ANS_PROF_CNT_OFST          19

/!* $BAq1`%l%3!<%I$N3F%9%m%C%H$N%*%U%;%C%H(B ($BJQ99(B) *!/
#ADDR_define   _SH_RSC_CONSUMED_UPPER_OFST          20
#ADDR_define   _SH_RSC_CONSUMED_LOWER_OFST          21
#ADDR_define   _SH_LAST_RSC_CONSUMED_UPPER_OFST     22
#ADDR_define   _SH_LAST_RSC_CONSUMED_LOWER_OFST     23
#ADDR_define   _SH_RSC_LEFT_UPPER_OFST              24
#ADDR_define   _SH_RSC_LEFT_LOWER_OFST              25
#ADDR_define   _SH_RSC_LIMIT_LEFT_UPPER_OFST        26
#ADDR_define   _SH_RSC_LIMIT_LEFT_LOWER_OFST        27
*/

/* !! $BAq1`%l%3!<%I$N3F%9%m%C%H$N%*%U%;%C%H(B(New) */
#ADDR_define   _SH_LOCK_FLAG_OFST                   0
#ADDR_define   _SH_ID_OFST                          1
#ADDR_define   _PTR_TO_PARENT_FP_REC_OFST           2
#ADDR_define   _RIGHT_BROTHER_SH_LINK_OFST          3
#ADDR_define   _LEFT_BROTHER_SH_LINK_OFST           4
#ADDR_define   _PTR_TO_REP_STREAM_OFST              5
#ADDR_define   _SH_CDESC_OFST                       6
#ADDR_define   _SH_STATUS_OFST                      7
#ADDR_define   _SH_MIN_PRIO_OFST                    8
#ADDR_define   _SH_MAX_PRIO_OFST                    9
#ADDR_define   _SH_EXCEPTION_MASK_OFST              10

#ADDR_define   _PTR_TO_FP_TBL_UPPER_OFST            11
#ADDR_define   _PTR_TO_FP_TBL_LOWER_OFST            12
#ADDR_define   _PTR_TO_RSC_REQ_FP_TBL_UPPER_OFST    13
#ADDR_define   _PTR_TO_RSC_REQ_FP_TBL_LOWER_OFST    14
#ADDR_define   _PTR_TO_READY_TERMINATE_CNT_OFST     15 /* 8$B%o!<%ID9(B */
#ADDR_define   _PTR_TO_START_STOP_BIT_TBL_UPPER_OFST 23
#ADDR_define   _PTR_TO_START_STOP_BIT_TBL_LOWER_OFST 24

#ADDR_define   _SH_STAT_HOOK_OFST                   25
#ADDR_define   _SH_STAT_CNT_OFST                    26
#ADDR_define   _SH_ASK_PROF_FP_CNT_OFST             27
#ADDR_define   _SH_REPTED_PROF_CNT_OFST             28
#ADDR_define   _SH_TOTAL_ANS_PROF_CNT_OFST          29
#ADDR_define   _SH_RSC_CONSUMED_UPPER_OFST          30
#ADDR_define   _SH_RSC_CONSUMED_LOWER_OFST          31
#ADDR_define   _SH_LAST_RSC_CONSUMED_UPPER_OFST     32
#ADDR_define   _SH_LAST_RSC_CONSUMED_LOWER_OFST     33
#ADDR_define   _SH_RSC_LEFT_UPPER_OFST              34
#ADDR_define   _SH_RSC_LEFT_LOWER_OFST              35
#ADDR_define   _SH_RSC_LIMIT_LEFT_UPPER_OFST        36
#ADDR_define   _SH_RSC_LIMIT_LEFT_LOWER_OFST        37


/******************************************************************** PSL **

(2) $BAq1`%l%3!<%I$N3d$jEv$F$H2rJ|(B

       written by kawai@icot22      on Fri May 18 17:46:15 1990
<Arguments>
  shoen_record : $BAq1`%l%3!<%I$X$N%]%$%s%?(B
<Temporally Used Variables>
  D_FreeSHRECPtr : $B%U%j!<%j%9%H4IM}$5$l$F$$$kAq1`%l%3!<%I(B(= 32$B%o!<%I$N(B
                        $B9=B$BN$HF1$8(B)$B$N@hF,$r0l;~J];}$9$k%l%8%9%?(B
<Level>
<PreCondition>
<Function>
  $BAq1`%l%3!<%IMQ$N9=B$BN$N3d$jEv$F(B/$B2rJ|$r9T$&!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define  D_FreeSHRECPtr  D_Free_64_PtrReg  /* !! D_Free_32_PtrReg */

#PSL_define  s_AllocShoenRecord(shoen_record)
{
  b_AllocN(shoen_record, D_FreeSHRECPtr, _SIZE_OF_SH_REC, SHREC);
  b_DecrementAddrReg(shoen_record);	/* $B%]%$%s%?$r(B1$B%o!<%IL\$K0\F0$9$k(B */
}



#PSL_define  s_ReclaimShoenRecord(shoen_record)
{
  b_IncrementAddrReg(shoen_record);    /*  $B%]%$%s%?$r(B0$B%o!<%IL\$K0\F0$9$k(B */
  b_ReclaimN(shoen_record, D_FreeSHRECPtr, _SIZE_OF_SH_REC);
}

/******************************************************************** PSL **

(3) $BAq1`$N3F%9%m%C%H$X$N%G!<%?3JG<$r9T$J$&%^%/%m(B

       written by kawai@icot22      on Fri May 18 17:58:56 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  s_PutShoenLockFlag(shoen_record, lock_flag_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutShoenLockFlag","Not SHREC Type"); }};

  p_WriteWithOffset(lock_flag_reg, shoen_record, _SH_LOCK_FLAG_OFST);
}



#PSL_define  s_PutShoenId(shoen_record, shoen_id_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutShoenId","Not SHREC Type"); }};

  p_WriteWithOffset(shoen_id_reg, shoen_record, _SH_ID_OFST);
}



#PSL_define  s_PutFPRecordOfShoen(shoen_record, fp_rec_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutFPRecordOfShoen","Not SHREC Type");}};

  p_WriteWithOffset(fp_rec_reg, shoen_record, _PTR_TO_PARENT_FP_REC_OFST);
}



#PSL_define  s_PutRightBrotherShoenLink(shoen_record, brother_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutRightBrotherShoenLink","Not SHREC Type");}};

  p_WriteWithOffset(brother_reg, shoen_record, _RIGHT_BROTHER_SH_LINK_OFST);
}



#PSL_define  s_PutLeftBrotherShoenLink(shoen_record, brother_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutLeftBrotherShoenLink","Not SHREC Type");}};

  p_WriteWithOffset(brother_reg, shoen_record, _LEFT_BROTHER_SH_LINK_OFST);
}



#PSL_define  s_PutShoenReportStream(shoen_record, rep_stream_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutShoenReportStream","Not SHREC Type");}};

  p_WriteWithOffset(rep_stream_reg, shoen_record, _PTR_TO_REP_STREAM_OFST);
}



#PSL_define  s_PutShoenCDESC(shoen_record, cdesc_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutShoenCDESC","Not SHREC Type");}};

  p_WriteWithOffset(cdesc_reg, shoen_record, _SH_CDESC_OFST);
}



/* $B0J2<$N%9%m%C%H$KCM$r3JG<$9$k>l9g$K$O!"%?%0$O(B DNTC $B$H$J$k(B */

#PSL_define  s_PutShoenStatus(shoen_record, shoen_status_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutShoenStatus","Not SHREC Type"); }};

  b_WriteDNTCWithOffset(shoen_status_reg, shoen_record, _SH_STATUS_OFST);
}



#PSL_define  s_PutShoenMinPriority(shoen_record, min_prio_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutShoenMinPriority","Not SHREC Type");}};

  b_WriteDNTCWithOffset(min_prio_reg, shoen_record, _SH_MIN_PRIO_OFST);
}



#PSL_define  s_PutShoenMaxPriority(shoen_record, max_prio_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutShoenMaxPriority","Not SHREC Type");}};

  b_WriteDNTCWithOffset(max_prio_reg, shoen_record, _SH_MAX_PRIO_OFST);
}



#PSL_define  s_PutShoenExceptionMask(shoen_record, ex_mask_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutShoenExceptionMask","Not SHREC Type");}};

  b_WriteDNTCWithOffset(ex_mask_reg, shoen_record, _SH_EXCEPTION_MASK_OFST);
}


/* Original
#PSL_define  s_PutFPTable(shoen_record, fp_table_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutFPTable","Not SHREC Type");}};

  p_WriteWithOffset(fp_table_reg, shoen_record, _PTR_TO_FP_TBL_OFST);
}
*/

/* !! */
#PSL_define  s_PutFPTable(shoen_record, fp_table_upper, fp_table_lower)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutFPTable","Not SHREC Type");}};

  b_WriteDNTCWithOffset(fp_table_upper, shoen_record,
			                _PTR_TO_FP_TBL_UPPER_OFST);
  b_WriteDNTCWithOffset(fp_table_lower, shoen_record,
			                _PTR_TO_FP_TBL_LOWER_OFST);
}

/* Original
#PSL_define  s_PutResourceRequestFPTable(shoen_record, res_req_fptable_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutResourceRequestFPTable","Not SHREC Type");}};

  p_WriteWithOffset(res_req_fptable_reg, shoen_record,
		                           _PTR_TO_RSC_REQ_FP_TBL_OFST);
}
*/

/* !! */
#PSL_define  s_PutResourceRequestFPTable(shoen_record, res_req_fptable_upper,
					               res_req_fptable_lower)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutResourceRequestFPTable","Not SHREC Type");}};

  b_WriteDNTCWithOffset(res_req_fptable_upper, shoen_record,
		                           _PTR_TO_RSC_REQ_FP_TBL_UPPER_OFST);
  b_WriteDNTCWithOffset(res_req_fptable_lower, shoen_record,
		                           _PTR_TO_RSC_REQ_FP_TBL_LOWER_OFST);
}


/* Original
#PSL_define  s_PutShoenReadyTerminateCounter(shoen_record, counter_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutShoenReadyTerminateCounter","Not SHREC Type");}};

  p_WriteWithOffset(counter_reg, shoen_record,
		                         _PTR_TO_READY_TERMINATE_CNT_OFST);
}
*/

/* !! $BGQ;_(B
   $B=i4|2=;~$O(B
     s_InitShoenReadyTerminateCounter(shoen_record)
   $B$rMQ$$$k!#(B
*/

/* Original
#PSL_define  s_PutShoenStartStopBitTable(shoen_record, bit_table)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutShoenStartStopBitTable","Not SHREC Type");}};

  p_WriteWithOffset(bit_table, shoen_record,
		                         _PTR_TO_START_STOP_BIT_TBL_OFST);
}
*/



/* !! */
#PSL_define  s_PutShoenStartStopBitTable(shoen_record, bit_table_upper,
					               bit_table_lower)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutShoenStartStopBitTable","Not SHREC Type");}};

  b_WriteDNTCWithOffset(bit_table_upper, shoen_record,
		                     _PTR_TO_START_STOP_BIT_TBL_UPPER_OFST);
  b_WriteDNTCWithOffset(bit_table_lower, shoen_record,
		                     _PTR_TO_START_STOP_BIT_TBL_LOWER_OFST);
}


#PSL_define  s_PutStatHook(shoen_record, stat_hook_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutStatHook","Not SHREC Type");}};

  b_WriteDNTCWithOffset(stat_hook_reg, shoen_record, _SH_STAT_HOOK_OFST);
}



#PSL_define  s_PutStatCount(shoen_record, stat_count_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutStatCount","Not SHREC Type");}};

  b_WriteDNTCWithOffset(stat_count_reg, shoen_record, _SH_STAT_CNT_OFST);
}




/* $BDI2C(B */
#PSL_define  s_PutAskProfileFPCount(shoen_record, profile_cnt_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutAskProfileFPCount","Not SHREC Type"); }};

  b_WriteDNTCWithOffset(profile_cnt_reg, shoen_record,
		                                  _SH_ASK_PROF_FP_CNT_OFST);
}


/* $BDI2C(B */
#PSL_define  s_PutReportedProfileCount(shoen_record, rept_prof_cnt_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutAskProfileFPCount","Not SHREC Type"); }};

  b_WriteDNTCWithOffset(rept_prof_cnt_reg, shoen_record,
		                                  _SH_REPTED_PROF_CNT_OFST);
}


/* $BDI2C(B */
#PSL_define  s_PutSHTotalAnsProfileCount(shoen_record, total_ans_prof_cnt_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutSHTotalAnsProfileCount","Not SHREC Type"); }};

  b_WriteDNTCWithOffset(total_ans_prof_cnt_reg, shoen_record,
		                                 _SH_TOTAL_ANS_PROF_CNT_OFST);
}



#PSL_define  s_PutShoenResourceConsumed(shoen_record, consumed_res_upper_reg,
					                consumed_res_lower_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutShoenResourceConsumed","Not SHREC Type");}};

  b_WriteDNTCWithOffset(consumed_res_upper_reg, shoen_record,
		                                _SH_RSC_CONSUMED_UPPER_OFST);
  b_WriteDNTCWithOffset(consumed_res_lower_reg, shoen_record,
		                                _SH_RSC_CONSUMED_LOWER_OFST);
}


#PSL_define  s_PutShoenLastResourceConsumed(shoen_record,
					      last_res_consumed_upper_reg,
					         last_res_consumed_lower_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutShoenLastResourceConsumed","Not SHREC Type");}};

  b_WriteDNTCWithOffset(last_res_consumed_upper_reg, shoen_record,
		                            _SH_LAST_RSC_CONSUMED_UPPER_OFST);
  b_WriteDNTCWithOffset(last_res_consumed_lower_reg, shoen_record,
		                            _SH_LAST_RSC_CONSUMED_LOWER_OFST);
}


#PSL_define  s_PutShoenResourceLeft(shoen_record, res_left_upper_reg,
					                res_left_lower_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutShoenResourceLeft","Not SHREC Type");}};

  b_WriteDNTCWithOffset(res_left_upper_reg, shoen_record,
		                                   _SH_RSC_LEFT_UPPER_OFST);
  b_WriteDNTCWithOffset(res_left_lower_reg, shoen_record,
		                                   _SH_RSC_LEFT_LOWER_OFST);
}


#PSL_define  s_PutShoenResourceLimitLeft(shoen_record,
					       res_limit_left_upper_reg,
					           res_limit_left_lower_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutShoenResourceLimitLeft","Not SHREC Type");}};

  b_WriteDNTCWithOffset(res_limit_left_upper_reg, shoen_record,
		                              _SH_RSC_LIMIT_LEFT_UPPER_OFST);
  b_WriteDNTCWithOffset(res_limit_left_lower_reg, shoen_record,
		                              _SH_RSC_LIMIT_LEFT_LOWER_OFST);
}

/******************************************************************** PSL **

(4) $BAq1`%l%3!<%I$N3F%9%m%C%H$+$iCM$r<h$j=P$9%^%/%m(B

       written by kawai@icot22      on Mon May 21 14:06:24 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  s_GetShoenId(shoen_record, shoen_id_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetShoenId","Not SHREC Type");}};

  p_ReadWithOffset(shoen_record, _SH_ID_OFST, shoen_id_reg);
  b_SetImmTypeMRBoff(BEXVAL, shoen_id_reg);
}



#PSL_define  s_GetShoenLockFlag(shoen_record, lock_flag_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetShoenLockFlag","Not SHREC Type");}};

  p_ReadWithOffset(shoen_record, _SH_LOCK_FLAG_OFST, lock_flag_reg);
}



#PSL_define  s_GetFPRecordOfShoen(shoen_record, fp_record_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetFPRecordOfShoen","Not SHREC Type");}};

  p_ReadWithOffset(shoen_record, _PTR_TO_PARENT_FP_REC_OFST, fp_record_reg);
}



#PSL_define  s_GetRightBrotherShoenLink(shoen_record, brother_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetRightBrotherShoenLink","Not SHREC Type");}};

  p_ReadWithOffset(shoen_record, _RIGHT_BROTHER_SH_LINK_OFST, brother_reg);
}



#PSL_define  s_GetLeftBrotherShoenLink(shoen_record, brother_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetLeftBrotherShoenLink","Not SHREC Type");}};

  p_ReadWithOffset(shoen_record, _LEFT_BROTHER_SH_LINK_OFST, brother_reg);
}



#PSL_define  s_GetShoenReportStream(shoen_record, rep_stream_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetShoenReportStream","Not SHREC Type");}};

  p_ReadWithOffset(shoen_record, _PTR_TO_REP_STREAM_OFST, rep_stream_reg);
}



#PSL_define  s_GetShoenStatus(shoen_record, shoen_status_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetShoenStatus","Not SHREC Type");}};

  p_ReadWithOffset(shoen_record, _SH_STATUS_OFST, shoen_status_reg);
}


#PSL_define  s_GetShoenMinPriority(shoen_record, min_prio_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetShoenMinPriority","Not SHREC Type");}};

  p_ReadWithOffset(shoen_record, _SH_MIN_PRIO_OFST, min_prio_reg);
}


#PSL_define  s_GetShoenMaxPriority(shoen_record, max_prio_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetShoenMaxPriority","Not SHREC Type");}};

  p_ReadWithOffset(shoen_record, _SH_MAX_PRIO_OFST, max_prio_reg);
}


#PSL_define  s_GetShoenExceptionMask(shoen_record, ex_mask_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetShoenExceptionMask","Not SHREC Type");}};

  p_ReadWithOffset(shoen_record, _SH_EXCEPTION_MASK_OFST, ex_mask_reg);
}


/* Original
#PSL_define  s_GetFPTable(shoen_record, fp_table_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetFPTable","Not SHREC Type");}};

  p_ReadWithOffset(shoen_record, _PTR_TO_FP_TBL_OFST, fp_table_reg);
}
*/

/* !! */
#PSL_define  s_GetFPTable(shoen_record, fp_table_upper, fp_table_lower)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetFPTable","Not SHREC Type");}};

  p_ReadWithOffset(shoen_record, _PTR_TO_FP_TBL_UPPER_OFST, fp_table_upper);
  p_ReadWithOffset(shoen_record, _PTR_TO_FP_TBL_LOWER_OFST, fp_table_lower);
}


/* Original
#PSL_define  s_GetResourceRequestFPTable(shoen_record, res_req_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetResourceRequestFPTable","Not SHREC Type");}};

  p_ReadWithOffset(shoen_record, _PTR_TO_RSC_REQ_FP_TBL_OFST, res_req_reg);
}
*/

/* !! */
#PSL_define  s_GetResourceRequestFPTable(shoen_record, res_req_upper,
					               res_req_lower)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetResourceRequestFPTable","Not SHREC Type");}};

  p_ReadWithOffset(shoen_record, _PTR_TO_RSC_REQ_FP_TBL_UPPER_OFST,
		                                          res_req_upper);
  p_ReadWithOffset(shoen_record, _PTR_TO_RSC_REQ_FP_TBL_LOWER_OFST,
		                                          res_req_lower);
}


#PSL_define  s_GetStatHook(shoen_record, stat_hook_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetStatHook","Not SHREC Type");}};

  p_ReadWithOffset(shoen_record, _SH_STAT_HOOK_OFST, stat_hook_reg);
}



#PSL_define  s_GetStatCount(shoen_record, stat_count_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetStatCount","Not SHREC Type");}};

  p_ReadWithOffset(shoen_record, _SH_STAT_CNT_OFST, stat_count_reg);
}


/* Original
#PSL_define  s_GetShoenReadyTerminateCounter(shoen_record, counter_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetShoenReadyTerminateCounter","Not SHREC Type");}};

  p_ReadWithOffset(shoen_record, _PTR_TO_READY_TERMINATE_CNT_OFST,
		                                                counter_reg);
}
*/

/* !! $BGQ;_(B */


#PSL_define  s_GetShoenResourceConsumed(shoen_record, consumed_res_upper_reg,
					                consumed_res_lower_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetShoenResourceConsumed","Not SHREC Type");}};

  p_ReadWithOffset(shoen_record, _SH_RSC_CONSUMED_UPPER_OFST, 
		                                    consumed_res_upper_reg);
  p_ReadWithOffset(shoen_record, _SH_RSC_CONSUMED_LOWER_OFST,
		                                    consumed_res_lower_reg);
}


#PSL_define  s_GetShoenLastResourceConsumed(shoen_record,
					      last_res_consumed_upper_reg,
					         last_res_consumed_lower_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetShoenLastResourceConsumed","Not SHREC Type");}};

  p_ReadWithOffset(shoen_record, _SH_LAST_RSC_CONSUMED_UPPER_OFST,
		                                last_res_consumed_upper_reg);
  p_ReadWithOffset(shoen_record, _SH_LAST_RSC_CONSUMED_LOWER_OFST,
		                                last_res_consumed_lower_reg);
}


#PSL_define  s_GetShoenResourceLeft(shoen_record, res_left_upper_reg,
					                res_left_lower_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetShoenResourceLeft","Not SHREC Type");}};

  p_ReadWithOffset(shoen_record, _SH_RSC_LEFT_UPPER_OFST, res_left_upper_reg);
  p_ReadWithOffset(shoen_record, _SH_RSC_LEFT_LOWER_OFST, res_left_lower_reg);
}


#PSL_define  s_GetShoenResourceLimitLeft(shoen_record,
					       res_limit_left_upper_reg,
					           res_limit_left_lower_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetShoenResourceLimitLeft","Not SHREC Type");}};

  p_ReadWithOffset(shoen_record, _SH_RSC_LIMIT_LEFT_UPPER_OFST,
		                                   res_limit_left_upper_reg);
  p_ReadWithOffset(shoen_record, _SH_RSC_LIMIT_LEFT_LOWER_OFST,
		                                   res_limit_left_lower_reg);
}

/* !! Original
#PSL_define  s_GetShoenStartStopBitTable(shoen_record, bit_table)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetShoenStartStopBitTable","Not SHREC Type");}};

  p_ReadWithOffset(shoen_record, _PTR_TO_START_STOP_BIT_TBL_OFST, bit_table);
}
*/

/* !! */
#PSL_define  s_GetShoenStartStopBitTable(shoen_record,
					       table_upper, table_lower)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetShoenStartStopBitTable","Not SHREC Type");}};

  p_ReadWithOffset(shoen_record, _PTR_TO_START_STOP_BIT_TBL_UPPER_OFST,
		                                                table_upper);
  p_ReadWithOffset(shoen_record, _PTR_TO_START_STOP_BIT_TBL_LOWER_OFST,
		                                                table_lower);
}


/* $BDI2C(B */
#PSL_define  s_GetAskProfileFPCount(shoen_record, profile_cnt_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetAskProfileFPCount","Not SHREC Type"); }};

  p_ReadWithOffset(shoen_record, _SH_ASK_PROF_FP_CNT_OFST, profile_cnt_reg);
}


/* $BDI2C(B */
#PSL_define  s_GetReportedProfileCount(shoen_record, rept_prof_cnt_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetAskProfileFPCount","Not SHREC Type"); }};

  p_ReadWithOffset(shoen_record, _SH_REPTED_PROF_CNT_OFST, rept_prof_cnt_reg);
}


/* $BDI2C(B */
#PSL_define  s_GetSHTotalAnsProfileCount(shoen_record, total_ans_prof_cnt_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetSHTotalAnsProfileCount","Not SHREC Type"); }};

  p_ReadWithOffset(shoen_record, _SH_TOTAL_ANS_PROF_CNT_OFST,
		                                      total_ans_prof_cnt_reg);
}
