
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/structures/str_shoen_rec_ope.psl.c
   ----- CREATED   : by kawai@icot22, on Thu May 24 15:07:03 1990
   ----- LAST SAVED: by kawai@icot22, on Thu Apr 30 12:05:17 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : $B$3$N%U%!%$%k$G$O!"Aq1`$N>uBV$*$h$SAq1`%l%3!<%I$N?'!9$J(B
                     $B%9%m%C%H$K3JG<$5$l$F$$$k%G!<%?$KBP$9$kA`:n$N$?$a$N%^%/%m(B
                     $B$,Dj5A$5$l$F$$$k!#(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **

(1) $BDj?t$NDj5A(B

       written by kawai@icot22      on Thu May 24 15:07:47 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/


/* $B;q8;$N6!5kC10L$O(B f_fp_main.psl.c $B$K0\$7$?!#(B90-10-01 reki */

/* $BAq1`$N<oN`(B  */
#CONST_define  _ORDINARY_SHOEN                      0x00000000
#CONST_define  _PROFILING_SHOEN                     0x00000001

/* $BAq1`$*$h$SN$?F$NA+0\>uBV(B */
#CONST_define  _STARTED                             0x00000000
#CONST_define  _STOPPED_BY_CTRL                     0x00000001
#CONST_define  _STOPPED_BY_PARENT                   0x00000002
#CONST_define  _STOPPED_BY_BOTH                     0x00000003
#CONST_define  _ABORTED                             0x00000004
#CONST_define  _TERMINATED                          0x00000005

/* !!! VOID$BAq1`GQ;_$K$H$b$J$$:o=|(B !!!
#CONST_define  _VOID_SHOEN                          0x0000000f
*/

/* $BAq1`$N>uBV%U%i%0%^%9%/(B */
#CONST_define  _RSC_REP_DISALLOWED_FLAG_MASK        0x00000100
#CONST_define  _NO_MORE_EXTERNAL_EVENT_FLAG_MASK    0x00000200
#CONST_define  _RSC_REQ_FP_EXISTANCE_FLAG_MASK      0x00000400

#CONST_define  _PROFILING_SHOEN_FLAG_MASK           0x00010000
#CONST_define  _PROFILING_PARENT_SHOEN_FLAG_MASK    0x00020000


/* $B3F<o>uBV%U%i%0%j%;%C%HMQ$N%Q%?!<%s(B*/
#CONST_define  _FLAG_RESET_PATTERN                  _ZERO

/* $BA+0\>uBV$K%"%/%;%9$9$k;~$KMQ$$$k%^%9%/(B */
#CONST_define  _TRANSIT_STATUS_MASK                 0x000000ff

/* $BAq1`$N%l%]!<%H%9%H%j!<%`$KJV$5$l$kCM(B */
#CONST_define  _STARTED_REP                         0x00000001
#CONST_define  _STOPPED_REP                         0x00000002
#CONST_define  _ABORTED_REP                         0x00000003
#CONST_define  _RSC_ADDED_REP                       0x00000004
#CONST_define  _STAT_STARTED_REP                    0x00000005
#CONST_define  _RSC_REP_ALLOWED_REP                 0x00000006
#CONST_define  _TERMINATED_REP                      0x00000007
#CONST_define  _RSC_LOW_REP                         0x00000008
#CONST_define  _STAT_REP                            0x00000009
#CONST_define  _RETURN_RSC_REP                      0x0000000a

#CONST_define  _PROF_STARTED_REP                    0x00000010
#CONST_define  _PROF_REJECTED_REP                   0x00000011
#CONST_define  _PROF_COMPLETED_REP                  0x00000012
#CONST_define  _PROF_INFO_REP                       0x00000013

#CONST_define  _EXCEPTION_REP                       100

/* FPTable$BN`A`:nMQ(B */
#CONST_define  _WORD_BIT_LENGTH                     32
#CONST_define  _HALF_WORD_BIT_LENGTH                16

/* StatHook$B$N2<0L(B16$B%S%C%H$X$N2C8:;;MQ(B */
#CONST_define  _LOWER_STAT_HOOK_CNT_MASK            0x0000ffff

/* StatHook$B$N>e0L(B16$B%S%C%H$X$N2C8:;;MQ(B */
#CONST_define  _UPPER_STAT_HOOK_CNT_UNIT            0x00010000
#CONST_define  _UPPER_STAT_HOOK_CNT_MASK            0xffff0000

/* $BAq1`%l%3!<%I$rN$?F$N;RAq1`%j%s%/$+$i=|$/;~$NM=LsMQ(B */
#CONST_define  _UNHOOK_NONRESERVED                  _ZERO
#CONST_define  _UNHOOK_RESERVED                     _ONE

#CONST_define  _INIT_READY_TERMINATE_COUNTER_VALUE  0x77777777
#CONST_define  _READY_TERMINATE_COUNTER_MASK_PATTERN  0x0000000f
#CONST_define  _READY_TERMINATE_COUNTER_PER_WORD    8
#CONST_define  _READY_TERMINATE_COUNTER_BASE        7
#CONST_define  _READY_TERMINATE_COUNTER_SHIFT_UNIT  4

/* For Debug */
#CONST_define  _READY_TERMINATE_COUNTER_LIMIT       15



/* $BAq1`%l%3!<%I%m%C%/MQ$N:n6HMQ%l%8%9%?(B */
#DATA_define  D_WorkShoenOrgLockTagReg  XXX

/* $BAq1`%G!<%?A`:n;~$N%o!<%/%l%8%9%?(B */
#DATA_define  D_WorkShoenTempReg1  XXX
#DATA_define  D_WorkShoenTempReg2  XXX
#DATA_define  D_WorkShoenTempReg3  XXX
#DATA_define  D_WorkShoenTempReg4  XXX
#DATA_define  D_WorkShoenTempReg5  XXX


/******************************************************************** PSL **

(2) $BAq1`$N3F%9%m%C%H$X$N%G!<%?A`:n$r9T$J$&%^%/%m(B

       written by kawai@icot22      on Fri May 18 20:43:43 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
  $B$=$l$>$l$N%^%/%m8F$S$@$785$GAq1`$K%=%U%H%m%C%/$r3]$1$F$*$/$3$H!#(B
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/


/******************************************************************** PSL **

(2.1) $BAq1`$N%U%i%05Z$SA+0\>uBV$rA`:n$9$k%^%/%m(B

       written by kawai@icot22      on Thu May 24 21:21:20 1990
<Arguments>
  shoen_record : $BAq1`%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
  imm_status : $BAq1`$NA+0\>uBV(B($BB(CM(B)
  imm_mask : $BAq1`$NA+0\>uBVA`:nMQ%^%9%/(B($BB(CM(B)
  imm_flag : $BAq1`$N%U%i%0(B($BB(CM(B)
  imm_flag_mask : $BAq1`$N%U%i%0A`:nMQ%^%9%/(B($BB(CM(B)
  transit_status_reg : $BAq1`$NA+0\>uBV(B($B=PNO(B)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $BAq1`$N%U%i%05Z$SA+0\>uBV$rA`:n$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/


#PSL_define  s_PutShoenTransitStatusImmediately(shoen_record, imm_status)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_PutShoenTransitStatusImmediately","Not SHREC Type"); }};

  s_SetShoenAnyFlags(shoen_record, _TRANSIT_STATUS_MASK, imm_status);
}



#PSL_define  s_SetShoenStatusFlag(shoen_record, imm_mask)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_SetShoenStatusFlag","Not SHREC Type"); }};

  s_SetShoenAnyFlags(shoen_record, imm_mask, imm_mask);
}



#PSL_define  s_ResetShoenStatusFlag(shoen_record, imm_mask)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_SetShoenStatusFlag","Not SHREC Type"); }};

  s_SetShoenAnyFlags(shoen_record, imm_mask, _FLAG_RESET_PATTERN);
}


#PSL_define  s_SetShoenAnyFlags(shoen_record, imm_mask, imm_flag)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_SetShoenAnyFlags","Not SHREC Type"); }};

  $USE(D_WorkShoenTempReg1);
  s_GetShoenStatus(shoen_record, D_WorkShoenTempReg1);
  b_ReplaceBitField(D_WorkShoenTempReg1, imm_mask, imm_flag);
  s_PutShoenStatus(shoen_record, D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg1);
}



#PSL_define  s_GetShoenTransitStatus(shoen_record, transit_status_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetShoenLogicalStatus","Not SHREC Type"); }};

  s_GetShoenStatusFlag(shoen_record, _TRANSIT_STATUS_MASK, transit_status_reg);
}



#PSL_define  s_GetShoenStatusFlag(shoen_record, imm_flag_mask, flag_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetShoenStatusFlag","Not SHREC Type"); }};

  s_GetShoenStatus(shoen_record, flag_reg);
  b_ExtractBitField(flag_reg, imm_flag_mask, flag_reg);
}


/******************************************************************** PSL **

(2.2) $BAq1`$N%m%C%/A`:n$N$?$a$N%^%/%m(B

       written by kawai@icot22      on Fri May 18 17:59:39 1990
<Arguments>
  shoen_record : $BAq1`%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
  org_tag_reg : $B%m%C%/$7$?%o!<%I$N%*%j%8%J%k$N%?%0$rJV$9%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $BAq1`%l%3!<%IA4BN$N%=%U%H%&%'%"%m%C%/%U%i%0$r%*%s(B($B%m%C%/>uBV(B)$B$H$9$k!#(B
  $B4{$K%m%C%/$5$l$F$$$kAq1`%l%3!<%I$KBP$7$F$3$N%^%/%m$r<B9T$9$k$H!"$=$NAq1`%l%3(B
$B!<%I$,%"%s%m%C%/$5$l$k$^$G%^%/%m$r<B9T$7$?(BPE$B$O%S%8!<%&%'%$%H$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  s_LockShoenRecord(shoen_record, org_tag_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_LockShoenRecord","Not SHREC Type"); }};

  b_SoftLockWithOrgTag(shoen_record, _SH_LOCK_FLAG_OFST, org_tag_reg);
}



#PSL_define  s_UnlockShoenRecord(shoen_record, org_tag_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_UnlockShoenRecord","Not SHREC Type"); }};

  b_SoftUnlockWithOrgTag(shoen_record, _SH_LOCK_FLAG_OFST, org_tag_reg);
}

/******************************************************************** PSL **

(2.3) $BAq1`$N:o=|M=Ls%U%i%0$NA`:nMQ%^%/%m(B

       written by kawai@icot22      on Fri May 18 19:13:58 1990
<Arguments>
  shoen_record : $BAq1`%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
 D_WorkShoenTempReg1 : $BAq1`%l%3!<%I$r%j%s%/$+$i30$9$?$a$NM=Ls:Q$_%U%i%0$r0l;~(B
                       $BJ];}$9$k%l%8%9%?(B
 D_WorkShoenTempReg2 : $BAq1`%l%3!<%I$r%j%s%/$+$i30$9$?$a$NL$M=Ls%U%i%0$r0l;~(B
                       $BJ];}$9$k%l%8%9%?(B
<Level>
<PreCondition>
  $B8F$S$@$785$GAq1`%l%3!<%I$K%m%C%/$r3]$1$F$*$/$3$H!#(B
<Function>
  $BAq1`%l%3!<%I$r?FN$?F$N;RAq1`%j%s%/$+$i30$9$?$a$NM=Ls%U%i%0$rN)$F$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  s_ReserveUnhookShoenRecord(shoen_record)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_ReserveUnhookShoenRecord","Not SHREC Type"); }};

  $USE(D_WorkShoenTempReg1);
  s_GetShoenLockFlag(shoen_record, D_WorkShoenTempReg1);
  p_SetImmediateValue(_UNHOOK_RESERVED, D_WorkShoenTempReg1);
  s_PutShoenLockFlag(shoen_record, D_WorkShoenTempReg1);
    /* $BAq1`%l%3!<%I$N%m%C%/%U%i%0%o!<%I$N%?%0(B(SLOCK)$B$rJ]B8$9$kI,MW$,$"$k$?$a(B
       $B$3$N$h$&$K$7$F$$$k!#(B
    */
  $RELEASE(D_WorkShoenTempReg1);
}

#PSL_define  s_NonReserveUnhookShoenRecord(shoen_record)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_NonReserveUnhookShoenRecord","Not SHREC Type"); }};

  $USE(D_WorkShoenTempReg1);
  s_GetShoenLockFlag(shoen_record, D_WorkShoenTempReg1);
  p_SetImmediateValue(_UNHOOK_NONRESERVED, D_WorkShoenTempReg1);
  s_PutShoenLockFlag(shoen_record, D_WorkShoenTempReg1);
    /* $BAq1`%l%3!<%I$N%m%C%/%U%i%0%o!<%I$N%?%0(B(SLOCK)$B$rJ]B8$9$kI,MW$,$"$k$?$a(B
       $B$3$N$h$&$K$7$F$$$k!#(B
    */
  $RELEASE(D_WorkShoenTempReg1);
}

/******************************************************************** PSL **

(2.4) $B;q8;Ld$$9g$o$;4X78$NA`:n%^%/%m(B

       written by kawai@icot22      on Mon May 21 21:56:51 1990
<Arguments>
  shoen_record : $BAq1`%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_WorkShoenTempReg1 : shoen_stat_hook$B$NCM$r0l;~J];}$9$k%l%8%9%?(B
  D_WorkShoenTempReg2 : shoen_stat_hook$B$NCM(B($B2<0L(B16$B%S%C%H(B)$B$r0l;~J];}$9$k%l%8%9%?(B
<Level>
<PreCondition>
<Function>
  $BAq1`$N(BStatHook$B$N>e0L!"2<0L(B16$B%S%C%H$NCM$r%$%s%/%j%a%s%H$9$k!#(B
  $B2<0L(B16$B%S%C%H$,%*!<%P!<%U%m!<$7$?$+H]$+$NH=DjIU$-!#(B
<Examples>
<Test>
<Explanation>
  $BAq1`%l%3!<%I$N(B shoen_stat_hook $B%9%m%C%H$O!"(B1$B%o!<%I(B(32$B%S%C%H$r2>Dj(B)$B$r0J2<$N(B
$B$h$&$K>e0L$H2<0L$KJ,$1$F!">CHq;q8;D4::MW5a$,?FN$?F$+$i$+!"$3$NAq1`$N%3%s%H%m(B
$B!<%k%9%H%j!<%`$+$i$N$b$N$+$r6hJL$7$F$$$k!#(B

  $B!\!]!]!]!]!]!]!]!]!]!]!]!]!]!]!]!]!]!\!]!]!]!]!]!]!]!]!]!]!]!]!]!]!]!]!]!\(B
  $B!C(B         shoen_stat_upper         $B!C(B          shoen_stat_lower        $B!C(B
  $B!\!]!]!]!]!]!]!]!]!]!]!]!]!]!]!]!]!]!\!]!]!]!]!]!]!]!]!]!]!]!]!]!]!]!]!]!\(B

  $BA`:n(B:
  [$B>CHq;q8;D4::MW5a;~(B]
    (1) $B%3%s%H%m!<%k%9%H%j!<%`$+$i>CHq;q8;D4::MW5a$,$-$?(B($B$D$^$j!"AH$_9~$_=R8l(B
        ask_statistics$B$,<B9T$5$l$?(B)$B>l9g!"(Bshoen_stat_lower $B$r%$%s%/%j%a%s%H$9$k(B
    (2) $B?FN$?F$+$i>CHq;q8;D4::MW5a$,$-$?>l9g!"(Bshoen_stat_lower $B$r%$%s%/%j%a%s%H(B
        $B$7$?8e!"$3$NCM$r:8$K%7%U%H$7$F(B shoen_stat_upper $B$H$9$k!#(B
        $B$D$^$j!"$3$N;~(B shoen_stat_upper $B$K$O!"?FN$?F$+$i>CHq;q8;D4::MW5a$,Mh$k(B
        $BA0$K%3%s%H%m!<%k%9%H%j!<%`$+$iMh$F$$$?>CHq;q8;D4::MW5a$H!"?FN$?F$+$i$N(B
        $B>CHq;q8;D4::MW5a?t(B(1$B$h$jBg$-$/$J$i$J$$$3$H$,J]>Z$5$l$F$$$k(B)$B$NOB$,F~$C$F(B
        $B$$$k!#(B
    (3) $B$5$i$K$=$N8e!"%3%s%H%m!<%k%9%H%j!<%`$+$i>CHq;q8;D4::MW5a$,$-$?>l9g!"(B
        shoen_stat_lower $B$r%$%s%/%j%a%s%H$9$k!#(B

  [$B>CHq;q8;Js9p;~(B]
    (1) shoen_stat_upper > 1 $B$G$"$l$P!"?FN$?F$+$i$N>CHq;q8;D4::MW5a$h$jA0$K(B
        $B%3%s%H%m!<%k%9%H%j!<%`$+$i>CHq;q8;D4::MW5a$,$-$F$$$?$O$:$G$"$k$+$i!"(B
        $B>CHq;q8;Js9p$O%l%]!<%H%9%H%j!<%`$K=P$7!"(Bshoen_stat_upper$B$r%G%/%j%a%s%H(B
        $B$9$k!#(B
    (2) shoen_stat_upper = 1 $B$G$"$l$P!"?FN$?F$K>CHq;q8;Js9p$r9T$$!"(B
        shoen_stat_upper $B$r%G%/%j%a%s%H$9$k!#(B
    (3) shoen_stat_lower > 0 $B$G$"$l$P!"%3%s%H%m!<%k%9%H%j!<%`$K$K>CHq;q8;Js9p(B
        $B$r9T$$!"(Bshoen_stat_lower $B$r%G%/%j%a%s%H$9$k!#(B
        

<ETC>
********************************************************************* PSL **/

#PSL_define  s_IncrementShoenLowerStatHook(shoen_record)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_IncrementShoenLowerStatHook","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  $USE(D_WorkShoenTempReg2);
  s_GetStatHook(shoen_record, D_WorkShoenTempReg1);
  b_ExtractBitField(D_WorkShoenTempReg1, _LOWER_STAT_HOOK_CNT_MASK,
		                                        D_WorkShoenTempReg2);
  b_IncrementReg(D_WorkShoenTempReg2);
  b_IfGreaterEqImm(D_WorkShoenTempReg2, _UPPER_STAT_HOOK_CNT_UNIT)
    { /* $B$b$72<0L(B16$B%S%C%H$,%*!<%P!<%U%m!<$7$?$i(B */
      @DEBUG{ VPIM_ERROR("s_IncrementShoenLowerStatHook",
			 "Lower Stat Hook of Shoen overflow"); };
    }
  else
    {
      b_IncrementReg(D_WorkShoenTempReg1);
    }
  $RELEASE(D_WorkShoenTempReg2);
  s_PutStatHook(shoen_record, D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg1);
}



#PSL_define  s_DecrementShoenLowerStatHook(shoen_record)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_DecrementShoenLowerStatHook","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  $USE(D_WorkShoenTempReg2);
  s_GetStatHook(shoen_record, D_WorkShoenTempReg1);
  b_ExtractBitField(D_WorkShoenTempReg1, _LOWER_STAT_HOOK_CNT_MASK,
		                                        D_WorkShoenTempReg2);
  b_DecrementReg(D_WorkShoenTempReg2);
  b_IfLess(D_WorkShoenTempReg2, D_NULL)
    { /* $B$b$72<0L(B16$B%S%C%H$,%"%s%@!<%U%m!<$7$?$i(B */
      @DEBUG{ VPIM_ERROR("s_DecrementShoenLowerStatHook",
			 "Lower Stat Hook of Shoen underflow"); };
    }
  else
    {
      b_DecrementReg(D_WorkShoenTempReg1);
    }
  $RELEASE(D_WorkShoenTempReg2);
  s_PutStatHook(shoen_record, D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg1);
}



#PSL_define  s_IncrementShoenLowerStatHookAndMoveToUpper(shoen_record)
{ /* !! $BCm0U(B:$B$3$N%^%/%m$r<B9T$9$k$H!">e0L(B16$B%S%C%H$N>pJs$O2u$l$k!#(B($B0n$l$k(B) !! */
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_IncrementShoenLowerStatHook","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  $USE(D_WorkShoenTempReg2);
  s_GetStatHook(shoen_record, D_WorkShoenTempReg1);
  b_ExtractBitField(D_WorkShoenTempReg1, _LOWER_STAT_HOOK_CNT_MASK,
		                                        D_WorkShoenTempReg2);
  b_IncrementReg(D_WorkShoenTempReg2);
  b_IfGreaterEqImm(D_WorkShoenTempReg2, _UPPER_STAT_HOOK_CNT_UNIT)
    { /* $B$b$72<0L(B16$B%S%C%H$,%*!<%P!<%U%m!<$7$?$i(B */
      @DEBUG{ VPIM_ERROR("s_IncrementShoenLowerStatHook",
			 "Lower Stat Hook of Shoen overflow"); };
    }
  else
    {
      b_IncrementReg(D_WorkShoenTempReg1);
      b_ShiftLeftImmediateWithDNTC(D_WorkShoenTempReg1, _HALF_WORD_BIT_LENGTH,
			                                  D_WorkShoenTempReg1);
      /* $B>e0L(B16$B%S%C%H$NCM$O2u$l$k(B($B%7%U%H$5$l$F0n$l$k(B) */
    }
  $RELEASE(D_WorkShoenTempReg2);
  s_PutStatHook(shoen_record, D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg1);
}



#PSL_define  s_IncrementShoenUpperStatHook(shoen_record)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_IncrementShoenUpperStatHook","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  $USE(D_WorkShoenTempReg2);
  s_GetStatHook(shoen_record, D_WorkShoenTempReg1);
  b_ExtractBitField(D_WorkShoenTempReg1, _UPPER_STAT_HOOK_CNT_MASK,
		                                        D_WorkShoenTempReg2);
  b_ShiftRightImmediateWithDNTC(D_WorkShoenTempReg2, _HALF_WORD_BIT_LENGTH,
			                                D_WorkShoenTempReg2);
  b_IncrementReg(D_WorkShoenTempReg2);
  b_IfGreaterEqImm(D_WorkShoenTempReg2, _UPPER_STAT_HOOK_CNT_UNIT)
    { /* $B$b$7>e0L(B16$B%S%C%H$,%*!<%P!<%U%m!<$7$?$i(B */
      @DEBUG{ VPIM_ERROR("s_IncrementShoenUpperStatHook",
			 "Upper Stat Hook of Shoen overflow"); };
    }
  else
    {
      b_AddImmediateWithTag(D_WorkShoenTempReg1, _UPPER_STAT_HOOK_CNT_UNIT,
			                                D_WorkShoenTempReg1);
    }
  $RELEASE(D_WorkShoenTempReg2);
  s_PutStatHook(shoen_record, D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg1);
}



#PSL_define  s_DecrementShoenUpperStatHook(shoen_record)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_DecrementShoenUpperStatHook","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  $USE(D_WorkShoenTempReg2);
  s_GetStatHook(shoen_record, D_WorkShoenTempReg1);
  b_ExtractBitField(D_WorkShoenTempReg1, _UPPER_STAT_HOOK_CNT_MASK,
		                                        D_WorkShoenTempReg2);
  b_ShiftRightImmediateWithDNTC(D_WorkShoenTempReg2, _HALF_WORD_BIT_LENGTH,
			                                D_WorkShoenTempReg2);
  b_DecrementReg(D_WorkShoenTempReg2);
  b_IfLess(D_WorkShoenTempReg2, D_NULL)
    { /* $B$b$7>e0L(B16$B%S%C%H$,%"%s%@!<%U%m!<$7$?$i(B */
      @DEBUG{ VPIM_ERROR("s_DecrementShoenUpperStatHook",
			 "Upper Stat Hook of Shoen underflow"); };
    }
  else
    {
      b_SubtractImmediateWithTag(D_WorkShoenTempReg1,
				            _UPPER_STAT_HOOK_CNT_UNIT,
			                                D_WorkShoenTempReg1);
    }
  $RELEASE(D_WorkShoenTempReg2);
  s_PutStatHook(shoen_record, D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg1);
}



#PSL_define  s_IncrementShoenStatCount(shoen_record)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_IncrementShoenStatCount","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  s_GetStatCount(shoen_record, D_WorkShoenTempReg1);
  b_IncrementReg(D_WorkShoenTempReg1);

  @DEBUG
    {
      $USE(D_WorkShoenTempReg2);
      b_ReadClusterNumInSystem(D_WorkShoenTempReg2);
      b_IfGreater(D_WorkShoenTempReg1, D_WorkShoenTempReg2)
	{ /* StatCount > ClusterNumInSystem$B$N$H$-(B */
	  VPIM_ERROR("s_IncrementShoenStatCount","ShoenStatCount overflow");
	  b_DecrementReg(D_WorkShoenTempReg1);
	}
      $RELEASE(D_WorkShoenTempReg2);
    };

  s_PutStatCount(shoen_record, D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg1);
}



#PSL_define  s_DecrementShoenStatCount(shoen_record)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_DecrementShoenStatCount","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  s_GetStatCount(shoen_record, D_WorkShoenTempReg1);
  b_DecrementReg(D_WorkShoenTempReg1);

  @DEBUG
    {
      b_IfLess(D_WorkShoenTempReg1, D_NULL)
	{ /* StatCount < 0 $B$N$H$-(B */
	  VPIM_ERROR("s_DecrementShoenStatCount","ShoenStatCount overflow");
	  b_IncrementReg(D_WorkShoenTempReg1);
	}
    };

  s_PutStatCount(shoen_record, D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg1);
}



#PSL_define  s_AddShoenStatCount(shoen_record, count)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_IncrementShoenStatCount","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  s_GetStatCount(shoen_record, D_WorkShoenTempReg1);
  b_AddWithDNTC(D_WorkShoenTempReg1, count, D_WorkShoenTempReg1);

  @DEBUG
    {
      $USE(D_WorkShoenTempReg2);
      b_ReadClusterNumInSystem(D_WorkShoenTempReg2);
      b_IfGreater(D_WorkShoenTempReg1, D_WorkShoenTempReg2)
	{ /* StatCount > ClusterNumInSystem$B$N$H$-(B */
	  VPIM_ERROR("s_IncrementShoenStatCount","ShoenStatCount overflow");
	  b_SubtractWithDNTC(D_WorkShoenTempReg1, count, D_WorkShoenTempReg1);
	}
      $RELEASE(D_WorkShoenTempReg2);
    };

  s_PutStatCount(shoen_record, D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg1);
}

/******************************************************************** PSL **

(2.5) $B;q8;NLA`:nMQ%^%/%m(B

       written by kawai@icot22      on Thu May 24 15:26:52 1990
<Arguments>
  shoen_record : $BAq1`%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_WorkShoenTempReg1 : $BAq1`$N;q8;$N>e0LItJ,$r0l;~J];}$9$k%l%8%9%?(B
  D_WorkShoenTempReg2 : $BAq1`$N;q8;$N2<0LItJ,$r0l;~J];}$9$k%l%8%9%?(B
<Level>
<PreCondition>
<Function>
  $BAq1`$N;q8;$rA`:n$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  s_AddShoenResourceConsumed(shoen_record, consumed_res_upper_reg,
					              consumed_res_lower_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_AddShoenResourceConsumed","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  $USE(D_WorkShoenTempReg2);
  s_GetShoenResourceConsumed(shoen_record, D_WorkShoenTempReg1,
			                                D_WorkShoenTempReg2);
  b_AddDoubleWord(D_WorkShoenTempReg1, D_WorkShoenTempReg2,
		  consumed_res_upper_reg, consumed_res_lower_reg,
		                   D_WorkShoenTempReg1, D_WorkShoenTempReg2);
  s_PutShoenResourceConsumed(shoen_record, D_WorkShoenTempReg1,
			                                D_WorkShoenTempReg2);
  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
}



#PSL_define  s_AddShoenResourceLeft(shoen_record, res_left_upper_reg,
					              res_left_lower_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_AddShoenResourceLeft","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  $USE(D_WorkShoenTempReg2);
  s_GetShoenResourceLeft(shoen_record, D_WorkShoenTempReg1,
			                                D_WorkShoenTempReg2);
  b_AddDoubleWord(D_WorkShoenTempReg1, D_WorkShoenTempReg2,
		  res_left_upper_reg, res_left_lower_reg,
		                   D_WorkShoenTempReg1, D_WorkShoenTempReg2);
  s_PutShoenResourceLeft(shoen_record, D_WorkShoenTempReg1,
			                                D_WorkShoenTempReg2);
  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
}



#PSL_define  s_SubtractShoenResourceLeft(shoen_record, res_left_upper_reg,
					             res_left_lower_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_SubtractShoenResourceLeft","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  $USE(D_WorkShoenTempReg2);
  s_GetShoenResourceLeft(shoen_record, D_WorkShoenTempReg1,
			                                D_WorkShoenTempReg2);
  b_SubtractDoubleWord(D_WorkShoenTempReg1, D_WorkShoenTempReg2,
		  res_left_upper_reg, res_left_lower_reg,
		                   D_WorkShoenTempReg1, D_WorkShoenTempReg2);
  s_PutShoenResourceLeft(shoen_record, D_WorkShoenTempReg1,
			                                D_WorkShoenTempReg2);
  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
}



#PSL_define  s_AddShoenResourceLimitLeft(shoen_record,
					          res_limit_left_upper_reg,
					            res_limit_left_lower_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_AddShoenResourceLimitLeft","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  $USE(D_WorkShoenTempReg2);
  s_GetShoenResourceLimitLeft(shoen_record, D_WorkShoenTempReg1,
			                                D_WorkShoenTempReg2);
  b_AddDoubleWord(D_WorkShoenTempReg1, D_WorkShoenTempReg2,
		  res_limit_left_upper_reg, res_limit_left_lower_reg,
		                   D_WorkShoenTempReg1, D_WorkShoenTempReg2);
  s_PutShoenResourceLimitLeft(shoen_record, D_WorkShoenTempReg1,
			                                D_WorkShoenTempReg2);
  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
}



#PSL_define  s_SubtractShoenResourceLimitLeft(shoen_record,
					      res_limit_left_upper_reg,
					           res_limit_left_lower_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_SubtractShoenResourceLimitLeft","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  $USE(D_WorkShoenTempReg2);
  s_GetShoenResourceLimitLeft(shoen_record, D_WorkShoenTempReg1,
			                                D_WorkShoenTempReg2);
  b_SubtractDoubleWord(D_WorkShoenTempReg1, D_WorkShoenTempReg2,
		  res_limit_left_upper_reg, res_limit_left_lower_reg,
		                   D_WorkShoenTempReg1, D_WorkShoenTempReg2);
  s_PutShoenResourceLimitLeft(shoen_record, D_WorkShoenTempReg1,
			                                D_WorkShoenTempReg2);
  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
}



#PSL_define  s_GetShoenResourceConsumedWithUpdate(shoen_record,
						   rsc_consumed_upper_reg,
						     rsc_consumed_lower_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetShoenResourceConsumedWithUpdate","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  $USE(D_WorkShoenTempReg2);
  s_GetShoenResourceConsumed(shoen_record, D_WorkShoenTempReg1,
				                     D_WorkShoenTempReg2);
  s_GetShoenLastResourceConsumed(shoen_record, rsc_consumed_upper_reg,
			                             rsc_consumed_lower_reg);
  b_SubtractDoubleWord(D_WorkShoenTempReg1, D_WorkShoenTempReg2, 
		              rsc_consumed_upper_reg, rsc_consumed_lower_reg,
		              rsc_consumed_upper_reg, rsc_consumed_lower_reg);
  s_PutShoenLastResourceConsumed(shoen_record, D_WorkShoenTempReg1,
			                                D_WorkShoenTempReg2);
  /* $BA02sJs9p$7$?>CHq;q8;NL$H:G?7$N>CHq;q8;NL$H$N:9$r5a$a$?8e$O(B
       LastResourceConsumed = ResourceConsumed
     $B$H$9$k!#(B
  */

  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
  
}

/******************************************************************** PSL **

(2.6) $BN$?F%F!<%V%kA`:nMQ%^%/%m(B

       written by kawai@icot22      on Thu May 24 17:25:11 1990
<Arguments>
  shoen_record : $BAq1`%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $BN$?F%F!<%V%kN`$rA`:n$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CONST_define  _FP_BIT_TBL_FLAG_OFF   _ZERO
#CONST_define  _FP_BIT_TBL_FLAG_ON    _ONE

/* Original
#PSL_define  s_SetFPBitTableFlag(table_reg, pos_reg, on_off_imm)
{
  @DEBUG{
    $USE(D_WorkShoenTempReg2);
    b_ReadClusterNumInSystem(D_WorkShoenTempReg2);
    b_IfGreaterEq(pos_reg, D_WorkShoenTempReg2)
      {
	VPIM_ERROR("s_SetFPBitTableFlagOn","Position of Table out of bounds");
      }
    $RELEASE(D_WorkShoenTempReg2);
  };

  $USE(D_WorkShoenTempReg2);
    /!* Table$B%Y%/%?$N2?%o!<%IL\$+$rJ];}(B *!/
  $USE(D_WorkShoenTempReg3);
    /!* $B%o!<%ICf$N2?%S%C%HL\$+$rJ];}(B *!/
  $USE(D_WorkShoenTempReg4);
    /!* Table$B%Y%/%?$N;XDjMWAG$rJ];}(B *!/
  $USE(D_WorkShoenTempReg5);

  b_DivideImmediateWithDNTC(pos_reg, _WORD_BIT_LENGTH, D_WorkShoenTempReg2);
  b_ModuloImmediateWithDNTC(pos_reg, _WORD_BIT_LENGTH, D_WorkShoenTempReg3);
  s_GetVectElementPosReg(table_reg, D_WorkShoenTempReg2, D_WorkShoenTempReg4);
  p_SetImmediateValue(on_off_imm, D_WorkShoenTempReg5);
  b_IfEqualImm(D_WorkShoenTempReg5, _FP_BIT_TBL_FLAG_ON)
    {
      b_FlagOnPosReg(D_WorkShoenTempReg4, D_WorkShoenTempReg3);
    }
  else
    {
      b_IfEqualImm(D_WorkShoenTempReg5, _FP_BIT_TBL_FLAG_OFF)
	{
	  b_FlagOffPosReg(D_WorkShoenTempReg4, D_WorkShoenTempReg3);
	}
      else
	{
	  @DEBUG{VPIM_ERROR("s_SetFPBitTableFlag","Illegal Flag Operation");};
	}
    }
  p_SetImmediateType(INT, D_WorkShoenTempReg4);
  s_PutVectElementPosReg(table_reg, D_WorkShoenTempReg2, D_WorkShoenTempReg4);
  $RELEASE(D_WorkShoenTempReg2);
  $RELEASE(D_WorkShoenTempReg3);
  $RELEASE(D_WorkShoenTempReg4);
  $RELEASE(D_WorkShoenTempReg5);
}
*/

/* !! $BGQ;_(B */


/* Original
#PSL_define  s_GetFPBitTableFlag(table_reg, cl_num_reg, result_reg)
{
  @DEBUG{
    $USE(D_WorkShoenTempReg3);
    b_ReadClusterNumInSystem(D_WorkShoenTempReg3);
    b_IfGreaterEq(cl_num_reg, D_WorkShoenTempReg3)
      {
	VPIM_ERROR("s_GetFPBitTableFlag","Illegal Cluster Number");
      }
    $RELEASE(D_WorkShoenTempReg3);
  };

  $USE(D_WorkShoenTempReg3);
    /!* FPTable$B%Y%/%?$N2?%o!<%IL\$+$rJ];}(B *!/
  $USE(D_WorkShoenTempReg4);
    /!* $B%o!<%ICf$N2?%S%C%HL\$+$rJ];}(B *!/
  $USE(D_WorkShoenTempReg5);
    /!* FPTable$B%Y%/%?$N;XDjMWAG$rJ];}(B *!/

  b_DivideImmediateWithDNTC(cl_num_reg, _WORD_BIT_LENGTH, D_WorkShoenTempReg3);
  b_ModuloImmediateWithDNTC(cl_num_reg, _WORD_BIT_LENGTH, D_WorkShoenTempReg4);
  s_GetVectElementPosReg(table_reg, D_WorkShoenTempReg3, D_WorkShoenTempReg5);
  $RELEASE(D_WorkShoenTempReg3);
  b_IfFlagOnPosReg(D_WorkShoenTempReg5, D_WorkShoenTempReg4)
    { /!* $B%U%i%0$,N)$C$F$$$?;~(B *!/
      p_SetImmediateValue(_FP_BIT_TBL_FLAG_ON, result_reg);
    }
  else
    { /!* $B%U%i%0$,N)$C$F$$$J$+$C$?;~(B *!/
      p_SetImmediateValue(_FP_BIT_TBL_FLAG_OFF, result_reg);
    }
  $RELEASE(D_WorkShoenTempReg4);
  $RELEASE(D_WorkShoenTempReg5);
}
*/

/* !! $BGQ;_(B */


/* Original
#PSL_define  s_SetFPTableFlagOn(shoen_record, cl_num_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_SetFPTableFlagOn","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  s_GetFPTable(shoen_record, D_WorkShoenTempReg1);
  s_SetFPBitTableFlag(D_WorkShoenTempReg1, cl_num_reg, _FP_BIT_TBL_FLAG_ON);
  s_PutFPTable(shoen_record, D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg1);
}
*/

/* !! */
#PSL_define  s_SetFPTableFlagOn(shoen_record, cl_num_reg)
{
  @DEBUG{
    $USE(D_WorkShoenTempReg2);
    b_ReadClusterNumInSystem(D_WorkShoenTempReg2);
    b_IfGreaterEq(cl_num_reg, D_WorkShoenTempReg2)
      {
	VPIM_ERROR("s_SetFPTableFlagOn","Position of Table out of bounds");
      }
    $RELEASE(D_WorkShoenTempReg2);
  };

  $USE(D_WorkShoenTempReg2);  /* upper fp_table */
  $USE(D_WorkShoenTempReg3);  /* lower fp_table */
  s_GetFPTable(shoen_record, D_WorkShoenTempReg2, D_WorkShoenTempReg3);

  b_IfGreaterEqImm(cl_num_reg, _WORD_BIT_LENGTH)
    {
      $USE(D_WorkShoenTempReg4); /* upper fp_table$BCf$N%S%C%H0LCV$rJ];}$9$k(B */
      b_SubtractImmediateWithDNTC(cl_num_reg, _WORD_BIT_LENGTH,
				                        D_WorkShoenTempReg4);
      @DEBUG{
	b_IfFlagOnPosReg(D_WorkShoenTempReg2, D_WorkShoenTempReg4)
	  {VPIM_ERROR("s_SetFPTableFlagOn","Already Flag on");}
      };

      b_FlagOnPosReg(D_WorkShoenTempReg2, D_WorkShoenTempReg4);
      $RELEASE(D_WorkShoenTempReg4);
    }
  else
    {
      @DEBUG{
	b_IfFlagOnPosReg(D_WorkShoenTempReg3, cl_num_reg)
	  {VPIM_ERROR("s_SetFPTableFlagOn","Already Flag on");}
      };

      b_FlagOnPosReg(D_WorkShoenTempReg3, cl_num_reg);
    }
  s_PutFPTable(shoen_record, D_WorkShoenTempReg2, D_WorkShoenTempReg3);

  $RELEASE(D_WorkShoenTempReg2);
  $RELEASE(D_WorkShoenTempReg3);
}



/* Original
#PSL_define  s_SetFPTableFlagOff(shoen_record, cl_num_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_SetFPTableFlagOff","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  s_GetFPTable(shoen_record, D_WorkShoenTempReg1);
  s_SetFPBitTableFlag(D_WorkShoenTempReg1, cl_num_reg, _FP_BIT_TBL_FLAG_OFF);
  s_PutFPTable(shoen_record, D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg1);
}
*/

/* !! */
#PSL_define  s_SetFPTableFlagOff(shoen_record, cl_num_reg)
{
  @DEBUG{
    $USE(D_WorkShoenTempReg2);
    b_ReadClusterNumInSystem(D_WorkShoenTempReg2);
    b_IfGreaterEq(cl_num_reg, D_WorkShoenTempReg2)
      {
	VPIM_ERROR("s_SetFPTableFlagOff","Position of Table out of bounds");
      }
    $RELEASE(D_WorkShoenTempReg2);
  };

  $USE(D_WorkShoenTempReg2);  /* upper fp_table */
  $USE(D_WorkShoenTempReg3);  /* lower fp_table */
  s_GetFPTable(shoen_record, D_WorkShoenTempReg2, D_WorkShoenTempReg3);

  b_IfGreaterEqImm(cl_num_reg, _WORD_BIT_LENGTH)
    {
      $USE(D_WorkShoenTempReg4); /* upper fp_table$BCf$N%S%C%H0LCV$rJ];}$9$k(B */
      b_SubtractImmediateWithDNTC(cl_num_reg, _WORD_BIT_LENGTH,
				                        D_WorkShoenTempReg4);

      @DEBUG{
	b_IfFlagOffPosReg(D_WorkShoenTempReg2, D_WorkShoenTempReg4)
	  {VPIM_ERROR("s_SetFPTableFlagOff","Already Flag off");}
      };

      b_FlagOffPosReg(D_WorkShoenTempReg2, D_WorkShoenTempReg4);
      $RELEASE(D_WorkShoenTempReg4);
    }
  else
    {
      @DEBUG{
	b_IfFlagOffPosReg(D_WorkShoenTempReg3, cl_num_reg)
	  {VPIM_ERROR("s_SetFPTableFlagOff","Already Flag off");}
      };

      b_FlagOffPosReg(D_WorkShoenTempReg3, cl_num_reg);
    }
  s_PutFPTable(shoen_record, D_WorkShoenTempReg2, D_WorkShoenTempReg3);

  $RELEASE(D_WorkShoenTempReg2);
  $RELEASE(D_WorkShoenTempReg3);
}


/* Original
#PSL_define  s_SetResourceRequestFPTableFlagOn(shoen_record, cl_num_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_SetResourceRequestFPTableFlagOn","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  s_GetResourceRequestFPTable(shoen_record, D_WorkShoenTempReg1);
  s_SetFPBitTableFlag(D_WorkShoenTempReg1, cl_num_reg, _FP_BIT_TBL_FLAG_ON);
  s_PutResourceRequestFPTable(shoen_record, D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg1);
  s_SetShoenStatusFlag(shoen_record, _RSC_REQ_FP_EXISTANCE_FLAG_MASK);
}
*/

/* !! */
#PSL_define  s_SetResourceRequestFPTableFlagOn(shoen_record, cl_num_reg)
{
  @DEBUG{
    $USE(D_WorkShoenTempReg2);
    b_ReadClusterNumInSystem(D_WorkShoenTempReg2);
    b_IfGreaterEq(cl_num_reg, D_WorkShoenTempReg2)
      {
	VPIM_ERROR("s_SetResourceRequestFPTableFlagOn",
		   "Position of Table out of bounds");
      }
    $RELEASE(D_WorkShoenTempReg2);
  };

  $USE(D_WorkShoenTempReg2);  /* upper res_req_fp_table */
  $USE(D_WorkShoenTempReg3);  /* lower res_req_fp_table */
  s_GetResourceRequestFPTable(shoen_record,
			      D_WorkShoenTempReg2, D_WorkShoenTempReg3);

  b_IfGreaterEqImm(cl_num_reg, _WORD_BIT_LENGTH)
    {
      $USE(D_WorkShoenTempReg4); 
      /* upper res_req_fp_table$BCf$N%S%C%H0LCV$rJ];}$9$k(B */
      b_SubtractImmediateWithDNTC(cl_num_reg, _WORD_BIT_LENGTH,
				                        D_WorkShoenTempReg4);
      @DEBUG{
	b_IfFlagOnPosReg(D_WorkShoenTempReg2, D_WorkShoenTempReg4)
	  {WARNING("s_SetResourceRequestFPTableFlagOn","Already Flag on");}
	/* $B0JA0$O(B VPIM_ERROR $B$H$7$F$$$?$,!"(BResourceRequest $BAw?.8eN$?F$,(B 
           $B=*7k$7!"Aq1`$,(B SupplyResource $B$rAw?.$9$kA0$K!"<!$N@$Be$NN$?F$+$i(B
           $B$N(B ResourceRequest $B$,E~Ce$7F@$k$?$a!"(BWARNING$B$KJQ99$7$?!#(B
           on '92.4.30 */
      };

      b_FlagOnPosReg(D_WorkShoenTempReg2, D_WorkShoenTempReg4);
      $RELEASE(D_WorkShoenTempReg4);
    }
  else
    {
      @DEBUG{
	b_IfFlagOnPosReg(D_WorkShoenTempReg3, cl_num_reg)
	  {WARNING("s_SetResourceRequestFPTableFlagOn","Already Flag on");}
	/* $B0JA0$O(B VPIM_ERROR $B$H$7$F$$$?$,!"(BResourceRequest $BAw?.8eN$?F$,(B 
           $B=*7k$7!"Aq1`$,(B SupplyResource $B$rAw?.$9$kA0$K!"<!$N@$Be$NN$?F$+$i(B
           $B$N(B ResourceRequest $B$,E~Ce$7F@$k$?$a!"(BWARNING$B$KJQ99$7$?!#(B
           on '92.4.30 */
      };

      b_FlagOnPosReg(D_WorkShoenTempReg3, cl_num_reg);
    }
  s_PutResourceRequestFPTable(shoen_record,
			      D_WorkShoenTempReg2, D_WorkShoenTempReg3);

  $RELEASE(D_WorkShoenTempReg2);
  $RELEASE(D_WorkShoenTempReg3);

  s_SetShoenStatusFlag(shoen_record, _RSC_REQ_FP_EXISTANCE_FLAG_MASK);
}


/* Original
#PSL_define  s_SetResourceRequestFPTableFlagOff(shoen_record, cl_num_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_SetFPTableFlagOff","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  s_GetResourceRequestFPTable(shoen_record, D_WorkShoenTempReg1);
  s_SetFPBitTableFlag(D_WorkShoenTempReg1, cl_num_reg, _FP_BIT_TBL_FLAG_OFF);
  s_PutResourceRequestFPTable(shoen_record, D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg1);
}
*/

/* !! */
#PSL_define  s_SetResourceRequestFPTableFlagOff(shoen_record, cl_num_reg)
{
  @DEBUG{
    $USE(D_WorkShoenTempReg2);
    b_ReadClusterNumInSystem(D_WorkShoenTempReg2);
    b_IfGreaterEq(cl_num_reg, D_WorkShoenTempReg2)
      {
	VPIM_ERROR("s_SetResourceRequestFPTableFlagOff",
		   "Position of Table out of bounds");
      }
    $RELEASE(D_WorkShoenTempReg2);
  };

  $USE(D_WorkShoenTempReg2);  /* upper res_req_fp_table */
  $USE(D_WorkShoenTempReg3);  /* lower res_req_fp_table */
  s_GetResourceRequestFPTable(shoen_record,
			      D_WorkShoenTempReg2, D_WorkShoenTempReg3);

  b_IfGreaterEqImm(cl_num_reg, _WORD_BIT_LENGTH)
    {
      $USE(D_WorkShoenTempReg4); 
      /* upper res_req_fp_table$BCf$N%S%C%H0LCV$rJ];}$9$k(B */
      b_SubtractImmediateWithDNTC(cl_num_reg, _WORD_BIT_LENGTH,
				                        D_WorkShoenTempReg4);
      @DEBUG{
	b_IfFlagOffPosReg(D_WorkShoenTempReg2, D_WorkShoenTempReg4)
	  {WARNING("s_SetResourceRequestFPTableFlagOff","Already Flag off");}
	/* $BN$?F$,=*7k$7$?>l9g$O!"2?$b9M$($:$K(B Flag $B$r(B Off $B$9$k$N$G(B
           WARNING $B$H$7$F$$$k!#(B*/
      };

      b_FlagOffPosReg(D_WorkShoenTempReg2, D_WorkShoenTempReg4);
      $RELEASE(D_WorkShoenTempReg4);
    }
  else
    {
      @DEBUG{
	b_IfFlagOffPosReg(D_WorkShoenTempReg3, cl_num_reg)
	  {WARNING("s_SetResourceRequestFPTableFlagOff","Already Flag off");}
      };

      b_FlagOffPosReg(D_WorkShoenTempReg3, cl_num_reg);
    }
  s_PutResourceRequestFPTable(shoen_record,
			      D_WorkShoenTempReg2, D_WorkShoenTempReg3);

  $RELEASE(D_WorkShoenTempReg2);
  $RELEASE(D_WorkShoenTempReg3);
}


/* Original
#PSL_define  s_MaintainResReqFPTable(shoen_record, dest_table_vect)
{
  $USE(D_WorkShoenTempReg1);
    /!* $BAq1`%l%3!<%I$N;q8;MW5aN$?F%F!<%V%k%Y%/%?$rJ];}$9$k(B *!/
  $USE(D_WorkShoenTempReg2);
    /!* supply_resource_message$B$N08@h$NN$?F%F!<%V%k%Y%/%?D9$rJ];}$9$k(B *!/
  $USE(D_WorkShoenTempReg3);
    /!* supply_resource_message$B$N08@h$NN$?F%F!<%V%k%Y%/%?MWAG$rJ];}$9$k(B *!/
  $USE(D_WorkShoenTempReg4);
    /!* $BAq1`%l%3!<%I$N;q8;MW5aN$?F%F!<%V%k%Y%/%?$NMWAG$rJ];}$9$k(B *!/
  s_GetResourceRequestFPTable(shoen_record, D_WorkShoenTempReg1);
  s_GetSizeVectType(dest_table_vect, D_WorkShoenTempReg2);
  LOOP()
    {
      b_DecrementReg(D_WorkShoenTempReg2);
      b_IfLess(D_WorkShoenTempReg2, D_NULL) {break;}
      s_GetVectElementPosReg(dest_table_vect, D_WorkShoenTempReg2,
			                                 D_WorkShoenTempReg3);
      s_GetVectElementPosReg(D_WorkShoenTempReg1, D_WorkShoenTempReg2,
			                                 D_WorkShoenTempReg4);
      b_BitwiseEorWithDNTC(D_WorkShoenTempReg3, D_WorkShoenTempReg4,
		                                         D_WorkShoenTempReg4);
      p_SetImmediateType(INT, D_WorkShoenTempReg4);
      s_PutVectElementPosReg(D_WorkShoenTempReg1, D_WorkShoenTempReg2,
			                                 D_WorkShoenTempReg4);
    }
  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
  $RELEASE(D_WorkShoenTempReg3);
  $RELEASE(D_WorkShoenTempReg4);
}
*/

/* !! */
#PSL_define  s_MaintainResReqFPTable(shoen_record,
				     dest_table_upper, dest_table_lower)
				                   
{
  $USE(D_WorkShoenTempReg1);
    /* $BAq1`%l%3!<%I$N;q8;MW5aN$?F%F!<%V%k(B(upper)$B$rJ];}$9$k(B */
  $USE(D_WorkShoenTempReg2);
    /* $BAq1`%l%3!<%I$N;q8;MW5aN$?F%F!<%V%k(B(lower)$B$rJ];}$9$k(B */
  s_GetResourceRequestFPTable(shoen_record,
			      D_WorkShoenTempReg1, D_WorkShoenTempReg2);

  b_BitwiseEorWithDNTC(D_WorkShoenTempReg1, dest_table_upper,
		                                         D_WorkShoenTempReg1);
  b_BitwiseEorWithDNTC(D_WorkShoenTempReg2, dest_table_lower,
		                                         D_WorkShoenTempReg2);
  s_PutResourceRequestFPTable(shoen_record,
			      D_WorkShoenTempReg1, D_WorkShoenTempReg2);
  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
}

/* Original
#PSL_define  s_CountDestinationFPs(fp_table_vect, fp_count)
{
  $USE(D_WorkShoenTempReg1);
  $USE(D_WorkShoenTempReg2);
  $USE(D_WorkShoenTempReg3);
  s_GetSizeVectType(fp_table_vect, D_WorkShoenTempReg1);
  p_MoveValue(D_NULL, fp_count);
  LOOP()
    {
      b_DecrementReg(D_WorkShoenTempReg1);
      b_IfLess(D_WorkShoenTempReg1, D_NULL) {break;}
      s_GetVectElementPosReg(fp_table_vect, D_WorkShoenTempReg1,
			                               D_WorkShoenTempReg2);
      p_SetImmediateValue(_WORD_BIT_LENGTH, D_WorkShoenTempReg3);
      LOOP()
	{
	  b_DecrementReg(D_WorkShoenTempReg3);
	  b_IfLess(D_WorkShoenTempReg3, D_NULL) {break;}
	  b_IfFlagOnPosReg(D_WorkShoenTempReg2, D_WorkShoenTempReg3)
	  /!* !! $B%3%a%s%H(B: $B9bB.2=$9$k$J$i(B D_ONE $B$r=g<!:8%7%U%H$7$F%^%9%/%Q%?%s(B
              $B$r<+J,$GMQ0U$7$?J}$,NI$$(B *!/
	    {
	      b_IncrementReg(fp_count);
	    }
	}
    }
  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
  $RELEASE(D_WorkShoenTempReg3);
}
*/

/* !! */
#PSL_define  s_CountDestinationFPs(fp_table_upper, fp_table_lower, fp_count)
{
  $USE(D_WorkShoenTempReg1);
  p_MoveValue(D_NULL, fp_count);
  p_SetImmediateValue(_WORD_BIT_LENGTH, D_WorkShoenTempReg1);
  LOOP()
    {
      b_DecrementReg(D_WorkShoenTempReg1);
      b_IfLess(D_WorkShoenTempReg1, D_NULL) {break;}
	  b_IfFlagOnPosReg(fp_table_upper, D_WorkShoenTempReg1)
	  /* !! $B%3%a%s%H(B: $B9bB.2=$9$k$J$i(B D_ONE $B$r=g<!:8%7%U%H$7$F%^%9%/%Q%?%s(B
             $B$r<+J,$GMQ0U$7$?J}$,NI$$(B */
	    {
	      b_IncrementReg(fp_count);
	    }
	  b_IfFlagOnPosReg(fp_table_lower, D_WorkShoenTempReg1)
	  /* !! $B%3%a%s%H(B: $B9bB.2=$9$k$J$i(B D_ONE $B$r=g<!:8%7%U%H$7$F%^%9%/%Q%?%s(B
             $B$r<+J,$GMQ0U$7$?J}$,NI$$(B */
	    {
	      b_IncrementReg(fp_count);
	    }
    }
  $RELEASE(D_WorkShoenTempReg1);
}

/* Original
#PSL_define  s_SetStartStopBitTableFlagOn(shoen_record, cl_num_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_SetStartStopBitTableFlagOn","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  s_GetShoenStartStopBitTable(shoen_record, D_WorkShoenTempReg1);
  s_SetFPBitTableFlag(D_WorkShoenTempReg1, cl_num_reg, _FP_BIT_TBL_FLAG_ON);
  s_PutShoenStartStopBitTable(shoen_record, D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg1);
}
*/

/* !! */
#PSL_define  s_SetStartStopBitTableFlagOn(shoen_record, cl_num_reg)
{
  @DEBUG{
    $USE(D_WorkShoenTempReg2);
    b_ReadClusterNumInSystem(D_WorkShoenTempReg2);
    b_IfGreaterEq(cl_num_reg, D_WorkShoenTempReg2)
      {
	VPIM_ERROR("s_SetStartStopBitTableFlagOn",
		   "Position of Table out of bounds");
      }
    $RELEASE(D_WorkShoenTempReg2);
  };

  $USE(D_WorkShoenTempReg2);  /* upper start_stop_bit_table */
  $USE(D_WorkShoenTempReg3);  /* lower start_stop_bit_table */
  s_GetShoenStartStopBitTable(shoen_record,
			      D_WorkShoenTempReg2, D_WorkShoenTempReg3);

  b_IfGreaterEqImm(cl_num_reg, _WORD_BIT_LENGTH)
    {
      $USE(D_WorkShoenTempReg4); 
      /* upper start_stop_bit_table$BCf$N%S%C%H0LCV$rJ];}$9$k(B */
      b_SubtractImmediateWithDNTC(cl_num_reg, _WORD_BIT_LENGTH,
				                    D_WorkShoenTempReg4);
      @DEBUG{
	b_IfFlagOnPosReg(D_WorkShoenTempReg2, D_WorkShoenTempReg4)
	  {VPIM_ERROR("s_SetStartStopBitTableFlagOn","Already Flag on");}
      };

      b_FlagOnPosReg(D_WorkShoenTempReg2, D_WorkShoenTempReg4);
      $RELEASE(D_WorkShoenTempReg4);
    }
  else
    {
      @DEBUG{
	b_IfFlagOnPosReg(D_WorkShoenTempReg3, cl_num_reg)
	  {VPIM_ERROR("s_SetStartStopBitTableFlagOn","Already Flag on");}
      };

      b_FlagOnPosReg(D_WorkShoenTempReg3, cl_num_reg);
    }
  s_PutShoenStartStopBitTable(shoen_record,
			      D_WorkShoenTempReg2, D_WorkShoenTempReg3);

  $RELEASE(D_WorkShoenTempReg2);
  $RELEASE(D_WorkShoenTempReg3);
}

/* Original
#PSL_define  s_SetStartStopBitTableFlagOff(shoen_record, cl_num_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_SetStartStopBitTableFlagOff","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  s_GetShoenStartStopBitTable(shoen_record, D_WorkShoenTempReg1);
  s_SetFPBitTableFlag(D_WorkShoenTempReg1, cl_num_reg, _FP_BIT_TBL_FLAG_OFF);
  s_PutShoenStartStopBitTable(shoen_record, D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg1);
}
*/

/* !! */
#PSL_define  s_SetStartStopBitTableFlagOff(shoen_record, cl_num_reg)
{
  @DEBUG{
    $USE(D_WorkShoenTempReg2);
    b_ReadClusterNumInSystem(D_WorkShoenTempReg2);
    b_IfGreaterEq(cl_num_reg, D_WorkShoenTempReg2)
      {
	VPIM_ERROR("s_SetStartStopBitTableFlagOff",
		   "Position of Table out of bounds");
      }
    $RELEASE(D_WorkShoenTempReg2);
  };

  $USE(D_WorkShoenTempReg2);  /* upper start_stop_bit_table */
  $USE(D_WorkShoenTempReg3);  /* lower start_stop_bit_table */
  s_GetShoenStartStopBitTable(shoen_record,
			      D_WorkShoenTempReg2, D_WorkShoenTempReg3);

  b_IfGreaterEqImm(cl_num_reg, _WORD_BIT_LENGTH)
    {
      $USE(D_WorkShoenTempReg4); 
      /* upper start_stop_bit_table$BCf$N%S%C%H0LCV$rJ];}$9$k(B */
      b_SubtractImmediateWithDNTC(cl_num_reg, _WORD_BIT_LENGTH,
				                      D_WorkShoenTempReg4);
      @DEBUG{
	b_IfFlagOffPosReg(D_WorkShoenTempReg2, D_WorkShoenTempReg4)
	  {VPIM_ERROR("s_SetStartStopBitTableFlagOff","Already Flag off");}
      };

      b_FlagOffPosReg(D_WorkShoenTempReg2, D_WorkShoenTempReg4);
      $RELEASE(D_WorkShoenTempReg4);
    }
  else
    {
      @DEBUG{
	b_IfFlagOffPosReg(D_WorkShoenTempReg3, cl_num_reg)
	  {VPIM_ERROR("s_SetStartStopBitTableFlagOff","Already Flag off");}
      };

      b_FlagOffPosReg(D_WorkShoenTempReg3, cl_num_reg);
    }
  s_PutShoenStartStopBitTable(shoen_record,
			      D_WorkShoenTempReg2, D_WorkShoenTempReg3);

  $RELEASE(D_WorkShoenTempReg2);
  $RELEASE(D_WorkShoenTempReg3);
}


/* Original
#PSL_define  s_MakeStoppedFPDestinationTable(fp_table, start_stop_bit_table,
				  	                      dest_table_vect)
{
  $USE(D_WorkShoenTempReg1);
    /!* $BN$?F%F!<%V%k%Y%/%?D9$rJ];}$9$k(B *!/
  $USE(D_WorkShoenTempReg2);
    /!* $BN$?F%F!<%V%k%Y%/%?MWAG$rJ];}$9$k(B *!/
  $USE(D_WorkShoenTempReg3);
    /!* start/stop$B%S%C%H%F!<%V%k%Y%/%?$NMWAG$rJ];}$9$k(B *!/
  s_GetSizeVectType(fp_table, D_WorkShoenTempReg1);
  LOOP()
    {
      b_DecrementReg(D_WorkShoenTempReg1);
      b_IfLess(D_WorkShoenTempReg1, D_NULL) {break;}
      s_GetVectElementPosReg(fp_table, D_WorkShoenTempReg1,
			                                 D_WorkShoenTempReg2);
      s_GetVectElementPosReg(start_stop_bit_table, D_WorkShoenTempReg1,
			                                 D_WorkShoenTempReg3);
      b_BitwiseAndWithDNTC(D_WorkShoenTempReg2, D_WorkShoenTempReg3,
		                                         D_WorkShoenTempReg3);
      p_SetImmediateType(INT, D_WorkShoenTempReg3);
      s_PutVectElementPosReg(dest_table_vect, D_WorkShoenTempReg1,
			                                 D_WorkShoenTempReg3);
    }
  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
  $RELEASE(D_WorkShoenTempReg3);
}
*/

/* !! */
#PSL_define  s_MakeStoppedFPDestinationTable(fp_table_upper, fp_table_lower,
					     start_stop_bit_table_upper,
					     start_stop_bit_table_lower,
					     dest_table_upper, 
					     dest_table_lower)
{
  b_BitwiseAndWithDNTC(fp_table_upper, start_stop_bit_table_upper,
		                                        dest_table_upper);
  b_BitwiseAndWithDNTC(fp_table_lower, start_stop_bit_table_lower,
		                                        dest_table_lower);
}


/* Original
#PSL_define  s_MakeStartedFPDestinationTable(fp_table, start_stop_bit_table,
				  	                      dest_table_vect)
{
  $USE(D_WorkShoenTempReg1);
    /!* $BN$?F%F!<%V%k%Y%/%?D9$rJ];}$9$k(B *!/
  $USE(D_WorkShoenTempReg2);
    /!* $BN$?F%F!<%V%k%Y%/%?MWAG$rJ];}$9$k(B *!/
  $USE(D_WorkShoenTempReg3);
    /!* start/stop$B%S%C%H%F!<%V%k%Y%/%?$NMWAG$rJ];}$9$k(B *!/
  s_GetSizeVectType(fp_table, D_WorkShoenTempReg1);
  LOOP()
    {
      b_DecrementReg(D_WorkShoenTempReg1);
      b_IfLess(D_WorkShoenTempReg1, D_NULL) {break;}
      s_GetVectElementPosReg(fp_table, D_WorkShoenTempReg1,
			                                 D_WorkShoenTempReg2);
      s_GetVectElementPosReg(start_stop_bit_table, D_WorkShoenTempReg1,
			                                 D_WorkShoenTempReg3);
      b_BitwiseEorWithDNTC(D_WorkShoenTempReg2, D_WorkShoenTempReg3,
		                                         D_WorkShoenTempReg3);
      b_BitwiseAndWithDNTC(D_WorkShoenTempReg2, D_WorkShoenTempReg3,
		                                         D_WorkShoenTempReg3);
      p_SetImmediateType(INT, D_WorkShoenTempReg3);
      s_PutVectElementPosReg(dest_table_vect, D_WorkShoenTempReg1,
			                                 D_WorkShoenTempReg3);
    }
  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
  $RELEASE(D_WorkShoenTempReg3);
}
*/

/* !! */
#PSL_define  s_MakeStartedFPDestinationTable(fp_table_upper, fp_table_lower,
					     start_stop_bit_table_upper,
					     start_stop_bit_table_lower,
					     dest_table_upper, 
					     dest_table_lower)
{
  b_BitwiseEorWithDNTC(fp_table_upper, start_stop_bit_table_upper,
		                                        dest_table_upper);
  b_BitwiseEorWithDNTC(fp_table_lower, start_stop_bit_table_lower,
		                                        dest_table_lower);
  b_BitwiseAndWithDNTC(fp_table_upper, dest_table_upper, dest_table_upper);
  b_BitwiseAndWithDNTC(fp_table_lower, dest_table_lower, dest_table_lower);
}

/* Original
#PSL_define  s_UpdateWithStoppedFPDestinations(start_stop_bit_table, 
					                    dest_table_vect)
{
  $USE(D_WorkShoenTempReg1);
    /!* start/stop$B%S%C%H%F!<%V%k%Y%/%?D9$rJ];}$9$k(B *!/
  $USE(D_WorkShoenTempReg2);
    /!* start/stop$B%S%C%H%F!<%V%k%Y%/%?MWAG$rJ];}$9$k(B *!/
  $USE(D_WorkShoenTempReg3);
    /!* start/stop$B%S%C%H%F!<%V%k%Y%/%?$NMWAG$rJ];}$9$k(B *!/
  s_GetSizeVectType(start_stop_bit_table, D_WorkShoenTempReg1);
  LOOP()
    {
      b_DecrementReg(D_WorkShoenTempReg1);
      b_IfLess(D_WorkShoenTempReg1, D_NULL) {break;}
      s_GetVectElementPosReg(start_stop_bit_table, D_WorkShoenTempReg1,
			                                 D_WorkShoenTempReg2);
      s_GetVectElementPosReg(dest_table_vect, D_WorkShoenTempReg1,
			                                 D_WorkShoenTempReg3);
      b_BitwiseComplementWithDNTC(D_WorkShoenTempReg3, D_WorkShoenTempReg3);
      b_BitwiseAndWithDNTC(D_WorkShoenTempReg2, D_WorkShoenTempReg3,
		                                         D_WorkShoenTempReg3);
      p_SetImmediateType(INT, D_WorkShoenTempReg3);
      s_PutVectElementPosReg(start_stop_bit_table, D_WorkShoenTempReg1,
			                                 D_WorkShoenTempReg3);
    }
  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
  $RELEASE(D_WorkShoenTempReg3);
}
*/

/* !! */
#PSL_define  s_UpdateWithStoppedFPDestinations(start_stop_bit_table_upper, 
					       start_stop_bit_table_lower, 
					       dest_table_upper,
					       dest_table_lower)
{
  /* dest_table$B$NCf?H$r2u$5$J$$$?$a(B */
  $USE(D_WorkShoenTempReg1);
  $USE(D_WorkShoenTempReg2);
  p_MoveValue(dest_table_upper, D_WorkShoenTempReg1);
  p_MoveValue(dest_table_lower, D_WorkShoenTempReg2);

  b_BitwiseComplementWithDNTC(D_WorkShoenTempReg1, D_WorkShoenTempReg1);
  b_BitwiseComplementWithDNTC(D_WorkShoenTempReg2, D_WorkShoenTempReg2);
  b_BitwiseAndWithDNTC(start_stop_bit_table_upper, D_WorkShoenTempReg1,
		                                   start_stop_bit_table_upper);
  b_BitwiseAndWithDNTC(start_stop_bit_table_lower, D_WorkShoenTempReg2,
		                                   start_stop_bit_table_lower);
  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
}


/* Original
#PSL_define  s_UpdateWithStartedFPDestinations(start_stop_bit_table, 
					                    dest_table_vect)
{
  $USE(D_WorkShoenTempReg1);
    /!* start/stop$B%S%C%H%F!<%V%k%Y%/%?D9$rJ];}$9$k(B *!/
  $USE(D_WorkShoenTempReg2);
    /!* start/stop$B%S%C%H%F!<%V%k%Y%/%?MWAG$rJ];}$9$k(B *!/
  $USE(D_WorkShoenTempReg3);
    /!* start/stop$B%S%C%H%F!<%V%k%Y%/%?$NMWAG$rJ];}$9$k(B *!/
  s_GetSizeVectType(start_stop_bit_table, D_WorkShoenTempReg1);
  LOOP()
    {
      b_DecrementReg(D_WorkShoenTempReg1);
      b_IfLess(D_WorkShoenTempReg1, D_NULL) {break;}
      s_GetVectElementPosReg(start_stop_bit_table, D_WorkShoenTempReg1,
			                                 D_WorkShoenTempReg2);
      s_GetVectElementPosReg(dest_table_vect, D_WorkShoenTempReg1,
			                                 D_WorkShoenTempReg3);
      b_BitwiseOrWithDNTC(D_WorkShoenTempReg2, D_WorkShoenTempReg3,
		                                         D_WorkShoenTempReg3);
      p_SetImmediateType(INT, D_WorkShoenTempReg3);
      s_PutVectElementPosReg(start_stop_bit_table, D_WorkShoenTempReg1,
			                                 D_WorkShoenTempReg3);
    }
  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
  $RELEASE(D_WorkShoenTempReg3);
}
*/

/* !! */
#PSL_define  s_UpdateWithStartedFPDestinations(start_stop_bit_table_upper, 
					       start_stop_bit_table_lower, 
					       dest_table_upper,
					       dest_table_lower)
{
  b_BitwiseOrWithDNTC(start_stop_bit_table_upper, dest_table_upper,
		                                   start_stop_bit_table_upper);
  b_BitwiseOrWithDNTC(start_stop_bit_table_lower, dest_table_lower,
		                                   start_stop_bit_table_lower);
}


/******************************************************************** PSL **

(2.7) Ready/Terminate$B%+%&%s%?A`:nMQ%^%/%m(B

       written by kawai@icot22      on Fri Sep 21 17:53:21 1990
<Arguments>
  shoen_record : $BAq1`%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $BAq1`$N(BReady/Terminate$B%+%&%s%?$rA`:n$9$k!#(B
  Ready/Terminate$B%+%&%s%?$O!"N$?F$+$iAw$i$l$F$/$k(BReady$B%a%C%;!<%8$d(BTerminated
$B%a%C%;!<%8$r%+%&%s%H$9$k$?$a$N%+%&%s%?$G$"$j!"$3$l$i$N%a%C%;!<%84V$GDI$$1[$7$,(B
$B$"$C$?>l9g$K$bN$?F$,B8:_$9$k$+H]$+$rGD0.$9$k$?$a$KMQ$$$i$l$k!#(B
  Ready/Terminate$B%+%&%s%?$O%7%9%F%`Cf$N%/%i%9%??tJ,$@$1MQ0U$5$l$F$*$j!"$"$k%/%i(B
$B%9%?$NN$?F$+$i(B
  (1) Ready$B%a%C%;!<%8$,Mh$?;~$K$O(B $B!\(B 1
  (2) Terminated$B%a%C%;!<%8$,Mh$?;~$K$O(B $B!](B 1
$B$5$l$k$b$N$G$"$k!#=>$C$F!"$3$N%+%&%s%?$,@5$N;~$K$O$=$N%/%i%9%?$K$ON$?F$,B8:_$9(B
$B$k2DG=@-$,$"$k$3$H$,J,$+$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CONST_define  _SIZE_OF_READY_TERMINATE_CNT_TABLE   8

/* !! New */
#PSL_define  s_InitShoenReadyTerminateCounter(shoen_record)
{
  $USE(D_WorkShoenTempReg1);
  $USE(D_WorkShoenTempReg2);
  $USE(D_WorkShoenTempReg3);

  b_AddImmediateWithDNTC(shoen_record, _PTR_TO_READY_TERMINATE_CNT_OFST,
			                                D_WorkShoenTempReg1);
  b_SetImmValueDNTC(_SIZE_OF_READY_TERMINATE_CNT_TABLE, D_WorkShoenTempReg2);

  b_SetImmValueDNTC(_INIT_READY_TERMINATE_COUNTER_VALUE, D_WorkShoenTempReg3);
		     
  LOOP() {
    b_DecrementReg(D_WorkShoenTempReg2);
    b_IfLess(D_WorkShoenTempReg2, D_NULL) {break;}
    p_Write(D_WorkShoenTempReg3, D_WorkShoenTempReg1);
    b_IncrementAddrReg(D_WorkShoenTempReg1);
  }
  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
  $RELEASE(D_WorkShoenTempReg3);
}


/* Original
#PSL_define  s_GetReadyTerminateCount(shoen_record, cl_num_reg, count_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetReadyTerminatedCount","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
    /!* $B%(%i!<%A%'%C%/5Z$S(BReady/Terminate$B%+%&%s%?%Y%/%?$NJ];}MQ(B *!/
  $USE(D_WorkShoenTempReg2);
    /!* Ready/Terminate$B%+%&%s%?%Y%/%?$N2?%o!<%IL\$+$rJ];}(B *!/
  $USE(D_WorkShoenTempReg3);
    /!* $B%o!<%ICf$N%7%U%HCM$rJ];}(B *!/
  $USE(D_WorkShoenTempReg4);
    /!* Ready/Terminate$B%+%&%s%?CM$rJ];}(B *!/
  @DEBUG{
    b_ReadClusterNumInSystem(D_WorkShoenTempReg1);
    b_IfGreaterEq(cl_num_reg, D_WorkShoenTempReg1)
      {
	VPIM_ERROR("s_GetReadyTerminatedCount", "Illegal Cluster Number");
      }
  };

  s_GetShoenReadyTerminateCounter(shoen_record, D_WorkShoenTempReg1);
  b_DivideImmediateWithDNTC(cl_num_reg, _READY_TERMINATE_COUNTER_PER_WORD,
		                                         D_WorkShoenTempReg2);
  s_GetVectElementPosReg(D_WorkShoenTempReg1, D_WorkShoenTempReg2,
			                                 D_WorkShoenTempReg2);
  b_ModuloImmediateWithDNTC(cl_num_reg, _READY_TERMINATE_COUNTER_PER_WORD,
		                                         D_WorkShoenTempReg3);
  b_MultiplyImmediateWithDNTC(D_WorkShoenTempReg3,
			      _READY_TERMINATE_COUNTER_SHIFT_UNIT,
		                                         D_WorkShoenTempReg3);
  p_SetImmediateValue(_READY_TERMINATE_COUNTER_MASK_PATTERN,
		                                         D_WorkShoenTempReg4);
  b_ShiftLeftWithDNTC(D_WorkShoenTempReg4,
		                    D_WorkShoenTempReg3, D_WorkShoenTempReg4);
  b_BitwiseAndWithDNTC(D_WorkShoenTempReg4,
		                    D_WorkShoenTempReg2, D_WorkShoenTempReg4);
  b_ShiftRightWithDNTC(D_WorkShoenTempReg4, D_WorkShoenTempReg3, count_reg);
  b_SubtractImmediateWithDNTC(count_reg, _READY_TERMINATE_COUNTER_BASE,
			                                           count_reg);
  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
  $RELEASE(D_WorkShoenTempReg3);
  $RELEASE(D_WorkShoenTempReg4);
}
*/

/* !! */
#ADDR_define _SHOEN_WORD_ADDR_OFST  1

#PSL_define  s_GetReadyTerminateCount(shoen_record, cl_num_reg, count_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    VPIM_ERROR("s_GetReadyTerminatedCount","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
    /* Ready/Terminate$B%+%&%s%?NN0h$N2?%o!<%IL\$+$rJ];}(B */
  $USE(D_WorkShoenTempReg2);
    /* $B%/%i%9%?HV9f$KAjEv$9$k%+%&%s%?$r4^$`%o!<%I$rJ];}(B */
  $USE(D_WorkShoenTempReg3);
    /* $B%o!<%ICf$N%7%U%HCM$rJ];}(B */

  @DEBUG{
    b_ReadClusterNumInSystem(D_WorkShoenTempReg1);
    b_IfGreaterEq(cl_num_reg, D_WorkShoenTempReg1)
      {
	VPIM_ERROR("s_GetReadyTerminatedCount", "Illegal Cluster Number");
      }
  };
  b_DivideImmediateWithDNTC(cl_num_reg, _READY_TERMINATE_COUNTER_PER_WORD,
		                                         D_WorkShoenTempReg1);
  /* !! Ready/Terminate$B%+%&%s%?Cf$N2?%o!<%IL\$+$r%^%7%s$N%"%I%l%C%7%s%0$K(B
        $B9g$o$;$F49;;$9$k!#(B*/
  b_MultiplyImmediateWithDNTC(D_WorkShoenTempReg1, _SHOEN_WORD_ADDR_OFST,
		                                         D_WorkShoenTempReg1);
  b_AddImmediateWithDNTC(shoen_record, _PTR_TO_READY_TERMINATE_CNT_OFST,
		                                         D_WorkShoenTempReg2);
  b_AddWithDNTC(D_WorkShoenTempReg1, D_WorkShoenTempReg2, D_WorkShoenTempReg1);
  p_Read(D_WorkShoenTempReg1, D_WorkShoenTempReg2);
  b_ModuloImmediateWithDNTC(cl_num_reg, _READY_TERMINATE_COUNTER_PER_WORD,
		                                         D_WorkShoenTempReg3);
  b_MultiplyImmediateWithDNTC(D_WorkShoenTempReg3,
			      _READY_TERMINATE_COUNTER_SHIFT_UNIT,
		                                         D_WorkShoenTempReg3);
  p_SetImmediateValue(_READY_TERMINATE_COUNTER_MASK_PATTERN, count_reg);
		                                         
  b_ShiftLeftWithDNTC(count_reg, D_WorkShoenTempReg3, count_reg);
  b_BitwiseAndWithDNTC(count_reg, D_WorkShoenTempReg2, count_reg);
  b_ShiftRightWithDNTC(count_reg, D_WorkShoenTempReg3, count_reg);
  b_SubtractImmediateWithDNTC(count_reg, _READY_TERMINATE_COUNTER_BASE,
			                                           count_reg);
  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
  $RELEASE(D_WorkShoenTempReg3);
}


/* Original
#PSL_define  s_IncrementReadyTerminateCount(shoen_record, cl_num_reg,
					                           result_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetReadyTerminatedCount","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
    /!* $B%(%i!<%A%'%C%/5Z$S(BReady/Terminate$B%+%&%s%?%Y%/%?$NJ];}MQ(B *!/
  $USE(D_WorkShoenTempReg2);
    /!* Ready/Terminate$B%+%&%s%?%Y%/%?$N2?%o!<%IL\$+$rJ];}(B *!/
  $USE(D_WorkShoenTempReg3);
    /!* $B%o!<%ICf$N%7%U%HCM$rJ];}(B *!/
  $USE(D_WorkShoenTempReg4);
    /!* Ready/Terminate$B%+%&%s%?CM$rJ];}(B *!/
  $USE(D_WorkShoenTempReg5);
  @DEBUG{
    b_ReadClusterNumInSystem(D_WorkShoenTempReg1);
    b_IfGreaterEq(cl_num_reg, D_WorkShoenTempReg1)
      {
	VPIM_ERROR("s_GetReadyTerminatedCount", "Illegal Cluster Number");
      }
  };

  s_GetShoenReadyTerminateCounter(shoen_record, D_WorkShoenTempReg1);
  b_DivideImmediateWithDNTC(cl_num_reg, _READY_TERMINATE_COUNTER_PER_WORD,
		                                         D_WorkShoenTempReg2);
  s_GetVectElementPosReg(D_WorkShoenTempReg1, D_WorkShoenTempReg2,
			                                 D_WorkShoenTempReg3);
  b_ModuloImmediateWithDNTC(cl_num_reg, _READY_TERMINATE_COUNTER_PER_WORD,
		                                         D_WorkShoenTempReg4);
  b_MultiplyImmediateWithDNTC(D_WorkShoenTempReg4,
			      _READY_TERMINATE_COUNTER_SHIFT_UNIT,
		                                         D_WorkShoenTempReg4);
  p_SetImmediateValue(_READY_TERMINATE_COUNTER_MASK_PATTERN,
		                                         D_WorkShoenTempReg5);
  b_ShiftLeftWithDNTC(D_WorkShoenTempReg5, D_WorkShoenTempReg4,
		                                         D_WorkShoenTempReg5);
  b_BitwiseAndWithDNTC(D_WorkShoenTempReg5, D_WorkShoenTempReg3, result_reg);
  b_ShiftRightWithDNTC(result_reg, D_WorkShoenTempReg4, result_reg);
  b_IncrementReg(result_reg);
  @DEBUG{
    b_IfGreaterImm(result_reg, _READY_TERMINATE_COUNTER_LIMIT)
      {VPIM_ERROR("s_IncrementReadyTerminateCount",
		                        "Ready/Terminate Counter Overflow !");
     }
  };
  b_BitwiseComplementWithDNTC(D_WorkShoenTempReg5, D_WorkShoenTempReg5);
  b_BitwiseAndWithDNTC(D_WorkShoenTempReg3, D_WorkShoenTempReg5,
		                                         D_WorkShoenTempReg3);
  b_ShiftLeftWithDNTC(result_reg, D_WorkShoenTempReg4, D_WorkShoenTempReg5);
  b_BitwiseOrWithDNTC(D_WorkShoenTempReg3, D_WorkShoenTempReg5,
		                                         D_WorkShoenTempReg3);
  p_SetImmediateType(INT, D_WorkShoenTempReg3);
  s_PutVectElementPosReg(D_WorkShoenTempReg1, D_WorkShoenTempReg2,
			                                 D_WorkShoenTempReg3);
  b_SubtractImmediateWithDNTC(result_reg, _READY_TERMINATE_COUNTER_BASE,
			                                          result_reg);
  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
  $RELEASE(D_WorkShoenTempReg3);
  $RELEASE(D_WorkShoenTempReg4);
  $RELEASE(D_WorkShoenTempReg5);
}
*/

/* !! */
#PSL_define  s_IncrementReadyTerminateCount(shoen_record, cl_num_reg,
					                           result_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    VPIM_ERROR("s_IncrementReadyTerminateCount","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
    /* Ready/Terminate$B%+%&%s%?NN0h$N2?%o!<%IL\$+$rJ];}(B */
  $USE(D_WorkShoenTempReg2);
    /* $B%/%i%9%?HV9f$KAjEv$9$k%+%&%s%?$r4^$`%o!<%I$rJ];}(B */
  $USE(D_WorkShoenTempReg3);
    /* $B%o!<%ICf$N%7%U%HCM$rJ];}(B */
  $USE(D_WorkShoenTempReg4);
  @DEBUG{
    b_ReadClusterNumInSystem(D_WorkShoenTempReg1);
    b_IfGreaterEq(cl_num_reg, D_WorkShoenTempReg1)
      {
	VPIM_ERROR("s_IncrementReadyTerminateCount", "Illegal Cluster Number");
      }
  };

  b_DivideImmediateWithDNTC(cl_num_reg, _READY_TERMINATE_COUNTER_PER_WORD,
		                                         D_WorkShoenTempReg1);
  /* !! Ready/Terminate$B%+%&%s%?Cf$N2?%o!<%IL\$+$r%^%7%s$N%"%I%l%C%7%s%0$K(B
        $B9g$o$;$F49;;$9$k!#(B*/
  b_MultiplyImmediateWithDNTC(D_WorkShoenTempReg1, _SHOEN_WORD_ADDR_OFST,
		                                         D_WorkShoenTempReg1);
  b_AddImmediateWithDNTC(shoen_record, _PTR_TO_READY_TERMINATE_CNT_OFST,
		                                         D_WorkShoenTempReg2);
  b_AddWithDNTC(D_WorkShoenTempReg1, D_WorkShoenTempReg2, D_WorkShoenTempReg1);
  p_Read(D_WorkShoenTempReg1, D_WorkShoenTempReg2);

  b_ModuloImmediateWithDNTC(cl_num_reg, _READY_TERMINATE_COUNTER_PER_WORD,
		                                         D_WorkShoenTempReg3);
  b_MultiplyImmediateWithDNTC(D_WorkShoenTempReg3,
			      _READY_TERMINATE_COUNTER_SHIFT_UNIT,
		                                         D_WorkShoenTempReg3);
  p_SetImmediateValue(_READY_TERMINATE_COUNTER_MASK_PATTERN,
		                                         D_WorkShoenTempReg4);
  b_ShiftLeftWithDNTC(D_WorkShoenTempReg4, D_WorkShoenTempReg3,
		                                         D_WorkShoenTempReg4);
  b_BitwiseAndWithDNTC(D_WorkShoenTempReg4, D_WorkShoenTempReg2, result_reg);
  b_ShiftRightWithDNTC(result_reg, D_WorkShoenTempReg3, result_reg);
  b_IncrementReg(result_reg);
  @DEBUG{
    b_IfGreaterImm(result_reg, _READY_TERMINATE_COUNTER_LIMIT)
      {VPIM_ERROR("s_IncrementReadyTerminateCount",
		                        "Ready/Terminate Counter Overflow !");
     }
  };
  b_BitwiseComplementWithDNTC(D_WorkShoenTempReg4, D_WorkShoenTempReg4);
  b_BitwiseAndWithDNTC(D_WorkShoenTempReg2, D_WorkShoenTempReg4,
		                                         D_WorkShoenTempReg2);
  b_ShiftLeftWithDNTC(result_reg, D_WorkShoenTempReg3, D_WorkShoenTempReg4);
  b_BitwiseOrWithDNTC(D_WorkShoenTempReg2, D_WorkShoenTempReg4,
		                                         D_WorkShoenTempReg2);
  p_Write(D_WorkShoenTempReg2, D_WorkShoenTempReg1);
  b_SubtractImmediateWithDNTC(result_reg, _READY_TERMINATE_COUNTER_BASE,
			                                          result_reg);
  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
  $RELEASE(D_WorkShoenTempReg3);
  $RELEASE(D_WorkShoenTempReg4);
}


/* Original
#PSL_define  s_DecrementReadyTerminateCount(shoen_record, cl_num_reg,
					                           result_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_GetReadyTerminatedCount","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
    /!* $B%(%i!<%A%'%C%/5Z$S(BReady/Terminate$B%+%&%s%?%Y%/%?$NJ];}MQ(B *!/
  $USE(D_WorkShoenTempReg2);
    /!* Ready/Terminate$B%+%&%s%?%Y%/%?$N2?%o!<%IL\$+$rJ];}(B *!/
  $USE(D_WorkShoenTempReg3);
    /!* $B%o!<%ICf$N%7%U%HCM$rJ];}(B *!/
  $USE(D_WorkShoenTempReg4);
    /!* Ready/Terminate$B%+%&%s%?CM$rJ];}(B *!/
  $USE(D_WorkShoenTempReg5);
  @DEBUG{
    b_ReadClusterNumInSystem(D_WorkShoenTempReg1);
    b_IfGreaterEq(cl_num_reg, D_WorkShoenTempReg1)
      {
	VPIM_ERROR("s_GetReadyTerminatedCount", "Illegal Cluster Number");
      }
  };

  s_GetShoenReadyTerminateCounter(shoen_record, D_WorkShoenTempReg1);
  b_DivideImmediateWithDNTC(cl_num_reg, _READY_TERMINATE_COUNTER_PER_WORD,
		                                         D_WorkShoenTempReg2);
  s_GetVectElementPosReg(D_WorkShoenTempReg1, D_WorkShoenTempReg2,
			                                 D_WorkShoenTempReg3);
  b_ModuloImmediateWithDNTC(cl_num_reg, _READY_TERMINATE_COUNTER_PER_WORD,
		                                         D_WorkShoenTempReg4);
  b_MultiplyImmediateWithDNTC(D_WorkShoenTempReg4,
			      _READY_TERMINATE_COUNTER_SHIFT_UNIT,
		                                         D_WorkShoenTempReg4);
  p_SetImmediateValue(_READY_TERMINATE_COUNTER_MASK_PATTERN,
		                                         D_WorkShoenTempReg5);
  b_ShiftLeftWithDNTC(D_WorkShoenTempReg5, D_WorkShoenTempReg4,
		                                         D_WorkShoenTempReg5);
  b_BitwiseAndWithDNTC(D_WorkShoenTempReg5, D_WorkShoenTempReg3, result_reg);
  b_ShiftRightWithDNTC(result_reg, D_WorkShoenTempReg4, result_reg);
  b_DecrementReg(result_reg);
  @DEBUG{
    b_IfLess(result_reg, D_NULL)
      {VPIM_ERROR("s_IncrementReadyTerminateCount",
		                        "Ready/Terminate Counter Underflow !");
     }
  };
  b_BitwiseComplementWithDNTC(D_WorkShoenTempReg5, D_WorkShoenTempReg5);
  b_BitwiseAndWithDNTC(D_WorkShoenTempReg3, D_WorkShoenTempReg5,
		                                         D_WorkShoenTempReg3);
  b_ShiftLeftWithDNTC(result_reg, D_WorkShoenTempReg4, D_WorkShoenTempReg5);
  b_BitwiseOrWithDNTC(D_WorkShoenTempReg3, D_WorkShoenTempReg5,
		                                         D_WorkShoenTempReg3);
  p_SetImmediateType(INT, D_WorkShoenTempReg3);
  s_PutVectElementPosReg(D_WorkShoenTempReg1, D_WorkShoenTempReg2,
			                                 D_WorkShoenTempReg3);
  b_SubtractImmediateWithDNTC(result_reg, _READY_TERMINATE_COUNTER_BASE,
			                                          result_reg);
  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
  $RELEASE(D_WorkShoenTempReg3);
  $RELEASE(D_WorkShoenTempReg4);
  $RELEASE(D_WorkShoenTempReg5);
}
*/

/* !! */
#PSL_define  s_DecrementReadyTerminateCount(shoen_record, cl_num_reg,
					                           result_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    VPIM_ERROR("s_DecrementReadyTerminateCount","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
    /* Ready/Terminate$B%+%&%s%?NN0h$N2?%o!<%IL\$+$rJ];}(B */
  $USE(D_WorkShoenTempReg2);
    /* $B%/%i%9%?HV9f$KAjEv$9$k%+%&%s%?$r4^$`%o!<%I$rJ];}(B */
  $USE(D_WorkShoenTempReg3);
    /* $B%o!<%ICf$N%7%U%HCM$rJ];}(B */
  $USE(D_WorkShoenTempReg4);
  @DEBUG{
    b_ReadClusterNumInSystem(D_WorkShoenTempReg1);
    b_IfGreaterEq(cl_num_reg, D_WorkShoenTempReg1)
      {
	VPIM_ERROR("s_DecrementReadyTerminateCount", "Illegal Cluster Number");
      }
  };

  b_DivideImmediateWithDNTC(cl_num_reg, _READY_TERMINATE_COUNTER_PER_WORD,
		                                         D_WorkShoenTempReg1);
  /* !! Ready/Terminate$B%+%&%s%?Cf$N2?%o!<%IL\$+$r%^%7%s$N%"%I%l%C%7%s%0$K(B
        $B9g$o$;$F49;;$9$k!#(B*/
  b_MultiplyImmediateWithDNTC(D_WorkShoenTempReg1, _SHOEN_WORD_ADDR_OFST,
		                                         D_WorkShoenTempReg1);
  b_AddImmediateWithDNTC(shoen_record, _PTR_TO_READY_TERMINATE_CNT_OFST,
		                                         D_WorkShoenTempReg2);
  b_AddWithDNTC(D_WorkShoenTempReg1, D_WorkShoenTempReg2, D_WorkShoenTempReg1);
  p_Read(D_WorkShoenTempReg1, D_WorkShoenTempReg2);

  b_ModuloImmediateWithDNTC(cl_num_reg, _READY_TERMINATE_COUNTER_PER_WORD,
		                                         D_WorkShoenTempReg3);
  b_MultiplyImmediateWithDNTC(D_WorkShoenTempReg3,
			      _READY_TERMINATE_COUNTER_SHIFT_UNIT,
		                                         D_WorkShoenTempReg3);
  p_SetImmediateValue(_READY_TERMINATE_COUNTER_MASK_PATTERN,
		                                         D_WorkShoenTempReg4);
  b_ShiftLeftWithDNTC(D_WorkShoenTempReg4, D_WorkShoenTempReg3,
		                                         D_WorkShoenTempReg4);
  b_BitwiseAndWithDNTC(D_WorkShoenTempReg4, D_WorkShoenTempReg2, result_reg);
  b_ShiftRightWithDNTC(result_reg, D_WorkShoenTempReg3, result_reg);
  b_DecrementReg(result_reg);
  @DEBUG{
    b_IfLess(result_reg, D_NULL)
      {VPIM_ERROR("s_DecrementReadyTerminateCount",
		                        "Ready/Terminate Counter Underflow !");
     }
  };
  b_BitwiseComplementWithDNTC(D_WorkShoenTempReg4, D_WorkShoenTempReg4);
  b_BitwiseAndWithDNTC(D_WorkShoenTempReg2, D_WorkShoenTempReg4,
		                                         D_WorkShoenTempReg2);
  b_ShiftLeftWithDNTC(result_reg, D_WorkShoenTempReg3, D_WorkShoenTempReg4);
  b_BitwiseOrWithDNTC(D_WorkShoenTempReg2, D_WorkShoenTempReg4,
		                                         D_WorkShoenTempReg2);
  p_Write(D_WorkShoenTempReg2, D_WorkShoenTempReg1);
  b_SubtractImmediateWithDNTC(result_reg, _READY_TERMINATE_COUNTER_BASE,
			                                          result_reg);
  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
  $RELEASE(D_WorkShoenTempReg3);
  $RELEASE(D_WorkShoenTempReg4);
}


#PSL_define  s_CountReadyMessage(shoen_record, cl_num_reg, result)
{ /* $B%/%i%9%?HV9f$KBP1~$9$k(B Ready/Terminated$B%a%C%;!<%8%+%&%s%H$r(B
     $B%$%s%/%j%a%s%H$7!"$=$N7k2L$r(B result$B$KJV$9!#(B */
  s_IncrementReadyTerminateCount(shoen_record, cl_num_reg, result);
}

#PSL_define  s_CountTerminatedMessage(shoen_record, cl_num_reg, result)
{ /* $B%/%i%9%?HV9f$KBP1~$9$k(B Ready/Terminated$B%a%C%;!<%8%+%&%s%H$r(B
     $B%G%/%j%a%s%H$7!"$=$N7k2L$r(B result$B$KJV$9!#(B */
  s_DecrementReadyTerminateCount(shoen_record, cl_num_reg, result);
}


/******************************************************************** PSL **

       written by kawai@icot22      on Thu May 16 21:43:32 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

/* $BDI2C(B */
#PSL_define  s_IncrementAskProfileFPCount(shoen_record)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    VPIM_ERROR("s_IncrementAskProfileFPCount","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  s_GetAskProfileFPCount(shoen_record, D_WorkShoenTempReg1);
  b_IncrementReg(D_WorkShoenTempReg1);

  @DEBUG
    {
      $USE(D_WorkShoenTempReg2);
      b_ReadClusterNumInSystem(D_WorkShoenTempReg2);
      b_IfGreater(D_WorkShoenTempReg1, D_WorkShoenTempReg2)
	{ /* ProfileCount > ClusterNumInSystem$B$N$H$-(B */
	  VPIM_ERROR("s_IncrementAskProfileFPCount",
		                            "AskProfileFPCount overflow");
	  b_DecrementReg(D_WorkShoenTempReg1);
	}
      $RELEASE(D_WorkShoenTempReg2);
    };

  s_PutAskProfileFPCount(shoen_record, D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg1);
}



#PSL_define  s_DecrementAskProfileFPCount(shoen_record)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    VPIM_ERROR("s_DecrementAskProfileFPCount","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  s_GetAskProfileFPCount(shoen_record, D_WorkShoenTempReg1);
  b_DecrementReg(D_WorkShoenTempReg1);

  @DEBUG
    {
      b_IfLess(D_WorkShoenTempReg1, D_NULL)
	{ /* ProfileCount < 0 $B$N$H$-(B */
	  VPIM_ERROR("s_DecrementAskProfileFPCount",
		                             "AskProfileFPCount underflow");
	  b_IncrementReg(D_WorkShoenTempReg1);
	}
    };

  s_PutAskProfileFPCount(shoen_record, D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg1);
}



#PSL_define  s_AddAskProfileFPCount(shoen_record, count)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    VPIM_ERROR("s_AddAskProfileFPCount","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  s_GetAskProfileFPCount(shoen_record, D_WorkShoenTempReg1);
  b_AddWithDNTC(D_WorkShoenTempReg1, count, D_WorkShoenTempReg1);

  @DEBUG
    {
      $USE(D_WorkShoenTempReg2);
      b_ReadClusterNumInSystem(D_WorkShoenTempReg2);
      b_IfGreater(D_WorkShoenTempReg1, D_WorkShoenTempReg2)
	{ /* ProfileCount > ClusterNumInSystem$B$N$H$-(B */
	  VPIM_ERROR("s_AddAskProfileFPCount","AskProfileFPCount overflow");
	  b_SubtractWithDNTC(D_WorkShoenTempReg1, count, D_WorkShoenTempReg1);
	}
      $RELEASE(D_WorkShoenTempReg2);
    };

  s_PutAskProfileFPCount(shoen_record, D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg1);
}


/* $BDI2C(B */
#PSL_define  s_AddSHTotalAnsProfileCount(shoen_record, count)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    VPIM_ERROR("s_AddSHTotalAnsProfileCount","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  s_GetSHTotalAnsProfileCount(shoen_record, D_WorkShoenTempReg1);
  b_AddWithDNTC(D_WorkShoenTempReg1, count, D_WorkShoenTempReg1);
  s_PutSHTotalAnsProfileCount(shoen_record, D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg1);
}


/* $BDI2C(B */
#PSL_define  s_IncrementReportedProfileCount(shoen_record)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    VPIM_ERROR("s_IncrementReportedProfileCount","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  s_GetReportedProfileCount(shoen_record, D_WorkShoenTempReg1);
  b_IncrementReg(D_WorkShoenTempReg1);
  s_PutReportedProfileCount(shoen_record, D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg1);
}

/* $BDI2C(B */
#PSL_define  s_ResetSHProfileCounters(shoen_record)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    VPIM_ERROR("s_ResetSHProfileCounters","Not SHREC Type");}};

  s_PutAskProfileFPCount(shoen_record, D_NULL);
  s_PutReportedProfileCount(shoen_record, D_NULL);
  s_PutSHTotalAnsProfileCount(shoen_record, D_NULL);
}


/******************************************************************** PSL **

(3) $B%9%m%C%H$NCM$NH=DjMQ%^%/%m(B

       written by kawai@icot22      on Mon May 21 16:36:36 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

/******************************************************************** PSL **

(3.1) $BAq1`$N>uBV$rLd$$9g$o$;$k$?$a$N%^%/%m(B

       written by kawai@icot22      on Thu Jul 26 21:59:29 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/


#CTRL_define  s_IfShoenTransitStatusImmediately(shoen_record, imm_status)
{
  $USE(D_WorkShoenTempReg1);
  s_GetShoenTransitStatus(shoen_record, D_WorkShoenTempReg1);
  p_CompareImmediate(D_WorkShoenTempReg1, imm_status);
  $RELEASE(D_WorkShoenTempReg1);
  p_IfEQ()
}



#CTRL_define  s_IfShoenStatusFlagOn(shoen_record, imm_flag_mask)
{
  $USE(D_WorkShoenTempReg1);
  s_GetShoenStatusFlag(shoen_record, imm_flag_mask, D_WorkShoenTempReg1);
  p_CompareImmediate(D_WorkShoenTempReg1, imm_flag_mask);
  $RELEASE(D_WorkShoenTempReg1);
  p_IfEQ()
}



#CTRL_define  s_IfShoenStatusFlagOff(shoen_record, imm_flag_mask)
{
  $USE(D_WorkShoenTempReg1);
  s_GetShoenStatusFlag(shoen_record, imm_flag_mask, D_WorkShoenTempReg1);
  p_CompareImmediate(D_WorkShoenTempReg1, imm_flag_mask);
  $RELEASE(D_WorkShoenTempReg1);
  p_IfNE()
}


#CTRL_define  s_IfShoenStopped(shoen_record)
{
  $USE(D_WorkShoenTransitStatus);
  s_GetShoenTransitStatus(shoen_record, D_WorkShoenTransitStatus);
  ValueSwitch(D_WorkShoenTransitStatus)
    {
    case _STOPPED_BY_CTRL:
    case _STOPPED_BY_PARENT:
    case _STOPPED_BY_BOTH:
      b_SetSuccess();
      break;
    case _STARTED:
    case _ABORTED:
    case _TERMINATED:
      b_SetFail();
      break;
    default:
      @DEBUG{ VPIM_ERROR("s_IfShoenStopped","Illegal Shoen Transit Status"); };
    }
  $RELEASE(D_WorkShoenTransitStatus);
  b_IfSuccess()
}

/* Original
#CTRL_define  s_IfFPTableFlagOn(shoen_record, cl_num_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_IfFPTableFlagOn","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  $USE(D_WorkShoenTempReg2);
  s_GetFPTable(shoen_record, D_WorkShoenTempReg1);
  s_GetFPBitTableFlag(D_WorkShoenTempReg1, cl_num_reg, D_WorkShoenTempReg2);
  p_CompareImmediate(D_WorkShoenTempReg2, _FP_BIT_TBL_FLAG_ON);
  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
  p_IfEQ()
}
*/

/* !! */
#CTRL_define  s_IfFPTableFlagOn(shoen_record, cl_num_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    VPIM_ERROR("s_IfFPTableFlagOn","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  $USE(D_WorkShoenTempReg2);
  s_GetFPTable(shoen_record, D_WorkShoenTempReg1, D_WorkShoenTempReg2);

  b_IfGreaterEqImm(cl_num_reg, _WORD_BIT_LENGTH)
    {
      $USE(D_WorkShoenTempReg3); /* upper fp_table$BCf$N%S%C%H0LCV$rJ];}$9$k(B */
      b_SubtractImmediateWithDNTC(cl_num_reg, _WORD_BIT_LENGTH,
				                        D_WorkShoenTempReg3);
      b_IfFlagOnPosReg(D_WorkShoenTempReg1, D_WorkShoenTempReg3)
	{
	  b_SetSuccess();
	}
      else
	{
	  b_SetFail();
	}
      $RELEASE(D_WorkShoenTempReg3);
    }
  else
    {
      b_IfFlagOnPosReg(D_WorkShoenTempReg2, cl_num_reg)
	{
	  b_SetSuccess();
	}
      else
	{
	  b_SetFail();
	}
    }

  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
  b_IfSuccess()
}


/* Original
#CTRL_define  s_IfResourceRequestFPTableFlagOn(shoen_record, cl_num_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_IfResourceRequestFPTableFlagOn","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  $USE(D_WorkShoenTempReg2);
  s_GetResourceRequestFPTable(shoen_record, D_WorkShoenTempReg1);
  s_GetFPBitTableFlag(D_WorkShoenTempReg1, cl_num_reg, D_WorkShoenTempReg2);
  p_CompareImmediate(D_WorkShoenTempReg2, _FP_BIT_TBL_FLAG_ON);
  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
  p_IfEQ()
}
*/

/* !! */
#CTRL_define  s_IfResourceRequestFPTableFlagOn(shoen_record, cl_num_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    VPIM_ERROR("s_IfResourceRequestFPTableFlagOn","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  $USE(D_WorkShoenTempReg2);
  s_GetResourceRequestFPTable(shoen_record,
			      D_WorkShoenTempReg1, D_WorkShoenTempReg2);

  b_IfGreaterEqImm(cl_num_reg, _WORD_BIT_LENGTH)
    {
      $USE(D_WorkShoenTempReg3); /* upper fp_table$BCf$N%S%C%H0LCV$rJ];}$9$k(B */
      b_SubtractImmediateWithDNTC(cl_num_reg, _WORD_BIT_LENGTH,
				                        D_WorkShoenTempReg3);
      b_IfFlagOnPosReg(D_WorkShoenTempReg1, D_WorkShoenTempReg3)
	{
	  b_SetSuccess();
	}
      else
	{
	  b_SetFail();
	}
      $RELEASE(D_WorkShoenTempReg3);
    }
  else
    {
      b_IfFlagOnPosReg(D_WorkShoenTempReg2, cl_num_reg)
	{
	  b_SetSuccess();
	}
      else
	{
	  b_SetFail();
	}
    }

  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
  b_IfSuccess()
}

/* Original
#CTRL_define  s_IfNotEmptyShoenResReqFPTable(shoen_record)

{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_IfNotEmptyShoenResReqFPTable","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
    /!* ResourceRequestFPTable$B%Y%/%?$NJ];}MQ(B *!/
  $USE(D_WorkShoenTempReg2);
    /!* ResourceRequestFPTable$B%Y%/%?$N%5%$%:$rJ];}(B *!/
  $USE(D_WorkShoenTempReg3);
    /!* ResourceRequestFPTable$B%Y%/%?$NMWAG$rJ];}(B *!/

  s_GetResourceRequestFPTable(shoen_record, D_WorkShoenTempReg1);
  s_GetSizeVectType(D_WorkShoenTempReg1, D_WorkShoenTempReg2);
  LOOP()
    {
      b_DecrementReg(D_WorkShoenTempReg2);
      b_IfLess(D_WorkShoenTempReg2, D_NULL) {break;}
      s_GetVectElementPosReg(D_WorkShoenTempReg1, D_WorkShoenTempReg2,
			                               D_WorkShoenTempReg3);
      b_IfNotEqual(D_WorkShoenTempReg3, D_NULL) {break;}
    }
  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg3);
  p_Compare(D_WorkShoenTempReg2, D_NULL);
  $RELEASE(D_WorkShoenTempReg2);
  p_IfGE()
}
*/

/* !! */
#CTRL_define  s_IfNotEmptyShoenResReqFPTable(shoen_record)

{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    VPIM_ERROR("s_IfNotEmptyShoenResReqFPTable","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  $USE(D_WorkShoenTempReg2);

  s_GetResourceRequestFPTable(shoen_record,
			      D_WorkShoenTempReg1, D_WorkShoenTempReg2);
  b_IfNotEqual(D_WorkShoenTempReg1, D_NULL)
    {
      b_SetSuccess();
    }
  else
    {
      b_IfNotEqual(D_WorkShoenTempReg2, D_NULL)
	{
	  b_SetSuccess();
	}
      else
	{
	  b_SetFail();
	}
    }

  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
  b_IfSuccess()
}



#CTRL_define  s_IfEnoughShoenResourceLeft(shoen_record, rsc_upper_reg,
					                      rsc_lower_reg)
{
  $USE(D_WorkShoenTempReg1);
  $USE(D_WorkShoenTempReg2);
  s_GetShoenResourceLeft(shoen_record, D_WorkShoenTempReg1,
			                                D_WorkShoenTempReg2);
  b_SubtractDoubleWord(D_WorkShoenTempReg1, D_WorkShoenTempReg2, 
		                            rsc_upper_reg, rsc_lower_reg, 
		                   D_WorkShoenTempReg1, D_WorkShoenTempReg2);
  p_Compare(D_WorkShoenTempReg1, D_NULL);
  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
  p_IfGE()
}



#CTRL_define  s_IfNotEnoughShoenResourceLeft(shoen_record, rsc_upper_reg,
					                      rsc_lower_reg)
{
  $USE(D_WorkShoenTempReg1);
  $USE(D_WorkShoenTempReg2);
  s_GetShoenResourceLeft(shoen_record, D_WorkShoenTempReg1,
			                                D_WorkShoenTempReg2);
  b_SubtractDoubleWord(D_WorkShoenTempReg1, D_WorkShoenTempReg2, 
		                            rsc_upper_reg, rsc_lower_reg, 
		                   D_WorkShoenTempReg1, D_WorkShoenTempReg2);
  p_Compare(D_WorkShoenTempReg1, D_NULL);
  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
  p_IfLT()
}



#CTRL_define  s_IfEnoughShoenResourceLimitLeft(shoen_record, rsc_upper_reg,
					                       rsc_lower_reg)
{
  $USE(D_WorkShoenTempReg1);
  $USE(D_WorkShoenTempReg2);
  s_GetShoenResourceLimitLeft(shoen_record, D_WorkShoenTempReg1,
			                                D_WorkShoenTempReg2);
  b_SubtractDoubleWord(D_WorkShoenTempReg1, D_WorkShoenTempReg2, 
		                            rsc_upper_reg, rsc_lower_reg, 
		                   D_WorkShoenTempReg1, D_WorkShoenTempReg2);
  p_Compare(D_WorkShoenTempReg1, D_NULL);
  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
  p_IfGE()
}



#CTRL_define  s_IfNotShoenUnhookReserved(shoen_record)
{
  $USE(D_WorkShoenTempReg1);
  s_GetShoenLockFlag(shoen_record, D_WorkShoenTempReg1);
  p_CompareImmediate(D_WorkShoenTempReg1, _UNHOOK_NONRESERVED);
  $RELEASE(D_WorkShoenTempReg1);
  p_IfEQ()
}

/* Original
#CTRL_define  s_IfStartStopBitTableFlagOn(shoen_record, cl_num_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_IfStartStopBitTableFlagOn","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  $USE(D_WorkShoenTempReg2);
  s_GetShoenStartStopBitTable(shoen_record, D_WorkShoenTempReg1);
  s_GetFPBitTableFlag(D_WorkShoenTempReg1, cl_num_reg, D_WorkShoenTempReg2);
  p_CompareImmediate(D_WorkShoenTempReg2, _FP_BIT_TBL_FLAG_ON);
  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
  p_IfEQ()
}
*/

/* !! */
#CTRL_define  s_IfStartStopBitTableFlagOn(shoen_record, cl_num_reg)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    VPIM_ERROR("s_IfStartStopBitTableFlagOn","Not SHREC Type");}};

  $USE(D_WorkShoenTempReg1);
  $USE(D_WorkShoenTempReg2);
  s_GetShoenStartStopBitTable(shoen_record,
			      D_WorkShoenTempReg1, D_WorkShoenTempReg2);

  b_IfGreaterEqImm(cl_num_reg, _WORD_BIT_LENGTH)
    {
      $USE(D_WorkShoenTempReg3); /* upper fp_table$BCf$N%S%C%H0LCV$rJ];}$9$k(B */
      b_SubtractImmediateWithDNTC(cl_num_reg, _WORD_BIT_LENGTH,
				                        D_WorkShoenTempReg3);
      b_IfFlagOnPosReg(D_WorkShoenTempReg1, D_WorkShoenTempReg3)
	{
	  b_SetSuccess();
	}
      else
	{
	  b_SetFail();
	}
      $RELEASE(D_WorkShoenTempReg3);
    }
  else
    {
      b_IfFlagOnPosReg(D_WorkShoenTempReg2, cl_num_reg)
	{
	  b_SetSuccess();
	}
      else
	{
	  b_SetFail();
	}
    }

  $RELEASE(D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg2);
  b_IfSuccess()
}


/* !! */
#DATA_define  D_WorkShoenFPTable1  XXX
#DATA_define  D_WorkShoenFPTable2  XXX

#DATA_define  D_WorkShoenTotalFPCount  XXX


#CTRL_define  s_IfFPExist(shoen_record)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_IfStartStopBitTableFlagOn","Not SHREC Type");}};

  $USE(D_WorkShoenFPTable1);
  $USE(D_WorkShoenFPTable2);
  $USE(D_WorkShoenTotalFPCount);

  /* !! */
  s_GetFPTable(shoen_record, D_WorkShoenFPTable1, D_WorkShoenFPTable2);
  /* !! */
  s_CountDestinationFPs(D_WorkShoenFPTable1, D_WorkShoenFPTable2,
			                          D_WorkShoenTotalFPCount);
  p_Compare(D_WorkShoenTotalFPCount, D_NULL);
  $RELEASE(D_WorkShoenTotalFPCount);
  $RELEASE(D_WorkShoenFPTable1);
  $RELEASE(D_WorkShoenFPTable2);
  p_IfNE()
}


#CTRL_define  s_IfNotFPExist(shoen_record)
{
  @DEBUG{ s_IfNotSHREC(shoen_record) {
    WARNING("s_IfStartStopBitTableFlagOn","Not SHREC Type");}};

  $USE(D_WorkShoenFPTable1);
  $USE(D_WorkShoenFPTable2);
  $USE(D_WorkShoenTotalFPCount);

  /* !! */
  s_GetFPTable(shoen_record, D_WorkShoenFPTable1, D_WorkShoenFPTable2);
  /* !! */
  s_CountDestinationFPs(D_WorkShoenFPTable1, D_WorkShoenFPTable2,
			                          D_WorkShoenTotalFPCount);
  p_Compare(D_WorkShoenTotalFPCount, D_NULL);
  $RELEASE(D_WorkShoenTotalFPCount);
  $RELEASE(D_WorkShoenFPTable1);
  $RELEASE(D_WorkShoenFPTable2);
  p_IfEQ()
}


/******************************************************************** PSL **

(3.2) $BAq1`$N;q8;4X78$NLd$$9g$o$;MQ%^%/%m(B

       written by kawai@icot22      on Wed Jun  6 16:18:16 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define  s_IfNotInAskingShoenStat(shoen_record)
{
  $USE(D_WorkShoenTempReg1);
  s_GetStatHook(shoen_record, D_WorkShoenTempReg1);
  p_Compare(D_WorkShoenTempReg1, D_NULL);
  $RELEASE(D_WorkShoenTempReg1);
  p_IfEQ()
}



#CTRL_define  s_IfInAskingShoenStat(shoen_record)
{
  $USE(D_WorkShoenTempReg1);
  s_GetStatHook(shoen_record, D_WorkShoenTempReg1);
  p_Compare(D_WorkShoenTempReg1, D_NULL);
  $RELEASE(D_WorkShoenTempReg1);
  p_IfNE()
}



#CTRL_define  s_IfNotReceiveAllAnsFromFP(shoen_record)
{
  $USE(D_WorkShoenTempReg1);
  s_GetStatCount(shoen_record, D_WorkShoenTempReg1);
  p_Compare(D_NULL, D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg1);
  p_IfNE()
}


#CTRL_define  s_IfInAskingShoenStatFromParentFP(shoen_record)
{
  $USE(D_WorkShoenTempReg1);
  s_GetStatHook(shoen_record, D_WorkShoenTempReg1);
  b_BitwiseAndImmediateWithDNTC(D_WorkShoenTempReg1, _UPPER_STAT_HOOK_CNT_MASK,
			                               D_WorkShoenTempReg1);
  p_Compare(D_WorkShoenTempReg1, D_NULL);
  $RELEASE(D_WorkShoenTempReg1);
  p_IfNE()
}



#CTRL_define  s_IfAskShoenStatFromOnlyParentFP(shoen_record)
{
  $USE(D_WorkShoenTempReg1);
  s_GetStatHook(shoen_record, D_WorkShoenTempReg1);
  b_BitwiseAndImmediateWithDNTC(D_WorkShoenTempReg1, _UPPER_STAT_HOOK_CNT_MASK,
			                               D_WorkShoenTempReg1);
  p_CompareImmediate(D_WorkShoenTempReg1, _UPPER_STAT_HOOK_CNT_UNIT);
  $RELEASE(D_WorkShoenTempReg1);
  p_IfEQ()
}


#CTRL_define  s_IfAskShoenStatFromOnlyCS(shoen_record)
{
  $USE(D_WorkShoenTempReg1);
  s_GetStatHook(shoen_record, D_WorkShoenTempReg1);
  b_IfNotEqual(D_WorkShoenTempReg1, D_NULL)
    {
      b_BitwiseAndImmediateWithDNTC(D_WorkShoenTempReg1,
				    _UPPER_STAT_HOOK_CNT_MASK,
			                               D_WorkShoenTempReg1);
      p_Compare(D_WorkShoenTempReg1, D_NULL);
    }
  else
    { /* FP$B$+$i$b(BCS$B$+$i$b>CHq;q8;NLLd$$9g$o$;$,$J$$$H$-(B */
      p_Compare(D_NULL, D_ONE);
    }
  $RELEASE(D_WorkShoenTempReg1);
  p_IfEQ()
}


#CTRL_define  s_IfAskShoenStatFromFPAndCS(shoen_record)
{
  s_IfAskShoenStatFromOnlyParentFP(shoen_record)
    {
      b_SetFail();
    }
  else
    {
      s_IfAskShoenStatFromOnlyCS(shoen_record)
	{
	  b_SetFail();
	}
      else
	{
	  b_SetSuccess();
	}
    }
  b_IfSuccess()
}

/******************************************************************** PSL **

(3.3) $BAq1`$N(BReady/Terminate$B%+%&%s%?MQLd$$9g$o$;%^%/%m(B

       written by kawai@icot22      on Thu Jul 26 22:00:48 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define  D_WorkShoenReadyTerminateCountReg  XXX

#CTRL_define  s_IfReadyTerminateOvertaken(shoen_record, cl_num_reg)
{ /* $BBP1~$9$k%/%i%9%?$N%+%&%s%?$,=i4|CM$HF1$8$+H]$+$rH=Dj$9$k!#(B*/
  $USE(D_WorkShoenReadyTerminateCountReg); 
  s_GetReadyTerminateCount(shoen_record, cl_num_reg,
			                 D_WorkShoenReadyTerminateCountReg);
  p_Compare(D_WorkShoenReadyTerminateCountReg, D_NULL);
  $RELEASE(D_WorkShoenReadyTerminateCountReg);
  p_IfNE()
}

/******************************************************************** PSL **

(4) $BAq1`$N%(%/%;%W%7%g%s%^%9%/$NLd$$9g$o$;MQ%^%/%m(B

       written by kawai@icot22      on Thu Jul 26 22:02:05 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define  D_WorkShoenExceptionMask  XXX

#CTRL_define  s_IfExceptionMasked(shoen_record, exception_tag)
{
  $USE(D_WorkShoenExceptionMask);
  s_GetShoenExceptionMask(shoen_record, D_WorkShoenExceptionMask);
  b_BitwiseAndWithDNTC(D_WorkShoenExceptionMask, exception_tag,
	                                           D_WorkShoenExceptionMask);
  p_Compare(exception_tag, D_WorkShoenExceptionMask);
  $RELEASE(D_WorkShoenExceptionMask); 
  p_IfNE()
}


/******************************************************************** PSL **

       written by kawai@icot22      on Thu May 16 21:45:27 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

/* $BDI2C(B */
#CTRL_define  s_IfNotInShoenProfiling(shoen_record)
{
  s_IfShoenStatusFlagOn(shoen_record, _PROFILING_SHOEN_FLAG_MASK)
    { /* $BAq1`$,(B Profile$BMQAq1`$J$i$P(B */
      s_IfShoenProfileCompleted(shoen_record)
	{ 
	  b_SetSuccess();
	}
      else
	{
	  b_SetFail();
	}
    }
  else
    { /* $BAq1`$,(B Profile$BMQAq1`$G$J$1$l$P(B */
      $USE(D_WorkShoenTempReg1);
      s_GetAskProfileFPCount(shoen_record, D_WorkShoenTempReg1);
      b_IfEqual(D_NULL, D_WorkShoenTempReg1)
	{ 
	  b_SetSuccess();
	}
      else
	{
	  b_SetFail();
	}
      $RELEASE(D_WorkShoenTempReg1);
    }
  b_IfSuccess()
}


/* $BDI2C(B */
#CTRL_define  s_IfInShoenProfiling(shoen_record)
{
  s_IfNotInShoenProfiling(shoen_record)
	{ 
	  b_SetFail();
	}
      else
	{
	  b_SetSuccess();
	}
  b_IfSuccess()
}


/* $BDI2C(B */
#CTRL_define  s_IfShoenProfilable(shoen_record)
{
  s_IfShoenStatusFlagOn(shoen_record, _PROFILING_SHOEN_FLAG_MASK)
    { /* $BAq1`$,(B Profile$BMQAq1`$J$i$P(B */
      s_IfShoenStatusFlagOff(shoen_record, _PROFILING_PARENT_SHOEN_FLAG_MASK)
	{ /* $B?FAq1`$,(B Profile$BMQAq1`$G$J$1$l$P(B */
	  s_IfShoenProfileCompleted(shoen_record)
	    { /* $B8=:_(B Profile$BCf$G$J$1$l$P(B */
	      $USE(D_WorkShoenTransitStatus);
	      s_GetShoenTransitStatus(shoen_record, D_WorkShoenTransitStatus);
	      ValueSwitch(D_WorkShoenTransitStatus)
		{ 
		case  _TERMINATED :
		case  _ABORTED :
		  /*  $B4{$KAq1`$,=*7k$"$k$$$O%"%\!<%H$7$F$$$?$i(B  */
		  @DEBUG{ WARNING("s_IfProfilableShoen",
				  "Shoen Already Terminated or Aborted"); };
		  b_SetFail();
		  break ;
		case  _STARTED :
		case  _STOPPED_BY_PARENT :
		case  _STOPPED_BY_CTRL :
		case  _STOPPED_BY_BOTH :
		  /* $BAq1`$,=*N;(B/$B%"%\!<%H$7$F$$$J$+$C$?$i(B */
		  b_SetSuccess();
		  break;
		default :
		  @DEBUG{
		    VPIM_ERROR("ShoenStatistics", "Illegal Shoen Status");
		  };
		  b_SetFail();
		}
	      $RELEASE(D_WorkShoenTransitStatus);
	    }
	  else
	    { /* $B8=:_(B Profile$BCf$J$i$P(B */
	      b_SetFail();
	    }
	}
      else
	{ /* $BAq1`$,(B Profile$BMQAq1`$G!"$+$D?FAq1`$b(B Profile$BMQAq1`$J$i$P(B */
	  b_SetFail();
	}
    }
  else
    { /* $BAq1`$,(B Profile$BMQAq1`$G$J$1$l$P(B */
      b_SetFail();
    }
  b_IfSuccess()
}


/* $BDI2C(B */
#CTRL_define  s_IfShoenProfilableFromFP(shoen_record)
{
  s_IfShoenStatusFlagOff(shoen_record, _PROFILING_SHOEN_FLAG_MASK)
    { /* $BAq1`$,(B Profile$BMQAq1`$G$J$1$l$P(B */
      s_IfShoenStatusFlagOn(shoen_record, _PROFILING_PARENT_SHOEN_FLAG_MASK)
	{ /* $B?FAq1`$,(B Profile$BMQAq1`$J$i$P(B */
	  $USE(D_WorkShoenTempReg1);
	  s_GetAskProfileFPCount(shoen_record, D_WorkShoenTempReg1);
	  b_IfEqual(D_NULL, D_WorkShoenTempReg1)
	    { /* $B8=:_(B Profile$BCf$G$J$1$l$P(B */
	      b_SetSuccess();
	    }
          else
	    {
	      b_SetFail();
	    }
	  $RELEASE(D_WorkShoenTempReg1);
	}
      else
	{
	  b_SetFail();
	}
    }
  else
    {
      b_SetFail();
    }
  b_IfSuccess()
}


/* $BDI2C(B */
#CTRL_define  s_IfLastAnsProfileFromFP(total_ans)
{
  p_Compare(total_ans, D_NULL);
  p_IfGT()
}


#CTRL_define  s_IfShoenProfileCompleted(shoen_record)
{
  $USE(D_WorkShoenTempReg1);
  s_GetAskProfileFPCount(shoen_record, D_WorkShoenTempReg1);
  b_IfEqual(D_WorkShoenTempReg1, D_NULL)
    { /* Profile$BAq1`$ND>2<$NN$?F$+$i$N(B Ans $B$,$9$Y$FJV$C$F$-$F$$$F(B */
      s_GetReportedProfileCount(shoen_record, D_WorkShoenTempReg1);
      $USE(D_WorkShoenTempReg2);
      s_GetSHTotalAnsProfileCount(shoen_record, D_WorkShoenTempReg2);
      b_IfEqual(D_WorkShoenTempReg1, D_WorkShoenTempReg2)
	{ /* $B4{(BProfile$B%l%]!<%H?t(B = $BM=Dj(BProfile$B%l%]!<%H?t(B $B$J$i$P(B */
	  b_SetSuccess();
	}
      else
	{
	  b_SetFail();
	}
      $RELEASE(D_WorkShoenTempReg2);
    }
  else
    {
      b_SetFail();
    }
  $RELEASE(D_WorkShoenTempReg1);
  b_IfSuccess()
}


#CTRL_define  s_IfAllFPAnsProfile(shoen_record)
{
  $USE(D_WorkShoenTempReg1);
  s_GetAskProfileFPCount(shoen_record, D_WorkShoenTempReg1);
  p_Compare(D_NULL, D_WorkShoenTempReg1);
  $RELEASE(D_WorkShoenTempReg1);
  p_IfEQ()
}
