
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V10/structures/str_sh_fp_send_message.psl.c
   ----- CREATED   : by yamamoto@icot22, on Thu May 24 17:19:35 1990
   ----- LAST SAVED: by ttakagi@icot22, on Fri Aug 23 17:55:31 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : $BAq1`(B<->$BN$?F4V%a%C%;!<%88r49%^%/%m$G;H$&%^%/%m(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */
/******************************************************************** PSL **

$BAq1`$+$i!"%S%C%H%^%C%W$G;XDj$5$l$?J#?t$NN$?F$X$N%a%C%;!<%8H/Aw(B
$B%S%C%H%^%C%W$NE83+$r9T$J$&2<@A$1$5$s$J$N$@(B

       written by yamamoto@icot22      on Thu Jun 21 21:45:29 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#DATA_define D_WorkShoenFPPacketSize	XXX
#DATA_define D_WorkShoenFPBitMapWord	XXX
#DATA_define D_WorkShoenFPVectSize	XXX
#DATA_define D_WorkShoenFPClusterNum	XXX
#DATA_define D_WorkShoenFPVectElemPos   XXX
#DATA_define D_WorkShoenFPVectElemAddr  XXX
#DATA_define D_WorkShoenFPNeedOrNot     XXX
#DATA_define D_WorkBitTableVect         XXX
#DATA_define D_WorkLoopCnt              XXX

#CONST_define _SHOEN_MASK_WORD_BIT_LENGTH 0xffffffe0
				      /* ~0x0000001f , 0x1f == 31 */

#CONST_define _SHOEN_LENGTH_OF_LOGICAL_MESSAGE 3
#CONST_define _SHOEN_LENGTH_OF_LOGICAL_MESSAGE_WITH_EOM 
				( _SHOEN_LENGTH_OF_LOGICAL_MESSAGE + 1 )
/* used also in f_int_cl_send_control.psl.c */

#PSL_define s_SendMessageToFPs_Distributer(packet_ptr,
			       dest_clusters_bitmap_vect_reg){
/* $B%k!<%W$N=`Hw(B */
/* argument of s_SendPackt */
  $USE(D_WorkShoenFPPacketSize);
  b_SetImmValueDNTC(_SHOEN_LENGTH_OF_LOGICAL_MESSAGE_WITH_EOM,
						D_WorkShoenFPPacketSize);
/* cluster number */
  $USE(D_WorkShoenFPClusterNum);
  b_SetImmValueDNTC(_ZERO,D_WorkShoenFPClusterNum);
/* bit map vector element pos ,to be incremented from zero to vect size */
  $USE(D_WorkShoenFPVectElemPos);
  b_SetImmValueDNTC(_ZERO,D_WorkShoenFPVectElemPos);
/* bit map vector size ,to detect end of outer loop */
  $USE(D_WorkShoenFPVectSize);
  s_GetSizeShortVect(dest_clusters_bitmap_vect_reg,
					D_WorkShoenFPVectSize);
/* $B%M%C%H%o!<%/%P%C%U%!ITB-$N$?$a$K%a%C%;!<%8$r%5%9%Z%s%I$9$k$H$-!"(B
   $B$=$N;~E@$G$N%S%C%H%^%C%W%o!<%I$rJ]B8$9$k!#(B
   $B$3$N%3%T!<$O$9$Y$FAw?.$G$-$?;~$K2s<}$9$k!#(B by ttakagi */
  $USE(D_WorkBitTableVect);
  s_AllocShortVector(D_WorkShoenFPVectSize, D_WorkBitTableVect);
  $CALL( s_CopyElemShortVect_Sub
	              (dest_clusters_bitmap_vect_reg, D_WorkBitTableVect));
/* I believe that destination vector is short vector !!! */

/* vector element address ( not position ) */
  $USE(D_WorkShoenFPVectElemAddr);
  $USE(D_WorkShoenFPNeedOrNot);
  $USE(D_WorkShoenFPBitMapWord);
  LOOP(){
    /* $B%S%C%H%^%C%W%o!<%I$N<h$j=P$7(B */
    s_GetStructElemAddrPosReg(D_WorkBitTableVect,
			      D_WorkShoenFPVectElemPos,
			      D_WorkShoenFPVectElemAddr);
    p_Read(D_WorkShoenFPVectElemAddr,D_WorkShoenFPBitMapWord);
    $USE(D_WorkLoopCnt);
    p_MoveWord(D_ONE, D_WorkLoopCnt);
    LOOP(){
      /* bitmap $B$G;XDj$5$l$?%/%i%9%?HV9f$N<h$j=P$7(B */
      b_BitwiseAndImmediateWithTag(D_WorkShoenFPBitMapWord,_ONE,
				   D_WorkShoenFPNeedOrNot);
      b_IfEqualImm(D_WorkShoenFPNeedOrNot,_ONE){
	/* $B%/%i%9%?Kh$KH/Aw$r0MMj$9$k(B */
	b_SetImmTypeMRBoff(INT, D_WorkShoenFPPacketSize);
	$USE(D_WorkStatusFlag);
	s_SendPacketWithoutPacketReclaim(packet_ptr,D_WorkShoenFPPacketSize,
		        D_WorkShoenFPClusterNum, D_WorkStatusFlag);
	b_IfEqualImm(D_WorkStatusFlag, _ONE){
	  /* $B%M%C%H%o!<%/%P%C%U%!$,$$$C$Q$$$G%a%C%;!<%8$,=q$-9~$a$J$+$C$?(B */
	  b_ShiftRightWithTag(D_WorkShoenFPBitMapWord, D_WorkLoopCnt, D_WorkShoenFPBitMapWord);
	  b_ShiftLeftWithTag(D_WorkShoenFPBitMapWord, D_WorkLoopCnt, D_WorkShoenFPBitMapWord);
	  $RELEASE(D_WorkStatusFlag);
	  /* message suspend */;
	  @DEBUG{
	    WARNING("s_SendMessageToFPs_Distributer",
		    "Send packet Suspended");
	  };
	  $USE(D_WorkPtrToPacketSuspRec);
	  s_AllocPacketSuspRec(D_WorkPtrToPacketSuspRec);
	  s_PutSuspPacketID_PacketSuspRec
                      (_PACKET_SUSP_DISTRIBUTE,D_WorkPtrToPacketSuspRec);
	  s_PutPacketInfo1_PacketSuspRec
	              (D_WorkBitTableVect, D_WorkPtrToPacketSuspRec);
	  s_PutPacketInfo2_PacketSuspRec
	              (packet_ptr, D_WorkPtrToPacketSuspRec);
	  /* $B0J2<$N%9%m%C%H$OG0$N$?$a(B */
	  s_PutPacketInfo3_PacketSuspRec
	              (D_NULL, D_WorkPtrToPacketSuspRec);
	  s_PutPacketInfo4_PacketSuspRec
	              (D_NULL, D_WorkPtrToPacketSuspRec);
	  s_PutPacketInfo5_PacketSuspRec
	              (D_NULL, D_WorkPtrToPacketSuspRec);
	  s_PutPacketInfo6_PacketSuspRec
	              (D_NULL, D_WorkPtrToPacketSuspRec);
	  s_PushPacketSuspRec(D_WorkPtrToPacketSuspRec);
	  $RELEASE(D_WorkPtrToPacketSuspRec);
	  b_SetEventFlag(_NETWORK_BUFFER_FULL_EVENT,D_PE_Number);
	  $RELEASE(D_WorkLoopCnt);
	  /* b_SetEventFlag(_PAGE_ALLOC_FAIL_EVENT,D_PE_Number); */
	  goto END;
	}
	$RELEASE(D_WorkStatusFlag);
      }
      b_IncrementReg(D_WorkLoopCnt);
      /* $B<!$N%S%C%H$X0\$k(B */
      b_ShiftRightImmediateWithTag(D_WorkShoenFPBitMapWord,_ONE,
				   D_WorkShoenFPBitMapWord);
      b_IfEqualImm(D_WorkShoenFPBitMapWord,_ZERO){
	/* $B$b$7$b!"$b$&%S%C%H%^%C%W%o!<%I$K#1$,N)$C$F$$$J$+$C$?$i(B */
	/* clusternum $B$r#3#2C10L$G@Z$j>e$2$F<!$N%S%C%H%^%C%W%o!<%I$X?J$`(B */
	b_AddImmediateWithTag(D_WorkShoenFPClusterNum,_WORD_BIT_LENGTH,
			      D_WorkShoenFPClusterNum);
	b_BitwiseAndImmediateWithTag(D_WorkShoenFPClusterNum,
				     _SHOEN_MASK_WORD_BIT_LENGTH,
				     D_WorkShoenFPClusterNum);
	break;/* break inner loop */
      }
      b_IncrementReg(D_WorkShoenFPClusterNum);
    }/* tail of inner loop */
    $RELEASE(D_WorkLoopCnt);
    /* $B<!$N%S%C%H%^%C%W%o!<%I$X0\$k(B */
    p_Write(D_NULL, D_WorkShoenFPVectElemAddr);
    b_IncrementReg(D_WorkShoenFPVectElemPos);
    /* bitmap $B$r$J$a=*$C$?$i(B */ 
    b_IfEqual(D_WorkShoenFPVectElemPos,D_WorkShoenFPVectSize)
      {break;/* break outer loop */}
  }/* tail of outer loop */
  s_ReclaimLogicalPacket(packet_ptr);
  s_ReclaimShortVector(D_WorkBitTableVect);

 END:
  $RELEASE(D_WorkBitTableVect);
  $RELEASE(D_WorkShoenFPBitMapWord);
  $RELEASE(D_WorkShoenFPClusterNum);
  $RELEASE(D_WorkShoenFPVectElemPos);
  $RELEASE(D_WorkShoenFPVectSize);
  $RELEASE(D_WorkShoenFPPacketSize);
  $RELEASE(D_WorkShoenFPVectElemAddr);
  $RELEASE(D_WorkShoenFPNeedOrNot);
}

