
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/structures/str_processor_profiler.psl.c
   ----- CREATED   : by imai@icot22, on Mon Aug 12 19:35:12 1991
   ----- LAST SAVED: by ttakagi@icot22, on Fri Jun 12 16:03:36 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 

  $B%W%m%U%!%$%k$KMQ$$$k8GDjNN0h$O<!$NDL$j$G$"$k!#(B
					$B(.(,(,(,(,(,(,(,(/(B
      _MEASUREMENT_REC_PTR_AREA_BASE--->$B(-9`L\(B0 for PE0	$B(-(B
					$B(7(!(!(!(!(!(!(!(9(B
					$B(-9`L\(B1 for PE0	$B(-(B
					$B(7(!(!(!(!(!(!(!(9(B
					$B!'(B	$B!'(B	$B!'(B
	$B9`L\Kh$K(B8$B8l$NNN0h$r3d$jIU$1$k(B	$B(7(!(!(!(!(!(!(!(9(B
					$B(-9`L\(Bn for PE0	$B(-(B
					$B(2(,(,(,(,(,(,(,(4(B
					$B(-9`L\(B0 for PE1	$B(-(B
	$B%/%i%9%?Kh$K7WB,$9$k9`L\$N>l9g(B	$B(7(!(!(!(!(!(!(!(9(B
	PE0 $B$NNN0h$rMQ$$!"$=$l0J30$N(B	$B(-9`L\(B1 for PE1	$B(-(B
	PE $B$N$?$a$NNN0h$O!";H$o$J$$!#(B	$B(7(!(!(!(!(!(!(!(9(B
					$B!'(B	$B!'(B	$B!'(B
					$B(7(!(!(!(!(!(!(!(9(B
					$B(-9`L\(Bn for PE1	$B(-(B
	$B$3$l$HA4$/F1$8Bg$-$5$NNN0h$r(B	$B(2(,(,(,(,(,(,(,(4(B
	_MEASUREMENT_REC_TEMP_AREA_BASE	$B!'(B	$B!'(B	$B!'(B
	$B$+$i;O$^$k$H$3$m$K3NJ]$7!"(B	$B!'(B	$B!'(B	$B!'(B
	$BF~NO%A%'%C%/Cf$KMQ$$$k(B		$B(2(,(,(,(,(,(,(,(4(B
					$B(-9`L\(B0 for PE7	$B(-(B
					$B(7(!(!(!(!(!(!(!(9(B
					$B(-9`L\(B1 for PE7	$B(-(B
					$B(7(!(!(!(!(!(!(!(9(B
					$B!'(B	$B!'(B	$B!'(B
					$B(7(!(!(!(!(!(!(!(9(B
					$B(-9`L\(Bn for PE7	$B(-(B
					$B(1(,(,(,(,(,(,(,(0(B

* == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

#CONST_define _MAX_ELEMENTS_PROFILE_VECT		7
#CONST_define _MAX_SLOTS_PROFILE_VECT			8
		/* $B",(B _MAX_ELEMENTS_PROFILE_VECT $B$r1[$($J$$#2%Y%-(B */

/* $BMWAG0LCV(B --> $B9`L\$rA}$d$7$?;~$O!"(Bs_IfClusterwiseMeasurementItem $B$r(B
                $B%a%s%F$9$k$3$H(B!! */
#CONST_define _IDLE_TIME_ELEM_POS_PROFILE_VECT		0
#CONST_define _GEVC_ELEM_POS_PROFILE_VECT		1
#CONST_define _MSG_SEND_FREQ_ELEM_POS_PROFILE_VECT	2
#CONST_define _MSG_RECV_FREQ_ELEM_POS_PROFILE_VECT	3
#CONST_define _LOCAL_GC_ELEM_POS_PROFILE_VECT		4
#CONST_define _LOG_EVENT_ELEM_POS_PROFILE_VECT		5
#CONST_define _MSG_ENC_DEC_TIME_ELEM_POS_PROFILE_VECT	6

/* $BI,MW$J%9%H%j%s%0(B($B$^$?$O%Y%/%?(B)$BMWAG?t$N2<8B(B */
#CONST_define _IDLE_TIME_MEASUREMENT_REC_ELMS_MIN	6
#CONST_define _MSG_SEND_FREQ_MEASUREMENT_REC_ELMS_MIN	32
#CONST_define _MSG_RECV_FREQ_MEASUREMENT_REC_ELMS_MIN	32
#CONST_define _LOCAL_GC_MEASUREMENT_REC_ELMS_MIN	6
#CONST_define _LOG_EVENT_MEASUREMENT_REC_ELMS_MIN	2
#CONST_define _MSG_ENC_DEC_TIME_MEASUREMENT_REC_ELMS_MIN	4

/* $B%9%H%j%s%0(B($B$^$?$O%Y%/%?(B)$BMWAG?t>e8B(B */
#CONST_define _IDLE_TIME_MEASUREMENT_REC_ELMS_MAX	0x100000 /* 1Mwords */
#CONST_define _MSG_SEND_FREQ_MEASUREMENT_REC_ELMS_MAX	32
#CONST_define _MSG_RECV_FREQ_MEASUREMENT_REC_ELMS_MAX	32
#CONST_define _LOCAL_GC_MEASUREMENT_REC_ELMS_MAX	0x100000 /* 1Mwords */
#CONST_define _LOG_EVENT_MEASUREMENT_REC_ELMS_MAX	0x100000 /* 1Mwords */
#CONST_define _MSG_ENC_DEC_TIME_MEASUREMENT_REC_ELMS_MAX	4

#DATA_define D_WorkProfVectElm	XXX


/******************************************************************** PSL **
 $B3F7WB,9`L\$,!"8=:_7WB,Cf$G$"$k$+$I$&$+$N8!::(B

#CTRL_define s_IfIdleTimeProfileOn()	
#CTRL_define s_IfMsgSendFreqProfileOn()
#CTRL_define s_IfMsgRecvFreqProfileOn()
#CTRL_define s_IfLocalGCFreqProfileOn()
#CTRL_define s_IfLogEventFreqProfileOn()
#CTRL_define s_IfMsgEncDecTimeFreqProfileOn()

       written by imai@icot22      on Mon Aug 12 19:40:38 1991

<Arguments> $B$J$7(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B7WB,9`L\Kh$K!"8=:_7WB,Cf$G$"$k$+$I$&$+$N8!::$r9T$J$&!#(B
  D_ProcessorProfilerMainSwitch $B$O!"%W%m%U%!%$%k$N%a%$%s%9%$%C%A$G$"$j!"(B
  $B$=$NCMIt$,!"(B
	_ALL1 : $B%a%$%s%9%$%C%A(B On
	_ZERO : $B%a%$%s%9%$%C%A(B Off
  $B$G$"$k!#(B

  $B%5%V%9%$%C%A$O!"%a%8%c!<%a%s%H%l%3!<%I$r7R$$$G$$$k%(%j%"$NCMIt$r8+$F(B
  $BH=CG$9$k!#%9%$%C%A(B Off $B$N>l9g$O!"(B(INT!0)$B$,=q$+$l$F$*$j!"$=$&$G$J$$>l(B
  $B9g$O!"%a%8%c!<%a%s%H%l%3!<%I$X$N%]%$%s%?(B (not 0)$B$,=q$+$l$F$$$k!#(B
<Examples>
<Test>
<Explanation>
  $B%a%8%c!<%a%s%H%l%3!<%I$r7R$$$G$$$k%(%j%"$NCMIt$O!"%=%U%H%m%C%/Cf$G$b(B
  $B85$NCM$,J]B8$5$l$F$$$k!#(B
<ETC>
  $B%"%$%I%k$K8B$j!"%a%$%s%9%$%C%A$rMxMQ$7$J$$!J$G$-$J$$!K(B
********************************************************************* PSL **/

#DATA_define D_ProcessorProfilerMainSwitch XXX /* $B%a%$%s%9%$%C%A(B */

#CTRL_define s_IfIdleTimeProfileOn(ptr) {
  p_Compare(ptr,D_NULL);
  p_IfNE()
}

#CTRL_define s_IfMsgSendFreqProfileOn() {
  $USE(D_WorkPtrToMeasurementRec);
  s_GetProcessorwiseMeasurementRecPtr(_MSG_SEND_FREQ_ELEM_POS_PROFILE_VECT,
				      D_WorkPtrToMeasurementRec);
  @DEBUG {
    b_IfZero(D_WorkPtrToMeasurementRec) {
      s_IfNotINT(D_WorkPtrToMeasurementRec) {
	b_IfNotSLOCK(D_WorkPtrToMeasurementRec) {
	  VPIM_ERROR("s_IfMsgSendFreqProfileOn","Illegal Ptr");
      }}}};
  b_BitwiseAndWithDNTC
    (D_WorkPtrToMeasurementRec,D_ProcessorProfilerMainSwitch,D_VOID);
  $RELEASE(D_WorkPtrToMeasurementRec);
  p_IfNE()
}

#CTRL_define s_IfMsgRecvFreqProfileOn() {
  $USE(D_WorkPtrToMeasurementRec);
  s_GetProcessorwiseMeasurementRecPtr(_MSG_RECV_FREQ_ELEM_POS_PROFILE_VECT,
				      D_WorkPtrToMeasurementRec);
  @DEBUG {
    b_IfZero(D_WorkPtrToMeasurementRec) {
      s_IfNotINT(D_WorkPtrToMeasurementRec) {
	b_IfNotSLOCK(D_WorkPtrToMeasurementRec) {
	  VPIM_ERROR("s_IfMsgRecvFreqProfileOn","Illegal Ptr");
      }}}};
  b_BitwiseAndWithDNTC
    (D_WorkPtrToMeasurementRec,D_ProcessorProfilerMainSwitch,D_VOID);
  $RELEASE(D_WorkPtrToMeasurementRec);
  p_IfNE()
}

#CTRL_define s_IfLocalGCFreqProfileOn() {
  $USE(D_WorkPtrToMeasurementRec);
  s_GetClusterwiseMeasurementRecPtr(_LOCAL_GC_ELEM_POS_PROFILE_VECT,
				      D_WorkPtrToMeasurementRec);
  @DEBUG {
    b_IfZero(D_WorkPtrToMeasurementRec) {
      s_IfNotINT(D_WorkPtrToMeasurementRec) {
	b_IfNotSLOCK(D_WorkPtrToMeasurementRec) {
	VPIM_ERROR("s_IfLocalGCFreqProfileOn","Illegal Ptr");
      }}}};
  b_BitwiseAndWithDNTC
    (D_WorkPtrToMeasurementRec,D_ProcessorProfilerMainSwitch,D_VOID);
  $RELEASE(D_WorkPtrToMeasurementRec);
  p_IfNE()
}

#CTRL_define s_IfLogEventFreqProfileOn() {
  $USE(D_WorkPtrToMeasurementRec);
  s_GetProcessorwiseMeasurementRecPtr(_LOG_EVENT_ELEM_POS_PROFILE_VECT,
				      D_WorkPtrToMeasurementRec);
  @DEBUG {
    b_IfZero(D_WorkPtrToMeasurementRec) {
      s_IfNotINT(D_WorkPtrToMeasurementRec) {
	b_IfNotSLOCK(D_WorkPtrToMeasurementRec) {
	  VPIM_ERROR("s_IfLogEventFreqProfileOn","Illegal Ptr");
      }}}};
  b_BitwiseAndWithDNTC
    (D_WorkPtrToMeasurementRec,D_ProcessorProfilerMainSwitch,D_VOID);
  $RELEASE(D_WorkPtrToMeasurementRec);
  p_IfNE()
}

#CTRL_define s_IfMsgEncDecTimeFreqProfileOn() {
  $USE(D_WorkPtrToMeasurementRec);
  s_GetProcessorwiseMeasurementRecPtr(_MSG_ENC_DEC_TIME_ELEM_POS_PROFILE_VECT,
				      D_WorkPtrToMeasurementRec);
  @DEBUG {
    b_IfZero(D_WorkPtrToMeasurementRec) {
      s_IfNotINT(D_WorkPtrToMeasurementRec) {
	b_IfNotSLOCK(D_WorkPtrToMeasurementRec) {
	  VPIM_ERROR("s_IfMsgEncDecTimeFreqProfileOn","Illegal Ptr");
      }}}};
  b_BitwiseAndWithDNTC
    (D_WorkPtrToMeasurementRec,D_ProcessorProfilerMainSwitch,D_VOID);
  $RELEASE(D_WorkPtrToMeasurementRec);
  p_IfNE()
}

/******************************************************************** PSL **
  $B7WB,9`L\$,!"%/%i%9%?Kh$+!"#P#EKh$+$N8!::(B
       written by imai@icot22      on Wed Sep 11 13:42:46 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define s_IfClusterwiseMeasurementItem(item_number_reg)
{
  ValueSwitch(item_number_reg) {
  case _IDLE_TIME_ELEM_POS_PROFILE_VECT:
  case _MSG_SEND_FREQ_ELEM_POS_PROFILE_VECT:
  case _MSG_RECV_FREQ_ELEM_POS_PROFILE_VECT:
  case _LOG_EVENT_ELEM_POS_PROFILE_VECT:
  case _MSG_ENC_DEC_TIME_ELEM_POS_PROFILE_VECT:
    b_SetFail(); break;
  case _GEVC_ELEM_POS_PROFILE_VECT:
  case _LOCAL_GC_ELEM_POS_PROFILE_VECT:
    b_SetSuccess(); break;
  default:
    @DEBUG{VPIM_ERROR("s_IfClusterwiseMeasurementItem","Illegal Value");};
  }
  b_IfSuccess()
}

#CTRL_define s_IfProcessorwiseMeasurementItem(item_number_reg)
{
  ValueSwitch(item_number_reg) {
  case _IDLE_TIME_ELEM_POS_PROFILE_VECT:
  case _MSG_SEND_FREQ_ELEM_POS_PROFILE_VECT:
  case _MSG_RECV_FREQ_ELEM_POS_PROFILE_VECT:
  case _LOG_EVENT_ELEM_POS_PROFILE_VECT:
  case _MSG_ENC_DEC_TIME_ELEM_POS_PROFILE_VECT:
    b_SetSuccess(); break;
  case _GEVC_ELEM_POS_PROFILE_VECT:
  case _LOCAL_GC_ELEM_POS_PROFILE_VECT:
    b_SetFail(); break;
  default:
    @DEBUG{VPIM_ERROR("s_IfProcessorwiseMeasurementItem","Illegal Value");};
  }
  b_IfSuccess()
}

/******************************************************************** PSL **
$B%a%8%c!<%a%s%H%l%3!<%I$r7R$0NN0h$X$NA`:n(B
  1. $B@55,NN0h$X$NA`:n(B
     1.1 $B@55,NN0h$N%=%U%H%m%C%/(B
     1.2 $B@55,NN0h$X$N%=%U%H%"%s%m%C%/(B
  2. $B2>NN0h$X$NA`:n(B
       written by imai@icot22      on Mon Aug 12 19:45:14 1991

  $B%a%8%c!<%a%s%H%l%3!<%I%]%$%s%?NN0h$O!"%7%9%F%`6&M-%(%j%"$KCV$/!#(B

  $B%/%i%9%?Kh$K7WB,$9$k9`L\$N>l9g!"(BPE0 $B$NNN0h$rMQ$$$k!#(B

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  $B2>NN0h$O!"(Bprocessor_profile $BAH9~=R8l$NF~NO%A%'%C%/Cf$K!"$=$N%A%'%C%/$,(B
  $BDL$C$?%a%8%c!<%a%s%H%l%3!<%I$r!"A4$F$N%A%'%C%/$,=*$o$k$^$G$N4V$KJ];}$7(B
  $B$F$*$/$?$a$NNN0h$G$"$k!#8e$NJ}$G%A%'%C%/$9$kF~NO$K!"IT@5F~NO$,$"$C$?;~(B
  $B$K$O!"Nc30$r=P$7$F!":#$^$G$N7WB,$K1F6A$rM?$($F$O$$$1$J$$$?$a!#(B
********************************************************************* PSL **/

#DATA_define	D_WorkPtrToMeasurementRec	XXX
#DATA_define	D_WorkIndex			XXX
#DATA_define	D_WorkCurrentTime		XXX
#DATA_define	D_WorkPrevTime			XXX


#PSL_define s_SoftLockMeasurementRecordPointerArea
	(imm_position, src_reg_pe_num, dst_reg)
{
  $USE(D_WorkSharedAreaAddr);
  $USE(D_WorkPeNum);
  b_MultiplyImmediateWithDNTC
    (src_reg_pe_num,_MAX_SLOTS_PROFILE_VECT,D_WorkPeNum);
  b_AddImmediateWithDNTC(D_WorkPeNum,imm_position,D_WorkPeNum);
  b_ExchangeElmposToOffset(D_WorkPeNum,D_WorkSharedAreaAddr);
  $RELEASE(D_WorkPeNum);
  b_SoftLockWithOrgData
    (D_WorkSharedAreaAddr,_MEASUREMENT_REC_PTR_AREA_BASE,dst_reg);
  $RELEASE(D_WorkSharedAreaAddr);
}

#PSL_define s_SoftLockMeasurementRecordPointerAreaPosReg
	(pos_reg, src_reg_pe_num, dst_reg)
{
  $USE(D_WorkSharedAreaAddr);
  $USE(D_WorkPeNum);

  b_MultiplyImmediateWithDNTC
    (src_reg_pe_num,_MAX_SLOTS_PROFILE_VECT,D_WorkPeNum);
  b_AddWithDNTC(D_WorkPeNum,pos_reg,D_WorkPeNum);
  b_ExchangeElmposToOffset(D_WorkPeNum,D_WorkSharedAreaAddr);
  $RELEASE(D_WorkPeNum);
  b_SoftLockWithOrgData
    (D_WorkSharedAreaAddr,_MEASUREMENT_REC_PTR_AREA_BASE,dst_reg);
  $RELEASE(D_WorkSharedAreaAddr);
}

#PSL_define s_SoftUnlockMeasurementRecordPointerArea
	(imm_position, src_reg_pe_num, src_reg)
{
  $USE(D_WorkSharedAreaAddr);
  $USE(D_WorkPeNum);

  b_MultiplyImmediateWithDNTC
    (src_reg_pe_num,_MAX_SLOTS_PROFILE_VECT,D_WorkPeNum);
  b_AddImmediateWithDNTC(D_WorkPeNum,imm_position,D_WorkPeNum);
  b_ExchangeElmposToOffset(D_WorkPeNum,D_WorkSharedAreaAddr);
  $RELEASE(D_WorkPeNum);
  b_SoftUnlockWithOrgData
    (D_WorkSharedAreaAddr,_MEASUREMENT_REC_PTR_AREA_BASE, src_reg);
  $RELEASE(D_WorkSharedAreaAddr);
}

#PSL_define s_SoftUnlockMeasurementRecordPointerAreaPosReg
	(pos_reg, src_reg_pe_num, src_reg)
{
  $USE(D_WorkSharedAreaAddr);
  $USE(D_WorkPeNum);

  b_MultiplyImmediateWithDNTC
    (src_reg_pe_num,_MAX_SLOTS_PROFILE_VECT,D_WorkPeNum);
  b_AddWithDNTC(D_WorkPeNum,pos_reg,D_WorkPeNum);
  b_ExchangeElmposToOffset(D_WorkPeNum,D_WorkSharedAreaAddr);
  $RELEASE(D_WorkPeNum);
  b_SoftUnlockWithOrgData
    (D_WorkSharedAreaAddr,_MEASUREMENT_REC_PTR_AREA_BASE, src_reg);
  $RELEASE(D_WorkSharedAreaAddr);
}

#PSL_define s_GetClusterwiseMeasurementRecPtr(imm_position, dst_ptr_reg)
{
  /* Processorwise $B$N(B 0 $BHV(B PE $B$N%9%m%C%H$rMQ$$$k(B */
  $USE(D_WorkSharedAreaAddr);
  b_SetImmValueDNTC(imm_position,D_WorkSharedAreaAddr);
  b_ExchangeElmposToOffset(D_WorkSharedAreaAddr, D_WorkSharedAreaAddr);
  p_ReadWithOffset
    (D_WorkSharedAreaAddr,_MEASUREMENT_REC_PTR_AREA_BASE, dst_ptr_reg);
  $RELEASE(D_WorkSharedAreaAddr);
}

#DATA_define D_WorkProfAddr XXX

#PSL_define s_GetProcessorwiseMeasurementRecPtr(imm_position,dst_ptr_reg)
{
  $USE(D_WorkProfAddr);
  $USE(D_WorkPeNum);

  b_MultiplyImmediateWithDNTC
	(D_PE_Number,_MAX_SLOTS_PROFILE_VECT,D_WorkPeNum);
  b_AddImmediateWithDNTC(D_WorkPeNum,imm_position,D_WorkPeNum);
  b_ExchangeElmposToOffset(D_WorkPeNum,D_WorkProfAddr);
  $RELEASE(D_WorkPeNum);
  p_ReadWithOffset(D_WorkProfAddr,_MEASUREMENT_REC_PTR_AREA_BASE, dst_ptr_reg);
  $RELEASE(D_WorkProfAddr);
}

#PSL_define s_PutToMeasurementRecordPointerArea
	(slot_pos_reg, src_reg_pe_num, src_reg)
{
  /* $B=i4|2=$N$_!"$=$l0J30$OI,$:%m%C%/$r;H$C$F$M(B */
  $USE(D_WorkSharedAreaAddr);
  $USE(D_WorkPeNum);

  b_MultiplyImmediateWithDNTC
    (src_reg_pe_num,_MAX_SLOTS_PROFILE_VECT,D_WorkPeNum);
  b_AddWithDNTC(D_WorkPeNum,slot_pos_reg,D_WorkPeNum);
  b_ExchangeElmposToOffset(D_WorkPeNum,D_WorkSharedAreaAddr);
  $RELEASE(D_WorkPeNum);
  p_WriteWithOffset
    (src_reg,D_WorkSharedAreaAddr,_MEASUREMENT_REC_PTR_AREA_BASE);
  $RELEASE(D_WorkSharedAreaAddr);
}

#PSL_define s_PutToMeasurementRecordTempArea
	(slot_pos_reg, src_reg_pe_num, src_reg)
{
  $USE(D_WorkSharedAreaAddr);
  $USE(D_WorkPeNum);

  b_MultiplyImmediateWithDNTC
    (src_reg_pe_num,_MAX_SLOTS_PROFILE_VECT,D_WorkPeNum);
  b_AddWithDNTC(D_WorkPeNum,slot_pos_reg,D_WorkPeNum);
  b_ExchangeElmposToOffset(D_WorkPeNum,D_WorkSharedAreaAddr);
  $RELEASE(D_WorkPeNum);
  p_WriteWithOffset
    (src_reg,D_WorkSharedAreaAddr,_MEASUREMENT_REC_TEMP_AREA_BASE);
  $RELEASE(D_WorkSharedAreaAddr);
}

#PSL_define s_GetFromMeasurementRecordTempArea
	(slot_pos_reg, src_reg_pe_num, dst_reg)
{
  $USE(D_WorkSharedAreaAddr);
  $USE(D_WorkPeNum);

  b_MultiplyImmediateWithDNTC
    (src_reg_pe_num,_MAX_SLOTS_PROFILE_VECT,D_WorkPeNum);
  b_AddWithDNTC(slot_pos_reg,D_WorkPeNum,D_WorkPeNum);
  b_ExchangeElmposToOffset(D_WorkPeNum,D_WorkSharedAreaAddr);
  $RELEASE(D_WorkPeNum);
  p_ReadWithOffset
    (D_WorkSharedAreaAddr,_MEASUREMENT_REC_TEMP_AREA_BASE,dst_reg);
  $RELEASE(D_WorkSharedAreaAddr);
}


/******************************************************************** PSL **
 $B!;(B $B3F7WB,9`L\Kh$N!"%a%8%c!<%a%s%H%l%3!<%I$NA`:n(B
********************************************************************* PSL **/

/******************************************************************** PSL **
$B7WB,9`L\#0!'(B $B%"%$%I%k;~4V(B

	s_RecordIdleStartLog()	$B%"%$%I%k$KF~$k;~$K8F$V(B
	s_RecordIdleStopLog()	$B%"%$%I%k$+$iH4$1$k;~$K8F$V(B
	s_InitIdleLogMeasurementRecord()
				$B%"%$%I%k%a%8%c!<%a%s%H%l%3!<%I$N=i4|2=(B
	s_TerminateIdleLogMeasurementRecord()
				$B%"%$%I%k%a%8%c!<%a%s%H%l%3!<%I$N8e;OKv=hM}(B

       written by imai@icot22      on Mon Aug 12 21:06:22 1991

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%"%$%I%k$N%a%8%c!<%a%s%H%l%3!<%I$N9=@.$O<!$NDL$j(B
	+-------+
STRG--->|CDESC	| ($BI,$:(B 32bit $B%9%H%j%s%0(B)
	|-------|
	|	| Offset (3-N) $B$I$3$^$G%l%3!<%I$7$?$+$N%]%$%s%?$,$o$j(B
	|-------|
	|	| Total Running $B;~4V(B
	|-------|
	|	| Total Idling $B;~4V(B
	|-------|
	|	| $B7WB,3+;O;~9o(B
	|-------|
	|	| 1st Idle start $B;~9o(B
	|-------|
	|	| 1st Idle stop  $B;~9o(B
	|-------|
	|	| 2nd Idle start $B;~9o(B
	|-------|
	|	| 2st Idle stop  $B;~9o(B
	|-------|
	:   :	:
	:   :	:
	|-------|
 n-1$BMWAG(B|	|
	+-------+
<Examples>
<Test>
<Explanation>
  $B3F%W%m%;%C%5$,!"%"%$%I%k>uBV!J$KF~$k!K!?!J$+$i=P$k!K;~$K8F$V(B
<ETC>
********************************************************************* PSL **/

/* $BMWAG0LCV(B(index)$B$J$N$G!"(B#ADDR_define $B$G$O$J$$(B */
#CONST_define	_INDEX_ELEM_POS_IDLE_MEASUREMENT_REC		0
#CONST_define	_TOTAL_RUN_TIME_ELEM_POS_IDLE_MEASUREMENT_REC	1
#CONST_define	_TOTAL_IDLE_TIME_ELEM_POS_IDLE_MEASUREMENT_REC	2
#CONST_define	_START_TIME_ELEM_POS_IDLE_MEASUREMENT_REC	3

#PSL_define s_RecordIdleStartLog()
{
  $USE(D_WorkPtrToMeasurementRec);
  s_SoftLockMeasurementRecordPointerArea
    (_IDLE_TIME_ELEM_POS_PROFILE_VECT,D_PE_Number,D_WorkPtrToMeasurementRec);
  @DEBUG{
    s_IfIdlingPE(D_WorkPtrToMeasurementRec) {
      VPIM_ERROR("s_RecordIdleStartLog","Inconsistency");
    }};
  s_IfIdleTimeProfileOn(D_WorkPtrToMeasurementRec) {
    @DEBUG{
      s_IfNotSTRG(D_WorkPtrToMeasurementRec) {
	VPIM_ERROR("s_RecordIdleStartLog","Not String!");
      }
    };
    /* $B7WB,Cf(B */
    $USE(D_WorkIndex);		$USE(D_WorkElemPos);
    $USE(D_WorkCurrentTime);    $USE(D_WorkPrevTime);
    $USE(D_WorkStringLen);

    /* (1) Index $B$r(B D_WorkIndex $B$KF@$k(B */
    b_SetImmValueDNTC(_INDEX_ELEM_POS_IDLE_MEASUREMENT_REC,D_WorkElemPos);
    s_Get32BitStringElement
      (D_WorkPtrToMeasurementRec,D_WorkElemPos,D_WorkIndex);
    @DEBUG{
      b_IfEven(D_WorkIndex) {
	VPIM_ERROR("s_RecordIdleStartLog","Index Inconsistency!");
      }};
    /* (2) $B%9%H%j%s%0D9$r(B D_WorkStringLen $B$KF@$k(B */
    s_GetStringType(D_WorkPtrToMeasurementRec,D_WorkStringLen,D_VOID);

    /* (3) $B8=:_;~9o$r(B D_WorkCurrentTime $B$KF@$k(B */
    b_GetCurrentTime(D_WorkCurrentTime);

    /* (4.1) $BA02s$N(B Idle Stop $B;~9o$,$I$3$K5-O?$5$l$F$$$k$+$rF@$k$?$a!"(B
		Index $B$,%*!<%P!<%U%m!<$7$?$+$I$&$+$N8!::$r$9$k(B */
    b_DecrementReg(D_WorkStringLen);
    b_IfGreater(D_WorkStringLen,D_WorkIndex) {
      /* (4.a) Index $B$O%*!<%P%U%m!<$7$F$$$J$$(B */
      /* (4.a.1) $BA02s(B Idle Stop $B$N;~9o$r(B D_WorkPrevTime $B$KBeF~$9$k(B*/
      s_Get32BitStringElement
	(D_WorkPtrToMeasurementRec,D_WorkIndex,D_WorkPrevTime);
      b_IncrementReg(D_WorkIndex);
      /* (4.a.2) $B:#$N;~9o(B (Idle Start) $B$r%l%3!<%I$K5-O?$9$k(B */
      s_Put32BitStringElement
	(D_WorkPtrToMeasurementRec,D_WorkIndex,D_WorkCurrentTime);
    } else {
      /* (4.b) Index $B$,%*!<%P%U%m!<$7$F$$$k(B */
      /* (4.b.1) $BA02s(B Idle Stop $B$N;~9o$,(B D_WorkPrevTime $B$KBeF~$9$k(B*/
      /* (4.a.2) $B:#$N;~9o(B (Idle Start) $B$r%l%3!<%I$K5-O?$9$k(B (overwrite) */
      s_Swap32BitStringElement
	(D_WorkPtrToMeasurementRec,D_WorkStringLen,
	 D_WorkPrevTime,D_WorkCurrentTime);
    }
    $RELEASE(D_WorkStringLen);
    $RELEASE(D_WorkIndex);
    $USE(D_WorkWordElem);
    /* (5)   Total Run Time $B$r99?7$9$k(B */
    /* (5.1) $B:#2s$N(B run time ($BA02s(B idle $B$rH4$1$?;~$+$i:#$^$G(B) $B$rF@$k(B */
    b_SubtractWithDNTC(D_WorkCurrentTime,D_WorkPrevTime,D_WorkWordElem);
    $RELEASE(D_WorkCurrentTime); $RELEASE(D_WorkPrevTime);
    /* (5.2) Total Run Time $B$r99?7$9$k(B */
    b_SetImmValueDNTC
      (_TOTAL_RUN_TIME_ELEM_POS_IDLE_MEASUREMENT_REC,D_WorkElemPos);
    s_AddValue32BitStringElement
      (D_WorkPtrToMeasurementRec,D_WorkElemPos,D_WorkWordElem);
    $RELEASE(D_WorkWordElem);

    /* (6) Index $B$r99?7$9$k(B */
    b_SetImmValueDNTC(_INDEX_ELEM_POS_IDLE_MEASUREMENT_REC,D_WorkElemPos);
    s_Increment32BitStringElement(D_WorkPtrToMeasurementRec,D_WorkElemPos);
    $RELEASE(D_WorkElemPos);
  }
  s_TurnOnIdling(D_WorkPtrToMeasurementRec);
  s_SoftUnlockMeasurementRecordPointerArea
    (_IDLE_TIME_ELEM_POS_PROFILE_VECT, D_PE_Number, D_WorkPtrToMeasurementRec);
  $RELEASE(D_WorkPtrToMeasurementRec);
}

#PSL_define s_RecordIdleStopLog()
{
  $USE(D_WorkPtrToMeasurementRec);
  s_SoftLockMeasurementRecordPointerArea
    (_IDLE_TIME_ELEM_POS_PROFILE_VECT,D_PE_Number,D_WorkPtrToMeasurementRec);
  @DEBUG{
    s_IfRunningPE(D_WorkPtrToMeasurementRec) {
      VPIM_ERROR("s_RecordIdleStopLog","Inconsistency");
    }
  };
  s_IfIdleTimeProfileOn(D_WorkPtrToMeasurementRec) {
    @DEBUG{ 
      s_IfNotSTRG(D_WorkPtrToMeasurementRec) {
	VPIM_ERROR("s_RecordIdleStopLog","Not String!");
      }
    };
    /* $B7WB,Cf(B */
    $USE(D_WorkIndex);		$USE(D_WorkElemPos);
    $USE(D_WorkCurrentTime);    $USE(D_WorkPrevTime);
    $USE(D_WorkStringLen);

    /* (1) Index $B$r(B D_WorkIndex $B$KF@$k(B */
    b_SetImmValueDNTC(_INDEX_ELEM_POS_IDLE_MEASUREMENT_REC,D_WorkElemPos);
    s_Get32BitStringElement
      (D_WorkPtrToMeasurementRec,D_WorkElemPos,D_WorkIndex);
    @DEBUG{
      b_IfOdd(D_WorkIndex) {
	VPIM_ERROR("s_RecordIdleStopLog","Index Inconsistency!");
      }};
    /* (2) $B%9%H%j%s%0D9$r(B D_WorkStringLen $B$KF@$k(B */
    s_GetStringType(D_WorkPtrToMeasurementRec,D_WorkStringLen,D_VOID);

    /* (3) $B8=:_;~9o$r(B D_WorkCurrentTime $B$KF@$k(B */
    b_GetCurrentTime(D_WorkCurrentTime);

    /* (4.1) $BA02s$N(B Idle Stop $B;~9o$,$I$3$K5-O?$5$l$F$$$k$+$rF@$k$?$a!"(B
		Index $B$,%*!<%P!<%U%m!<$7$?$+$I$&$+$N8!::$r$9$k(B */
    b_DecrementReg(D_WorkStringLen);
    b_IfGreater(D_WorkStringLen, D_WorkIndex) {
      /* (4.a) Index $B$O%*!<%P%U%m!<$7$F$$$J$$(B */
      /* (4.a.1) $BA02s(B Idle Stop $B$N;~9o$,(B D_WorkPrevTime $B$KBeF~$9$k(B*/
      s_Get32BitStringElement
	(D_WorkPtrToMeasurementRec,D_WorkIndex,D_WorkPrevTime);
      b_IncrementReg(D_WorkIndex);
      /* (4.a.2) $B:#$N;~9o(B (Idle Start) $B$r%l%3!<%I$K5-O?$9$k(B */
      s_Put32BitStringElement
	(D_WorkPtrToMeasurementRec,D_WorkIndex,D_WorkCurrentTime);
    } else {
      /* (4.b) Index $B$,%*!<%P%U%m!<$7$F$$$k(B */
      /* (4.b.1) $BA02s(B Idle Stop $B$N;~9o$,(B D_WorkPrevTime $B$KBeF~$9$k(B*/
      /* (4.a.2) $B:#$N;~9o(B (Idle Start) $B$r%l%3!<%I$K5-O?$9$k(B (overwrite) */
      s_Swap32BitStringElement
	(D_WorkPtrToMeasurementRec,D_WorkStringLen,
	 D_WorkPrevTime,D_WorkCurrentTime);
    }
    $RELEASE(D_WorkStringLen);
    $RELEASE(D_WorkIndex);
    $USE(D_WorkWordElem);
    /* (5)   Total Idle Time $B$r99?7$9$k(B */
    /* (5.1) $B:#2s$N(B Idle time ($BA02s(B idle $B$KF~$C$?;~$+$i:#$^$G(B) $B$rF@$k(B */
    b_SubtractWithDNTC(D_WorkCurrentTime,D_WorkPrevTime,D_WorkWordElem);
    $RELEASE(D_WorkCurrentTime); $RELEASE(D_WorkPrevTime);
    /* (5.2) Total Idle Time $B$r99?7$9$k(B */
    b_SetImmValueDNTC
      (_TOTAL_IDLE_TIME_ELEM_POS_IDLE_MEASUREMENT_REC,D_WorkElemPos);
    s_AddValue32BitStringElement
      (D_WorkPtrToMeasurementRec,D_WorkElemPos,D_WorkWordElem);
    $RELEASE(D_WorkWordElem);

    /* (6) Index $B$r99?7$9$k(B */
    b_SetImmValueDNTC(_INDEX_ELEM_POS_IDLE_MEASUREMENT_REC,D_WorkElemPos);
    s_Increment32BitStringElement(D_WorkPtrToMeasurementRec,D_WorkElemPos);
    $RELEASE(D_WorkElemPos);
  }
  s_TurnOnRunning(D_WorkPtrToMeasurementRec);
  s_SoftUnlockMeasurementRecordPointerArea
    (_IDLE_TIME_ELEM_POS_PROFILE_VECT, D_PE_Number, D_WorkPtrToMeasurementRec);
  $RELEASE(D_WorkPtrToMeasurementRec);
}

#PSL_define s_InitIdleLogMeasurementRecord
	(src_ptr_to_rec,src_current_time,src_idling_flag)
{
  $USE(D_WorkElemPos); $USE(D_WorkWordElem);
  s_IfIdlingPE(src_idling_flag) {
    /* $B!J#1!K(B Offset := 4 */
    b_SetImmTypeValueMRBoff(INT, _FOUR, D_WorkWordElem);
  } else {
    /* $B!J#1!K(B Offset := 3 */
    b_SetImmTypeValueMRBoff(INT, _THREE, D_WorkWordElem);
  }
  b_SetZero(D_WorkElemPos);
  s_Put32BitStringElement(src_ptr_to_rec,D_WorkElemPos,D_WorkWordElem);
  /* $B!J#2!K(B Total Running Time := 0 */
  b_IncrementReg(D_WorkElemPos);
  b_SetImmTypeValueMRBoff(INT,_ZERO,D_WorkWordElem);
  s_Put32BitStringElement(src_ptr_to_rec, D_WorkElemPos, D_WorkWordElem);
  /* $B!J#3!K(B Total Idle Time := 0 */
  b_IncrementReg(D_WorkElemPos);
  s_Put32BitStringElement(src_ptr_to_rec, D_WorkElemPos, D_WorkWordElem);
  /* $B!J#4!K(B Time of Start := $B:#$N;~9o(B */
  b_IncrementReg(D_WorkElemPos);
  s_Put32BitStringElement(src_ptr_to_rec, D_WorkElemPos, src_current_time);
  s_IfIdlingPE(src_idling_flag) {
    /* $B!J#5!K(B first Idle start time := $B:#$N;~9o(B */
    b_IncrementReg(D_WorkElemPos);
    s_Put32BitStringElement(src_ptr_to_rec, D_WorkElemPos, src_current_time);
  }
  $RELEASE(D_WorkWordElem);  $RELEASE(D_WorkElemPos); 
}

#PSL_define s_TerminateIdleLogMeasurementRecord
	(src_ptr_to_rec,src_current_time)
{
  /* (1) Index $B$r(B D_WorkIndex $B$KF@$k(B */
  $USE(D_WorkElemPos); $USE(D_WorkIndex);
  b_SetImmValueDNTC(_INDEX_ELEM_POS_IDLE_MEASUREMENT_REC,D_WorkElemPos);
  s_Get32BitStringElement
    (src_ptr_to_rec,D_WorkElemPos,D_WorkIndex);
  @DEBUG{
    s_IfRunningPE(src_ptr_to_rec) {
      b_IfEven(D_WorkIndex) {
	VPIM_ERROR("s_TerminateIdleLogMeasurementRecord",
		   "Inconsistency (running)");
      }
    } else {
      b_IfOdd(D_WorkIndex) {
	VPIM_ERROR("s_TerminateIdleLogMeasurementRecord",
		   "Inconsistency (idle)");
      }
    }
  };
  $USE(D_WorkStringLen); $USE(D_WorkPrevTime);
  /* (2) $B%9%H%j%s%0D9$r(B D_WorkStringLen $B$KF@$k(B */
  s_GetStringType(src_ptr_to_rec,D_WorkStringLen,D_VOID);
  /* (3.1) $BA02s$N;~9o$,$I$3$K5-O?$5$l$F$$$k$+$rF@$k$?$a!"(B
		Index $B$,%*!<%P!<%U%m!<$7$?$+$I$&$+$N8!::$r$9$k(B */
  b_DecrementReg(D_WorkStringLen);
  b_IfGreater(D_WorkStringLen,D_WorkIndex) {
    /* (3.a) Index $B$O%*!<%P%U%m!<$7$F$$$J$$(B */
    /* (3.a.1) $BA02s(B Idle Stop $B$N;~9o$r(B D_WorkPrevTime $B$KBeF~$9$k(B*/
    s_Get32BitStringElement
      (src_ptr_to_rec,D_WorkIndex,D_WorkPrevTime);
    b_IncrementReg(D_WorkIndex);
    /* (3.a.2) $B:#$N;~9o(B ($B7WB,=*N;(B) $B$r%l%3!<%I$K5-O?$9$k(B */
    s_Put32BitStringElement
      (src_ptr_to_rec,D_WorkIndex,src_current_time);
  } else {
    /* (3.b) Index $B$,%*!<%P%U%m!<$7$F$$$k(B */
    /* (3.b.1) $BA02s(B Idle Stop $B$N;~9o$r(B D_WorkPrevTime $B$KBeF~$9$k(B*/
    /* (3.a.2) $B:#$N;~9o(B ($B7WB,=*N;(B) $B$r%l%3!<%I$K5-O?$9$k(B (overwrite) */
    s_Swap32BitStringElement
      (src_ptr_to_rec,D_WorkStringLen,D_WorkPrevTime,src_current_time);
  }
  $RELEASE(D_WorkStringLen);
  $USE(D_WorkWordElem);
  b_SubtractWithDNTC(src_current_time,D_WorkPrevTime,D_WorkWordElem);
  $RELEASE(D_WorkPrevTime);

  s_IfRunningPE(src_ptr_to_rec) {
    /* $B%H!<%?%k(B Running Time $B$r99?7$9$k(B */
    b_SetImmValueDNTC
      (_TOTAL_RUN_TIME_ELEM_POS_IDLE_MEASUREMENT_REC,D_WorkElemPos);
    s_AddValue32BitStringElement
      (src_ptr_to_rec,D_WorkElemPos,D_WorkWordElem);
  } else {
    /* $B%H!<%?%k(B Idling Time $B$r99?7$9$k(B */
    b_SetImmValueDNTC
      (_TOTAL_IDLE_TIME_ELEM_POS_IDLE_MEASUREMENT_REC,D_WorkElemPos);
    s_AddValue32BitStringElement
      (src_ptr_to_rec,D_WorkElemPos,D_WorkWordElem);
    s_TurnOnRunning(src_ptr_to_rec); /* MRB $B$r(B off $B$K$7$J$$$H$b$C$?$$$J$$$?$a(B*/
  }
  $RELEASE(D_WorkWordElem);
  $RELEASE(D_WorkIndex);$RELEASE(D_WorkElemPos);
}

#CTRL_define s_IfRunningPE(ptr)
{
  s_IfMRBoff(ptr)
}

#CTRL_define s_IfIdlingPE(ptr)
{
  s_IfMRBon(ptr)
}

#PSL_define s_TurnOnRunning(ptr)
{
  s_MRBoffReg(ptr);
}

#PSL_define s_TurnOnIdling(ptr)
{
  s_MRBonReg(ptr);
}

/******************************************************************** PSL **
  $B7WB,9`L\#1!'#G#E#V#C(B

  Multi-PSI $B8GM-$N%O!<%I%&%'%"$rMxMQ$7$?7WB,$G$"$j!"(BVPIM$B$G$O(B
  $B0l@Z%5%]!<%H$7$J$$!#(BMulti-PSI Compatible $B$N$?$a$KF~$l$F$$$k!#(B

       written by imai@icot22      on Fri Sep 13 10:46:04 1991

********************************************************************* PSL **/


/******************************************************************** PSL **
  $B7WB,9`L\#2(B,$B#3!'(B	$B%a%C%;!<%8Aw!?<u?.IQEY(B

	s_RecordMsgSendCountLogMsgType(ptr_to_logical_packet)
		$B#1%a%C%;!<%8$NAw?.;~$K8F$V(B
	s_RecordMsgRecvCountLogMsgType(ptr_to_logical_packet)
		$B#1%a%C%;!<%8$N<u?.;~$K8F$V(B
	s_RecordMultiPacketRecvCountNumberOfMessages()
		$B%^%k%A%Q%1%C%H$H$J$C$?%a%C%;!<%8$r<u?.$9$kKh$K#1EY8F$V(B
	s_RecordMultiPacketRecvCountNumberOfPackets()
		$B%^%k%A%Q%1%C%H$H$J$C$?>l9g$K!"%Q%1%C%H<u?.Kh$K8F$V(B
	s_RecordMultiPacketSendCountNumberOfMessages()
		$B%^%k%A%Q%1%C%H$H$J$C$?%a%C%;!<%8$rAw?.$9$kKh$K#1EY8F$V(B
	s_RecordMultiPacketSendCountNumberOfPackets()
		$B%^%k%A%Q%1%C%H$H$J$C$?>l9g$K!"%Q%1%C%HAw?.Kh$K8F$V(B

       written by imai@icot22      on Tue Aug 20 20:29:59 1991

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $BO@M}%Q%1%C%H$N(B1$B%o!<%I%*%U%;%C%H0LCV$K!"%a%C%;!<%8<oJL$,=q$$$F$"$k!#(B
  $B$3$l$r85$K!"Aw<u?.IQEY$r%+%&%s%H$7$F$$$k!#(B
<ETC>
********************************************************************* PSL **/

#ADDR_define	_MSG_TYPE_OFST_IN_LOGICAL_PACKET	1

#CONST_define	_INDEX_OF_MULTI_PACKET_MSGS	30
#CONST_define	_INDEX_OF_MULTI_PACKET_PACKETS	31

#PSL_define s_RecordMsgSendCountLogMsgType(ptr_to_logical_packet)
{
  s_IfMsgSendFreqProfileOn() {
    $USE(D_WorkID);
    p_ReadWithOffset
	(ptr_to_logical_packet,_MSG_TYPE_OFST_IN_LOGICAL_PACKET,D_WorkID);
    $USE(D_WorkPtrToMeasurementRec);
    s_SoftLockMeasurementRecordPointerArea
      (_MSG_SEND_FREQ_ELEM_POS_PROFILE_VECT,
       D_PE_Number, D_WorkPtrToMeasurementRec);
    s_IfNotINT(D_WorkPtrToMeasurementRec) {
      s_Increment32BitStringElement(D_WorkPtrToMeasurementRec,D_WorkID);
    } /* else $B0l=V$N$9$-$r$D$+$l$F(B profile mode $B$G$J$/$J$C$?(B */
    s_SoftUnlockMeasurementRecordPointerArea
      (_MSG_SEND_FREQ_ELEM_POS_PROFILE_VECT,
       D_PE_Number, D_WorkPtrToMeasurementRec);
    $RELEASE(D_WorkPtrToMeasurementRec);
    $RELEASE(D_WorkID);
  }
}

/* $BO@M}%Q%1%C%H$r:n$i$:$KD>@\%M%C%H%o!<%/$K%a%C%;!<%8$r=P$9>l9g$K;HMQ(B */
#PSL_define s_RecordMsgSendCountLogMsgTypeImm(msg_id_imm)
{
  s_IfMsgSendFreqProfileOn() {
    $USE(D_WorkID);
    b_SetImmValueDNTC(msg_id_imm, D_WorkID);
    $USE(D_WorkPtrToMeasurementRec);
    s_SoftLockMeasurementRecordPointerArea
      (_MSG_SEND_FREQ_ELEM_POS_PROFILE_VECT,
       D_PE_Number, D_WorkPtrToMeasurementRec);
    s_IfNotINT(D_WorkPtrToMeasurementRec) {
      s_Increment32BitStringElement(D_WorkPtrToMeasurementRec,D_WorkID);
    } /* else $B0l=V$N$9$-$r$D$+$l$F(B profile mode $B$G$J$/$J$C$?(B */
    s_SoftUnlockMeasurementRecordPointerArea
      (_MSG_SEND_FREQ_ELEM_POS_PROFILE_VECT,
       D_PE_Number, D_WorkPtrToMeasurementRec);
    $RELEASE(D_WorkPtrToMeasurementRec);
    $RELEASE(D_WorkID);
  }
}

/* $BO@M}%Q%1%C%H$r:n$i$:$KD>@\%M%C%H%o!<%/$K%a%C%;!<%8$r=P$9>l9g$K;HMQ(B */
#PSL_define s_RecordMsgSendCountLogMsgTypeReg(msg_id_reg)
{
  s_IfMsgSendFreqProfileOn() {
    $USE(D_WorkPtrToMeasurementRec);
    s_SoftLockMeasurementRecordPointerArea
      (_MSG_SEND_FREQ_ELEM_POS_PROFILE_VECT,
       D_PE_Number, D_WorkPtrToMeasurementRec);
    s_IfNotINT(D_WorkPtrToMeasurementRec) {
      s_Increment32BitStringElement(D_WorkPtrToMeasurementRec,msg_id_reg);
    } /* else $B0l=V$N$9$-$r$D$+$l$F(B profile mode $B$G$J$/$J$C$?(B */
    s_SoftUnlockMeasurementRecordPointerArea
      (_MSG_SEND_FREQ_ELEM_POS_PROFILE_VECT,
       D_PE_Number, D_WorkPtrToMeasurementRec);
    $RELEASE(D_WorkPtrToMeasurementRec);
  }
}

#PSL_define s_RecordMsgRecvCountLogMsgType(ptr_to_logical_packet)
{
  s_IfMsgRecvFreqProfileOn() {
    $USE(D_WorkID);
    p_ReadWithOffset
	(ptr_to_logical_packet,_MSG_TYPE_OFST_IN_LOGICAL_PACKET,D_WorkID);
    $USE(D_WorkPtrToMeasurementRec);
    s_SoftLockMeasurementRecordPointerArea
      (_MSG_RECV_FREQ_ELEM_POS_PROFILE_VECT,
       D_PE_Number, D_WorkPtrToMeasurementRec);
    s_IfNotINT(D_WorkPtrToMeasurementRec) {
      s_Increment32BitStringElement(D_WorkPtrToMeasurementRec,D_WorkID);
    }  /* else $B0l=V$N$9$-$r$D$+$l$F(B profile mode $B$G$J$/$J$C$?(B */
    s_SoftUnlockMeasurementRecordPointerArea
      (_MSG_RECV_FREQ_ELEM_POS_PROFILE_VECT,
       D_PE_Number, D_WorkPtrToMeasurementRec);
    $RELEASE(D_WorkPtrToMeasurementRec);
    $RELEASE(D_WorkID);
  }
}

#PSL_define s_RecordMultiPacketRecvCountNumberOfMessages()
{
  s_IfMsgRecvFreqProfileOn() {
    $USE(D_WorkPtrToMeasurementRec);
    s_SoftLockMeasurementRecordPointerArea
      (_MSG_RECV_FREQ_ELEM_POS_PROFILE_VECT,
       D_PE_Number, D_WorkPtrToMeasurementRec);
    s_IfNotINT(D_WorkPtrToMeasurementRec) {
      $USE(D_WorkIndex);
      b_SetImmValueDNTC(_INDEX_OF_MULTI_PACKET_MSGS,D_WorkIndex);
      s_Increment32BitStringElement(D_WorkPtrToMeasurementRec,D_WorkIndex);
      $RELEASE(D_WorkIndex);
    }  /* else $B0l=V$N$9$-$r$D$+$l$F(B profile mode $B$G$J$/$J$C$?(B */
    s_SoftUnlockMeasurementRecordPointerArea
      (_MSG_RECV_FREQ_ELEM_POS_PROFILE_VECT,
       D_PE_Number, D_WorkPtrToMeasurementRec);
    $RELEASE(D_WorkPtrToMeasurementRec);
  }
}

#PSL_define s_RecordMultiPacketRecvCountNumberOfPackets()
{
  s_IfMsgRecvFreqProfileOn() {
    $USE(D_WorkPtrToMeasurementRec);
    s_SoftLockMeasurementRecordPointerArea
      (_MSG_RECV_FREQ_ELEM_POS_PROFILE_VECT,
       D_PE_Number, D_WorkPtrToMeasurementRec);
    s_IfNotINT(D_WorkPtrToMeasurementRec) {
      $USE(D_WorkIndex);
      b_SetImmValueDNTC(_INDEX_OF_MULTI_PACKET_PACKETS,D_WorkIndex);
      s_Increment32BitStringElement(D_WorkPtrToMeasurementRec,D_WorkIndex);
      $RELEASE(D_WorkIndex);
    } /* else $B0l=V$N$9$-$r$D$+$l$F(B profile mode $B$G$J$/$J$C$?(B */
    s_SoftUnlockMeasurementRecordPointerArea
      (_MSG_RECV_FREQ_ELEM_POS_PROFILE_VECT,
       D_PE_Number, D_WorkPtrToMeasurementRec);
    $RELEASE(D_WorkPtrToMeasurementRec);
  }
}

#PSL_define s_RecordMultiPacketSendCountNumberOfMessages()
{
  s_IfMsgSendFreqProfileOn() {
    $USE(D_WorkPtrToMeasurementRec);
    s_SoftLockMeasurementRecordPointerArea
      (_MSG_SEND_FREQ_ELEM_POS_PROFILE_VECT,
       D_PE_Number, D_WorkPtrToMeasurementRec);
    s_IfNotINT(D_WorkPtrToMeasurementRec) {
      $USE(D_WorkIndex);
      b_SetImmValueDNTC(_INDEX_OF_MULTI_PACKET_MSGS,D_WorkIndex);
      s_Increment32BitStringElement(D_WorkPtrToMeasurementRec,D_WorkIndex);
      $RELEASE(D_WorkIndex);
    } /* else $B0l=V$N$9$-$r$D$+$l$F(B profile mode $B$G$J$/$J$C$?(B */
    s_SoftUnlockMeasurementRecordPointerArea
      (_MSG_SEND_FREQ_ELEM_POS_PROFILE_VECT,
       D_PE_Number, D_WorkPtrToMeasurementRec);
    $RELEASE(D_WorkPtrToMeasurementRec);
  }
}

#PSL_define s_RecordMultiPacketSendCountNumberOfPackets()
{
  s_IfMsgSendFreqProfileOn() {
    $USE(D_WorkPtrToMeasurementRec);
    s_SoftLockMeasurementRecordPointerArea
      (_MSG_SEND_FREQ_ELEM_POS_PROFILE_VECT,
       D_PE_Number, D_WorkPtrToMeasurementRec);
    s_IfNotINT(D_WorkPtrToMeasurementRec) {
      $USE(D_WorkIndex);
      b_SetImmValueDNTC(_INDEX_OF_MULTI_PACKET_PACKETS,D_WorkIndex);
      s_Increment32BitStringElement(D_WorkPtrToMeasurementRec,D_WorkIndex);
      $RELEASE(D_WorkIndex);
    } /* else $B0l=V$N$9$-$r$D$+$l$F(B profile mode $B$G$J$/$J$C$?(B */
    s_SoftUnlockMeasurementRecordPointerArea
      (_MSG_SEND_FREQ_ELEM_POS_PROFILE_VECT,
       D_PE_Number, D_WorkPtrToMeasurementRec);
    $RELEASE(D_WorkPtrToMeasurementRec);
  }
}

#PSL_define s_InitMsgCountLogMeasurementRecord(src_rec_ptr)
{
  $USE(D_WorkElemPos);
  b_SetImmValueDNTC(_MSG_RECV_FREQ_MEASUREMENT_REC_ELMS_MIN,D_WorkElemPos);
  LOOP() {
    b_DecrementReg(D_WorkElemPos);
    s_Put32BitStringElement(src_rec_ptr,D_WorkElemPos,D_NULL);
    b_IfZero(D_WorkElemPos) { break; }
  }
  $RELEASE(D_WorkElemPos);
}

/******************************************************************** PSL **
  $B7WB,9`L\#4!'(B	$B%/%i%9%?Kh$N6I=j#G#C(B

	s_RecordLocalGCLogStart()
		$B#G#C5/F0;~$K8F$V(B
	s_RecordLocalGCLogStop()
		$B#G#C=*N;;~$K8F$V(B
	s_InitLocalGCLogMeasurementRecord(src_rec_ptr)
		$B#G#C%a%8%c!<%a%s%H%l%3!<%I$N=i4|2=(B
	s_TerminateLocalGCLogMeasurementRecord(src_rec_ptr)
		$B#G#C%a%8%c!<%a%s%H%l%3!<%I$N8e;OKv=hM}(B

       written by imai@icot22      on Tue Aug 20 15:22:23 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
	$B%/%i%9%?Kh$N7WB,$G$"$k(B
<Examples>
<Test>
<Explanation>
	+-------+
STRG--->|CDESC	| ($BI,$:(B 32bit $B%9%H%j%s%0(B)
	|-------|
	|	| Offset (5-N) $B$I$3$^$G%l%3!<%I$7$?$+$N%]%$%s%?$,$o$j(B
	|-------|
	|	| Total GC $B2s?t(B
	|-------|
	|	| Total GC $B;~4V(B
	|-------|
	|	| Max. Heap Top after GC
	|-------|
	|	| $B7WB,3+;O;~9o(B
	|-------|
	|	| $B7WB,3+;O;~E@$N(B Heap Top
	|-------|
	|	| 1st GC Start Time
	|-------|
	|	| Heap Top before 1st GC
	|-------|
	|	| 1st GC End Time
	|-------|
	|	| Heap Top after 1st GC
	|-------|
	:   :	:
	:   :	:
	|-------|
	|	| $B7WB,=*N;;~9o(B
	|-------|
 n-1$BMWAG(B|	| $B7WB,=*N;;~$N(B Heap Top
	+-------+
<ETC>
  1$B2s$N(BGC$B$K$D$-(B 4 $BMWAG$,%Z%"$H$J$C$F5-O?$5$l$k!#(B
********************************************************************* PSL **/

#CONST_define _GC_INDEX_ELEM_POS_IN_MEASUREMENT_REC		0
#CONST_define _TOTAL_GC_COUNT_ELEM_POS_IN_MEASUREMENT_REC	1
#CONST_define _TOTAL_GC_TIME_ELEM_POS_IN_MEASUREMENT_REC	2
#CONST_define _MAX_HEAP_TOP_AFTER_GC_ELEM_POS_IN_MEASUREMENT_REC	3

#CONST_define _GC_SUB_VALUE_INDEX	4

#PSL_define s_RecordLocalGCLogStart()
{
  s_IfLocalGCFreqProfileOn() {
    $USE(D_WorkPtrToMeasurementRec); $USE(D_WorkElemPos);
    s_SoftLockMeasurementRecordPointerArea	/* 0 $BHV(B PE $B$NNN0h$K5-O?$9$k(B */
      (_LOCAL_GC_ELEM_POS_PROFILE_VECT, D_NULL, D_WorkPtrToMeasurementRec);
    @DEBUG{ s_IfINT(D_WorkPtrToMeasurementRec) {
      VPIM_ERROR("s_RecordLocalGCLogStart","Unbelievable!!");
    }};
    /* (1) $B%H!<%?%k#G#C%+%&%s%H$N%$%s%/%j%a%s%H(B */
    b_SetImmValueDNTC
      (_TOTAL_GC_COUNT_ELEM_POS_IN_MEASUREMENT_REC,D_WorkElemPos);
    s_Increment32BitStringElement(D_WorkPtrToMeasurementRec,D_WorkElemPos);
    /* (2) Index$B$r(B D_WorkIndex $B$KF@$k(B */
    b_SetImmValueDNTC(_INDEX_ELEM_POS_IDLE_MEASUREMENT_REC,D_WorkElemPos);
    $USE(D_WorkIndex);
    s_Get32BitStringElement
      (D_WorkPtrToMeasurementRec,D_WorkElemPos,D_WorkIndex);
    /* (3) $B%9%H%j%s%0D9$r(B D_WorkStringLen $B$KF@$k(B */
    $USE(D_WorkStringLen);
    s_GetStringType(D_WorkPtrToMeasurementRec,D_WorkStringLen,D_VOID);
    /* (4) $B:#2s5-O?$9$Y$-(B Index $B$rF@$k(B (D_WorkIndex $B$O!"(Bmodify $B$5$l$k(B) */
    s_GetIndexOfLocalGCLogStart(D_WorkIndex,D_WorkStringLen);
    $RELEASE(D_WorkStringLen);
    /* (5) $B8=:_;~9o$rF@$F!"9o0u$9$k(B */
    $USE(D_WorkCurrentTime);
    b_GetCurrentTime(D_WorkCurrentTime);
    s_Put32BitStringElement
      (D_WorkPtrToMeasurementRec,D_WorkIndex,D_WorkCurrentTime);
    $RELEASE(D_WorkCurrentTime);
    /* (6) $B%R!<%W%H%C%W$r5-O?$9$k(B */
    b_IncrementReg(D_WorkIndex);
    $USE(D_WorkHeapTopPtr);
    s_GetCurrentLogicalHeapTop(D_WorkHeapTopPtr);
    s_Put32BitStringElement
      (D_WorkPtrToMeasurementRec,D_WorkIndex,D_WorkHeapTopPtr);
    $RELEASE(D_WorkHeapTopPtr);
    /* (7) Index += 2; $B$r9T$J$&(B */
    b_SetImmValueDNTC(_TWO,D_WorkIndex);
    s_AddValue32BitStringElement
      (D_WorkPtrToMeasurementRec,D_WorkElemPos,D_WorkIndex);
    $RELEASE(D_WorkIndex);
    s_SoftUnlockMeasurementRecordPointerArea
      (_LOCAL_GC_ELEM_POS_PROFILE_VECT, D_NULL, D_WorkPtrToMeasurementRec);
    $RELEASE(D_WorkPtrToMeasurementRec); $RELEASE(D_WorkElemPos);
  }
}

#PSL_define s_RecordLocalGCLogStop()
{
  s_IfLocalGCFreqProfileOn() {
    $USE(D_WorkPtrToMeasurementRec); $USE(D_WorkElemPos);
    s_SoftLockMeasurementRecordPointerArea
      (_LOCAL_GC_ELEM_POS_PROFILE_VECT,
       D_NULL, D_WorkPtrToMeasurementRec); /* 0 $BHV(B PE $B$NNN0h$K5-O?$9$k(B */
    @DEBUG{ s_IfINT(D_WorkPtrToMeasurementRec) {
      VPIM_ERROR("s_RecordLocalGCLogStop","Unbelievable!!");
    }};
    /* (1) $B%R!<%W%H%C%W$r(B D_WorkHeapTopPtr $B$KF@$k(B */
    $USE(D_WorkHeapTopPtr);
    s_GetCurrentLogicalHeapTop(D_WorkHeapTopPtr);
    /* (2) $B%R!<%W%H%C%W$,(B Max Heap $B$r1[$($?$i5-O?$9$k(B */
    /* (2.1) Max Heap $B$rFI$`(B */
    b_SetImmValueDNTC
      (_MAX_HEAP_TOP_AFTER_GC_ELEM_POS_IN_MEASUREMENT_REC,D_WorkElemPos);
    $USE(D_WorkPrevPtr);
    s_Get32BitStringElement
      (D_WorkPtrToMeasurementRec,D_WorkElemPos,D_WorkPrevPtr);
    /* (2.2) $B1[$($F$$$?$i5-O?$9$k(B */
    b_IfGreater(D_WorkHeapTopPtr,D_WorkPrevPtr) {
      s_Put32BitStringElement
	(D_WorkPtrToMeasurementRec,D_WorkElemPos,D_WorkHeapTopPtr);
    }
    $RELEASE(D_WorkPrevPtr);
    /* (3) $B8=:_;~9o$rF@$k(B */
    $USE(D_WorkCurrentTime);
    b_GetCurrentTime(D_WorkCurrentTime);
    /* (4) $BA02s5-O?0LCV$r(B D_WorkIndex $B$KF@$k(B */
    b_SetImmValueDNTC(_INDEX_ELEM_POS_IDLE_MEASUREMENT_REC,D_WorkElemPos);
    $USE(D_WorkIndex);
    s_Get32BitStringElement
      (D_WorkPtrToMeasurementRec,D_WorkElemPos,D_WorkIndex);
    b_SubtractImmediateWithDNTC(D_WorkIndex,_TWO,D_WorkIndex);
    $USE(D_WorkStringLen);
    s_GetStringType(D_WorkPtrToMeasurementRec,D_WorkStringLen,D_VOID);
    s_GetIndexOfLocalGCLogStart(D_WorkIndex,D_WorkStringLen);
    /* (5) $B#G#C3+;O;~9o$rF@$k(B */
    $USE(D_WorkPrevTime);
    s_Get32BitStringElement
      (D_WorkPtrToMeasurementRec,D_WorkIndex,D_WorkPrevTime);
    /* (6) $B:#2s5-O?0LCV$r(B D_WorkIndex $B$KF@$k(B */
    b_SetImmValueDNTC(_INDEX_ELEM_POS_IDLE_MEASUREMENT_REC,D_WorkElemPos);
    s_Get32BitStringElement
      (D_WorkPtrToMeasurementRec,D_WorkElemPos,D_WorkIndex);
    s_GetIndexOfLocalGCLogStop(D_WorkIndex,D_WorkStringLen);
    $RELEASE(D_WorkStringLen);
    b_IfNotZero(D_WorkIndex) {
      /* overflow $B$7$F$$$J$$(B */
      /* (6.1.a) GC $B=*N;;~9o$N9o0u(B */
      s_Put32BitStringElement
	(D_WorkPtrToMeasurementRec,D_WorkIndex,D_WorkCurrentTime); 
      /* (6.1.b) $B%R!<%W%H%C%W$N9o0u(B */
      b_IncrementReg(D_WorkIndex);
      s_Put32BitStringElement
	(D_WorkPtrToMeasurementRec,D_WorkIndex,D_WorkHeapTopPtr);
    } /* else nothing to do */
    $RELEASE(D_WorkHeapTopPtr);
    /* (7) GC $B;~4V$N@Q;;(B */
    /* (7.1) $B:#2s$N(BGC$B;~4V$rF@$k(B */
    b_SubtractWithDNTC(D_WorkCurrentTime,D_WorkPrevTime,D_WorkCurrentTime);
    $RELEASE(D_WorkPrevTime);
    /* (7.2) $B@Q;;$9$k(B */
    b_SetImmValueDNTC
      (_TOTAL_GC_TIME_ELEM_POS_IN_MEASUREMENT_REC,D_WorkElemPos);
    s_AddValue32BitStringElement
      (D_WorkPtrToMeasurementRec,D_WorkElemPos,D_WorkCurrentTime);
    $RELEASE(D_WorkCurrentTime);
    /* (8) Index $B$r99?7$9$k(B */
    b_SetImmValueDNTC(_GC_INDEX_ELEM_POS_IN_MEASUREMENT_REC,D_WorkElemPos);
    b_SetImmValueDNTC(_TWO,D_WorkIndex);
    s_AddValue32BitStringElement
      (D_WorkPtrToMeasurementRec,D_WorkElemPos,D_WorkIndex);
    $RELEASE(D_WorkIndex);
    s_SoftUnlockMeasurementRecordPointerArea
      (_LOCAL_GC_ELEM_POS_PROFILE_VECT, D_NULL, D_WorkPtrToMeasurementRec);
    $RELEASE(D_WorkPtrToMeasurementRec); $RELEASE(D_WorkElemPos);
  }
}

#PSL_define s_InitLocalGCLogMeasurementRecord(src_rec_ptr)
{
  $USE(D_WorkElemPos); $USE(D_WorkWordElem);
  /* $BBh(B 0 $BMWAG(B; Index */
  b_SetImmValueDNTC(_GC_INDEX_ELEM_POS_IN_MEASUREMENT_REC,D_WorkElemPos);
  b_SetImmTypeValueMRBoff(INT,_FIVE,D_WorkWordElem);
  s_Put32BitStringElement(src_rec_ptr,D_WorkElemPos,D_WorkWordElem);
  /* $BBh(B 1 $BMWAG(B; Total GC Count */
  b_IncrementReg(D_WorkElemPos);
  b_SetImmTypeValueMRBoff(INT,_ZERO,D_WorkWordElem);
  s_Put32BitStringElement(src_rec_ptr,D_WorkElemPos,D_WorkWordElem);
  /* $BBh(B 2 $BMWAG(B; Total GC Time */
  b_IncrementReg(D_WorkElemPos);
  s_Put32BitStringElement(src_rec_ptr,D_WorkElemPos,D_WorkWordElem);
  /* $BBh(B 3 $BMWAG(B; Max Heap Top after GC */
  b_IncrementReg(D_WorkElemPos);
  s_Put32BitStringElement(src_rec_ptr,D_WorkElemPos,D_WorkWordElem);
  /* $BBh(B 4 $BMWAG(B; Start Time */
  b_IncrementReg(D_WorkElemPos);
  b_GetCurrentTime(D_WorkWordElem);
  s_Put32BitStringElement(src_rec_ptr,D_WorkElemPos,D_WorkWordElem);
  /* $BBh(B 5 $BMWAG(B; Heap Top */
  b_IncrementReg(D_WorkElemPos);
  s_GetCurrentLogicalHeapTop(D_WorkWordElem);
  s_Put32BitStringElement(src_rec_ptr,D_WorkElemPos,D_WorkWordElem);
  $RELEASE(D_WorkWordElem); $RELEASE(D_WorkElemPos);
}

#PSL_define s_TerminateLocalGCLogMeasurementRecord(src_rec_ptr)
{
  $USE(D_WorkElemPos);
  /* (1) GC$B=*N;;~9o$N9o0u(B */
  /* (1.1) $B5-O?0LCV(B (Index) $B$rF@$k(B */
  b_SetImmValueDNTC(_GC_INDEX_ELEM_POS_IN_MEASUREMENT_REC,D_WorkElemPos);
  $USE(D_WorkIndex);
  s_Get32BitStringElement(src_rec_ptr,D_WorkElemPos,D_WorkIndex);
  $RELEASE(D_WorkElemPos);
  $USE(D_WorkStringLen);
  s_GetStringType(src_rec_ptr,D_WorkStringLen,D_VOID);
  s_GetIndexOfLocalGCLogStart(D_WorkIndex,D_WorkStringLen);
  $RELEASE(D_WorkStringLen);
  $USE(D_WorkCurrentTime);
  b_GetCurrentTime(D_WorkCurrentTime);
  /* (3.2) $B9o0u$9$k(B */
  s_Put32BitStringElement(src_rec_ptr,D_WorkIndex,D_WorkCurrentTime);
  $RELEASE(D_WorkCurrentTime);
  /* (3) $B%R!<%W%H%C%W%]%$%s%?$N9o0u(B */
  b_IncrementReg(D_WorkIndex);
  $USE(D_WorkHeapTopPtr);
  s_GetCurrentLogicalHeapTop(D_WorkHeapTopPtr);
  /* (2.2) $B9o0u$9$k(B */
  s_Put32BitStringElement(src_rec_ptr,D_WorkIndex,D_WorkHeapTopPtr);
  $RELEASE(D_WorkHeapTopPtr);
  $RELEASE(D_WorkIndex);
}

#PSL_define s_GetCurrentLogicalHeapTop(dst_reg)
{
  b_ReadGlobalHeapTop(dst_reg);
  b_IfGreater(D_CurrentHeapEndPtr,D_HeapHalfAddr) {
    /* $B:#$^$G;H$C$F$$$?%R!<%W$O!">e0L%"%I%l%9B&(B */
    b_SubtractWithDNTC(dst_reg,D_HeapHalfAddr,dst_reg);
  } else {
    /* $B:#$^$G;H$C$F$$$?%R!<%W$O!"2<0L%"%I%l%9B&(B */
    b_SubtractImmediateWithDNTC(dst_reg,_HEAP_AREA_BASE,dst_reg);
  }
}

#CONST_define _MASK_OF_LOCAL_GC_LOG_INDEX	0xfffffffc

#PSL_define s_GetIndexOfLocalGCLogStart(index,string_len)
{
  $USE(D_WorkLength);
  b_SubtractImmediateWithDNTC(string_len,_TWO,D_WorkLength);
  b_IfGreaterEq(index,D_WorkLength) {
    /* overflow $B$7$?(B */
    b_BitwiseAndImmediateWithTag(string_len,_MASK_OF_LOCAL_GC_LOG_INDEX,index);
    b_SubtractImmediateWithTag(index,_TWO,index);
  } else {
    b_IncrementReg(index);
  }
  $RELEASE(D_WorkLength);
}

#PSL_define s_GetIndexOfLocalGCLogStop(index,string_len)
{
  $USE(D_WorkLength);
  b_SubtractImmediateWithDNTC(string_len,_FOUR,D_WorkLength);
  b_IfGreaterEq(index,D_WorkLength) {
    /* overflow $B$7$?(B */
    p_MoveWord(D_NULL,index);
  } else {
    b_IncrementReg(index);
  }
  $RELEASE(D_WorkLength);
}


/******************************************************************** PSL **
  $B7WB,9`L\#5!'(B  log_event/1 $B$K$h$k5-O?(B

	s_RecordLogEventLog(ptr_to_id)
		log_event/1 $B$,8F$P$l$?;~$K!"$=$N0z?t$H;~9o$r5-O?$9$k(B
	s_InitLogEventLogMeasurementRecord(src_measurement_rec_ptr)
		log_event $B%a%8%c!<%a%s%H%l%3!<%I!J%Y%/%?!K$N=i4|2=(B

       written by imai@icot22      on Tue Aug 20 16:08:30 1991

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  $B4q?tMWAGL\(B(2N-1)$B$H!"6v?tMWAGL\(B(2N)$B$r%Z%"$G;H$&(B
  ^^^^^^^^^^^^^^^^    ^^^^^^^^^^^^^^
  $B;~9o(B		      $B%m%0(B

$B!&=*N;8e=hM}$O!"2?$bI,MW$J$$!#(B

********************************************************************* PSL **/

#PSL_define s_RecordLogEventLog(ptr_to_id)
{
  s_IfLogEventFreqProfileOn() {
    $USE(D_WorkPtrToMeasurementRec);
    s_SoftLockMeasurementRecordPointerArea
      (_LOG_EVENT_ELEM_POS_PROFILE_VECT,
       D_PE_Number,D_WorkPtrToMeasurementRec);
    s_IfINT(D_WorkPtrToMeasurementRec) {
      /* $B0l=V$N$9$-$r$D$+$l$F!"(Bprofile mode $B$G$J$/$J$C$?(B */
      goto NopWithSoftUnlock;
    }
    $USE(D_WorkIndex);   $USE(D_WorkVectSize);
    s_GetVectElementPosReg(D_WorkPtrToMeasurementRec,D_NULL,D_WorkIndex);
    s_GetSizeVectType(D_WorkPtrToMeasurementRec,D_WorkVectSize);
    b_SubtractImmediateWithDNTC(D_WorkVectSize,_TWO,D_WorkVectSize);
    b_IfLessEq(D_WorkIndex,D_WorkVectSize) {
      $USE(D_WorkCurrentTime);
      b_GetCurrentTime(D_WorkCurrentTime);
      b_SetImmTypeMRBoff(INT,D_WorkCurrentTime);
      b_IncrementReg(D_WorkIndex);
      s_PutVectElementPosReg(D_WorkPtrToMeasurementRec,D_WorkIndex,
			     D_WorkCurrentTime);
      b_IncrementReg(D_WorkIndex);
      s_PutVectElementPosReg(D_WorkPtrToMeasurementRec,D_WorkIndex,ptr_to_id);
      /* Index (0$BMWAGL\$r99?7(B) */
      s_PutVectElementPosReg(D_WorkPtrToMeasurementRec,D_NULL,D_WorkIndex);
      $RELEASE(D_WorkCurrentTime);
    } else {
      b_AddImmediateWithDNTC(D_WorkIndex,_TWO,D_WorkIndex);
      s_PutVectElementPosReg(D_WorkPtrToMeasurementRec,D_NULL,D_WorkIndex);
    }
  NopWithSoftUnlock:
    s_SoftUnlockMeasurementRecordPointerArea
      (_LOG_EVENT_ELEM_POS_PROFILE_VECT,
       D_PE_Number,D_WorkPtrToMeasurementRec);
    $RELEASE(D_WorkVectSize); $RELEASE(D_WorkIndex);
    $RELEASE(D_WorkPtrToMeasurementRec);
  }
}
  
#PSL_define s_InitLogEventLogMeasurementRecord(src_measurement_rec_ptr)
{
  $USE(D_WorkVectorSize);
  s_GetSizeVectType(src_measurement_rec_ptr,D_WorkVectorSize);
  $USE(D_WorkInitMemReg);
  b_SetImmTypeValueMRBoff(INT,_ZERO,D_WorkInitMemReg);
  $USE(D_WorkElemOfst);
  b_ExchangeElmposToOffset(D_WorkVectorSize, D_WorkElemOfst);
  $RELEASE(D_WorkVectorSize);
  b_DecrementAddrReg(D_WorkElemOfst);
  LOOP(){
    b_IfLess(D_WorkElemOfst, D_NULL){ break;}
    s_PutVectElementOffsetReg
      (src_measurement_rec_ptr, D_WorkElemOfst, D_WorkInitMemReg);
    b_DecrementAddrReg(D_WorkElemOfst);
  }
  $RELEASE(D_WorkElemOfst);
  $RELEASE(D_WorkInitMemReg);
}

/******************************************************************** PSL **
   $B7WB,9`L\#6!'(B	$B%a%C%;!<%8$N%(%s%3!<%I!?%G%3!<%I;~4V(B

	s_RecordMsgEncodeStart()
		$B%a%C%;!<%8$N%(%s%3!<%I$r3+;O$7$?;~$K8F$V(B
	s_RecordMsgEncodeStop()
		$B%a%C%;!<%8$N%(%s%3!<%I$r=*N;$7$?;~$K8F$V(B
	s_RecordMsgDecodeStart()
		$B%a%C%;!<%8$N%G%3!<%I$r3+;O$7$?;~$K8F$V(B
	s_RecordMsgDecodeStop()
		$B%a%C%;!<%8$N%G%3!<%I$r=*N;$7$?;~$K8F$V(B
	s_InitMsgEncDecTimeMeasurementRecord(src_rec,src_current_time)
		$B%(%s%3!<%I!?%G%3!<%I;~4V%a%8%c!<%a%s%H%l%3!<%I$N=i4|2=(B
	s_TerminateMsgEncDecTimeMeasurementRecord(src_rec,src_current_time)
		$B%(%s%3!<%I!?%G%3!<%I;~4V%a%8%c!<%a%s%H%l%3!<%I$N8e;OKv(B

       written by imai@icot22      on Fri Sep 13 13:39:07 1991

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
$B!&%a%C%;!<%8$N%G%3!<%ICf$K%(%s%3!<%I$r9T$J$&>l9g$,$"$k!#(B
	(e.g. %read $B%G%3!<%I;~$N(B %answer_value $B%(%s%3!<%I(B $B$d!"(B
	      %star_shoen $B%G%3!<%I;~$N(B %start_shoen $B%(%s%3!<%I(B $B$J$I(B)
  $B$3$N>l9g!"%(%s%3!<%I;~4V$O!"%G%3!<%I;~4V$K4^$^$J$$!#(B

$B!&%a%C%;!<%8$N%(%s%3!<%I!?%G%3!<%ICf$K!"%a%8%c!<%a%s%H%l%3!<%I$,<h$j49$((B
  $B$i$l$k$3$H$,$"$k!#$3$N>l9g!"(B

  |
  |---+   $B%G%3!<%I3+;O(B    (a)
  |-+ |   $B%(%s%3!<%I3+;O(B  (b)
 ---|-|-- $B%l%3!<%I<h$j49$((B(c)
  |-+ |   $B%(%s%3!<%I=*N;(B  (d)
  |   |
  |-+ |   $B%(%s%3!<%I3+;O(B  (e)
  |-+ |   $B%(%s%3!<%I=*N;(B  (f)
  |---+   $B%G%3!<%I3+;O(B    (g)
  |

  $B;~9o(B(d) $B$K$O!"(B(d-c) $B$r!";~9o(B(g) $B$K$O!"(B((g-c) - (f-e)) $B$r2C;;$9$k(B
<ETC>
********************************************************************* PSL **/

#DATA_define D_MsgEncodeStartTime XXX
#DATA_define D_MsgDecodeStartTime XXX

#CONST_define _MSG_ENC_ELEM_POS_IN_MEASUREMENT_REC			0
#CONST_define _MSG_DEC_ELEM_POS_IN_MEASUREMENT_REC			1
#CONST_define _MSG_ENC_DEC_START_TIME_ELEM_POS_IN_MEASUREMENT_REC	2
#CONST_define _MSG_ENC_DEC_STOP_TIME_ELEM_POS_IN_MEASUREMENT_REC	3

#PSL_define s_RecordMsgEncodeStart()
{
  @DEBUG{
    s_IfMRBon(D_MsgEncodeStartTime) {
      WARNING("s_RecordMsgEncodeStart",
		 "Illegal Invoke (Enc Start --> Enc Start)");
      ttakagi_check_point();
    }
    s_IfMRBon(D_MsgDecodeStartTime) {
      WARNING("s_RecordMsgEncodeStart",
		 "Illegal Invoke (Dec Start --> Enc Start)");
      ttakagi_check_point();
    }
  };
  s_IfMsgEncDecTimeFreqProfileOn() {
    b_GetCurrentTime(D_MsgEncodeStartTime);
  }
  @DEBUG{
    s_MRBonReg(D_MsgEncodeStartTime);
  };
}

#PSL_define s_RecordMsgEncodeStop()
{
  @DEBUG{
    s_IfMRBoff(D_MsgEncodeStartTime) {
      WARNING("s_RecordMsgEncodeStop",
		 "Illegal Invoke (Encode not started)");
      ttakagi_check_point();
    }
    s_IfMRBon(D_MsgDecodeStartTime) {
      WARNING("s_RecordMsgEncodeStop",
		 "Illegal Invoke (Dec Start --> Enc Stop");
      ttakagi_check_point();
    }
  };
  s_IfMsgEncDecTimeFreqProfileOn() {
    $USE(D_WorkPtrToMeasurementRec); $USE(D_WorkElemPos);
    s_SoftLockMeasurementRecordPointerArea
      (_MSG_ENC_DEC_TIME_ELEM_POS_PROFILE_VECT,
       D_PE_Number,D_WorkPtrToMeasurementRec);
    s_IfNotINT(D_WorkPtrToMeasurementRec) {
      $USE(D_WorkCurrentTime);
      b_GetCurrentTime(D_WorkCurrentTime);
      b_SetImmValueDNTC
	(_MSG_ENC_DEC_START_TIME_ELEM_POS_IN_MEASUREMENT_REC,D_WorkElemPos);
      $USE(D_WorkStatus);
      s_Get32BitStringElement(D_WorkPtrToMeasurementRec,D_WorkElemPos,
			      D_WorkStatus);
      b_IfLessEqU(D_WorkStatus,D_MsgDecodeStartTime) {
	/* $BDL>o(B */
	b_SubtractWithDNTC
	    (D_WorkCurrentTime,D_MsgEncodeStartTime,D_WorkCurrentTime);
      } else {
	b_SubtractWithDNTC(D_WorkCurrentTime,D_WorkStatus,D_WorkCurrentTime);
      }
      $RELEASE(D_WorkStatus);
      b_SetImmValueDNTC(_MSG_ENC_ELEM_POS_IN_MEASUREMENT_REC,D_WorkElemPos);
      s_AddValue32BitStringElement(D_WorkPtrToMeasurementRec,D_WorkElemPos,
				   D_WorkCurrentTime);
      $RELEASE(D_WorkCurrentTime);
    } /* else $B0l=V$N$9$-$r$D$+$l$F(B profile mode $B$G$J$/$J$C$?(B */
    s_SoftUnlockMeasurementRecordPointerArea
      (_MSG_ENC_DEC_TIME_ELEM_POS_PROFILE_VECT,
       D_PE_Number,D_WorkPtrToMeasurementRec);
    $RELEASE(D_WorkElemPos); $RELEASE(D_WorkPtrToMeasurementRec);
  }
  @DEBUG{
    s_MRBoffReg(D_MsgEncodeStartTime);
  };
}

#PSL_define s_RecordMsgDecodeStart()
{
  @DEBUG{
    s_IfMRBon(D_MsgDecodeStartTime) {
      WARNING("s_RecordMsgDecodeStart",
		 "Illegal Invoke (Enc Start --> Dec Start)");
      ttakagi_check_point();
    }
    s_IfMRBon(D_MsgDecodeStartTime) {
      WARNING("s_RecordMsgDecodeStart",
		 "Illegal Invoke (Dec Start --> Dec Start)");
      ttakagi_check_point();
    }
  };
  s_IfMsgEncDecTimeFreqProfileOn() {
    b_GetCurrentTime(D_MsgDecodeStartTime);
  }
  @DEBUG{
    s_MRBonReg(D_MsgDecodeStartTime);
  };
}

#PSL_define s_RecordMsgDecodeStop()
{
  @DEBUG{
    s_IfMRBoff(D_MsgDecodeStartTime) {
      WARNING("s_RecordMsgDecodeStop",
		 "Illegal Invoke (Decode not started)");
      ttakagi_check_point();
    }
    s_IfMRBon(D_MsgEncodeStartTime) {
      WARNING("s_RecordMsgDecodeStop",
		 "Illegal Invoke (Enc Start --> Dec Stop");
      ttakagi_check_point();
    }
  };
  s_IfMsgEncDecTimeFreqProfileOn() {
    @DEBUG{
      p_IfLT() {
	WARNING("s_UpdateMsgDecodeTimeStopLog","Timer overflow");
      }
    };
    $USE(D_WorkCurrentTime);
    $USE(D_WorkPtrToMeasurementRec); $USE(D_WorkElemPos);
    s_SoftLockMeasurementRecordPointerArea
      (_MSG_ENC_DEC_TIME_ELEM_POS_PROFILE_VECT,
       D_PE_Number,D_WorkPtrToMeasurementRec);
    s_IfNotINT(D_WorkPtrToMeasurementRec) {
      b_GetCurrentTime(D_WorkCurrentTime);
      b_SetImmValueDNTC
	(_MSG_ENC_DEC_START_TIME_ELEM_POS_IN_MEASUREMENT_REC,D_WorkElemPos);
      $USE(D_WorkStatus);
      s_Get32BitStringElement(D_WorkPtrToMeasurementRec,D_WorkElemPos,
			      D_WorkStatus);
      b_IfLessEqU(D_WorkStatus,D_MsgDecodeStartTime) {
	/* $BDL>o(B */
	b_SubtractWithDNTC
	  (D_WorkCurrentTime,D_MsgDecodeStartTime,D_WorkCurrentTime);
      } else {
	/* Decode $BCf$K%l%3!<%I<h$j49$($,$"$C$?(B*/
	b_SubtractWithDNTC
	  (D_WorkCurrentTime,D_WorkStatus,D_WorkCurrentTime);
      }
      $RELEASE(D_WorkStatus);
      b_SetImmValueDNTC(_MSG_DEC_ELEM_POS_IN_MEASUREMENT_REC,D_WorkElemPos);
      s_AddValue32BitStringElement(D_WorkPtrToMeasurementRec,D_WorkElemPos,
				   D_WorkCurrentTime);
    } /* else $B0l=V$N$9$-$r$D$+$l$F(B profile mode $B$G$J$/$J$C$?(B */
    s_SoftUnlockMeasurementRecordPointerArea
      (_MSG_ENC_DEC_TIME_ELEM_POS_PROFILE_VECT,
       D_PE_Number,D_WorkPtrToMeasurementRec);
    $RELEASE(D_WorkElemPos); $RELEASE(D_WorkPtrToMeasurementRec);
    $RELEASE(D_WorkCurrentTime);
  }
  @DEBUG{
    s_MRBoffReg(D_MsgDecodeStartTime);
  };
}

#PSL_define s_InitMsgEncDecTimeMeasurementRecord(src_rec,src_current_time)
{
  $USE(D_WorkElemPos);
  b_SetImmValueDNTC(_MSG_ENC_ELEM_POS_IN_MEASUREMENT_REC,D_WorkElemPos);
  $USE(D_WorkStructElem);
  b_SetImmTypeValueMRBoff(INT,_ZERO,D_WorkStructElem);
  s_Put32BitStringElement(src_rec,D_WorkElemPos,D_WorkStructElem);
  b_IncrementReg(D_WorkElemPos);
  s_Put32BitStringElement(src_rec,D_WorkElemPos,D_WorkStructElem);
  $RELEASE(D_WorkStructElem);
  b_SetImmValueDNTC(_MSG_ENC_DEC_START_TIME_ELEM_POS_IN_MEASUREMENT_REC,
		    D_WorkElemPos);
  s_Put32BitStringElement(src_rec,D_WorkElemPos,src_current_time);
  $RELEASE(D_WorkElemPos);
}

#PSL_define s_TerminateMsgEncDecTimeMeasurementRecord(src_rec,src_current_time)
{
  $USE(D_WorkElemPos);
  b_SetImmValueDNTC(_MSG_ENC_DEC_STOP_TIME_ELEM_POS_IN_MEASUREMENT_REC,
		    D_WorkElemPos);
  s_Put32BitStringElement(src_rec,D_WorkElemPos,src_current_time);
  $RELEASE(D_WorkElemPos);
}

/******************************************************************** PSL **
  $B%a%8%c!<%a%s%H%l%3!<%I%]%$%s%?NN0h!?2>NN0h$N=i4|2=(B
       written by imai@icot22      on Thu Aug 22 19:32:30 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkWordElem	XXX

#PSL_define s_InitMeasurementRecPointerArea()
{
  $USE(D_WorkWordElem); $USE(D_WorkElemPos);
  b_SetImmTypeValueMRBoff(INT,_ZERO,D_WorkWordElem);
  b_SetImmValueDNTC(_MAX_SLOTS_PROFILE_VECT,D_WorkElemPos);
  LOOP() {
    b_DecrementReg(D_WorkElemPos);
    s_PutToMeasurementRecordPointerArea
     (D_WorkElemPos, D_PE_Number, D_WorkWordElem);
    b_IfZero(D_WorkElemPos) { break; }
  }
  $RELEASE(D_WorkElemPos); $RELEASE(D_WorkWordElem);
}

#PSL_define s_InitMeasurementRecTempArea()
{
  $USE(D_WorkWordElem);
  $USE(D_WorkCopyCount);
  $USE(D_WorkNumCount);
  b_SetImmTypeValueMRBoff(INT,_ZERO,D_WorkWordElem);
  b_ReadPENumInCluster(D_WorkNumCount);
  LOOP() {
    b_DecrementReg(D_WorkNumCount);
    b_SetImmValueDNTC(_MAX_ELEMENTS_PROFILE_VECT,D_WorkCopyCount);
    LOOP() {
      b_DecrementReg(D_WorkCopyCount);
      s_PutToMeasurementRecordTempArea
	(D_WorkCopyCount, D_WorkNumCount, D_WorkWordElem);
      b_IfZero(D_WorkCopyCount) { break; }
    }
    b_IfZero(D_WorkNumCount) { break; }
  }
  $RELEASE(D_WorkNumCount);
  $RELEASE(D_WorkCopyCount);
  $RELEASE(D_WorkWordElem);
}

/******************************************************************** PSL **
  $B%W%m%U%!%$%k%a%$%s%9%$%C%A$N8!::(B
       written by imai@icot22      on Sat Aug 24 13:02:06 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_InitializeProcessorProfilerMainSwitch()
{
  b_SetImmValueDNTC(_ZERO,D_ProcessorProfilerMainSwitch);
}

#PSL_define s_ProfileMainSwitchOn()
{
  @DEBUG{
    b_IfNotEqualImm(D_ProcessorProfilerMainSwitch,_ZERO) {
      WARNING("s_ProfileMainSwitchOn","Previous State was NOT OFF");
    }};
  b_SetImmValueDNTC(_ALL1,D_ProcessorProfilerMainSwitch);
}

#PSL_define s_ProfileMainSwitchOff()
{
  @DEBUG{
    b_IfNotEqualImm(D_ProcessorProfilerMainSwitch,_ALL1) {
      WARNING("s_ProfileMainSwitchOff","Previous State was NOT ON");
    }};
  b_SetImmValueDNTC(_ZERO,D_ProcessorProfilerMainSwitch);
}

#CTRL_define s_IfProfileMainSwitchOn()
{
  b_IfNotEqual(D_ProcessorProfilerMainSwitch,D_NULL)
}

#CTRL_define s_IfProfileMainSwitchOff()
{
  b_IfEqual(D_ProcessorProfilerMainSwitch,D_NULL)
}



/******************************************************************** PSL **
  $B%W%m%U%!%$%k%a%$%s%9%$%C%A$N>uBVJQ2=$N%V%m!<%I%-%c%9%H(B
       written by imai@icot22      on Fri Aug 23 17:30:24 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_BroadcastProcessorProfileSwitch()
{
  b_ReadWithLockCommArea (_PROCESSOR_PROFILE_STAT_CHANGE,D_VOID);
  /* $BA4(B PE $B$KDLCN(B */
  b_AllSignalOnSCR(_PROCESSOR_PROFILE_CHANGE_EVENT);
  /* $B%m!<%+%k%j%;%C%H(B */
  b_ResetEventFlag(_PROCESSOR_PROFILE_CHANGE_EVENT,D_PE_Number);
  b_WriteAndUnlockCommArea 
    (D_ProcessorProfilerMainSwitch, _PROCESSOR_PROFILE_STAT_CHANGE);
}


/******************************************************************** PSL **
$B$3$N%U%!%$%k$GMQ$$$k(B $B%a%8%c!<%a%s%H%l%3!<%I$KBP$9$k=hM}%^%/%m72(B
       written by imai@icot22      on Tue Aug 20 20:24:39 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  $BE83+=*C<$K$7$F!"9bB.2=$r?^$C$?J}$,NI$$!#(B
	s_PutStringElementPosReg
	s_GetStringElementPosReg
  $B$O!"2?(Bbit$B%9%H%j%s%0$+$rF0E*$KH=Dj$7$F!"(BShift $B$r$7$?$j$7$F(B
  $B$d$C$H!"FI$_$@$7$?$j!"=q$-9~$s$@$j$7$F$$$k!#(B
********************************************************************* PSL **/

#DATA_define D_Work32BitElement	XXX

#PSL_define s_Increment32BitStringElement(ptr_to_32bit_string,elm_pos_reg)
{
  @DEBUG{
    s_IfNotSTRG(ptr_to_32bit_string) {
      VPIM_ERROR("s_Increment32BitStringElement","Not String");
    }};
  $USE(D_WorkStrElmSize); $USE(D_Work32BitElement);
  b_SetImmValueDNTC(_ELEM_SIZE_OF_STRG32,D_WorkStrElmSize);
  s_GetStringElementPosReg(ptr_to_32bit_string,elm_pos_reg,
			   D_WorkStrElmSize,D_Work32BitElement);
  b_IncrementReg(D_Work32BitElement);
  s_PutStringElementPosReg(ptr_to_32bit_string,elm_pos_reg,
			   D_WorkStrElmSize,D_Work32BitElement);
  $RELEASE(D_WorkStrElmSize); $RELEASE(D_Work32BitElement);
}

#PSL_define s_Increment32BitStringElementWithResult
	(ptr_to_32bit_string,elm_pos_reg,result_reg)
{
  @DEBUG{
    s_IfNotSTRG(ptr_to_32bit_string) {
      VPIM_ERROR("s_Increment32BitStringElement","Not String");
    }};
  $USE(D_WorkStrElmSize);
  b_SetImmValueDNTC(_ELEM_SIZE_OF_STRG32,D_WorkStrElmSize);
  s_GetStringElementPosReg(ptr_to_32bit_string,elm_pos_reg,
			   D_WorkStrElmSize,result_reg);
  b_IncrementReg(result_reg);
  s_PutStringElementPosReg(ptr_to_32bit_string,elm_pos_reg,
			   D_WorkStrElmSize,result_reg);
  $RELEASE(D_WorkStrElmSize);
}

#PSL_define s_AddValue32BitStringElement
	(ptr_to_32bit_string,elm_pos_reg,add_value_reg)
{
  @DEBUG{
    s_IfNotSTRG(ptr_to_32bit_string) {
      VPIM_ERROR("s_AddValue32BitStringElement","Not String");
    }};
  $USE(D_WorkStrElmSize); $USE(D_Work32BitElement);
  b_SetImmValueDNTC(_ELEM_SIZE_OF_STRG32,D_WorkStrElmSize);
  s_GetStringElementPosReg(ptr_to_32bit_string,elm_pos_reg,
			   D_WorkStrElmSize,D_Work32BitElement);
  b_AddWithTag(D_Work32BitElement,add_value_reg,D_Work32BitElement);
  s_PutStringElementPosReg(ptr_to_32bit_string,elm_pos_reg,
			   D_WorkStrElmSize,D_Work32BitElement);
  $RELEASE(D_WorkStrElmSize); $RELEASE(D_Work32BitElement);
}

#PSL_define s_Get32BitStringElement
	(ptr_to_32bit_string,elm_pos_reg,dst_reg)
{
  $USE(D_WorkStrElmSize);
  b_SetImmValueDNTC(_ELEM_SIZE_OF_STRG32,D_WorkStrElmSize);
  s_GetStringElementPosReg(ptr_to_32bit_string,elm_pos_reg,
			   D_WorkStrElmSize,dst_reg);
  $RELEASE(D_WorkStrElmSize);
}

#PSL_define s_Put32BitStringElement
	(ptr_to_32bit_string,elm_pos_reg,src_reg)
{
  $USE(D_WorkStrElmSize);
  b_SetImmValueDNTC(_ELEM_SIZE_OF_STRG32,D_WorkStrElmSize);
  s_PutStringElementPosReg(ptr_to_32bit_string,elm_pos_reg,
			   D_WorkStrElmSize,src_reg);
  $RELEASE(D_WorkStrElmSize);
}

#PSL_define s_Swap32BitStringElement
	(ptr_to_32bit_string,elm_pos_reg,dst_old_elm,src_new_elm)
{
  $USE(D_WorkStrElmSize);
  b_SetImmValueDNTC(_ELEM_SIZE_OF_STRG32,D_WorkStrElmSize);
  s_GetStringElementPosReg
    (ptr_to_32bit_string,elm_pos_reg,D_WorkStrElmSize,dst_old_elm);
  s_PutStringElementPosReg
    (ptr_to_32bit_string,elm_pos_reg,D_WorkStrElmSize,src_new_elm);
  $RELEASE(D_WorkStrElmSize);
}

/******************************************************************** PSL **
  processor_profile/2 $B$N(B
  $BF~NO8!::$N;~$N%^%/%m4V%$%s%?%U%'!<%9$N$?$a$N%^%/%m(B
       written by imai@icot22      on Mon Aug 26 19:10:44 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $BF~NO8!::$N7k2L!"(B
  $BE,@5F~NO(B:		_PROCESSOR_PROFILE_PROPER_INPUT
  $BL$Dj5AEy$K$h$kCfCG(B:	_PROCESSOR_PROFILE_SUSPENSION_INPUT
  $BIT@5F~NO(B:		_PROCESSOR_PROFILE_ILLEGAL_INPUT
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CONST_define _PROCESSOR_PROFILE_PROPER_INPUT		0
#CONST_define _PROCESSOR_PROFILE_SUSPENTION_INPUT	1
#CONST_define _PROCESSOR_PROFILE_ILLEGAL_INPUT		2
#CONST_define _PROCESSOR_PROFILE_RANGE_OVERFLOW		3

#PSL_define s_SetProperInputProcessorProfile(reg)
{
  b_SetImmValueDNTC(_PROCESSOR_PROFILE_PROPER_INPUT,reg);
}

#PSL_define s_SetSuspentionInputProcessorProfile(reg)
{
  b_SetImmValueDNTC(_PROCESSOR_PROFILE_SUSPENTION_INPUT,reg);
}

#PSL_define s_SetIllegalInputProcessorProfile(reg)
{
  b_SetImmValueDNTC(_PROCESSOR_PROFILE_ILLEGAL_INPUT,reg);
}

#PSL_define s_SetRangeOverflowProcessorProfile(reg)
{
  b_SetImmValueDNTC(_PROCESSOR_PROFILE_RANGE_OVERFLOW,reg);
}

#CTRL_define s_IfNotProperInputProcessorProfile(reg)
{
  b_IfNotEqualImm(reg,_PROCESSOR_PROFILE_PROPER_INPUT)
}

#CTRL_define s_IfProperInputProcessorProfile(reg)
{
  b_IfEqualImm(reg,_PROCESSOR_PROFILE_PROPER_INPUT)

}
