
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/structures/str_pr_goal_stack.psl.c
   ----- CREATED   : by hirata@icot22, on Tue Jun 12 09:21:58 1990
   ----- LAST SAVED: by imai@icot22, on Tue Oct 15 19:24:34 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : structures
   ----- ABSTRACT  : $B%W%i%$%*%j%F%#IU$-%4!<%k%9%?%C%/$HA`:n(B

A. $B9`L\(B
  1. $B%W%i%$%*%j%F%#IU$-%4!<%k%9%?%C%/$N%(%s%H%j(B
  2. $B%W%i%$%*%j%F%#IU$-%4!<%k%9%?%C%/$N9=B$(B
  3. $B@)8f%l%8%9%?$H%3%s%9%?%s%H(B
    3.1 $B%4!<%k%9%?%C%/$NA`:n$K$*$1$kNN0h%A%'%C%/(B
  4. $B%4!<%k%9%?%C%/%(%s%H%j$N3F%9%m%C%H$X$N=q$-9~$_(B
  5. $B%4!<%k%9%?%C%/%(%s%H%j$N3F%9%m%C%H$NFI$_$@$7(B
  6. $B%W%i%$%*%j%F%#$K=>$C$F%4!<%k%9%?%C%/%(%s%H%j$rF@$kA`:n(B
  7. $B<!$N6u$G$J$$%9%?%C%/%(%s%H%j$rF@$kA`:n(B
  8. $B%W%i%$%*%j%F%#IU$-%4!<%k%9%?%C%/$N=i4|2=(B
    8.1  PE $B$X$N%4!<%k%9%?%C%/$NNN0h$r3d$jEv$F(B
    8.2  $BA4$F$N%4!<%k%9%?%C%/%(%s%H%j$N=i4|2=(B
  9. $B%4!<%k%9%?%C%/$N>uBV$rD4$Y$kA`:n(B ($B%$%Y%s%H%O%s%I%iMQ(B)
    9.1  $B%W%m%;%C%5$,%"%$%I%k$+$I$&$+D4$Y$kA`:n(B
    9.2  $B%W%m%;%C%5$N%4!<%k%9%?%C%/$KJ#?t$N%4!<%k$,$"$k$+$I$&$+$rD4$Y$kA`:n(B
 10. $B%W%i%$%*%j%F%#%-%e!<$NA`:n(B
 11. $B%4!<%k%9%?%C%/$NESCf$N%(%s%H%j$N:o=|(B
 12. $B%4!<%k%j%s%/$,6u$G$J$$%(%s%H%j$rA\$9(B

B. $BM%@hEYIU$-%4!<%k%9%?%C%/$*$h$S%9%?%C%/$KBP$9$kA`:n$rDj5A$9$k(B.

  $B!&(BV02$B$K$*$1$k;EMM$O(B, $B%^%k%A(BPSI$B$N=hM}7O$H$[$\F1$8$G$"$k!#$7$+$7(B, $B%/%i%9%?Fb$N(B
    $BIi2YJ,;6J}<0$r(BPIM$B8~$1$K2~NI$9$kI,MW$b$"$k$?$a(B, $B8=;EMM$O2>HG$H9M$($?J}$,(B
    $BNI$$!#(B

  $B!&%4!<%k%9%?%C%/$N%(%s%H%j$O8GDjD9$N%"%l%$$H$7$F(B, $B3F(BPE$BKh$KMQ0U$9$k!#(B
    $B%"%l%$$NBg$-$5$O(B, $BJ*M}%W%i%$%*%j%F%#$N$H$kCM$N@0?tG\$G$"$k!#(B

<HERE WE ARE>
  $B6X$8<j$N%3%T!<$r7+$j=P$7$F$7$^$C$?!#8e$G8+D>$=$C$H!#(Bpolish up here
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
1. $B%W%i%$%*%j%F%#IU$-%4!<%k%9%?%C%/$N%(%s%H%j(B

       written by goto@icot22      Tue Nov 22 09:19:40 1988

<Explanation>
	$B%4!<%k%9%?%C%/$N%(%s%H%j(B(GOAL_STACK_ENTRY)$B$O(B,
	     0.	$B<!$KDc$$M%@hEY(B($B6u$G$J$$(B)$B%(%s%H%j$X$N%]%$%s%?(B
	     1.	$B$=$N%(%s%H%j$NJ*M}%W%i%$%*%j%F%#(B,
	     2.	$B%4!<%k%l%3!<%I$X$N%]%$%s%?(B,
	     3.	$B<!$K9bM%@hEY(B($B6u$G$J$$(B)$B%(%s%H%j$X$N%]%$%s%?(B
	$B$+$i$J$k!#$=$l$>$l$N%9%m%C%H$OCM$H$7$F(B32$B%S%C%H$r;}$D!#(B
	$B%(%s%H%j$X$N%]%$%s%?(B, $B$*$h$S%4!<%k%l%3!<%I%j%s%/$N=*C<$O(B EOL $B$H$9$k!#(B

	typedef struct {
		word	pointer_to_next_lower_entry;
		word	physical_priority;
	  	word	pointer_to_goalrecord;
		word	pointer_to_next_higher_entry;
	      } GOAL_STACK_ENTRY

		Higher Priority
  		^
	+-------|--+
 xxxx3	|REF !  o  |	goalrecord	goalrecord	goalrecord
        |----------|    +----------+    +----------+    +----------+
 xxxx2	|HOOK!  o--+--->|HOOK!  o--+--->|HOOK!  o--+--->|EOL !     |
        |----------|    |	   |	|	   |	|	   |
 xxxx1	|INT !prio |    |	   |	|	   |	|	   |
        |----------|    +----------+	+----------+	+----------+
 xxxx0	|REF !  o  |
	+-------|--+
		V
		Lower Priority
<ETC>
********************************************************************* PSL **/

#ADDR_define _SIZE_OF_STACK_ENTRY	4	/* PIM/c, PIM/i */
					/*	32  bytes PIM/p */

#ADDR_define	_HIGHER_ENTRY_OFST_STE	3
#ADDR_define	_GR_PTR_OFST_STE	2
#ADDR_define	_PHY_PRIO_OFST_STE	1
#ADDR_define	_LOWER_ENTRY_OFST_STE	0

/* typedef word[_SIZE_OF_STACK_ENTRY]	stackentryrecord;		*/

/******************************************************************** PSL **
2.  $B%W%i%$%*%j%F%#IU$-%4!<%k%9%?%C%/$N9=B$(B

       written by goto@icot22      Tue Nov 22 09:03:43 1988

<Explanation>

 	$B%4!<%k%9%?%C%/$O8GDjD9$N%"%l%$$H$7$F(B, $B3F(BPE$BKh$KMQ0U$9$k!#(B
	$B%"%l%$$NBg$-$5(B(_SIZE_OF_PHY_GOAL_STACK)$B$O(B, $BJ*M}%W%i%$%*%j%F%#$N(B
	$B$H$kCM(B(_MAX_PHY_PRIO - _MIN_PHY_PRIO + 1) $B$N(B $B%(%s%H%j%5%$%:(B
	(_SIZE_OF_STACK_ENTRY)$BG\$G$"$k!#(B

			(Higher Address)
			|    :     | <----- D_GoalStackLimit
			+----------+
			|EOL !     |
		        |----------|    +----------+    +----------+
		 	|HOOK!  o--+--->|HOOK!  o--+--->|EOL !	   |
		        |----------|    |	   |	|	   |
D_Max_Priority  ==	|INT !prio |    |	   |	|	   |
		        |----------|    +----------+	+----------+
			|REF !   o |
			+--------|-+
			|        v |
			: 	   :
D_CurrentStackEntryPtr	|      ^   |	D_CurrentGoalStackPtr
	    |		+------|---+      |
	    |		|REF ! o   |	  |
	    |	        |----------|      +->+----------+    +----------+
	    |	        |HOOK!  o--+-------->|HOOK!  o--+--->| EOL !	|
	    |	        |----------|         |	        |    |	        |
	    |	        |INT !prio |         |	        |    |	        |
	    |	        |----------|         +----------+    +----------+
	    +---------->|REF !   o |
			+--------|-+
			|        v |
			|      : : |
			|      ^   |
			+------|---+
			|REF ! o   |
		        |----------|    +----------+
		        |HOOK!  o--+--->|EOL !     | Idle Goal (Special)
		        |----------|    |	   |
		        |INT !prio |    |	   |
		        |----------|    +----------+
		        |EOL !     | <----- D_GoalStackBase
		        +----------+
			(Lower Address)
********************************************************************* PSL **/

/******************************************************************** PSL **
3. $B@)8f%l%8%9%?$H%3%s%9%?%s%H(B

       written by goto@icot22      Tue Nov 22 09:03:43 1988

<Explanation>
  D_CurrentStackEntryPtr : 
	$B8=:_<B9TCf$N%4!<%k%l%3!<%I$NM%@hEY$KAjEv$9$k%4!<%k%9%?%C%/%(%s%H%j$r(B
	$B;X$9%]%$%s%?!#(B($BDL>o$O%(%s%H%j$N(B pointer_to_next_lower_entry $B$r;X$9!#(B)

  D_CurrentGoalStackPtr :
      -	$B8=:_<B9TCf$N%4!<%k$N%W%i%$%*%j%F%#$KBP1~$9$k%4!<%k%9%?%C%/%(%s%H%j$+$i(B
	$B?-$S$F$$$k(B($B$+$i$N>l9g$b$"$k(B)$B%l%G%#%4!<%k$N%j%s%/$K$*$$$F(B, $B8=:_<B9TCf$N(B
	$B%4!<%k$r<h$j=P$7$?@h$r;X$7$F$$$k%]%$%s%?(B.
      -	$B%4!<%k$r%G%-%e!<$9$k;~$O(B, $BK\%]%$%s%?$N;X$9@h$+$i%4!<%k$r<h$j=P$9(B.
      -	$BK\%]%$%s%?$NFbMF$,(B "EOL" $B$N>l9g$O(B, $B%9%?%C%/%(%s%H%j$r%W%i%$%*%j%F%#$N(B
	$BDc$$J}8~$XC)$j(B, $B%4!<%k$r<h$j=P$9(B. $B$3$N;~(B, D_CurrentStackEntryPtr,
	D_CurrentGoalStackPtr, D_Max_Priority $B$r(B $B99?7$9$k(B.
      -	$B<B9TCf$N%4!<%k$,F10l%W%i%$%*%j%F%#$N%4!<%k$r%U%)!<%/$7$?>l9g(B, $B$=$l$r(B
	$B%(%s%-%e%&$9$k>l=j$H$J$k(B.  $B$3$N$?$a(B, $B2<?^$K<($9$h$&$K(B, $B%9%?%C%/%(%s%H%j(B
	$B$+$i%4!<%k$X$N%]%$%s%?$HF10l$K$J$i$J$$>l9g$,$"$k(B. 
      -	$B$=$3$G(B, $B9b$$%W%i%$%*%j%F%#$N%4!<%k$r%U%)!<%/$7(B,  $B$=$N<B9T$K@Z$jJQ$o$k(B
	$B>l9g$O(B, $B$=$l$^$G$N(B D_CurrentGoalStackPtr $B$NCM$r(B D_CurrentStackEntryPtr
	$B$,;X$9%(%s%H%j$K=q$-La$9I,MW$,$"$k(B. 
	(c.f. f_EnqueueGoalWithPriority, f_HigherPriorityGoal,
	 s_CountGoalInStackUntilEnough)

				+-------+
   D_CurrentGoalStackPtr------->|  GR	+--+
				+-------+  |
   D_CurrentStackEntryPtr		   |
	|				   |
	|	|	|		   |
	+------>|-------|		   |	+-------+	+-------+
     StackEntry	|   *----------------------+--->|  GR	+------>|  GR	|
		|-------|			+-------+	+-------+
		|	|


  D_GoalStackLimit : (permanent register, may be in memory)
	$B%4!<%k%9%?%C%/$N%"%l%$$N>eC<$r;X$9%]%$%s%?%l%8%9%?(B
       	($BDL>o$O:G>e0L%(%s%H%j$N0l$D@h$r;X$9!#(B)	

  D_GoalStackBase : (permanent register, may be in memory)
     	$B%4!<%k%9%?%C%/$N%"%l%$$N2<C<$r;X$9%]%$%s%?%l%8%9%?(B

  D_Current_Priority : see str_klb_reg.psl.c
  D_Max_Priority : see str_klb_reg.psl.c

_MAX_PHY_PRIO :
_REP_GOAL_PRIO :
_INPUT_GOAL_PRIO :
_MIN_PHY_PRIO :
_IDLE_GOAL_PRIO :
_SIZE_OF_PHY_GOAL_STACK :

<ETC> 
  $BO@M}%W%i%$%*%j%F%#$O!"Id9g$J$7@0?t$N1i;;$,9b$/$D$/$N$G!"(B
  31 $B%S%C%H$H$9$k(B
********************************************************************* PSL **/

/* #CONST_define _SIZE_OF_PHY_GOAL_STACK 0x4000	defined in bsc_mem_map */
#CONST_define _MAX_PHY_PRIO		0xfff   /*4095*/
#CONST_define _MIN_PHY_PRIO		0 
#CONST_define _IDLE_GOAL_PRIO		0 

#CONST_define _MAX_LOGICAL_PRIO		0x7fffffff
#CONST_define _MIN_LOGICAL_PRIO		0x00100000	/* $B%"%$%I%k$r$N$>$/(B */
#CONST_define _REPORT_GOAL_PRIO		0x7fe00000
#CONST_define _INPUT_GOAL_PRIO		0x7fffffff
#CONST_define _HIGHEST_LOGICAL_PRIO_MASK_SAME_PHYSICAL_PRIO	0x0007ffff

	/* _SIZE_OF_PHY_GOAL_STACK =
	 *	(_MAX_PHY_PRIO - _MIN_PHY_PRIO + 1) * _SIZE_OF_STACK_ENTRY
	 */

#DATA_define D_GoalStackBase		XXX	/* in memory */
#DATA_define D_GoalStackLimit		XXX	/* in memory */
#DATA_define D_CurrentStackEntryPtr	XXX
#DATA_define D_CurrentGoalStackPtr	XXX

#DATA_define D_WorkLink			XXX
#DATA_define D_WorkCalDst		XXX
#DATA_define D_WorkStackEntryPtr	XXX
#DATA_define D_WorkInitSetPriority	XXX	/* $B=i4|2=;~$N$_$GMQ$$$k(B */
#DATA_define D_WorkHigh			XXX
#DATA_define D_WorkLow			XXX
#DATA_define D_WorkEntryPos		XXX
#DATA_define D_WorkIdlePriority		XXX

/******************************************************************** PSL **
3.1 $B%4!<%k%9%?%C%/$NA`:n$K$*$1$kNN0h%A%'%C%/(B

       written by goto@icot22      Thu Jan 12 11:14:15 1989

<Arguments>
  ptr_to_entry : $B%4!<%k%9%?%C%/$X$N%]%$%s%?(B
  priority_reg : $B%W%i%$%*%j%F%#$r<($9%l%8%9%?(B
<Temporally Used Variables> none
<Level> structures
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  Debug $BMQ$G$"$j(B @DEBUG {...} $B$NCf$G$N$_MQ$$$k!#(B
<ETC>
********************************************************************* PSL **/

#PSL_define s_StackEntryCheck (ptr_to_entry)
{
  b_IfRangeOver (ptr_to_entry, D_GoalStackLimit){
     @DEBUG{ VPIM_ERROR ("s_StackEntryCheck", "StackEntry Overflow"); };
   }
  b_IfRangeUnder (ptr_to_entry, D_GoalStackBase) {
     @DEBUG{ VPIM_ERROR ("s_StackEntryCheck", "StackEntry Underflow"); };
   }
}

#PSL_define s_StackEntryLinkCheck(ptr_to_entry)
{
  $USE(D_WorkDebug);
  s_GetLowStackEntry(ptr_to_entry,D_WorkDebug);
  b_IfEOL(D_WorkDebug) {
    s_GetHighStackEntry(ptr_to_entry,D_WorkDebug);
    b_IfEOL(D_WorkDebug) {
      s_GetPriorityStackEntry(ptr_to_entry,D_WorkDebug);
      b_IfNotEqualImm(D_WorkDebug,_IDLE_GOAL_PRIO) {
	@DEBUG{
	  VPIM_ERROR("s_StackEntryLinkCheck","No Higher Link nor Lower Link!");
	};
      }
    }
  }
  $RELEASE(D_WorkDebug);
}

#PSL_define s_PriorityCheck (priority_reg)
{
  b_IfGreaterImm(priority_reg, _MAX_PHY_PRIO) {
    @DEBUG{OUT_OF_SPEC ("s_PriorityCheck", "Too High Prioriry");};
  }
  b_IfLessImm   (priority_reg, _MIN_PHY_PRIO) {
    @DEBUG{OUT_OF_SPEC ("s_PriorityCheck", "Too Low Prioriry");};
  }
}

#PSL_define s_ArityCheck(ptr_to_gr)
{
  $USE(D_WorkArity);  $USE(D_WorkCodePtr);  $USE(D_WorkDebug);
  s_GetArityGoalRecord(ptr_to_gr,D_WorkArity);
  s_GetCodeGoalRecord(ptr_to_gr,D_WorkCodePtr);
  s_GetPredArityFromCode(D_WorkCodePtr,D_WorkDebug);
  b_IfNotEqual(D_WorkArity,D_WorkDebug) {
    @DEBUG{VPIM_ERROR("s_ArityCheck","Arity Mismatch (in GR and in Code)!!");};
  }
  $RELEASE(D_WorkDebug); $RELEASE(D_WorkCodePtr); $RELEASE(D_WorkArity);
}

/******************************************************************** PSL **
$BJ*M}%W%i%$%*%j%F%#$HO@M}%W%i%$%*%j%F%#$N49;;(B
       written by imai@icot22      on Sat Dec 22 19:48:39 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CONST_define	_LOGICAL_PRIO_BITS	31
#CONST_define	_PHYSICAL_PRIO_BITS	12
#CONST_define	_SHIFT_VALUE_LOGICAL_TO_PHYSICAL_PRIO	19

#PSL_define s_ConvertLogicalToPhysicalPriority(logical_prio,physical_prio)
{
  b_ShiftRightImmediateWithTag
    (logical_prio,_SHIFT_VALUE_LOGICAL_TO_PHYSICAL_PRIO, physical_prio);
  @DEBUG{ s_PriorityCheck(physical_prio); };
}

/******************************************************************** PSL **
4. $B%4!<%k%9%?%C%/%(%s%H%j$N3F%9%m%C%H$X$N=q$-9~$_(B

       written by goto@icot22      Tue Nov 22 14:48:49 1988

<Arguments>
  ptr_to_entry : $B%9%?%C%/%(%s%H%j$r;X$9%]%$%s%?(B
  src_reg : $B0lHL$N%l%8%9%?(B
  imm_num : $BB(CM$GJ*M}%W%i%$%*%j%F%#$r@_Dj$9$k;~$N@0?tCM!#(B
<Temporally Used Variables>
<Level>	structures
<PreCondition>
<Function>
  $B%l%8%9%?$+$i%4!<%k%9%?%C%/%(%s%H%j$N3F%9%m%C%H$X$N=q$-9~$_(B
	(s_Put....StackEntry)
  $B%4!<%k%9%?%C%/%(%s%H%j$N3F%9%m%C%H$X$N(B EOL $B$N=q$-9~$_(B
  	(s_PutEOL...StackEntry)
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_PutHighStackEntry		(ptr_to_entry, src_reg)
{
  @DEBUG { b_WarningIfSameRegNum (ptr_to_entry, src_reg); };
  @DEBUG { s_StackEntryCheck (ptr_to_entry); };
  p_WriteWithOffset (src_reg, ptr_to_entry, _HIGHER_ENTRY_OFST_STE);
}

#PSL_define s_PutEOLHighStackEntry	(ptr_to_entry)
{
  @DEBUG { s_StackEntryCheck (ptr_to_entry); };
  p_WriteWithOffset (D_EOL, ptr_to_entry, _HIGHER_ENTRY_OFST_STE);
}

#PSL_define s_PutLowStackEntry		(ptr_to_entry, src_reg)
{
  @DEBUG { b_WarningIfSameRegNum (ptr_to_entry, src_reg); };
  @DEBUG { s_StackEntryCheck (ptr_to_entry); };
  p_WriteWithOffset (src_reg, ptr_to_entry, _LOWER_ENTRY_OFST_STE);
}

#PSL_define s_PutEOLLowStackEntry	(ptr_to_entry)
{
  @DEBUG { s_StackEntryCheck (ptr_to_entry); };
  p_WriteWithOffset (D_EOL, ptr_to_entry, _LOWER_ENTRY_OFST_STE);
}

#PSL_define s_PutGoalPtrStackEntry	(ptr_to_entry, src_reg)
{
  @DEBUG { b_ErrorIfSameRegNum (ptr_to_entry, src_reg); };
  @DEBUG { s_StackEntryCheck (ptr_to_entry); };
  p_WriteWithOffset (src_reg, ptr_to_entry, _GR_PTR_OFST_STE);
}

#PSL_define s_PutEOLGoalPtrStackEntry	(ptr_to_entry)
{
  @DEBUG { s_StackEntryCheck (ptr_to_entry); };
  p_WriteWithOffset (D_EOL, ptr_to_entry, _GR_PTR_OFST_STE);
}

#PSL_define s_PutPriorityStackEntry	(ptr_to_entry, src_reg)
{
  @DEBUG { b_ErrorIfSameRegNum (ptr_to_entry, src_reg); };
  @DEBUG { s_StackEntryCheck (ptr_to_entry); };
  p_WriteWithOffset (src_reg, ptr_to_entry, _PHY_PRIO_OFST_STE);
}

/******************************************************************** PSL **
5. $B%4!<%k%9%?%C%/%(%s%H%j$N3F%9%m%C%H$NFI$_$@$7(B

       written by goto@icot22      Thu Jan 12 11:21:38 1989

<Arguments>
  ptr_to_entry : $B%9%?%C%/%(%s%H%j$r;X$9%]%$%s%?(B
  dst_reg : $B0lHL$N%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%4!<%k%9%?%C%/%(%s%H%j$N3F%9%m%C%H$N%l%8%9%?$X$NFI$_$@$7(B
	(s_Get....StackEntry)
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_GetHighStackEntry		(ptr_to_entry, dst_reg)
{
  @DEBUG { s_StackEntryCheck (ptr_to_entry); };
  p_ReadWithOffset (ptr_to_entry, _HIGHER_ENTRY_OFST_STE, dst_reg);
}

#PSL_define s_GetLowStackEntry		(ptr_to_entry, dst_reg)
{
  @DEBUG { s_StackEntryCheck (ptr_to_entry); };
  p_ReadWithOffset (ptr_to_entry, _LOWER_ENTRY_OFST_STE, dst_reg);
}

#PSL_define s_GetGoalPtrStackEntry	(ptr_to_entry, dst_reg)
{
  @DEBUG { b_WarningIfSameRegNum (ptr_to_entry, dst_reg); };
  @DEBUG { s_StackEntryCheck (ptr_to_entry); };
  p_ReadWithOffset (ptr_to_entry, _GR_PTR_OFST_STE, dst_reg);
}

#PSL_define s_GetPriorityStackEntry	(ptr_to_entry, dst_reg)
{
  @DEBUG { b_WarningIfSameRegNum (ptr_to_entry, dst_reg); };
  @DEBUG { s_StackEntryCheck (ptr_to_entry); };
  p_ReadWithOffset ( ptr_to_entry, _PHY_PRIO_OFST_STE, dst_reg);
}

/******************************************************************** PSL **
6. $B%W%i%$%*%j%F%#$K=>$C$F%4!<%k%9%?%C%/%(%s%H%j$rF@$kA`:n(B

       written by goto@icot22      Tue Nov 22 15:15:35 1988

<Arguments>
  priority : $BJ*M}%W%i%$%*%j%F%#CM$r;}$D%l%8%9%?(B
  ptr_to_entry : $B%W%i%$%*%j%F%#%9%?%C%/$N%(%s%H%j(B
<Temporally Used Variables>
  D_WorkCalDst : used for address calculation.
<Level>	structures
<PreCondition>
<Function>
  s_GetEntryPosition (priority, ptr_to_entry) :
	$B%W%i%$%*%j%F%#(B (priority) $B$KAjEv$9$k%4!<%k%9%?%C%/%(%s%H%j$N>l=j(B
	(ptr_to_entry) $B$rF@$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_GetEntryPosition		(priority, dst_ptr_to_entry)
{
  @DEBUG { 
    s_PriorityCheck (priority);
    b_WarningIfSameRegNum (dst_ptr_to_entry, priority); 
  };
  $USE(D_WorkCalDst);
  b_SubtractImmediateWithDNTC (priority, _MIN_PHY_PRIO, D_WorkCalDst);
  b_MultiplyImmediateWithDNTC (D_WorkCalDst,_SIZE_OF_STACK_ENTRY,D_WorkCalDst);
  b_AddWithDNTC (D_WorkCalDst, D_GoalStackBase, dst_ptr_to_entry);
  $RELEASE(D_WorkCalDst); 
  b_SetImmTypeMRBoff (DREF, dst_ptr_to_entry);

  @DEBUG { s_StackEntryCheck (dst_ptr_to_entry);};
}

/******************************************************************** PSL **
7. $B<!$N%A%'%$%s$K7R$,$C$F$$$k%9%?%C%/%(%s%H%j$rF@$kA`:n(B

       written by goto@icot22      Wed Jan 11 20:13:15 1989

<Arguments>
  ptr_to_entry : $B%(%s%H%j$X$N%]%$%s%?(B
  dst_higher_entry : $B0l$D>e$N%(%s%H%j$r;X$9%]%$%s%?(B
  dst_lower_entry : $B0l$D2<$N%(%s%H%j$r;X$9%]%$%s%?(B
<Temporally Used Variables> 
  D_WorkStackEntryPtr :
  D_WorkLink : 
<Level> structures
<PreCondition>
<Function>
  $B;XDj$5$l$?(B entry $B$+$i(B $B>e(B($B2<(B)$BJ}8~$K%9%?%C%/%(%s%H%j$rC)$j(B, $B%(%s%H%j4V$N(B
  $B%A%'%$%s$K7R$,$C$F$$$k:G=i$N%(%s%H%j$X$N%]%$%s%?$rJV$9!#(B
<Examples>
<Test>
<Explanation>
  $B8=%4!<%k$H0[$J$k%W%i%$%*%j%F%#$N%4!<%k$r%(%s%-%e%&$9$k;~$KMQ$$$k!#(B
  see f_EnqueueGoalWithPriority (..) in f_goal_queue.psl.c

<ETC>
********************************************************************* PSL **/

#PSL_define s_GetHigherValidStackEntry (ptr_to_entry, dst_higher_entry)
{
  $USE(D_WorkStackEntryPtr); $USE(D_WorkLink);
  p_MoveWord (ptr_to_entry, D_WorkStackEntryPtr);
  LOOP () {
    b_AddImmediateWithTag
      (D_WorkStackEntryPtr, _SIZE_OF_STACK_ENTRY, dst_higher_entry);
    s_GetLowStackEntry (dst_higher_entry, D_WorkLink);
    b_IfEOL (D_WorkLink) {
      p_MoveWord (dst_higher_entry, D_WorkStackEntryPtr);
      @DEBUG{
	s_GetHighStackEntry(dst_higher_entry, D_WorkLink);
	b_IfNotEOL(D_WorkLink) {
	  VPIM_ERROR("s_GetHigherValidStackEntry","Illegal entry found");
	}
      };
    } else { break; /* from LOOP */}
  }
  $RELEASE(D_WorkStackEntryPtr); $RELEASE(D_WorkLink);
}

#PSL_define s_GetLowerValidStackEntry (ptr_to_entry, dst_lower_entry)
{
  $USE(D_WorkStackEntryPtr);    $USE(D_WorkLink);
  p_MoveWord (ptr_to_entry, D_WorkStackEntryPtr);
  LOOP () {
    b_SubtractImmediateWithTag
      (D_WorkStackEntryPtr, _SIZE_OF_STACK_ENTRY, dst_lower_entry);

    s_GetHighStackEntry (dst_lower_entry, D_WorkLink);
    b_IfEOL (D_WorkLink) {
      p_MoveWord (dst_lower_entry, D_WorkStackEntryPtr);
      @DEBUG{
	s_GetLowStackEntry(dst_lower_entry, D_WorkLink);
	b_IfNotEOL(D_WorkLink) {
	  VPIM_ERROR("s_GetLowerValidStackEntry","Illegal entry found");
	}
      };
    } else { 
      @DEBUG{
	s_GetLowStackEntry (dst_lower_entry, D_WorkLink);
	b_IfEOL(D_WorkLink) {
	  s_GetPriorityStackEntry (dst_lower_entry, D_WorkLink);
	  b_IfNotEqualImm(D_WorkLink, _IDLE_GOAL_PRIO) {
	    VPIM_ERROR("s_GetLowerValidEntry","Illegal entry");
	  }
	}
      };
      break; /* from LOOP */
    }
  } /* end of LOOP */
  $RELEASE(D_WorkStackEntryPtr);       $RELEASE(D_WorkLink);
}

/******************************************************************** PSL **
8. $B%W%i%$%*%j%F%#IU$-%4!<%k%9%?%C%/$N=i4|2=(B

       written by goto@icot22      Fri Jan 13 18:49:22 1989

<Arguments> none
<Temporally Used Variables>
  D_WorkStackEntryPtr : 
  D_WorkInitSetPriority :
<Level> structures
<PreCondition>
<Function>
  D_GoalStackBase
  D_GoalStackLimit $B$r@_Dj$7!"(B

  $B3F%9%?%C%/%(%s%H%j$r2<5-$N$h$&$K=i4|2=$9$k!#(B
	+----------+
 xxxx0	|EOL !     |
        |----------|
 xxxx1	|EOL !     |
        |----------|
 xxxx2	|INT !prio |
        |----------|
 xxxx3	|EOL !     |
	+----------+

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_InitializeGoalStackEntry ()
{
  b_SetImmValueDNTC(_LOCAL_MEM_GOAL_STACK_ENTRY_AREA_BASE, D_GoalStackBase);
  b_SetImmValueDNTC(_LOCAL_MEM_GOAL_STACK_ENTRY_AREA_LIMIT,D_GoalStackLimit);
  b_ConvertLocalMemAddrToGlobalMemAddr(D_GoalStackBase,D_GoalStackBase);
  b_ConvertLocalMemAddrToGlobalMemAddr(D_GoalStackLimit,D_GoalStackLimit);

  p_MoveWord (D_EOL, D_CurrentGoalStackPtr);
  /* $B%+%l%s%H%W%i%$%*%j%F%#$O!"%"%$%I%k%4!<%k$HF1$8:GDc$NCM(B*/
  p_MoveWord (D_GoalStackBase, D_CurrentStackEntryPtr);

  $USE(D_WorkStackEntryPtr); $USE(D_WorkInitSetPriority);

  p_MoveWord (D_GoalStackBase, D_WorkStackEntryPtr);
  b_MoveWithImmTypeMRBoff (D_NULL, INT, D_WorkInitSetPriority);
  LOOP () {
    s_PutEOLHighStackEntry (D_WorkStackEntryPtr);
    s_PutEOLGoalPtrStackEntry (D_WorkStackEntryPtr);
    s_PutPriorityStackEntry (D_WorkStackEntryPtr, D_WorkInitSetPriority);
    s_PutEOLLowStackEntry (D_WorkStackEntryPtr);
    p_AddImmediate 
      (D_WorkStackEntryPtr, _SIZE_OF_STACK_ENTRY, D_WorkStackEntryPtr);
    b_IfRangeOver (D_WorkStackEntryPtr, D_GoalStackLimit) break;
    b_IncrementReg (D_WorkInitSetPriority);
  }
  $RELEASE(D_WorkStackEntryPtr); $RELEASE(D_WorkInitSetPriority);
}

/******************************************************************** PSL **
9.  $B%4!<%k%9%?%C%/$N>uBV$rD4$Y$kA`:n(B ($B%$%Y%s%H%O%s%I%iMQ(B)

       written by goto@icot22      on Mon Feb  6 13:44:03 1989
<PreCondition>
  $BK\%^%/%m$O(B, $B%9%j%C%H%A%'%C%/$N%$%Y%s%H%O%s%I%i$+$i8F$S=P$5$l(B, $B%4!<%k%9%?%C%/(B
  $B$N>uBV$rD4$Y$k$b$N$G$"$k!#$3$N$?$a(B, $B0J2<$N2>Dj$r@_$1$k(B.
  $B!&%$%Y%s%H%O%s%I%i$,F0:n$9$k;~$O(B, $B$=$l$^$G<B9T$7$F$$$?%4!<%k$O%4!<%k%l%3!<%I(B
    $B$K%;!<%V$5$l(B, $B%4!<%k%9%?%C%/$K%W%C%7%e$5$l$F$$$k(B.
  $B!&(BD_CurrentGoalStackPtr : $B>e5-$G%W%C%7%e$7$?%4!<%k$r;X$9!#(B
  $B!&(BD_CurrentStackEntryPtr : $B>e5-$G%W%C%7%e$7$?%4!<%k$,%j%s%/$5$l$F$$$k%9%?%C(B
 	$B%/%(%s%H%j$r;X$9!#(B
  $B!&(BD_Max_Priority : $B$=$N;~E@$G%W%m%;%C%5$N%4!<%k%9%?%C%/$K$D$J$,$C$F$$$k%4!<%k(B
	$B$NCf$G(B, $B:G>e0L$N%W%i%$%*%j%F%#CM$r<($9(B.
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

/******************************************************************** PSL **
9.1  $B%W%m%;%C%5$,%"%$%I%k$+$I$&$+D4$Y$kA`:n(B
       written by goto@icot22      on Thu Mar 16 09:24:11 1989
<Arguments>
  none
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B!&(Bs_IfIdle() :
	$B%W%m%;%C%5$O%"%$%I%k%4!<%k$r<B9T$7$F$$$?(B. ($B%4!<%k%9%?%C%/$K$O(B
	$B%"%$%I%k%4!<%k$N$_$,$D$J$,$C$F$$$k(B).
  $B!&(Bs_IfNotIdle() : s_IfIdle $B$N5U(B.
<Examples>
<Test>
<Explanation>
  $B!&(BD_GoalCntInStack $B$O(B 
	1 : D_ArgReg0 $B$,(B $B6u$G(B, $B%9%?%C%/Fb$K%"%$%I%k%4!<%k$,$"$k;~(B
	0 : D_ArgReg0 $B$K%"%$%I%k%4!<%k$,$"$k;~(B
    $B$N$$$:$l$+$G$"$k!#(B
<ETC>
********************************************************************* PSL **/

	/*--- $BL$;HMQ$K$D$-GQ;_(B 1991.04.26 (by imai)------*/

/******************************************************************** PSL **
9.2  $B%W%m%;%C%5$N%4!<%k%9%?%C%/$KJ#?t$N%4!<%k$,$"$k$+$I$&$+$rD4$Y$kA`:n(B
       written by goto@icot22      on Thu Mar 16 09:25:14 1989
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B!&(Bs_IfEnoughGoal() : $B%W%m%;%C%5$N%4!<%k%9%?%C%/$K$OBt;3$N%4!<%k$,$"$k(B. 
	($B%4!<%k%9%?%C%/$K$O%"%$%I%k%4!<%k$NB>$K(B_ENOUGH_GOALS (= 2) $B8D0J>e$N(B
	$B%4!<%k$,$"$k(B).
  $B!&(Bs_IfNotEnoughGoal() : $B%W%m%;%C%5$N%4!<%k%9%?%C%/$K$OBt;3$N%4!<%k$,$J$$(B.
	($B%4!<%k%9%?%C%/$K$O%"%$%I%k%4!<%k$NB>$K(B_ENOUGH_GOALS$B8D$N%4!<%k$,$J$$(B).
<Examples>
<Test>
<Explanation>
  $B!&(BD_GoalCntInStack $B$O(B, 
	$B=i4|2=;~(B : 0
<ETC>
********************************************************************* PSL **/

#CONST_define _ENOUGH_GOALS	3

#CTRL_define s_IfNotEnoughGoal ()
{
  b_IfLessImm (D_GoalCntInStack, _ENOUGH_GOALS)
}

/******************************************************************** PSL **
10. $B%W%i%*%j%F%#%-%e!<$NA`:n(B
       written by nakagawa@icot22      on Fri Mar  3 17:53:35 1989

<Arguments>
  new_entry :
  max_entry :
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
 s_InsertAsHighestStackEntry(new_entry,max_entry)
 s_InsertAsHigherStackEntry(new_entry)
 s_InsertAsLowerStackEntry(new_entry)
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_InsertAsHighestStackEntry(new_entry,max_physical_prio)
{
  $USE(D_WorkEntryLo);
  s_GetEntryPosition(max_physical_prio, D_WorkEntryLo);
  @DEBUG{ b_IfEqual(new_entry,D_WorkEntryLo) {
    VPIM_ERROR("s_InsertAsHighestStackEntry","Not Highest!!");
  }};
  s_PutLowStackEntry (new_entry, D_WorkEntryLo);
  /* $B?7%(%s%H%j$+$i$3$l$^$G:G9b%W%i%$%*%j%F%#$N%(%s%H%j$G$"$C$?$b$N$r;X$9(B */
  s_PutHighStackEntry (D_WorkEntryLo, new_entry);
  /* $B$3$l$^$G:G9b%W%i%$%*%j%F%#$N%(%s%H%j$G$"$C$?$b$N$+$i?7%(%s%H%j$r;X$9(B */
  $RELEASE(D_WorkEntryLo);
}

#PSL_define s_InsertAsHigherStackEntry(new_entry)
{
  $USE(D_WorkHigh); $USE(D_WorkLow);

  s_GetLowerValidStackEntry (new_entry, D_WorkLow);
  s_GetHighStackEntry (D_WorkLow, D_WorkHigh);
	/* 
	 * $B%W%i%$%*%j%F%#$NDc$$J}8~$X%4!<%k%j%s%/$,6u$G$J$$%(%s%H%j$rC5$7(B,
	 * $B%(%s%-%e!<$7$h$&$H$7$F$$$k?7%(%s%H%j$N2<$N%(%s%H%j$rF@$k(B.
	 */
  s_PutLowStackEntry (new_entry, D_WorkLow);
		/* $B?7%(%s%H%j$N2<$N%(%s%H%j$r%;%C%H(B */
  s_PutHighStackEntry (D_WorkLow, new_entry);
		/* $B2<$N%(%s%H%j$+$i?7%(%s%H%j$r;X$9(B */
  s_PutHighStackEntry (new_entry, D_WorkHigh);
		/* $B?7%(%s%H%j$N>e$N%(%s%H%j$r%;%C%H(B */
  s_PutLowStackEntry (D_WorkHigh, new_entry);
		/* $B>e$N%(%s%H%j$+$i?7%(%s%H%j$r;X$9(B */
  $RELEASE(D_WorkHigh); $RELEASE(D_WorkLow);
}

#PSL_define s_InsertAsLowerStackEntry(new_entry)
{
  $USE(D_WorkHigh); $USE(D_WorkLow);
  s_GetHigherValidStackEntry (new_entry, D_WorkHigh);
  s_GetLowStackEntry (D_WorkHigh, D_WorkLow);
	/* 
	 * $B%W%i%$%*%j%F%#$NDc$$J}8~$X%4!<%k%j%s%/$,6u$G$J$$%(%s%H%j$rC5$7(B,
	 * $B%(%s%-%e!<$7$h$&$H$7$F$$$k?7%(%s%H%j$N$&$(2<$N%(%s%H%j$rF@$k(B.
	 */
  s_PutLowStackEntry (new_entry, D_WorkLow);
		/* $B?7%(%s%H%j$N2<$N%(%s%H%j$r%;%C%H(B */
  s_PutHighStackEntry (D_WorkLow, new_entry);
		/* $B2<$N%(%s%H%j$+$i?7%(%s%H%j$r;X$9(B */
  s_PutHighStackEntry (new_entry, D_WorkHigh);
		/* $B?7%(%s%H%j$N>e$N%(%s%H%j$r%;%C%H(B */
  s_PutLowStackEntry (D_WorkHigh, new_entry);
		/* $B>e$N%(%s%H%j$+$i?7%(%s%H%j$r;X$9(B */

  $RELEASE(D_WorkHigh); $RELEASE(D_WorkLow);
}

#PSL_define s_DeleteAsHighestStackEntry(entry)
{
  @DEBUG{/*-------------- entry $B$N%4!<%k%j%s%/$O6u$N$O$:(B!!------------*/
    $USE(D_WorkGoals);
    s_GetGoalPtrStackEntry(entry, D_WorkGoals);
    b_IfNotEOL(D_WorkGoals) {
      VPIM_ERROR("s_DeleteAsHighestStackEntry","Illegal call");
    }
    $RELEASE(D_WorkGoals);
  };
  LOOP() {
    $USE(D_WorkEntryPos);
    p_MoveWord(entry, D_WorkEntryPos);
    s_GetLowStackEntry (entry, entry);
    s_PutEOLLowStackEntry  (D_WorkEntryPos);
    @DEBUG{
      $USE(D_WorkHigh);
      s_GetHighStackEntry(D_WorkEntryPos, D_WorkHigh);
      b_IfNotEOL(D_WorkHigh) {
	VPIM_ERROR("s_DeleteAsHighestStackEntry","Illegal entry");
      }
      $RELEASE(D_WorkHigh);
    };
    $RELEASE(D_WorkEntryPos);

    s_PutEOLHighStackEntry (entry);
    /* $B?7$?$J%(%s%H%j$N(B pointer_to_next_high $B$r(BEOL$B$K$9$k(B. */

    $USE(D_WorkGoals);
    s_GetGoalPtrStackEntry(entry, D_WorkGoals);
    b_IfNotEOL(D_WorkGoals) {
      $RELEASE(D_WorkGoals);
      break; /* from LOOP */
    }
    $RELEASE(D_WorkGoals);
  } /* end of LOOP */
}

/******************************************************************** PSL **
11. $B%4!<%k%9%?%C%/$NESCf$N%(%s%H%j$N:o=|(B

       written by nakagawa@icot22      on Fri Apr  7 23:10:34 1989
  $B;HMQ$5$l$k$3$H$,$J$$$N$G>C5n$7$?(B
********************************************************************* PSL **/

#DATA_define D_WorkEntryHi XXX
#DATA_define D_WorkEntryLo XXX


/******************************************************************** PSL **
12. $B%4!<%k%j%s%/$,6u$G$J$$%(%s%H%j$rA\$9(B
       written by goto@icot22      on Fri Sep  8 11:19:43 1989
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_GetLowerNonEmptyStackEntry (init_entry, dst_lower_entry)
{
  $USE(D_WorkLink);
  s_GetLowStackEntry(init_entry, dst_lower_entry);
  LOOP () {
    s_GetGoalPtrStackEntry (dst_lower_entry, D_WorkLink);
    s_IfHOOK(D_WorkLink) {
      break; /* from LOOP */
    } else {
      @DEBUG{
	b_IfNotEOL(D_WorkLink){
	  VPIM_ERROR("s_GetLowerNonEmptyStackEntry","Illegal entry");
	}
      };
      s_GetLowStackEntry(dst_lower_entry, dst_lower_entry);
    }
  } /* end of LOOP */
  $RELEASE(D_WorkLink);
}

/******************************************************************** PSL **
 $B%4!<%k%9%?%C%/%]%$%s%?$N%-%c%C%7%e!?%G%-%c%C%7%e(B
       written by imai@icot22      on Tue Apr 30 14:15:13 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_CacheCurrentGoalStack()
{
  s_GetGoalPtrStackEntry (D_CurrentStackEntryPtr, D_CurrentGoalStackPtr);
}

#PSL_define s_DecacheCurrentGoalStack()
{
  s_PutGoalPtrStackEntry (D_CurrentStackEntryPtr, D_CurrentGoalStackPtr);
}

/******************************************************************** PSL **
$B%4!<%k%9%?%C%/$N=i4|2=(B
       written by imai@icot22      on Tue Apr 30 14:21:12 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_InitializeGoalStack()
{
  $USE(D_WorkPhysicalPrio);
  b_SetImmTypeValueMRBon(INT,_IDLE_GOAL_PRIO,D_WorkPhysicalPrio);
  s_ConvertLogicalToPhysicalPriority(D_WorkPhysicalPrio,D_WorkPhysicalPrio);
  s_GetEntryPosition(D_WorkPhysicalPrio, D_CurrentStackEntryPtr);
  $RELEASE(D_WorkPhysicalPrio);

  b_SetZero(D_GoalCntInStack);
  b_SetEOL(D_CurrentGoalStackPtr);
}
