
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/structures/str_passive_unify.psl.c
   ----- CREATED   : by hirata@icot22, on Mon Jun 11 22:38:16 1990
   ----- LAST SAVED: by imai@icot22, on Tue Oct 15 19:19:33 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : structures
   ----- ABSTRACT  : 
A. $B9`L\(B
  1. $B%f%K%U%!%$%9%?%C%/$N9=B$(B
  2. $B%f%K%U%!%$%9%?%C%/$N=i4|3d$jEv$F$H%j%;%C%H(B
  3. unify stack operations 
  4. Passive unify operations
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
1. $B%f%K%U%!%$%9%?%C%/$N9=B$(B

       written by nishida@icot22      Wed Dec  7 14:32:57 1988

<Explanation>
  UNIFY_STACK         $B<uF0It$N%8%'%M%i%k%f%K%U%!%$$8$K!"(B
                      $B9=B$BN$X$N%]%$%s%?$r3JG<$9$k%9%?%C%/(B

D_UnifyStackLimit :  $B%f%K%U%!%$%9%?%C%/$N>e8B$r<($9%]%$%s%?%l%8%9%?(B
D_UnifyStackBase : $B%f%K%U%!%$%9%?%C%/$NDl$r<($9%]%$%s%?%l%8%9%?(B
D_UnifyStackPtr :    $B%f%K%U%!%$%9%?%C%/$N%H%C%W$r<($9%]%$%s%?%l%8%9%?(B

<ETC>
                 registers
                 |-----------------|
                 | structure X     |  D_WorkRegPu1
                 |-----------------|
                 | structure Y     |  D_WorkRegPu2
                 |-----------------|
                 | unify stack ptr |  UStkP
                 |-----------------|
                 |current position |  D_WorkRegCrp
                 |-----------------|
                 |struct size  N   |  D_WorkRegSSize
                 |-----------------|
                 |struct X address |  D_WorkRegXadr
                 |-----------------|
                 |struct Y address |  D_WorkRegYadr
                 |-----------------|


                 UnifyStack(memory)
                 |-----------------| StackLimit
                 |                 |
                 |                 |
                 |-----------------|
                 |current position |  <----  UStkP
                 |-----------------|
                 |struct size  N   |
                 |-----------------|
                 |struct X address |
                 |-----------------|
                 |struct Y address |
                 |-----------------|
                 |                 |
                 |                 |
                 |                 |
                 |-----------------| StackBottom

- Stack$B$K@Q$`$Y$-$O<B$O(B3 words$B$G==J,!#(B
  X,Y$B$N(Bstructures$B$N@hF,$r;X$9(BTag$BIU$-%]%$%s%?$H(Bcrp
- depth first order traversal
- stack$B$K(Bpush$B$7$?;~E@$G$O!":#$b$0$C$F$$$k(Bstructure$B$N(Broot$B$r;X$9$N$G!"(B
  pop$B$7$?8e$G(Bnext element$B$r<h$j$@$7$F(Bunification$B$rB3$1$J$/$F$O$J$i$J$$(B
********************************************************************* PSL **/

#ADDR_define C_U_STACK_FRAME_SIZE	4

/* $B%"%I%l%9Dj?t$N%M%$%_%s%0$,$*$+$7$*$^$C$;(B -- Reki 91.02.14 */

#DATA_define  D_UnifyStackLimit            XXX
#DATA_define  D_UnifyStackBase           XXX
#DATA_define  D_UnifyStackPtr              XXX

#ADDR_define _CRP_OFFSET   0
#ADDR_define _SSIZE_OFFSET 1
#ADDR_define _XADR_OFFSET  2
#ADDR_define _YADR_OFFSET  3

/******************************************************************** PSL **
2. $B%f%K%U%!%$%9%?%C%/$N=i4|2=(B

       written by nishida@icot22      on Wed Jan 25 21:38:45 1989
       revised by imai@icot22      on Thu Jun 21 20:38:01 1990

<Arguments>
<Temporally Used Variables>
<Level>		structures
<PreCondition>	None
<Function>
  s_InitializeUnifyStack() : $B%f%K%U%!%$%9%?%C%/$N=i4|2=(B
<Examples>
<Test>		Not yet.
<Explanation>
	$B%7%9%F%`$N=i4|2=$K$*$$$F(B, $B%f%K%U%!%$%9%?%C%/(B( unify stack)$BNN0h$r(B
	$B3d$jEv$F(B, $B%f%K%U%!%$%9%?%C%/4XO"$N%l%8%9%?$r=i4|2=$9$k!#(B
<ETC>
********************************************************************* PSL **/

#PSL_define s_InitializeUnifyStack()
{ 
  b_SetImmValueDNTC(_LOCAL_MEM_UNIFY_STACK_AREA_BASE, D_UnifyStackBase);
  b_SetImmValueDNTC(_LOCAL_MEM_UNIFY_STACK_AREA_LIMIT,D_UnifyStackLimit);
  b_ConvertLocalMemAddrToGlobalMemAddr(D_UnifyStackBase,D_UnifyStackBase);
  b_ConvertLocalMemAddrToGlobalMemAddr(D_UnifyStackLimit,D_UnifyStackLimit);
  p_MoveWord (D_UnifyStackBase, D_UnifyStackPtr);
}

/******************************************************************** PSL **
3. Unify Stack Operation 

       written by nishida@icot22      Wed Nov 16 14:49:32 1988

<Arguments>
  reg_crp : 	$B9=B$BNFb$G$N8=:_0LCV(B (D_WorkRegCrp)
  reg_str_size:	$B9=B$BN%5%$%:(B  (D_WorkRegSSize)
  reg_x_addr :	$B9=B$BN(BX$BB&$N%"%I%l%9(B (D_WorkRegXadr)
  reg_y_addr :	$B9=B$BN(BY$BB&$N%"%I%l%9(B (D_WorkRegYadr)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $B<uF0It$N%8%'%M%i%k%f%K%U%!%$$K$*$1$k%f%K%U%!%$%9%?%C%/$N4pK\A`:n(B
<ETC>
********************************************************************* PSL **/

#CTRL_define s_IfUnifyStackEmpty()
{
  @DEBUG {
    b_IfLess (D_UnifyStackPtr, D_UnifyStackBase) {
      VPIM_ERROR ("s_IfUStkEmpty", "Illegal D_UnifyStackPtr");
    }
  };
  b_IfEqual(D_UnifyStackPtr, D_UnifyStackBase) 
}

#CTRL_define s_IfUnifyStackFull()
{
  b_IfGreaterEq(D_UnifyStackPtr, D_UnifyStackLimit) 
}

#PSL_define s_PushUnifyStack(reg_crp, reg_str_size, reg_x_addr, reg_y_addr){
			/* writing the current position (nth element)	*/
  p_WriteWithOffset(reg_crp, D_UnifyStackPtr, _CRP_OFFSET);   
			/* structure size of the current object		*/
  p_WriteWithOffset(reg_str_size, D_UnifyStackPtr, _SSIZE_OFFSET); 
			/* the current point address of structure X	*/
  p_WriteWithOffset(reg_x_addr, D_UnifyStackPtr, _XADR_OFFSET);
			/* the current point address of structure Y	*/
  p_WriteWithOffset(reg_y_addr, D_UnifyStackPtr, _YADR_OFFSET);
			/* incrementing the stack pointer		*/
  b_AddImmediateWithTag
    (D_UnifyStackPtr, C_U_STACK_FRAME_SIZE, D_UnifyStackPtr);
  @DEBUG{
    s_IfUnifyStackFull() {
      VPIM_ERROR("s_PushUnifyStack","Unify Stack Overflow!!");
    }
  };
}

		/* the pop operations has the reverse order to push's	*/
#PSL_define s_PopUnifyStack(reg_crp, reg_str_size, reg_x_addr, reg_y_addr){
  @DEBUG{
    s_IfUnifyStackEmpty() {
      VPIM_ERROR("s_PopUnifyStack","Stack Empty!!");
    }
  };
			/* derementing the stack pointer		*/
  b_SubtractImmediateWithTag
    (D_UnifyStackPtr, C_U_STACK_FRAME_SIZE, D_UnifyStackPtr);
		/* reading the current point address of structure Y	*/
  p_ReadWithOffset(D_UnifyStackPtr, _YADR_OFFSET, reg_y_addr);
			/* the current point address of structure X	*/
  p_ReadWithOffset(D_UnifyStackPtr, _XADR_OFFSET, reg_x_addr);
			/* structure size of the current object		*/
  p_ReadWithOffset(D_UnifyStackPtr, _SSIZE_OFFSET, reg_str_size);
			/* the current position (nth element)		*/
  p_ReadWithOffset(D_UnifyStackPtr, _CRP_OFFSET, reg_crp);
}

/******************************************************************** PSL **
4. Passive unify operations

       written by goto@icot22      on Fri Mar 17 21:43:41 1989
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  s_IfMoreStrElem(reg_crp, reg_str_size) :
	$B9=B$BN$NMWAG0LCV$r<($9%l%8%9%?(B "reg_crp" $B$,(B, $B9=B$BN$NBg$-$5$r<($9(B
	$B%l%8%9%?(B "reg_str_size" $B$h$j>.$5$$$3$H$r%A%'%C%/$9$k(B.

  s_GetSizeofStrct(reg, dst_reg) :
	$B%]%$%s%?(B "reg" $B$+$i;X$5$l$k9=B$BN$NMWAG?t$r(B "dst_reg" $B$KJV$9(B.

<Examples>
<Test>
<Explanation>
  Passive unification $B$N4pK\A`:n(B
<ETC>
********************************************************************* PSL **/

#CTRL_define s_IfMoreStrElem(reg_crp, reg_str_size)
{ 
  b_IfLess(reg_crp, reg_str_size)
}

#PSL_define s_GetSizeofStrct(reg, dst_reg)
{
  TypeSwitch (reg) {
   case LongVectorGrp () :
     s_GetSizeLongVect(reg, dst_reg);
     break;
   case ListGrp () :
     b_SetImmValueDNTC( _SIZE_OF_LIST, dst_reg);
     break;
   case ShortVectorGrp () : /* VECT1$B!A(BVECT8 */
     s_GetSizeShortVect(reg, dst_reg);
     break;
   default:
			/* $B%9%H%j%s%0$O%f%K%U%!%$%9%?%C%/$K$O@Q$^$l$J$$(B	*/
     @DEBUG { VPIM_ERROR ("s_GetSizeofStrct", "Illegal Type"); };
   }
}
