
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/structures/str_mrb_ope.psl.c
   ----- CREATED   : by hirata@icot22, on Tue Jun 12 17:56:31 1990
   ----- LAST SAVED: by imai@icot22, on Wed Nov  6 22:30:13 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : structures
   ----- ABSTRACT  : 

$B9`L\(B
  1. $B;2>H%Q%9$N(BMRB$B%A%'%C%/$H%;%C%H(B
    $B!&0z?t%l%8%9%?(B"reg"$B$N(BMRB$B$N%F%9%H$*$h$S%;%C%H(B/$B%j%;%C%H(B

  2. $B%]%$%s%?$N(BMRB$B$H%*%V%8%'%/%H$N(BMRB$B$r(BOR$B$9$k%a%b%j%j!<%I(B
    $B!&9=B$BN$NMWAG$r%"%/%;%9$9$kA`:n(B (see str_small_struct.psl.c) $B$G$O(B, 
      $B9=B$BN$NK\BN$X$N%]%$%s%?$,;}$D(BMRB$B$HMWAG$N(BMRB$B$N(BOR$B$r(B $BMWAG$rFI$_=P$7$?(B
      $B%l%8%9%?$K@_Dj$9$k(B.

  3. $B%G%l%U%!%l%s%9$N4pK\A`:n(B
    $B!&%G%l%U%!%l%s%9$G$O(B, MRB$B>pJs$N%a%$%s%F%J%s%9$N$?$a$K(B, $B%]%$%s%?B&$N(B
      MRB$B>pJs$r%*%V%8%'%/%HB&$KEA$($F$$$/I,MW$,$"$k!#(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
1. $B;2>H%Q%9$N(BMRB$B%A%'%C%/$H%;%C%H(B

       written by goto@icot22      on Fri Jan 20 09:32:53 1989
<Arguments> reg: $B0z?t%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B0z?t%l%8%9%?(B"reg"$B$N(BMRB$B$N%F%9%H$*$h$S%;%C%H(B/$B%j%;%C%H(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define s_IfMRBoff(reg)	{  p_IfMRBEQImmediate(reg, _MRB_OFF) }
#CTRL_define s_IfMRBon(reg)	{  p_IfMRBEQImmediate(reg, _MRB_ON) }

#PSL_define s_MRBonReg( reg )
{
  p_SetImmediateMRB( _MRB_ON, reg);
}

#PSL_define s_MRBoffReg( reg )
{
  p_SetImmediateMRB( _MRB_OFF, reg);
}

/******************************************************************** PSL **
2. $B%]%$%s%?$N(BMRB$B$H%*%V%8%'%/%H$N(BMRB$B$r(BOR$B$9$k%a%b%j%j!<%I(B

       written by goto@icot22      Thu Nov 17 21:43:40 1988

<Arguments>
  addr_reg : $B%"%I%l%9%l%8%9%?(B
  imm_ofst : $BB(CM$N%"%I%l%9%*%U%;%C%H(B
  opr_ofst : KL1-B$BL?Na$N%*%Z%i%s%I$G;XDj$5$l$?%"%I%l%9%*%U%;%C%H(B
  dst_reg : 
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  addr_reg $B$H(B dst_reg $B$KF10l$N%l%8%9%?$,;XDj$5$l$&$k$3$H$KCm0U(B
<ETC>
********************************************************************* PSL **/

#PSL_define s_ReadWithMRBor(addr_reg, dst_reg)
{						/* PIM/p $B$N(BMRBorRead */
/*
  @REGOPE_OPT {
    _ReadWithMRBor(addr_reg, dst_reg); goto End;
  };
*/
  s_IfMRBon(addr_reg){ 
    p_Read(addr_reg, dst_reg);
    s_MRBonReg(dst_reg); 
  } else {
    p_Read(addr_reg, dst_reg);
  }
 End:;
}

#PSL_define s_ReadWithOffsetMRBor(addr_reg, imm_ofst, dst_reg)
{						/* PIM/p $B$N(BMRBorRead */
/*
  @REGOPE_OPT {
    _ReadWithOffsetMRBor(addr_reg, imm_ofst, dst_reg); goto End;
  };
*/
  s_IfMRBon(addr_reg){
    p_ReadWithOffset(addr_reg, imm_ofst, dst_reg);
    s_MRBonReg(dst_reg); 
  } else {
    p_ReadWithOffset(addr_reg, imm_ofst, dst_reg);
  }
 End:;
}

#PSL_define s_ReadWithOffsetOprMRBor(addr_reg, opr_ofst, dst_reg)
{						/* PIM/p $B$N(BMRBorRead */
/*
  @REGOPE_OPT {
    _ReadWithOffsetOprMRBor(addr_reg, opr_ofst, dst_reg); goto End;
  };
*/
  s_IfMRBon(addr_reg){
    p_ReadWithOffsetOPR(addr_reg, opr_ofst, dst_reg);
    s_MRBonReg(dst_reg); 
  } else {
    p_ReadWithOffsetOPR(addr_reg, opr_ofst, dst_reg);
  }
 End:;
}

#DATA_define D_WorkRealAddr	XXX

#PSL_define s_ReadWithRegOffsetMRBor(addr_reg, reg_ofst, dst_reg)
{						/* PIM/p $B$N(BMRBorRead */
  $USE(D_WorkRealAddr);
  b_AddWithDNTC (addr_reg, reg_ofst, D_WorkRealAddr); 
                                    /* $B%"%I%l%9$N1i;;$G$"$k$3$H$KCm0U(B!! */
  p_Read (D_WorkRealAddr, dst_reg);
  $RELEASE(D_WorkRealAddr);
  s_IfMRBon(addr_reg){
    s_MRBonReg(dst_reg); 
  }
}

/******************************************************************** PSL **
3. $B%G%l%U%!%l%s%9$N4pK\A`:n(B

       written by goto@icot22      on Wed Feb  1 14:23:29 1989
<Arguments>
  data_reg : $B%G%l%U%!%l%s%9$NBP>]$H$J$k%l%8%9%?(B ($B7k2L$NLa$j@h$G$b$"$k(B)
  save_reg : data_reg$B$rBTHr$9$k%l%8%9%?(B
	($B<B:]$K%]%$%s%?$r<j7+$C$F%G%l%U%!%l%s%9$r9T$C$?;~(B, $BBP>]%;%k$X$N(B
  	$B%]%$%s%?$r;}$D%l%8%9%?$H$J$k(B)
<Temporally Used Variables> none
<Level>
<PreCondition>
<Function>
  data_reg$B$r(Bsave_reg$B$K%3%T!<$7$?8e(B, data_reg$B$N@h$r(Bdata_reg$B$KFI$_9~$`(B.
  $BF1;~$K(B, $B5l(Bdata_reg$B$N(BMRB$B$H$N(BOR$B$r?7(Bdata_reg$B$N(BMRB$B$H$9$k(B.
<Examples>

#PSL_define f_PassiveDeref(reg, work)
{
  LOOP{
    s_IfREF(reg){
				** $B$3$N>r7oH=Dj$N$J$$(Bderef$B%^%/%m$b$"$k$+$b(B...
      s_DerefReg(reg, work);	** PIM/p $B$N(Bderef$BL?Na(B 
      s_IfNotUnbound(reg){
	s_IfMRBoff(reg){
	  s_ReclaimVariable(work);
	  			** ../structures/str_small_struct.psl.c$B;2>H(B
	};
      } else break;
    } else break;
  }
}
<Test>
<Explanation>
  PIM/p $B$N(Bderef$BL?Na$KAjEv$9$k(B.
<ETC>
  s_DerefRegInGC $B$O!"(BGC$BCf$K%G%l%U7k2L$,(B MARKED $B$K$J$k>l9g$,$"$k$?$a!"(B
  @DEBUG $BJ8$rJQ99$7$?$@$1$G$"$j!"$3$l$r=|$/$HA4$/F1$8$K$J$k!#(B
********************************************************************* PSL **/

#PSL_define s_DerefReg(data_reg, save_reg)	
{
  @DEBUG {
    s_IfArgTypeErr (data_reg) {
      VPIM_ERROR ("s_DerefReg", "Illegal_Goal_Argument_Type");
    }
  };
  p_MoveWord (data_reg, save_reg);
  s_ReadWithMRBor(data_reg, data_reg);
  @DEBUG {
    s_IfKL1TypeErr (data_reg) {
      preg(save_reg); preg(data_reg);
      VPIM_ERROR ("s_DerefReg", "Illegal_KL1_Type");
    }
  };
}  

#PSL_define s_DerefRegInGC(data_reg, save_reg)	
{
  @DEBUG {
    s_IfArgTypeErr (data_reg) {
      VPIM_ERROR ("s_DerefRegInGC", "Illegal_Goal_Argument_Type");
    }
  };
  p_MoveWord (data_reg, save_reg);
  s_ReadWithMRBor(data_reg, data_reg);
  @DEBUG {
    s_IfKL1TypeErr (data_reg) {
      b_IfNotMARKED(data_reg) {
	VPIM_ERROR ("s_DerefRegInGC", "Illegal_KL1_Type");
      }
    }
  };
}  

/******************************************************************** PSL **
  4. $B%"%H%_%C%/%G!<%?$N(B MRB $B$r!{$K$9$kA`:n(B

       written by imai@icot22      on Thu Sep 27 16:01:14 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>

	+-------+	+-------+
$B0z?t#1(B	|REFx	------->|ATOMx	|
	+-------+	+-------+

	+-------+	+-------+
$B0z?t#2(B	|REFo	------->|UNDF	|
	+-------+	+-------+

$B$N$h$&$J%f%K%U%#%1!<%7%g%s$K$*$$$F!"0z?t#1$r%G%l%U$r9T$J$&$H%l%8%9%?>e$K(B
$B!|$N%"%H%`$,>h$k!#$3$l$rC1=c$K(B UNDF $B%;%k$K=q$-9~$_$K9T$/$H!"(BUNDF$B$N=q$+$l(B
$B$F$$$?%;%k$,%$%s%/%j%a%s%?%k$K2s<}$G$-$J$/$J$C$F$7$^$&!#$=$3$G!"%"%H%_%C%/(B
$B%G!<%?$O0lEY(B MRB $B$r!{$K$7$F=q$-9~$`!#(B

$B$?$@$7!"(B
	+-------+	+-------+
$B0z?t#1(B	|REFx	------->|ATOMx	|
	+-------+	+-------+

	+-------+	+-------+
$B0z?t#2(B	|REFx	------->|UNDF	|
	+-------+	+-------+

$B$N$h$&$J>l9g$K$O!"!{$G=q$1$J$$$?$a:F$S!|$K$9$kA`:n$,F~$k$7!"(B

	+-------+	+-------+
$B0z?t#1(B	|REFo	------->|ATOMo	|
	+-------+	+-------+

	+-------+	+-------+
$B0z?t#2(B	|REFo	------->|UNDF	|
	+-------+	+-------+

$B$N$h$&$JB?$$$H;W$o$l$k%Q%?!<%s$G$O!"$3$NA`:n$O%*!<%P%X%C%I$K$J$k!#(B

$B>\:Y$JB,Dj$K$h$j!"(BNOP$B$K$9$k$+$I$&$+$r7hDj$7$?$$!#(B

<ETC>
********************************************************************* PSL **/

#PSL_define s_TurnMRBoffIfAtomic(reg)
{
  s_IfAtomic(reg) {
    s_MRBoffReg(reg);
  }
}
