
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/structures/str_merger_record.psl.c
   ----- CREATED   : by imai@icot22, on Wed Jun 20 15:07:49 1990
   ----- LAST SAVED: by imai@icot22, on Tue Oct 15 15:46:22 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 

  $B%^!<%8%c%;%k$O!"0J2<$N?^$K<($9#8%o!<%I$NO"B3NN0h$N%;%k$H$7$FDj5A$5$l$k!#(B
  
+--------------+        +--------------------------+      +-------------+   
|$BF~NO%9%H%j!<%`(B|------->|GOAL:$BF~NO%9%H%j!<%`?t(B	   | +--> |  $B=PNO@hJQ?t(B |
+--------------+        +--------------------------+ |    +-------------+
			|REF :$B=PNO$X$N%]%$%s%?(B    ---+
			+--------------------------+
			|FPREC:$BN$?F$X$N%]%$%s%?(B	   |
			+--------------------------+ 
			|MOD:$B%b%8%e!<%k$X$N%]%$%s%?(B|
		        +--------------------------+
			|INT:$B%b%8%e!<%kFb%*%U%;%C%H(B|
		        +--------------------------+
			|INT: $B%W%m%;%C%5#I#D(B	   |
		        +--------------------------+
			|INT: $B%W%i%$%*%j%F%#(B	   |
		        +--------------------------+
			|INT: $BB0@-(B		   |
		        +--------------------------+


1) $BF~NO%9%H%j!<%`?t(B
	$B%?%$%W$O(B GOALx (GOALo $B$O%4!<%k%l%3!<%I$N@hF,(B)
	$B%^!<%8%c%;%k<+BN$N;2>H%+%&%s%H$H9M$($k;v$,$G$-$k!#(B

2) $B=PNOJQ?t$X$N%]%$%s%?(B
	$B%?%$%W$O!"(BREFo or REFx

3) $BN$?F$X$N%]%$%s%?(B
	$B%^!<%8%c%W%m%;%9$N=jB0$9$kN$?F$X$N%]%$%s%?!#(B
	$B=jB0$9$kN$?F$N>uBV$,!"(Bstopped$B$G$"$C$?$h$&$J>l9g$O(B
	$BF~NO$r=PNO$7$F$O$J$i$J$$!#(B

4) $B%b%8%e!<%k$X$N%]%$%s%?(B
5) $B%b%8%e!<%kFb%*%U%;%C%H(B
	$B%^!<%8%c%W%m%;%9$,1J5WCfCG$7$?>l9g!"$"$k$$$O%^!<%8%c%W%m%;%9$,(B
	$B0[>oF~NO$K$h$jNc30$r5/$3$7$?>l9g$KAq1`$N%l%]!<%H%9%H%j!<%`$rDL(B
	$B$7$FJs9p$9$k$?$a$KMQ$$$i$l$k!#(Bmerge/3 $B$,%3%s%Q%$%k$5$l$?7k2L$N(B
	KL1-B $BL?Na$r;X$7$F$$$k!#(B

6) $B%W%m%;%C%5#I#D(B
	$B%^!<%8%c%W%m%;%9$r:n$C$?%W%m%;%C%5HV9f(B
7) $B%W%i%$%*%j%F%#(B
	$B%^!<%8%c%W%m%;%9$r:n$C$?;~E@$N%W%i%$%*%j%F%#(B
	$BNc30H/@8;~$NBeBX%4!<%k$N%W%i%$%*%j%F%#$KMQ$$$k$@$1$G!"(B
	$BDL>o<B9T;~$K$O<i$i$l$J$$(B
8) $BB0@-(B
	$B%^!<%8%c%W%m%;%9$NB0@-(B
	$BNc30H/@8;~$NBeBX%4!<%k$N%W%i%$%*%j%F%#$KMQ$$$k$@$1$G!"(B
	$BDL>o<B9T;~$K$O<i$i$l$J$$(B

$BK\%U%!%$%kFb$N%^%/%m$N35MW(B

  1. $B%^!<%8%c%;%k$N@8@.(B
  2. $B%^!<%8%c%;%k$N3F%9%m%C%H$X$N%"%/%;%9(B
   2.1   $B%^!<%8%c%;%k$N3F%9%m%C%H$X$N=q$-=P$7(B
   2.2   $B%^!<%8%c%;%k$N3F%9%m%C%H$+$i$NFI$_9~$_(B

  MGHOK$B$7$F$$$kJQ?t$,6qBN2=$7$?;~$K=PNOJQ?t$K$D$J$2$kA`:n$O!"(BMGHOK$B$r6q(B
$BBN2=$9$kL?Na(B(get $B7OL?Na(B) $B$,9T$J$&!#(B

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

#CONST_define _SIZE_OF_MERGER_RECORD		8
#CONST_define _VALID_SIZE_OF_MERGER_RECORD	8

#ADDR_define _REF_COUNT_OFST_MGR	0
#ADDR_define _GOAL_TYPE_OFST_MGR	0
#ADDR_define _OUTPUT_STREAM_OFST_MGR	1
#ADDR_define _FP_REC_OFST_MGR		2
#ADDR_define _MOD_PTR_OFST_MGR		3
#ADDR_define _OFST_IN_MOD_OFST_MGR	4
#ADDR_define _PROCESSOR_ID_OFST_MGR	5
#ADDR_define _PRIORITY_OFST_MGR		6
#ADDR_define _ATTRIBUTE_OFST_MGR	7



/******************************************************************** PSL **
s_AllocMergerCell
       written by nakase@icot22      on Wed Feb 22 14:02:31 1989
<Arguments>
 ptr_to_merger :  $B@8@.$5$l$k%^!<%8%c%;%k$X$N%]%$%s%?(B 
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%^!<%8%c%;%k$r:n$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_AllocMergerCell(ptr_to_merger) {
  b_Alloc8(ptr_to_merger,MGHOK);
}

#PSL_define s_ReclaimMergerCell(ptr_to_merger) {
  @DEBUG{ s_IfNotMGHOK(ptr_to_merger) {
    VPIM_ERROR("s_ReclaimMergerCell","Illegal Type ptr_to_merger!!");
  }};
  b_Reclaim8(ptr_to_merger);
}


/******************************************************************** PSL **
$B%^!<%8%c%;%k$N3F%9%m%C%H$X$N%"%/%;%9(B
       written by nakase@icot22      on Wed Feb 22 14:12:19 1989
<Arguments>
 merger:  $B%^!<%8%c%;%k$X$N%]%$%s%?(B
 src_reg: $B%^!<%8%c%;%k$N3F%9%m%C%H$K=q$-9~$`CM$rJ];}$9$k%l%8%9%?(B
 dst_reg: $B%^!<%8%c%;%k$X3F%9%m%C%H$+$iFI$_=P$7$?CM$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
 $B%^!<%8%c%;%k$N3F%9%m%C%H$NCM$NFI$_=q$-$r$9$k(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_PutMergerOutStream(ptr_to_merger,src_reg)
{
  @DEBUG{ s_IfNotREF(src_reg) {
    VPIM_ERROR("s_PutMergerOutStream","Not REF");
  }};
  p_WriteWithOffset(src_reg,ptr_to_merger,_OUTPUT_STREAM_OFST_MGR);
}

#PSL_define s_PutMergerRefCount(ptr_to_merger,src_reg)
{
  b_WriteImmTagWithOffset
    (_MRB_ON, GOAL, src_reg, ptr_to_merger,_REF_COUNT_OFST_MGR);
}

#PSL_define s_PutMergerFPPtr(ptr_to_merger,src_reg)
{
  @DEBUG{ s_IfNotFPREC(src_reg){
    VPIM_ERROR("s_PutMergerFPPtr","Not FPREC");
  }};
  p_WriteWithOffset(src_reg,ptr_to_merger,_FP_REC_OFST_MGR);
}

#PSL_define s_CompareSwapMergerOutStreamX(ptr_to_merger,old_reg,new_reg)
{
  b_CompareSwapWithOffsetX
	(ptr_to_merger,_OUTPUT_STREAM_OFST_MGR,old_reg,new_reg);
}

#PSL_define s_GetMergerOutStream(ptr_to_merger,dst_reg)
{
  p_ReadWithOffset(ptr_to_merger,_OUTPUT_STREAM_OFST_MGR,dst_reg);
  @DEBUG{ s_IfNotREF(dst_reg){
    VPIM_ERROR("s_GetMergerOutStream","Not REF");
  }};
}

#PSL_define s_GetMergerRefCount(ptr_to_merger,dst_reg)
{
  p_ReadWithOffset(ptr_to_merger,_REF_COUNT_OFST_MGR,dst_reg);
  @DEBUG{ s_IfNotGOAL(dst_reg){
    VPIM_ERROR("s_GetMergerRefCount","Not GOAL");
  }};
}

#PSL_define s_GetMergerFPPtr(ptr_to_merger,dst_reg)
{
  p_ReadWithOffset(ptr_to_merger,_FP_REC_OFST_MGR,dst_reg);
  @DEBUG{ s_IfNotFPREC(dst_reg){
    VPIM_ERROR("s_GetMergerFPPtr","Not FPREC");
  }};
}

#PSL_define s_IncrementMergerRefCountX(ptr_to_merger)
{
  b_AddValueWithOffsetX(ptr_to_merger,_REF_COUNT_OFST_MGR,D_ONE);
}

#PSL_define s_AddMergerRefCountX(ptr_to_merger,counter_reg)
{
  b_AddValueWithOffsetX(ptr_to_merger,_REF_COUNT_OFST_MGR,counter_reg);
}

#CTRL_define s_IfDecrementMergerRefCountAndTurnedZeroX(ptr_to_merger)
{
  $USE(D_WorkRefCnt);
  b_SubtractValueWithLockX
		(ptr_to_merger,_REF_COUNT_OFST_MGR,D_ONE,D_WorkRefCnt);
  @DEBUG{
    s_IfNotGOAL(D_WorkRefCnt) {
      VPIM_ERROR("s_IfDecrementMergerRefCountAndTurnedZeroX","Illegal Type");
    }
    s_IfMRBoff(D_WorkRefCnt) {
      VPIM_ERROR("s_IfDecrementMergerRefCountAndTurnedZeroX","Illegal MRB");
    }
  };
  p_Compare(D_WorkRefCnt,D_NULL);
  @DEBUG{ p_IfLT() {VPIM_ERROR("s_IfDecrementMergerRefCountAndTurnedZeroX",
			       "Illegal Ref Count!!");}};
  $RELEASE(D_WorkRefCnt);
  p_IfEQ()
}

#PSL_define s_PutMergerModulePtr(ptr_to_merger,src_reg)
{
  @DEBUG{ s_IfNotMOD(src_reg){
    VPIM_ERROR("s_PutMergerModulePtr","Not MOD");
  }};
  p_WriteWithOffset(src_reg,ptr_to_merger,_MOD_PTR_OFST_MGR);
}

#PSL_define s_GetMergerModulePtr(ptr_to_merger,dst_reg)
{
  p_ReadWithOffset(ptr_to_merger,_MOD_PTR_OFST_MGR,dst_reg);
  @DEBUG{ s_IfNotMOD(dst_reg){
    VPIM_ERROR("s_GetMergerModulePtr","Not MOD");
  }};
}

#PSL_define s_PutMergerOffsetInModule(ptr_to_merger,src_reg)
{
  @DEBUG{ s_IfNotINT(src_reg){
    VPIM_ERROR("s_PutMergerOffsetInModule","Not INT");
  }};
  p_WriteWithOffset(src_reg,ptr_to_merger,_OFST_IN_MOD_OFST_MGR);
}

#PSL_define s_GetMergerOffsetInModule(ptr_to_merger,dst_reg)
{
  p_ReadWithOffset(ptr_to_merger,_OFST_IN_MOD_OFST_MGR,dst_reg);
  @DEBUG{ s_IfNotINT(dst_reg){
    VPIM_ERROR("s_GetMergerOffsetInModule","Not INT");
  }};
}

#PSL_define s_PutMergerProcessorId(ptr_to_merger,src_reg)
{
  @DEBUG{ s_IfNotINT(src_reg){
    VPIM_ERROR("s_PutMergerProcessorId","Not INT");
  }};
  p_WriteWithOffset(src_reg,ptr_to_merger,_PROCESSOR_ID_OFST_MGR);
}

#PSL_define s_GetMergerProcessorId(ptr_to_merger,dst_reg)
{
  p_ReadWithOffset(ptr_to_merger,_PROCESSOR_ID_OFST_MGR,dst_reg);
  @DEBUG{ s_IfNotINT(dst_reg){
    VPIM_ERROR("s_GetMergerProcessorId","Not INT");
  }};
}

#PSL_define s_PutMergerPriority(ptr_to_merger,src_reg)
{
  @DEBUG{ s_IfNotINT(src_reg){
    VPIM_ERROR("s_PutMergerPriority","Not INT");
  }};
  p_WriteWithOffset(src_reg,ptr_to_merger,_PRIORITY_OFST_MGR);
}

#PSL_define s_GetMergerPriority(ptr_to_merger,dst_reg)
{
  p_ReadWithOffset(ptr_to_merger,_PRIORITY_OFST_MGR,dst_reg);
  @DEBUG{ s_IfNotINT(dst_reg){
    VPIM_ERROR("s_GetMergerPriority","Not INT");
  }};
}

#PSL_define s_PutMergerAttribute(ptr_to_merger,src_reg)
{
  @DEBUG{ s_IfNotINT(src_reg){
    VPIM_ERROR("s_PutMergerAttribute","Not INT");
  }};
  p_WriteWithOffset(src_reg,ptr_to_merger,_ATTRIBUTE_OFST_MGR);
}

#PSL_define s_GetMergerAttribute(ptr_to_merger,dst_reg)
{
  p_ReadWithOffset(ptr_to_merger,_ATTRIBUTE_OFST_MGR,dst_reg);
  @DEBUG{ s_IfNotINT(dst_reg){
    VPIM_ERROR("s_GetMergerAttribute","Not INT");
  }};
}

#PSL_define s_MakePredicateInfoMerger(ptr_to_merger,info_vect)
{
  s_AllocVect3(info_vect);
  $USE(D_WorkInstrId);
  b_SetImmTypeValueMRBoff(INT,BLT_B_MERGE,D_WorkInstrId);
  s_PutVectElementImmOfst(info_vect,_ELEM1_OFST_VECT,D_WorkInstrId);
  s_GetMergerModulePtr(ptr_to_merger,D_WorkInstrId);
  s_PutVectElementImmOfst(info_vect,_ELEM2_OFST_VECT,D_WorkInstrId);
  s_GetMergerOffsetInModule(ptr_to_merger,D_WorkInstrId);
  s_PutVectElementImmOfst(info_vect,_ELEM3_OFST_VECT,D_WorkInstrId);
  $RELEASE(D_WorkInstrId);
}
