
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/structures/str_klb_reg.psl.c
   ----- CREATED   : by hirata@icot22, on Wed May 16 10:25:12 1990
   ----- LAST SAVED: by imai@icot22, on Thu Oct 31 16:39:36 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : structure
   ----- ABSTRACT  : 

A. $B9`L\(B
  1.  KL1$B$N%4!<%k0z?t%l%8%9%?(B
  2.  KL1-B$BL?Na$N<B9T@)8f$K4X$9$k%l%8%9%?$H4pK\A`:n(B
	* D_KLB_PC
    2.1  KL1-B $B$NL?Na%"%I%l%9$N7W;;(B
	- s_GetKLB_Address_OPR
	- s_SetKLB_PC_OPR
	- s_SetKLB_PC
  3.  $B%4!<%k%+%&%s%?(B
	* D_Fork_Ctr
	- s_DecrementForkCounter
	- s_IncrementForkCounter
  4.  $B%W%i%$%*%j%F%#4X78$N@)8f%l%8%9%?(B
	* D_Current_Priority --> $BGQ;_(B
    4.1  CLMaxPriority$B$NA`:n(B
  5.  $B$=$N$[$+$N@)8f%l%8%9%?(B
	* D_Current_FP_Ptr
B. KL1$B$N=hM}7O$K$*$$$FMQ$$$k(BKL1$B@lMQ%l%8%9%?$H4pK\A`:n$rDj5A$9$k!#(B

  $B!&%4!<%k0z?tMQ$K$O:GBg(B32$B8D$N%l%8%9%?$rMQ0U$7$F$$$k!#$?$@$7(B, $B:#8e(B $B%a%b%j$K(B
    $B%4!<%k%l%3!<%I$N%3%s%F%-%9%H$rCV$$$?$^$^$N(BKL1-B$BL?Na%;%C%H$,$^$H$^$C$?>l9g$O(B
    $B<B5!(BPIM$B$K9g$o$;$F%l%8%9%??t$r8:$i$9$3$H$K$J$k!#(B

  $B!&(BKL1-B$BL?Na$N%W%m%0%i%`%+%&%s%?(B(D_KLB_PC)$B$ODL>o$N%l%8%9%?$HF1MM$KDj5A$9$k!#(B
    $B$?$@$7(B, $B%W%m%0%i%`%+%&%s%?$N0UL#IU$1$O<B5!(BPIM$BKh$K0[$J$k$H9M$($i$l$k$?$a(B,
    $B@lMQ$N%"%/%;%9%^%/%m$rMQ$$$k$3$H$H$7(B (2.1 $B;2>H(B), VPIM$B;EMM$NCf$G$OD>@\A`:n(B
    $B$7$J$$!#(B
  $B!&(BD_Current_Priority$B$N%?%0$O(Bcurrent goal$B$N(Bresident$BB0@-$r$"$i$o$9$N$G!"(B
    $BCm0U$,I,MW(B (see str_goal)
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */
/******************************************************************** PSL **
1.  KL1$B$N%4!<%k0z?t%l%8%9%?(B
       written by goto@icot22      Tue Dec 27 16:08:06 1988

<Explanation>
  - $B0z?t%l%8%9%?$O(B $B:GBg(B _MAX_ARG_REG $B8DMQ0U$9$k(B.
  - _MAX_ARG_REG $B$NCM$O(B, KL1 Compiler $B$H$N4V$G<h$j7h$a$k(B.
  - _MAX_ARG_REG_OF_KLB$B$NCM$O(B, KL1 Compiler(for KL1-B)$B$H$N4V$G<h$j7h$a$k(B.
********************************************************************* PSL **/
#CONST_define _MAX_ARG_REG		64
#CONST_define _MAX_ARG_REG_OF_KLB	32
#DATA_define D_ArgReg0 		0
#DATA_define D_ArgReg1 		1
#DATA_define D_ArgReg2 		2
#DATA_define D_ArgReg3 		3
#DATA_define D_ArgReg4 		4
#DATA_define D_ArgReg5 		5
#DATA_define D_ArgReg6 		6
#DATA_define D_ArgReg7 		7
#DATA_define D_ArgReg8 		8
#DATA_define D_ArgReg9 		9
#DATA_define D_ArgReg10 	10
#DATA_define D_ArgReg11 	11
#DATA_define D_ArgReg12		12
#DATA_define D_ArgReg13 	13
#DATA_define D_ArgReg14 	14
#DATA_define D_ArgReg15 	15
#DATA_define D_ArgReg16 	16
#DATA_define D_ArgReg17 	17
#DATA_define D_ArgReg18 	18
#DATA_define D_ArgReg19 	19
#DATA_define D_ArgReg20 	20
#DATA_define D_ArgReg21 	21
#DATA_define D_ArgReg22		22
#DATA_define D_ArgReg23 	23
#DATA_define D_ArgReg24 	24
#DATA_define D_ArgReg25 	25
#DATA_define D_ArgReg26 	26
#DATA_define D_ArgReg27 	27
#DATA_define D_ArgReg28 	28
#DATA_define D_ArgReg29 	29
#DATA_define D_ArgReg30 	30
#DATA_define D_ArgReg31 	31

/******************************************************************** PSL **
2.  KL1-B$BL?Na$N<B9T@)8f$K4X$9$k%l%8%9%?$H4pK\A`:n(B

2.1  KL1-B $B$NL?Na%"%I%l%9$N7W;;$*$h$S%W%m%0%i%`%+%&%s%?$N%;%C%H(B
       written by goto@icot22      on Fri Mar 17 15:18:26 1989
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  s_GetKLB_Address_OPR :
	D_KLB_PC $B$KBP$9$k2C;;(B. $B1i;;Nc30$r5/$3$5$J$$$b$N$r2>Dj$9$k(B
	(return val := PC + opr)
  s_SetKLB_PC_OPR :
  	$BL?Na%*%Z%i%s%I(B($B%i%Y%k(B)$B$G;XDj$5$l$?L?Na%"%I%l%9$r(BD_KLB_PC$B$K%;%C%H$9$k(B.
        KL1-B$B%*%Z%i%s%I$G;XDj$5$l$?%"%I%l%9$OAjBP%"%I%l%9$G$"$k!#(B
	(return val := (PC += opr))
  s_SetKLB_PC :
        $B0z?t$K;XDj$5$l$?%l%8%9%?$NCM$r(BKL1-B$B%W%m%0%i%`%+%&%s%?(B(D_KLB_PC)$B$K(B
        $B%;%C%H$9$k!#%l%8%9%?Fb$NCM$O@dBP%"%I%l%9$r;XDj$9$k!#(B
	(PC := address)
  $BCm0U(B: s_SetKLB_PC_OPR $B$*$h$S(B s_SetKLB_PC $B$O(BPIM/P$B$J$I$N(BRISC$BIw%"!<%-%F%/%A%c$G(B
       $B$O%f!<%6%W%m%0%i%`Cf$K%8%c%s%WL?Na$H$7$FE83+$5$l$k$N$G!"(BKL1-B$BL?Na%l%Y%k(B
       $B$N5-=R$K$*$$$F$O!":G8e$KCV$/I,MW$,M-$k!#(B

<Explanation>
  D_KLB_PC : KL1-B$BL?Na$N%W%m%0%i%`%+%&%s%?(B.
********************************************************************* PSL **/
#DATA_define D_KLB_PC		XXX
#DATA_define D_WorkLabel 	XXX   /* D_WorkB9 */

#PSL_define s_GetKLB_Address_OPR( opr_field, klb_addr_ptr)
{
  $USE(D_WorkLabel);
  p_MoveImmediateValueFromImmediateField(opr_field, D_WorkLabel);
  b_AddWithDNTC(D_WorkLabel, D_KLB_PC, klb_addr_ptr);
  b_SetImmTypeMRBoff(COD,klb_addr_ptr);
  $RELEASE(D_WorkLabel);
}

#PSL_define s_SetKLB_PC_OPR(opr_field)
{
  $USE(D_WorkLabel);
  p_MoveImmediateValueFromImmediateField(opr_field, D_WorkLabel);
  b_AddWithTag(D_KLB_PC, D_WorkLabel, D_KLB_PC);
  $RELEASE(D_WorkLabel);
}

#PSL_define s_SetKLB_PC(addr_reg)
{
  p_MoveWord(addr_reg,D_KLB_PC);
}

/******************************************************************** PSL **
3.  $B%4!<%k%+%&%s%?(B

       written by hirata@icot22      on Wed May 16 10:45:53 1990

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>

s_SetZeroForkCounter: D_Fork_Ctr $B$K%<%m$r%;%C%H$9$k!#(B
	$B$3$l$+$i<B9T$7$h$&$H$9$k%4!<%k$,=jB0$9$kN$?F$,$3$l$^$G$N$b$N$H(B
	$B0[$J$k;~$J$I(B ($B%"%$%I%k>uBV$+$i%9%?!<%H$9$k;~$bF1$8(B)
s_DecrementForkCounter (): D_Fork_Ctr $B$N%$%s%/%j%a%s%H!#(B
     	$B8=:_<B9TCf$N%4!<%k$HF10l$NN$?F$K=jB0$9$k%4!<%k$r(Benqueue$B$7$?;~(B.
s_IncrementForkCounter: D_Fork_Ctr $B$N%G%/%j%a%s%H!#(B
	proceed$BL?Na$K$*$$$F(B "-1"$B$9$k(B.
s_IfForkCounterGTZero: D_Fork_Ctr$B$,(B1$B0J>e$N;~(Btrue$B!#(B
s_IncrementByForkCounter: $B%l%8%9%?$NCM$r(BD_Fork_Ctr$B$NJ,$@$1%$%s%/%j%a%s%H$9$k!#(B
s_ReadForkCounterTo: D_Fork_Ctr$B$NCM$rFI$s$G%l%8%9%?$KBeF~$9$k!#(B

<Examples>
  (1)  $B8=Aq1`(B($BN$?F(B)$B$K$*$1$k%4!<%k?t4IM}%+%&%s%?(B(D_Fork_Ctr)
  
  $B$"$k%/%i%9%?$K$*$$$F(B, 
  $B$"$kN$?F$N2<$K$"$k;R%4!<%k$N?t$O(B, $BN$?F%l%3!<%IFb$N(B child_counter $B$K$h$C$F(B
  $B<($5$l$k!#(BKL1$B$H$7$F$O(B, child_counter == 0 $B$K$h$C$F(B, $BN$?F$N=*N;$r8!=P$9$k!#(B
  $B$3$N$?$a(B, proceed$BL?Na(B, enqueue$BL?Na$K$*$$$FN$?FFb$N(Bchild_counter$B$r99?7$9$l$P(B
  $B%4!<%k?t$N4IM}$,2DG=$G$"$k!#(B
  $B$?$@$7(B, $BN$?F(B($B%l%3!<%I(B)$B$O%/%i%9%?Fb6&M-%G!<%?9=B$$G$"$k$?$a(B, $B99?7%3%9%H$,(B
  $B9b$$!#$=$N$?$a(B, $B8=:_<B9TCf$N%4!<%k$,B0$9$kN$?F$N%+%&%s%?$r3F(BPE$B$N%l%8%9%?(B
  (D_Fork_Ctr)$B$H$7$F%-%c%C%7%e$7(B, $BN$?FFb$N(Bchild_counter$B$r99?7$9$kA`:n$r8:$i(B
  $B$9$3$H$K$9$k!#(B

  $BN$?F$N(Bchild_counter$B$N99?7(B:
     a.	$B$3$l$+$i<B9T$7$h$&$H$9$k%4!<%k$,=jB0$9$kN$?F$,$3$l$^$G$N$b$N$H0[$J$k;~(B,
	$B8=:_$N(BD_Fork_Ctr$B$NCM$rN$?F$N(Bchild_counter$B$K2C$($k!#(B
	($B$3$3$G(B, child_counter == 0 $B$+$I$&$+D4$Y$k!#(B)
     b. $B%"%$%I%k$H$J$C$?;~(B. ($B$3$N>l9g(B, $B%"%$%I%k%4!<%k$,FCJL$NN$?F$K=jB0$7$F$$$k(B
	$B$?$a(B, $B>e5-(Ba.$B$HF1$8$3$H$K$J$k(B.
  $B$?$@$7!"%/%i%9%?Fb$G%4!<%k$rAw<u$9$kA`:n<+?H$O!"(B
	D_Fork_Ctr$B$HN$?F$N(Bchild_counter$B$K1F6A$7$J$$(B.

<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

		/* $B8=Aq1`(B($BN$?F(B)$B$KB0$9$k%4!<%k?t4IM}%+%&%s%?$N%-%c%C%7%e(B */
#DATA_define D_Fork_Ctr		XXX

#PSL_define s_SetZeroForkCounter ()
{
  p_MoveWord (D_NULL, D_Fork_Ctr);
}

#PSL_define s_DecrementForkCounter ()
{
  b_DecrementReg(D_Fork_Ctr);
}

#PSL_define s_IncrementForkCounter ()
{
  b_IncrementReg(D_Fork_Ctr);
}

#CTRL_define s_IfForkCounterGTZero ()
{
  b_IfGreater(D_Fork_Ctr, D_NULL)
}

#PSL_define s_IncrementByForkCounter (reg)
{
  b_AddWithTag(reg, D_Fork_Ctr, reg);
}

#PSL_define s_ReadForkCounterTo (reg)
{
  p_MoveWord(D_Fork_Ctr, reg);
}

/******************************************************************** PSL **
4.  $B%W%i%$%*%j%F%#4X78$N@)8f%l%8%9%?(B

       written by hirata@icot22      on Wed May 16 15:03:19 1990
<Level> structures
<Explanation>

D_Current_Priority : $B8=:_<B9TCf$N%4!<%k$NJ*M}%W%i%$%*%j%F%#$r<($9%l%8%9%?(B.
  $BM[$J%W%i%$%*%j%F%#;XDj$,$J$$(Benqueue$BL?Na$K$h$C$F%4!<%k$r%U%)!<%/$9$k;~$O(B,
  $BK\%l%8%9%?$NCM$r;2>H$9$k(B. (c.f. klb_enqueue_goal_with_priority)

  $B4pK\E*$K$O(B, proceed$BL?Na(B, suspend$BL?Na$K$h$C$F(B, $B?7$7$$%4!<%k$,%G%-%e!<$5$l(B,
  $B$=$N%3%s%F%-%9%H$,%l%8%9%?$K0z$->e$2$?;~$K@_Dj$9$Y$-$G$"$k$,(B, $B:GE,2=$N$?$a$K(B
  $B0J2<$N>l9g$K$N$_99?7$7$F$$$k(B.
	1. $B:G9b0L%W%i%$%*%j%F%#$N%4!<%k$r%G%-%e!<$7$h$&$H$7$?;~(B, D_CurrentGoal
	   StackPtr $B$N@h$,6u(B(EOL)$B$G$"$C$?$?$a(B, $B%4!<%k%9%?%C%/%(%s%H%j$r$?$0$C$?(B
	   $B;~(B (c.f. f_DequeueHighestPriorityGoal)
	2. $BFbIt%$%Y%s%H%O%s%I%i$K$*$$$F(B, "$B%W%i%$%*%j%F%#$N9b$$%4!<%k$N%U%)!<%/(B"
	   (_HighPriorityGoalEvent) $B$r8!=P$7$?;~(B. (c.f. f_HigherPriorityGoal ).

D_Max_Priority : $B%l%G%#%4!<%k$N:G9b0L%W%i%$%*%j%F%#$r<($9%l%8%9%?(B.
  $BM[$J%W%i%$%*%j%F%#;XDj$r;}$D(Benqueue$BL?Na$K$h$C$F8=%W%i%$%*%j%F%#(B
  (D_Current_Priority)$B$h$j9b$$%W%i%$%*%j%F%#$r;}$D%4!<%k$r%U%)!<%/$9$k;~(B,
  $B$*$h$S(B, $BB>$N%W%m%;%C%5$+$i<u$1<h$C$?%4!<%k$N%W%i%$%*%j%F%#$,8=%W%i%$%*%j%F%#(B
  $B$h$j9b$$;~(B, $BK\%l%8%9%?$K$=$NCM$r@_Dj$9$k(B.
  ----> $B$3$N$H$-%?%$%W$r(B INTo $B$K$7!"$3$N>uBV$r(B VAILD $B$J>uBV$H8F$V!#(B
  $BA0<T$N>l9g$O%9%j%C%H%A%'%C%/MW0x$H$7(B, $B%9%j%C%H%A%'%C%/=hM}$NCf$G(B,
  D_Current_Priority, $B$H%4!<%k%9%?%C%/4X78$N%l%8%9%?$r99?7$9$k!#(B
  ----> $B99?7$r=*$($?$i%?%$%W$r(B EOLo $B$K$7!"$3$N>uBV$r(B INVALID $B$J>uBV$H8F$V!#(B

D_Pressure : $B05NO%a!<%?(B

CLMaxPriority : $B%/%i%9%?Fb$N:G9b0LJ*M}%W%i%$%*%j%F%#$r<($9%l%8%9%?(B.
  (Global register in each cluster, allocated in shared memory).
<ETC>
  $B$H$3$m$,!"(BD_Current_Priority$B$G!"%4!<%kB0@-$N%F%9%H$b7s$M$F$$$k$N$G(B
  $BCm0U$,I,MW!#(B

********************************************************************* PSL **/

/* #DATA_define D_Current_Priority	XXX	--> $BGQ;_(B */

#DATA_define D_WorkCurrentPriority	XXX

#DATA_define D_Max_Priority 	XXX	/* $BJ*M}%W%i%$%*%j%F%#$rJ];}$9$k(B */
					/* $BCm0U(B: D_Current_Priority $B$OO@M}(B */
#DATA_define D_Pressure		XXX

#CTRL_define s_IfValidMaxPriority()
{
  p_IfTypeEQImmediate(D_Max_Priority,INT)
}

#CTRL_define s_IfInvalidMaxPriority()
{
  p_IfTypeEQImmediate(D_Max_Priority,EOL)
}

#PSL_define s_InvalidateMaxPriority()
{
  p_MoveWord(D_EOL,D_Max_Priority);
}

#PSL_define s_SetMaxPriority(prio_reg)
{
  b_MoveWithImmTypeMRBoff(prio_reg,INT,D_Max_Priority);
}

/******************************************************************** PSL **
4.1  CLMaxPriority$B$NA`:n(B
       written by goto@icot22      on Tue Jan 24 17:37:41 1989

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  s_GetCLMaxPriority (reg) : $B6&M-%W%i%$%*%j%F%#$NFI$_$@$7(B
  s_SwapCLMaxPriorityX (old_priority_reg, new_priority_reg) :
  	$B6&M-%W%i%$%*%j%F%#$NFI$_$@$7$H99?7(B($B%l%8%9%?(B)
  s_SwapImmCLMaxPriorityX (old_priority_reg, imm_new_priority) :
  	$B6&M-%W%i%$%*%j%F%#$NFI$_$@$7$H99?7(B($BB(CM(B)
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_GetCLMaxPriority (reg)
{
  b_ReadCommArea (_PRIO_MAX_OFST, reg);
}

/******************************************************************** PSL **
5.  $B$=$N$[$+$N@)8f%l%8%9%?(B

       written by goto@icot22      on Mon Jan 23 21:09:26 1989
<Explanation>
  D_Current_FP_Ptr : $B8=:_<B9TCf$N%4!<%k$NAq1`(B($BN$?F(B)$B$r;X$9%]%$%s%?%l%8%9%?(B

  D_ResourceCache : $B8=:_$NN$?F$+$i%j%=!<%9(B($B%j%@%/%7%g%s?t(B)$B$r(BPE$B$K(B
		$B%-%c%C%7%e$9$k%l%8%9%?(B
	$B%4!<%k$r%G%-%e!<$7$?;~(B, $BN$?F$,@Z$jJQ$o$C$?$i85$NN$?F$N%j%=!<%9%9%m%C%H(B
	$B$K=q$-La$7(B(i_DequeueNewGoal), $B0lC6%<%m%/%j%"$5$l$k(B.
	(s_UpdateFPResourceCountX).
	$BDL>o$O(B, $B%4!<%k%j%@%/%7%g%s$N@Z$lL\(B(klb_proceed, klb_execute) $B$G8F$S=P$5(B
	$B$l$k(B f_Consume () $B$K$*$$$F%G%#%/%j%a%s%H$5$l$k!#(B
	$B%<%m$K$J$C$?$i(B, $B0lDjNL$N;q8;(B($B%j%@%/%7%g%s?t(B)$B$r!"(BD_Current_FP_Ptr
	$B$,;X$9N$?F$+$i<h$C$F$-$F%-%c%C%7%e$9$k(B
	(s_GetFPResourceCacheX).
<ETC>
  D_WorkGoalPtr : $B%4!<%k%l%3!<%I$r;X$9%l%8%9%?(B
  	proceed, suspend $BEy$K$*$$$F%G%-%e!<$^$?$O%5%9%Z%s%I$5$;$k%4!<%k$r;X$9(B

********************************************************************* PSL **/

#DATA_define D_Current_FP_Ptr	XXX

/*--- $B5l(B s_SetCurrentPriorityAndFP ---*/
#PSL_define s_SetCurrentEnvRecPtrAndFP (ptr_to_curr_gr)
{
  @DEBUG { 
    s_IfNotHOOK( ptr_to_curr_gr ) {
      s_IfNotEHOOK( ptr_to_curr_gr ) {
	VPIM_ERROR( "s_SetCurrentPriorityAndFP", "Not_Goal" );
  }}};
  s_GetEnvRecGoalRecord(ptr_to_curr_gr,D_CurrentEnvRecPtr);

  @DEBUG { b_WarningIfSameRegNum (ptr_to_curr_gr, D_Current_FP_Ptr); };
  s_GetFosterparentGoalRecord(ptr_to_curr_gr,D_Current_FP_Ptr);
  @DEBUG { s_IfNotFPREC (D_Current_FP_Ptr){
	VPIM_ERROR ("s_SetCurrentPriorityAndFP","Not-Goal");}
  };
}

#CTRL_define s_IfCurrentFPEqualToFPof (ptr_to_gr)
{
  $USE(D_WorkFPPtr);
  p_ReadWithOffset(ptr_to_gr, _FP_PTR_OFST_GR, D_WorkFPPtr);
  p_Compare(D_Current_FP_Ptr, D_WorkFPPtr);
  $RELEASE(D_WorkFPPtr);		/* Is this release timing correct? */
  p_IfEQ()
}

#DATA_define D_ResourceCache	XXX

#DATA_define D_WorkGoalPtr	XXX	/* $B5l(B D_CurrentGoalPtr */

#DATA_define D_WorkGoalLink	XXX	/* $B5l(B D_CurrentGoalPtr */


