/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/structures/str_int_cl_packet.psl.c
   ----- CREATED   : by nakase@icot22, on Wed Jun  6 09:59:20 1990
   ----- LAST SAVED: by ttakagi@icot22, on Fri Jun 19 14:27:13 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : STRUCTURES
   ----- ABSTRACT  : $B%Q%1%C%H$N3d$jEv$F!"2s<}!"Aw<u?.(B

0. $B%/%i%9%?4V%a%C%;!<%8<oJL$NDj5A(B

1. $BO@M}%Q%1%C%H$N3d$jEv$F(B
   1.1 s_AllocLogicalPacket(size_reg, packet_ptr)
   1.2 s_AllocLogicalPacketImmSize(imm_size, packet_ptr)

2. $BO@M}%Q%1%C%H$N2s<}(B
   s_ReclaimLogicalPacket(packet_ptr)

3. $BO@M}%Q%1%C%H$K4X$9$k7W;;(B
   3.1 $BO@M}%Q%1%C%H$N<B8z%5%$%:$rF@$k(B
       s_GetPacketSize(packet_ptr, current_packet_ptr, size_reg)
   3.2 $BO@M}%Q%1%C%H$N%G!<%?=q$-9~$_0LCV$rF@$k(B
       s_GetCurrentPacketPtr(packet_ptr, current_packet_ptr)

4. $BO@M}%Q%1%C%H$K%G!<%?$r#1$DF~$l$k(B
   4.1 s_Put_1_Data_inLogicalPacket(current_packet_ptr, data_reg)
   4.2 s_Put_1_ImmData_inLogicalPacket(current_packet_ptr, imm_data)
   4.3 s_Put_1_Data_WithDNTC_inLogicalPacket(current_packet_ptr, data_reg)

5. $BO@M}%Q%1%C%H$+$i%G!<%?$r#1$D<h$j=P$9(B
   s_Get_1_Data_fromLogicalPacket(current_packet_ptr, data_reg)

6. $B%M%C%H%o!<%/$K%Q%1%C%H$rAw?.$9$k(B
   6.1 s_SendPacket(packet_ptr, packet_size_reg, cluster_num_reg)
   6.2 s_SendPacket_ToFPs_Sub(A_PacketPtr, A_FPTableUpper, A_FPTableLower)
   6.2.1 s_SendPacket_ToFPTableBitOn(packet_ptr, fp_table, cluster_num)

 6.3 $B%7%s%0%k!&%Q%1%C%H$NAw?.(B
   6.3.1 s_SendSinglePacket(packet_ptr, packet_size_reg, cluster_num_reg)
   6.3.2 s_SendPacketWithoutPacketReclaim
                           (packet_ptr, packet_size_reg, cluster_num_reg)

 6.4 $B%^%k%A%Q%1%C%H$NAw?.(B
   s_SendMultiPacket(packet_ptr, cluster_num_reg,
                  packet_id_reg, packet_num_reg, packet_cnt_reg, last_size_reg)

7. $B%M%C%H%o!<%/$+$i%G!<%?$rFI$_9~$`(B

8. $B<u?.$7$?%Q%1%C%H$N%A%'%C%/(B

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
0. $B%/%i%9%?4V%a%C%;!<%8<oJL$NDj5A(B

       written by ttakagi@icot22      on Tue May 15 13:34:11 1990

<Explanation>
  $B<oJL?t(B
      $B%G!<%?4X78(B          8
      $BAq1`N$?F4X78(B       17
      $BNc30=hM}4X78(B        1
      $B$=$NB>(B              1
    -------------------------
      $B9g7W(B               27

<ETC>
  $B$?$@$7!"(B_NW_PIMS_SHUTDOWN $B$O!"(BPIM/s $B@lMQ$N<oJL$G$"$k!#(B
********************************************************************* PSL **/
                                                 /*    $B@N!";HMQ$7$F$$$?HV9f(B */
                                                 /*                      $B"-(B */
#CONST_define _NW_THROW_GOAL               0     /* %throw_goal           1 */
#CONST_define _NW_READY                    1     /* %ready              101 */
#CONST_define _NW_TERMINATED               2     /* %terminated         102 */
#CONST_define _NW_START                    3     /* %start              103 */
#CONST_define _NW_STOP                     4     /* %stop               104 */
#CONST_define _NW_ABORT                    5     /* %abort              105 */
#CONST_define _NW_READ                     6     /* %read                 2 */
#CONST_define _NW_ANSWER_VALUE             7     /* %answer_value         3 */
#CONST_define _NW_RELEASE                  8     /* %release              4 */
#CONST_define _NW_UNIFY                    9     /* %unify                5 */
#CONST_define _NW_EXCEPTION               10     /* %exception          201 */

/* 11 $B!A(B 13 $B$O%9%H%j!<%`:GE,2=%a%C%;!<%8MQ$G!"L$%$%s%W%j%a%s%H(B */

#CONST_define _NW_REQUEST_WTC             14     /* %request_WTC        106 */
#CONST_define _NW_SUPPLY_WTC              15     /* %supply_WTC         107 */
#CONST_define _NW_RETURN_WTC              16     /* %return_WTC         108 */
#CONST_define _NW_REQUEST_RESOURCE        17     /* %request_resource   117 */
#CONST_define _NW_SUPPLY_RESOURCE         18     /* %supply_resource    115 */
#CONST_define _NW_RETURN_RESOURCE         19     /* %return_resource    116 */
#CONST_define _NW_ASK_STATISTICS          20     /* %ask_statistics     118 */
#CONST_define _NW_ANSWER_STATISTICS       21     /* %answer_statistics  119 */
#CONST_define _NW_SHOEN_PROFILE           22     /* %answer_profile     123 */
#CONST_define _NW_SHOEN_PROFILE_REQUEST   23     /* %ask_profile        122 */

/* $BK\Mh(B 24 $B$O(B %syncronized_GC $BMQ$G$"$k$,!"8=:_L$;HMQ$J$N$G(B
   _NW_PIMS_SHUTDOWN $B$r2>$KF~$l$F$$$k!#(B                    */
#CONST_define _NW_PIMS_SHUTDOWN		  24	 /* PIM/s $B@lMQ(B -------  499 */

#CONST_define _NW_REQUEST_BEXID_WEX       25     /* %request_bexid_wex    6 */
#CONST_define _NW_REQUEST_BEXID_BEX       26     /* %request_bexid_bex    7 */
#CONST_define _NW_SUPPLY_BEXID            27     /* %answer_bexid         8 */

#CONST_define _NW_NAK_START               28     /* %nak_start          120 */
#CONST_define _NW_NAK_STOP                29     /* %nak_stop           121 */

/******************************************************************** PSL **
1. $BO@M}%Q%1%C%H$N3d$jEv$F(B

1.1 s_AllocLogicalPacket(size_reg, packet_ptr)
  $B%5%$%:$O%l%8%9%?$G;XDj$9$k!#(B
  $B;XDj%5%$%:$r3JG<$9$k$KB-$k%Y%/%?$r3dEv$F$F%]%$%s%?$rJV$9!#(B
  $B2DJQD9%Q%1%C%H$N3dEv$KJXMx!#(B

1.2 s_AllocLogicalPacketImmSize(imm_size, packet_ptr)
  $B%5%$%:$OB(CM$G;XDj$9$k!#(B
  $B;XDj%5%$%:$r3JG<$9$k$KB-$k%Y%/%?$r3dEv$F$F%]%$%s%?$rJV$9!#(B
  $B2DJQD9%Q%1%C%H$N3dEv$KJXMx!#(B

       written by nakase@icot22      on Wed Jun  6 20:32:07 1990

<Arguments>
  size_reg:   $B%Q%1%C%H$N%5%$%:!JF~NO%l%8%9%?!K(B
  packet_ptr: $B%M%C%H%o!<%/$K=PNO$9$k%Q%1%C%H$X$N%]%$%s%?!J=PNO!K(B
  imm_size:   $B%Q%1%C%H$N%5%$%:!JB(CM!K(B

<Explanation>
  $BO@M}%Q%1%C%HD9$K$O@)8B$O$J$$!#(B
  $B$3$N%l%Y%k$G$O!"%^%k%A%Q%1%C%H$K$J$k$+H]$+$OH=Dj$7$J$$(B $B!#(B
  $B<B:]$K%M%C%H%o!<%/$KAw$j=P$9;~$KH=Dj$9$k!#(B

<ETC>
  $BO@M}%Q%1%C%H$O(B 32$B%S%C%H!&%9%H%j%s%0$H$7$F9=@.$9$k!#(B
  $B$3$l$O(B $B#G#C$N$H$-Cf?H$rFI$_Ht$P$9$?$a$G$"$k!#(B
  $B$7$?$,$C$F!"%a%b%j>e$K$O(B CDESC $B$NJ,$r4^$a$F(B (size + 1) $B3NJ]$5$l$k!#(B
********************************************************************* PSL **/

#CONST_define _STRING_SIZE_LOGICAL_PACKET  32

#PSL_define s_AllocLogicalPacket(size_reg, packet_ptr)
{
  $USE(D_WorkStringSize);
  b_SetImmValueDNTC(_STRING_SIZE_LOGICAL_PACKET, D_WorkStringSize);
  $USE(D_WorkDesc);
  s_SetStringDescOnReg(size_reg, D_WorkStringSize, D_WorkDesc);
  $CALL( s_AllocStrgMRBoffWithDesc_Sub(packet_ptr, D_WorkDesc) );
  $RELEASE(D_WorkDesc);
  $RELEASE(D_WorkStringSize);
}

#PSL_define s_AllocLogicalPacketImmSize(imm_size, packet_ptr)
{
  $USE(D_WorkPacket_Size);
  b_SetImmValueDNTC(imm_size, D_WorkPacket_Size);
  s_AllocLogicalPacket(D_WorkPacket_Size, packet_ptr);
  $RELEASE(D_WorkPacket_Size);
}

/******************************************************************** PSL **
2. $BO@M}%Q%1%C%H$N2s<}(B

s_ReclaimLogicalPacket(packet_ptr)

       written by nakase@icot22      on Wed Jun 13 15:18:52 1990

<Arguments>
  packet_ptr: $B2s<}$9$kO@M}%Q%1%C%H$X$N%]%$%s%?(B

<Explanation>
  $BO@M}%Q%1%C%H$O(B String $B$J$N$G!"(Bs_ReclaimString $B$r;HMQ$9$k!#(B

<ETC>
********************************************************************* PSL **/

#PSL_define s_ReclaimLogicalPacket(packet_ptr)
{
  @DEBUG{
    s_IfNotSTRG(packet_ptr) {
      VPIM_ERROR("s_ReclaimLogicalPacket", "LogicalPacketPtr is not STRG");
    }
  };
  s_ReclaimString(packet_ptr);
}

/******************************************************************** PSL **
3. $BO@M}%Q%1%C%H$K4X$9$k7W;;(B

3.1 $BO@M}%Q%1%C%H$N<B8z%5%$%:$rF@$k(B

s_GetPacketSize(packet_ptr, current_packet_ptr, size_reg)

3.2 $BO@M}%Q%1%C%H$N%G!<%?=q$-9~$_0LCV$rF@$k(B

s_GetCurrentPacketPtr(packet_ptr, current_packet_ptr)

       written by nakase@icot22      on Fri Jun 22 20:54:12 1990

<Arguments>
 packet_ptr          : $BO@M}%Q%1%C%H$X$N%]%$%s%?(B
 current_packet_ptr  : $BO@M}%Q%1%C%H$N:G=*%G!<%?$N#1$D@h$r;X$9%]%$%s%?(B
 size_reg            : $BO@M}%Q%1%C%H$N<B8z%5%$%:(B

<Explanation>
  <$B%Q%1%C%H$N<B8z%5%$%:(B>
     = <$B%Q%1%C%H$N@hF,%]%$%s%?(B> - <$B%Q%1%C%H$N:G=*%G!<%?$N#1$D@h$r;X$9%]%$%s%?(B>
       - <CDESC $B$NJ,(B (= 1)>

  $BO@M}%Q%1%C%H(B
    +----------+---------------------+
    | CDESC    |                     |
    +----------+---------------------+   \
    |                                |   |
    /                                /   |
             $B%Q%1%C%H%G!<%?(B               > $B%Q%1%C%H$N<B8z%5%$%:(B
    /                                /   |
    |                                |   |
    +----------+---------------------+   /

<ETC>
********************************************************************* PSL **/

#PSL_define s_GetPacketSize(packet_ptr, current_packet_ptr, size_reg)
{
  b_SubtractWithDNTC(current_packet_ptr, packet_ptr, size_reg);
  /*--- $B"-(B added by A. Imai (1991.08.22) for byte addressing PIM/x */
  b_ExchangeOffsetToElmpos(size_reg, size_reg);
  b_SubtractImmediateWithDNTC(size_reg, _ONE, size_reg);
}

#PSL_define s_GetCurrentPacketPtr(packet_ptr, current_packet_ptr)
{
  p_MoveWord(packet_ptr, current_packet_ptr);
  b_IncrementAddrReg(current_packet_ptr);
}

#CTRL_define s_IfSinglePacket(packet_size)
{
  b_IfLessEq(packet_size, _SINGLE_PACKET_DATA_SIZE_MAX)
}

/******************************************************************** PSL **
4. $BO@M}%Q%1%C%H$K%G!<%?$r#1$DF~$l$k(B

4.1 s_Put_1_Data_inLogicalPacket(current_packet_ptr, data_reg)
$B%G!<%?$O%l%8%9%?$K$"$k!#(B

4.2 s_Put_1_ImmData_inLogicalPacket(current_packet_ptr, imm_data)
$BB(CM%G!<%?$N=q$-9~$_(B

4.3 s_Put_1_Data_WithDNTC_inLogicalPacket(current_packet_ptr, data_reg)
$B%?%0$r(B DNTC $B$K$7$F=q$-9~$`!#(B

       written by nakase@icot22      on Sat Jun 23 17:03:12 1990

<Arguments>
  current_packet_ptr: $BO@M}%Q%1%C%H$G%G!<%?$r3JG<$9$k0LCV!J%]%$%s%?!K(B
  data_reg:           $B%G!<%?!J%l%8%9%?!K(B
  imm_data:           $B%G!<%?!JB(CM!K(B

<Explanation>
$B!&%G!<%?$,B(CM$N>l9g$O!"(BDNTC $B%?%0$rIU$1$F3JG<$9$k!#(B
$B!&(Bcurrent_packet_ptr $B$O!"$R$H$D@h$K?J$a$i$l$k!#(B

<ETC>
********************************************************************* PSL **/

#PSL_define s_Put_1_Data_inLogicalPacket(current_packet_ptr, data_reg)
{
  p_Write(data_reg, current_packet_ptr);
  b_IncrementAddrReg(current_packet_ptr);
}

#DATA_define D_WorkImmDataInPacket XXX

#PSL_define s_Put_1_ImmData_inLogicalPacket(current_packet_ptr, imm_data)
{
  $USE(D_WorkImmDataInPacket);
  b_SetImmValueDNTC(imm_data, D_WorkImmDataInPacket);
  p_Write(D_WorkImmDataInPacket, current_packet_ptr);
  $RELEASE(D_WorkImmDataInPacket);
  b_IncrementAddrReg(current_packet_ptr);
}

#DATA_define D_WorkDataDNTC XXX

#PSL_define s_Put_1_Data_WithDNTC_inLogicalPacket(current_packet_ptr, data_reg)
{
  $USE(D_WorkDataDNTC);
  b_MoveWithImmTypeMRBoff(data_reg, DNTC, D_WorkDataDNTC);
  p_Write(D_WorkDataDNTC, current_packet_ptr);
  $RELEASE(D_WorkDataDNTC);
  b_IncrementAddrReg(current_packet_ptr);
}

/******************************************************************** PSL **
4.0 $B%G!<%?$r#1$DAw=P$9$k(B

4.0.1 s_Send_1_Data_toNetwork(data_reg)
$B%G!<%?$O%l%8%9%?$K$"$k!#(B

4.0.2 s_Send_1_ImmData_toNetwork(imm_data)
$BB(CM%G!<%?$N=q$-9~$_(B

4.0.3 s_Send_1_Data_WithDNTC_toNetwork(data_reg)
$B%?%0$r(B DNTC $B$K$7$F=q$-9~$`!#(B

       written by ttakagi@icot22      on Wed Mar  4 17:01:41 1992

<Arguments>
  data_reg:           $B%G!<%?!J%l%8%9%?!K(B
  imm_data:           $B%G!<%?!JB(CM!K(B

<Explanation>
$B!&%G!<%?$,B(CM$N>l9g$O!"(BDNTC $B%?%0$rIU$1$F3JG<$9$k!#(B

<ETC>
********************************************************************* PSL **/

#PSL_define s_Send_1_Data_toNetwork(data_reg)
{
  b_SendMessageOneWord(data_reg);
}

#PSL_define s_Send_1_ImmData_toNetwork(imm_data)
{
  $USE(D_WorkImmDataInPacket);
  b_SetImmValueDNTC(imm_data, D_WorkImmDataInPacket);
  b_SendMessageOneWord(D_WorkImmDataInPacket);
  $RELEASE(D_WorkImmDataInPacket);
}

#PSL_define s_Send_1_Data_WithDNTC_toNetwork(data_reg)
{
  $USE(D_WorkDataDNTC);
  b_MoveWithImmTypeMRBoff(data_reg, DNTC, D_WorkDataDNTC);
  b_SendMessageOneWord(D_WorkDataDNTC);
  $RELEASE(D_WorkDataDNTC);
}

#PSL_define s_Send_PacketHeader_toNetwork(recv_cl_num, packet_size)
{
  s_Send_1_Data_WithDNTC_toNetwork(D_CL_Number);
  s_Send_1_Data_WithDNTC_toNetwork(recv_cl_num);
  b_SetImmTypeMRBoff(INT, packet_size);
  s_Send_1_Data_toNetwork(packet_size);
}

/******************************************************************** PSL **
5. $BO@M}%Q%1%C%H$+$i%G!<%?$r#1$D<h$j=P$9(B

s_Get_1_Data_fromLogicalPacket(current_packet_ptr, data_reg)

       written by nakase@icot22      on Sat Jun 23 17:03:37 1990

<Arguments>
  current_packet_ptr: $BO@M}%Q%1%C%H$G$N%G!<%?$rFI$_=P$90LCV!J%]%$%s%?!K(B
  data_reg:           $B<h$j=P$9%G!<%?(B DST

<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_Get_1_Data_fromLogicalPacket(current_packet_ptr, data_reg)
{
  p_Read(current_packet_ptr, data_reg);
  b_IncrementAddrReg(current_packet_ptr);
}

/******************************************************************** PSL **
6. $B%Q%1%C%H$NAw?.(B

6.1 s_SendPacket(packet_ptr, packet_size_reg, cluster_num_reg)
$BAw?.Aj<j$,#1$D$N;~$K;HMQ(B

6.2 s_SendPacket_ToFPs_Sub(A_PacketPtr, A_FPTableUpper, A_FPTableLower)
$BAw?.Aj<j$,J#?t$N;~$K;HMQ(B($BAq1`$+$iN$?F(B)

6.2.1 s_SendPacket_ToFPTableBitOn(packet_ptr, fp_table, cluster_num)
$BN$?F%F!<%V%k$N#1%o!<%IJ,$rAw?.(B
s_SendPacket_ToFPs_Sub$B$N$_$+$i8F$P$l$k!#(B

       written by nakase@icot22      on Wed Jun 13 15:26:03 1990

<Arguments>
  A_PacketPtr: $BO@M}%Q%1%C%H$X$N%]%$%s%?(B
  A_PacketSize: $BO@M}%Q%1%C%H$N%o!<%I%5%$%:!J%l%8%9%?!K(B
  A_ClNum: $BAw$j@h$N%/%i%9%?HV9f!J%l%8%9%?!K(B

  A_FPTableUpper: $BN$?F%F!<%V%k(B($B>e0L(B)
  A_FPTableLower: $BN$?F%F!<%V%k(B($B2<0L(B)

<Explanation>
  $BO@M}%Q%1%C%H$N%5%$%:$,!"(B
    _SINGLE_PACKET_DATA_SIZE_MAX $B0J2<(B    --->  $B%7%s%0%k!&%Q%1%C%H(B
    _SINGLE_PACKET_DATA_SIZE_MAX $B$h$jBg(B  --->  $B%^%k%A!&%Q%1%C%H(B
<ETC>
********************************************************************* PSL **/

#DATA_define 	D_WorkCurrentPacketSlot XXX
#DATA_define	D_WorkSendData		XXX

#SUBARG_define A_PacketPtr  SRC
#SUBARG_define A_PacketSize SRC
#SUBARG_define A_ClNum      SRC

#SUBROUTINE s_SendPacket_Sub(A_PacketPtr, A_PacketSize, A_ClNum)
{
  b_IfGreaterImm(A_PacketSize, _SINGLE_PACKET_DATA_SIZE_MAX) {
   /*** for Processor Profile ***/ /* multi-packet$B$K$J$k%a%C%;!<%8$N%+%&%s%H(B */
    s_RecordMultiPacketSendCountNumberOfMessages();
    $USE(D_WorkMultiPacketID);
    s_GenerateMultiPacketIdX(D_WorkMultiPacketID);
    $USE(D_WorkMultiPacketNum);
    $USE(D_WorkLastSize);
    s_GetPacketTotalNum(A_PacketSize, D_WorkMultiPacketNum, D_WorkLastSize);
    p_SubtractImmediate
              (D_WorkLastSize, _MULTI_PACKET_CONTROL_SIZE, D_WorkLastSize);
    $USE(D_WorkMultiPacketCount);
    b_SetImmTypeValueMRBoff(DNTC, _ONE, D_WorkMultiPacketCount);
    s_SendMultiPacket(A_PacketPtr, A_ClNum, D_WorkMultiPacketID,
		      D_WorkMultiPacketNum, D_WorkMultiPacketCount,
		      D_WorkLastSize);
    $RELEASE(D_WorkMultiPacketCount);
    $RELEASE(D_WorkLastSize);
    $RELEASE(D_WorkMultiPacketNum);
    $RELEASE(D_WorkMultiPacketID);
  } else {
    s_SendSinglePacket(A_PacketPtr, A_PacketSize, A_ClNum);
  }
  $RETURN();
}

#CONST_define _FP_TABLE_UPPER_CL_NUM  32
#CONST_define _FP_TABLE_LOWER_CL_NUM   0

#SUBARG_define A_PacketPtr       SRC
#SUBARG_define A_FPTableUpper    MODIFY
#SUBARG_define A_FPTableLower    MODIFY

#SUBROUTINE s_SendPacket_ToFPs_Sub(A_PacketPtr, A_FPTableUpper, A_FPTableLower)
{
  $USE(D_WorkClusterNum);

  b_IfNotEqualImm(A_FPTableLower, _ZERO) {
    b_SetImmValueDNTC(_FP_TABLE_LOWER_CL_NUM, D_WorkClusterNum);
    s_SendPacket_ToFPTableBitOn(A_PacketPtr, A_FPTableLower, D_WorkClusterNum);
    b_IfEqual(D_WorkClusterNum, D_ALL1) {
      goto PACKET_SUSPEND;
    }
  }

  b_IfNotEqualImm(A_FPTableUpper, _ZERO) {
    b_SetImmValueDNTC(_FP_TABLE_UPPER_CL_NUM, D_WorkClusterNum);
    s_SendPacket_ToFPTableBitOn(A_PacketPtr, A_FPTableUpper, D_WorkClusterNum);
    b_IfEqual(D_WorkClusterNum, D_ALL1) {
      goto PACKET_SUSPEND;
    }
  }

  s_ReclaimLogicalPacket(A_PacketPtr);
  goto NORMAL_FINISH;

 PACKET_SUSPEND:
  @DEBUG{ WARNING("s_SendPacket_ToFPs_Sub","Packet suspended."); };
  s_PacketSuspend_Distribute(A_PacketPtr, A_FPTableUpper, A_FPTableLower);

 NORMAL_FINISH:
  $RELEASE(D_WorkClusterNum);
  
  $RETURN();
}

#CONST_define _PACKET_SIZE_SHOEN_TO_FP  4
#DATA_define D_WorkFPTableBit XXX

#PSL_define s_SendPacket_ToFPTableBitOn(packet_ptr, fp_table, cluster_num)
{
  $USE(D_WorkPacketSize);
  b_SetImmValueDNTC(_PACKET_SIZE_SHOEN_TO_FP, D_WorkPacketSize);
  $USE(D_WorkFPTableBit);
  LOOP() {
    b_BitwiseAndImmediateWithDNTC(fp_table, _ONE, D_WorkFPTableBit);
    b_IfEqualImm(D_WorkFPTableBit, _ONE) {
      $USE(D_WorkStatusFlag);
      s_SendPacketWithoutPacketReclaim
	         (packet_ptr, D_WorkPacketSize, cluster_num, D_WorkStatusFlag);
      b_IfEqual(D_WorkStatusFlag, D_ONE) {
	b_ShiftLeftWithDNTC(fp_table, cluster_num, fp_table);
	p_MoveWord(D_ALL1, cluster_num);
	$RELEASE(D_WorkStatusFlag);
	break;
      }
      $RELEASE(D_WorkStatusFlag);
    }
    b_IncrementReg(cluster_num);
    b_ShiftRightImmediateWithDNTC(fp_table, _ONE, fp_table);
    b_IfEqualImm(fp_table, _ZERO) {
      break;
    }
  }
  $RELEASE(D_WorkFPTableBit);
  $RELEASE(D_WorkPacketSize);
}

/******************************************************************** PSL **
6.3 $B%7%s%0%k!&%Q%1%C%H$NAw?.(B

6.3.1 s_SendSinglePacket(packet_ptr, packet_size_reg, cluster_num_reg)
$BDL>o$N%Q%1%C%HAw?.(B

6.3.2 s_SendPacketWithoutPacketReclaim(packet_ptr, packet_size_reg, cluster_num_reg)
$BF10l%Q%1%C%H$rJ#?t$N%/%i%9%?$KAw?.$9$k>l9g!"O@M}%Q%1%C%H$r2s<}$7$J$$!#(B
$BA4$F$N%/%i%9%?$KAw?.$7$?;~$K2s<}$9$k!#(B

       written by ttakagi@icot22      on Fri Oct  5 10:56:50 1990

<Packet Format>
  PIM/s $B$G$NJ*M}%Q%1%C%H9=@.!J%7%s%0%k%Q%1%C%H!K(B

    +--------+----------------------------------+
  0 | DNTC   ! $B<+%/%i%9%?HV9f(B                   |
    +--------+----------------------------------+
  1 | DNTC   ! $BAj<j%/%i%9%?HV9f(B                 |
    +--------+----------------------------------+
  2 | INTo   ! $B%Q%1%C%HD9(B($B%o!<%I(B)               |
    +--------+----------------------------------+ \
  3 | DNTC   ! $B%a%C%;!<%8<oJL(B                   | |
    +--------+----------------------------------+ |
    |                                           | |
    /                                           / |
                [$B%a%C%;!<%8K\BN(B]                   > $BO@M}%Q%1%C%H(B
    /                                           / |
    |                                           | |
    +--------+----------------------------------+ /
    | EOLx   ! $B#E#O#M(B                           |
    +--------+----------------------------------+

<Arguments>
 packet_ptr:      $BO@M}%Q%1%C%H$X$N%]%$%s%?(B
 packet_size_reg: $BO@M}%Q%1%C%H$N%5%$%:(B
 cluster_num_reg: $BAw?.@h%/%i%9%?HV9f(B

<Explanation>
$B!&(Bs_SendPacketWithoutPacketReclaim $B$OAq1`$+$iN$?F$XDL?.$9$k$H$-$J$I!"(B
  $BF1$8%a%C%;!<%8$r0lEY$KJ#?tAw?.$9$k>l9g$K;HMQ$5$l$k!#(B
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkStatusFlag XXX
#DATA_define D_WorkPtrToPacketSuspRec XXX

#PSL_define s_SendSinglePacket(packet_ptr, packet_size_reg, cluster_num_reg)
{
  $USE(D_WorkStatusFlag);
  s_SendPacketWithoutPacketReclaim
              (packet_ptr, packet_size_reg, cluster_num_reg, D_WorkStatusFlag);
  b_IfNotEqualImm(D_WorkStatusFlag, _ONE) {
    s_ReclaimLogicalPacket(packet_ptr);
  } else {
    @DEBUG{ WARNING("s_SendSinglePacket","Network buffer FULL"); };
    s_PacketSuspend_Single(packet_ptr, packet_size_reg, cluster_num_reg);
  }
  $RELEASE(D_WorkStatusFlag);
}

#DATA_define D_WorkPacSize XXX

#PSL_define s_SendPacketWithoutPacketReclaim
              (packet_ptr, packet_size_reg, cluster_num_reg, status_reg)
{
  b_IfNetWorkBufferStatusOK(packet_size_reg) {
    /*** for Processor Profile ***/ /* $B%a%C%;!<%8<oJL$N%+%&%s%H(B */
    s_RecordMsgSendCountLogMsgType(packet_ptr);
    $USE(D_WorkCurrentPacketSlot);
    p_MoveWord(packet_ptr, D_WorkCurrentPacketSlot);
    b_IncrementAddrReg(D_WorkCurrentPacketSlot); /* CDESC$BJ,(B */
    b_SendMessageOneWord(D_CL_Number);
    b_SendMessageOneWord(cluster_num_reg);
    $USE(D_WorkPacSize);
    /* LogicalPacketSize + SinglePacketControlSize = SinglePacketSize */
    b_SubtractImmediateWithDNTC
      (packet_size_reg, _SINGLE_PACKET_CONTROL_SIZE, D_WorkPacSize);
/*    b_DecrementReg(D_WorkPacSize); */
    b_SetImmTypeMRBoff(INT, D_WorkPacSize);  /* SinglePacket -> INTo */
    b_SendMessageOneWord(D_WorkPacSize);
    $RELEASE(D_WorkPacSize);
    $USE(D_WorkCount);
    $USE(D_WorkSendData);
    b_SetImmValueDNTC(_ZERO, D_WorkCount);
    LOOP(){
      s_Get_1_Data_fromLogicalPacket(D_WorkCurrentPacketSlot, D_WorkSendData);
      b_SendMessageOneWord(D_WorkSendData);
      b_IncrementReg(D_WorkCount);
      b_IfEqual(D_WorkCount, packet_size_reg) { break; }
    }
    $RELEASE(D_WorkSendData);
    $RELEASE(D_WorkCount);
    $RELEASE(D_WorkCurrentPacketSlot);
    p_MoveWord(D_NULL, status_reg);
  } else {
    /* $B%M%C%H%o!<%/%P%C%U%!$,$"$U$l$?>l9g(B */
    p_MoveWord(D_ONE, status_reg);
    b_SetEventFlag(_NETWORK_BUFFER_FULL_EVENT, D_PE_Number);
  }
}

/******************************************************************** PSL **
6.4 $B%^%k%A%Q%1%C%H$NAw?.(B

s_SendMultiPacket(packet_ptr, cluster_num_reg,
                  packet_id_reg, packet_num_reg, packet_cnt_reg, last_size_reg)

       written by ttakagi@icot22      on Wed Oct  3 10:10:54 1990

<Packet Format>
  PIM/s $B$G$NJ*M}%Q%1%C%H9=@.(B($B%^%k%A%Q%1%C%H(B)

    +--------+----------------------------------+
  0 | DNTC   ! $B<+%/%i%9%?HV9f(B                   |
    +--------+----------------------------------+
  1 | DNTC   ! $BAj<j%/%i%9%?HV9f(B                 |
    +--------+----------------------------------+
  2 | INTx   ! $B%Q%1%C%HD9(B($B%o!<%I(B)               |
    +--------+----------------------------------+
  3 | DNTC   ! $B%Q%1%C%H#I#D(B($BHV9f(B)               |
    +--------+----------------------------------+
  4 | DNTC   ! $B%Q%1%C%HHV9f(B                     |
    +--------+----------------------------------+
  5 | DNTC   ! $B%H!<%?%k!&%Q%1%C%H?t(B             |
    +--------+----------------------------------+ \
    |                                           | |
    /                                           / |
             [$B%a%C%;!<%8K\BN$N0lIt(B]                > $BO@M}%Q%1%C%H$N0lIt(B
    /                                           / |
    |                                           | |
    +--------+----------------------------------+ /
    | EOLx   ! $B#E#O#M(B                           |
    +--------+----------------------------------+

<Arguments>
 packet_ptr: $BO@M}%Q%1%C%H$X$N%]%$%s%?(B (CDESC$B$r;X$7$F$$$k(B)
 packet_size_reg: $BO@M}%Q%1%C%H$N%G!<%?ItJ,$N%5%$%:(B($B%l%8%9%?(B)
 cluster_num_reg: $BAw$j@h%/%i%9%?HV9f(B($B%l%8%9%?(B)

<Explanation>
  $B%H!<%?%kO@M}%Q%1%C%HD9%9%m%C%H$N%?%0$,(B INTx $B$G$"$k$3$H$KCm0U!*(B

<ETC>
********************************************************************* PSL **/

#CONST_define _PHYSICAL_PACKET_SIZE_MAX     256
#CONST_define _SINGLE_PACKET_CONTROL_SIZE    -3
#CONST_define _SINGLE_PACKET_DATA_SIZE_MAX
              (_PHYSICAL_PACKET_SIZE_MAX + _SINGLE_PACKET_CONTROL_SIZE)
#CONST_define _MULTI_PACKET_CONTROL_SIZE     -6
#CONST_define _MULTI_PACKET_DATA_SIZE
              (_PHYSICAL_PACKET_SIZE_MAX + _MULTI_PACKET_CONTROL_SIZE)

#DATA_define D_WorkMultiPacketCount XXX
#DATA_define D_WorkMultiPacketNum   XXX
#DATA_define D_WorkPacketID         XXX
#DATA_define D_WorkMyClusterNum     XXX
#DATA_define D_WorkMultiPacketID    XXX
#DATA_define D_WorkMsgStatus        XXX
#DATA_define D_WorkPacketNum        XXX
#DATA_define D_WorkPacketTotalNum   XXX
#DATA_define D_WorkMsgData          XXX
#DATA_define D_WorkMultiPacketTop   XXX
#DATA_define D_WorkLastSize         XXX
#DATA_define D_WorkContPacketSize   XXX
#DATA_define D_WorkSlotOffset       XXX

#PSL_define s_SendMultiPacket(packet_ptr, cluster_num_reg,
            packet_id_reg, packet_num_reg, packet_cnt_reg, last_size_reg)
{
  /*** $B3F%Q%1%C%H$K=q$-9~$`%a%C%;!<%8!&%X%C%@!<$r=`Hw$9$k(B ***/
  /* $B%a%C%;!<%8D9%9%m%C%H$N(B MRB $B$r(B ON $B$K$9$k(B == $B%^%k%A%Q%1%C%H(B */
  $USE(D_WorkMyClusterNum);
  b_MoveWithImmTypeMRBoff(D_CL_Number, DNTC, D_WorkMyClusterNum);
  b_SetImmTypeMRBoff(DNTC, cluster_num_reg);
  $USE(D_WorkContPacketSize);
  b_SetImmTypeValueMRBon(INT, _PHYSICAL_PACKET_SIZE_MAX, D_WorkContPacketSize);

  /*** $B%Q%1%C%H$X$N%]%$%s%?$rA\$9(B ***/
  $USE(D_WorkCurrentPacketSlot);
  p_MoveWord(packet_ptr, D_WorkCurrentPacketSlot);
  b_IncrementAddrReg(D_WorkCurrentPacketSlot); /* CDESC $B$NJ,(B */
  $USE(D_WorkSlotOffset);
  b_SubtractImmediateWithDNTC
            (packet_cnt_reg, _ONE, D_WorkSlotOffset);
  b_MultiplyImmediateWithDNTC
            (D_WorkSlotOffset, _MULTI_PACKET_DATA_SIZE, D_WorkSlotOffset);
  b_ExchangeElmposToOffset(D_WorkSlotOffset,D_WorkSlotOffset);
  b_AddWithDNTC
        (D_WorkCurrentPacketSlot,D_WorkSlotOffset,D_WorkCurrentPacketSlot);
  $RELEASE(D_WorkSlotOffset);

  /*** $B3F%Q%1%C%H$NAw?.(B ***/
  $USE(D_WorkSendData);
  LOOP() {
    b_IfNetWorkBufferStatusOK(D_WorkContPacketSize){ 
      /*** for Processor Profile ***/
      s_RecordMultiPacketSendCountNumberOfPackets();
      /*** $B<+%/%i%9%?HV9f$rAw?.(B ***/
      b_SendMessageOneWord(D_WorkMyClusterNum);
      /*** $BAj<j%/%i%9%?HV9f$NAw?.(B ***/
      b_SendMessageOneWord(cluster_num_reg);
      /*** $B%Q%1%C%HD9$rAw?.(B ***/
      b_IfNotEqual(packet_cnt_reg, packet_num_reg) {
	b_SendMessageOneWord(D_WorkContPacketSize);
      } else {
	b_SendMessageOneWord(last_size_reg);
      }
      /*** $B%Q%1%C%H#I#D$rAw?.(B ***/
      b_SendMessageOneWord(packet_id_reg);
      /*** $B%Q%1%C%HHV9f$NAw?.(B ***/
      b_SendMessageOneWord(packet_cnt_reg);
      /*** $B%H!<%?%k!&%Q%1%C%H?t$NAw?.(B ***/
      b_SendMessageOneWord(packet_num_reg);
      /*** $B#1%Q%1%C%H$NMWAG?t$N%+%&%s%?(B ***/
      $USE(D_WorkCount);
      b_SetImmValueDNTC(_ZERO, D_WorkCount);
      /*** $B3FMWAG$NAw?.(B ***/
      LOOP() {
	s_Get_1_Data_fromLogicalPacket(D_WorkCurrentPacketSlot,D_WorkSendData);
	b_IfEOM(D_WorkSendData) { break; }
	b_SendMessageOneWord(D_WorkSendData);
	b_IncrementReg(D_WorkCount);
	b_IfEqualImm(D_WorkCount, _MULTI_PACKET_DATA_SIZE) { break; }
      }
      $RELEASE(D_WorkCount);
      /*** $B#E#O#M$NAw?.(B ***/
      b_SendMessageOneWord(D_EOM_REG);

      b_IncrementReg(packet_cnt_reg);
      b_IfGreater(packet_cnt_reg, packet_num_reg) { break; }
    } else {
      @DEBUG{
	WARNING("s_SendMultiPacket","Send packet multi Suspended");
      };
      $USE(D_WorkPtrToPacketSuspRec);
      s_AllocPacketSuspRec(D_WorkPtrToPacketSuspRec);
      s_PutSuspPacketID_PacketSuspRec
                      (_PACKET_SUSP_MULTI,D_WorkPtrToPacketSuspRec);
      p_SetImmediateType(INT,cluster_num_reg);
      s_PutPacketInfo1_PacketSuspRec
	              (cluster_num_reg, D_WorkPtrToPacketSuspRec);
      p_SetImmediateType(INT,packet_id_reg);
      s_PutPacketInfo2_PacketSuspRec
	              (packet_id_reg, D_WorkPtrToPacketSuspRec);
      p_SetImmediateType(INT,last_size_reg);
      s_PutPacketInfo3_PacketSuspRec
	              (last_size_reg, D_WorkPtrToPacketSuspRec);
      p_SetImmediateType(INT,packet_cnt_reg);
      s_PutPacketInfo4_PacketSuspRec
	              (packet_cnt_reg, D_WorkPtrToPacketSuspRec);
      p_SetImmediateType(INT,packet_num_reg);
      s_PutPacketInfo5_PacketSuspRec
	              (packet_num_reg, D_WorkPtrToPacketSuspRec);
      s_PutPacketInfo6_PacketSuspRec
	              (packet_ptr, D_WorkPtrToPacketSuspRec);
      s_PushPacketSuspRec(D_WorkPtrToPacketSuspRec);
      $RELEASE(D_WorkPtrToPacketSuspRec);
      b_SetEventFlag(_NETWORK_BUFFER_FULL_EVENT,D_PE_Number);
      goto SUSP_LABEL;
    }
  }
  /*** $BO@M}%Q%1%C%H$N2s<}(B ***/
  s_ReclaimLogicalPacket(packet_ptr);
 SUSP_LABEL:
  $RELEASE(D_WorkContPacketSize);
  $RELEASE(D_WorkSendData);
  $RELEASE(D_WorkMyClusterNum);
  $RELEASE(D_WorkCurrentPacketSlot);

  @DEBUG{
    WARNING("s_SendMultiPacket","Send multi packet");
  };
}

/******************************************************************** PSL **
6.5 $B%^%k%A%Q%1%C%H$K$7$?;~$N%Q%1%C%H?t$r7W;;$9$k(B

s_GetPacketTotalNum

       written by ttakagi@icot22      on Thu Feb 14 17:10:57 1991

<Arguments>
+ packet_size_reg: $BO@M}%Q%1%C%H$N%5%$%:(B($B%l%8%9%?(B)
- packet_num_reg:  $B%Q%1%C%H$NAm?t(B($B%l%8%9%?(B)
- modulo_reg:      $B:G8e$N%Q%1%C%H$N%5%$%:(B($B%l%8%9%?(B)

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkModulo           XXX

#PSL_define s_GetPacketTotalNum(packet_size_reg, packet_num_reg, modulo_reg)
{
  b_DivideImmediateWithDNTC
	(packet_size_reg, _MULTI_PACKET_DATA_SIZE, packet_num_reg);
  b_ModuloImmediateWithDNTC
	(packet_size_reg, _MULTI_PACKET_DATA_SIZE, modulo_reg);
  b_IfNotZero(modulo_reg) {
    b_IncrementReg(packet_num_reg);
    b_SubtractImmediateWithTag
	(modulo_reg, _MULTI_PACKET_CONTROL_SIZE, modulo_reg);
    /* _MULTI_PACKET_CONTROL_SIZE$B$r2C$($?$$$N$G$"$k$,!"Ii$N?t$J$N$G(B
       $B0z$-;;$r$7$F$$$k!#(B */
    b_DecrementReg(modulo_reg);
    /* EOM$B$NJ,$r#1$DM>J,$KB-$7$F$7$^$&$N$G!"$3$3$G(B $B#1(B $B0z$$$F$*$/!#(B */
    b_SetImmTypeMRBon(INT, modulo_reg);
    /* $B%^%k%A%Q%1%C%H$N%Q%1%C%HD9$O(B INTx $B$K$9$k!#(B */
  } else {
    b_SetImmTypeValueMRBon(INT, _PHYSICAL_PACKET_SIZE_MAX, modulo_reg);
  }
/*  b_SetImmTypeMRBoff(DNTC, packet_num_reg); */
}

/******************************************************************** PSL **
7. $B%Q%1%C%H$N<u?.(B

7.1 s_ReceivePacket(packet_ptr)

       written by nakase@icot22      on Thu Jun 14 10:44:03 1990

<Arguments>
  packet_ptr: $B%a%b%j>e$KE83+$5$l$?%Q%1%C%H$X$N%]%$%s%?(B

<Function>
  $B<u?.$7$?%Q%1%C%H$r%a%b%j>e$KE83+$7$?$b$N$X$N%]%$%s%?$r(Bpacket_ptr$B$KJV$9!#(B
  $B%Q%1%C%H$,L5$$>l9g$O!"(Bpacket_ptr $B$K(B D_NULL $B$r%;%C%H$9$k!#(B

<Explanation>
  $BN/$C$F$$$k%a%C%;!<%8$9$Y$F$rFI$`(B

<ETC>
********************************************************************* PSL **/

#DATA_define	D_WorkCurrentPacketTop	XXX
#DATA_define	D_WorkPacketLength	XXX
#DATA_define	D_WorkStatusReg		XXX
#DATA_define    D_WorkSenderClNum       XXX
#DATA_define    D_WorkReceiverClNum     XXX

#PSL_define s_ReceivePacket(packet_ptr)
{
  $USE(D_WorkSenderClNum);
  $USE(D_WorkStatusReg);
  b_ReceiveMessageOneWord(D_WorkSenderClNum, D_WorkStatusReg);
  b_IfMessageStatusOK(D_WorkStatusReg) {
    $USE(D_WorkReceiverClNum);
    b_ReceiveMessageOneWord(D_WorkReceiverClNum, D_WorkStatusReg);
    @DEBUG{
      b_IfNotEqual(D_WorkReceiverClNum, D_CL_Number) {
	VPIM_ERROR("s_ReceivePacket",
		   "The message to different cluster has received");
      }
    };
    $RELEASE(D_WorkReceiverClNum);
    $USE(D_WorkPacketLength);
    b_ReceiveMessageOneWord(D_WorkPacketLength, D_WorkStatusReg);
    s_IfMRBoff(D_WorkPacketLength) {
      s_ReceiveSinglePacket(packet_ptr, D_WorkPacketLength);
    } else {
      s_ReceiveMultiPacket(packet_ptr, D_WorkSenderClNum, D_WorkPacketLength);
    }
    $RELEASE(D_WorkPacketLength);
  } else {
    p_MoveWord(D_NULL, packet_ptr);
  }
  $RELEASE(D_WorkSenderClNum);
  $RELEASE(D_WorkStatusReg);
}

/******************************************************************** PSL **
7.2 $B%7%s%0%k!&%Q%1%C%H$N<u?.(B

       written by ttakagi@icot22      on Fri Oct  5 16:03:37 1990

<Arguments>
 packet_ptr:      $BO@M}%Q%1%C%H$X$N%]%$%s%?(B DST
 packet_size_reg: $B%Q%1%C%H!&%5%$%:!J%l%8%9%?!K(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $B%M%C%H%o!<%/$+$i%a%C%;!<%8$r#1%o!<%I$E$DFI$_$H$j!"O@M}%Q%1%C%H$K(B
  $B=q$-9~$s$G$$$/!#(B

<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkReceivedPacketData XXX

#PSL_define s_ReceiveSinglePacket(packet_ptr, packet_size_reg)
{
  $USE(D_WorkPacSize);
  b_AddImmediateWithDNTC
	(packet_size_reg, _SINGLE_PACKET_CONTROL_SIZE, D_WorkPacSize);
  b_IncrementReg(D_WorkPacSize);		/* EOM$BJ,(B */
  s_AllocLogicalPacket(D_WorkPacSize, packet_ptr);
  $USE(D_WorkCurrentPacketTop);
  s_GetCurrentPacketPtr(packet_ptr, D_WorkCurrentPacketTop);
  $USE(D_WorkReceivedPacketData);
  LOOP(){
    b_ReceiveMessageOneWord(D_WorkReceivedPacketData, D_VOID);
    s_Put_1_Data_inLogicalPacket
      (D_WorkCurrentPacketTop, D_WorkReceivedPacketData);
    b_IfEOM(D_WorkReceivedPacketData) { break; }
  }
  $RELEASE(D_WorkPacSize);
  $RELEASE(D_WorkReceivedPacketData);
  $RELEASE(D_WorkCurrentPacketTop);
}

/******************************************************************** PSL **
7.3 $B%^%k%A!&%Q%1%C%H$N<u?.(B

       written by ttakagi@icot22      on Fri Oct  5 16:04:22 1990

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
$B!&E~Ce$7$?%Q%1%C%H$rFI$_$H$k!#(B
$B!&%Q%1%C%H#I#D$r8+$F!"%^%k%A%Q%1%C%H%l%3!<%I$rC5$9!#(B
  $B8+$D$+$i$J$1$l$P(B $B@8@.$7$F!"%^%k%A%Q%1%C%H$N%j%s%/$K(B push $B$9$k!#(B
$B!&%^%k%A%Q%1%C%H%l%3!<%I$K7R$,$C$F$$$kO@M}%Q%1%C%H$X!"FI$_$H$C$?%Q%1%C%H$N(B
  $BFbMF(B($B%G!<%?ItJ,$N$_(B)$B$r=q$-9~$`!#(B
$B!&%a%C%;!<%8$,A4$FE~Ce$7$?>l9g$O!"(B
  $B%^%k%A%Q%1%C%H%l%3!<%I$K$D$J$,$l$?%Q%1%C%H$+$i!"O@M}%Q%1%C%H$X$N%]%$%s%?$r(B
  $B%a%C%;!<%8$N%G%#%9%Q%C%A%c$KEO$9!#(B
$B!&%a%C%;!<%8$,L$40@.$N>l9g$O!"(B
  packet_ptr $B$K(B EOLx $B$rJV$9!#!J$3$NJ}K!$O1x$$$+$bCN$l$J$$!K(B

<Examples>
<Test>
<Explanation>

   +----------------+    +-------------------+          +-------------------+
   | MultiPacketTop |--->| MultiPacketRecord |-- ... -->| MultiPacketRecord |
   +----------------+    /                   /          /                   /
                         |                   |          |                   |
                         +-------------------+          +-------------------+
                         | ptr_to_packet     |-+        | ptr_to_packet     |-+
                         +-------------------+ |        +-------------------+ |
                           +---------------+   |          +---------------+   |
                           | LogicalPacket |<--+          | LogicalPacket |<--+
                           /               /              /               /
                           |               |              |               |
                           +---------------+              +---------------+

<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkMultiPacketRec   XXX
#DATA_define D_WorkLogicalPacketPtr XXX
#DATA_define D_WorkLogicalPacketLen XXX
#DATA_define D_WorkMultiLogicalPacketPtr XXX
#DATA_define D_WorkPacketData XXX

#PSL_define s_ReceiveMultiPacket(packet_ptr, cluster_num_reg, packet_size_reg)
{
  /*** for Processor Profile ***/
  s_RecordMultiPacketRecvCountNumberOfPackets();

  $USE(D_WorkMsgStatus);
  $USE(D_WorkPacketID);
  /*** s_ReceivePacket $B$G%a%C%;!<%8D9$^$GFI$s$G$$$k(B ***/
  /*** $B%Q%1%C%H#I#D$rFI$_$H$k(B ***/
  b_ReceiveMessageOneWord(D_WorkPacketID, D_WorkMsgStatus);
  $USE(D_WorkPacketNum);
  /*** $B%Q%1%C%HHV9f$rFI$_$H$k(B ***/
  b_ReceiveMessageOneWord(D_WorkPacketNum, D_WorkMsgStatus);
  $USE(D_WorkPacketTotalNum);
  /*** $B%Q%1%C%HAm?t$rFI$_$H$k(B ***/
  b_ReceiveMessageOneWord(D_WorkPacketTotalNum, D_WorkMsgStatus);
  $RELEASE(D_WorkMsgStatus);
  
  $USE(D_WorkMultiPacketTop);
  s_SoftLockMultiPacketTop(D_WorkMultiPacketTop);
  $USE(D_WorkMultiPacketRec);
  /*** $B%Q%1%C%H#I#D$HAw?.%/%i%9%?HV9f$+$i%Q%1%C%H%l%3!<%I$r$5$,$9(B.   ***
   *** $B8+$D$+$i$J$+$C$?>l9g$O!"(BD_WorkMultiPacketRec $B$K(B D_NULL $B$,JV$k(B ***/
  s_FindMultiPacketRecord
    (D_WorkMultiPacketTop,D_WorkPacketID,cluster_num_reg,D_WorkMultiPacketRec);
  b_IfIllegalPointer(D_WorkMultiPacketRec) {
  /*** $B%Q%1%C%H%l%3!<%I$,8+$D$+$i$J$+$C$?>l9g(B ***/
    s_AllocMultiPacketRecord(D_WorkMultiPacketRec, D_WorkPacketTotalNum);
    s_PutPacketID_inMultiPacketRecord(D_WorkMultiPacketRec, D_WorkPacketID);
    s_PutClNum_inMultiPacketRecord(D_WorkMultiPacketRec, cluster_num_reg);
    s_PutTotalPacketNum_inMultiPacketRecord
                        (D_WorkMultiPacketRec, D_WorkPacketTotalNum);
    s_PushMultiPacketRecord(D_WorkMultiPacketTop, D_WorkMultiPacketRec);
    $USE(D_WorkLogicalPacketPtr);
    s_MakeSeparateLogicalPacket_PutMultiPacketData
                                (D_WorkLogicalPacketPtr, packet_size_reg);
    s_PutLogicalPacket_inMultiPacketRecord
               (D_WorkMultiPacketRec, D_WorkPacketNum, D_WorkLogicalPacketPtr);
    $RELEASE(D_WorkLogicalPacketPtr);
    s_IncrementPacketCount(D_WorkMultiPacketRec);
    b_MoveWithMRBon(D_NULL, packet_ptr);
  } else {
  /*** $B%Q%1%C%H%l%3!<%I$,8+$D$+$C$?>l9g(B ***/
    $USE(D_WorkLogicalPacketPtr);
    s_MakeSeparateLogicalPacket_PutMultiPacketData
                                (D_WorkLogicalPacketPtr, packet_size_reg);
    s_PutLogicalPacket_inMultiPacketRecord
               (D_WorkMultiPacketRec, D_WorkPacketNum, D_WorkLogicalPacketPtr);
    $RELEASE(D_WorkLogicalPacketPtr);
    s_IncrementPacketCount(D_WorkMultiPacketRec);
    $USE(D_WorkCount);
    s_GetPacketCount_fromMultiPacketRecord(D_WorkMultiPacketRec, D_WorkCount);
    b_IfEqual(D_WorkCount, D_WorkPacketTotalNum) {
      s_PopMultiPacketRecord(D_WorkMultiPacketTop, D_WorkMultiPacketRec);
      s_MakeLogicalPacket_fromSeparateLogicalPacket
	              (packet_ptr, D_WorkMultiPacketRec, D_WorkPacketTotalNum);
    } else {
      b_MoveWithMRBon(D_NULL, packet_ptr);
    }
    $RELEASE(D_WorkCount);
  }

  s_SoftUnlockMultiPacketTop(D_WorkMultiPacketTop);

  $RELEASE(D_WorkMultiPacketRec);
  $RELEASE(D_WorkMultiPacketTop);
  $RELEASE(D_WorkPacketTotalNum);
  $RELEASE(D_WorkPacketNum);
  $RELEASE(D_WorkPacketID);
}

/******************************************************************** PSL **
7.4 $B%^%k%A%Q%1%C%H$N%G!<%?$rJ,3dO@M}%Q%1%C%H$K=q$-9~$`(B

s_MakeSeparateLogicalPacket_PutMultiPacketData

       written by ttakagi@icot22      on Tue Oct  9 16:08:30 1990

<Arguments>
 logical_packet_ptr:
 packet_size_reg:

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_MakeSeparateLogicalPacket_PutMultiPacketData
                                    (logical_packet_ptr, packet_size_reg)
{
  $USE(D_WorkPacSize);
  b_AddImmediateWithDNTC
          (packet_size_reg, _MULTI_PACKET_CONTROL_SIZE, D_WorkPacSize);
  b_IncrementReg(D_WorkPacSize); /* EOM$BJ,(B */
  s_AllocLogicalPacket(D_WorkPacSize, logical_packet_ptr);
  $RELEASE(D_WorkPacSize);
  $USE(D_WorkCurrentPacketPtr);
  p_MoveWord(logical_packet_ptr, D_WorkCurrentPacketPtr);
  b_IncrementReg(D_WorkCurrentPacketPtr); /* CDESC $BMQ(B */
  $USE(D_WorkMsgData);
  LOOP() {
    b_ReceiveMessageOneWord(D_WorkMsgData, D_VOID);
    s_Put_1_Data_inLogicalPacket(D_WorkCurrentPacketPtr, D_WorkMsgData);
    b_IfEOM(D_WorkMsgData) { break; }
  }
  $RELEASE(D_WorkMsgData);
  $RELEASE(D_WorkCurrentPacketPtr);
}

/******************************************************************** PSL **
7.5 $B%^%k%A%Q%1%C%H%l%3!<%I$K7R$,$C$F$$$kJ,3dO@M}%Q%1%C%H$r9g$o$;$F(B
    $B#1$D$NO@M}%Q%1%C%H$r9=@.$9$k(B

s_MakeLogicalPacket_fromSeparateLogicalPacket

       written by ttakagi@icot22      on Thu Dec 27 14:31:57 1990

<Arguments>
 logical_packet_ptr:   $BO@M}%Q%1%C%H$X$N%]%$%s%?(B($B=PNO(B)
 packet_rec_ptr:       $B%^%k%A%Q%1%C%H%l%3!<%I$X$N%]%$%s%?(B
 total_packet_num_reg: $B%Q%1%C%H$NAm?t(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkNumCount XXX

#PSL_define s_MakeLogicalPacket_fromSeparateLogicalPacket
               (logical_packet_ptr, packet_rec_ptr, total_packet_num_reg)
{
  /*** for Processor Profile ***/
  s_RecordMultiPacketRecvCountNumberOfMessages();

  $USE(D_WorkLogicalPacketLen);
  b_SetImmValueDNTC(_MULTI_PACKET_DATA_SIZE, D_WorkLogicalPacketLen);
  b_MultiplyWithDNTC
        (D_WorkLogicalPacketLen, total_packet_num_reg, D_WorkLogicalPacketLen);
  s_AllocLogicalPacket(D_WorkLogicalPacketLen, logical_packet_ptr);
  $RELEASE(D_WorkLogicalPacketLen);

  b_IfNotIllegalPointer(logical_packet_ptr) {
    $USE(D_WorkLogicalPacketPtr);
    p_MoveWord(logical_packet_ptr, D_WorkLogicalPacketPtr);
    b_IncrementAddrReg(D_WorkLogicalPacketPtr); /* CDESC $BMQ(B */
    $USE(D_WorkNumCount);
    b_SetImmValueDNTC(_ZERO, D_WorkNumCount);
    LOOP() {
      b_IfEqual(D_WorkNumCount, total_packet_num_reg) { break; }
      $USE(D_WorkMultiLogicalPacketPtr);
      s_GetLogicalPacket_fromMultiPacketRecord
	  (packet_rec_ptr, D_WorkNumCount, D_WorkMultiLogicalPacketPtr);
      b_IncrementAddrReg(D_WorkMultiLogicalPacketPtr); /* CDESC $BMQ(B */
      $USE(D_WorkPacketData);
      LOOP() {
	s_Get_1_Data_fromLogicalPacket
	    (D_WorkMultiLogicalPacketPtr, D_WorkPacketData);
	b_IfEOM(D_WorkPacketData) { break; }
	s_Put_1_Data_inLogicalPacket
	    (D_WorkLogicalPacketPtr, D_WorkPacketData);
      }
      $RELEASE(D_WorkPacketData);
      $RELEASE(D_WorkMultiLogicalPacketPtr);
      b_IncrementReg(D_WorkNumCount);
    }
    $RELEASE(D_WorkNumCount);
    $RELEASE(D_WorkLogicalPacketPtr);
    s_ReclaimMultiPacketRecord(packet_rec_ptr);
  } else {
    /* $BO@M}%Q%1%C%HAH$_N)$F=hM}$N%5%9%Z%s%I(B */
    $USE(D_WorkPtrToMsgSuspRec);
    s_AllocMsgSuspRec(D_WorkPtrToMsgSuspRec);
    s_PutSuspMsgID_MsgSuspRec
                   (_MSG_SUSP_MAKE_MULTI_PACKET, D_WorkPtrToMsgSuspRec);
    s_PutMsgInfo1_MsgSuspRec(packet_rec_ptr, D_WorkPtrToMsgSuspRec);
    s_PutMsgInfo2_MsgSuspRec(D_NULL, D_WorkPtrToMsgSuspRec); /* $BG0$N$?$a(B */
    s_PushMsgSuspRec(D_WorkPtrToMsgSuspRec);
    $RELEASE(D_WorkPtrToMsgSuspRec);
    @DEBUG{ WARNING("s_MakeLogicalPacket_fromSeparateLogicalPacket",
		    "Message Suspend"); };
  }

  @DEBUG{
    WARNING("s_MakeLogicalPacket_fromSeparateLogicalPacket",
	    "Receive multi packet");
  };
}

/******************************************************************** PSL **
8. $B<u?.$7$?%Q%1%C%H$N%A%'%C%/(B

s_IfCompletePacket(packet_ptr)

       written by nakase@icot22      on Wed Jun 27 12:28:10 1990

<Arguments>
 packet_ptr: $B<u?.$7$?%Q%1%C%H$X$N%]%$%s%?(B
             $B%Q%1%C%H$,L$40@.$N$H$-$O!"(BEOLx $B$,$/$k!#(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B<u?.$7$?%Q%1%C%H$N%A%'%C%/!#(B

  $B<u?.$7$?%Q%1%C%H$N<oN`$K$h$C$F!"8e$N=hM}$,0[$J$k!#(B
  (1) $B%7%s%0%k%Q%1%C%H(B                  ------>    $B%a%C%;!<%8<u?.=hM}(B   
  (2) $B%^%k%A%Q%1%C%H!J%Q%1%C%H40@.!K(B    ------>    $B%^%k%A%Q%1%C%H%G%3!<%I=hM}(B
                                                    & $B%a%C%;!<%8<u?.=hM}(B
  (3) $B%^%k%A%Q%1%C%H!J%Q%1%C%HL$40@.!K(B  ------>    $B%^%k%A%Q%1%C%H<u?.$N(B
                                                   $B%5%9%Z%s%I%5%9%Z%s%I=hM}(B

  (1),(2)$B$N;~$O!"(BCC=EQ$B!"(B(3)$B$N;~$O!"(BCC=NE
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define s_IfCompletePacket(packet_ptr)
{
  s_IfMRBon(packet_ptr) {
    b_IfEOL(packet_ptr) {
      b_SetFail();
    } else {
      @DEBUG{ VPIM_ERROR("s_IfCompletePacket","Invalid packet ptr"); };
    }
  } else {
    @DEBUG{
      s_IfNotSTRG(packet_ptr) {
	VPIM_ERROR("s_IfCompletePacket","Packet ptr is not STRG");
      }
    };
    b_SetSuccess();
  }
  b_IfSuccess()
}
