/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/structures/str_int_cl_multi_packet_rec.psl.c
   ----- CREATED   : by ttakagi@icot22, on Fri Oct  5 11:23:28 1990
   ----- LAST SAVED: by ttakagi@icot22, on Tue Mar  3 15:12:28 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 

1. $B%^%k%A!&%Q%1%C%H!&%l%3!<%I$N@8@.(B
2. $B%^%k%A!&%Q%1%C%H!&%l%3!<%I$N2s<}(B
3. $B%^%k%A!&%Q%1%C%H!&%l%3!<%I$X$NA`:n(B
4. $B%^%k%A!&%Q%1%C%H!&%l%3!<%I$N(B push, pop, find
5.$B!JAw?.;~$N!K%^%k%A%Q%1%C%H#I#D$N@8@.(B
6. $B!J<u?.;~$N!K%^%k%A%Q%1%C%H%H%C%W$KBP$9$kA`:n(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
1. $B%^%k%A!&%Q%1%C%H!&%l%3!<%I$N@8@.(B

       written by ttakagi@icot22      on Fri Oct  5 11:23:37 1990

<Record Format>

    +-----------+----------------------------------+
    | INT       ! $B%Q%1%C%H#I#D(B                     |
    +-----------+----------------------------------+
    | INT       ! $BAw?.B&$N%/%i%9%?HV9f(B             |
    +-----------+----------------------------------+
    | INT       ! $B%Q%1%C%H?t(B                       |
    +-----------+----------------------------------+
    | INT       ! $B<u$1<h$C$?%Q%1%C%H$N?t(B($B%+%&%s%?(B) |
    +-----------+----------------------------------+
    | VECT6/EOL ! $B<!%l%3!<%I$X$N%]%$%s%?(B           |
    +-----------+----------------------------------+
    | STRG      ! $B%Q%1%C%H$X$N%]%$%s%?(B $B#0HV(B        |
    +-----------+----------------------------------+
    |                                              |
    /                                              /

    /                                              /
    |                                              |
    +-----------+----------------------------------+
    | STRG      ! $B%Q%1%C%H$X$N%]%$%s%?(B n$BHV(B         |
    +-----------+----------------------------------+

<Arguments>
- ptr_to_rec: $B%^%k%A%Q%1%C%H%l%3!<%I$X$N%]%$%s%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CONST_define _MULTI_PACKET_REC_CONTROL_SIZE  5

#DATA_define D_WorkPacketRecSize  XXX
#DATA_define D_WorkMultiPacketCnt XXX
#DATA_define D_WorkPacketRecSlot  XXX

#PSL_define s_AllocMultiPacketRecord(ptr_to_rec, total_packet_num)
{
  $USE(D_WorkPacketRecSize);
  p_MoveWord(total_packet_num, D_WorkPacketRecSize);
  p_AddImmediate
    (D_WorkPacketRecSize, _MULTI_PACKET_REC_CONTROL_SIZE, D_WorkPacketRecSize);
  ValueSwitch(D_WorkPacketRecSize) {
  case 6: s_AllocVect6(ptr_to_rec); break;
  case 7: s_AllocVect7(ptr_to_rec); break;
  case 8: s_AllocVect8(ptr_to_rec); break;
  default:  $CALL( s_AllocLongVect_Sub(D_WorkPacketRecSize, ptr_to_rec) );
            break;
  }
  $USE(D_WorkMultiPacketCnt);
  b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkMultiPacketCnt);
  /* $B<u?.%Q%1%C%H?t$N%+%&%s%?$r(B 0 $B$K$7$F$*$/(B */
  s_PutPacketCount_inMultiPacketRecord(ptr_to_rec, D_WorkMultiPacketCnt);
  $RELEASE(D_WorkMultiPacketCnt);
  /* $B<!$N%^%k%A%Q%1%C%H%l%3!<%I$X$N%]%$%s%?$r(B D_NULL $B$K$9$k(B($BG0$N$?$a(B) */
  s_PutNextLink_inMultiPacketRecord(ptr_to_rec, D_NULL);
  /* $B%^%k%A%Q%1%C%H<u?.$NESCf$G(BGC$B$,5/$3$C$?>l9g$KHw$($F%9%m%C%H$r=i4|2=(B */
  $USE(D_WorkPacketRecSlot);
  b_SetImmValueDNTC(_LOGICAL_PACKET_MULTI_PACKET_REC_POS, D_WorkPacketRecSlot);
  LOOP() {
    s_PutVectElementPosReg(ptr_to_rec, D_WorkPacketRecSlot, D_NULL);
    b_IncrementReg(D_WorkPacketRecSlot);
    b_IfEqual(D_WorkPacketRecSlot, D_WorkPacketRecSize) { break; }
  }
  $RELEASE(D_WorkPacketRecSlot);
  $RELEASE(D_WorkPacketRecSize);
}

/* $B%^%k%A%Q%1%C%H%l%3!<%I$N3F%9%m%C%H$N0LCV(B */
#CONST_define         _PACKET_ID_MULTI_PACKET_REC_POS  0
#CONST_define            _CL_NUM_MULTI_PACKET_REC_POS  1
#CONST_define  _TOTAL_PACKET_NUM_MULTI_PACKET_REC_POS  2
#CONST_define        _PACKET_CNT_MULTI_PACKET_REC_POS  3
#CONST_define         _NEXT_LINK_MULTI_PACKET_REC_POS  4
#CONST_define    _LOGICAL_PACKET_MULTI_PACKET_REC_POS  5

/******************************************************************** PSL **
2. $B%^%k%A!&%Q%1%C%H!&%l%3!<%I$N2s<}(B

       written by ttakagi@icot22      on Fri Oct  5 11:41:10 1990

<Arguments>
+ ptr_to_rec: $B%^%k%A%Q%1%C%H%l%3!<%I$X$N%]%$%s%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkTotalPacketNum XXX

#PSL_define s_ReclaimMultiPacketRecord(ptr_to_rec)
{
  /* MultiPacketRecord$B$,Jz$($F$$$kO@M}%Q%1%C%H$r2s<}$9$k(B */
  $USE(D_WorkTotalPacketNum);
  s_GetTotalPacketNum_fromMultiPacketRecord(ptr_to_rec, D_WorkTotalPacketNum);
  $USE(D_WorkNumCount);
  b_SetImmValueDNTC(_ZERO, D_WorkNumCount);
  LOOP() {
    $USE(D_WorkMultiLogicalPacketPtr);
    s_GetLogicalPacket_fromMultiPacketRecord
      (ptr_to_rec, D_WorkNumCount, D_WorkMultiLogicalPacketPtr);
    s_ReclaimLogicalPacket(D_WorkMultiLogicalPacketPtr);
    $RELEASE(D_WorkMultiLogicalPacketPtr);
    b_IncrementReg(D_WorkNumCount);
    b_IfEqual(D_WorkNumCount, D_WorkTotalPacketNum) { break; }
  }
  $RELEASE(D_WorkNumCount);
  $RELEASE(D_WorkTotalPacketNum);
  /* MultiPacketRecord$B<+BN$N2s<}(B */
  TypeSwitch(ptr_to_rec) {
  case VECT6: 
  case VECT7: 
  case VECT8:
    s_ReclaimShortVector(ptr_to_rec);
    break;
  case VECT: 
    $USE(D_WorkVectSize);
    s_GetSizeLongVect(ptr_to_rec, D_WorkVectSize);
    s_ReclaimLongVector(D_WorkVectSize, ptr_to_rec);
    $RELEASE(D_WorkVectSize);
    break;
  default:
    @DEBUG {
      VPIM_ERROR("s_ReclaimMultiPacketRecord",
		 "Illegal Type MultiPacketRecPtr");
    };
    break;
  }
}

/******************************************************************** PSL **
3. $B%^%k%A!&%Q%1%C%H!&%l%3!<%I$X$NA`:n(B

       written by ttakagi@icot22      on Fri Oct  5 11:45:17 1990

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
$B!&3F%9%m%C%H$+$i$N%G!<%?$NFI$_=P$7$H!"3F%9%m%C%H$X$N%G!<%?$N=q$-9~$_(B
$B!&<u?.%Q%1%C%H?t%+%&%s%?$N%$%s%/%j%a%s%HA`:n(B

<ETC>
********************************************************************* PSL **/

#PSL_define s_GetPacketID_fromMultiPacketRecord(ptr_to_rec, dst_reg)
{
  p_ReadWithOffset(ptr_to_rec, _PACKET_ID_MULTI_PACKET_REC_POS, dst_reg);
}

#PSL_define s_GetClNum_fromMultiPacketRecord(ptr_to_rec, dst_reg)
{
  p_ReadWithOffset(ptr_to_rec, _CL_NUM_MULTI_PACKET_REC_POS, dst_reg);
}

#PSL_define s_GetTotalPacketNum_fromMultiPacketRecord(ptr_to_rec, dst_reg)
{
  p_ReadWithOffset
    (ptr_to_rec, _TOTAL_PACKET_NUM_MULTI_PACKET_REC_POS, dst_reg);
}

#PSL_define s_GetPacketCount_fromMultiPacketRecord(ptr_to_rec, dst_reg)
{
  p_ReadWithOffset(ptr_to_rec, _PACKET_CNT_MULTI_PACKET_REC_POS, dst_reg);
}

#PSL_define s_GetNextLink_fromMultiPacketRecord(ptr_to_rec, dst_reg)
{
  p_ReadWithOffset(ptr_to_rec, _NEXT_LINK_MULTI_PACKET_REC_POS, dst_reg);
}

#DATA_define D_WorkPos XXX

#PSL_define s_GetLogicalPacket_fromMultiPacketRecord
                                        (ptr_to_rec, pos_reg, dst_reg)
{
  $USE(D_WorkPos);
  p_MoveWord(pos_reg, D_WorkPos);
  p_AddImmediate(D_WorkPos, _LOGICAL_PACKET_MULTI_PACKET_REC_POS, D_WorkPos);
  s_GetVectElementPosReg(ptr_to_rec, D_WorkPos, dst_reg);
  $RELEASE(D_WorkPos);
}

/*-----------------------------------------------*/

#PSL_define s_PutPacketID_inMultiPacketRecord(ptr_to_rec, packet_id_reg)
{
  b_SetImmTypeMRBoff(INT, packet_id_reg); /* $BG0$N$?$a(B */
  p_WriteWithOffset
    (packet_id_reg, ptr_to_rec, _PACKET_ID_MULTI_PACKET_REC_POS);
}

#PSL_define s_PutClNum_inMultiPacketRecord(ptr_to_rec, cl_num_reg)
{
  b_SetImmTypeMRBoff(INT, cl_num_reg);
  p_WriteWithOffset(cl_num_reg, ptr_to_rec, _CL_NUM_MULTI_PACKET_REC_POS);
}

#PSL_define s_PutTotalPacketNum_inMultiPacketRecord(ptr_to_rec, packet_num_reg)
{
  b_SetImmTypeMRBoff(INT, packet_num_reg);
  p_WriteWithOffset
    (packet_num_reg, ptr_to_rec, _TOTAL_PACKET_NUM_MULTI_PACKET_REC_POS);
}

#PSL_define s_PutPacketCount_inMultiPacketRecord(ptr_to_rec, packet_cnt_reg)
{
  b_SetImmTypeMRBoff(INT, packet_cnt_reg); /* $BG0$N$?$a(B */
  p_WriteWithOffset
    (packet_cnt_reg, ptr_to_rec, _PACKET_CNT_MULTI_PACKET_REC_POS);
}

#PSL_define s_PutNextLink_inMultiPacketRecord(ptr_to_rec, next_ptr)
{
  p_WriteWithOffset(next_ptr, ptr_to_rec, _NEXT_LINK_MULTI_PACKET_REC_POS);
}

#PSL_define s_PutLogicalPacket_inMultiPacketRecord
                               (ptr_to_rec, pos_reg, packet_ptr)
{
  $USE(D_WorkPos);
  p_MoveWord(pos_reg, D_WorkPos);
  p_AddImmediate(D_WorkPos, _LOGICAL_PACKET_MULTI_PACKET_REC_POS, D_WorkPos);
  b_DecrementReg(D_WorkPos); /* pos_reg$B$,#1%*%j%8%s$J$N$G(B */
  s_PutVectElementPosReg(ptr_to_rec, D_WorkPos, packet_ptr);
  $RELEASE(D_WorkPos);
}

#DATA_define D_WorkPacketCnt XXX

#PSL_define s_IncrementPacketCount(ptr_to_rec)
{
  $USE(D_WorkPacketCnt);
  s_GetPacketCount_fromMultiPacketRecord(ptr_to_rec, D_WorkPacketCnt);
  b_IncrementReg(D_WorkPacketCnt);
  s_PutPacketCount_inMultiPacketRecord(ptr_to_rec, D_WorkPacketCnt);
  $RELEASE(D_WorkPacketCnt);
}

/******************************************************************** PSL **
4. $B%^%k%A!&%Q%1%C%H!&%l%3!<%I$N(B push, pop, find

       written by ttakagi@icot22      on Fri Oct  5 14:03:09 1990

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_PushMultiPacketRecord(packet_top_ptr, ptr_to_rec)
{
  s_PutNextLink_inMultiPacketRecord(ptr_to_rec, packet_top_ptr);
  p_MoveWord(ptr_to_rec, packet_top_ptr);
}

#DATA_define D_WorkPacketRecPtr     XXX
#DATA_define D_WorkNextPacketRecPtr XXX

#PSL_define s_PopMultiPacketRecord(multi_packet_top, ptr_to_rec)
{
  b_IfEqual(multi_packet_top, ptr_to_rec) {
    $USE(D_WorkPacketRecPtr);
    s_GetNextLink_fromMultiPacketRecord(ptr_to_rec, D_WorkPacketRecPtr);
    p_MoveWord(D_WorkPacketRecPtr, multi_packet_top);
    $RELEASE(D_WorkPacketRecPtr);
  } else {
    $USE(D_WorkPacketRecPtr);
    p_MoveWord(multi_packet_top, D_WorkPacketRecPtr);
    $USE(D_WorkNextPacketRecPtr);
    LOOP() {
      s_GetNextLink_fromMultiPacketRecord
        (D_WorkPacketRecPtr, D_WorkNextPacketRecPtr);
      b_IfEqual(D_WorkNextPacketRecPtr, ptr_to_rec) {
        s_GetNextLink_fromMultiPacketRecord
          (ptr_to_rec, D_WorkNextPacketRecPtr);
        s_PutNextLink_inMultiPacketRecord
          (D_WorkPacketRecPtr, D_WorkNextPacketRecPtr);
        break;
      }
      p_MoveWord(D_WorkNextPacketRecPtr, D_WorkPacketRecPtr);
    }
    $RELEASE(D_WorkPacketRecPtr);
    $RELEASE(D_WorkNextPacketRecPtr);
  }
}

#DATA_define D_WorkPacket_ID   XXX
#DATA_define D_WorkPacketClNum XXX

#PSL_define s_FindMultiPacketRecord
              (multi_packet_top, packet_id_reg, cluster_num_reg, ptr_to_rec)
{
  p_MoveWord(multi_packet_top, ptr_to_rec);
  b_IfNotIllegalPointer(ptr_to_rec) {
    $USE(D_WorkPacket_ID);
    $USE(D_WorkPacketClNum);
    LOOP() {
      s_GetPacketID_fromMultiPacketRecord(ptr_to_rec, D_WorkPacket_ID);
      b_IfEqual(D_WorkPacket_ID, packet_id_reg) {
	s_GetClNum_fromMultiPacketRecord(ptr_to_rec, D_WorkPacketClNum);
	b_IfEqual(D_WorkPacketClNum, cluster_num_reg) { break; }
      }
      s_GetNextLink_fromMultiPacketRecord(ptr_to_rec, ptr_to_rec);
      b_IfWordEq(ptr_to_rec, D_NULL) { break; }
    }
    $RELEASE(D_WorkPacket_ID);
    $RELEASE(D_WorkPacketClNum);
  }
}

/******************************************************************** PSL **
5.$B!JAw?.;~$N!K%^%k%A%Q%1%C%H#I#D$N@8@.(B

s_GenerateMultiPacketIdX(dst_id_reg)

       written by imai@icot22      on Thu Oct  4 17:06:46 1990

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  PIM/p$B$N$h$&$K%a%C%;!<%8$N9T$-@h(B PE $B$,7h$^$C$F$$$k>l9g$O!"(BPacketID$B$r(B
  PE $B%m!<%+%k$K;}$C$FNI$$$N$G!"GSB>@)8f$,$$$i$J$$!#(B
********************************************************************* PSL **/

#PSL_define s_GenerateMultiPacketIdX(dst_id_reg)
{
  b_IncrementSharedAreaX
    (_MEM_MANAGE_AREA_BASE, _MULTI_PACKET_ID_OFST, dst_id_reg);
  b_SetImmTypeMRBoff(INT, dst_id_reg);
}

/******************************************************************** PSL **
6. $B!J<u?.;~$N!K%^%k%A%Q%1%C%H%H%C%W$KBP$9$kA`:n(B

s_SoftLockMultiPacketTop(dst_ptr)
s_SoftUnlockMultiPacketTop(src_ptr)

       written by imai@icot22      on Thu Oct  4 17:07:14 1990

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  PIM/p$B$N$h$&$K%a%C%;!<%8$N9T$-@h(B PE $B$,7h$^$C$F$$$k>l9g$O!"(BPacketTop$B$r(B
  PE $B%m!<%+%k$K;}$C$FNI$$$N$G!"$3$N%m%C%/A`:n$O$$$i$J$/$J$k!#(B
********************************************************************* PSL **/

#PSL_define s_SoftLockMultiPacketTop(dst_ptr)
{
  b_SoftLockSharedAreaX
      (_MEM_MANAGE_AREA_BASE, _MULTI_PACKET_TOP_OFST, dst_ptr);
}

#PSL_define s_SoftUnlockMultiPacketTop(src_ptr)
{
  b_SoftUnlockSharedAreaX
    (src_ptr, _MEM_MANAGE_AREA_BASE, _MULTI_PACKET_TOP_OFST);
}
