
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/structures/str_int_cl_msg_susp.psl.c
   ----- CREATED   : by ttakagi@icot22, on Thu Nov 28 14:27:09 1991
   ----- LAST SAVED: by ttakagi@icot22, on Fri May 22 11:51:05 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : $B%a%b%jITB-$K$h$k%a%C%;!<%8$N%5%9%Z%s%I(B
                     $B%M%C%H%o!<%/%P%C%U%!$"$U$l$K$h$k%Q%1%C%H$N%5%9%Z%s%I(B

1. $B%a%b%jITB-;~$N%a%C%;!<%8%5%9%Z%s%I(B
1.1 $B<u?.%a%C%;!<%8%5%9%Z%s%I%U%i%0$N%;%C%H!"%j%;%C%H!"%F%9%H(B
1.2 $B%a%C%;!<%8%5%9%Z%s%7%g%s%l%3!<%I$N@8@.!"2s<}(B
1.3 $B%a%C%;!<%8%5%9%Z%s%7%g%s%l%3!<%I$KBP$9$kA`:n(B
1.4 $B%a%C%;!<%8%5%9%Z%s%7%g%s%l%3!<%I$N(B push, pop

2. $B%M%C%H%o!<%/%P%C%U%!$,0n$l$?;~!"Aw?.$7$h$&$H$7$?%Q%1%C%H$r%5%9%Z%s%I$9$k=hM}(B
2.1 $B%Q%1%C%H!&%5%9%Z%s%7%g%s!&%l%3!<%I$N@8@.!"2s<}(B
2.2 $B%Q%1%C%H!&%5%9%Z%s%7%g%s!&%l%3!<%I$KBP$9$kA`:n(B
2.3 $B%Q%1%C%H!&%5%9%Z%s%7%g%s!&%l%3!<%I$N(B push, pop

3. 
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
1. $B%a%b%jITB-;~$N%a%C%;!<%8%5%9%Z%s%I$K4X$9$k3F<o%G!<%?$NDj5A(B

       written by ttakagi@icot22      on Mon Apr 22 11:37:51 1991

<Explanation>

         System Area         |                   Heap Area

   +-----------------------+ |
   | MsgSuspRecvPacketFlag |
   +-----------------------+ |

   +-----------------------+ |  +-------------+        +-------------+
   | MsgSuspRecTop         |--->| NextRecLink |- ... ->| NextRecLink |
   +-----------------------+ |  +-------------+        +-------------+
                                | MsgSuspID   |        | MsgSuspID   |
                             |  +-------------+        +-------------+
                                | MsgInfo 1   |        | MsgInfo 1   |
                             |  +-------------+        +-------------+
                                | MsgInfo 2   |        | MsgInfo 2   |
                             |  +-------------+        +-------------+

$B!&(BMsgSuspRecvPacketFlag $B$O!"%Q%1%C%H<u?.$NESCf$G%a%b%jITB-$N$?$a$K=hM}(B
  $B%k!<%A%s$rH4$1$?$3$H$rCN$i$;$k%U%i%0$G!"<!$N%9%j%C%H%A%'%C%/$KF~$C$?(B
  $B;~$K%(%i!<$H$N6hJL$r$D$1$k$?$a$KMQ0U$7$?!#(B
  $B>-MhE*$K$OL5$/$F$b$$$$!#(B
$B!&%l%3!<%I$,$D$J$,$C$F$$$k$+$I$&$+$NH=CG$O!"(BMsgSuspRecTop $B$NCM$G$D$1$k!#(B
  $B$D$J$,$C$F$$$J$$>l9g$O(B NULL$BCM$,$O$$$k!#(B

<ETC>
********************************************************************* PSL **/

/* $B%a%C%;!<%8!&%5%9%Z%s%7%g%s!&%l%3!<%I$N%H%C%W(B */
#DATA_define D_MsgSuspRecTop                  XXX

/* $B<u?.$7$?%a%C%;!<%8AH$_N)$F$,%5%9%Z%s%I$7$?$3$H$rCN$i$;$k%U%i%0(B */
#DATA_define D_RecvPacketSuspFlag             XXX

/* $B%a%C%;!<%8%5%9%Z%s%7%g%s%l%3!<%I$N3F%9%m%C%H$X$N%*%U%;%C%H(B */
#ADDR_define _MSG_SUSP_REC_NEXT_LINK_OFST       0
#ADDR_define _MSG_SUSP_REC_ID_OFST              1
#ADDR_define _MSG_SUSP_REC_INFO_1_OFST          2
#ADDR_define _MSG_SUSP_REC_INFO_2_OFST          3

/* $B3F<o%a%C%;!<%8%5%9%Z%s%7%g%s#I#D(B */
#CONST_define _MSG_SUSP_SEND_THROW_GOAL         1
#CONST_define _MSG_SUSP_SEND_ANSWER_VALUE       2
#CONST_define _MSG_SUSP_RECV_PACKET             3
#CONST_define _MSG_SUSP_MAKE_MULTI_PACKET       4

/* $B%a%C%;!<%8%5%9%Z%s%I$K4X$9$k%G!<%?$N%$%K%7%c%i%$%:(B */
#PSL_define s_InitIntClMsgSusp()
{
  p_MoveWord(D_NULL, D_MsgSuspRecTop);
  p_MoveWord(D_NULL, D_PacketSuspRecTop);
  s_ResetRecvPacketSuspFlag();
}

/******************************************************************** PSL **
1.1 $B<u?.%a%C%;!<%8%5%9%Z%s%I%U%i%0$N%;%C%H!"%j%;%C%H!"%F%9%H(B

       written by ttakagi@icot22      on Mon Apr 22 14:55:43 1991

<Arguments>

<Explanation>
$B!&%a%C%;!<%8%O%s%I%i$N%k!<%A%s(B(f_NwMessageHandler_Sub)$B$G$O!"%M%C%H%o!<%/$K(B
  $BN/$C$F$$$k%Q%1%C%H$rA4$FFI$_9~$`$^$G%k!<%W$9$k=hM}$K$J$C$F$$$k!#(B
  $B$7$+$7!"$3$N%k!<%W$NESCf$G%a%b%j$,ITB-$7$?>l9g$O!"%9%j%C%H%A%'%C%/MW0x(B
  _NW_MSG_PACKET_ARV_EVENT $B$rN)$F$?$^$^!"%k!<%W$rH4$1$k$h$&$K$7$F$$$k!#(B

  $B<!$N%9%j%C%H%A%'%C%/$G$O!"(B_NW_MSG_PACKET_ARV_EVENT $B$,%a%b%jITB-$N$?$a$K(B
  $BN)$F$i$l$?$N$+!"@5$7$/%Q%1%C%H$,E~Ce$7$FN)$F$i$l$?$N$+$,J,$+$i$J$$!#(B
  $B$@$+$i!"%Q%1%C%H$,L5$$$N$K(B _NW_MSG_PACKET_ARV_EVENT $B$,N)$C$F$$$k$3$H$,(B
  $B$"$k!#(B
  
  $B$3$N%U%i%0$O!"$3$l$i$N6hJL$rIU$1$k$?$a$KMQ0U$7$?!#(B
  $B$?$@$7!"%Q%1%C%H$,L5$$>l9g(B f_NwMessageHandler_Sub $B$O!"$=$N$^$^$L$1$k$@$1(B
  $B$J$N$G!"I,$:6hJL$r$D$1$J$1$l$P$J$i$J$$$H$$$&$3$H$O$J$$!#(B
  $B8=:_$O!"%G%P%C%0$N$?$a$K$3$N%U%i%0$rMQ0U$7$F$$$k!#(B

<ETC>
********************************************************************* PSL **/

#PSL_define s_SetRecvPacketSuspFlag()
{
  p_MoveWord(D_ONE, D_RecvPacketSuspFlag);
}

#PSL_define s_ResetRecvPacketSuspFlag()
{
  p_MoveWord(D_NULL, D_RecvPacketSuspFlag);
}

#CTRL_define s_IfRecvPacketSuspFlagOn()
{
  b_IfEqual(D_RecvPacketSuspFlag, D_ONE)
}

/******************************************************************** PSL **
1.2 $B%a%C%;!<%8%5%9%Z%s%7%g%s%l%3!<%I$N@8@.!"2s<}(B

       written by ttakagi@icot22      on Mon Apr 22 14:54:38 1991

<Arguments>
 msg_susp_rec: $B%a%C%;!<%8%5%9%Z%s%7%g%s%l%3!<%I$X$N%]%$%s%?(B

<Explanation>

  +-------------+      +--------------------------+
  | msg_rec_ptr |----->| Ptr to next msg-susp-rec |
  +-------------+      +--------------------------+
     $B%l%8%9%?(B          | msg-susp ID              |
                       +--------------------------+
                       | msg-susp Info 1          |
                       +--------------------------+
                       | msg-susp Info 2          |
                       +--------------------------+
<ETC>
  
********************************************************************* PSL **/

#PSL_define s_AllocMsgSuspRec(msg_rec_ptr)
{
  b_Alloc4(msg_rec_ptr, VECT4);
  s_PutNextRecLink_MsgSuspRec(D_NULL, msg_rec_ptr);
}

#PSL_define s_ReclaimMsgSuspRec(msg_rec_ptr)
{
  b_Reclaim4(msg_rec_ptr);
}

/******************************************************************** PSL **
1.3 $B%a%C%;!<%8%5%9%Z%s%7%g%s%l%3!<%I$KBP$9$kA`:n(B

       written by ttakagi@icot22      on Mon Apr 22 14:55:02 1991

<Arguments>

<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_PutNextRecLink_MsgSuspRec(next_rec_ptr, msg_rec_ptr)
{
  p_WriteWithOffset(next_rec_ptr, msg_rec_ptr, _MSG_SUSP_REC_NEXT_LINK_OFST);
}

#PSL_define s_GetNextRecLink_MsgSuspRec(msg_rec_ptr, next_rec_ptr)
{
  p_ReadWithOffset(msg_rec_ptr, _MSG_SUSP_REC_NEXT_LINK_OFST, next_rec_ptr);
}

#DATA_define D_WorkSuspMsgID XXX

#PSL_define s_PutSuspMsgID_MsgSuspRec(imm_id, msg_rec_ptr)
{
  $USE(D_WorkSuspMsgID);
  b_SetImmTypeValueMRBoff(INT, imm_id, D_WorkSuspMsgID);
  p_WriteWithOffset(D_WorkSuspMsgID, msg_rec_ptr, _MSG_SUSP_REC_ID_OFST);
  $RELEASE(D_WorkSuspMsgID);
}

#PSL_define s_GetSuspMsgID_MsgSuspRec(msg_rec_ptr, msg_id_reg)
{
  p_ReadWithOffset(msg_rec_ptr, _MSG_SUSP_REC_ID_OFST, msg_id_reg);
}

#PSL_define s_PutMsgInfo1_MsgSuspRec(info_reg, msg_rec_ptr)
{
  p_WriteWithOffset(info_reg, msg_rec_ptr, _MSG_SUSP_REC_INFO_1_OFST);
}

#PSL_define s_GetMsgInfo1_MsgSuspRec(msg_rec_ptr, info_reg)
{
  p_ReadWithOffset(msg_rec_ptr, _MSG_SUSP_REC_INFO_1_OFST, info_reg);
}

#PSL_define s_PutMsgInfo2_MsgSuspRec(info_reg, msg_rec_ptr)
{
  p_WriteWithOffset(info_reg, msg_rec_ptr, _MSG_SUSP_REC_INFO_2_OFST);
}

#PSL_define s_GetMsgInfo2_MsgSuspRec(msg_rec_ptr, info_reg)
{
  p_ReadWithOffset(msg_rec_ptr, _MSG_SUSP_REC_INFO_2_OFST, info_reg);
}

/******************************************************************** PSL **
1.4 $B%a%C%;!<%8%5%9%Z%s%7%g%s%l%3!<%I$N(B push, pop

       written by ttakagi@icot22      on Mon Apr 22 15:01:08 1991

<Arguments>

<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_PushMsgSuspRec(susp_rec_ptr)
{
  s_PutNextRecLink_MsgSuspRec(D_MsgSuspRecTop, susp_rec_ptr);
  p_MoveWord(susp_rec_ptr, D_MsgSuspRecTop);
}

#PSL_define s_PopMsgSuspRec(susp_rec_ptr)
{
  b_IfEOL(D_MsgSuspRecTop){
    b_SetIllegalPointer(susp_rec_ptr);
  }else{
    p_MoveWord(D_MsgSuspRecTop, susp_rec_ptr);
    s_GetNextRecLink_MsgSuspRec(susp_rec_ptr, D_MsgSuspRecTop);
  }
}

/******************************************************************** PSL **
2. $B%M%C%H%o!<%/!&%P%C%U%!$,0n$l$?;~!"Aw?.$7$h$&$H$7$?%Q%1%C%H$r(B
   $B%5%9%Z%s%I$9$k=hM}(B

       written by ttakagi@icot22      on Fri Jul  5 19:21:19 1991

<Explanation>
<ETC>
********************************************************************* PSL **/

/* $B%Q%1%C%H!&%5%9%Z%s%7%g%s!&%l%3!<%I$N%H%C%W(B */
#DATA_define D_PacketSuspRecTop XXX

/* $B%Q%1%C%H!&%5%9%Z%s%7%g%s!&%l%3!<%I$N3F%9%m%C%H$X$N%*%U%;%C%H(B */
#ADDR_define _PACKET_SUSP_REC_NEXT_LINK_OFST     0
#ADDR_define _PACKET_SUSP_REC_ID_OFST            1
#ADDR_define _PACKET_SUSP_REC_INFO_1_OFST        2
#ADDR_define _PACKET_SUSP_REC_INFO_2_OFST        3
#ADDR_define _PACKET_SUSP_REC_INFO_3_OFST        4
#ADDR_define _PACKET_SUSP_REC_INFO_4_OFST        5
#ADDR_define _PACKET_SUSP_REC_INFO_5_OFST        6
#ADDR_define _PACKET_SUSP_REC_INFO_6_OFST        7

/* $B3F<o%Q%1%C%H!&%5%9%Z%s%7%g%s#I#D(B */
#CONST_define _PACKET_SUSP_SINGLE         1
#CONST_define _PACKET_SUSP_MULTI          2
#CONST_define _PACKET_SUSP_DISTRIBUTE     3

/******************************************************************** PSL **
2.1 $B%Q%1%C%H!&%5%9%Z%s%7%g%s!&%l%3!<%I$N@8@.!"2s<}(B

       written by ttakagi@icot22      on Fri Jul  5 19:50:00 1991

<Arguments>

<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_AllocPacketSuspRec(packet_rec_ptr)
{
  b_Alloc8(packet_rec_ptr, VECT8);
  s_PutNextRecLink_PacketSuspRec(D_NULL, packet_rec_ptr);
}

#PSL_define s_ReclaimPacketSuspRec(packet_rec_ptr)
{
  b_Reclaim8(packet_rec_ptr);
}

/******************************************************************** PSL **
2.2 $B%Q%1%C%H!&%5%9%Z%s%7%g%s!&%l%3!<%I$KBP$9$kA`:n(B

       written by ttakagi@icot22      on Fri Jul  5 19:51:45 1991

<Arguments>

<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_PutNextRecLink_PacketSuspRec(next_rec_ptr, packet_rec_ptr)
{
  p_WriteWithOffset
             (next_rec_ptr, packet_rec_ptr, _PACKET_SUSP_REC_NEXT_LINK_OFST);
}

#PSL_define s_GetNextRecLink_PacketSuspRec(packet_rec_ptr, next_rec_ptr)
{
  p_ReadWithOffset
            (packet_rec_ptr, _PACKET_SUSP_REC_NEXT_LINK_OFST, next_rec_ptr);
}

#DATA_define D_WorkSuspPacketID XXX

#PSL_define s_PutSuspPacketID_PacketSuspRec(imm_id, packet_rec_ptr)
{
  $USE(D_WorkSuspPacketID);
  b_SetImmTypeValueMRBoff(INT, imm_id, D_WorkSuspPacketID);
  p_WriteWithOffset
             (D_WorkSuspPacketID, packet_rec_ptr, _PACKET_SUSP_REC_ID_OFST);
  $RELEASE(D_WorkSuspPacketID);
}

#PSL_define s_GetSuspPacketID_PacketSuspRec(packet_rec_ptr, packet_id_reg)
{
  p_ReadWithOffset(packet_rec_ptr, _PACKET_SUSP_REC_ID_OFST, packet_id_reg);
}

#PSL_define s_PutPacketInfo1_PacketSuspRec(info_reg, packet_rec_ptr)
{
  p_WriteWithOffset(info_reg, packet_rec_ptr, _PACKET_SUSP_REC_INFO_1_OFST);
}

#PSL_define s_GetPacketInfo1_PacketSuspRec(packet_rec_ptr, info_reg)
{
  p_ReadWithOffset(packet_rec_ptr, _PACKET_SUSP_REC_INFO_1_OFST, info_reg);
}

#PSL_define s_PutPacketInfo2_PacketSuspRec(info_reg, packet_rec_ptr)
{
  p_WriteWithOffset(info_reg, packet_rec_ptr, _PACKET_SUSP_REC_INFO_2_OFST);
}

#PSL_define s_GetPacketInfo2_PacketSuspRec(packet_rec_ptr, info_reg)
{
  p_ReadWithOffset(packet_rec_ptr, _PACKET_SUSP_REC_INFO_2_OFST, info_reg);
}

#PSL_define s_PutPacketInfo3_PacketSuspRec(info_reg, packet_rec_ptr)
{
  p_WriteWithOffset(info_reg, packet_rec_ptr, _PACKET_SUSP_REC_INFO_3_OFST);
}

#PSL_define s_GetPacketInfo3_PacketSuspRec(packet_rec_ptr, info_reg)
{
  p_ReadWithOffset(packet_rec_ptr, _PACKET_SUSP_REC_INFO_3_OFST, info_reg);
}

#PSL_define s_PutPacketInfo4_PacketSuspRec(info_reg, packet_rec_ptr)
{
  p_WriteWithOffset(info_reg, packet_rec_ptr, _PACKET_SUSP_REC_INFO_4_OFST);
}

#PSL_define s_GetPacketInfo4_PacketSuspRec(packet_rec_ptr, info_reg)
{
  p_ReadWithOffset(packet_rec_ptr, _PACKET_SUSP_REC_INFO_4_OFST, info_reg);
}

#PSL_define s_PutPacketInfo5_PacketSuspRec(info_reg, packet_rec_ptr)
{
  p_WriteWithOffset(info_reg, packet_rec_ptr, _PACKET_SUSP_REC_INFO_5_OFST);
}

#PSL_define s_GetPacketInfo5_PacketSuspRec(packet_rec_ptr, info_reg)
{
  p_ReadWithOffset(packet_rec_ptr, _PACKET_SUSP_REC_INFO_5_OFST, info_reg);
}

#PSL_define s_PutPacketInfo6_PacketSuspRec(info_reg, packet_rec_ptr)
{
  p_WriteWithOffset(info_reg, packet_rec_ptr, _PACKET_SUSP_REC_INFO_6_OFST);
}

#PSL_define s_GetPacketInfo6_PacketSuspRec(packet_rec_ptr, info_reg)
{
  p_ReadWithOffset(packet_rec_ptr, _PACKET_SUSP_REC_INFO_6_OFST, info_reg);
}

/******************************************************************** PSL **
2.3 $B%Q%1%C%H!&%5%9%Z%s%7%g%s!&%l%3!<%I$N(B push, pop

       written by ttakagi@icot22      on Mon Apr 22 15:01:08 1991

<Arguments>

<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_PushPacketSuspRec(susp_rec_ptr)
{
  s_PutNextRecLink_PacketSuspRec(D_PacketSuspRecTop, susp_rec_ptr);
  p_MoveWord(susp_rec_ptr, D_PacketSuspRecTop);
}

#PSL_define s_PopPacketSuspRec(susp_rec_ptr)
{
  b_IfEOL(D_PacketSuspRecTop){
      b_SetIllegalPointer(susp_rec_ptr);
  }else{
      p_MoveWord(D_PacketSuspRecTop, susp_rec_ptr);
      s_GetNextRecLink_PacketSuspRec(susp_rec_ptr, D_PacketSuspRecTop);
  }
}

/******************************************************************** PSL **
3.1 $B%7%s%0%k%Q%1%C%H$N%5%9%Z%s%I(B

s_PacketSuspend_Single

       written by ttakagi@icot22      on Thu Dec 19 12:56:56 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkSuspDataReg XXX

#PSL_define s_PacketSuspend_Single(packet_ptr, packet_size, cluster_num)
{
  $USE(D_WorkPtrToPacketSuspRec);
  s_AllocPacketSuspRec(D_WorkPtrToPacketSuspRec);
  s_PutSuspPacketID_PacketSuspRec
                      (_PACKET_SUSP_SINGLE, D_WorkPtrToPacketSuspRec);

  p_SetImmediateType(INT, cluster_num);
  s_PutPacketInfo1_PacketSuspRec(cluster_num, D_WorkPtrToPacketSuspRec);
  p_SetImmediateType(INT,packet_size);
  s_PutPacketInfo2_PacketSuspRec(packet_size, D_WorkPtrToPacketSuspRec);
  s_PutPacketInfo3_PacketSuspRec(packet_ptr, D_WorkPtrToPacketSuspRec);

  s_PutPacketInfo4_PacketSuspRec(D_NULL, D_WorkPtrToPacketSuspRec);
  s_PutPacketInfo5_PacketSuspRec(D_NULL, D_WorkPtrToPacketSuspRec);
  s_PutPacketInfo6_PacketSuspRec(D_NULL, D_WorkPtrToPacketSuspRec);

  s_PushPacketSuspRec(D_WorkPtrToPacketSuspRec);
  $RELEASE(D_WorkPtrToPacketSuspRec);
  b_SetEventFlag(_NETWORK_BUFFER_FULL_EVENT, D_PE_Number);
}

/******************************************************************** PSL **
3.3 $BAq1`$+$iN$?F$X(Bdistribute$B$9$k%Q%1%C%H$N%5%9%Z%s%I(B

s_PacketSuspend_Distribute

       written by ttakagi@icot22      on Thu Dec 19 12:25:30 1991

<Arguments>
 packet_ptr: $B%5%9%Z%s%I$9$kO@M}%Q%1%C%H$X$N%]%$%s%?(B
 tbl_upper:  $BN$?F%F!<%V%k(B($B>e0L(B)
 tbl_lower:  $BN$?F%F!<%V%k(B($B2<0L(B)

<Explanation>
$B!&Aq1`$+$iJ#?t$NN$?F$X%a%C%;!<%8$rAw?.$7$F$$$k:GCf$K%M%C%H%o!<%/%P%C%U%!$,(B
  $B$"$U$l$?>l9g$K8F$P$l$k!#(B
$B!&%5%9%Z%s%I$7$?%a%C%;!<%8$O<!$N%9%j%C%H%A%'%C%/$N%?%$%_%s%0$GAw?.$,(B
  $B:F;n9T$5$l$k!#(B
<ETC>
$B!&N$?F%F!<%V%k$N%?%0$O(B INTo $B$K$9$k!#$3$l$O#G#C$N$?$a$G$"$k!#(B
********************************************************************* PSL **/

#PSL_define s_PacketSuspend_Distribute(packet_ptr, tbl_upper, tbl_lower)
{
  $USE(D_WorkPtrToPacketSuspRec);

  s_AllocPacketSuspRec(D_WorkPtrToPacketSuspRec);
  s_PutSuspPacketID_PacketSuspRec
                      (_PACKET_SUSP_DISTRIBUTE,D_WorkPtrToPacketSuspRec);

  $USE(D_WorkSuspDataReg);

  b_MoveWithImmTypeMRBoff(tbl_upper, INT, D_WorkSuspDataReg);
  s_PutPacketInfo1_PacketSuspRec(D_WorkSuspDataReg, D_WorkPtrToPacketSuspRec);

  b_MoveWithImmTypeMRBoff(tbl_lower, INT, D_WorkSuspDataReg);
  s_PutPacketInfo2_PacketSuspRec(D_WorkSuspDataReg, D_WorkPtrToPacketSuspRec);

  s_PutPacketInfo3_PacketSuspRec(packet_ptr, D_WorkPtrToPacketSuspRec);

  s_PutPacketInfo4_PacketSuspRec(D_NULL, D_WorkPtrToPacketSuspRec);
  s_PutPacketInfo5_PacketSuspRec(D_NULL, D_WorkPtrToPacketSuspRec);
  s_PutPacketInfo6_PacketSuspRec(D_NULL, D_WorkPtrToPacketSuspRec);

  $RELEASE(D_WorkSuspDataReg);

  s_PushPacketSuspRec(D_WorkPtrToPacketSuspRec);

  $RELEASE(D_WorkPtrToPacketSuspRec);
}
