
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/structures/str_gc_type.psl.c
   ----- CREATED   : by f-hataza@icot22, on Fri Jun 22 10:45:38 1990
   ----- LAST SAVED: by f-doumae@icot22, on Wed Nov 13 16:41:02 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : STRUCTURES
   ----- ABSTRACT  : $B%?%$%WKh$N(BGC$B=hM}(B

  $B$3$3$K$"$k%^%/%m$O!"(Bs_GCTypeDispatch() (in str_gc_main.psl.c) $B$+$i8F$P$l$k!#(B

  1. $B%j%9%H%;%k$N(BGC$B=hM}(B
  1.5 FLT$B$N(BGC$B=hM}(B
  2. $B%9%H%j%s%0$N(BGC$B=hM}(B
  3. $B%7%g!<%H%Y%/%?$N(BGC$B=hM}(B
  4. $B%m%s%0%Y%/%?$N(BGC$B=hM}(B
  [ 5. REF$B$N(BGC$B=hM}(B ($B:o=|(B) ]
  6. $B%4!<%k%l%3!<%I$N(BGC$B=hM}(B
  7. $BGrM"F~I=$N(BGC$B=hM}(B
  8. $B9uM"F~I=$N(BGC$B=hM}(B
  9. CDESC$B$N(BGC$B=hM}(B
 10. $B%3!<%I$N(BGC$B=hM}(B
 11. $BAq1`%l%3!<%I$N(BGC$B=hM}(B
 12. $BN$?F%l%3!<%I$N(BGC$B=hM}(B
 13. $B%^!<%8%c%;%k$N(BGC$B=hM}(B

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

#DATA_define	D_WorkModuleSize	XXX
#DATA_define	D_WorkStrTopOfst	XXX
#DATA_define	D_WorkStrCopySize	XXX
#DATA_define	D_WorkStrAllocSize	XXX
#DATA_define	D_WorkGCAreaSize	XXX
#DATA_define	D_WorkPtrToGCAreaTop	XXX

/******************************************************************** PSL **
  1. $B%j%9%H%;%k$N(BGC$B=hM}(B
    s_GCList

       written by imai@icot22      on Sat Feb 10 19:35:36 1990
<Arguments>
  sweep_ptr (src):	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B8=:_%9%$!<%WCf$N%o!<%I$X$N%]%$%s%?(B
  swept_elm (src):	($B%?%0$r4^$a$F0UL#$r;}$D(B)
	$B5lNN0h$K$"$k%j%9%H%;%k$X$N%]%$%s%?!#%?%$%W$O(B LIST
	(swept_elm = *sweep_ptr $B$G$"$k(B)
  updated_size_ofst (dst):	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B99?7$5$l$?%Z!<%8%H%C%W$N%;!<%VNN0h$N%*%U%;%C%H(B
	(_PAGE_TOP_2WORD or _PAGE_TOP_NOT_MODIFIED $B$N#2CM(B )
  updated_pagetop_ptr (dst):	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B99?7$5$l$?%Z!<%8%H%C%W$NCM(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
	swept_elm $B$N(B MRB $B$K$h$C$F!"(B
	($B!{(B) $B%^!<%/$;$:$K%3%T!<$9$k(B
	($B!|(B) $B%^!<%/$9$k$H$H$b$K!"MWAG$b9u$/$7$F%3%T!<$9$k(B
<ETC>
********************************************************************* PSL **/

#PSL_define s_GCList(sweep_ptr,swept_elm,updated_size_ofst,updated_pagetop_ptr)
{
  @DEBUG{
    s_IfNotLIST(swept_elm) {
      VPIM_ERROR("s_GCList","Not LIST");
    }
    s_IfNotOldArea(swept_elm) {
      VPIM_ERROR("s_GCList","swept_elm does not point old area");
    }
  };
  s_IfMRBoff(swept_elm) {
    s_GC2WordNoMark
      (sweep_ptr,swept_elm,updated_size_ofst,updated_pagetop_ptr);
    @PROBE{ b_AddImmediateWithTag(D_GC_ListCnt,_TWO,D_GC_ListCnt); };
  } else {
    s_GC2WordMarkWithMRBor
      (sweep_ptr,swept_elm,updated_size_ofst,updated_pagetop_ptr);
    @PROBE{
      s_IfModifiedPageTop(updated_size_ofst) {
	b_AddImmediateWithTag(D_GC_ListCnt,_TWO,D_GC_ListCnt);
      }};
  }
}

/******************************************************************** PSL **
  1.5 FLT$B$N(BGC$B=hM}(B $B!J(B $B4pK\E*$K(B List $B$HF1$8$J$N$G$3$3$KCV$$$?!#!K(B
    s_GCFLT

       written by imai@icot22      on Sat Feb 10 19:35:36 1990
<Arguments>
  sweep_ptr (src):	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B8=:_%9%$!<%WCf$N%o!<%I$X$N%]%$%s%?(B
  swept_elm (src):	($B%?%0$r4^$a$F0UL#$r;}$D(B)
	$B5lNN0h$K$"$k%j%9%H%;%k$X$N%]%$%s%?!#%?%$%W$O(B FLT
	(swept_elm = *sweep_ptr $B$G$"$k(B)
  updated_size_ofst (dst):	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B99?7$5$l$?%Z!<%8%H%C%W$N%;!<%VNN0h$N%*%U%;%C%H(B
	(_PAGE_TOP_2WORD or _PAGE_TOP_NOT_MODIFIED $B$N#2CM(B )
  updated_pagetop_ptr (dst):	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B99?7$5$l$?%Z!<%8%H%C%W$NCM(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
	swept_elm $B$N(B MRB $B$K$h$C$F!"(B
	($B!{(B) $B%^!<%/$;$:$K%3%T!<$9$k(B
	($B!|(B) $B%^!<%/$9$k$H$H$b$K!"MWAG$b9u$/$7$F%3%T!<$9$k(B
<ETC>
********************************************************************* PSL **/

#PSL_define s_GCFLT(sweep_ptr,swept_elm,updated_size_ofst,updated_pagetop_ptr)
{
  @DEBUG{
    s_IfNotFLT(swept_elm) {
      VPIM_ERROR("s_GCFLT","Not FLT");
    }
    s_IfNotOldArea(swept_elm) {
      VPIM_ERROR("s_GCFLT","swept_elm does not point old area");
    }
  };
  s_IfMRBoff(swept_elm) {
    s_GC2WordNoMark
      (sweep_ptr,swept_elm,updated_size_ofst,updated_pagetop_ptr);
    @PROBE{ b_AddImmediateWithTag(D_GC_FloatingCnt,_TWO,D_GC_FloatingCnt); };
  } else {
    s_GC2WordMarkWithMRBor
      (sweep_ptr,swept_elm,updated_size_ofst,updated_pagetop_ptr);
    @PROBE{
      s_IfModifiedPageTop(updated_size_ofst) {
	b_AddImmediateWithTag(D_GC_FloatingCnt,_TWO,D_GC_FloatingCnt);
      }};
  }
}

/******************************************************************** PSL **
  2. $B%9%H%j%s%0$N(BGC$B=hM}(B
    s_GCString

       written by imai@icot22      on Sat Feb 10 19:38:31 1990
<Arguments>
  sweep_ptr (src):	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B8=:_%9%$!<%WCf$N%o!<%I$X$N%]%$%s%?(B
  swept_elm (src):	($B%?%0$r4^$a$F0UL#$r;}$D(B)
	$B5lNN0h$K$"$k%9%H%j%s%0$X$N%]%$%s%?!#%?%$%W$O(B STRG
	(swept_elm = *sweep_ptr $B$G$"$k(B)
  updated_size_ofst (dst):	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B99?7$5$l$?%Z!<%8%H%C%W$N%;!<%VNN0h$N%*%U%;%C%H(B
  updated_pagetop_ptr (dst):	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B99?7$5$l$?%Z!<%8%H%C%W$NCM(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  String $B$N;X$7$F$$$k@h$N9=B$$K$O%]%$%s%?$,$J$$$N$G(B, 
  String $B%X$N%]%$%s%?$,!|$G$"$C$F$b!"(BMRBor$B$NI,MW$O$J$$(B
********************************************************************* PSL **/

#PSL_define s_GCString
	(sweep_ptr, swept_elm, updated_size_ofst, updated_pagetop_ptr)
{
  @DEBUG{
    s_IfNotSTRG(swept_elm) {
      VPIM_ERROR("s_GCString","swept_elm is not STRG type");
    }
    s_IfNotOldArea(swept_elm) {
      VPIM_ERROR("s_GCString","swept_elm does not point old area");
    }
  };
  $USE(D_WorkStrCopySize);
  s_GetStringSize(swept_elm,D_WorkStrCopySize);
  b_IncrementReg(D_WorkStrCopySize);   /* $B%G%#%9%/%j%W%?$NJ,(B */
  s_IfMRBoff(swept_elm){
    $CALL(s_GCNWordNoMark_Sub(sweep_ptr,swept_elm,D_WorkStrCopySize,D_NULL,
			       updated_size_ofst, updated_pagetop_ptr));
  } else {
    $CALL(s_GCNWordMark_Sub(sweep_ptr,swept_elm,D_WorkStrCopySize,D_NULL,
				  updated_size_ofst, updated_pagetop_ptr));
  }
  $RELEASE(D_WorkStrCopySize);
}

/******************************************************************** PSL **
  3. $B%7%g!<%H%Y%/%?$N(BGC$B=hM}(B
    s_GCShortVector

       written by imai@icot22      on Sat Feb 10 19:48:47 1990
<Arguments>
  sweep_ptr (src):	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B8=:_%9%$!<%WCf$N%o!<%I$X$N%]%$%s%?(B
  swept_elm (src):	($B%?%0$r4^$a$F0UL#$r;}$D(B)
	$B5lNN0h$K$"$k%7%g!<%H%Y%/%?$X$N%]%$%s%?!#%?%$%W$O(B VECT1 $B$+$i(B VECT8
	(swept_elm = *sweep_ptr $B$G$"$k(B)
  updated_size_ofst (dst):	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B99?7$5$l$?%Z!<%8%H%C%W$N%;!<%VNN0h$N%*%U%;%C%H(B
  updated_pagetop_ptr (dst):	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B99?7$5$l$?%Z!<%8%H%C%W$NCM(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_GCShortVector
	(sweep_ptr, swept_elm, updated_size_ofst, updated_pagetop_ptr)
{
  @DEBUG{
    s_IfNotShortVectors(swept_elm){
      VPIM_ERROR("s_GCShortVector","swept_elm is not short vectors!");
    }
    s_IfNotOldArea(swept_elm) {
      VPIM_ERROR("s_GCShortVector","swept_elm does not point old area");
    }
  };
  $USE(D_WorkStrCopySize);
  s_GetSizeShortVect(swept_elm,D_WorkStrCopySize);
  s_IfMRBoff(swept_elm){
      $CALL(s_GCNWordNoMark_Sub
	    (sweep_ptr,swept_elm,D_WorkStrCopySize,D_NULL,
	     updated_size_ofst, updated_pagetop_ptr));
    } else {
      $CALL(s_GCNWordMarkWithMRBor_Sub
	    (sweep_ptr,swept_elm,D_WorkStrCopySize,D_NULL,
	     updated_size_ofst, updated_pagetop_ptr));
    }
  $RELEASE(D_WorkStrCopySize);
}

/******************************************************************** PSL **
  4. $B%m%s%0%Y%/%?$N(BGC$B=hM}(B
    s_GCLongVector

       written by imai@icot22      on Sat Feb 10 20:04:30 1990
<Arguments>
  sweep_ptr (src):	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B8=:_%9%$!<%WCf$N%o!<%I$X$N%]%$%s%?(B
  swept_elm (src):	($B%?%0$r4^$a$F0UL#$r;}$D(B)
	$B5lNN0h$K$"$k%m%s%0%Y%/%?$X$N%]%$%s%?!#%?%$%W$O(B VECT
	(swept_elm = *sweep_ptr $B$G$"$k(B)
  updated_size_ofst (dst):	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B99?7$5$l$?%Z!<%8%H%C%W$N%;!<%VNN0h$N%*%U%;%C%H(B
  updated_pagetop_ptr (dst):	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B99?7$5$l$?%Z!<%8%H%C%W$NCM(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_GCLongVector
	(sweep_ptr, swept_elm, updated_size_ofst, updated_pagetop_ptr)
{
  @DEBUG{
    s_IfNotLongVectors(swept_elm){
      VPIM_ERROR("s_GCLongVector","swept_elm is not Long vectors!");
    }
    s_IfNotOldArea(swept_elm) {
      VPIM_ERROR("s_GCLongVector","swept_elm does not point old area");
    }
  };
  $USE(D_WorkStrCopySize); $USE(D_WorkStrTopOfst);
  s_GetSizeLongVect(swept_elm,D_WorkStrCopySize);
  @DEBUG{
    b_IfLessEqImm(D_WorkStrCopySize, _MAX_SIZE_OF_SVECT) {
      VPIM_ERROR("s_GCLongVector", "Illegal Long Vector!! (size <= 8)");
    }
  };
  b_IncrementReg(D_WorkStrCopySize); /* $B%5%$%:3JG<$N$?$a$N#1%o!<%IJ,(B */
  b_SetImmValueDNTC(_VECT_SIZE_OFST_LVECT,D_WorkStrTopOfst);
  s_IfMRBoff(swept_elm){
    $CALL(s_GCNWordNoMark_Sub
	  (sweep_ptr,swept_elm,D_WorkStrCopySize,D_WorkStrTopOfst,
	   updated_size_ofst, updated_pagetop_ptr));
  } else {
    $CALL(s_GCNWordMarkWithMRBor_Sub
	  (sweep_ptr,swept_elm,D_WorkStrCopySize,D_WorkStrTopOfst,
	   updated_size_ofst, updated_pagetop_ptr));
  }
  $RELEASE(D_WorkStrTopOfst);  $RELEASE(D_WorkStrCopySize);
}

/******************************************************************** PSL **
  [ 5. REF$B$N(BGC$B=hM}(B ($B:o=|(B) ]
    s_GCRef

       written by imai@icot22      on Sat Feb 10 12:26:16 1990
<Arguments>
  sweep_ptr (src):	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B8=:_%9%$!<%WCf$N%o!<%I$X$N%]%$%s%?(B
  swept_elm (src):	($B%?%0$r4^$a$F0UL#$r;}$D(B)
	$B5lNN0h$K$"$k(BREF$B%]%$%s%?!#%?%$%W$O(B REF
	(swept_elm = *sweep_ptr $B$G$"$k(B)
  updated_size_ofst (dst):	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B99?7$5$l$?%Z!<%8%H%C%W$N%;!<%VNN0h$N%*%U%;%C%H(B
  updated_pagetop_ptr (dst):	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B99?7$5$l$?%Z!<%8%H%C%W$NCM(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%G%l%U%!%l%s%9$r9T$$!"@h$,6qBN2=$7$F$$$k$+$I$&$+$r%A%'%C%/$9$k!#(B
  1) $B6qBN2=$7$F$$$k>l9g(B
      DEREF $B$N8e(B sweep_ptr $B$N;X$9@h$r=q$-49$(!"(Bsweep_ptr$B$r?J$a$J$$$G!"(B
      $B$b$&0lEY!"$3$N%k!<%W$r2s$k$h$&$K$9$k!#$3$N7k2L!"ITMW$J(BRead
      $B$,(B1$BEYF~$k$,!"4V0c$$$J$/%-%c%C%7%e$K%R%C%H$9$k$N$G!"(B
      $BEvLL$O!"$3$l$G5v$7$F$b$i$&!#(B
          (DEREF $BA0(B)
              Register  |     Memory
              |-------| |   |-------|     |-------|     |-------|      
     sweep_ptr|     ----|-->| REF ------> | REF ------> |Atom!a |
              |-------| |   |-------|     |-------|     |-------|      
          (DEREF $B8e(B)    |$B$3$N%;%k$K=q$-9~$`(B
              |-------| |   |-------|
     sweep_ptr|     ----|-->| Atom!a|
              |-------| |   |-------|
                        |
    
  2) $B6qBN2=$7$F$$$J$$>l9g(B
      DEREF$B7k2L$r=q$-La$7$F!"L$Dj5AJQ?t%;%k$N%3%T!<$r9T$&(B
          (DEREF $BA0(B)
              Register  |     Memory
              |-------| |   |-------|     |-------|     |-------|      
     sweep_ptr|     ----|-->| REF ------> | REF ------> |UNDF   |
              |-------| |   |-------|     |-------|     |-------|      
          (DEREF $B8e(B)    |
              |-------| |   |-------|     |-------|
     sweep_ptr|     ----|-->| REF ------> |PtrToNew|------------------->
              |-------| |   |-------|     |-------|
                        |
        
<Examples>
<Test>
<Explanation>
  >>>>> $BHFMQ$N%G%l%U%!%l%s%9%k!<%A%s$r;H$o$J$$M}M3(B <<<<<

  $BHFMQ%k!<%A%s$O(BMRB$B!{$N;~$K(B1$B%o!<%I%;%k$r2s<}$9$k$,!"(B
  $B$3$l$,L@$+$KL5BL$J=hM}$G$"$k$?$a!#(B($B2s<}$7$FC/$,;H$&$H8@$&$N$@(B!!)

<ETC>
********************************************************************* PSL **/

/*** $B:o=|(B in s_GCTypeDispatch ***/

/******************************************************************** PSL **
  6. $B%4!<%k%l%3!<%I$N(BGC$B=hM}(B
    s_GCGoalRecord

       written by imai@icot22      on Sat Feb 10 20:06:22 1990
       revised by imai@icot22      on Fri Oct  5 17:10:53 1990
<Arguments>
  sweep_ptr (src):	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B8=:_%9%$!<%WCf$N%o!<%I$X$N%]%$%s%?(B
  swept_elm (src):	($B%?%0$r4^$a$F0UL#$r;}$D(B)
	$B5lNN0h$K$"$k%4!<%k%l%3!<%I$X$N%]%$%s%?!#%?%$%W$O(B HOOK
	(swept_elm = *sweep_ptr $B$G$"$k(B)
  updated_size_ofst (dst):	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B99?7$5$l$?%Z!<%8%H%C%W$N%;!<%VNN0h$N%*%U%;%C%H(B
	(_PageTop16Word or _PageTop32Word)
  updated_pagetop_ptr (dst):	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B99?7$5$l$?%Z!<%8%H%C%W$NCM(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
   $BI,$:!"C10l;2>H$G$"$k;v$,J]>Z$5$l$F$$$k(B
<Revised Memo on "Oct  5">
   $B1J5WCfCG%4!<%k$rH/8+$9$k$?$a!"%3%T!<$7$?$3$H$rH=Dj$9$k$?$a$K%^!<%/$r(B
  $B$D$1$k$3$H$K$J$C$?!#!J$A$g$C$HHa$7$$!*!K(B
********************************************************************* PSL **/
#DATA_define D_WorkOfstCheck XXX   /* for DEBUG */

#CONST_define _GOAL_RECORD_OFST_CHECK_MASK	0x0000000f

#PSL_define s_GCGoalRecord
	(sweep_ptr,swept_elm,updated_size_ofst,updated_pagetop_ptr)
{
  @DEBUG{ /*----------$B8F$S$@$7>r7o(B-------------*/
    s_IfNotSingleHookGrp(swept_elm) {
      VPIM_ERROR("s_GCGoalRecord","Not HOOK nor EHOOK");
    }
    s_IfNotOldArea(swept_elm) {
      VPIM_ERROR("s_GCGoalRecord","swept_elm does not point old area!");
    }
    /*--- $B%*%U%;%C%H$O#1$N$O$:(B ---*/
    $USE(D_WorkOfstCheck);
    b_BitwiseAndImmediateWithDNTC
      (swept_elm,_GOAL_RECORD_OFST_CHECK_MASK,D_WorkOfstCheck);
    b_IfNotEqualImm(D_WorkOfstCheck,_ONE){
      VPIM_ERROR("s_GCGoalRecord","Illegal_Pointer");
    }
    $RELEASE(D_WorkOfstCheck);
  };
  $USE(D_WorkStrCopySize); $USE(D_WorkStrTopOfst);
  $USE(D_WorkStrAllocSize);

  $USE(D_WorkFPPtr);

  /* $B=jB0$9$kN$?F$N>uBV$r8+$k(B */
  s_GetFosterparentGoalRecord(swept_elm,D_WorkFPPtr);
  s_IfAbortedOrAbortedTerminateFP(D_WorkFPPtr) {
	/* $B0z?t$O%3%T!<$7$J$$(B */
    s_PutArityGoalRecord(swept_elm,D_NULL);	/* $B5lNN0h$K0z?t#0$r=q$-9~$`(B */
    b_SetImmValueDNTC(_SIZE_OF_SHORT_GR,D_WorkStrAllocSize);
    b_SetImmValueDNTC(_SIZE_OF_CTRL_INFO_GR,D_WorkStrCopySize);
	/* $B%3!<%I$b%3%T!<$7$J$$$h$&$K(B EOL $B$r=q$-9~$s$G$*$/(B */
    p_WriteWithOffset(D_EOL,swept_elm,_CODE_PTR_OFST_GR);
	/* $B1J5WCfCG%4!<%k$NH/8+%U%'!<%:$G$O!"(BGOAL $B%?%$%W$N$D$$$F$$$J$$(B
         * $B$b$N$,8=$l$k2DG=@-$,$"$k$N$G!"(BGOAL$B%?%$%W$K$9$k(B
         */
  } else {
	  /* Alloc Size$B$r5a$a$k(B */
    s_GetArityGoalRecord(swept_elm, D_WorkStrCopySize);	/* (1) */
    b_IfMARKED(D_WorkStrCopySize) {
    /* $B1J5WCfCG%4!<%k$N%3%T!<$N;~$K$O!"(B
     * $B4{$K%^!<%/$5$l$F$$$k$H$$$&$3$H$,$"$j$&$k(B !!
     */
      b_SetImmValueDNTC(_SIZE_OF_SHORT_GR,D_WorkStrAllocSize);
      b_SetImmValueDNTC(_SIZE_OF_CTRL_INFO_GR,D_WorkStrCopySize);
    } else {
      b_IfLessEqImm (D_WorkStrCopySize, _MAX_ARGS_SHORT_GR){
	b_SetImmValueDNTC(_SIZE_OF_SHORT_GR,D_WorkStrAllocSize);
      } else {
	b_SetImmValueDNTC(_SIZE_OF_LONG_GR,D_WorkStrAllocSize);
      }
    }
	  /* -- Copy Size $B$rF@$k(B -- */  
    b_AddImmediateWithTag(D_WorkStrCopySize,_SIZE_OF_CTRL_INFO_GR,D_WorkStrCopySize);
  }
    		/* (1) $B$H$NB-$7;;$G(B Copy Size $B$rF@$k(B */
  /* -------------- GC$B=hM}(B ---------------------------------- */
  b_SetImmValueDNTC(_ARITY_OFST_GR,D_WorkStrTopOfst);
  s_GetUpdatePageTopOfst(D_WorkStrAllocSize,updated_size_ofst);
  s_GCUnderPageSizeMark
	(sweep_ptr,swept_elm,D_WorkStrTopOfst,D_WorkStrCopySize,
	 D_WorkStrAllocSize, updated_size_ofst, updated_pagetop_ptr);
  s_IfModifiedPageTop(updated_size_ofst){
    s_IncrementChildCountInGC(D_WorkFPPtr);
  }
  $RELEASE(D_WorkFPPtr);
  $RELEASE(D_WorkStrAllocSize);$RELEASE(D_WorkStrCopySize);
  $RELEASE(D_WorkStrTopOfst);
}

/******************************************************************** PSL **
  7. $BGrM"F~I=$N(BGC$B=hM}(B
    s_GCWImpRec

       written by imai@icot22      on Sat Feb 10 20:30:18 1990
<Arguments>
  sweep_ptr (src):	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B8=:_%9%$!<%WCf$N%o!<%I$X$N%]%$%s%?(B
  swept_elm (src):	($B%?%0$r4^$a$F0UL#$r;}$D(B)
	$B5lNN0h$K$"$k%]%$%s%?!#%?%$%W$O(B WEXREF or WEXVAL
	(swept_elm = *sweep_ptr $B$G$"$k(B)
  updated_size_ofst (dst):	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B99?7$5$l$?%Z!<%8%H%C%W$N%;!<%VNN0h$N%*%U%;%C%H(B
	($B>o$K(B_PAGE_TOP_NOT_MODIFIED)
  updated_pagetop_ptr (dst):	($B%?%0It$O0UL#$r;}$?$J$$(B)
	($B>o$K0UL#$r;}$?$J$$(B)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $BGrM"F~I=$O!"%R!<%W$K$H$i$l$J$$$N$G!"%3%T!<$9$k$N$G$O$J$/!"%^!<%/$9$k(B
  $B$@$1$G$"$k(B
<ETC>
  $B#G#C=hM}$,=*N;$7$?8e$GGrM"F~I=%(%j%"$r%9%-%c%s$9$k!#(B
  $B$3$N;~!"%?%$%W$,(B
  (1) FLC	: $B2?$b$7$J$$$G$h$$!#(B
  (2) MARKED	: $B$^$@@8$-$F$$$k$N$G!"(BINT $B$KLa$9!#(B
  (3) INT	: $B#G#C$K$h$C$FITMW$K$J$C$?$3$H$,H=L@$7$?$N$G(B
		  $B%U%j!<%j%9%H$KJV$9!#(B
********************************************************************* PSL **/

#PSL_define s_GCWImpRec
	(sweep_ptr,swept_elm,updated_size_ofst,updated_pagetop_ptr)
{
  $USE(D_WorkElement);
  p_Read(swept_elm,D_WorkElement);
  s_GCMarkReg(D_WorkElement);
  p_Write(D_WorkElement,swept_elm);
  $RELEASE(D_WorkElement);
  b_IncrementAddrReg(sweep_ptr);
  s_SetPageTopNotModified(updated_size_ofst);
}

/******************************************************************** PSL **
  8. $B9uM"F~I=$N(BGC$B=hM}(B
    s_GCBImpRec

       written by imai@icot22      on Sat Feb 10 20:32:58 1990
<Arguments>
  sweep_ptr (src):	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B8=:_%9%$!<%WCf$N%o!<%I$X$N%]%$%s%?(B
  swept_elm (src):	($B%?%0$r4^$a$F0UL#$r;}$D(B)
	$B5lNN0h$K$"$k%]%$%s%?!#%?%$%W$O(B BEXREF or BEXVAL
	(swept_elm = *sweep_ptr $B$G$"$k(B)
  updated_size_ofst (dst):	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B99?7$5$l$?%Z!<%8%H%C%W$N%;!<%VNN0h$N%*%U%;%C%H(B
	($B>o$K(B _PAGE_TOP_8WORD)
  updated_pagetop_ptr (dst):	($B%?%0It$O0UL#$r;}$?$J$$(B)
	($B>o$K(B $B#8%o!<%I$N%Z!<%8%H%C%W$NCM$,JV$C$F$/$k(B)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  $B9uM"F~I=$OC10l;2>H$,J]>Z$5$l$F$$$k$,!"%^!<%/IU$1$r9T$C$F$*$+$J$$$H(B
  $B8e$G%9%$!<%W$9$k;~$K!"%3%T!<:Q$_$+$I$&$+$,H=Dj$G$-$J$$$?$a!"(B
	  s_GCUnderPageSizeMark
  $B$r;H$C$F$$$k!#$3$N%^%/%mCf$G$O!"%^!<%/IU$1;~$KGSB>@)8f$r9T$C$F$$$k$,!"(B
  $BK\MhI,MW$N$J$$$b$N$G$"$k!#(B
********************************************************************* PSL **/

#PSL_define s_GCBImpRec
	(sweep_ptr,swept_elm,updated_size_ofst,updated_pagetop_ptr)
{
  @DEBUG{
    s_IfNotBEXT(swept_elm) {
      VPIM_ERROR("s_GCBimpRec","Not BEXVAL nor BEXREF");
    }
    s_IfNotOldArea(swept_elm) {
      VPIM_ERROR("s_GCBimpRec","swept_elm does not point old area!");
    }
  };
  $USE(D_WorkStrAllocSize); $USE(D_WorkStrCopySize);
  $USE(D_WorkStrTopOfst);
  b_SetImmValueDNTC(_BIMP_REC_ALLOC_SIZE,D_WorkStrAllocSize);
  b_SetImmValueDNTC(_BIMP_REC_SIZE,D_WorkStrCopySize);
  b_SetImmValueDNTC(_ZERO,D_WorkStrTopOfst);
  s_GetUpdatePageTopOfst(D_WorkStrCopySize,updated_size_ofst);
  s_GCUnderPageSizeMark
	(sweep_ptr,swept_elm,D_WorkStrTopOfst,D_WorkStrCopySize,
	 D_WorkStrAllocSize, updated_size_ofst, updated_pagetop_ptr);
  $RELEASE(D_WorkStrTopOfst);
  $RELEASE(D_WorkStrCopySize);
  $RELEASE(D_WorkStrAllocSize);
}

/******************************************************************** PSL **
  $B%R!<%W$KCV$+$l$?9uM"=P%l%3!<%IK\BN$N%3%T!<(B
       written by imai@icot22      on Mon Jul  2 10:47:29 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_GCBExpRec
	(sweep_ptr,swept_elm,updated_size_ofst,updated_page_top_ptr)
{
  $USE(D_WorkStrCopySize);
  b_SetImmValueDNTC(_BEXP_REC_SIZE,D_WorkStrCopySize);
  $CALL(s_GCNWordMark_Sub
	(sweep_ptr,swept_elm,D_WorkStrCopySize,D_NULL,
	 updated_size_ofst,updated_page_top_ptr));
  $RELEASE(D_WorkStrCopySize);
}

#PSL_define s_GCRHOOK
	(sweep_ptr,swept_elm,updated_size_ofst,updated_page_top_ptr)
{
  $USE(D_WorkStrCopySize);
  b_SetImmValueDNTC(_REPLY_REC_SIZE,D_WorkStrCopySize);
  $CALL(s_GCNWordNoMark_Sub
	(sweep_ptr,swept_elm,D_WorkStrCopySize,D_NULL,
	 updated_size_ofst,updated_page_top_ptr));
  $RELEASE(D_WorkStrCopySize);
}


/******************************************************************** PSL **
  9. CDESC$B$N(BGC$B=hM}(B
     s_GC_CDESC

       written by imai@icot22      on Sat Feb 10 20:34:56 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
   CDESC$B$,8=$l$?$i!"$=$N8e$NNN0hJ,!"%9%$!<%W%]%$%s%?$r?J$a$k!#(B
<ETC> 
********************************************************************* PSL **/

#PSL_define s_GC_CDESC
	  (sweep_ptr,swept_elm,updated_size_ofst,updated_pagetop_ptr)

{
  s_GetStringSizeWithDesc(swept_elm,swept_elm);
  b_ExchangeElmposToOffset(swept_elm, swept_elm); /* $BMWAG?t(B ==> $B%*%U%;%C%H(B */
  b_IncrementAddrReg(sweep_ptr);
  b_AddWithTag(sweep_ptr,swept_elm,sweep_ptr);
  s_SetPageTopNotModified(updated_size_ofst);
}

/******************************************************************** PSL **
 10. $B%3!<%I$N(BGC$B=hM}(B
    s_GCCode
    s_GCModule

       written by imai@icot22      on Sat Feb 10 20:59:28 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  CAL $B$NJQ99$K$h$j!"%b%8%e!<%k308F$S=P$7$N%-%c%C%7%eNN0h$b(B
  $BL58z2=$7$J$$(B
********************************************************************* PSL **/

#PSL_define s_GCCode
	(sweep_ptr,swept_elm,updated_size_ofst,updated_pagetop_ptr)
{
  s_IfSystemArea(swept_elm) { /* $B#D!]#C#o#d#e%"%I%l%9(B ==> $B%3%T!<$7$J$$(B */
    b_IncrementAddrReg(sweep_ptr);
    s_SetPageTopNotModified(updated_size_ofst);
  } else {
    $USE(D_WorkStrTopOfst); $USE(D_WorkStrCopySize);
    s_GetModuleTopFromCode(swept_elm, D_WorkStrTopOfst);
    p_Read(D_WorkStrTopOfst,D_WorkStrCopySize);
    b_SubtractWithTag(D_WorkStrTopOfst,swept_elm,D_WorkStrTopOfst);
    $CALL(s_GCNWordMark_Sub
	  (sweep_ptr,swept_elm,D_WorkStrCopySize,D_WorkStrTopOfst,
	   updated_size_ofst, updated_pagetop_ptr));
    $RELEASE(D_WorkStrCopySize);
    $RELEASE(D_WorkStrTopOfst);
  }
}

#PSL_define s_GCModule
	(sweep_ptr,swept_elm,updated_size_ofst,updated_pagetop_ptr)
{
  s_IfSystemArea(swept_elm) { /* $B#D!]#C#o#d#e%"%I%l%9(B ==> $B%3%T!<$7$J$$(B */
    b_IncrementAddrReg(sweep_ptr);
    s_SetPageTopNotModified(updated_size_ofst);
  } else {
    $USE(D_WorkStrTopOfst); $USE(D_WorkStrCopySize);
    p_Read(swept_elm,D_WorkStrCopySize);
    b_SetImmValueDNTC(_ZERO,D_WorkStrTopOfst);
    $CALL(s_GCNWordMark_Sub
	  (sweep_ptr,swept_elm,D_WorkStrCopySize,D_WorkStrTopOfst,
	   updated_size_ofst, updated_pagetop_ptr));
    $RELEASE(D_WorkStrCopySize);
    $RELEASE(D_WorkStrTopOfst);
  }
}

/******************************************************************** PSL **
 11. $BAq1`%l%3!<%I$N(BGC$B=hM}(B
    s_GCShoenRecord_Sub

       written by imai@icot22      on Sat Feb 10 21:12:22 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  1991.11.8	$B8F$S=P$7IQEY$N3d$K!"%3!<%I$,Bg$-$$$N$G!"%5%V%k!<%A%s$K$7$?(B
********************************************************************* PSL **/

#SUBARG_define A_SweepPtr	MODIFY
#SUBARG_define A_SweptElm	MODIFY
#SUBARG_define A_UpdatedSizeOfst	DST
#SUBARG_define A_UpdatedPagetopPtr	DST

#SUBROUTINE s_GCShoenRecord_Sub
	(A_SweepPtr,A_SweptElm,A_UpdatedSizeOfst,A_UpdatedPagetopPtr)
{
  $USE(D_WorkStrCopySize);  $USE(D_WorkStrAllocSize);
  $USE(D_WorkStrTopOfst);
  b_SetImmValueDNTC(_SIZE_OF_SH_REC,D_WorkStrAllocSize);
  b_SetImmValueDNTC(_VALID_SIZE_OF_SH_REC,D_WorkStrCopySize);
  b_SetImmValueDNTC(_ZERO,D_WorkStrTopOfst);
  s_GetUpdatePageTopOfst
	(D_WorkStrCopySize, A_UpdatedSizeOfst);
  s_GCUnderPageSizeMark
	(A_SweepPtr,A_SweptElm,D_WorkStrTopOfst,D_WorkStrCopySize,
	 D_WorkStrAllocSize,  A_UpdatedSizeOfst, A_UpdatedPagetopPtr);
  /*---- $B%A%c%$%k%I%+%&%s%H$N%a%s%F%J%s%9(B -----*/
  s_IfModifiedPageTop(A_UpdatedSizeOfst){

    s_IfShoenTransitStatusImmediately(A_SweptElm,_TERMINATED)
      {/* $B;RAq1`%j%s%/$+$i30$5$l$F$$$F!"%4!<%k$+$i$O$^$@;X$5$l$F$$$k(B
          $BAq1`%l%3!<%I$C$F%'$N$,M-$k$N$h!#(B
         $B!JAq1`%b%8%e!<%k$N%3%s%H%m!<%k=R8l!K(B */;
     }else{
      $USE(D_WorkFPPtr);
      s_GetFPRecordOfShoen(A_SweptElm,D_WorkFPPtr);
      s_IncrementChildCountInGC(D_WorkFPPtr);
      $RELEASE(D_WorkFPPtr);
    }
  }
  $RELEASE(D_WorkStrTopOfst); $RELEASE(D_WorkStrAllocSize);
  $RELEASE(D_WorkStrCopySize);
  $RETURN();
}

/******************************************************************** PSL **
 12. $BN$?F%l%3!<%I$N(BGC$B=hM}(B
    s_GCFosterParentRecord

       written by imai@icot22      on Sat Feb 10 21:12:22 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_GCFosterParentRecord
	(sweep_ptr,swept_elm,updated_size_ofst,updated_pagetop_ptr)
{
  s_IfSystemArea(swept_elm) { /*=== $B%@%_!<N$?F(B ===*/
    /* $B%R!<%W$G$O$J$$$H$3$m$KCV$+$l$F$$$k$N$G%3%T!<$7$J$$(B */
    b_IncrementAddrReg(sweep_ptr);
    s_SetPageTopNotModified(updated_size_ofst);
  } else {
    $USE(D_WorkStrCopySize);  $USE(D_WorkStrAllocSize);
    $USE(D_WorkStrTopOfst);
    b_SetImmValueDNTC(_SIZE_OF_FP_RECORD,D_WorkStrAllocSize);
    b_SetImmValueDNTC(_VALID_SIZE_OF_FP_RECORD,D_WorkStrCopySize);
    b_SetImmValueDNTC(_ZERO,D_WorkStrTopOfst);
    s_GetUpdatePageTopOfst(D_WorkStrCopySize,updated_size_ofst);
    s_GCUnderPageSizeMark
      (sweep_ptr,swept_elm,D_WorkStrTopOfst,D_WorkStrCopySize,
       D_WorkStrAllocSize, updated_size_ofst, updated_pagetop_ptr);
    s_IfModifiedPageTop(updated_size_ofst){
      /* $B?7NN0h$N(B Child Count In GC $B$r(B $B%/%j%"$9$k(B */
      $USE(D_WorkNewReg);
      p_Read(swept_elm,D_WorkNewReg);
      p_SetImmediateType(FPREC,D_WorkNewReg);
      s_PutFPChildCountInGC(D_WorkNewReg,D_NULL);
      $RELEASE(D_WorkNewReg);
    }
    $RELEASE(D_WorkStrTopOfst);
    $RELEASE(D_WorkStrAllocSize); $RELEASE(D_WorkStrCopySize);
  } 
}

/******************************************************************** PSL **
 13. $B%^!<%8%c%;%k$N(BGC$B=hM}(B
    s_GCMergerCell

       written by imai@icot22      on Tue Feb 20 12:10:32 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $B=jB0$9$kN$?F$,%"%\!<%H>uBV$G$"$C$?>l9g$N=hM}$OHs>o$KJ#;($G$"$k(B

$B%9%$!<%WA0(B		merger cell($B5lNN0h(B)
	+-------+	+-------+
sweep-->| MGHOK ------->|	|
	+-------+	+-------+
			|	|
			+-------+

$B%9%$!<%W8e(B		$B#1%o!<%I%;%k(B($B?7NN0h(B)
	+-------+	+-------+
sweep-->| REFo  ------->| EUNDF	| %% MGHOK $B$H(B EMGHOK $B$,6&DL%k!<%A%s$N$?$a(B
	+-------+	+-------+

<ETC>
********************************************************************* PSL **/

#PSL_define s_GCMergerCell
	(sweep_ptr,swept_elm,updated_size_ofst,updated_pagetop_ptr)
{
  $USE(D_WorkStrCopySize);  $USE(D_WorkStrAllocSize);
  $USE(D_WorkStrTopOfst);

  b_SetImmValueDNTC(_SIZE_OF_MERGER_RECORD,D_WorkStrAllocSize);
  b_SetImmValueDNTC(_VALID_SIZE_OF_MERGER_RECORD,D_WorkStrCopySize);
  b_SetImmValueDNTC(_ZERO,D_WorkStrTopOfst);
  $USE(D_WorkFPPtr);
  s_GetMergerFPPtr(swept_elm,D_WorkFPPtr);
  s_IfAbortedOrAbortedTerminateFP(D_WorkFPPtr) {
    /* $BN$?F$,%"%\!<%H>uBV$G$"$C$?(B */
    @DEBUG{WARNING("s_GCMergerCell","Aborted FP!!");};
    @PROBE {
      b_IncrementReg(D_GC_MRBo_COUNT);
      b_IncrementReg(D_GC_COPIED_WORDS_UNDER_PAGE);
    };
    /* GOAL $B%?%$%W$rL58z2=$9$k(B */
    p_WriteWithOffset(D_NULL,swept_elm,_GOAL_TYPE_OFST_MGR);
    /* $B#1%o!<%I$N%Z!<%8$r99?7$9$k(B */
    b_SetImmValueDNTC(_PAGE_TOP_1WORD,updated_size_ofst);
    s_CachePageTopPtr(updated_size_ofst,updated_pagetop_ptr);
    $USE(D_WorkNewReg);
    /* $B%Z!<%8%H%C%W$K!"(BEUNDF$B$r=q$/(B */
    b_SetImmTypeValueMRBoff(EUNDF,_ZERO,D_WorkNewReg);
    s_WriteElementToHeapTop(D_WorkNewReg,updated_pagetop_ptr);

    /* $B%9%$!<%W%]%$%s%?$N;X$9@h$K(B REFo $B$r=q$/(B */
    b_MoveWithImmTypeMRBoff(updated_pagetop_ptr,REF,D_WorkNewReg);
    p_Write(D_WorkNewReg,sweep_ptr);

    b_IncrementAddrReg(updated_pagetop_ptr);
    b_IncrementAddrReg(sweep_ptr);

    /* $B$3$l$r8F$S=P$7$?8e!"#1%o!<%I$N%Z!<%8$r;H$$@Z$C$?$+$I$&$+$NH=Dj$,F~$k(B */
    $RELEASE(D_WorkNewReg);
  } else {
    s_GetUpdatePageTopOfst(D_WorkStrCopySize,updated_size_ofst);
    s_GCUnderPageSizeMark
      (sweep_ptr,swept_elm,D_WorkStrTopOfst,D_WorkStrCopySize,
       D_WorkStrAllocSize, updated_size_ofst, updated_pagetop_ptr);
  /* -------------- $B%A%c%$%k%I%+%&%s%H$N%a%s%F%J%s%9(B ---------------- */
    s_IfModifiedPageTop(updated_size_ofst) {
      s_IncrementChildCountInGC(D_WorkFPPtr);
    }
  }
  $RELEASE(D_WorkFPPtr);
  $RELEASE(D_WorkStrTopOfst);
  $RELEASE(D_WorkStrAllocSize); $RELEASE(D_WorkStrCopySize);
}

/******************************************************************** PSL **
$B%5%9%Z%s%I%l%3!<%I4X78(B
       written by imai@icot22      on Thu Oct  4 10:26:49 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_GCSuspendRecordNoMark
	(sweep_ptr,swept_elm,updated_size_ofst,updated_page_top_ptr)
{
  s_GC2WordNoMark(sweep_ptr,swept_elm,updated_size_ofst,updated_page_top_ptr);
  @PROBE{ b_AddImmediateWithTag(D_GC_SuspendRecordCnt,_TWO,D_GC_SuspendRecordCnt); };
}

#PSL_define s_GCSuspendRecordMark
	(sweep_ptr,swept_elm,updated_size_ofst,updated_page_top_ptr)
{
  s_GC2WordMark(sweep_ptr,swept_elm,updated_size_ofst,updated_page_top_ptr);
  @PROBE{
    s_IfModifiedPageTop(updated_size_ofst) {
      b_AddImmediateWithTag(D_GC_SuspendRecordCnt,_TWO,D_GC_SuspendRecordCnt);
    }};
}
