
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/structures/str_gc_pre_post.psl.c
   ----- CREATED   : by f-hataza@icot22, on Thu Jun 21 16:29:30 1990
   ----- LAST SAVED: by imai@ss-pimp2, on Fri May  1 19:28:08 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : STRUCTURES
   ----- ABSTRACT  : $B#G#C$NA08e$G9T$J$&=hM}$r=8$a$?%U%!%$%k(B

  1. $B?7NN0h$N%Z!<%83NJ](B
  2. $B#G#C%k!<%H$N%3%T!<(B
  3. $B%R!<%W$N@ZBX$((B
  4. $B#G#C%9%?%C%/$N=i4|2=(B
  5. $B%-%c%C%7%e$N=q$-La$7(B
  6. $B%"%$%I%k%4!<%k%9%?%C%/%(%s%H%j$N<h$j=P$7(B
  7. $B#G#C=*N;8e$N%U%j!<%j%9%H@8@.(B
  8. $B%]%$%s%?%;!<%V%(%j%"$N=i4|2=(B
  9. $B#G#C=*N;8e!"5lNN0h$K%4%_%G!<%?$r=q$-9~$`(B
 10. $B#G#C=*N;8e!"1J5WCfCG>uBV$K4Y$C$?!J6KBg!K%4!<%k$r8!=P$9$k(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */


/******************************************************************** PSL **
  1. $B?7NN0h$N%Z!<%83NJ](B
    s_GCInitAllocNewAreaPage

       written by imai@icot22      on Mon Jul  3 12:01:22 1989
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $BA4%5%$%:J,$N%Z!<%8$r3NJ]$9$k!#$?$@$7!"#2#5#6%o!<%I$r1[$($k$b$N$K4X$7$F$O(B
  $BI,MW$K$J$C$?;~E@$G!"I,MW$K$J$C$?J,$@$13NJ]$9$k$N$G!"=i4|2=;~$K$O3NJ]$7$J$$!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_GCInitAllocNewAreaPage()
{
  @PROBE{ s_ClearGCCounter(); };
  b_ReadGlobalHeapEnd(D_CurrentHeapEndPtr);
  $USE(D_WorkPtr);
	/*** 1 Word ***/
  s_AllocOnePageGC(D_WorkPtr);
  s_DecachePageTopPtrImmSize(_PAGE_TOP_1WORD,D_WorkPtr);
  s_DecacheSweepPtrImmSize(_SWEEP_1WORD,D_WorkPtr);
	/*** 2 Word ***/
  s_AllocOnePageGC(D_WorkPtr);
  s_DecachePageTopPtrImmSize(_PAGE_TOP_2WORD,D_WorkPtr);
  s_DecacheSweepPtrImmSize(_SWEEP_2WORD,D_WorkPtr);
	/*** 4 Word ***/
  s_AllocOnePageGC(D_WorkPtr);
  s_DecachePageTopPtrImmSize(_PAGE_TOP_4WORD,D_WorkPtr);
  s_DecacheSweepPtrImmSize(_SWEEP_4WORD,D_WorkPtr);
	/*** 8 Word ***/
  s_AllocOnePageGC(D_WorkPtr);
  s_DecachePageTopPtrImmSize(_PAGE_TOP_8WORD,D_WorkPtr);
  s_DecacheSweepPtrImmSize(_SWEEP_8WORD,D_WorkPtr);
	/*** 16 Word ***/
  s_AllocOnePageGC(D_WorkPtr);
  s_DecachePageTopPtrImmSize(_PAGE_TOP_16WORD,D_WorkPtr);
  s_DecacheSweepPtrImmSize(_SWEEP_16WORD,D_WorkPtr);
	/*** 32 Word ***/
  s_AllocOnePageGC(D_WorkPtr);
  s_DecachePageTopPtrImmSize(_PAGE_TOP_32WORD,D_WorkPtr);
  s_DecacheSweepPtrImmSize(_SWEEP_32WORD,D_WorkPtr);
	/*** 64 Word ***/
  s_AllocOnePageGC(D_WorkPtr);
  s_DecachePageTopPtrImmSize(_PAGE_TOP_64WORD,D_WorkPtr);
  s_DecacheSweepPtrImmSize(_SWEEP_64WORD,D_WorkPtr);
	/*** 128 Word ***/
  s_AllocOnePageGC(D_WorkPtr);
  s_DecachePageTopPtrImmSize(_PAGE_TOP_128WORD,D_WorkPtr);
  s_DecacheSweepPtrImmSize(_SWEEP_128WORD,D_WorkPtr);
	/*** 256 Word ***/
  $RELEASE(D_WorkPtr);  
  s_DecachePageTopPtrImmSize(_PAGE_TOP_256WORD,D_NULL);
  s_DecacheSweepPtrImmSize(_SWEEP_256WORD,D_NULL);
}

/******************************************************************** PSL **
  2. $B#G#C%k!<%H$N%3%T!<(B
   2.1 $B%l%G%#!<%4!<%k%9%?%C%/$+$i;X$5$l$k#G#C%k!<%H$N%3%T!<(B
   s_CopyGCRootReadyGoalStackEntry

       written by imai@icot22      on Mon Jul  3 12:08:51 1989
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%l%G%#%4!<%k%9%?%C%/$+$i;X$5$l$k#G#C%k!<%H$r?7NN0h$K%3%T!<$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
  $B8=:_$N%$%s%W%j%a%s%F!<%7%g%s$O!"%k!<%H$O(B
  $B!&%l%G%#%4!<%k%9%?%C%/(B
  $B!&%/%i%9%?FbIi2YJ,;6MQ$N%4!<%k%]%9%H(B
********************************************************************* PSL **/

#PSL_define s_CopyGCRootReadyGoalStackEntry()
{
  $USE(D_WorkStackEntryPtr);
  s_GetIdleGoalStackEntry(D_WorkStackEntryPtr);
  $USE(D_WorkGoalPtr);
  LOOP() {
    b_AddImmediateWithDNTC(D_WorkStackEntryPtr,_GR_PTR_OFST_STE,D_WorkGoalPtr);
    s_GCRootGoalRecord(D_WorkGoalPtr);
    s_GetHighStackEntry(D_WorkStackEntryPtr,D_WorkStackEntryPtr);
    b_IfEOL(D_WorkStackEntryPtr) { break; }
  }
  $RELEASE(D_WorkGoalPtr);
  $RELEASE(D_WorkStackEntryPtr);
}

#PSL_define s_CopyGCRootInnerClusterGoalPost()
{
  $USE(D_WorkGoalPtr);
  b_GetGoalPostAddrToPE (D_PE_Number , D_WorkGoalPtr);
  s_GCRootGoalRecord(D_WorkGoalPtr);
  $RELEASE(D_WorkGoalPtr);
}

/******************************************************************** PSL **
   2.2 $B%4!<%k%l%3!<%I$+$i;X$5$l$k#G#C%k!<%H$N%3%T!<(B
     s_GCRootGoalRecord()

       written by imai@icot22      on Tue Feb 20 17:24:59 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  ptr_to_root $B$O!"@55,$N(B sweep_ptr $B$G$O$J$$$?$a(B($B?7NN0h$X$N%]%$%s%?$G$O$J$$(B)
  $B$?$H$((B modify $B$5$l$F$b(B decache $B$7$F$O$$$1$J$$!#(B
  $B$?$@$7!"%9%?%C%/$KF~$l$k$h$&$J>u67$r$N$>$/!#(B
<ETC>
********************************************************************* PSL **/

#PSL_define s_GCRootGoalRecord(ptr_to_root)
{
  $USE(D_WorkStrElement);
  $USE(D_WorkUpdatedSizeOfst);
  $USE(D_WorkUpdatedPageTop);
  p_Read(ptr_to_root,D_WorkStrElement);
  TypeSwitch(D_WorkStrElement) {
  case HOOK:
    s_GCGoalRecord(ptr_to_root,D_WorkStrElement,
		   D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop);
    @DEBUG{
      s_IfNotModifiedPageTop(D_WorkUpdatedSizeOfst) {
	VPIM_ERROR("s_GCRootGoalRecord","Why not modified?");
      }
    };
    $CALL(s_HeapAcquirementUnitCheckInRootCopy_Sub
	  (D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop));
    break;
  case EOL:
    break;
  default:
    @DEBUG{VPIM_ERROR("s_GCRootGoalRecord","Illegal Type D_WorkStrElement");};
  }
  $RELEASE(D_WorkUpdatedPageTop);
  $RELEASE(D_WorkUpdatedSizeOfst);
  $RELEASE(D_WorkStrElement);
}

/******************************************************************** PSL **
   2.4 $BM"=PI=$+$i;X$5$l$k#G#C%k!<%H$N%3%T!<(B
     s_CopyGCRootWhiteExportTable

       written by imai@icot22      on Thu Mar 22 14:34:14 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_CopyGCRootExportTable()
{
  $USE(D_WorkSweepPtr);$USE(D_WorkSize);$USE(D_WorkUpdatedSizeOfst);
  $USE(D_WorkUpdatedPageTop); $USE(D_WorkStrElement);

  /* PE $BKh$K(B $B%9%$!<%W$r3+;O$9$k0LCV$H%5%$%:$r5a$a$k(B */
  s_DivideAreaAndGetStartAddrAndSize
    (_EXP_REC_BASE,_EXP_REC_SIZE,D_WorkSweepPtr,D_WorkSize);
  LOOP() {
    p_Read(D_WorkSweepPtr,D_WorkStrElement);
    TypeSwitch(D_WorkStrElement) {
    case CDESC:
      @DEBUG{VPIM_ERROR("s_CoypGCRootExportTable","CDESC is Illegal!!");};
    case FLC:
    case EOL:      /* $B%U%j!<%j%9%HCf$N%;%k(B */ 
      b_IncrementAddrReg(D_WorkSweepPtr);
      break;
    case BEXREF:
      /* $B9uM"=P$5$l$F$$$k(B --> $B9uM"=P%l%3!<%I$r;X$7$F$$$k(B */
/*
      @DEBUG{
	s_IfMRBoff(D_WorkStrElement) {
	  VPIM_ERROR("s_CopyGCRootExportTable","BEXREFo is invalid data");
	}
      };
*/
      s_GCBExpRec(D_WorkSweepPtr,D_WorkStrElement,
		  D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop);
      goto CommonRoutine;
    case REF: /* $BGrM"=P$5$l$F$$$k(B */
      /* Unify $B%U%i%0$r(B MRB $B$rMQ$$$F$$$k$?$a!":G=i$N#1CJ$O(B Deref $B=PMh$J$$(B */
      /* $B$?$@$7!"(BUnify $B%U%i%0$,N)$C$F$$$k;~$O!"(BMRB-OR $B$r9T$J$&(B */
      s_IfMRBon(D_WorkStrElement) {
	$USE(D_WorkDerefUnifyArg2);
	s_ReadWithMRBor(D_WorkStrElement,D_WorkDerefUnifyArg2);
	s_IfNotUnbound(D_WorkDerefUnifyArg2) {
	  p_Write(D_WorkDerefUnifyArg2,D_WorkStrElement);
	}
	$RELEASE(D_WorkDerefUnifyArg2);
      }
      s_GC1WordMark(D_WorkSweepPtr,D_WorkStrElement,
		    D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop);
      goto CommonRoutine;
    case ListGrp():
      s_GCList(D_WorkSweepPtr,D_WorkStrElement,
	       D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop);
      goto CommonRoutine;
    case StringGrp():
      s_GCString(D_WorkSweepPtr,D_WorkStrElement,
		 D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop);
      goto CommonRoutine;
    case ShortVectorGrp():
      s_GCShortVector(D_WorkSweepPtr,D_WorkStrElement,
		      D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop);
      goto CommonRoutine;
    case LongVectorGrp():
      s_GCLongVector(D_WorkSweepPtr,D_WorkStrElement,
		     D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop);
      goto CommonRoutine;
    default:
      @DEBUG{VPIM_ERROR("s_CopyGCRootExportTable","Illegal Type");};
      break;
    CommonRoutine:
      $CALL(s_HeapAcquirementUnitCheckInRootCopy_Sub
	    (D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop));
    }
    b_DecrementReg(D_WorkSize);
    p_IfEQ() { break; }
  }
  $RELEASE(D_WorkUpdatedPageTop);$RELEASE(D_WorkUpdatedSizeOfst);
  $RELEASE(D_WorkSize);$RELEASE(D_WorkSweepPtr); $RELEASE(D_WorkStrElement);
}

/******************************************************************** PSL **
 2.5 $B9uM"F~%O%C%7%eI=$r%9%-%c%s$7!"$9$Y$F$NN$?F$r%3%T!<$9$k(B

  s_CopyGCRootAllFosterParent();

       written by imai@icot22      on Wed Sep 26 21:54:05 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $B9uM"F~%l%3!<%I<+BN$O!"8e$K%3%T!<$5$l$k!#(B
  $BN$?F%l%3!<%I$@$1$r%3%T!<$9$k!#(B
<ETC>
********************************************************************* PSL **/

#PSL_define s_CopyGCRootFosterParentInBIT()
{
  $USE(D_WorkHash); $USE(D_WorkHashEntry); $USE(D_WorkSize);

  /* $B%W%m%;%C%5Kh$KC4Ev$9$kHO0O$r7hDj$9$k(B */
  s_DivideAreaAndGetStartAddrAndSize
    (_BIMP_HASH_TBL_BASE,_BIMP_HASH_TBL_SIZE,D_WorkHash,D_WorkSize);
  LOOP() {
    p_Read(D_WorkHash,D_WorkHashEntry);
    b_IfNotEOL(D_WorkHashEntry) {
      LOOP() {
	$USE(D_WorkFPPtr);
	s_GetExcellBImpRec(D_WorkHashEntry,D_WorkFPPtr);
	s_IfFPREC(D_WorkFPPtr) {
	  $USE(D_WorkSweepPtr);
	  b_AddImmediateWithDNTC
	    (D_SweepSaveAreaBase,_FP_PTR_SAVE_AREA,D_WorkSweepPtr);
	  p_Write(D_WorkFPPtr,D_WorkSweepPtr);
	  $USE(D_WorkUpdatedSizeOfst); $USE(D_WorkUpdatedPageTop);
	  s_GCFosterParentRecord(D_WorkSweepPtr,D_WorkFPPtr,
				 D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop);
	  $CALL(s_HeapAcquirementUnitCheckInRootCopy_Sub
		(D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop));
	  $RELEASE(D_WorkUpdatedPageTop);$RELEASE(D_WorkUpdatedSizeOfst);
	  $RELEASE(D_WorkSweepPtr);
	}
	$RELEASE(D_WorkFPPtr);
	s_GetChainBImpRec(D_WorkHashEntry,D_WorkHashEntry);
	b_IfEOL(D_WorkHashEntry) { break; }
      }
    }
    b_IncrementAddrReg(D_WorkHash);
    b_DecrementAddrReg(D_WorkSize);
    p_IfEQ() { break; }
  }
  $RELEASE(D_WorkSize);$RELEASE(D_WorkHashEntry);$RELEASE(D_WorkHash);
}

/******************************************************************** PSL **
2.7 PIM/s $B@lMQ$N(B $B%3%s%=!<%kF~=PNO%-%e!<$r%^!<%-%s%0%k!<%H$K$9$k(B
       written by imai@icot22      on Mon Nov 26 16:31:17 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/


#PSL_define s_CopyGCRootConsoleIOQueue()
{
  b_IfEqual(D_PE_Number,D_NULL) {
    $USE(D_WorkStrElement);
    $USE(D_WorkUpdatedSizeOfst);
    $USE(D_WorkUpdatedPageTop);
    $USE(D_WorkSweepPtr);
	/* HEAD $B$N3NG'(B */
    b_SetImmValueDNTC(_MEM_MANAGE_AREA_BASE,D_WorkSweepPtr);
    p_ReadWithOffset(D_WorkSweepPtr,_PIMS_CONSOLE_QUEUE_HEAD,D_WorkStrElement);
    b_AddImmediateWithDNTC
      (D_WorkSweepPtr, _PIMS_CONSOLE_QUEUE_HEAD, D_WorkSweepPtr);
    TypeSwitch(D_WorkStrElement) {
    case LIST:
      s_GCList(D_WorkSweepPtr,D_WorkStrElement,
	       D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop);
      $CALL(s_HeapAcquirementUnitCheckInRootCopy_Sub
	    (D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop));
      break;
    case ATOM:
      break;
    default:
      @DEBUG{VPIM_ERROR("s_CopyGCRootConsoleIOQueue","Illegal Type");};
    }
	/* TAIL $B$N3NG'(B */
    b_SetImmValueDNTC(_MEM_MANAGE_AREA_BASE,D_WorkSweepPtr);

    p_ReadWithOffset(D_WorkSweepPtr,_PIMS_CONSOLE_QUEUE_TAIL,D_WorkStrElement);
    b_AddImmediateWithTag
      (D_WorkSweepPtr, _PIMS_CONSOLE_QUEUE_TAIL, D_WorkSweepPtr);
    TypeSwitch(D_WorkStrElement) {
    case LIST:
      s_GCList(D_WorkSweepPtr,D_WorkStrElement,
	       D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop);
      s_IfModifiedPageTop(D_WorkUpdatedSizeOfst) {
	$CALL(s_HeapAcquirementUnitCheckInRootCopy_Sub
	      (D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop));
      }
      break;
    case ATOM:      break;
    default:
      @DEBUG{VPIM_ERROR("s_CopyGCRootConsoleIOQueue","Illegal Type");};
    }
    $RELEASE(D_WorkSweepPtr);
    $RELEASE(D_WorkUpdatedPageTop);
    $RELEASE(D_WorkUpdatedSizeOfst);
    $RELEASE(D_WorkStrElement);
  } /* else nothing to do */
}

/******************************************************************** PSL **
  s_CopyGCRootMessageSuspensionRecordTop()
 2.8 $B%a%C%;!<%8%5%9%Z%s%7%g%s%l%3!<%I$N%H%C%W(B ($B%l%8%9%?>e(B) 
	$B$r%^!<%-%s%0%k!<%H$K$9$k(B

       written by imai@icot22      on Fri May 10 19:46:33 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_CopyGCRootMessageSuspensionRecordTop()
{
  /* $B$H$j$"$($:!"%5%9%Z%s%I%9%?%C%/$NDl$K(B D_MsgSuspRecTop $B$r$+$-$3$`(B */
  p_Write(D_MsgSuspRecTop,D_SuspendStackBase);

  /* Sweep Ptr $B$N(B $B@_Dj(B */
  $USE(D_WorkSweepPtr); $USE(D_WorkStrElement);
  p_MoveValue(D_SuspendStackBase,D_WorkSweepPtr);
  p_MoveWord(D_MsgSuspRecTop,D_WorkStrElement);

  TypeSwitch(D_WorkStrElement) {
  case EOL:
    break;
  case VECT4:
    @DEBUG{WARNING("s_CopyGCRootMessageSuspensionRecordTop",
		   "VECT4 is linked from MessageSuspensionRecordTop");};
    $USE(D_WorkUpdatedPageTop); $USE(D_WorkUpdatedSizeOfst);
    s_GCShortVector(D_WorkSweepPtr,D_WorkStrElement,D_WorkUpdatedSizeOfst,
		    D_WorkUpdatedPageTop);
    $CALL(s_HeapAcquirementUnitCheckInRootCopy_Sub
	  (D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop));
    $RELEASE(D_WorkUpdatedSizeOfst);$RELEASE(D_WorkUpdatedPageTop);

    /* GC$B7k2L$r(B D_MsgSuspRecTop $B$K=q$-La$9(B */
    p_Read(D_SuspendStackBase,D_MsgSuspRecTop);
    break;
  default:
    @DEBUG{
      VPIM_ERROR("s_CopyGCRootMessageSuspensionRecordTop","Illegal Type");
    };
  }
  $RELEASE(D_WorkStrElement);$RELEASE(D_WorkSweepPtr);
}


/******************************************************************** PSL **
  2.9 s_CopyGCRootMultiPacketRecordTop
  $B%^%k%A%Q%1%C%H%l%3!<%I$N%H%C%W$r%^!<%-%s%0%k!<%H$K$9$k(B
  ($B%/%i%9%?$G0l?M$,$9$l$PNI$$(B)
       written by imai@icot22      on Fri May 10 19:46:57 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define   s_CopyGCRootMultiPacketRecordTop()
{
  b_IfEqual(D_PE_Number,D_NULL) /* $B%<%mHV(BPE$B$N$_$NA`:n(B */ {
    $USE(D_WorkSweepPtr); $USE(D_WorkStrElement);

    /* Sweep Ptr $B$N@_Dj(B */
    b_SetImmValueDNTC(_MEM_MANAGE_AREA_BASE,D_WorkSweepPtr);
    p_ReadWithOffset
      (D_WorkSweepPtr,_MULTI_PACKET_TOP_OFST,D_WorkStrElement);
    b_AddImmediateWithTag
      (D_WorkSweepPtr,_MULTI_PACKET_TOP_OFST, D_WorkSweepPtr);
    TypeSwitch(D_WorkStrElement) {
    case EOL:	/* Nothing To Do */
      break;
    case VECT6: case VECT7: case VECT8:
      @DEBUG{WARNING("s_CopyGCRootMultiPacketRecordTop",
		     "Short Vector is linked from MultiPacketRecord Top");};
      $USE(D_WorkUpdatedPageTop); $USE(D_WorkUpdatedSizeOfst);
      s_GCShortVector(D_WorkSweepPtr,D_WorkStrElement,D_WorkUpdatedSizeOfst,
		      D_WorkUpdatedPageTop);
      $CALL(s_HeapAcquirementUnitCheckInRootCopy_Sub
	    (D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop));
      $RELEASE(D_WorkUpdatedSizeOfst);$RELEASE(D_WorkUpdatedPageTop);
      break;
    case LongVectorGrp():
      @DEBUG{WARNING("s_CopyGCRootMultiPacketRecordTop",
		     "Long Vector is linked from MultiPacketRecord Top");};
      $USE(D_WorkUpdatedPageTop); $USE(D_WorkUpdatedSizeOfst);
      s_GCLongVector(D_WorkSweepPtr,D_WorkStrElement,D_WorkUpdatedSizeOfst,
		      D_WorkUpdatedPageTop);
      $CALL(s_HeapAcquirementUnitCheckInRootCopy_Sub
	    (D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop));
      $RELEASE(D_WorkUpdatedSizeOfst);$RELEASE(D_WorkUpdatedPageTop);
      break;
    default:
      @DEBUG{VPIM_ERROR("s_CopyGCRootMultiPacketRecordTop","Illegal Type");};
    }
    $RELEASE(D_WorkSweepPtr); $RELEASE(D_WorkStrElement);
  }
}

/******************************************************************** PSL **
  s_CopyGCRootPacketSuspensionRecordTop()
 2.10 $B%Q%1%C%HAw?.%5%9%Z%s%7%g%s%l%3!<%I$N%H%C%W(B ($B%l%8%9%?>e(B) 
	$B$r%^!<%-%s%0%k!<%H$K$9$k(B

       written by imai@icot22      on Tue Jul 30 17:21:29 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/


#PSL_define s_CopyGCRootPacketSuspensionRecordTop()
{
  /* $B$H$j$"$($:!"%5%9%Z%s%I%9%?%C%/$NDl$K(B D_MsgSuspRecTop $B$r$+$-$3$`(B */
  p_Write(D_PacketSuspRecTop,D_SuspendStackBase);

  /* Sweep Ptr $B$N(B $B@_Dj(B */
  $USE(D_WorkSweepPtr); $USE(D_WorkStrElement);
  p_MoveValue(D_SuspendStackBase,D_WorkSweepPtr);
  p_MoveWord(D_PacketSuspRecTop,D_WorkStrElement);

  TypeSwitch(D_WorkStrElement) {
  case EOL:
    break;
  case VECT8:
    @DEBUG{WARNING("s_CopyGCRootPacketSuspensionRecordTop",
		   "VECT8 is linked from MessageSuspensionRecordTop");};
    $USE(D_WorkUpdatedPageTop); $USE(D_WorkUpdatedSizeOfst);
    s_GCShortVector(D_WorkSweepPtr,D_WorkStrElement,D_WorkUpdatedSizeOfst,
		    D_WorkUpdatedPageTop);
    $CALL(s_HeapAcquirementUnitCheckInRootCopy_Sub
	  (D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop));
    $RELEASE(D_WorkUpdatedSizeOfst);$RELEASE(D_WorkUpdatedPageTop);

    /* GC$B7k2L$r(B D_MsgSuspRecTop $B$K=q$-La$9(B */
    p_Read(D_SuspendStackBase,D_PacketSuspRecTop);
    break;
  default:
    @DEBUG{
      VPIM_ERROR("s_CopyGCRootPacketSuspensionRecordTop","Illegal Type");
    };
  }
  $RELEASE(D_WorkStrElement);$RELEASE(D_WorkSweepPtr);
}


/******************************************************************** PSL **
2.11 HeapAlertVariable$B$r%^!<%-%s%0%k!<%H$K$9$k(B

$B0J2<$N7A$K8BDj$5$l$F$$$k!#(B

    EOL

$B$^$?$O!"(B

    REFo ----+---> HOOKo ----> GoalRec --+
             |                           |
             +---------------------------+

$B$?$@$7!"(B GoalRec: DcodeUnify

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/


#PSL_define s_CopyGCRootHeapAlertVar()
{
  b_IfZero(D_PE_Number) {
    $USE(D_WorkStrElement);
    $USE(D_WorkUpdatedSizeOfst);
    $USE(D_WorkUpdatedPageTop);
    $USE(D_WorkSweepPtr);

    b_SetImmValueDNTC(_MEM_MANAGE_AREA_BASE,D_WorkSweepPtr);
    p_ReadWithOffset(D_WorkSweepPtr,
		     _HEAP_ALERT_VARIABLE_OFST,D_WorkStrElement);
    b_AddImmediateWithDNTC(D_WorkSweepPtr,
		   _HEAP_ALERT_VARIABLE_OFST,D_WorkSweepPtr);
    TypeSwitch(D_WorkStrElement) {
    case REF:
      s_GC1WordMark(D_WorkSweepPtr,D_WorkStrElement,
		    D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop);
      $CALL(s_HeapAcquirementUnitCheckInRootCopy_Sub
	    (D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop));
      break;
    case EOL:
      break;
    default:
      @DEBUG{VPIM_ERROR("s_CopyGCRootHeapAletVar","Illegal Type");};
    }
    $RELEASE(D_WorkSweepPtr);
    $RELEASE(D_WorkUpdatedPageTop);
    $RELEASE(D_WorkUpdatedSizeOfst);
    $RELEASE(D_WorkStrElement);
  } /* else nothing to do */
}

/******************************************************************** PSL **
2.12 AlarmTimerVariable$B$r%^!<%-%s%0%k!<%H$K$9$k(B

PE$BKh$K%k!<%H$r;}$C$F$$$k!#(B
$B3F%k!<%H$+$i;X$5$l$F$$$k%G!<%?$O0J2<$N7A$K8BDj$5$l$F$$$k!#(B

    ATOM

$B$^$?$O!"(B

    REFo ----+---> HOOKo ----> GoalRec --+
             |                           |
             +---------------------------+

$B$?$@$7!"(B GoalRec: DcodeUnify

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/


#PSL_define s_CopyGCRootAlarmTimerVar()
{
  $USE(D_WorkStrElement);
  $USE(D_WorkUpdatedSizeOfst);
  $USE(D_WorkUpdatedPageTop);
  $USE(D_WorkSweepPtr);

  b_ExchangeElmposToOffset(D_PE_Number,D_WorkSweepPtr);
  b_AddImmediateWithDNTC
    (D_WorkSweepPtr,_ALARM_TIMER_VARIABLE_BASE,D_WorkSweepPtr);
  p_Read(D_WorkSweepPtr,D_WorkStrElement);

  TypeSwitch(D_WorkStrElement) {
  case REF:
    s_GC1WordMark(D_WorkSweepPtr,D_WorkStrElement,
		  D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop);
    $CALL(s_HeapAcquirementUnitCheckInRootCopy_Sub
	  (D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop));
    break;
  case ATOM:
    break;
  default:
    @DEBUG{VPIM_ERROR("s_CopyGCRootAlarmTimerVar","Illegal Type");};
  }
  $RELEASE(D_WorkSweepPtr);
  $RELEASE(D_WorkUpdatedPageTop);
  $RELEASE(D_WorkUpdatedSizeOfst);
  $RELEASE(D_WorkStrElement);
}

/******************************************************************** PSL **
  2.13 processor_profiler $B$N(B $B%a%8%c!<%a%s%H%l%3!<%I$r@\B3$9$kNN0h$r(B
	$B#G#C%k!<%H$K$9$k(B
       written by imai@icot22      on Tue Aug 27 20:29:55 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define   s_CopyGCRootProcessorProfilerPointerArea()
{
  b_IfZero(D_PE_Number) {
    $USE(D_WorkStackEntryPtr);
    b_SetImmValueDNTC(_MEASUREMENT_REC_PTR_AREA_BASE,D_WorkStackEntryPtr);
    $USE(D_WorkEndPtr);
    b_ReadPENumInCluster(D_WorkEndPtr);
    b_MultiplyImmediateWithTag
      (D_WorkEndPtr,_MAX_ELEMENTS_PROFILE_VECT,D_WorkEndPtr);
    b_ExchangeElmposToOffset(D_WorkEndPtr,D_WorkEndPtr);
    b_AddWithTag(D_WorkEndPtr,D_WorkStackEntryPtr,D_WorkEndPtr);

    $USE(D_WorkPtrToMeasurementRec);
    $USE(D_WorkUpdatedSizeOfst); $USE(D_WorkUpdatedPageTop);
    LOOP() {
      p_Read(D_WorkStackEntryPtr,D_WorkPtrToMeasurementRec);
      TypeSwitch(D_WorkPtrToMeasurementRec) {
      case INT: 
	b_IncrementAddrReg(D_WorkStackEntryPtr);
	goto NoCheck;
      case STRG:
	s_GCString(D_WorkStackEntryPtr,D_WorkPtrToMeasurementRec,
		   D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop);      break;
      case ShortVectorGrp():
	s_GCShortVector(D_WorkStackEntryPtr,D_WorkPtrToMeasurementRec,
			D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop); break;
      case LongVectorGrp():
	s_GCLongVector(D_WorkStackEntryPtr,D_WorkPtrToMeasurementRec,
		       D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop); break;
      default:
	@DEBUG{VPIM_ERROR("s_CopyGCRootProcessorProfilerPointerArea",
			  "Illegal Type");};
      }
      $CALL(s_HeapAcquirementUnitCheckInRootCopy_Sub
	    (D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop));
    NoCheck:
      b_IfEqual(D_WorkStackEntryPtr,D_WorkEndPtr) {
	break;
      }
    }
    $RELEASE(D_WorkEndPtr);
    $RELEASE(D_WorkUpdatedSizeOfst); $RELEASE(D_WorkUpdatedPageTop);
    $RELEASE(D_WorkPtrToMeasurementRec);
    $RELEASE(D_WorkStackEntryPtr);
  }
}
/******************************************************************** PSL **
2.14 SCSI $B4XO"$N%k!<%H(B
       written by imai@icot22      on Wed Oct  2 15:22:59 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_CopyGCRootScsiRecords()
{
  b_IfScsiAvailable() {
    /* $BM=Ls%-%e!<(B */
    s_CopyGCRootScsiReserveQueue();
    /* $B%P%98"%-%e!<(B */
    s_CopyGCRootScsiBusFreeWaitingQueue();
    /* $B<B9TCf%j%9%H(B */
    s_CopyGCRootScsiExecutingList();
    /* $B%3%^%s%I%l%3!<%I6u$-BT$A%-%e!<(B */
    s_CopyGCRootScsiCommRecFreeListWaitingQueue();
    /* $BE>Aw%l%3!<%I6u$-BT$A%-%e!<(B */
    s_CopyGCRootScsiTransRecFreeListWaitingQueue();
    /* $BDLCNJQ?t(B */
    s_CopyGCRootScsiInterruptStream();
    /* $BDLCNJQ?t(B */
    s_CopyGCRootSelectVect();
  }
}

#PSL_define s_CopyGCRootScsiReserveQueue()
{
  $CALL( s_CopyGCRootScsiQueue_Sub(D_ScsiReservTop) );
}

#PSL_define s_CopyGCRootScsiBusFreeWaitingQueue()
{
  $CALL( s_CopyGCRootScsiQueue_Sub(D_ScsiBusFreeWaitingTop) );
}

#PSL_define s_CopyGCRootScsiExecutingList()
{
  $CALL( s_CopyGCRootScsiQueue_Sub(D_ScsiExecutingListTop) );
}

#SUBARG_define A_QueuePtr	SRC

#SUBROUTINE s_CopyGCRootScsiQueue_Sub(A_QueuePtr)
{
  $USE(D_WorkQueue);	$USE(D_WorkSweepPtr);
  $USE(D_WorkUpdatedSizeOfst); $USE(D_WorkUpdatedPageTop);
  $USE(D_WorkEndPtr); $USE(D_WorkStrElement);

  p_MoveWord(A_QueuePtr,D_WorkQueue);
  LOOP() {
    b_IfEOL(D_WorkQueue) { break; }
    p_MoveWord(D_WorkQueue,D_WorkSweepPtr);
    TypeSwitch(D_WorkQueue) {
    case INT:	/* $BE>Aw%l%3!<%I$@$h(B */
      b_AddImmediateWithDNTC
	(D_WorkQueue,_SCSI_TRANS_REC_GC_MAINTENANCE_AREA_MAX_OFST,
	 D_WorkEndPtr);
      break;
    case ATOM:	/* $B%3%^%s%I%l%3!<%I$@$h(B */
      b_AddImmediateWithDNTC
	(D_WorkQueue,_SCSI_COMM_REC_GC_MAINTENANCE_AREA_MAX_OFST,
	 D_WorkEndPtr);
      break;
    default:
      @DEBUG{VPIM_ERROR("s_CopyGCRootScsiQueue_Sub","Illegal Queue Link");};
    }
    LOOP() {
      p_Read(D_WorkSweepPtr,D_WorkStrElement);
      TypeSwitch(D_WorkStrElement) {
      case INT: case ATOM: case EOL: case VECT0: goto Next;
      case REF:
	s_GC1WordMark(D_WorkSweepPtr,D_WorkStrElement,
		      D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop);
	break;
      case ShortVectorGrp():
	s_GCShortVector(D_WorkSweepPtr,D_WorkStrElement,
			D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop);
	break;
      case LongVectorGrp():
	s_GCLongVector(D_WorkSweepPtr,D_WorkStrElement,
		       D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop);
	break;
      case FPREC:
	s_GCFosterParentRecord(D_WorkSweepPtr,D_WorkStrElement,
			       D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop);
	break;
      case STRG:
	s_GCString(D_WorkSweepPtr,D_WorkStrElement,
		   D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop);
	break;
      default:
	@DEBUG{VPIM_ERROR("s_CopyGCRootScsiQueue_Sub","Illegal Type");};
      }
      $CALL(s_HeapAcquirementUnitCheckInRootCopy_Sub
	    (D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop));
      goto NoIncrement;
    Next:
      b_IncrementAddrReg(D_WorkSweepPtr);
    NoIncrement:
      b_IfEqual(D_WorkSweepPtr,D_WorkEndPtr) { break; }
    }
    /* $B%-%e!<$N@h$rFI$`(B */
    p_Read(D_WorkQueue, D_WorkQueue);
  }

  $RELEASE(D_WorkStrElement);  $RELEASE(D_WorkEndPtr);
  $RELEASE(D_WorkUpdatedSizeOfst); $RELEASE(D_WorkUpdatedPageTop);
  $RELEASE(D_WorkSweepPtr);	$RELEASE(D_WorkQueue);
  $RETURN();
}


#PSL_define s_CopyGCRootScsiCommRecFreeListWaitingQueue()
{
  $CALL(s_CopyGCRootGoalRecordOnRegister_Sub(D_ScsiCommRecFreeListWaitingTop));
}

#PSL_define s_CopyGCRootScsiTransRecFreeListWaitingQueue()
{
  $CALL(s_CopyGCRootGoalRecordOnRegister_Sub(D_ScsiTransRecFreeListWaitingTop));
}

#SUBARG_define A_GoalPtr	MODIFY

#SUBROUTINE s_CopyGCRootGoalRecordOnRegister_Sub(A_GoalPtr)
{
  p_Write(A_GoalPtr, D_SuspendStackBase);
  s_GCRootGoalRecord(D_SuspendStackBase);
  p_Read(D_SuspendStackBase, A_GoalPtr);
  $RETURN();
}

#PSL_define s_CopyGCRootScsiInterruptStream()
{
  s_IfREF(D_ScsiInterruptStr) {
    $USE(D_WorkUpdatedPageTop); $USE(D_WorkUpdatedSizeOfst);
    $USE(D_WorkSweepPtr);
    p_Write(D_ScsiInterruptStr, D_SuspendStackBase);
    p_MoveValue(D_SuspendStackBase,D_WorkSweepPtr);
    s_GC1WordMark(D_WorkSweepPtr,D_ScsiInterruptStr,
		    D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop);
    $CALL(s_HeapAcquirementUnitCheckInRootCopy_Sub
	  (D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop));
    p_Read(D_SuspendStackBase, D_ScsiInterruptStr);
    $RELEASE(D_WorkSweepPtr);
    $RELEASE(D_WorkUpdatedSizeOfst); $RELEASE(D_WorkUpdatedPageTop);
  } else {
    @DEBUG{
      b_IfNotEOL(D_ScsiInterruptStr) {
	VPIM_ERROR("s_CopyGCRootScsiInterruptStream","Not REF nor EOL");
      }
    };
  }
}

#PSL_define  s_CopyGCRootSelectVect()
{
  s_IfREF(D_ScsiSelectVect) {
    $USE(D_WorkUpdatedPageTop); $USE(D_WorkUpdatedSizeOfst);
    $USE(D_WorkSweepPtr);
    p_Write(D_ScsiSelectVect, D_SuspendStackBase);
    p_MoveValue(D_SuspendStackBase,D_WorkSweepPtr);
    s_GC1WordMark(D_WorkSweepPtr,D_ScsiSelectVect,
		    D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop);
    $CALL(s_HeapAcquirementUnitCheckInRootCopy_Sub
	  (D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop));
    p_Read(D_SuspendStackBase, D_ScsiSelectVect);
    $RELEASE(D_WorkSweepPtr);
    $RELEASE(D_WorkUpdatedSizeOfst); $RELEASE(D_WorkUpdatedPageTop);
  } else {
    @DEBUG{
      b_IfNotEOL(D_ScsiSelectVect) {
	VPIM_ERROR("s_CopyGCRootScsiSelectVect","Not REF nor EOL");
      }
    };
  }
}

/******************************************************************** PSL **
SIMPLE SCSI ($B<B5!$G$OITMW(B)
       written by imai@icot22      on Mon Oct 28 14:04:08 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_CopyGCRootSimpleScsi()
{
  b_IfNotZero(D_SimpleScsiRecvIssue) {
    /* $B$H$j$"$($:!"%5%9%Z%s%I%9%?%C%/$NDl$K(B register $B$NCM$r$+$-$3$`(B */
    $USE(D_WorkIndex); $USE(D_WorkSweepPtr);
    $USE(D_WorkUpdatedSizeOfst); $USE(D_WorkUpdatedPageTop);
    b_SetImmValueDNTC(_SEVEN,D_WorkIndex);
    LOOP() {
      ValueSwitch(D_WorkIndex) {
      case 0: goto End;
      case 1: p_Write(D_SimpleScsiTransLen,D_SuspendStackBase);	break;
      case 2: p_Write(D_SimpleScsiNewData,D_SuspendStackBase);	break;
      case 3: p_Write(D_SimpleScsiID,D_SuspendStackBase);	break;
      case 4: p_Write(D_SimpleScsiResult,D_SuspendStackBase);	break;
      case 5: p_Write(D_SimpleScsiFPPtr,D_SuspendStackBase);	break;
      case 6: p_Write(D_SimpleScsiEnvRecPtr,D_SuspendStackBase);break;
      case 7: p_Write(D_SimpleScsiRecvString,D_SuspendStackBase);break;
      default:
	@DEBUG{VPIM_ERROR("s_CopyGCRootSimpleScsi","???");};
      }
      /* Sweep Ptr $B$N(B $B@_Dj(B */
      p_MoveValue(D_SuspendStackBase,D_WorkSweepPtr);
      s_GCTypeDispatch
	(D_WorkSweepPtr,D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop);
      $CALL(s_HeapAcquirementUnitCheckInRootCopy_Sub
	    (D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop));
      /* GC$B7k2L$r(B register $B$K=q$-La$9(B */
      ValueSwitch(D_WorkIndex) {
      case 1: p_Read(D_SuspendStackBase,D_SimpleScsiTransLen);	break;
      case 2: p_Read(D_SuspendStackBase,D_SimpleScsiNewData);	break;
      case 3: p_Read(D_SuspendStackBase,D_SimpleScsiID);	break;
      case 4: p_Read(D_SuspendStackBase,D_SimpleScsiResult);	break;
      case 5: p_Read(D_SuspendStackBase,D_SimpleScsiFPPtr);	break;
      case 6: p_Read(D_SuspendStackBase,D_SimpleScsiEnvRecPtr);	break;
      case 7: p_Read(D_SuspendStackBase,D_SimpleScsiRecvString);break;
      default:
	@DEBUG{VPIM_ERROR("s_CopyGCRootSimpleScsi","???");};
      }
      b_DecrementReg(D_WorkIndex);
    }
  End:
    $RELEASE(D_WorkUpdatedPageTop); $RELEASE(D_WorkUpdatedSizeOfst);
    $RELEASE(D_WorkSweepPtr); $RELEASE(D_WorkIndex);
  }
}

/******************************************************************** PSL **
(#SUBROUTINE) s_HeapAcquirementUnitCheckInRootCopy_Sub

       written by imai@icot22      on Fri Sep 21 14:02:14 1990
<Arguments>
  A_SizeOfst : $B99?7$5$l$?!J2DG=@-$N$"$k!K%5%$%:(B
  A_PageTop  : $B99?7$5$l$?!J2DG=@-$N$"$k!K%Z!<%8%H%C%W$NCM(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%R!<%W3MF@%f%K%C%H$N=*$j$K$J$C$?$i!"%R!<%W$r3NJ]$7!"(B
  $B!J%9%#!<%WCf$G$O$J$$$N$G!K(BGC$B%9%?%C%/$KF~$l$F!"(B
  $B%9%#!<%W%]%$%s%?$b?J$a$k(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_SizeOfst	SRC
#SUBARG_define A_PageTop	MODIFY

#SUBROUTINE s_HeapAcquirementUnitCheckInRootCopy_Sub(A_SizeOfst,A_PageTop)
{
  s_IfModifiedPageTop(A_SizeOfst) {
    s_IfHeapAcquirementUnitTop(A_PageTop) {
      b_SubtractImmediateWithTag
	(A_PageTop,_SIZE_OF_HEAP_ACQUIREMENT_UNIT_IN_GC, A_PageTop);
      s_PushOneHeapAcquirementUnitGCStack(A_PageTop);
      s_AllocOnePageGC(A_PageTop);
	    /* $B0J2<$N5-=R$O0l8+4qL/$K8+$($k$,<B$O@5$7$$(B */
	    /* $B#G#C%k!<%H$,%3%T!<$5$l$k$^$G$O!"(B
	     * $B%9%$!<%W%]%$%s%?$,?J$s$G$O$J$i$J$$$+$i$G$"$k!#(B
	     * $B6&M-%9%?%C%/$KF~$l$i$l$?$b$N$O!"$J$+$C$?$b$N$H$7$F?J$a$k!#(B
	     */
      s_DecacheSweepPtr(A_SizeOfst,A_PageTop);
    }
    s_DecachePageTopPtr(A_SizeOfst,A_PageTop);
  }
  $RETURN();
}

/******************************************************************** PSL **
3. $B9uM"=PI=$+$i;X$5$l$k$b$N$N%j%O%C%7%e(B
     s_CopyGCRootBlackExportTable

       written by imai@icot22      on Thu Mar 22 14:34:32 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define	D_WorkChainTop	XXX

#PSL_define s_RehashBlackExportHashTableAfterGC()
{
  $USE(D_WorkChainTop);
  /* $B%O%C%7%e%F!<%V%k$r%/%j%"$9$k$H6&$K!"%(%s%H%j!<%A%'!<%s$r0lK\2=$9$k(B */
  s_ClearBExpHashEntryAndConnectAllBExpRec(D_WorkChainTop);
  /* D_WorkChainTop $B$N@hF,$O(B $BM"=PI=%(%s%H%j$N%*%U%;%C%H(B */

  /* $B0lK\2=$7$?%(%s%H%j$rC)$j!"%j%O%C%7%e$9$k(B */
  s_EnterBExpHashEntryAndConnectAllBExpRec(D_WorkChainTop);
  $RELEASE(D_WorkChainTop);
}


/******************************************************************** PSL **
  s_ClearBExpHashEntryAndConnectAllBExpRec(chain_top)
  $B9uM"=P%O%C%7%eI=$r%/%j%"$7!"M-8z$J9uM"=P%l%3!<%I$r0lK\2=$9$k(B

       written by imai@icot22      on Tue Aug 28 20:07:10 1990
<Arguments>
  chain_top : (dst) $B0lK\2=$5$l$?%A%'!<%s$N@hF,$r;X$9%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
($B8F$S=P$7A0(B)
       $B%O%C%7%eI=(B	$BM"=PI=(B		$B9uM"=P%l%3!<%I(B
	|-------|	|	|
	|$B!&(B	|	|	|	+-------+
	|-------|	|-------|   +-->|	|
	|HLINK	------->|BEXREF	----+	|HLINK	|
	|-------|	|-------|	+|------+
	|$B!&(B	|	|    +-----------+
	|-------|	|    |	|	+-------+
	|$B!&(B	|	|----V--|   +-->|	|
	|-------|	|BEXREF	----+	|$B!&(B(EOL)|
	|HLINK	---+	|-------|	+-------+
	|-------|  +--->|BEXREF	----+	+-------+
	|	|	|-------|   +-->|	|
			|	|	|$B!&(B(EOL)|
					+-------+
($B8F$S=P$78e(B)
	chain_top ($BCM$rJV$9(B)
	+-------+
	|HLINK	----+
	+-------+   |
		    |
       $B%O%C%7%eI=(B   |	$BM"=PI=(B		$B9uM"=P%l%3!<%I(B
	|-------|   |	|	|
	|$B!&(B(EOL)|   |	|	|	+-------+
	|-------|   |	|-------|   +-->|	|
	|$B!&(B	|   +-->|BEXREF	----+	|	|
	|-------|	|-------|	+|------+
	|$B!&(B	|	|    +-----------+
	|-------|	|    |	|	+-------+
	|$B!&(B	|	|----V--|   +-->|	|
	|-------|	|BEXREF	----+	|	|
	|$B!&(B	|	|-------|<------/-------+
	|-------|	|BEXREF	----+	+-------+
	|	|	|-------|   +-->|	|
			|	|	|$B!&(B	|
					+-------+
<Examples>
<Test>
<Explanation>
  $B%j%s%/$O!"I,$:!VM"=PI=!W$H!V9uM"F~%l%3!<%I!W$N%Z%"$K$J$C$F$$$k$3$H(B
  $B$KCm0U$5$l$?$$!*(B
<ETC>
********************************************************************* PSL **/

#DATA_define	D_WorkBExpOffset	XXX
#DATA_define	D_WorkTail		XXX

#PSL_define s_ClearBExpHashEntryAndConnectAllBExpRec(chain_top)
{
  /* $B%k!<%WA0$N=i4|@_Dj(B */
  $USE(D_WorkAddr);		$USE(D_WorkSize);
  b_SetImmValueDNTC(_BEXP_HASH_TBL_BASE,D_WorkAddr);
  b_SetImmValueDNTC(_BEXP_HASH_TBL_SIZE,D_WorkSize);
  p_MoveWord(D_NULL,chain_top);
  $USE(D_WorkBExpOffset);
  LOOP() {
    p_Read(D_WorkAddr,D_WorkBExpOffset);
    b_IfNotEOL(D_WorkBExpOffset) {
      $USE(D_WorkTail);
      /* Tail $B$r8+$D$1$k(B */
      s_GetTailOfBExpRecHashChain(D_WorkBExpOffset,D_WorkTail);
      /* $B%A%'%$%sA4BN$r(B Push */
      s_PutChainBExpRec(D_WorkTail,chain_top);
      $RELEASE(D_WorkTail);
      p_MoveWord(D_WorkBExpOffset,chain_top);
      /* $B%O%C%7%e%(%s%H%j$r%/%j%"(B */
      s_InvalidateBExpHashEntry(D_WorkAddr);
    }
    /* $B<!$N%k!<%W$N$?$a$N=`Hw$H%k!<%WC&=P$NH=Dj(B */
    b_IncrementAddrReg(D_WorkAddr);
    b_DecrementAddrReg(D_WorkSize);
    p_IfEQ() { break; }
  }
  $RELEASE(D_WorkBExpOffset);$RELEASE(D_WorkSize);$RELEASE(D_WorkAddr);
}

#PSL_define s_GetTailOfBExpRecHashChain
	(src_top_exp_entry_ofst,dst_tail_bexprec_ptr)
{
  /* Do not modify src */
  $USE(D_WorkExpEntryOfst);
  p_MoveWord(src_top_exp_entry_ofst,D_WorkExpEntryOfst);
  LOOP(){
  s_GetDataExpEntry(D_WorkExpEntryOfst,dst_tail_bexprec_ptr);
  s_GetChainBExpRec(dst_tail_bexprec_ptr,D_WorkExpEntryOfst);
    b_IfEOL(D_WorkExpEntryOfst) { break; }
  }
  $RELEASE(D_WorkExpEntryOfst);
}

#PSL_define s_InvalidateBExpHashEntry(hash_entry_ptr)
{
  p_Write(D_NULL,hash_entry_ptr);
}

/******************************************************************** PSL **
 s_EnterBExpHashEntryAndConnectAllBExpRec(chain_top)

       written by imai@icot22      on Tue Aug 28 20:29:40 1990
<Arguments>
  chain_top : (modify) $B%A%'!<%s$N@hF,(B ($BM"=PI=$N%*%U%;%C%H(B)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B0lK\2=$5$l$?%A%'!<%s$r$?$I$j!"%j%O%C%7%e$7$F$f$/!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_EnterBExpHashEntryAndConnectAllBExpRec(chain_top)
{
  $USE(D_WorkPtr); $USE(D_WorkExportedData); $USE(D_WorkLink);
  LOOP() {
    b_IfEOL(chain_top) { break; }
    s_GetDataExpEntry(chain_top,D_WorkPtr);
    s_GetDataBExpRec(D_WorkPtr,D_WorkExportedData,chain_top);
    s_GetChainBExpRec(D_WorkPtr,D_WorkLink);
    s_PutChainBExpRec(D_WorkPtr,D_EOL); /* NEXT Link $B$O!"(B EOL */
    s_IfNotAtomic(D_WorkExportedData) {
      /* $BM"=P$5$l$?%G!<%?$N%"%I%l%9$O#G#C$K$h$C$FJQ$o$k$N$G%j%O%C%7%e$9$k(B */
      s_PushBExpRecToBExpHashEntry(chain_top,D_WorkExportedData);
    } else { 
	 /* $B%O%C%7%e%j%s%/$+$i30$9(B
	 * ($B%(%s%H%j$H$7$F$O@8$-$F$$$k$,:FM"=P$5$l$J$$(B)
	 */
      @DEBUG{WARNING("s_EnterBExpHashEntryAndConnectAllBExpRec",
		     "ExportedData is Already instantiated to Atomic");};
    }
    p_MoveWord(D_WorkLink,chain_top);
  }
  $RELEASE(D_WorkExportedData); $RELEASE(D_WorkPtr); $RELEASE(D_WorkLink);
}

/******************************************************************** PSL **
SCSI$B$N8e=hM}(B
       written by imai@icot22      on Wed Oct  2 15:15:31 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_ScsiGCPostProcedure()
{
  b_IfScsiAvailable() {
    b_IfNotEOL(D_ScsiCommRecFreeListWaitingEnd) {
      p_ReadWithOffset(D_ScsiCommRecFreeListWaitingEnd,_ARITY_OFST_GR,
		       D_ScsiCommRecFreeListWaitingEnd);
      b_SetImmTypeMRBoff(HOOK,D_ScsiCommRecFreeListWaitingEnd);
    }

    b_IfNotEOL(D_ScsiTransRecFreeListWaitingEnd) {
      p_ReadWithOffset(D_ScsiTransRecFreeListWaitingEnd,_ARITY_OFST_GR,
		       D_ScsiTransRecFreeListWaitingEnd);
      b_SetImmTypeMRBoff(HOOK,D_ScsiTransRecFreeListWaitingEnd);
    }
  }
}


/******************************************************************** PSL **
  3. $B%R!<%W$N@ZBX$((B
    s_SwitchHeapBeforeGC()

       written by imai@icot22      on Fri Jun  9 17:47:58 1989
<Arguments> $B$J$7(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%R!<%WLL$r@Z$jBX$($k!#B>$N#P#E$OBT$A>uBV$N;~$K!"#1#P#E$,8F$V!#(B
  $BF14|A`:n$O=q$+$l$F$$$J$$!#>e0L%l%Y%k$GF14|$r=q$/I,MW$,$"$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkHeapTopPtr XXX

#PSL_define s_SwitchHeapBeforeGC()
{
  $USE(D_WorkHeapTopPtr); 
  @MONITOR{ monitor_gc_start(); };
  b_IfGreater(D_CurrentHeapEndPtr,D_HeapHalfAddr) {
    /* $B:#$^$G;H$C$F$$$?%R!<%W$O!">e0L%"%I%l%9B&(B */
    b_SetImmValueDNTC(_HEAP_AREA_BASE, D_WorkHeapTopPtr);
    p_MoveValue(D_HeapHalfAddr, D_CurrentHeapEndPtr);
  } else {
    /* $B:#$^$G;H$C$F$$$?%R!<%W$O!"2<0L%"%I%l%9B&(B */
    p_MoveValue(D_HeapHalfAddr, D_WorkHeapTopPtr);
    p_MoveValue(D_SizeOfMemory, D_CurrentHeapEndPtr);
  }
  b_DecrementAddrReg(D_CurrentHeapEndPtr);
  b_WriteGlobalHeapTop(D_WorkHeapTopPtr);
  b_WriteGlobalHeapEnd(D_CurrentHeapEndPtr);
  b_InitFreePageTop();
  $RELEASE(D_WorkHeapTopPtr);
}

/******************************************************************** PSL **
  4. $B#G#C%9%?%C%/$N=i4|2=(B
    s_InitGCStack()

       written by imai@icot22      on Fri Jun  9 17:53:55 1989
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $BJBNs#G#C$NIi2YJ,;6$NC10L$H$J$k!V%3%T!<8e%Z!<%8!W$r7R$$$G$*$/%9%?%C%/$r(B
  $B=i4|2=$9$k!#(B
<Examples>
<Test>
<Explanation> $B#1#P#E$,8F$V(B
<ETC>
********************************************************************* PSL **/

#PSL_define s_InitGCStack()
{
  $USE(D_WorkAddr);
  b_SetImmValueDNTC(_GC_STACK_AREA_BASE,D_WorkAddr);
  b_WriteSharedArea(D_WorkAddr,_COMM_AREA_BASE,_GC_STACK_PTR);
  $RELEASE(D_WorkAddr);
}

/******************************************************************** PSL **
  5. $B%-%c%C%7%e$N=q$-La$7(B
    s_CacheFlushBack()

       written by imai@icot22      on Fri Jun  9 18:35:11 1989

$B?7NN0h$KBP$7$F$O!"#D#i#r#e#c#t#W#r#i#t#e$G=q$-9~$_$r9T$&$N$G!"(B
$B$3$l$,%R%C%H$7$J$$$3$H$rJ]>Z$9$kI,MW$,$"$k!#$9$J$o$A!"%-%c%C%7%e$N(B
Modified$B%V%m%C%/$O6&M-%a%b%j$K=q$-La$9I,MW$,$"$k!#(B

$B#H!?#W$G0lH/40N;=PMh$k$h$&$JL?Na$r;}$C$F$$$k%^%7%s$J$i$P!"$=$NL?Na$K(B
$BCV$-49$($l$PNI$$!#$=$N$h$&$JL?Na$,$J$$>l9g$O!"?7NN0h$N$"$kNN0h$r!"(B
ReadExclusively($BIaDL$N(BRead$B$G$b$h$$(B)$B$GgS$a2s$;$PNI$$!#(B
$B$3$NNN0h$O!"%-%c%C%7%eMFNL!"%;%C%H?t$K$h$C$F0[$J$k!#(B
$B!J#4%o!<%I%V%m%C%/$N>l9g!"#4%o!<%IA4It$rFI$`I,MW$b$J$$!#!K(B

$B%^%7%s0MB8$G$"$k$7!"#V#P#I#M$G$O!"%-%c%C%7%e$N9=@.$^$GDj$a$J$$$N$G(B
$B#P#S#L$G$O5-=R$7$J$$!#%-%c%C%7%e%7%_%e%l!<%7%g%s$r9T$&>l9g!"(B
$B#F#l#u#s#h#B#a#c#k$7$?$3$H$r!"%-%c%C%7%e%7%_%e%l!<%?$K65$($kI,MW$,$"$k!#(B
********************************************************************* PSL **/

#PSL_define s_CacheFlushBack()
{
  ;
  /* $B#P#S#L$G$O=q$-$^$;$s!#3F<R!"4hD%$C$F=q$$$F2<$5$$!#(B
   *  $B<ALd$,$"$l$P<u$1IU$1$^$9(B (imai@icot.or.jp)
   */
}

/******************************************************************** PSL **
  6. $B%"%$%I%k%4!<%k%9%?%C%/%(%s%H%j$N<h$j=P$7(B
    s_GetIdleGoalStackEntry(dst_ptr_reg)

       written by imai@icot22      on Thu Sep 28 21:44:09 1989

<Arguments>
    dst_ptr_reg : $B%"%$%I%k%4!<%k%9%?%C%/%(%s%H%j$N%]%$%s%?$,JV$C$F$/$k(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_GetIdleGoalStackEntry(dst_ptr_reg)
{
  p_MoveWord(D_GoalStackBase,dst_ptr_reg);
}

/******************************************************************** PSL **
  7. $B#G#C=*N;8e$N%U%j!<%j%9%H@8@.(B
    s_MakeFreeListAfterGC()

       written by imai@icot22      on Fri Aug 25 11:43:39 1989
<Arguments> $B$J$7(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  1,2,4,8,16,32,64,128$B$N%5%$%:$N%U%j!<%j%9%H$r$=$l$>$l:n$k(B
<Examples>
<Test>
<Explanation>
  $B3F%5%$%:Kh$K%Z!<%8$r3NJ]$9$k$H!";H$$@Z$i$:$K(BGC$B=*N;$K$J$k!#(B
  $B$3$l$r%U%j!<%j%9%H$K$7$F!"(BGC$B8e$K;H$*$&$H$9$k!VIOK3@-!W$NH/A[!#(B
  
<ETC>
********************************************************************* PSL **/

#PSL_define s_MakeFreeListAfterGC()
{
  $USE(D_WorkPtr);
  s_CachePageTopPtrImmSize(_PAGE_TOP_1WORD,D_WorkPtr);
  s_MakeFreeListFromPageRest
      (D_WorkPtr,D_Free_1_PtrReg,_NEXT_CELL_OFST_FL1,_WORD_0);
  s_CachePageTopPtrImmSize(_PAGE_TOP_2WORD,D_WorkPtr);
  s_MakeFreeListFromPageRest
      (D_WorkPtr,D_Free_2_PtrReg,_NEXT_CELL_OFST_FL2,_WORD_0);
  s_CachePageTopPtrImmSize(_PAGE_TOP_4WORD,D_WorkPtr);
  s_MakeFreeListFromPageRest
      (D_WorkPtr,D_Free_4_PtrReg,_NEXT_CELL_OFST_FL4,_WORD_0);
  s_CachePageTopPtrImmSize(_PAGE_TOP_8WORD,D_WorkPtr);
  s_MakeFreeListFromPageRest
      (D_WorkPtr,D_Free_8_PtrReg,_NEXT_CELL_OFST_FL8,_WORD_0);
  s_CachePageTopPtrImmSize(_PAGE_TOP_16WORD,D_WorkPtr);
  s_MakeFreeListFromPageRest
      (D_WorkPtr,D_Free_16_PtrReg,_NEXT_CELL_OFST_FL16,_WORD_1);
  s_CachePageTopPtrImmSize(_PAGE_TOP_32WORD,D_WorkPtr);
  s_MakeFreeListFromPageRest
      (D_WorkPtr,D_Free_32_PtrReg,_NEXT_CELL_OFST_FL32,_WORD_1);
  s_CachePageTopPtrImmSize(_PAGE_TOP_64WORD,D_WorkPtr);
  s_MakeFreeListFromPageRest
      (D_WorkPtr,D_Free_64_PtrReg,_NEXT_CELL_OFST_FL64,_WORD_1);
  s_CachePageTopPtrImmSize(_PAGE_TOP_128WORD,D_WorkPtr);
  s_MakeFreeListFromPageRest
      (D_WorkPtr,D_Free_128_PtrReg,_NEXT_CELL_OFST_FL128,_WORD_1);
  $RELEASE(D_WorkPtr);
}

/******************************************************************** PSL **
  7.1 $B%Z!<%8;DIt$+$i%U%j!<%j%9%H$r:n@.$9$k(B
    s_MakeFreeListFromPageRest()

       written by imai@icot22      on Fri Aug 25 11:44:58 1989
<Arguments>
  pagetop : $B%Z!<%8%H%C%W%]%$%s%?(B
	($B$3$l$h$jA0$,;HMQ$5$l!"$3$l0J9_$,;HMQ$5$l$F$$$J$$(B)
  fl_ptr  : $B%U%j!<%j%9%H$N@hF,$r;X$9!"8GDj%l%8%9%?(B
  imm_size: $B%U%j!<%j%9%H%5%$%:(B($BB(CM(B)
  imm_ofst: $B%U%j!<%j%9%H%j%s%/$rCV$/0LCV(B($BB(CM(B:$B@hF,$+$i$N%*%U%;%C%H(B)
<Temporally Used Variables>
  D_WorkAddr
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  $B%-%c%C%7%e%V%m%C%/%5%$%:(B(4 Word)$B0J>e$N%U%j!<%j%9%H$r:n@.$9$k;~$K!"(B
  4 Word$BKh$K(B Direct Write$B$K$h$k6u=q$-$r$7$?J}$,$h$$$+$b$7$l$J$$!#(B
********************************************************************* PSL **/

#PSL_define s_MakeFreeListFromPageRest(pagetop,fl_ptr,imm_size,imm_ofst)
{
  @DEBUG{ s_IfOldArea(pagetop) {
    VPIM_ERROR("s_MakeFreeListFromPageRest","pagetop points oldarea");
  }};
  $USE(D_WorkAddr);
  b_AddImmediateWithTag(pagetop,imm_ofst,pagetop);		/* Address */
  b_MoveWithImmTypeMRBoff(pagetop,FLC,fl_ptr); 
  b_AddImmediateWithDNTC(pagetop,imm_size,D_WorkAddr);	/* Address */
  p_MoveTag(fl_ptr,D_WorkAddr);
  LOOP() {
    s_IfNotSameHeapAcquirementUnit(pagetop,D_WorkAddr) {
      p_WriteDirectly(D_NULL,pagetop);
      break;
    } else {
      p_WriteDirectly(D_WorkAddr,pagetop);
      p_MoveValue(D_WorkAddr,pagetop);
      b_AddImmediateWithTag(D_WorkAddr,imm_size,D_WorkAddr);
    }
  }
  $RELEASE(D_WorkAddr);
}

/******************************************************************** PSL **
  8. $B%]%$%s%?%;!<%V%(%j%"$N=i4|2=(B

       written by imai@icot22      on Tue Feb 20 15:34:07 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

		/* $B#G#C$N%Z!<%8%H%C%W%]%$%s%?%;!<%VNN0h$N3d$jEv$F(B */
#PSL_define s_InitializePageTopSaveArea ()
{
  b_SetImmValueDNTC
      (_LOCAL_MEM_GC_PAGETOP_SAVE_AREA_BASE,D_PageTopSaveAreaBase);
  b_ConvertLocalMemAddrToGlobalMemAddr
      (D_PageTopSaveAreaBase,D_PageTopSaveAreaBase);
}
		/* $B#G#C$N%9%$!<%W%]%$%s%?%;!<%VNN0h$N3d$jEv$F(B */
#PSL_define s_InitializeSweepSaveArea ()
{
  b_SetImmValueDNTC(_LOCAL_MEM_GC_SWEEP_SAVE_AREA_BASE,D_SweepSaveAreaBase);
  b_ConvertLocalMemAddrToGlobalMemAddr
    (D_SweepSaveAreaBase,D_SweepSaveAreaBase);
}

/******************************************************************** PSL **
  9. $B#G#C=*N;8e!"5lNN0h$K%4%_%G!<%?$r=q$-9~$`(B

       written by imai@icot22      on Wed May 16 16:58:36 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC> @DEBUG $B@lMQ(B $B#G#C=*N;8e!"5lNN0h$r$a$A$c$a$A$c$JCM$K$9$k(B
********************************************************************* PSL **/
#DATA_define D_WorkMemAddr    XXX
#DATA_define D_WorkBottomAddr XXX

#CONST_define _RANDOM_VALUE_OF_OLD_AREA	0xabcdabcd

#PSL_define s_ClearOldAreaAfterGC()
{
  $USE(D_WorkMemAddr); $USE(D_WorkBottomAddr); $USE(D_WorkSize);
  b_IfGreater(D_CurrentHeapEndPtr,D_HeapHalfAddr) {
    b_SetImmValueDNTC(_HEAP_AREA_BASE,D_WorkMemAddr);
    p_MoveValue(D_HeapHalfAddr,D_WorkBottomAddr);
  } else {
    p_MoveValue(D_HeapHalfAddr,D_WorkMemAddr);
    p_MoveValue(D_SizeOfMemory,D_WorkBottomAddr);
  }
  p_SetImmediateWord(FLC,_MRB_OFF,_RANDOM_VALUE_OF_OLD_AREA,D_WorkSize);
  LOOP() {
    p_Write(D_WorkSize,D_WorkMemAddr);
    b_IncrementAddrReg(D_WorkMemAddr);
    b_IfEqual(D_WorkMemAddr,D_WorkBottomAddr) { break ;}
  }
  $RELEASE(D_WorkSize);  $RELEASE(D_WorkBottomAddr); $RELEASE(D_WorkMemAddr);
}

/******************************************************************** PSL **

s_DivideAreaAndGetStartAddrAndSize
  (imm_base,imm_size,start_ptr,size)

       written by imai@icot22      on Wed Aug  1 16:37:03 1990
<Arguments>
  imm_size: $BA4BN$N%5%$%:(B
  imm_base: $BNN0h$N@hF,%"%I%l%9(B
  start_ptr: (dst) $B#P#E$,C4Ev$9$k3+;O$9$Y$->l=j(B
  size:      (dst) $B#P#E$,C4Ev$9$kNN0h$N?t(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $B%/%i%9%?Fb(B PE $BBf?t$,2DJQ$G$"$k$H$7$?;~$K$bBP1~$G$-$k$h$&$K!"(B
  $BM"=PI=%(%j%"(B $B$r(B $B%/%i%9%?Fb(BPE$BBf?t(B $B$G3d;;$7!"(BPE$BHV9f$K1~$8$?(B
  $B%9%$!<%W3+;O%]%$%s%H$H!"8D?t$r5a$a$k!#(B

  $B$?$@$7!"%/%i%9%?Fb(BPE$BBf?t$GNN0h$,3d$j@Z$l$J$$>l9g$O!"(BPE$BHV9f$N(B
  $B0lHVBg$-$$(B PE $B$,:G8e?t%o!<%I$r!VM>J,!W$KC4Ev$9$k(B
<ETC>
********************************************************************* PSL **/
#CONST_define _ADDRESS_BOUNDARY_MASK 0xffffffff /* PIM/p,PIM/k 0xfffffff8 */
#DATA_define D_WorkPENum	XXX

#PSL_define  s_DivideAreaAndGetStartAddrAndSize
	(imm_base,imm_size,start_ptr,size)
{
  $USE(D_WorkPENum); $USE(D_WorkAllocCnt);
  b_ReadPENumInCluster(D_WorkPENum);
  b_SetImmValueDNTC(imm_size,D_WorkAllocCnt);
  b_DivideWithDNTC(D_WorkAllocCnt,D_WorkPENum,size);
  b_BitwiseAndImmediateWithDNTC(size,_ADDRESS_BOUNDARY_MASK,size);

  b_MultiplyWithDNTC(size,D_PE_Number,start_ptr);
  b_AddImmediateWithTag(start_ptr,imm_base,start_ptr);

  /* $B$b$7$b<+J,$,0lHV:G8eIt$rC4Ev$9$k$J$i$P(B */
  b_DecrementReg(D_WorkPENum);
  b_IfEqual(D_WorkPENum,D_PE_Number) {
    /* $B3d$j@Z$l$J$+$C$?!VM>$j!W$bC4Ev$7$^$7$g$&(B */
    $USE(D_WorkRestSize);
    /* size := imm_base + imm_size - start_ptr */
    b_MinusWithDNTC(start_ptr,D_WorkRestSize);
    b_AddImmediateWithDNTC(D_WorkRestSize,imm_base,size);
    b_AddImmediateWithTag(size,imm_size,size);
    $RELEASE(D_WorkRestSize);
  }
  $RELEASE(D_WorkAllocCnt);$RELEASE(D_WorkPENum);
}

/******************************************************************** PSL **
s_IfMyJob
       written by imai@icot22      on Thu Aug  2 10:30:53 1990
<Arguments>
  imm_number : $B<+J,$N;E;v$+$I$&$+$NH=Dj$N$?$a$NB(CM(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
  see. f_GCPostProcedure in f_gc_in_cluster.psl.c
<Test>
<Explanation>
  $BFHN)$J;E;v$,(B 4 $B$D$"$j(B
  $B%/%i%9%?Fb(B PE $BBf?t$,(B 2$B$N;~!"(B
		$B;E;vHV9f(B 0,2 $B$O!"(BPE0
		$B;E;vHV9f(B 1,3 $B$O!"(BPE1
  $B%/%i%9%?Fb(B PE $BBf?t$,(B 3$B$N;~!"(B
		$B;E;vHV9f(B 0,3 $B$O!"(BPE0
		$B;E;vHV9f(B 1   $B$O!"(BPE1
		$B;E;vHV9f(B 2   $B$O!"(BPE2
  $B%/%i%9%?Fb(B PE $BBf?t$,(B 4$B0J>e$N;~!"(B
		$B;E;vHV9f(B 0   $B$O!"(BPE0
		$B;E;vHV9f(B 1   $B$O!"(BPE1
		$B;E;vHV9f(B 2   $B$O!"(BPE2
		$B;E;vHV9f(B 3   $B$O!"(BPE3
<ETC>
********************************************************************* PSL **/

#CTRL_define s_IfMyJob(imm_number) {
  $USE(D_WorkS1);
  b_SetImmValueDNTC(imm_number,D_WorkS1);
  $USE(D_WorkPENum);
  b_ReadPENumInCluster(D_WorkPENum);
  b_ModuloWithDNTC(D_WorkS1,D_WorkPENum,D_WorkPENum);
  $RELEASE(D_WorkS1);
  p_Compare(D_WorkPENum,D_PE_Number);
  $RELEASE(D_WorkPENum);
  p_IfEQ()
}

/******************************************************************** PSL **
$B9=B$BNI=$N%a%s%F%J%s%9(B
       written by imai@icot22      on Tue Sep 11 16:58:55 1990

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_ClearIDHashAndConnectStructTable(chain_top)
{
  $USE(D_WorkAddr); $USE(D_WorkSize);
  $USE(D_WorkOldStructRecPtr); $USE(D_WorkTail);

  b_SetImmTypeValueMRBoff(WEXREF,_STR_ID_HASH_TBL_BASE,D_WorkAddr);
  b_SetImmValueDNTC(_STR_ID_HASH_TBL_SIZE,D_WorkSize);
  p_MoveWord(D_EOL,chain_top);
  LOOP() {
    p_Read(D_WorkAddr,D_WorkOldStructRecPtr);
    b_IfNotEOL(D_WorkOldStructRecPtr) {
      p_Write(D_EOL,D_WorkAddr);
      s_GetTailOfStrIdHashChain(D_WorkOldStructRecPtr,D_WorkTail);
      s_PutIdChainStructRec(D_WorkTail,chain_top);
      p_MoveWord(D_WorkOldStructRecPtr,chain_top);
    }
    b_IncrementAddrReg(D_WorkAddr);
    b_DecrementAddrReg(D_WorkSize);
    p_IfEQ() { break; }
  }
  $RELEASE(D_WorkTail); $RELEASE(D_WorkOldStructRecPtr);
  $RELEASE(D_WorkSize); $RELEASE(D_WorkAddr);
}

#PSL_define s_ClearAddressHashStructTable()
{
  $USE(D_WorkAddr); $USE(D_WorkSize);
  b_SetImmTypeValueMRBoff(WEXREF,_STR_ADDR_HASH_TBL_BASE,D_WorkAddr);
  b_SetImmValueDNTC(_STR_ADDR_HASH_TBL_SIZE,D_WorkSize);
  LOOP() {
    p_Write(D_EOL,D_WorkAddr);
    b_IncrementAddrReg(D_WorkAddr);
    b_DecrementAddrReg(D_WorkSize);
    p_IfEQ() { break; }
  }
  $RELEASE(D_WorkSize); $RELEASE(D_WorkAddr);
}


#DATA_define D_WorkOldStructRecPtr XXX
#DATA_define D_WorkNewStructRecPtr XXX

#PSL_define s_PushStrTableRecordIntoHashLink(chain_top)
{
  $USE(D_WorkOldStructRecPtr); $USE(D_WorkNewStructRecPtr);
  $USE(D_WorkStrAddr); $USE(D_WorkElement); $USE(D_WorkHashEntry);

  p_MoveWord(chain_top,D_WorkOldStructRecPtr);
  LOOP() {
    b_IfEOL(D_WorkOldStructRecPtr) { break; }
    s_GetAddrStructRec(D_WorkOldStructRecPtr,D_WorkStrAddr);
    TypeSwitch(D_WorkStrAddr) {
    case VECT:
      s_GetSizeLongVect(D_WorkStrAddr,D_WorkElement);
      break;
    case MOD: case REF:
	/* REF $B$H$$$&$N$O!"(BMOD $BE~Ce$^$G$N(B EXVAL $B$X$N%]%$%s%?(B */
      p_Read(D_WorkStrAddr,D_WorkElement);
      break;
    default:
      @DEBUG{ VPIM_ERROR("f_MaintainStructTable","Illegal Type"); };
    }
    s_IfMarked(D_WorkElement) {
	/* (1) $B?7NN0h$K%l%3!<%I$r3d$jIU$1$k(B */
      s_AllocEntryOfStructRec(D_WorkNewStructRecPtr);
	/* (2) $B9=B$BN$X$N%"%I%l%9$r=q$/(B */
      p_MoveValue(D_WorkElement,D_WorkStrAddr); /* $B%?%0ItJ]B8(B */
      s_PutAddrStructRec(D_WorkNewStructRecPtr,D_WorkStrAddr);
      goto Maintain_Common;
    }
    s_IfSystemArea(D_WorkStrAddr) { /* D-Code $B%b%8%e!<%k$N$?$a(B */
      @DEBUG{ s_IfNotMOD(D_WorkStrAddr) {
	VPIM_ERROR("s_PushStrTableRecordIntoHashLink","Not D-Code Module");
      }};
	/* (1) $B?7NN0h$K%l%3!<%I$r3d$jIU$1$k(B */
      s_AllocEntryOfStructRec(D_WorkNewStructRecPtr);
	/* (2) $B9=B$BN$X$N%"%I%l%9$r=q$/(B */
      s_PutAddrStructRec(D_WorkNewStructRecPtr,D_WorkStrAddr);
      goto Maintain_Common;
    } else {
      goto NEXT;
    }
  Maintain_Common:
    /*========= $B9=B$BN$O%3%T!<$5$l$?(B --> $B#G#C8e$bM-8z(B ============*/
	/* (3) $B%"%I%l%9%O%C%7%e%A%'!<%s$K%W%C%7%e(B */
    s_PutAddrChainStructRec(D_WorkNewStructRecPtr,D_EOL);
    s_HashStrAddrGetEntryAddr(D_WorkStrAddr,D_WorkHashEntry);
    p_Read(D_WorkHashEntry,chain_top);
    s_PushStrAddrHashChain(D_WorkNewStructRecPtr,chain_top);
    p_Write(chain_top,D_WorkHashEntry);
	/* (4) $B9=B$BN#I#D$r%3%T!<$9$k(B */
    s_GetIdStructRec(D_WorkOldStructRecPtr,D_WorkElement);
    s_PutIdStructRec(D_WorkNewStructRecPtr,D_WorkElement);
	/* (5) $B#I#D%O%C%7%e%A%'!<%s$K%W%C%7%e(B*/
    s_PutIdChainStructRec(D_WorkNewStructRecPtr,D_EOL);
    s_HashStrIdGetEntryAddr(D_WorkElement,D_WorkHashEntry);
    p_Read(D_WorkHashEntry,chain_top);
    s_PushStrIdHashChain(D_WorkNewStructRecPtr,chain_top);
    p_Write(chain_top,D_WorkHashEntry);

  NEXT:
    s_GetIdChainStructRec(D_WorkOldStructRecPtr,D_WorkOldStructRecPtr);
  }
  $RELEASE(D_WorkOldStructRecPtr); $RELEASE(D_WorkNewStructRecPtr);
  $RELEASE(D_WorkStrAddr); $RELEASE(D_WorkElement); $RELEASE(D_WorkHashEntry);
}


#PSL_define	s_CheckChildCount(fp_ptr,deadlock_goal_flag_reg)
{
  $USE(D_WorkCnt);  $USE(D_WorkFPOrgReg);
  s_GetFPChildCount(fp_ptr,D_WorkFPOrgReg);

  s_GetFPStatGatherEventCount(fp_ptr,D_WorkCnt);
  b_SubtractWithTag(D_WorkFPOrgReg,D_WorkCnt,D_WorkFPOrgReg);
  /* $B@hAw$j$7$?%$%Y%s%H=hM}$,M-$k$H$=$l$,%A%c%$%k%I%+%&%s%H$K$bF~$C$F$$$k(B */
                                                         /* Reki 90-11-09 */
  s_GetFPChildCountInGC(fp_ptr,D_WorkCnt);
  p_Compare(D_WorkFPOrgReg,D_WorkCnt);
    @DEBUG{
      p_IfLT() {
	VPIM_ERROR("s_CheckChildCount","Unbelievalble");
      }
    };
  p_IfGT() {
    /* $B1J5WCfCG%4!<%k$rH/8+$9$k=hM}$r9T$J$&$?$a$N%U%i%0$N%;%C%H(B */
    @DEBUG{
      WARNING("s_CheckChildCount","Some goal are deadlocked!");
    };
    p_MoveWord(D_ONE,deadlock_goal_flag_reg);
  }
  $RELEASE(D_WorkFPOrgReg);$RELEASE(D_WorkCnt);
}

/******************************************************************** PSL **
  s_PushMaximalGoalStack(stack_ptr,data_ptr)
  $B6KBg8uJd%F!<%V%k$X$NEPO?(B
       written by imai@icot22      on Mon Oct 15 17:17:43 1990
<Arguments>
 stack_ptr: (modify) $B%9%?%C%/%]%$%s%?(B
 data_ptr:  (src) $BEPO?$9$Y$-%4!<%k%l%3!<%I$^$?$O%^!<%8%c%l%3!<%I$X$N%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  s_PushMaximalGoalStack(stack_ptr,data_ptr)
{
  $USE(D_WorkAddr);
  TypeSwitch(data_ptr) {
  case HOOK:
    p_ReadWithOffset(data_ptr,_GOAL_TYPE_OFST_GR,D_WorkAddr);
    b_IncrementAddrReg(D_WorkAddr);
    b_SetImmTypeMRBoff(HOOK,D_WorkAddr);
    break;
  case MGHOK:
    p_ReadWithOffset(data_ptr,_GOAL_TYPE_OFST_MGR,D_WorkAddr);
    b_SetImmTypeMRBoff(MGHOK,D_WorkAddr);
    break;
  default:
    @DEBUG{VPIM_ERROR("s_PushMaximalGoalStack","Illegal Type");};
  }
  b_PushWordStack(stack_ptr,D_WorkAddr);
  $RELEASE(D_WorkAddr);
  b_IfGreaterEq(stack_ptr, D_UnifyStackLimit) {
    @DEBUG{
      VPIM_ERROR("s_MakeLinkOfMaximalGoalsAndMergers","Stack Overflow");
    };
  }
}

/******************************************************************** PSL **
  s_MarkAndSift_Sub
       written by imai@icot22      on Mon Oct  8 21:11:49 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B6KBg8uJd%F!<%V%k$KEPO?$5$l$?%4!<%k%l%3!<%I!?%^!<%8%c%l%3!<%I$N$&$A!"(B
  $B??$K6KBg$H$J$k%4!<%k$N$_$rCj=P$9$k(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkStackBaseReg	XXX
#DATA_define D_WorkStackLimitReg	XXX
#DATA_define D_WorkNewCrp	XXX /* Crp --> Current Position */
#DATA_define D_WorkNewEndPtr	XXX
#DATA_define D_WorkEndPtr	XXX

#SUBARG_define A_MaximalTablePtr	SRC
#SUBARG_define A_MaximalTableBase	SRC
#SUBARG_define A_GoalPtr		SRC

#SUBROUTINE s_MarkAndSift_Sub(A_MaximalTablePtr,A_MaximalTableBase,A_GoalPtr)
{
  @DEBUG{
    b_IfLess(A_MaximalTablePtr,A_MaximalTableBase) {
      VPIM_ERROR("s_MarkAndSift_Sub","Illegal Area Ptr");
    }
    s_IfNotNewArea(A_GoalPtr) {
      VPIM_ERROR("s_MarkAndSift_Sub","Illegal A_GoalPtr");
    }
  };

  $USE(D_WorkStackPtrReg); $USE(D_WorkStackBaseReg);
  $USE(D_WorkStackLimitReg);
  b_IfGreater(D_CurrentHeapEndPtr,D_HeapHalfAddr) {
    b_SetImmValueDNTC(_HEAP_AREA_BASE,D_WorkStackBaseReg);
    p_MoveValue(D_HeapHalfAddr,D_WorkStackLimitReg);
  } else {
    p_MoveValue(D_HeapHalfAddr,D_WorkStackBaseReg);
    p_MoveValue(D_SizeOfMemory,D_WorkStackLimitReg);
  }
  p_MoveWord(D_WorkStackBaseReg,D_WorkStackPtrReg);
  
  $USE(D_WorkRegCrp); $USE(D_WorkEndPtr);
  s_GetRangeOfStructureMarkingPhaseWithMarkAndSift
      (A_MaximalTablePtr,A_MaximalTableBase,
       A_GoalPtr,D_EOL,A_GoalPtr,D_WorkRegCrp,D_WorkEndPtr);
  LOOP() {
    @DEBUG{ b_IfGreater(D_WorkRegCrp,D_WorkEndPtr) {
      VPIM_ERROR("s_MarkAndSift_Sub","Illegal D_WorkRegCrp???");
    }};
    b_IfEqual(D_WorkRegCrp,D_WorkEndPtr) {
      @DEBUG{ b_IfLess(D_WorkStackPtrReg,D_WorkStackBaseReg) {
	VPIM_ERROR("s_MarkAndSift_Sub","Mark Stack Empty");
      }};
      b_IfEqual(D_WorkStackPtrReg,D_WorkStackBaseReg) {
	/* $B%9%?%C%/$,6u$K$J$C$?$i=*N;(B */	break;
      }
      s_PopMarkStack(D_WorkStackPtrReg,D_WorkRegCrp,D_WorkEndPtr);
    }
    $USE(D_WorkElement);
    p_Read(D_WorkRegCrp,D_WorkElement);
    $USE(D_WorkNewCrp); $USE(D_WorkNewEndPtr);
	 /* $B$3$NCf$G!"(BSift $B$b9T$J$&(B */
    s_GetRangeOfStructureMarkingPhaseWithMarkAndSift
      (A_MaximalTablePtr,A_MaximalTableBase,
       A_GoalPtr,D_WorkRegCrp,D_WorkElement,D_WorkNewCrp,D_WorkNewEndPtr);
    $RELEASE(D_WorkElement);
    b_IncrementAddrReg(D_WorkRegCrp);
    b_IfWordNotEq(D_WorkNewCrp,D_NULL) {
      b_IfNotEqual(D_WorkRegCrp,D_WorkEndPtr) { 
	s_PushMarkStack(D_WorkStackPtrReg,D_WorkRegCrp,D_WorkEndPtr);
	b_IfGreater(D_WorkStackPtrReg,D_WorkStackLimitReg) {
	  @DEBUG{ VPIM_ERROR("s_MarkAndSift_Sub","MarkStackOverflow");};
	}
      } /* else  $B9=B$BN$N:G8e$NMWAG$N>l9g$O!"%9%?%C%/$K@Q$^$J$$(B ($B:GE,2=(B) */
      p_MoveWord(D_WorkNewCrp,D_WorkRegCrp);
      p_MoveWord(D_WorkNewEndPtr,D_WorkEndPtr);
    }
    $RELEASE(D_WorkNewCrp); $RELEASE(D_WorkNewEndPtr);
  }
  $RELEASE(D_WorkRegCrp); $RELEASE(D_WorkEndPtr);
  $RELEASE(D_WorkStackBaseReg);$RELEASE(D_WorkStackPtrReg);
  $RELEASE(D_WorkStackLimitReg);
  $RETURN();
}

/******************************************************************** PSL **
s_GetRangeOfStructureMarkingPhase(ptr_reg,dst_start,dst_end)
$B9=B$BN$N:F5"E*$KD4$Y$k$Y$-3+;OE@$H!"=*N;E@$N%"%I%l%9$r5a$a$k(B
$B$^$?!":F$SK,$l$J$$$h$&$K%^!<%/$E$1$r9T$J$&(B

       written by imai@icot22      on Thu Oct 11 11:42:05 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
  $B9=B$BN$G$J$$>l9g!"(Bdst_start $B$K(B D_NULL $B$rJV$9(B
  $B%4!<%k%l%3!<%I$N>l9g!"3+;OE@!"=*N;E@$O(B $B0z?t%9%m%C%H$N$_$rBP>]$K$9$k(B

  $B=*N;E@$O!"$=$l$r4^$^$J$$(B

	|	|
start	|-------| ----+
------->|///////|     |
	|-------|     |
	|///////|     | $BD4$Y$kHO0O(B
	|-------|     |
	|///////|     |
end	|-------| ----+
------->|	|
	|-------|

<Test>
<Explanation>
$B1J5WCfCG%4!<%k$NJs9p$KEv$?$C$F$O!"Js9p$r9T$J$&%4!<%k!J6KBg%4!<%k!K$O!"(B
$B<B9T$,J|4~$5$l$?$3$H$K$J$k(B(Reduction Failure $B$HF1$8(B)$B!#$f$($K!"$=$N%4!<%k$O(B
HOOK $B%A%'!<%s$+$i30$9I,MW$,$"$k!#$J$<$J$i!"(BHOOK$B%A%'!<%s$K7R$,$C$F$$$k$H!"(B
$B$=$NJQ?t$,6qBN2=$5$l$?;~$K!"<B9T$rJ|4~$7$?$O$:$N6KBg%4!<%k$,:F3+$5$l$F(B
$B$7$^$&$+$i$G$"$k!#$3$N=hM}$r!"$3$N%^%/%m$G<B9T$9$k!#(B

<ETC>
********************************************************************* PSL **/


#PSL_define s_GetRangeOfStructureMarkingPhaseWithMarkAndSift
     (src_table_ptr,src_table_base,src_goal_reg,
      src_prev_ptr, src_current_ptr_reg,dst_start,dst_end)
{
  @DEBUG{
    s_IfNotNewArea(src_goal_reg) {
      VPIM_ERROR("s_GetRangeOfStructureMarkingPhase","Illegal src_goal_reg");
    }
  };
  TypeSwitch (src_current_ptr_reg) {
  case AtomicGrp():
  case StringGrp(): /* $B%9%H%j%s%0$O$=$N@h$K%]%$%s%?$r;}$?$J$$$N$GL5;k(B */
  case FloatingGrp():
  case NullVectorGrp():
  case UNDF: case VOID:
  case EUNDF: case EOL:
  case BEXREF: case BEXVAL:  case WEXREF: case WEXVAL: /* $B$3$l$i$bL5;k(B!! */
  case COD:  case MOD: /* $B$3$l$i$bL5;k(B!! */
  case SHREC:  case FPREC: /* $B$3$l$^$?L5;k(B!! */
    p_MoveWord(D_NULL,dst_start); break;
  case HOOK: case EHOOK:
    s_IfVisitedObject(src_current_ptr_reg) {
      p_MoveWord(D_NULL,dst_start);
    } else {
      b_IfEqual( src_current_ptr_reg, src_goal_reg ) {
	/* $B8=:_D4::Cf$N6KBg%4!<%k$rH/8+$7$?(B */
	b_IfNotEOL( src_prev_ptr ) {
	  s_DisconnectGoalRecordMarkAndSiftPhase
	    ( src_prev_ptr, src_current_ptr_reg );
	  p_MoveWord(D_NULL,dst_start);
	  break; /* $B$3$l0J>eDI$o$J$$(B */
	}
      }
      s_SetAsVisited(src_prev_ptr);
      s_SearchAndDeleteInMaximalTable
	(src_table_ptr,src_table_base,src_goal_reg,src_current_ptr_reg);
      p_MoveWord(src_current_ptr_reg,dst_start);

      /* $BD4::3+;OE@$H=*N;E@$N@_Dj(B */
      $USE(D_WorkArity); $USE(D_WorkOffset);
      s_GetArityGoalRecord(src_current_ptr_reg,D_WorkArity);
      b_ExchangeElmposToOffset(D_WorkArity,D_WorkOffset);
      b_DecrementAddrReg(D_WorkOffset);
/*
      b_AddWithDNTC(dst_start,D_WorkOffset,dst_end);
      b_AddImmediateWithDNTC(dst_end,_SIZE_OF_CTRL_INFO_GR,dst_end);
*/
      b_SetImmValueDNTC(_SIZE_OF_CTRL_INFO_GR,dst_end);
      b_ExchangeElmposToOffset(dst_end,dst_end);
      b_AddWithDNTC(dst_end,dst_start,dst_end);
      $RELEASE(D_WorkArity); $RELEASE(D_WorkOffset);
    }
    break;
  case REF:
    s_IfVisitedObject(src_prev_ptr) {
      p_MoveWord(D_NULL,dst_start);	/* $BL58B%k!<%W$KBP1~(B */
    } else {
      p_MoveWord(src_current_ptr_reg,dst_start);
      b_AddImmediateWithDNTC(src_current_ptr_reg,_WORD_1,dst_end);
      s_SetAsVisited(src_prev_ptr); 
   }
    break;
  case StreamGrp():
    s_IfVisitedObject(src_current_ptr_reg) {
      p_MoveWord(D_NULL,dst_start);
    } else {
      s_SetAsVisited(src_prev_ptr);
      s_SearchAndDeleteInMaximalTable
	(src_table_ptr,src_table_base,src_goal_reg,src_current_ptr_reg);
      /* $BD4::3+;OE@$H=*N;E@$N@_Dj(B */
      /* $B%^!<%8%c=PNO$N#1%o!<%I$@$1$G$h$$(B */
      b_AddImmediateWithDNTC(src_current_ptr_reg,_WORD_1,dst_start);
      b_AddImmediateWithDNTC(src_current_ptr_reg,_WORD_2,dst_end);
    }
    break;
  case ShortVectorGrp (): /* VECT1$B!A(BVECT8 */
    s_IfVisitedObject(src_current_ptr_reg) {
      p_MoveWord(D_NULL,dst_start);
    } else {
      p_MoveWord(src_current_ptr_reg,dst_start);
      $USE(D_WorkArity); $USE(D_WorkOffset);
      s_GetSizeShortVect(src_current_ptr_reg, D_WorkArity);
      b_ExchangeElmposToOffset(D_WorkArity, D_WorkOffset);
      b_AddWithDNTC(dst_start,D_WorkOffset,dst_end);
      $RELEASE(D_WorkArity); $RELEASE(D_WorkOffset);
      s_SetAsVisited(src_prev_ptr);
    }
    break;
  case LongVectorGrp () : /* $B%G%9%/%j%W%?$OL5;k(B */
    s_IfVisitedObject(src_current_ptr_reg) {
      p_MoveWord(D_NULL,dst_start);
    } else {
      p_MoveWord(src_current_ptr_reg,dst_start);
      $USE(D_WorkArity); $USE(D_WorkOffset);
      s_GetSizeLongVect(src_current_ptr_reg, D_WorkArity);
      b_ExchangeElmposToOffset(D_WorkArity, D_WorkOffset);
      b_AddWithDNTC(dst_start,D_WorkOffset,dst_end);
      $RELEASE(D_WorkArity); $RELEASE(D_WorkOffset);
      s_SetAsVisited(src_prev_ptr);
    }
    break;
  case DREF:
    s_IfVisitedObject(src_current_ptr_reg) {
      p_MoveWord(D_NULL,dst_start);
    } else {
      p_MoveWord(src_current_ptr_reg,dst_start);
      b_AddImmediateWithDNTC(src_current_ptr_reg,_SIZE_OF_SF,dst_end);
      s_SetAsVisited(src_prev_ptr);
    }
    break; 
  case MHOOK:  case EMHOK:
    s_IfVisitedObject(src_current_ptr_reg) {
      p_MoveWord(D_NULL,dst_start);
    } else {
      p_MoveWord(src_current_ptr_reg,dst_start);
      b_AddImmediateWithDNTC(src_current_ptr_reg,_SIZE_OF_SR,dst_end);
      s_SetAsVisited(src_prev_ptr);
    }
    break; 
  case RDHOK:
    s_IfVisitedObject(src_current_ptr_reg) {
      p_MoveWord(D_NULL,dst_start);
    } else {
      p_MoveWord(src_current_ptr_reg,dst_start);
      b_AddImmediateWithDNTC(src_current_ptr_reg,_RDHOK_REC_SIZE,dst_end);
      s_SetAsVisited(src_prev_ptr);
    }
    break;
  case RHOOK:
    s_IfVisitedObject(src_current_ptr_reg) {
      p_MoveWord(D_NULL,dst_start);
    } else {
      p_MoveWord(src_current_ptr_reg,dst_start);
      b_AddImmediateWithDNTC(src_current_ptr_reg,_REPLY_REC_SIZE,dst_end);
      s_SetAsVisited(src_prev_ptr);
    }
    break;
  case ListGrp () :
    s_IfVisitedObject(src_current_ptr_reg) {
      p_MoveWord(D_NULL,dst_start);
    } else {
      p_MoveWord(src_current_ptr_reg,dst_start);
/*
      b_AddImmediateWithDNTC(src_current_ptr_reg,_SIZE_OF_LIST,dst_end);
*/
      b_SetImmValueDNTC(_SIZE_OF_LIST,dst_end);
      b_ExchangeElmposToOffset(dst_end,dst_end);
      b_AddImmediateWithDNTC(src_current_ptr_reg,dst_end,dst_end);
      s_SetAsVisited(src_prev_ptr);
    }
    break;
  default:
    @DEBUG { VPIM_ERROR ("s_GetSizeofStrct", "Illegal Type"); };
  }
}


#PSL_define      s_SearchAndDeleteInMaximalTable
	(src_table_ptr,src_table_base,src_goal_reg,src_current_ptr_reg)
{
  $USE(D_WorkPtr1); $USE(D_WorkGoals);
  p_MoveWord(src_table_ptr,D_WorkPtr1);
  LOOP() {
    p_Read(D_WorkPtr1,D_WorkGoals);
    b_IfEqual(D_WorkGoals,src_current_ptr_reg) {
      b_IfEqual(D_WorkGoals,src_goal_reg) {
	/* $B:#D4$Y$F$$$k6KBg%4!<%k$O8+$D$+$C$FEv$?$jA0(B */
	break;
      } else {
	/* $B:#$_$D$1$?%4!<%k$O6KBg%4!<%k$G$O$J$$$3$H$,H=L@$7$?(B */
	/* HOOK or MGHOK $B$N%]%$%s%?$rL58z2=$9$k(B */
	p_Write(D_NULL,D_WorkPtr1);
	break;
      }
    }
    b_IfEqual(D_WorkPtr1,src_table_base) { break; }
    b_DecrementAddrReg(D_WorkPtr1);
  }
  $RELEASE(D_WorkGoals);  $RELEASE(D_WorkPtr1);
}

#DATA_define D_WorkNextPtr XXX

#PSL_define      s_DisconnectGoalRecordMarkAndSiftPhase
	( src_prev_ptr, src_current_ptr_reg )
{
  /* $B6KBg%4!<%k$N(B NEXT LINK $B$rD4$Y$k(B */
  /* $B$3$N(B HOOK $B$O!"2?$+$i;X$5$l$F$$$k$+$rD4$Y$k(B */
  $USE(D_WorkNextPtr); $USE(D_WorkNewReg);
  s_GetNextGoalRecord( src_current_ptr_reg, D_WorkNextPtr );
  s_IfREF( src_prev_ptr ) {
      /* (1) REF $B$+$i;X$5$l$?(B $BJQ?t%;%k(B */
	/*---- $BJQ?t%;%k$+$i;X$5$l$F$$$k(B ---*/
    b_IfEOL( D_WorkNextPtr ) {
      s_IfHOOK( src_current_ptr_reg ) {
	b_SetImmTypeValueMRBoff( UNDF, _ZERO, D_WorkNewReg );
      } else { /* Only EHOOK */
	b_SetImmTypeValueMRBoff( EUNDF, _ZERO, D_WorkNewReg );
      }
    } else {
      s_IfHOOK( src_current_ptr_reg ) {
	@DEBUG {
	  s_IfEHookGrp(D_WorkNextPtr) {
	    VPIM_ERROR("s_GetRangeOfStructureMarkingPhaseWithMarkAndSift",
		       "Illegal D_WorkNextPtr (EHookGrp)");
	  }};
	p_MoveWord(D_WorkNextPtr, D_WorkNewReg );
      } else { /* Only EHOOK */
	p_MoveWord(D_WorkNextPtr, D_WorkNewReg );
	TypeSwitch(D_WorkNextPtr) {
	case HOOK:
	  p_SetImmediateType(EHOOK,D_WorkNewReg ); break;
	case MHOOK:
	  p_SetImmediateType(EMHOK,D_WorkNewReg ); break;
	case RHOOK:
	case RDHOK: break;
	default:
	  @DEBUG{
	    VPIM_ERROR("s_GetRangeOfStructureMarkingPhaseWithMarkAndSift",
		       "Illegal Type"); };
	}
      }
    }
  } else {
      /* (2) $B$=$l0J30$N@)8f%l%3!<%I$+$i;X$5$l$?(B HOOK $B%A%'!<%s(B */
	  /*---- $B%j%s%/9=B$$+$i;X$5$l$F$$$k(B ----*/
    p_MoveWord( D_WorkNextPtr, D_WorkNewReg );
  }
  p_Write(D_WorkNewReg, src_prev_ptr);
  $RELEASE(D_WorkNextPtr); $RELEASE(D_WorkNewReg);
}

#ADDR_define _WORD_MINUS_1_OFST	(-1)
#ADDR_define _WORD_MINUS_2_OFST	(-2)

#PSL_define s_PushMarkStack(stack_ptr,src_current_ptr,src_end_ptr)
{
  @DEBUG{
    s_IfNotOldArea(stack_ptr) {
      VPIM_ERROR("s_PushMarkStack","Illegal stack_ptr");
    }
    s_IfNotNewArea(src_current_ptr) {
      VPIM_ERROR("s_PushMarkStack","Illegal src_current_ptr");
    }
    s_IfNotNewArea(src_end_ptr) {
      VPIM_ERROR("s_PushMarkStack","Illegal src_current_ptr");
    }
  };
  p_WriteWithOffset(src_current_ptr,stack_ptr,_WORD_0);
  p_WriteWithOffset(src_end_ptr,stack_ptr,_WORD_1);
  b_AddImmediateWithTag(stack_ptr,_WORD_2,stack_ptr);
}

#PSL_define s_PopMarkStack(stack_ptr,dst_current_ptr,dst_end_ptr)
{
  @DEBUG{
    s_IfNotOldArea(stack_ptr) {
      VPIM_ERROR("s_PopMarkStack","Illegal stack_ptr");
    }
  };
  /* for pipeline */
  p_ReadWithOffset(stack_ptr,_WORD_MINUS_1_OFST,dst_end_ptr);
  p_ReadWithOffset(stack_ptr,_WORD_MINUS_2_OFST,dst_current_ptr);
  b_SubtractImmediateWithTag(stack_ptr,_WORD_2,stack_ptr);
  @DEBUG{
    s_IfNotNewArea(dst_current_ptr) {
      VPIM_ERROR("s_PopMarkStack","Illegal dst_current_ptr");
    }
    s_IfNotNewArea(dst_end_ptr) {
      VPIM_ERROR("s_PopMarkStack","Illegal dst_current_ptr");
    }
  };
}


/******************************************************************** PSL **
VISITED $B%^!<%/$K4X$9$kA`:n(B
       written by imai@icot22      on Sat Oct 13 12:39:30 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  Mark & Sift $B%U%'!<%:$G$O!"6KBg8uJd%F!<%V%k$+$i$?$I$l$k$b$N$r$9$Y$F$?$I$k(B
  $B$?$a$K%9%?%C%/$rMQ$$$k$,!"0lEYC)$C$?%]%$%s%?%?%$%W$O!":G>e0L%S%C%H$rH?E>$7(B
  $B4{$KK,$l$?$3$H$N0u$r$D$1$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
  $B$?$@$7!"<B%"%I%l%96u4V$,(B32bit$B$b$"$k$h$&$J%^%7%s$G$O!"$3$N%F%/%K%C%/$O(B
  $B$D$+$($J$$!#(BPIM/x $B$G$O!"Bg>fIW!#(B
********************************************************************* PSL **/

#CONST_define _VISIT_MARK_MASK_PATTERN 0x80000000
#CONST_define _VISIT_MARK_NOT_PATTERN  0x7fffffff

#PSL_define s_SetAsVisited(ptr_reg)
{
  b_IfNotZero(ptr_reg) {
    /* $B=PH/E@$N>l9g$r=|$/(B */
    $USE(D_WorkReg);
    p_Read(ptr_reg,D_WorkReg);
    @DEBUG{ s_IfVisitedObject(D_WorkReg){
      VPIM_ERROR("s_SetAsVisited","Doubly Marking");}};
    p_BitwiseOrImmediate(D_WorkReg,_VISIT_MARK_MASK_PATTERN,D_WorkReg);
				/* $B%?%0ItJ]B8(B */
    p_Write(D_WorkReg,ptr_reg);
    $RELEASE(D_WorkReg);
  }
}

#CTRL_define s_IfVisitedObject(ptr_reg)
{
  b_BitwiseAndImmediateWithDNTC(ptr_reg,_VISIT_MARK_MASK_PATTERN,D_VOID);
  p_IfNE()
}

#CTRL_define s_IfVisitedPtr(ptr_reg)
{
  $USE(D_WorkMask);
  p_Read(ptr_reg,D_WorkMask);
  b_BitwiseAndImmediateWithDNTC(D_WorkMask,_VISIT_MARK_MASK_PATTERN,D_VOID);
  $RELEASE(D_WorkMask);
  p_IfNE()
}

#PSL_define s_MaintainFosterParentPointersAfterGC()
{
  /* D_Current_FP_Ptr $B$*$h$S!"(BInner Event Stack $BFb$N(B
   * $BN$?F$X$N%]%$%s%?$r%a%s%F%J%s%9$9$k(B
   */

  s_IfSystemArea(D_Current_FP_Ptr) {
     /* $B%@%_!<N$?F!"2?$b$7$J$/$FNI$$(B */    ;
  } else {
    p_ReadWithOffset(D_Current_FP_Ptr,_WORD_0,D_Current_FP_Ptr);
    @DEBUG{ s_IfNotMarked(D_Current_FP_Ptr) {
      VPIM_ERROR("s_MaintainFosterParentPointersAfterGC",
		 "Why Not Marked *D_Current_FP_Ptr!!");
    }};
  }
  b_SetImmTypeMRBoff(FPREC, D_Current_FP_Ptr);

  $USE(D_WorkStackPtrReg); $USE(D_WorkFPPtr);
  p_MoveWord(D_InnerEventStackPtr,D_WorkStackPtrReg);
  LOOP() {
    b_IfEqual(D_WorkStackPtrReg,D_InnerEventStackBase) { break; }
    b_DecrementAddrReg(D_WorkStackPtrReg);
    p_Read(D_WorkStackPtrReg,D_WorkFPPtr);
    @DEBUG{ /* $B$"$$$K$/(B D_WorkFPPtr $B$N%?%$%W$O(B FPREC $B$G$J$$$N$@(B */
      s_IfSystemArea(D_WorkFPPtr) {
	VPIM_ERROR("s_MaintainFosterParentPointersAfterGC","Why Dummy-FP?");
      }
    };
    $USE(D_WorkNewReg);
    p_Read(D_WorkFPPtr,D_WorkNewReg);
    @DEBUG{
      s_IfNotMarked(D_WorkNewReg) {
	VPIM_ERROR("s_MaintainFosterParentPointersAfterGC",
		   "Why Not Marked *D_WorkFPPtr!!");
      }
    };
    p_MoveTag(D_WorkFPPtr,D_WorkNewReg);
    p_Write(D_WorkNewReg,D_WorkStackPtrReg);
    $RELEASE(D_WorkNewReg);
  }
  $RELEASE(D_WorkFPPtr);  $RELEASE(D_WorkStackPtrReg);
}
