/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/structures/str_gc_main.psl.c
   ----- CREATED   : by f-hataza@icot22, on Tue Jun 19 21:15:03 1990
   ----- LAST SAVED: by imai@galileo, on Sun May 24 23:20:57 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : STRUCTURES
   ----- ABSTRACT  : GC$B=hM}$N%a%$%sItJ,(B

  1. $B%9%$!<%W$N4pK\=hM}(B
  2. $B%?%$%W$K$h$j3F<o$N#G#C%k!<%A%s$K%G%#%9%Q%C%A$9$k=hM}(B
  3. $B5lNN0h$+$i?7NN0h$X$N%3%T!<(B
   3.1 $B#1%o!<%I%3%T!<(B
   3.2 $B#2%o!<%I%3%T!<(B
   3.3 $B#N%o!<%I%3%T!<(B
   3.4 $B%Z!<%8%5%$%:L$K~$N%3%T!<(B
   3.5 $B%Z!<%8%5%$%:0J>e$N%3%T!<(B

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

#DATA_define D_WorkSweepPtr		XXX
#DATA_define D_WorkUpdatedSizeOfst	XXX
#DATA_define D_WorkUpdatedPageTop	XXX
#DATA_define D_WorkSweptElm		XXX
#DATA_define D_WorkPageTopPtr		XXX
#DATA_define D_WorkSameSizePageTop	XXX
#DATA_define D_WorkOldAreaElm		XXX
#DATA_define D_WorkPtrToOldArea		XXX
#DATA_define D_WorkUpdatedSizeSweep	XXX
#DATA_define D_WorkStrElement		XXX

/******************************************************************** PSL **
  1. $B%9%$!<%W$N4pK\=hM}(B
    s_SweepPage_Sub

       written by imai@icot22      on Sat Feb 10 16:25:02 1990
<Arguments>
  A_SizeOfst(SRC): $B$3$l$+$i%9%$!<%W$r3+;O$9$k%Z!<%8$N%5%$%:!#(B
	$B%9%$!<%W%]%$%s%?$r3JG<$9$kNN0h$N@hF,$+$i$N%*%U%;%C%H$H$7$FEO$9!#(B
<Temporally Used Variables>
  D_WorkSweepPtr :
	A_SizeOfst $B$NCM$r85$K!"%-%c%C%7%e$7$?%9%$!<%W%]%$%s%?$NCM!#(B
	($B%?%0It$O0UL#$r;}$?$J$$(B)
  D_WorkUpdatedSizeOfst :
	s_GCTypeDispatch() $B$K$h$C$F99?7$5$l$?%Z!<%8$N%5%$%:!#(B
        $B%Z!<%8%H%C%W%]%$%s%?$r3JG<$9$kNN0h@hF,$+$i$N%*%U%;%C%H$H$7$FJV$5$l$k!#(B
	($B%?%0It$O0UL#$r;}$?$J$$(B)
  D_WorkUpdatedPageTop  :
	s_GCTypeDispatch() $B$K$h$C$F99?7$5$l$?%Z!<%8%H%C%W%]%$%s%?$N(B
	$BCM$,JV$5$l$k!#(B
	($B%?%0It$O0UL#$r;}$?$J$$(B)
<Level>
  structures
<PreCondition>
  $BA4$F$N%5%$%:$N%Z!<%8$G!"(BPageTop, Sweep $B6&$K!"%G%-%c%C%7%e$5$l$F$$$k$3$H(B
<Function>
  $B$"$k%5%$%:$N%Z!<%8$r%9%$!<%W$9$k!#(B
  $B%9%$!<%W%]%$%s%?$,!"$3$N%5%$%:$N%Z!<%8%H%C%W$H0lCW$7$?$i!"%k!<%W$+$iH4$1$k!#(B
<Examples>
<PostCondition>
  $BA4$F$N%5%$%:$N%Z!<%8$G!"(BPageTop, Sweep $B6&$K!"%G%-%c%C%7%e$5$l$k!#(B
<Test>
<Explanation>
<ETC>
  $B7k9==hM}$,=E$$$N$G!"(B
  $B#2#5#6%o!<%I%Z!<%8$N%9%$!<%W$H!"(B
  $B$=$l0J30$NBg$-$5$N%Z!<%8$N%9%$!<%W$O(B
  $BJL$N%k!<%A%s$K$7$FF0E*$J%A%'%C%/$r8:$i$7$?J}$,$$$$$+$bCN$l$J$$(B
********************************************************************* PSL **/
#DATA_define D_WorkTop XXX

#SUBARG_define A_SizeOfst	SRC

#SUBROUTINE s_SweepPage_Sub(A_SizeOfst)
{
  $USE(D_WorkSweepPtr);
  $USE(D_WorkUpdatedSizeOfst);
  $USE(D_WorkUpdatedPageTop);
  s_CacheSweepPtr(A_SizeOfst,D_WorkSweepPtr);
  LOOP() {
    @PROBE{ b_IncrementReg(D_GC_SWEEP_PTR_MOVE); };
    s_GCTypeDispatch
      (D_WorkSweepPtr,D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop);
  /*-------------------------------------------------------------*
    $B>e5-%^%/%m8F$S=P$7$K$h$j(B
	D_WorkSweepPtr $B$O!"(B1$B%o!<%I99?7$5$l$k!#(B (CDESC$B;~(B $B$N$_(B $BNc30(B)
	PageTopPtr$B$O!"(B $B$I$l$+$R$H$D$@$199?7$5$l$k!#(B
	    ( $B$?$@$7!"(BAtomic$B%G!<%?$r%9%$!<%W$7$?;~$J$I$O!"99?7$5$l$J$$!#(B)
	$B99?7$5$l$?%Z!<%8$N(B
		$B%5%$%:$r<($9(B	D_WorkUpdatedSizeOfst
		$B99?7$5$l$?CM(B	D_WorkUpdatedPageTop
	$B$,!"JV$5$l$k!#(B
   *-------------------------------------------------------------*/
    s_CheckPageTopPtrOverflow
      (D_WorkUpdatedSizeOfst,D_WorkUpdatedPageTop,D_WorkSweepPtr,A_SizeOfst);
    s_CheckSweepPtrOverflow(D_WorkSweepPtr,A_SizeOfst);
      /*------------------------------------------------*
       * $B%9%$!<%W$,%Z!<%8%H%C%W$H0lCW$7$?$i!"(B		*
       * $B%k!<%W$+$iH4$1$k(B				*
       *------------------------------------------------*/
    b_IfNotEqual(A_SizeOfst,D_WorkUpdatedSizeOfst) {
      s_CachePageTopPtr(A_SizeOfst,D_WorkUpdatedPageTop);
    }
    @DEBUG{ b_IfGreater(D_WorkSweepPtr,D_WorkUpdatedPageTop) {
      VPIM_ERROR("s_SweepPage_Sub","Why SweepPtr > PageTopPtr");
    }};
    b_IfEqual(D_WorkSweepPtr,D_WorkUpdatedPageTop) {
      s_DecacheSweepPtr(A_SizeOfst,D_WorkSweepPtr);	break;
    }
  }
  $RELEASE(D_WorkUpdatedPageTop); $RELEASE(D_WorkUpdatedSizeOfst);
  $RELEASE(D_WorkSweepPtr);
  $RETURN();
}


/******************************************************************** PSL **
  s_CheckPageTopPtrOverflow

  $B%3%T!<8e!"%Z!<%8%H%C%W$,#H#E#U!J%R!<%W3HD%%f%K%C%H!K$r;H$$@Z$C$?$+$I$&$+$N(B
  $B%A%'%C%/$r9T$J$&(B
       written by imai@icot22      on Mon Feb 18 14:04:08 1991

<Arguments>
  updated_size_ofst:	$B99?7$5$l$?!J$+$b$7$l$J$$!K%Z!<%8%H%C%W$N%5%$%:$r<($9(B
			$B!J<B:]$K$O!"$=$N%]%$%s%?$N%;!<%V@h%*%U%;%C%H!K(B
  updated_pagetop:	$B99?7$5$l$F?7$7$/$J$C$?%Z!<%8%H%C%W$NCM(B
  current_sweep:	$B8=:_%9%$!<%WCf$N0LCV$r;X$9%]%$%s%?(B
  sweeping_size_ofst:	$B8=:_%9%$!<%WCf$N%5%$%:(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_CheckPageTopPtrOverflow
  (updated_size_ofst,updated_pagetop,current_sweep,sweeping_size_ofst)
{
  s_IfModifiedPageTop(updated_size_ofst) {
    s_IfHeapAcquirementUnitTop(updated_pagetop) {
      b_IfLessImm(updated_size_ofst,_PAGE_TOP_256WORD) {
	/*--- $B99?7$5$l$?%Z!<%8%H%C%W$,!"%Z!<%8%5%$%:L$K~$N$b$N$G$"$l$P(B ---*/
	$USE(D_WorkUpdatedSizeSweep);
	s_DecacheSweepPtr(sweeping_size_ofst,current_sweep);
	    /* $B$3$N(BDecache$B$O!"99?7$7$?%Z!<%8$N%5%$%:$,!"%9%$!<%W$7$?%Z!<%8$N(B *
	     * $B%5%$%:$HEy$7$$;~!"<!$N(BCache$B$NA0$K=q$-La$7$F$*$/I,MW$,$"$k$?$a(B */
	s_CacheSweepPtr(updated_size_ofst,D_WorkUpdatedSizeSweep);

	s_IfNotSameHeapAcquirementUnitPreviousUnit
	  (updated_pagetop,D_WorkUpdatedSizeSweep) {
	    @PROBE{ _gc_increment_counter_top_case_1(); };
	    /* 2$B%R!<%W3MF@C10L0J>eN%$l$?$i(B */
	    $USE(D_WorkPageTopPtr);
	    b_SubtractImmediateWithDNTC
	      (updated_pagetop,_SIZE_OF_HEAP_ACQUIREMENT_UNIT_IN_GC,
	       D_WorkPageTopPtr);
	    s_PushOneHeapAcquirementUnitGCStack(D_WorkPageTopPtr);
	    $RELEASE(D_WorkPageTopPtr);
	  } else {
	    /* $BF1;~$K(B Sn, Bn  $B$,(B HEU top $B$KE~C#$7$?;~$N$?$a$NBP:v(B */
	    s_IfHeapAcquirementUnitTop(current_sweep) {
	      b_IfEqual(sweeping_size_ofst, updated_size_ofst) {
		$USE(D_WorkPageTopPtr);
		b_SubtractImmediateWithDNTC
		  (updated_pagetop,_SIZE_OF_HEAP_ACQUIREMENT_UNIT_IN_GC,
		   D_WorkPageTopPtr);
		s_PushOneHeapAcquirementUnitGCStack(D_WorkPageTopPtr);
		$RELEASE(D_WorkPageTopPtr);
		s_AllocOnePageGC(updated_pagetop);
		s_SetNewSweepPtrAsTopOfHEU(current_sweep,updated_pagetop);
		goto NoAllocNewPage;
	      }
	    }
	    @PROBE{ _gc_increment_counter_top_case_2(); };
	  }
	s_AllocOnePageGC(updated_pagetop);
      NoAllocNewPage:;
	$RELEASE(D_WorkUpdatedSizeSweep);
      } else {
	/* $B%Z!<%8%5%$%:0J>e$N>l9g$O$"$i$+$8$a3d$jIU$1$F$*$/$3$H$,$G$-$J$$$N$G!"(B
	  CopyGCCore$B$GI,MW;~$K3d$jIU$1$i$l$F$$$k(B */
	@PROBE{ _gc_increment_counter_top_case_3(); }; 
      }
    } else {
      @PROBE{ _gc_increment_counter_top_case_4(); }; 
    }
    s_DecachePageTopPtr(updated_size_ofst,updated_pagetop);
  }
}

/******************************************************************** PSL **
  s_CheckPageTopPtrOverflow

  $B%3%T!<8e!"%Z!<%8%H%C%W$,#H#E#U!J%R!<%W3HD%%f%K%C%H!K$r;H$$@Z$C$?$+$I$&$+$N(B
  $B%A%'%C%/$r9T$J$&(B

       written by imai@icot22      on Mon Feb 18 14:07:48 1991

<Arguments>
 sweep_ptr:		$B8=:_%9%$!<%WCf$N0LCV$r<($7$?%]%$%s%?(B
 sweeping_size_ofst:	$B8=:_%9%$!<%WCf$N%5%$%:(B
			$B!J<B:]$K$O!"$=$N%]%$%s%?$N%;!<%V@h%*%U%;%C%H!K(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/


#PSL_define s_CheckSweepPtrOverflow(sweep_ptr,sweeping_size_ofst)
{
  s_IfLoadDistributionUnitTop(sweep_ptr) {
    b_IfLessEqImm(sweeping_size_ofst,_LOAD_DISTRIBUTION_UNIT_OFST) {
      /*----------------------------------------------------------------*
       * $B%9%$!<%W$,Ii2YJ,;6%f%K%C%H$N:G8e$KE~C#$7$?$i!"(B			*
       * ( 32$B%o!<%I0J>e$N%Z!<%8$r%9%$!<%WCf$N>l9g$r=|$/(B)		*
       * --> because 65$B%o!<%I$N9=B$BN$O(B 128 $B%o!<%I$K3d$jIU$1$i$l$k$,(B	*
       *     $B$3$N>l9g!"%9%$!<%W%]%$%s%?$N0\F0@h$,(B 96$B%o!<%IL\$K$J$j(B	*
       *     (CDESC$B$GHt$P$5$l$kH&$N(B) $B%4%_NN0h$K$J$C$F$7$^$&$?$a(B		*
       *----------------------------------------------------------------*/
      $USE(D_WorkSameSizePageTop);
      s_CachePageTopPtr(sweeping_size_ofst,D_WorkSameSizePageTop);
      s_IfNotSameLoadDistributionUnit(D_WorkSameSizePageTop,sweep_ptr) {

	s_IfNotSameHeapAcquirementUnit(D_WorkSameSizePageTop,sweep_ptr){
		/*== $BIi2YJ,;6%f%K%C%H$b%R!<%W3MF@%f%K%C%H$b$$$:$l$b0[$J$k(B ==*/
		/*  (I) sweep $B$+$i(B $B%R!<%W3MF@%f%K%C%H$N=*$j$^$G(B
		 * (II) (pagetop$B$N=jB0$9$k(B) $B%R!<%W3MF@%f%K%C%H$N@hF,$+$i(B
		 *     (pagetop$B$N=jB0$9$k(B) $BIi2YJ,;6%f%K%C%H$N@hF,$^$G(B
		 * $B$N#2NN0h$r%W!<%k$KF~$l$k(B
		 */

	  @PROBE{ _gc_increment_counter_sweep_case_1(); };
	  /* $B#1%Z!<%8L\(B */
	  $USE(D_WorkTop); $USE(D_WorkSize);

	  s_IfHeapAcquirementUnitTop(sweep_ptr) {
	    ; /* nothing to do */
	  } else {
	    s_GetTailOfHeapAcquirementUnit(sweep_ptr,D_WorkTop);
	    b_SubtractWithDNTC(D_WorkTop,sweep_ptr,D_WorkSize);
	    s_PushMultipleLoadDistributionUnitGCStack(sweep_ptr,D_WorkSize);
	  }
	  /* $B#2%Z!<%8L\(B */
	  s_GetTopOfLoadDistributionUnit(D_WorkSameSizePageTop,D_WorkTop);
	  s_IfHeapAcquirementUnitTop(D_WorkTop) {
	    p_MoveWord(D_WorkTop,sweep_ptr);
	  } else {
	    $USE(D_WorkPagePtr);
	    s_GetTopOfHeapAcquirementUnit(D_WorkSameSizePageTop,D_WorkPagePtr);
	    b_SubtractWithDNTC(D_WorkTop,D_WorkPagePtr,D_WorkSize);
	    s_PushMultipleLoadDistributionUnitGCStack
	      (D_WorkPagePtr,D_WorkSize);
	    p_MoveWord(D_WorkTop,sweep_ptr);
	    $RELEASE(D_WorkPagePtr);
	  }
	  $RELEASE(D_WorkSize);
	  $RELEASE(D_WorkTop);
	} else {
	  @PROBE{ _gc_increment_counter_sweep_case_2(); };
		/*== $BIi2YJ,;6%f%K%C%H$O0[$J$k$,!"%R!<%W3MF@%f%K%C%H$OF1$8(B ==*/
		/* sweep $B$+$i(B (pagetop$B$N=jB0$9$k(B) $BIi2YJ,;6%f%K%C%H$N@hF,$^$G(B
		 * $B$NNN0h$r%W!<%k$KF~$l$k(B
		 */
	  $USE(D_WorkTop);
	  s_GetTopOfLoadDistributionUnit(D_WorkSameSizePageTop,D_WorkTop);
	  $USE(D_WorkSize);
	  b_SubtractWithDNTC(D_WorkTop,sweep_ptr,D_WorkSize);
	  b_IfNotZero(D_WorkSize) {
	    s_PushMultipleLoadDistributionUnitGCStack(sweep_ptr,D_WorkSize);
	      p_MoveWord(D_WorkTop,sweep_ptr);
	  }
	  $RELEASE(D_WorkSize);
	  $RELEASE(D_WorkTop);
	}
      } else {
	@PROBE{ _gc_increment_counter_sweep_case_3(); };
	s_SetNewSweepPtrAsTopOfLDU(sweep_ptr,D_WorkSameSizePageTop);
      }
      $RELEASE(D_WorkSameSizePageTop);
    } else {
      b_IfNotEqualImm(sweeping_size_ofst,_HEAP_ACQUIREMENT_UNIT_OFST) {
	  /* $B#3#2%o!<%I0J>e#2#5#60J2<$N%9%$!<%W$N>l9g(B */
	s_IfHeapAcquirementUnitTop(sweep_ptr) {
	  @PROBE{ _gc_increment_counter_sweep_case_4(); };
	  $USE(D_WorkSameSizePageTop);
	  s_CachePageTopPtr(sweeping_size_ofst,D_WorkSameSizePageTop);
	  s_SetNewSweepPtrAsTopOfHEU(sweep_ptr,D_WorkSameSizePageTop);
	  $RELEASE(D_WorkSameSizePageTop);
	} else {
	  @PROBE{ _gc_increment_counter_sweep_case_5(); };
	}
      } else {
	/* $B#2#5#60J>e$N%9%$!<%W$N>l9g(B $B!J2?$b$7$J$$!K(B*/
	/* $B$?$@C1$K!"(BSweep = PageTop $B$K$J$k$^$G7+$jJV$9(B */
	@PROBE{ _gc_increment_counter_sweep_case_6(); };
      }
    }
  } else {
    @PROBE{ _gc_increment_counter_sweep_case_6(); };
  }
}

/******************************************************************** PSL **
  2. $B%?%$%W$K$h$j3F<o$N#G#C%k!<%A%s$K%G%#%9%Q%C%A$9$k=hM}(B
    s_GCTypeDispatch

       written by imai@icot22      on Mon Jul  3 13:21:06 1989
<Arguments>
    sweep_ptr           : $B%9%$!<%W%]%$%s%?(B
    updated_size_ofst   : $B%9%$!<%W$K$h$C$F99?7$5$l$?%Z!<%8$N%5%$%:(B ($B%*%U%;%C%H(B)
    updated_pagetop_ptr : $B%9%$!<%W$K$h$C$F99?7$5$l$?%Z!<%8%H%C%W(B
<Temporally Used Variables>
    D_WorkSweptElm      :  sweep_ptr$B$N;X$7$F$$$k@h$rFI$_=P$7$?CM(B
<Level>
<PreCondition>
<Function>
  sweep_ptr$B$N;X$7$F$$$k@h$r(B D_WorkSweptElm $B$KFI$_!"(B
  $B$=$N%?%$%W$K$h$C$F!"$=$l$>$l$N%?%$%W$K1~$8$?(BGC$B%k!<%A%s$r8F$S=P$9(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_GCTypeDispatch(sweep_ptr,updated_size_ofst,updated_pagetop_ptr)
{
  $USE(D_WorkSweptElm);

 Again:
  p_Read(sweep_ptr,D_WorkSweptElm);
  TypeSwitch(D_WorkSweptElm) {
    /*----------------------------------------------------------*
     * $B%]%$%s%?$G$J$$$b$N(B (ATOM, INT, UNDF, VECT0 $B$J$I(B)		*
     *----------------------------------------------------------*/
  case AtomicGrp():		
  case NullVectorGrp():
  case UNDF: case VOID:
  case EUNDF: case EOL: case HLINK: case GOAL:
    b_IncrementAddrReg(sweep_ptr);
    s_SetPageTopNotModified(updated_size_ofst);
    break ;
    /*----------------------------------------------------------*
     * $BIbF0>.?tE@(B				                *
     *----------------------------------------------------------*/
  case FloatingGrp():
/*    @DEBUG{WARNING("s_GCTypeDispatch","GC floating point"); };	*/
    s_GCFLT(sweep_ptr,D_WorkSweptElm,updated_size_ofst,updated_pagetop_ptr);
    break;
    /*----------------------------------------------------------*
     * $B%j%9%H(B							*
     *----------------------------------------------------------*/
  case ListGrp():
    s_GCList(sweep_ptr,D_WorkSweptElm,updated_size_ofst,updated_pagetop_ptr);
    break;
    /*----------------------------------------------------------*
     * $B%9%H%j%s%0(B						*
     *----------------------------------------------------------*/
  case StringGrp():
    s_GCString(sweep_ptr,D_WorkSweptElm,updated_size_ofst,updated_pagetop_ptr);
    break;
    /*----------------------------------------------------------*
     * $B%7%g!<%H%Y%/%?(B						*
     *----------------------------------------------------------*/
  case ShortVectorGrp():
    s_GCShortVector
      (sweep_ptr,D_WorkSweptElm,updated_size_ofst,updated_pagetop_ptr);
    break;
    /*----------------------------------------------------------*
     * $B%m%s%0%Y%/%?(B						*
     *----------------------------------------------------------*/
  case LongVectorGrp():
    s_GCLongVector
      (sweep_ptr,D_WorkSweptElm,updated_size_ofst,updated_pagetop_ptr);
    break;
    /*----------------------------------------------------------*
     * $B#R#E#F(B							*
     *----------------------------------------------------------*/
  case REF:
    $USE(D_WorkDerefPtr);
    /*---- $B%G%l%U%!%l%s%93+;O(B -----------------------------------------*/
    LOOP(){
      s_DerefRegInGC(D_WorkSweptElm, D_WorkDerefPtr); /* MRBor Read */
      s_IfNotREF(D_WorkSweptElm) {
	break;
      }
    }
    /*---- $B%G%l%U%!%l%s%9=*N;(B ------------------------------------------*
     * D_WorkSweptElm: $B%G%l%U7k2L$NF~$C$?%l%8%9%?(B			*
     * D_WorkDerefPtr: D_WorkSweptElm$B$X$N%]%$%s%?$,F~$C$?%l%8%9%?(B(REF)	*
     *------------------------------------------------------------------*/
    s_IfUnbound(D_WorkSweptElm) {	/* $B4^(B EXREF$B7O(B */
      p_Write(D_WorkDerefPtr, sweep_ptr);
      s_GC1WordMark
	(sweep_ptr,D_WorkDerefPtr,updated_size_ofst,updated_pagetop_ptr);
      @PROBE{ s_IfModifiedPageTop(updated_size_ofst) {
	b_IncrementReg(D_GC_VariableCnt);
      }};
      /* $B$3$N7k2L!"(B sweep_ptr $B$O%$%s%/%j%a%s%H$5$l$k!#(B */
    } else {
      s_SetPageTopNotModified(updated_size_ofst);
      s_IfMarked(D_WorkSweptElm) {
	s_WriteNewAreaPtrWithTag(D_WorkDerefPtr,D_WorkSweptElm,sweep_ptr);
	b_IncrementAddrReg(sweep_ptr);
      /* $B$3$N7k2L!"(B sweep_ptr $B$O%$%s%/%j%a%s%H$5$l$k!#(B */
      } else {
	$RELEASE(D_WorkDerefPtr);
	p_Write(D_WorkSweptElm , sweep_ptr);
      /* $B$3$N7k2L!"(B sweep_ptr $B$O%$%s%/%j%a%s%H$5$l$J$$!#(B
       * $B$?$@$7!"(BD_WorkSweptElm$B$,%"%H%_%C%/$G$"$l$P!"(B
       * $B%$%s%/%j%a%s%H$7$F$7$^$C$F$bNI$$(B($B:GE,2=$NM>CO(B)
       */
	goto Again;
      }
    }
    $RELEASE(D_WorkDerefPtr);
    break;
    /*----------------------------------------------------------*
     * $B#D#R#E#F(B $B!J(B Suspend Flag (2word) $B$X$N%]%$%s%?(B: $BB?=E;2>H!K(B*
     *----------------------------------------------------------*/
  case DREF:					
    s_GCSuspendRecordMark
      (sweep_ptr,D_WorkSweptElm,updated_size_ofst,updated_pagetop_ptr);
    break;
    /*----------------------------------------------------------*
     * $B#H#O#O#K(B ( Goal Record $B%X$N%]%$%s%?(B: $BC10l;2>H(B)		*
     *----------------------------------------------------------*/
  case HOOK: case EHOOK:
    s_GCGoalRecord
      (sweep_ptr,D_WorkSweptElm,updated_size_ofst,updated_pagetop_ptr);
    break;
    /*----------------------------------------------------------*
     * $B#M#H#O#O#K(B,     $B#R#H#O#O#K(B,        $B#R#D#H#O#K(B		*
     * suspend record, reply hook record, read hook record	*
     *		$B%X$N%]%$%s%?(B ($B$$$:$l$bC10l;2>H%G!<%?(B)		*
     *----------------------------------------------------------*/
  case MHOOK: case EMHOK: case RDHOK:
    s_GCSuspendRecordNoMark
      (sweep_ptr,D_WorkSweptElm,updated_size_ofst,updated_pagetop_ptr);
    break;
  case RHOOK:
    s_GCRHOOK
      (sweep_ptr,D_WorkSweptElm,updated_size_ofst,updated_pagetop_ptr);
    break;
  case WEXREF: case WEXVAL:
    /*----------------------------------------------------------*
     * $B#W#E#X#R#E#F!!#W#E#X#V#A#L(B ($BGrM"F~I=$X$N%]%$%s%?(B)	*
     *----------------------------------------------------------*/
    s_GCWImpRec
      (sweep_ptr,D_WorkSweptElm,updated_size_ofst,updated_pagetop_ptr);
    break;
    /*----------------------------------------------------------*
     * $B#B#E#X#R#E#F!!#B#E#X#V#A#L(B ($B9uM"F~I=$X$N%]%$%s%?(B)	*
     *----------------------------------------------------------*/
  case BEXREF: case BEXVAL:
    s_GCBImpRec
      (sweep_ptr,D_WorkSweptElm,updated_size_ofst,updated_pagetop_ptr);
    break;
    /*----------------------------------------------------------*
     * $B%9%H%j!<%`%0%k!<%W(B					*
     *----------------------------------------------------------*/
  case StreamGrp():
    s_GCMergerCell
      (sweep_ptr,D_WorkSweptElm,updated_size_ofst,updated_pagetop_ptr);
    break;
    /*----------------------------------------------------------*
     * $B#C#D#E#S#C(B $B!J%9%H%j%s%0$H%3!<%I$N@hF,$N%*%V%8%'%/%H%?%0!K(B*
     *----------------------------------------------------------*/
  case CDESC:
    s_GC_CDESC
	  (sweep_ptr,D_WorkSweptElm,updated_size_ofst,updated_pagetop_ptr);
    break ;
    /*----------------------------------------------------------*
     * $B#C#O#D(B $B!J%3!<%I%X$N%]%$%s%?!K(B				*
     *----------------------------------------------------------*/
  case COD:
    s_GCCode(sweep_ptr,D_WorkSweptElm,updated_size_ofst,updated_pagetop_ptr);
    break;
    /*----------------------------------------------------------*
     * $B#M#O#D(B $B!J%b%8%e!<%k!J%3!<%I$N@hF,!K%X$N%]%$%s%?!K(B	*
     *----------------------------------------------------------*/
  case MOD:
    s_GCModule(sweep_ptr,D_WorkSweptElm,updated_size_ofst,updated_pagetop_ptr);
    break;
    /*----------------------------------------------------------*
     * $B#S#H#R#E#C(B $B!JAq1`%l%3!<%I%X$N%]%$%s%?!K(B			*
     *----------------------------------------------------------*/
  case SHREC:
    $CALL(s_GCShoenRecord_Sub
	  (sweep_ptr,D_WorkSweptElm,updated_size_ofst,updated_pagetop_ptr));
    break;
    /*----------------------------------------------------------*
     * $B#F#P#R#E#C(B $B!JN$?F%l%3!<%I%X$N%]%$%s%?!K(B			*
     *----------------------------------------------------------*/
  case FPREC:
    s_GCFosterParentRecord
      (sweep_ptr,D_WorkSweptElm,updated_size_ofst,updated_pagetop_ptr);
    break;
  case EXLOCK: case SLOCK:
    @DEBUG{ VPIM_ERROR("s_GCTypeDispatch","Locked Tag Appeared (Why?)");};
    break;
  case MARKED:
    @DEBUG{ VPIM_ERROR("s_GCTypeDispatch","MARKED appererd(Why?)");};
    break;
  case DNTC:
    @DEBUG{ VPIM_ERROR("s_GCTypeDispatch","DNTC appererd!! (Why?)");};
    break;
  default:
    @DEBUG{ VPIM_ERROR("s_GCTypeDispatch","Illegal Type");};
  }
  $RELEASE(D_WorkSweptElm);
}

/******************************************************************** PSL **
  3. $B5lNN0h$+$i?7NN0h$X$N%3%T!<(B
   3.1 $B#1%o!<%I%3%T!<(B
     s_GC1WordMark

       written by imai@icot22      on Sat Feb 10 17:34:33 1990
<Arguments>
  sweep_ptr (modify):		($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B%9%$!<%W%]%$%s%?$NCM!"#1%o!<%I%$%s%/%j%a%s%H$5$l$k(B
  swept_elm (src):		($B%?%0!"CM6&$K0UL#$r;}$D(B)
	$B%9%$!<%W%]%$%s%?$N;X$9@h$rFI$_=P$7$?CM(B
	($B5lNN0h$X$N%]%$%s%?$K$J$C$F$$$k(B)
  updated_size_ofst (dst)  : 	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B%3%T!<$7$?>l9g(B		_PAGE_TOP_1WORD $B$NCM(B
	$B%3%T!<:Q$_$N>l9g(B	_PAGE_TOP_NOT_MODIFIED $B$NCM(B $B$rJV$9(B
  updated_pagetop_ptr (dst): 	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B%3%T!<$7$?>l9g(B		$B99?7$7$?%Z!<%8%H%C%W%]%$%s%?$NCM$rJV$9(B
				($B%G%-%c%C%7%e$5$l$F$$$J$$$3$H$KCm0U(B)
	$B%3%T!<:Q$_$N>l9g(B	$B0UL#$r;}$?$J$$(B
<Temporally Used Variables>
  D_WorkOldAreaElm :
	$BFI$_=P$7$?5lNN0h$NCM$r;}$D(B
<Level> structures
<PreCondition>
  $B%Z!<%8%H%C%W%]%$%s%?$O!"A4$F%G%-%c%C%7%e$5$l$F$$$k!#(B
<Function>
  1. swept_elm $B$N;X$9@h$r(B D_WorkOldAreaElm $B$KFI$_=P$9!#(B
  2.a D_WorkOldAreaElm$B$,%^!<%/$5$l$F$$$J$+$C$?$i!"(B
	Compare & Swap $B$G%^!<%/$7!"%3%T!<$r9T$&(B
  2.b D_WorkOldAreaElm$B$,%^!<%/$5$l$F$$$?$i!"$=$NCMIt$K$"$kCM$,(B
	$B0z$C1[$7@h$N?7NN0h$X$N%]%$%s%?$G$"$k!#(B
<Examples>
  invoked by s_GCTypeDispatch
<Test>
<Explanation>
<ETC>
  Compare & Swap $B$K<:GT$7$?>l9g$O!"4{$K%^!<%/$5$l$F$$$?$N$HA4$/F1$8(B
  $B=hM}$GNI$$!#5lNN0h$K$"$k%;%k$O(B 
	(GC $BA0$NCM(B) --> (MARKED)
  $B$K!"0lEYJQ2=$9$k$@$1$G!"$=$l0J>e$O7h$7$FJQ2=$7$J$$$+$i$G$"$k!#(B
********************************************************************* PSL **/

#PSL_define s_GC1WordMark
	(sweep_ptr,swept_elm,updated_size_ofst,updated_pagetop_ptr)
{
  $USE(D_WorkOldAreaElm);
  p_Read(swept_elm,D_WorkOldAreaElm);
  s_IfNotMarked(D_WorkOldAreaElm) {
    b_SetImmValueDNTC(_PAGE_TOP_1WORD,updated_size_ofst);
    s_CachePageTopPtr(updated_size_ofst,updated_pagetop_ptr);
    s_CompareSwapGCOldAreaX(swept_elm,D_WorkOldAreaElm,updated_pagetop_ptr);
    p_IfEQ() { /*------ Compare & Swap Success ------*/
      @PROBE{
	b_IncrementReg(D_GC_COPIED_WORDS_UNDER_PAGE);
	b_IncrementReg(D_GC_MRBx_COUNT);
      };
      s_WriteElementToHeapTop(D_WorkOldAreaElm,updated_pagetop_ptr);
      s_WriteHeapTopPtrWithTag(swept_elm,updated_pagetop_ptr,sweep_ptr);
      b_IncrementAddrReg(updated_pagetop_ptr);
      goto END;
    }
  }
  /*------------ Already Marked!! -------*/
  @PROBE{ b_IncrementReg(D_GC_ALREADY_COPIED_COUNT);};
  s_WriteNewAreaPtrWithTag(swept_elm,D_WorkOldAreaElm,sweep_ptr);
  s_SetPageTopNotModified(updated_size_ofst);
 END:
  b_IncrementAddrReg(sweep_ptr);
  $RELEASE(D_WorkOldAreaElm);
}

/******************************************************************** PSL **
   3.2 $B#2%o!<%I%3%T!<(B
     s_GC2WordMark
     s_GC2WordNoMark
     s_GC2WordMarkWithMRBor

       written by imai@icot22      on Sat Feb 10 17:56:57 1990

<Arguments>
  sweep_ptr (modify):		($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B%9%$!<%W%]%$%s%?$NCM!"#1%o!<%I%$%s%/%j%a%s%H$5$l$k(B
  swept_elm (src):		($B%?%0!"CM6&$K0UL#$r;}$D(B)
	$B%9%$!<%W%]%$%s%?$N;X$9@h$rFI$_=P$7$?CM(B
	($B5lNN0h$X$N%]%$%s%?$K$J$C$F$$$k(B)
  updated_size_ofst (dst)  : 	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B%3%T!<$7$?>l9g(B		_PAGE_TOP_2WORD $B$NCM(B
	$B%3%T!<:Q$_$N>l9g(B	_PAGE_TOP_NOT_MODIFIED $B$NCM(B $B$rJV$9(B
  updated_pagetop_ptr (dst): 	($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B%3%T!<$7$?>l9g(B		$B99?7$7$?%Z!<%8%H%C%W%]%$%s%?$NCM$rJV$9(B
				($B%G%-%c%C%7%e$5$l$F$$$J$$$3$H$KCm0U(B)
	$B%3%T!<:Q$_$N>l9g(B	$B0UL#$r;}$?$J$$(B
<Temporally Used Variables>
  D_WorkOldAreaElm :
	$BFI$_=P$7$?5lNN0h$NCM$r;}$D(B
<Level> structures
<PreCondition>
  $B%Z!<%8%H%C%W%]%$%s%?$O!"A4$F%G%-%c%C%7%e$5$l$F$$$k!#(B
<Function>
  1. swept_elm $B$N;X$9@h$r(B D_WorkOldAreaElm $B$KFI$_=P$9!#(B
  2.a D_WorkOldAreaElm$B$,%^!<%/$5$l$F$$$J$+$C$?$i!"(B
	Compare & Swap $B$G%^!<%/$7!"%3%T!<$r9T$&(B
  2.b D_WorkOldAreaElm$B$,%^!<%/$5$l$F$$$?$i!"$=$NCMIt$K$"$kCM$,(B
	$B0z$C1[$7@h$N?7NN0h$X$N%]%$%s%?$G$"$k!#(B
<Examples>
  invoked by s_GCRef (Only??)
<Test>
<Explanation>
  s_GC2WordMark		: Suspend Flag $B$N$h$&$K(B $BB?=E;2>H$N2DG=@-$,$"$k$b$N(B
  s_GC2WordNoMark	: MRB$B$,!{$N%j%9%H$d!"(BSuspend Record$B$N;~$N$h$&$K!"(B
			  $B5lNN0h$r%^!<%/$9$kI,MW$,$J$$>l9g(B
  s_GC2WordMarkWithMRBor: MRB$B$,!|$N%j%9%H$N;~(B
	$B$3$l$O!"(B
	+-------+    +-------+
	|LIST$B!|(B ---->|ATOM  a|
	+-------+    |-------|      +-------+
	             |LIST$B!{(B ----+->|       |
	+-------+    +-------+   |  |-------+
	|LIST$B!|(B -----------------+  |       |
	+-------+                   +-------+
	$B$3$N$h$&$J9=B$$,$"$C$?>l9g$rA[Dj$7$F!"9=B$BN$NMWAG$r!|$K$7$F(B
	$B!J$3$N>l9g(B LIST$B!{$r(B LIST$B!|$K$7$F!K%3%T!<$9$k$?$a$G$"$k!#(B
	($B$=$&$7$J$$$H!"!{$N>l9g$N:GE,2=$,$G$-$J$$(B)
		
<ETC>
  Compare & Swap $B$K<:GT$7$?>l9g$O!"4{$K%^!<%/$5$l$F$$$?$N$HA4$/F1$8(B
  $B=hM}$GNI$$!#5lNN0h$K$"$k%;%k$O(B 
	(GC $BA0$NCM(B) --> (MARKED)
  $B$K!"0lEYJQ2=$9$k$@$1$G!"$=$l0J>e$O7h$7$FJQ2=$7$J$$$+$i$G$"$k!#(B
********************************************************************* PSL **/

#PSL_define s_GC2WordMark
	(sweep_ptr,swept_elm,updated_size_ofst,updated_pagetop_ptr)
{
  $USE(D_WorkOldAreaElm);
  /*------- $B8F$S$@$7>r7o(B --------*/
  @DEBUG { 
    s_IfMRBoff(swept_elm) {
      s_IfNotDREF(swept_elm) {
	VPIM_ERROR("s_GC2WordMark","MRB is not on");
      }}};
  p_Read(swept_elm,D_WorkOldAreaElm);
  s_IfNotMarked(D_WorkOldAreaElm){
    b_SetImmValueDNTC(_PAGE_TOP_2WORD,updated_size_ofst);
    s_CachePageTopPtr(updated_size_ofst,updated_pagetop_ptr);
    s_CompareSwapGCOldAreaX(swept_elm,D_WorkOldAreaElm,updated_pagetop_ptr);
    p_IfEQ() { /*------ Compare & Swap Success ------*/
      @PROBE{ 
	b_IncrementReg(D_GC_MRBx_COUNT);
	b_AddImmediateWithDNTC
	  (D_GC_COPIED_WORDS_UNDER_PAGE,_TWO,D_GC_COPIED_WORDS_UNDER_PAGE);
      };
      s_WriteElementToHeapTop(D_WorkOldAreaElm,updated_pagetop_ptr);
      s_WriteHeapTopPtrWithTag(swept_elm,updated_pagetop_ptr,sweep_ptr);
      b_IncrementAddrReg(updated_pagetop_ptr);
      b_IncrementAddrReg(swept_elm);
      s_CopyOneWordFromOldToNew(swept_elm,updated_pagetop_ptr);
      b_IncrementAddrReg(updated_pagetop_ptr);
      goto END;
    }
  }
  /* Already Marked!! */
  @PROBE{ b_IncrementReg(D_GC_ALREADY_COPIED_COUNT);};
  s_WriteNewAreaPtrWithTag(swept_elm,D_WorkOldAreaElm,sweep_ptr);
  s_SetPageTopNotModified(updated_size_ofst);
 END:
  b_IncrementAddrReg(sweep_ptr); /* address */
  $RELEASE(D_WorkOldAreaElm);
}

#PSL_define s_GC2WordNoMark
	(sweep_ptr,swept_elm,updated_size_ofst,updated_pagetop_ptr)
{
  $USE(D_WorkOldAreaElm);
  @PROBE{
    b_IncrementReg(D_GC_MRBo_COUNT);
    b_AddImmediateWithDNTC
      (D_GC_COPIED_WORDS_UNDER_PAGE,_TWO,D_GC_COPIED_WORDS_UNDER_PAGE);
  };
  p_Read(swept_elm,D_WorkOldAreaElm);
  @DEBUG{ s_IfMarked(D_WorkOldAreaElm){
    VPIM_ERROR("s_GC2WordNoMark","Why MARKED??");
  }};
  b_SetImmValueDNTC(_PAGE_TOP_2WORD,updated_size_ofst);
  s_CachePageTopPtr(updated_size_ofst,updated_pagetop_ptr);
  s_WriteElementToHeapTop(D_WorkOldAreaElm,updated_pagetop_ptr);
  s_WriteHeapTopPtrWithTag(swept_elm,updated_pagetop_ptr,sweep_ptr);
  b_IncrementAddrReg(updated_pagetop_ptr);
  b_IncrementAddrReg(swept_elm);
  s_CopyOneWordFromOldToNew(swept_elm,updated_pagetop_ptr);
  b_IncrementAddrReg(updated_pagetop_ptr);
  b_IncrementAddrReg(sweep_ptr);
  $RELEASE(D_WorkOldAreaElm);
}

#PSL_define s_GC2WordMarkWithMRBor
	(sweep_ptr,swept_elm,updated_size_ofst,updated_pagetop_ptr)
{
  $USE(D_WorkOldAreaElm);
 /*------- $B8F$S$@$7>r7o(B --------*/
  @DEBUG {
    s_IfMRBoff(swept_elm) {
      VPIM_ERROR("s_GC2WordMarkWithMRBor","MRB is not on");
    }};
  s_ReadWithMRBor(swept_elm,D_WorkOldAreaElm);
  s_IfNotMarked(D_WorkOldAreaElm){
    b_SetImmValueDNTC(_PAGE_TOP_2WORD,updated_size_ofst);
    s_CachePageTopPtr(updated_size_ofst,updated_pagetop_ptr);
    s_CompareSwapGCOldAreaX(swept_elm,D_WorkOldAreaElm,updated_pagetop_ptr);
    p_IfEQ() { /*------ Compare & Swap Success ------*/
      @PROBE{ 
	b_IncrementReg(D_GC_MRBx_COUNT);
	b_AddImmediateWithDNTC
	  (D_GC_COPIED_WORDS_UNDER_PAGE,_TWO,D_GC_COPIED_WORDS_UNDER_PAGE);
      };
      s_WriteElementToHeapTop(D_WorkOldAreaElm,updated_pagetop_ptr);
      s_WriteHeapTopPtrWithTag(swept_elm,updated_pagetop_ptr,sweep_ptr);
      b_IncrementAddrReg(updated_pagetop_ptr);
      b_IncrementAddrReg(swept_elm);
      s_CopyOneWordFromOldToNewWithMRBor(swept_elm,updated_pagetop_ptr);
      b_IncrementAddrReg(updated_pagetop_ptr);
      goto END;
    }
  }
  /* Already Marked!! */
  @PROBE{ b_IncrementReg(D_GC_ALREADY_COPIED_COUNT);};
  s_WriteNewAreaPtrWithTag(swept_elm,D_WorkOldAreaElm,sweep_ptr);
  s_SetPageTopNotModified(updated_size_ofst);
 END:
  b_IncrementAddrReg(sweep_ptr); /* address */
  $RELEASE(D_WorkOldAreaElm);
}

/******************************************************************** PSL **
   3.3 $B#N%o!<%I%3%T!<(B
     s_GCNWordMark_Sub
     s_GCNWordNoMark_Sub
     s_GCNWordMarkWithMRBor_Sub

       written by imai@icot22      on Sat Feb 10 18:10:08 1990

<Arguments>
  A_SweepPtr		MODIFY:		($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B%9%$!<%W%]%$%s%?$NCM!"#1%o!<%I%$%s%/%j%a%s%H$5$l$k(B
  A_SweptElm		SRC:		($B%?%0!"CM6&$K0UL#$r;}$D(B)
	$B%9%$!<%W%]%$%s%?$N;X$9@h$rFI$_=P$7$?CM(B
	($B5lNN0h$X$N%]%$%s%?$K$J$C$F$$$k(B)
  A_StrCopySize		SRC:		($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B2?%o!<%I%3%T!<$9$l$PNI$$$+$NCM!J%o!<%I?t!K(B
  A_StrTopOfst		SRC:		($B%?%0It$O0UL#$r;}$?$J$$(B)
        A_SweptElm $B$,;X$9CM$KBP$7$F2C;;$9$k$H!"9=B$BN$N@hF,$N%"%I%l%9$,(B
	$BF@$i$l$k$h$&$JCM!#Nc$($P%m%s%0%Y%/%?$N>l9g(B (-1)$B!"%3!<%I$N>l9g$O(B
	$BIi$N?t$,F~$k(B
  A_UpdatedSizeOfst	DST:		($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B%3%T!<$7$?>l9g(B		A_StrCopySize $B$r85$K4]$a$?CM(B
				($B%;!<%V%(%j%"$N%*%U%;%C%H(B)
	$B%3%T!<:Q$_$N>l9g(B	_PAGE_TOP_NOT_MODIFIED $B$NCM(B	$B$rJV$9(B
  A_UpdatedPageTopPtr	DST:		($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B%3%T!<$7$?>l9g(B		$B99?7$7$?%Z!<%8%H%C%W%]%$%s%?$NCM$rJV$9(B
				($B%G%-%c%C%7%e$5$l$F$$$J$$$3$H$KCm0U(B)
	$B%3%T!<:Q$_$N>l9g(B	$B0UL#$r;}$?$J$$(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
     s_GCNWordMark_Sub            for STRGx, MOD, COD
     s_GCNWordNoMark_Sub          for STRGo, VECT1~8o, VECTo
     s_GCNWordMarkWithMRBor_Sub   for VECT1~8x, VECTx

     $B$3$3$N%5%V%k!<%A%s$G$O!"%3%T!<$9$k%o!<%I?t(B(A_StrCopySize)$B$K$h$C$F(B
       A_StrCopySize =< 128  ==> s_GCUnderPageSizeMark $B$J$I(B
       A_StrCopySize >  128  ==> s_GCOverPageSizeMark_Sub $B$J$I(B
   $B$N%^%/%m$K=hM}$r?6$jJ,$1$F$$$k!#(B
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_SweepPtr		MODIFY
#SUBARG_define A_SweptElm		SRC
#SUBARG_define A_StrCopySize		SRC
#SUBARG_define A_StrTopOfst		SRC
#SUBARG_define A_UpdatedSizeOfst	DST
#SUBARG_define A_UpdatedPageTopPtr	DST

#SUBROUTINE s_GCNWordMark_Sub
	  (A_SweepPtr,A_SweptElm,A_StrCopySize,A_StrTopOfst,
	   A_UpdatedSizeOfst,A_UpdatedPageTopPtr)
{
  $USE(D_WorkStrAllocSize);
  b_IfGreaterImm
	(A_StrCopySize, _HALF_OF_WORD_SIZE_OF_HEAP_ACQUIREMENT_UNIT_IN_GC) {
    s_GetSizeRoundUpBySizeOfHeapPage(A_StrCopySize,D_WorkStrAllocSize);
    b_SetImmValueDNTC(_PAGE_TOP_NOT_MODIFIED,A_UpdatedSizeOfst);
    $CALL(s_GCOverPageSizeMark_Sub
	  (A_SweepPtr,A_SweptElm,A_StrTopOfst,
	   A_StrCopySize,D_WorkStrAllocSize));
  } else {
    s_GetAllocSizeAndUpdatePageTopOfst
      (A_StrCopySize,D_WorkStrAllocSize,A_UpdatedSizeOfst);
    s_GCUnderPageSizeMark
      (A_SweepPtr,A_SweptElm,A_StrTopOfst,A_StrCopySize,D_WorkStrAllocSize,
       A_UpdatedSizeOfst,A_UpdatedPageTopPtr);
  }
  $RELEASE(D_WorkStrAllocSize);
  $RETURN();
}


#SUBARG_define A_SweepPtr		MODIFY
#SUBARG_define A_SweptElm		SRC
#SUBARG_define A_StrCopySize		SRC
#SUBARG_define A_StrTopOfst		SRC
#SUBARG_define A_UpdatedSizeOfst	DST
#SUBARG_define A_UpdatedPageTopPtr	DST

#SUBROUTINE s_GCNWordNoMark_Sub
	  (A_SweepPtr,A_SweptElm,A_StrCopySize,A_StrTopOfst,
	   A_UpdatedSizeOfst,A_UpdatedPageTopPtr)
{
  $USE(D_WorkStrAllocSize);
  b_IfGreaterImm
	(A_StrCopySize, _HALF_OF_WORD_SIZE_OF_HEAP_ACQUIREMENT_UNIT_IN_GC) {
    s_GetSizeRoundUpBySizeOfHeapPage(A_StrCopySize,D_WorkStrAllocSize);
    b_SetImmValueDNTC(_PAGE_TOP_NOT_MODIFIED,A_UpdatedSizeOfst);
    $CALL(s_GCOverPageSizeNoMark_Sub
	  (A_SweepPtr,A_SweptElm,A_StrTopOfst,
	   A_StrCopySize,D_WorkStrAllocSize));
  } else {
    s_GetAllocSizeAndUpdatePageTopOfst
      (A_StrCopySize,D_WorkStrAllocSize,A_UpdatedSizeOfst);
    s_GCUnderPageSizeNoMark
      (A_SweepPtr,A_SweptElm,A_StrTopOfst,A_StrCopySize,D_WorkStrAllocSize,
       A_UpdatedSizeOfst,A_UpdatedPageTopPtr);
  }
  $RELEASE(D_WorkStrAllocSize);
  $RETURN();
}


#SUBARG_define A_SweepPtr		MODIFY
#SUBARG_define A_SweptElm		SRC
#SUBARG_define A_StrCopySize		SRC
#SUBARG_define A_StrTopOfst		SRC
#SUBARG_define A_UpdatedSizeOfst	DST
#SUBARG_define A_UpdatedPageTopPtr	DST

#SUBROUTINE s_GCNWordMarkWithMRBor_Sub
	  (A_SweepPtr,A_SweptElm,A_StrCopySize,A_StrTopOfst,
	   A_UpdatedSizeOfst,A_UpdatedPageTopPtr)
{
  $USE(D_WorkStrAllocSize);
  b_IfGreaterImm
	(A_StrCopySize, _HALF_OF_WORD_SIZE_OF_HEAP_ACQUIREMENT_UNIT_IN_GC) {
    s_GetSizeRoundUpBySizeOfHeapPage(A_StrCopySize,D_WorkStrAllocSize);
    b_SetImmValueDNTC(_PAGE_TOP_NOT_MODIFIED,A_UpdatedSizeOfst);
    $CALL(s_GCOverPageSizeMarkWithMRBor_Sub
	  (A_SweepPtr,A_SweptElm,A_StrTopOfst,
	   A_StrCopySize,D_WorkStrAllocSize));
  } else {
    s_GetAllocSizeAndUpdatePageTopOfst
      (A_StrCopySize,D_WorkStrAllocSize,A_UpdatedSizeOfst);
    s_GCUnderPageSizeMarkWithMRBor
      (A_SweepPtr,A_SweptElm,A_StrTopOfst,A_StrCopySize,D_WorkStrAllocSize,
       A_UpdatedSizeOfst,A_UpdatedPageTopPtr);
  }
  $RELEASE(D_WorkStrAllocSize);
  $RETURN();
}

/******************************************************************** PSL **
   3.4 $B%Z!<%8%5%$%:L$K~$N%3%T!<(B
     s_GCUnderPageSizeMark
     s_GCUnderPageSizeNoMark
     s_GCUnderPageSizeMarkWithMRBor

       written by imai@icot22      on Sat Feb 10 18:29:51 1990
<Arguments>
  sweep_ptr		(modify):		($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B%9%$!<%W%]%$%s%?$NCM!"#1%o!<%I%$%s%/%j%a%s%H$5$l$k(B
  swept_elm		(src):		($B%?%0!"CM6&$K0UL#$r;}$D(B)
	$B%9%$!<%W%]%$%s%?$N;X$9@h$rFI$_=P$7$?CM(B
	($B5lNN0h$X$N%]%$%s%?$K$J$C$F$$$k(B)
  str_top_ofst		(src):		($B%?%0It$O0UL#$r;}$?$J$$(B)
        swept_elm $B$,;X$9CM$KBP$7$F2C;;$9$k$H!"9=B$BN$N@hF,$N%"%I%l%9$,(B
	$BF@$i$l$k$h$&$JCM!#Nc$($P%m%s%0%Y%/%?$N>l9g(B (-1)$B!"%3!<%I$N>l9g$O(B
	$BIi$N?t$,F~$k(B
  copy_size		(src):		($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B2?%o!<%I%3%T!<$9$l$PNI$$$+$NCM!J%o!<%I?t!K(B
  alloc_size		(src):          ($B%?%0It$O0UL#$r;}$?$J$$(B)
	copy_size $B$r%U%j!<%j%9%H$N%5%$%:$K@Z$j>e$2$?$b$N!#J*M}%5%$%:!#(B
  updated_size_ofst	(dst):		($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B%3%T!<$7$?>l9g(B		copy_size $B$r85$K4]$a$?CM(B
				($B%;!<%V%(%j%"$N%*%U%;%C%H(B)
	$B%3%T!<:Q$_$N>l9g(B	_PAGE_TOP_NOT_MODIFIED $B$NCM(B	$B$rJV$9(B
  updated_page_top_ptr	(dst):		($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B%3%T!<$7$?>l9g(B		$B99?7$7$?%Z!<%8%H%C%W%]%$%s%?$NCM$rJV$9(B
				($B%G%-%c%C%7%e$5$l$F$$$J$$$3$H$KCm0U(B)
	$B%3%T!<:Q$_$N>l9g(B	$B0UL#$r;}$?$J$$(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_GCUnderPageSizeMark
	(sweep_ptr,swept_elm,str_top_ofst,copy_size,alloc_size,
	 updated_size_ofst,updated_page_top_ptr)
{
  $USE(D_WorkPtrToOldArea);
  /* $B@Q6KE*$J0UL#$G!"(Bb_AddWithTag */
  b_AddWithTag(swept_elm,str_top_ofst,D_WorkPtrToOldArea);
  $USE(D_WorkOldAreaElm);
  p_Read(D_WorkPtrToOldArea,D_WorkOldAreaElm);
  s_IfNotMarked(D_WorkOldAreaElm) {
    s_CachePageTopPtr(updated_size_ofst,updated_page_top_ptr);
    s_CompareSwapGCOldAreaX
      (D_WorkPtrToOldArea,D_WorkOldAreaElm,updated_page_top_ptr);
    p_IfEQ() { /*------ Compare & Swap Success ------*/
      @PROBE{
	s_CountCopySizeMRBxGC(copy_size);
	s_CountCopyTypeGC(swept_elm,copy_size);
      };
      s_WriteElementToHeapTop(D_WorkOldAreaElm,updated_page_top_ptr);
      s_WriteHeapTopPtrWithTagWithOffset
	(swept_elm,updated_page_top_ptr,str_top_ofst,sweep_ptr);
      s_CopyStrRestGC
	(D_WorkPtrToOldArea,updated_page_top_ptr,alloc_size,copy_size);
      goto END;
    }
  }
  @PROBE{ b_IncrementReg(D_GC_ALREADY_COPIED_COUNT);};
  s_SetPageTopNotModified(updated_size_ofst);
  s_WriteNewAreaPtrWithTagWithOffset
    (swept_elm,D_WorkOldAreaElm,sweep_ptr,str_top_ofst);
 END:
  $RELEASE(D_WorkOldAreaElm);  $RELEASE(D_WorkPtrToOldArea);
  b_IncrementAddrReg(sweep_ptr);
}

#PSL_define s_GCUnderPageSizeNoMark
	(sweep_ptr,swept_elm,str_top_ofst,copy_size,alloc_size,
	 updated_size_ofst,updated_page_top_ptr)
{
  $USE(D_WorkPtrToOldArea);
  /* $B@Q6KE*$J0UL#$G!"(Bb_AddWithTag */
  b_AddWithTag(swept_elm,str_top_ofst,D_WorkPtrToOldArea);
  $USE(D_WorkOldAreaElm);
  p_Read(D_WorkPtrToOldArea,D_WorkOldAreaElm);
  @DEBUG{  s_IfMarked(D_WorkOldAreaElm) {
    VPIM_ERROR("s_GCNWordUnderPageSizeNoMark","Why MARKED??");
  }};
  @PROBE{
    s_CountCopySizeMRBoGC(copy_size);
    s_CountCopyTypeGC(swept_elm,copy_size);
  };
  s_CachePageTopPtr(updated_size_ofst,updated_page_top_ptr);
  s_WriteElementToHeapTop(D_WorkOldAreaElm,updated_page_top_ptr);
  s_WriteHeapTopPtrWithTagWithOffset
    (swept_elm,updated_page_top_ptr,str_top_ofst,sweep_ptr);
  s_CopyStrRestGC
    (D_WorkPtrToOldArea,updated_page_top_ptr,alloc_size,copy_size);
  $RELEASE(D_WorkOldAreaElm);
  $RELEASE(D_WorkPtrToOldArea);
  b_IncrementAddrReg(sweep_ptr);
}

#PSL_define s_GCUnderPageSizeMarkWithMRBor
	(sweep_ptr,swept_elm,str_top_ofst,copy_size,alloc_size,
	 updated_size_ofst,updated_page_top_ptr)
{
  $USE(D_WorkPtrToOldArea);
  /* $B@Q6KE*$J0UL#$G!"(Bb_AddWithTag */
  b_AddWithTag(swept_elm,str_top_ofst,D_WorkPtrToOldArea);
  $USE(D_WorkOldAreaElm);
  s_ReadWithMRBor(D_WorkPtrToOldArea,D_WorkOldAreaElm);
  s_IfNotMarked(D_WorkOldAreaElm) {
    s_CachePageTopPtr(updated_size_ofst,updated_page_top_ptr);
    s_CompareSwapGCOldAreaX
      (D_WorkPtrToOldArea,D_WorkOldAreaElm,updated_page_top_ptr);
    p_IfEQ() { /*------ Compare & Swap Success ------*/
      @PROBE{
	s_CountCopySizeMRBxGC(copy_size); 
	s_CountCopyTypeGC(swept_elm,copy_size);
      };
      s_WriteElementToHeapTop(D_WorkOldAreaElm,updated_page_top_ptr);
      s_WriteHeapTopPtrWithTagWithOffset
	(swept_elm,updated_page_top_ptr,str_top_ofst,sweep_ptr);
      s_CopyStrRestGCWithMRBor
	(D_WorkPtrToOldArea,updated_page_top_ptr,alloc_size,copy_size);
      goto END;
    }
  }
  @PROBE{ b_IncrementReg(D_GC_ALREADY_COPIED_COUNT);};
  s_SetPageTopNotModified(updated_size_ofst);
  s_WriteNewAreaPtrWithTagWithOffset
    (swept_elm,D_WorkOldAreaElm,sweep_ptr,str_top_ofst);
 END:
  $RELEASE(D_WorkOldAreaElm);
  $RELEASE(D_WorkPtrToOldArea);
  b_IncrementAddrReg(sweep_ptr);
}

/******************************************************************** PSL **
   3.5 $B%Z!<%8%5%$%:0J>e$N%3%T!<(B

       written by imai@icot22      on Sat Feb 10 19:29:13 1990
<Arguments>
  A_SweepPtr		MODIFY:		($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B%9%$!<%W%]%$%s%?$NCM!"#1%o!<%I%$%s%/%j%a%s%H$5$l$k(B
  A_SweptElm		SRC:		($B%?%0!"CM6&$K0UL#$r;}$D(B)
	$B%9%$!<%W%]%$%s%?$N;X$9@h$rFI$_=P$7$?CM(B
	($B5lNN0h$X$N%]%$%s%?$K$J$C$F$$$k(B)
  A_StrTopOfst		SRC:		($B%?%0It$O0UL#$r;}$?$J$$(B)
        A_SweptElm $B$,;X$9CM$KBP$7$F2C;;$9$k$H!"9=B$BN$N@hF,$N%"%I%l%9$,(B
	$BF@$i$l$k$h$&$JCM!#Nc$($P%m%s%0%Y%/%?$N>l9g(B (-1)$B!"%3!<%I$N>l9g$O(B
	$BIi$N?t$,F~$k(B
  A_StrCopySize		SRC:		($B%?%0It$O0UL#$r;}$?$J$$(B)
	$B2?%o!<%I%3%T!<$9$l$PNI$$$+$NCM!J%o!<%I?t!K(B
  A_AllocSize		SRC:            ($B%?%0It$O0UL#$r;}$?$J$$(B)
	A_CopySize $B$r%Z!<%8$N%5%$%:$K@Z$j>e$2$?$b$N!#J*M}%5%$%:!#(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_SweepPtr	MODIFY
#SUBARG_define A_SweptElm	SRC
#SUBARG_define A_StrTopOfst	SRC
#SUBARG_define A_CopySize	SRC
#SUBARG_define A_AllocSize	SRC

#SUBROUTINE s_GCOverPageSizeMark_Sub
	(A_SweepPtr,A_SweptElm,A_StrTopOfst,A_CopySize,A_AllocSize)
{
  $USE(D_WorkPtrToOldArea);
  /* $B@Q6KE*$J0UL#$G!"(Bb_AddWithTag */
  b_AddWithTag(A_SweptElm,A_StrTopOfst,D_WorkPtrToOldArea); /* address */
  $USE(D_WorkOldAreaElm);
  p_Read(D_WorkPtrToOldArea,D_WorkOldAreaElm);
  s_IfNotMarked(D_WorkOldAreaElm){
    s_CompareSwapGCBusyFlagX(D_WorkPtrToOldArea,D_WorkOldAreaElm);
    p_IfEQ() {
      $USE(D_WorkPageTopPtr);
      @PROBE{
	s_CountCopySizeMRBxGC(A_CopySize);
	s_CountCopyTypeGC(A_SweptElm,A_CopySize);
      };
      /*====== $B%=%U%H%m%C%/@.8y(B =======*/
      s_AllocMultiplePageGC(A_AllocSize,D_WorkPageTopPtr);
      /* $B%=%U%H%m%C%/2r=|(B */
      s_GCBusyFlagOff(D_WorkPtrToOldArea,D_WorkPageTopPtr);
      $USE(D_WorkPtr1);
      p_MoveValue(D_WorkPageTopPtr,D_WorkPtr1);
      s_WriteElementToHeapTop(D_WorkOldAreaElm,D_WorkPageTopPtr);
      s_WriteHeapTopPtrWithTagWithOffset
	(A_SweptElm,D_WorkPageTopPtr,A_StrTopOfst,A_SweepPtr);
      s_CopyStrRestGC
	(D_WorkPtrToOldArea,D_WorkPageTopPtr,A_AllocSize,A_CopySize);
      $RELEASE(D_WorkPageTopPtr);
      /* $B#20z?tL\$OJG?t$G$O$J$/!"%o!<%I?t(B */
      s_PushMultipleHeapAcquirementUnitGCStack(D_WorkPtr1,A_AllocSize);
       $RELEASE(D_WorkPtr1);
      goto END;
    } else {
      /*====== $B%=%U%H%m%C%/$K<:GT(B ========*/
      /* $B%=%U%H%m%C%/$,30$l$k$^$G%S%8!<%&%'%$%H(B */
      s_BusyWaitUntilFlagOff(D_WorkPtrToOldArea,D_WorkOldAreaElm);
    }
  }
  @PROBE{ b_IncrementReg(D_GC_ALREADY_COPIED_COUNT);};
  s_WriteNewAreaPtrWithTagWithOffset
    (A_SweptElm,D_WorkOldAreaElm,A_SweepPtr,A_StrTopOfst);
 END:
  b_IncrementAddrReg(A_SweepPtr);
  $RELEASE(D_WorkOldAreaElm);$RELEASE(D_WorkPtrToOldArea);
  $RETURN();
}


#SUBARG_define A_SweepPtr	MODIFY
#SUBARG_define A_SweptElm	SRC
#SUBARG_define A_StrTopOfst	SRC
#SUBARG_define A_CopySize	SRC
#SUBARG_define A_AllocSize	SRC

#SUBROUTINE s_GCOverPageSizeNoMark_Sub
	(A_SweepPtr,A_SweptElm,A_StrTopOfst,A_CopySize,A_AllocSize)
{
  $USE(D_WorkPtrToOldArea);
  /* $B@Q6KE*$J0UL#$G!"(Bb_AddWithTag */
  b_AddWithTag(A_SweptElm,A_StrTopOfst,D_WorkPtrToOldArea); /* address */
  $USE(D_WorkOldAreaElm);
  p_Read(D_WorkPtrToOldArea,D_WorkOldAreaElm);
  @PROBE{
    s_CountCopySizeMRBoGC(A_CopySize);
    s_CountCopyTypeGC(A_SweptElm,A_CopySize);
  };
  @DEBUG{ s_IfMarked(D_WorkOldAreaElm){
    VPIM_ERROR("s_GCOverPageSizeNoMark_Sub","Why MARKED??");
  }};
  $USE(D_WorkPageTopPtr);
  s_AllocMultiplePageGC(A_AllocSize,D_WorkPageTopPtr);
  s_WriteElementToHeapTop(D_WorkOldAreaElm,D_WorkPageTopPtr);
  s_WriteHeapTopPtrWithTagWithOffset
    (A_SweptElm,D_WorkPageTopPtr,A_StrTopOfst,A_SweepPtr);
  $USE(D_WorkPtr1);
  p_MoveValue(D_WorkPageTopPtr,D_WorkPtr1);
  s_CopyStrRestGC
    (D_WorkPtrToOldArea,D_WorkPageTopPtr,A_AllocSize,A_CopySize);
  /* $B#20z?tL\$OJG?t$G$O$J$/!"%o!<%I?t(B */
  $RELEASE(D_WorkPageTopPtr);
  s_PushMultipleHeapAcquirementUnitGCStack(D_WorkPtr1,A_AllocSize);
  $RELEASE(D_WorkPtr1);
  b_IncrementAddrReg(A_SweepPtr);
  $RELEASE(D_WorkOldAreaElm);$RELEASE(D_WorkPtrToOldArea);
  $RETURN();
}


#SUBARG_define A_SweepPtr	MODIFY
#SUBARG_define A_SweptElm	SRC
#SUBARG_define A_StrTopOfst	SRC
#SUBARG_define A_CopySize	SRC
#SUBARG_define A_AllocSize	SRC

#SUBROUTINE s_GCOverPageSizeMarkWithMRBor_Sub
	(A_SweepPtr,A_SweptElm,A_StrTopOfst,A_CopySize,A_AllocSize)
{
  $USE(D_WorkPtrToOldArea);
  /* $B@Q6KE*$J0UL#$G!"(Bb_AddWithTag */
  b_AddWithTag(A_SweptElm,A_StrTopOfst,D_WorkPtrToOldArea); /* address */
  $USE(D_WorkOldAreaElm);
  s_ReadWithMRBor(D_WorkPtrToOldArea,D_WorkOldAreaElm);
  s_IfNotMarked(D_WorkOldAreaElm){
    s_CompareSwapGCBusyFlagX(D_WorkPtrToOldArea,D_WorkOldAreaElm);
    p_IfEQ() {
      $USE(D_WorkPageTopPtr);
      @PROBE{
	s_CountCopySizeMRBxGC(A_CopySize);
	s_CountCopyTypeGC(A_SweptElm,A_CopySize);
      };
      /*====== $B%=%U%H%m%C%/@.8y(B =======*/
      s_AllocMultiplePageGC(A_AllocSize,D_WorkPageTopPtr);
      /* $B%=%U%H%m%C%/2r=|(B */
      s_GCBusyFlagOff(D_WorkPtrToOldArea,D_WorkPageTopPtr);
      $USE(D_WorkPtr1);
      p_MoveValue(D_WorkPageTopPtr,D_WorkPtr1);
      s_WriteElementToHeapTop(D_WorkOldAreaElm,D_WorkPageTopPtr);
      s_WriteHeapTopPtrWithTagWithOffset
	(A_SweptElm,D_WorkPageTopPtr,A_StrTopOfst,A_SweepPtr);
      s_CopyStrRestGCWithMRBor
	(D_WorkPtrToOldArea,D_WorkPageTopPtr,A_AllocSize,A_CopySize);
      $RELEASE(D_WorkPageTopPtr);
      /* $B#20z?tL\$OJG?t$G$O$J$/!"%o!<%I?t(B */
      s_PushMultipleHeapAcquirementUnitGCStack(D_WorkPtr1,A_AllocSize);
      $RELEASE(D_WorkPtr1);
      goto END;
    } else {
      /*====== $B%=%U%H%m%C%/$K<:GT(B ========*/
      /* $B%=%U%H%m%C%/$,30$l$k$^$G%S%8!<%&%'%$%H(B */
      s_BusyWaitUntilFlagOff(D_WorkPtrToOldArea,D_WorkOldAreaElm);
    }
  }
  @PROBE{ b_IncrementReg(D_GC_ALREADY_COPIED_COUNT);};
  s_WriteNewAreaPtrWithTagWithOffset
    (A_SweptElm,D_WorkOldAreaElm,A_SweepPtr,A_StrTopOfst);
 END:
  b_IncrementAddrReg(A_SweepPtr);
  $RELEASE(D_WorkOldAreaElm);$RELEASE(D_WorkPtrToOldArea);
  $RETURN();
}
