
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/structures/str_gc_basic.psl.c
   ----- CREATED   : by f-hataza@icot22, on Wed Jun 20 11:14:48 1990
   ----- LAST SAVED: by imai@icot22, on Wed Apr 29 11:54:18 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : STRUCTURES
   ----- ABSTRACT  : GC$B=hM}$N4pK\%^%/%m(B

  1. $B#G#C%Z!<%8$N6&M-%9%?%C%/$X$N%W%C%7%e%]%C%W(B
   1.1 $B#1%R!<%W3MF@%f%K%C%H$N%W%C%7%e(B
   1.2 $BJ#?t#1%R!<%W3MF@%f%K%C%H$N%W%C%7%e(B
   1.3 $BJ#?tIi2YJ,;6%f%K%C%H$N%W%C%7%e(B
   1.4 $B#G#C%Z!<%8$N%]%C%W(B
   1.5 $B6&M-%9%?%C%/$,6u$+$I$&$+$N%A%'%C%/(B
   1.6 $B6&M-%9%?%C%/%]%$%s%?$N%m%C%/!?%"%s%m%C%/(B
   1.7 $B6&M-%9%?%C%/$r9=@.$9$kMWAG$N=q$-9~$_!?FI$_$@$7(B
  2. $B#C#o#m#p#a#r#e!u#S#w#a#p$d!"%=%U%H%m%C%/$J$I$N4pK\A`:n(B
  3. $B#G#C;~$N%9%F!<%?%9(B
  4. $BE}7W>pJs<}=8$N$?$a$N%^%/%m(B
  5. $B#G#C%^!<%/$K4X$9$kA`:n(B
  6. $B#G#C4X78$N%A%'%C%/%^%/%m(B
   6.1 $B%b%8%e!<%k%H%C%W$+$I$&$+$N%A%'%C%/(B
   6.2 $B%7%9%F%`%(%j%"$+$I$&$+$N%A%'%C%/(B
   6.3 $B?75lNN0h$N%A%'%C%/(B
  7. $B%R!<%W%H%C%W$X$N=q$-9~$_(B
   7.1 $B%R!<%W%H%C%W$X$N(B1$BMWAG=q$-9~$_(B
   7.2 $B5lNN0h$+$i$N(B1$B%o!<%I%3%T!<(B
   7.3 $B5lNN0h$+$i$N9=B$BN%3%T!<(B
  8. $B5lNN0h$X$N%]%$%s%?$N=q$-9~$_(B
   8.1 $B5lNN0h$X$N%R!<%W%H%C%W%]%$%s%?$N=q$-9~$_(B
   8.2 $B5lNN0h$X$N?7NN0h$r;X$9%]%$%s%?$N=q$-9~$_(B
  9. $B%9%$!<%W%]%$%s%?!"%Z!<%8%H%C%W%]%$%s%?$K4X$9$k%^%/%m(B
   9.1 $B%9%$!<%W%]%$%s%?$N@_Dj(B
   9.2 $B%Z!<%8$N=*$j$N8!=P(B
   9.3 $BF1$8%Z!<%8$+$I$&$+$N%A%'%C%/(B
 10. $B#G#C;~$N%Z!<%8$N3d$jEv$F(B
  10.1 $B#G#C;~$N(B1$B%Z!<%8$N3d$jEv$F(B
  10.2 $B#G#C;~$NJ#?t%Z!<%8$N3d$jEv$F(B
 11. $B%]%$%s%?%;!<%V%(%j%"$NA`:n(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
  1. $B#G#C%Z!<%8$N6&M-%9%?%C%/$X$N%W%C%7%e%]%C%W(B

       written by imai@icot22      on Tue May 30 15:42:44 1989

$B!c!c!c(B  $B#G#C%Z!<%86&M-%9%?%C%/$N9=B$(B  $B!d!d!d(B
                                       ($B$3$NI=$G$O!"%"%I%l%9>e0L$,>e(B)

_GC_STACK_AREA_LIMIT    --------| $B;H$($J$$(B |
				|==========|
				|    $B6u(B    |
				|----------|
				|    $B6u(B    |
				|==========|
_GC_STACK_PTR			|    $B6u(B    |
	+-------+		|----------|
	|      ---------------->|    $B6u(B    |
	+-------+		|==========|
				|INTo! 1024|
				|----------|			+-------+
				|       ----------------------->|	|
				|==========|			|	|
				|INTo!  256|			|	|
				|----------|    +-------+	|	|
_GC_STACK_AREA_BASE     --------|         ----->|	|	|	|
				|==========|    |	|	|	|
********************************************************************* PSL **/


#ADDR_define _GC_PAGE_STACK_ENTRY_SIZE		2

#ADDR_define  _GC_PAGE_STACK_PAGE_TOP_PTR_OFST	0
#ADDR_define  _GC_PAGE_STACK_SIZE_OFST		1

#DATA_define 	D_WorkGCStackPtr 	XXX
#DATA_define	D_WorkElement		XXX

/******************************************************************** PSL **
   1.1 $B#1%R!<%W3MF@C10L$N%W%C%7%e(B
     s_PushOneHeapAcquirementUnitGCStack(ptr_to_page)

       written by imai@icot22      on Wed Aug  2 10:38:00 1989

<Arguments> 
  ptr_to_page : $B%W%C%7%e$9$Y$-%Z!<%8$N@hF,$N%"%I%l%9$r;}$D%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function> 1$B%R!<%W3MF@C10L$NNN0h$r(BGC$B%Z!<%86&M-%9%?%C%/$X%W%C%7%e$9$k!#(B
<Examples>
<Test>
<Explanation>
  $B%Z!<%8%H%C%W%]%$%s%?$N0\F0;~$K8F$P$l$k(B
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkAreaSize XXX

#PSL_define s_PushOneHeapAcquirementUnitGCStack(ptr_to_page)
{
  $USE(D_WorkGCStackPtr);
  @DEBUG{
    b_BitwiseAndImmediateWithDNTC
      (ptr_to_page, _MASK_OF_HEAP_ACQUIREMENT_UNIT_IN_GC, D_VOID);
    p_IfNE() {
      VPIM_ERROR("s_PushOneHeapAcquirementUnitGCStack",
		 "ptr_to_page doesn't point page top");
    }
  };
  s_SoftLockGCPageStackPtr(D_WorkGCStackPtr);
  $USE(D_WorkAreaSize);
  b_SetImmValueDNTC(_WORD_SIZE_OF_HEAP_ACQUIREMENT_UNIT_IN_GC,D_WorkAreaSize);
  s_WriteGCPageStackPagePtr(D_WorkGCStackPtr,ptr_to_page);
  s_WriteGCPageStackSize(D_WorkGCStackPtr,D_WorkAreaSize);
  $RELEASE(D_WorkAreaSize);
  b_AddImmediateWithDNTC
    (D_WorkGCStackPtr,_GC_PAGE_STACK_ENTRY_SIZE,D_WorkGCStackPtr);
  @DEBUG{
    b_IfGreaterEqImm(D_WorkGCStackPtr,_GC_STACK_AREA_LIMIT) {
      VPIM_ERROR("s_PushOneHeapAcquirementUnitGCStack","GCStack Overflow!!");
    }
  };
  s_SoftUnlockGCPageStackPtr(D_WorkGCStackPtr);
  @PROBE{ b_IncrementReg(D_GC_ENQUEUE_COUNT); };
  $RELEASE(D_WorkGCStackPtr);
}

/******************************************************************** PSL **
   1.2 $BJ#?t%R!<%W3MF@C10L$N%W%C%7%e(B
     s_PushMultiplePageGCStack(ptr_to_page,page_size_reg)

       written by imai@icot22      on Wed Aug  2 10:43:20 1989

<Arguments>
  ptr_to_page   : $B%W%C%7%e$9$Y$-%Z!<%8$N@hF,$N%"%I%l%9$r;}$D%l%8%9%?(B
  page_size_reg : $B%W%C%7%e$9$Y$-%Z!<%8$NBg$-$5!J%o!<%I?t!K(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function> $BJ#?t%Z!<%8$NNN0h$r(BGC$B%Z!<%86&M-%9%?%C%/$X%W%C%7%e$9$k!#(B
<Examples>
<Test>
<Explanation>
  $BBg$-$J9=B$BN$r%3%T!<$7$?D>8e$K8F$P$l$k(B
<ETC>
********************************************************************* PSL **/

#PSL_define s_PushMultipleHeapAcquirementUnitGCStack(ptr_to_page,page_size_reg)
{
  @DEBUG{
    b_BitwiseAndImmediateWithDNTC
      (ptr_to_page, _MASK_OF_HEAP_ACQUIREMENT_UNIT_IN_GC, D_VOID);
    p_IfNE() {
      VPIM_ERROR("s_PushOnePageGCStack","ptr_to_page doesn't point page top");
    }
    b_BitwiseAndImmediateWithDNTC
      (page_size_reg, _MASK_OF_HEAP_ACQUIREMENT_UNIT_SIZE, D_VOID);
    p_IfNE() {
      VPIM_ERROR("s_PushMultiplePageGCStack","page_size_reg % 256 != 0");
    }
  };
  $USE(D_WorkGCStackPtr);
  s_SoftLockGCPageStackPtr(D_WorkGCStackPtr);
  s_WriteGCPageStackPagePtr(D_WorkGCStackPtr,ptr_to_page);
  s_WriteGCPageStackSize(D_WorkGCStackPtr,page_size_reg);
  b_AddImmediateWithDNTC
    (D_WorkGCStackPtr,_GC_PAGE_STACK_ENTRY_SIZE,D_WorkGCStackPtr);
  @DEBUG{
    b_IfGreaterEqImm(D_WorkGCStackPtr,_GC_STACK_AREA_LIMIT) {
      VPIM_ERROR("s_PushPageGCStack","GCStack Overflow!!");
    }
  };
  s_SoftUnlockGCPageStackPtr(D_WorkGCStackPtr);
  @PROBE{ b_IncrementReg(D_GC_ENQUEUE_COUNT); };
  $RELEASE(D_WorkGCStackPtr);
}

/******************************************************************** PSL **
  1.3 $BJ#?tIi2YJ,;6%f%K%C%H$N%W%C%7%e(B
    s_PushMultipleLoadDistributionUnitGCStack(ptr_to_page,page_size_reg)

       written by imai@icot22      on Wed Aug 15 11:56:28 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $B%9%$!<%W%]%$%s%?0\F0;~$K8F$P$l$k(B
<ETC>
********************************************************************* PSL **/

#PSL_define
	s_PushMultipleLoadDistributionUnitGCStack(ptr_to_page,page_size_reg)
{
  @DEBUG{
    b_BitwiseAndImmediateWithDNTC
      (ptr_to_page,_MASK_OF_LOAD_DISTRIBUTION_UNIT_IN_GC,D_VOID);
    p_IfNE() {
      VPIM_ERROR("s_PushMultipleLoadDistributionUnitGCStack",
	 "ptr_to_page doesn't point top of the load distribution unit");
    }
    b_BitwiseAndImmediateWithDNTC
      (page_size_reg,_MASK_OF_LOAD_DISTRIBUTION_UNIT_SIZE,D_VOID);
    p_IfNE() {
      VPIM_ERROR("s_PushMultipleLoadDistributionUnitGCStack",
		 "page_size_reg % 64 != 0");
    }
  };
  $USE(D_WorkGCStackPtr);
  s_SoftLockGCPageStackPtr(D_WorkGCStackPtr);
  s_WriteGCPageStackPagePtr(D_WorkGCStackPtr,ptr_to_page);
  s_WriteGCPageStackSize(D_WorkGCStackPtr,page_size_reg);
  b_AddImmediateWithDNTC
    (D_WorkGCStackPtr,_GC_PAGE_STACK_ENTRY_SIZE,D_WorkGCStackPtr);
  @DEBUG{
    b_IfGreaterEqImm(D_WorkGCStackPtr,_GC_STACK_AREA_LIMIT) {
      VPIM_ERROR("s_PushPageGCStack","GCStack Overflow!!");
    }
  };
  s_SoftUnlockGCPageStackPtr(D_WorkGCStackPtr);
  @PROBE{ b_IncrementReg(D_GC_ENQUEUE_COUNT); };
  $RELEASE(D_WorkGCStackPtr);
}

/******************************************************************** PSL **
   1.4 $B#G#C%Z!<%8$N%]%C%W(B
     s_PopPageGCStack()

       written by imai@icot22      on Wed Aug  2 10:52:06 1989
<Arguments>
  ptr_to_page:	$B<h$j=P$7$?%Z!<%8$N@hF,%"%I%l%9$r;X$9%l%8%9%?(B
  ptr_to_end:	$B<h$j=P$7$?%Z!<%8$N:G8e$N%"%I%l%9$r;X$9%l%8%9%?(B
  ($B$3$N%^%/%m$r8F$V$H!"$3$l$i$N%l%8%9%?$KCM$,3JG<$5$l$FLa$C$F$/$k(B)

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  GC$B%Z!<%86&M-%9%?%C%/$+$i!"#1(B($B$^$?$OJ#?t$N(B)$BIi2YJ,;6%f%K%C%H$NNN0h$r(B
  $B%]%C%W$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_PtrToPageTop	DST
#SUBARG_define A_PtrToPageEnd	DST

#SUBROUTINE s_PopPageGCStack_Sub(A_PtrToPageTop,A_PtrToPageEnd)
{
  $USE(D_WorkGCStackPtr);
  s_SoftLockGCPageStackPtr(D_WorkGCStackPtr);
  @DEBUG{
    b_IfLessImm(D_WorkGCStackPtr,_GC_STACK_AREA_BASE) {
      VPIM_ERROR("s_PopPageGCStack","GCStack Underflow!!");
    }
  };
  b_IfEqualImm(D_WorkGCStackPtr,_GC_STACK_AREA_BASE) {
    p_MoveWord(D_NULL,A_PtrToPageTop);
    p_MoveWord(D_NULL,A_PtrToPageEnd);
  } else {
    b_SubtractImmediateWithTag
      (D_WorkGCStackPtr,_GC_PAGE_STACK_ENTRY_SIZE,D_WorkGCStackPtr);
    s_ReadGCPageStackPagePtr(D_WorkGCStackPtr,A_PtrToPageTop);
    s_ReadGCPageStackSize(D_WorkGCStackPtr,A_PtrToPageEnd);
    /* $B%5%$%:(B --> $B%"%I%l%9JQ49(B */
    b_ExchangeElmposToOffset(A_PtrToPageEnd,A_PtrToPageEnd);
    b_AddWithTag(A_PtrToPageEnd,A_PtrToPageTop,A_PtrToPageEnd); /* address */
    @PROBE{
      b_IncrementReg(D_GC_DEQUEUE_COUNT);
    };
    @DEBUG{
      b_BitwiseAndImmediateWithDNTC
	(A_PtrToPageTop,_MASK_OF_LOAD_DISTRIBUTION_UNIT_IN_GC,D_VOID);
      p_IfNE() {
	VPIM_ERROR("s_PopPageGCStack","A_PtrToPageTop % 64 != 0");
      }
      b_BitwiseAndImmediateWithDNTC
	(A_PtrToPageEnd,_MASK_OF_LOAD_DISTRIBUTION_UNIT_IN_GC,D_VOID);
      p_IfNE() {
	VPIM_ERROR("s_PopPageGCStack","A_PtrToPageEnd % 64 != 0");
      }
    };
  }
  s_SoftUnlockGCPageStackPtr(D_WorkGCStackPtr);
  $RELEASE(D_WorkGCStackPtr);
  $RETURN();
}

/******************************************************************** PSL **
   1.5 $B6&M-%9%?%C%/$,6u$+$I$&$+$N%A%'%C%/(B
     s_IfNotEmptyGCPageStack()

       written by imai@icot22      on Tue Feb 13 15:11:23 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define s_IfNotEmptyGCPageStack()
{
  $USE(D_WorkGCStackPtr);
  b_ReadSharedArea(_COMM_AREA_BASE,_GC_STACK_PTR,D_WorkGCStackPtr);
  b_IfEqualImm(D_WorkGCStackPtr,_GC_STACK_AREA_BASE) {
    b_SetFail();
  } else {
    b_SetSuccess();
  }
  $RELEASE(D_WorkGCStackPtr);
  b_IfSuccess()
}

/******************************************************************** PSL **
   1.6 $B6&M-%9%?%C%/%]%$%s%?$N%m%C%/!?%"%s%m%C%/(B
     s_SoftLockGCPageStackPtr(dst_stack_ptr)
     s_SoftUnlockGCPageStackPtr(src_stack_ptr)

       written by imai@icot22      on Tue Feb 13 14:11:29 1990
<Arguments>
    dst_stack_ptr : $BFI$_=P$7$?6&M-%9%?%C%/%]%$%s%?$r3JG<$9$k%l%8%9%?(B
    src_stack_ptr : $B=q$-La$96&M-%9%?%C%/%]%$%s%?$r3JG<$7$?%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    s_SoftLockGCPageStackPtr(dst_stack_ptr) :
        $B6&M-%9%?%C%/%]%$%s%?$r!"%=%U%H%m%C%/$7$F(Bdst_stack_ptr$B$KFI$_=P$9!#(B
    s_SoftUnlockGCPageStackPtr(src_stack_ptr) :
        src_stack_ptr$B$r6&M-%9%?%C%/%]%$%s%?$K=q$-La$7!"%=%U%H%m%C%/$r2r=|$9$k!#(B
<Examples>
<Test>
<Explanation>
    $B6&M-%9%?%C%/%]%$%s%?$,!"4{$K%=%U%H%m%C%/$5$l$F$$$k;~$K$O!"(Bbusy_wait $B$9$k!#(B
<ETC>
********************************************************************* PSL **/

#PSL_define s_SoftLockGCPageStackPtr(dst_stack_ptr)
{
  b_SoftLockSharedAreaX (_COMM_AREA_BASE,_GC_STACK_PTR,dst_stack_ptr);
}

#PSL_define s_SoftUnlockGCPageStackPtr(src_stack_ptr)
{
  b_SoftUnlockSharedAreaX (src_stack_ptr,_COMM_AREA_BASE,_GC_STACK_PTR);
}

/******************************************************************** PSL **
   1.7 $B6&M-%9%?%C%/$r9=@.$9$kMWAG$N=q$-9~$_!?FI$_$@$7(B
     s_WriteGCPageStackPagePtr(gc_stack_ptr,ptr_to_page)
     s_WriteGCPageStackSize(gc_stack_ptr,page_size_reg)
     s_ReadGCPageStackPagePtr(gc_stack_ptr,ptr_to_page)
     s_ReadGCPageStackSize(gc_stack_ptr,page_size_reg)

       written by imai@icot22      on Tue Feb 13 14:23:12 1990
<Arguments>
    gc_stack_ptr  : GC$B%Z!<%86&M-%9%?%C%/%]%$%s%?(B
    ptr_to_page   : $B%W%C%7%e!?%]%C%W$9$k%Z!<%8$X$N%]%$%s%?(B
    page_size_reg : $B%W%C%7%e!?%]%C%W$9$k%Z!<%8$N%5%$%:(B ($B%o!<%I?t(B)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  s_WriteGCPageStackPagePtr(gc_stack_ptr,ptr_to_page)
{
  @PROBE {
    /* $BC/$,%W%C%7%e$7$?$N$+$r=q$$$F$*$/(B */
    p_MoveValueToType(D_PE_Number,ptr_to_page);
  };
  p_WriteWithOffset(ptr_to_page,gc_stack_ptr,_GC_PAGE_STACK_PAGE_TOP_PTR_OFST);
}

#PSL_define  s_WriteGCPageStackSize(gc_stack_ptr,page_size_reg)
{
  @DEBUG{
    b_BitwiseAndImmediateWithDNTC
      (page_size_reg,_MASK_OF_LOAD_DISTRIBUTION_UNIT_SIZE,D_VOID);
    p_IfNE() {
      VPIM_ERROR("s_WriteGCPageStackSize","Illegal page_size_reg");
    }
  };
  p_WriteWithOffset(page_size_reg,gc_stack_ptr,_GC_PAGE_STACK_SIZE_OFST);
}

#PSL_define  s_ReadGCPageStackPagePtr(gc_stack_ptr,ptr_to_page)
{
  p_ReadWithOffset(gc_stack_ptr,_GC_PAGE_STACK_PAGE_TOP_PTR_OFST,ptr_to_page);
}

#PSL_define  s_ReadGCPageStackSize(gc_stack_ptr,page_size_reg)
{
  p_ReadWithOffset(gc_stack_ptr,_GC_PAGE_STACK_SIZE_OFST,page_size_reg);
}

/******************************************************************** PSL **
  2. $B#C#o#m#p#a#r#e!u#S#w#a#p$d!"%=%U%H%m%C%/$J$I$N4pK\A`:n(B

       written by imai@icot22      on Wed Jul 26 10:27:25 1989
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    s_CompareSwapGCOldAreaX(ptr_reg,old_reg,new_reg) :
        ptr_reg$B$N;X$95lNN0h$K!"(Bnew_reg$B$r%^!<%/$7$F=q$-9~$`!#(B
        Compare & Swap $B$K<:GT$7$?>l9g(B($B$D$^$j!"4{$K%^!<%/$5$l$F$$$?>l9g(B)$B$K$O!"(B
        old_reg $B$K$=$NFbMF$rFI$_=P$9!#(B
    s_CompareSwapGCBusyFlagX(addr,old) :
        addr$B$N;X$95lNN0h$,!"(Bold$B$KEy$7$1$l$P!"$=$3$r%=%U%H%m%C%/$9$k!#(B
        Compare & Swap $B$K<:GT$7$?>l9g$K$O!"2?$b$7$J$$!#(B
    s_BusyWaitUntilFlagOff(addr,data) :
        addr$B$N;X$9%a%b%j$r(Bdata$B$KFI$_9~$_!"%=%U%H%m%C%/$,2r=|$5$l$k$^$G(B
        busy_wait $B$9$k!#(B
    s_GCBusyFlagOff(addr,data) :
        addr$B$N;X$95lNN0h$N%=%U%H%m%C%/$r2r=|$7!"(Bdata$B$r%^!<%/$7$F=q$-9~$`!#(B
    s_SyncronizeByGCBarrier() :
	$B#G#CCf$K%/%i%9%?Fb$NA4%W%m%;%C%5$,F14|$r$H$k%]%$%s%H$G$h$V!#(B
	$B%9%j%C%H%A%'%C%/%l%8%9%?$rMxMQ$7$?%P%j%"$N@_Dj$HF14|BT$A(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_CompareSwapGCOldAreaX(ptr_reg,old_reg,new_reg)
{
  @DEBUG{
    s_IfNotOldArea(ptr_reg) {
      VPIM_ERROR("s_CompareSwapGCOldAreaX","Illegal ptr_reg");
    }
  };
  b_CompareSwapGCOldAreaX(ptr_reg,old_reg,new_reg);
}

#PSL_define s_CompareSwapGCBusyFlagX(addr,old)
{
  @DEBUG{
    s_IfNotOldArea(addr) {
      VPIM_ERROR("s_CompareSwapGCBusyFlagX","Illegal ptr_reg");
    }
  };
  b_CompareSwapGCBusyFlagX(addr,old);
}

#PSL_define s_BusyWaitUntilFlagOff(addr,data)
{
  @DEBUG{
    s_IfNotOldArea(addr) {
      VPIM_ERROR("s_BusyWaitUntilFlagOff","Illegal addr");
    }
  };
  LOOP() {
    p_Read(addr,data);
    b_IfNotSLOCK(data) { break; }
  }
}

#PSL_define s_GCBusyFlagOff(addr,data)
{
  $USE(D_WorkNewReg);
  p_MoveWord(data,D_WorkNewReg);
  s_GCMarkReg(D_WorkNewReg);
  b_ChangeDataWithLockX (addr, D_VOID, D_WorkNewReg);
  $RELEASE(D_WorkNewReg);
}

#PSL_define s_SyncronizeByGCBarrier()
{
  $USE(D_WorkOldCounter);
  b_ReadCommArea(_ONE_TO_ALL_COUNTER_OFST, D_WorkOldCounter);
  b_IfLastBarrierComm (){
    b_ClearMsgAndResetBarrier();
    b_IncrementSyncroCountX();
  } else {
    b_WaitSyncroCount (D_WorkOldCounter);
  }
  $RELEASE(D_WorkOldCounter);
}

/******************************************************************** PSL **
  3. $B#G#C;~$N%9%F!<%?%9(B
       written by imai@icot22      on Wed Jul 26 10:29:34 1989
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    s_IfAllIdleGCBitMap() : $B$9$Y$F$N#P#E$G#G#C$,(BIdle$B$K$J$C$?$+%A%'%C%/$9$k!#(B
    s_GCBitMapTurnIdleX() : $B<+#P#E$N#G#C%S%C%H%^%C%W%U%i%0$r(BIdle$B$K$9$k!#(B
    s_GCBitMapTurnActiveX() : $B<+#P#E$N#G#C%S%C%H%^%C%W%U%i%0$r(BActive$B$K$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkGCStatus XXX

#CTRL_define s_IfAllIdleGCBitMap()
{
  $USE(D_WorkGCStatus);
  b_ReadCommArea(_GC_STATUS_BITMAP,D_WorkGCStatus);
  p_Compare(D_WorkGCStatus,D_NULL);
  $RELEASE(D_WorkGCStatus);
  p_IfEQ()
}

#DATA_define D_WorkBaseAddr XXX

#PSL_define s_GCBitMapTurnIdleX()
{
  $USE(D_WorkBaseAddr);
  b_SetImmValueDNTC(_COMM_AREA_BASE,D_WorkBaseAddr);
  b_FlagOffPosRegWithOffsetX(D_WorkBaseAddr,_GC_STATUS_BITMAP,D_PE_Number);
  $RELEASE(D_WorkBaseAddr);
}

#PSL_define s_GCBitMapTurnActiveX()
{
  $USE(D_WorkBaseAddr);
  b_SetImmValueDNTC(_COMM_AREA_BASE,D_WorkBaseAddr);
  b_FlagOnPosRegWithOffsetX(D_WorkBaseAddr,_GC_STATUS_BITMAP,D_PE_Number);
  $RELEASE(D_WorkBaseAddr);
}

/******************************************************************** PSL **
  4. $BE}7W>pJs<}=8$N$?$a$N%^%/%m(B
       written by imai@icot22      on Tue Aug 29 17:14:53 1989

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function> @PROBE{} $B$NCf$@$1$G;H$o$l$k!#(B
    s_CountCopySizeMRBoGC(alloc_size) :
        $B%5%$%:(Balloc_size$B$G(BMRBoff$B$N#G#C;~%3%T!<2s?t$r%$%s%/%j%a%s%H$9$k!#(B
    s_CountCopySizeMRBxGC(alloc_size) :
        $B%5%$%:(Balloc_size$B$G(BMRBon$B$N#G#C;~%3%T!<2s?t$r%$%s%/%j%a%s%H$9$k!#(B
    s_ClearGCCounter() :
        $BE}7W>pJs<}=8MQ$N%+%&%s%?$r=i4|2=$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
 GCNWord$B7O$G8F$P$l$k$b$N$N$_$3$N%^%/%m$G%+%&%s%H(B (s_CountCopyTypeGC)

 $BCY$$$N$G!"(BC $B$GD>@\=q$$$F$$$k(B
********************************************************************* PSL **/

#PSL_define s_CountCopySizeMRBoGC(copy_size)
{
  _CountCopySizeMRBoGC(copy_size);
}

#PSL_define s_CountCopySizeMRBxGC(copy_size)
{
  _CountCopySizeMRBxGC(copy_size);
}

#PSL_define s_CountCopyTypeGC(swept_elm,copy_size)
{
  _CountCopyTypeGC(swept_elm,copy_size);
}

/*---- $BK\Mh$N%3!<%I(B ---
#PSL_define s_CountCopySizeMRBoGC(copy_size)
{
  b_IncrementReg(D_GC_MRBo_COUNT);
  b_IfGreaterImm(copy_size,_SIZE_OF_HEAP_ACQUIREMENT_UNIT_IN_GC) {
    p_Add(D_GC_COPIED_WORDS_OVER_PAGE,copy_size,D_GC_COPIED_WORDS_OVER_PAGE);
  } else {
    p_Add(D_GC_COPIED_WORDS_UNDER_PAGE,copy_size,D_GC_COPIED_WORDS_UNDER_PAGE);
  }
}

#PSL_define s_CountCopySizeMRBxGC(copy_size)
{
  b_IncrementReg(D_GC_MRBx_COUNT);
  b_IfGreaterImm(copy_size,_SIZE_OF_HEAP_ACQUIREMENT_UNIT_IN_GC) {
    p_Add(D_GC_COPIED_WORDS_OVER_PAGE,copy_size,D_GC_COPIED_WORDS_OVER_PAGE);
  } else {
    p_Add(D_GC_COPIED_WORDS_UNDER_PAGE,copy_size,D_GC_COPIED_WORDS_UNDER_PAGE);
  }
}


#PSL_define s_CountCopyTypeGC(swept_elm,copy_size)
{
  TypeSwitch(swept_elm){
  case StringGrp():
    p_Add(D_GC_StringCnt,copy_size,D_GC_StringCnt); break;
  case ShortVectorGrp():  case LongVectorGrp():
    p_Add(D_GC_VectorCnt,copy_size,D_GC_VectorCnt); break;
  case COD:  case MOD:
    p_Add(D_GC_ModuleCnt,copy_size,D_GC_ModuleCnt); break;
  case RHOOK:
    p_Add(D_GC_SuspendRecordCnt,copy_size,D_GC_SuspendRecordCnt); break;
  case BEXREF: case BEXVAL:
    p_Add(D_GC_TradeRecordCnt,copy_size,D_GC_TradeRecordCnt); break;
  case HOOK: case EHOOK:
    p_Add(D_GC_GoalRecordCnt,copy_size,D_GC_GoalRecordCnt); break;
  case SHREC: case FPREC:
    p_Add(D_GC_MetaCtrlRecordCnt,copy_size,D_GC_MetaCtrlRecordCnt); break;
  case MGHOK:
    p_Add(D_GC_MergerRecordCnt,copy_size,D_GC_MergerRecordCnt); break;
  default:
    @DEBUG{VPIM_ERROR("s_CountCopyTypeGC","Illegal Type");};
  }
}
----*/
#PSL_define s_ClearGCCounter()
{
  p_MoveWord(D_NULL,D_GC_MRBo_COUNT);
  p_MoveWord(D_NULL,D_GC_MRBx_COUNT);
  p_MoveWord(D_NULL,D_GC_ALREADY_COPIED_COUNT);
  p_MoveWord(D_NULL,D_GC_ALLOC_PAGE_COUNT);
  p_MoveWord(D_NULL,D_GC_ENQUEUE_COUNT);
  p_MoveWord(D_NULL,D_GC_DEQUEUE_COUNT);
  p_MoveWord(D_NULL,D_GC_SWEEP_PTR_MOVE);
  p_MoveWord(D_NULL,D_GC_COPIED_WORDS_UNDER_PAGE);
  p_MoveWord(D_NULL,D_GC_COPIED_WORDS_OVER_PAGE);
  p_MoveWord(D_NULL,D_GC_VariableCnt);
  p_MoveWord(D_NULL,D_GC_ListCnt);
  p_MoveWord(D_NULL,D_GC_StringCnt);
  p_MoveWord(D_NULL,D_GC_VectorCnt);
  p_MoveWord(D_NULL,D_GC_GoalRecordCnt);
  p_MoveWord(D_NULL,D_GC_TradeRecordCnt);
  p_MoveWord(D_NULL,D_GC_SuspendRecordCnt);
  p_MoveWord(D_NULL,D_GC_ModuleCnt);
  p_MoveWord(D_NULL,D_GC_MetaCtrlRecordCnt);
  p_MoveWord(D_NULL,D_GC_MergerRecordCnt);
}

/******************************************************************** PSL **
  5. $B#G#C%^!<%/$K4X$9$kA`:n(B

       written by imai@icot22      on Thu Sep 28 21:41:31 1989

<Arguments> reg : $B%A%'%C%/$9$Y$-%l%8%9%?(B
<Temporally Used Variables>
  $B$J$7(B
<Level>
<PreCondition>
  $B$J$7(B
<Function>
    s_IfMarked(reg)    : $B%l%8%9%?(Breg $B$,#G#C%^!<%/:Q$_$G$"$k$+!#(B
    s_IfNotMarked(reg) : $B%l%8%9%?(Breg $B$,#G#C%^!<%/:Q$_$G$J$$$+!#(B
    s_GCMarkReg(reg)   : $B%l%8%9%?(Breg $B$r%^!<%/$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/


#CTRL_define s_IfMarked(reg) {
  b_IfMARKED(reg)
}

#CTRL_define s_IfNotMarked(reg) {
  b_IfNotMARKED(reg)
}

#PSL_define s_GCMarkReg(reg)
{
  b_SetImmTypeMRBoff(MARKED,reg);
}

/******************************************************************** PSL **
  6. $B#G#C4X78$N%A%'%C%/%^%/%m(B
********************************************************************* PSL **/

/******************************************************************** PSL **
   6.1 $B%7%9%F%`%(%j%"$+$I$&$+$N%A%'%C%/(B
     s_IfSystemArea(addr)

       written by imai@icot22      on Wed May 17 13:48:30 1989
<Arguments>
  addr : $B%a%$%s%a%b%j$N%"%I%l%9$,(BValue$BIt$K3JG<$5$l$?%l%8%9%?(B
	($B%?%0It$O2?$G$"$C$F$b9=$$$^$;$s(B)
<Temporally Used Variables>
  $B$J$$(B
<Level>
<PreCondition>
<Function>
  addr$B%l%8%9%?$N(Bvalue$BIt$,(B_HEAP_AREA_BASEe$B$h$j>.$5$$$+$I$&$+$NHf3S$r9T$&!#(B
<Examples>
<Test>
<Explanation>
  $B0l3g#G#C;~$K!"%7%9%F%`8GDj%(%j%"$N$b$N$O%3%T!<$7$J$$!#(B
  $B$3$l$K$O!"%7%9%F%`$,;H$&#D!]#C#o#d#e$d!"%@%_!<N$?F%l%3!<%I$J$I$,(B
  $B4^$^$l$k!#(B
<ETC>
********************************************************************* PSL **/

#CTRL_define s_IfSystemArea(addr) {
  b_IfRangeUnderImm(addr,_HEAP_AREA_BASE)
}

#CTRL_define s_IfNotSystemArea(addr) {
  b_IfRangeOverImm(addr,_HEAP_AREA_BASE)
}

/******************************************************************** PSL **
   6.2 $B?75lNN0h$N%A%'%C%/(B
     s_IfNewArea(ptr_reg)
     s_IfNotNewArea(ptr_reg)
     s_IfOldArea(ptr_reg)
     s_IfNotOldArea(ptr_reg)

       written by imai@icot22      on Tue Feb 13 21:03:04 1990
<Arguments>
  ptr_reg : $B%?%0It$OL50UL#(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  ptr_reg $B$,!"?7NN0h$r;X$7$F$$$k$+!"5lNN0h$r;X$7$F$$$k$+$rH=Dj$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
  D_CurrentHeapEndPtr $B$O?7NN0h$N:G8e$r;X$7$F$$$k!#(B
  (_SIZE_OF_MEMORY - 1) or (_HEAP_HALF_ADDR -1) $B$NCM$r$H$k!#(B
  
********************************************************************* PSL **/

#CTRL_define s_IfNewArea(ptr_reg)
{
  @DEBUG{
    b_IfLessImm(ptr_reg,_HEAP_AREA_BASE) {
      WARNING("s_IfNewArea","ptr_reg underflow");
    }
    b_IfGreaterEq(ptr_reg,D_SizeOfMemory) {
      WARNING("s_IfNewArea","ptr_reg overflow");
    }
  };
  b_IfGreater(D_CurrentHeapEndPtr,D_HeapHalfAddr) {
    b_IfGreaterEq(ptr_reg,D_HeapHalfAddr) {
      b_SetSuccess();
    } else {
      b_SetFail();
    }
  } else {
    b_IfLess(ptr_reg,D_HeapHalfAddr) {
      b_SetSuccess();
    } else {
      b_SetFail();
    }
  }
  b_IfSuccess()
}

#CTRL_define s_IfNotNewArea(ptr_reg)
{
  @DEBUG{
    b_IfLessImm(ptr_reg,_HEAP_AREA_BASE) {
      WARNING("s_IfNotNewArea","ptr_reg underflow"); /* for msg suspend */
    }
    b_IfGreaterEq(ptr_reg,D_SizeOfMemory) {
      WARNING("s_IfNotNewArea","ptr_reg overflow"); /* for msg suspend */
    }
  };
  b_IfGreater(D_CurrentHeapEndPtr,D_HeapHalfAddr) {
    b_IfGreaterEq(ptr_reg,D_HeapHalfAddr) {
      b_SetSuccess();
    } else {
      b_SetFail();
    }
  } else {
    b_IfLess(ptr_reg,D_HeapHalfAddr) {
      b_SetSuccess();
    } else {
      b_SetFail();
    }
  }
  b_IfFail()
}

#CTRL_define s_IfOldArea(ptr_reg)
{
  s_IfNotNewArea(ptr_reg)
}

#CTRL_define s_IfNotOldArea(ptr_reg)
{
  s_IfNewArea(ptr_reg)
}

/******************************************************************** PSL **
  7. $B%R!<%W%H%C%W$X$N=q$-9~$_(B
   7.1 $B%R!<%W%H%C%W$X$N(B1$BMWAG=q$-9~$_(B
     s_WriteElementToHeapTop

       written by imai@icot22      on Wed May 17 13:45:56 1989
<Arguments>
 elm:	        $B%R!<%W%H%C%W$K=q$-$?$$CM$NF~$C$?%l%8%9%?(B
 heap_top_ptr:	$B%R!<%W%H%C%W%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%R!<%W%H%C%W$K#1MWAG$r=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
  $BL$;HMQNN0h$J$N$G!"$3$N=q$-9~$_$K$O#D#i#r#e#c#t!!#W#r#i#t#e$,;H$($k!#(B
<ETC>
********************************************************************* PSL **/

#PSL_define s_WriteElementToHeapTop(elm,heap_top_ptr)
{
  @DEBUG{
    s_IfMarked(elm) {
      VPIM_ERROR("s_WriteElementToHeapTop","elm type MARKED is illegal");
    }
    s_IfNotNewArea(heap_top_ptr) {
      VPIM_ERROR("s_WriteElementToHeapTop","Illegal heap_top_ptr");
    }
    TypeSwitch(elm) {
    case REF:
    case StructureGroup():
      s_IfNotVECT0(elm) {
	s_IfNotOldArea(elm) {
	  WARNING("s_WriteElementToHeapTop","Illegal Element??");
	}
      }
      break;
    case COD:
    case MOD:
      s_IfNotSystemArea(elm){
	s_IfNotOldArea(elm) {
	  WARNING("s_WriteElementToHeapTop","Illegal Element??(MOD, COD)"); 
	}
      }
    default:
      break;
    }
  };
  p_WriteDirectly(elm,heap_top_ptr);
}

/******************************************************************** PSL **
   7.2 $B5lNN0h$+$i$N(B1$B%o!<%I%3%T!<(B

       written by imai@icot22      on Wed May 17 13:45:56 1989
<Arguments>
    old_area_ptr : $B%3%T!<85$N5lNN0h$X$N%]%$%s%?(B
    new_area_ptr : $B%3%T!<@h$N?7NN0h$X$N%]%$%s%?(B($B%R!<%W%H%C%W(B)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    s_CopyOneWordFromOldToNew(old_area_ptr,new_area_ptr) :
        old_area_ptr $B$+$i(B1$B%o!<%I$rFI$_9~$_!"(Bnew_area_ptr $B$N@h$X=q$-9~$`!#(B
    s_CopyOneWordFromOldToNewWithMRBor(old_area_ptr,new_area_ptr) :
        old_area_ptr $B$+$i(B1$B%o!<%I$r(BMRBor$B$7$FFI$_9~$_!"(Bnew_area_ptr $B$N@h$X(B
        $B=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_CopyOneWordFromOldToNew(old_area_ptr,new_area_ptr)
{
  @DEBUG{
    s_IfNotOldArea(old_area_ptr) {
      VPIM_ERROR("s_CopyOneWordFromOldToNew","Illegal old_area_ptr");
    }
    s_IfNotNewArea(new_area_ptr) {
      VPIM_ERROR("s_CopyOneWordFromOldToNew","Illegal new_area_ptr");
    }
  };
  $USE(D_WorkElement);
  p_Read(old_area_ptr,D_WorkElement);
  s_WriteElementToHeapTop(D_WorkElement,new_area_ptr);
  $RELEASE(D_WorkElement);
}

#PSL_define s_CopyOneWordFromOldToNewWithMRBor(old_area_ptr,new_area_ptr)
{
  @DEBUG{
    s_IfNotOldArea(old_area_ptr) {
      VPIM_ERROR("s_CopyOneWordFromOldToNewWithMRBor","Illegal old_area_ptr");
    }
    s_IfNotNewArea(new_area_ptr) {
      VPIM_ERROR("s_CopyOneWordFromOldToNewWithMRBor","Illegal new_area_ptr");
    }
    s_IfMRBoff(old_area_ptr) {
      VPIM_ERROR("s_CopyOneWordFromOldToNewWithMRBor","Why MRB off??");
    }
  };
  $USE(D_WorkElement);
  s_ReadWithMRBor(old_area_ptr,D_WorkElement);
  s_WriteElementToHeapTop(D_WorkElement,new_area_ptr);
  $RELEASE(D_WorkElement);
}

/******************************************************************** PSL **
   7.3 $B5lNN0h$+$i$N9=B$BN%3%T!<(B

       written by imai@icot22      on Wed May 17 13:45:56 1989
<Arguments>
    old_area_ptr : $B%3%T!<85$N5lNN0h$X$N%]%$%s%?(B
    new_area_ptr : $B%3%T!<@h$N?7NN0h$X$N%]%$%s%?(B($B%R!<%W%H%C%W(B)
    alloc_size   : $B9=B$BN$NJ*M}%5%$%:(B ($B3d$jIU$1$F$$$k%U%j!<%j%9%H$NBg$-$5(B)
    copy_size    : $B9=B$BN$N%3%T!<$9$k$Y$-Bg$-$5(B
<Temporally Used Variables>
    D_WorkRestSize : alloc_size $B$H(B copy_size $B$N:9!#(B0$B$G$J$1$l$P!"(Bcopy_size$BJ,$N(B
        $B%3%T!<$,=*$C$?8e$G!"$3$NJ,$K(BCDESC$B%?%$%W$N%G%#%9%/%j%W%?$r$D$1$k!#(B
<Level>
<PreCondition>
<Function>
    s_CopyStrRestGC(old_area_ptr,new_area_ptr,alloc_size,copy_size) :
        old_area_ptr $B$+$i9=B$BN$rFI$_9~$_!"(Bnew_area_ptr $B$N@h$X=q$-9~$`!#(B
    s_CopyStrRestGCWithMRBor
	           (old_area_ptr,new_area_ptr,alloc_size,copy_size) :
        old_area_ptr $B$+$i9=B$BN$r(BMRBor$B$7$FFI$_9~$_!"(Bnew_area_ptr $B$N@h$X(B
        $B=q$-9~$`!#(B
    s_WriteCDESCOnStructEnd(pagetop_ptr,rest_size) :
        $B%3%T!<;~$N!"(B alloc_size $B$H(B copy_size $B$N:9$,(B 0$B$G$J$1$l$P!"(B
        $B$=$NJ,$K(BCDESC$B%?%$%W$N%G%#%9%/%j%W%?$r$D$1$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#DATA_define D_WorkRestSize XXX

#PSL_define s_CopyStrRestGC(old_area_ptr,new_area_ptr,alloc_size,copy_size)
{
  @DEBUG{
    s_IfNotOldArea(old_area_ptr) {
      VPIM_ERROR("s_CopyStrRestGC","Illegal old_area_ptr");
    }
    s_IfNotNewArea(new_area_ptr) {
      VPIM_ERROR("s_CopyStrRestGC","Illegal new_area_ptr");
    }
    b_IfLess(alloc_size,copy_size) {
      VPIM_ERROR("s_CopyStrRestGC","alloc_size is less than copy_size");
    }
    b_IfLessImm(alloc_size,_ZERO) {
      VPIM_ERROR("s_CopyStrRestGC","copy_size is negative");
    }
    b_IfLessImm(copy_size,_ZERO) {
      VPIM_ERROR("s_CopyStrRestGC","copy_size is negative");
    }
  };
  $USE(D_WorkRestSize); $USE(D_WorkLength);
  p_MoveWord(copy_size,D_WorkLength);
  b_SubtractWithDNTC(alloc_size,D_WorkLength,D_WorkRestSize);
  LOOP() {
    b_IncrementAddrReg(new_area_ptr);
    b_DecrementReg(D_WorkLength);
    p_IfEQ() {
      b_IfNotZero(D_WorkRestSize) {
	s_WriteCDESCOnStructEnd(new_area_ptr,D_WorkRestSize);
      }
      break;
    } else {
      b_IncrementAddrReg(old_area_ptr);
      s_CopyOneWordFromOldToNew(old_area_ptr,new_area_ptr);
    }
  }
  $RELEASE(D_WorkLength);  $RELEASE(D_WorkRestSize);
}

#PSL_define s_CopyStrRestGCWithMRBor
	(old_area_ptr,new_area_ptr,alloc_size,copy_size)
{
  @DEBUG{
    s_IfNotOldArea(old_area_ptr) {
      VPIM_ERROR("s_CopyStrRestGCWithMRBor","Illegal old_area_ptr");
    }
    s_IfNotNewArea(new_area_ptr) {
      VPIM_ERROR("s_CopyStrRestGCWithMRBor","Illegal new_area_ptr");
    }
    b_IfLess(alloc_size,copy_size) {
      VPIM_ERROR("s_CopyStrRestGCWithMRBor",
		 "alloc_size is less than copy_size");
    }
    b_IfLessImm(alloc_size,_ZERO) {
      VPIM_ERROR("s_CopyStrRestGCWithMRBor","copy_size is negative");
    }
    b_IfLessImm(copy_size,_ZERO) {
      VPIM_ERROR("s_CopyStrRestGCWithMRBor","copy_size is negative");
    }
  };
  $USE(D_WorkRestSize); $USE(D_WorkLength);
  p_MoveWord(copy_size,D_WorkLength);
  b_SubtractWithDNTC(alloc_size,D_WorkLength,D_WorkRestSize);
  LOOP() {
    b_IncrementAddrReg(new_area_ptr);
    b_DecrementReg(D_WorkLength);
    p_IfEQ() {
      b_IfNotZero(D_WorkRestSize) {
	s_WriteCDESCOnStructEnd(new_area_ptr,D_WorkRestSize);
      }
      break;
    } else {
      b_IncrementAddrReg(old_area_ptr);
      s_CopyOneWordFromOldToNewWithMRBor(old_area_ptr,new_area_ptr);
    }
  }
  $RELEASE(D_WorkLength);  $RELEASE(D_WorkRestSize);
}

#CONST_define	_MASK_OF_LOWER_24BITS	0x00ffffff
#CONST_define	_CDESK_GC_SKIP_PATTERN	0x05000000

#PSL_define s_WriteCDESCOnStructEnd(pagetop_ptr,rest_size)
{
  $USE(D_WorkAddDst);
  p_MoveWord(pagetop_ptr,D_WorkAddDst);
  $USE(D_WorkOffset);
  b_ExchangeElmposToOffset(rest_size,D_WorkOffset);
                               /* rest_size $B$r(B byte$BC10L$K$7$F$+$i(Bp_add$B$9$Y$-(B */
				/* $B$H=q$$$F$"$C$?$N$G!"$=$&$7$?!#(B */
  b_AddWithTag(pagetop_ptr,D_WorkOffset,pagetop_ptr);
  $RELEASE(D_WorkOffset);
  b_DecrementReg(rest_size);
  b_BitwiseAndImmediateWithDNTC(rest_size,_MASK_OF_LOWER_24BITS,rest_size);
  b_BitwiseOrImmediateWithDNTC(rest_size,_CDESK_GC_SKIP_PATTERN,rest_size);
  b_SetImmTypeMRBoff(CDESC,rest_size);
  s_WriteElementToHeapTop(rest_size,D_WorkAddDst);
  $RELEASE(D_WorkAddDst);
}

/******************************************************************** PSL **
  8. $B5lNN0h$X$N%]%$%s%?$N=q$-9~$_(B
   8.1 $B5lNN0h$X$N%R!<%W%H%C%W%]%$%s%?$N=q$-9~$_(B

       written by imai@icot22      on Wed May 17 13:43:05 1989
<Arguments>
  tag_reg:	$B=q$-9~$`%G!<%?$N%?%0It(B
  heap_top_ptr: ($B=q$-9~$`%G!<%?$N(BValue$BIt(B)$B%R!<%W%H%C%W%]%$%s%?(B
  ht_offset:	$B%*%U%;%C%H(B
  dst_addr_reg: $B=q$-9~$_$r9T$*$&$H$9$k%a%b%j%"%I%l%9$NF~$C$?%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    s_WriteHeapTopPtrWithTag(tag_reg,heap_top_ptr,dst_addr_reg) :
	$B%^!<%/:Q$_$G$J$$>l9g$K8F$P$l!"8=:_%9%$!<%WCf$N(Bdst_addr_reg
	$B$K!"%R!<%W%H%C%W$X$N%]%$%s%?(B(heap_top_ptr)$B$r=q$-9~$`!#$3$N(B
	$B%]%$%s%?$N%?%0$O!"(Btag_reg$B$+$i;}$C$F$/$k(B
    s_WriteHeapTopPtrWithTagWithOffset
	          (tag_reg,heap_top_ptr,ht_offset,dst_addr_reg) :
        $B=q$-9~$_@h$,!"(Bheap_top_ptr + ht_offset $B$G;XDj$5$l$k0J30$O!"F1>e!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_WriteHeapTopPtrWithTag
	(tag_reg,heap_top_ptr,dst_addr_reg)
{
  @DEBUG{
    s_IfMarked(tag_reg) {
      VPIM_ERROR("s_WriteHeapTopPtrWithTag","tag_reg is marked!!");
    }
    s_IfNotNewArea(heap_top_ptr) {
      VPIM_ERROR("s_WriteHeapTopPtrWithTag","Illegal heap_top_ptr");
    }
  };
  p_MoveTag(tag_reg, heap_top_ptr);
  p_Write(heap_top_ptr,dst_addr_reg);
}

#PSL_define s_WriteHeapTopPtrWithTagWithOffset
	(tag_reg,heap_top_ptr,ht_offset,dst_addr_reg)
{
  @DEBUG{
    s_IfMarked(tag_reg) {
      VPIM_ERROR("s_WriteHeapTopPtrWithTagWithOffset","tag_reg is marked!!");
    }
    s_IfNotNewArea(heap_top_ptr) {
      VPIM_ERROR("s_WriteHeapTopPtrWithTagWithOffset","Illegal heap_top_ptr");
    }
  };
  $USE(D_WorkAddr);
  b_SubtractWithDNTC(heap_top_ptr,ht_offset,D_WorkAddr); /*address add */
  p_MoveTag(tag_reg, D_WorkAddr);
  p_Write(D_WorkAddr,dst_addr_reg);
  $RELEASE(D_WorkAddr);
}

/******************************************************************** PSL **
   8.2 $B5lNN0h$X$N?7NN0h$r;X$9%]%$%s%?$N=q$-9~$_(B

       written by imai@icot22      on Wed May 17 13:35:53 1989
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    s_WriteNewAreaPtrWithTag(tag_reg,new_area_ptr,dst_addr_reg) :
	$B?7NN0h$K%3%T!<:Q$_$N>l9g$K8F$P$l!"(Bdst_addr_reg$B$N@h$K!"(B
	tag_reg$B$N%?%0!"(Bnew_area_ptr$B$N(BValue$B$,=q$-9~$^$l$k!#(B
    s_WriteNewAreaPtrWithTagWithOffset
                 (tag_reg,new_area_ptr,dst_addr_reg,offset_reg) :
        $B=q$-9~$_@h$,!"(Bdst_addr_reg + ht_offset $B$G;XDj$5$l$k0J30$O!"F1>e!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_WriteNewAreaPtrWithTag(tag_reg,new_area_ptr,dst_addr_reg)
{
  @DEBUG{
    s_IfMarked(tag_reg) {
      VPIM_ERROR("s_WriteNewAreaPtrWithTag","tag_reg is MARKED!!");
    }
    s_IfNotNewArea(new_area_ptr) {
      VPIM_ERROR("s_WriteNewAreaPtrWithTag","Illegal new_area_ptr");
    }
  };
  $USE(D_WorkAddr);
  p_MoveValue(new_area_ptr,D_WorkAddr);
  p_MoveTag(tag_reg,D_WorkAddr);
  p_Write(D_WorkAddr,dst_addr_reg);
  $RELEASE(D_WorkAddr);
}

#PSL_define s_WriteNewAreaPtrWithTagWithOffset
	(tag_reg,new_area_ptr,dst_addr_reg,offset_reg)
{
  @DEBUG{
    s_IfMarked(tag_reg) {
      VPIM_ERROR("s_WriteNewAreaPtrWithTagWithOffset","tag_reg is MARKED!!");
    }
    s_IfNotNewArea(new_area_ptr) {
      VPIM_ERROR("s_WriteNewAreaPtrWithTagWithOffset","Illegal new_area_ptr");
    }
  };
  $USE(D_WorkAddr);
  b_SubtractWithDNTC(new_area_ptr,offset_reg,D_WorkAddr);
  p_MoveTag(tag_reg,D_WorkAddr);
  p_Write(D_WorkAddr,dst_addr_reg);
  $RELEASE(D_WorkAddr);
}

/******************************************************************** PSL **
  9. $B%9%$!<%W%]%$%s%?!"%Z!<%8%H%C%W%]%$%s%?$K4X$9$k%^%/%m(B
   9.1 $B%9%$!<%W%]%$%s%?$N@_Dj(B

       written by imai@icot22      on Thu Sep 28 21:51:25 1989
<Arguments>
  sweep_ptr:   ($B=PNO(B) $B%9%$!<%W%]%$%s%?(B
  pagetop_ptr: ($BF~NO(B) $B%Z!<%8%H%C%W%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    s_SetNewSweepPtr(sweep_ptr, page_top_ptr) :
        page_top_ptr $B$N;X$9Ii2YJ,;6%f%K%C%H$N@hF,%"%I%l%9$r(B
	sweep_ptr $B$K@_Dj$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

/*
 * _SIZE_OF_HEAP_ACQUIREMENT_UNIT_IN_GC $B$NCM$OJQ99$G$-$J$$(B
 *		see PIM-I-P-PSL-099
 */
#CONST_define _WORD_SIZE_OF_HEAP_ACQUIREMENT_UNIT_IN_GC	_SIZE_OF_HEAP_PAGE
#ADDR_define  _SIZE_OF_HEAP_ACQUIREMENT_UNIT_IN_GC	256

#CONST_define _HALF_OF_WORD_SIZE_OF_HEAP_ACQUIREMENT_UNIT_IN_GC 128
#ADDR_define  _HEAP_ACQUIREMENT_UNIT_OFST	_SWEEP_256WORD

#CONST_define _WORD_SIZE_OF_LOAD_DISTRIBUTION_UNIT_IN_GC    32
#ADDR_define _SIZE_OF_LOAD_DISTRIBUTION_UNIT_IN_GC    32

#ADDR_define _LOAD_DISTRIBUTION_UNIT_OFST	_SWEEP_32WORD

#CONST_define _MASK_OF_LOAD_DISTRIBUTION_UNIT_IN_GC	0x0000001f
	/* PIM/p 0xff (8bytes = 1word), PIM/[ik] 0x7f (4bytes = 1word)*/
#CONST_define _MASK_OF_LOAD_DISTRIBUTION_UNIT_SIZE	0x0000001f
#CONST_define _NOT_OF_LOAD_DISTRIBUTION_UNIT_IN_GC	0xffffffe0

#CONST_define _MASK_OF_HEAP_ACQUIREMENT_UNIT_IN_GC	0x000000ff
		/* PIM/p 0x7ff, PIM/[ik] 0x3ff */
#CONST_define _MASK_OF_HEAP_ACQUIREMENT_UNIT_SIZE	0x000000ff
#CONST_define _NOT_OF_HEAP_ACQUIREMENT_UNIT_IN_GC	0xffffff00

#PSL_define s_SetNewSweepPtrAsTopOfLDU(sweep_ptr,page_top_ptr)
{
  b_BitwiseAndImmediateWithDNTC
    (page_top_ptr,_NOT_OF_LOAD_DISTRIBUTION_UNIT_IN_GC,sweep_ptr);
}

#PSL_define s_SetNewSweepPtrAsTopOfHEU(sweep_ptr,page_top_ptr)
{
  b_BitwiseAndImmediateWithDNTC
    (page_top_ptr,_NOT_OF_HEAP_ACQUIREMENT_UNIT_IN_GC,sweep_ptr);
}

/******************************************************************** PSL **
   9.2 $B%Z!<%8$N@hF,$N8!=P(B

       written by imai@icot22      on Thu Sep 28 21:51:41 1989
<Arguments>
    ptr : $B%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define s_IfLoadDistributionUnitTop(ptr) {
  b_BitwiseAndImmediateWithDNTC
    (ptr,_MASK_OF_LOAD_DISTRIBUTION_UNIT_IN_GC,D_VOID);
  p_IfEQ()
}

#CTRL_define s_IfHeapAcquirementUnitTop(ptr) {
  b_BitwiseAndImmediateWithDNTC
    (ptr,_MASK_OF_HEAP_ACQUIREMENT_UNIT_IN_GC,D_VOID);
  p_IfEQ()
}


/******************************************************************** PSL **
   9.3 $BF1$8%Z!<%8$+$I$&$+$N%A%'%C%/(B

       written by imai@icot22      on Tue Aug 29 15:30:28 1989
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    s_IfNotSameLoadDistributionUnit
    s_IfNotSameHeapAcquirementUnit

<Examples>
<Test>
<Explanation>
    s_IfNotSame.....Unit(ptr1,ptr2) $B$O!"(B
          ptr1$B$H(B ptr2$B$,!"K\Ev$KF1$8%f%K%C%H$+$I$&$+$r%A%'%C%/(B


[$BF1$8Nc(B]                /---24--\   /-- 8--\
ptr1			001.....10  01001100
ptr2			001.....10  00110000
      (EOR)		000.....00  01111100
($B2<0L(B8$B%S%C%H%^%9%/(B)     000.....00  00000000 ====> all 0 $B$K$J$k(B

[$B0c$&Nc(B]
ptr1			001.....10  01001100
ptr2			001.....01  00110000
      (EOR)		000.....11  01111100
($B2<0L(B8$B%S%C%H%^%9%/(B)     000.....11  00000000 ====> all 0 $B$K$J$i$J$$(B
<ETC>
********************************************************************* PSL **/
#DATA_define D_WorkSweepPage   XXX

#CTRL_define s_IfNotSameLoadDistributionUnit(ptr1,ptr2)
{
  $USE(D_WorkSweepPage);
  b_BitwiseEorWithDNTC(ptr1,ptr2,D_WorkSweepPage);
  b_BitwiseAndImmediateWithDNTC
    (D_WorkSweepPage,_NOT_OF_LOAD_DISTRIBUTION_UNIT_IN_GC,D_VOID);
  $RELEASE(D_WorkSweepPage);
  p_IfNE()
}


#CTRL_define s_IfNotSameHeapAcquirementUnit(page_top_ptr,sweep_ptr)
{
  $USE(D_WorkSweepPage);
  b_BitwiseEorWithDNTC(page_top_ptr,sweep_ptr,D_WorkSweepPage);
  b_BitwiseAndImmediateWithDNTC
    (D_WorkSweepPage,_NOT_OF_HEAP_ACQUIREMENT_UNIT_IN_GC,D_VOID);
  $RELEASE(D_WorkSweepPage);
  p_IfNE()
}


#CTRL_define s_IfNotSameHeapAcquirementUnitPreviousUnit(page_top_ptr,sweep_ptr)
{
  @DEBUG{
    b_BitwiseAndImmediateWithDNTC
      (page_top_ptr,_MASK_OF_HEAP_ACQUIREMENT_UNIT_IN_GC,D_VOID);
    p_IfNE() {
      VPIM_ERROR("s_IfNotSameHeapAcquirementUnitPreviousUnit",
		 "Illegal Invoke (page_top_ptr must point top of page)");
    }
  };
  $USE(D_WorkSweepPage);
  b_SubtractImmediateWithDNTC
    (page_top_ptr,_SIZE_OF_HEAP_ACQUIREMENT_UNIT_IN_GC,D_WorkSweepPage);
  p_Compare(D_WorkSweepPage,sweep_ptr);
  $RELEASE(D_WorkSweepPage);
  p_IfGT()
}

#PSL_define s_GetTopOfLoadDistributionUnit(src_ptr,dst_top_ptr)
{
  b_BitwiseAndImmediateWithDNTC
    (src_ptr,_NOT_OF_LOAD_DISTRIBUTION_UNIT_IN_GC,dst_top_ptr);
}

#PSL_define s_GetTailOfHeapAcquirementUnit(src_ptr,dst_top_ptr)
{
  /* tail $B$H$$$&$h$j$+(B $B<!$N%Z!<%8$N@hF,$@$M(B */
  b_BitwiseAndImmediateWithDNTC
    (src_ptr,_NOT_OF_HEAP_ACQUIREMENT_UNIT_IN_GC,dst_top_ptr);
  b_AddImmediateWithDNTC
    (dst_top_ptr,_SIZE_OF_HEAP_ACQUIREMENT_UNIT_IN_GC,dst_top_ptr);
}

#PSL_define s_GetTopOfHeapAcquirementUnit(src_ptr,dst_top_ptr)
{
  /* tail $B$H$$$&$h$j$+(B $B<!$N%Z!<%8$N@hF,$@$M(B */
  b_BitwiseAndImmediateWithDNTC
    (src_ptr,_NOT_OF_HEAP_ACQUIREMENT_UNIT_IN_GC,dst_top_ptr);
}

/******************************************************************** PSL **
 10. $B#G#C;~$N%Z!<%8$N3d$jEv$F(B
  10.1 $B#G#C;~$N(B1$B%Z!<%8$N3d$jEv$F(B
     s_AllocOnePageGC()

       written by imai@icot22      on Fri Aug 25 11:54:23 1989
<Arguments>
  ptr_to_page : $B3d$jEv$F$?%Z!<%8$N@hF,%"%I%l%9(B($BJV$C$F$/$k(B)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B#G#C;~$K!"%3%T!<$9$k$?$a$N%Z!<%8$r!"?7NN0h$+$i#1%Z!<%83NJ]$7!"(B
  $B$3$N%Z!<%8$N@hF,%"%I%l%9$r(Bptr_to_page$B%l%8%9%?$N(BValue$BIt$K3JG<$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
  $B3d$jEv$F$K<:GT$7$?;~$N=hM}$O!"(BSVP$B$K3d=P$9$+(B?
  (GC$B$,$G$-$J$$$[$I%a%b%j$r;H$o$l$F$7$^$C$?(B)
********************************************************************* PSL **/

#PSL_define s_AllocOnePageGC(ptr_to_page)
{
  $USE(D_WorkNewHeapTop);
  b_ReadOldAddImmGlobalHeapTopX
    (ptr_to_page, _SIZE_OF_HEAP_ACQUIREMENT_UNIT_IN_GC, D_WorkNewHeapTop);
  @MONITOR{ PrintHeapTop(ptr_to_page);};
  b_IfHeapLimitOver(D_WorkNewHeapTop) {
    @DEBUG{ VPIM_ERROR("s_AllocOnePageGC","HEAP_AREA_TOO_SMALL(Cannot_GC)"); };
  }
  $RELEASE(D_WorkNewHeapTop);
}

/******************************************************************** PSL **
  10.2 $B#G#C;~$NJ#?t%Z!<%8$N3d$jEv$F(B
     s_AllocMultiplePageGC()

       written by imai@icot22      on Fri Aug 25 11:54:23 1989
<Arguments>
  page_size   : $B3d$jEv$F$k%o!<%I?t(B(256$B$N@0?tG\(B)
  ptr_to_page : $B3d$jEv$F$?%Z!<%8$N@hF,%"%I%l%9(B($BJV$C$F$/$k(B)
<Temporally Used Variables>
  D_WorkNewHeapTop
  D_WorkAddr
<Level>
<PreCondition>
<Function>
  $B#G#C;~$K!"%3%T!<$9$k$?$a$N%Z!<%8$r!"?7NN0h$+$i#1%Z!<%83NJ]$7!"(B
  $B$3$N%Z!<%8$N@hF,%"%I%l%9$r(Bptr_to_page$B%l%8%9%?$N(BValue$BIt$K3JG<$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
  $B3d$jEv$F$K<:GT$7$?;~$N=hM}$O!"(BSVP$B$K3d=P$9$+(B?
********************************************************************* PSL **/

#PSL_define s_AllocMultiplePageGC(size,ptr_to_page)
{
  $USE(D_WorkNewHeapTop);
  @DEBUG{
    b_BitwiseAndImmediateWithDNTC
      (size,_MASK_OF_HEAP_ACQUIREMENT_UNIT_SIZE,D_VOID);
    p_IfNE(){
      VPIM_ERROR("s_AllocMultiplePageGC","size%256 is not 0");
    }
  };
  $USE(D_WorkSize);
  /* size $B$O%o!<%I?t!#$3$3$G%^%7%s$N%"%I%l%C%7%s%0$K9g$o$;$?%5%$%:$KJQ49$9$k!#(B
                                                       1991.08.20 f-doumae */
  b_ExchangeElmposToOffset(size, D_WorkSize);
  b_ReadOldAddGlobalHeapTopX(ptr_to_page, D_WorkSize, D_WorkNewHeapTop);
  $RELEASE(D_WorkSize);

  @MONITOR{ PrintHeapTop(ptr_to_page);};
  b_IfHeapLimitOver(D_WorkNewHeapTop) {
    @DEBUG{
      VPIM_ERROR("s_AllocMultiplePageGC","HEAP_AREA_TOO_SMALL(Cannot_GC)");
    };
  }
  $RELEASE(D_WorkNewHeapTop);
}

/******************************************************************** PSL **
 11. $B%]%$%s%?%;!<%V%(%j%"$NA`:n(B
       written by imai@icot22      on Tue Feb 13 16:51:30 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CONST_define _PAGE_TOP_NOT_MODIFIED	0xffffffff
#ADDR_define _PAGE_TOP_1WORD		0
#ADDR_define _PAGE_TOP_2WORD		1
#ADDR_define _PAGE_TOP_4WORD		2
#ADDR_define _PAGE_TOP_8WORD		3
#ADDR_define _PAGE_TOP_16WORD		4
#ADDR_define _PAGE_TOP_32WORD		5
#ADDR_define _PAGE_TOP_64WORD		6
#ADDR_define _PAGE_TOP_128WORD		7
#ADDR_define _PAGE_TOP_256WORD		8

#CONST_define _SWEEP_NOT_MODIFIED	0xffffffff
#ADDR_define _SWEEP_1WORD		0
#ADDR_define _SWEEP_2WORD		1
#ADDR_define _SWEEP_4WORD		2
#ADDR_define _SWEEP_8WORD		3
#ADDR_define _SWEEP_16WORD		4
#ADDR_define _SWEEP_32WORD		5
#ADDR_define _SWEEP_64WORD		6
#ADDR_define _SWEEP_128WORD		7
#ADDR_define _SWEEP_256WORD		8

#ADDR_define _FP_PTR_SAVE_AREA	10

#DATA_define D_SweepSaveAreaBase	XXX
#DATA_define D_PageTopSaveAreaBase	XXX

/*************************************************************
    $B%l%8%9%?$K$h$k%;!<%V%(%j%"%*%U%;%C%H$N;XDj(B
*************************************************************/
#PSL_define s_CacheSweepPtr(size_ofst_reg,cached_register) {
  @DEBUG{
    s_IfNotModifiedSweep(size_ofst_reg) {
      VPIM_ERROR("s_CacheSweepPtr","Illegal size_ofst_reg");
    }};
  $USE(D_WorkAddr);
  b_AddWithDNTC(D_SweepSaveAreaBase,size_ofst_reg,D_WorkAddr);
  p_Read(D_WorkAddr,cached_register);
  $RELEASE(D_WorkAddr);
}

#PSL_define s_DecacheSweepPtr(size_ofst_reg,cached_register)
{
  @DEBUG{
    s_IfNotModifiedSweep(size_ofst_reg) {
      VPIM_ERROR("s_DecacheSweepPtr","Illegal size_ofst_reg");
    }};
  $USE(D_WorkAddr);
  b_AddWithDNTC(D_SweepSaveAreaBase,size_ofst_reg,D_WorkAddr);
  p_Write(cached_register,D_WorkAddr);
  $RELEASE(D_WorkAddr);
}

#PSL_define s_CachePageTopPtr(size_ofst_reg,cached_register)
{
  @DEBUG{
    s_IfNotModifiedPageTop(size_ofst_reg) {
      VPIM_ERROR("s_CachePageTopPtr","Illegal size_ofst_reg");
    }};
  $USE(D_WorkAddr);
  b_AddWithDNTC(D_PageTopSaveAreaBase,size_ofst_reg,D_WorkAddr);
  p_Read(D_WorkAddr,cached_register);
  $RELEASE(D_WorkAddr);
}

#PSL_define s_DecachePageTopPtr(size_ofst_reg,cached_register)
{
  @DEBUG{
    s_IfNotModifiedPageTop(size_ofst_reg) {
      VPIM_ERROR("s_DecachePageTopPtr","Illegal size_ofst_reg");
    }};
  $USE(D_WorkAddr);
  b_AddWithDNTC(D_PageTopSaveAreaBase,size_ofst_reg,D_WorkAddr);
  p_Write(cached_register,D_WorkAddr);
  $RELEASE(D_WorkAddr);
}

/*************************************************************
    $BB(CM$K$h$k%;!<%V%(%j%"%*%U%;%C%H$N;XDj(B
*************************************************************/
#PSL_define s_CacheSweepPtrImmSize(imm_size_ofst,cached_register)
{
  p_ReadWithOffset(D_SweepSaveAreaBase,imm_size_ofst,cached_register);
}

#PSL_define s_DecacheSweepPtrImmSize(imm_size_ofst,cached_register)
{
  p_WriteWithOffset(cached_register,D_SweepSaveAreaBase,imm_size_ofst);
}

#PSL_define s_CachePageTopPtrImmSize(imm_size_ofst,cached_register)
{
  p_ReadWithOffset(D_PageTopSaveAreaBase,imm_size_ofst,cached_register);
}

#PSL_define s_DecachePageTopPtrImmSize(imm_size_ofst,cached_register)
{
  p_WriteWithOffset(cached_register,D_PageTopSaveAreaBase,imm_size_ofst);
}

/*************************************************************
    $B%]%$%s%?$,99?7$5$l$?$+$I$&$+$N%A%'%C%/(B
*************************************************************/
#CTRL_define s_IfModifiedPageTop(size_ofst_reg)
{
  b_IfNotEqualImm(size_ofst_reg,_PAGE_TOP_NOT_MODIFIED)
}

#CTRL_define s_IfNotModifiedPageTop(size_ofst_reg)
{
  b_IfEqualImm(size_ofst_reg,_PAGE_TOP_NOT_MODIFIED)
}

#CTRL_define s_IfModifiedSweep(size_ofst_reg)
{
  b_IfNotEqualImm(size_ofst_reg,_SWEEP_NOT_MODIFIED)
}

#CTRL_define s_IfNotModifiedSweep(size_ofst_reg)
{
  b_IfEqualImm(size_ofst_reg,_SWEEP_NOT_MODIFIED)
}

/*************************************************************
    $B%]%$%s%?$K99?7$7$J$+$C$?$H$$$&0u$r$D$1$k(B
*************************************************************/

#PSL_define s_SetSweepNotModified(updated_size_ofst) 
{
  b_SetImmValueDNTC(_SWEEP_NOT_MODIFIED,updated_size_ofst);
}

#PSL_define s_SetPageTopNotModified(updated_size_ofst) 
{
  b_SetImmValueDNTC(_PAGE_TOP_NOT_MODIFIED,updated_size_ofst);
}

/*************************************************************
    $B%3%T!<$9$k%5%$%:$+$i!"3d$jIU$1$KI,MW$J%5%$%:$H(B
    $B$=$N%Z!<%8%H%C%W$N%*%U%;%C%H$rF@$k(B
*************************************************************/

#PSL_define s_GetAllocSizeAndUpdatePageTopOfst
	(src_copy_size,dst_alloc_size,dst_updated_size_ofst)
{
  b_IfGreaterImm(src_copy_size,_SIZE_OF_FL64) {
    b_SetImmValueDNTC(_SIZE_OF_FL128,	dst_alloc_size);
    b_SetImmValueDNTC(_PAGE_TOP_128WORD,dst_updated_size_ofst);
    goto END;
  }
  b_IfGreaterImm(src_copy_size,_SIZE_OF_FL32) {
    b_SetImmValueDNTC(_SIZE_OF_FL64,	dst_alloc_size);
    b_SetImmValueDNTC(_PAGE_TOP_64WORD,	dst_updated_size_ofst);
    goto END;
  }
  b_IfGreaterImm(src_copy_size,_SIZE_OF_FL16) {
    b_SetImmValueDNTC(_SIZE_OF_FL32,	dst_alloc_size);
    b_SetImmValueDNTC(_PAGE_TOP_32WORD,	dst_updated_size_ofst);
    goto END;
  } 
  b_IfGreaterImm(src_copy_size,_SIZE_OF_FL8) {
    b_SetImmValueDNTC(_SIZE_OF_FL16,	dst_alloc_size);
    b_SetImmValueDNTC(_PAGE_TOP_16WORD, dst_updated_size_ofst);
    goto END;
  }
  b_IfGreaterImm(src_copy_size,_SIZE_OF_FL4) {
    b_SetImmValueDNTC(_SIZE_OF_FL8,	dst_alloc_size);
    b_SetImmValueDNTC(_PAGE_TOP_8WORD,	dst_updated_size_ofst);
    goto END;
  }
  b_IfGreaterImm(src_copy_size,_SIZE_OF_FL2) {
    b_SetImmValueDNTC(_SIZE_OF_FL4,	dst_alloc_size);
    b_SetImmValueDNTC(_PAGE_TOP_4WORD,	dst_updated_size_ofst);
    goto END;
  }
  b_IfGreaterImm(src_copy_size,_SIZE_OF_FL1) {
    b_SetImmValueDNTC(_SIZE_OF_FL2,	dst_alloc_size);
    b_SetImmValueDNTC(_PAGE_TOP_2WORD,	dst_updated_size_ofst);
    goto END;
  }
  b_IfGreaterImm(src_copy_size,_ZERO) {
    b_SetImmValueDNTC(_SIZE_OF_FL1,	dst_alloc_size);
    b_SetImmValueDNTC(_PAGE_TOP_1WORD,	dst_updated_size_ofst);
  } else {
    @DEBUG{VPIM_ERROR("s_GetAllocSizeAndUpdatePageTopOfst",
		      "src_copy_size is negative");};
  }
 END:;
}

/*************************************************************
    $B%3%T!<$9$k%5%$%:$+$i!"$=$N%Z!<%8%H%C%W$N%*%U%;%C%H$rF@$k(B
*************************************************************/
#PSL_define s_GetUpdatePageTopOfst
	(src_copy_size,dst_updated_size_ofst)
{
  b_IfGreaterImm(src_copy_size,_SIZE_OF_FL64) {
    b_SetImmValueDNTC(_PAGE_TOP_128WORD,dst_updated_size_ofst);
    goto END;
  }
  b_IfGreaterImm(src_copy_size,_SIZE_OF_FL32) {
    b_SetImmValueDNTC(_PAGE_TOP_64WORD,	dst_updated_size_ofst);
    goto END;
  }
  b_IfGreaterImm(src_copy_size,_SIZE_OF_FL16) {
    b_SetImmValueDNTC(_PAGE_TOP_32WORD,	dst_updated_size_ofst);
    goto END;
  } 
  b_IfGreaterImm(src_copy_size,_SIZE_OF_FL8) {
    b_SetImmValueDNTC(_PAGE_TOP_16WORD, dst_updated_size_ofst);
    goto END;
  }
  b_IfGreaterImm(src_copy_size,_SIZE_OF_FL4) {
    b_SetImmValueDNTC(_PAGE_TOP_8WORD,	dst_updated_size_ofst);
    goto END;
  }
  b_IfGreaterImm(src_copy_size,_SIZE_OF_FL2) {
    b_SetImmValueDNTC(_PAGE_TOP_4WORD,	dst_updated_size_ofst);
    goto END;
  }
  b_IfGreaterImm(src_copy_size,_SIZE_OF_FL1) {
    b_SetImmValueDNTC(_PAGE_TOP_2WORD,	dst_updated_size_ofst);
    goto END;
  }
  b_IfGreaterImm(src_copy_size,_ZERO) {
    b_SetImmValueDNTC(_PAGE_TOP_1WORD,	dst_updated_size_ofst);
  } else {
    @DEBUG{VPIM_ERROR("s_GetAllocSizeAndUpdatePageTopOfst",
		      "src_copy_size is negative");};
  }
 END:;
}
/******************************************************************** PSL **
$B%R!<%W%Z!<%8%5%$%:$,#2#5#6$H2>Dj$7$?;~$N!"(B
$B@Z$j>e$2=hM}$r9T$&%^%/%m(B

       written by imai@icot22      on Tue Aug 29 14:19:36 1989

	raw_size_reg=  2 $B$N$H$-(B nearest_size_reg = 256
	raw_size_reg=256 $B$N$H$-(B nearest_size_reg = 256
	raw_size_reg=257 $B$N$H$-(B nearest_size_reg = 512

  $B<BNc$r=P$7$?J}$,NI$/J,$+$k(B!!
********************************************************************* PSL **/

#CONST_define _UPPER_24BIT_MASK	0x000000ff
#CONST_define _LOWER_8BIT_MASK	0xffffff00

#PSL_define s_GetSizeRoundUpBySizeOfHeapPage(raw_size_reg, nearest_size_reg)
{
  $USE(D_WorkSize);
  b_AddImmediateWithDNTC(raw_size_reg,_UPPER_24BIT_MASK,D_WorkSize);
  b_BitwiseAndImmediateWithDNTC(D_WorkSize,_LOWER_8BIT_MASK,nearest_size_reg);
  $RELEASE(D_WorkSize);
}

/******************************************************************** PSL **
$B1J5WCfCG%4!<%k$N8!=P$N$?$a$N=hM}(B
       written by imai@icot22      on Fri Sep 21 17:09:20 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_IncrementChildCountInGC(fp_rec)
{
  b_AddValueWithOffsetX(fp_rec,_FP_CHILD_COUNT_IN_GC_OFFSET,D_ONE);
}
