
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/structures/str_fp_rec_ope.psl.c
   ----- CREATED   : by yamamoto@icot22, on Thu May 24 17:19:08 1990
   ----- LAST SAVED: by kawai@icot22, on Wed Apr 22 15:25:02 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : structure
   ----- ABSTRACT  : $BN$?F%l%3!<%I$N3F%9%m%C%H$X$NJ#9gA`:n(B
		     1. READ-EXECUTE-WRITE
		     2. READ-TEST
	($B=PMh$l$P!"(B#CONST_define$B$5$l$?%9%m%C%HL>$b;H$$$?$/$J$$!#(B)
	($BB($A!"(Bstr_fp_record$B$N%^%/%m$r$3$3$G;H$&$h$&$K$9$k!#(B)

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **

(0) $BDj?t$NDj5A(B

       written by kawai@icot22      on Thu May 24 15:07:47 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

/* $BN$?F$N>uBV(B */

#CONST_define _FP_RESERVED		0x01
#CONST_define _FP_STARTED		0x00
#CONST_define _FP_STOPPED		0x02
#CONST_define _FP_ABORTED		0x03
#CONST_define _FP_TERMINATE             0x04
#CONST_define _FP_ABORTED_TERMINATE     0x05
/*************************************************************************/
/* $BCm0U(B : _FP_STARTED $B$H<!$N(B _FP_RSC_EXHAUSTED_FLAG $B$N(B off $B$O(B
   s_IfRunnableFP,s_IfNotRunnableFP $B$G9bB.$KH=Dj$7$?$$$N$G(B
   _FP_STARTED 0x00 $B$G$"$k$3$H$H!"(B_FP_RSC_EXAUSTED_FLAG $B$,(B
   TransitStatus $B$NNY$K$"$k$3$H$OI,MW>r7o$K$J$C$F$$$k!#(B         */
/*************************************************************************/

#CONST_define  _FP_RSC_EXHAUSTED_FLAG               0x00000100
#CONST_define  _FP_WTC_REQ_FLAG                     0x00010000
#CONST_define  _FP_RSC_REQ_FLAG                     0x00020000
#CONST_define  _FP_CHILD_RSC_REQ_FLAG               0x01000000

#CONST_define  _FP_PROFILING_FLAG                   0x10000000

#CONST_define  _FP_TRANSIT_STATUS_MASK              0x000000ff
#CONST_define  _FP_RUNNABLE_MASK                    0x000001ff

#CONST_define  _FP_STATUS_FLAGS_MASK		    0xffffff00

/* $B%o!<%/%l%8%9%?(B */

#DATA_define D_WorkFPRecOpe XXX
#DATA_define D_WorkFPRecOpe2 XXX


/******************************************************************** PSL **

       written by yamamoto@icot22      on Thu May 24 17:19:12 1990

(1) $B%S%C%H%U%#!<%k%IA`:n(B

cf	V02:       written by kawai@icot21      on Tue Aug 29 21:12:07 1989

********************************************************************* PSL **/
/******************************************************************** PSL **

  s_PutFPTransitStatusImmediately(fp_record, imm_status)

       written by kawai@icot21      on Tue Aug 29 21:12:07 1989
<Arguments>
  fp_record : $BN$?F$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
  imm_status : $BN$?F$NA+0\>uBV(B($BB(CM(B)
<Temporally Used Variables>
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$NA+0\>uBV$r(Bimm_status($BB(CM(B)$B$G<($5$l$k>uBV$K$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  s_PutFPTransitStatusImm(fp_record, imm_status)
{
  @DEBUG{s_IfNotFPREC(fp_record){
    VPIM_ERROR("s_PutFPTransitStatusImm","Not FPREC type");}};

  s_SetFPStatusFlags(fp_record, _FP_TRANSIT_STATUS_MASK, imm_status);

}

#PSL_define  s_SetFPStatusFlags(fp_record, imm_mask, imm_flag)
{
  @DEBUG{ s_IfNotFPREC(fp_record) {
    VPIM_ERROR("s_SetFPStatusFlags","Not FPREC Type"); }};

  $USE(D_WorkFPRecOpe);
  s_GetFPStatus(fp_record, D_WorkFPRecOpe);
  b_ReplaceBitField(D_WorkFPRecOpe, imm_mask, imm_flag);
  s_PutFPStatus(fp_record, D_WorkFPRecOpe);
  $RELEASE(D_WorkFPRecOpe);
}

/******************************************************************** PSL **

  s_GetFPTransitStatus(fp_record, log_status_reg)

       written by kawai@icot21      on Wed Dec 13 20:30:34 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
  transit_status_reg : $BN$?F$NA+0\>uBV$rJV$9$?$a$N%l%8%9%?(B
<Temporally Used Variables>
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$NA+0\>uBV$r<h$j=P$9!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  s_GetFPTransitStatus(fp_record, transit_status_reg)
{
  @DEBUG{ s_IfNotFPREC(fp_record) {
    VPIM_ERROR("s_GetFPTransitStatus","Not FPREC Type"); }};

  s_GetFPStatusFlags(fp_record, _TRANSIT_STATUS_MASK, transit_status_reg);
}

#PSL_define  s_GetFPStatusFlags(fp_record, imm_flag_mask, flag_reg)
{
  @DEBUG{ s_IfNotFPREC(fp_record) {
    VPIM_ERROR("s_GetFPStatusFlags","Not FPREC Type"); }};

  s_GetFPStatus(fp_record, flag_reg);
  b_ExtractBitField(flag_reg, imm_flag_mask, flag_reg);
}


/******************************************************************** PSL **

$BN$?F>uBV%U%i%0$N=i4|2=!"%;%C%H!"%j%;%C%H!"%F%9%H(B

       written by yamamoto@icot22      on Sat Jun 23 21:22:50 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
$BN$?F>uBV%U%i%0$O0J2<$N;M<o(B

_FP_RSC_EXHAUSTED_FLAG
_FP_WTC_REQ_FLAG
_FP_RSC_REQ_FLAG
_FP_CHILD_RSC_REQ_FLAG

<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_PutFPStatusFlag(fp_record, imm_flag){
  $USE(D_WorkFPRecOpe);
  p_ReadWithOffset(fp_record,_FP_STATUS_OFFSET,D_WorkFPRecOpe);
  b_ReplaceBitField(D_WorkFPRecOpe,_FP_STATUS_FLAGS_MASK,imm_flag);
  b_WriteDNTCWithOffset(D_WorkFPRecOpe,fp_record,_FP_STATUS_OFFSET);
  $RELEASE(D_WorkFPRecOpe);
}

#PSL_define s_SetFPStatusFlag(fp_record, imm_flag){
  $USE(D_WorkFPRecOpe);
  p_ReadWithOffset(fp_record,_FP_STATUS_OFFSET,D_WorkFPRecOpe);
  b_ReplaceBitField(D_WorkFPRecOpe,imm_flag,imm_flag);
  b_WriteDNTCWithOffset(D_WorkFPRecOpe,fp_record,_FP_STATUS_OFFSET);
  $RELEASE(D_WorkFPRecOpe);
}
#PSL_define s_ResetFPStatusFlag(fp_record, imm_flag){
  $USE(D_WorkFPRecOpe);
  p_ReadWithOffset(fp_record,_FP_STATUS_OFFSET,D_WorkFPRecOpe);
  b_ReplaceBitField(D_WorkFPRecOpe,imm_flag,_ZERO);
  b_WriteDNTCWithOffset(D_WorkFPRecOpe,fp_record,_FP_STATUS_OFFSET);
  $RELEASE(D_WorkFPRecOpe);
}

#CTRL_define s_IfFPResourceExhausted(fp_record){
  $USE(D_WorkFPRecOpe);
  p_ReadWithOffset(fp_record,_FP_STATUS_OFFSET,D_WorkFPRecOpe);
  b_ExtractBitField(D_WorkFPRecOpe,_FP_RSC_EXHAUSTED_FLAG,D_WorkFPRecOpe);
  p_CompareImmediate(D_WorkFPRecOpe,_FP_RSC_EXHAUSTED_FLAG);
  $RELEASE(D_WorkFPRecOpe);
  p_IfEQ()
}
#CTRL_define s_IfNotFPResourceExhausted(fp_record){
  $USE(D_WorkFPRecOpe);
  p_ReadWithOffset(fp_record,_FP_STATUS_OFFSET,D_WorkFPRecOpe);
  b_ExtractBitField(D_WorkFPRecOpe,_FP_RSC_EXHAUSTED_FLAG,D_WorkFPRecOpe);
  p_CompareImmediate(D_WorkFPRecOpe,_FP_RSC_EXHAUSTED_FLAG);
  $RELEASE(D_WorkFPRecOpe);
  p_IfNE()
}

#CTRL_define s_IfFPWTCRequest(fp_record){
  $USE(D_WorkFPRecOpe);
  p_ReadWithOffset(fp_record,_FP_STATUS_OFFSET,D_WorkFPRecOpe);
  b_ExtractBitField(D_WorkFPRecOpe,_FP_WTC_REQ_FLAG,D_WorkFPRecOpe);
  p_CompareImmediate(D_WorkFPRecOpe,_FP_WTC_REQ_FLAG);
  $RELEASE(D_WorkFPRecOpe);
  p_IfEQ()
}
#CTRL_define s_IfNotFPWTCRequest(fp_record){
  $USE(D_WorkFPRecOpe);
  p_ReadWithOffset(fp_record,_FP_STATUS_OFFSET,D_WorkFPRecOpe);
  b_ExtractBitField(D_WorkFPRecOpe,_FP_WTC_REQ_FLAG,D_WorkFPRecOpe);
  p_CompareImmediate(D_WorkFPRecOpe,_FP_WTC_REQ_FLAG);
  $RELEASE(D_WorkFPRecOpe);
  p_IfNE()
}

#CTRL_define s_IfFPResourceRequest(fp_record){
  $USE(D_WorkFPRecOpe);
  p_ReadWithOffset(fp_record,_FP_STATUS_OFFSET,D_WorkFPRecOpe);
  b_ExtractBitField(D_WorkFPRecOpe,_FP_RSC_REQ_FLAG,D_WorkFPRecOpe);
  p_CompareImmediate(D_WorkFPRecOpe,_FP_RSC_REQ_FLAG);
  $RELEASE(D_WorkFPRecOpe);
  p_IfEQ()
}
#CTRL_define s_IfNotFPResourceRequest(fp_record){
  $USE(D_WorkFPRecOpe);
  p_ReadWithOffset(fp_record,_FP_STATUS_OFFSET,D_WorkFPRecOpe);
  b_ExtractBitField(D_WorkFPRecOpe,_FP_RSC_REQ_FLAG,D_WorkFPRecOpe);
  p_CompareImmediate(D_WorkFPRecOpe,_FP_RSC_REQ_FLAG);
  $RELEASE(D_WorkFPRecOpe);
  p_IfNE()
}

#CTRL_define s_IfFPChiledResourceRequest(fp_record){
  $USE(D_WorkFPRecOpe);
  p_ReadWithOffset(fp_record,_FP_STATUS_OFFSET,D_WorkFPRecOpe);
  b_ExtractBitField(D_WorkFPRecOpe,_FP_CHILD_RSC_REQ_FLAG,D_WorkFPRecOpe);
  p_CompareImmediate(D_WorkFPRecOpe,_FP_CHILD_RSC_REQ_FLAG);
  $RELEASE(D_WorkFPRecOpe);
  p_IfEQ()
}
#CTRL_define s_IfNotFPChiledResourceRequest(fp_record){
  $USE(D_WorkFPRecOpe);
  p_ReadWithOffset(fp_record,_FP_STATUS_OFFSET,D_WorkFPRecOpe);
  b_ExtractBitField(D_WorkFPRecOpe,_FP_CHILD_RSC_REQ_FLAG,D_WorkFPRecOpe);
  p_CompareImmediate(D_WorkFPRecOpe,_FP_CHILD_RSC_REQ_FLAG);
  $RELEASE(D_WorkFPRecOpe);
  p_IfNE()
}

#CTRL_define s_IfProfilingFP(fp_record){
  $USE(D_WorkFPRecOpe);
  p_ReadWithOffset(fp_record,_FP_STATUS_OFFSET,D_WorkFPRecOpe);
  b_ExtractBitField(D_WorkFPRecOpe,_FP_PROFILING_FLAG,D_WorkFPRecOpe);
  p_CompareImmediate(D_WorkFPRecOpe,_FP_PROFILING_FLAG);
  $RELEASE(D_WorkFPRecOpe);
  p_IfEQ()
}
#CTRL_define s_IfNotProfilingFP(fp_record){
  $USE(D_WorkFPRecOpe);
  p_ReadWithOffset(fp_record,_FP_STATUS_OFFSET,D_WorkFPRecOpe);
  b_ExtractBitField(D_WorkFPRecOpe,_FP_PROFILING_FLAG,D_WorkFPRecOpe);
  p_CompareImmediate(D_WorkFPRecOpe,_FP_PROFILING_FLAG);
  $RELEASE(D_WorkFPRecOpe);
  p_IfNE()
}


/******************************************************************** PSL **

       written by yamamoto@icot22      on Mon Jun 18 14:40:11 1990

  (2) $BN$?F%l%3!<%I$N3F%9%m%C%H$NFbMF$rA`:n$9$k%^%/%m(B

cf	V02:       written by kawai@icot21      on Wed Dec 13 21:59:29 1989

********************************************************************* PSL **/
/******************************************************************** PSL **

  s_GetFPResourceConsumedWithUpdate(fp_record,
			 res_consume_upper_reg, res_consume_lower_reg)

       written by kawai@icot21      on Wed Dec 13 22:01:07 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
  res_consumed_reg : $BN$?F$N>CHq$7$?;q8;NL$rJV$9%l%8%9%?(B
<Temporally Used Variables>
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$N>CHq$7$?;q8;NL$r<h$j$@$7!"F1;~$K99?7$9$k!#(B
  	i.e.	return_value <- last_left - left 
		last_left <- left
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  s_GetFPResourceConsumedWithUpdate(fp_record,
			 res_consume_upper_reg, res_consume_lower_reg)
{
  @DEBUG{s_IfNotFPREC(fp_record){
    VPIM_ERROR("s_GetFPResourceConsumedWithUpdate","Not FPREC type");}};

  p_ReadWithOffset(fp_record, _FP_LAST_RESOURCE_LEFT_UPPER_OFFSET,
                                              res_consume_upper_reg);
  p_ReadWithOffset(fp_record, _FP_LAST_RESOURCE_LEFT_LOWER_OFFSET,
                                              res_consume_lower_reg);
  $USE(D_WorkFPRecOpe);
  $USE(D_WorkFPRecOpe2);
  p_ReadWithOffset(fp_record, _FP_RESOURCE_LEFT_UPPER_OFFSET,
		                               D_WorkFPRecOpe);
  p_ReadWithOffset(fp_record, _FP_RESOURCE_LEFT_LOWER_OFFSET,
		                               D_WorkFPRecOpe2);
  b_SubtractDoubleWord(res_consume_upper_reg,res_consume_lower_reg,
		D_WorkFPRecOpe,D_WorkFPRecOpe2,
		res_consume_upper_reg,res_consume_lower_reg);

  b_WriteDNTCWithOffset(D_WorkFPRecOpe, fp_record, 
				_FP_LAST_RESOURCE_LEFT_UPPER_OFFSET);
  b_WriteDNTCWithOffset(D_WorkFPRecOpe2, fp_record, 
				_FP_LAST_RESOURCE_LEFT_LOWER_OFFSET);
  /*  $B>CHq;q8;NL$rJV$7$?8e$O!"(B
      last_resource_left = resource_left
      $B$H$7$F$7$^$&!#(B
  */

  $RELEASE(D_WorkFPRecOpe);
  $RELEASE(D_WorkFPRecOpe2);
}

/******************************************************************** PSL **

       written by yamamoto@icot22      on Sun Jun 24 16:09:40 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_SubtractFPResourceLeft(fp_record,
				rsc_upper_reg, rsc_lower_reg)
{
  $USE(D_WorkFPRecOpe);
  $USE(D_WorkFPRecOpe2);
  p_ReadWithOffset(fp_record, _FP_RESOURCE_LEFT_LOWER_OFFSET,
                      D_WorkFPRecOpe2);
  p_ReadWithOffset(fp_record, _FP_RESOURCE_LEFT_UPPER_OFFSET,
                      D_WorkFPRecOpe);

  b_SubtractDoubleWord(D_WorkFPRecOpe, D_WorkFPRecOpe2,
			rsc_upper_reg, rsc_lower_reg,
			D_WorkFPRecOpe, D_WorkFPRecOpe2);

  b_WriteDNTCWithOffset(D_WorkFPRecOpe2, fp_record,
                                           _FP_RESOURCE_LEFT_LOWER_OFFSET);
  b_WriteDNTCWithOffset(D_WorkFPRecOpe, fp_record,
                                           _FP_RESOURCE_LEFT_UPPER_OFFSET);
  $RELEASE(D_WorkFPRecOpe);
  $RELEASE(D_WorkFPRecOpe2);
}
#PSL_define s_AddFPResourceLeft(fp_record,
				rsc_upper_reg, rsc_lower_reg)
{
  $USE(D_WorkFPRecOpe);
  $USE(D_WorkFPRecOpe2);
  p_ReadWithOffset(fp_record, _FP_RESOURCE_LEFT_LOWER_OFFSET,
                      D_WorkFPRecOpe2);
  p_ReadWithOffset(fp_record, _FP_RESOURCE_LEFT_UPPER_OFFSET,
                      D_WorkFPRecOpe);

  b_AddDoubleWord(D_WorkFPRecOpe, D_WorkFPRecOpe2,
			rsc_upper_reg, rsc_lower_reg,
			D_WorkFPRecOpe, D_WorkFPRecOpe2);

  b_WriteDNTCWithOffset(D_WorkFPRecOpe2, fp_record,
                                           _FP_RESOURCE_LEFT_LOWER_OFFSET);
  b_WriteDNTCWithOffset(D_WorkFPRecOpe, fp_record,
                                           _FP_RESOURCE_LEFT_UPPER_OFFSET);
  $RELEASE(D_WorkFPRecOpe);
  $RELEASE(D_WorkFPRecOpe2);
}
#PSL_define s_SubtractFPLastResourceLeft(fp_record,
				rsc_upper_reg, rsc_lower_reg)
{
  $USE(D_WorkFPRecOpe);
  $USE(D_WorkFPRecOpe2);
  p_ReadWithOffset(fp_record, _FP_LAST_RESOURCE_LEFT_LOWER_OFFSET,
                      D_WorkFPRecOpe2);
  p_ReadWithOffset(fp_record, _FP_LAST_RESOURCE_LEFT_UPPER_OFFSET,
                      D_WorkFPRecOpe);

  b_SubtractDoubleWord(D_WorkFPRecOpe, D_WorkFPRecOpe2,
			rsc_upper_reg, rsc_lower_reg,
			D_WorkFPRecOpe, D_WorkFPRecOpe2);

  b_WriteDNTCWithOffset(D_WorkFPRecOpe2, fp_record,
                                       _FP_LAST_RESOURCE_LEFT_LOWER_OFFSET);
  b_WriteDNTCWithOffset(D_WorkFPRecOpe, fp_record,
                                       _FP_LAST_RESOURCE_LEFT_UPPER_OFFSET);
  $RELEASE(D_WorkFPRecOpe);
  $RELEASE(D_WorkFPRecOpe2);
}
#PSL_define s_AddFPLastResourceLeft(fp_record,
				rsc_upper_reg, rsc_lower_reg)
{
  $USE(D_WorkFPRecOpe);
  $USE(D_WorkFPRecOpe2);
  p_ReadWithOffset(fp_record, _FP_LAST_RESOURCE_LEFT_LOWER_OFFSET,
                      D_WorkFPRecOpe2);
  p_ReadWithOffset(fp_record, _FP_LAST_RESOURCE_LEFT_UPPER_OFFSET,
                      D_WorkFPRecOpe);

  b_AddDoubleWord(D_WorkFPRecOpe, D_WorkFPRecOpe2,
			rsc_upper_reg, rsc_lower_reg,
			D_WorkFPRecOpe, D_WorkFPRecOpe2);

  b_WriteDNTCWithOffset(D_WorkFPRecOpe2, fp_record,
                                       _FP_LAST_RESOURCE_LEFT_LOWER_OFFSET);
  b_WriteDNTCWithOffset(D_WorkFPRecOpe, fp_record,
                                       _FP_LAST_RESOURCE_LEFT_UPPER_OFFSET);
  $RELEASE(D_WorkFPRecOpe);
  $RELEASE(D_WorkFPRecOpe2);
}

#PSL_define s_AddFPAnswerResource(fp_record,
				rsc_upper_reg, rsc_lower_reg)
{
  $USE(D_WorkFPRecOpe);
  $USE(D_WorkFPRecOpe2);
  p_ReadWithOffset(fp_record, _FP_ANSWER_RESOURCE_LOWER_OFFSET,
                      D_WorkFPRecOpe2);
  p_ReadWithOffset(fp_record, _FP_ANSWER_RESOURCE_UPPER_OFFSET,
                      D_WorkFPRecOpe);

  b_AddDoubleWord(D_WorkFPRecOpe, D_WorkFPRecOpe2,
			rsc_upper_reg, rsc_lower_reg,
			D_WorkFPRecOpe, D_WorkFPRecOpe2);

  b_WriteDNTCWithOffset(D_WorkFPRecOpe2, fp_record,
                                       _FP_ANSWER_RESOURCE_LOWER_OFFSET);
  b_WriteDNTCWithOffset(D_WorkFPRecOpe, fp_record,
                                       _FP_ANSWER_RESOURCE_UPPER_OFFSET);
  $RELEASE(D_WorkFPRecOpe);
  $RELEASE(D_WorkFPRecOpe2);
}


#CONST_define  _RESULT_SUCCESS  0
#CONST_define  _RESULT_FAIL     1

#PSL_define s_DrawResourceFromFP(fp_record, rsc_upper_reg, rsc_lower_reg,
				                                 result_reg)
{
  $USE(D_WorkFPRecOpe);
  $USE(D_WorkFPRecOpe2);
  s_GetFPResourceLeft(fp_record, D_WorkFPRecOpe, D_WorkFPRecOpe2);

  b_SubtractDoubleWord(D_WorkFPRecOpe, D_WorkFPRecOpe2,
			rsc_upper_reg, rsc_lower_reg,
			D_WorkFPRecOpe, D_WorkFPRecOpe2);

  b_IfGreaterEq(D_WorkFPRecOpe, D_NULL){
    /* left - reqeust >= 0 */
    b_IfNotZeroDoubleWord(D_WorkFPRecOpe, D_WorkFPRecOpe2){
      /* left - reqeust > 0 */
      /* Enough resouce Left case */
      s_PutFPResourceLeft(fp_record, D_WorkFPRecOpe, D_WorkFPRecOpe2);

      s_GetFPLastResourceLeft(fp_record, D_WorkFPRecOpe, D_WorkFPRecOpe2);
      /* FPLastResourceLeft >= FPResourceLeft */
      b_SubtractDoubleWord(D_WorkFPRecOpe, D_WorkFPRecOpe2,
			   rsc_upper_reg, rsc_lower_reg,
			   D_WorkFPRecOpe, D_WorkFPRecOpe2);
      s_PutFPLastResourceLeft(fp_record, D_WorkFPRecOpe, D_WorkFPRecOpe2);
      b_SetImmValueDNTC(_RESULT_SUCCESS, result_reg);

    }else{
      /* left - request == 0 */
      /* Not enough resouce Left case */
      b_SetImmValueDNTC(_RESULT_FAIL, result_reg);
      /* _RESULT_FAIL $B$J$i$P!">e$NJ}$G(B request_resource $B$,$G$k!#(B*/
    }
  } else { 
    /* left - reqeust < 0 */
    /* Not enough resouce Left case */
    b_SetImmValueDNTC(_RESULT_FAIL, result_reg);
    /* _RESULT_FAIL $B$J$i$P!">e$NJ}$G(B request_resource $B$,$G$k!#(B*/
  }

  $RELEASE(D_WorkFPRecOpe);
  $RELEASE(D_WorkFPRecOpe2);
}



#PSL_define s_ThrowAwayResourceFromFP(fp_record, rsc_upper_reg, rsc_lower_reg,
				                                 result_reg)
{
  $USE(D_WorkFPRecOpe);
  $USE(D_WorkFPRecOpe2);
  s_GetFPResourceLeft(fp_record, D_WorkFPRecOpe, D_WorkFPRecOpe2);

  b_SubtractDoubleWord(D_WorkFPRecOpe, D_WorkFPRecOpe2,
			rsc_upper_reg, rsc_lower_reg,
			D_WorkFPRecOpe, D_WorkFPRecOpe2);

  b_IfGreaterEq(D_WorkFPRecOpe, D_NULL)
    { /* Enough resouce Left case */
      s_PutFPResourceLeft(fp_record, D_WorkFPRecOpe, D_WorkFPRecOpe2);
      b_SetImmValueDNTC(_RESULT_SUCCESS, result_reg);
    }
  else
    { /* Not enough resouce Left case */
      b_SetImmValueDNTC(_RESULT_FAIL, result_reg);
    }

  $RELEASE(D_WorkFPRecOpe);
  $RELEASE(D_WorkFPRecOpe2);
}



/******************************************************************** PSL **

  s_IncrementFPChildCount(fp_record)

       written by kawai@icot21      Tue Dec  6 22:38:25 1988
       revised by kawai@icot21      on Fri Mar 24 17:39:19 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$N(BChildCount$B$r%$%s%/%j%a%s%H$9$k!#(B
  ($B%O!<%I%&%'%"%m%C%/IU$-$@$C$?$1$I$d$a$?(B)
<Examples>
<Test>
<Explanation>
<ETC>
<Revised Memo on "Mar 24">
  b_XXXValueWithOffsetX$B$rMQ$$$k$h$&$K2~=$!#(B
<Revised Memo on "Nov 9">
  Increment, Decrement, Clear $B$r(B IncrementFP, DecrementFP, ClearFP $B$K$7$?!#(B
  $B%=%U%H%m%C%/$r30$7$?!#(B
********************************************************************* PSL **/

#PSL_define  s_IncrementFPChildCount(fp_record)
{
  @DEBUG{s_IfNotFPREC(fp_record){
    VPIM_ERROR("s_IncrementFPChildCount","Not FPREC type");}};

  $USE(D_WorkFPRecOpe);
  p_ReadWithOffset(fp_record, _FP_CHILD_COUNT_OFFSET, D_WorkFPRecOpe);
  @DEBUG{ b_IfLessImm( D_WorkFPRecOpe, _ZERO ) {
    VPIM_ERROR("s_IncrementFPChildCount","Illegal Child Count");
  }};
  b_IncrementReg(D_WorkFPRecOpe);
  b_WriteDNTCWithOffset(D_WorkFPRecOpe, fp_record, _FP_CHILD_COUNT_OFFSET);
  $RELEASE(D_WorkFPRecOpe);
}

/******************************************************************** PSL **

  s_DecrementFPChildCount(fp_record)

       written by kawai@icot21      on Thu Dec 14 11:20:47 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$N(BChildCount$B$r%G%/%j%a%s%H$9$k!#(B
  ($B%O!<%I%&%'%"%m%C%/IU$-$@$C$?$1$I$d$a$?(B)
<Examples>
<Test>
<Explanation>
<ETC>
<Revised Memo on "Mar 24">
  b_XXXValueWithOffsetX$B$rMQ$$$k$h$&$K2~=$!#(B
<Revised Memo on "Nov 9">
  Increment, Decrement, Clear $B$r(B IncrementFP, DecrementFP, ClearFP $B$K$7$?!#(B
  $B%=%U%H%m%C%/$r30$7$?!#(B
********************************************************************* PSL **/

#PSL_define  s_DecrementFPChildCount(fp_record)
{
  @DEBUG{s_IfNotFPREC(fp_record){
    VPIM_ERROR("s_DecrementFPChildCount","Not FPREC type");}};

  $USE(D_WorkFPRecOpe);
  p_ReadWithOffset(fp_record, _FP_CHILD_COUNT_OFFSET, D_WorkFPRecOpe);
  b_DecrementReg(D_WorkFPRecOpe);
  @DEBUG{
    b_IfLessImm(D_WorkFPRecOpe, _ZERO){
      VPIM_ERROR("s_DecrementFPChildCount","invalid child count");
    }};
  b_WriteDNTCWithOffset(D_WorkFPRecOpe, fp_record, _FP_CHILD_COUNT_OFFSET);
  $RELEASE(D_WorkFPRecOpe);
}

/******************************************************************** PSL **

  s_ClearFPChildCount(fp_record)

       written by kawai@icot21      on Thu Dec 14 11:22:09 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$N(BChildCount$B$r%<%m%/%j%"$9$k!#(B
  ($B%O!<%I%&%'%"%m%C%/IU$-$@$C$?$1$I$d$a$?(B)
<Examples>
<Test>
<Explanation>
<ETC>
<Revised Memo on "Mar 24">
  b_XXXValueWithOffsetX$B$rMQ$$$k$h$&$K2~=$!#(B
<Revised Memo on "Nov 9">
  Increment, Decrement, Clear $B$r(B IncrementFP, DecrementFP, ClearFP $B$K$7$?!#(B
  $B%=%U%H%m%C%/$r30$7$?!#(B
********************************************************************* PSL **/

#PSL_define  s_ClearFPChildCount(fp_record)
{
  @DEBUG{s_IfNotFPREC(fp_record){
    VPIM_ERROR("s_ClearFPChildCount","Not FPREC type");}};

  b_WriteDNTCWithOffset(D_NULL, fp_record, _FP_CHILD_COUNT_OFFSET);
}

/******************************************************************** PSL **

  s_UpdateFPChildCount(fp_record)

       written by kawai@icot21      on Thu Dec 14 11:23:55 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$N(BChildCount$B$NCM$K!"(BPE$B$K%-%c%C%7%e$5$l$F$$$?(BChildCount$B$NCM(B(=D_Fork_Ctr)$B$r(B
$B2C;;$9$k!#(B
  $B$3$N%^%/%m$O!"%4!<%k$N(Bdequeue$B;~$KN$?F$,%+%l%s%H$JN$?F$+$iJQ$o$k;~$K8F$S=P$5$l(B
$B$k!#(B
  ($B%O!<%I%&%'%"%m%C%/IU$-$@$C$?$1$I$d$a$?(B)
<Examples>
<Test>
<Explanation>
<ETC>
<Revised Memo on "Mar 24">
  b_XXXValueWithOffsetX$B$rMQ$$$k$h$&$K2~=$!#(B
<Revised Memo on "Nov 9">
  Increment, Decrement, Clear $B$r(B IncrementFP, DecrementFP, ClearFP $B$K$7$?!#(B
  $B%=%U%H%m%C%/$r30$7$?!#(B
********************************************************************* PSL **/

#PSL_define  s_UpdateFPChildCount(fp_record)
{
  @DEBUG{s_IfNotFPREC(fp_record){
    VPIM_ERROR("s_UpdateFPChildCount","Not FPREC type");}};

  $USE(D_WorkFPRecOpe);
  p_ReadWithOffset(fp_record, _FP_CHILD_COUNT_OFFSET, D_WorkFPRecOpe);
  s_IncrementByForkCounter (D_WorkFPRecOpe);

  @DEBUG{b_IfLess(D_WorkFPRecOpe, D_NULL){
    VPIM_ERROR("s_UpdateFPChildCount","Negative ChildCount !!");}};

  b_WriteDNTCWithOffset(D_WorkFPRecOpe, fp_record, _FP_CHILD_COUNT_OFFSET);
  $RELEASE(D_WorkFPRecOpe);
}

/******************************************************************** PSL **

  s_AddFPChildCount(fp_record, child_count_reg)

       written by kawai@icot21      on Fri Feb 16 17:03:33 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  s_AddFPChildCount(fp_record, child_count_reg)
{
  @DEBUG{s_IfNotFPREC(fp_record){
    VPIM_ERROR("s_AddFPChildCount","Not FPREC type");}};

  $USE(D_WorkFPRecOpe);
  p_ReadWithOffset(fp_record, _FP_CHILD_COUNT_OFFSET, D_WorkFPRecOpe);
  p_Add(D_WorkFPRecOpe, child_count_reg, D_WorkFPRecOpe);

  @DEBUG{b_IfLess(D_WorkFPRecOpe, D_NULL){
    VPIM_ERROR("s_AddFPChildCount","Negative ChildCount !!");}};

  b_WriteDNTCWithOffset(D_WorkFPRecOpe, fp_record, _FP_CHILD_COUNT_OFFSET);
  $RELEASE(D_WorkFPRecOpe);
}


/******************************************************************** PSL **

  s_IncrementFPChildShoenStatisticsCount(fp_record)

       written by kawai@icot21      on Tue Nov 28 12:02:51 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$N(B child_shoen_statistics_count $B$r%$%s%/%j%a%s%H$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  s_IncrementFPChildShoenStatisticsCount(fp_record)
{
  @DEBUG{s_IfNotFPREC(fp_record){
    VPIM_ERROR("s_IncrementFPChildShoenStatisticsCount","Not FPREC type");}};

  $USE(D_WorkFPRecOpe);
  p_ReadWithOffset(fp_record, 
		_FP_CHILD_SHOEN_STATISTICS_COUNT_OFFSET, D_WorkFPRecOpe);
  b_IncrementReg(D_WorkFPRecOpe);
  b_WriteDNTCWithOffset(D_WorkFPRecOpe, 
		fp_record, _FP_CHILD_SHOEN_STATISTICS_COUNT_OFFSET);
  $RELEASE(D_WorkFPRecOpe);
}

/******************************************************************** PSL **

  s_DecrementFPChildShoenStatisticsCount(fp_record)

       written by kawai@icot21      on Thu Dec 14 11:38:19 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$N(B chld_shoen_statitics_count $B$r%G%/%j%a%s%H$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  s_DecrementFPChildShoenStatisticsCount(fp_record)
{
  @DEBUG{s_IfNotFPREC(fp_record){
    VPIM_ERROR("s_DecrementFPChildShoenStatisticsCount","Not FPREC type");}};

  $USE(D_WorkFPRecOpe);
  p_ReadWithOffset(fp_record, 
		_FP_CHILD_SHOEN_STATISTICS_COUNT_OFFSET, D_WorkFPRecOpe);
  b_DecrementReg(D_WorkFPRecOpe);
  b_WriteDNTCWithOffset(D_WorkFPRecOpe, 
			fp_record, _FP_CHILD_SHOEN_STATISTICS_COUNT_OFFSET);
  $RELEASE(D_WorkFPRecOpe);
}

/******************************************************************** PSL **

  s_AddFPProfilingTotalAnswerCount(fp_record, child_count_reg)

       written by kawai@icot21      on Fri Feb 16 17:03:33 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  s_AddFPProfilingTotalAnswerCount(fp_record, child_count_reg)
{
  @DEBUG{s_IfNotFPREC(fp_record){
    VPIM_ERROR("s_AddFPProfilingTotalAnswerCount","Not FPREC type");}};

  $USE(D_WorkFPRecOpe);
  p_ReadWithOffset(fp_record, _FP_PROFILING_TOTAL_ANSWER_COUNT_OFFSET, 
		   D_WorkFPRecOpe);
  p_Add(D_WorkFPRecOpe, child_count_reg, D_WorkFPRecOpe);
  b_WriteDNTCWithOffset(D_WorkFPRecOpe, fp_record, 
		    _FP_PROFILING_TOTAL_ANSWER_COUNT_OFFSET);
  $RELEASE(D_WorkFPRecOpe);
}


/******************************************************************** PSL **

  s_IncrementFPProfilingChildShoenCount(fp_record)

       written by kawai@icot21      on Tue Nov 28 12:02:51 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$N(B profiling_child_shoen_count $B$r%$%s%/%j%a%s%H$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  s_IncrementFPProfilingChildShoenCount(fp_record)
{
  @DEBUG{s_IfNotFPREC(fp_record){
    VPIM_ERROR("s_IncrementFPProfilingChildShoenCount","Not FPREC type");}};

  $USE(D_WorkFPRecOpe);
  p_ReadWithOffset(fp_record, 
		_FP_PROFILING_CHILD_SHOEN_COUNT_OFFSET, D_WorkFPRecOpe);
  b_IncrementReg(D_WorkFPRecOpe);
  b_WriteDNTCWithOffset(D_WorkFPRecOpe, 
		fp_record, _FP_PROFILING_CHILD_SHOEN_COUNT_OFFSET);
  $RELEASE(D_WorkFPRecOpe);
}

/******************************************************************** PSL **

  s_DecrementFPProfilingChildShoenCount(fp_record)

       written by kawai@icot21      on Thu Dec 14 11:38:19 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$N(B profiling_chld_shoen_count $B$r%G%/%j%a%s%H$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  s_DecrementFPProfilingChildShoenCount(fp_record)
{
  @DEBUG{s_IfNotFPREC(fp_record){
    VPIM_ERROR("s_DecrementFPProfilingChildShoenCount","Not FPREC type");}};

  $USE(D_WorkFPRecOpe);
  p_ReadWithOffset(fp_record, 
		_FP_PROFILING_CHILD_SHOEN_COUNT_OFFSET, D_WorkFPRecOpe);
  b_DecrementReg(D_WorkFPRecOpe);
  b_WriteDNTCWithOffset(D_WorkFPRecOpe, 
			fp_record, _FP_PROFILING_CHILD_SHOEN_COUNT_OFFSET);
  $RELEASE(D_WorkFPRecOpe);
}

/******************************************************************** PSL **

       written by yamamoto@icot22      on Mon Jun 18 14:39:01 1990

  (3) $BN$?F$N3F%9%m%C%H$NFbMF$rD4$Y$k%^%/%m(B

cf	V02:	written by kawai@icot21      on Tue Jan 31 18:10:01 1989

********************************************************************* PSL **/
/******************************************************************** PSL **

  s_IfAbortedFP(fp_record)

       written by kawai@icot21      on Wed Dec 13 22:26:30 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_WorkFPRecOpe : $BN$?F$NO@M}>uBV$r0l;~J];}$9$k%l%8%9%?(B
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$,%"%\!<%H>uBV$+H]$+$rD4$Y$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define  s_IfAbortedFP(fp_record)
{
  $USE(D_WorkFPRecOpe);
  s_GetFPTransitStatus(fp_record, D_WorkFPRecOpe);
  p_CompareImmediate(D_WorkFPRecOpe, _FP_ABORTED);
  $RELEASE(D_WorkFPRecOpe);
  p_IfEQ()
}

/******************************************************************** PSL **

  s_IfTerminateFP(fp_record)

       written by kawai@icot21      on Wed Dec 13 22:26:30 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_WorkFPRecOpe : $BN$?F$NO@M}>uBV$r0l;~J];}$9$k%l%8%9%?(B
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$,%?!<%_%M%$%H!J2rJ|M=Ls!K>uBV$+H]$+$rD4$Y$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define  s_IfTerminateFP(fp_record)
{
  $USE(D_WorkFPRecOpe);
  s_GetFPTransitStatus(fp_record, D_WorkFPRecOpe);
  p_CompareImmediate(D_WorkFPRecOpe, _FP_TERMINATE);
  $RELEASE(D_WorkFPRecOpe);
  p_IfEQ()
}

/******************************************************************** PSL **

  s_IfAbortedTerminateFP(fp_record)

       written by kawai@icot21      on Wed Dec 13 22:26:30 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_WorkFPRecOpe : $BN$?F$NO@M}>uBV$r0l;~J];}$9$k%l%8%9%?(B
<Level>
  structures
<PreCondition>
<Function>
  $B%"%\!<%F%C%IN$?F$,%?!<%_%M%$%H!J2rJ|M=Ls!K>uBV$+H]$+$rD4$Y$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define  s_IfAbortedTerminateFP(fp_record)
{
  $USE(D_WorkFPRecOpe);
  s_GetFPTransitStatus(fp_record, D_WorkFPRecOpe);
  p_CompareImmediate(D_WorkFPRecOpe, _FP_ABORTED_TERMINATE);
  $RELEASE(D_WorkFPRecOpe);
  p_IfEQ()
}

/******************************************************************** PSL **

  s_IfAbortedOrAbortedTerminateFP(fp_record)

       written by kawai@icot21      on Wed Dec 13 22:26:30 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_WorkFPRecOpe : $BN$?F$NO@M}>uBV$r0l;~J];}$9$k%l%8%9%?(B
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$,(B{$B%"%\!<%H>uBV$^$?$O%"%\!<%H%?!<%_%M%$%H>uBV(B}$B$+H]$+$rD4$Y$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define  s_IfAbortedOrAbortedTerminateFP(fp_record)
{
  $USE(D_WorkFPRecOpe);
  s_GetFPTransitStatus(fp_record, D_WorkFPRecOpe);
  p_CompareImmediate(D_WorkFPRecOpe, _FP_ABORTED_TERMINATE);
  p_IfEQ(){
    p_Compare(D_NULL,D_NULL);
  }else{
    p_CompareImmediate(D_WorkFPRecOpe, _FP_ABORTED);
    p_IfEQ(){
      p_Compare(D_NULL,D_NULL);
    }else{
      p_Compare(D_NULL,D_ONE);
    }
  }
  $RELEASE(D_WorkFPRecOpe);
  p_IfEQ()
}
/*
  $B$3$l$G$b$$$$$h$M(B 90-11-27 -- Reki
{
  $USE(D_WorkFPRecOpe);
  s_GetFPTransitStatus(fp_record, D_WorkFPRecOpe);
  p_CompareImmediate(D_WorkFPRecOpe, _FP_ABORTED_TERMINATE);
  p_IfNE(){
    p_CompareImmediate(D_WorkFPRecOpe, _FP_ABORTED);
  }
  $RELEASE(D_WorkFPRecOpe);
  p_IfEQ()
}
*/


/******************************************************************** PSL **

  s_IfNotStartedFP(fp_record)

       written by kawai@icot21      on Thu Dec 14 10:58:27 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_WorkFPRecOpe : $BN$?F$NO@M}>uBV$r0l;~J];}$9$k%l%8%9%?(B
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$,(B start $B>uBV$G$J$$$+$I$&$+$rH=Dj$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define  s_IfNotStartedFP(fp_record)
{
  $USE(D_WorkFPRecOpe);
  s_GetFPTransitStatus(fp_record, D_WorkFPRecOpe);
  p_CompareImmediate(D_WorkFPRecOpe, _FP_STARTED);
  $RELEASE(D_WorkFPRecOpe);
  p_IfNE()
}

/******************************************************************** PSL **

  s_IfStoppedFP(fp_record)

       written by kawai@icot21      on Thu Dec 14 11:02:15 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_WorkFPRecOpe : $BN$?F$NO@M}>uBV$r0l;~J];}$9$k%l%8%9%?(B
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$,Dd;_>uBV$+H]$+$rH=Dj$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define  s_IfStoppedFP(fp_record)
{
  $USE(D_WorkFPRecOpe);
  s_GetFPTransitStatus(fp_record, D_WorkFPRecOpe);
  p_CompareImmediate(D_WorkFPRecOpe, _FP_STOPPED);
  $RELEASE(D_WorkFPRecOpe);
  p_IfEQ()
}

/******************************************************************** PSL **

  s_IfStoppedFP(fp_record)

       written by kawai@icot21      on Thu Dec 14 11:02:15 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_WorkFPRecOpe : $BN$?F$NO@M}>uBV$r0l;~J];}$9$k%l%8%9%?(B
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$,Dd;_>uBV$+H]$+$rH=Dj$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define  s_IfReservedFP(fp_record)
{
  $USE(D_WorkFPRecOpe);
  s_GetFPTransitStatus(fp_record, D_WorkFPRecOpe);
  p_CompareImmediate(D_WorkFPRecOpe, _FP_RESERVED);
  $RELEASE(D_WorkFPRecOpe);
  p_IfEQ()
}

/******************************************************************** PSL **

  s_IfNotRunnableFP(fp_record)

       written by kawai@icot21      on Thu Dec 14 11:05:53 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_WorkFPRecOpe : $BN$?F$NO@M}>uBV$r0l;~J];}$9$k%l%8%9%?(B
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$KB0$9$k%4!<%k$N%j%@%/%7%g%s$r9T$J$C$F$O$$$1$J$$$+$I$&$+$rH=Dj$9$k!#(B
  ($BN$?F$N>uBV$,(B (started$B$G$O$J$$(B) $B$"$k$$$O(B (resource_exhausted$B$G$"$k(B))
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
/*************************************************************************/
/* $BCm0U(B : _FP_STARTED $B$H<!$N(B _FP_RSC_EXHAUSTED_FLAG $B$N(B off $B$O(B
   s_IfRunnableFP,s_IfNotRunnableFP $B$G9bB.$KH=Dj$7$?$$$N$G(B
   _FP_STARTED 0x00 $B$G$"$k$3$H$H!"(B_FP_RSC_EXAUSTED_FLAG $B$,(B
   TransitStatus $B$NNY$K$"$k$3$H$OI,MW>r7o$K$J$C$F$$$k!#(B         */
/*************************************************************************/

#CTRL_define  s_IfNotRunnableFP(fp_record)
{
  $USE(D_WorkFPRecOpe);
  s_GetFPStatus(fp_record, D_WorkFPRecOpe);
  b_ExtractBitField(D_WorkFPRecOpe, _FP_RUNNABLE_MASK,
		                                D_WorkFPRecOpe);
  p_CompareImmediate(D_WorkFPRecOpe, _ZERO);
  $RELEASE(D_WorkFPRecOpe);
  p_IfNE()
}

/******************************************************************** PSL **

  s_IfRunnableFP(fp_record)

       written by kawai@icot21      on Thu Dec 14 11:09:00 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_WorkFPRecOpe : $BN$?F$NO@M}>uBV$r0l;~J];}$9$k%l%8%9%?(B
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$KB0$9$k%4!<%k$N%j%@%/%7%g%s$r9T$J$C$F$bNI$$$+H]$+$rH=Dj$9$k!#(B
  ($BN$?F$N>uBV$,(B started $B$+$D(B resource_exhausted $B$O(B off)
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
/*************************************************************************/
/* $BCm0U(B : _FP_STARTED $B$H<!$N(B _FP_RSC_EXHAUSTED_FLAG $B$N(B off $B$O(B
   s_IfRunnableFP,s_IfNotRunnableFP $B$G9bB.$KH=Dj$7$?$$$N$G(B
   _FP_STARTED 0x00 $B$G$"$k$3$H$H!"(B_FP_RSC_EXAUSTED_FLAG $B$,(B
   TransitStatus $B$NNY$K$"$k$3$H$OI,MW>r7o$K$J$C$F$$$k!#(B         */
/*************************************************************************/

#CTRL_define  s_IfRunnableFP(fp_record)
{
  $USE(D_WorkFPRecOpe);
  s_GetFPStatus(fp_record, D_WorkFPRecOpe);
  b_ExtractBitField(D_WorkFPRecOpe, _FP_RUNNABLE_MASK,
		                                D_WorkFPRecOpe);
  p_CompareImmediate(D_WorkFPRecOpe, _ZERO);
  $RELEASE(D_WorkFPRecOpe);
  p_IfEQ()
}

/******************************************************************** PSL **

  s_IfEQTransitStatusFPImm(fp_record, imm_status)

       written by kawai@icot21      on Thu Apr  6 23:26:10 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$rJ];}$9$k%l%8%9%?(B
  imm_status : $B%9%F!<%?%9(B($BB(CM(B)
<Temporally Used Variables>
  D_Work_FP_Status_Reg : $BN$?F$N%9%F!<%?%9$r0l;~J];}$9$k%l%8%9%?(B
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$NO@M}%9%F!<%?%9$,(Bimm_status$B$HF1$8$+H]$+$rH=Dj$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define  D_Work_FP_Status_Reg   XXX

#CTRL_define  s_IfEQTransitStatusFPImm(fp_record, imm_status)
{
  $USE(D_Work_FP_Status_Reg);
  s_GetFPTransitStatus(fp_record, D_Work_FP_Status_Reg);
  p_CompareImmediate(D_Work_FP_Status_Reg, imm_status);
  $RELEASE(D_Work_FP_Status_Reg);
  p_IfEQ()
}

/******************************************************************** PSL **

$B>uBV%U%i%0$N%F%9%H(B

$B>uBV%U%i%0$N%;%C%H!"%j%;%C%H$N$H$3$m$KCV$$$F$"$k!#(B

********************************************************************* PSL **/
/******************************************************************** PSL **

  s_IfNoChild(fp_record)

       written by kawai@icot21      on Mon Nov  6 23:34:34 1989
<Arguments>
  fp_record : $BN$?F$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$N(BChildCount$B$,(B0$B$G$"$k$,H]$+$rH=Dj$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define  s_IfNoChild(fp_record)
{
  $USE(D_WorkFPRecOpe);
  s_GetFPChildCount(fp_record, D_WorkFPRecOpe);
  @DEBUG{
    p_Compare(D_WorkFPRecOpe, D_NULL);
    p_IfLT(){VPIM_ERROR("s_IfNoChild","Child Count is negative!!!");}
  };
  p_Compare(D_WorkFPRecOpe, D_NULL);
  $RELEASE(D_WorkFPRecOpe);
  p_IfEQ()
}

/******************************************************************** PSL **

  s_IfAllChildShoenStatisticsCompleted(fp_record)

       written by kawai@icot21      on Mon Nov  6 23:34:34 1989
<Arguments>
  fp_record : $BN$?F$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$N(BChildShoenStatisticsCount$B$,(B0$B$G$"$k$,H]$+$rH=Dj$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define  s_IfAllChildShoenStatisticsCompleted(fp_record)
{
  $USE(D_WorkFPRecOpe);
  s_GetFPChildShoenStatisticsCount(fp_record, D_WorkFPRecOpe);
  p_Compare(D_WorkFPRecOpe, D_NULL);
  $RELEASE(D_WorkFPRecOpe);
  p_IfEQ()
}

/******************************************************************** PSL **
s_IfNoSuspendedMsg

       written by nakase@icot22      on Fri Apr  6 15:40:30 1990
<Arguments>
  fp_record : $BN$?F$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
 $BN$?F$K%5%9%Z%s%I$7$?%a%C%;!<%8$,$"$k$+H=Dj$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define  s_IfNoSuspendedMsg(fp_record)
{
  $USE(D_WorkFPRecOpe);
  s_GetFPSuspendedMessage(fp_record, D_WorkFPRecOpe);
  p_IfTypeEQ(D_WorkFPRecOpe, D_EOL){
    p_Compare(D_NULL,D_NULL);
  }else{
    p_Compare(D_NULL,D_ONE);
  }
  $RELEASE(D_WorkFPRecOpe);
  p_IfEQ()
}

/******************************************************************** PSL **

  s_IfEnoughFPResourceLeft(fp_record, resource_reg)

       written by kawai@icot22      on Wed Jun 14 17:11:16 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$rJ];}$9$k%l%8%9%?(B
  resource_reg : $B%j%=!<%9NL$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_WorkFPRecOpe : $BN$?F%l%3!<%I$N%j%=!<%9;DNL$r0l;~J];}$9$k%l%8%9%?(B
<Level>
    structures
<PreCondition>
<Function>
  $BN$?F%l%3!<%I$N%j%=!<%9;DNL$,(Bresource_reg$B0J>e$+H]$+$rH=Dj$9$k!#(B
  ($B%=%U%H%m%C%/$J$7(B)
<Examples>
<Test>
<Explanation>
<ETC>
  $B:G8e$NH=Dj$r(B p_IfGT $B$+$i(B p_IfGE $B$KJQ99(B('90.3.19)
********************************************************************* PSL **/

#CTRL_define  s_IfEnoughFPResourceLeft(fp_record, resource_reg)
{
  s_IfDummyFP(fp_record){
    p_Compare(D_NULL,D_NULL);
  }else{
    $USE(D_WorkFPRecOpe);
    p_ReadWithOffset(fp_record, _FP_RESOURCE_LEFT_UPPER_OFFSET,
		     D_WorkFPRecOpe);
    p_Compare(D_WorkFPRecOpe, D_NULL);
    p_IfEQ(){
      p_ReadWithOffset(fp_record, _FP_RESOURCE_LEFT_LOWER_OFFSET,
		       D_WorkFPRecOpe);
      b_CompareU(D_WorkFPRecOpe, resource_reg);
    }else{
      p_Compare(D_NULL,D_NULL);/* $BN$?F$N%j%=!<%9%l%U$H$OIi$K$J$i$J$$$O$:(B */
    }
    $RELEASE(D_WorkFPRecOpe);
  }
  p_IfGE()
}

/******************************************************************** PSL **

  s_IfNotEnoughFPResourceLeft(fp_record, resource_reg)

       written by kawai@icot22      on Wed Jun 14 17:11:16 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$rJ];}$9$k%l%8%9%?(B
  resource_reg : $B%j%=!<%9NL$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_WorkFPRecOpe : $BN$?F%l%3!<%I$N%j%=!<%9;DNL$r0l;~J];}$9$k%l%8%9%?(B
<Level>
    structures
<PreCondition>
<Function>
  $BN$?F%l%3!<%I$N%j%=!<%9;DNL$,(Bresource_reg$B$h$j>/$J$$$+H]$+$rH=Dj$9$k!#(B
  ($B%=%U%H%m%C%/$J$7(B)
<Examples>
<Test>
<Explanation>
<ETC>
  $B:G8e$NH=Dj$r(B p_IfLE $B$+$i(B p_IfLT $B$KJQ99(B('90.3.19)
********************************************************************* PSL **/

#CTRL_define  s_IfNotEnoughFPResourceLeft(fp_record, resource_reg)
{
  s_IfDummyFP(fp_record){
    p_Compare(D_NULL,D_NULL);
  }else{
    $USE(D_WorkFPRecOpe);
    p_ReadWithOffset(fp_record, _FP_RESOURCE_LEFT_UPPER_OFFSET,
		     D_WorkFPRecOpe);
    p_Compare(D_WorkFPRecOpe, D_NULL);
    p_IfEQ(){
      p_ReadWithOffset(fp_record, _FP_RESOURCE_LEFT_LOWER_OFFSET,
		       D_WorkFPRecOpe);
      b_CompareU(D_WorkFPRecOpe, resource_reg);
    }else{
      p_Compare(D_NULL,D_NULL);/* $BN$?F$N%j%=!<%9%l%U$H$OIi$K$J$i$J$$$O$:(B */
    }
    $RELEASE(D_WorkFPRecOpe);
  }
  p_IfLT()
}

/******************************************************************** PSL **

  s_IfExhaustedFPResource(fp_record)

       written by kawai@icot21      on Wed Aug 30 12:33:48 1989
<Arguments>
  fp_record : $BN$?F$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_WorkFPRecOpe : $BN$?F$N;q8;NL$r0l;~J];}$9$k%l%8%9%?(B
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$,;q8;$r;H$$2L$?$7$F$$$k$+H]$+$rH=Dj$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define  s_IfExhaustedFPResource(fp_record)
{
  s_IfDummyFP(fp_record){
    p_Compare(D_ONE,D_NULL);
  }else{
    $USE(D_WorkFPRecOpe);
    p_ReadWithOffset(fp_record, _FP_RESOURCE_LEFT_UPPER_OFFSET,
		     D_WorkFPRecOpe);
    p_Compare(D_WorkFPRecOpe, D_NULL);
    p_IfEQ(){
      p_ReadWithOffset(fp_record, _FP_RESOURCE_LEFT_LOWER_OFFSET,
		       D_WorkFPRecOpe);
      p_Compare(D_WorkFPRecOpe, D_NULL);
    }else{
      p_Compare(D_ONE,D_NULL);
    }
    $RELEASE(D_WorkFPRecOpe);
  }
  p_IfEQ()/* $BN$?F$N%j%=!<%9%l%U$H$OIi$K$J$i$J$$$O$:(B */
}

/******* start stop count increment and decrement and test *******/

/******************************************************************** PSL **

  s_IncrementFPStartStopCount(fp_record,count_reg)

       written by kawai@icot21      on Tue Nov 28 12:02:51 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$N(B start_stop_count $B$r%$%s%/%j%a%s%H$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  s_IncrementFPStartStopCount(fp_record,start_stop_count)
{
  @DEBUG{s_IfNotFPREC(fp_record){
    VPIM_ERROR("s_IncrementFPStartStopCount","Not FPREC type");}};

  $USE(D_WorkFPRecOpe);
  p_ReadWithOffset(fp_record, _FP_START_STOP_COUNT_OFFSET, D_WorkFPRecOpe);
  b_IncrementReg(D_WorkFPRecOpe);
  b_WriteDNTCWithOffset(D_WorkFPRecOpe, fp_record, _FP_START_STOP_COUNT_OFFSET);
  p_MoveWord(D_WorkFPRecOpe,start_stop_count);
  $RELEASE(D_WorkFPRecOpe);
}

/******************************************************************** PSL **

  s_DecrementFPStartStopCount(fp_record,count_reg)

       written by kawai@icot21      on Thu Dec 14 11:38:19 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$N(B start_stop_count $B$r%G%/%j%a%s%H$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  s_DecrementFPStartStopCount(fp_record,start_stop_count)
{
  @DEBUG{s_IfNotFPREC(fp_record){
    VPIM_ERROR("s_DecrementFPStartStopCount","Not FPREC type");}};

  $USE(D_WorkFPRecOpe);
  p_ReadWithOffset(fp_record, _FP_START_STOP_COUNT_OFFSET, D_WorkFPRecOpe);
  b_DecrementReg(D_WorkFPRecOpe);
  b_WriteDNTCWithOffset(D_WorkFPRecOpe, fp_record, _FP_START_STOP_COUNT_OFFSET);
  p_MoveWord(D_WorkFPRecOpe,start_stop_count);
  $RELEASE(D_WorkFPRecOpe);
}

/******* stat gather event count increment and decrement and test *******/

/******************************************************************** PSL **

  s_IncrementFPStatGatherEventCount(fp_record)

       written by kawai@icot21      on Tue Nov 28 12:02:51 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$N(B stat_gather_event_count $B$r%$%s%/%j%a%s%H$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  s_IncrementFPStatGatherEventCount(fp_record)
{
  @DEBUG{s_IfNotFPREC(fp_record){
    VPIM_ERROR("s_IncrementFPStatGatherEventCount","Not FPREC type");}};

  $USE(D_WorkFPRecOpe);
  p_ReadWithOffset(fp_record, _FP_STAT_GATHER_EVENT_COUNT_OFFSET, 
		   D_WorkFPRecOpe);
  b_IncrementReg(D_WorkFPRecOpe);
  b_WriteDNTCWithOffset(D_WorkFPRecOpe, fp_record, 
		    _FP_STAT_GATHER_EVENT_COUNT_OFFSET);
  $RELEASE(D_WorkFPRecOpe);
}

/******************************************************************** PSL **

  s_DecrementFPStatGatherEventCount(fp_record)

       written by kawai@icot21      on Thu Dec 14 11:38:19 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$N(B stat_gather_event_count $B$r%G%/%j%a%s%H$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  s_DecrementFPStatGatherEventCount(fp_record)
{
  @DEBUG{s_IfNotFPREC(fp_record){
    VPIM_ERROR("s_DecrementFPStatGatherEventCount","Not FPREC type");}};

  $USE(D_WorkFPRecOpe);
  p_ReadWithOffset(fp_record, _FP_STAT_GATHER_EVENT_COUNT_OFFSET, 
		   D_WorkFPRecOpe);
  b_DecrementReg(D_WorkFPRecOpe);
  b_WriteDNTCWithOffset(D_WorkFPRecOpe, fp_record, 
			_FP_STAT_GATHER_EVENT_COUNT_OFFSET);
  $RELEASE(D_WorkFPRecOpe);
}

/******************************************************************** PSL **

  s_IfNoStatGatherEvent(fp_record)

       written by kawai@icot21      on Mon Nov  6 23:34:34 1989
<Arguments>
  fp_record : $BN$?F$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$N(BStatGatherEventCount$B$,Nm$N;~??(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define  s_IfNoStatGatherEvent(fp_record)
{
  $USE(D_WorkFPRecOpe);
  s_GetFPStatGatherEventCount(fp_record, D_WorkFPRecOpe);
  p_Compare(D_WorkFPRecOpe, D_NULL);
  $RELEASE(D_WorkFPRecOpe);
  p_IfEQ()
}

/******************************************************************** PSL **

  s_IfJustOneStatGatherEvent(fp_record)

       written by kawai@icot21      on Mon Nov  6 23:34:34 1989
<Arguments>
  fp_record : $BN$?F$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
  structures
<PreCondition>
<Function>
  $BN$?F$N(BStatGatherEventCount$B$,0m$N;~??(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define  s_IfJustOneStatGatherEvent(fp_record)
{
  $USE(D_WorkFPRecOpe);
  s_GetFPStatGatherEventCount(fp_record, D_WorkFPRecOpe);
  p_Compare(D_WorkFPRecOpe, D_ONE);
  $RELEASE(D_WorkFPRecOpe);
  p_IfEQ()
}

/******************************************************************** PSL **

       written by kawai@icot22      on Thu Jan 31 11:09:11 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $BN$?F$,=*7k$7$F$7$^$o$J$$$3$H$rJ]>Z$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  s_EnsureFPExistance(fp_record, childcount_up)
{
  s_AddFPChildCount(fp_record, childcount_up);
  s_IncrementFPStatGatherEventCount(fp_record);
}


/******************************************************************** PSL **

s_IfNodeAndCountOutOfBounds(fp_record, min_node_reg, node_cnt_reg)

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
$B0z?t$G;XDj$5$l$?!"%N!<%IHO0O$,!"N$?F$N;}$D%N!<%IHO0O$+$i$O$_=P$7$F$$$?$i??(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define  s_IfNodeAndCountOutOfBounds(fp_record, 
					  min_node_reg, node_cnt_reg)
{
  $USE(D_WorkShoenTempReg1);
  s_GetFPMinNode(fp_record, D_WorkShoenTempReg1);
  b_IfLess(min_node_reg, D_WorkShoenTempReg1)
    {
      b_SetSuccess();
    }
  else
    {
      $USE(D_WorkShoenTempReg2);
      s_GetFPNodeCount(fp_record, D_WorkShoenTempReg2);
      b_AddWithDNTC(D_WorkShoenTempReg1, D_WorkShoenTempReg2, 
		    D_WorkShoenTempReg1);
/*    b_DecrementReg(D_WorkShoenTempReg1);  Work1 = fp_min + fp_cnt - 1 */
      b_AddWithDNTC(min_node_reg, node_cnt_reg, D_WorkShoenTempReg2);
/*    b_DecrementReg(D_WorkShoenTempReg2);  Work2 = min + cnt - 1 */
      b_IfLess(D_WorkShoenTempReg1, D_WorkShoenTempReg2)
	{
	  b_SetSuccess();
	}
      else
	{
	  b_SetFail();
	}
      $RELEASE(D_WorkShoenTempReg2);
    }
  $RELEASE(D_WorkShoenTempReg1);
  b_IfSuccess()
}
/******************************************************************** PSL **

s_IfNodeOutOfBounds(fp_record, node_reg)

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
$B0z?t$G;XDj$5$l$?!"%N!<%I$,!"N$?F$N;}$D%N!<%IHO0O$+$i$O$_=P$7$F$$$?$i??(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define  s_IfNodeOutOfBounds(fp_record, node_reg)
{
  $USE(D_WorkShoenTempReg1);
  s_GetFPMinNode(fp_record, D_WorkShoenTempReg1);
  b_IfLess(node_reg, D_WorkShoenTempReg1)
    {
      b_SetSuccess();
    }
  else
    {
      $USE(D_WorkShoenTempReg2);
      s_GetFPNodeCount(fp_record, D_WorkShoenTempReg2);
      b_AddWithDNTC(D_WorkShoenTempReg1, D_WorkShoenTempReg2, 
		    D_WorkShoenTempReg1);
      b_DecrementReg(D_WorkShoenTempReg1); /* Work1 = fp_min + fp_cnt - 1 */
      b_IfLess(D_WorkShoenTempReg1, node_reg)
	{
	  b_SetSuccess();
	}
      else
	{
	  b_SetFail();
	}
      $RELEASE(D_WorkShoenTempReg2);
    }
  $RELEASE(D_WorkShoenTempReg1);
  b_IfSuccess()
}
