
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/structures/str_fp_profiling_shoen.psl.c
   ----- CREATED   : by yamamoto@icot22, on Mon May 13 10:35:26 1991
   ----- LAST SAVED: by yamamoto@icot22, on Fri May 15 18:54:02 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : structures
   ----- ABSTRACT  : $B%W%m%U%!%$%j%s%0Aq1`$N$?$a$N%G!<%?9=B$$H$=$NA`:n(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **

       written by yamamoto@icot22      on Mon May 13 10:49:00 1991

  $B%W%m%U%!%$%j%s%0Aq1`$N$?$a$N%G!<%?9=B$$H$=$NA`:n(B

$B%W%m%U%!%$%j%s%0%G!<%?$ON$?FKh$K<}=8$9$k!#(B
$B<}=8%G!<%?$O!"=R8lKh$N%+%&%s%?$r@_$1!"(B
$B%O%C%7%eI=$N@h$K<}=8%G!<%?$rD>@\%j%s%/$7$F$$$/!#(B
$BAq1`$KJs9p$9$k;~N$?FKh$K#1K\$K$^$H$a$FM"=P$9$k!#(B

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

/******************************************************************** PSL **

$B%W%m%U%!%$%j%s%0%?%$%W(B

       written by yamamoto@icot22      on Thu May 16 12:29:32 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>

$B%f!<%6$KJs9p$5$l$k%?%$%W(B
_FP_PROFILETYPE_FPTERMINATE
_FP_PROFILETYPE_ANSWER    
_FP_PROFILETYPE_COUNTLIMIT

$B=hM}7O$N$_$,2r<a$9$k%?%$%W(B
$B!J#a#s#k#p#r#o#f$,N$?F$N%?!<%_%M!<%7%g%s$H9T$-0c$$$K$J$C$?;~$N#n#a#c#k!K(B
_FP_PROFILETYPE_NO_FP      


<ETC>
********************************************************************* PSL **/

#CONST_define _FP_PROFILETYPE_FPTERMINATE    0
#CONST_define _FP_PROFILETYPE_ANSWER         1
#CONST_define _FP_PROFILETYPE_COUNTLIMIT     2

#CONST_define _FP_PROFILETYPE_NO_FP         10




/******************************************************************** PSL **

s_FPAllocProfilingEntry(arg1,arg2,arg3,entry)

s_FPPushProfilingEntry(fp_rec,entry)
s_FPPopProfilingEntry(fp_rec,entry)

s_FPIncrementDequeueCountProfilingEntry(entry)
s_FPIncrementSuspendCountProfilingEntry(entry)

       written by yamamoto@icot22      on Mon May 13 10:58:37 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>

$B%W%m%U%!%$%j%s%0$GJs9p$5$l$k%G!<%?$K4X$7$F!"(BPIM$B$G$O!"(Bcod $B$OI,$:I,MW!#(B
$BIU2C>pJs$r$D$1$k>l9g$K$O(B cod $B$b4^$a$F%Y%/%?$K$9$l$P(BVect4 $B$GNI$$!#(B

$B$7$+$7!"(BVPIM $B$H$7$F$O!"#1%o!<%I$rM=Ls8l$H$7$F!"(BMulti-PSI $B$HF1$8(B Vect5 
$B$N$^$^$K$7$F$"$k!#(B

$BIU2C>pJs$H$7$F$O!"AH$_9~$_$,%5%9%Z%s%I$7$?;~$N!"8F$S$@$7=R8l$NFCDj$N$?$a!"(B
$B8F$S$@$7%b%8%e!<%k!"F1%*%U%;%C%H$rIU$1$k$3$H$J$I$,9M$($i$l$k!#(B

$B$I$3$^$GIU2C>pJs$rIU$1$k$+$O%^%7%s0MB8$H$9$k!#(B

VPIM $B$G$O!"IU2C>pJs$rIU$1$F$$$J$$!#!J(B91/06/10$B%j%j!<%9;~E@!K(B

********************************************************************* PSL **/

#ADDR_define _FP_PROFILE_ENTRY_COD_OFST       0  /* cod */
#ADDR_define _FP_PROFILE_ENTRY_ENV_INFO_OFST  1
#ADDR_define _FP_PROFILE_ENTRY_DEQC_OFST      2
#ADDR_define _FP_PROFILE_ENTRY_SUSPC_OFST     3
#ADDR_define _FP_PROFILE_ENTRY_NEXT_OFST      4

#DATA_define D_WorkFPProfileIncResult XXX
#DATA_define D_WorkFPProfileInitEntry XXX
#DATA_define D_WorkFPProfEnvRec       XXX
#DATA_define D_WorkFPProfEnvInfo      XXX
#DATA_define D_WorkFPProfEnvInfo2     XXX
#DATA_define D_WorkFPProfCode         XXX

#CONST_define _FP_PROFILE_COUNT_KIND_DEQUEUE 1
#CONST_define _FP_PROFILE_COUNT_KIND_SUSPEND 2

#PSL_define s_FPAllocAndInitProfilingEntry(cod,env,entry){

  s_AllocVect5(entry);

/* $B%3!<%I%X$N%]%$%s%?$r3JG<(B */
  p_WriteWithOffset(cod,entry,_FP_PROFILE_ENTRY_COD_OFST);

  $USE(D_WorkFPProfileInitEntry);
  b_SetImmTypeValueMRBoff(INT,_ZERO,D_WorkFPProfileInitEntry);

/* $B%+%&%s%?$N=i4|2=(B */
  p_WriteWithOffset(D_WorkFPProfileInitEntry,
		    entry,_FP_PROFILE_ENTRY_DEQC_OFST);
  p_WriteWithOffset(D_WorkFPProfileInitEntry,
		    entry,_FP_PROFILE_ENTRY_SUSPC_OFST);

/* $BIU2C>pJs!J8F$S=P$785>pJs!K$N3JG<(B */
  p_WriteWithOffset(env,entry,_FP_PROFILE_ENTRY_ENV_INFO_OFST);
/* $B4D6-%l%3!<%I$O3dEv;~$K9u$/$7$F$"$k!#(B */
/* see str_env_record.psl.c 91-11-01 yamamoto */
/* $BB0@-!"%W%i%$%*%j%F%#Ey$O6hJL$;$:%+%&%s%H$9$k$N$G!"(B
 * KL1$B%W%m%0%i%^$K$O%@%_!<%9%m%C%H$G$7$+$J$$!#(B
 */

/* $B<!MWAG%]%$%s%?$N=i4|2=(B */  
  b_SetImmTypeValueMRBoff(ATOM,_ZERO,D_WorkFPProfileInitEntry);
  p_WriteWithOffset(D_WorkFPProfileInitEntry,
		    entry,_FP_PROFILE_ENTRY_NEXT_OFST);

  $RELEASE(D_WorkFPProfileInitEntry);

}

/* macros for profiling entry operation */

#PSL_define s_FPPushProfilingEntryAtTail(entry,to){
  p_WriteWithOffset(entry,to,_FP_PROFILE_ENTRY_NEXT_OFST);
}

#PSL_define s_FPPopAllProfilingEntries(from,entry,org_data_reg){
/*
  p_Read(from,entry);
*/
  p_MoveWord(org_data_reg,entry);

  $USE(D_WorkFPProfileInitEntry);
  b_SetImmTypeValueMRBoff(ATOM,_ZERO,D_WorkFPProfileInitEntry);
  p_MoveWord(D_WorkFPProfileInitEntry,org_data_reg);
  $RELEASE(D_WorkFPProfileInitEntry);
}

#PSL_define s_FPIncrementCountProfilingEntry(kind,entry,result){

  b_IfEqualImm(kind,_FP_PROFILE_COUNT_KIND_DEQUEUE){

    $USE(D_WorkFPProfileIncResult);
    p_ReadWithOffset(entry,_FP_PROFILE_ENTRY_DEQC_OFST,
		     D_WorkFPProfileIncResult);
    b_IncrementReg(D_WorkFPProfileIncResult);
    p_WriteWithOffset(D_WorkFPProfileIncResult,
		      entry,_FP_PROFILE_ENTRY_DEQC_OFST);
    p_MoveWord(D_WorkFPProfileIncResult,result);
    $RELEASE(D_WorkFPProfileIncResult);
    
  }else{
    
    $USE(D_WorkFPProfileIncResult);
    p_ReadWithOffset(entry,_FP_PROFILE_ENTRY_SUSPC_OFST,
		     D_WorkFPProfileIncResult);
    b_IncrementReg(D_WorkFPProfileIncResult);
    p_WriteWithOffset(D_WorkFPProfileIncResult,
		      entry,_FP_PROFILE_ENTRY_SUSPC_OFST);
    p_MoveWord(D_WorkFPProfileIncResult,result);
    $RELEASE(D_WorkFPProfileIncResult);
    
  }
}

#CTRL_define s_IfSameCountingTarget(prof_ent,code,env){

  $USE(D_WorkFPProfCode);

  p_ReadWithOffset(prof_ent,_FP_PROFILE_ENTRY_COD_OFST,D_WorkFPProfCode);
  b_IfNotEqual(code,D_WorkFPProfCode){
	b_SetFail(); /* $B%a%$%s%Q%9(B */
  }else{

    $USE(D_WorkFPProfEnvInfo);
    $USE(D_WorkFPProfEnvRec);
    $USE(D_WorkFPProfEnvInfo2);

    p_ReadWithOffset(prof_ent,_FP_PROFILE_ENTRY_ENV_INFO_OFST,
		    D_WorkFPProfEnvRec);

    p_IfTypeNE(env,D_WorkFPProfEnvRec){
      b_SetFail();
    }else{
      TypeSwitch(env){

      case VECT2:
      case VECT3:
	b_SetSuccess();
	break;

      case VECT4:
	s_GetOriginalModulePtrEnvRecord(D_WorkFPProfEnvRec,
					D_WorkFPProfEnvInfo);
	s_GetOriginalModulePtrEnvRecord(env,D_WorkFPProfEnvInfo2);
	b_IfWordNotEq(D_WorkFPProfEnvInfo,D_WorkFPProfEnvInfo2){
	  b_SetFail();
	  break;
	}
	s_GetOriginalModuleOfstEnvRecord(D_WorkFPProfEnvRec,
					 D_WorkFPProfEnvInfo);
	s_GetOriginalModuleOfstEnvRecord(env,D_WorkFPProfEnvInfo2);
	b_IfWordNotEq(D_WorkFPProfEnvInfo,D_WorkFPProfEnvInfo2){
	  b_SetFail();
	  break;
	}
	b_SetSuccess();
	break;

      case VECT6:
      case VECT8:
	s_GetOriginalModulePtrEnvRecord(D_WorkFPProfEnvRec,
					D_WorkFPProfEnvInfo);
	s_GetOriginalModulePtrEnvRecord(env,D_WorkFPProfEnvInfo2);
	b_IfWordNotEq(D_WorkFPProfEnvInfo,D_WorkFPProfEnvInfo2){
	  b_SetFail();
	  break;
	}
	s_GetOriginalModuleOfstEnvRecord(D_WorkFPProfEnvRec,
					 D_WorkFPProfEnvInfo);
	s_GetOriginalModuleOfstEnvRecord(env,D_WorkFPProfEnvInfo2);
	b_IfWordNotEq(D_WorkFPProfEnvInfo,D_WorkFPProfEnvInfo2){
	  b_SetFail();
	  break;
	}
	s_GetCallerModulePtrEnvRecord(D_WorkFPProfEnvRec,
					D_WorkFPProfEnvInfo);
	s_GetCallerModulePtrEnvRecord(env,D_WorkFPProfEnvInfo2);
	b_IfWordNotEq(D_WorkFPProfEnvInfo,D_WorkFPProfEnvInfo2){
	  b_SetFail();
	  break;
	}
	s_GetCallerModuleOfstEnvRecord(D_WorkFPProfEnvRec,
					 D_WorkFPProfEnvInfo);
	s_GetCallerModuleOfstEnvRecord(env,D_WorkFPProfEnvInfo2);
	b_IfWordNotEq(D_WorkFPProfEnvInfo,D_WorkFPProfEnvInfo2){
	  b_SetFail();
	  break;
	}
	b_SetSuccess();
	break;

      default:
	@DEBUG{VPIM_ERROR("s_IfSameCountingTarget",
			  "illegal type of env rec");};
      }
    }
    $RELEASE(D_WorkFPProfEnvInfo);
    $RELEASE(D_WorkFPProfEnvRec);
    $RELEASE(D_WorkFPProfEnvInfo2);
  }
  $RELEASE(D_WorkFPProfCode);
  b_IfSuccess()
}


/******************************************************************** PSL **

s_FPAllocProfilingHashTab(fp_rec)
s_FPReclaimProfilingHashTab(fp_rec)

       written by yamamoto@icot22      on Mon May 13 11:01:06 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
$B%O%C%7%eI=$N%5%$%:$OE,Ev(B (1P(=256W)/2-1W=127W) $B$K7h$a$?!#(B
$BJ*M}%5%$%:(B1/2P$B$N%Y%/%?$^$G$O!"BT$?$:$K$H$l$k!#(B
$B!J(BP$B!'%Z!<%8(B $B!a(B $B%U%j!<%j%9%H$N4IM}C10L!K(B reki 91-06-28

$B%O%C%7%eCM$NHO0O$O#0!A#1#2#6$G$"$k!#(B
$B%O%C%7%eCM$r7W;;$9$k;~!"(B
$B#7%S%C%H%^%9%/$N8e!"#1#2#7$@$C$?$i#10z$$$F#1#2#6$K$7$F$$$k!#(B

********************************************************************* PSL **/

#DATA_define  D_WorkFPProfiling1        XXX
#DATA_define  D_WorkFPProfiling2        XXX
#DATA_define  D_WorkFPProfiling3        XXX

#CONST_define _SIZE_OF_FP_PROFILING_HASH_TAB   127
#CONST_define _FP_PROFILING_HASH_MASK 0x7f

#PSL_define  s_FPAllocProfilingHashTab(fp_record)
{

  $USE(D_WorkFPProfiling2);
  p_SetImmediateValue(_SIZE_OF_FP_PROFILING_HASH_TAB,D_WorkFPProfiling2);

  $USE(D_WorkFPProfiling1);
  $CALL(s_AllocLongVect_Sub(D_WorkFPProfiling2,
			    D_WorkFPProfiling1));
  s_PutFPProfilingData(fp_record,D_WorkFPProfiling1);

  $USE(D_WorkFPProfiling3);
  p_SetImmediateWord(ATOM,_MRB_OFF,_ZERO,D_WorkFPProfiling3);
  LOOP(){
    p_Write(D_WorkFPProfiling3,D_WorkFPProfiling1);
    b_IncrementAddrReg(D_WorkFPProfiling1);
    b_DecrementReg(D_WorkFPProfiling2);
    b_IfZero(D_WorkFPProfiling2)break;
  }
  $RELEASE(D_WorkFPProfiling1);
  $RELEASE(D_WorkFPProfiling2);
  $RELEASE(D_WorkFPProfiling3);
  @DEBUG{
    _PrintFPInfoS(fp_record);
    WARNING("s_FPAllocProfilingHashTab","allocate profiling hash table");
  };
}

#PSL_define  s_FPReclaimProfilingHashTab(fp_record)
{
  @DEBUG{
    _PrintFPInfo(fp_record);
    WARNING("s_FPReclaimProfilingHashTab","reclaim profiling hash table");
  };

  $USE(D_WorkFPProfiling1);
  $USE(D_WorkFPProfiling3);
  s_LockFPRecord(fp_record,D_WorkFPProfiling3);
  s_GetFPProfilingData(fp_record,D_WorkFPProfiling1);
  s_PutFPProfilingData(fp_record,D_EOL);
  s_UnlockFPRecord(fp_record, D_WorkFPProfiling3);
  $RELEASE(D_WorkFPProfiling3);

  $USE(D_WorkFPProfiling2);
  p_SetImmediateValue(_SIZE_OF_FP_PROFILING_HASH_TAB,D_WorkFPProfiling2);

  s_ReclaimLongVector(D_WorkFPProfiling2,
		      D_WorkFPProfiling1);
  $RELEASE(D_WorkFPProfiling2);
  $RELEASE(D_WorkFPProfiling1);
}

/* $B%O%C%7%eCM$O%"%I%l%9%*%U%;%C%H$KJQ49$7$F$+$iJV$9(B */
#PSL_define s_FPProfilingHashValue(cod,hash_value){

  $USE(D_WorkFPProfiling1);
  $USE(D_WorkFPProfiling2);
  $USE(D_WorkFPProfiling3);

  s_GetModNameFromCode(cod,D_WorkFPProfiling1);
  s_GetPredNameFromCode(cod,D_WorkFPProfiling2);
  s_GetPredArityFromCode(cod,D_WorkFPProfiling3);

  b_AddWithDNTC(D_WorkFPProfiling1,D_WorkFPProfiling2,D_WorkFPProfiling1);
  $RELEASE(D_WorkFPProfiling2);

  b_AddWithDNTC(D_WorkFPProfiling1,D_WorkFPProfiling3,D_WorkFPProfiling1);
  $RELEASE(D_WorkFPProfiling3);

  b_BitwiseAndImmediateWithDNTC(D_WorkFPProfiling1,
			_FP_PROFILING_HASH_MASK,D_WorkFPProfiling1);

  b_IfEqualImm(D_WorkFPProfiling1,_FP_PROFILING_HASH_MASK){
    b_DecrementReg(D_WorkFPProfiling1);/* size of table is 127, not 128 */
  }

  b_ExchangeElmposToOffset(D_WorkFPProfiling1,hash_value);
  $RELEASE(D_WorkFPProfiling1);
}

/*********************************************

$B%O%C%7%eI=%(%s%H%j$NGSB>@)8f%^%/%m(B

$B%O%C%7%eI=A4BN$N%m%C%/$O@-G=$rCx$7$/Dc2<$5$;$k$N$G$d$a$?!#(B(91/09/26 REKI)

**********************************************/

#ADDR_define _FP_PROFILING_HASH_ENTRY_LOCK_FLAG_OFST 0

#PSL_define s_LockFPProfilingHashEntry(entry,org_data_reg){
  b_SoftLockWithOrgData(entry,
		       _FP_PROFILING_HASH_ENTRY_LOCK_FLAG_OFST,
		       org_data_reg);
}

#PSL_define s_UnlockFPProfilingHashEntry(entry,org_data_reg){
  b_SoftUnlockWithOrgData(entry,
			 _FP_PROFILING_HASH_ENTRY_LOCK_FLAG_OFST,
			 org_data_reg);
}
