
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/structures/str_floating_point.psl.c
   ----- CREATED   : by yamamoto@icot22, on Mon Aug  5 21:53:17 1991
   ----- LAST SAVED: by yamamoto@icot22, on Fri Apr 10 13:50:32 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

#PSL_define s_AllocFLT	(dst_reg){
  b_Alloc2 (dst_reg, FLT);
}

#PSL_define s_ReclaimFLT (src_reg){
  b_Reclaim2 (src_reg);
}

#DATA_define D_WorkFLT_SaveRestore  XXX
#DATA_define D_WorkFLT_SaveRestore2 XXX

#PSL_define s_SaveFPURegOPR(fpureg,posimmopr){
  $USE(D_WorkFLT_SaveRestore2);
  p_MoveImmediateValueFromImmediateField(posimmopr,D_WorkFLT_SaveRestore2);
  $USE(D_WorkFLT_SaveRestore);
  b_ExchangeElmposToOffset(D_WorkFLT_SaveRestore2,D_WorkFLT_SaveRestore);
  $RELEASE(D_WorkFLT_SaveRestore2);
  b_AddWithDNTC(D_KlbRegSaveAreaBase,
	    D_WorkFLT_SaveRestore,D_WorkFLT_SaveRestore);
  s_FPURegWriteDoubleWord(fpureg,D_WorkFLT_SaveRestore);
  $RELEASE(D_WorkFLT_SaveRestore);
}

#PSL_define s_RestoreFPURegOPR(posimmopr,fpureg){
  $USE(D_WorkFLT_SaveRestore2);
  p_MoveImmediateValueFromImmediateField(posimmopr,D_WorkFLT_SaveRestore2);
  $USE(D_WorkFLT_SaveRestore);
  b_ExchangeElmposToOffset(D_WorkFLT_SaveRestore2,D_WorkFLT_SaveRestore);
  $RELEASE(D_WorkFLT_SaveRestore2);
  b_AddWithDNTC(D_KlbRegSaveAreaBase,
	    D_WorkFLT_SaveRestore,D_WorkFLT_SaveRestore);
  s_FPURegReadDoubleWord(D_WorkFLT_SaveRestore,fpureg);
  $RELEASE(D_WorkFLT_SaveRestore);
}

#PSL_define s_FPURegReadDoubleWord(reg,fpureg){
  p_ReadWithOffset(reg,_FLT_MS_OFST,D_FLTWork_MSWord);
  p_ReadWithOffset(reg,_FLT_LS_OFST,D_FLTWork_LSWord);
  p_MoveMSWordToFPU(D_FLTWork_MSWord,fpureg);
  p_MoveLSWordToFPU(D_FLTWork_LSWord,fpureg);
}

#PSL_define s_FPURegWriteDoubleWord(fpureg,reg){
  p_MoveMSWordFromFPU(fpureg,D_FLTWork_MSWord);
  p_MoveLSWordFromFPU(fpureg,D_FLTWork_LSWord);
  b_SetImmTypeMRBoff(INT,D_FLTWork_MSWord);
  b_SetImmTypeMRBoff(INT,D_FLTWork_LSWord);
  p_WriteWithOffset(D_FLTWork_MSWord,reg,_FLT_MS_OFST);
  p_WriteWithOffset(D_FLTWork_LSWord,reg,_FLT_LS_OFST);
}

#PSL_define s_FPURegPutConstant(flt_ms_word_immopr,
				flt_ls_word_immopr,
				fpureg){
  p_MoveImmediateValueFromImmediateField(flt_ms_word_immopr,D_FLTWork_MSWord);
  p_MoveImmediateValueFromImmediateField(flt_ls_word_immopr,D_FLTWork_LSWord);
  p_MoveMSWordToFPU(D_FLTWork_MSWord,fpureg);
  p_MoveLSWordToFPU(D_FLTWork_LSWord,fpureg);

}

/*********************** structures *******************/
/* called from body builtins */
/* include alloc,reuse,reclaim of FLT body */

#DATA_define D_FPU_REG0 32
#DATA_define D_FPU_REG1 34
#DATA_define D_FPU_REG2 36
#DATA_define D_FPU_REG3 38

#PSL_define s_FLT_Add(src1,src2,dst){
  s_FPURegReadDoubleWord(src1,D_FPU_REG0);
  s_FPURegReadDoubleWord(src2,D_FPU_REG1);
  p_FLT_Add(D_FPU_REG0,D_FPU_REG1,D_FPU_REG2);
  s_IfMRBoff(src1){
    p_MoveWord(src1,dst);
    s_IfMRBoff(src2){s_ReclaimFLT(src2);}
    goto L_END;
  }
  s_IfMRBoff(src2){
    p_MoveWord(src2,dst);
    goto L_END;
  }
  s_AllocFLT(dst);
 L_END:
  s_FPURegWriteDoubleWord(D_FPU_REG2,dst);
}

#PSL_define s_FLT_Subtract(src1,src2,dst){
  s_FPURegReadDoubleWord(src1,D_FPU_REG0);
  s_FPURegReadDoubleWord(src2,D_FPU_REG1);
  p_FLT_Subtract(D_FPU_REG0,D_FPU_REG1,D_FPU_REG2);
  s_IfMRBoff(src1){
    p_MoveWord(src1,dst);
    s_IfMRBoff(src2){s_ReclaimFLT(src2);}
    goto L_END;
  }
  s_IfMRBoff(src2){
    p_MoveWord(src2,dst);
    goto L_END;
  }
  s_AllocFLT(dst);
 L_END:
  s_FPURegWriteDoubleWord(D_FPU_REG2,dst);
}

#PSL_define s_FLT_Multiply(src1,src2,dst){
  s_FPURegReadDoubleWord(src1,D_FPU_REG0);
  s_FPURegReadDoubleWord(src2,D_FPU_REG1);
  p_FLT_Multiply(D_FPU_REG0,D_FPU_REG1,D_FPU_REG2);
  s_IfMRBoff(src1){
    p_MoveWord(src1,dst);
    s_IfMRBoff(src2){s_ReclaimFLT(src2);}
    goto L_END;
  }
  s_IfMRBoff(src2){
    p_MoveWord(src2,dst);
    goto L_END;
  }
  s_AllocFLT(dst);
 L_END:
  s_FPURegWriteDoubleWord(D_FPU_REG2,dst);
}

#PSL_define s_FLT_Divide(src1,src2,dst){
  s_FPURegReadDoubleWord(src1,D_FPU_REG0);
  s_FPURegReadDoubleWord(src2,D_FPU_REG1);
  p_FLT_Divide(D_FPU_REG0,D_FPU_REG1,D_FPU_REG2);
  s_IfMRBoff(src1){
    p_MoveWord(src1,dst);
    s_IfMRBoff(src2){s_ReclaimFLT(src2);}
    goto L_END;
  }
  s_IfMRBoff(src2){
    p_MoveWord(src2,dst);
    goto L_END;
  }
  s_AllocFLT(dst);
 L_END:
  s_FPURegWriteDoubleWord(D_FPU_REG2,dst);
}

/* s_FloatingPointToInteger(src,dst) $B$OL5$$!#$+$o$j$K!"(B
 * f_FloatingPointToIntegerAndCheckOverFlowException(src,dst)
 * $B$,M-$k!#(B
 */

#PSL_define s_IntegerToFloatingPoint(src,dst){
  s_AllocFLT(dst);
  p_IntegerToFloatingPoint(src,D_FPU_REG0);
  s_FPURegWriteDoubleWord(D_FPU_REG0,dst);
}

#PSL_define s_FloatingPointToBinary(src,dst1,dst2){
  b_ReadFLTMSWord(src,dst1);
  b_ReadFLTLSWord(src,dst2);
  s_IfMRBoff(src){s_ReclaimFLT(src);}
}

#PSL_define s_BinaryToFloatingPoint(src1,src2,dst){
  s_AllocFLT(dst);
  b_WriteFLTMSWord(src1,dst);
  b_WriteFLTLSWord(src2,dst);
}

/* these constant definitions are shared with KL1 macros */
/***************************************************************	
	$B#I#E#E#E$N%/%i%9%A%'%C%/$r9T$J$&(B
	$BJV$5$l$kCM!J(BINT$B!K$O0J2<DL$j!#(B

 39     31         7   6   5   4   3   2   1   0     $B%S%C%H0LCV(B
 +-----+---------+---+---+---+---+---+---+---+---+
 | INT |         |   |   |   |   |   |   |   |   |
 +-----+---------+---+---+---+---+---+---+---+---+   $B%/%i%9(B
		   |           |   |   |   |   |     
		   |           |   |   |   |   +---  $B@55,2=?t(B
		   |           |   |   |   +-------  $B%<%m(B
		   |           |   |   +-----------  $BHs@55,2=?t(B
		   |           |   +---------------  $BL58BBg(B
		   |           +-------------------  $BHs?t(B
		   | 
		   |
		   +-------------------------------  $BId9g(B
******************************************************************/

                                     /* E = biased exponent, F = fraction */
#CONST_define _FLT_NORM      0x1     /* 0 < E < 2047     $B@55,2=?t(B */
#CONST_define _FLT_ZERO      0x2     /* E = 0, F = 0     $B%<%m(B     */
#CONST_define _FLT_DENORM    0x4     /* E = 0, F != 0    $BHs@55,2=?t(B */
#CONST_define _FLT_INF       0x8     /* E = 2047, F = 0  $BL58BBg(B */
#CONST_define _FLT_NAN      0x10     /* E = 2047, F != 0 $BHs?t(B */
#CONST_define _FLT_SIGNBIT  0x80     /* $BId9f(B */
#CONST_define _MASK_EXPONENT      0x7ff00000
#CONST_define _MASK_FRACTION      0x000fffff
#CONST_define _BIT_POS_EXPONENT 20
#CONST_define _NUM_EXPONENT 2047

#DATA_define D_WorkOddReg XXX
#DATA_define D_WorkEvenReg XXX
#DATA_define D_WorkFLTSign XXX
#DATA_define D_WorkExponent XXX

#PSL_define  s_GetTypeOfFloatingPoint(fpu_reg,reg){
  b_SetImmTypeValueMRBoff(INT,_FLT_NORM,reg);/**** dummy for pim/s ****/
/*_GetTypeOfFloatingPoint(fpureg,reg); */
/* $B0J2<$O!"(BPIM/p $BMQ(B by f-morita  
  $DW_USE(D_WorkFLTDoubleWord); 
<* PIM/p $B$N(B PSL $B$G$O(B DoubleWord $B$N(B WorkRegister $B$,5-=R$G$-$k(B *>
  $USE(D_WorkOddReg);    
  $USE(D_WorkEvenReg); 
  $USE(D_WorkFLTSign);  
  $USE(D_WorkExponent);
  p_MoveDoubleWordFromFPU(fpu_reg, D_WorkFLTDoubleWord);
  p_GetEvenFromDW(D_WorkFLTDoubleWord, D_WorkEvenReg);
  p_GetOddFromDW(D_WorkFLTDoubleWord, D_WorkOddReg);  <* $B>e2<0L$KJ,$1$k(B*>
  $DW_RELEASE(D_WorkFLTDoubleWord);
  b_IfGreaterEq(D_WorkEvenReg, D_NULL){  <* $BId9f$N@5Ii$r8+$k(B  *>
    p_SetImmediateValue(_ZERO, D_WorkFLTSign);  <* $BId9f$O%<%m(B *>
  }else{  <* $BId9f$OIi(B *>
    p_SetImmediateValue(_FLT_SIGNBIT, D_WorkFLTSign); <*$BId9f%S%C%H$rN)$F$k(B*>
  }  <* E$B$NItJ,$r<h$j=P$9(B *>
  b_BitwiseAndImmediateWithDNTC(D_WorkEvenReg, _MASK_EXPONENT, D_WorkExponent);
  b_ShiftRightImmediate(D_WorkExponent, _BIT_POS_EXPONENT, D_WorkExponent);
  b_IfNotZero(D_WorkExponent){  <* E != 0 *>
    b_IfNotEqualImm(D_WorkExponent, _NUM_EXPONENT){   <* E != 2047 *>
      b_SetImmValueDNTC(_FLT_NORM, reg);  <* reg$B$O@55,2=?t(B *>
    }else{  <* E = 2047 *>
      b_IfNotZero(D_WorkOddReg){  <* F != 0 *>
	b_SetImmValueDNTC(_FLT_NAN, reg);  <* reg$B$OHs?t(B*>
      }else{  <* F = 0$B$@$,!"(BD_WorkEvenReg$B$N2<(B20$B7e$,(B0$B$+$I$&$+$N%A%'%C%/(B  *>
	b_BitwiseAndImmediateWithDNTC(D_WorkEvenReg, _MASK_FRACTION, 
				      D_WorkEvenReg);
	b_IfZero(D_WorkEvenReg){  <* $B2<(B20$B7e$b(B0$B$,3NDj(B *>
	  b_SetImmValueDNTC(_FLT_INF, reg);  <* reg$B$OL58BBg(B*>
	}else{  <* E = 2047, F != 0($B2<(B20$B7e$,(B0$B$G$J$$$+$i(B) *>
	  b_SetImmValueDNTC(_FLT_NAN, reg);  <* reg$B$OHs?t(B*>
	}
      }
    }
  }else{ <* E = 0 *>
    b_IfNotZero(D_WorkOddReg){<* F != 0 *>
      b_SetImmValueDNTC(_FLT_DENORM, reg);  <* reg$B$OHs@55,2=?t(B*>
    }else{ <* E = 0, F = 0$B$@$,!"(BD_WorkEvenReg$B$N2<(B20$B7e$,(B0$B$+$I$&$+$N%A%'%C%/(B *>
      b_IfZero(D_WorkEvenReg){ <* $B2<(B20$B7e$b(B0$B$,3NDj(B *>
	b_SetImmValueDNTC(_FLT_ZERO, reg);         <* reg$B$O%<%m(B *>
      }else{ <* E = 0, F != 0($B2<(B20$B7e$,(B0$B$G$J$$$+$i(B) *>
	b_SetImmValueDNTC(_FLT_DENORM, reg);  <* reg$B$OHs@55,2=?t(B*>
      }
    }
  }
  b_BitwiseOrWithDNTC(D_WorkFLTSign, reg, reg);  <* $BId9f$r=q$-9~$`(B *>
  b_SetImmTypeMRBoff(INT, reg);
  $RELEASE(D_WorkExponent);
  $RELEASE(D_WorkFLTSign);
  $RELEASE(D_WorkEvenReg);
  $RELEASE(D_WorkOddReg);
*/
}
