
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/structures/str_env_record.psl.c
   ----- CREATED   : by imai@icot22, on Wed Dec  5 11:58:06 1990
   ----- LAST SAVED: by imai@galileo, on Mon May 11 13:11:45 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     :
   ----- ABSTRACT  : $B%4!<%k%l%3!<%I$+$i;X$5$l$k4D6-%l%3!<%I$NDj5A$HA`:n(B 

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

#DATA_define D_CurrentEnvRecPtr	XXX	/* $B%Q!<%^%M%s%H%l%8%9%?(B */
#DATA_define D_WorkEnvRecPtr	XXX
#DATA_define D_WorkModule	XXX

#CONST_define _NON_DEBUG_ENV_REC_TYPE		VECT2
#CONST_define _TRACE_ENV_REC_TYPE		VECT3
#CONST_define _ORIGINAL_CODE_INFO_ENV_REC_TYPE	VECT4
#CONST_define _CALLER_CODE_INFO_ENV_REC_TYPE	VECT6
#CONST_define _SPY_ENV_REC_TYPE			VECT8

#CONST_define _RESIDENT_PE 2
#CONST_define _RESIDENT_CLUSTER 1
#CONST_define _EMIGRANT_CLUSTER 0

#ADDR_define	_PRIORITY_OFST_ENV_REC			0
#ADDR_define	_ATTRIBUTE_OFST_ENV_REC			1
#ADDR_define	_TRACE_ID_OFST_ENV_REC			2	/* $B7sMQ(B */
#ADDR_define	_ORIGINAL_MODULE_PTR_OFST_ENV_REC	2	/* $B7sMQ(B */
#ADDR_define	_ORIGINAL_MODULE_OFST_OFST_ENV_REC	3
#ADDR_define	_CALLER_MODULE_PTR_OFST_ENV_REC		4
#ADDR_define	_CALLER_MODULE_OFST_OFST_ENV_REC	5
#ADDR_define	_SPY_ID_OFST_ENV_REC			6
#ADDR_define	_SPY_TABLE_PTR_OFST_ENV_REC		7

/******************************************************************** PSL **

       written by imai@icot22      on Tue Dec  4 20:31:06 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define s_AllocNonDebugEnvRecord ( ptr_to_envrec )
{
  s_AllocVect2( ptr_to_envrec );
  s_MRBonReg( ptr_to_envrec );
}

#PSL_define s_AllocOriginalInfoEnvRecord ( ptr_to_envrec )
{
  s_AllocVect4( ptr_to_envrec );
  /* s_MRBoffReg( ptr_to_envrec ); */

  s_MRBonReg( ptr_to_envrec );
/* $BAq1`%W%m%U%!%$%k$GD>@\%f!<%6$K8+$;$k2DG=@-$,$"$k$N$G9u$/$9$k$3$H$K$7$?!#(B*/
/* 91-11-01 yamamoto */
}

#PSL_define s_AllocCallerInfoEnvRecord ( ptr_to_envrec )
{
  s_AllocVect6( ptr_to_envrec );
  s_MRBonReg( ptr_to_envrec );
}

#PSL_define s_AllocTraceEnvRecord ( ptr_to_envrec )
{
  s_AllocVect3( ptr_to_envrec );
  /* s_MRBoffReg( ptr_to_envrec ); */

  s_MRBonReg( ptr_to_envrec );
/* $BAq1`%W%m%U%!%$%k$GD>@\%f!<%6$K8+$;$k2DG=@-$,$"$k$N$G9u$/$9$k$3$H$K$7$?!#(B*/
/* 91-11-01 yamamoto */
}

#PSL_define s_AllocSpyingEnvRecord ( ptr_to_envrec )
{
  s_AllocVect8( ptr_to_envrec );
  s_MRBonReg( ptr_to_envrec );
}

/******************************************************************** PSL **
  $B4D6-%l%3!<%I$N3F%9%m%C%H$N%"%/%;%9(B

       written by imai@icot22      on Tue Dec  4 20:31:15 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

/*---  $B%W%i%$%*%j%F%#(B ---*/

#PSL_define s_GetPriorityEnvRecord( ptr_to_envrec, logical_prio_reg )
{
  @DEBUG{	/*--- $B8F$S$@$7>r7o(B ---*/
    s_IfNotShortVectors( ptr_to_envrec) {
      VPIM_ERROR("s_GetPriorityEnvRecord","Not VECT ptr_to_envrec");
    }
  };
  p_ReadWithOffset( ptr_to_envrec, _PRIORITY_OFST_ENV_REC, logical_prio_reg );
  @DEBUG{
    s_IfNotINT( logical_prio_reg ) {
      VPIM_ERROR("s_GetPriorityEnvRecord","Not INT logical_prio_reg");
    }
  };
}

#PSL_define s_PutPriorityEnvRecord( ptr_to_envrec, logical_prio_reg )
{
  @DEBUG{
    s_IfNotShortVectors( ptr_to_envrec) {
      VPIM_ERROR("s_PutPriorityEnvRecord","Not VECT ptr_to_envrec");
    }
    s_IfNotINT(logical_prio_reg) {
      VPIM_ERROR("s_PutPriorityEnvRecord","Not INT logical_prio_reg");
    }
  };
  p_WriteWithOffset( logical_prio_reg, ptr_to_envrec, _PRIORITY_OFST_ENV_REC );
}

/*-- $B%4!<%kB0@-(B --*/

#PSL_define s_GetAttributeEnvRecord( ptr_to_envrec, attribute_reg )
{
  @DEBUG{
    s_IfNotShortVectors( ptr_to_envrec) {
      VPIM_ERROR("s_GetAttributeEnvRecord","Not VECT ptr_to_envrec");
    }
  };
  p_ReadWithOffset( ptr_to_envrec, _ATTRIBUTE_OFST_ENV_REC, attribute_reg );
  @DEBUG{
    s_IfNotINT(attribute_reg) {
      VPIM_ERROR("s_GetAttributeEnvRecord","Not INT attribute_reg");
    }
  };
}

#PSL_define s_PutAttributeEnvRecord( ptr_to_envrec, attribute_reg )
{
  @DEBUG{
    s_IfNotShortVectors( ptr_to_envrec) {
      VPIM_ERROR("s_PutAttributeEnvRecord","Not VECT ptr_to_envrec");
    }
    s_IfNotINT(attribute_reg) {
      VPIM_ERROR("s_PutAttributeEnvRecord","Not INT attribute_reg");
    }
  };
  p_WriteWithOffset( attribute_reg, ptr_to_envrec, _ATTRIBUTE_OFST_ENV_REC );
}

#PSL_define s_PutImmAttributeEnvRecord( ptr_to_envrec, imm_attr )
{
  @DEBUG{
    s_IfNotShortVectors( ptr_to_envrec) {
      VPIM_ERROR("s_PutAttributeEnvRecord","Not VECT ptr_to_envrec");
    }
  };
  $USE(D_WorkAttribute);
  b_SetImmTypeValueMRBoff(INT,imm_attr,D_WorkAttribute);
  p_WriteWithOffset( D_WorkAttribute, ptr_to_envrec, _ATTRIBUTE_OFST_ENV_REC );
  $RELEASE(D_WorkAttribute);
}

#PSL_define s_PutResidentPEAttrEnvRecord( ptr_to_envrec )
{
  $USE(D_WorkAttribute);
  b_SetImmTypeValueMRBoff(INT,_RESIDENT_PE,D_WorkAttribute);
  s_PutAttributeEnvRecord( ptr_to_envrec, D_WorkAttribute);
  $RELEASE(D_WorkAttribute);
}

#PSL_define s_PutResidentClusterAttrEnvRecord( ptr_to_envrec )
{
  $USE(D_WorkAttribute);
  b_SetImmTypeValueMRBoff(INT,_RESIDENT_CLUSTER,D_WorkAttribute);
  s_PutAttributeEnvRecord( ptr_to_envrec, D_WorkAttribute);
  $RELEASE(D_WorkAttribute);
}

#PSL_define s_PutEmigrantClusterEnvRecord( ptr_to_envrec )
{
  $USE(D_WorkAttribute);
  b_SetImmTypeValueMRBoff(INT,_EMIGRANT_CLUSTER,D_WorkAttribute);
  s_PutAttributeEnvRecord( ptr_to_envrec, D_WorkAttribute);
  $RELEASE(D_WorkAttribute);
}

#CTRL_define s_IfResidentPEAttrEnvRecord( ptr_to_envrec )
{
  $USE(D_WorkAttribute);
  s_GetAttributeEnvRecord( ptr_to_envrec, D_WorkAttribute );
  p_CompareImmediate( D_WorkAttribute, _RESIDENT_PE );
  $RELEASE(D_WorkAttribute);
  p_IfEQ()
}

#CTRL_define s_IfNotResidentPEAttrEnvRecord( ptr_to_envrec )
{
  $USE(D_WorkAttribute);
  s_GetAttributeEnvRecord( ptr_to_envrec, D_WorkAttribute );
  p_CompareImmediate( D_WorkAttribute, _RESIDENT_PE );
  $RELEASE(D_WorkAttribute);
  p_IfNE()
}

#CTRL_define s_IfResidentClusterAttrEnvRecord( ptr_to_envrec )
{
  $USE(D_WorkAttribute);
  s_GetAttributeEnvRecord( ptr_to_envrec, D_WorkAttribute );
  p_CompareImmediate( D_WorkAttribute, _RESIDENT_CLUSTER );
  $RELEASE(D_WorkAttribute);
  p_IfEQ()
}

#CTRL_define s_IfNotResidentClusterAttrEnvRecord( ptr_to_envrec )
{
  $USE(D_WorkAttribute);
  s_GetAttributeEnvRecord( ptr_to_envrec, D_WorkAttribute );
  p_CompareImmediate( D_WorkAttribute, _RESIDENT_CLUSTER );
  $RELEASE(D_WorkAttribute);
  p_IfNE()
}

#CTRL_define s_IfEmigrantClusterAttrEnvRecord( ptr_to_envrec )
{
  $USE(D_WorkAttribute);
  s_GetAttributeEnvRecord( ptr_to_envrec, D_WorkAttribute );
  p_CompareImmediate( D_WorkAttribute, _EMIGRANT_CLUSTER );
  $RELEASE(D_WorkAttribute);
  p_IfEQ()
}

#CTRL_define s_IfNotEmigrantClusterAttrEnvRecord( ptr_to_envrec )
{
  $USE(D_WorkAttribute);
  s_GetAttributeEnvRecord( ptr_to_envrec, D_WorkAttribute );
  p_CompareImmediate( D_WorkAttribute, _EMIGRANT_CLUSTER );
  $RELEASE(D_WorkAttribute);
  p_IfNE()
}

#CTRL_define s_IfCurrentInResidentPE()
{
  s_IfResidentPEAttrEnvRecord(D_CurrentEnvRecPtr)
}

#CTRL_define s_IfCurrentInResidentCluster()
{
  s_IfResidentClusterAttrEnvRecord(D_CurrentEnvRecPtr)
}

#CTRL_define s_IfCurrentInEmigrantCluster()
{
  s_IfEmigrantClusterAttrEnvRecord(D_CurrentEnvRecPtr)
}

/*--- $B%H%l!<%9#I#D(B ---*/

#PSL_define s_GetTraceIdEnvRecord( ptr_to_envrec, trace_id_reg )
{
  @DEBUG{
    s_IfNotVECT3( ptr_to_envrec) {
      VPIM_ERROR("s_GetTraceIdEnvRecord","Not VECT ptr_to_envrec");
    }
  };
  p_ReadWithOffset( ptr_to_envrec, _TRACE_ID_OFST_ENV_REC, trace_id_reg );
  
}

#PSL_define s_PutTraceIdEnvRecord( ptr_to_envrec, trace_id_reg )
{
  @DEBUG{ s_IfNotVECT3( ptr_to_envrec) {
    VPIM_ERROR("s_PutTraceIdEnvRecord","Not VECT ptr_to_envrec");
  }};
  p_WriteWithOffset( trace_id_reg, ptr_to_envrec, _TRACE_ID_OFST_ENV_REC );
}

/*--- $B%*%j%8%J%k%4!<%k$N%b%8%e!<%k(B ---*/

#PSL_define s_GetOriginalModulePtrEnvRecord( ptr_to_envrec, mod_ptr )
{
  @DEBUG{
    s_IfNotShortVectors( ptr_to_envrec) {
      VPIM_ERROR("s_GetOriginalModulePtrEnvRecord","Not VECT ptr_to_envrec");
    }
  };
  p_ReadWithOffset
    ( ptr_to_envrec, _ORIGINAL_MODULE_PTR_OFST_ENV_REC, mod_ptr );
  
}

#PSL_define s_PutOriginalModulePtrEnvRecord( ptr_to_envrec, mod_ptr )
{
  @DEBUG{ s_IfNotShortVectors( ptr_to_envrec) {
    VPIM_ERROR("s_PutOriginalModulePtrEnvRecord","Not VECT ptr_to_envrec");
  }};
  p_WriteWithOffset
    ( mod_ptr, ptr_to_envrec, _ORIGINAL_MODULE_PTR_OFST_ENV_REC);
}

/*--- $B%*%j%8%J%k%4!<%k$N%b%8%e!<%kFb$G$N%*%U%;%C%H(B ---*/

#PSL_define s_GetOriginalModuleOfstEnvRecord( ptr_to_envrec, ofst_reg )
{
  @DEBUG{
    s_IfNotShortVectors( ptr_to_envrec) {
      VPIM_ERROR("s_GetOriginalModuleOfstEnvRecord","Not VECT ptr_to_envrec");
    }
  };
  p_ReadWithOffset( ptr_to_envrec, _ORIGINAL_MODULE_OFST_OFST_ENV_REC, ofst_reg );
  
}

#PSL_define s_PutOriginalModuleOfstEnvRecord( ptr_to_envrec, ofst_reg )
{
  @DEBUG{ s_IfNotShortVectors( ptr_to_envrec) {
    VPIM_ERROR("s_PutOriginalModuleOfstEnvRecord","Not VECT ptr_to_envrec");
  }};
  p_WriteWithOffset( ofst_reg, ptr_to_envrec, _ORIGINAL_MODULE_OFST_OFST_ENV_REC);
}

/*--- $B8F$S$@$785$N%b%8%e!<%k(B ---*/

#PSL_define s_GetCallerModulePtrEnvRecord( ptr_to_envrec, mod_ptr )
{
  @DEBUG{
    s_IfNotShortVectors( ptr_to_envrec) {
      VPIM_ERROR("s_GetCallerModulePtrEnvRecord","Not VECT ptr_to_envrec");
    }
  };
  p_ReadWithOffset
    ( ptr_to_envrec, _CALLER_MODULE_PTR_OFST_ENV_REC, mod_ptr );
  
}

#PSL_define s_PutCallerModulePtrEnvRecord( ptr_to_envrec, mod_ptr )
{
  @DEBUG{ s_IfNotShortVectors( ptr_to_envrec) {
    VPIM_ERROR("s_PutCallerModulePtrEnvRecord","Not VECT ptr_to_envrec");
  }};
  p_WriteWithOffset
    ( mod_ptr, ptr_to_envrec, _CALLER_MODULE_PTR_OFST_ENV_REC);
}

/*--- $B8F$S$@$785$N%b%8%e!<%kFb$G$N%*%U%;%C%H(B ---*/

#PSL_define s_GetCallerModuleOfstEnvRecord( ptr_to_envrec, ofst_reg )
{
  @DEBUG{
    s_IfNotShortVectors( ptr_to_envrec) {
      VPIM_ERROR("s_GetCallerModuleOfstEnvRecord","Not VECT ptr_to_envrec");
    }
  };
  p_ReadWithOffset( ptr_to_envrec, _CALLER_MODULE_OFST_OFST_ENV_REC, ofst_reg );
  
}

#PSL_define s_PutCallerModuleOfstEnvRecord( ptr_to_envrec, ofst_reg )
{
  @DEBUG{ s_IfNotShortVectors( ptr_to_envrec) {
    VPIM_ERROR("s_PutCallerModuleOfstEnvRecord","Not VECT ptr_to_envrec");
  }};
  p_WriteWithOffset( ofst_reg, ptr_to_envrec, _CALLER_MODULE_OFST_OFST_ENV_REC );
}

/*--- $B%9%Q%$#I#D(B ---*/

#PSL_define s_GetSpyIdEnvRecord( ptr_to_envrec, spy_id_reg )
{
  @DEBUG{
    s_IfNotVECT8( ptr_to_envrec) {
      VPIM_ERROR("s_GetSpyIdEnvRecord","Not VECT8 ptr_to_envrec");
    }
  };
  p_ReadWithOffset( ptr_to_envrec, _SPY_ID_OFST_ENV_REC, spy_id_reg );
  
}

#PSL_define s_PutSpyIdEnvRecord( ptr_to_envrec, spy_id_reg )
{
  @DEBUG{ s_IfNotVECT8( ptr_to_envrec) {
    VPIM_ERROR("s_PutSpyIdEnvRecord","Not VECT8 ptr_to_envrec");
  }};
  p_WriteWithOffset( spy_id_reg, ptr_to_envrec, _SPY_ID_OFST_ENV_REC );
}

/*--- $B%9%Q%$BP>]I=$X$N%]%$%s%?(B ---*/

#PSL_define s_GetSpyTablePtrEnvRecord( ptr_to_envrec, spy_table_ptr )
{
  @DEBUG{
    s_IfNotVECT8( ptr_to_envrec) {
      VPIM_ERROR("s_GetSpyTableEnvRecord","Not VECT8 ptr_to_envrec");
    }
  };
  p_ReadWithOffset( ptr_to_envrec, _SPY_TABLE_PTR_OFST_ENV_REC, spy_table_ptr );
  @DEBUG{
    s_IfNotVectors( spy_table_ptr ) {
      VPIM_ERROR("s_GetSpyTableEnvRecord","Not vector ptr_to_envrec");
    }
  };
}

#PSL_define s_GetSpyTablePtrEnvRecordWithMark( ptr_to_envrec, spy_table_ptr )
{
  @DEBUG{
    s_IfNotVECT8( ptr_to_envrec) {
      VPIM_ERROR("s_GetSpyTableEnvRecord","Not VECT8 ptr_to_envrec");
    }
  };
  p_ReadWithOffset(ptr_to_envrec,_SPY_TABLE_PTR_OFST_ENV_REC,spy_table_ptr);
  s_MRBonReg(spy_table_ptr);
  p_WriteWithOffset(spy_table_ptr,ptr_to_envrec,_SPY_TABLE_PTR_OFST_ENV_REC);
  @DEBUG{
    s_IfNotVectors( spy_table_ptr ) {
      VPIM_ERROR("s_GetSpyTableEnvRecord","Not vector ptr_to_envrec");
    }
  };
}

#PSL_define s_PutSpyTablePtrEnvRecord( ptr_to_envrec, spy_table_ptr )
{
  @DEBUG{
    s_IfNotVECT8( ptr_to_envrec) {
      VPIM_ERROR("s_PutSpyTablePtrEnvRecord","Not VECT8 ptr_to_envrec");
    }
    s_IfNotVectors( spy_table_ptr ) {
      VPIM_ERROR("s_PutSpyTablePtrEnvRecord","Not vector spy_table_ptr");
    }
  };
  p_WriteWithOffset( spy_table_ptr, ptr_to_envrec,_SPY_TABLE_PTR_OFST_ENV_REC);
}


/******************************************************************** PSL **
  $B5l>pJs$N%3%T!<!"?7%9%m%C%H$N=i4|2=$J$I$N;(4X?t(B
       written by imai@icot22      on Wed Dec 26 12:02:49 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  s_CopyPrioAndAttrEnvRecord :
	$B%W%i%$%*%j%F%#$HB0@-$r%3%T!<$9$k(B
  s_CopyOriginalAndCallerEnvRecord : 
	$B%*%j%8%J%k$H8F=P85>pJs$r%3%T!<$9$k(B
  s_CopyOriginalEnvRecord : 
	$B%*%j%8%J%k>pJs$r%3%T!<$9$k(B
  s_CopyCallerEnvRecord : 
	$B8F$S$@$785>pJs$r%3%T!<$9$k(B
  s_InvalidateOriginalAndCallerEnvRecord : 
	$B%*%j%8%J%k$H8F=P85>pJs$r(B ATOM!0 ($B;HMQ$7$F$$$J$$(B) $B$K=i4|2=$9$k(B
<Examples>
<Test>
<Explanation>
	$B4D6-%l%3!<%I$N%5%$%:$O0[$J$C$F$$$F$b9=$o$J$$(B
<ETC>
********************************************************************* PSL **/


#DATA_define D_WorkOldValue	XXX

#PSL_define s_CopyPrioAndAttrEnvRecord( old_env_rec, new_env_rec )
{
  /* $B%l%8%9%?$,K-IY$K$"$k%Q%$%W%i%$%s%^%7%s$G$O!"(B
    $BL?Na=g=x$NCV49$($,E,Ev$+$H;W$$$^$9!#%O%$!#(B
   */
  s_CopyPriorityEnvRecord( old_env_rec, new_env_rec );
  s_CopyAttributeEnvRecord( old_env_rec, new_env_rec );
}

#PSL_define s_CopyPriorityEnvRecord( old_env_rec, new_env_rec )
{
  $USE(D_WorkOldValue);
  s_GetPriorityEnvRecord(old_env_rec, D_WorkOldValue);
  s_PutPriorityEnvRecord(new_env_rec, D_WorkOldValue);
  $RELEASE(D_WorkOldValue);
}

#PSL_define s_CopyAttributeEnvRecord( old_env_rec, new_env_rec )
{
  $USE(D_WorkOldValue);
  s_GetAttributeEnvRecord(old_env_rec, D_WorkOldValue);
  s_PutAttributeEnvRecord(new_env_rec, D_WorkOldValue);
  $RELEASE(D_WorkOldValue);
}

#PSL_define	s_CopyOriginalAndCallerEnvRecord( old_env_rec, new_env_rec )
{
  s_CopyOriginalEnvRecord( old_env_rec, new_env_rec );
  s_CopyCallerEnvRecord( old_env_rec, new_env_rec );
}

#PSL_define	s_CopyOriginalEnvRecord( old_env_rec, new_env_rec )
{
  /* $B%l%8%9%?$,K-IY$K$"$k%Q%$%W%i%$%s%^%7%s$G$O!"(B
    $BL?Na=g=x$NCV49$($,E,Ev$+$H;W$$$^$9!#%O%$!#(B
   */
  @DEBUG{
    TypeSwitch(old_env_rec) {
    case _ORIGINAL_CODE_INFO_ENV_REC_TYPE:
    case _CALLER_CODE_INFO_ENV_REC_TYPE:
    case _SPY_ENV_REC_TYPE:	break;
    default:
      VPIM_ERROR("s_CopyOriginalEnvRecord","Illegal Type old_env_rec");
    }
  };
  $USE(D_WorkOldValue);
  s_GetOriginalModulePtrEnvRecord( old_env_rec, D_WorkOldValue );
  s_PutOriginalModulePtrEnvRecord( new_env_rec, D_WorkOldValue );
  s_GetOriginalModuleOfstEnvRecord( old_env_rec, D_WorkOldValue );
  s_PutOriginalModuleOfstEnvRecord( new_env_rec, D_WorkOldValue );
  $RELEASE(D_WorkOldValue);
}

#PSL_define	s_CopyCallerEnvRecord( old_env_rec, new_env_rec )
{
  /* $B%l%8%9%?$,K-IY$K$"$k%Q%$%W%i%$%s%^%7%s$G$O!"(B
    $BL?Na=g=x$NCV49$($,E,Ev$+$H;W$$$^$9!#%O%$!#(B
   */
  @DEBUG{
    TypeSwitch(old_env_rec) {
    case _CALLER_CODE_INFO_ENV_REC_TYPE:
    case _SPY_ENV_REC_TYPE:	break;
    default:
      VPIM_ERROR("s_CopyCallerEnvRecord","Illegal Type old_env_rec");
    }
  };
  $USE(D_WorkOldValue);
  s_GetCallerModulePtrEnvRecord( old_env_rec, D_WorkOldValue );
  s_PutCallerModulePtrEnvRecord( new_env_rec, D_WorkOldValue );
  s_GetCallerModuleOfstEnvRecord( old_env_rec, D_WorkOldValue );
  s_PutCallerModuleOfstEnvRecord( new_env_rec, D_WorkOldValue );
  $RELEASE(D_WorkOldValue);
}

#PSL_define   s_CopySpyIdAndTablePtrEnvRecord( old_env_rec, new_env_rec )
{
  /* $B%l%8%9%?$,K-IY$K$"$k%Q%$%W%i%$%s%^%7%s$G$O!"(B
    $BL?Na=g=x$NCV49$($,E,Ev$+$H;W$$$^$9!#%O%$!#(B
   */
  @DEBUG{
    TypeSwitch(old_env_rec) {
    case _SPY_ENV_REC_TYPE:	break;
    default:
      VPIM_ERROR("s_CopySpyIdAndTablePtrEnvRecord","Illegal Type old_env_rec");
    }
  };
  $USE(D_WorkOldValue);
  s_GetSpyIdEnvRecord( old_env_rec, D_WorkOldValue );
  s_PutSpyIdEnvRecord( new_env_rec, D_WorkOldValue );
  s_GetSpyTablePtrEnvRecord( old_env_rec, D_WorkOldValue );
  s_PutSpyTablePtrEnvRecord( new_env_rec, D_WorkOldValue );
  $RELEASE(D_WorkOldValue);
}

#PSL_define   s_InvalidateOriginalAndCallerEnvRecord( env_rec_ptr )
{
  s_InvalidateOriginalEnvRecord( env_rec_ptr );
  s_InvalidateCallerEnvRecord( env_rec_ptr );
}

#PSL_define   s_InvalidateOriginalEnvRecord( env_rec_ptr )
{
  @DEBUG{
    TypeSwitch(env_rec_ptr) {
    case _ORIGINAL_CODE_INFO_ENV_REC_TYPE:
    case _CALLER_CODE_INFO_ENV_REC_TYPE:
    case _SPY_ENV_REC_TYPE:	break;
    default:
      VPIM_ERROR("s_InvalidateOriginalEnvRecord",
		 "Illegal Type env_rec_ptr");
    }
  };
  $USE(D_WorkNIL);
  b_MoveWithImmTypeMRBoff( D_NULL, ATOM, D_WorkNIL );
  s_PutOriginalModulePtrEnvRecord(env_rec_ptr, D_WorkNIL );
  s_PutOriginalModuleOfstEnvRecord( env_rec_ptr, D_WorkNIL );
  $RELEASE(D_WorkNIL);
}

#PSL_define   s_InvalidateCallerEnvRecord( env_rec_ptr )
{
  @DEBUG{
    TypeSwitch(env_rec_ptr) {
    case _CALLER_CODE_INFO_ENV_REC_TYPE:
    case _SPY_ENV_REC_TYPE:	break;
    default:
      VPIM_ERROR("s_InvalidateCallerEnvRecord",
		 "Illegal Type env_rec_ptr");
    }
  };
  $USE(D_WorkNIL);
  b_MoveWithImmTypeMRBoff( D_NULL, ATOM, D_WorkNIL );
  s_PutCallerModulePtrEnvRecord(env_rec_ptr, D_WorkNIL );
  s_PutCallerModuleOfstEnvRecord( env_rec_ptr, D_WorkNIL );
  $RELEASE(D_WorkNIL);
}

#CTRL_define s_IfValidOriginalInfo( env_rec_ptr )
{
  $USE(D_WorkElement);
  s_GetOriginalModulePtrEnvRecord( env_rec_ptr, D_WorkElement );
  p_Compare( D_WorkElement, D_NULL );
  $RELEASE(D_WorkElement);
  p_IfNE()
}

#CTRL_define s_IfValidCallerInfo( env_rec_ptr )
{
  $USE(D_WorkElement);
  s_GetCallerModulePtrEnvRecord( env_rec_ptr, D_WorkElement );
  p_Compare( D_WorkElement, D_NULL );
  $RELEASE(D_WorkElement);
  p_IfNE()
}

#PSL_define s_CreateSameEnvRecFromMerger(src_ptr_to_merger,dst_env_rec_ptr)
{
  $USE(D_WorkAttribute);
  s_AllocNonDebugEnvRecord(dst_env_rec_ptr);
  s_GetMergerAttribute(src_ptr_to_merger,D_WorkAttribute);
  s_PutAttributeEnvRecord(dst_env_rec_ptr,D_WorkAttribute);
  s_GetMergerPriority(src_ptr_to_merger,D_WorkAttribute);
  s_PutPriorityEnvRecord(dst_env_rec_ptr,D_WorkAttribute);
  $RELEASE(D_WorkAttribute);
}
