
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V10/structures/str_byte_acc.psl.c
   ----- CREATED   : by f-doumae@icot22, on Wed Nov 14 15:41:24 1990
   ----- LAST SAVED: by f-takei@icot22, on Thu Mar 28 16:56:49 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 

s_ReadByteData(string_ptr, pos_reg, dst_reg)
s_WriteByteData(src_reg, string_ptr, pos_reg)
s_ScsiTargetSendData(data_buf_reg, data_ptr_reg, data_len_reg)
s_ScsiTargetReceiveData(data_buf_reg, data_ptr_reg, data_len_reg)
s_ScsiInitiatorSendData(data_buf_reg, data_ptr_reg, data_len_reg)
s_ScsiInitiatorReceiveData(data_buf_reg, data_ptr_reg)

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */
#PSL_define s_ReadByteData(string_ptr, pos_reg, dst_reg)
{
  $USE(D_WorkElemSize);
  b_SetImmValueDNTC(_ELEM_SIZE_OF_STRG8, D_WorkElemSize);
  s_GetStringElement(string_ptr, pos_reg, D_WorkElemSize, dst_reg);
  $RELEASE(D_WorkElemSize);
}

#PSL_define s_WriteByteData(src_reg, string_ptr, pos_reg)
{
  $USE(D_WorkElemSize);
  b_SetImmValueDNTC(_ELEM_SIZE_OF_STRG8, D_WorkElemSize);
  s_PutStringElement(string_ptr, pos_reg, D_WorkElemSize, src_reg);
  $RELEASE(D_WorkElemSize);
}

#PSL_define s_ScsiTargetSendData(data_buf_reg, data_ptr_reg, data_len_reg)
{
    LOOP(){
	b_IfSPCDataBufferNotFull(){
	    $USE(D_WorkData);
	    s_ReadByteData(data_buf_reg, data_ptr_reg, D_WorkData);
	    b_SetScsiDataReg(D_WorkData);
	    $RELEASE(D_WorkData);
	    b_IncrementReg(data_ptr_reg);
	    b_DecrementReg(data_len_reg);
	}
	b_IfScsiAnyInterrupt(){
	    break;
	}
	b_IfZero(data_len_reg){
	    break;
	}
    }
/*    b_BusyWaitUntilSPCNotBusy(); */
}

#PSL_define s_ScsiTargetReceiveData(data_buf_reg, data_ptr_reg, data_len_reg)
{
    LOOP(){
	b_IfSPCDataBufferNotEmpty(){
	    $USE(D_WorkData);
	    b_GetScsiDataReg(D_WorkData);
	    s_WriteByteData(D_WorkData, data_buf_reg, data_ptr_reg);
	    $RELEASE(D_WorkData);
	    b_IncrementReg(data_ptr_reg);
	    b_DecrementReg(data_len_reg);
	}
	b_IfScsiAnyInterrupt(){
	    break;
	}
	b_IfZero(data_len_reg){
	    break;
	}
    }
/*    b_BusyWaitUntilSPCNotBusy(); */
}

#PSL_define s_ScsiInitiatorSendData(data_buf_reg, data_ptr_reg, data_len_reg)
{
    $USE(D_WorkInterrupt);
    LOOP(){
	b_GetScsiInterrupt(D_WorkInterrupt);
	b_IfScsiInterruptSPCHardwareError(D_WorkInterrupt){
	    b_ScsiSetATN();
	    goto Send_Null_Data;
	}
	b_IfScsiParityError(){
	    b_ScsiSetATN();
	    goto Send_Null_Data;
	}
	b_IfSPCDataBufferNotFull(){
	    $USE(D_WorkData1);
	    s_ReadByteData(data_buf_reg, data_ptr_reg, D_WorkData1);
	    /* data_ptr_reg$B$N;X$9%"%I%l%9$+$i(B1$B%P%$%H(BD_WorkData$B$KFI$_9~$`!#(B*/
	    b_SetScsiDataReg(D_WorkData1);
	    $RELEASE(D_WorkData1);
	    b_IncrementReg(data_ptr_reg);
	    b_DecrementReg(data_len_reg);
	}
	b_IfSPCNotBusy(){
	    goto END;
        }
	b_IfZero(data_len_reg){
	    break;
	}
    }
    b_BusyWaitUntilSPCNotBusy();
    goto END;

  Send_Null_Data:
    LOOP(){
	b_IfSPCDataBufferNotFull(){
	    b_SetScsiDataReg(D_NULL);
	}
       	b_IfSPCNotBusy(){
	    break;
	}
    }

  END:
    $RELEASE(D_WorkInterrupt);
}

#PSL_define s_ScsiInitiatorReceiveData(data_buf_reg, data_ptr_reg)
{
    $USE(D_WorkData1);
    $USE(D_WorkInterrupt);
    LOOP(){
	b_GetScsiInterrupt(D_WorkInterrupt);
	b_IfScsiInterruptSPCHardwareError(D_WorkInterrupt){
	    b_ScsiSetATN();
	    goto Ignore_Data;
	}
	b_IfScsiParityError(){
	    b_ScsiSetATN();
	    goto Ignore_Data;
	}
	b_IfSPCDataBufferNotEmpty(){
	    b_GetScsiDataReg(D_WorkData1);
	    s_WriteByteData(D_WorkData1, data_buf_reg, data_ptr_reg);
	    b_IncrementReg(data_ptr_reg);
	}
	b_IfSPCNotBusy(){
	    goto END;
	}
    }

  Ignore_Data:
    LOOP(){
	b_IfSPCDataBufferNotEmpty(){
	    b_GetScsiDataReg(D_VOID);
	}
	b_IfSPCNotBusy(){
	    break;
	}
    }

  END:
    $RELEASE(D_WorkInterrupt);
    $RELEASE(D_WorkData1);
}
