
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/structures/str_bignum.psl.c
   ----- CREATED   : by yamamoto@icot22, on Sun Feb 23 19:01:00 1992
   ----- LAST SAVED: by yamamoto@icot22, on Wed Feb 26 17:38:40 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **

       written by yamamoto@icot22      on Sun Feb 23 19:13:49 1992

$BG\@:EY@0?t!"B>G\D9@:EY@0?t$N%5%]!<%H$G?7$?$K:n@.$7$?!"(B
$B#s%l%Y%k%^%/%m(B

********************************************************************* PSL **/

#CONST_define _BIGNUM_ELM_SIZE  32


#PSL_define  s_Add_BIGNUM_1(str_src1,src_len1,str_src2,src_len2,
			    str_dst,dst_len){
  s_Add_BIGNUM(str_src1,src_len1,str_src2,src_len2,str_dst,dst_len);
}

#PSL_define  s_Add_BIGNUM_2(str_src1,src_len1,str_src2,src_len2,
			    str_dst,dst_len){
  s_Add_BIGNUM(str_src1,src_len1,str_src2,src_len2,str_dst,dst_len);
}

#PSL_define  s_Add_BIGNUM_3(str_src1,src_len1,str_src2,src_len2,
			    str_dst,dst_len){
  s_Add_BIGNUM(str_src1,src_len1,str_src2,src_len2,str_dst,dst_len);
}

/* $B8F=PB&$G>l9gJ,$1$r$7$F$$$k$,!"$3$3$iJU$r4hD%$C$F$b$7$g$&$,$J$$$N$+$J!)(B */
/* $B$H$$$&$3$H$G!"7k6I0l$D$N%^%/%m$K$J$C$F$$$k!#(B */
/* $B8F=PB&$bE;$a$F$bNI$$$N$@$1$I$M!#(B */

#DATA_define D_WorkBIGNUM_Src1  XXX
#DATA_define D_WorkBIGNUM_Src2  XXX
#DATA_define D_WorkBIGNUM_DstU  XXX
#DATA_define D_WorkBIGNUM_DstL  XXX
#DATA_define D_WorkBIGNUM_Carry XXX

#DATA_define D_WorkBIGNUM_Slevel_StrLen  XXX
#DATA_define D_WorkBIGNUM_Slevel_ElmSize XXX
#DATA_define D_WorkBIGNUM_Slevel_StrDesc XXX

#CONST_define _HALF_OF_PAGE_SIZE 128 /* _SIZE_OF_HEAP_PAGE * 0.5 */

/* args named *len* used as counter */
/* pre-condition dst_len >= src_len1 >= src_len2 */

#PSL_define  s_Add_BIGNUM(str_src1,src_len1,str_src2,src_len2,
			  str_dst,dst_len){
  $USE(D_WorkBIGNUM_Src1);
  $USE(D_WorkBIGNUM_Src2);
  $USE(D_WorkBIGNUM_DstU);
  $USE(D_WorkBIGNUM_DstL);
  $USE(D_WorkBIGNUM_Carry);
  
  p_MoveWord(D_NULL,D_WorkBIGNUM_Carry);

  LOOP(){ /* dst = src1 + src2 + carry */

    b_DecrementReg(src_len1);
    b_DecrementReg(src_len2);
    b_DecrementReg(dst_len);

    s_GetStringWordPosReg(str_src1,src_len1,D_WorkBIGNUM_Src1);
    s_GetStringWordPosReg(str_src2,src_len2,D_WorkBIGNUM_Src2);

    b_AddDoubleWord(D_NULL,D_WorkBIGNUM_Src1,
		    D_NULL,D_WorkBIGNUM_Src2,
		    D_WorkBIGNUM_DstU,D_WorkBIGNUM_DstL);
    
    b_AddDoubleWord(D_WorkBIGNUM_DstU,D_WorkBIGNUM_DstL,
		    D_NULL,D_WorkBIGNUM_Carry,
		    D_WorkBIGNUM_Src1,D_WorkBIGNUM_Src2); /* just work */
    
    p_MoveWord(D_WorkBIGNUM_Src1,D_WorkBIGNUM_Carry);
    
    s_PutStringWordPosReg(str_dst,dst_len,D_WorkBIGNUM_Src2);
    
    b_IfZero(src_len2){break;}
  }

  b_IfZero(src_len1){goto L_END;}

  LOOP(){ /* dst = src1 + carry */

    b_DecrementReg(src_len1);
    b_DecrementReg(dst_len);

    s_GetStringWordPosReg(str_src1,src_len1,D_WorkBIGNUM_Src1);

    b_AddDoubleWord(D_NULL,D_WorkBIGNUM_Src1,
		    D_NULL,D_WorkBIGNUM_Carry,
		    D_WorkBIGNUM_DstU,D_WorkBIGNUM_DstL);
    
    p_MoveWord(D_WorkBIGNUM_DstU,D_WorkBIGNUM_Carry);

    s_PutStringWordPosReg(str_dst,dst_len,D_WorkBIGNUM_DstL);
    
    b_IfZero(src_len1){break;}
  }

 L_END: /* dst = carry */

  b_IfNotZero(dst_len){
    b_DecrementReg(dst_len);
    @DEBUG{
      b_IfNotZero(dst_len){
	VPIM_ERROR("s_Add_BIGNUM","??? UNDERFLOW ???");
      }
    };
    b_IfNotZero(D_WorkBIGNUM_Carry){
      s_PutStringWordPosReg(str_dst,dst_len,D_WorkBIGNUM_Carry);
    }else{ /* $BA0$X$D$a$k=hM}$,I,MW$G$9(B */
      $USE(D_WorkBIGNUM_Slevel_StrLen);
      $USE(D_WorkBIGNUM_Slevel_ElmSize);
      $USE(D_WorkBIGNUM_Slevel_StrDesc);
      s_GetStringType(str_dst,
		      D_WorkBIGNUM_Slevel_StrLen,
		      D_WorkBIGNUM_Slevel_ElmSize);
      b_DecrementReg(D_WorkBIGNUM_Slevel_StrLen);
      s_SetStringDescOnReg(D_WorkBIGNUM_Slevel_StrLen,
			   D_WorkBIGNUM_Slevel_ElmSize,
			   D_WorkBIGNUM_Slevel_StrDesc);
      $RELEASE(D_WorkBIGNUM_Slevel_ElmSize);
      p_MoveWord(D_NULL,dst_len);
      p_MoveWord(D_ONE,src_len1);
      
      b_IfLessImm(D_WorkBIGNUM_Slevel_StrLen,_HALF_OF_PAGE_SIZE){
	p_MoveWord(str_dst,str_src1);
	$CALL( s_AllocStrgMRBoffWithDesc_Sub(str_dst,
					     D_WorkBIGNUM_Slevel_StrDesc) );
	$RELEASE(D_WorkBIGNUM_Slevel_StrDesc);

	LOOP(){ 
	  s_GetStringWordPosReg(str_src1,src_len1,D_WorkBIGNUM_Src1);
	  s_PutStringWordPosReg(str_dst,dst_len,D_WorkBIGNUM_Src1);
	  b_IncrementReg(dst_len);
	  b_IncrementReg(src_len1);
	  b_IfEqual(dst_len,D_WorkBIGNUM_Slevel_StrLen){break;}
	}

	$RELEASE(D_WorkBIGNUM_Slevel_StrLen);
	s_ReclaimString(str_src1);

      }else{

	LOOP(){ 
	  s_GetStringWordPosReg(str_dst,src_len1,D_WorkBIGNUM_Src1);
	  s_PutStringWordPosReg(str_dst,dst_len,D_WorkBIGNUM_Src1);
	  b_IncrementReg(dst_len);
	  b_IncrementReg(src_len1);
	  b_IfEqual(dst_len,D_WorkBIGNUM_Slevel_StrLen){break;}
	}

	$RELEASE(D_WorkBIGNUM_Slevel_StrLen);
	s_PutStringDesc(D_WorkBIGNUM_Slevel_StrDesc,str_dst);
	$RELEASE(D_WorkBIGNUM_Slevel_StrDesc);

      }
    }
  }else{
    @DEBUG{
      b_IfNotZero(D_WorkBIGNUM_Carry){
	VPIM_ERROR("s_Add_BIGNUM","??? OVERFLOW ???");
      }
    };
  }

  $RELEASE(D_WorkBIGNUM_Src1);
  $RELEASE(D_WorkBIGNUM_Src2);
  $RELEASE(D_WorkBIGNUM_DstU);
  $RELEASE(D_WorkBIGNUM_DstL);
  $RELEASE(D_WorkBIGNUM_Carry);

}

#DATA_define D_WorkBIGNUM_Borrow XXX

/* args named *len* used as counter */
/* pre-condition */
/* str_src1 > str_src2, dst_len = src_len1 >= src_len2 */

#PSL_define  s_Subtract_BIGNUM(str_src1,src_len1,str_src2,src_len2,
			       str_dst,dst_len){

  $USE(D_WorkBIGNUM_Src1);
  $USE(D_WorkBIGNUM_Src2);
  $USE(D_WorkBIGNUM_DstU);
  $USE(D_WorkBIGNUM_DstL);
  $USE(D_WorkBIGNUM_Borrow);

  p_MoveWord(D_NULL,D_WorkBIGNUM_Borrow);

  LOOP(){ /* dst = src1 - src2 - borrow */
    b_DecrementReg(src_len1);
    b_DecrementReg(src_len2);
    b_DecrementReg(dst_len);

    s_GetStringWordPosReg(str_src1,src_len1,D_WorkBIGNUM_Src1);
    s_GetStringWordPosReg(str_src2,src_len2,D_WorkBIGNUM_Src2);

    b_SubtractDoubleWord(D_ONE,D_WorkBIGNUM_Src1,
			 D_NULL,D_WorkBIGNUM_Src2,
			 D_WorkBIGNUM_DstU,D_WorkBIGNUM_DstL);
    
    b_SubtractDoubleWord(D_WorkBIGNUM_DstU,D_WorkBIGNUM_DstL,
			 D_NULL,D_WorkBIGNUM_Borrow,
			 D_WorkBIGNUM_Src1,D_WorkBIGNUM_Src2); /* just work */
 
    b_BitwiseEorWithDNTC(D_WorkBIGNUM_Src1,D_ONE,D_WorkBIGNUM_Borrow);

    s_PutStringWordPosReg(str_dst,dst_len,D_WorkBIGNUM_Src2);
    
    b_IfZero(src_len2){break;}
  }

  b_IfZero(src_len1){goto L_END;}

  LOOP(){ /* dst = src1 - borrow */

    b_DecrementReg(src_len1);
    b_DecrementReg(dst_len);

    s_GetStringWordPosReg(str_src1,src_len1,D_WorkBIGNUM_Src1);

    b_SubtractDoubleWord(D_ONE,D_WorkBIGNUM_Src1,
			 D_NULL,D_WorkBIGNUM_Borrow,
			 D_WorkBIGNUM_DstU,D_WorkBIGNUM_DstL);
    
    b_BitwiseEorWithDNTC(D_WorkBIGNUM_DstU,D_ONE,D_WorkBIGNUM_Borrow);

    s_PutStringWordPosReg(str_dst,dst_len,D_WorkBIGNUM_DstL);
    
    b_IfZero(src_len1){break;}
  }

 L_END: 

/* $BA0$K$D$a$k=hM}$,I,MW$J$i$P$3$3$G$d$k!#(B */

  @DEBUG{
    b_IfNotZero(dst_len){
      VPIM_ERROR("s_Subtract_BIGNUM","??? dst_len != src_len1 ???");
    }
    b_IfNotZero(D_WorkBIGNUM_Borrow){
      VPIM_ERROR("s_Subtract_BIGNUM","??? str_src2 > str_src1 ???");
    }
  };

  s_GetStringWordPosReg(str_dst,D_NULL,D_WorkBIGNUM_Src1);
  b_IfNotZero(D_WorkBIGNUM_Src1){goto L_END2;}
  
  p_MoveWord(D_ONE,src_len1);

  LOOP(){ /* $BHsNm%o!<%I$N%5!<%A(B */
    s_GetStringWordPosReg(str_dst,src_len1,D_WorkBIGNUM_Src1);
    b_IfNotZero(D_WorkBIGNUM_Src1){break;}
    b_IncrementReg(src_len1);
  }

  $USE(D_WorkBIGNUM_Slevel_StrLen);
  $USE(D_WorkBIGNUM_Slevel_ElmSize);
  $USE(D_WorkBIGNUM_Slevel_StrDesc);
  s_GetStringType(str_dst,
		  D_WorkBIGNUM_Slevel_StrLen,
		  D_WorkBIGNUM_Slevel_ElmSize);
  p_Subtract(D_WorkBIGNUM_Slevel_StrLen,src_len1,
	     D_WorkBIGNUM_Slevel_StrLen);
  @DEBUG{
    b_IfLessEq(D_WorkBIGNUM_Slevel_StrLen,D_NULL){
      VPIM_ERROR("s_Subtract_BIGNUM","??? UNDERFLOW ???");
    }
  };
  s_SetStringDescOnReg(D_WorkBIGNUM_Slevel_StrLen,
		       D_WorkBIGNUM_Slevel_ElmSize,
		       D_WorkBIGNUM_Slevel_StrDesc);
  $RELEASE(D_WorkBIGNUM_Slevel_ElmSize);
  p_MoveWord(D_NULL,dst_len);

  b_IfLessImm(D_WorkBIGNUM_Slevel_StrLen,_HALF_OF_PAGE_SIZE){
    p_MoveWord(str_dst,str_src1);
    $CALL( s_AllocStrgMRBoffWithDesc_Sub(str_dst,
					 D_WorkBIGNUM_Slevel_StrDesc) );
    $RELEASE(D_WorkBIGNUM_Slevel_StrDesc);


    LOOP(){ /* $BA0$D$a=hM}(B */
      s_GetStringWordPosReg(str_src1,src_len1,D_WorkBIGNUM_Src1);
      s_PutStringWordPosReg(str_dst,dst_len,D_WorkBIGNUM_Src1);
      b_IncrementReg(dst_len);
      b_IncrementReg(src_len1);
      b_IfEqual(dst_len,D_WorkBIGNUM_Slevel_StrLen){break;}
    }
    
    $RELEASE(D_WorkBIGNUM_Slevel_StrLen);
    s_ReclaimString(str_src1);

  }else{

    LOOP(){ /* $BA0$D$a=hM}(B */
      s_GetStringWordPosReg(str_dst,src_len1,D_WorkBIGNUM_Src1);
      s_PutStringWordPosReg(str_dst,dst_len,D_WorkBIGNUM_Src1);
      b_IncrementReg(dst_len);
      b_IncrementReg(src_len1);
      b_IfEqual(dst_len,D_WorkBIGNUM_Slevel_StrLen){break;}
    }

    $RELEASE(D_WorkBIGNUM_Slevel_StrLen);
    s_PutStringDesc(D_WorkBIGNUM_Slevel_StrDesc,str_dst);
    $RELEASE(D_WorkBIGNUM_Slevel_StrDesc);
  }

 L_END2:
  $RELEASE(D_WorkBIGNUM_Src1);
  $RELEASE(D_WorkBIGNUM_Src2);
  $RELEASE(D_WorkBIGNUM_DstU);
  $RELEASE(D_WorkBIGNUM_DstL);
  $RELEASE(D_WorkBIGNUM_Borrow);
  
}

#PSL_define s_Multiply_BIGNUM_By_Word(str_src,src_len,int_src,str_dst,dst_len){

  $USE(D_WorkBIGNUM_Src1);
  $USE(D_WorkBIGNUM_Src2);
  $USE(D_WorkBIGNUM_DstU);
  $USE(D_WorkBIGNUM_DstL);
  $USE(D_WorkBIGNUM_Carry);
  
  p_MoveWord(D_NULL,D_WorkBIGNUM_Carry);

  LOOP(){ /* dst = src1 * src2 + carry */

    b_DecrementReg(src_len);
    b_DecrementReg(dst_len);

    s_GetStringWordPosReg(str_src,src_len,D_WorkBIGNUM_Src1);

    b_Multiply_ExtendedInt(D_WorkBIGNUM_Src1,int_src,
			   D_WorkBIGNUM_DstU,D_WorkBIGNUM_DstL);
    
    b_AddDoubleWord(D_WorkBIGNUM_DstU,D_WorkBIGNUM_DstL,
		    D_NULL,D_WorkBIGNUM_Carry,
		    D_WorkBIGNUM_Src1,D_WorkBIGNUM_Src2); /* just work */
    
    p_MoveWord(D_WorkBIGNUM_Src1,D_WorkBIGNUM_Carry);
    
    s_PutStringWordPosReg(str_dst,dst_len,D_WorkBIGNUM_Src2);
    
    b_IfZero(src_len){break;}
  }

 L_END: /* dst = carry */

  b_DecrementReg(dst_len);
  @DEBUG{
    b_IfNotZero(dst_len){
      VPIM_ERROR("s_Add_BIGNUM","??? dst_len != src_len + 1 ???");
    }
  };
  b_IfNotZero(D_WorkBIGNUM_Carry){
    s_PutStringWordPosReg(str_dst,dst_len,D_WorkBIGNUM_Carry);
  }else{ /* $BA0$X$D$a$k=hM}$,I,MW$G$9(B */
    $USE(D_WorkBIGNUM_Slevel_StrLen);
    $USE(D_WorkBIGNUM_Slevel_ElmSize);
    $USE(D_WorkBIGNUM_Slevel_StrDesc);
    s_GetStringType(str_dst,
		    D_WorkBIGNUM_Slevel_StrLen,
		    D_WorkBIGNUM_Slevel_ElmSize);
    b_DecrementReg(D_WorkBIGNUM_Slevel_StrLen);
    s_SetStringDescOnReg(D_WorkBIGNUM_Slevel_StrLen,
			 D_WorkBIGNUM_Slevel_ElmSize,
			 D_WorkBIGNUM_Slevel_StrDesc);
    $RELEASE(D_WorkBIGNUM_Slevel_ElmSize);

    p_MoveWord(D_NULL,dst_len);
    p_MoveWord(D_ONE,src_len);
      
    b_IfLessImm(D_WorkBIGNUM_Slevel_StrLen,_HALF_OF_PAGE_SIZE){
      p_MoveWord(str_dst,str_src);
      $CALL( s_AllocStrgMRBoffWithDesc_Sub(str_dst,
					   D_WorkBIGNUM_Slevel_StrDesc) );
      $RELEASE(D_WorkBIGNUM_Slevel_StrDesc);

      LOOP(){ 
	s_GetStringWordPosReg(str_src,src_len,D_WorkBIGNUM_Src1);
	s_PutStringWordPosReg(str_dst,dst_len,D_WorkBIGNUM_Src1);
	b_IncrementReg(dst_len);
	b_IncrementReg(src_len);
	b_IfEqual(dst_len,D_WorkBIGNUM_Slevel_StrLen){break;}
      }

      $RELEASE(D_WorkBIGNUM_Slevel_StrLen);
      s_ReclaimString(str_src);
      
    }else{

      LOOP(){ 
	s_GetStringWordPosReg(str_dst,src_len,D_WorkBIGNUM_Src1);
	s_PutStringWordPosReg(str_dst,dst_len,D_WorkBIGNUM_Src1);
	b_IncrementReg(dst_len);
	b_IncrementReg(src_len);
	b_IfEqual(dst_len,D_WorkBIGNUM_Slevel_StrLen){break;}
      }
      $RELEASE(D_WorkBIGNUM_Slevel_StrLen);
      s_PutStringDesc(D_WorkBIGNUM_Slevel_StrDesc,str_dst);
      $RELEASE(D_WorkBIGNUM_Slevel_StrDesc);
    }
  }

  $RELEASE(D_WorkBIGNUM_Src1);
  $RELEASE(D_WorkBIGNUM_Src2);
  $RELEASE(D_WorkBIGNUM_DstU);
  $RELEASE(D_WorkBIGNUM_DstL);
  $RELEASE(D_WorkBIGNUM_Carry);

}


/* $B%,!<%I$NAH9~$r<:GT$XF3$/$K$O!"0J2<$N%^%/%m$r@.8y$5$;$k$3$H!#(B*/

/* $B7?$NITE,9g$O<:GT$K$7$F$*$/!#(B*/
/* $B%9%H%j%s%00J30$O%3%s%Q%$%i$,%A%'%C%/$r$7$F$$$k$N$G$3$J$$$O$:!#(B*/
/* $B$h$C$F!"(B@DEBUG $B$G%A%'%C%/$7$F(B VPIM_ERROR $B$K$9$k!#(B*/
/* $B#3#2%S%C%H0J30$N%9%H%j%s%0$O$3$3$^$GMh$k2DG=@-$,$"$k$N$G!"(B*/
/* $B<:GT$H$9$k!#(B*/


#CTRL_define s_IfBignumLessThan(src1,src2){

  $USE(D_WorkBignumStrLen1);
  $USE(D_WorkBignumElmSize);
  $USE(D_WorkBignumFirstElm);
  s_GetStringType(src1,D_WorkBignumStrLen1,D_WorkBignumElmSize);
  b_IfNotEqualImm(D_WorkBignumElmSize,_BIGNUM_ELM_SIZE){
    $RELEASE(D_WorkBignumFirstElm);
    $RELEASE(D_WorkBignumStrLen1);
    $RELEASE(D_WorkBignumElmSize);
    b_SetSuccess();
    goto L_END;
  }
  b_IfNotZero(D_WorkBignumStrLen1){
    s_GetStringWordPosReg(src1,D_NULL,D_WorkBignumFirstElm);
    b_IfZero(D_WorkBignumFirstElm){ /* src1 leading zero element */
      $RELEASE(D_WorkBignumFirstElm);
      $RELEASE(D_WorkBignumStrLen1);
      $RELEASE(D_WorkBignumElmSize);
      b_SetSuccess();
      goto L_END;
    }
  }
  s_GetStringType(src2,D_WorkBignumStrLen1,D_WorkBignumElmSize);
  b_IfNotEqualImm(D_WorkBignumElmSize,_BIGNUM_ELM_SIZE){
    $RELEASE(D_WorkBignumFirstElm);
    $RELEASE(D_WorkBignumStrLen1);
    $RELEASE(D_WorkBignumElmSize);
    b_SetSuccess();
    goto L_END;
  }
  b_IfNotZero(D_WorkBignumStrLen1){
    s_GetStringWordPosReg(src2,D_NULL,D_WorkBignumFirstElm);
    b_IfZero(D_WorkBignumFirstElm){ /* src2 leading zero element */
      $RELEASE(D_WorkBignumFirstElm);
      $RELEASE(D_WorkBignumStrLen1);
      $RELEASE(D_WorkBignumElmSize);
      b_SetSuccess();
      goto L_END;
    }
  }
  $RELEASE(D_WorkBignumFirstElm);
  $RELEASE(D_WorkBignumStrLen1);
  $RELEASE(D_WorkBignumElmSize);
  s_CompareBIGNUM(src1,src2);
  p_IfLT(){b_SetSuccess();}else{b_SetFail();}
 L_END: ;
  b_IfSuccess()
}

#CTRL_define s_IfBignumNotLessThan(src1,src2){

  $USE(D_WorkBignumStrLen1);
  $USE(D_WorkBignumElmSize);
  $USE(D_WorkBignumFirstElm);
  s_GetStringType(src1,D_WorkBignumStrLen1,D_WorkBignumElmSize);
  b_IfNotEqualImm(D_WorkBignumElmSize,_BIGNUM_ELM_SIZE){
    $RELEASE(D_WorkBignumFirstElm);
    $RELEASE(D_WorkBignumStrLen1);
    $RELEASE(D_WorkBignumElmSize);
    b_SetSuccess();
    goto L_END;
  }
  b_IfNotZero(D_WorkBignumStrLen1){
    s_GetStringWordPosReg(src1,D_NULL,D_WorkBignumFirstElm);
    b_IfZero(D_WorkBignumFirstElm){ /* src1 leading zero element */
      $RELEASE(D_WorkBignumFirstElm);
      $RELEASE(D_WorkBignumStrLen1);
      $RELEASE(D_WorkBignumElmSize);
      b_SetSuccess();
      goto L_END;
    }
  }
  s_GetStringType(src2,D_WorkBignumStrLen1,D_WorkBignumElmSize);
  b_IfNotEqualImm(D_WorkBignumElmSize,_BIGNUM_ELM_SIZE){
    $RELEASE(D_WorkBignumFirstElm);
    $RELEASE(D_WorkBignumStrLen1);
    $RELEASE(D_WorkBignumElmSize);
    b_SetSuccess();
    goto L_END;
  }
  b_IfNotZero(D_WorkBignumStrLen1){
    s_GetStringWordPosReg(src2,D_NULL,D_WorkBignumFirstElm);
    b_IfZero(D_WorkBignumFirstElm){ /* src2 leading zero element */
      $RELEASE(D_WorkBignumFirstElm);
      $RELEASE(D_WorkBignumStrLen1);
      $RELEASE(D_WorkBignumElmSize);
      b_SetSuccess();
      goto L_END;
    }
  }
  $RELEASE(D_WorkBignumFirstElm);
  $RELEASE(D_WorkBignumStrLen1);
  $RELEASE(D_WorkBignumElmSize);
  s_CompareBIGNUM(src1,src2);
  p_IfGE(){b_SetSuccess();}else{b_SetFail();}
 L_END: ;
  b_IfSuccess()
}

#DATA_define D_WorkBIGNUM_CompCount    XXX
#DATA_define D_WorkBIGNUM_Comp_StrLen1 XXX
#DATA_define D_WorkBIGNUM_Comp_StrLen2 XXX
#DATA_define D_WorkBIGNUM_Comp_Src1    XXX
#DATA_define D_WorkBIGNUM_Comp_Src2    XXX
#DATA_define D_WorkBIGNUM_Comp_ElmSize XXX

#PSL_define s_CompareBIGNUM(src1,src2){

  $USE(D_WorkBIGNUM_Comp_StrLen1);
  $USE(D_WorkBIGNUM_Comp_StrLen2);
  $USE(D_WorkBIGNUM_Comp_ElmSize);
  s_GetStringType(src1,D_WorkBIGNUM_Comp_StrLen1,D_WorkBIGNUM_Comp_ElmSize);
  s_GetStringType(src2,D_WorkBIGNUM_Comp_StrLen2,D_WorkBIGNUM_Comp_ElmSize);

  p_Compare(D_WorkBIGNUM_Comp_StrLen1,D_WorkBIGNUM_Comp_StrLen2);
  p_IfNE(){goto L_END;}

  b_IfZero(D_WorkBIGNUM_Comp_StrLen1){goto L_END;}

  $USE(D_WorkBIGNUM_CompCount);
  $USE(D_WorkBIGNUM_Comp_Src1);
  $USE(D_WorkBIGNUM_Comp_Src2);
  p_MoveWord(D_NULL,D_WorkBIGNUM_CompCount);

  LOOP(){
    s_GetStringWordPosReg(src1,D_WorkBIGNUM_CompCount,D_WorkBIGNUM_Comp_Src1);
    s_GetStringWordPosReg(src2,D_WorkBIGNUM_CompCount,D_WorkBIGNUM_Comp_Src2);
    b_CompareU(D_WorkBIGNUM_Comp_Src1,D_WorkBIGNUM_Comp_Src2);
    p_IfNE(){break;}
    b_IncrementReg(D_WorkBIGNUM_CompCount);
    b_IfEqual(D_WorkBIGNUM_CompCount,D_WorkBIGNUM_Comp_StrLen1){break;}
  }
  $RELEASE(D_WorkBIGNUM_Comp_Src1);
  $RELEASE(D_WorkBIGNUM_Comp_Src2);
  $RELEASE(D_WorkBIGNUM_CompCount);

 L_END:
  $RELEASE(D_WorkBIGNUM_Comp_StrLen1);
  $RELEASE(D_WorkBIGNUM_Comp_StrLen2);
  $RELEASE(D_WorkBIGNUM_Comp_ElmSize);
}
