
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/primitives/prim.psl.c
   ----- CREATED   : by yamamoto@icot22, on Mon Jun  4 22:01:33 1990
   ----- LAST SAVED: by ttakagi@icot22, on Mon Apr 20 22:19:40 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : primitive
   ----- ABSTRACT  : all primitive macros ( include extension )
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */
/***************************************************************************/
/*							PIM-I-P-PSL-028    */
/*							890208 YAMAMOTO    */
/***************************************************************************/
/******************************************************************** PSL **
$B4pK\%^%/%m(B
       written by yamamoto@icot21      on Tue Feb  7 21:40:13 1989

<Level>primitive

CONTENTS

1. operation macros

1.1 data transport
1.1.1 move -- inter-register transport
1.1.2 set -- move immediate data to register
1.1.3 read -- transport from memory to register
1.1.4 write -- transport from register to memory
1.1.5 unlock -- same as WriteAndUnlock but no writing
1.1.6 kl1b operand fields operations
1.1.7 SCR,SCR-bit access
1.1.8 SPC register access
1.1.9 FPU register access

1.2 arithmetic operation
1.2.1 word operation
1.2.2 value field operations(signed int arithmetic)
1.2.3 value field operations(bitwise arithmetic)
1.2.4 floating point operations(use FPU)

2.  control macros

2.1 test Type field
2.2 test MRB field
2.3 test tag field all
2.4 test CCR
2.5 test SCF
2.6 test FPU-CCR

3. data macros

3.1 temp reg for primitive level definitions

3.2 kl1b operand fields
3.2.1 indirect register field to specify kl1b argument register
3.2.2 immediate value field

3.3 tag field constant

4 extensions for memory access with immediate operand field

********************************************************************* PSL **/

/***************************************************************************/
/*** 1. operation macros						   */
/***************************************************************************/

/*** 1.1 data transport ****************************************************/

	/**************************/
	/**			 **/
	/**   Don't care CCR !!! **/
	/**			 **/
	/**************************/

/****************************************************************************/
/* 1.1.1 move -- inter-register transport				    */
/*****************************************************************************

p_MoveWord(SrcReg,DstReg)

p_MoveValue(SrcReg,DstReg)
p_MoveTag(SrcReg,DstReg)
p_MoveType(SrcReg,DstReg)
p_MoveMRB(SrcReg,DstReg)

p_MoveTypeToValue(SrcReg,DstReg)
p_MoveValueToType(SrcReg,DstReg)

p_MoveTagToValue(SrdReg,DstReg) just for tag_and_value, machine dependent
p_MoveValueToTag(SrdReg,DstReg) just for set_tag_and_value
****************************************************************************/

/***************************************************************************/
/* 1.1.2 set -- move immediate data to register 			   */
/****************************************************************************

p_SetImmediateWord(SrcImmType,SrcImmMRB,SrcImmValue,DstReg)

p_SetImmediateValue(SrcImmValue,DstReg)
p_SetImmediateTag(SrcImmType,SrcImmMRB,DstReg)
p_SetImmediateType(SrcImmType,DstReg)
p_SetImmediateMRB(SrcImmMRB,DstReg)

****************************************************************************/

#PSL_define	p_MoveWord(SrcReg,DstReg)
	{
	_MoveWord(SrcReg,DstReg);
	}

#PSL_define	p_MoveValue(SrcReg,DstReg)
	{
	_MoveValue(SrcReg,DstReg);
	}

#PSL_define	p_MoveTag(SrcReg,DstReg)
	{
	_MoveTag(SrcReg,DstReg);
	}

#PSL_define	p_MoveType(SrcReg,DstReg)
	{
	_MoveType(SrcReg,DstReg);
	}

#PSL_define	p_MoveMRB(SrcReg,DstReg)
	{
	_MoveMRB(SrcReg,DstReg);
	}


#PSL_define	p_MoveTypeToValue(SrcReg,DstReg)
	{
	_MoveTypeToValue(SrcReg,DstReg);
	}

#PSL_define	p_MoveValueToType(SrcReg,DstReg)
	{
	_MoveValueToType(SrcReg,DstReg);
	}

/*  CAUTION !!! p_MoveTagToValue is only for a builtin tag_and_value */
#PSL_define	p_MoveTagToValue(SrcReg,DstReg)
	{
	_MoveTagToValue(SrcReg,DstReg);
	}

/*  CAUTION !!! p_MoveValueToTag is only for a set_tag_and_value */
#PSL_define	p_MoveValueToTag(SrcReg,DstReg)
	{
	_MoveValueToTag(SrcReg,DstReg);
	}

#PSL_define	p_SetImmediateWord(SrcImmType,SrcImmMRB,SrcImmValue,DstReg)
	{
	_SetImmediateWord(SrcImmType,SrcImmMRB,SrcImmValue,DstReg);
	}

#PSL_define	p_SetImmediateValue(SrcImmValue,DstReg)
	{
	_SetImmediateValue(SrcImmValue,DstReg);
	}

#PSL_define	p_SetImmediateTag(SrcImmType,SrcImmMRB,DstReg)
	{
	_SetImmediateType(SrcImmType,DstReg);
	_SetImmediateMRB(SrcImmMRB,DstReg);
	}

#PSL_define	p_SetImmediateType(SrcImmType,DstReg)
	{
	_SetImmediateType(SrcImmType,DstReg);
	}

#PSL_define	p_SetImmediateMRB(SrcImmMRB,DstReg)
	{
	_SetImmediateMRB(SrcImmMRB,DstReg);
	}


/**************************************************************/
/* 1.1.3-5 read/write --- inter memory and register transport */
/*	   and some memory access controle function -- unlock */
/**************************************************************/

	/******************************************************/
	/* word unit only 				      */
	/* some cache control effective only for 	      */
	/* down direction accessing			      */
	/******************************************************/

/****************************************************************************/
/* 1.1.3 read -- transport from memory to register			    */
/*****************************************************************************

p_Read(SrcMemAddrReg,DstReg)

p_ReadAndPurge(SrcMemAddrReg,DstReg)
p_ReadAndInvalidate(SrcMemAddrReg,DstReg)
p_ReadExclusively(SrcMemAddrReg,DstReg)
p_ReadWithLock(SrcMemAddrReg,DstReg)

p_ReadWithOffset(SrcMemAddrReg,SrcImmOff,DstReg)

p_ReadAndPurgeWithOffset(SrcMemAddrReg,SrcImmOff,DstReg)
p_ReadAndInvalidateWithOffset(SrcMemAddrReg,SrcImmOff,DstReg)
p_ReadExclusivelyWithOffset(SrcMemAddrReg,SrcImmOff,DstReg)
p_ReadWithLockWithOffset(SrcMemAddrReg,SrcImmOff,DstReg)

******************************************************************************/

/*****************************************************************************/
/* 1.1.4 write -- transport from register to memory 			     */
/******************************************************************************

p_Write(SrcReg,DstMemAddrReg)

p_WriteDirectly(SrcReg,DstMemAddrReg)
p_WriteAndUnlock(SrcReg,DstMemAddrReg)

p_WriteWithOffset(SrcReg,DstMemAddrReg,DstImmOff)

p_WriteDirectlyWithOffset(SrcReg,DstMemAddrReg,DstImmOff)
p_WriteAndUnlockWithOffset(SrcReg,DstMemAddrReg,DstImmOff)

******************************************************************************/

/*****************************************************************************/
/* 1.1.5 unlock -- same as WriteAndUnlock but no writing 		     */
/******************************************************************************

p_Unlock(DstMemAddrReg)

p_UnlockWithOffset(DstMemAddrReg,DstImmOff)

******************************************************************************/

#PSL_define	p_Read(SrcMemAddrReg,DstReg)
	{
	@PROBE2{ probe_increment_counter(D_PROBE_COUNTER_TOTAL_READ);};
	_Read(SrcMemAddrReg,DstReg);
	}

#PSL_define	p_ReadAndPurge(SrcMemAddrReg,DstReg)
	{
	@PROBE2{ probe_increment_counter(D_PROBE_COUNTER_TOTAL_READ);};
	_ReadAndPurge(SrcMemAddrReg,DstReg);
	}

#PSL_define	p_ReadAndInvalidate(SrcMemAddrReg,DstReg)
	{
	@PROBE2{ probe_increment_counter(D_PROBE_COUNTER_TOTAL_READ);};
	_ReadAndInvalidate(SrcMemAddrReg,DstReg);
	}

#PSL_define	p_ReadExclusively(SrcMemAddrReg,DstReg)
	{
	@PROBE2{ probe_increment_counter(D_PROBE_COUNTER_TOTAL_READ);};
	_ReadExclusively(SrcMemAddrReg,DstReg);
	}

#PSL_define	p_ReadWithLock(SrcMemAddrReg,DstReg)
	{
	@PROBE2{ probe_increment_counter(D_PROBE_COUNTER_TOTAL_READ);};
	_ReadWithLock(SrcMemAddrReg,DstReg);
	}

#PSL_define	p_ReadWithOffset(SrcMemAddrReg,SrcImmOff,DstReg)
	{
	@PROBE2{ probe_increment_counter(D_PROBE_COUNTER_TOTAL_READ);};
	_ReadWithOffset(SrcMemAddrReg,SrcImmOff,DstReg);
/*
	$USE(D_Work_P_Level_1);
	_SetImmediateValue(SrcImmOff,D_Work_P_Level_1);
	_AddressAdd(SrcMemAddrReg,D_Work_P_Level_1,D_Work_P_Level_1);
	_Read(D_Work_P_Level_1,DstReg);
	$RELEASE(D_Work_P_Level_1);
*/
	}

#PSL_define	p_ReadAndPurgeWithOffset(SrcMemAddrReg,SrcImmOff,DstReg)
	{
	@PROBE2{ probe_increment_counter(D_PROBE_COUNTER_TOTAL_READ);};
	_ReadWithOffset(SrcMemAddrReg,SrcImmOff,DstReg);
/*
	$USE(D_Work_P_Level_1);
	_SetImmediateValue(SrcImmOff,D_Work_P_Level_1);
	_AddressAdd(SrcMemAddrReg,D_Work_P_Level_1,D_Work_P_Level_1);
	_ReadAndPurge(D_Work_P_Level_1,DstReg);
	$RELEASE(D_Work_P_Level_1);
*/
	}

#PSL_define	p_ReadAndInvalidateWithOffset(SrcMemAddrReg,SrcImmOff,DstReg)
	{
	@PROBE2{ probe_increment_counter(D_PROBE_COUNTER_TOTAL_READ);};
	_ReadWithOffset(SrcMemAddrReg,SrcImmOff,DstReg);
/*
	$USE(D_Work_P_Level_1);
	_SetImmediateValue(SrcImmOff,D_Work_P_Level_1);
	_AddressAdd(SrcMemAddrReg,D_Work_P_Level_1,D_Work_P_Level_1);
	_ReadAndInvalidate(D_Work_P_Level_1,DstReg);
	$RELEASE(D_Work_P_Level_1);
*/
	}

#PSL_define	p_ReadExclusivelyWithOffset(SrcMemAddrReg,SrcImmOff,DstReg)
	{
	@PROBE2{ probe_increment_counter(D_PROBE_COUNTER_TOTAL_READ);};
	_ReadWithOffset(SrcMemAddrReg,SrcImmOff,DstReg);
/*
	$USE(D_Work_P_Level_1);
	_SetImmediateValue(SrcImmOff,D_Work_P_Level_1);
	_AddressAdd(SrcMemAddrReg,D_Work_P_Level_1,D_Work_P_Level_1);
	_ReadExclusively(D_Work_P_Level_1,DstReg);
	$RELEASE(D_Work_P_Level_1);
*/
	}


#PSL_define	p_ReadWithLockWithOffset(SrcMemAddrReg,SrcImmOff,DstReg)
	{
	@PROBE2{ probe_increment_counter(D_PROBE_COUNTER_TOTAL_READ);};
	$USE(D_Work_P_Level_1);
	_SetImmediateValue(SrcImmOff,D_Work_P_Level_1);
	_AddressAdd(SrcMemAddrReg,D_Work_P_Level_1,D_Work_P_Level_1);
	_ReadWithLock(D_Work_P_Level_1,DstReg);
	$RELEASE(D_Work_P_Level_1);
	}

#PSL_define	p_Write(SrcReg,DstMemAddrReg)
	{
	@PROBE2{ probe_increment_counter(D_PROBE_COUNTER_TOTAL_WRITE);};
	_Write(SrcReg,DstMemAddrReg);
	}

#PSL_define	p_WriteDirectly(SrcReg,DstMemAddrReg)
	{
	@PROBE2{ probe_increment_counter(D_PROBE_COUNTER_TOTAL_WRITE);};
	_WriteDirectly(SrcReg,DstMemAddrReg);
	}

#PSL_define	p_WriteAndUnlock(SrcReg,DstMemAddrReg)
	{
	@PROBE2{ probe_increment_counter(D_PROBE_COUNTER_TOTAL_WRITE);};
	_WriteAndUnlock(SrcReg,DstMemAddrReg);
	}


#PSL_define	p_WriteWithOffset(SrcReg,DstMemAddrReg,DstImmOff)
	{
	@PROBE2{ probe_increment_counter(D_PROBE_COUNTER_TOTAL_WRITE);};
	_WriteWithOffset(SrcReg,DstMemAddrReg,DstImmOff);
/*
	$USE(D_Work_P_Level_1);
	_SetImmediateValue(DstImmOff,D_Work_P_Level_1);
	_AddressAdd(DstMemAddrReg,D_Work_P_Level_1,D_Work_P_Level_1);
	_Write(SrcReg,D_Work_P_Level_1);
	$RELEASE(D_Work_P_Level_1);
*/
	}

#PSL_define	p_WriteDirectlyWithOffset(SrcReg,DstMemAddrReg,DstImmOff)
	{
	@PROBE2{ probe_increment_counter(D_PROBE_COUNTER_TOTAL_WRITE);};
	_WriteWithOffset(SrcReg,DstMemAddrReg,DstImmOff);
/*
	$USE(D_Work_P_Level_1);
	_SetImmediateValue(DstImmOff,D_Work_P_Level_1);
	_AddressAdd(DstMemAddrReg,D_Work_P_Level_1,D_Work_P_Level_1);
	_WriteDirectly(SrcReg,D_Work_P_Level_1);
	$RELEASE(D_Work_P_Level_1);
*/
	}

#PSL_define	p_WriteAndUnlockWithOffset(SrcReg,DstMemAddrReg,DstImmOff)
	{
	@PROBE2{ probe_increment_counter(D_PROBE_COUNTER_TOTAL_WRITE);};
	$USE(D_Work_P_Level_1);
	_SetImmediateValue(DstImmOff,D_Work_P_Level_1);
	_AddressAdd(DstMemAddrReg,D_Work_P_Level_1,D_Work_P_Level_1);
	_WriteAndUnlock(SrcReg,D_Work_P_Level_1);
	$RELEASE(D_Work_P_Level_1);
	}

#PSL_define	p_Unlock(DstMemAddrReg)
	{
	_Unlock(DstMemAddrReg);
	}

#PSL_define	p_UnlockWithOffset(DstMemAddrReg,DstImmOff)
	{
	$USE(D_Work_P_Level_1);
	_SetImmediateValue(DstImmOff,D_Work_P_Level_1);
	_AddressAdd(DstMemAddrReg,D_Work_P_Level_1,D_Work_P_Level_1);
	_Unlock(D_Work_P_Level_1);
	$RELEASE(D_Work_P_Level_1);
	}

/***** 1.1.6 kl1b operand fields operations ********/

/*****************************************************************************/
/* move word						 		     */
/* from/to kl1b arg reg specified by indirect reg field  		     */
/* to/from general register				 		     */
/******************************************************************************

p_MoveWordFromArgRegIndirectlyWithRegisterField(SrcRegField,DstReg)

p_MoveWordToArgRegIndirectlyWithRegisterField(SrcReg,DstRegField)

******************************************************************************/

/*****************************************************************************/
/* move value of immediate field 			    		     */
/* ( it must be already extended to full value field size   		     */
/* in appropriate way -- signed or unsigned )		    		     */
/* to value field of general register 			    		     */
/*                                                                           */
/* AND DON'T CARE TAG FIELD OF DESTINATION REGISTER !!!                      */
/******************************************************************************

p_MoveImmediateValueFromImmediateField(SrcImmField,DstReg)

******************************************************************************/

#PSL_define	p_MoveWordFromArgRegIndirectlyWithRegisterField(SrcRegField,DstReg)
{
  _MoveWordFromArgRegIndirectlyWithRegisterField(SrcRegField,DstReg);
}

#PSL_define	p_MoveWordToArgRegIndirectlyWithRegisterField(SrcReg,DstRegField)
{
  _MoveWordToArgRegIndirectlyWithRegisterField(SrcReg,DstRegField);
}

#PSL_define	p_MoveImmediateValueFromImmediateField(SrcImmField,DstReg)
{
  _MoveImmediateValueFromImmediateField(SrcImmField,DstReg);
}


/****************************************************************************/
/* 1.1.7 SCR(SlitCheckRegister),SCR-bit access 				    */
/*****************************************************************************

:::read whole SCR:::

p_GetSCR(DestReg)     SCR->DestReg.value , DestReg.tag no change

:::write SCR-bit::: NOTE!! only these macros affect SCF(SlitCheckFlag)
                    NOTE!!(also)these macros may affect SCR/SCF of other PE
								   ^^^^^
p_SetSCRBitImmPosition(ImmSignalPosition,PENumberReg)

p_ResetSCRBitImmPosition(ImmSignalPosition,PENumberReg)

p_SetSCRBitImmPositionAll(ImmSignalPosition)     ::::set for all PEs::::

p_ResetSCRBitImmPositionAll(ImmSignalPosition)   ::::reset for all PEs::::

p_PutSCRBit(SignalValueReg,SignalPositionReg,PENumberReg) :::general use:::

NOTE:

SignalPosition: 0 ( 0 origin ) to 31 ( full value field size
                                              --- but machine dependent )

SignalValue   : 0 , 1
( definitions like [#CONST_define _SIGON 1] must include in basic lebel )

PENumber      : 0 ( 0 origin ) to XXX ( ???
                                     --- machine ( configuration ) dependent )

PENumberReg,SignalValueReg,SignalPositionReg only use value field

******************************************************************************/

#PSL_define	p_GetSCR(DestReg)
{
			_GetSCR(DestReg);
}


#PSL_define	p_SetSCRBitImmPosition(ImmSignalPosition,PENumberReg)
{
			_SetSCRBitImmPosition(ImmSignalPosition,PENumberReg);
}

#PSL_define	p_ResetSCRBitImmPosition(ImmSignalPosition,PENumberReg)
{
			_ResetSCRBitImmPosition(ImmSignalPosition,PENumberReg);
}

#PSL_define	p_SetSCRBitImmPositionAll(ImmSignalPosition)
{
			_SetSCRBitImmPositionAll(ImmSignalPosition);
}

#PSL_define	p_ResetSCRBitImmPositionAll(ImmSignalPosition)
{
			_ResetSCRBitImmPositionAll(ImmSignalPosition);
}

#PSL_define	p_PutSCRBit(SignalValueReg,SignalPositionReg,PENumberReg)
{
		_PutSCRBit(SignalValueReg,SignalPositionReg,PENumberReg);
}

/****************************************************************************/
/* 1.1.8 SPC(ScsiProtocolController) register access 			    */
/*****************************************************************************

  p_ReadSPCReg  (ImmRegAddress, DestReg)
  p_WriteSPCReg (SrcReg, ImmRegAddress)

******************************************************************************/

#PSL_define	p_ReadSPCReg (ImmRegAddress, DestReg)
{
  _ReadSPCReg (ImmRegAddress, DestReg);
}

#PSL_define	p_WriteSPCReg (SrcReg, ImmRegAddress)
{
  _WriteSPCReg (SrcReg, ImmRegAddress);
}

/****************************************************************************/
/* 1.1.9 FPU(Floating Processing Unit) register access 			    */
/*****************************************************************************
p_MoveMSWordToFPU(reg,fpureg)
p_MoveMSWordFromFPU(fpureg,reg)
p_MoveLSWordToFPU(reg,fpureg)
p_MoveLSWordFromFPU(fpureg,reg)
****************************************************************************/

#PSL_define p_MoveMSWordToFPU(reg,fpureg){
  _MoveMSWordToFPU(reg,fpureg);
}

#PSL_define p_MoveMSWordFromFPU(fpureg,reg){
  _MoveMSWordFromFPU(fpureg,reg);
}

#PSL_define p_MoveLSWordToFPU(reg,fpureg){
  _MoveLSWordToFPU(reg,fpureg);
}

#PSL_define p_MoveLSWordFromFPU(fpureg,reg){
  _MoveLSWordFromFPU(fpureg,reg);
}


/****** 1.2 arithmetic operation ******/

	/******************************************/
	/* only these operations affect CCR !!!!! */
	/******************************************/

/*************************************************************************/
/* fpu operations affect both FPU-CCR(operation result) , CPU-CCR(undef) */
/*************************************************************************/

/*****************************************************************************/
/* 1.2.1  word operation 						     */
/******************************************************************************

p_CompareWord(SrcReg1,SrcReg2)	::: full word comparison
                                    compare S1,S2, no destination
				    only IfWordEQ and IfWordNE are valid checks

p_CompareTypeAndValue(SrcReg1,SrcReg2)
                                ::: only type field and value field comparison
                                    compare S1,S2, no destination
				    only IfWordEQ and IfWordNE are valid checks

******************************************************************************/

#PSL_define	p_CompareWord(SrcReg1,SrcReg2)
	{
	_CompareWord(SrcReg1,SrcReg2);
	}

#PSL_define	p_CompareTypeAndValue(SrcReg1,SrcReg2)
	{
	_CompareTypeAndValue(SrcReg1,SrcReg2);
	}

/*****************************************************************************/
/* 1.2.2 signed int 							     */
/******************************************************************************

Tag field of DstReg is undefined !!!!

Even in the case like p_Add(Src1 , Src2 , Src1).
                            ^^^^          ^^^^


	Note: condition EQ means Zero	(except Comp,CompImm)
			NE       NonZero
			GT       Positive
			    .
			    .
			    .

					*** valid condition checks ***
p_Add(SrcReg1,SrcReg2,DstReg)
					*** EQ,NE,GT,GE,LT,LE,Overflow

p_AddImmediate(SrcReg,SrcImm,DstReg)
					*** EQ,NE,GT,GE,LT,LE,Overflow

p_Subtract(SrcReg1,SrcReg2,DstReg)	 	 ::: S1-S2 
					*** EQ,NE,GT,GE,LT,LE,Overflow

p_SubtractImmediate(SrcReg,SrcImm,DstReg)	 ::: SR-SI
					*** EQ,NE,GT,GE,LT,LE,Overflow

p_Compare(SrcReg1,SrcReg2)		::: test S1-S2, no destination
					*** EQ,NE,GT,GE,LT,LE,********

p_CompareImmediate(SrcReg,SrcImm)	::: test SR-SI, no destination
					*** EQ,NE,GT,GE,LT,LE,********


p_Multiply(SrcReg1,SrcReg2,DstReg)
					*** EQ,NE,GT,GE,LT,LE,********

p_MultiplyImmediate(SrcReg,SrcImm,DstReg)
					*** EQ,NE,GT,GE,LT,LE,********

p_Divide(SrcReg1,SrcReg2,DstReg)	::: S1/S2
					*** EQ,NE,GT,GE,LT,LE,ZeroDivide

p_DivideImmediate(SrcReg,SrcImm,DstReg)	::: SR/SI
					*** EQ,NE,GT,GE,LT,LE,ZeroDivide

p_Modulo(SrcReg1,SrcReg2,DstReg)	::: S1/S2
					*** EQ,NE,GT,GE,LT,LE,ZeroDivide

p_ModuloImmediate(SrcReg,SrcImm,DstReg)	::: SR/SI
					*** EQ,NE,GT,GE,LT,LE,ZeroDivide

******************************************************************************/

#PSL_define	p_Add(SrcReg1,SrcReg2,DstReg)
	{
	_Add(SrcReg1,SrcReg2,DstReg);
	}

#PSL_define	p_AddImmediate(SrcReg,SrcImm,DstReg)
	{
	$USE(D_Work_P_Level_1);
	_SetImmediateValue(SrcImm,D_Work_P_Level_1);
	_Add(SrcReg,D_Work_P_Level_1,DstReg);
	$RELEASE(D_Work_P_Level_1);
	}

#PSL_define	p_AddrAdd(SrcReg1,SrcReg2,DstReg)
	{
	_AddressAdd(SrcReg1,SrcReg2,DstReg);
	}

#PSL_define	p_AddrAddImmediate(SrcReg,SrcImm,DstReg)
	{
	$USE(D_Work_P_Level_1);
	_SetImmediateValue(SrcImm,D_Work_P_Level_1);
	_AddressAdd(SrcReg,D_Work_P_Level_1,DstReg);
	$RELEASE(D_Work_P_Level_1);
	}

#PSL_define	p_Subtract(SrcReg1,SrcReg2,DstReg)
	{
	_Subtract(SrcReg1,SrcReg2,DstReg);
	}

#PSL_define	p_SubtractImmediate(SrcReg,SrcImm,DstReg)
	{
	$USE(D_Work_P_Level_1);
	_SetImmediateValue(SrcImm,D_Work_P_Level_1);
	_Subtract(SrcReg,D_Work_P_Level_1,DstReg);
	$RELEASE(D_Work_P_Level_1);
	}

#PSL_define	p_Compare(SrcReg1,SrcReg2)
	{
	_Compare(SrcReg1,SrcReg2);
	}

#PSL_define	p_CompareImmediate(SrcReg,SrcImm)
{
/*  @REGOPE_OPT {
    _CompareImmediate(SrcReg,SrcImm); goto End;
  };
  $USE(D_Work_P_Level_1);
  _SetImmediateValue(SrcImm,D_Work_P_Level_1);
  _Compare(SrcReg,D_Work_P_Level_1);
  $RELEASE(D_Work_P_Level_1);
 End:; */
  @REGOPE_OPT {
    _CompareImmediate(SrcReg,SrcImm);
  } else {
    $USE(D_Work_P_Level_1);
    _SetImmediateValue(SrcImm,D_Work_P_Level_1);
    _Compare(SrcReg,D_Work_P_Level_1);
    $RELEASE(D_Work_P_Level_1);
  };
}

#PSL_define	p_Multiply(SrcReg1,SrcReg2,DstReg)
	{
	_Multiply(SrcReg1,SrcReg2,DstReg);
	}

#PSL_define	p_MultiplyImmediate(SrcReg,SrcImm,DstReg)
	{
	$USE(D_Work_P_Level_1);
	_SetImmediateValue(SrcImm,D_Work_P_Level_1);
	_Multiply(SrcReg,D_Work_P_Level_1,DstReg);
	$RELEASE(D_Work_P_Level_1);
	}

#PSL_define	p_Divide(SrcReg1,SrcReg2,DstReg)
	{
	_Divide(SrcReg1,SrcReg2,DstReg);
	}

#PSL_define	p_DivideImmediate(SrcReg,SrcImm,DstReg)
	{
	$USE(D_Work_P_Level_1);
	_SetImmediateValue(SrcImm,D_Work_P_Level_1);
	_Divide(SrcReg,D_Work_P_Level_1,DstReg);
	$RELEASE(D_Work_P_Level_1);
	}

#PSL_define	p_Modulo(SrcReg1,SrcReg2,DstReg)
	{
	_Modulo(SrcReg1,SrcReg2,DstReg);
	}

#PSL_define	p_ModuloImmediate(SrcReg,SrcImm,DstReg)
	{
	$USE(D_Work_P_Level_1);
	_SetImmediateValue(SrcImm,D_Work_P_Level_1);
	_Modulo(SrcReg,D_Work_P_Level_1,DstReg);
	$RELEASE(D_Work_P_Level_1);
	}

/*****************************************************************************/
/* 1.2.3 bitwise 							     */
/******************************************************************************

Tag field of DstReg is undefined !!!


	Note:	in bitwize arithmetic operations 
		conditions EQ and NE correspond Zero and Non-Zero

p_ShiftLeft(SrcReg,ShiftCntReg,DstReg)
					*** EQ,NE,**,**,**,**,********

p_ShiftRight(SrcReg,ShiftCntReg,DstReg)	::: logical shift only
					*** EQ,NE,**,**,**,**,********


p_BitwiseAnd(SrcReg1,SrcReg2,DstReg)
					*** EQ,NE,**,**,**,**,********

p_BitwiseAndImmediate(SrcReg,SrcImm,DstReg)
					*** EQ,NE,**,**,**,**,********

p_BitwiseOr(SrcReg1,SrcReg2,DstReg)
					*** EQ,NE,**,**,**,**,********

p_BitwiseOrImmediate(SrcReg,SrcImm,DstReg)
					*** EQ,NE,**,**,**,**,********

p_BitwiseEor(SrcReg1,SrcReg2,DstReg)
					*** EQ,NE,**,**,**,**,********

p_BitwiseEorImmediate(SrcReg,SrcImm,DstReg)
					*** EQ,NE,**,**,**,**,********

p_BitwiseNot(SrcReg,DstReg)
					*** EQ,NE,**,**,**,**,********

******************************************************************************/

#PSL_define	p_ArithmeticShiftRight(SrcReg,ShiftCntReg,DstReg)
	{
	_ArithmeticShiftRight(SrcReg,ShiftCntReg,DstReg);
	}

#PSL_define	p_ShiftLeft(SrcReg,ShiftCntReg,DstReg)
	{
	_ShiftLeft(SrcReg,ShiftCntReg,DstReg);
	}

#PSL_define	p_ShiftRight(SrcReg,ShiftCntReg,DstReg)
	{
	_ShiftRight(SrcReg,ShiftCntReg,DstReg);
	}

#PSL_define	p_BitwiseAnd(SrcReg1,SrcReg2,DstReg)
	{
	_BitwiseAnd(SrcReg1,SrcReg2,DstReg);
	}

#PSL_define	p_BitwiseAndImmediate(SrcReg,SrcImm,DstReg)
	{
	$USE(D_Work_P_Level_1);
	_SetImmediateValue(SrcImm,D_Work_P_Level_1);
	_BitwiseAnd(SrcReg,D_Work_P_Level_1,DstReg);
	$RELEASE(D_Work_P_Level_1);
	}

#PSL_define	p_BitwiseOr(SrcReg1,SrcReg2,DstReg)
	{
	_BitwiseOr(SrcReg1,SrcReg2,DstReg);
	}

#PSL_define	p_BitwiseOrImmediate(SrcReg,SrcImm,DstReg)
	{
	$USE(D_Work_P_Level_1);
	_SetImmediateValue(SrcImm,D_Work_P_Level_1);
	_BitwiseOr(SrcReg,D_Work_P_Level_1,DstReg);
	$RELEASE(D_Work_P_Level_1);
	}

#PSL_define	p_BitwiseEor(SrcReg1,SrcReg2,DstReg)
	{
	_BitwiseEor(SrcReg1,SrcReg2,DstReg);
	}

#PSL_define	p_BitwiseEorImmediate(SrcReg,SrcImm,DstReg)
	{
	$USE(D_Work_P_Level_1);
	_SetImmediateValue(SrcImm,D_Work_P_Level_1);
	_BitwiseEor(SrcReg,D_Work_P_Level_1,DstReg);
	$RELEASE(D_Work_P_Level_1);
	}

#PSL_define	p_BitwiseNot(SrcReg,DstReg)
	{
	_BitwiseNot(SrcReg,DstReg);
	}

/*****************************************************************************/
/* 1.2.4 floating point
/******************************************************************************
/* fpu operations affect both FPU-CCR(operation result) , CPU-CCR(undef) ***
p_FLT_Compare(src_fpu_reg1,src_fpu_reg2)
p_FLT_Pattern_Compare(src_fpu_reg1,src_fpu_reg2)
p_FLT_Add(src_fpu_reg1,src_fpu_reg2,dst_fpu_reg)
p_FLT_Subtract(src_fpu_reg1,src_fpu_reg2,dst_fpu_reg)
p_FLT_Multiply(src_fpu_reg1,src_fpu_reg2,dst_fpu_reg)
p_FLT_Divide(src_fpu_reg1,src_fpu_reg2,dst_fpu_reg)
p_FloatingPointToInteger(src_fpu_reg,dst_reg)
p_IntegerToFloatingPoint(src_reg,dst_fpu_reg)
***************************************************************************/

#PSL_define p_FLT_Compare(src_fpu_reg1,src_fpu_reg2){
  _FLT_Compare(src_fpu_reg1,src_fpu_reg2);
}

#PSL_define p_FLT_Pattern_Compare(src_fpu_reg1,src_fpu_reg2){
  _FLT_Pattern_Compare(src_fpu_reg1,src_fpu_reg2);
}

#PSL_define  p_FLT_Add(src_fpu_reg1,src_fpu_reg2,dst_fpu_reg){
  _FLT_Add(src_fpu_reg1,src_fpu_reg2,dst_fpu_reg);
}

#PSL_define  p_FLT_Subtract(src_fpu_reg1,src_fpu_reg2,dst_fpu_reg){
  _FLT_Subtract(src_fpu_reg1,src_fpu_reg2,dst_fpu_reg);
}

#PSL_define  p_FLT_Multiply(src_fpu_reg1,src_fpu_reg2,dst_fpu_reg){
  _FLT_Multiply(src_fpu_reg1,src_fpu_reg2,dst_fpu_reg);
}

#PSL_define  p_FLT_Divide(src_fpu_reg1,src_fpu_reg2,dst_fpu_reg){
  _FLT_Divide(src_fpu_reg1,src_fpu_reg2,dst_fpu_reg);
}


#PSL_define  p_FloatingPointToInteger(src_fpu_reg,dst_reg){
  _FloatingPointToInteger(src_fpu_reg,dst_reg);
}

#PSL_define  p_IntegerToFloatingPoint(src_reg,dst_fpu_reg){
  _IntegerToFloatingPoint(src_reg,dst_fpu_reg);
}


/*****************************/
/**** 2. control macros ******/
/*****************************/

/*****************************************************************************/
/* 2.1 test Type field 						     */
/******************************************************************************

p_IfTypeEQ(SrcReg1,SrcReg2)
p_IfTypeEQImmediate(SrcReg,SrcImm)

p_IfTypeNE(SrcReg1,SrcReg2)
p_IfTypeNEImmediate(SrcReg,SrcImm)

******************************************************************************/

/*****************************************************************************/
/* 2.2 test MRB field 						     */
/******************************************************************************

p_IfMRBEQ(SrcReg1,SrcReg2)
p_IfMRBEQImmediate(SrcReg,SrcImm)

p_IfMRBNE(SrcReg1,SrcReg2)
p_IfMRBNEImmediate(SrcReg,SrcImm)

******************************************************************************/

/*****************************************************************************/
/* 2.3 test tag field all 						     */
/******************************************************************************

p_IfTagEQ(SrcReg1,SrcReg2)
p_IfTagEQImmediate(SrcReg,SrcImmType,SrcImmMRB)

p_IfTagNE(SrcReg1,SrcReg2)
p_IfTagNEImmediate(SrcReg,SrcImmType,SrcImmMRB)

******************************************************************************/

/*****************************************************************************/
/* 2.4 test CCR 							     */
/******************************************************************************

p_IfWordEQ()
p_IfWordNE()

p_IfEQ()
p_IfNE()
p_IfGT()
p_IfGE()
p_IfLT()
p_IfLE()

p_IfOverflow()
p_IfZeroDivide()

******************************************************************************/

/*****************************************************************************/
/*  2.5 test SCF 							     */
/******************************************************************************

p_IfSCFON()

******************************************************************************/

/*****************************************************************************/
/*  2.6 test FPU-CCR                                                         */
/**************************************************************************
p_If_FLT_EQ()
p_If_FLT_NE()
p_If_FLT_GE()
p_If_FLT_GT()
p_If_FLT_LE()
p_If_FLT_LT()
***************************************************************************/

#CTRL_define	p_IfTypeEQ(SrcReg1,SrcReg2)
{
			_IfTypeEQ(SrcReg1,SrcReg2)
}

#CTRL_define	p_IfTypeEQImmediate(SrcReg,SrcImm)
{
	_IfTypeEQImmediate(SrcReg,SrcImm)
/*
	$USE(D_P_Level_Work_2);
			_SetImmediateType(SrcImm,D_P_Level_Work_2);
			_IfTypeEQ(SrcReg,D_P_Level_Work_2)
	$RELEASE(D_P_Level_Work_2);
*/
}

#CTRL_define	p_IfTypeNE(SrcReg1,SrcReg2)
{
			_IfTypeNE(SrcReg1,SrcReg2)
}

#CTRL_define	p_IfTypeNEImmediate(SrcReg,SrcImm)
{
	_IfTypeNEImmediate(SrcReg,SrcImm)
/*
	$USE(D_P_Level_Work_2);
			_SetImmediateType(SrcImm,D_P_Level_Work_2);
			_IfTypeNE(SrcReg,D_P_Level_Work_2)
	$RELEASE(D_P_Level_Work_2);
*/
}

#CTRL_define	p_IfMRBEQ(SrcReg1,SrcReg2)
{
			_IfMRBEQ(SrcReg1,SrcReg2)
}

#CTRL_define	p_IfMRBEQImmediate(SrcReg,SrcImm)
{
			_IfMRBEQImmediate(SrcReg,SrcImm)
/*
	$USE(D_P_Level_Work_2);
			_SetImmediateMRB(SrcImm,D_P_Level_Work_2);
			_IfMRBEQ(SrcReg,D_P_Level_Work_2)
	$RELEASE(D_P_Level_Work_2);
*/
}

#CTRL_define	p_IfMRBNE(SrcReg1,SrcReg2)
{
			_IfMRBNE(SrcReg1,SrcReg2)
}

#CTRL_define	p_IfMRBNEImmediate(SrcReg,SrcImm)
{
			_IfMRBNEImmediate(SrcReg,SrcImm)
/*
	$USE(D_P_Level_Work_2);
			_SetImmediateMRB(SrcImm,D_P_Level_Work_2);
			_IfMRBNE(SrcReg,D_P_Level_Work_2)
	$RELEASE(D_P_Level_Work_2);
*/
}

#CTRL_define	p_IfTagEQ(SrcReg1,SrcReg2)
{
			_IfTagEQ(SrcReg1,SrcReg2)
}

#CTRL_define	p_IfTagEQImmediate(SrcReg,SrcImmType,SrcImmMRB)
{
/*
	$USE(D_P_Level_Work_2);
*/
			_SetImmediateType(SrcImmType,D_P_Level_Work_2);
			_SetImmediateMRB(SrcImmMRB,D_P_Level_Work_2);
			_IfTagEQ(SrcReg,D_P_Level_Work_2)
/*
	$RELEASE(D_P_Level_Work_2);
*/
}

#CTRL_define	p_IfTagNE(SrcReg1,SrcReg2)
{
			_IfTagNE(SrcReg1,SrcReg2)
}

#CTRL_define	p_IfTagNEImmediate(SrcReg,SrcImmType,SrcImmMRB)
{
/*
	$USE(D_P_Level_Work_2);
*/
			_SetImmediateType(SrcImmType,D_P_Level_Work_2);
			_SetImmediateMRB(SrcImmMRB,D_P_Level_Work_2);
			_IfTagNE(SrcReg,D_P_Level_Work_2)
/*
	$RELEASE(D_P_Level_Work_2);
*/
}

#CTRL_define	p_IfWordEQ()
{
/* IfEQ -> IfWordEQ */
_IfEQ()
/*
_IfWordEQ()
*/
}

#CTRL_define	p_IfWordNE()
{
/* IfNE -> IfWordNE */
_IfNE()
/*
_IfWordNE()
*/
}

#CTRL_define	p_IfEQ()
{
_IfEQ()
}

#CTRL_define	p_IfNE()
{
_IfNE()
}

#CTRL_define	p_IfGT()
{
_IfGT()
}

#CTRL_define	p_IfGE()
{
_IfGE()
}

#CTRL_define	p_IfLT()
{
_IfLT()
}

#CTRL_define	p_IfLE()
{
_IfLE()
}


#CTRL_define	p_IfOverflow()
{
_IfOverflow()
}

#CTRL_define	p_IfZeroDivide()
{
_IfZeroDivide()
}


#CTRL_define	p_IfSCFON()
{
_IfSCFON()
}
/*********floating*******/

#CTRL_define p_If_FLT_EQ(){
  _If_FLT_EQ()
}

#CTRL_define p_If_FLT_NE(){
  _If_FLT_NE()
}

#CTRL_define p_If_FLT_GE(){
  _If_FLT_GE()
}

#CTRL_define p_If_FLT_GT(){
  _If_FLT_GT()
}

#CTRL_define p_If_FLT_LE(){
  _If_FLT_LE()
}

#CTRL_define p_If_FLT_LT(){
  _If_FLT_LT()
}



/*************************************************************/
/*** 3. data macros -- names of the data are macro also ******/
/*************************************************************/
/*********************** ... as a logical configuration ******/

/* 3.1 temp reg for primitive level definitions */

#DATA_define D_Work_P_Level_1		XXX /* machin-dependent value */
#DATA_define D_P_Level_Work_2		XXX /* machin-dependent value */
/* it is not D_Work_P_Level_2, because it is used at the tail of control */
/* macro definition and can not be and "$RELEASE"ed.  */
/* D_Work_XXX without $USE/$RELEASE makes checker to be down. */



/* 3.2 kl1b operand fields */

	/*****************************************/
	/* may be not real register 		 */
	/* only value field in Word is effective */
	/*****************************************/

	/****************************************************************/
	/* primitive level macros are generic for			*/
	/* general registers and operand fields except following case.	*/
	/* ImmdiateField is only valid for src of value field of Word.	*/
	/* ex. p_MoveValue(ImmField,DstReg) :valid			*/
	/*     p_Add(SrcReg,ImmField,DstReg):valid			*/
	/****************************************************************/

/* 3.2.1 indirect register field to specify kl1b argument register */

/*
#OPR_define	_IndirectRegField1	XXX
#OPR_define	_IndirectRegField2	XXX
#OPR_define	_IndirectRegField3	XXX
#OPR_define	_IndirectRegField4	XXX
#OPR_define	_IndirectRegField5	XXX
#OPR_define	_IndirectRegField6	XXX
#OPR_define	_IndirectRegField7	XXX
#OPR_define	_IndirectRegField8	XXX
#OPR_define	_IndirectRegField9	XXX
#OPR_define	_IndirectRegField10	XXX
#OPR_define	_IndirectRegField11	XXX
#OPR_define	_IndirectRegField12	XXX
#OPR_define	_IndirectRegField13	XXX
#OPR_define	_IndirectRegField14	XXX
#OPR_define	_IndirectRegField15	XXX
#OPR_define	_IndirectRegField16	XXX
*/

/* 3.2.2 immediate value field */

/*
#OPR_define	_ImmediateField0	XXX
                ::: instruction code field !!! :::
#OPR_define	_ImmediateField1	XXX
#OPR_define	_ImmediateField2	XXX
#OPR_define	_ImmediateField3	XXX
#OPR_define	_ImmediateField4	XXX
#OPR_define	_ImmediateField5	XXX
#OPR_define	_ImmediateField6	XXX
#OPR_define	_ImmediateField7	XXX
#OPR_define	_ImmediateField8	XXX
#OPR_define	_ImmediateField9	XXX
#OPR_define	_ImmediateField10	XXX
#OPR_define	_ImmediateField11	XXX
#OPR_define	_ImmediateField12	XXX
#OPR_define	_ImmediateField13	XXX
#OPR_define	_ImmediateField14	XXX
#OPR_define	_ImmediateField15	XXX
#OPR_define	_ImmediateField16	XXX
 */

/**************************/
/* 3.3 tag field constant */
/**************************/
/******************************************************************** PSL **
$B%?%0%U%#!<%k%I$NCM$N$?$a$NDj5A(B

       written by goto@icot22      Tue Dec 20 13:21:55 1988
       revised by yamamoto@icot21      on Tue Feb  7 20:19:02 1989

********************************************************************* PSL **/

#CONST_define _MRB_0 	0
#CONST_define _MRB_1 	1

/****************************************************************************/
/****** 4 extensions for memory access with immediate operand field *******/
/****************************************************************************/
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   $B85$N(B  FILE NAME : /usr/pim/vpim/V0/primitives/prim_ext_opf.psl.c
   ----- CREATED   : by nishida@icot22, on Fri Dec 16 19:35:43 1988
   ----- LEVEL     : primitives
   ----- ABSTRACT  : extension for immediate opprrand field

<HERE WE ARE>
#PSL_define p_WriteWithOffsetOPR(src_reg, addr_reg, opr_field)
#PSL_define p_ReadWithOffsetOPR(addr_reg, opr_field, dst_reg)

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */
/******************************************************************** PSL **
  $B%*%Z%i%s%I%U%#!<%k%ICf$N%$%_%G%#%(!<%HCM$r;H$&$?$a$N3HD%(B

       written by nishida@icot22      Fri Dec 16 19:40:43 1988
       revised by yamamoto@icot21      on Tue Feb  7 19:17:04 1989

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define p_WriteWithOffsetOPR(src_reg, addr_reg, opr_field){
  @PROBE2{ probe_increment_counter(D_PROBE_COUNTER_TOTAL_WRITE);};
/*  @REGOPE_OPT {
    _WriteWithOffsetOPR(src_reg, addr_reg, opr_field); goto End;
  };
  $USE(D_Work_P_Level_1);
  _MoveImmediateValueFromImmediateField(opr_field, D_Work_P_Level_1);
  _AddressAdd(addr_reg, D_Work_P_Level_1, D_Work_P_Level_1);
  _Write(src_reg, D_Work_P_Level_1);
  $RELEASE(D_Work_P_Level_1);
 End:; */
  @REGOPE_OPT {
    _WriteWithOffsetOPR(src_reg, addr_reg, opr_field);
  } else {
    $USE(D_Work_P_Level_1);
    _MoveImmediateValueFromImmediateField(opr_field, D_Work_P_Level_1);
    _AddressAdd(addr_reg, D_Work_P_Level_1, D_Work_P_Level_1);
    _Write(src_reg, D_Work_P_Level_1);
    $RELEASE(D_Work_P_Level_1);
  };
}

#PSL_define p_ReadWithOffsetOPR(addr_reg, opr_field, dst_reg){
  @PROBE2{ probe_increment_counter(D_PROBE_COUNTER_TOTAL_READ);};
/*  @REGOPE_OPT {
    _ReadWithOffsetOPR(addr_reg, opr_field, dst_reg); goto End;
  };
  $USE(D_Work_P_Level_1);
  _MoveImmediateValueFromImmediateField(opr_field, D_Work_P_Level_1);
  _AddressAdd(addr_reg, D_Work_P_Level_1, D_Work_P_Level_1);
  _Read(D_Work_P_Level_1, dst_reg);
  $RELEASE(D_Work_P_Level_1);
 End:; */
  @REGOPE_OPT {
    _ReadWithOffsetOPR(addr_reg, opr_field, dst_reg);
  } else {
    $USE(D_Work_P_Level_1);
    _MoveImmediateValueFromImmediateField(opr_field, D_Work_P_Level_1);
    _AddressAdd(addr_reg, D_Work_P_Level_1, D_Work_P_Level_1);
    _Read(D_Work_P_Level_1, dst_reg);
    $RELEASE(D_Work_P_Level_1);
  };
}


