
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V10/interpreter/klb_vpim_io.psl.c
   ----- CREATED   : by yamamoto@icot22, on Sat Jun  9 18:56:16 1990
   ----- LAST SAVED: by yamamoto@icot22, on Tue Dec 25 15:02:52 1990
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : INTERPRETER
   ----- ABSTRACT  : vpim(pim/s)$B@lMQ$N(BI/O$BAH$_9~$_=R8l(B $B!J%G%P%C%0MQ!K(B 

vpim_open_file
vpim_close_file
vpim_read_file
vpim_write_file

vpim_put_console
vpim_get_console

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **

       written by yamamoto@icot22      on Tue Mar 13 17:48:36 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |    vpim_open_file     |     A1    |     A2    | 
    |                       |           |           |
    +-----------+-----------+-----------+-----------+
    |    A3     |                                   |
    |           |                                   |
    +-----------+-----------+-----------+-----------+

<Arguments>

 A1: $B%U%!%$%kHV9f!J=PNO!"(BINT$B!K(B 
 A2: $B%U%!%$%kL>!JF~NO!"#8%S%C%H%9%H%j%s%0!"6qBN2=$5$l$F$$$k$3$H!K(B 
 A3: $B%"%/%;%9%b!<%I!JF~NO!"(BINT: $B#0!'(Bread,$B#1!'(Bwrite$B!"6qBN2=$5$l$F$$$k$3$H!K(B 

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>

$B;XDj$5$l$?L>A0$N%U%!%$%k$r%*!<%W%s$9$k!#(B 

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_FileDescNew   _IndirectRegField1
#OPF_define I_FileName      _IndirectRegField2
#OPF_define I_AccessMode    _IndirectRegField3

#PSL_define vpim_open_file()
{
  $USE (D_Workreg);
  f_ActiveDeref (I_FileName, D_Workreg);
  $RELEASE (D_Workreg);
  TypeSwitch (I_FileName) {
    case StringGrp ():
      break;
    case UnboundGroup ():
    case INT:
    case ATOM:
    case FLT:
    case ListGrp ():
    case NullVectorGrp ():
    case ShortVectorGrp ():
    case LongVectorGrp ():
    case RefGroup ():
    case ControlGroup ():
    default:
      @DEBUG {VPIM_ERROR ("vpim_open_file", "illegal type");};
      break;
  }

  $USE (D_Workreg);
  f_ActiveDeref (I_AccessMode, D_Workreg);
  $RELEASE (D_Workreg);
  TypeSwitch (I_AccessMode) {
    case INT:
      break;
    case UnboundGroup ():
    case StringGrp ():
    case ATOM:
    case FLT:
    case ListGrp ():
    case NullVectorGrp ():
    case ShortVectorGrp ():
    case LongVectorGrp ():
    case RefGroup ():
    case ControlGroup ():
    default:
      @DEBUG {VPIM_ERROR ("vpim_open_file", "illegal type");};
      break;
  }

    _vpim_open_file(I_FileDescNew,I_FileName,I_AccessMode);
}


/******************************************************************** PSL **

       written by yamamoto@icot22      on Tue Mar 13 17:48:36 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |    vpim_close_file    |     A1    |           | 
    |                       |           |           |
    +-----------+-----------+-----------+-----------+

<Arguments>

 A1: $B%U%!%$%kHV9f!JF~NO!"(BINT,$B6qBN2=$5$l$F$$$k$3$H!K(B 

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_FileDescOld   _IndirectRegField1

#PSL_define vpim_close_file()
{

  $USE (D_Workreg);
  f_ActiveDeref (I_FileDescOld, D_Workreg);
  $RELEASE (D_Workreg);
  TypeSwitch (I_FileDescOld) {
    case INT:
      break;
    case UnboundGroup ():
    case StringGrp ():
    case ATOM:
    case FLT:
    case ListGrp ():
    case NullVectorGrp ():
    case ShortVectorGrp ():
    case LongVectorGrp ():
    case RefGroup ():
    case ControlGroup ():
    default:
      @DEBUG {VPIM_ERROR ("vpim_close_file", "illegal type");};
      break;
  }

    _vpim_close_file(I_FileDescOld);
}


/******************************************************************** PSL **

       written by yamamoto@icot22      on Tue Mar 13 17:48:36 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |    vpim_read_file     |     A1    |     A2    | 
    |                       |           |           |
    +-----------+-----------+-----------+-----------+
    |    A3     |    A4     |     A5    |           |
    |           |           |           |           |
    +-----------+-----------+-----------+-----------+

<Arguments>

 A1: $B%U%!%$%kHV9f!JF~NO(B,INT,$B6qBN2=$5$l$F$$$k$3$H(B $B!K(B 
 A2: $B%U%!%$%kHV9f!J=PNO!"(BINT $B!K(B 
 A3: $B%P%C%U%!!JF~NO!"#8%S%C%H%9%H%j%s%0!"6qBN2=$5$l$F$$$k$3$H!"(B
     MRBoff$B$G$"$k$3$H!K(B
 A4: $B%P%C%U%!!J=PNO!"#8%S%C%H%9%H%j%s%0!K(B 
 A5: $B%P%C%U%!Cf$NM-8z%G!<%?NL!J=PNO!"(BINT$B!"(B
     $B%P%C%U%!$N%9%H%j%s%0D9$h$j??$K>.$G$"$k>l9g(B End-Of-File $B$N0UL#$r4^$`!K(B 

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_FileDescOld   _IndirectRegField1
#OPF_define I_FileDescNew   _IndirectRegField2
#OPF_define I_StrBuffOld    _IndirectRegField3
#OPF_define I_StrBuffNew    _IndirectRegField4
#OPF_define I_Count         _IndirectRegField5

#PSL_define vpim_read_file()
{
  $USE (D_Workreg);
  f_ActiveDeref (I_StrBuffOld, D_Workreg);
  $RELEASE (D_Workreg);
  TypeSwitch (I_StrBuffOld) {
    case StringGrp ():
      break;
    case UnboundGroup ():
    case INT:
    case ATOM:
    case FLT:
    case ListGrp ():
    case NullVectorGrp ():
    case ShortVectorGrp ():
    case LongVectorGrp ():
    case RefGroup ():
    case ControlGroup ():
    default:
      @DEBUG {VPIM_ERROR ("vpim_read_file", "illegal type");};
      break;
  }

  $USE (D_Workreg);
  f_ActiveDeref (I_FileDescOld, D_Workreg);
  $RELEASE (D_Workreg);
  TypeSwitch (I_FileDescOld) {
    case INT:
      break;
    case UnboundGroup ():
    case StringGrp ():
    case ATOM:
    case FLT:
    case ListGrp ():
    case NullVectorGrp ():
    case ShortVectorGrp ():
    case LongVectorGrp ():
    case RefGroup ():
    case ControlGroup ():
    default:
      @DEBUG {VPIM_ERROR ("vpim_read_file", "illegal type");};
      break;
  }
    _vpim_read_file
      (I_FileDescOld,I_FileDescNew,I_StrBuffOld,I_StrBuffNew,I_Count);
}

/******************************************************************** PSL **

       written by yamamoto@icot22      on Tue Mar 13 17:48:36 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |    vpim_write_file    |     A1    |     A2    | 
    |                       |           |           |
    +-----------+-----------+-----------+-----------+
    |    A3     |    A4     |    A5     |           |
    |           |           |           |           |
    +-----------+-----------+-----------+-----------+

<Arguments>

 A1: $B%U%!%$%kHV9f!JF~NO!"(BINT$B!"6qBN2=$5$l$F$$$k$3$H!K(B 
 A2: $B%U%!%$%kHV9f!J=PNO!"(BINT$B!K(B 
 A3: $B%P%C%U%!!JF~NO!"#8%S%C%H%9%H%j%s%0!"6qBN2=$5$l$F$$$k$3$H(B,
     MRB0ff$B$G$"$k$3$H!K(B 
 A4: $B%P%C%U%!!J=PNO!"#8%S%C%H%9%H%j%s%0!K(B 
 A5: $B%P%C%U%!Cf$NM-8z%G!<%?NL!JF~NO!"(BINT$B!"6qBN2=$5$l$F$$$k$3$H!K(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_FileDescOld   _IndirectRegField1
#OPF_define I_FileDescNew   _IndirectRegField2
#OPF_define I_StrBuffOld    _IndirectRegField3
#OPF_define I_StrBuffNew    _IndirectRegField4
#OPF_define I_Count         _IndirectRegField5

#PSL_define vpim_write_file()
{
  $USE (D_Workreg);
  f_ActiveDeref (I_StrBuffOld, D_Workreg);
  $RELEASE (D_Workreg);
  TypeSwitch (I_StrBuffOld) {
    case StringGrp ():
      break;
    case UnboundGroup ():
    case INT:
    case ATOM:
    case FLT:
    case ListGrp ():
    case NullVectorGrp ():
    case ShortVectorGrp ():
    case LongVectorGrp ():
    case RefGroup ():
    case ControlGroup ():
    default:
      @DEBUG {VPIM_ERROR ("vpim_write_file", "I_StrBuffOld:illegal type");};
      break;
  }

  $USE (D_Workreg);
  f_ActiveDeref (I_FileDescOld, D_Workreg);
  $RELEASE (D_Workreg);
  TypeSwitch (I_FileDescOld) {
    case INT:
      break;
    case UnboundGroup ():
    case StringGrp ():
    case ATOM:
    case FLT:
    case ListGrp ():
    case NullVectorGrp ():
    case ShortVectorGrp ():
    case LongVectorGrp ():
    case RefGroup ():
    case ControlGroup ():
    default:
      @DEBUG {VPIM_ERROR ("vpim_write_file", "I_FileDescOld:illegal type");};
      break;
  }

  $USE (D_Workreg);
  f_ActiveDeref (I_Count, D_Workreg);
  $RELEASE (D_Workreg);
  TypeSwitch (I_Count) {
    case INT:
      break;
    case UnboundGroup ():
    case StringGrp ():
    case ATOM:
    case FLT:
    case ListGrp ():
    case NullVectorGrp ():
    case ShortVectorGrp ():
    case LongVectorGrp ():
    case RefGroup ():
    case ControlGroup ():
    default:
      @DEBUG {VPIM_ERROR ("vpim_write_file", "I_Count:illegal type");};
      break;
  }

    _vpim_write_file
      (I_FileDescOld,I_FileDescNew,I_StrBuffOld,I_StrBuffNew,I_Count);
}

/******************************************************************** PSL **

       written by yamamoto@icot22      on Tue Mar 13 17:48:36 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |    vpim_put_console   |     A1    |           | 
    |                       |           |           |
    +-----------+-----------+-----------+-----------+

<Arguments>

 A1: $B%3%s%=!<%k=PNO%G!<%?!JF~NO!K(B 

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>

INT$B$N;~!"2<0L#1%P%$%H$rJ8;z%3!<%I$H2r<a$7$F%3%s%=!<%k$K=PNO(B 
$B#8%S%C%H%9%H%j%s%0$N;~!"J8;zNs$H2r<a$7$F%3%s%=!<%k$K=PNO(B 
$B$=$NB>!"L5;k(B 

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_DataToDisplay   _IndirectRegField1

#PSL_define vpim_put_console()
{
  $USE (D_Workreg);
  f_ActiveDeref (I_DataToDisplay, D_Workreg);
  p_MoveWord(I_DataToDisplay,D_Workreg);
  _vpim_put_console(D_Workreg);
  $RELEASE (D_Workreg);
}

/******************************************************************** PSL **

       written by yamamoto@icot22      on Tue Mar 13 17:48:36 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |    vpim_get_console   |     A1    |     A2    | 
    |                       |           |           |
    +-----------+-----------+-----------+-----------+

<Arguments>

 A1: $B%3%s%=!<%k=PNO%G!<%?!JF~NO!"6qBN2=$5$l$F$$$k$3$H!K(B 
 A2: $B%-!<%\!<%IF~NO%G!<%?!J=PNO!"(BINT$B!K(B 

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>

A$B#1$r%W%m%s%W%H$H$7$F=PNO$7!"F~NO$rBT$D!#(B 
$B%3%s%=!<%k$N#19TF~NO$rE,Ev$J@0?t$KJQ49$7$F(BA2$B$H$9$k!#(B 
$BJQ49$N;EJ}!"@0?tI=5-!'@0?tCM!"6u9T!'%<%m!"(B $B$=$NB>!'>!<j$JCM!#(B 

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_PromptString      _IndirectRegField1
#OPF_define I_DataFromKeyBord   _IndirectRegField2

#DATA_define  D_WORK_GET_CONSOLE   XXX  /* used in vpim_io.c ... */
#DATA_define  D_WORK_GET_CONSOLE2   XXX  /* used in vpim_io.c ... */
#DATA_define  D_WORK_GET_CONSOLE3   XXX  /* used in vpim_io.c ... */
#DATA_define  D_WORK_GET_CONSOLE4   XXX  /* used in vpim_io.c ... */

#PSL_define vpim_get_console()
{
  $USE (D_Workreg);
  f_ActiveDeref (I_PromptString, D_Workreg);
  $RELEASE (D_Workreg);
  $USE(D_WORK_GET_CONSOLE);
  $USE(D_WORK_GET_CONSOLE2);
  $USE(D_WORK_GET_CONSOLE3);
  $USE(D_WORK_GET_CONSOLE4);
    _vpim_get_console(I_PromptString,I_DataFromKeyBord);
  $RELEASE(D_WORK_GET_CONSOLE4);
  $RELEASE(D_WORK_GET_CONSOLE3);
  $RELEASE(D_WORK_GET_CONSOLE2);
  $RELEASE(D_WORK_GET_CONSOLE);
}
