/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/interpreter/klb_unify_main.psl.c
   ----- CREATED   : by hirata@icot22, on Fri May 25 19:49:24 1990
   ----- LAST SAVED: by imai@icot22, on Wed Jul 22 10:33:23 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : interpreter
   ----- ABSTRACT  : general active unifier

A. $B3F%^%/%m$N8F$S=P$74X78(B
<< klb_unify_main.psl.c >>
		+--> i_ConnectHookLink -+-> $CALL(i_ConnectHookLink_Sub)
		|			|
		|			V
		+--> (UnifyUnbound) -------> f_UnifyRetryByDcode
		|
  klb_unify() --+--------------------+-------+
				     |	     |
<< klb_unify_bound.psl.c >>	     |	     |
  klb_unify_atom() --------+	     |	     |
  klb_unify_int()  --------+	     |	     |
  klb_unify_bound_value() -+	     |	     |
			   |	     |	     |
			   V	     |	     |
		i_KlbUnifyBound	     |	     |
			   |	     |	     |
			   V	     V	     |
		$CALL(i_KlbUnifyBound_Sub)   |
			       |	     |
			       V	     V
			i_Unify_List_List(arg1, arg2)
			i_Unify_SVect_SVect(arg1, arg2)
			i_Unify_LVect_LVect(arg1, arg2)
               		i_Unify_VOID

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

#DATA_define D_WorkPtr1		XXX
#DATA_define D_WorkPtr2		XXX

/******************************************************************** PSL **
unify Ai Aj
       written by nishida@icot22      Mon Dec  5 15:28:33 1988
       revised by goto@icot22      on Fri Jun 23 09:52:31 1989
  0            1            2            3            4
  +------------+------------+------------+------------+
  |        unify            |     Ai     |     Aj     |
  +------------+------------+------------+------------+

<Arguments>
  Ai      $B%l%8%9%?(B
  Aj      $B%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B!&(BAi$B$H(BAj$B$r%G%l%U%!%l%s%9$7!"%"%/%F%#%V%f%K%U%!%$$9$k(B
<Examples>
<Test>
<Explanation>
  $B!&%8%'%M%i%k%f%K%U%!%$$O!"(BD$B%3!<%I$r;HMQ$7$F(B
    $B:F5"8F=P$7$r<B8=$9$k!#(B

***  D code for list-list unify

  p([X1|Y1], [Y1|Y2])  :- true | X1 = Y1, X2 = Y2.

#DATA_define _Dcode_list_unifier[] {
                      reset_ssp
	              load_wait(CGP,0,R1,Lsusp)
		      is_list(R1,Lsusp)
		      read(R1,car,R2)
		      read(R1,cdr,R3)
	              load_wait(CGP,1,R4,Lsusp)
		      is_list(R4,Lsusp)
		      read(R4,car,R5)
		      read(R4,cdr,R6)
		      collect_list(R1)
		      collect_list(R4)
		      unify(R2,R5)
		      unify(R3,R6)
		      collect_goal(2,CGP)
		      proceed

	    Lsusp:    suspend
   
  }

***  D code for vect-vect unifier

  uni_v(0, V1, V2) :- true | true.
  uni_v(N, V1, V2) :- 
           N > 0,
           sub(N, 1, N1),
           vector_elem(V1, N1, Elm1),
           vector_elem(V2, N1, Elm2) |
           Elm1 = Elm2,
           uni_v(N1, V1, V2).


  #DATA_define _Dcode_vect_unifier[] {
           L1:   reset_ssp.
		 load_wait(CGP,R0,R1,Lsusp)
		 is_integer(R1,Lsusp)
		 test_integer(0,R1,L2)
		 load(CGP,2,R2)
		 collect_value(R2)
		 load(CGP,1,R2)
		 collect_value(R2)
		 collect_goal(3,CGP)
                 proceed

          L2 :   put_integer(0,R2)
		 integer_less_than(R2,R1,Lsusp)
		 put_integer(1,R2)
		 b_integer_subtract(R1,R2,R1)
		 mark(R1)
		 load(CGP,1,R2)
	         b_vector_element(R2,R1,R2,R3)
		 load(CGP,2,R4)
		 b_vector_element(R4,R1,R4,R5)
	         unify(R2,R4)
		 store(R1,CGP,0)
		 store(R3,CGP,1)
		 store(R5,CGP,2)
		 execute(3,L1)
			    
         Lsusp:  suspend

<ETC>
********************************************************************* PSL **/

#OPF_define I_RegSource1	_IndirectRegField1
#OPF_define I_RegSource2	_IndirectRegField2
#OPF_define I_ImmRegSource1	_ImmediateField1
#OPF_define I_ImmRegSource2	_ImmediateField2

#PSL_define klb_unify()
{
  @DEBUG{
    b_IfRangeErr(I_ImmRegSource1, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_unify", "r1_range");
    }
    b_IfRangeErr(I_ImmRegSource2, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_unify", "r2_range");
    }
    s_IfArgTypeErr (I_RegSource1){ 
      VPIM_ERROR ("klb_unify", "Illegal type 1");
    }
    s_IfArgTypeErr (I_RegSource2){ 
      VPIM_ERROR ("klb_unify", "Illegal type 2");
    }
  };

  @TRACE{
    f_IfTraceMode() {
      f_TraceActiveUnify(UNIFY, I_RegSource1, I_RegSource2);
      goto End_of_KL1B_Instruction;
    }
  };
  @PROBE{unify_probe(I_RegSource1, I_RegSource2, UNIFY);};

  $CALL( i_GeneralUnify_Sub (I_RegSource1,I_RegSource2) );
 End_of_KL1B_Instruction:;
}

#SUBARG_define   A_Src1         MODIFY
#SUBARG_define   A_Src2         MODIFY

#SUBROUTINE	i_GeneralUnify_Sub ( A_Src1, A_Src2 )
{
  $USE(D_WorkPtr1);
 Unify_Retry_Label_FromSrc1:
  f_ActiveDeref(A_Src1, D_WorkPtr1);
  s_IfNotUnbound_Opt ( A_Src1 ) {
  /******************************************************
   * case 1						*
   *    arg1 : Not UNBOUND, not REF	(A_Src1)	*
   * 	arg2 : 	??			(A_Src2)	*
   ******************************************************/
    $RELEASE(D_WorkPtr1);
    s_TurnMRBoffIfAtomic( A_Src1 );
    $CALL( i_KlbUnifyBound_Sub ( A_Src2, A_Src1 ) );
    $RETURN();
  }

  $USE(D_WorkPtr2);
 Unify_Retry_Label_FromSrc2:
  f_ActiveDeref(A_Src2, D_WorkPtr2);
  s_IfNotUnbound_Opt ( A_Src2 ) {
  /******************************************************
   * case 2						*
   *    arg1 :  A_Src1 = *D_WorkPtr1 = Unbound		*
   * 	arg2 :  A_Src2 = bound, Not REF			*
   ******************************************************/
    p_MoveWord(D_WorkPtr1, A_Src1);
    $RELEASE(D_WorkPtr1);
    $RELEASE(D_WorkPtr2);
    s_TurnMRBoffIfAtomic( A_Src2 );
    $CALL( i_KlbUnifyBound_Sub ( A_Src1, A_Src2) );
    $RETURN();
  }
  /******************************************************
   * case 3						*
   *    arg1 :  A_Src1 = Unbound, 			*
   *		D_WorkPtr1 = REF			*
   * 	arg2 :  A_Src2 = Unbound, 			*
   *		D_WorkPtr2 = REF			*
   ******************************************************/
  @PROBE { s_CountType (A_Src1); };

  TypeSwitch (A_Src1) {
  case UNDF:
  Label_UNDF_Reg1:
    /*==========================================*
     * src 1: UNDF				*
     *==========================================*/
    TypeSwitch (A_Src2) {
    case UNDF:
    Label_UNDF_Reg1_UNDF_Reg2:
       /*---------------------------------------------------------------*
	*	src1: UNDF	src2: UNDF				*
	* $B%"%I%l%9$rHf3S$7$F(B higher addr $B$+$i(B lower addr $B$X%j%s%/$rD%$k(B *
	*---------------------------------------------------------------*/
      p_Compare(D_WorkPtr1, D_WorkPtr2);
      p_IfGT() {			/* D_WorkPtr1 > D_WorkPtr2 */
        /*** $B$?$@$7(BA_Src1, A_Src2 $B$NFbMF$OJQ2=$9$k2DG=@-$"$j(B ***/
        f_MakeConnectionPathWithoutCompare(D_WorkPtr1, A_Src1, D_WorkPtr2);
	/* KL1 $B$N0z?t%l%8%9%?>e$K$$$-$J$jL$Dj5AJQ?t$,:\$i$J$$$h$&$K$9$k$?$a(B */
	p_MoveWord (D_WorkPtr1, A_Src1);  p_MoveWord (D_WorkPtr2, A_Src2);
	$RELEASE(D_WorkPtr1);	$RELEASE(D_WorkPtr2);
	$RETURN();
      }
      p_IfLT() {			/* D_WorkPtr1 < D_WorkPtr2 */
	  /*** $BF1MM$K(BA_Src1, A_Src2 $B$NFbMF$OJQ2=$9$k2DG=@-$"$j(B ***/
	f_MakeConnectionPathWithoutCompare(D_WorkPtr2, A_Src2, D_WorkPtr1);
	/* KL1 $B$N0z?t%l%8%9%?>e$K$$$-$J$jL$Dj5AJQ?t$,:\$i$J$$$h$&$K$9$k$?$a(B */
	p_MoveWord (D_WorkPtr1, A_Src1);  p_MoveWord (D_WorkPtr2, A_Src2);
	$RELEASE(D_WorkPtr1);	$RELEASE(D_WorkPtr2);
	$RETURN();
      }
      /* else $B%]%$%s%?$,Ey$7$$$N$G%f%K%U%#%1!<%7%g%s$O@.8y(B */
      goto End_of_General_Unify;
    case HookGrp():
    case ExpVarGrp():
    case StreamGrp():
       /*---------------------------------------------------------------*
	*	src1: UNDF	src2: HookGrp, ExpVarGrp, StreamGrp	*
        *	UNDF $BB&$+$i(B HookGrp, ExpVarGrp, StreamGrp $BB&$K%Q%9$rD%$k(B*
	*---------------------------------------------------------------*/
      $CALL( i_MakeConnectionPath_Sub(D_WorkPtr1, A_Src1, D_WorkPtr2) );
      goto End_of_General_Unify;
    case VOID:
       /*---------------------------------------------------------------*
	*	src1: UNDF	src2: VOID				*
	*---------------------------------------------------------------*/
      s_IfMRBoff(D_WorkPtr2) {
	f_Unify_VOID(D_WorkPtr2, D_WorkPtr1);
	goto End_of_General_Unify;
      } else {
	goto Label_UNDF_Reg1_UNDF_Reg2;
      }
    case EX_Grp():
       /*---------------------------------------------------------------*
	*	src1: UNDF	src2: EX_Grp				*
	*---------------------------------------------------------------*/
      f_Unify_EX_General( D_WorkPtr2, A_Src2, D_WorkPtr1 );
      goto End_of_General_Unify;
    case EXLOCK:
       /*---------------------------------------------------------------*
	*	src1: UNDF	src2: EXLOCK				*
	*---------------------------------------------------------------*/
      p_MoveWord(D_WorkPtr2, A_Src2);
      goto  Unify_Retry_Label_FromSrc2;
    default:
/*      b_JumpCSPByVpimError();	*/
      @DEBUG{ VPIM_ERROR ("klb_unify", "Illegal_type"); };
      goto End_of_General_Unify;
    }
  case HookGrp():
  Label_HOOK_Reg1:
    /*==========================================*
     * src 1: HookGrp()				*
     *==========================================*/
    TypeSwitch(A_Src2) {
       /*---------------------------------------------------------------*
	*	src1: HookGrp	src2: UNDF				*
        *	UNDF $B$+$i(B HookGrp $B$K%Q%9$rD%$k(B				*
	*---------------------------------------------------------------*/
    case UNDF:
    Label_HookGrp_Reg1_UNDF_Reg2:
      $CALL( i_MakeConnectionPath_Sub(D_WorkPtr2, A_Src2, D_WorkPtr1) );
      goto End_of_General_Unify;
       /*---------------------------------------------------------------*
	*	src1: HookGrp	src2: EUNDF				*
        *  HookGrp $B$r(B EHookGrp $B$K=q$-49$(!"(B				*
	*	EUNDF $B$+$i(B HookGrp $B$K%Q%9$rD%$k(B				*
	*---------------------------------------------------------------*/
    case EUNDF:
      f_IfFailCompareSwap_UnboundToEunboundX(D_WorkPtr1, A_Src1){
/*	$RARE;	*/
	@DEBUG{ WARNING("i_GeneralUnify","Excell SoftLock Failed"); };
	p_MoveWord(D_WorkPtr2, A_Src2);
	goto  Unify_Retry_Label_FromSrc2;
      } else {
	goto  Label_HookGrp_Reg1_UNDF_Reg2;
      }
       /*---------------------------------------------------------------*
	*	src1: HookGrp	src2: HookGrp, EHookGrp			*
	* $B%"%I%l%9$rHf3S$7$F(B higher addr $B$+$i(B lower addr $B$X%j%s%/$rD%$k(B *
	*---------------------------------------------------------------*/
    case HookGrp():
    case EHookGrp():
      p_Compare(D_WorkPtr1, D_WorkPtr2);
      p_IfGT() {			/* D_WorkPtr1 > D_WorkPtr2 */
	f_ConnectHookLink(D_WorkPtr1, A_Src1, D_WorkPtr2, A_Src2);
	goto  End_of_General_Unify;
      }
      p_IfLT() {			/* D_WorkPtr1 < D_WorkPtr2 */
	f_ConnectHookLink(D_WorkPtr2, A_Src2, D_WorkPtr1, A_Src1);
	goto  End_of_General_Unify;
      }
      /* else $B%]%$%s%?$,Ey$7$$$N$G%f%K%U%#%1!<%7%g%s$O@.8y(B */
      goto  End_of_General_Unify;
       /*---------------------------------------------------------------*
	*	src1: HookGrp	src2: HookGrp, EX_Grp			*
	*---------------------------------------------------------------*/
    case EX_Grp():
      f_Unify_EX_General(D_WorkPtr2, A_Src2, D_WorkPtr1);
      goto  End_of_General_Unify;
       /*---------------------------------------------------------------*
	*	src1: HookGrp	src2: HookGrp, EX_Grp			*
	*---------------------------------------------------------------*/
    case StreamGrp():
      $CALL( f_Unify_MGHOK_HookGrp_Sub
	    (D_WorkPtr2,A_Src2,D_WorkPtr1,A_Src1) );
      goto  End_of_General_Unify;
       /*---------------------------------------------------------------*
	*	src1: HookGrp	src2: VOID				*
	*---------------------------------------------------------------*/
    case VOID:
      s_IfMRBoff(D_WorkPtr2) {
	f_Unify_VOID(D_WorkPtr2, D_WorkPtr1);
	goto End_of_General_Unify;
      } else {
	goto  Label_HookGrp_Reg1_UNDF_Reg2;
      }
    case EXLOCK:
      p_MoveWord(D_WorkPtr2, A_Src2);
      goto  Unify_Retry_Label_FromSrc2;
    default:
/*      b_JumpCSPByVpimError();	*/
      @DEBUG { VPIM_ERROR ("klb_unify", "Illegal_type"); }; break;
    }
    break;
    /*==========================================*
     * src 1: EUNDF				*
     *==========================================*/
  case EUNDF:
    TypeSwitch(A_Src2) {
       /*---------------------------------------------------------------*
	*	src1: EUNDF	src2: UNDF				*
	*  UNDF $B$+$i(B EUNDF $B$K%Q%9$rD%$k(B 				*
	*---------------------------------------------------------------*/
    case UNDF:
      $CALL( i_MakeConnectionPath_Sub(D_WorkPtr2, A_Src2, D_WorkPtr1) );
      goto End_of_General_Unify;
       /*---------------------------------------------------------------*
	*	src1: EUNDF	src2: HOOK				*
        *  HookGrp $B$r(B EHookGrp $B$K=q$-49$(!"(B				*
	*	EUNDF$B$+$i(BHOOK, MHOOK$BB&$K%Q%9$rD%$k(B			*
	*---------------------------------------------------------------*/
    case HookGrp():
      f_IfFailCompareSwap_UnboundToEunboundX(D_WorkPtr2, A_Src2){
/*	$RARE;	*/
	$CALL( f_UnifyRetryByDcode_Sub (D_WorkPtr2, D_WorkPtr1) );
	@DEBUG{ WARNING("i_GeneralUnify","Excell SoftLock Failed"); };
      } else {
	$CALL( i_MakeConnectionPath_Sub (D_WorkPtr1, A_Src1, D_WorkPtr2) );
      }
      goto End_of_General_Unify;
    case EX_Grp():
       /*---------------------------------------------------------------*
	*	src1: EUNDF	src2:  EX_Grp				*
	*---------------------------------------------------------------*/
      f_Unify_EX_Eundf( D_WorkPtr2, A_Src2, D_WorkPtr1 );
      goto End_of_General_Unify;
    default:
       /*---------------------------------------------------------------*
	*	src1: EUNDF	src2:  $B$=$l0J30(B				*
	*  src1 $B$,(B UNDF $B$N>l9g$HF1$8=hM}$GNI$$(B				*
	*---------------------------------------------------------------*/
      goto Label_UNDF_Reg1;
    }
    /*==========================================*
     * src 1: EHookGrp()			*
     *==========================================*/
  case EHookGrp():
    TypeSwitch(A_Src2) {
    case EX_Grp():
       /*---------------------------------------------------------------*
	*	src1: EHookGrp	src2:  EX_Grp				*
	*---------------------------------------------------------------*/
      f_Unify_EX_Eundf( D_WorkPtr2, A_Src2, D_WorkPtr1 );
      goto End_of_General_Unify;
    default:
       /*---------------------------------------------------------------*
	*	src1: EHookGrp	src2:  $B$=$l0J30(B				*
	*  src1 $B$,(B HOOK $B$N>l9g$HF1$8=hM}$GNI$$(B				*
	*---------------------------------------------------------------*/
      goto Label_HOOK_Reg1;
    }
  case StreamGrp():
    /*==========================================*
     * src 1: StreamGrp()			*
     *==========================================*/
    $CALL( f_Unify_MGHOK_Sub(D_WorkPtr1,A_Src1,D_WorkPtr2,A_Src2) );
    goto End_of_General_Unify;
  case VOID:
    /*==========================================*
     * src 1: VOID				*
     *==========================================*/
    s_IfMRBoff(D_WorkPtr1) {
      f_Unify_VOID (D_WorkPtr1,D_WorkPtr2);
      goto End_of_General_Unify;
    } else {
      goto Label_UNDF_Reg1;
    }
  case EX_Grp():
    /*==========================================*
     * src 1: EX_Grp				*
     *==========================================*/
    f_Unify_EX_General(D_WorkPtr1, A_Src1, D_WorkPtr2);
    goto End_of_General_Unify;
  case EXLOCK:
    /*==========================================================*
     * src 1: EXLOCK ------> $B%m%C%/$,30$l$k$^$G:F;n9T$9$k(B	*
     *==========================================================*/
    p_MoveWord( D_WorkPtr2, A_Src2 );
    $RELEASE( D_WorkPtr2 );
    p_MoveWord( D_WorkPtr1, A_Src1 );
    goto Unify_Retry_Label_FromSrc1;
  default:
/*      b_JumpCSPByVpimError();	*/
    @DEBUG{ VPIM_ERROR("i_ActiveUnify_Sub","Illegal Type"); };
  }
 End_of_General_Unify:
	/* KL1 $B$N0z?t%l%8%9%?>e$K$$$-$J$jL$Dj5AJQ?t$,:\$i$J$$$h$&$K$9$k$?$a(B */
  p_MoveWord( D_WorkPtr1, A_Src1 ); 
  p_MoveWord( D_WorkPtr2, A_Src2 ); 
  $RELEASE( D_WorkPtr1 ); $RELEASE( D_WorkPtr2 );
  $RETURN();
}

#SUBARG_define	A_Ptr1	SRC
#SUBARG_define	A_Old	MODIFY
#SUBARG_define	A_New	SRC

#SUBROUTINE	i_MakeConnectionPath_Sub(A_Ptr1, A_Old, A_New)
{
  f_MakeConnectionPath(A_Ptr1, A_Old, A_New);
  $RETURN();
}
