
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/interpreter/klb_unify_bound.psl.c
   ----- CREATED   : by hirata@icot22, on Fri May 25 19:55:02 1990
   ----- LAST SAVED: by imai@icot22, on Thu Oct 24 13:47:54 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : interpreter
   ----- ABSTRACT  : active unifier of UNDEF with bounded
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

#DATA_define D_WorkConst	XXX

/******************************************************************** PSL **
unify_atom  atom Reg

       written by goto@icot22      on Thu Jul  6 12:12:00 1989

  0            1            2            3            4
  +------------+------------+------------+------------+
  |     new_unify_atom      |      don't care         |
  +------------+------------+------------+------------+
  |                       atom                        |
  +------------+------------+------------+------------+
  |     Reg    |                  don't  care         |
  +------------+------------+------------+------------+

<Arguments>
  Ri      $B%l%8%9%?(B
  atom    $BB(CM(B

<Function>
  $B!&(BRi$B$r%G%l%U%!%l%s%9$7!"(Batom$B$H%"%/%F%#%V%f%K%U%!%$$9$k(B
<ETC>
********************************************************************* PSL **/

#OPF_define I_ImmAtom  _ImmediateField1
#OPF_define I_RegSource  _IndirectRegField2

#OPF_define I_ImmRegSource _ImmediateField2

#PSL_define klb_unify_atom ()
{
  @DEBUG{
    b_IfRangeErr(I_ImmRegSource, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("klb_unify_atom","r2_range");
    }
  };
  $USE(D_WorkConst);
  b_MoveImmOprWithMRBandType (I_ImmAtom, _MRB_OFF, ATOM, D_WorkConst);

  @TRACE{
    f_IfTraceMode() {
      f_TraceActiveUnify(UNIFY_ATOM, I_RegSource, D_WorkConst);
      goto End_of_KL1B_Instruction;
    }
  };
  @PROBE{ unify_probe(D_WorkConst,I_RegSource,UNIFY_ATOM); };

  i_KlbUnifyBound (I_RegSource, D_WorkConst);
 End_of_KL1B_Instruction:
  $RELEASE(D_WorkConst);
}


/******************************************************************** PSL **
unify_integer integer Ri

       written by goto@icot22      on Thu Jul  6 12:15:07 1989

  0            1            2            3            4
  +------------+------------+------------+------------+
  |  new_unify_integer      |         don't care      |
  +------------+------------+------------+------------+
  |                     integer                       |
  +------------+------------+------------+------------+
  |    Ri      |             don't care               |
  +------------+------------+------------+------------+
<Arguments>
  Ri      $B%l%8%9%?(B
  integer $BB(CM(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B!&(BRi$B$r%G%l%U%!%l%s%9$7!"(Binteger$B$H%"%/%F%#%V%f%K%U%!%$$9$k(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_ImmInt  _ImmediateField1
#OPF_define I_RegSource  _IndirectRegField2

#OPF_define I_ImmRegSource  _ImmediateField2

#PSL_define klb_unify_integer()
{
  @DEBUG {
    b_IfRangeErr(I_ImmRegSource, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_unify_integer", "r2_range");
    }
  };
  $USE(D_WorkConst);
  b_MoveImmOprWithMRBandType (I_ImmInt, _MRB_OFF, INT, D_WorkConst);
  @TRACE{
    f_IfTraceMode() {
      f_TraceActiveUnify(UNIFY_INTEGER, I_RegSource, D_WorkConst);
      goto End_of_KL1B_Instruction;
    }
  };
  @PROBE{ unify_probe(D_WorkConst,I_RegSource,UNIFY_INTEGER); };
  i_KlbUnifyBound (I_RegSource, D_WorkConst);
 End_of_KL1B_Instruction:
  $RELEASE(D_WorkConst);
}

/******************************************************************** PSL **
unify_bound_value Rstr, Reg

       written by goto@icot22      on Thu Jul  6 12:20:57 1989

  0            1            2            3            4
  +------------+------------+------------+------------+
  |     unify_bound_value   |    Rbound  |    Reg     |
  +------------+------------+------------+------------+
<Arguments>
  Rbound     $B%l%8%9%?(B($B6qBN2=$7$?CM!&9=B$BN$r;X$9%l%8%9%?(B)
  Reg        $B%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B!&(BReg$B$r%G%l%U%!%l%s%9$7!"(BRbound$B$H%"%/%F%#%V%f%K%U%!%$$9$k(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_RegToBounded _IndirectRegField1 /* $B6qBN2=$7$?$b$N$X$N%]%$%s%?(B*/
#OPF_define I_RegToVar     _IndirectRegField2 /* $BJQ?t(B($BL$Dj5A(B)$B$X$N%]%$%s%?(B*/
#OPF_define I_ImmRegToBounded	_ImmediateField1
#OPF_define I_ImmRegToVar	_ImmediateField2

#PSL_define klb_unify_bound_value()
{
  @DEBUG{
    b_IfRangeErr(I_ImmRegToBounded, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_unify_bound_value", "r1_range");
    }
    b_IfRangeErr(I_ImmRegToVar, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_unify_bound_value", "r2_range");
    }
    s_IfNotStruct(I_RegToBounded) { /* ==> s_IfREF  */
      s_IfNotFLT(I_RegToBounded) { 
	VPIM_ERROR("klb_unify_bound_value", "R1_is_Not_Struct");
      }
    }
  };
  @TRACE{
    f_IfTraceMode() {
      f_TraceActiveUnify(UNIFY_BOUND_VALUE, I_RegToBounded, I_RegToVar);
      goto End_of_KL1B_Instruction;
    }
  };
  @PROBE{ unify_probe(I_RegToBounded,I_RegToVar,UNIFY_BOUND_VALUE); };
  i_KlbUnifyBound (I_RegToVar, I_RegToBounded);
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
"REF --> UNDF"$B$H(BBounded$B$N%"%/%F%#%V%f%K%U%!%$L?Na$NK\BN(B
       written by hirata@icot22      on Fri May 25 20:49:45 1990
<Arguments>
  arg_reg : $B%f%K%U%#%1!<%7%g%s$NBP>]$H$J$k(B(UNDEF or Bounded)$BJQ?t(B
  bound_reg : $B%f%K%U%#%1!<%7%g%s$NBP>]$H$J$kDj?t$+9=B$BN$X$N%]%$%s%?(B
		$B$r;}$D%l%8%9%?!#%]%$%s%?$N>l9g$O!"(BDeref$B:Q$_$G!"(B
		LIST or VECT $BEy$N%?%0$r;}$D!#(B
<Temporally Used Variables>
  D_WorkPtr1
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $B%f%K%U%#%1!<%7%g%s$NBP>]$H$J$kJQ?t$,(B "REF --> UNDF" $B$N;~$N$_$r(B
  $B:GE,2=$9$k%k!<%A%s(B
<ETC>
********************************************************************* PSL **/

#PSL_define i_KlbUnifyBound (arg_reg, bound_reg)
{
  s_IfNotREF (arg_reg) {goto Label_GeneralKlbUnifyBound;}
  $USE(D_WorkPtr1);
  s_DerefReg (arg_reg, D_WorkPtr1);	/* $B0lCJ$@$1%G%l%U%!%l%s%9(B */
  s_IfUNDF (arg_reg) {
    s_TurnMRBoffIfAtomic(bound_reg);
    f_IfSuccessActUnifyWithPtrMRBX (D_WorkPtr1, arg_reg, bound_reg){
      p_MoveWord (bound_reg, arg_reg);
      $RELEASE(D_WorkPtr1);
      goto END;
    } else {
      p_MoveWord (D_WorkPtr1, arg_reg);
      /* retry $B$9$kHt$S@h$N(B f_ActiveDeref $B$N0z?t$K(BUnbound$B$rD>@\EO$5$J$$$?$a!#(B*/
      $RELEASE(D_WorkPtr1);
      goto Label_GeneralKlbUnifyBound;
    }
  } else {
    p_MoveWord (D_WorkPtr1, arg_reg);
    /* retry $B$9$kHt$S@h$N(B f_ActiveDeref $B$N0z?t$K(BUnbound$B$rD>@\EO$5$J$$$?$a!#(B*/
    $RELEASE(D_WorkPtr1);
  }    /* end of s_IfUNDF */
 Label_GeneralKlbUnifyBound:
  $CALL( i_KlbUnifyBound_Sub ( arg_reg, bound_reg ) );
 END: ;
}

/******************************************************************** PSL **
$B0lJ}$N0z$-?t$,(BBounded$B$G$"$k$h$&$J(Bactive unification$B$N%5%V%k!<%A%s(B
       written by hirata@icot22      on Fri May 25 21:37:24 1990
<Arguments>
  A_Arg : $B%f%K%U%#%1!<%7%g%s$NBP>]$H$J$k0z?t$N%3%T!<(B
  A_BoundReg : $B%f%K%U%#%1!<%7%g%s$NBP>]$H$J$kCM(B($BDj?t(B,$B%]%$%s%?(B)$B$r;}$D%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
  i_KlbUnifyBound $B$+$i8F$S=P$5$l$kHFMQ%5%V%k!<%A%s(B
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

/* #DATA_define D_WorkExCell1    XXX */
#DATA_define	D_WorkPtrToDerefCell	XXX

#SUBARG_define	A_Arg		MODIFY
#SUBARG_define	A_BoundReg	MODIFY	/* ?? */

#SUBROUTINE i_KlbUnifyBound_Sub (A_Arg, A_BoundReg)
{
  @DEBUG{ 
    s_IfREF(A_BoundReg){
      VPIM_ERROR("i_KlbUnifyBound_Sub","Illegal Type (A_BoundReg) REF!!");
    }
    s_IfUnbound(A_BoundReg){
      VPIM_ERROR("i_KlbUnifyBound_Sub","Illegal Type (A_BoundReg) Unbound!!");
    }
    s_IfArgTypeErr(A_Arg){
      VPIM_ERROR("i_KlbUnifyBound_Sub","Illegal Type (A_Arg) !!");
    }
    s_IfUnbound(A_Arg){
      VPIM_ERROR("i_KlbUnifyBound_Sub","Illegal Type (A_Arg)Direct Unbound!!");
    }
  };
  $USE(D_WorkPtrToDerefCell);
  s_TurnMRBoffIfAtomic(A_BoundReg);
 LabelRetry_KlbUnify:
  f_ActiveDeref(A_Arg, D_WorkPtrToDerefCell);
  @PROBE { s_CountType (A_Arg); };
  TypeSwitch(A_Arg) {
    case ATOM:    case INT:
      b_IfTypeValueEq(A_Arg, A_BoundReg) {
	break;  /* $B%f%K%U%#%1!<%7%g%s@.8y(B */
      }
      $CALL( f_FailActiveUnify_Sub (A_Arg, A_BoundReg) );
      break;
    case FloatingGrp():
      @DEBUG {WARNING("i_KlbUnifyBound_Sub","Floating Type Unification");};
      p_IfTypeEQ(A_Arg, A_BoundReg) {
	b_IfNotEqual(A_Arg, A_BoundReg) {
	  f_IfFloatingEqual(A_Arg, A_BoundReg) { break; }
        } else { break; }
      }
      goto FailActiveUnify;
    case LIST:
      s_IfLIST (A_BoundReg)  {
	b_IfNotEqual(A_Arg, A_BoundReg){
	  f_Unify_List_List (A_Arg, A_BoundReg);
	  break;
	}
      } else {	goto FailActiveUnify; }
      break;
    case StringGrp():
      p_IfTypeEQ(A_Arg, A_BoundReg) {
	b_IfNotEqual(A_Arg, A_BoundReg) {
	  f_IfStringEqual(A_Arg, A_BoundReg) { break; }
        } else { break; }
      }
      goto FailActiveUnify;
    case ShortVectorGrp():
    case LongVectorGrp(): 
      s_IfVectors (A_BoundReg)  {	
	b_IfNotEqual(A_Arg, A_BoundReg){
	  f_Unify_Vect_Vect (A_Arg, A_BoundReg);
	}
      } else { goto FailActiveUnify; }
      break;
    case NullVectorGrp():
/* $B%J%k%Y%/%?$NCMIt$r(B 0 $B$HJ]>Z$9$k$J$i$P=hM}$O%"%H%_%C%/$HF1$8$GNI$$!#(B*/
      s_IfNotNullVectors (A_BoundReg)  { goto FailActiveUnify; } 	
      break;
    case RefGroup(): 
      @DEBUG { VPIM_ERROR ("klb_unify_atom", "Illegal_type"); }; break;
    case VOID: 
	/* $B:n$i$l$?;~$O(BVOID$B$G$"$C$?$,!"(B
	 * +-------+      +---------+
	 * | REFo ------->| VOID    |  ($B6qBN2=$7$F$bB>$N;2>H%Q%9$,$J$$$N$G(B
	 * +-------+      +---------+   $BB(:B$K2s<}$9$k!#(B)
	 * $B$=$N8e!"(Bmark$BL?Na$,=P$F!"(B
	 * +-------+      +---------+
	 * | REFx ------->| VOID    |  (UNDF$BF1MM$K6qBN2=$9$l$PNI$$(B)
	 * +-------+  |   +---------+
	 * +-------+  |
	 * | REFx ----+
	 * +-------+
         * $B$H$J$k%1!<%9$,$"$k!#(B
	 */
      s_IfMRBoff(A_Arg) {
	f_Unify_VOID (D_WorkPtrToDerefCell, A_BoundReg);
	break;
      } /* else { same as case UNDF: } */
    case UNDF:
    case EUNDF:
      f_IfSuccessActUnifyWithPtrMRBX (D_WorkPtrToDerefCell, A_Arg, A_BoundReg){
	p_MoveWord (A_BoundReg, A_Arg);
      } else {
	p_MoveWord (D_WorkPtrToDerefCell, A_Arg);
	/* retry $B$9$kHt$S@h$N(Bf_ActiveDeref$B$N0z?t$K(BUnbound$B$rD>@\EO$5$J$$$?$a!#(B*/
	goto LabelRetry_KlbUnify;
      }
      break;
    case HookGrp(): 
    case EHOOK:
    case EMHOK:
    case RHOOK:
      f_IfSuccessActUnifyWithPtrMRBX (D_WorkPtrToDerefCell, A_Arg, A_BoundReg){
	$CALL( f_WakeUpProcess_Sub( A_Arg) );
	p_MoveWord (A_BoundReg, A_Arg);
      } else {
	p_MoveWord (D_WorkPtrToDerefCell, A_Arg);
	/* retry $B$9$kHt$S@h$N(Bf_ActiveDeref$B$N0z?t$K(BUnbound$B$rD>@\EO$5$J$$$?$a!#(B*/
	goto LabelRetry_KlbUnify;
      }
      break;
    case RDHOK:
    case ExrefGrp():	
    case ExvalGrp():
      f_Unify_EX_Bounded(D_WorkPtrToDerefCell, A_Arg, A_BoundReg);
      break;
    case EXLOCK: /* $B%=%U%H%m%C%/Cf$O(B Busy Wait */
      p_MoveWord (D_WorkPtrToDerefCell, A_Arg);
      goto  LabelRetry_KlbUnify;
    case StreamGrp():	/* MGHOK */
      $CALL(f_Unify_MGHOK_Bound_Sub(D_WorkPtrToDerefCell,A_Arg,A_BoundReg));
      break;
    /*---case ControlGroup():---*/
    case COD:
    case MOD:
      b_IfTypeValueNotEq(A_Arg,A_BoundReg) {
	goto FailActiveUnify;
      }
      break;
    default: 
      @DEBUG { VPIM_ERROR ("i_KlbUnifyBound_Sub", "Illegal_type");}; break;
  }
  $RELEASE(D_WorkPtrToDerefCell);
  $RETURN ();
 FailActiveUnify:
  $RELEASE(D_WorkPtrToDerefCell);
  $CALL(f_FailActiveUnify_Sub(A_Arg,A_BoundReg));
  $RETURN ();
}
