
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V10/interpreter/klb_reuse.psl.c
   ----- CREATED   : by f-hataza@icot22, on Thu May 17 16:49:36 1990
   ----- LAST SAVED: by imai@icot22, on Sat Jun 15 20:42:21 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : INTERPRETER
   ----- ABSTRACT  : $B:FMxMQ(B

  1. $B9=B$BN$N:FMxMQ(B
  klb_reuse (Reg, oldtype, newtype) ::  KL1-B$BCf4V7A<0(B
  klb_reuse_list (Reg)
  klb_reuse_for_list (Reg)
  klb_reuse_vector (size, Reg)
  klb_reuse_for_vector (size, Reg)

  2. $BMWAG$r4^$`9=B$BN$N:FMxMQ(B :: ($BDI2C(B 1990.02.02)
  klb_reuse_with_elements (Reg, oldtype, newtype, copyflag) :: KL1-B$BCf4V7A<0(B
  klb_reuse_list_with_elements (Reg, copyflag)
  klb_reuse_for_list_with_elements (Reg, copyflag)
  klb_reuse_vector_with_elements (size, Reg, copyflag)
  klb_reuse_for_vector_with_elements (size, Reg, copyflag)

  $B%m%s%0%Y%/%?$N(Breuse$B$O9T$o$J$$!#$3$l$O%3%s%Q%$%i$K%^%7%s9=@.>pJs$H(B
  $B$7$FM?$($i$l$F$$$k!#=>$C$F%m%s%0%Y%/%?$r(Breuse$B$7$h$&$H$7$?;~$O!"(B
  OUT_OF_SPEC$B$G$"$j%3%s%Q%$%i$N%P%0$N2DG=@-$,$"$k!#(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
  1. $B9=B$BN$N:FMxMQ(B
     klb_reuse Reg, oldtype, newtype

       written by f-doumae@icot22      on Wed Jul 12 16:34:40 1989
<Arguments>
    Reg     : $B9=B$BN$X$N%]%$%s%?$r;}$D%l%8%9%?(B
    oldtype : list $B$^$?$O(B vector(ARITY)
    newtype : list $B$^$?$O(B vector(ARITY)
          ($B$3$3$K!"(Blist$B!"(Bvector $B$O(BKL1$B$N%"%H%`!"(BARITY $B$O@0?t(B)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
    $BITMW$K$J$C$?%a%b%jNN0h$r!"?7$7$$9=B$BN$N$?$a$K:FMxMQ$9$kL?Na!#(B
    $B$"$k9=B$BN$,$I$NBg$-$5$N9=B$BN$K:FMxMQ$G$-$k$+$O=hM}7O$K0MB8$9$k!#(B
    $B$h$C$F!"%3%s%Q%$%i$K$O$=$NAH$_9g$o$;$rM?$($F$*$+$J$1$l$P$J$i$J$$!#(B
    reuse$BL?Na$O%]%9%H%3%s%Q%$%i$K$h$C$F!"(B
    reuse_list
    reuse_for_list
    reuse_vector
    reuse_for_vector
    $B$N2?$l$+$KE83+$5$l$k$N$G=hM}7O$KD>@\(B reuse$B$,EO$k$3$H$O$J$$!#(B
<ETC>
********************************************************************* PSL **/

/******************************************************************** PSL **
klb_reuse_list Reg

       written by f-doumae@icot22      on Wed Jul 12 16:38:36 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |      reuse_list       |   Reg     | don't care|
    +-----------+-----------+-----------+-----------+
<Arguments>
    Reg : $B%j%9%H$X$N%]%$%s%?$r;}$D%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B!&%l%8%9%?(BReg$B$,(BMRB$B!{$N$H$-!"$=$l$,;X$9%j%9%H$r:FMxMQ$9$k!#(B($BB($A2?$b$7$J$$(B)
    $B!&%l%8%9%?(BReg$B$,(BMRB$B!|$N$H$-!"?7$?$K(BMRB$B!{$N%j%9%H$r3d$jIU$1$=$3$X$N%]%$%s%?$r(B
      Reg$B$K=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define  I_RegSource    _IndirectRegField1
#OPF_define  I_ImmRegSource _ImmediateField1

#PSL_define klb_reuse_list()
{
  @DEBUG {
    b_IfRangeErr(I_ImmRegSource, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_reuse_list", "r1 range");
    }
    s_IfNotLIST(I_RegSource){
      VPIM_ERROR("klb_reuse_list","Illegal_reuse_type");
    }
  };
  s_IfMRBon(I_RegSource){
    s_AllocList(I_RegSource);
  }
}

/******************************************************************** PSL **
klb_reuse_for_list Reg

       written by f-doumae@icot22      on Wed Jul 12 17:01:48 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |    reuse_for_list     |   Reg     | don't care|
    +-----------+-----------+-----------+-----------+
<Arguments>
    Reg : 2$BMWAG%Y%/%?$X$N%]%$%s%?$r;}$D%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B!&%l%8%9%?(BReg$B$,(BMRB$B!{$N$H$-!"$=$N%?%$%W$r(B LIST $B$K=q$-49$($F:FMxMQ$9$k!#(B
    $B!&%l%8%9%?(BReg$B$,(BMRB$B!|$N$H$-!"?7$?$K(BMRB$B!{$N%j%9%H$r3d$jIU$1$=$3$X$N%]%$%s%?$r(B
      Reg$B$K=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
    $B$3$NL?Na$O(B2$BMWAG%Y%/%?$r%j%9%H$H$7$F:FMxMQ$7$h$&$H$9$k;~$K$G$k!#(B
<ETC>
********************************************************************* PSL **/

#OPF_define  I_RegSource    _IndirectRegField1
#OPF_define  I_ImmRegSource _ImmediateField1

#PSL_define klb_reuse_for_list()
{
  @DEBUG {
    b_IfRangeErr(I_ImmRegSource, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_reuse_for_list", "r1 range");
    }
    s_IfNotVECT2(I_RegSource){
      VPIM_ERROR("klb_reuse_for_list","Illegal_reuse_type");
    }
  };
  s_IfMRBon(I_RegSource){
    s_AllocList(I_RegSource);
  } else{
    b_SetImmTypeMRBoff(LIST, I_RegSource);
  }
}

/******************************************************************** PSL **
klb_reuse_vector size, Reg

       written by f-doumae@icot22      on Thu Jul 13 10:30:00 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |      reuse_vector     |   size    |    Reg    |
    +-----------+-----------+-----------+-----------+
<Arguments>
    size   : $B%Y%/%?$NMWAG?t(B($B@0?t(B)
    Reg    : $B%Y%/%?$X$N%]%$%s%?$r;}$D%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
    $B!&(BReg$B$N;X$9%Y%/%?$NMWAG?t$O(Bsize$B$G$"$k$3$H!#(B
    $B!&(BReg$B$N;X$9%Y%/%?$O%7%g!<%H%Y%/%?$N$_!#(B
<Function>
    $B!&%l%8%9%?(BReg$B$,(BMRB$B!{$N$H$-!"$=$l$,;X$9%Y%/%?$r:FMxMQ$9$k!#(B($BB($A2?$b$7$J$$(B)
    $B!&%l%8%9%?(BReg$B$,(BMRB$B!|$N$H$-!"?7$?$KMWAG?t(Bsize$B!"(BMRB$B!{$N%Y%/%?$r3d$jIU$1$=$3(B
      $B$X$N%]%$%s%?$r(BReg$B$K=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
    $B<B:]$N%^%7%sL?Na$G$O(B, $B3d$jEv$F$k%Y%/%?$N%5%$%:Kh$KJL$NL?Na$H$9$k!#(B
<ETC>
********************************************************************* PSL **/
#OPF_define  I_ImmVectSize   _ImmediateField1
#OPF_define  I_RegSrcVect    _IndirectRegField2

#OPF_define  I_ImmRegSrcVect _ImmediateField2

#PSL_define klb_reuse_vector()
{
  @DEBUG {
    b_IfRangeErr(I_ImmRegSrcVect, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_reuse_vector", "r2 range");
    }
    s_IfNotShortVectors(I_RegSrcVect){
      OUT_OF_SPEC("klb_reuse_vector","Illegal_reuse_type");
    }
    b_IfRangeErr(I_ImmVectSize,
		 _MIN_SIZE_OF_REUSE_VECT, _MAX_SIZE_OF_REUSE_VECT) {
      OUT_OF_SPEC ("klb_reuse_vector", "Illegal_reuse_size");
    }
  };
  s_IfMRBon(I_RegSrcVect){
    f_AllocVectorOpr(I_RegSrcVect, I_ImmVectSize);
  }
}

/******************************************************************** PSL **
klb_reuse_for_vector size, Reg

       written by f-doumae@icot22      on Thu Jul 13 10:30:00 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |     reuse_for_vector  |   size    |   Reg     |
    +-----------+-----------+-----------+-----------+
<Arguments>
    size   : $B%Y%/%?$NMWAG?t(B($B@0?t(B)
    Reg    : $B%j%9%H$^$?$O%Y%/%?$X$N%]%$%s%?$r;}$D%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
    $B!&(BReg$B$N;X$9%Y%/%?$NMWAG?t$,(Bsize$B$G$J$$!#$^$?$O!"(BReg$B$,%j%9%H$r;X$7(B
      size = 2 $B$G$"$k!#(B
    $B!&(BReg$B$N;X$9%Y%/%?$O%7%g!<%H%Y%/%?$N$_!#(B($BJQ99(B 90.02.05)
<Function>
    $B!&%l%8%9%?(BReg$B$,(BMRB$B!{$N$H$-!"%?%$%W$r=q$-49$($F:FMxMQ$9$k!#(B
    $B!&%l%8%9%?(BReg$B$,(BMRB$B!|$N$H$-!"?7$?$KMWAG?t(Bsize$B!"(BMRB$B!{$N%Y%/%?$r3d$jIU$1$=$3(B
      $B$X$N%]%$%s%?$r(BReg$B$K=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
    $B%3%s%Q%$%i$O$"$k%Y%/%?$,2?%o!<%I$N%l%3!<%I$K3d$jEv$F$i$l$F$$$k$+$r(B
    $BCN$C$F$$$k!#$h$C$F!"(B4$B%o!<%I%l%3!<%I$K3d$jEv$F$i$l$F$$$k(BVECT3,VECT4
    $B$r(BVECT2$B$d(BVECT5$B$K:FMxMQ$9$k$h$&$J$3$H$O$7$J$$!#(B
    ($B%^%7%s9=@.>pJs$H$7$FM?$($i$l$F$$$k!#(B)

    $B<B:]$N%^%7%sL?Na$G$O(B, $B3d$jEv$F$k%Y%/%?$N%5%$%:Kh$KJL$NL?Na$H$9$kJ}$,NI$$!#(B
<ETC>
********************************************************************* PSL **/
#OPF_define  I_ImmVectSize  _ImmediateField1
#OPF_define  I_RegSource    _IndirectRegField2

#OPF_define  I_ImmRegSource _ImmediateField2

#PSL_define klb_reuse_for_vector()
{
  @DEBUG {
    b_IfRangeErr(I_ImmRegSource, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_reuse_for_vector", "r2 range");
    }
    b_IfRangeErr(I_ImmVectSize,
		 _MIN_SIZE_OF_REUSE_VECT, _MAX_SIZE_OF_REUSE_VECT) {
      OUT_OF_SPEC ("klb_reuse_for_vector", "Illegal_reuse_size");
    }
  };
  s_IfMRBon(I_RegSource){
    f_AllocVectorOpr(I_RegSource, I_ImmVectSize);
  } else {
    s_IfLIST(I_RegSource){
      b_SetImmTypeMRBoff(VECT2, I_RegSource);
      @DEBUG{
	$USE(D_WorkCheckVectSize);
	b_MoveImmOprWithMRBandType
	  (I_ImmVectSize,_MRB_OFF,INT,D_WorkCheckVectSize);
	b_IfNotEqualImm(D_WorkCheckVectSize, _SIZE_OF_VECT2){
	  VPIM_ERROR("klb_reuse_for_vector","Illegal_reuse_list");
	}
	$RELEASE(D_WorkCheckVectSize);
      };
    } else {
      @DEBUG{
	s_IfNotVectors(I_RegSource){
	  VPIM_ERROR("klb_reuse_for_vector","Illegal_reuse_type");
	}
      };
      $USE(D_WorkVectSize);
      b_MoveImmOprWithMRBandType (I_ImmVectSize,_MRB_OFF,INT,D_WorkVectSize);
      s_SetShortVectTypeMRBoff (D_WorkVectSize, I_RegSource);
      $RELEASE(D_WorkVectSize);
    }  /*  end of s_IfLIST  */
  }  /*  end of s_IfMRBon  */
}

/******************************************************************** PSL **
  2. $BMWAG$r4^$`9=B$BN$N:FMxMQ(B :: ($BDI2C(B 1990.02.02)
     reuse_with_elements Reg, oldtype, newtype, copyflag

       written by f-doumae@icot22      on Fri Feb  2 11:59:41 1990
<Arguments>
    Reg     : $B9=B$BN$X$N%]%$%s%?$r;}$D%l%8%9%?(B
    oldtype : list $B$^$?$O(B vector(ARITY)
    newtype : list $B$^$?$O(B vector(ARITY)
          ($B$3$3$K!"(Blist$B!"(Bvector $B$O(BKL1$B$N%"%H%`!"(BARITY $B$O@0?t(B)
    copyflag : Reg$B$,(BMRB$B!|$N;~?7$7$/3d$jIU$1$?9=B$BN$K%3%T!<$7$J$1$l$P(B
               $B$J$i$J$$MWAG0LCV$r<($7$?(B8$B%S%C%H$N%U%i%0!#(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B5l9=B$BN$NMWAG$r4^$a$F:FMxMQ$r9T$&L?Na!#%l%8%9%?(BReg$B$N(BMRB$B$,(BOFF$B$N>l9g!"(B
  $BMWAG$r4^$a$F9=B$BN$N:FMxMQ$9$k!#B($A!"$3$N;~$O(Breuse$BL?Na$HF1$8$G(B
  $B2?$b$7$J$$!#(BMRB$B$,(BON$B$N>l9g$O?7$?$K9=B$BN$r3d$jIU$1!":FMxMQ$9$kMWAG$r(B
  $B%3%T!<$9$k!#$3$N%3%T!<$9$Y$-MWAG$r<($9>pJs$,(Bcopyflag$B$G$"$k!#(B
  $BB($A!"MWAG0LCV$r<($9%S%C%H$,(B"1"$B$G$"$l$PBP1~$9$kMWAG$r%3%T!<$7!"(B
  "0"$B$G$"$l$P$=$NI,MW$,$J$$$3$H$r0UL#$9$k!#(B

  $B$3$N(Breuse_with_elements$B$O(BKL1-B$BCf4V7A<0L?Na$G%]%9%H%3%s%Q%$%i$K$h$C$F!"(B
    klb_reuse_list_with_elements
    klb_reuse_for_list_with_elements
    klb_reuse_vector_with_elements
    klb_reuse_for_vector_with_elements
  $B$N2?$l$+$KE83+$5$l$k$N$G=hM}7O$KD>@\(B reuse_with_elements$B$,EO$k$3$H$O$J$$!#(B

<Examples>
<Test>
<Explanation>
  copyflag$B$O%]%9%H%3%s%Q%$%i$K$h$C$F<!$N$h$&$KJQ49$5$l$k!#(B
   ex.
   [0|1]      ==>  b"00000010"  %% car$B$,Bh(B1bit$B!"(Bcdr$B$,Bh(B2bit (cdr$B$r%3%T!<$9$k(B)
   {1,1,0}    ==>  b"00000011"  %% $B%Y%/%?$NBh(B1$BMWAG$,Bh(B1bit$B!"Bh(B2$BMWAG$,Bh(B2bit$B!"(B
                                %% $BBh(B3$BMWAG$,Bh(B3bit ($BBh(B1$B!"Bh(B2$BMWAG$r%3%T!<$9$k(B)
<ETC>
********************************************************************* PSL **/

/******************************************************************** PSL **
klb_reuse_list_with_elements Reg, copyflag

       written by f-doumae@icot22      on Fri Feb  2 10:45:09 1990

    0           1            2           3           4
    +-----------+------------+-----------+-----------+
    |reuse_list_with_elements|   Reg     | copyflag  |
    +-----------+------------+-----------+-----------+

<Arguments>
    Reg      : $B%j%9%H$X$N%]%$%s%?$r;}$D%l%8%9%?(B
    copyflag : Reg$B$,(BMRB$B!|$N;~?7$7$/3d$jIU$1$?%j%9%H$K%3%T!<$7$J$1$l$P(B
               $B$J$i$J$$MWAG0LCV$r<($7$?(B8$B%S%C%H$N%U%i%0!#(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B!&%l%8%9%?(BReg$B$,(BMRB$B!{$N$H$-!"$=$l$,;X$9%j%9%H$r:FMxMQ$9$k!#(B($BB($A2?$b$7$J$$(B)
    $B!&%l%8%9%?(BReg$B$,(BMRB$B!|$N$H$-!"?7$?$K(BMRB$B!{$N%j%9%H$r3d$jIU$1$=$3$X$N%]%$%s%?$r(B
      Reg$B$K=q$-9~$_!"(Bcopyflag$B$N>pJs$r$b$H$KMWAG$r%3%T!<$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#DATA_define D_WorkListPtr     XXX
#DATA_define D_WorkCopyFlag    XXX

#OPF_define  I_RegSource    _IndirectRegField1
#OPF_define  I_ImmCopyFlag  _ImmediateField2

#OPF_define  I_ImmRegSource _ImmediateField1

#PSL_define klb_reuse_list_with_elements()
{
  @DEBUG {
    b_IfRangeErr(I_ImmRegSource, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_reuse_list_with_elements", "r1 range");
    }
    s_IfNotLIST(I_RegSource){
      VPIM_ERROR("klb_reuse_list_with_elements","Illegal_reuse_type");
    }
  };
  s_IfMRBon(I_RegSource){
    $USE(D_WorkListPtr);
    $USE(D_WorkCopyFlag);
    p_MoveImmediateValueFromImmediateField(I_ImmCopyFlag, D_WorkCopyFlag);
    p_MoveWord(I_RegSource, D_WorkListPtr);
    s_AllocList(I_RegSource);
    $CALL(s_CopyReuseElemList_Sub
	       (D_WorkListPtr, I_RegSource, D_WorkCopyFlag) );
    $RELEASE(D_WorkCopyFlag);
    $RELEASE(D_WorkListPtr);
  }
}

/******************************************************************** PSL **
klb_reuse_for_list_with_elements Reg, copyflag

       written by f-doumae@icot22      on Fri Feb  2 10:45:09 1990

    0           1            2           3           4
    +-----------+------------+-----------+-----------+
    |  reuse_for_list        |   Reg     | copyflag  |
    |          _with_elements|           |           |
    +-----------+------------+-----------+-----------+

<Arguments>
    Reg      : 2$BMWAG%Y%/%?$X$N%]%$%s%?$r;}$D%l%8%9%?(B
    copyflag : Reg$B$,(BMRB$B!|$N;~?7$7$/3d$jIU$1$?%j%9%H$K%3%T!<$7$J$1$l$P(B
               $B$J$i$J$$MWAG0LCV$r<($7$?(B8$B%S%C%H$N%U%i%0!#(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B!&%l%8%9%?(BReg$B$,(BMRB$B!{$N$H$-!"%?%$%W$r(BLIST$B$K=q$-49$($F:FMxMQ$9$k!#(B
    $B!&%l%8%9%?(BReg$B$,(BMRB$B!|$N$H$-!"?7$?$K(BMRB$B!{$N%j%9%H$r3d$jIU$1$=$3$X$N%]%$%s%?$r(B
      Reg$B$K=q$-9~$_!"(Bcopyflag$B$N>pJs$r$b$H$KMWAG$r%3%T!<$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define  I_RegSource    _IndirectRegField1
#OPF_define  I_ImmCopyFlag  _ImmediateField2

#OPF_define  I_ImmRegSource _ImmediateField1

#PSL_define klb_reuse_for_list_with_elements()
{
  @DEBUG {
    b_IfRangeErr(I_ImmRegSource, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_reuse_for_list_with_elements", "r1 range");
    }
    s_IfNotVECT2(I_RegSource){
      VPIM_ERROR("klb_reuse_for_list_with_elements","Illegal_reuse_type");
    }
  };
  s_IfMRBon(I_RegSource){
    $USE(D_WorkVectPtr);
    $USE(D_WorkCopyFlag);
    p_MoveImmediateValueFromImmediateField(I_ImmCopyFlag, D_WorkCopyFlag);
    p_MoveWord(I_RegSource, D_WorkVectPtr);
    s_AllocList(I_RegSource);
    $CALL(s_CopyReuseElemList_Sub
	       (D_WorkVectPtr, I_RegSource, D_WorkCopyFlag) );
    $RELEASE(D_WorkCopyFlag);
    $RELEASE(D_WorkVectPtr);
  } else {
    b_SetImmTypeMRBoff(LIST, I_RegSource);
  }
}

/******************************************************************** PSL **
klb_reuse_vector_with_elements size, Reg, copyflag

       written by f-doumae@icot22      on Fri Feb  2 10:45:09 1990

    0           1            2           3           4
    +-----------+------------+-----------+-----------+
    |  reuse_vector          |   size    |   Reg     |
    |          _with_elements|           |           |
    +-----------+------------+-----------+-----------+
    |  copyflag |             don't care             |
    +-----------+------------+-----------+-----------+
<Arguments>
    size     : $B%Y%/%?$NMWAG?t(B
    Reg      : $B%Y%/%?$X$N%]%$%s%?$r;}$D%l%8%9%?(B
    copyflag : Reg$B$,(BMRB$B!|$N;~?7$7$/3d$jIU$1$?%j%9%H$K%3%T!<$7$J$1$l$P(B
               $B$J$i$J$$MWAG0LCV$r<($7$?(B8$B%S%C%H$N%U%i%0!#(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B!&%l%8%9%?(BReg$B$,(BMRB$B!{$N$H$-!"$=$l$,;X$9%Y%/%?$r:FMxMQ$9$k!#(B($BB($A2?$b$7$J$$(B)
    $B!&%l%8%9%?(BReg$B$,(BMRB$B!|$N$H$-!"?7$?$KMWAG?t(Bsize$B!"(BMRB$B!{$N%Y%/%?$r3d$jIU$1$=$3$X(B
      $B$N%]%$%s%?$r(BReg$B$K=q$-9~$_!"(Bcopyflag$B$N>pJs$r$b$H$KMWAG$r%3%T!<$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#DATA_define D_WorkVectPtr XXX

#OPF_define  I_ImmVectSize  _ImmediateField1
#OPF_define  I_RegSource    _IndirectRegField2
#OPF_define  I_ImmCopyFlag  _ImmediateField3

#OPF_define  I_ImmRegSource _ImmediateField2

#PSL_define klb_reuse_vector_with_elements()
{
  @DEBUG {
    b_IfRangeErr(I_ImmRegSource, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_reuse_vector_with_elements", "r2 range");
    }
    s_IfNotShortVectors(I_RegSource){
      VPIM_ERROR("klb_reuse_vector_with_elements","Illegal_reuse_type");
    }
    b_IfRangeErr(I_ImmVectSize,
		 _MIN_SIZE_OF_REUSE_VECT, _MAX_SIZE_OF_REUSE_VECT) {
      OUT_OF_SPEC ("klb_reuse_vector_with_elements", "Illegal_reuse_size");
    }
  };
  s_IfMRBon(I_RegSource){
    $USE(D_WorkVectPtr);
    $USE(D_WorkCopyFlag);
    $USE(D_WorkVectSize);
    p_MoveImmediateValueFromImmediateField(I_ImmCopyFlag, D_WorkCopyFlag);
    p_MoveImmediateValueFromImmediateField(I_ImmVectSize, D_WorkVectSize);
    p_MoveWord(I_RegSource, D_WorkVectPtr);
    $CALL( f_AllocVectorMRBoff_Sub(D_WorkVectSize, I_RegSource));
    $CALL( s_CopyReuseElemVect_Sub(D_WorkVectPtr, I_RegSource,
				   D_WorkVectSize, D_WorkCopyFlag) );
    $RELEASE(D_WorkVectSize);
    $RELEASE(D_WorkCopyFlag);
    $RELEASE(D_WorkVectPtr);
  }
}

/******************************************************************** PSL **
klb_reuse_for_vector_with_elements size, Reg, copyflag

       written by f-doumae@icot22      on Fri Feb  2 10:45:09 1990

    0           1            2           3           4
    +-----------+------------+-----------+-----------+
    |  reuse_for_vector      |   size    |   Reg     |
    |          _with_elements|           |           |
    +-----------+------------+-----------+-----------+
    |  copyflag |             don't care             |
    +-----------+------------+-----------+-----------+
<Arguments>
    size     : $B%Y%/%?$NMWAG?t(B
    Reg      : $B%Y%/%?$^$?$O%j%9%H$X$N%]%$%s%?$r;}$D%l%8%9%?(B
    copyflag : Reg$B$,(BMRB$B!|$N;~?7$7$/3d$jIU$1$?%j%9%H$K%3%T!<$7$J$1$l$P(B
               $B$J$i$J$$MWAG0LCV$r<($7$?(B8$B%S%C%H$N%U%i%0!#(B

<Temporally Used Variables>
<Level>
<PreCondition>
    $B!&(BReg$B$N;X$9%Y%/%?$NMWAG?t$,(Bsize$B$G$J$$!#$^$?$O!"(BReg$B$,%j%9%H$r;X$7(B
      size = 2 $B$G$"$k!#(B
    $B!&(BReg$B$N;X$9%Y%/%?$O%7%g!<%H%Y%/%?$N$_!#(B
<Function>
    $B!&%l%8%9%?(BReg$B$,(BMRB$B!{$N$H$-!"%?%$%W$r=q$-49$($F:FMxMQ$9$k!#(B
    $B!&%l%8%9%?(BReg$B$,(BMRB$B!|$N$H$-!"?7$?$KMWAG?t(Bsize$B!"(BMRB$B!{$N%j%9%H$r3d$jIU$1$=$3$X(B
      $B$N%]%$%s%?$r(BReg$B$K=q$-9~$_!"(Bcopyflag$B$N>pJs$r$b$H$KMWAG$r%3%T!<$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define  I_ImmVectSize  _ImmediateField1
#OPF_define  I_RegSource    _IndirectRegField2
#OPF_define  I_ImmCopyFlag  _ImmediateField3

#OPF_define  I_ImmRegSource _ImmediateField2

#PSL_define klb_reuse_for_vector_with_elements()
{
  @DEBUG {
    b_IfRangeErr(I_ImmRegSource, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_reuse_for_vector_with_elements", "r2 range");
    }
    b_IfRangeErr(I_ImmVectSize,
		 _MIN_SIZE_OF_REUSE_VECT, _MAX_SIZE_OF_REUSE_VECT) {
      OUT_OF_SPEC ("klb_reuse_for_vector_with_elements", "Illegal_reuse_size");
    }
    s_IfNotLIST(I_RegSource){
      s_IfNotShortVectors(I_RegSource){
        VPIM_ERROR("klb_reuse_for_vector_with_elements","Illegal_reuse_type");
      }
    }
  };
  s_IfMRBon(I_RegSource){
    $USE(D_WorkVectPtr);
    $USE(D_WorkCopyFlag);
    $USE(D_WorkVectSize);
    p_MoveImmediateValueFromImmediateField(I_ImmCopyFlag, D_WorkCopyFlag);
    p_MoveImmediateValueFromImmediateField(I_ImmVectSize, D_WorkVectSize);
    p_MoveWord(I_RegSource, D_WorkVectPtr);
    $CALL( f_AllocVectorMRBoff_Sub(D_WorkVectSize, I_RegSource));

    $CALL( s_CopyReuseElemVect_Sub(D_WorkVectPtr, I_RegSource,
				   D_WorkVectSize, D_WorkCopyFlag) );
    $RELEASE(D_WorkVectSize);
    $RELEASE(D_WorkCopyFlag);
    $RELEASE(D_WorkVectPtr);
  } else {
    $USE(D_WorkVectSize);
    b_MoveImmOprWithMRBandType (I_ImmVectSize,_MRB_OFF,INT,D_WorkVectSize);
    s_SetShortVectTypeMRBoff (D_WorkVectSize, I_RegSource);
    $RELEASE(D_WorkVectSize);
  }
}
