
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V10/interpreter/klb_put.psl.c
   ----- CREATED   : by hirata@icot22, on Tue May 15 11:19:04 1990
   ----- LAST SAVED: by f-hataza@icot22, on Fri Mar  8 15:57:22 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : interpreter
   ----- ABSTRACT  : $BDj?t$r(B($B%a%b%j$+$iFI$s$G$-$F(B)$B%l%8%9%?$K=q$-9~$`(B

  klb_put_atom(atom, Reg)
  klb_put_integer(integer, Reg)
  klb_read_cst(Lconst, Reg)
  klb_read_cst_wait(Lconst, Reg, Lsusp)
  klb_read_cst_wait_single(Lconst, Reg, Lsusp)

  $B0J2<$N%^%/%m$rDI2C$9$k!#(B(1990.11.29)
  klb_get_module(Lmod, Reg)
  klb_get_module_wait(Lmod, Reg, Lsusp)
  klb_get_module_builtin(Reg)
  klb_get_module_self(Reg)
  klb_get_code(Lexpred, Reg)
  klb_get_code_wait(Lexpred, Reg, Lsusp)
  klb_get_code_builtin(imm_id, Reg)
  klb_get_code_self(Lpred, Reg)
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
klb_put_atom atom, Reg

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |       put_atom        |      don't care       |
    +-----------+-----------+-----------+-----------+
    |                     atom                      |
    +-----------+-----------+-----------+-----------+
    |	Reg     |	      don't care	    |
    +-----------+-----------+-----------+-----------+
<Arguments>
    atom  : $B%"%H%`HV9f(B($B@0?t(B)
    Reg   : $B%l%8%9%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    Reg$B$K(Batom$B$r%m!<%I$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_ImmAtom		_ImmediateField1
#OPF_define I_ImmRegDest	_ImmediateField2
#OPF_define I_RegDest		_IndirectRegField2

#PSL_define klb_put_atom()
{
  @DEBUG{
    b_IfRangeErr(I_ImmRegDest,_ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_put_atom", "r2_range");
    }
  };
  p_MoveImmediateValueFromImmediateField(I_ImmAtom,I_RegDest);
  b_SetImmTypeMRBoff(ATOM, I_RegDest);
}

/******************************************************************** PSL **
klb_put_integer integer, Reg

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |      put_integer      |      don't care	    |
    +-----------+-----------+-----------+-----------+
    |	                integer                     |
    +-----------+-----------+-----------+-----------+
    |   Reg     |             don't care            |
    +-----------+-----------+-----------+-----------+
<Arguments>
    integer : $B@0?t(B
    Reg     : $B%l%8%9%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    Reg$B$K(Binteger$B$r%m!<%I$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_ImmInt		_ImmediateField1
#OPF_define I_RegDest		_IndirectRegField2
#OPF_define I_ImmRegDest	_ImmediateField2

#PSL_define klb_put_integer()
{
  @DEBUG{
    b_IfRangeErr(I_ImmRegDest,_ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_put_integet", "r2_range");
    }
  };
  p_MoveImmediateValueFromImmediateField(I_ImmInt,I_RegDest);
  b_SetImmTypeMRBoff(INT, I_RegDest);
}

/******************************************************************** PSL **
klb_read_cst Lconst, Reg

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |       read_cst        |       Lconst	    |
    +-----------+-----------+-----------+-----------+
    |   Reg     |             don't care            |
    +-----------+-----------+-----------+-----------+
<Arguments>
    Lconst   : $B<+%b%8%e!<%kCf$NDj?tNN0h$X$N%]%$%s%?(B(PC$BAjBP%"%I%l%9(B)
    Reg      : $B%l%8%9%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    Reg$B$K(BPC+Lconst$B$K$"$k%G!<%?$rFI$_9~$`!#(B
<Examples>
<Test>
<Explanation>
    $B%b%8%e!<%kCf$G;HMQ$7$F$$$k9=B$BNDj?t%G!<%?$X$N%]%$%s%?$ODj?tNN0h$KCV$+$l(B
    $B$F$$$k!#$=$N%]%$%s%?$r(BReg$B$KFI$_9~$`!#(B
<ETC>
********************************************************************* PSL **/
#OPF_define I_ImmLconst	_ImmediateField1
#OPF_define I_RegDest	_IndirectRegField2
#OPF_define I_ImmRegDest	_ImmediateField2

#PSL_define klb_read_cst()
{
  @DEBUG{
    b_IfRangeErr(I_ImmRegDest, _ZERO, _MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_read_cst", "r2 range");
    }
  };

  s_ReadConstWithPCOffset(I_ImmLconst, I_RegDest);

  @DEBUG{
    s_IfArgTypeErr(I_RegDest){
      OUT_OF_SPEC ("klb_read_cst", "type_not_argument");
    }
  };
}

/******************************************************************** PSL **
klb_read_cst_wait Lconst, Reg, Lsusp

       written by f-doumae@icot22      on Tue Feb 27 17:32:10 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |   read_cst_wait       |         Lconst	    |
    +-----------+-----------+-----------+-----------+
    |   Reg     |         Lsusp         |don't care |
    +-----------+-----------+-----------+-----------+

<Arguments>
    Lconst : $B<+%b%8%e!<%kCf$NDj?tNN0h$X$N%]%$%s%?(B(PC$BAjBP%"%I%l%9(B)
    Reg    : $B%l%8%9%?(B
    Lsusp  : $B%5%9%Z%s%I%i%Y%k(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B%3!<%I$NDj?tNN0h$K$"$k9=B$BN$X$N%]%$%s%?$r(BReg$B$KFI$_9~$`!#(B
    Reg$B$O%G%l%U$7!"$b$7L$Dj5A$G$"$l$P%9%?%C%/$K@Q$s$G(BLsusp$B$KJ,4t$9$k!#(B
  -->   $B$3$3$G!"L$Dj5A$H$OB>$N%/%i%9%?$KB8:_$9$k$H$$$&0UL#$G!"I,$:(B EXVAL
	$B$K$J$C$F$$$k$O$:$G$"$k!#(B(UNDF $B$J$I$O$"$j$($J$$(B)
<Examples>
<Test>
<Explanation>
    $BDj?tNN0h$K$"$k%G!<%?$O(BREF -> EXVAL$B$N2DG=@-$,$"$j!"$=$N;~$O%5%9%Z%s%I=hM}$N(B
    $BCf$G(Bread$B%a%C%;!<%8$rAw?.$9$k=hM}$r$9$k!#(B
    REF -> EXVAL$B$O(BREF$B$N%A%'!<%s$K$J$k$3$H$O$J$$$N$G0lCJ$@$1%G%l%U$r9T$($P$h$$(B
    $B$O$:!#(B
<ETC>
********************************************************************* PSL **/
#OPF_define I_ImmLconst  _ImmediateField1
#OPF_define I_RegDest    _IndirectRegField2
#OPF_define I_ImmLsusp   _ImmediateField3

#OPF_define I_ImmRegDest _ImmediateField2

#PSL_define klb_read_cst_wait()
{
  @DEBUG{
    b_IfRangeErr(I_ImmRegDest, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_read_cst_wait", "r2 range");
    }
  };
  s_ReadWithOffsetOprMRBor(D_KLB_PC, I_ImmLconst, I_RegDest);
  s_IfREF(I_RegDest){
    $USE(D_WorkDerefPtr);
    s_DerefReg(I_RegDest, D_WorkDerefPtr);
    s_IfUnbound(I_RegDest){
      @DEBUG{ s_IfNotExval(I_RegDest) {
	VPIM_ERROR("klb_read_cst_wait","Illegal Type");
      }};
      p_MoveWord(D_WorkDerefPtr, I_RegDest);
      s_PushSuspendStack(I_RegDest);
      s_SetKLB_PC_OPR(I_ImmLsusp);
    }
    $RELEASE(D_WorkDerefPtr);
  } 
}

/******************************************************************** PSL **
klb_read_cst_wait_single Lconst, Reg, Lsusp

       written by f-doumae@icot22      on Tue Feb 27 17:57:31 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    | read_cst_wait_single  |         Lconst	    |
    +-----------+-----------+-----------+-----------+
    |   Reg     |         Lsusp         |don't care |
    +-----------+-----------+-----------+-----------+

<Arguments>
    Lconst : $B<+%b%8%e!<%kCf$NDj?tNN0h$X$N%]%$%s%?(B(PC$BAjBP%"%I%l%9(B)
    Reg    : $B%l%8%9%?(B
    Lsusp  : $B%5%9%Z%s%I%i%Y%k(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B%3!<%I$NDj?tNN0h$K$"$k9=B$BN$X$N%]%$%s%?$r(BReg$B$KFI$_9~$`!#(B
    Reg$B$O%G%l%U$7!"$b$7L$Dj5A$G$"$l$P(BLsusp$B$KJ,4t$9$k!#(B
  -->   $B$3$3$G!"L$Dj5A$H$OB>$N%/%i%9%?$KB8:_$9$k$H$$$&0UL#$G!"I,$:(B EXVAL
	$B$K$J$C$F$$$k$O$:$G$"$k!#(B(UNDF $B$J$I$O$"$j$($J$$(B)
<Examples>
<Test>
<Explanation>
<ETC>
    klb_read_cst_wait$B$H$O!"(Bs_IfUnbound(I_RegDest) $B$NCf$G(B
    s_PushSuspendStack(I_RegDest); $B$r<B9T$7$J$$E@$@$10[$J$k!#(B
********************************************************************* PSL **/
#OPF_define I_ImmLconst  _ImmediateField1
#OPF_define I_RegDest    _IndirectRegField2
#OPF_define I_ImmLsusp   _ImmediateField3
#OPF_define I_ImmRegDest _ImmediateField2

#PSL_define klb_read_cst_wait_single()
{
  @DEBUG{
    b_IfRangeErr(I_ImmRegDest, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_read_cst_wait_single", "r2 range");
    }
  };
  s_ReadWithOffsetOprMRBor(D_KLB_PC, I_ImmLconst, I_RegDest);
  s_IfREF(I_RegDest){
    $USE(D_WorkDerefPtr);
    s_DerefReg(I_RegDest, D_WorkDerefPtr);
    s_IfUnbound(I_RegDest){
      @DEBUG{ s_IfNotExval(I_RegDest) {
	s_IfNotRDHOK(I_RegDest){
	  s_IfNotEXLOCK(I_RegDest){
	  VPIM_ERROR("klb_read_cst_wait_single","Illegal Type");
      }}}};
      p_MoveWord(D_WorkDerefPtr, I_RegDest);
      s_SetKLB_PC_OPR(I_ImmLsusp);
    }
    $RELEASE(D_WorkDerefPtr);
  } 
}

/******************************************************************** PSL **
  klb_get_module Lmod, Reg

       written by f-hataza@icot22      on Thu Nov 29 20:14:53 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |      get_module       |         Lmod	    |
    +-----------+-----------+-----------+-----------+
    |   Reg     |            don't care             |
    +-----------+-----------+-----------+-----------+

<Arguments>
    Lmod   : $B<+%b%8%e!<%kCf$N%b%8%e!<%k5-=R;R$X$N%]%$%s%?(B(PC$BAjBP%"%I%l%9(B)
    Reg    : $B%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B%3!<%I$N%b%8%e!<%k5-=R;R$K$"$k%b%8%e!<%k$X$N%]%$%s%?$r(BReg$B$KFI$_9~$`!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_ImmLmod		_ImmediateField1
#OPF_define I_RegModule		_IndirectRegField2

#OPF_define I_ImmRegModule	_ImmediateField2   /* @DEBUG$BMQ(B */

#PSL_define klb_get_module()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegModule, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      OUT_OF_SPEC( "klb_get_module", "r2_range" );
    }
  };
  p_ReadWithOffsetOPR(D_KLB_PC, I_ImmLmod, I_RegModule);
  /* $B$3$NL?Na$G$O!"C1=c$KFI$_=P$9$@$1!#(B */
}

/******************************************************************** PSL **
  klb_get_module_wait Lmod, Reg, Lsusp

       written by f-hataza@icot22      on Thu Nov 29 20:14:53 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |   get_module_wait     |         Lmod	    |
    +-----------+-----------+-----------+-----------+
    |   Reg     |         Lsusp         | don't care|
    +-----------+-----------+-----------+-----------+

<Arguments>
    Lmod   : $B<+%b%8%e!<%kCf$N%b%8%e!<%k5-=R;R$X$N%]%$%s%?(B(PC$BAjBP%"%I%l%9(B)
    Reg    : $B%l%8%9%?(B
    Lsusp  : $B%5%9%Z%s%I%i%Y%k(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B%3!<%I$N%b%8%e!<%k5-=R;R$K$"$k%b%8%e!<%k$X$N%]%$%s%?$r(BReg$B$KFI$_9~$`!#(B
    Reg$B$O%G%l%U$7!"$b$7L$Dj5A$G$"$l$P%9%?%C%/$K@Q$s$G(B Lsusp$B$KJ,4t$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_ImmLmod		_ImmediateField1
#OPF_define I_RegModule		_IndirectRegField2
#OPF_define I_ImmLsusp		_ImmediateField3

#OPF_define I_ImmRegModule	_ImmediateField2   /* @DEBUG$BMQ(B */

#PSL_define klb_get_module_wait()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegModule, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      OUT_OF_SPEC( "klb_get_module_wait", "r2_range" );
    }
  };
  p_ReadWithOffsetOPR(D_KLB_PC, I_ImmLmod, I_RegModule);
  $USE(D_WorkDerefPtr);
  f_ActiveDeref(I_RegModule, D_WorkDerefPtr);	/* $B%G%l%U$,I,MW(B */
  s_IfUnbound(I_RegModule){
    p_MoveWord(D_WorkDerefPtr,I_RegModule);
    s_PushSuspendStack(D_WorkDerefPtr);
    s_SetKLB_PC_OPR(I_ImmLsusp);
  }
  $RELEASE(D_WorkDerefPtr);
}

/******************************************************************** PSL **
  klb_get_module_builtin Reg

       written by f-hataza@icot22      on Thu Nov 29 20:14:53 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |  get_module_builtin   |   Reg     | don't care|
    +-----------+-----------+-----------+-----------+

<Arguments>
    Reg    : $B%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    builtin$B%b%8%e!<%k$X$N%]%$%s%?$r(BReg$B$KFI$_9~$`!#(B
<Examples>
<Test>
<Explanation>
    s_GetBuiltinModulePtr (defined in str_code.psl.c) $B;2>H!#(B
<ETC>
********************************************************************* PSL **/
#OPF_define I_RegModule		_IndirectRegField1
#OPF_define I_ImmRegModule	_ImmediateField1   /* @DEBUG$BMQ(B */

#PSL_define klb_get_module_builtin()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegModule, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      OUT_OF_SPEC( "klb_get_module_builtin", "r1_range" );
    }
  };
  s_GetBuiltinModulePtr(I_RegModule);

  @DEBUG{ s_IfNotMOD(I_RegModule){
      VPIM_ERROR("klb_get_module_builtin","module not found !!");
  }};
}

/******************************************************************** PSL **
  klb_get_module_self Reg

       written by f-hataza@icot22      on Thu Nov 29 20:14:53 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |  get_module_self	    |   Reg     | don't care|
    +-----------+-----------+-----------+-----------+

<Arguments>
    Reg    : $B%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B<+%b%8%e!<%k$X$N%]%$%s%?$r(BReg$B$KFI$_9~$`!#(B
<Examples>
<Test>
<Explanation>
    $B<+%b%8%e!<%k@hF,%"%I%l%9$NC5$7J}$K$D$$$F$O!"(Bstr_code.psl.c$B;2>H!#(B
<ETC>
********************************************************************* PSL **/
#OPF_define I_RegModule		_IndirectRegField1
#OPF_define I_ImmRegModule	_ImmediateField1   /* @DEBUG$BMQ(B */

#PSL_define klb_get_module_self()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegModule, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      OUT_OF_SPEC( "klb_get_module_self", "r1_range" );
    }
  };
  s_GetModuleTopAndOffsetFromPC(D_KLB_PC, I_RegModule, D_VOID);

  @DEBUG{ s_IfNotMOD(I_RegModule){
      VPIM_ERROR("klb_get_module_self","module not found !!");
  }};
}

/******************************************************************** PSL **
  klb_get_code Lexpred, Reg

       written by f-hataza@icot22      on Thu Nov 29 20:15:04 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |      get_code         |        Lexpred	    |
    +-----------+-----------+-----------+-----------+
    |   Reg     |            don't care             |
    +-----------+-----------+-----------+-----------+

<Arguments>
    Lexpred: $B<+%b%8%e!<%kCf$N=R8l5-=R;R$X$N%]%$%s%?(B(PC$BAjBP%"%I%l%9(B)
    Reg    : $B%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B%3!<%I$N=R8l5-=R;R$K$"$k%b%8%e!<%k30=R8l$X$N%]%$%s%?$r(BReg$B$KFI$_9~$`!#(B
    $B$3$N%]%$%s%?$,%-%c%C%7%e$5$l$F$$$J$$;~$K$O!"%b%8%e!<%k5-=R;R$r$?$I$C$F(B
    $B30It%b%8%e!<%kCf$N%(%s%H%j%F!<%V%k$rD4$Y!"%3!<%I$X$N%]%$%s%?$rF@$k!#(B
    $B>\:Y$K$D$$$F$O!"(Bstr_code.psl.c$B;2>H!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#DATA_define D_WorkPredDescPtr	XXX
#DATA_define D_WorkModPtr	XXX

#OPF_define I_ImmExtPred	_ImmediateField1
#OPF_define I_RegCode		_IndirectRegField2

#OPF_define I_ImmRegCode	_ImmediateField2   /* @DEBUG$BMQ(B */

#PSL_define klb_get_code()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegCode, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      OUT_OF_SPEC( "klb_get_code", "r2_range" );
    }
  };
  p_ReadWithOffsetOPR(D_KLB_PC, I_ImmExtPred, I_RegCode);
  s_IfNotCOD(I_RegCode){
    /* $B%3!<%I$,%-%c%C%7%e$5$l$F$$$J$+$C$?>l9g(B */
    $USE(D_WorkPredDescPtr);
    s_GetPredDescPtr(I_ImmExtPred,D_WorkPredDescPtr);
    $USE(D_WorkModPtr);
    s_GetModPtrFromPredDesc(D_WorkPredDescPtr,D_WorkModPtr);
    $USE(D_WorkDerefPtr);
    f_ActiveDeref(D_WorkModPtr, D_WorkDerefPtr);	/* $B%G%l%U$,I,MW(B */
    s_IfMOD(D_WorkModPtr) {
      /* $B%b%8%e!<%k$O!"%/%i%9%?Fb$KB8:_$9$k(B */
	/* ==> $B=R8l5-=R;R$r;H$C$F%3!<%I$rC5$9!#$^$?!"=R8l5-=R;R$X!"(B
	       $B%3!<%I$r%-%c%C%7%e$9$k!#(B*/
      s_GetCodeFromPredDesc(D_WorkPredDescPtr,D_WorkModPtr,I_RegCode);
      @DEBUG{ s_IfNotCOD(I_RegCode){
	  VPIM_ERROR("klb_get_code","code not found !!");
      }};
    }else{
      s_IfUnbound(D_WorkModPtr){
	/* $B%b%8%e!<%k$O!"L$Dj5A(B or $B30It;2>H(B */
	  /* ==> I_RegCode$B$K$OJQ?t$r3d$jIU$1!"(Bpredicate_to_code$B$r(BD$B%3!<%I$H$7$F(B
                 $B%5%9%Z%s%I$5$;$k!#(B */
	$CALL( f_DcodeEnqueueInfoGetCode_Sub(D_WorkPredDescPtr,D_WorkDerefPtr,
					     I_RegCode) );
      }else{
	/* $B%G%^%s%I%m!<%I$9$k>l9g$K$O!"(BATOM$B$N2DG=@-$"$j!#>\:YL$Dj!#(B*/
	@DEBUG{VPIM_ERROR("klb_get_code","illegal_mod_ptr");};
      }
    }
    $RELEASE(D_WorkDerefPtr);
    $RELEASE(D_WorkModPtr);
    $RELEASE(D_WorkPredDescPtr);
  }
}

/******************************************************************** PSL **
  klb_get_code_wait Lexpred, Reg, Lsusp

       written by f-hataza@icot22      on Thu Nov 29 20:15:04 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |      get_code         |        Lexpred	    |
    +-----------+-----------+-----------+-----------+
    |   Reg     |         Lsusp         |don't care |
    +-----------+-----------+-----------+-----------+

<Arguments>
    Lexpred: $B<+%b%8%e!<%kCf$N=R8l5-=R;R$X$N%]%$%s%?(B(PC$BAjBP%"%I%l%9(B)
    Reg    : $B%l%8%9%?(B
    Lsusp  : $B%5%9%Z%s%I%i%Y%k(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B%3!<%I$N=R8l5-=R;R$K$"$k%b%8%e!<%k30=R8l$X$N%]%$%s%?$r(BReg$B$KFI$_9~$`!#(B
    $B$3$N%]%$%s%?$,%-%c%C%7%e$5$l$F$$$J$$;~$K$O!"%b%8%e!<%k5-=R;R$r$?$I$C$F(B
    $B30It%b%8%e!<%kCf$N%(%s%H%j%F!<%V%k$rD4$Y!"%3!<%I$X$N%]%$%s%?$rF@$k!#(B
    $B%b%8%e!<%k$,L$Dj5A!"30It;2>H$N>l9g$K$O%9%?%C%/$K@Q$s$G(BLsusp$B$XJ,4t$9$k!#(B
    $B>\:Y$K$D$$$F$O!"(Bstr_code.psl.c$B;2>H!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_ImmExtPred	_ImmediateField1
#OPF_define I_RegCode		_IndirectRegField2
#OPF_define I_ImmLsusp		_ImmediateField3

#OPF_define I_ImmRegCode	_ImmediateField2   /* @DEBUG$BMQ(B */

#PSL_define klb_get_code_wait()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegCode, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      OUT_OF_SPEC( "klb_get_code_wait", "r2_range" );
    }
  };
  p_ReadWithOffsetOPR(D_KLB_PC, I_ImmExtPred, I_RegCode);
  s_IfNotCOD(I_RegCode){
    /* $B%3!<%I$,%-%c%C%7%e$5$l$F$$$J$+$C$?>l9g(B */
    $USE(D_WorkPredDescPtr);
    s_GetPredDescPtr(I_ImmExtPred,D_WorkPredDescPtr);
    $USE(D_WorkModPtr);
    s_GetModPtrFromPredDesc(D_WorkPredDescPtr,D_WorkModPtr);
    $USE(D_WorkDerefPtr);
    f_ActiveDeref(D_WorkModPtr, D_WorkDerefPtr);	/* $B%G%l%U$,I,MW(B */
    s_IfMOD(D_WorkModPtr) {
      /* $B%b%8%e!<%k$O!"%/%i%9%?Fb$KB8:_$9$k(B */
	/* ==> $B=R8l5-=R;R$r;H$C$F%3!<%I$rC5$9!#$^$?!"=R8l5-=R;R$X!"(B
	       $B%3!<%I$r%-%c%C%7%e$9$k!#(B*/
      s_GetCodeFromPredDesc(D_WorkPredDescPtr,D_WorkModPtr,I_RegCode);
      @DEBUG{ s_IfNotCOD(I_RegCode){
	  VPIM_ERROR("klb_get_code_wait","code not found !!");
      }};
    }else{
      /* $B%b%8%e!<%k$O!"L$Dj5A(B or $B30It;2>H(B */
	/* ==> $B%b%8%e!<%k$,%j%s%+$K$h$C$F6qBN2=$5$l$k$+!"M"F~$5$l$k$N$rBT$D!#(B*/
      s_IfUnbound(D_WorkModPtr){
        s_PushSuspendStack(D_WorkDerefPtr);
        s_SetKLB_PC_OPR(I_ImmLsusp);
      }else{
	/* $B%G%^%s%I%m!<%I$9$k>l9g$K$O!"(BATOM$B$N2DG=@-$"$j!#>\:YL$Dj!#(B*/
	@DEBUG{VPIM_ERROR("klb_get_code_wait","illegal_mod_ptr");};
      }
    }
    $RELEASE(D_WorkDerefPtr);
    $RELEASE(D_WorkModPtr);
    $RELEASE(D_WorkPredDescPtr);
  }
}

/******************************************************************** PSL **
  klb_get_code_builtin imm_id, Reg

       written by f-hataza@icot22      on Thu Nov 29 20:14:53 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |  get_code_builtin     |      don't care       |
    +-----------+-----------+-----------+-----------+
    |                    imm_id                     |
    +-----------+-----------+-----------+-----------+
    |    Reg    |            don't care             |
    +-----------+-----------+-----------+-----------+
    
<Arguments>
    imm_id : D$B%3!<%I(BID
    Reg    : $B%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    builtin$B%b%8%e!<%kCf$N(BD$B%3!<%I(BID$B$G;XDj$5$l$k=R8l%3!<%I$X$N%]%$%s%?$r(B
    Reg$B$KFI$_9~$`!#(B
<Examples>
<Test>
<Explanation>
    D$B%3!<%I(BID$B$O!"%3%s%Q%$%i$N=PNO$9$k=R8lL>!"%"%j%F%#$r85$K%]%9%H%3%s%Q%$%i$,(B
    $BD4$Y$F%3!<%ICf$K$*$/!#(BKL1$B%=!<%9$G$O!"(Bbuiltin:PRED$B$G;XDj$9$k!#(B
<ETC>
    imm_id$B$H$7$F!"8=:_(BVPIM$B$G$O(B2$B%P%$%H$7$+;H$C$F$$$J$$$N$G!"(B2$B%P%$%H@0?t(B
    $B$G$b==J,$G$"$k!#(B
********************************************************************* PSL **/
#OPF_define I_ImmDcodeID	_ImmediateField1
#OPF_define I_RegCode		_IndirectRegField2
#OPF_define I_ImmRegCode	_ImmediateField2   /* @DEBUG$BMQ(B */

#PSL_define klb_get_code_builtin()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegCode, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      OUT_OF_SPEC( "klb_get_code_builtin", "r2_range" );
    }
  };
  /* D$B%3!<%I%b%8%e!<%kCf$N=R8l$N%"%I%l%9$rF@$k(B */
  s_GetDcodeAddressOPR(I_ImmDcodeID,I_RegCode);

  @DEBUG{ b_IfEqual(I_RegCode,D_NULL){
    /* $BB8:_$7$J$$(BID$B$N>l9g$K$O!"(BD_NULL$B$,JV$5$l$k!#$3$N>l9g$K$O!"(B
       $B%]%9%H%3%s%Q%$%i$N%P%0$H9M$($i$l$k!#(B*/
      VPIM_ERROR("klb_get_code_builtin","code not found !!");
  }};
  b_SetImmTypeMRBoff(COD, I_RegCode);
}


/******************************************************************** PSL **
  klb_get_code_self Lpred, Reg

       written by f-hataza@icot22      on Thu Nov 29 20:14:53 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |  get_code_self	    |        Lpred          |
    +-----------+-----------+-----------+-----------+
    |    Reg    |             don't care            |
    +-----------+-----------+-----------+-----------+

<Arguments>
    Lpred  : $B<+%b%8%e!<%kFb$N=R8l$X$N%]%$%s%?(B(PC$BAjBP%"%I%l%9(B)
    Reg    : $B%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B<+%b%8%e!<%k$N=R8l%3!<%I$X$N%]%$%s%?$r(BReg$B$KFI$_9~$`!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_ImmLpred		_ImmediateField1
#OPF_define I_RegCode		_IndirectRegField2
#OPF_define I_ImmRegCode	_ImmediateField2   /* @DEBUG$BMQ(B */

#PSL_define klb_get_code_self()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegCode, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      OUT_OF_SPEC( "klb_get_code_self", "r2_range" );
    }
  };
  s_GetKLB_Address_OPR(I_ImmLpred,I_RegCode);
    /* $B$3$N%^%/%m$NCf$G(BCOD$B%?%$%W$N@_Dj$r9T$J$C$F$$$k!#(B */
  @DEBUG{ s_IfNotCOD(I_RegCode){
      VPIM_ERROR("klb_get_code_self","code not found !!");
  }};
}
