
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V10/interpreter/klb_pimos.psl.c
   ----- CREATED   : by yamamoto@icot22, on Fri Jul 26 11:02:48 1991
   ----- LAST SAVED: by yamamoto@icot22, on Tue Oct  1 10:39:50 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/* PIMOS$B%5%]!<%H4X78(B $B%,!<%I$b%\%G%#$b$"$k$G$h!#(B*/

/* $BB>$N%l%Y%k$N%3!<%G%#%s%0$bF~$C$F$?$j$9$k$h!#(B*/

/*****************************************************************
$B!}(B $B%a%b%jD>@\A`:n!J#G!K(B $B"*(B kblt_guard_blt_memory $B$G$b:n$k$+!)(B

 $B!&(Btag_and_value(Data,^Tag,^Value)
	guard, system
	$BG$0U(B($BJQ?t$r=|$/(B)$B%G!<%?$N(BTag$B$H(BValue$B$NCM$r@0?tCM$H$7$F5a$a$k!#(B
	$B$1$C$3$&?'!9$J>lLL$G;H$o$l$k!#%F%9%H%W%m$G$b;HMQ!#(B

        wait$B7O$NL?Na$r%3%s%Q%$%i$,=P$9$N$G!"(B
        $B%l%8%9%?>e$NCM$rJV$9$@$1$GNI$$!#(B

 $B!&(Bset_tag_and_value(^Data,Tag,Value)
	guard, system
	$B;XDj$N(BTag$B$H(BValue$B$r;}$C$?%G!<%?(B($B%"%H%_%C%/$K8BDj(B)$B$r@8@.$9$k!#(B
	$B%m!<%@!<$GHV9f$r;XDj$7$F%"%H%`$r@8@.$9$k$N$K;H$&!#(B

 $B!&(Bword(Address,^Tag,^Value)
	guard, system
	$B;XDj%"%I%l%9$N%a%b%j$N(BTag$B$H(BValue$B$NCM$r@0?tCM$H$7$F5a$a$k!#(B
	$B%F%9%H%W%m$G;HMQ!#(B

 $B!&(Bset_word(Address,Tag,Value)
	guard, system
	$B;XDj$N(BTag$B$H(BValue$B$r;}$C$?%G!<%?(B($B%"%H%_%C%/$K8BDj(B)$B$r@8@.$7!"(B
	$B;XDj%"%I%l%9$N%a%b%j$K=q$-9~$`!#(B
********************************************************************/

#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_R3field    _IndirectRegField3

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2
#OPF_define I_ImmR3field _ImmediateField3

#DATA_define D_WorkBuiltins XXX

#PSL_define kblt_tag_and_value(){
  @DEBUG{
    b_IfRangeErr(I_ImmR1field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_tag_and_value","r1_range");
    }
    b_IfRangeErr(I_ImmR2field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_tag_and_value","r2_range");
    }
    b_IfRangeErr(I_ImmR3field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_tag_and_value","r3_range");
    }
  };
  $USE(D_WorkBuiltins);
  p_MoveWord(I_R1field,D_WorkBuiltins);
  /* maybe I_R1field, I_R2field and I_R3field are the same register */
  /* so I use work register */
  p_MoveTagToValue(D_WorkBuiltins,I_R2field);
  p_MoveWord(D_WorkBuiltins,I_R3field);
  $RELEASE(D_WorkBuiltins);
  p_SetImmediateTag(INT,_MRB_OFF,I_R2field);
  p_SetImmediateTag(INT,_MRB_OFF,I_R3field);
}
#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_R3field    _IndirectRegField3

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2
#OPF_define I_ImmR3field _ImmediateField3

#PSL_define kblt_set_tag_and_value(){
  @DEBUG{
    b_IfRangeErr(I_ImmR1field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_set_tag_and_value","r1_range");
    }
    b_IfRangeErr(I_ImmR2field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_set_tag_and_value","r2_range");
    }
    b_IfRangeErr(I_ImmR3field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_set_tag_and_value","r3_range");
    }
  };
  p_MoveValueToTag(I_R2field,I_R1field);
  p_MoveValue(I_R3field,I_R1field);
}
#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_R3field    _IndirectRegField3

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2
#OPF_define I_ImmR3field _ImmediateField3

#PSL_define kblt_word(){
  @DEBUG{
    b_IfRangeErr(I_ImmR1field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_word","r1_range");
    }
    b_IfRangeErr(I_ImmR2field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_word","r2_range");
    }
    b_IfRangeErr(I_ImmR3field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_word","r3_range");
    }
  };
  p_Read(I_R1field,I_R3field);
  p_MoveTagToValue(I_R3field,I_R2field);
  p_SetImmediateTag(INT,_MRB_OFF,I_R2field);
  p_SetImmediateTag(INT,_MRB_OFF,I_R3field);
}
#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_R3field    _IndirectRegField3

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2
#OPF_define I_ImmR3field _ImmediateField3

#PSL_define kblt_set_word(){
  @DEBUG{
    b_IfRangeErr(I_ImmR1field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_set_word","r1_range");
    }
    b_IfRangeErr(I_ImmR2field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_set_word","r2_range");
    }
    b_IfRangeErr(I_ImmR3field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_set_word","r3_range");
    }
  };
  $USE(D_WorkBuiltins);
  p_MoveValueToTag(I_R2field,D_WorkBuiltins);
  p_MoveValue(I_R3field,D_WorkBuiltins);
  p_Write(D_WorkBuiltins,I_R1field);
  $RELEASE(D_WorkBuiltins);
}

/***************************************************************
$B!}(B $B%R!<%W$NA`:n!J#B!K(B
  $B!J%7%9%F%`0l@F$N%/%i%9%?Fb(BGC$B$N$?$a$K;H$&!K(B

 $B!&(Bget_heap_size(^Size,^Used)
	body, user
	$B8=:_$N%R!<%W;HMQNL$r5a$a$k!#(B

 Size: $B%R!<%WA4BN$N%5%$%:!"0lEYN)$A>e$,$C$?$iF1$8CM$N$O$:!#(B
       $B%3%T!<#G#C$N!"JRLL$N%5%$%:$G$9$M!#(B
 Used: $B8=:_$N;HMQNL!#(B

	$BC10L!J%o!<%I!?%P%$%H!K$O%^%7%s0MB8(B

 $B!&(Bset_heap_alert(Asize,^Aalarm)
	body, system
	$B;HMQNL$,;XDj$NCM(B Asize $B$r1[$($?$i(B/$B1[$($F$$$?$i(B Aalarm $B$r(B
	$B8=:_$N;HMQNL$G6qBN2=$9$k!#(B

	$B$9$G$K6qBN2=BT$A$N%j%/%(%9%H$,$"$k>l9g!"(B
	$B@h$N%j%/%(%9%H$KBP$7$F$O(B [] $B$rJV$9!#(B

 Asize: $B;HMQNL$HHf3S$5$l$kCM!#;HMQNL$,$3$NCM$r1[$($?$i!"(B
         Aalarm $B$r8=:_$N;HMQNL$G6qBN2=$9$k!#(B

        $B!J$3$l$O6qBN2=BT$A$NJQ?t$r3P$($F$*$/$3$H$,I,MW(B
						->GC$B%k!<%H$,A}$($k!K(B

 Aalarm $B$r(BKL1$B%W%m%0%i%`B&$G>!<j$K6qBN2=$9$k$H!"(B
        set_heap_alert$B$rH/9T$7$?%4!<%k$NB0$9$kAq1`$K(B
        $B%f%K%U%#%1!<%7%g%s$N<:GT$,Js9p$5$l$k$G$"$m$&!#(B

$B;XDj%5%$%:$,!"%R!<%W%5%$%:$r1[$($F$$$?$iNc30$K$7$F$"$k!#(B

******************************************************************/

#OPF_define I_HeapSize _IndirectRegField1
#OPF_define I_HeapUsed _IndirectRegField2

#PSL_define kblt_b_get_heap_size(){
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp2ArgVect_OO_Sub
	    (D_WorkArgVect,I_HeapSize,I_HeapUsed));
      f_TraceBodyBuiltin(BLT_B_GET_HEAP_SIZE,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  s_GetHeapSize(I_HeapSize,I_HeapUsed);
 End_of_KL1B_Instruction:;
}

#DATA_define D_Work_HeapSize XXX
#DATA_define D_Work_HeapUsed XXX

#OPF_define I_HeapAlertSize _IndirectRegField1
#OPF_define I_AlarmVariable _IndirectRegField2

#PSL_define kblt_b_set_heap_alert(){
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp2ArgVect_IO_Sub
	    (D_WorkArgVect,I_HeapAlertSize,I_AlarmVariable));
      f_TraceBodyBuiltin(BLT_B_SET_HEAP_ALERT,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE (D_Workreg1);
  f_ActiveDeref (I_HeapAlertSize, D_Workreg1);
  TypeSwitch (I_HeapAlertSize) {

    case INT:
      $RELEASE (D_Workreg1);
      break;

    case UnboundGroup (): 
      p_MoveWord (D_Workreg1, I_HeapAlertSize);
      $RELEASE (D_Workreg1);
      f_DcodeEnqueue2Ope_IO(BLT_B_SET_HEAP_ALERT,
			     I_HeapAlertSize,
			     I_AlarmVariable);
      /* I_HeapAlertSize $B$,(B UNDEF$B7O$J$i%5%9%Z%s%I(B */
      goto END;

    case ATOM:
    case FLT:
    case StructureGroup ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg1);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
      $USE (D_WorkOpCode);
      b_SetImmTypeValueMRBoff (INT, BLT_B_SET_HEAP_ALERT, D_WorkOpCode);
      $CALL (f_Exception_2Arg_IO_Sub(D_WorkExceptionCode, D_WorkOpCode, 
				     D_WorkExcepArgPos,
				     I_HeapAlertSize,
				     I_AlarmVariable));
      $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
      $RELEASE(D_WorkExcepArgPos);
      goto END;

    default: 
      $RELEASE (D_Workreg1);
      @DEBUG {VPIM_ERROR ("kblt_b_set_heap_alert", "undefined type");};
      goto END;
  }

  $USE(D_Work_HeapSize);
  $USE(D_Work_HeapUsed);
  s_GetHeapSize(D_Work_HeapSize,D_Work_HeapUsed);

  b_IfGreaterEq(I_HeapAlertSize,D_Work_HeapSize){
    /* $B$b$7!"(BHeapAlertSize $B$,(B HeapSize $B$r1[$($F$$$?$i!"(B
     * AlarmVariable $B$,6qBN2=$5$l$k$3$H$,$J$/$J$k$N$G!"Nc30$H$9$k!#(B
     */
    $RELEASE(D_Work_HeapSize);
    $RELEASE(D_Work_HeapUsed);
    $USE (D_WorkExceptionCode);
    $USE(D_WorkExcepArgPos);
    b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP, D_WorkExceptionCode);
    b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
    $USE (D_WorkOpCode);
    b_SetImmTypeValueMRBoff (INT, BLT_B_SET_HEAP_ALERT, D_WorkOpCode);
    $CALL (f_Exception_2Arg_IO_Sub(D_WorkExceptionCode, D_WorkOpCode, 
				   D_WorkExcepArgPos,
				   I_HeapAlertSize,
				   I_AlarmVariable));
    $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
    $RELEASE(D_WorkExcepArgPos);
    goto END;
  }
  $RELEASE(D_Work_HeapSize);

  b_IfGreater(D_Work_HeapUsed,I_HeapAlertSize){
    /* HeapUsed $B$,$9$G$K(B HeapAlertSize $B$r1[$($F$$$?$i!"(B
     * AlarmVariable $B$r(B HeapUsed $B$G6qBN2=!JC1$J$kBeF~!K$9$k!#(B
     */
    $USE(D_Work_HeapAlertVarLockOrgTagReg);
    b_LockHeapAlertVar(D_Work_HeapAlertVarLockOrgTagReg);
    $USE(D_Work_HeapAlertVar);
    b_GetHeapAlertVar(D_Work_HeapAlertVar);
    s_IfREF(D_Work_HeapAlertVar){
      /* $B@h9T$9$k6qBN2=BT$A$"$j(B $B"*(B $B5/$3$7$F$7$^$&!#(B*/
      $USE(D_WorkConst);
      b_MoveWithImmTypeMRBoff(D_NULL,ATOM,D_WorkConst); /* [] */
      i_KlbUnifyBound(D_Work_HeapAlertVar,D_WorkConst);
      /* $B$3$s$J$N8F$s$G$k$+$i(B f-$B%l%Y%k$KMn$;$J$$!D(B */
      $RELEASE(D_WorkConst);
      s_ResetHeapAlertVar();
    }
    $RELEASE(D_Work_HeapAlertVar);
    b_UnlockHeapAlertVar(D_Work_HeapAlertVarLockOrgTagReg);
    $RELEASE(D_Work_HeapAlertVarLockOrgTagReg);
    b_MoveWithImmTypeMRBoff(D_Work_HeapUsed,INT,I_AlarmVariable);
    $RELEASE(D_Work_HeapUsed);
  }else{
    /* HeapUsed $B$,$^$@(B HeapAlertSize $B$r1[$($F$$$J$+$C$?$i!"(B
     * AlarmVariable $B$KJQ?t$r3d$jEv$F$F!"$3$l$r3P$($F$*$/!#(B
     * $B%R!<%W%H%C%W99?7$N;~$K!"%A%'%C%/$9$kI,MW$"$j!#(B
     */
    $RELEASE(D_Work_HeapUsed);
    $USE(D_Work_HeapAlertVarLockOrgTagReg);
    b_LockHeapAlertVar(D_Work_HeapAlertVarLockOrgTagReg);
    $USE(D_Work_HeapAlertVar);
    b_GetHeapAlertVar(D_Work_HeapAlertVar);
    s_IfREF(D_Work_HeapAlertVar){
      /* $B@h9T$9$k6qBN2=BT$A$"$j(B $B"*(B $B5/$3$7$F$7$^$&!#(B*/
      $USE(D_WorkConst);
      b_MoveWithImmTypeMRBoff(D_NULL,ATOM,D_WorkConst); /* [] */
      i_KlbUnifyBound(D_Work_HeapAlertVar,D_WorkConst);
      /* $B$3$s$J$N8F$s$G$k$+$i(B f-$B%l%Y%k$KMn$;$J$$!D(B */
      $RELEASE(D_WorkConst);
    }
    b_SetHeapAlertSize(I_HeapAlertSize);
    s_AllocVariable(D_Work_HeapAlertVar);
    s_AllocVariable(I_AlarmVariable);
    $USE(D_WorkNewGR);
    $CALL(f_MakeUnifier_Sub(D_WorkNewGR,D_Work_HeapAlertVar,I_AlarmVariable));
    @DEBUG{
      s_IfNotHOOK(D_WorkNewGR){
	VPIM_ERROR("kblt_b_set_heap_alert","NewGR ptr type not HOOK");
      }
    };
    @PROBE { b_IncrementReg( D_HOOK_GOAL_COUNT ); };
    p_Write(D_WorkNewGR,D_Work_HeapAlertVar);
    $RELEASE(D_WorkNewGR);
    b_SetHeapAlertVar(D_Work_HeapAlertVar);
    $RELEASE(D_Work_HeapAlertVar);
    b_UnlockHeapAlertVar(D_Work_HeapAlertVarLockOrgTagReg);
    $RELEASE(D_Work_HeapAlertVarLockOrgTagReg);
  }

 END: ;
 End_of_KL1B_Instruction: ;
}

/*****************************************************************
$B!}(B $B%?%$%^$NA`:n!J%U%'%C%W$N;~7W$KG$$9$N$H$OJL!K(B
	$B!J%^%7%s$K$h$C$F$O$J$/$F$bNI$$$,%@%_!<$OI,MW!K(B

 $B!&(Bsystem_timer(^High,^Low) $B!J#G!K(B
	guard, user
	$B%7%9%F%`%?%$%^$NCM$r<h$j=P$9!#(B
	$B%7%9%F%`%?%$%^$O(BPE$B$,;}$C$F$$$k0lDj4V3V$G%$%s%/%j%a%s%H$5$l$k%+%&%s%?(B
	$B$G$"$k$,!"%$%s%/%j%a%s%H$9$k4V3V$O5!<o0MB8!)(B
	$B%S%C%HI}$O#6#4%S%C%H0JFb!#(B

 $B!&(Bset_timer(High,Low,^Wakeup)     $B!J#B!K(B
	body, system
	$B%"%i!<%`%/%m%C%/$N5!G=!#(B
	$B;XDj;~9o(B($B%7%9%F%`%?%$%^$NCM(B)$B$K(B Wakeup $B$r6qBN2=$9$k!#(B

	set_timer $B$N%j%/%(%9%H$O%/%i%9%?Fb$G!"#P#EKh$K<u$1IU$1$k!#(B
	$B0lO"$N%j%/%(%9%H$O!"#P#E%l%8%G%s%H$J%W%m%;%9$,H/9T$9$k$3$H!#(B

	$B%?%$%^5!G=$r;}$?$J$$(B PIM $B$G$O(B, Wakeup $B$K$?$@$A$K(B [] $B$r%f%K%U%!%$$9(B
	$B$k!#(B

     $B0JA0$K$3$N=R8l$G(B wakeup $BJs9p$r;XDj$7$?$,L$=hM}$N$b$N$,$"$l$P(B, $B0JA0(B
     $B$K;XDj$5$l$?(B Wakeup $B$K(B [] $B$r%f%K%U%!%$$9(B
 
     $B;XDj;~9o$,(B ($B%7%9%F%`!&%?%$%^$G7W$C$F(B) $B4{$KMh$F$$$l$P(B, $B$?$@$A$K(B 
     Wakeup $B$H%7%9%F%`!&%?%$%^$NCM$r%f%K%U%!%$$9$k(B.  $B$^$@$J$i$P(B, $B;XDj;~9o(B 
     $B0J9_(B ($B$N$G$-$k$@$1Aa$$;~9o(B) $B$K(B Wakeup $B$H$=$N;~E@$N%7%9%F%`!&%?(B
     $B%$%^$NCM$r%f%K%U%!%$$9$k(B.

$B%?%$%^$NCM$rJV$9$3$H$K$OFC$K0UL#$O$J$$(B.  $B2?$+JV$9$H$7$?$i0UL#$"$j$2$J(B
$B$b$N$rJV$7$?$3$H$,$$$$$@$m$&(B, $B$H$$$&DxEY$N$3$H$G$"$k(B.

     $B$H$$$&$3$H$G!"(B
     $B@53N$K$$$&$H%7%9%F%`%?%$%^$N2<0L%o!<%I$H$N%f%K%U%!%$$K$J$C$F$^$9!D(B
     $BN>J}F~$C$?%Y%/%?$NJ}$,NI$$!)(B

$B$J$*(B, $B%?%$%^$NC10L;~4V$*$h$SCM$NHO0O$O=hM}7O0MB8$H$9$k(B.  $B$G$-$l$P(B 1ms 
$BDxEY0J2<$NC10L;~4V$G(B, 1 $BF|DxEY0J>e$NHO0O$rI=$;$k$3$H$,K>$^$7$$(B.

$B%7%9%F%`!&%?%$%^$OM-8BI}(B ($B0J2<(B, $B2>$K(B W $B%S%C%H$H$9$k(B) $B$7$+$J$$$N$G(B, $B%i%C(B
$B%W!&%"%i%&%s%I$,LdBj$K$J$k(B.  $B$=$3$G(B, $B0J2<$N$h$&$K@0?tCM$GM?$($i$l$?;~(B
$B9o$NA08e4X78$r7h$a$k$3$H$K$9$k(B.

    $B!V(BT2 $B$O(B T1 $B$HF1;~9o!W(B :- T2 = T1 | true.
    $B!V(BT2 $B$O(B T1 $B$h$j8e!W(B :- T2 &- T1 <  2^(W-1) | true.
    $B!V(BT2 $B$O(B T1 $B$h$jA0!W(B :- T2 &- T1 >= 2^(W-1) | true.

$B$?$@$7(B, $B%*%Z%l!<%?(B &- $B$O(B mod 2^W $B$NId9f$J$7$N8:;;(B.
$B$A$g$&$I(B 2^(W-1) $B$@$1N%$l$F$$$k;~$O!V(BT2 $B$O(B T1 $B$h$jA0!W(B


	0				       2^W
	+--------+-----------+------------------+
		 T1	     T2
		 |-----------|
		    T2 - T1
     +--+--------+---------------------------+--+
  T1-2^W	 T2			     T1
     |-----------|
    (T2-T1) mod 2^W

********************************************

PIM/p $B$b(B PIM/s $B$b(B $B%"%i!<%`%?%$%^$O(B PE $B%m!<%+%k!#(B

*****************************************************************/

#OPF_define I_TimeHigh _IndirectRegField1
#OPF_define I_TimeLow  _IndirectRegField2

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2

#PSL_define kblt_system_timer(){
  @DEBUG{
    b_IfRangeErr(I_ImmR1field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_system_timer","r1_range");
    }
    b_IfRangeErr(I_ImmR2field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_system_timer","r2_range");
    }
  };
/* just for PIM/s */
  b_MoveWithImmTypeMRBoff(D_NULL,INT,I_TimeHigh);
  b_GetCurrentTime(I_TimeLow);
  b_SetImmTypeMRBoff(INT,I_TimeLow);

/* for PIM/p ?? */
/* _GetCurrentTime(I_TimeHigh,I_TimeLow);*/

}

#DATA_define D_Work_NewTime       XXX
#DATA_define D_Work_OldTime       XXX
#DATA_define D_Work_AlarmTimerVar XXX
#DATA_define D_Work_CurrentTime   XXX

#OPF_define I_TimeHigh _IndirectRegField1
#OPF_define I_TimeLow  _IndirectRegField2
#OPF_define I_Wakeup   _IndirectRegField3

#PSL_define kblt_b_set_timer(){
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_IIO_Sub
	    (D_WorkArgVect,I_TimeHigh,I_TimeLow,I_Wakeup));
      f_TraceBodyBuiltin(BLT_B_SET_TIMER,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

/* $BBh#10z?t(B I_TimerHigh $B$N%A%'%C%/(B */

  $USE (D_Workreg1);
  f_ActiveDeref (I_TimeHigh, D_Workreg1);
  TypeSwitch (I_TimeHigh) {

    case INT:
      $RELEASE (D_Workreg1);
      break;

    case UnboundGroup (): 
      p_MoveWord (D_Workreg1, I_TimeHigh);
      $RELEASE (D_Workreg1);
      f_DcodeEnqueue3Ope_IIO(BLT_B_SET_TIMER,
			     I_TimeHigh,I_TimeLow,
			     I_Wakeup);
      /* I_TimeHigh $B$,(B UNDEF$B7O$J$i%5%9%Z%s%I(B */
      goto END;

    case ATOM:
    case FLT:
    case StructureGroup ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg1);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
      $USE (D_WorkOpCode);
      b_SetImmTypeValueMRBoff (INT, BLT_B_SET_TIMER, D_WorkOpCode);
      $CALL (f_Exception_3Arg_IIO_Sub(D_WorkExceptionCode, D_WorkOpCode, 
				     D_WorkExcepArgPos,
				     I_TimeHigh,I_TimeLow,
				     I_Wakeup));
      $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
      $RELEASE(D_WorkExcepArgPos);
      goto END;

    default: 
      $RELEASE (D_Workreg1);
      @DEBUG {VPIM_ERROR ("kblt_b_set_timer", "undefined type");};
      goto END;
  }

/* $BBh#20z?t(B I_TimerLow $B$N%A%'%C%/(B */

  $USE (D_Workreg1);
  f_ActiveDeref (I_TimeLow, D_Workreg1);
  TypeSwitch (I_TimeLow) {

    case INT:
      $RELEASE (D_Workreg1);
      break;

    case UnboundGroup (): 
      p_MoveWord (D_Workreg1, I_TimeLow);
      $RELEASE (D_Workreg1);
      f_DcodeEnqueue3Ope_IIO(BLT_B_SET_TIMER,
			     I_TimeHigh,I_TimeLow,
			     I_Wakeup);
      /* I_TimeHigh $B$,(B UNDEF$B7O$J$i%5%9%Z%s%I(B */
      goto END;

    case ATOM:
    case FLT:
    case StructureGroup ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg1);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
      $USE (D_WorkOpCode);
      b_SetImmTypeValueMRBoff (INT, BLT_B_SET_TIMER, D_WorkOpCode);
      $CALL (f_Exception_3Arg_IIO_Sub(D_WorkExceptionCode, D_WorkOpCode, 
				     D_WorkExcepArgPos,
				     I_TimeHigh,I_TimeLow,
				     I_Wakeup));
      $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
      $RELEASE(D_WorkExcepArgPos);
      goto END;

    default: 
      $RELEASE (D_Workreg1);
      @DEBUG {VPIM_ERROR ("kblt_b_set_timer", "undefined type");};
      goto END;
  }

  @DEBUG{
    b_IfNotZero(I_TimeHigh){
      WARNING("kblt_b_set_time","TimeHigh not ZERO ignored (PIM/s only)");
    }
  };

  b_SignalOffSCR(_TIMER_ALARM_EVENT,D_PE_Number);

  $USE(D_Work_CurrentTime);
  b_GetCurrentTime(D_Work_CurrentTime);
  b_SetImmTypeMRBoff(INT,D_Work_CurrentTime);

  $USE(D_Work_AlarmTimerVar);
  s_ReadAlarmTimerVar(D_Work_AlarmTimerVar);
  s_IfREF(D_Work_AlarmTimerVar){
    @DEBUG{
      WARNING("kblt_b_set_time","there's a leading request");
    };
    /* $B@h9T$9$k6qBN2=BT$A$"$j(B $B"*(B $B5/$3$7$F$7$^$&!#(B*/
    $USE(D_WorkConst);
    b_MoveWithImmTypeMRBoff(D_NULL,ATOM,D_WorkConst);
    /* $B@h9T%j%/%(%9%H$N%-%c%s%;%k$r(B [] $B$GI=$7$F$$$k(B */
    i_KlbUnifyBound(D_Work_AlarmTimerVar,D_WorkConst);
    /* $B$3$s$J$N8F$s$G$k$+$i(B f-$B%l%Y%k$KMn$;$J$$!D(B */
    $RELEASE(D_WorkConst);
    s_ResetAlarmTimerVar();
  }
  $RELEASE(D_Work_AlarmTimerVar);

  $USE(D_Work_NewTime);/* PIM/p $B$G$O!"$3$3$i$X$s$r#2%o!<%I2=$9$k!#(B*/
  b_SubtractWithTag(I_TimeLow,D_Work_CurrentTime,D_Work_NewTime);
  p_IfLE(){
    @DEBUG{
      WARNING("kblt_b_set_time","already time reached");
    };
    /* $B$9$G$K;XDj;~9o$K$J$C$F$$$k!?$r2a$.$F$$$k!#(B*/
    $RELEASE(D_Work_NewTime);
    $USE(D_Work_OldTime);
    _SetAlarmTimer(D_NULL,D_Work_OldTime);
    $RELEASE(D_Work_OldTime);
    p_MoveWord(D_Work_CurrentTime,I_Wakeup);
    $RELEASE(D_Work_CurrentTime);
  }else{
    @DEBUG{
      WARNING("kblt_b_set_time",
	      "time not reached, make dcode unify goal hook");
    };
    /* $B$^$@;XDj;~9o$K$J$C$F$$$J$$!#(B */
    $RELEASE(D_Work_CurrentTime);
    $USE(D_Work_OldTime);
    _SetAlarmTimer(D_Work_NewTime,D_Work_OldTime);
    $RELEASE(D_Work_OldTime);
    $RELEASE(D_Work_NewTime);
    $USE(D_Work_AlarmTimerVar);
    s_AllocVariable(D_Work_AlarmTimerVar);
    s_AllocVariable(I_Wakeup);
    $USE(D_WorkNewGR);
    $CALL(f_MakeUnifier_Sub(D_WorkNewGR,D_Work_AlarmTimerVar,I_Wakeup));
    @DEBUG{
      s_IfNotHOOK(D_WorkNewGR){
	VPIM_ERROR("kblt_b_set_timer","NewGR ptr type not HOOK");
      }
    };
    @PROBE { b_IncrementReg( D_HOOK_GOAL_COUNT ); };
    p_Write(D_WorkNewGR,D_Work_AlarmTimerVar);
    $RELEASE(D_WorkNewGR);
    s_WriteAlarmTimerVar(D_Work_AlarmTimerVar);
    $RELEASE(D_Work_AlarmTimerVar);
  }

 END: ;
 End_of_KL1B_Instruction:;

/* $B%5%]!<%H$NL5$$%^%7%s(B
 * b_SetImmTypeValueMRBoff(ATOM,_ZERO,I_Wakeup);
 */

/* for PIM/p */
/*
$B!}$O(BBA register $B$N%"%/%;%9(B

$B0F#1!c!c(B
$B!}(B  _stop_timer();
$B!}(B  _if_timer_zero(){
$B!}(B  -get_current_time();
      _if_old_request_exist(){
        _instantiate_for_old_request();
$B!}(B      _reset_interrupt_flag();  $B%;%C%H$5$l$F$J$/$F$b%j%;%C%H$7$F(B
                                  $B#O#K$J$i$P!"0F#2$bNI$$(B
      }
    }else{
      _instantiate_for_old_request();
    }

    _if_time_reached(){
$B!}(B    _set_zero_timer();
      _return_current_time();
    }else{
      _hook_new_request();
$B!}(B    _set_timer();
$B!}(B    _run_timer();
    }
$B!d!d(B

$B0F#2(B
$B!c!c(B

$B!}(B  _stop_timer();
$B!}(B  _reset_interrupt_flag();
$B!}(B  -get_current_time();

    _if_old_request_exist(){
      _instantiate_for_old_request();
    }

    _if_time_reached(){
$B!}(B    _set_zero_timer();
      _return_current_time();
    }else{
      _hook_new_request();
$B!}(B    _set_timer();
$B!}(B    _run_timer();
    }
$B!d!d(B
*/

}
