
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/interpreter/klb_index.psl.c
   ----- CREATED   : by f-doumae@icot22, on Tue May 15 13:59:52 1990
   ----- LAST SAVED: by yamamoto@icot22, on Mon Oct 28 14:45:13 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : interpreter
   ----- ABSTRACT  : $B%?%$%WH=Dj!"CMH=Dj(B

1. $B%?%$%WH=Dj(B
    klb_is_atom (Reg, Lfail)
    klb_is_integer (Reg, Lfail)
    klb_is_floating_point (Reg, Lfail)
    klb_is_list (Reg, Lfail)
    klb_is_vector (Reg, Lfail)
    klb_is_string (Reg, Lfail)

2. $BCMH=Dj(B(2$BJ}8~J,4t(B)
    klb_test_atom (atom, Reg, Lfail)
    klb_test_integer (int, Reg, Lfail)
    klb_test_vect_size (size, Reg, Lfail)

3. $BCMH=Dj(B($BB?J}8~J,4t(B)
    klb_hash_on_atom (Reg, mask, Ltable)
    klb_hash_on_integer (Reg, mask, Ltable)
    klb_jump_on_integer (Reg, size, bias, Ltable)
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
$B%?%$%WH=Dj(B 
    klb_is_atom (Reg, Lfail)
    klb_is_integer (Reg, Lfail)
    klb_is_floating_point (Reg, Lfail)
    klb_is_list (Reg, Lfail)
    klb_is_vector (Reg, Lfail)
    klb_is_string (Reg, Lfail)

       written by f-doumae@icot22      on Wed May 16 13:45:28 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |        is_XXX         |    Reg    | don't care|
    +-----------+-----------+-----------+-----------+
    |         Lfail         |      don't  care      |
    +-----------+-----------+-----------+-----------+
<Arguments>
    Reg   : $B%l%8%9%?(B
    Lfail : $B%U%'%$%k%i%Y%k(B
<Temporally Used Variables>
<Level>
<PreCondition>
    Reg$B$O%G%l%U:Q$_(B
<Function>
    Reg$B>e$N%G!<%?$N%?%$%WH=Dj$r9T$&!#(B
    $B%?%$%W$,(B XXX $B$G$J$1$l$P!"%U%'%$%k%i%Y%k(BLfail $B$KJ,4t$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_RegSource _IndirectRegField1
#OPF_define I_ImmLfail  _ImmediateField2

#OPF_define I_ImmRegSource _ImmediateField1

#PSL_define klb_is_atom()
{
  @DEBUG{
    b_IfRangeErr(I_ImmRegSource, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("klb_is_atom","r1 range");
    }
  };
  s_IfNotATOM(I_RegSource) {
    s_SetKLB_PC_OPR(I_ImmLfail);
  }
}

#OPF_define I_RegSource _IndirectRegField1
#OPF_define I_ImmLfail  _ImmediateField2

#OPF_define I_ImmRegSource _ImmediateField1

#PSL_define klb_is_integer()
{
  @DEBUG{
    b_IfRangeErr(I_ImmRegSource, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("klb_is_integer","r1 range");
    }
  };
  s_IfNotINT(I_RegSource) {
    s_SetKLB_PC_OPR(I_ImmLfail);
  }
}

#OPF_define I_RegSource _IndirectRegField1
#OPF_define I_ImmLfail  _ImmediateField2

#OPF_define I_ImmRegSource _ImmediateField1

#PSL_define klb_is_floating_point()
{
  @DEBUG{
    b_IfRangeErr(I_ImmRegSource, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("klb_is_floating_point","r1 range");
    }
  };
  s_IfNotFLT(I_RegSource) {
    s_SetKLB_PC_OPR(I_ImmLfail);
  }
}

#OPF_define I_RegSource _IndirectRegField1
#OPF_define I_ImmLfail  _ImmediateField2

#OPF_define I_ImmRegSource _ImmediateField1

#PSL_define klb_is_list()
{
  @DEBUG{
    b_IfRangeErr(I_ImmRegSource, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("klb_is_list","r1 range");
    }
  };
  s_IfNotLIST(I_RegSource) {
    s_SetKLB_PC_OPR(I_ImmLfail);
  }
}

#OPF_define I_RegSource _IndirectRegField1
#OPF_define I_ImmLfail  _ImmediateField2

#OPF_define I_ImmRegSource _ImmediateField1

#PSL_define klb_is_vector()
{
  @DEBUG{
    b_IfRangeErr(I_ImmRegSource, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("klb_is_vector","r1 range");
    }
  };
  s_IfNotVectors(I_RegSource) {
    s_SetKLB_PC_OPR(I_ImmLfail);
  }
}

#OPF_define I_RegSource _IndirectRegField1
#OPF_define I_ImmLfail  _ImmediateField2

#OPF_define I_ImmRegSource _ImmediateField1

#PSL_define klb_is_string()
{
  @DEBUG{
    b_IfRangeErr(I_ImmRegSource, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("klb_is_string","r1 range");
    }
  };
  s_IfNotSTRG(I_RegSource) {
    s_SetKLB_PC_OPR(I_ImmLfail);
  }
}


/******************************************************************** PSL **
klb_test_atom  atom, Reg, Lfail

       written by f-doumae@icot22      on Wed May 16 14:03:02 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |       test_atom       |        don't care     |
    +-----------+-----------+-----------+-----------+
    |                     atom                      |
    +-----------+-----------+-----------+-----------+
    |    Reg    |         Lfail         | don't care|
    +-----------+-----------+-----------+-----------+
<Arguments>
    atom       : $B%"%H%`HV9f(B($B@0?t(B)
    Reg        : $B%l%8%9%?(B
    Lfail      : $B%U%'%$%k%i%Y%k(B
<Temporally Used Variables>
<Level>
<PreCondition>
    Reg$B$O%G%l%U!"%?%$%WH=Dj:Q$_(B
<Function>
    Reg$B>e$N(BValue$BIt$NCM$,(Batom$B$G$J$1$l$P!"%U%'%$%k%i%Y%k(BLfail$B$KJ,4t$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_ImmAtom       _ImmediateField1
#OPF_define I_RegSource     _IndirectRegField2
#OPF_define I_ImmLfail      _ImmediateField3

#OPF_define I_ImmRegSource  _ImmediateField2

#PSL_define klb_test_atom()
{
  @DEBUG{
    b_IfRangeErr(I_ImmRegSource, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("klb_test_atom","r2 range");
    }
    s_IfNotATOM(I_RegSource){
      VPIM_ERROR("klb_test_atom","Illegal_type");
    }
  };
  b_IfNotEqualOpr(I_RegSource, I_ImmAtom){
    s_SetKLB_PC_OPR(I_ImmLfail);
  }
}


/******************************************************************** PSL **
klb_test_integer  integer, Reg, Lfail

       written by f-doumae@icot22      on Wed May 16 14:15:17 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |      test_integer     |       don't care      |
    +-----------+-----------+-----------+-----------+
    |                    integer                    |
    +-----------+-----------+-----------+-----------+
    |    Reg    |         Lfail         |don't  care|
    +-----------+-----------+-----------+-----------+
<Arguments>
    integer    : $B@0?t(B
    Reg        : $B%l%8%9%?(B
    Lfail      : $B%U%'%$%k%i%Y%k(B
<Temporally Used Variables>
<Level>
<PreCondition>
    Reg$B$O%G%l%U!"%?%$%WH=Dj:Q$_(B
<Function>
    Reg$B>e$N(BValue$BIt$NCM$,(Binteger$B$G$J$1$l$P!"(BLfial$B$KJ,4t$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_ImmInt       _ImmediateField1
#OPF_define I_RegSource    _IndirectRegField2
#OPF_define I_ImmLfail     _ImmediateField3

#OPF_define I_ImmRegSource _ImmediateField2

#PSL_define klb_test_integer()
{
  @DEBUG{
    b_IfRangeErr(I_ImmRegSource, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("klb_test_integer","r2 range");
    }
    s_IfNotINT(I_RegSource){
      VPIM_ERROR("klb_test_integer","Illegal_type");
    }
  };
  b_IfNotEqualOpr(I_RegSource, I_ImmInt){
    s_SetKLB_PC_OPR(I_ImmLfail);
  }
}


/******************************************************************** PSL **
klb_test_vect_size  size, Reg, Lfail

       written by f-doumae@icot22      on Wed May 16 14:22:23 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |    test_vect_size     |   size    |    Reg    |
    +-----------+-----------+-----------+-----------+
    |         Lfail         |      don't care       |
    +-----------+-----------+-----------+-----------+
<Arguments>
    size  : $B%Y%/%?$NMWAG?t(B($B@0?t(B)
    Reg   : $B%Y%/%?$r;X$9%l%8%9%?(B
    Lfail : $B%U%'%$%k%i%Y%k(B
<Temporally Used Variables>
    D_WorkVectSize : Reg$B>e$N%Y%/%?$NMWAG?t(B
<Level>
<PreCondition>
    Reg$B$O%G%l%U!"%?%$%WH=Dj:Q$_(B
<Function>
    Reg$B>e$N%Y%/%?$NMWAG?t$,(Bsize$B$G$J$1$l$P!"(BLfail$B$KJ,4t$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_ImmVectSize    _ImmediateField1
#OPF_define I_RegSource      _IndirectRegField2
#OPF_define I_ImmLfail       _ImmediateField3

#OPF_define I_ImmRegSource   _ImmediateField2

#PSL_define klb_test_vect_size()
{
  @DEBUG{
    b_IfRangeErr(I_ImmRegSource, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("klb_test_vect_size","r2 range");
    }
    s_IfNotVectors(I_RegSource){
      VPIM_ERROR("klb_test_vect_size","Illegal type");
    }
  };
  $USE(D_WorkVectSize);
  s_GetSizeVectType(I_RegSource, D_WorkVectSize);
  b_IfNotEqualOpr(D_WorkVectSize, I_ImmVectSize){
    s_SetKLB_PC_OPR(I_ImmLfail);
  }
  $RELEASE(D_WorkVectSize);
}

/******************************************************************** PSL **
klb_hash_on_atom Reg, mask, Ltable

       written by f-doumae@icot22      on Mon Jun 11 11:11:30 1990

     0          1          2          3          4  
     +----------+----------+----------+----------+
     | 	  hash_on_atom     |    Reg   |don't care|
     +----------+----------+----------+----------+
     |        mask         |       Ltable        |
     +----------+----------+----------+----------+ 

<Arguments>
    Reg  : $BHf3S$9$kCM(B($B%"%H%`(B:$B@0?tCM(B)$B$r;}$D%l%8%9%?(B
    mask : $B%^%9%/CM(B(mask + 1 $B$,%O%C%7%e%F!<%V%k%5%$%:$K$J$k(B)
    Ltable : $B%O%C%7%e%F!<%V%k$X$N(BPC$BAjBP%"%I%l%9(B
<Temporally Used Variables>
<Level>
<PreCondition>
    Reg$B$O%G%l%U!"%?%$%WH=Dj:Q$_(B
<Function>
    $B%O%C%7%e%F!<%V%k$K$h$kB?J}8~J,4tL?Na!#%l%8%9%?(BReg$B>e$N%"%H%`$NCM$,(B
    $B%F!<%V%kCf$K$"$l$P!"$=$l$KBP1~$9$k%i%Y%k$KJ,4t$7!"$=$NCM$,!"%F!<%V%k$K(B
    $B$J$$>l9g$K$O<!L?Na$K?J$`!#(B
<Examples>
<Test>
<Explanation>
    $B%F!<%V%k$N7A<0$O(BPIM$B<B5!Kh$K0[$J$k!#(B
    PIM/s$B$K$*$1$k%F!<%V%k7A<0$O(Bstr_code.psl.c$B$r;2>H$N$3$H!#(B
<ETC>
********************************************************************* PSL **/
#DATA_define D_WorkMask XXX

#OPF_define I_RegSource _IndirectRegField1
#OPF_define I_ImmMask   _ImmediateField2
#OPF_define I_ImmLtable _ImmediateField3

#OPF_define I_ImmRegSource  _ImmediateField1

#PSL_define klb_hash_on_atom()
{
  @DEBUG{
    b_IfRangeErr(I_ImmRegSource, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("klb_hash_on_atom","r1 range");
    }
    s_IfNotATOM(I_RegSource){
      VPIM_ERROR("klb_hash_on_atom","Illegal_type");
    }
  };
  $USE(D_WorkMask);
  p_MoveImmediateValueFromImmediateField(I_ImmMask, D_WorkMask);
  s_GetAddressHashOnValue(I_RegSource, D_WorkMask, I_ImmLtable);
  $RELEASE(D_WorkMask);
}

/******************************************************************** PSL **
klb_hash_on_integer Reg, mask, Ltable

       written by f-doumae@icot22      on Mon Jun 11 11:46:28 1990

     0          1          2          3          4  
     +----------+----------+----------+----------+
     | 	  hash_on_integer  |    Reg   |don't care|
     +----------+----------+----------+----------+
     |        mask         |       Ltable        |
     +----------+----------+----------+----------+ 
<Arguments>
    Reg  : $BHf3S$9$kCM(B($B@0?tCM(B)$B$r;}$D%l%8%9%?(B
    mask : $B%^%9%/CM(B(mask + 1 $B$,%O%C%7%e%F!<%V%k%5%$%:$K$J$k(B)
    Ltable : $B%O%C%7%e%F!<%V%k$X$N(BPC$BAjBP%"%I%l%9(B
<Temporally Used Variables>
<Level>
<PreCondition>
    Reg$B$O%G%l%U!"%?%$%WH=Dj:Q$_(B
<Function>
    $B%O%C%7%e%F!<%V%k$K$h$kB?J}8~J,4tL?Na!#%l%8%9%?(BReg$B>e$N@0?tCM$,(B
    $B%F!<%V%kCf$K$"$l$P!"$=$l$KBP1~$9$k%i%Y%k$KJ,4t$7!"$=$NCM$,!"%F!<%V%k$K(B
    $B$J$$>l9g$K$O<!L?Na$K?J$`!#(B
<Examples>
<Test>
<Explanation>
    $B%F!<%V%k$N7A<0$O(BPIM$B<B5!Kh$K0[$J$k!#(B
    PIM/s$B$K$*$1$k%F!<%V%k7A<0$O(Bstr_code.psl.c$B$r;2>H$N$3$H!#(B
<ETC>
********************************************************************* PSL **/
#OPF_define I_RegSource _IndirectRegField1
#OPF_define I_ImmMask   _ImmediateField2
#OPF_define I_ImmLtable _ImmediateField3

#OPF_define I_ImmRegSource  _ImmediateField1

#PSL_define klb_hash_on_integer()
{
  @DEBUG{
    b_IfRangeErr(I_ImmRegSource, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("klb_hash_on_integer","r1 range");
    }
    s_IfNotINT(I_RegSource){
      VPIM_ERROR("klb_hash_on_integer","Illegal_type");
    }
  };
  $USE(D_WorkMask);
  p_MoveImmediateValueFromImmediateField(I_ImmMask, D_WorkMask);
  s_GetAddressHashOnValue(I_RegSource, D_WorkMask, I_ImmLtable);
  $RELEASE(D_WorkMask);
}

/******************************************************************** PSL **
klb_jump_on_integer Reg, size, bias, Ltable

       written by f-doumae@icot22      on Mon Jun 11 11:57:27 1990

     0          1          2          3          4  
     +----------+----------+----------+----------+
     | 	jump_on_intger     |   Reg    |don't care|
     +----------+----------+----------+----------+
     |         size        |     don't care      |
     +----------+----------+----------+----------+
     |                   bias                    |
     +----------+----------+----------+----------+ 
     |        Ltable       |                     |
     +----------+----------+----------+----------+ 
<Arguments>
    Reg   $B%l%8%9%?(B($B@0?t$N$_(B)
    size  $B%(%s%H%j%5%$%:(B(16 bit$B0JFb$N@0?t(B)
    bias  $B%F!<%V%k$r$R$/A0$K@0?tCM$+$i8:;;$9$kDj?t(B
    Ltable $B%8%c%s%W%F!<%V%k$X$N(BPC$BAjBP%"%I%l%9(B
<Temporally Used Variables>
<Level>
<PreCondition>
    Reg$B$O%G%l%U!"%?%$%WH=Dj:Q$_(B
<Function>
    $B%$%s%G%C%/%9%F!<%V%k$K$h$kB?J}8~J,4tL?Na!#%l%8%9%?(BReg$B>e$N@0?tCM$,(B
    $B%F!<%V%kCf$K$"$l$P!"$=$l$KBP1~$9$k%i%Y%k$KJ,4t$7!"$=$NCM$,!"%F!<%V%k$K(B
    $B$J$$>l9g$K$O<!L?Na$K?J$`!#(B
<Examples>
<Test>
<Explanation>
    $B%$%s%G%C%/%9%F!<%V%k$O!"@0?tCM$,(Bbias$B0J>e(Bbias+size$BL$K~$KBP1~$9$k%(%s%H%j$r(B
    $B;}$A!"@0?tCM$,$=$NHO0OFb$N>l9g$KBP1~$9$k%(%s%H%j$N%i%Y%k$KJ,4t$9$k!#(B
    $B>0!"%3%s%Q%$%i$X$N;X<($K$h$j!"(Bbias$B$NHO0O$r@)8B$9$k$3$H$,$G$-!"Nc$($P(B
    $BI,$:(B0$B$H$J$k$h$&$K$9$k$H%F!<%V%k$O(B0$B$+$i$NO"B3$7$?CM$KBP1~$9$k$3$H$K$J$k!#(B
<ETC>
********************************************************************* PSL **/
#OPF_define I_RegSource   _IndirectRegField1
#OPF_define I_ImmTblSize  _ImmediateField2
#OPF_define I_ImmBias     _ImmediateField3
#OPF_define I_ImmLtable   _ImmediateField4

#OPF_define I_ImmRegSource _ImmediateField1

#PSL_define klb_jump_on_integer()
{
  @DEBUG{
    b_IfRangeErr(I_ImmRegSource, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("klb_jump_on_integer","r1 range");
    }
    s_IfNotINT(I_RegSource){
      VPIM_ERROR("klb_jump_on_integer","Illegal_type");
    }
  };
  $USE(D_WorkSize);
  $USE(D_WorkValueReg);
  p_MoveImmediateValueFromImmediateField(I_ImmTblSize, D_WorkSize);
  p_MoveImmediateValueFromImmediateField(I_ImmBias, D_WorkValueReg);
  b_SubtractWithDNTC(I_RegSource,D_WorkValueReg,D_WorkValueReg);
  s_GetAddressJumpOnInt(D_WorkValueReg,D_WorkSize,I_ImmLtable);
  $RELEASE(D_WorkValueReg);
  $RELEASE(D_WorkSize);
}
