
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V10/interpreter/klb_guard_blt_struct.psl.c
   ----- CREATED   : by f-hataza@icot22, on Mon May 14 16:43:53 1990
   ----- LAST SAVED: by kawai@icot22, on Tue Sep 17 12:14:28 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : INTERPRETER
   ----- ABSTRACT  : $B9=B$BN7O%,!<%IAH9~=R8l(B

  $BAH$_9~$_=R8l$G$O!"0z?t$N7?$N7h$^$C$F$$$k$b$N$,B?$$!#(B
$B!LB-$7;;$NBh0l0z?t$HBhFs0z?t$O@0?t$G$J$1$l$P$J$i$J$$!"Ey!M(B
  $B%3%s%Q%$%i$G$O!"$3$NMM$JAH$_9~$_=R8l$NA0$K!"7?$N%A%'%C%/$H6qBN2=$rBT$D(B
read_wait, load_wait, is_integer $BL?Na$J$I$r=P$9$N$G!"AH$_9~$_=R8l$N(B
$BCf$G$O0z$-?t$N7?$N%A%'%C%/$OI,MW$J$$!#(B
  $B%,!<%I$NAH$_9~$_=R8lCf$K@8$8$?Nc30$OAq1`$KJs9p$5$l$k$3$H$O$J$/!"(B
$B<!8uJd@a$KJ,4t$9$k7A$G=hM}$5$l$k!#(B

1. $B9=B$%A%'%C%/7OAH$_9~$_=R8l(B
#PSL_define kblt_vector_size() 
[#PSL_define kblt_vector_element() $B:o=|(B(1990.02.14)]
#PSL_define kblt_string_length_element_size()
#PSL_define kblt_string_element()
#PSL_define kblt_string_less_than()
#PSL_define kblt_string_not_less_than()
#PSL_define kblt_string_equal()
#PSL_define kblt_string_not_equal()
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
kblt_vector_size A1, A2

       written by f-doumae@icot22      on Tue Jul 25 15:57:20 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |      vector_size      |    A1     |    A2     | 
    +-----------+-----------+-----------+-----------+
<Arguments>
    A1 : $B%l%8%9%?(B($B%Y%/%?$N$_(B)
    A2 : $B%l%8%9%?(B($B=PNO(B)

<Temporally Used Variables>
<Level>
<PreCondition>
    A1$B$O%G%l%U!"%?%$%W%A%'%C%/:Q$_(B
    A2$B$OL$Dj5A(B
<Function>
    A1$B$N;X$9%Y%/%?$N%5%$%:$r(BA2$B$K=q$-9~$_<!L?Na$X(B
<Examples>
<Test>
<Explanation>
    A1 $B$OA0$K(B is_vector $B$G%?%$%W%A%'%C%/$5$l$F$$$k$N$G!"I,$:%Y%/%?$G$"$k!#(B
<ETC>
********************************************************************* PSL **/
#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2

#PSL_define  kblt_vector_size()
{
  @DEBUG {
    b_IfRangeErr(I_ImmR1field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_vector_size","r1_range");
    }
    b_IfRangeErr(I_ImmR2field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_vector_size","r2_range");
    }
    s_IfNotVectors(I_R1field) {
      VPIM_ERROR("kblt_vector_size","illegal_type");
    }
  };
  s_GetSizeVectType(I_R1field,I_R2field); 
  /*  p_SetImmediateTag (INT, _MRB_OFF, _GC_OFF, I_R2field); */
  /*  $B%?%$%W(B INT$B$O!"(Bs_GetSizeVectType$B$NCf$G@_Dj$7$F$$$k(B */
}

/******************************************************************** PSL **
string_length_element_size A1, A2, A3

       written by ymiyazak@icot22      Fri Jan  6 16:30:27 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |string_length          |     A1    |     A2    |
    |       _element_size   |           |           |
    +-----------+-----------+-----------+-----------+
    |    A3     |            don't care             |
    +-----------+-----------+-----------+-----------+
<Arguments>
   A1       $B%l%8%9%?(B
   A2       $B%l%8%9%?(B($B@0?t=PNO(B) 
   A3       $B%l%8%9%?(B($B@0?t=PNO(B)

<Temporally Used Variables>
<Level>
<PreCondition>
    $B!&(BA1 $B$O%G%l%U!"%?%$%W%A%'%C%/:Q$_(B
<Function>
    $B!&%9%H%j%s%0(BA1$B$N%9%H%j%s%0D9$r(BA2$B$K!"MWAG%5%$%:$r(BA3 $B$K(B 
    $B=q$-9~$_!"<!L?Na$X(B
<Examples>
<Test>
<Explanation>
    A1 $B$OA0$K(B is_string $B$G%?%$%W%A%'%C%/$5$l$F$$$k$N$G!"I,$:%9%H%j%s%0$G$"$k!#(B
<ETC>
********************************************************************* PSL **/
#OPF_define I_RegSrcString     _IndirectRegField1
#OPF_define I_RegDstLength     _IndirectRegField2
#OPF_define I_RegDstElmSize    _IndirectRegField3

#OPF_define I_ImmRegSrcString  _ImmediateField1
#OPF_define I_ImmRegDstLength  _ImmediateField2
#OPF_define I_ImmRegDstElmSize _ImmediateField3

#PSL_define kblt_string_length_element_size()
{
  @DEBUG {
    b_IfRangeErr(I_ImmRegSrcString, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_string_length_element_size","r1_range");
    }
    b_IfRangeErr(I_ImmRegDstLength, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_string_length_element_size","r2_range");
    }
    b_IfRangeErr(I_ImmRegDstElmSize, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_string_length_element_size","r3_range");
    }
    s_IfNotStrings(I_RegSrcString) {
	VPIM_ERROR("kblt_string_length_element_size","illegal_type");
    }
  };
  s_GetStringType(I_RegSrcString, I_RegDstLength, I_RegDstElmSize);
       /* $B%?%0$N@_Dj$O!"$3$N%^%/%m$NCf$G9T$o$l$k(B */
}

/******************************************************************** PSL **
string_element A1, A2, A3, A4

       written by ymiyazak@icot22      Fri Jan  6 16:48:46 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |     string_element    |     A1    |     A2    |
    +-----------+-----------+-----------+-----------+
    |    A3     |    A4     |     don't care        |
    +-----------+-----------+-----------+-----------+

<Arguments>
   A1       $B%l%8%9%?(B($B%9%H%j%s%0$X$N%]%$%s%?(B)
   A2       $B%l%8%9%?(B($BMWAG0LCV(B)
   A3       $B%l%8%9%?(B($BMWAG%5%$%:(B)
   A4       $B%l%8%9%?(B($B@0?t=PNO(B) 

<Temporally Used Variables>
<Level>
<PreCondition>
    $B!&(BA1 $B$O%G%l%U%!%l%s%9!"%?%$%W%A%'%C%/:Q$_(B
    $B!&(BA2 $B$O%G%l%U%!%l%s%9!"%?%$%W%A%'%C%/:Q$_(B
    $B!&(BA3 $B$O%G%l%U%!%l%s%9!"%?%$%W%A%'%C%/:Q$_(B
<Function>
    $B!&(BA4 $B$KMWAG%5%$%:(BA3, $B%9%H%j%s%0(BA1 $B$N(B A2 $BHVL\$NMWAG$r=q$-9~$`!#(B
    (A1,A2$B$N%A%'%C%/$O4{$K$5$l$F$$$k(B)
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_RegSrcString     _IndirectRegField1
#OPF_define I_RegSrcElmPos     _IndirectRegField2
#OPF_define I_RegSrcElmSize    _IndirectRegField3
#OPF_define I_RegDstElement    _IndirectRegField4

#OPF_define I_ImmRegSrcString  _ImmediateField1
#OPF_define I_ImmRegSrcElmPos  _ImmediateField2
#OPF_define I_ImmRegSrcElmSize _ImmediateField3
#OPF_define I_ImmRegDstElement _ImmediateField4

#PSL_define kblt_string_element() 
{
  @DEBUG {
    b_IfRangeErr(I_ImmRegSrcString, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_string_element","r1_range");
    }
    b_IfRangeErr(I_ImmRegSrcElmPos, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_string_element","r2_range");
    }
    b_IfRangeErr(I_ImmRegSrcElmSize, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_string_element","r3_range");
    }
    b_IfRangeErr(I_ImmRegDstElement, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_string_element","r4_range");
    }
    s_IfNotStrings(I_RegSrcString) {
      VPIM_ERROR("kblt_string_element","r1_illegal_type");
    }
    s_IfNotINT(I_RegSrcElmPos){
      VPIM_ERROR("kblt_string_element","r2_illegal_type");
    }
    $USE(D_Workreg);                       /* $B%9%H%j%s%0D9(B */
    $USE(D_Workreg2);                       /* $BMWAG%5%$%:(B   */
    s_GetStringType(I_RegSrcString, D_Workreg, D_Workreg2);
    b_IfNotEqual(D_Workreg2,I_RegSrcElmSize){
      VPIM_ERROR("kblt_string_element","r3_illegal_element_size");
    }
    $RELEASE(D_Workreg2);
    $RELEASE(D_Workreg);
  };
  s_GetStringElementPosReg
      (I_RegSrcString, I_RegSrcElmPos, I_RegSrcElmSize, I_RegDstElement);
}

/******************************************************************** PSL **
module A1, A2, A3, Lfail

       written by nakase@icot22      on Tue Oct  9 17:37:25 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |        module         |     A1    |     A2    |
    +-----------+-----------+-----------+-----------+
    |     A3    |         Lfail         | don't care|
    +-----------+-----------+-----------+-----------+

<Arguments>
  A1  $B%l%8%9%?!J%b%8%e!<%k$X$N%]%$%s%?!K(B
  A2  $B%l%8%9%?!J@0?t=PNO!K(B
  A3  $B%l%8%9%?!J@0?t=PNO!K(B
  Lfail $B%U%'%$%k%i%Y%k(B
<Temporally Used Variables>
<Level>
<PreCondition>
    $B!&(BA1 $B$O%G%l%U%!%l%s%9:Q$_(B
<Function>
    $B!&(BA1$B$,(BMOD$B7?$G$J$1$l$P!"%U%'%$%k%i%Y%k(BLfail$B$KJ,4t$9$k!#(B
    $B!&(BA1$B$,(BMOD$B7?$N;~!"(B
      $B!&(BA2$B$K(BA1$B$K;X$5$l$k%b%8%e!<%k$N%5%$%:$r=PNO$9$k!#(B 
      $B!&(BA3$B$K(BA1$B$K;X$5$l$k%b%8%e!<%k$N(BGC$B%a%s%F%J%s%9NN0h$N%5%$%:$r=PNO$9$k!#(B
<Examples>
<Test>
<Explanation>
    $B!&%b%8%e!<%k$N7A<0$K$D$$$F$O(B str_code.psl.c$B$r;2>H!#(B
<ETC>
********************************************************************* PSL **/

#OPF_define I_RegSrcModule    _IndirectRegField1
#OPF_define I_RegModuleSize   _IndirectRegField2
#OPF_define I_RegGCSize       _IndirectRegField3
#OPF_define I_ImmLfail        _ImmediateField4

#PSL_define kblt_module()
{
  s_IfMOD(I_RegSrcModule){
    s_GetModuleSize(I_RegSrcModule, I_RegModuleSize);
    s_GetGCAreaSize(I_RegSrcModule, I_RegGCSize);
    @DEBUG{
      s_IfNotINT(I_RegModuleSize){
        VPIM_ERROR("kblt_module","r2_illegal_type_output");
      }
      s_IfNotINT(I_RegGCSize){
        VPIM_ERROR("kblt_module","r3_illegal_type_output");
      }
    };
  } else {
    s_SetKLB_PC_OPR(I_ImmLfail);
  }
}


/******************************************************************** PSL **
code A1, A2, A3, A4, A5, Lfail

       written by nakase@icot22      on Tue Oct  9 19:17:34 1990


    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |        module         |     A1    |     A2    |
    +-----------+-----------+-----------+-----------+
    |     A3    |     A4    |     A5    | don't care|
    +-----------+-----------+-----------+-----------+
    |         Lfail         |      don't care       |
    +-----------+-----------+-----------+-----------+

<Arguments>
  A1  $B%l%8%9%?!J%3!<%I$X$N%]%$%s%?!K(B
  A2  $B%l%8%9%?!J%b%8%e!<%k$X$N%]%$%s%?!N=PNO!O!K(B
  A3  $B%l%8%9%?!J=R8lL>%"%H%`!N=PNO!O!K(B
  A4  $B%l%8%9%?!J0z?t8D?t!N=PNO!O!K(B
  A5  $B%l%8%9%?!J%b%8%e!<%k@hF,$+$i$N%3!<%I%]%$%s%?$N0LCV!N=PNO!O!K(B
  Lfail $B%U%'%$%k%i%Y%k(B
<Temporally Used Variables>
<Level>
<PreCondition>
    $B!&(BA1 $B$O%G%l%U%!%l%s%9:Q$_(B
<Function>
    $B!&(BA1$B$,(BCOD$B7?$G$J$1$l$P!"%U%'%$%k%i%Y%k(BLfail$B$KJ,4t$9$k!#(B
    $B!&(BA1$B$,(BCOD$B7?$N;~!"(B
      $B!&(BA2$B$K(BA1$B$K;X$5$l$k%3!<%I$N%b%8%e!<%k$X$N%]%$%s%?$r=PNO$9$k!#(B 
      $B!&(BA3$B$K(BA1$B$K;X$5$l$k%3!<%I$N=R8lL>%"%H%`$r=PNO$9$k!#(B 
      $B!&(BA4$B$K(BA1$B$K;X$5$l$k%3!<%I$N0z?t8D?t$r=PNO$9$k!#(B 
      $B!&(BA5$B$K(BA1$B$K;X$5$l$k%3!<%I$N%b%8%e!<%k!&%*%U%;%C%H$r=PNO$9$k!#(B 
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_RegSrcCode      _IndirectRegField1
#OPF_define I_RegModPtr       _IndirectRegField2
#OPF_define I_RegPredName     _IndirectRegField3
#OPF_define I_RegArity        _IndirectRegField4
#OPF_define I_RegOffset       _IndirectRegField5
#OPF_define I_ImmLfail        _ImmediateField6

#PSL_define kblt_code()
{
  s_IfCOD(I_RegSrcCode){
    s_GetModuleTopFromCode(I_RegSrcCode, I_RegModPtr); /* $BCf$G(Btype$B@_Dj:Q$_(B */
    s_GetPredNameFromCode(I_RegSrcCode, I_RegPredName);
    s_GetPredArityFromCode(I_RegSrcCode, I_RegArity);
    s_GetPredOffset(I_RegSrcCode, I_RegModPtr, I_RegOffset);
    b_SetImmTypeMRBoff(INT, I_RegOffset);
  } else {
    s_SetKLB_PC_OPR(I_ImmLfail);
  }
}

/******************************************************************** PSL **
kblt_string_less_than A1, A2, Lfail

       written by kawai@icot22      on Wed Aug  7 14:36:33 1991

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |   string_less_than    |     A1    |     A2    |
    +-----------+-----------+-----------+-----------+
    |         Lfail         |      don't care       |
    +-----------+-----------+-----------+-----------+

<Arguments>
  A1  $B%l%8%9%?!J%9%H%j%s%0$X$N%]%$%s%?!K(B
  A2  $B%l%8%9%?!J%9%H%j%s%0$X$N%]%$%s%?!K(B
  Lfail $B%U%'%$%k%i%Y%k(B
<Temporally Used Variables>
<Level>
<PreCondition>
    $B!&(BA1$B!"(BA2 $B$O%G%l%U%!%l%s%9!"%?%$%W%A%'%C%/:Q$_(B
<Function>
    $B!&(BA1$B$K;X$5$l$k%9%H%j%s%0$,!"(BA2$B$K;X$5$l$k%9%H%j%s%0$h$j>.$5$$$+H]$+$r(B
        $BH=Dj$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define  D_WorkStrCompareResult  XXX

#OPF_define I_ArgString1      _IndirectRegField1
#OPF_define I_ArgString2      _IndirectRegField2
#OPF_define I_ImmLfail        _ImmediateField3

#PSL_define kblt_string_less_than()
{
  @DEBUG{
    s_IfNotStrings(I_ArgString1)
      { /* $BBh(B0$B0z?t$,%9%H%j%s%0$G$J$+$C$?$i(B */
	VPIM_ERROR("kblt_string_less_than","Illegal type of Arg0");
      }
    s_IfNotStrings(I_ArgString2)
      { /* $BBh(B1$B0z?t$,%9%H%j%s%0$G$J$+$C$?$i(B */
	VPIM_ERROR("kblt_string_less_than","Illegal type of Arg1");
      }
  };

  $USE(D_WorkStrCompareResult);
  $CALL( f_StringLessThan_Sub(I_ArgString1, I_ArgString2,
			                    D_WorkStrCompareResult) );
  b_IfEqualImm(D_WorkStrCompareResult, _STRING_COMPARE_RESULT_FAIL)
    {
      s_SetKLB_PC_OPR(I_ImmLfail);
    }
  $RELEASE(D_WorkStrCompareResult);
}

/******************************************************************** PSL **
kblt_string_not_less_than A1, A2, Lfail

       written by kawai@icot22      on Wed Aug  7 14:36:33 1991

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    | string_not_less_than  |     A1    |     A2    |
    +-----------+-----------+-----------+-----------+
    |         Lfail         |      don't care       |
    +-----------+-----------+-----------+-----------+

<Arguments>
  A1  $B%l%8%9%?!J%9%H%j%s%0$X$N%]%$%s%?!K(B
  A2  $B%l%8%9%?!J%9%H%j%s%0$X$N%]%$%s%?!K(B
  Lfail $B%U%'%$%k%i%Y%k(B
<Temporally Used Variables>
<Level>
<PreCondition>
    $B!&(BA1$B!"(BA2 $B$O%G%l%U%!%l%s%9!"%?%$%W%A%'%C%/:Q$_(B
<Function>
    $B!&(BA1$B$K;X$5$l$k%9%H%j%s%0$,!"(BA2$B$K;X$5$l$k%9%H%j%s%0$h$j>.$5$/$J$$$+H]$+$r(B
        $BH=Dj$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_ArgString1      _IndirectRegField1
#OPF_define I_ArgString2      _IndirectRegField2
#OPF_define I_ImmLfail        _ImmediateField3

#PSL_define kblt_string_not_less_than()
{
  @DEBUG{
    s_IfNotStrings(I_ArgString1)
      { /* $BBh(B0$B0z?t$,%9%H%j%s%0$G$J$+$C$?$i(B */
	VPIM_ERROR("kblt_string_not_less_than","Illegal type of Arg0");
      }
    s_IfNotStrings(I_ArgString2)
      { /* $BBh(B1$B0z?t$,%9%H%j%s%0$G$J$+$C$?$i(B */
	VPIM_ERROR("kblt_string_not_less_than","Illegal type of Arg1");
      }
  };

  $USE(D_WorkStrCompareResult);
  $CALL( f_StringLessThan_Sub(I_ArgString1, I_ArgString2,
				      D_WorkStrCompareResult) );
  b_IfEqualImm(D_WorkStrCompareResult, _STRING_COMPARE_RESULT_SUCCESS)
    {
      s_SetKLB_PC_OPR(I_ImmLfail);
    }
  $RELEASE(D_WorkStrCompareResult);
}

/******************************************************************** PSL **
kblt_string_equal A1, A2, Lfail

       written by kawai@icot22      on Wed Aug  7 14:36:33 1991

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |     string_equal      |     A1    |     A2    |
    +-----------+-----------+-----------+-----------+
    |         Lfail         |      don't care       |
    +-----------+-----------+-----------+-----------+

<Arguments>
  A1  $B%l%8%9%?!J%9%H%j%s%0$X$N%]%$%s%?!K(B
  A2  $B%l%8%9%?!J%9%H%j%s%0$X$N%]%$%s%?!K(B
  Lfail $B%U%'%$%k%i%Y%k(B
<Temporally Used Variables>
<Level>
<PreCondition>
    $B!&(BA1$B!"(BA2 $B$O%G%l%U%!%l%s%9!"%?%$%W%A%'%C%/:Q$_(B
<Function>
    $B!&(BA1$B$K;X$5$l$k%9%H%j%s%0$H!"(BA2$B$K;X$5$l$k%9%H%j%s%0$,Ey$7$$$+H]$+$r(B
        $BH=Dj$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_ArgString1      _IndirectRegField1
#OPF_define I_ArgString2      _IndirectRegField2
#OPF_define I_ImmLfail        _ImmediateField3

#PSL_define kblt_string_equal()
{
  @DEBUG{
    s_IfNotStrings(I_ArgString1)
      { /* $BBh(B0$B0z?t$,%9%H%j%s%0$G$J$+$C$?$i(B */
	VPIM_ERROR("kblt_string_equal","Illegal type of Arg0");
      }
    s_IfNotStrings(I_ArgString2)
      { /* $BBh(B1$B0z?t$,%9%H%j%s%0$G$J$+$C$?$i(B */
	VPIM_ERROR("kblt_string_equal","Illegal type of Arg1");
      }
  };

  f_IfStringNotEqual(I_ArgString1, I_ArgString2)
    {
      s_SetKLB_PC_OPR(I_ImmLfail);
    }
}

/******************************************************************** PSL **
kblt_string_not_equal A1, A2, Lfail

       written by kawai@icot22      on Wed Aug  7 14:36:33 1991

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |   string_not_equal    |     A1    |     A2    |
    +-----------+-----------+-----------+-----------+
    |         Lfail         |      don't care       |
    +-----------+-----------+-----------+-----------+

<Arguments>
  A1  $B%l%8%9%?!J%9%H%j%s%0$X$N%]%$%s%?!K(B
  A2  $B%l%8%9%?!J%9%H%j%s%0$X$N%]%$%s%?!K(B
  Lfail $B%U%'%$%k%i%Y%k(B
<Temporally Used Variables>
<Level>
<PreCondition>
    $B!&(BA1$B!"(BA2 $B$O%G%l%U%!%l%s%9!"%?%$%W%A%'%C%/:Q$_(B
<Function>
    $B!&(BA1$B$K;X$5$l$k%9%H%j%s%0$H!"(BA2$B$K;X$5$l$k%9%H%j%s%0$,Ey$7$/$J$$$+H]$+$r(B
        $BH=Dj$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_ArgString1      _IndirectRegField1
#OPF_define I_ArgString2      _IndirectRegField2
#OPF_define I_ImmLfail        _ImmediateField3

#PSL_define kblt_string_not_equal()
{
  @DEBUG{
    s_IfNotStrings(I_ArgString1)
      { /* $BBh(B0$B0z?t$,%9%H%j%s%0$G$J$+$C$?$i(B */
	VPIM_ERROR("kblt_string_not_equal","Illegal type of Arg0");
      }
    s_IfNotStrings(I_ArgString2)
      { /* $BBh(B1$B0z?t$,%9%H%j%s%0$G$J$+$C$?$i(B */
	VPIM_ERROR("kblt_string_not_equal","Illegal type of Arg1");
      }
  };

  f_IfStringEqual(I_ArgString1, I_ArgString2)
    {
      s_SetKLB_PC_OPR(I_ImmLfail);
    }
}
