
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V10/interpreter/klb_guard_blt_floating_point.psl.c
   ----- CREATED   : by yamamoto@icot22, on Sun Jun 23 18:40:36 1991
   ----- LAST SAVED: by yamamoto@icot22, on Wed Oct  2 11:00:06 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */
/******************************************************************** PSL **
$B%,!<%IIt$NIbF0>.?tE@1i;;AH9~=R8l(B
       written by yamamoto@icot22      on Wed Oct  2 10:49:20 1991
<PreCondition>
  $BF~NO0z?t$OIbF0>.?tE@%G!<%?$G6qBN2=:Q$_(B
<Arguments>
  $B%G!<%?$O#F#P#U%l%8%9%?>e$K$"$k!#(B
  $B1i;;7k2L$NL58BBg!"Hs?t$J$I$rAH9~$N<:GT$H$O$7$J$$!#(B
  $BHs?t$J$I$r4^$a$?7k2L$N%A%'%C%/$O(B floating_point/2 $B$rMQ$$$k!#(B
  <Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
/******************************************************************** PSL **
$B;;=Q1i;;AH9~=R8l(B
       written by yamamoto@icot22      on Wed Oct  2 10:49:20 1991

kblt_floating_point_add(freg,freg,freg)
kblt_floating_point_subtract(freg,freg,freg)
kblt_floating_point_multiply(freg,freg,freg)
kblt_floating_point_divide(freg,freg,freg)

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_R3field    _IndirectRegField3

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2
#OPF_define I_ImmR3field _ImmediateField3

#PSL_define kblt_floating_point_add(){
  @DEBUG{
    b_IfFPURegRangeErr(I_ImmR1field){
      OUT_OF_SPEC("kblt_floating_point_add","r1_range");
    }
    b_IfFPURegRangeErr(I_ImmR2field){
      OUT_OF_SPEC("kblt_floating_point_add","r2_range");
    }
    b_IfFPURegRangeErr(I_ImmR3field){
      OUT_OF_SPEC("kblt_floating_point_add","r3_range");
    }
  };
  p_FLT_Add(I_R1field, I_R2field, I_R3field);
}

#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_R3field    _IndirectRegField3

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2
#OPF_define I_ImmR3field _ImmediateField3

#PSL_define kblt_floating_point_subtract(){
  @DEBUG{
    b_IfFPURegRangeErr(I_ImmR1field){
      OUT_OF_SPEC("kblt_floating_point_subtract","r1_range");
    }
    b_IfFPURegRangeErr(I_ImmR2field){
      OUT_OF_SPEC("kblt_floating_point_subtract","r2_range");
    }
    b_IfFPURegRangeErr(I_ImmR3field){
      OUT_OF_SPEC("kblt_floating_point_subtract","r3_range");
    }
  };
  p_FLT_Subtract(I_R1field, I_R2field, I_R3field);
}

#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_R3field    _IndirectRegField3

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2
#OPF_define I_ImmR3field _ImmediateField3

#PSL_define kblt_floating_point_multiply(){
  @DEBUG{
    b_IfFPURegRangeErr(I_ImmR1field){
      OUT_OF_SPEC("kblt_floating_point_multiply","r1_range");
    }
    b_IfFPURegRangeErr(I_ImmR2field){
      OUT_OF_SPEC("kblt_floating_point_multiply","r2_range");
    }
    b_IfFPURegRangeErr(I_ImmR3field){
      OUT_OF_SPEC("kblt_floating_point_multiply","r3_range");
    }
  };
  p_FLT_Multiply(I_R1field, I_R2field, I_R3field);
}

#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_R3field    _IndirectRegField3

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2
#OPF_define I_ImmR3field _ImmediateField3

#PSL_define kblt_floating_point_divide(){
  @DEBUG{
    b_IfFPURegRangeErr(I_ImmR1field){
      OUT_OF_SPEC("kblt_floating_point_divide","r1_range");
    }
    b_IfFPURegRangeErr(I_ImmR2field){
      OUT_OF_SPEC("kblt_floating_point_divide","r2_range");
    }
    b_IfFPURegRangeErr(I_ImmR3field){
      OUT_OF_SPEC("kblt_floating_point_divide","r3_range");
    }
  };
  p_FLT_Divide(I_R1field, I_R2field, I_R3field);
}

/******************************************************************** PSL **
$BJQ491i;;AH9~=R8l(B
       written by yamamoto@icot22      on Wed Oct  2 10:51:45 1991

kblt_floating_point_to_integer(freg,reg,lab)
kblt_integer_to_floating_point(reg,freg)

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
$B@0?t$HIbF0>.?tE@?t$N4V$NJQ49$r9T$J$&!#(B
kblt_floating_point_to_integer $B$O@0?t%*!<%P%U%m!<$r5/$3$92DG=@-$,$"$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_ImmLfail   _ImmediateField3

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2

#PSL_define kblt_floating_point_to_integer(){
  @DEBUG{
    b_IfFPURegRangeErr(I_ImmR1field){
      OUT_OF_SPEC("kblt_floating_point_to_integer","r1_range");
    }
    b_IfRangeErr(I_ImmR2field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_floating_point_to_integer","r2_range");
    }
    s_IfNotFLT(I_R1field){
      VPIM_ERROR("kblt_floating_point_to_integer","invalid_type");
    }
  };
  p_FloatingPointToInteger(I_R1field, I_R2field);
  p_IfOverflow(){
      s_SetKLB_PC_OPR(I_ImmLfail);
  }
}

#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2

#PSL_define kblt_integer_to_floating_point(){
  @DEBUG{
    b_IfRangeErr(I_ImmR1field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_to_floating_point","r1_range");
    }
    b_IfFPURegRangeErr(I_ImmR2field){
      OUT_OF_SPEC("kblt_integer_to_floating_point","r2_range");
    }
    s_IfNotINT(I_R1field){
      VPIM_ERROR("kblt_integer_to_floating_point","invalid_type");
    }
  };
  p_IntegerToFloatingPoint(I_R1field, I_R2field);
}

/******************************************************************** PSL **
$BHf3S1i;;(B/$B>r7oJ,4tAH9~=R8l(B
       written by yamamoto@icot22      on Wed Oct  2 10:56:27 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/


#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_ImmLfail   _ImmediateField3

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2

#PSL_define kblt_floating_point_equal() {

  @DEBUG{
    b_IfFPURegRangeErr(I_ImmR1field){
      OUT_OF_SPEC("kblt_floating_point_equal","r1_range");
    }
    b_IfFPURegRangeErr(I_ImmR2field){
      OUT_OF_SPEC("kblt_floating_point_equal","r2_range");
    }
  };
  p_FLT_Compare(I_R1field, I_R2field);
  p_If_FLT_NE(){
      s_SetKLB_PC_OPR(I_ImmLfail);
  }
}

#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_ImmLfail   _ImmediateField3

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2

#PSL_define kblt_floating_point_not_equal() {
  @DEBUG{
    b_IfFPURegRangeErr(I_ImmR1field){
      OUT_OF_SPEC("kblt_floating_point_not_equal","r1_range");
    }
    b_IfFPURegRangeErr(I_ImmR2field){
      OUT_OF_SPEC("kblt_floating_point_not_equal","r2_range");
    }
  };
  p_FLT_Compare(I_R1field, I_R2field);
  p_If_FLT_EQ(){
      s_SetKLB_PC_OPR(I_ImmLfail);
  }
}

#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_ImmLfail   _ImmediateField3

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2
#PSL_define kblt_floating_point_less_than() {
  @DEBUG{
    b_IfFPURegRangeErr(I_ImmR1field){
      OUT_OF_SPEC("kblt_floating_point_less_than","r1_range");
    }
    b_IfFPURegRangeErr(I_ImmR2field){
      OUT_OF_SPEC("kblt_floating_point_less_than","r2_range");
    }
  };
  p_FLT_Compare(I_R1field, I_R2field);
  p_If_FLT_GE(){
      s_SetKLB_PC_OPR(I_ImmLfail);
  }
}

#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_ImmLfail   _ImmediateField3

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2
#PSL_define kblt_floating_point_not_less_than() {
  @DEBUG{
    b_IfFPURegRangeErr(I_ImmR1field){
      OUT_OF_SPEC("kblt_floating_point_not_less_than","r1_range");
    }
    b_IfFPURegRangeErr(I_ImmR2field){
      OUT_OF_SPEC("kblt_floating_point_not_less_than","r2_range");
    }
  };
  p_FLT_Compare(I_R1field, I_R2field);
  p_If_FLT_LT(){
      s_SetKLB_PC_OPR(I_ImmLfail);
  }
}

/******************************************************************** PSL **
IEEE$BIbF0>.?tE@%/%i%9%A%'%C%/(B
       written by yamamoto@icot22      on Wed Oct  2 10:57:39 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
$BL58BBg!"Hs?t$J$I$N%A%'%C%/$r9T$J$&!#(B
<Examples>
<Test>
<Explanation>
<ETC>
$B%/%i%9$rI=$9Dj?t$NDj5A$O(B str_floating_point.psl.c
********************************************************************* PSL **/

#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2

#PSL_define kblt_floating_point(){
  @DEBUG{
    b_IfFPURegRangeErr(I_ImmR1field){
      OUT_OF_SPEC("kblt_floating_point","r1_range");
    }
    b_IfRangeErr(I_ImmR2field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_floating_point","r2_range");
    }
  };
  s_GetTypeOfFloatingPoint(I_R1field, I_R2field);
} 



