
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/interpreter/klb_guard_blt_bignum.psl.c
   ----- CREATED   : by yamamoto@icot22, on Fri Nov  8 16:04:26 1991
   ----- LAST SAVED: by yamamoto@icot22, on Tue Jul 14 16:27:34 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */
/******************************************************************** PSL **
  $BB?G\D9@0?t(B(BIGNUM)$B1i;;(B

$B?t<0=hM}$J$I$NBg$-$J@0?t$r07$&%"%W%j%1!<%7%g%sMQ$K(B
PIMOS$B$,Ds6!$9$kB?G\D9@0?t1i;;%i%$%V%i%j$r9bB.2=$9$k$?$a!"(B
$BB?G\D9@0?t1i;;$N4pK\1i;;$rAH9~=R8l2=$7$?!#(B

$BHf3S$O$9$Y$F%,!<%IAH9~=R8l$G$"$k!#(B

$B=hM}7O$N%l%Y%k$G$O!"(B
$B%,!<%IAH$_9~$_=R8l$K$*$1$kF~NO$N%?%$%W%A%'%C%/$O9T$J$o$J$$!#(B
BIGNUM $B$,F~$k$Y$-0z?t$N%A%'%C%/$O!"(B
32$B%S%C%H%9%H%j%s%0$N%?%$%W%A%'%C%/L?Na$,%3%s%Q%$%i$K$h$C$FJL$K=P$5$l$k!#(B
$B$3$N%A%'%C%/$GITEv%?%$%W$N>l9g$O<:GT!#(B

kblt_bignum_less_than A1, A2, Lfail
kblt_bignum_not_less_than A1, A2, Lfail

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |bignum_(not_)less_than |    A1     |    A2     | 
    +-----------+-----------+-----------+-----------+
    |	      Lfail	    |	   don't care	    |
    +-----------+-----------+-----------+-----------+

<Arguments>
    A1 : $B%l%8%9%?(B(32$B%S%C%H%9%H%j%s%0$N$_!"%G%l%U:Q$_(B)
    A2 : $B%l%8%9%?(B(32$B%S%C%H%9%H%j%s%0$N$_!"%G%l%U:Q$_(B)
    Lfail : $B%U%'%$%k%i%Y%k(B

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>

BIGNUM$BF1;N$NBg>.$rHf3S$9$k!#(B

bignum_less_than
    $B!&(BA1$B$,(BA2$B$h$j>.$5$1$l$P!"<!L?Na$X(B
    $B!&$=$l0J30$O!"<!8uJd%"%I%l%9(BLfail$B$XJ,4t(B

bignum_not_less_than
    $B!&(BA1$B$,(BA2$B$h$j>.$5$/$J$1$l$P!"<!L?Na$X(B
    $B!&$=$l0J30$O!"<!8uJd%"%I%l%9(BLfail$B$XJ,4t(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_ImmLfail   _ImmediateField3

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2

#PSL_define kblt_bignum_less_than() {

  @DEBUG{
    b_IfRangeErr(I_ImmR1field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_bignum_less_than","r1_range");
    }
    b_IfRangeErr(I_ImmR2field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_bignum_less_than","r2_range");
    }
    s_IfNotStrings(I_R1field) {VPIM_ERROR("kblt_bignum_less_than",
					  "invalid_type");}
    s_IfNotStrings(I_R2field) {VPIM_ERROR("kblt_bignum_less_than",
					  "invalid_type");}
  };
  s_IfBignumNotLessThan(I_R1field, I_R2field){
    s_SetKLB_PC_OPR(I_ImmLfail);
  }
}

#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_ImmLfail   _ImmediateField3

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2

#PSL_define kblt_bignum_not_less_than() {

  @DEBUG{
    b_IfRangeErr(I_ImmR1field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_bignum_not_less_than","r1_range");
    }
    b_IfRangeErr(I_ImmR2field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_bignum_not_less_than","r2_range");
    }
    s_IfNotStrings(I_R1field) {VPIM_ERROR("kblt_bignum_not_less_than",
					  "invalid_type");}
    s_IfNotStrings(I_R2field) {VPIM_ERROR("kblt_bignum_not_less_than",
					  "invalid_type");}
  };
  s_IfBignumLessThan(I_R1field, I_R2field){
    s_SetKLB_PC_OPR(I_ImmLfail);
  }
}
