
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V05/interpreter/klb_guard_blt_arith.psl.c
   ----- CREATED   : by f-hataza@icot22, on Mon May 14 13:50:40 1990
   ----- LAST SAVED: by yamamoto@icot22, on Wed Aug 22 13:49:17 1990
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : INTERPRETER
   ----- ABSTRACT  : $BHf3S!&1i;;7O%,!<%IAH9~=R8l(B

  $BAH$_9~$_=R8l$G$O!"0z?t$N7?$N7h$^$C$F$$$k$b$N$,B?$$!#(B
$B!LB-$7;;$NBh0l0z?t$HBhFs0z?t$O@0?t$G$J$1$l$P$J$i$J$$!"Ey!M(B
  $B%3%s%Q%$%i$G$O!"$3$NMM$JAH$_9~$_=R8l$NA0$K!"7?$N%A%'%C%/$H6qBN2=$rBT$D(B
read_wait, load_wait, is_integer $BL?Na$J$I$r=P$9$N$G!"AH$_9~$_=R8l$N(B
$BCf$G$O0z$-?t$N7?$N%A%'%C%/$OI,MW$J$$!#(B
  $B%,!<%I$NAH$_9~$_=R8lCf$K@8$8$?Nc30$OAq1`$KJs9p$5$l$k$3$H$O$J$/!"(B
$B<!8uJd@a$KJ,4t$9$k7A$G=hM}$5$l$k!#(B

1. $B@0?tHf3S7OAH$_9~$_=R8l(B
#PSL_define kblt_integer_equal() 
#PSL_define kblt_integer_not_equal() 
#PSL_define kblt_integer_less_than() 
#PSL_define kblt_integer_not_less_than() 

2. $B@0?tO@M}1i;;7OAH$_9~$_=R8l(B
#PSL_define kblt_integer_and() 
#PSL_define kblt_integer_or() 
#PSL_define kblt_integer_exclusive_or() 
#PSL_define kblt_integer_shift_left() 
#PSL_define kblt_integer_shift_right() 
[#PSL_define kblt_integer_complement() $B:o=|(B(1990.02.28)]

3. $B@0?t;;=Q1i;;7OAH$_9~$_=R8l(B
#PSL_define kblt_integer_add() 
#PSL_define kblt_integer_subtract() 
#PSL_define kblt_integer_multiply() 
#PSL_define kblt_integer_divide()
#PSL_define kblt_integer_modulo() 
[#PSL_define kblt_integer_minus() $B:o=|(B(1990.02.28)]
#PSL_define kblt_integer_increment() 
#PSL_define kblt_integer_decrement() 

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
1. $B@0?tHf3S7OAH$_9~$_=R8l(B

kblt_integer_equal A1, A2, Lfail

       written by f-doumae@icot22      on Tue Jul 25 14:46:17 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |    integer_equal      |    A1     |    A2     | 
    +-----------+-----------+-----------+-----------+
    |	      Lfail	    |	   don't care	    |
    +-----------+-----------+-----------+-----------+

<Arguments>
    A1 : $B%l%8%9%?(B($B@0?t$N$_(B)
    A2 : $B%l%8%9%?(B($B@0?t$N$_(B)
    Lfail : $B%U%'%$%k%i%Y%k(B

<Temporally Used Variables>
<Level>
<PreCondition>
    $B!&(BA1, A2$B$O%G%l%U:Q$_(B
    $B!&(BA1, A2$B$O@0?t$N$_(B
<Function>
    A1$B$H(BA2$B$,(B
          $B!&Ey$7$1$l$P(B, $B<!L?Na$X(B
          $B!&$=$l0J30$O(B, Lfail$B$XJ,4t(B
<Examples>
[KL1]
  p(X,Y):-equal(X,Y)|true.

[KL1/B]
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_ImmLfail   _ImmediateField3

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2

#PSL_define  kblt_integer_equal()
{
  @DEBUG{
    b_IfRangeErr(I_ImmR1field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_equal","r1_range");
    }
    b_IfRangeErr(I_ImmR2field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_equal","r2_range");
    }
    s_IfNotINT(I_R1field) {VPIM_ERROR("kblt_integer_equal","invalid_type");}
    s_IfNotINT(I_R2field) {VPIM_ERROR("kblt_integer_equal","invalid_type");} 
  };
  p_Compare(I_R1field, I_R2field);
  p_IfNE(){
      s_SetKLB_PC_OPR(I_ImmLfail);
  }
}

/******************************************************************** PSL **
kblt_integer_not_equal A1, A2, Lfail

       written by f-doumae@icot22      on Tue Jul 25 15:20:57 1989
    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |    integer_not_equal  |    A1     |    A2     | 
    +-----------+-----------+-----------+-----------+
    |	      Lfail	    |	  don't care	    |
    +-----------+-----------+-----------+-----------+
<Arguments>
    A1    $BHf3SBP>](B1 ($B%l%8%9%?(B)
    A2    $BHf3SBP>](B2 ($B%l%8%9%?(B)

<Temporally Used Variables>
<Level>
<PreCondition>
    $B!&(BA1$B!"(BA2$B$O%G%l%U:Q$_(B
    $B!&(BA1$B!"(BA2$B$O@0?t$N$_(B
<Function>
    A1$B$H(BA2$B$,(B
          $B!&Ey$7$/$J$1$l$P!"<!L?Na$X(B
          $B!&$=$l0J30$O!"<!8uJd%"%I%l%9(BLfail$B$XJ,4t(B
<Examples>
[KL1]
  p(X,Y):-not_equal(X,Y)|true.
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_ImmLfail   _ImmediateField3

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2

#PSL_define  kblt_integer_not_equal()
{
  @DEBUG{
    b_IfRangeErr(I_ImmR1field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_not_equal","r1_range");
    }
    b_IfRangeErr(I_ImmR2field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_not_equal","r2_range");
    }
    s_IfNotINT(I_R1field) {VPIM_ERROR("integer_not_equal","invalid_type");}
    s_IfNotINT(I_R2field) {VPIM_ERROR("integer_not_equal","invalid_type");} 
  };
  p_Compare(I_R1field, I_R2field);
  p_IfEQ(){
      s_SetKLB_PC_OPR(I_ImmLfail);
  }
}

/******************************************************************** PSL **
kblt_integer_less_than A1, A2, Lfail

       written by f-doumae@icot22      on Tue Jul 25 15:23:26 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |  integer_less_than    |    A1     |    A2     | 
    +-----------+-----------+-----------+-----------+
    |	      Lfail	    |	   don't care	    |
    +-----------+-----------+-----------+-----------+
<Arguments>
    A1 : $B%l%8%9%?(B($B@0?t$N$_(B)
    A2 : $B%l%8%9%?(B($B@0?t$N$_(B)
    Lfail : $B%U%'%$%k%i%Y%k(B

<Temporally Used Variables>
<Level>
<PreCondition>
    $B!&(BA1$B!"(BA2$B$O%G%l%U:Q$_(B
    $B!&(BA1$B!"(BA2$B$O@0?t$N$_(B
<Function>
    $B!&(BA1$B$,(BA2$B$h$j>.$5$1$l$P!"<!L?Na$X(B
    $B!&$=$l0J30$O!"<!8uJd%"%I%l%9(BLfail$B$XJ,4t(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_ImmLfail   _ImmediateField3

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2

#PSL_define  kblt_integer_less_than()
{
  @DEBUG{
    b_IfRangeErr(I_ImmR1field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_less_than","r1_range");
    }
    b_IfRangeErr(I_ImmR2field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_less_than","r2_range");
    }
    s_IfNotINT(I_R1field) {VPIM_ERROR("integer_less_than","invalid_type");}
    s_IfNotINT(I_R2field) {VPIM_ERROR("integer_less_than","invalid_type");} 
  };
  p_Compare(I_R1field, I_R2field);
  p_IfGE(){
      s_SetKLB_PC_OPR(I_ImmLfail);
  }
}

/******************************************************************** PSL **
kblt_integer_not_less_than A1, A2, Lfail

       written by f-doumae@icot22      on Tue Jul 25 15:26:00 1989

    0             1             2           3           4
    +-------------+-------------+-----------+-----------+
    |  integer_not_less_than    |    A1     |    A2     | 
    +-------------+-------------+-----------+-----------+
    |	      Lfail	        |	don't care	|
    +-------------+-------------+-----------+-----------+
<Arguments>
    A1 : $B%l%8%9%?(B($B@0?t$N$_(B)
    A2 : $B%l%8%9%?(B($B@0?t$N$_(B)
    Lfail : $B%U%'%$%k%i%Y%k(B

<Temporally Used Variables>
<Level>
<PreCondition>
    $B!&(BA1$B!"(BA2$B$O%G%l%U:Q$_(B
    $B!&(BA1$B!"(BA2$B$O@0?t$N$_(B
<Function>
    $B!&(BA1$B$,(BA2$B$h$j>.$5$/$J$1$l$P!"<!L?Na$X(B
    $B!&$=$l0J30$O!"<!8uJd%"%I%l%9(BLfail$B$XJ,4t(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_ImmLfail   _ImmediateField3

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2

#PSL_define  kblt_integer_not_less_than()
{
  @DEBUG{
    b_IfRangeErr(I_ImmR1field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_not_less_than","r1_range");
    }
    b_IfRangeErr(I_ImmR2field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_not_less_than","r2_range");
    }
    s_IfNotINT(I_R1field) {VPIM_ERROR("integer_not_less_than","invalid_type");}
    s_IfNotINT(I_R2field) {VPIM_ERROR("integer_not_less_than","invalid_type");} 
  };
  p_Compare(I_R1field, I_R2field);
  p_IfLT(){
      s_SetKLB_PC_OPR(I_ImmLfail);
  }
}

/******************************************************************** PSL **
kblt_integer_and A1, A2, A3

       written by f-doumae@icot22      on Tue Jul 25 15:49:51 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |     integer_and       |    A1     |    A2     | 
    +-----------+-----------+-----------+-----------+
    |	   A3   |            don't care             |
    +-----------+-----------+-----------+-----------+
<Arguments>
    A1 : $B%l%8%9%?(B($B@0?t$N$_(B)
    A2 : $B%l%8%9%?(B($B@0?t$N$_(B)
    A3 : $B%l%8%9%?(B($B=PNO(B)

<Temporally Used Variables>
<Level>
<PreCondition>
    $B!&(BA1$B!"(BA2$B$O%G%l%U:Q$_(B
    $B!&(BA1$B!"(BA2$B$O@0?t$N$_(B
    $B!&(BA3$B$OL$Dj5A(B
<Function>
    A3$B$K(BA1$B$H(BA2$B$NO@M}@Q$r=q$-9~$_!"<!L?Na$X(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_R3field    _IndirectRegField3

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2
#OPF_define I_ImmR3field _ImmediateField3

#PSL_define  kblt_integer_and()
{
  @DEBUG{
    b_IfRangeErr(I_ImmR1field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_and","r1_range");
    }
    b_IfRangeErr(I_ImmR2field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_and","r2_range");
    }
    b_IfRangeErr(I_ImmR3field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_and","r3_range");
    }
    s_IfNotINT(I_R1field) {VPIM_ERROR("integer_and","invalid_type");}
    s_IfNotINT(I_R2field) {VPIM_ERROR("integer_and","invalid_type");} 
  };
  b_BitwiseAndWithTag(I_R1field,I_R2field,I_R3field);
}

/******************************************************************** PSL **
kblt_integer_or A1, A2, A3

       written by f-doumae@icot22      on Tue Jul 25 15:49:51 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |     integer_or        |    A1     |    A2     | 
    +-----------+-----------+-----------+-----------+
    |	   A3   |            don't care             |
    +-----------+-----------+-----------+-----------+
<Arguments>
    A1 : $B%l%8%9%?(B($B@0?t$N$_(B)
    A2 : $B%l%8%9%?(B($B@0?t$N$_(B)
    A3 : $B%l%8%9%?(B($B=PNO(B)

<Temporally Used Variables>
<Level>
<PreCondition>
    $B!&(BA1$B!"(BA2$B$O%G%l%U:Q$_(B
    $B!&(BA1$B!"(BA2$B$O@0?t$N$_(B
    $B!&(BA3$B$OL$Dj5A(B
<Function>
    A3$B$K(BA1$B$H(BA2$B$NO@M}OB$r=q$-9~$_!"<!L?Na$X(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_R3field    _IndirectRegField3

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2
#OPF_define I_ImmR3field _ImmediateField3

#PSL_define  kblt_integer_or()
{
  @DEBUG{
    b_IfRangeErr(I_ImmR1field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_or","r1_range");
    }
    b_IfRangeErr(I_ImmR2field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_or","r2_range");
    }
    b_IfRangeErr(I_ImmR3field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_or","r3_range");
    }
    s_IfNotINT(I_R1field) {VPIM_ERROR("integer_or","invalid_type");}
    s_IfNotINT(I_R2field) {VPIM_ERROR("integer_or","invalid_type");} 
  };
  b_BitwiseOrWithTag(I_R1field,I_R2field,I_R3field);
}

/******************************************************************** PSL **
kblt_integer_exclusive_or A1, A2, A3

       written by f-doumae@icot22      on Tue Jul 25 15:49:51 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |  integer_exclusive_or |    A1    |    A2     | 
    +-----------+-----------+-----------+-----------+
    |	   A3   |            don't care             |
    +-----------+-----------+-----------+-----------+
<Arguments>
    A1 : $B%l%8%9%?(B($B@0?t$N$_(B)
    A2 : $B%l%8%9%?(B($B@0?t$N$_(B)
    A3 : $B%l%8%9%?(B($B=PNO(B)

<Temporally Used Variables>
<Level>
<PreCondition>
    $B!&(BA1$B!"(BA2$B$O%G%l%U:Q$_(B
    $B!&(BA1$B!"(BA2$B$O@0?t$N$_(B
    $B!&(BA3$B$OL$Dj5A(B
<Function>
    A3$B$K(BA1$B$H(BA2$B$NGSB>E*O@M}OB$r=q$-9~$_!"<!L?Na$X(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_R3field    _IndirectRegField3

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2
#OPF_define I_ImmR3field _ImmediateField3

#PSL_define  kblt_integer_exclusive_or()
{
  @DEBUG{
    b_IfRangeErr(I_ImmR1field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_exclusive_or","r1_range");
    }
    b_IfRangeErr(I_ImmR2field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_exclusive_or","r2_range");
    }
    b_IfRangeErr(I_ImmR3field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_exclusive_or","r3_range");
    }
    s_IfNotINT(I_R1field) {VPIM_ERROR("integer_exclusive_or","invalid_type");}
    s_IfNotINT(I_R2field) {VPIM_ERROR("integer_exclusive_or","invalid_type");} 
  };
  b_BitwiseEorWithTag(I_R1field,I_R2field,I_R3field);
}

/******************************************************************** PSL **
kblt_integer_shift_left A1, A2, A3, Lfail

       written by f-doumae@icot22      on Tue Jul 25 15:42:30 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |   integer_shift_left  |    A1     |    A2     | 
    +-----------+-----------+-----------+-----------+
    |	   A3   |        Lfail	        | don't care|
    +-----------+-----------+-----------+-----------+
<Arguments>
    A1 : $B%l%8%9%?(B($B@0?t$N$_(B)
    A2 : $B%l%8%9%?(B($B@0?t$N$_(B)
    A3 : $B%l%8%9%?(B($B=PNO(B)
    Lfail : $B%U%'%$%k%i%Y%k(B

<Temporally Used Variables>
<Level>
<PreCondition>
    $B!&(BA1$B!"(BA2$B$O%G%l%U:Q$_(B
    $B!&(BA1$B!"(BA2$B$O@0?t$N$_(B
    $B!&(BA3$B$OL$Dj5A(B
<Function>
    $B!&(BA2$B$,(B32$BL$K~$J$i$P!"(BA3$B$K(BA1$B$r(BA2$B$@$1:8%7%U%H$7$?CM$r=q$-9~$_!"<!L?Na$X(B
    $B!&$=$l0J30$O!"<!8uJd%"%I%l%9(BLfail$B$XJ,4t(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_R3field    _IndirectRegField3
#OPF_define I_ImmLfail   _ImmediateField4

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2
#OPF_define I_ImmR3field _ImmediateField3

#PSL_define  kblt_integer_shift_left()
{
  @DEBUG{
    b_IfRangeErr(I_ImmR1field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_shift_left","r1_range");
    }
    b_IfRangeErr(I_ImmR2field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_shift_left","r2_range");
    }
    b_IfRangeErr(I_ImmR3field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_shift_left","r3_range");
    }
    s_IfNotINT(I_R1field) {VPIM_ERROR("integer_shift_left","invalid_type");}
    s_IfNotINT(I_R2field) {VPIM_ERROR("integer_shift_left","invalid_type");} 
  };
  b_IfGreaterEqImm(I_R2field, _WordLength){ /* WordLength is 32 default */
      s_SetKLB_PC_OPR(I_ImmLfail);
  }else{
      b_IfLessImm(I_R2field, _ZERO){
	  s_SetKLB_PC_OPR(I_ImmLfail);
      }else{
	  b_ShiftLeftWithTag(I_R1field, I_R2field, I_R3field);
      }
  }
}

/******************************************************************** PSL **
kblt_integer_shift_right A1, A2, A3, Lfail

       written by f-doumae@icot22      on Tue Jul 25 15:46:31 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |   integer_shift_right |    A1     |    A2     | 
    +-----------+-----------+-----------+-----------+
    |	   A3   |        Lfail	        | don't care|
    +-----------+-----------+-----------+-----------+
<Arguments>
    A1 : $B%l%8%9%?(B($B@0?t$N$_(B)
    A2 : $B%l%8%9%?(B($B@0?t$N$_(B)
    A3 : $B%l%8%9%?(B($B=PNO(B)
    Lfail : $B%U%'%$%k%i%Y%k(B

<Temporally Used Variables>
<Level>
<PreCondition>
    $B!&(BA1$B!"(BA2$B$O%G%l%U:Q$_(B
    $B!&(BA1$B!"(BA2$B$O@0?t$N$_(B
    $B!&(BA3$B$OL$Dj5A(B
<Function>
    $B!&(BA2$B$,(B32$BL$K~$J$i$P!"(BA3$B$K(BA1$B$r(BA2$B$@$11&%7%U%H$7$?CM$r=q$-9~$_!"<!L?Na$X(B
    $B!&$=$l0J30$O!"<!8uJd%"%I%l%9(BLfail$B$XJ,4t(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_R3field    _IndirectRegField3
#OPF_define I_ImmLfail   _ImmediateField4

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2
#OPF_define I_ImmR3field _ImmediateField3

#PSL_define  kblt_integer_shift_right()
{
  @DEBUG{
    b_IfRangeErr(I_ImmR1field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_shift_right","r1_range");
    }
    b_IfRangeErr(I_ImmR2field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_shift_right","r2_range");
    }
    b_IfRangeErr(I_ImmR3field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_shift_right","r3_range");
    }
    s_IfNotINT(I_R1field) {VPIM_ERROR("integer_shift_right","invalid_type");}
    s_IfNotINT(I_R2field) {VPIM_ERROR("integer_shift_right","invalid_type");} 
  };
  b_IfGreaterEqImm(I_R2field, _WordLength){ /* WordLength is 32 default */
      s_SetKLB_PC_OPR(I_ImmLfail);
  }else{
      b_IfLessImm(I_R2field, _ZERO){
	  s_SetKLB_PC_OPR(I_ImmLfail);
      }else{
	  b_ShiftRightWithTag(I_R1field, I_R2field, I_R3field);
      }
  }
}

/******************************************************************** PSL **
3. $B@0?t;;=Q1i;;7OAH$_9~$_=R8l(B

kblt_integer_add A1, A2, A3, Lfail

       written by f-doumae@icot22      on Tue Jul 25 15:27:14 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |      integer_add      |    A1     |    A2     | 
    +-----------+-----------+-----------+-----------+
    |	   A3   |        Lfail	        | don't care|
    +-----------+-----------+-----------+-----------+
<Arguments>
    A1 : $B%l%8%9%?(B($B@0?t$N$_(B)
    A2 : $B%l%8%9%?(B($B@0?t$N$_(B)
    A3 : $B%l%8%9%?(B($B=PNO(B)
    Lfail : $B%U%'%$%k%i%Y%k(B

<Temporally Used Variables>
<Level>
<PreCondition>
    $B!&(BA1$B!"(BA2$B$O%G%l%U:Q$_(B
    $B!&(BA1$B!"(BA2$B$O@0?t$N$_(B
    $B!&(BA3$B$OL$Dj5A(B
<Function>
    A3$B$K(BA1$B$H(BA2$B$r2C$($?CM$r=q$-9~$_!"<!L?Na$X(B
    $B%*%P!<%U%m!<$N$H$-$O<!8uJd%"%I%l%9(BLfial$B$KJ,4t(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_R3field    _IndirectRegField3
#OPF_define I_ImmLfail   _ImmediateField4

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2
#OPF_define I_ImmR3field _ImmediateField3

#PSL_define  kblt_integer_add()
{
  @DEBUG{
    b_IfRangeErr(I_ImmR1field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_add","r1_range");
    }
    b_IfRangeErr(I_ImmR2field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_add","r2_range");
    }
    b_IfRangeErr(I_ImmR3field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_add","r3_range");
    }
    s_IfNotINT(I_R1field) {VPIM_ERROR("integer_add","invalid_type");}
    s_IfNotINT(I_R2field) {VPIM_ERROR("integer_add","invalid_type");} 
  };
  b_AddWithTag(I_R1field, I_R2field, I_R3field);
  p_IfOverflow(){
      s_SetKLB_PC_OPR(I_ImmLfail);
  }
}

/******************************************************************** PSL **
kblt_integer_subtract A1, A2, A3, Lfail

       written by f-doumae@icot22      on Tue Jul 25 15:30:55 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |   integer_subtract    |    A1     |    A2     | 
    +-----------+-----------+-----------+-----------+
    |	   A3   |        Lfail	        | don't care|
    +-----------+-----------+-----------+-----------+
<Arguments>
    A1 : $B%l%8%9%?(B($B@0?t$N$_(B)
    A2 : $B%l%8%9%?(B($B@0?t$N$_(B)
    A3 : $B%l%8%9%?(B($B=PNO(B)
    Lfail : $B%U%'%$%k%i%Y%k(B

<Temporally Used Variables>
<Level>
<PreCondition>
    $B!&(BA1$B!"(BA2$B$O%G%l%U:Q$_(B
    $B!&(BA1$B!"(BA2$B$O@0?t$N$_(B
    $B!&(BA3$B$OL$Dj5A(B
<Function>
    A3$B$K(BA1$B$+$i(BA2$B$r0z$$$?CM$r=q$-9~$_!"<!L?Na$X(B
    $B%*%P!<%U%m!<$N$H$-$O<!8uJd%"%I%l%9(BLfial$B$KJ,4t(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_R3field    _IndirectRegField3
#OPF_define I_ImmLfail   _ImmediateField4

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2
#OPF_define I_ImmR3field _ImmediateField3

#PSL_define  kblt_integer_subtract()
{
  @DEBUG{
    b_IfRangeErr(I_ImmR1field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_subtract","r1_range");
    }
    b_IfRangeErr(I_ImmR2field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_subtract","r2_range");
    }
    b_IfRangeErr(I_ImmR3field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_subtract","r3_range");
    }
    s_IfNotINT(I_R1field) {VPIM_ERROR("integer_subtract","invalid_type");}
    s_IfNotINT(I_R2field) {VPIM_ERROR("integer_subtract","invalid_type");} 
  };
  b_SubtractWithTag(I_R1field, I_R2field, I_R3field);
  p_IfOverflow(){
      s_SetKLB_PC_OPR(I_ImmLfail);
  }
}

/******************************************************************** PSL **
kblt_integer_multiply A1, A2, A3, Lfail

       written by f-doumae@icot22      on Tue Jul 25 15:32:43 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |     integer_multiply  |    A1     |    A2     | 
    +-----------+-----------+-----------+-----------+
    |	   A3   |        Lfail	        | don't care|
    +-----------+-----------+-----------+-----------+
<Arguments>
    A1 : $B%l%8%9%?(B($B@0?t$N$_(B)
    A2 : $B%l%8%9%?(B($B@0?t$N$_(B)
    A3 : $B%l%8%9%?(B($B=PNO(B)
    Lfail : $B%U%'%$%k%i%Y%k(B

<Temporally Used Variables>
<Level>
<PreCondition>
    $B!&(BA1$B!"(BA2$B$O%G%l%U:Q$_(B
    $B!&(BA1$B!"(BA2$B$O@0?t$N$_(B
    $B!&(BA3$B$OL$Dj5A(B
<Function>
    A3$B$K(BA1$B$H(BA2$B$r3]$1$?CM$r=q$-9~$_!"<!L?Na$X(B
    $B%*%P!<%U%m!<$N$H$-$O<!8uJd%"%I%l%9(BLfial$B$KJ,4t(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_R3field    _IndirectRegField3
#OPF_define I_ImmLfail   _ImmediateField4

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2
#OPF_define I_ImmR3field _ImmediateField3

#PSL_define  kblt_integer_multiply()
{
  @DEBUG{
    b_IfRangeErr(I_ImmR1field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_multiply","r1_range");
    }
    b_IfRangeErr(I_ImmR2field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_multiply","r2_range");
    }
    b_IfRangeErr(I_ImmR3field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_multiply","r3_range");
    }
    s_IfNotINT(I_R1field) {VPIM_ERROR("integer_multiply","invalid_type");}
    s_IfNotINT(I_R2field) {VPIM_ERROR("integer_multiply","invalid_type");} 
  };
  b_MultiplyWithTag(I_R1field, I_R2field, I_R3field);
  p_IfOverflow(){
      s_SetKLB_PC_OPR(I_ImmLfail);
  }
}

/******************************************************************** PSL **
kblt_integer_divide A1, A2, A3, Lfail

       written by f-doumae@icot22      on Tue Jul 25 15:34:56 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |     integer_divide    |    A1     |    A2     | 
    +-----------+-----------+-----------+-----------+
    |	   A3   |        Lfail	        | don't care|
    +-----------+-----------+-----------+-----------+
<Arguments>
    A1 : $B%l%8%9%?(B($B@0?t$N$_(B)
    A2 : $B%l%8%9%?(B($B@0?t$N$_(B)
    A3 : $B%l%8%9%?(B($B=PNO(B)
    Lfail : $B%U%'%$%k%i%Y%k(B

<Temporally Used Variables>
<Level>
<PreCondition>
    $B!&(BA1$B!"(BA2$B$O%G%l%U:Q$_(B
    $B!&(BA1$B!"(BA2$B$O@0?t$N$_(B
    $B!&(BA3$B$OL$Dj5A(B
<Function>
    $B!&(BA1$B$,(B0$B$G$J$1$l$P!"(BA3$B$K(BA1$B$r(BA2$B$G3d$C$?CM$r=q$-9~$_!"<!L?Na$X(B
    $B!&$=$l0J30$O!"<!8uJd%"%I%l%9(BLfail$B$XJ,4t(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_R3field    _IndirectRegField3
#OPF_define I_ImmLfail   _ImmediateField4

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2
#OPF_define I_ImmR3field _ImmediateField3

#PSL_define  kblt_integer_divide()
{
  @DEBUG{
    b_IfRangeErr(I_ImmR1field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_divide","r1_range");
    }
    b_IfRangeErr(I_ImmR2field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_divide","r2_range");
    }
    b_IfRangeErr(I_ImmR3field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_divide","r3_range");
    }
    s_IfNotINT(I_R1field) {VPIM_ERROR("integer_divide","invalid_type");}
    s_IfNotINT(I_R2field) {VPIM_ERROR("integer_divide","invalid_type");} 
  };
  b_DivideWithTag(I_R1field, I_R2field, I_R3field);
  p_IfZeroDivide() {
      s_SetKLB_PC_OPR(I_ImmLfail);
  }
  p_IfOverflow(){
      s_SetKLB_PC_OPR(I_ImmLfail);
  }
}

/******************************************************************** PSL **
kblt_integer_modulo A1, A2, A3, Lfail

       written by f-doumae@icot22      on Tue Jul 25 15:36:43 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |     integer_modulo    |    A1     |    A2     | 
    +-----------+-----------+-----------+-----------+
    |	   A3   |        Lfail	        | don't care|
    +-----------+-----------+-----------+-----------+
<Arguments>
    A1 : $B%l%8%9%?(B($B@0?t$N$_(B)
    A2 : $B%l%8%9%?(B($B@0?t$N$_(B)
    A3 : $B%l%8%9%?(B($B=PNO(B)
    Lfail : $B%U%'%$%k%i%Y%k(B

<Temporally Used Variables>
<Level>
<PreCondition>
    $B!&(BA1$B!"(BA2$B$O%G%l%U:Q$_(B
    $B!&(BA1$B!"(BA2$B$O@0?t$N$_(B
    $B!&(BA3$B$OL$Dj5A(B
<Function>
    $B!&(BA1$B$,(B0$B$G$J$1$l$P!"(BA3$B$K(BA1$B$r(BA2$B$G3d$C$?M>$j$r=q$-9~$_!"<!L?Na$X(B
    $B!&$=$l0J30$O!"<!8uJd%"%I%l%9(BLfail$B$XJ,4t(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_R3field    _IndirectRegField3
#OPF_define I_ImmLfail   _ImmediateField4

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2
#OPF_define I_ImmR3field _ImmediateField3

#PSL_define  kblt_integer_modulo()
{
  @DEBUG{
    b_IfRangeErr(I_ImmR1field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_modulo","r1_range");
    }
    b_IfRangeErr(I_ImmR2field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_modulo","r2_range");
    }
    b_IfRangeErr(I_ImmR3field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_modulo","r3_range");
    }
    s_IfNotINT(I_R1field) {VPIM_ERROR("integer_modulo","invalid_type");}
    s_IfNotINT(I_R2field) {VPIM_ERROR("integer_modulo","invalid_type");} 
  };
  b_ModuloWithTag(I_R1field, I_R2field, I_R3field);
  p_IfZeroDivide() {
      s_SetKLB_PC_OPR(I_ImmLfail);
  }
  p_IfOverflow(){
      s_SetKLB_PC_OPR(I_ImmLfail);
  }
}

/******************************************************************** PSL **
kblt_integer_increment A1, A2, Lfail

       written by f-doumae@icot22      on Tue Jul 25 15:27:14 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |  integer_increment    |    A1     |    A2     | 
    +-----------+-----------+-----------+-----------+
    |	      Lfail	    |     don't care        |
    +-----------+-----------+-----------+-----------+
<Arguments>
    A1 : $B%l%8%9%?(B($B@0?t$N$_(B)
    A2 : $B%l%8%9%?(B($B=PNO(B)
    Lfail : $B%U%'%$%k%i%Y%k(B

<Temporally Used Variables>
<Level>
<PreCondition>
    $B!&(BA1 $B$O%G%l%U:Q$_(B
    $B!&(BA1 $B$O@0?t$N$_(B
    $B!&(BA2 $B$OL$Dj5A(B
<Function>
    A1$B$K(B 1$B$r2C$($?CM$r(B A2$B$K=q$-9~$_!"<!L?Na$X(B
    $B%*%P!<%U%m!<$N$H$-$O<!8uJd%"%I%l%9(BLfial$B$KJ,4t(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_ImmLfail   _ImmediateField3

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2

#PSL_define  kblt_integer_increment()
{
  @DEBUG{
    b_IfRangeErr(I_ImmR1field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_increment","r1_range");
    }
    b_IfRangeErr(I_ImmR2field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_increment","r2_range");
    }
    s_IfNotINT(I_R1field) {VPIM_ERROR("kblt_integer_increment","invalid_type");}
  };
  b_AddImmediateWithTag (I_R1field, _ONE, I_R2field);
  p_IfOverflow() {
    s_SetKLB_PC_OPR(I_ImmLfail);
  }
}

/******************************************************************** PSL **
kblt_integer_decrement A1, A2, Lfail

       written by f-doumae@icot22      on Tue Jul 25 15:27:14 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |   integer_decrement   |    A1     |    A2     | 
    +-----------+-----------+-----------+-----------+
    |	      Lfail	    |     don't care        |
    +-----------+-----------+-----------+-----------+
<Arguments>
    A1 : $B%l%8%9%?(B($B@0?t$N$_(B)
    A2 : $B%l%8%9%?(B($B=PNO(B)
    Lfail : $B%U%'%$%k%i%Y%k(B

<Temporally Used Variables>
<Level>
<PreCondition>
    $B!&(BA1 $B$O%G%l%U:Q$_(B
    $B!&(BA1 $B$O@0?t$N$_(B
    $B!&(BA2 $B$OL$Dj5A(B
<Function>
    A1$B$+$i(B 1$B$r8:$8$?CM$r(B A2$B$K=q$-9~$_!"<!L?Na$X(B
    $B%*%P!<%U%m!<$N$H$-$O<!8uJd%"%I%l%9(BLfial$B$KJ,4t(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_R1field    _IndirectRegField1
#OPF_define I_R2field    _IndirectRegField2
#OPF_define I_ImmLfail   _ImmediateField3

#OPF_define I_ImmR1field _ImmediateField1
#OPF_define I_ImmR2field _ImmediateField2

#PSL_define  kblt_integer_decrement()
{
  @DEBUG{
    b_IfRangeErr(I_ImmR1field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_decrement","r1_range");
    }
    b_IfRangeErr(I_ImmR2field, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC("kblt_integer_decrement","r2_range");
    }
    s_IfNotINT(I_R1field) {VPIM_ERROR("kblt_integer_decrement","invalid_type");}
  };
  b_SubtractImmediateWithTag (I_R1field, _ONE, I_R2field);
  p_IfOverflow() {
    s_SetKLB_PC_OPR(I_ImmLfail);
  }
}
