
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/interpreter/klb_fork.psl.c
   ----- CREATED   : by f-hataza@icot22, on Mon Jan 21 13:57:35 1991
   ----- LAST SAVED: by ttakagi@icot22, on Thu Apr  2 15:00:02 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 

klb_alloc_goal (arity, Rgoal)
klb_collect_goal (arity, Rgoal)
klb_enqueue (Rgoal, Rcode, arity)
klb_enqueue_with_priority (Rgoal, Rcode, Rprio, arity)
klb_enqueue_to_cluster (Rgoal, Rcode, Rclus, arity)
klb_enqueue_to_processor (Rgoal, Rcode, Rpe, arity)
klb_enqueue_resident_to_cluster (Rgoal, Rcode, Rclus, arity)
klb_enqueue_resident_to_processor (Rgoal, Rcode, Rpe, arity)
klb_enqueue_emigrant_to_cluster (Rgoal, Rcode, arity)
klb_enqueue_emigrant_to_processor (Rgoal, Rcode, arity)
kblt_b_enqueue (Rgoal, Rcode, arity)
kblt_b_enqueue_with_priority (Rgoal, Rcode, Rprio)
kblt_b_enqueue_to_cluster (Rgoal, Rcode, Rclus)
kblt_b_enqueue_to_processor (Rgoal, Rcode, Rpe)
kblt_b_enqueue_resident_to_cluster (Rgoal, Rcode, Rclus)
kblt_b_enqueue_resident_to_processor (Rgoal, Rcode, Rpe)
kblt_b_enqueue_emigrant_to_cluster (Rgoal, Rcode)
kblt_b_enqueue_emigrant_to_processor (Rgoal, Rcode)
klb_set_caller_code_info (Rgoal)

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */
#DATA_define D_WorkCodeAddress      XXX
#DATA_define D_WorkPredicateAddr    XXX
#DATA_define D_WorkOffset           XXX

/******************************************************************** PSL **
klb_alloc_goal arity, Rgoal

       written by f-doumae@icot22      on Thu Jun  7 14:04:11 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |      alloc_goal       |   arity   |   Rgoal   | 
    +-----------+-----------+-----------+-----------+
<Arguments>
    arity : $B%4!<%k$N0z?t8D?t(B      
    Rgoal : $B%4!<%k$r;X$9%l%8%9%?(B(distination)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    arity$B8D$N0z?t$r3JG<$G$-$k%4!<%k%l%3!<%I$r3d$jIU$1!"@)8f>pJs$r=q$-9~$_!"(B
    $B$=$3$X$N%]%$%s%?$r(BRgoal$B$K=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
    $B%4!<%k%l%3!<%I$O(B16,32$B%o!<%I$N(B2$B<oN`$,$"$k!#(B($B0z?t(B0$B!A(B26)
    $B<B5!$G$O%]%9%H%3%s%Q%$%i$,(BArity$B$K$h$jL?Na$r=P$7J,$1$k!#(B

    alloc_goal  --+--> alloc_goal16
                  +--> alloc_goal32
                           :
<ETC>
********************************************************************* PSL **/
#OPF_define I_ImmArity      _ImmediateField1
#OPF_define I_RegGoalPtr    _IndirectRegField2

#OPF_define I_ImmRegGoalPtr _ImmediateField2   /* @DEBUG$BMQ(B */

#PSL_define klb_alloc_goal()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegGoalPtr, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "klb_alloc_goal", "r2_range" );
    }
  };
  $USE(D_WorkArity);
  p_MoveImmediateValueFromImmediateField(I_ImmArity, D_WorkArity);
  b_IfLessEqImm (D_WorkArity, _MAX_ARGS_SHORT_GR){
    s_AllocShortGoalRecord( I_RegGoalPtr );
  } else {
    b_IfLessEqImm (D_WorkArity, _MAX_ARGS_LONG_GR){
      s_AllocLongGoalRecord( I_RegGoalPtr );
    } else {
	@DEBUG{ OUT_OF_SPEC("klb_alloc_goal","argument-overflew");};
    }
  }
  $RELEASE(D_WorkArity);
  s_PutNextEOLGoalRecord( I_RegGoalPtr );
  s_PutFosterparentGoalRecord( I_RegGoalPtr, D_Current_FP_Ptr );
  s_PutProcessorIdGoalRecord( I_RegGoalPtr, D_PE_Number );
  s_PutEnvRecGoalRecord( I_RegGoalPtr, D_CurrentEnvRecPtr );
/* $B%3!<%I$X$N%]%$%s%?(B,$B%"%j%F%#$O(Benqueue$BL?Na$G=q$-9~$^$l$k!#(B*/
}

/******************************************************************** PSL **
klb_collect_goal arity, Rgoal

       written by f-doumae@icot22      on Thu Jun  7 14:08:32 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |     collect_goal      |   arity   |   Rgoal   | 
    +-----------+-----------+-----------+-----------+
<Arguments>
    arity : Rgoal$B$,;X$9%4!<%k%l%3!<%I$N0z?t8D?t(B
    Rgoal : $B%4!<%k%l%3!<%I$r;X$9%]%$%s%?$r;}$D%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B%l%8%9%?(BRgoal$B$G;X$5$l$k0z?t(Barity$B8DMQ$N%4!<%k%l%3!<%I$r2s<}$9$k!#(B
    $B2s<}8e(B, Rgoal $B$r(B NULL (= D_NULL) $B$H$9$k!#(B
<Examples>
<Test>
<Explanation>
    $B%4!<%k%l%3!<%I$O(B16,32$B%o!<%I$N(B2$B<oN`$,$"$k!#(B($B0z?t(B0$B!A(B26)
    $B<B5!$G$O%]%9%H%3%s%Q%$%i$,(BArity$B$K$h$jL?Na$r=P$7J,$1$k!#(B

    collect_goal  --+--> collect_goal16
                    +--> collect_goal32
                           :
<ETC>
********************************************************************* PSL **/
#OPF_define I_ImmArity      _ImmediateField1
#OPF_define I_RegGoalPtr    _IndirectRegField2

#OPF_define I_ImmRegGoalPtr _ImmediateField2   /* @DEBUG$BMQ(B */

#PSL_define klb_collect_goal()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegGoalPtr, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "klb_collect_goal", "r2_range" );
    }
  };
  $USE(D_WorkArity);
  p_MoveImmediateValueFromImmediateField(I_ImmArity, D_WorkArity);
  b_IfLessEqImm (D_WorkArity, _MAX_ARGS_SHORT_GR){
    s_ReclaimShortGoalRecord( I_RegGoalPtr );
  } else {
    b_IfLessEqImm (D_WorkArity, _MAX_ARGS_LONG_GR){
      s_ReclaimLongGoalRecord( I_RegGoalPtr );
    } else {
	@DEBUG{VPIM_ERROR("klb_collect_goal","not-used-gr-size");};
    }
  }
  $RELEASE(D_WorkArity);
  f_MakeEmptyCGP( I_RegGoalPtr );
}

/******************************************************************** PSL **
klb_enqueue Rgoal, Rcode, arity

       written by f-doumae@icot22      on Thu Jun  7 14:11:56 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |        enqueue        |   Rgoal   |   Rcode   | 
    +-----------+-----------+-----------+-----------+
    |   arity   |             don't care            |
    +-----------+-----------+-----------+-----------+
<Arguments>
    Rgoal : $B%4!<%k%l%3!<%I$X$N%]%$%s%?$r$b$D%l%8%9%?(B
    Rcode : $B%3!<%I$X$N%]%$%s%?(B
    arity : $B%4!<%k$N0z?t8D?t(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B%l%8%9%?(BRgoal$B$G;X$5$l$k%4!<%k%l%3!<%I$K(BRcode$B$G;XDj$5$l$k%3!<%I$X$N(B
    $B%"%I%l%9$H!"(Barity$B$r=q$-9~$_!"%(%s%-%e!<$9$k!#(B
    Rcode $B$,L$Dj5A$N;~$K$O!"(BD$B%3!<%I%4!<%k$r$D$/$C$F(Bapply$B$r%5%9%Z%s%I$9$k!#(B
<Examples>
<Test>
<Explanation>
    $B%(%s%-%e!<$9$k%4!<%k$,=jB0$9$kAq1`(B($BN$?F(B)$B!"%W%i%$%*%j%F%#!"(B
    PE$BHV9f$O%4!<%k%l%3!<%I$,3d$jIU$1$i$l$?;~$K@_Dj$5$l$F$$$k!#(B
    (cf. klb_alloc_goal)
<ETC>
********************************************************************* PSL **/
#OPF_define  I_RegGoalPtr    _IndirectRegField1
#OPF_define  I_RegCode       _IndirectRegField2
#OPF_define  I_ImmArity      _ImmediateField3

#OPF_define  I_ImmRegGoalPtr _ImmediateField1   /* @DEBUG$BMQ(B */
#OPF_define  I_ImmRegCode    _ImmediateField2   /* @DEBUG$BMQ(B */

#PSL_define klb_enqueue()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegGoalPtr, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "klb_enqueue", "r1_range" );
    }
    b_IfRangeErr( I_ImmRegCode, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "klb_enqueue", "r2_range" );
    }
  };

  s_PutArityGoalRecordOPR( I_RegGoalPtr, I_ImmArity );

  @TRACE{
	/* ENQUEUE is defined in p_opecode_table.psl.c 
		The Value is same as _ImmediateField0 */
    f_IfTraceMode() {
      f_TraceNormalGoal( ENQUEUE, I_RegGoalPtr, I_RegCode );
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_WorkDerefPtr);
  /* $BK\Mh(BCOD$B$G$J$1$l$P%G%l%U$9$k$h$&$K$9$k$HB.$$$O$:$@$,!"(B... */
  f_ActiveDeref(I_RegCode,D_WorkDerefPtr);
  s_IfCOD(I_RegCode) {
    $RELEASE(D_WorkDerefPtr);
    s_PutCodeGoalRecord(I_RegGoalPtr, I_RegCode);
    @SPY{
      f_IfSpyMode() {
	f_IfSpiedGoal( I_RegGoalPtr ) {
	  f_ReportSpyExceptionNormalGoal(ENQUEUE, I_RegGoalPtr);
          goto End_of_KL1B_Instruction;
	}
      }
    };
    @DEBUG{ _PrintEnqueuedGoal(I_RegGoalPtr); };
    f_PushGoalToStack(I_RegGoalPtr);
    s_IncrementForkCounter();
  } else {
    /* I_RegCode $B$,(B UNDF $B$@$C$?$i%5%9%Z%s%I$5$;$k(B */
    @DEBUG{ s_IfNotUnbound(I_RegCode) {
        VPIM_ERROR("klb_enqueue","illegal code data");
    } };
    p_MoveWord( D_WorkDerefPtr, I_RegCode);
    /* s_PutCodeGoalRecord(I_RegGoalPtr, D_WorkDerefPtr);
       --> $B%?%$%W$r(B COD $B$K$7$F$7$^$&$N$G!""-$N$h$&$K$9$k(B */
    p_WriteWithOffset(D_WorkDerefPtr, I_RegGoalPtr, _CODE_PTR_OFST_GR);
    $RELEASE(D_WorkDerefPtr);
    s_IncrementForkCounter(); /* $B%3!<%I$,7h$^$i$J$/$F%5%9%Z%s%I$7$?%4!<%kJ,(B */
    f_DcodeEnqueue2Ope_II(BLT_B_ENQUEUE, I_RegGoalPtr, I_RegCode);
  }
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
klb_enqueue_with_priority Rgoal, Rcode, Rprio, arity

       written by f-doumae@icot22      on Thu Jun  7 14:19:53 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    | enqueue_with_priority |   Rgoal   |   Rcode   |
    +-----------+-----------+-----------+-----------+
    |   Rpri    |   arity   |      don't care       |
    +-----------+-----------+-----------+-----------+
<Arguments>
    Rgoal : $B%4!<%k%l%3!<%I$X$N%]%$%s%?$r;}$D%l%8%9%?(B
    Rcode : $B%3!<%I$X$N%]%$%s%?$r;}$D%l%8%9%?(B
    Rprio : $B%W%i%$%*%j%F%#(B
    arity : $B%4!<%k$N0z?t8D?t(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B%l%8%9%?(BRgoal$B$G;X$5$l$k%4!<%k%l%3!<%I$K(BRcode$B$G;XDj$5$l$k%3!<%I$X$N(B
    $B%"%I%l%9(B, arity, Rprio$B>e$N%W%i%$%*%j%F%#$r=q$-9~$_!"%(%s%-%e!<$9$k!#(B
<Examples>
<Test>
<Explanation>
    $B%W%i%$%*%j%F%#$O%4!<%k%l%3!<%I$,3d$jIU$1$i$l$?;~$K4{$K?F%4!<%k$N(B
    ($B%+%l%s%H(B)$B%W%i%$%*%j%F%#$,=q$-9~$^$l$F$$$k$,(B(see klb_alloc_goal)$B!"(B
    $B$b$&0lEY?7$?$K%W%i%$%*%j%F%#$r>e=q$-$9$k!#(B
<ETC>
********************************************************************* PSL **/
#OPF_define  I_RegGoalPtr     _IndirectRegField1
#OPF_define  I_RegCode        _IndirectRegField2
#OPF_define  I_RegPriority    _IndirectRegField3
#OPF_define  I_ImmArity       _ImmediateField4

#OPF_define  I_ImmRegGoalPtr  _ImmediateField1   /* @DEBUG$BMQ(B */
#OPF_define  I_ImmRegCode     _ImmediateField2   /* @DEBUG$BMQ(B */
#OPF_define  I_ImmRegPriority _ImmediateField3   /* @DEBUG$BMQ(B */

#PSL_define klb_enqueue_with_priority()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegGoalPtr, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "klb_enqueue_with_priority", "r1_range" );
    }
    b_IfRangeErr( I_ImmRegCode, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "klb_enqueue_with_priority", "r2_range" );
    }
    b_IfRangeErr( I_ImmRegPriority, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "klb_enqueue_with_priority", "r3_range" );
    }
  };
  s_PutArityGoalRecordOPR( I_RegGoalPtr, I_ImmArity );

  @TRACE{
    f_IfTraceMode() {
      f_TracePrioGoal
	( ENQUEUE_WITH_PRIORITY, I_RegGoalPtr, I_RegCode, I_RegPriority );
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_WorkConst);
  b_SetImmValueDNTC(ENQUEUE_WITH_PRIORITY,D_WorkConst);
  $CALL(i_Enqueue_Sub(D_WorkConst, I_RegGoalPtr, I_RegCode, I_RegPriority));
  $RELEASE(D_WorkConst);
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
klb_enqueue_to_cluster Rgoal, Rcode, Rclus, arity

       written by f-doumae@icot22      on Thu Jun  7 14:35:54 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |  enqueue_to_cluster   |   Rgoal   |   Rcode   |
    +-----------+-----------+-----------+-----------+
    |   Rclus   |   arity   |      don't care       |
    +-----------+-----------+-----------+-----------+
<Arguments>
    Rgoal : $B%4!<%k%l%3!<%I$X$N%]%$%s%?$r;}$D%l%8%9%?(B
    Rcode : $B%3!<%I$X$N%]%$%s%?$r;}$D%l%8%9%?(B
    Rclus : $BAw?.@h%/%i%9%?HV9f!J%l%8%9%?!K(B
    arity : $B%4!<%k$N0z?t8D?t!JB(CM!K(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B%l%8%9%?(BRgoal$B$G;X$5$l$k%4!<%k%l%3!<%I$K(BRcode$B$G;XDj$5$l$k%3!<%I$X$N(B
    $B%"%I%l%9(B, arity$B$r=q$-9~$_!"(B Rclus$B$G;XDj$5$l$k%/%i%9%?$KAw=P$9$k!#(B
    Rclus$B$,%+%l%s%H%/%i%9%?$G$"$l$P(B($BDL>o$N(B)$B%(%s%-%e!<$r$9$k!#(B

    $B%l%8%9%?(B Rclus $B$,L$Dj5A$N>l9g$O!"CM$,7h$^$k$^$G(B %throw $B$r%5%9%Z%s%I$9$k(B
    $B%5%9%Z%s%IJ}<0$O(B <Explanation> $B$r;2>H$N$3$H(B
<Examples>
  KL1:
    go :- true| p@cluster(1).

  KLB:
    predicate(go/0,{2}).
        commit.
        change_goal_attribute(r0,1).
%%                               ^ cluster-resident$B$r0UL#$9$k!#(B
        put_integer(1,r1).
        enqueue_cluster(r0,r1,p/0).
        proceed.
<Test>
<Explanation>
    $B$3$NL?Na$NA0$K$OI,$:(Bchange_goal_attribute/2$B$K$h$C$F%4!<%kB0@-$r(B
    cluster-resident$B$KJQ$($F$$$k!#(B

  $B%l%8%9%?(B Rclus $B$,L$Dj5A$N>l9g!"(B
  (1) $B%4!<%k0z?t$r%Y%/%?$K$9$k(B
  (2) $B%4!<%k%l%3!<%I$r2s<}$9$k(B
  (3) $B2<$N$h$&$J(B D-Code $B%4!<%k$r@8@.$7!"(BRclus $B$K%U%C%/$5$;$k(B
	dcode_enqueue_cluster(Cluster,Code,Argv) :- integer(Cluster) |
		dcode_apply(Code,Argv)@cluster(Cluster).
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkSendGoalArity XXX

#OPF_define I_RegGoalPtr  _IndirectRegField1
#OPF_define I_RegCode     _IndirectRegField2
#OPF_define I_RegClusNum  _IndirectRegField3
#OPF_define I_ImmArity    _ImmediateField4

#OPF_define I_ImmRegGoalPtr  _ImmediateField1   /* @DEBUG$BMQ(B */
#OPF_define I_ImmRegCode     _ImmediateField2   /* @DEBUG$BMQ(B */
#OPF_define I_ImmRegClusNum  _ImmediateField3   /* @DEBUG$BMQ(B */

#PSL_define klb_enqueue_to_cluster()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegGoalPtr, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      OUT_OF_SPEC( "klb_enqueue_to_cluster", "r1_range" );
    }
    b_IfRangeErr( I_ImmRegCode, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      OUT_OF_SPEC( "klb_enqueue_to_cluster", "r2_range" );
    }
    b_IfRangeErr( I_ImmRegClusNum, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      OUT_OF_SPEC( "klb_enqueue_to_cluster", "r3_range" );
    }
  };

  s_PutArityGoalRecordOPR( I_RegGoalPtr, I_ImmArity );
  @TRACE{
    f_IfTraceMode() {
      f_TraceThrowGoalFamily
	( ENQUEUE_TO_CLUSTER, I_RegGoalPtr, I_RegCode, I_RegClusNum );
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_WorkConst);
  b_SetImmValueDNTC(ENQUEUE_TO_CLUSTER,D_WorkConst);
  $CALL(i_Enqueue_Sub(D_WorkConst, I_RegGoalPtr, I_RegCode, I_RegClusNum));
  $RELEASE(D_WorkConst);
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
klb_enqueue_to_processor Rgoal, Rcode, Rpe, arity

       written by f-doumae@icot22      on Thu Jun  7 15:42:21 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |  enqueue_to_processor |   Rgoal   |   Rcode   |
    +-----------+-----------+-----------+-----------+
    |    Rpe    |   arity   |      don't care       |
    +-----------+-----------+-----------+-----------+
<Arguments>
    Rgoal : $B%4!<%k%l%3!<%I$X$N%]%$%s%?$r;}$D%l%8%9%?(B
    Rcode : $B%3!<%I$X$N%]%$%s%?$r;}$D%l%8%9%?(B
    Rpe   : $B%W%m%;%C%5HV9f(B($B%l%8%9%?(B)
    arity : $B%4!<%k$N0z?t8D?t(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
  KL1:
    go :- true| p@processor(1).

  KLB:
    predicate(go/0,{2}).
        commit.
        change_goal_attribute(r0,2).
        put_integer(1,r1).
        enqueue_processor(r0,r1,p/0).
        proceed.
<Test>
<Explanation>
    $B$3$NL?Na$NA0$K$OI,$:(Bchange_goal_attribute/2 $B$,$G$F!"%4!<%kB0@-$r(B
    resident-processor $B$KJQ$($F$$$k!#(B

  $B%l%8%9%?(B Rpe $B$,L$Dj5A$N>l9g!"(B
  (1) $B%4!<%k0z?t$r%Y%/%?$K$9$k(B
  (2) $B%4!<%k%l%3!<%I$r2s<}$9$k(B
  (3) $B2<$N$h$&$J(B D-Code $B%4!<%k$r@8@.$7!"(BRpe $B$K%U%C%/$5$;$k(B
	dcode_enqueue_processor(Processor,Code,Argv) :- integer(Processor) |
		dcode_apply(Code,Argv)@processor(Processor).
<ETC>
********************************************************************* PSL **/
#OPF_define  I_RegGoalPtr     _IndirectRegField1
#OPF_define  I_RegCode        _IndirectRegField2
#OPF_define  I_RegPeNum       _IndirectRegField3
#OPF_define  I_ImmArity       _ImmediateField4

#OPF_define  I_ImmRegGoalPtr  _ImmediateField1   /* @DEBUG$BMQ(B */
#OPF_define  I_ImmRegCode     _ImmediateField2   /* @DEBUG$BMQ(B */
#OPF_define  I_ImmRegPeNum    _ImmediateField3   /* @DEBUG$BMQ(B */

#PSL_define klb_enqueue_to_processor()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegGoalPtr, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "klb_enqueue_to_processor", "r1_range" );
    }
    b_IfRangeErr( I_ImmRegCode, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      OUT_OF_SPEC( "klb_enqueue_to_processor", "r2_range" );
    }
    b_IfRangeErr( I_ImmRegPeNum, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "klb_enqueue_processor", "r3_range" );
    }
  };

  s_PutArityGoalRecordOPR( I_RegGoalPtr, I_ImmArity );

  @TRACE{
    f_IfTraceMode() {
      f_TraceThrowGoalFamily
	( ENQUEUE_TO_PROCESSOR, I_RegGoalPtr, I_RegCode, I_RegPeNum );
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_WorkConst);
  b_SetImmValueDNTC(ENQUEUE_TO_PROCESSOR,D_WorkConst);
  $CALL(i_Enqueue_Sub(D_WorkConst, I_RegGoalPtr, I_RegCode, I_RegPeNum));
  $RELEASE(D_WorkConst);
 End_of_KL1B_Instruction:;
}

#DATA_define D_WorkAttribute XXX

#OPF_define I_RegGoalPtr  _IndirectRegField1
#OPF_define I_RegCode     _IndirectRegField2
#OPF_define I_RegClusNum  _IndirectRegField3
#OPF_define I_ImmArity    _ImmediateField4

#OPF_define I_ImmRegGoalPtr  _ImmediateField1   /* @DEBUG$BMQ(B */
#OPF_define I_ImmRegCode     _ImmediateField2   /* @DEBUG$BMQ(B */
#OPF_define I_ImmRegClusNum  _ImmediateField3   /* @DEBUG$BMQ(B */

#PSL_define klb_enqueue_resident_to_cluster()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegGoalPtr, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      OUT_OF_SPEC( "klb_enqueue_resident_to_cluster", "r1_range" );
    }
    b_IfRangeErr( I_ImmRegCode, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      OUT_OF_SPEC( "klb_enqueue_resident_to_cluster", "r2_range" );
    }
    b_IfRangeErr( I_ImmRegClusNum, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      OUT_OF_SPEC( "klb_enqueue_resident_to_cluster", "r3_range" );
    }
  };

  s_PutArityGoalRecordOPR( I_RegGoalPtr, I_ImmArity );

  $USE(D_WorkAttribute);
  b_SetImmTypeValueMRBoff(INT,_RESIDENT_CLUSTER,D_WorkAttribute);
  f_ChangeAttributeGoalRecord(I_RegGoalPtr,D_WorkAttribute);
  $RELEASE(D_WorkAttribute);

  @TRACE{
    f_IfTraceMode() {
      f_TraceThrowGoalFamily
	( ENQUEUE_RESIDENT_TO_CLUSTER, I_RegGoalPtr, I_RegCode, I_RegClusNum );
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_WorkConst);
  b_SetImmValueDNTC(ENQUEUE_RESIDENT_TO_CLUSTER,D_WorkConst);
  $CALL(i_Enqueue_Sub(D_WorkConst, I_RegGoalPtr, I_RegCode, I_RegClusNum));
  $RELEASE(D_WorkConst);
 End_of_KL1B_Instruction:;
}

#OPF_define  I_RegGoalPtr     _IndirectRegField1
#OPF_define  I_RegCode        _IndirectRegField2
#OPF_define  I_RegPeNum       _IndirectRegField3
#OPF_define  I_ImmArity       _ImmediateField4

#OPF_define  I_ImmRegGoalPtr  _ImmediateField1   /* @DEBUG$BMQ(B */
#OPF_define  I_ImmRegCode     _ImmediateField2   /* @DEBUG$BMQ(B */
#OPF_define  I_ImmRegPeNum    _ImmediateField3   /* @DEBUG$BMQ(B */

#PSL_define klb_enqueue_resident_to_processor()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegGoalPtr, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "klb_enqueue_resident_to_processor", "r1_range" );
    }
    b_IfRangeErr( I_ImmRegCode, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      OUT_OF_SPEC( "klb_enqueue_resident_to_processor", "r2_range" );
    }
    b_IfRangeErr( I_ImmRegPeNum, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "klb_enqueue_resident_to_processor", "r3_range" );
    }
  };

  s_PutArityGoalRecordOPR( I_RegGoalPtr, I_ImmArity );

  $USE(D_WorkAttribute);
  b_SetImmTypeValueMRBoff(INT,_RESIDENT_PE,D_WorkAttribute);
  f_ChangeAttributeGoalRecord(I_RegGoalPtr,D_WorkAttribute);
  $RELEASE(D_WorkAttribute);

  @TRACE{
    f_IfTraceMode() {
      f_TraceThrowGoalFamily
	( ENQUEUE_RESIDENT_TO_PROCESSOR, I_RegGoalPtr, I_RegCode, I_RegPeNum );
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_WorkConst);
  b_SetImmValueDNTC(ENQUEUE_RESIDENT_TO_PROCESSOR,D_WorkConst);
  $CALL(i_Enqueue_Sub(D_WorkConst, I_RegGoalPtr, I_RegCode, I_RegPeNum));
  $RELEASE(D_WorkConst);
 End_of_KL1B_Instruction:;
}

#OPF_define  I_RegGoalPtr    _IndirectRegField1
#OPF_define  I_RegCode       _IndirectRegField2
#OPF_define  I_ImmArity      _ImmediateField3

#OPF_define  I_ImmRegGoalPtr _ImmediateField1   /* @DEBUG$BMQ(B */
#OPF_define  I_ImmRegCode    _ImmediateField2   /* @DEBUG$BMQ(B */

#PSL_define klb_enqueue_emigrant_to_cluster()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegGoalPtr, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "klb_enqueue_emigrant_to_cluster", "r1_range" );
    }
    b_IfRangeErr( I_ImmRegCode, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "klb_enqueue_emigrant_to_cluster", "r2_range" );
    }
  };

  s_PutArityGoalRecordOPR( I_RegGoalPtr, I_ImmArity );

  $USE(D_WorkAttribute);
  b_SetImmTypeValueMRBoff(INT,_EMIGRANT_CLUSTER,D_WorkAttribute);
  f_ChangeAttributeGoalRecord(I_RegGoalPtr,D_WorkAttribute);
  $RELEASE(D_WorkAttribute);

  @TRACE{
    f_IfTraceMode() {
      f_TraceNormalGoal(ENQUEUE_EMIGRANT_TO_CLUSTER,I_RegGoalPtr, I_RegCode );
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_WorkConst);
  b_SetImmValueDNTC(ENQUEUE_EMIGRANT_TO_CLUSTER,D_WorkConst);
  $CALL(i_Enqueue_Sub(D_WorkConst, I_RegGoalPtr, I_RegCode, D_EOL));
  $RELEASE(D_WorkConst);
 End_of_KL1B_Instruction:;
}

#OPF_define  I_RegGoalPtr    _IndirectRegField1
#OPF_define  I_RegCode       _IndirectRegField2
#OPF_define  I_ImmArity      _ImmediateField3

#OPF_define  I_ImmRegGoalPtr _ImmediateField1   /* @DEBUG$BMQ(B */
#OPF_define  I_ImmRegCode    _ImmediateField2   /* @DEBUG$BMQ(B */

#PSL_define klb_enqueue_emigrant_to_processor()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegGoalPtr, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "klb_enqueue_emigrant_to_processor", "r1_range" );
    }
    b_IfRangeErr( I_ImmRegCode, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "klb_enqueue_emigrant_to_processor", "r2_range" );
    }
  };

  s_PutArityGoalRecordOPR( I_RegGoalPtr, I_ImmArity );

  s_IfResidentPEAttrEnvRecord(D_CurrentEnvRecPtr){
    /* $B$3$l0J30$N>l9g(B(_RESIDENT_CLUSTER, _EMIGRANT_CLUSTER) $B$G$O!"(B
       PE emigrant $B$NB0@-$r;}$D$N$GJQ99$7$J$$!#(B*/
    $USE(D_WorkAttribute);
    b_SetImmTypeValueMRBoff(INT,_RESIDENT_CLUSTER,D_WorkAttribute);
    f_ChangeAttributeGoalRecord(I_RegGoalPtr,D_WorkAttribute);
    $RELEASE(D_WorkAttribute);
  }

  @TRACE{
    f_IfTraceMode() {
      f_TraceNormalGoal(ENQUEUE_EMIGRANT_TO_PROCESSOR,I_RegGoalPtr,I_RegCode);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_WorkConst);
  b_SetImmValueDNTC(ENQUEUE_EMIGRANT_TO_PROCESSOR,D_WorkConst);
  $CALL(i_Enqueue_Sub(D_WorkConst, I_RegGoalPtr, I_RegCode, D_EOL));
  $RELEASE(D_WorkConst);
 End_of_KL1B_Instruction:;
}

#OPF_define  I_RegGoalPtr    _IndirectRegField1
#OPF_define  I_RegCode       _IndirectRegField2

#OPF_define  I_ImmRegGoalPtr _ImmediateField1   /* @DEBUG$BMQ(B */
#OPF_define  I_ImmRegCode    _ImmediateField2   /* @DEBUG$BMQ(B */

#PSL_define kblt_b_enqueue()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegGoalPtr, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "kblt_b_enqueue", "r1_range" );
    }
    b_IfRangeErr( I_ImmRegCode, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "kblt_b_enqueue", "r2_range" );
    }
  };
  @TRACE{
    f_IfTraceMode() {
       @DEBUG{VPIM_ERROR("kblt_b_enqueue","can't be trace mode !!");};
       /* $B%H%l!<%9%b!<%I$G$O(Benqueue$B7OL?Na$,%5%9%Z%s%I$9$k$3$H$O$J$$$O$:!#(B */
    }
  };

  $USE(D_WorkDerefPtr);
  /* $BK\Mh(BCOD$B$G$J$1$l$P%G%l%U$9$k$h$&$K$9$k$HB.$$$O$:$@$,!"(B... */
  f_ActiveDeref(I_RegCode,D_WorkDerefPtr);
  s_IfCOD(I_RegCode) {
    $RELEASE(D_WorkDerefPtr);
    s_PutCodeGoalRecord(I_RegGoalPtr, I_RegCode);
    @SPY{
      f_IfSpyMode() {
	f_IfSpiedGoal( I_RegGoalPtr ) {
	  f_ReportSpyExceptionNormalGoal(BLT_B_ENQUEUE, I_RegGoalPtr);
          goto End_of_KL1B_Instruction;
	}
      }
    };
    @DEBUG{ _PrintEnqueuedGoal(I_RegGoalPtr); };
    f_PushGoalToStack(I_RegGoalPtr);
    /* s_IncrementForkCounter(); $B%5%9%Z%s%I;~$K(B $BA}$d$5$l$F$$$k(B */
  } else {
    $RELEASE(D_WorkDerefPtr);
    /* D$B%3!<%I%4!<%k$,(Bresume$B$9$k;~$K$OI,$:6qBN2=$5$l$F$$$k$O$:!#(B */
    @DEBUG{ VPIM_ERROR("kblt_b_enqueue","illegal code data");};
  }
 End_of_KL1B_Instruction:;
}

#OPF_define  I_RegGoalPtr     _IndirectRegField1
#OPF_define  I_RegCode        _IndirectRegField2
#OPF_define  I_RegPriority    _IndirectRegField3

#OPF_define  I_ImmRegGoalPtr  _ImmediateField1   /* @DEBUG$BMQ(B */
#OPF_define  I_ImmRegCode     _ImmediateField2   /* @DEBUG$BMQ(B */
#OPF_define  I_ImmRegPriority _ImmediateField3   /* @DEBUG$BMQ(B */

#PSL_define kblt_b_enqueue_with_priority()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegGoalPtr, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "kblt_b_enqueue_with_priority", "r1_range" );
    }
    b_IfRangeErr( I_ImmRegCode, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "kblt_b_enqueue_with_priority", "r2_range" );
    }
    b_IfRangeErr( I_ImmRegPriority, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "kblt_b_enqueue_with_priority", "r3_range" );
    }
  };

  $USE(D_WorkConst);
  b_SetImmValueDNTC(BLT_B_ENQUEUE_WITH_PRIORITY,D_WorkConst);
  $CALL(i_BodyBltEnqueue_Sub
			(D_WorkConst,I_RegGoalPtr,I_RegCode,I_RegPriority));
  $RELEASE(D_WorkConst);
}

#OPF_define I_RegGoalPtr  _IndirectRegField1
#OPF_define I_RegCode     _IndirectRegField2
#OPF_define I_RegClusNum  _IndirectRegField3

#OPF_define I_ImmRegGoalPtr  _ImmediateField1   /* @DEBUG$BMQ(B */
#OPF_define I_ImmRegCode     _ImmediateField2   /* @DEBUG$BMQ(B */
#OPF_define I_ImmRegClusNum  _ImmediateField3   /* @DEBUG$BMQ(B */

#PSL_define kblt_b_enqueue_to_cluster()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegGoalPtr, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      OUT_OF_SPEC( "kblt_b_enqueue_to_cluster", "r1_range" );
    }
    b_IfRangeErr( I_ImmRegCode, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      OUT_OF_SPEC( "kblt_b_enqueue_to_cluster", "r2_range" );
    }
    b_IfRangeErr( I_ImmRegClusNum, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      OUT_OF_SPEC( "kblt_b_enqueue_to_cluster", "r3_range" );
    }
  };

  $USE(D_WorkConst);
  b_SetImmValueDNTC(BLT_B_ENQUEUE_TO_CLUSTER,D_WorkConst);
  $CALL(i_BodyBltEnqueue_Sub
			(D_WorkConst,I_RegGoalPtr,I_RegCode,I_RegClusNum));
  $RELEASE(D_WorkConst);
}

#OPF_define  I_RegGoalPtr     _IndirectRegField1
#OPF_define  I_RegCode        _IndirectRegField2
#OPF_define  I_RegPeNum       _IndirectRegField3

#OPF_define  I_ImmRegGoalPtr  _ImmediateField1   /* @DEBUG$BMQ(B */
#OPF_define  I_ImmRegCode     _ImmediateField2   /* @DEBUG$BMQ(B */
#OPF_define  I_ImmRegPeNum    _ImmediateField3   /* @DEBUG$BMQ(B */

#PSL_define kblt_b_enqueue_to_processor()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegGoalPtr, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "kblt_b_enqueue_to_processor", "r1_range" );
    }
    b_IfRangeErr( I_ImmRegCode, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      OUT_OF_SPEC( "kblt_b_enqueue_to_processor", "r2_range" );
    }
    b_IfRangeErr( I_ImmRegPeNum, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "kblt_b_enqueue_to_processor", "r3_range" );
    }
  };

  $USE(D_WorkConst);
  b_SetImmValueDNTC(BLT_B_ENQUEUE_TO_PROCESSOR,D_WorkConst);
  $CALL(i_BodyBltEnqueue_Sub
			(D_WorkConst,I_RegGoalPtr,I_RegCode,I_RegPeNum));
  $RELEASE(D_WorkConst);
}

#OPF_define I_RegGoalPtr  _IndirectRegField1
#OPF_define I_RegCode     _IndirectRegField2
#OPF_define I_RegClusNum  _IndirectRegField3

#OPF_define I_ImmRegGoalPtr  _ImmediateField1   /* @DEBUG$BMQ(B */
#OPF_define I_ImmRegCode     _ImmediateField2   /* @DEBUG$BMQ(B */
#OPF_define I_ImmRegClusNum  _ImmediateField3   /* @DEBUG$BMQ(B */

#PSL_define kblt_b_enqueue_resident_to_cluster()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegGoalPtr, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      OUT_OF_SPEC( "kblt_b_enqueue_resident_to_cluster", "r1_range" );
    }
    b_IfRangeErr( I_ImmRegCode, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      OUT_OF_SPEC( "kblt_b_enqueue_resident_to_cluster", "r2_range" );
    }
    b_IfRangeErr( I_ImmRegClusNum, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      OUT_OF_SPEC( "kblt_b_enqueue_resident_to_cluster", "r3_range" );
    }
  };

  /* $B%4!<%k$NB0@-$O%5%9%Z%s%I$9$kA0$K@_Dj:Q$_(B */

  $USE(D_WorkConst);
  b_SetImmValueDNTC(BLT_B_ENQUEUE_RESIDENT_TO_CLUSTER,D_WorkConst);
  $CALL(i_BodyBltEnqueue_Sub
			(D_WorkConst,I_RegGoalPtr,I_RegCode,I_RegClusNum));
  $RELEASE(D_WorkConst);
}

#OPF_define  I_RegGoalPtr     _IndirectRegField1
#OPF_define  I_RegCode        _IndirectRegField2
#OPF_define  I_RegPeNum       _IndirectRegField3

#OPF_define  I_ImmRegGoalPtr  _ImmediateField1   /* @DEBUG$BMQ(B */
#OPF_define  I_ImmRegCode     _ImmediateField2   /* @DEBUG$BMQ(B */
#OPF_define  I_ImmRegPeNum    _ImmediateField3   /* @DEBUG$BMQ(B */

#PSL_define kblt_b_enqueue_resident_to_processor()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegGoalPtr, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "kblt_b_enqueue_resident_to_processor", "r1_range" );
    }
    b_IfRangeErr( I_ImmRegCode, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      OUT_OF_SPEC( "kblt_b_enqueue_resident_to_processor", "r2_range" );
    }
    b_IfRangeErr( I_ImmRegPeNum, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "kblt_b_enqueue_resident_to_processor", "r3_range" );
    }
  };

  /* $B%4!<%k$NB0@-$O%5%9%Z%s%I$9$kA0$K@_Dj:Q$_(B */

  $USE(D_WorkConst);
  b_SetImmValueDNTC(BLT_B_ENQUEUE_RESIDENT_TO_PROCESSOR,D_WorkConst);
  $CALL(i_BodyBltEnqueue_Sub
			(D_WorkConst,I_RegGoalPtr,I_RegCode,I_RegPeNum));
  $RELEASE(D_WorkConst);
}

#OPF_define  I_RegGoalPtr    _IndirectRegField1
#OPF_define  I_RegCode       _IndirectRegField2

#OPF_define  I_ImmRegGoalPtr _ImmediateField1   /* @DEBUG$BMQ(B */
#OPF_define  I_ImmRegCode    _ImmediateField2   /* @DEBUG$BMQ(B */

#PSL_define kblt_b_enqueue_emigrant_to_cluster()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegGoalPtr, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "kblt_b_enqueue_emigrant_to_cluster", "r1_range" );
    }
    b_IfRangeErr( I_ImmRegCode, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "kblt_b_enqueue_emigrant_to_cluster", "r2_range" );
    }
  };

  /* $B%4!<%k$NB0@-$O%5%9%Z%s%I$9$kA0$K@_Dj:Q$_(B */

  $USE(D_WorkConst);
  b_SetImmValueDNTC(BLT_B_ENQUEUE_EMIGRANT_TO_CLUSTER,D_WorkConst);
  $CALL(i_BodyBltEnqueue_Sub
			(D_WorkConst,I_RegGoalPtr,I_RegCode,D_EOL));
  $RELEASE(D_WorkConst);
}

#OPF_define  I_RegGoalPtr    _IndirectRegField1
#OPF_define  I_RegCode       _IndirectRegField2

#OPF_define  I_ImmRegGoalPtr _ImmediateField1   /* @DEBUG$BMQ(B */
#OPF_define  I_ImmRegCode    _ImmediateField2   /* @DEBUG$BMQ(B */

#PSL_define kblt_b_enqueue_emigrant_to_processor()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegGoalPtr, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "kblt_b_enqueue_emigrant_to_processor", "r1_range" );
    }
    b_IfRangeErr( I_ImmRegCode, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "kblt_b_enqueue_emigrant_to_processor", "r2_range" );
    }
  };

  /* $B%4!<%k$NB0@-$O%5%9%Z%s%I$9$kA0$K@_Dj:Q$_(B */

  $USE(D_WorkConst);
  b_SetImmValueDNTC(BLT_B_ENQUEUE_EMIGRANT_TO_PROCESSOR,D_WorkConst);
  $CALL(i_BodyBltEnqueue_Sub
			(D_WorkConst,I_RegGoalPtr,I_RegCode,D_EOL));
  $RELEASE(D_WorkConst);
}

#DATA_define D_WorkDcodeAddr XXX

#SUBARG_define  A_InstrID   SRC
#SUBARG_define  A_Goal      SRC
#SUBARG_define  A_Code      MODIFY
#SUBARG_define  A_Pragma    MODIFY

#SUBROUTINE i_Enqueue_Sub(A_InstrID,A_Goal,A_Code,A_Pragma)
{
  s_IncrementForkCounter(); /* A_Goal $B%4!<%k$NJ,(B */

  p_WriteWithOffset(D_EOL, A_Goal,  _CODE_PTR_OFST_GR);

  $USE(D_WorkDerefPtr);
  f_ActiveDeref(A_Code, D_WorkDerefPtr);
  s_IfNotCOD(A_Code) {
    s_IfUnbound(A_Code) {
      p_MoveWord(D_WorkDerefPtr,A_Code);
      /* s_PutCodeGoalRecord(A_Goal, D_WorkDerefPtr);
      --> $B%?%$%W$r(B COD $B$K$7$F$7$^$&$N$G!""-$N$h$&$K$9$k(B */
      p_WriteWithOffset(D_WorkDerefPtr, A_Goal,  _CODE_PTR_OFST_GR);
      $RELEASE(D_WorkDerefPtr);
      goto Suspend;
    } else {
      @DEBUG{ VPIM_ERROR("i_Enqueue_Sub","illegal code data"); };
    }
  }
  b_IfNotEOL(A_Pragma) {
    f_ActiveDeref(A_Pragma, D_WorkDerefPtr);
    s_IfNotINT(A_Pragma) {
      s_IfUnbound(A_Pragma) {
        p_MoveWord(D_WorkDerefPtr,A_Pragma);
        $RELEASE(D_WorkDerefPtr);
        goto Suspend;
      } else {
        @DEBUG{ OUT_OF_SPEC("i_Enqueue_Sub","illegal pragma data"); };
        /* $BK\Mh$ONc30$K$9$Y$-(B */
      }
    }
  }
  $RELEASE(D_WorkDerefPtr);

  /* A_Code, A_Pragma($BITMW$N;~(BEOL) $B$,6qBN2=$7$F$$$l$P!"(BEnqueue$B7OL?Na$r(B
     $B<B9T$9$k(B */
  i_ExecEnqueue(A_InstrID,A_Goal,A_Code,A_Pragma);
  $RETURN();

 Suspend:
  $USE(D_WorkDcodeAddr);
  ValueSwitch(A_InstrID) {
    case ENQUEUE: /* VPIM$B$G$O(B klb_enqueue$B$N>l9g$@$1FCJL=hM}$9$k$N$GITMW$@$,(B  */
                  /* PIM/p$B$G$O!"%5%9%Z%s%I$9$k>l9g$K$O$3$N%5%V%k!<%A%s$r;H$&(B */
      f_GetDcodeAddress(BLT_B_ENQUEUE,D_WorkDcodeAddr);
      break;
    case ENQUEUE_WITH_PRIORITY:
      f_GetDcodeAddress(BLT_B_ENQUEUE_WITH_PRIORITY,D_WorkDcodeAddr);
      break;
    case ENQUEUE_TO_CLUSTER:
      f_GetDcodeAddress(BLT_B_ENQUEUE_TO_CLUSTER,D_WorkDcodeAddr);
      break;
    case ENQUEUE_RESIDENT_TO_CLUSTER:
      f_GetDcodeAddress(BLT_B_ENQUEUE_RESIDENT_TO_CLUSTER,D_WorkDcodeAddr);
      break;
    case ENQUEUE_TO_PROCESSOR:
      f_GetDcodeAddress(BLT_B_ENQUEUE_TO_PROCESSOR,D_WorkDcodeAddr);
      break;
    case ENQUEUE_RESIDENT_TO_PROCESSOR:
      f_GetDcodeAddress(BLT_B_ENQUEUE_RESIDENT_TO_PROCESSOR,D_WorkDcodeAddr);
      break;
    case ENQUEUE_EMIGRANT_TO_CLUSTER:
      f_GetDcodeAddress(BLT_B_ENQUEUE_EMIGRANT_TO_CLUSTER,D_WorkDcodeAddr);
      break;
    case ENQUEUE_EMIGRANT_TO_PROCESSOR:
      f_GetDcodeAddress(BLT_B_ENQUEUE_EMIGRANT_TO_PROCESSOR,D_WorkDcodeAddr);
      break;
    default:
      @DEBUG{ VPIM_ERROR("i_Enqueue_Sub","illegal InstrID");};
  }
  b_IfEOL(A_Pragma) {  /* $B%W%i%0%^L5$7$N(BEnqueue$B7OL?Na(B */
    $CALL(f_DcodeEnqueue2Operand_Sub(D_WorkDcodeAddr,A_Goal,A_Code));
  } else {
    $CALL(f_DcodeEnqueue3Operand_Sub(D_WorkDcodeAddr,A_Goal,A_Code,A_Pragma));
  }
  $RELEASE(D_WorkDcodeAddr);
  $RETURN();
}

#SUBARG_define  A_InstrID   SRC
#SUBARG_define  A_Goal      SRC
#SUBARG_define  A_Code      SRC
#SUBARG_define  A_Pragma    SRC

#SUBROUTINE i_BodyBltEnqueue_Sub(A_InstrID,A_Goal,A_Code,A_Pragma)
{
  @DEBUG{
    f_IfTraceMode() {
      VPIM_ERROR("i_BodyBltEnqueue_Sub","can't be trace mode !!");
       /* $B%H%l!<%9%b!<%I$G$O(Benqueue$B7OL?Na$,%5%9%Z%s%I$9$k$3$H$O$J$$$O$:!#(B */
    }
    s_IfNotCOD(A_Code) {
      VPIM_ERROR("i_BodyBltEnqueue_Sub","illegal code data");
    }
    s_IfNotINT(A_Pragma) {
      b_IfNotEOL(A_Pragma) {  /* pragma $B$N$J$$L?Na(B */
        VPIM_ERROR("i_BodyBltEnqueue_Sub","illegal pragma data");
      }
    }
  };
  i_ExecEnqueue(A_InstrID,A_Goal,A_Code,A_Pragma);
  $RETURN();
}


#PSL_define i_ExecEnqueue(instr_id, goal, code, pragma)
{
  s_PutCodeGoalRecord(goal,code);
  ValueSwitch(instr_id){
    case ENQUEUE_WITH_PRIORITY:
    case BLT_B_ENQUEUE_WITH_PRIORITY:
      f_ChangePriorityGoalRecord(goal, pragma);
      @SPY{
        f_IfSpyMode(){
          f_IfSpiedGoal(goal){
	    b_SetImmTypeMRBoff(INT,instr_id);
	    $CALL(f_ReportSpyExceptionPrioGoal_Sub
				(instr_id,goal,pragma));
	    break;
          }
        }
      };
      $CALL(f_PushGoalToStackWithPriority_Sub(goal,pragma) );
      @DEBUG{ _PrintEnqueuedGoal(goal); };
      /* s_IncrementForkCounter(); $B4{$KA}$d$5$l$F$$$k(B */
      break;

    case ENQUEUE_TO_CLUSTER:
    case ENQUEUE_RESIDENT_TO_CLUSTER:
    case BLT_B_ENQUEUE_TO_CLUSTER:
    case BLT_B_ENQUEUE_RESIDENT_TO_CLUSTER:
      @SPY{
        f_IfSpyMode(){
	  f_IfSpiedGoal(goal){
	    b_SetImmTypeMRBoff(INT,instr_id);
	    $CALL(f_ReportSpyExceptionThrowGoalFamily_Sub
				(instr_id,goal,pragma));
          } else {
	    b_IfNotEqual(D_CL_Number,pragma) {
	      $CALL(f_SendGoalWithSpyMode_Sub(pragma,goal));
	    } else {	/* $B<+J,$N%/%i%9%?$N>l9g(B */
	      f_PushGoalToStack(goal);
	      /* s_IncrementForkCounter(); $B4{$KA}$d$5$l$F$$$k(B */
	    }
	  }
	  break;
        }
      };
      b_IfNotEqual( D_CL_Number,pragma) {
	s_IfNodeOutOfBounds(D_Current_FP_Ptr, pragma) {
	  @DEBUG{ VPIM_ERROR("i_ExecEnqueue","node is out of bounds"); };
	} else {
	  /* pragma $B$N%?%0$O!"$3$N(B throw_goal $B$,%5%9%Z%s%I$7$F$$$?(B
	     $B$b$N$G$O$J$$$3$H$r<($9$?$a$K!"(B INTo $B$r%;%C%H$9$k!#(B */
	  b_SetImmTypeMRBoff(INT, pragma);
	  $CALL( f_Send_IntClMsg_ThrowGoal_Sub
		                 (pragma, goal, D_Current_FP_Ptr) );
	  s_DecrementForkCounter();
	}
          /* Throw$B$5$l$?(Bgoal$B$NJ,(B */
      } else {	/* $B<+J,$N%/%i%9%?$N>l9g(B */
        f_PushGoalToStack(goal);
        @DEBUG{ _PrintEnqueuedGoal(goal); };
	/* s_IncrementForkCounter(); $B4{$KA}$d$5$l$F$$$k(B */
      }
      break;

    case ENQUEUE_TO_PROCESSOR:
    case ENQUEUE_RESIDENT_TO_PROCESSOR:
    case BLT_B_ENQUEUE_TO_PROCESSOR:
    case BLT_B_ENQUEUE_RESIDENT_TO_PROCESSOR:
      s_PutProcessorIdGoalRecord(goal,pragma);
      @SPY{
	f_IfSpyMode() {
	  f_IfSpiedGoal(goal) {
	    b_SetImmTypeMRBoff(INT,instr_id);
	    $CALL(f_ReportSpyExceptionThrowGoalFamily_Sub
				(instr_id,goal,pragma));
            break;
	  }
	}
      };
      /* s_IncrementForkCounter(); $B4{$KA}$d$5$l$F$$$k(B */
      b_IfEqual(pragma, D_PE_Number){	    /* $BF10l(BPE$B$N>l9g(B */
        f_PushGoalToStack(goal);
        @DEBUG{ _PrintEnqueuedGoal(goal); };
      }else{
	    /* ---------  Fork Counter $B$N%a%s%F%J%s%9(B --(BEGIN)--*/
        /* f_SelectGoalAndSendToPE_Sub in f_throw_goal_in_cluster.psl.c $B;2>H(B */
        s_IfForkCounterGTZero () {
	  $USE(D_WorkFPOrgLockTagReg);
	  s_LockFPRecord (D_Current_FP_Ptr, D_WorkFPOrgLockTagReg);
	  s_UpdateFPChildCount (D_Current_FP_Ptr);
	  @DEBUG{ /*-------------------------------------------------*/
	    p_IfLT() {
	      VPIM_ERROR("i_BodyBltEnqueue_Sub","ForkCout_UnderFlow");
	    }
	    p_IfEQ() {
	      VPIM_ERROR("i_BodyBltEnqueue_Sub","ForkCout_ZERO!!");
	    }
	  }; /*-------------------------------------------------------*/
	  s_UnlockFPRecord (D_Current_FP_Ptr, D_WorkFPOrgLockTagReg);
	  $RELEASE(D_WorkFPOrgLockTagReg);
	  s_SetZeroForkCounter ();
	}
	/* ---------  Fork Counter $B$N%a%s%F%J%s%9(B --(END)----*/

	f_SendGoalToPE_in_cluster(goal, pragma);
      }
      break;

    case ENQUEUE_EMIGRANT_TO_CLUSTER:
    case ENQUEUE_EMIGRANT_TO_PROCESSOR:
    case BLT_B_ENQUEUE_EMIGRANT_TO_CLUSTER:
    case BLT_B_ENQUEUE_EMIGRANT_TO_PROCESSOR:
    case ENQUEUE:
    case BLT_B_ENQUEUE:
                  /* VPIM$B$G$O(B klb_enqueue$B$N>l9g$@$1FCJL=hM}$9$k$N$GITMW$@$,(B  */
                  /* PIM/p$B$G$O!"%5%9%Z%s%I$9$k>l9gEy$K$O$3$N%k!<%A%s$r;H$&(B   */
      @SPY{
        f_IfSpyMode(){
	  f_IfSpiedGoal(goal){
	    b_SetImmTypeMRBoff(INT,instr_id);
	    $CALL(f_ReportSpyExceptionNormalGoal_Sub(instr_id,goal));
            break;
          }
        }
      };
      f_PushGoalToStack(goal);
      @DEBUG{ _PrintEnqueuedGoal(goal); };
      /* s_IncrementForkCounter(); $B4{$KA}$d$5$l$F$$$k(B */
      break;

    default:
      @DEBUG{VPIM_ERROR("i_ExecEnqueue","Illegal instr_id");};;
  }
}

/******************************************************************** PSL **
klb_set_caller_code_info Rgoal

       written by f-hataza@icot22      on Wed Dec  5 15:35:54 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |  set_caller_code_info |   Rgoal   | don't care|
    +-----------+-----------+-----------+-----------+

<Arguments>
    Rgoal : $B%4!<%k%l%3!<%I$r;X$9%]%$%s%?$r;}$D%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%l%8%9%?(BRgoal$B$G;XDj$5$l$k%4!<%k$N(B caller code info. $B$K$3$NL?Na$N0LCV$r(B
  Module $B$H(B offset $B$G3JG<$9$k!#(BKL1$B$G5-=R$7$?AH$_9~$_=R8l$r<B9TCf$KNc30$,(B
  $BH/@8$7$?>l9g$K!"8F$S=P$785$rFCDj$9$k$N$K;HMQ$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_RegGoalPtr  _IndirectRegField1
#OPF_define I_ImmRegGoalPtr _ImmediateField1

#PSL_define klb_set_caller_code_info()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegGoalPtr, _ZERO, _MAX_ARG_REG_OF_KLB ) {
       OUT_OF_SPEC( "klb_set_caller_code_info", "r1_range" );
    }
  };

  f_AttachCallerInfoGoalRecord(I_RegGoalPtr);
}
