
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V10/interpreter/klb_floating_point.psl.c
   ----- CREATED   : by yamamoto@icot22, on Mon Aug  5 21:54:53 1991
   ----- LAST SAVED: by yamamoto@icot22, on Wed Oct  2 11:09:09 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
$B%f%K%U%#%1!<%7%g%s(B
klb_fpu_equal

       written by yamamoto@icot22      on Wed Oct  2 11:02:24 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>

   klb_fpu_equal $B$OAH9~=R8l$N(B klb_floating_point_equal $B$H0c$C$F!"(B
   $B%f%K%U%#%1!<%7%g%s$H$7$F$N%Q%?%s%^%C%A%s%0$N%F%9%H$r9T$J$&!#(B
   $BJ,N`$H$7$F$O!"(Bklb_compare.psl.c $B$N(B klb_equal $B$NCg4V$G$"$k$,!"(B
   $B0z?t$H$7$F(B FPU $B%l%8%9%?$rMQ$$$k$N$G$3$3$KF~$l$F$"$k!#(B

   $B6qBNE*$K$O!"(B

  f(X,Y):- Y $=:= X + 1 | .... $B$G$O(B
  klb_floating_point_equal $B$,8F$S=P$5$l$F!"$3$N$H$-$O(B
  $B$?$H$($P!"(B+0 $B$H(B -0 $B$O%$%3!<%k$G$"$k!#(B

  $B0lJ}(B

  f(X,Y):- Y $:= X + 1 | .... $B$G$O(B
  klb_fpu_equal $B$,8F$S=P$5$l$F!"$3$N$H$-$O(B
  $B$?$H$($P!"(B+0 $B$H(B -0 $B$O0[$J$k%Q%?%s$G$"$k!#(B

********************************************************************* PSL **/

#OPF_define I_FPURegSrc1 _IndirectRegField1
#OPF_define I_FPURegSrc2 _IndirectRegField2
#OPF_define I_ImmLfail   _ImmediateField3

#OPF_define I_ImmFPURegSrc1 _ImmediateField1
#OPF_define I_ImmFPURegSrc2 _ImmediateField2

#PSL_define klb_fpu_equal(){
  @DEBUG{
    b_IfFPURegRangeErr(I_ImmFPURegSrc1){
      OUT_OF_SPEC("kblt_floating_point_add","r1_range");
    }
    b_IfFPURegRangeErr(I_ImmFPURegSrc2){
      OUT_OF_SPEC("kblt_floating_point_add","r2_range");
    }
  };
  p_FLT_Pattern_Compare(I_FPURegSrc1, I_FPURegSrc2);
  p_If_FLT_NE(){
    s_SetKLB_PC_OPR(I_ImmLfail);
  }
}
/******************************************************************** PSL **
FPU$B%l%8%9%?$H(BKL1$B0z?t4V$N%G!<%?E>Aw(B

$B!}(B klb_move_to_fpu
$B!}(B klb_move_from_fpu

       written by yamamoto@icot22      on Wed Oct  2 11:03:01 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/


#OPF_define I_RegSrc       _IndirectRegField1
#OPF_define I_FPURegDst    _IndirectRegField2

#OPF_define I_ImmRegSrc    _ImmediateField1
#OPF_define I_ImmFPURegDst _ImmediateField2

#PSL_define klb_move_to_fpu(){
  @DEBUG {
    b_IfRangeErr(I_ImmRegSrc, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_move_to_fpu", "r1 range");
    }
    b_IfFPURegRangeErr(I_ImmFPURegDst) {
      OUT_OF_SPEC ("klb_move_to_fpu", "r2 range");
    }
    s_IfNotFLT(I_RegSrc) {
      VPIM_ERROR("klb_move_to_fpu","Illegal_type");
    }
  };
  s_FPURegReadDoubleWord(I_RegSrc,I_FPURegDst);
}

#OPF_define I_FPURegSrc    _IndirectRegField1
#OPF_define I_RegDst       _IndirectRegField2

#OPF_define I_ImmFPURegSrc _ImmediateField1
#OPF_define I_ImmRegDst    _ImmediateField2

#PSL_define klb_move_from_fpu(){
  @DEBUG {
    b_IfFPURegRangeErr(I_ImmFPURegSrc) {
      OUT_OF_SPEC ("klb_move_from_fpu", "r1 range");
    }
    b_IfRangeErr(I_ImmRegDst, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_move_from_fpu", "r2 range");
    }
    s_IfNotFLT(I_RegDst) {
      VPIM_ERROR("klb_move_float_fpu","Illegal_type");
    }
  };
  s_FPURegWriteDoubleWord(I_FPURegSrc,I_RegDst);
}
/******************************************************************** PSL **
FPU$B%l%8%9%?$N(BSave/Restore

$B!}(B klb_save_fpu
$B!}(B klb_restore_fpu

       written by yamamoto@icot22      on Wed Oct  2 11:03:56 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>

 FPU$B%l%8%9%?$N(BSave/Restore$B$O!"0z?t%l%8%9%?$NB`HrNN0h$r6&MQ$7$F$$$k!#(B
 $B>WFM$N2sHr$O#K#L#1%3%s%Q%$%i!J%]%9%H%3%s%Q%$%i!K$N@UG$(B             
 $BFs$D$NNN0h$KJ,$1$F$7$^$&$N$,4JC1!#(B                                 
 $B=hM}7O$O!";XDj0LCV$NO"B3$7$?#2%o!<%I$r;HMQ$9$k(B                     
 $B;XDj0LCV$,4q?t$G$O$$$1$J$$!J%A%'%C%/$7$F$J$$$1$I!K!#(B               

 $B8=:_(B(91-10-03)$B$O(B
 $B#V#P#I#M$G$O!"#P#E%m!<%+%k$K!"(B
 $B0z?t%l%8%9%?$NB`HrNN0h#2#5#6%o!<%I$rMQ0U$7$F$"$j!"(B
 $B#0!A#1#2#7$r%4!<%k0z?t%l%8%9%?$NB`HrMQ$K!"(B
 $B#1#2#8!A#2#5#5$r#2%o!<%IAH$_$K$7$F(BFPU$B%l%8%9%?MQ$NB`HrMQ$K;H$C$F$$$k!#(B

********************************************************************* PSL **/

#OPF_define I_FPURegSrc    _IndirectRegField1
#OPF_define I_ImmPos       _ImmediateField2

#OPF_define I_ImmFPURegSrc _ImmediateField1

#PSL_define klb_save_fpu(){
  @DEBUG {
    b_IfFPURegRangeErr(I_ImmFPURegSrc) {
      OUT_OF_SPEC ("klb_save_fpu", "r1 range");
    }
  };
  s_SaveFPURegOPR(I_FPURegSrc,I_ImmPos);
}

#OPF_define I_ImmPos       _ImmediateField1
#OPF_define I_FPURegDst    _IndirectRegField2

#OPF_define I_ImmFPURegDst _ImmediateField2

#PSL_define klb_restore_fpu(){
  @DEBUG {
    b_IfFPURegRangeErr(I_ImmFPURegDst) {
      OUT_OF_SPEC ("klb_restore_fpu", "r2 range");
    }
  };
  s_RestoreFPURegOPR(I_ImmPos,I_FPURegDst);
}
/******************************************************************** PSL **
FLT$BDj?t$N@_Dj!#(B

$B!}(B klb_put_floating_point

       written by yamamoto@icot22      on Wed Oct  2 11:05:55 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>

FLT$BDj?t$rD>@\%*%Z%i%s%I$H$7$F;}$D$N$O$N%,!<%IMQ$N(B
klb_put_floating_point $B$N$_!#(B

$B%\%G%#$N(BFLT$BDj?t$O!"9=B$BNDj?t$K$J$k!#(B
$B%3%s%Q%$%i$,(BGC$BNN0h$+$iFI$_9~$`L?Na(B(read_cst)$B$r=P$9!#(B

<ETC>
********************************************************************* PSL **/
#OPF_define I_FLTMSWord _ImmediateField1
#OPF_define I_FLTLSWord _ImmediateField2
#OPF_define I_FPURegDst _IndirectRegField3

#OPF_define I_ImmFPURegDst _ImmediateField3

#PSL_define klb_put_floating_point(){
  @DEBUG {
    b_IfFPURegRangeErr(I_ImmFPURegDst) {
      OUT_OF_SPEC ("klb_put_floating_point", "r3 range");
    }
  };
  s_FPURegPutConstant(I_FLTMSWord,I_FLTLSWord,I_FPURegDst);
}

/******************************************************************** PSL **
$B#K#L#10z?tMQIbF0>.?tE@%G!<%?$N3dEv!"2s<}!":FMxMQ(B

$B!}(B klb_alloc_floating_point
$B!}(B klb_collect_floating_point
$B!}(B klb_reuse_floating_point

       written by yamamoto@icot22      on Wed Oct  2 11:06:25 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_RegDest     _IndirectRegField1
#OPF_define I_ImmRegDest  _ImmediateField1

#PSL_define klb_alloc_floating_point(){
  @DEBUG {
    b_IfRangeErr(I_ImmRegDest, _ZERO ,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_alloc_floating_point", "r1 range");
    }
  };
  s_AllocFLT(I_RegDest);
}

#OPF_define I_RegSource1  _IndirectRegField1
#OPF_define I_ImmRegSource1 _ImmediateField1

#PSL_define klb_collect_floating_point(){
  @DEBUG {
    b_IfRangeErr(I_ImmRegSource1, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_collect_floating_point", "r1 range");
    }
    s_IfNotFLT(I_RegSource1) {
      VPIM_ERROR("klb_collect_floating","Illegal_type");
    }
  };
  s_IfMRBoff(I_RegSource1) { s_ReclaimFLT(I_RegSource1);} 
}

/* FLT <-> LIST$B!"(BFLT <-> VECT2 $B$NMM$J%j%f!<%9$O:n$C$F$J$$!#(B*/
/* LIST <-> VECT2 $B$O$d$C$F$k!#(B*/
#OPF_define  I_RegSource    _IndirectRegField1
#OPF_define  I_ImmRegSource _ImmediateField1

#PSL_define klb_reuse_floating_point(){
  @DEBUG {
    b_IfRangeErr(I_ImmRegSource, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_reuse_floating_point", "r1 range");
    }
    s_IfNotFLT(I_RegSource){
      VPIM_ERROR("klb_reuse_floating_point","Illegal_reuse_type");
    }
  };
  s_IfMRBon(I_RegSource){
    s_AllocFLT(I_RegSource);
  }
}
