
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V10/interpreter/klb_debug.psl.c
   ----- CREATED   : by yamamoto@icot22, on Sat Jun  9 18:47:00 1990
   ----- LAST SAVED: by yamamoto@icot22, on Sat Aug  3 17:57:31 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : INTERPRETER
   ----- ABSTRACT  : V10$B$G$O%5%]!<%H$5$l$F$$$J$$AH$_9~$_=R8l!J%G%P%C%0MQ!K(B

kblt_request_gc
kblt_b_consume_resource
kblt_b_current_priority
test_get_type_and_mrb
test_read

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **

       written by ymiyazak@icot22      Fri Jan  6 18:15:37 1989
       revised by imai@icot22      on Tue Feb 20 15:45:44 1990

request_gc

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |      request_gc       | don't care| don't care|
    |                       |           |           |
    +-----------+-----------+-----------+-----------+

<Arguments>
	$B$J$7(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
<Revised Memo on "Feb 20">
$B!&(BA1 $B$,L$Dj5A$J$i!"$=$l$r%5%9%Z%s%7%g%s%9%?%C%/$K@Q$_!"<!8uJd%"%I%l%9$XJ,4t(B
$B!&$=$l0J30$O!"%R!<%WNN0h$N(B GC $B%U%i%0$r(B OFF $B$K$7!"<!L?Na$X(B

--> $BL50z?t$K(B
********************************************************************* PSL **/


#PSL_define  kblt_request_gc()
{
  b_SetEventFlag (_PAGE_ALLOC_FAIL_EVENT, D_PE_Number); 
                                         /*  Set Slit-checking Event */
  @DEBUG{WARNING("kblt_request_gc","Local-GC requested!");};
}



#PSL_define  kblt_b_consume_resource()

{
  @DEBUG{ OUT_OF_SPEC("--", "not supported in V1.0");};
}

/******************************************************************** PSL **
test_get_type_and_mrb Reg, Rtype, Rmrb ($B%G%P%C%0MQ(B)

       written by f-doumae@icot21      on Fri Feb 16 15:03:24 1990

<Arguments>
    Reg    : $B%l%8%9%?(B($B%]%$%s%?(B)
    Rtype  : Reg$B$N%G!<%?$N%?%$%W(B($B@0?tCM(B)
    Rmrb   : Reg$B$N%G!<%?$N(BMRB($B@0?tCM(B)

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
   Reg$B$N%G!<%?$N%?%$%W$H(BMRB$B$r@0?tCM$H$7$F(B Rtype, Rmrb $B$KJV$9!#(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_RegSource  _IndirectRegField1
#OPF_define I_RegType    _IndirectRegField2
#OPF_define I_RegMRB     _IndirectRegField3

#OPF_define I_ImmRegSource  _ImmediateField1
#OPF_define I_ImmRegType    _ImmediateField2
#OPF_define I_ImmRegMRB     _ImmediateField3

#PSL_define  test_get_type_and_mrb()
{
  @DEBUG{
    b_IfRangeErr(I_ImmRegSource, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("test_get_type_and_mrb", "r1 range");
    }
    b_IfRangeErr(I_ImmRegType, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("test_get_type_and_mrb", "r2 range");
    }
    b_IfRangeErr(I_ImmRegMRB, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("test_get_type_and_mrb", "r3 range");
    }
  };
  p_MoveTypeToValue(I_RegSource, I_RegType);
  b_SetImmTypeMRBoff(INT, I_RegType);
  s_IfMRBon(I_RegSource){
    p_MoveWord(D_ONE, I_RegMRB);
  } else {
    p_MoveWord(D_NULL, I_RegMRB);
  }
  b_SetImmTypeMRBoff(INT, I_RegMRB);
}


/******************************************************************** PSL **
test_read  Reg, Rdata

       written by f-doumae@icot21      on Fri Feb 16 15:27:53 1990
<Arguments>
    Reg     : $B%l%8%9%?(B($B%]%$%s%?(B)
    imm_pos : $B%]%8%7%g%s(B
    Rdata   : Reg $B$N@h$N%G!<%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
   Reg $B$N@h$N%G!<%?$N(Bimm_pos$BHVL\$r(BMRB$B$r(BOR$B$;$:$K$=$N$^$^FI$_9~$_!"(BRdata $B$KJV$9!#(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_RegSource _IndirectRegField1
#OPF_define I_ImmPos    _ImmediateField2
#OPF_define I_RegData   _IndirectRegField3

#OPF_define I_ImmRegSource _ImmediateField1
#OPF_define I_ImmRegData   _ImmediateField3

#PSL_define  test_read()
{
  @DEBUG{
    b_IfRangeErr(I_ImmRegSource, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("test_read", "r1 range");
    }
    b_IfRangeErr(I_ImmRegData, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("test_read", "r3 range");
    }
  };
  p_ReadWithOffsetOPR(I_RegSource, I_ImmPos, I_RegData);
}

/******************************************************************** PSL **

       written by yamamoto@icot22      on Tue Jul  3 17:01:42 1990

$B0J2<$N(B 

	#PSL_define kblt_b_vpim_atom_name(){

$B$H(B 

	#PSL_define kblt_b_vpim_intern_atom(){

$B$H$O!"#P#I#M#O#S$N%5%]!<%H$,$J$$4V$N2>$NAH$_9~$_$G$"$k!#(B
$B#P#I#M!?#s>e$G%3%s%Q%$%i$rAv$i$;$k;~$K;H$C$?$j$7$F$$$k$h!#(B

********************************************************************* PSL **/
/******************************************************************** PSL **

       written by nakase@icot22      on Thu Mar 29 18:22:19 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkStringLen XXX
#DATA_define D_WorkStringSize XXX


#OPF_define I_Atom      _IndirectRegField1 /* imput */
#OPF_define I_String    _IndirectRegField2 /* output */

#PSL_define kblt_b_vpim_atom_name(){
  $USE(D_Workreg1);

  f_ActiveDeref(I_Atom, D_Workreg1);
  @DEBUG{s_IfNotATOM(I_Atom){VPIM_ERROR("kblt_b_atom_name","invalid arg1");}};
  $RELEASE(D_Workreg1);

  $USE(D_WorkStringLen);
  $USE(D_WorkStringSize);

  atom_name(I_Atom,I_String, D_WorkStringLen, D_WorkStringSize); 

  b_SetImmTypeMRBoff(STRG, I_String);
  $RELEASE(D_WorkStringSize);
  $RELEASE(D_WorkStringLen);
  @DEBUG{s_IfNotSTRG(I_String){VPIM_ERROR("kblt_b_atom_name","invalid arg2");}};
}

/******************************************************************** PSL **

       written by nakase@icot22      on Thu Mar 29 18:24:10 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_Atom      _IndirectRegField1 /* output */
#OPF_define I_String    _IndirectRegField2 /* input */

#PSL_define kblt_b_vpim_intern_atom(){
  $USE(D_Workreg1);

  f_ActiveDeref(I_String, D_Workreg1);

  @DEBUG{s_IfNotSTRG(I_String){VPIM_ERROR("kblt_b_vpim_intern_atom","invalid arg2");}};
  $RELEASE(D_Workreg1);

  intern_atom(I_Atom,I_String); 

  b_SetImmTypeMRBoff(ATOM, I_Atom);
  @DEBUG{s_IfNotATOM(I_Atom){VPIM_ERROR("kblt_b_vpim_intern_atom","invalid arg1");}};
}

/******************************************************************** PSL **
kblt_halt 
       written by pim@icot22      on Fri Mar 24 17:05:55 1989
       revised by imai@icot22      on Sat Feb 17 12:10:43 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
  $B%,!<%IAH$_9~$_=R8l(B
  $B%3%s%Q%$%i$,(B wait $B7O$NL?Na$r=P$9$N$GBT$?$:$K<B9T$G$-$k!#(B
<Function>
<Examples>
<Test>
<Explanation>
  $B$3$NAH$_9~$_=R8l$O(B, PIM/s $B$K$*$$$F(Bidle $B$K$J$C$?A4(BPE $B$r;_$a$k$?$a(B
  $B$K;H$o$l$k!#0z?t$O(B INT 0 $B!#(B

  $B<B5!$G$O0z?t$K1~$8$F=hM}FbMF$,JQ$o$C$FNI$$!#(B
  $B0lHL$K$O!"(BKL1$B=hM}7O$NF0:n$rDd;_$7!"(BSVP$BB&$K@)8f$r0\$9!#(B
  SVP$B$N;X<($K$h$j:F3+$b$"$j$&$k!#(B

<ETC>
<Revised Memo on "Feb 17">
  $BB>$N%/%i%9%?$rDd;_$5$;$k$?$a$K!"(B_NW_PIMS_SHUTDOWN $B%a%C%;!<%8$rAw$k(B
*********************************************************************PSL **/

#OPF_define I_HaltCode _IndirectRegField1

#PSL_define  kblt_halt()
{

@DEBUG{
  WARNING("kblt_halt","kblt_halt is called");
  _PrintHaltCode(I_HaltCode);
};
  $USE(D_WorkCLNum);
  b_ReadClusterNumInSystem(D_WorkCLNum);
  b_DecrementReg(D_WorkCLNum);
  LOOP() {
    $CALL(f_Send_IntClMsg_PIMs_Shutdown_Sub(D_WorkCLNum));
    b_DecrementReg(D_WorkCLNum);
    p_IfLT() { break; }
  }
  $RELEASE(D_WorkCLNum);
}

#PSL_define  kblt_b_pims_shut_down()
{
  _TerminateProcessor();
}

