
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/interpreter/klb_control.psl.c
   ----- CREATED   : by f-doumae@icot22, on Tue May 22 13:49:27 1990
   ----- LAST SAVED: by imai@icot22, on Thu Jun 18 20:05:57 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : interpreter
   ----- ABSTRACT  : 

klb_proceed ()
klb_execute (code, arity)
klb_execute_self (Lpred, arity)
klb_suspend (Lpred, arity)
klb_suspend_single (Reg, Lpred, arity)
klb_fail (Lpred, arity)
klb_otherwise (Lpred, arity)
klb_alternatively ()
klb_jump (Label)

kblt_idle ()
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
klb_proceed

       written by f-doumae@icot22      on Tue May 22 13:58:33 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |        proceed        |       don't care      |
    +-----------+-----------+-----------+-----------+

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B!&%j%@%/%7%g%s?t$N%+%&%s%H$r$9$k!#(B
  $B!&%9%j%C%H%A%'%C%/%U%i%0$r8!::$7!"%9%j%C%H%A%'%C%/%$%Y%s%H$,(B
    $BH/@8$7$F$$$?$i!"%9%j%C%H%A%'%C%/%O%s%I%i$r8F$S=P$9!#(B
  $B!&%4!<%k$r%G%-%e!<$7!"<B9T$9$k!#(B
<Examples>
<Test>
<Explanation>
  $B!&%j%@%/%7%g%s$N@Z$lL\$G$"$k!#(B
    - $B%j%=!<%9>CHq(B
    - $B%j%=!<%9ITB-$N%A%'%C%/(B
  $B!&%9%j%C%H%A%'%C%/=hM}$,8F$S=P$5$l$k%?%$%_%s%0$G$"$k!#(B
  $B!&(BPE$B$N(BD_Fork_Ctr $B$r%G%/%j%a%s%H$7(B, $B<!$K<B9T$9$Y$-%4!<%k$r%4!<%k%9%?%C%/$+$i(B
    $B%G%-%e!<$9$k(B.
<ETC>
  !!$BCm0U(B!!
  $B?7%3%s%Q%$%i$G$O(B0$BHV%l%8%9%?(B($B%,!<%I$G$O(BCGP)$B$r%\%G%#$G$OHFMQ%l%8%9%?$H(B
  $B$7$F;}$A$$$k$?$a!"%^%/%m$N@hF,$G(BNULL$B$K=i4|2=$7$F$$$k!#(B
********************************************************************* PSL **/
#PSL_define klb_proceed()
{
  @TRACE{
    f_IfTraceMode() {
      $CALL(f_ReportTraceException_Sub());
    }
  };
  f_MakeEmptyCGP(D_ArgReg0);
  f_Consume();
  s_DecrementForkCounter();
  f_IfEventHappen() {
    $CALL( f_SlitCheck_Sub() );
  }
  $CALL( i_DequeueNewGoal_Sub() );
  @PROBE2{ probe_load_if_reg_base(); };
  $USE( D_WorkCodeAddress );
  s_GetCodeGoalRecord( D_ArgReg0, D_WorkCodeAddress );
  s_SetKLB_PC( D_WorkCodeAddress );
  $RELEASE( D_WorkCodeAddress );

  @MONITOR{ _pims_monitor(); };
  @PIMS_TRACE_SPY{ _predicate_trace(); };
  @MONITOR{ _reduction_started(); };
  @PROBE{ _predicate_trade_trace(); };
}

/******************************************************************** PSL **
klb_execute code, arity

       written by f-doumae@icot22      on Tue May 22 14:05:41 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |        execute        |   code    |  arity    |
    +-----------+-----------+-----------+-----------+
<Arguments>
    code  : $B=R8l%3!<%I$X$N%]%$%s%?(B($B%l%8%9%?(B)
    arity  : $B=R8l$N0z?t8D?t(B($BB(CM(B)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B!&%j%=!<%9>CHq$H%j%=!<%9ITB-$r%A%'%C%/$9$k(B.
  $B!&%9%j%C%H%A%'%C%/%U%i%0$r8!::$9$k!#(B
    - $B%9%j%C%H%A%'%C%/%$%Y%s%H$,H/@8$7$F$$$?>l9g(B
       CGP$B%l%8%9%?$,;X$9%4!<%k%l%3!<%I$r%4!<%k%9%?%C%/$K%(%s%-%e!<$7$F!"(B
       $B%9%j%C%H%A%'%C%/%O%s%I%i$r8F$S=P$9!#(B
    - $B%9%j%C%H%A%'%C%/%$%Y%s%H$,H/@8$7$F$$$J$+$C$?>l9g(B
       CGP$B%l%8%9%?$G;XDj$5$l$?%4!<%k$r<B9T$9$k!#(B
<Examples>
<Test>
<Explanation>
   execute$B7OL?Na$GKh2s@_Dj$7$F$$$k$H%*!<%P!<%X%C%I$,Bg$-$$$N$G%"%j%F%#$H(B
   $B%3!<%I$X$N%]%$%s%?$O%9%j%C%H%A%'%C%/%$%Y%s%H$,H/@8$7$F%R!<%W$K(B
   $B7R$2$i$l$k:]$K%4!<%k%l%3!<%I$K=q$-9~$`!#(B
<ETC>
********************************************************************* PSL **/
#OPF_define I_RegCode        _IndirectRegField1
#OPF_define I_ImmArity       _ImmediateField2

#PSL_define klb_execute() 
{
  @TRACE{ /* enqueue & proceed $B$N=hM}(B */
    f_IfTraceMode() {
      s_PutArityGoalRecordOPR(D_ArgReg0, I_ImmArity); 
      s_PutCodeGoalRecord(D_ArgReg0, I_RegCode);
      f_TraceNormalGoal( EXECUTE, D_ArgReg0, I_RegCode );
      $CALL(f_ReportTraceException_Sub());
      f_MakeEmptyCGP(D_ArgReg0);
      f_Consume();
      s_DecrementForkCounter();
      f_IfEventHappen() {
	$CALL( f_SlitCheck_Sub() );
      }
      $CALL( i_DequeueNewGoal_Sub() );
      @PROBE2{ probe_load_if_reg_base(); };
      $USE( D_WorkCodeAddress );
      s_GetCodeGoalRecord( D_ArgReg0, D_WorkCodeAddress );
      s_SetKLB_PC( D_WorkCodeAddress );
      $RELEASE( D_WorkCodeAddress );
      @MONITOR{ _pims_monitor(); };
      @PIMS_TRACE_SPY{ _predicate_trace(); };
      @MONITOR{ _reduction_started(); };
      @PROBE{ _predicate_trade_trace(); };
      goto End_of_KL1B_Instruction;
    }
  };
  @SPY{
    f_IfSpyMode() {
      s_PutArityGoalRecordOPR(D_ArgReg0, I_ImmArity); 
      s_PutCodeGoalRecord(D_ArgReg0, I_RegCode);
      f_IfSpiedGoal( D_ArgReg0 ) {
	f_ReportSpyExceptionNormalGoal( EXECUTE, D_ArgReg0 );
	f_MakeEmptyCGP(D_ArgReg0);
	f_Consume();
	s_DecrementForkCounter();
	f_IfEventHappen() {
	  $CALL( f_SlitCheck_Sub() );
	}
	$CALL( i_DequeueNewGoal_Sub() );
	@PROBE2{ probe_load_if_reg_base(); };
	$USE( D_WorkCodeAddress );
	s_GetCodeGoalRecord( D_ArgReg0, D_WorkCodeAddress );
	s_SetKLB_PC( D_WorkCodeAddress );
	$RELEASE( D_WorkCodeAddress );
	@MONITOR{ _pims_monitor(); };
	@PIMS_TRACE_SPY{ _predicate_trace(); };
	@MONITOR{ _reduction_started(); };
	@PROBE{ _predicate_trade_trace(); };
	goto End_of_KL1B_Instruction;
      }
    }
  };

  f_Consume();
  $USE(D_WorkDerefPtr);
  /* $BK\Mh(BCOD$B$G$J$1$l$P%G%l%U$9$k$h$&$K$9$k$HB.$$$O$:$@$,!"(B... */
  f_ActiveDeref(I_RegCode,D_WorkDerefPtr);
  s_IfCOD(I_RegCode) {
    $RELEASE(D_WorkDerefPtr);
    f_IfEventHappen() {
      @PROBE2{ probe_store_if_reg_base(); };
      s_PutArityGoalRecordOPR(D_ArgReg0, I_ImmArity); 
      s_PutCodeGoalRecord(D_ArgReg0, I_RegCode);
      $CALL ( f_SlitCheck_Sub () );
      f_IfEmptyCGP (D_ArgReg0) {
        $CALL ( i_DequeueNewGoal_Sub() );  
        s_GetCodeGoalRecord(D_ArgReg0, I_RegCode);
        /* $B$3$3$G(B I_RegCode $B$NFbMF$rGK2u$9$k$,Bg>fIW$N$O$:(B */
      }else{
	f_IfSHProfModeOn(){
	  $CALL(f_FPIncrementDequeueCountProfilingEntry_Sub(I_RegCode,
						      D_CurrentEnvRecPtr));
	}
      }
      @PROBE2{ probe_load_if_reg_base(); };
    }else{
      f_IfSHProfModeOn(){
	$CALL(f_FPIncrementDequeueCountProfilingEntry_Sub(I_RegCode,
							  D_CurrentEnvRecPtr));
      }
    }
  } else {
    /* I_RegCode $B$,(B UNDF $B$@$C$?$i(B apply $B$r%5%9%Z%s%I$5$;$k(B */
    @DEBUG{ s_IfNotUnbound(I_RegCode) {
        VPIM_ERROR("klb_execute","illegal code data");
    } };
    @PROBE2{ probe_store_if_reg_base(); };
    s_PutArityGoalRecordOPR( D_ArgReg0, I_ImmArity ); 
    /*-------------------------------------------------------------
      $B%"%j%F%#$r=q$-9~$s$G$$$k$N$O(Bf_DcodeEnqueueExternalCall_Sub $B$N$J$+$G(B
      D_ArgReg0$B$+$iFI$_=P$7$F$$$k$?$a!#(B ==> $B8!F$(B                          
    ---------------------------------------------------------------*/
    $CALL( f_DcodeEnqueueExternalCall_Sub(D_WorkDerefPtr, D_ArgReg0 ) );
    $RELEASE(D_WorkDerefPtr);
    /*-------------------------------------------------------------
      f_DcodeEnqueueExternalCall $B$G$O(BD$B%3!<%I%4!<%k$r:n$k;~$K(BForkCount$B$r(B
      $B%$%s%/%j%a%s%H$7$F$$$k!#(B
    ---------------------------------------------------------------*/
    s_ReclaimGoalRecord( D_ArgReg0 );
    f_MakeEmptyCGP( D_ArgReg0 );
    s_DecrementForkCounter(); 
    f_IfEventHappen() {
      $CALL ( f_SlitCheck_Sub () );
    }
    $CALL ( i_DequeueNewGoal_Sub() );
    @PROBE2{ probe_load_if_reg_base(); };
    s_GetCodeGoalRecord(D_ArgReg0, I_RegCode);
  }
  s_SetKLB_PC(I_RegCode);
  @MONITOR{ _pims_monitor(); };
  @PIMS_TRACE_SPY{ _predicate_trace(); };
  @MONITOR{ _reduction_started(); };
  @PROBE{ _predicate_trade_trace(); };
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
klb_execute_self Lpred, arity

       written by f-hataza@icot22      on Mon Dec  3 23:02:52 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |     execute_self      |         Lpred         |
    +-----------+-----------+-----------+-----------+
    |    arity  |             don't care            |
    +-----------+-----------+-----------+-----------+
<Arguments>
    Lpred  : $B=R8l%3!<%I$X$N(BPC$BAjBP%i%Y%k(B($BB(CM(B:$BId9fIU$-@0?t(B)
    arity  : $B=R8l$N0z?t8D?t(B($BB(CM(B)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B!&%j%=!<%9>CHq$H%j%=!<%9ITB-$r%A%'%C%/$9$k(B.
  $B!&%9%j%C%H%A%'%C%/%U%i%0$r8!::$9$k!#(B
    - $B%9%j%C%H%A%'%C%/%$%Y%s%H$,H/@8$7$F$$$?>l9g(B
       CGP$B%l%8%9%?$,;X$9%4!<%k%l%3!<%I$r%4!<%k%9%?%C%/$K%(%s%-%e!<$7$F!"(B
       $B%9%j%C%H%A%'%C%/%O%s%I%i$r8F$S=P$9!#(B
    - $B%9%j%C%H%A%'%C%/%$%Y%s%H$,H/@8$7$F$$$J$+$C$?>l9g(B
       CGP$B%l%8%9%?$G;XDj$5$l$?%4!<%k$r<B9T$9$k!#(B
<Examples>
<Test>
<Explanation>
   get_code + execute $B$N9bB.2=HG!#(B
<ETC>
********************************************************************* PSL **/
#OPF_define I_ImmLpred       _ImmediateField1
#OPF_define I_ImmArity       _ImmediateField2

#PSL_define klb_execute_self() 
{
  @TRACE{ /* enqueue & proceed $B$N=hM}(B */
    f_IfTraceMode() {
      s_PutArityGoalRecordOPR(D_ArgReg0, I_ImmArity); 
      $USE(D_WorkCodeAddress);
      s_GetKLB_Address_OPR( I_ImmLpred, D_WorkCodeAddress );
      s_PutCodeGoalRecord( D_ArgReg0, D_WorkCodeAddress );
      f_TraceNormalGoal( EXECUTE_SELF, D_ArgReg0, D_WorkCodeAddress );
      $RELEASE(D_WorkCodeAddress);
      $CALL( f_ReportTraceException_Sub() );
      f_MakeEmptyCGP(D_ArgReg0);
      f_Consume();
      s_DecrementForkCounter();
      f_IfEventHappen() {
	$CALL( f_SlitCheck_Sub() );
      }
      $CALL( i_DequeueNewGoal_Sub() );
      /* @PROBE2{ probe_load_if_reg_base(); }; */
      $USE( D_WorkCodeAddress );
      s_GetCodeGoalRecord( D_ArgReg0, D_WorkCodeAddress );
      s_SetKLB_PC( D_WorkCodeAddress );
      $RELEASE( D_WorkCodeAddress );
      @MONITOR{ _pims_monitor(); };
      @PIMS_TRACE_SPY{ _predicate_trace(); };
      @MONITOR{ _reduction_started(); };
      @PROBE{ _predicate_trade_trace(); };
      goto End_of_KL1B_Instruction;
    }
  };

  @SPY{
    f_IfSpyMode() {
      $USE(D_WorkCodeAddress);
      s_GetKLB_Address_OPR( I_ImmLpred, D_WorkCodeAddress );
      s_PutCodeGoalRecord( D_ArgReg0, D_WorkCodeAddress );
      $RELEASE(D_WorkCodeAddress);
      s_PutArityGoalRecordOPR(D_ArgReg0, I_ImmArity); 
      f_IfSpiedGoal( D_ArgReg0 ) {
	f_ReportSpyExceptionNormalGoal( EXECUTE_SELF, D_ArgReg0 );
	f_MakeEmptyCGP(D_ArgReg0);
	f_Consume();
	s_DecrementForkCounter();
	f_IfEventHappen() {
	  $CALL( f_SlitCheck_Sub() );
	}
	$CALL( i_DequeueNewGoal_Sub() );
	@PROBE2{ probe_load_if_reg_base(); };
	$USE( D_WorkCodeAddress );
	s_GetCodeGoalRecord( D_ArgReg0, D_WorkCodeAddress );
	s_SetKLB_PC( D_WorkCodeAddress );
	$RELEASE( D_WorkCodeAddress );
	@MONITOR{ _pims_monitor(); };
	@PIMS_TRACE_SPY{ _predicate_trace(); };
	@MONITOR{ _reduction_started(); };
	@PROBE{ _predicate_trade_trace(); };
	goto End_of_KL1B_Instruction;
      }
    }
  };

  f_Consume();

  f_IfEventHappen() {
    @PROBE2{ probe_store_if_reg_base(); };
    s_PutArityGoalRecordOPR(D_ArgReg0, I_ImmArity); 
    $USE(D_WorkCodeAddress);
    s_GetKLB_Address_OPR(I_ImmLpred, D_WorkCodeAddress);
    s_PutCodeGoalRecord(D_ArgReg0, D_WorkCodeAddress);

    $CALL ( f_SlitCheck_Sub () );
    f_IfEmptyCGP (D_ArgReg0) {
      $CALL ( i_DequeueNewGoal_Sub() );  
      s_GetCodeGoalRecord(D_ArgReg0, D_WorkCodeAddress);
    }else{
      f_IfSHProfModeOn(){
	$CALL(f_FPIncrementDequeueCountProfilingEntry_Sub(D_WorkCodeAddress,
							  D_CurrentEnvRecPtr));
      }
    }
    s_SetKLB_PC(D_WorkCodeAddress);
    $RELEASE(D_WorkCodeAddress);
    @PROBE2{ probe_load_if_reg_base(); };
  } else {
    f_IfSHProfModeOn(){
      $USE(D_WorkCodeAddress);
      s_GetKLB_Address_OPR(I_ImmLpred, D_WorkCodeAddress);
      $CALL(f_FPIncrementDequeueCountProfilingEntry_Sub(D_WorkCodeAddress,
							D_CurrentEnvRecPtr));
      $RELEASE(D_WorkCodeAddress);
    }
    s_SetKLB_PC_OPR(I_ImmLpred);
  }
  @MONITOR{ _pims_monitor(); };
  @PIMS_TRACE_SPY{ _predicate_trace(); };
  @MONITOR{ _reduction_started(); };
  @PROBE{ _predicate_trade_trace(); };
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
klb_suspend Lpred, arity

       written by f-doumae@icot22      on Tue May 22 19:54:32 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |        suspend        |         Lpred         |
    +-----------+-----------+-----------+-----------+
    |    arity  |            don't  care            |
    +-----------+-----------+-----------+-----------+

<Arguments>
    Lpred  : $B=R8l%3!<%I$X$N(BPC$BAjBP%i%Y%k(B($BB(CM(B:$BId9fIU$-@0?t(B)
    arity  : $B=R8l$N0z?t8D?t(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B!&%5%9%Z%s%I%9%?%C%/$,6u$J$i$P!"%U%'%$%k$NNc30$rH/@8!#(B
  $B!&%5%9%Z%s%I%9%?%C%/$,6u$G$J$1$l$P!"(BLpred$B$G<($5$l$k%"%I%l%9$r(B
    $B%4!<%k%l%3!<%I$K%;%C%H$7$F!"%5%9%Z%s%I$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_ImmLpred       _ImmediateField1
#OPF_define I_ImmArity       _ImmediateField2

#PSL_define klb_suspend()
{
  s_PutArityGoalRecordOPR (D_ArgReg0, I_ImmArity);
  $USE( D_WorkCodeAddress );
  s_GetKLB_Address_OPR( I_ImmLpred, D_WorkCodeAddress );
  s_PutCodeGoalRecord( D_ArgReg0, D_WorkCodeAddress );
  $RELEASE( D_WorkCodeAddress );

  s_IfInvalidSuspendStack() {
    f_Fail();
  } else {
    @PROBE2{ probe_store_if_reg_base(); };
    f_Suspend();
  }
  f_IfEventHappen() {
    $CALL( f_SlitCheck_Sub() );
  }
  /* $B<!$K<B9T$9$k%4!<%k$r<h$j=P$9=hM}(B */
  $CALL( i_DequeueNewGoal_Sub() );
  @PROBE2{ probe_load_if_reg_base(); };

  $USE(D_WorkCodeAddress);
  s_GetCodeGoalRecord( D_ArgReg0, D_WorkCodeAddress );
  s_SetKLB_PC( D_WorkCodeAddress );
  $RELEASE( D_WorkCodeAddress );

  @MONITOR{ _pims_monitor(); };
  @PIMS_TRACE_SPY{ _predicate_trace(); };
  @MONITOR{ _reduction_suspended(); };
  @MONITOR{ _reduction_started(); };
  @PROBE{ _predicate_trade_trace(); };
}

/******************************************************************** PSL **
klb_suspend_single Reg, Lpred, arity

       written by f-doumae@icot22      on Tue May 22 20:01:42 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |      suspend_single   |    Reg    | don't care|
    +-----------+-----------+-----------+-----------+
    |        Lpred          |   arity   | don't care|
    +-----------+-----------+-----------+-----------+

<Arguments>
    Reg    : $B%5%9%Z%s%IMW0x(B
    Lpred  : $B=R8l%3!<%I$X$N(BPC$BAjBP%i%Y%k(B($BB(CM(B:$BId9fIU$-@0?t(B)
    arity  : $B%4!<%k$N0z?t8D?t(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B!&(BReg$B$,L$Dj5AJQ?t$G$"$l$P!"(BCGP$B%l%8%9%?$G;X$5$l$k%4!<%k$r(B
    $B%5%9%Z%s%I$9$k!#(B($B6qBN2=$5$l$F$$$?>l9g$O!"%+%l%s%H%4!<%k%9%?%C%/$K(B
                     $B%(%s%-%e!<$9$k!#(B==> see f_HookSingleSuspendGoal_Sub)
  $B!&<!$K<B9T$9$k%4!<%k$r%G%-%e!<$9$k!#(B
<Examples>
<Test>
<Explanation>
   $B%5%9%Z%s%I%9%?%C%/$r;H$o$J$$:GE,2=$N$?$a$NL?Na!#(B(single-wait only)
<ETC>
********************************************************************* PSL **/
#OPF_define I_RegSuspFactor     _IndirectRegField1
#OPF_define I_ImmLpred          _ImmediateField2
#OPF_define I_ImmArity          _ImmediateField3

#OPF_define I_ImmRegSuspFactor  _ImmediateField1

#PSL_define klb_suspend_single()
{
  @DEBUG {
    b_IfRangeErr( I_ImmRegSuspFactor, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      VPIM_ERROR( "klb_suspend_single", "r1_range" );
    }
  };
  @PROBE { b_IncrementReg( D_SUSPEND_COUNT ); };
  @PROBE2{ probe_increment_counter(D_PROBE_COUNTER_TOTAL_SUSPEND);};
  /* $B%5%9%Z%s%I=hM}(B */

  s_PutArityGoalRecordOPR (D_ArgReg0, I_ImmArity);
  $USE( D_WorkCodeAddress );
  s_GetKLB_Address_OPR(I_ImmLpred, D_WorkCodeAddress );
  s_PutCodeGoalRecord(D_ArgReg0, D_WorkCodeAddress);

  f_IfSHProfModeOn(){
    $CALL(f_FPIncrementSuspendCountProfilingEntry_Sub(D_WorkCodeAddress,
						      D_CurrentEnvRecPtr));
  }

  $RELEASE( D_WorkCodeAddress );

  @MONITOR{ _print_suspended(); };
  @PROBE2{ probe_store_if_reg_base(); };
  $CALL( f_HookSingleSuspendGoal_Sub( D_ArgReg0, I_RegSuspFactor ) );
  f_MakeEmptyCGP ( D_ArgReg0 );	/* $B%+%l%s%H%4!<%k%]%$%s%?$r6u$H$9$k(B */
  f_IfEventHappen() {
      $CALL ( f_SlitCheck_Sub() );
  }
  /* $B<!$K<B9T$9$k%4!<%k$r<h$j=P$9=hM}(B */
  $CALL ( i_DequeueNewGoal_Sub() );
  @PROBE2{ probe_load_if_reg_base(); };

  $USE(D_WorkCodeAddress);
  s_GetCodeGoalRecord( D_ArgReg0, D_WorkCodeAddress );
  s_SetKLB_PC( D_WorkCodeAddress );
  $RELEASE( D_WorkCodeAddress );

  @MONITOR{ _pims_monitor(); };
  @PIMS_TRACE_SPY{ _predicate_trace(); };
  @MONITOR{ _reduction_suspended(); };
  @MONITOR{ _reduction_started(); };
  @PROBE{ _predicate_trade_trace(); };
}

/******************************************************************** PSL **
klb_fail Lpred, arity

       written by f-doumae@icot22      on Thu May 24 14:53:51 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |          fail         |         Lpred         |
    +-----------+-----------+-----------+-----------+
    |   arity   |             don't care            |
    +-----------+-----------+-----------+-----------+
<Arguments>
    Lpred : $B=R8l%3!<%I$X$N(BPC$BAjBP%i%Y%k(B($BB(CM(B:$BId9fIU$-@0?t(B)
    arity : $B=R8l$N0z?t8D?t(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B!&<:GT$7$?%4!<%k$N>pJs$rAq1`$N%l%]!<%H%9%H%j!<%`$K$"$2$k!#(B
    $B!&%9%j%C%H%A%'%C%/(B
    $B!&?7$7$$%4!<%k$r%G%-%e!<$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
    $B%5%9%Z%s%7%g%s%9%?%C%/$r;H$o$J$$:GE,2=$G!"%U%'%$%k%i%Y%k$N9T$-@h$H(B
    $B$7$F;H$&!#(B
********************************************************************* PSL **/
#OPF_define	I_ImmLpred	_ImmediateField1
#OPF_define     I_ImmArity      _ImmediateField2

#PSL_define klb_fail()
{
  $USE( D_WorkCodeAddress );
  s_GetKLB_Address_OPR( I_ImmLpred, D_WorkCodeAddress );
  s_PutCodeGoalRecord(D_ArgReg0, D_WorkCodeAddress);
  $RELEASE( D_WorkCodeAddress );
  s_PutArityGoalRecordOPR(D_ArgReg0, I_ImmArity);
  f_Fail();
  /* $B$3$N;~E@$G(BD_ArgReg0$B$O(BNULL$B$G$"$k!#(B */
  f_IfEventHappen() {
      $CALL( f_SlitCheck_Sub() );
  }
  /* $B<!$K<B9T$9$k%4!<%k$r<h$j=P$9=hM}(B */
  $CALL( i_DequeueNewGoal_Sub() );
  @PROBE2{ probe_load_if_reg_base(); };
  $USE(D_WorkCodeAddress);
  s_GetCodeGoalRecord( D_ArgReg0, D_WorkCodeAddress );
  s_SetKLB_PC( D_WorkCodeAddress );
  $RELEASE( D_WorkCodeAddress );
}

/******************************************************************** PSL **
klb_otherwise Lpred, arity

       written by f-doumae@icot22      on Fri May 25 15:01:04 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |       otherwise       |         Lpred         |
    +-----------+-----------+-----------+-----------+
    |   arity   |             don't care            |
    +-----------+-----------+-----------+-----------+

<Arguments>
    Lpred : $B=R8l%3!<%I$X$N(BPC$BAjBP%i%Y%k(B($BB(CM(B:$BId9fIU$-@0?t(B) 
    arity : $B=R8l$N0z?t8D?t(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B%5%9%Z%s%7%g%s%9%?%C%/$KL$Dj5AJQ?t$,@Q$^$l$F$$$?>l9g$O!"(BD_ArgReg0$B$,;X$9(B
    $B%4!<%k%l%3!<%I$r%5%9%Z%s%I$9$k!#JQ?t$,4{$K6qBN2=$7$F$$$?>l9g$O!"(B
    D_ArgReg0$B$N;X$9%4!<%k%l%3!<%I$r%l%G%#%4!<%k%9%?%C%/$K%(%s%-%e!<$9$k!#(B
    $B%9%?%C%/$K2?$b@Q$^$l$F$$$J$$;~$O!"<!L?Na$N<B9T$K0\$k!#(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define	I_ImmLpred	_ImmediateField1
#OPF_define     I_ImmArity      _ImmediateField2

#PSL_define klb_otherwise()
{
  s_IfValidSuspendStack() {
    s_PutArityGoalRecordOPR (D_ArgReg0, I_ImmArity);
    $USE( D_WorkCodeAddress );
    s_GetKLB_Address_OPR( I_ImmLpred, D_WorkCodeAddress );
    s_PutCodeGoalRecord (D_ArgReg0, D_WorkCodeAddress);
    $RELEASE( D_WorkCodeAddress );
    @PROBE2{ probe_store_if_reg_base(); };
    f_Suspend();
    f_IfEventHappen() {
      $CALL( f_SlitCheck_Sub() );
    }
    /* $B<!$K<B9T$9$k%4!<%k$r<h$j=P$9=hM}(B */
    $CALL( i_DequeueNewGoal_Sub() );
    @PROBE2{ probe_load_if_reg_base(); };
    $USE(D_WorkCodeAddress);
    s_GetCodeGoalRecord( D_ArgReg0, D_WorkCodeAddress );
    s_SetKLB_PC( D_WorkCodeAddress );
    $RELEASE( D_WorkCodeAddress );

    @MONITOR{ _reduction_suspended(); };
    @MONITOR{ _reduction_started(); };
  }
}


/******************************************************************** PSL **
klb_alternatively ()

       written by imai@icot22      on Mon Sep  3 13:59:12 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |       klb_jump        |      don't care       |
    +-----------+-----------+-----------+-----------+

<Arguments> $B$J$7(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%5%9%Z%s%8%g%s%9%?%C%/$K@Q$^$l$F$$$k$b$N$,$"$l$P!"$=$NJQ?t$KBP$7$F(B
  ($B$b$730It;2>H$G$"$l$P(B) %read $B%a%C%;!<%8$rAw=P$9$k!#(B
  $B$b$7!"@Q$^$l$F$$$k$b$N$,2?$b$J$$>l9g!"$"$k$$$O30It;2>H$G$J$$>l9g$O(B
  NOP $B$HF1MM$G$"$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#PSL_define klb_alternatively()
{
  s_IfValidSuspendStack() {
    f_ReadEagerly(); /* in f_reduce_susp_resume.psl.c */
  } /* else NOP */
}

/******************************************************************** PSL **
klb_jump Label

       written by f-doumae@icot22      on Fri May 25 15:01:56 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |       klb_jump        |        Label          |
    +-----------+-----------+-----------+-----------+

<Arguments>
    Label : $BJ,4t@h%i%Y%k(B($BB(CM(B:$BId9fIU$-@0?t(B)

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    Label$B$KL5>r7oJ,4t$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_ImmLabel   _ImmediateField1

#PSL_define klb_jump()
{
  s_SetKLB_PC_OPR(I_ImmLabel);
}

/******************************************************************** PSL **
klb_commit
       written by imai@icot22      on Mon Dec 17 21:21:04 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%3%_%C%H%*%Z%l!<%?$rDL2a$7$?;~$K=P$k(B.
  $B%H%l!<%9%b!<%I$N;~$N$_!"(BD_CurrentDebugInfo $B$K(B I_ImmDebugInfo $B$r%;%C%H$9$k(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_ImmDebugInfo   _ImmediateField1

#PSL_define klb_commit()
{
  @TRACE{
    /* f_IfTraceMode()  ---> $B$3$l$0$i$$!"H=Dj$9$k$h$jKh2s$d$C$?J}$,$$$$(B */
    f_ResetTraceSubGoalListTop();
    f_SetDebugInfo(I_ImmDebugInfo);
  };
}

/******************************************************************** PSL **
klb_check_heap
       written by imai@icot22      on Mon Dec 17 21:23:25 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_ImmPageSize   _ImmediateField1

#PSL_define klb_check_heap()
{
  $USE(D_WorkSize); $USE(D_WorkNewHeapTop);
  p_MoveImmediateValueFromImmediateField(I_ImmPageSize,D_WorkSize);
  b_ShiftLeftImmediateWithDNTC(D_WorkSize,_PG_SIZE_SHIFT,D_WorkSize);
  b_ExchangeElmposToOffset(D_WorkSize,D_WorkSize);
  b_ReadGlobalHeapTop(D_WorkNewHeapTop);
  b_AddWithDNTC(D_WorkNewHeapTop,D_WorkSize,D_WorkNewHeapTop);
  b_IfHeapLimitWarning(D_WorkNewHeapTop) {
    @TRACE{
      b_SetEventFlag (_PAGE_ALLOC_FAIL_EVENT, D_PE_Number);
      f_PushGoalToStack(D_ArgReg0);
      f_IfEventHappen() {
	$CALL( f_SlitCheck_Sub() );
      }
    };
	 /* $B<!$K<B9T$9$k%4!<%k$r<h$j=P$9=hM}(B */
    $CALL( i_DequeueNewGoal_Sub() );
    @PROBE2{ probe_load_if_reg_base(); };
    $USE(D_WorkCodeAddress);
    s_GetCodeGoalRecord( D_ArgReg0, D_WorkCodeAddress );
    s_SetKLB_PC( D_WorkCodeAddress );
    $RELEASE(D_WorkCodeAddress);
  }
  /* else proceed !! */
  $RELEASE(D_WorkNewHeapTop);$RELEASE(D_WorkSize);
}


/******************************************************************** PSL **
kblt_idle

       written by f-doumae@icot22      on Fri May 25 16:47:49 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |         idle          |	      Lfail	    |
    +-----------+-----------+-----------+-----------+
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
idle$B$K$J$C$?;~$K8F$P$l$k!#(B
$B%4!<%k%j%/%(%9%H$r=P$7!"%9%j%C%H%A%'%C%/%$%Y%s%H$,H/@8$9$k$N$r(B
$BBT$C$F%k!<%W$9$k!#(B

$B%"%$%I%k%4!<%k$O!"<!$N$h$&$KDj5A$5$l$k!#(B

dcode_idle_goal :- idle | builtin:pims_shut_down.
alternatively.
dcode_idle_goal :- true | dcode_idle_goal.

$BBh(B1$B@a$N(B $B%,!<%IAH$_9~$_=R8l(B idle $BCf$G$O!"%4!<%k$NMW5a$r9T$J$C$?8e(B
$B%9%j%C%H%A%'%C%/%l%8%9%?$r8+$J$,$i%k!<%W$7!"<!$N$$$:$l$+$K$J$k$^$GBT$D!#(B
  (1) $B%9%j%C%H%A%'%C%/%U%i%0$,N)$F$i$l$?$i!"%U%'%$%k$7$F!"Bh(B2$B@a$r<B9T!#(B
  (2) $B=*N;$r8!=P$7$?>l9g%3%_%C%H$7$F!"AH$_9~$_=R8l(B pims_shut_down $B$K$*$$$F(B
      $B=*N;=hM}$r9T$&!#(B
$BBh(B2$B@a$G$O!"<+J,<+?H$r8F$S=P$7$F$$$k$@$1$G$"$k$,!"<B:]$K$O!"(Bexecute$B$9$kA0$K(B
$B%9%j%C%H%A%'%C%/=hM}$r9T$J$$!"$3$3$GB>(BPE$B$+$i%4!<%k$,Ej$2$i$l$F$$$l$P!"$=$N(B
$B=hM}$K0\$k!#(Bidle $B%4!<%k<+BN$O!"%9%j%C%H%A%'%C%/A0$K%(%s%-%e!<$5$l$k!#(B

<Examples>
<Test>
<Explanation>
<ETC>
1990.12.28 Greatly Modified by Imai Akira
********************************************************************* PSL **/

#DATA_define	D_WorkStatus	XXX

#OPF_define I_ImmLfail  _ImmediateField1

#PSL_define kblt_idle()
{
  s_RecordIdleStartLog();
  @MONITOR{ _idle_start(); };
  f_GoalRequest( D_PE_Number );
  LOOP() {
    b_IntervalTimer();
    f_IfEventHappen() {
      s_IfGoalRequest() {
	/*--- $BB>$N%W%m%;%C%5$+$i$N%4!<%kMW5a(B --> $B?JDh$G$-$k$O$:$,$J$$(B ----*/
	b_ResetEventFlag(_GOAL_REQ_EVENT,D_PE_Number); 
      } else {
      /*-------- Fail (Jump To Alternative Clause) !! ----------*/
	s_RecordIdleStopLog();
	@MONITOR{ _idle_end(); _reduction_started(); };
	@PROBE{
	  b_DecrementReg(D_REDUCTION_COUNT);
/*	  _decrement_cl_reduction_count(); */
	};
	b_IncrementReg(D_ResourceCache); /*-- $B%3%_%C%H;~E@$G8:$i$5$l$k$?$a(B --*/
	s_SetKLB_PC_OPR(I_ImmLfail);
	break; /* from LOOP */
      }
    }
    $USE( D_WorkStatus );
    b_ReadClusterHaltFlag( D_WorkStatus );
    b_IfNotZero( D_WorkStatus ) {
      /*-------- Commit !! -------------------------------------*/
      $RELEASE( D_WorkStatus );
      s_RecordIdleStopLog();
      @MONITOR{ _idle_end(); };
      break; /* from LOOP */
    }
    $RELEASE( D_WorkStatus );
  }
}

/******************************************************************** PSL **
(SUBROUTINE) i_DequeueNewGoal_Sub

       written by f-doumae@icot22      on Fri May 25 17:00:55 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
  $B!&A0$N%4!<%k%j%@%/%7%g%s$N4V$K(B, $B$h$j9b$$%W%i%$%*%j%F%#$r;}$D%4!<%k$,@8$8$?(B
    $B>l9g$O(B, $B%9%j%C%H%A%'%C%/=hM}$K$*$$$F(B
	D_CurrentGoalStackPtr: $B%G%-%e!<$9$k%4!<%k%l%3!<%I$X$N%]%$%s%?$r;X$9(B.
	D_Current_Priority: $B8=:_(B($B$3$l$+$i(B)$B<B9T$9$k%4!<%k$N%W%i%$%*%j%F%#(B
  	D_CurrentStackEntryPtr: $B8=:_(B($B$3$l$+$i(B)$B<B9T$9$k%4!<%k$N%W%i%$%*%j%F%#(B
		$B$KBP1~$9$k%4!<%k%9%?%C%/%(%s%H%j$X$N%]%$%s%?(B.
    $B$,99?7$5$l$F$$$k$b$N$H$9$k!#(B
    $B$?$@$7(B, $B%9%j%C%H%A%'%C%/$G;v>]$,@8$8$F$$$J$+$C$?$h$&$J>l9g$O(B,
    D_CurrentGoalStackPtr, D_Current_Priority, D_CurrentStackEntryPtr $B$OA0$N(B
    $B%4!<%k%j%@%/%7%g%s$G@_Dj$5$l$?CM$H$J$k!#(B
	(D_CurrentGoalStackPtr$B$O(BEOL$B$H$J$C$F$$$k>l9g$,$"$k!#(B)
  $B!&>e5-$K$h$j(B, D_Current_Priority$B$O$=$N(BPE$B$N%4!<%k%9%?%C%/Cf$N%l%G%#%4!<%k$N(B
    $B$J$+$G:G9b0L$N%W%i%$%*%j%F%#$H$J$C$F$$$k$O$:$G$"$k!#(B
    $B$3$N$?$a(B, D_CurrentStackEntryPtr$B$,;X$9%9%?%C%/%(%s%H%j$O2<5-$N$h$&$K$J$C$F(B
    $B$$$k(B.

		+---------------+
		|EOL		|	Higher-entry
		|---------------|
		|HOOK !	   *---------->	 to a Goalrecord (or EOL)
		|---------------|
		|INT  !	priority|
		|---------------|
		|REF  !	   *	|	Lower-entry
		+----------|----+
  			   |
			   V
<Function>
  $B!&$3$l$^$G<B9T$7$F$$$?%4!<%k$,=jB0$9$kN$?F$X$N%]%$%s%?$r%o!<%/$X%`!<%V$9$k(B. 
  $B!&(BD_CurrentGoalStackPtr$B$,(BEOL$B$G$J$1$l$P(B, $B$=$N@h$N%4!<%k%l%3!<%I$r<h$j=P$7(B,
    $BFbMF$r%l%8%9%?$K0z$->e$2$k!#(B
  $B!&(BD_CurrentGoalstackPtr$B$,(BEOL$B$N;~$O(B, $B8=:_$N(BD_Current_Priority$B$h$jDc$$%W%i%$%*(B
    $B%j%F%#$N%l%G%#%4!<%k$r%4!<%k%9%?%C%/$+$iC5$7(B, D_Current_Priority $B$H(B
    D_CurrentGoalStackPtr$B$r99?7$7$F$+$i%4!<%k%l%3!<%I$r<h$j=P$9!#(B
    $B$3$N;~(B, D_Max_Priority, D_MaxPrioStackEntryPtr $B$r(B $B$=$l$>$l(B, 
    D_Current_Priority, D_CurrentStackEntryPtr $B$NCM$K99?7$9$k(B.
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#DATA_define D_WorkOldFPPtr             XXX
#DATA_define D_WorkOldResourceCache     XXX
#DATA_define D_WorkOldForkCount         XXX
#DATA_define D_WorkDequeueNewGoalCodePtr XXX

#SUBROUTINE  i_DequeueNewGoal_Sub()
{
  $USE( D_WorkOldFPPtr );
  p_MoveWord( D_Current_FP_Ptr, D_WorkOldFPPtr );

  LOOP() {
    f_IfNoCurrentPhyPrioGoal() {
      $CALL( f_GetHighestCurrentGoalStackPtr_Sub() );
    }
    f_PopGoalFromStack( D_ArgReg0 );
    @DEBUG{
      s_IfEHOOK(D_ArgReg0){
	VPIM_ERROR("i_DequeueNewGoal_Sub","EHOOK appeared. (Why?)");
      }
    };
    f_CheckGoalExecutable( D_ArgReg0, D_WorkOldFPPtr );
    f_IfNotEmptyCGP( D_ArgReg0 ) { break; }
  }

  f_IfSHProfModeOn(){
    $USE(D_WorkDequeueNewGoalCodePtr);
    s_GetCodeGoalRecord (D_ArgReg0,D_WorkDequeueNewGoalCodePtr);
    $CALL(f_FPIncrementDequeueCountProfilingEntry_Sub(
					      D_WorkDequeueNewGoalCodePtr,
					      D_CurrentEnvRecPtr));
    $RELEASE(D_WorkDequeueNewGoalCodePtr);
  }

  @TRACE{
    p_IfTypeEQImmediate(D_CurrentEnvRecPtr, _TRACE_ENV_REC_TYPE) {
      /* $B%H%l!<%9%b!<%I$K$J$C$?(B */
      s_GetTraceIdEnvRecord(D_CurrentEnvRecPtr,D_CurrentTraceId);
    } else {
      f_ResetTraceMode();
    }
  };
  @SPY{
    p_IfTypeEQImmediate(D_CurrentEnvRecPtr, _SPY_ENV_REC_TYPE) {
      /* $B%9%Q%$%b!<%I$K$J$C$?(B */
      s_GetSpyIdEnvRecord(D_CurrentEnvRecPtr,D_CurrentSpyId);
      s_GetSpyTablePtrEnvRecord(D_CurrentEnvRecPtr,D_CurrentSpiedCodeVect);
    } else {
      f_ResetSpyMode();
    }
  };
  $RELEASE( D_WorkOldFPPtr );
  $RETURN();
}
