/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V05/interpreter/klb_compare.psl.c
   ----- CREATED   : by f-hataza@icot22, on Fri May 11 21:09:41 1990
   ----- LAST SAVED: by f-hataza@icot22, on Mon Sep  3 12:27:26 1990
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : INTERPRETER
   ----- ABSTRACT  : $BHf3S(B

  klb_equal (Reg1, Reg2, Lsusp, Lfail)
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */
/******************************************************************** PSL **
klb_equal Reg1, Reg2, Lsusp, Lfail

       written by f-doumae@icot22      on Mon Jul 10 16:10:03 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |         equal         |    Reg1   |   Reg2    | 
    +-----------+-----------+-----------+-----------+
    |	      Lsusp	    |	     Lfial	    |
    +-----------+-----------+-----------+-----------+
<Arguments>
    Reg1  :  $B%l%8%9%?(B
    Reg2  :  $B%l%8%9%?(B
    Lsusp :  $B%5%9%Z%s%I%i%Y%k(B
    Lfail :  $B%U%'%$%k%i%Y%k(B
<Temporally Used Variables>
<Level>
<PreCondition>
    Reg1, Reg2$B$O%G%l%U!"6qBN2=:Q$_$G$"$k$3$H!#(B
<Function>
    $B%l%8%9%?>e$N%G!<%?$N%?%$%W$HCM$rHf3S$7!"F1$8$G$J$1$l$P(B Lfail $B$XJ,4t$9$k!#(B
    $BAPJ}$,F1$8<oN`(B/$BBg$-$5$N9=B$BN$N>l9g$K$O!"$=$NA4MWAG$bHf3S$9$k!#(B
    $B$3$N;~!"ESCf$GL$Dj5AJQ?t$,M-$C$?>l9g$K$O(B Lsusp $B$XJ,4t$9$k!#(B
<Examples>
    $BL$Dj5A$N>l9gF10lJQ?t$r;X$7$F$$$F$b%5%9%Z%s%I$9$k!#(B

       +-------+            +--------+
   R1  |  REF  |----------->|  UNDF  |
       +-------+     |      +--------+   ===> $B%5%9%Z%s%I(B
       +-------+     |
   R2  |  REF  |-----+
       +-------+

       +-------+            +--------+
   R1  | LIST  |----------->|  atom  |
       +-------+            +--------+          +--------+
                            |  REF   |--------->|  UNDF  |
                            +--------+     |    +--------+
       +-------+            +--------+     |
   R2  | LIST  |----------->|  atom  |     |                ==> $B%5%9%Z%s%I(B
       +-------+            +--------+     |
                            |  REF   |-----+
                            +--------+
<Test>
<Explanation>
<ETC>
    V02$B$N(B i_EqualStruct, i_Equal_Sub $B$O!"(Bf-$B%l%Y%k(B(f_reduce_passive_unify.psl.c)
    $B$X0\F0$7$?!#(B
********************************************************************* PSL **/
#OPF_define I_RegSource1      _IndirectRegField1
#OPF_define I_RegSource2      _IndirectRegField2
#OPF_define I_ImmLsusp        _ImmediateField3
#OPF_define I_ImmLfail        _ImmediateField4

#OPF_define I_ImmRegSource1   _ImmediateField1
#OPF_define I_ImmRegSource2   _ImmediateField2

#PSL_define klb_equal() 
{
  @DEBUG {/*---------------------------------------------------*/
    b_IfRangeErr(I_ImmRegSource1, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_equal", "r1 range");
    }
    b_IfRangeErr(I_ImmRegSource2, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_equal", "r2 range");
    }
    s_IfUnbound(I_RegSource1) {
      VPIM_ERROR ("klb_equal", "r1 Illegal_type Unbound");
    }
    s_IfUnbound(I_RegSource2) {
      VPIM_ERROR ("klb_equal", "r2 Illegal_type Unbound");
    }
    s_IfREF(I_RegSource1) {
      VPIM_ERROR ("klb_equal", "r1 Illegal_type REF");
    }
    s_IfREF(I_RegSource2) {
      VPIM_ERROR ("klb_equal", "r2 Illegal_type REF");
    }
  }; /*---------------------------------------------------*/
  s_IfNotAtomic(I_RegSource1) {
    f_EqualStruct(I_RegSource1, I_RegSource2, I_ImmLsusp, I_ImmLfail);
  } else {
    b_IfTypeValueNotEq(I_RegSource1, I_RegSource2){
      s_SetKLB_PC_OPR(I_ImmLfail); /*  Lfail $B$KJ,4t(B  */
    }
  }
}
