
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V10/interpreter/klb_collect.psl.c
   ----- CREATED   : by f-hataza@icot22, on Fri May 11 19:54:53 1990
   ----- LAST SAVED: by f-hataza@icot22, on Wed Mar  6 16:52:35 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : INTERPRETER
   ----- ABSTRACT  : $B2s<}(B

  klb_collect_list(Reg)
  klb_collect_vector(size, Reg)
  klb_collect_value(Reg)


(1) collect_list $B$O%j%9%H$N%3%s%9%;%k$r!"(Bcollect_vect $B$O%Y%/%?$NK\BN$r(B
   MRB$BGr$N;~$K2s<}$9$k!#$=$N@h$r:F5"E*$K2s<}$9$k$3$H$O$7$J$$!#(B

(2) collect_value $B$G$b:F5"E*$J2s<}$O9T$o$:$=$NI=AX$N$_$r2s<}$9$k!#(B
   $B$7$+$7!"%j%9%H$N(BCDR$BIt$K$D$$$F$O%j%9%H9=B$$K$*$$$F?<$5$,(B3$B$^$G$O2s<}$r9T$&!#(B

           +-------+                    $B2s<}$NBP>](B        | $B2s<}$NBP>]30(B
  LIST --->| atom  |                                      |
           +-------+   +-------+                          |
           | LIST ---->| VECT ---------------------------------> ???
           +-------+   +-------+   +-------+              |
                       | LIST ---->| atom  |              |
                       +-------+   +-------+   +-------+  |
                                   | LIST ---->| REF ----------> ???
                                   +-------+   +-------+  |
                                               | LIST ---------> ???       
                          ex.1                 +-------+  |
                                                          |
           +-------+                                      | 
  LIST --->| atom  |                                      |
           +-------+   +-------+                          |
           | LIST ---->| VECT ---------------------------------> ???
           +-------+   +-------+   +-------+              |
                       | VECT ---->| int   |              |
                       +-------+   +-------+              |
                                   | LIST ---------------------> ???
                                   +-------+              |
                          ex.2                            |
                                                          |

(3) collect_value $B$K$*$1$k(BVOID$BJQ?t!"(BUNDEF$BJQ?t$N=hM}$K$D$$$F(B
                                                  (cf. str_variable_type.psl.c)
   $B!&Gr%Q%9(BVOID$B$O2s<}$9$k!#(B
   $B!&9u%Q%9(BVOID$B$O2s<}$7$J$$!#(B($B9u%Q%9(BVOID$B$O=hM}>e9u%Q%9(BUNDEF$B$HEy2A$G$"$k!#(B)
   $B!&Gr%Q%9(BUNDEF$B$O(BVOID$B$K=q$-49$($k!#(B($B8e$G2s<}$G$-$k2DG=@-$,M-$k!#(B)
   $B!&9u%Q%9(BUNDEF$B$O2s<}$7$J$$!#(B($BEvA3(B!!)
   $B!&Gr%Q%9(BHOOK$B7O$N>l9g$OGr%Q%9(BUNDEF$B$HF1$8$G$"$k$+$i(BVOID$B$K=q$-49$($k!#(B
     $B$=$l$HF1;~$K(BHOOK$B$5$l$F$$$?%4!<%k$OC!$-5/$3$9!#(B

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
klb_collect_list Reg

       written by f-doumae@icot22      on Mon Jul 10 14:59:03 1989

  0            1            2            3            4
  +------------+------------+------------+------------+
  |      collect_list       |    Reg     | don't care |
  +------------+------------+------------+------------+

<Arguments>
    Reg  : $B%j%9%H$r;X$9%l%8%9%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
    Reg$B$O%G%l%U:Q$_!#(B
<Function>
    $B!&(BReg$B$N(BMRB$B$,!{(B(OFF)$B$J$i!"%j%9%H$N%3%s%9%;%k$r2s<}$7!"<!L?Na$X(B
    $B!&(BReg$B$N(BMRB$B$,!|(B(ON)$B$J$i!"<!L?Na$X(B
<Examples>
<Test>
<Explanation>
<ETC>
    $B!&%j%9%HA4BN$r!":F5"E*$K2s<}$9$k$3$H$O$7$J$$(B
********************************************************************* PSL **/

#OPF_define I_RegSource1  _IndirectRegField1
#OPF_define I_ImmRegSource1 _ImmediateField1

#PSL_define klb_collect_list() 
{
  @DEBUG {
    b_IfRangeErr(I_ImmRegSource1, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_collect_list", "r1 range");
    }
    s_IfNotLIST(I_RegSource1) {
      VPIM_ERROR("klb_collect_list","Illegal_type");
    }
  };
  s_IfMRBoff(I_RegSource1) { s_ReclaimList(I_RegSource1);} 
}

/******************************************************************** PSL **
klb_collect_vector size, Reg

       written by f-doumae@icot22      on Mon Jul 10 15:07:09 1989
  0            1            2            3            4
  +------------+------------+------------+------------+
  |      collect_vector     |    size    |    Reg     |
  +------------+------------+------------+------------+

<Arguments>
    size  : $B%Y%/%?$N%5%$%:(B($B@0?t(B)
    Reg   : $B%Y%/%?$r;X$9%l%8%9%?(B

<Temporally Used Variables>
    D_WorkVectSize : $B%m%s%0%Y%/%?$N%5%$%:$r3JG<$9$k%l%8%9%?(B
                     (defined in klb_body_blt_data.psl.c)
<Level>
<PreCondition>
    $B!&(BReg$B$O%G%l%U:Q$_(B
    $B!&(BReg$B$N%?%$%W$,%Y%/%?$G$J$+$C$?$i!"%3%s%Q%$%i$N%(%i!<(B
<Function>
    $B!&(BReg$B$N(BMRB$B$,!{(B(OFF)$B$J$i!"%Y%/%?K\BN(B($B$N$_(B)$B$r2s<}$7!"<!L?Na$X(B
    $B!&(BReg$B$N(BMRB$B$,!|(B(ON)$B$J$i!"<!L?Na$X(B
<Examples>
<Test>
<Explanation>
<ETC>
    $B!&%Y%/%?K\BN$N@h$r!":F5"E*$K2s<}$9$k$3$H$O$7$J$$(B
    $B!&<B5!$G$O%Y%/%?$N%5%$%:Kh$K%^%/%m$rJ,$1$?J}$,NI$$!#(B
********************************************************************* PSL **/

#OPF_define I_ImmSize    	_ImmediateField1
#OPF_define I_RegSource  	_IndirectRegField2
#OPF_define I_ImmRegSource 	_ImmediateField2

#PSL_define klb_collect_vector() 
{
  @DEBUG{
    b_IfRangeErr(I_ImmRegSource, _ZERO, _MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_collect_vector", "r2 range");
    }
    s_IfNotVectors(I_RegSource) { 
      VPIM_ERROR("klb_collect_vector","Illegal_type");
    }
  };
  s_IfMRBoff(I_RegSource) {
    @PROBE {s_CountType(I_RegSource); };
    TypeSwitch(I_RegSource) {
      case ShortVectorGrp(): /* VECT1$B!A(BVECT8 */
	  s_ReclaimShortVector(I_RegSource);
	  break;
      case LongVectorGrp():
	  @DEBUG { 
	    b_IfRangeUnderImm(I_ImmSize,_ZERO) {
	      VPIM_ERROR("klb_collect_vector","Minus_Size"); 
	    }
	  };
	  $USE(D_WorkVectSize);
	  b_MoveImmOprWithMRBandType(I_ImmSize,_MRB_OFF,INT,D_WorkVectSize);
	  s_ReclaimLongVector(D_WorkVectSize, I_RegSource);
	  $RELEASE(D_WorkVectSize);
	  break;
      case NullVectorGrp():  /* $B2s<}$7$h$&$H$9$k$N$O%3%s%Q%$%i$N%P%0(B */
      default:
	  @DEBUG {
	    VPIM_ERROR("klb_collect_vector", "Illegal_type");
	  };
	  break;
    } /* end of TypeSwitch */
  }
}

/******************************************************************** PSL **
klb_collect_value Reg

       written by f-doumae@icot22      on Mon Jul 10 15:13:12 1989

  0            1            2            3            4
  +------------+------------+------------+------------+
  |     collect_value       |    Reg     | don't care |
  +------------+------------+------------+------------+

<Arguments>
    Reg : $B%l%8%9%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  Reg$B$+$i;X$5$l$k%a%b%j%;%k$r!"2s<}$9$k!#(BD$B%3!<%I$O;HMQ$7$J$$!#(B
    
  VOID$BJQ?t!"(BUNDEF$BJQ?t$N=hM}$K$D$$$F0J2<$NDL$j!#(B(cf. str_variable_type.psl.c)
   $B!&Gr%Q%9(BVOID$B$O2s<}$9$k!#(B
   $B!&9u%Q%9(BVOID$B$O2s<}$7$J$$!#(B($B9u%Q%9(BVOID$B$O=hM}>e9u%Q%9(BUNDEF$B$HEy2A$G$"$k!#(B)
   $B!&Gr%Q%9(BUNDEF$B$O(BVOID$B$K=q$-49$($k!#(B($B8e$G2s<}$G$-$k2DG=@-$,M-$k!#(B) *$BCm(B*
   $B!&Gr%Q%9(BHOOK$B7O$N>l9g$OGr%Q%9(BUNDEF$B$HF1$8$G$"$k$+$i(BVOID$B$K=q$-49$($k!#(B*$BCm(B*
     $B$=$l$HF1;~$K(BHOOK$B$5$l$F$$$?%4!<%k$OC!$-5/$3$9!#(B

   *$BCm(B*
     UNDEF$B$r(BVOID$B$K=q$-49$($k:]$K$O!"(BUNDEF$B$,B>$N(BPE$B$K$h$C$F=q$-49$($i$l$F$$$k(B
     $B2DG=@-$,M-$k$N$GGSB>%"%/%;%9$,I,MW$K$J$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_ImmRegSource  _ImmediateField1
#OPF_define I_RegSource     _IndirectRegField1

#PSL_define klb_collect_value()
{
  @DEBUG{
    b_IfRangeErr(I_ImmRegSource, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_collect_value", "r1 range");
    }
  };
  s_IfMRBoff(I_RegSource) {
    $USE( D_WorkCollectValueCaller );
    b_SetImmValueDNTC
      ( _COLLECT_VALUE_FROM_KL1B_COLLECT_VALUE, D_WorkCollectValueCaller );
    $CALL( f_CollectValue_Sub(I_RegSource, D_WorkCollectValueCaller) );
    $RELEASE( D_WorkCollectValueCaller );
  }
}
