
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/interpreter/klb_body_blt_struct.psl.c
   ----- CREATED   : by yamamoto@icot22, on Mon Jun  4 20:39:53 1990
   ----- LAST SAVED: by kawai@icot22, on Thu Jul  9 18:07:24 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : INTERPRETER
   ----- ABSTRACT  : $B%\%G%#$N%Y%/%?!&%9%H%j%s%04X78$NAH$_9~$_=R8l(B

  $B%\%G%#$N%Y%/%?!&%9%H%j%s%04X78$NAH$_9~$_=R8l$G$O!"F~NO0z$-?t$,;XDj$N%?%$%W$G(B
$B$J$$>l9g!"Nc30$rH/@8$7$FAq1`$KCN$i$;$k!#$^$?!"F~NO0z$-?t$,L$Dj5A$N>l9g$O!"%5%9(B
$B%Z%s%I$9$k!#(B('klb_body_blt_arith.psl.c' $B;2>H(B)
  $B%Y%/%?!&%9%H%j%s%0$N@8@.;~$K%R!<%WNN0h$,ITB-$7$?;~$K$O!"(B D$B%3!<%I%4!<%k$r%(%s(B
$B%-%e!<$9$k!#(B ($BNN0h$r3d$jIU$1$k%^%/%mFb$G!"(BGC$B$,MW5a$5$l$k(B)
  $B$3$N%U%!%$%kFb$NAH$_9~$_=R8l$KBP$7$F!"%3%s%Q%$%i$OF~NO$H=PNO$G%l%8%9%?$,=EJ#(B
$B$7$J$$$3$H$rJ]>Z$9$k!#(B

$B$3$N%U%!%$%k$GDj5A$5$l$F$$$kAH$_9~$_=R8l(B

#PSL_define kblt_b_vector_size() 
#PSL_define kblt_b_vector_element() 
#PSL_define kblt_b_new_vector() 
#PSL_define kblt_b_set_vector_element() 

#PSL_define kblt_b_string_length_element_size()
#PSL_define kblt_b_new_string()
#PSL_define kblt_b_string_element()
#PSL_define kblt_b_set_string_element()

#PSL_define kblt_b_binary_string_operation ()    '91.7.17 added.
#PSL_define kblt_b_shifting_string_operation ()  '91.7.17 added.
#PSL_define kblt_b_unary_string_operation ()     '91.7.17 added.
#PSL_define kblt_b_search_character ()           '91.7.17 added.
#PSL_define kblt_b_search_characters ()          '91.7.17 added.
#PSL_define kblt_b_change_element_size ()        '91.7.17 added.

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
b_vector_size  A1 A2 A3

       written by nakase@icot22      Tue Nov  1 16:54:26 1988

  0            1            2            3            4
  +------------+------------+------------+------------+
  |    b_vector_size        |     A1     |     A2     |
  +------------+------------+------------+------------+
  |      A3    |      don't    care                   |
  +------------+------------+------------+------------+

<Arguments>

  A1   $BF~NO(B  $B%Y%/%?(B($B%l%8%9%?(B) ($BL$Dj5A$J$i%5%9%Z%s%I!"(B
                               $B%Y%/%?0J30$K6qBN2=$5$l$F$$$?$iNc30(B)
  A2   $B=PNO(B  $B%5%$%:(B($B%l%8%9%?(B) ($B@0?t(B)
  A3   $B=PNO(B  $B%Y%/%?(B($B%l%8%9%?(B) (A1 $B$H%f%K%U%!%$$5$l$k(B)

<Temporally Used Variables>
<Level>  interpreter
<PreCondition>
  $B!&F~NO$H=PNO$N%l%8%9%?$O!"=EJ#$7$J$$!#(B
<Function>
  $B!&(BA1$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B
    $B!&%Y%/%?0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA2$B$K%Y%/%?%5%$%:$r=q$-=P$7!"(BA3$B$K(BA1$B$N%3%T!<$r=q$-9~$`!#(B
    $B!&F~NO%Y%/%?$,(B MRB$B!|$G!"?7$7$/%Y%/%?$r3d$jIU$1$k$N$K(B
      $B%R!<%WNN0h$,ITB-$7$?;~$K$O!"(B D$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_SrcVect _IndirectRegField1
#OPF_define I_DstSize _IndirectRegField2
#OPF_define I_DstVect _IndirectRegField3

#PSL_define kblt_b_vector_size () 
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_IOO_Sub
	    (D_WorkArgVect,I_SrcVect,I_DstSize,I_DstVect));
      f_TraceBodyBuiltin(BLT_B_VECTOR,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE (D_Workreg);
  f_ActiveDeref (I_SrcVect, D_Workreg);
  TypeSwitch (I_SrcVect) {
    case ShortVectorGrp ():
      s_GetSizeShortVect (I_SrcVect, I_DstSize);
      f_CopyShortVectorMRB (I_SrcVect, I_DstSize, I_DstVect);
      break;
    case LongVectorGrp ():
      s_GetSizeLongVect (I_SrcVect, I_DstSize);
      f_CopyLongVectorMRB (I_SrcVect, I_DstSize, I_DstVect);
      b_IfWordEq (I_DstVect, D_NULL) {
          /* $B%R!<%WNN0hITB-$G!"%Y%/%?$r@8@.$G$-$J$+$C$?;~$O!"(B
           * Dcode $B%4!<%k$r(B enqueue $B$9$k!#(B
           */
        f_DcodeEnqueue3Ope_IOO(BLT_B_VECTOR,I_SrcVect,I_DstSize,I_DstVect);
        @DEBUG {WARNING ("kblt_b_vector_size", "Dcode Goal enqueued"); };
      }
      break;
    case NullVectorGrp ():
      b_MoveWithImmTypeMRBoff (D_NULL, INT, I_DstSize);
      f_CopyNullVector (I_SrcVect, I_DstVect);
      break;

    case UnboundGroup (): 
      p_MoveWord (D_Workreg, I_SrcVect);
      f_DcodeEnqueue3Ope_IOO(BLT_B_VECTOR,I_SrcVect,I_DstSize,I_DstVect);
      break;

    case ListGrp ():
    case StringGrp ():
    case ConstantGroup ():
    case RefGroup ():
    case ControlGroup ():
      $USE (D_WorkOpCode); $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, BLT_B_VECTOR, D_WorkOpCode);
      b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
      $CALL (f_Exception_3Arg_IOO_Sub
              (D_WorkExceptionCode, D_WorkOpCode, D_WorkExcepArgPos, 
               I_SrcVect, I_DstSize, I_DstVect) );
      $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
      $RELEASE(D_WorkExcepArgPos);
      break;
    
    default:
      @DEBUG {VPIM_ERROR ("kblt_b_vector_size", "undefined type");};
      break;
    }
  $RELEASE (D_Workreg);
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
b_new_vector  A1 A2

       written by nakase@icot22      Wed Nov  2 11:00:59 1988

  0            1            2            3            4
  +------------+------------+------------+------------+
  |       b_new_vector      |     A1     |     A2     |
  +------------+------------+------------+------------+

<Arguments>
  A1   $B=PNO(B  $B%Y%/%?(B ($B%l%8%9%?(B)
  A2   $BF~NO(B  $B%5%$%:(B ($B%l%8%9%?(B) ($BL$Dj5A$J$i%5%9%Z%s%I!"(B
                               $BHsIi@0?t0J30$K6qBN2=$5$l$F$$$?$iNc30(B)

<Temporally Used Variables>
<Level>  interpreter
<PreCondition>
  $B!&F~NO$H=PNO$N%l%8%9%?$O!"=EJ#$7$J$$!#(B
<Function>
  $B!&(BA2$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B
    $B!&HsIi@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA2$B$,HsIi@0?t$N;~!"(B
    $B!&(BA2$B%5%$%:$N%Y%/%?$r(BA1$B$K3d$jIU$1!"3FMWAG$r@0?t(B (INT) 0$B$K=i4|2=$9$k!#(B
  $B!&%R!<%WNN0hITB-$G!"%Y%/%?$r@8@.$G$-$J$+$C$?;~$O!"(B
    $B!&(BD$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_DstVect _IndirectRegField1
#OPF_define I_SrcSize _IndirectRegField2

#PSL_define kblt_b_new_vector () 
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp2ArgVect_OI_Sub(D_WorkArgVect,I_DstVect,I_SrcSize));
      f_TraceBodyBuiltin(BLT_B_NEW_VECTOR,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  $USE (D_Workreg);
  f_ActiveDeref (I_SrcSize, D_Workreg);
  TypeSwitch (I_SrcSize) {
    case INT:
      b_IfLess (I_SrcSize, D_NULL) {
          /* $B;XDj$5$l$?%5%$%:$,Ii?t$J$iNc30(B */
        $USE (D_WorkExceptionCode);
        b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP,
				                        D_WorkExceptionCode);
        goto Exception;
      } else {
	b_IfGreater(I_SrcSize,D_AvailableHeapSize) {
	  /* $B%R!<%WJRLL$N%5%$%:$h$jBg$-$$>l9g$ONc30(B */
	  $USE (D_WorkExceptionCode);
	  b_SetImmTypeValueMRBoff
	    (INT, _RANGE_OVERFLOW_EXCP, D_WorkExceptionCode);
	  goto Exception;
	}
	  /* $B;XDj$5$l$?%5%$%:$,HsIi$J$i%Y%/%?$r3d$jIU$1$k(B */
        $CALL ( f_AllocVectorMRBoff_Sub (I_SrcSize, I_DstVect) );
        b_IfWordEq (I_DstVect, D_NULL) {
            /* $B%R!<%WNN0hITB-$G!"%Y%/%?$r@8@.$G$-$J$+$C$?;~$O!"(B
             * Dcode $B%4!<%k$r(B enqueue $B$9$k!#(B
             */
          f_DcodeEnqueue2Ope_OI (BLT_B_NEW_VECTOR, I_DstVect, I_SrcSize);
          @DEBUG { WARNING ("kblt_b_new_vector", "Dcode Goal enqueued"); };
        } else {
            /* $B%Y%/%?$N=i4|2=$r9T$&(B */
	  b_MoveWithImmTypeMRBoff (D_NULL, INT, D_Workreg);
          f_InitializeVector (D_Workreg, I_SrcSize, I_DstVect);
        }
      }
      break;
    case UnboundGroup (): 
      p_MoveWord (D_Workreg, I_SrcSize);
      f_DcodeEnqueue2Ope_OI(BLT_B_NEW_VECTOR, I_DstVect, I_SrcSize);
      break;

    case ATOM:
    case FLT:
    case StructureGroup ():
    case RefGroup ():
    case ControlGroup ():
      $USE (D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      goto Exception;
    default: 
      @DEBUG {VPIM_ERROR ("kblt_b_new_vector", "undefined type");};
      break;
  }
  goto END;

 Exception:
  $USE(D_WorkExcepArgPos);
  $USE (D_WorkOpCode);
  b_SetImmTypeValueMRBoff (INT, BLT_B_NEW_VECTOR, D_WorkOpCode);
  b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
  $CALL (f_Exception_2Arg_OI_Sub(D_WorkExceptionCode, D_WorkOpCode, 
				 D_WorkExcepArgPos, I_DstVect, I_SrcSize) );
  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
 END:
  $RELEASE (D_Workreg);
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
b_vector_element A1 A2 A3 A4

       written by nakase@icot22      Wed Nov  2 14:41:00 1988

  0            1            2            3            4
  +------------+------------+------------+------------+
  |     b_vector_element    |    A1      |     A2     |
  +------------+------------+------------+------------+
  |     A3     |     A4     |     don't  care         |
  +------------+------------+------------+------------+

<Arguments>
  A1   $BF~NO(B  $B%Y%/%?(B  ($B%l%8%9%?(B) ($BL$Dj5A$J$i%5%9%Z%s%I!"(B
                                 $B%Y%/%?0J30$K6qBN2=$5$l$F$$$?$iNc30(B)
  A2   $BF~NO(B  $BMWAGHV9f(B ($B%l%8%9%?(B) ($BL$Dj5A$J$i%5%9%Z%s%I!"(B
                                 $BHsIi@0?t0J30$K6qBN2=$5$l$F$$$?$iNc30(B)
  A3   $B=PNO(B  $B%Y%/%?MWAG(B ($B%l%8%9%?(B)
  A4   $B=PNO(B  $B%Y%/%?(B  ($B%l%8%9%?(B) (A1 $B$H%f%K%U%!%$$5$l$k(B)

<Temporally Used Variables>
<Level>  interpreter
<PreCondition>
  $B!&F~NO$H=PNO$N%l%8%9%?$O!"=EJ#$7$J$$!#(B
<Function>
  $B!&(BA1$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B
    $B!&%Y%/%?0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA2$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B
    $B!&HsIi@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA2$B$,(B 0$B0J>e(B A1$B$N%5%$%:L$K~$J$i!"(B
    $B!&(BA1$B$N(BA2$BHVL\$NMWAG$r(BA3$B$KF~$l!"(BA1$B$r(BA4$B$K%3%T!<$9$k!#(B
    $B!&F~NO%Y%/%?$,(B MRB$B!|$G!"?7$7$/%Y%/%?$r3d$jIU$1$k$N$K(B
      $B%R!<%WNN0h$,ITB-$7$?;~$K$O!"(B D$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B
  $B!&(B A1 $B$N(B $BBh(B(A2) $BMWAG$H(BA3 $B$O!"Nc$((B A1($BF~NO%Y%/%?(B) $B$N(B MRB $B$,!{$G$"$C$F$b!"(B
     $B;2>H?t$,A}$($k$?$a!"(BMRB $B$r!|$K$7$J$1$l$P$J$i$J$$!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#DATA_define D_WorkVectSize   XXX

#OPF_define I_SrcVect _IndirectRegField1
#OPF_define I_SrcIndex _IndirectRegField2
#OPF_define I_DstElem _IndirectRegField3
#OPF_define I_DstVect _IndirectRegField4

#PSL_define kblt_b_vector_element () 
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp4ArgVect_IIOO_Sub
	    (D_WorkArgVect,I_SrcVect,I_SrcIndex,I_DstElem,I_DstVect));
      f_TraceBodyBuiltin(BLT_B_VECTOR_ELEMENT,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  $USE (D_Workreg);
  f_ActiveDeref (I_SrcIndex, D_Workreg);
  TypeSwitch (I_SrcIndex) {
    case INT: 
      b_IfLess (I_SrcIndex, D_NULL) {
      /* $B;XDj$5$l$?MWAGHV9f$,Ii?t$J$iNc30(B */
        $USE (D_WorkExceptionCode);
	$USE(D_WorkExcepArgPos);
        b_SetImmTypeValueMRBoff(INT,_OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
	b_SetImmTypeValueMRBoff(INT, _ONE, D_WorkExcepArgPos);
        goto Exception;
      } else {
      /* $B;XDj$5$l$?MWAGHV9f$,HsIi$J$i(B... */
        f_ActiveDeref (I_SrcVect, D_Workreg);
        TypeSwitch (I_SrcVect) {
          case ShortVectorGrp ():  
 	    $USE (D_WorkVectSize);
	    s_GetSizeShortVect (I_SrcVect, D_WorkVectSize);
	    b_IfLess (I_SrcIndex, D_WorkVectSize){
	      /* $B%Y%/%?%5%$%:L$K~$N;~(B */
	      /* $B%^!<%/=hM}(B */
	      s_GetVectElementPosReg (I_SrcVect, I_SrcIndex, I_DstElem);
	      s_MRBonReg(I_DstElem);
	      s_PutVectElementPosReg (I_SrcVect, I_SrcIndex, I_DstElem);
	      $RELEASE (D_WorkVectSize);
              p_MoveWord(I_SrcVect, I_DstVect);
	    } else {
              /* $B%Y%/%?%5%$%:0J>e$N;~$ONc30(B */
              $RELEASE (D_WorkVectSize);
              $USE (D_WorkExceptionCode);
	      $USE(D_WorkExcepArgPos);
              b_SetImmTypeValueMRBoff
		(INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
	      b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
              goto Exception;
	    }
            break;

          case LongVectorGrp ():
 	    $USE (D_WorkVectSize);
	    s_GetSizeLongVect (I_SrcVect, D_WorkVectSize);
	    b_IfLess (I_SrcIndex, D_WorkVectSize){
	      /* $B%Y%/%?%5%$%:L$K~$N;~(B */
	      $RELEASE (D_WorkVectSize);
	      s_GetVectElementPosReg (I_SrcVect, I_SrcIndex, I_DstElem);
	      /* $B%^!<%/=hM}(B */
	      s_MRBonReg(I_DstElem);
	      s_PutVectElementPosReg (I_SrcVect, I_SrcIndex, I_DstElem);
              p_MoveWord(I_SrcVect, I_DstVect);
	    } else {
              /* $B%Y%/%?%5%$%:0J>e$N;~$ONc30(B */
              $RELEASE (D_WorkVectSize);
              $USE (D_WorkExceptionCode);
	      $USE(D_WorkExcepArgPos);
              b_SetImmTypeValueMRBoff
		(INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
	      b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
              goto Exception;
	    }
            break;

          case UnboundGroup ():
	    p_MoveWord (D_Workreg, I_SrcVect);
	    f_DcodeEnqueue4Ope_IIOO(BLT_B_VECTOR_ELEMENT,
                             I_SrcVect, I_SrcIndex, I_DstElem, I_DstVect);
            break;
          case NullVectorGrp ():
          case ConstantGroup ():
          case ListGrp ():
          case StringGrp ():
          case RefGroup ():
          case ControlGroup ():
            $USE (D_WorkExceptionCode);
	    $USE(D_WorkExcepArgPos);
            b_SetImmTypeValueMRBoff
	      (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
	    b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
            goto Exception;
          default: 
            @DEBUG {VPIM_ERROR ("kblt_b_vector_element", "undefined type");};
            break;
	}
      } /* end of b_IfLessImm */
      break;

    case UnboundGroup ():
      p_MoveWord (D_Workreg, I_SrcIndex);
      f_DcodeEnqueue4Ope_IIOO (BLT_B_VECTOR_ELEMENT, 
		 I_SrcVect, I_SrcIndex, I_DstElem, I_DstVect);
      break;
    case ATOM:
    case FLT:
    case StructureGroup ():
    case RefGroup ():
    case ControlGroup ():
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
      goto Exception; 
    default:
      @DEBUG {VPIM_ERROR ("kblt_b_vector_element", "undefined type");};
      break;
  }
  goto END;

 Exception:
  $USE (D_WorkOpCode);
  b_SetImmTypeValueMRBoff (INT, BLT_B_VECTOR_ELEMENT, D_WorkOpCode);
  $CALL (f_Exception_4Arg_IIOO_Sub (D_WorkExceptionCode, D_WorkOpCode, 
	D_WorkExcepArgPos, I_SrcVect, I_SrcIndex, I_DstElem, I_DstVect) );
  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
 END:
  $RELEASE (D_Workreg);
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
b_set_vector_element A1 A2 A3 A4 A5

       written by nakase@icot22      Wed Nov  9 18:18:46 1988

  0            1            2            3            4
  +------------+------------+------------+------------+
  |  b_set_vector_element   |     A1     |     A2     |
  +------------+------------+------------+------------+
  |      A3    |    A4      |     A5     |don't care  |
  +------------+------------+------------+------------+

<Arguments>
  A1   $BF~NO(B  $B%Y%/%?(B  ($B%l%8%9%?(B) ($BL$Dj5A$J$i%5%9%Z%s%I!"(B
                                 $B%Y%/%?0J30$K6qBN2=$5$l$F$$$?$iNc30(B)
  A2   $BF~NO(B  $BMWAGHV9f(B ($B%l%8%9%?(B) ($BL$Dj5A$J$i%5%9%Z%s%I!"(B
                                 $BHsIi@0?t0J30$K6qBN2=$5$l$F$$$?$iNc30(B)
  A3   $B=PNO(B  $B%Y%/%?MWAG(B ($B%l%8%9%?(B) 
  A4   $BF~NO(B  $B%Y%/%??7MWAG(B ($B%l%8%9%?(B)
  A5   $B=PNO(B  $B%Y%/%?(B  ($B%l%8%9%?(B)
	 
<Temporally Used Variables>
<Level>   interpreter
<PreCondition>
  $B!&F~NO$H=PNO$N%l%8%9%?$O!"=EJ#$7$J$$!#(B
<Function>
  $B!&(BA1$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B
    $B!&%Y%/%?0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA2$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B
    $B!&HsIi@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA2$B$,(B 0$B0J>e(B A1$B$N%5%$%:L$K~$N@0?t$J$i!"(B
    $B!&(BA1$B$N(BA2$BHVL\$NMWAG$r(BA3$B$KF~$l!"(BA1 (MRB$B!{(B)$B!"$^$?$O!"(BA1$B$N%3%T!<(B (MRB$B!|(B)
      $B$N(BA2$BHVL\$NMWAG$r(BA4$B$K=q$-49$($?%Y%/%?$r(BA5$B$K=q$-=P$9!#(B
    $B!&F~NO%Y%/%?$,(B MRB$B!|$G!"?7$7$/%Y%/%?$r3d$jIU$1$k$N$K(B
      $B%R!<%WNN0h$,ITB-$7$?;~$K$O!"(B D$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_OldVctSrc _IndirectRegField1  /* Old vector (src) */
#OPF_define I_IndexSrc  _IndirectRegField2  /* Position (src) */
#OPF_define I_OldElmDst _IndirectRegField3  /* Old Element (dst) */
#OPF_define I_NewElmSrc _IndirectRegField4  /* New Element (src) */
#OPF_define I_NewVctDst _IndirectRegField5  /* New vector (dst) */

#PSL_define kblt_b_set_vector_element () 
{
  @DEBUG {
    s_IfArgTypeErr (I_OldVctSrc){
	VPIM_ERROR ("b_set_vector_element", "Illegal_A1");
    }
    s_IfArgTypeErr (I_IndexSrc) {
	VPIM_ERROR ("b_set_vector_element", "Illegal_A2");
    }
    s_IfArgTypeErr (I_NewElmSrc){
	VPIM_ERROR ("b_set_vector_element", "Illegal_A4");
    }
  };

  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp5ArgVect_IIOIO_Sub
	    (D_WorkArgVect,
	     I_OldVctSrc,I_IndexSrc,I_OldElmDst,I_NewElmSrc,I_NewVctDst));
      f_TraceBodyBuiltin(BLT_B_SET_VECTOR_ELEMENT,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE (D_Workreg1);
  f_ActiveDeref (I_IndexSrc, D_Workreg1);
  TypeSwitch (I_IndexSrc) {
    case INT:
      b_IfLess (I_IndexSrc, D_NULL) {
        /* $B;XDj$5$l$?MWAGHV9f$,Ii?t$J$iNc30(B */
        $USE (D_WorkExceptionCode);
	$USE(D_WorkExcepArgPos);
        b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP,
				                     D_WorkExceptionCode);
	b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
        goto Exception;
      } else {
        /* $B;XDj$5$l$?MWAGHV9f$,HsIi$J$i(B... */
        $USE (D_Workreg2);
        f_ActiveDeref (I_OldVctSrc, D_Workreg2);
        TypeSwitch (I_OldVctSrc) {
          case ShortVectorGrp ():  
 	    $USE (D_WorkVectSize);
	    s_GetSizeShortVect (I_OldVctSrc, D_WorkVectSize);
	    b_IfLess (I_IndexSrc, D_WorkVectSize){
	      /* $B%Y%/%?%5%$%:L$K~$N;~(B */
              f_CopyShortVectorMRB (I_OldVctSrc, D_WorkVectSize, I_NewVctDst);
	      $RELEASE (D_WorkVectSize);
	      s_GetVectElementPosReg (I_OldVctSrc, I_IndexSrc, I_OldElmDst);
              s_PutVectElementPosReg (I_NewVctDst, I_IndexSrc, I_NewElmSrc);
	    } else {
              /* $B%Y%/%?%5%$%:0J>e$N;~$ONc30(B */
	      $RELEASE (D_Workreg2);
              $RELEASE (D_WorkVectSize);
              $USE (D_WorkExceptionCode);
	      $USE(D_WorkExcepArgPos);
              b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP,
				                       D_WorkExceptionCode);
	      b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
              goto Exception;
	    }
  	    break;

          case LongVectorGrp ():
 	    $USE (D_WorkVectSize);
	    s_GetSizeLongVect (I_OldVctSrc, D_WorkVectSize);
	    b_IfLess (I_IndexSrc, D_WorkVectSize){
	      /* $B%Y%/%?%5%$%:L$K~$N;~(B */
              f_CopyLongVectorMRB (I_OldVctSrc, D_WorkVectSize, I_NewVctDst);
	      $RELEASE (D_WorkVectSize);
              b_IfWordNotEq (I_NewVctDst, D_NULL) {
                /* $B%Y%/%?$,$G$-$?;~!"5lMWAG$rFI$_!"?7MWAG$r=q$-9~$`(B */
                s_GetVectElementPosReg (I_OldVctSrc, I_IndexSrc, I_OldElmDst);
                s_PutVectElementPosReg (I_NewVctDst, I_IndexSrc, I_NewElmSrc);
	      } else {
                /* $B%R!<%WNN0hITB-$G!"%Y%/%?$r@8@.$G$-$J$+$C$?;~$O!"(B
                 * Dcode $B%4!<%k$r(B enqueue $B$9$k!#(B
                 */
                f_DcodeEnqueue5Ope_IIOIO
                       (BLT_B_SET_VECTOR_ELEMENT, I_OldVctSrc, 
                        I_IndexSrc, I_OldElmDst, I_NewElmSrc, I_NewVctDst);
                @DEBUG { WARNING ("kblt_b_set_vector_element", 
                                                 "Dcode Goal enqueued"); };
              }
	    } else {
              /* $B%Y%/%?%5%$%:0J>e$N;~$ONc30(B */
	      $RELEASE (D_Workreg2);
              $RELEASE (D_WorkVectSize);
              $USE (D_WorkExceptionCode);
	      $USE(D_WorkExcepArgPos);
              b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP,
				                         D_WorkExceptionCode);
	      b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExceptionCode);
              goto Exception;
	    }
            break;

  	  case UnboundGroup ():   
            p_MoveWord (D_Workreg2, I_OldVctSrc);
	    f_DcodeEnqueue5Ope_IIOIO
	      (BLT_B_SET_VECTOR_ELEMENT,
               I_OldVctSrc, I_IndexSrc, I_OldElmDst, I_NewElmSrc, I_NewVctDst);
	    break;

          case NullVectorGrp ():
          case ConstantGroup ():
          case ListGrp ():
          case StringGrp ():
          case RefGroup ():
          case ControlGroup ():
            $USE (D_WorkExceptionCode);
	    $USE(D_WorkExcepArgPos);
            b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP,
				                          D_WorkExceptionCode);
	    b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
	    $RELEASE (D_Workreg2);
            goto Exception;

	  default:  
            @DEBUG {VPIM_ERROR ("kblt_b_set_vector_element", "undefined type");};
            break;
        }
        $RELEASE (D_Workreg2);
      }
      break;

    case UnboundGroup ():   
      p_MoveWord (D_Workreg1, I_IndexSrc);
      f_DcodeEnqueue5Ope_IIOIO (BLT_B_SET_VECTOR_ELEMENT,
	  I_OldVctSrc, I_IndexSrc, I_OldElmDst, I_NewElmSrc, I_NewVctDst);
      break;
      
    case ATOM:
    case FLT:
    case StructureGroup ():
    case RefGroup ():
    case ControlGroup ():
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
      goto Exception;
    default:
      @DEBUG {VPIM_ERROR ("kblt_b_set_vector_element", "undefined type");};
      break;
  }
  goto END;

 Exception:
  $USE (D_WorkOpCode);
  b_SetImmTypeValueMRBoff (INT, BLT_B_SET_VECTOR_ELEMENT, D_WorkOpCode);
  $CALL (f_Exception_5Arg_IIOIO_Sub (D_WorkExceptionCode, D_WorkOpCode, 
			     D_WorkExcepArgPos, I_OldVctSrc, I_IndexSrc, 
			     I_OldElmDst, I_NewElmSrc, I_NewVctDst) );
  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
 END:
  $RELEASE (D_Workreg1);
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
b_string_length_element_size A1, A2, A3, A4

       written by ymiyazak@icot22      Fri Jan  6 17:15:30 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |    b_string_length    |     A1    |     A2    |
    |      _element_size    |           |           |
    +-----------+-----------+-----------+-----------+
    |    A3     |    A4     |       don't care      |
    +-----------+-----------+-----------+-----------+

<Arguments>

  A1   $BF~NO(B  $B%9%H%j%s%0(B ($B%l%8%9%?(B) ($BL$Dj5A$J$i%5%9%Z%s%I!"(B
                                   $B%9%H%j%s%00J30$K6qBN2=$5$l$F$$$?$iNc30(B)
  A2   $B=PNO(B  $BMWAGD9(B ($B%l%8%9%?(B) ($B@0?t(B)
  A3   $B=PNO(B  $BMWAG%5%$%:(B ($B%l%8%9%?(B) ($B@0?t(B)
  A4   $B=PNO(B  $B%9%H%j%s%0(B ($B%l%8%9%?(B) (A1 $B$H%f%K%U%!%$$5$l$k(B)

<Temporally Used Variables>
<Level>    interpreter
<PreCondition>
  $B!&F~NO$H=PNO$N%l%8%9%?$O!"=EJ#$7$J$$!#(B
<Function>
  $B!&(BA1$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B
    $B!&%9%H%j%s%00J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA1$B$,%9%H%j%s%0$J$i!"(B
    $B!&(BA1$B$NMWAGD9$r(BA2$B$KF~$l!"MWAG%5%$%:$r(BA3$B$KF~$l$F!"(B
      A4$B$K(BA1$B$N%3%T!<$r=q$-9~$`!#(B
    $B!&F~NO%9%H%j%s%0$,(B MRB$B!|$G!"?7$7$/%9%H%j%s%0$r3d$jIU$1$k$N$K(B
      $B%R!<%WNN0h$,ITB-$7$?;~$K$O!"(B D$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_SrcString _IndirectRegField1
#OPF_define I_DstLength _IndirectRegField2
#OPF_define I_DstSize   _IndirectRegField3
#OPF_define I_DstString _IndirectRegField4

#PSL_define kblt_b_string_length_element_size ()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp4ArgVect_IOOO_Sub
	    (D_WorkArgVect,I_SrcString,I_DstLength,I_DstSize,I_DstString));
      f_TraceBodyBuiltin(BLT_B_STRING,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE (D_Workreg);
  f_ActiveDeref (I_SrcString, D_Workreg);
  TypeSwitch (I_SrcString) {
    case StringGrp ():
      s_GetStringType (I_SrcString, I_DstLength, I_DstSize);
      f_CopyStringMRB (I_SrcString, I_DstString);
      b_IfWordEq (I_DstString, D_NULL) {
          /* $B%R!<%WNN0hITB-$G!"%9%H%j%s%0$r@8@.$G$-$J$+$C$?;~$O!"(B
           * Dcode $B%4!<%k$r(B enqueue $B$9$k!#(B
           */
        f_DcodeEnqueue4Ope_IOOO (BLT_B_STRING, 
                   I_SrcString, I_DstLength, I_DstSize, I_DstString); 
        @DEBUG { WARNING ("kblt_b_string_length_element_size",
			  "Dcode Goal enqueued"); };
      }
      break;

    case UnboundGroup (): 
      p_MoveWord (D_Workreg, I_SrcString);
      f_DcodeEnqueue4Ope_IOOO(BLT_B_STRING,
	 I_SrcString, I_DstLength, I_DstSize, I_DstString); 
      break;
  
    case NullVectorGrp ():
    case ShortVectorGrp ():
    case LongVectorGrp ():
    case ListGrp ():
    case ConstantGroup ():
    case RefGroup ():
    case ControlGroup ():
      $USE (D_WorkOpCode); $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, BLT_B_STRING, D_WorkOpCode);
      b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
      $CALL (f_Exception_4Arg_IOOO_Sub (D_WorkExceptionCode, D_WorkOpCode, 
	D_WorkExcepArgPos, I_SrcString, I_DstLength, I_DstSize, I_DstString) );
      $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
      $RELEASE(D_WorkExcepArgPos);
      break;
    
    default:
      @DEBUG {VPIM_ERROR ("kblt_b_string_length_element_size",
			  "undefined type");};
      break;
    }
  $RELEASE (D_Workreg);
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
b_new_string A1, A2, A3

       written by ymiyazak@icot22      Fri Jan  6 17:25:41 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |     b_new_string      |     A1    |     A2    |
    +-----------+-----------+-----------+-----------+
    |     A3    |            don't care             |
    +-----------+-----------+-----------+-----------+
<Arguments>
  A1   $B=PNO(B  $B%9%H%j%s%0(B ($B%l%8%9%?(B)
  A2   $BF~NO(B  $BMWAGD9(B ($B%l%8%9%?(B)     ($BL$Dj5A$J$i%5%9%Z%s%I!"(B
                                   $BHsIi@0?t0J30$K6qBN2=$5$l$F$$$?$iNc30(B)
  A3   $BF~NO(B  $BMWAG%5%$%:(B ($B%l%8%9%?(B) ($BL$Dj5A$J$i%5%9%Z%s%I!"(B
                                 1$B0J>e(B32$B0J2<$N@0?t0J30$K6qBN2=$5$l$F$$$?$iNc30(B)

<Temporally Used Variables>
<Level>    interpreter
<PreCondition>
  $B!&F~NO$H=PNO$N%l%8%9%?$O!"=EJ#$7$J$$!#(B
<Function>
  $B!&(BA2$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B
    $B!&HsIi@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA3$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B
    $B!&(B1$B0J>e(B32$B0J2<$N@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
      ($BC"$7!"8=:_$O(B1, 8, 16, 32 $B$N2?$l$+$7$+5v$5$l$J$$!#(B)
  $B!&(BA2, A3 $B$,>r7o$rK~$?$;$P!"(B
    $B!&MWAGD9(BA2$B!"MWAG%5%$%:(BA3 $B$N%9%H%j%s%0$r@8@.$7(B A1$B$K3d$jIU$1$k!#(B
    $B!&%R!<%WNN0h$,ITB-$7$?;~$K$O!"(B D$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_DstString _IndirectRegField1
#OPF_define I_SrcLength _IndirectRegField2
#OPF_define I_SrcSize   _IndirectRegField3

#PSL_define kblt_b_new_string ()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_OII_Sub(D_WorkArgVect,
				       I_DstString, I_SrcLength, I_SrcSize)); 
      f_TraceBodyBuiltin(BLT_B_NEW_STRING,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  $USE (D_Workreg);
  f_ActiveDeref (I_SrcLength, D_Workreg);
  TypeSwitch (I_SrcLength) {
    case INT:
      b_IfLess (I_SrcLength, D_NULL) {              
            /* $B;XDj$5$l$?MWAGD9$,(B $BIi?t$J$iNc30(B */
        $USE (D_WorkExceptionCode);
	$USE(D_WorkExcepArgPos);
        b_SetImmTypeValueMRBoff (INT,_RANGE_OVERFLOW_EXCP,D_WorkExceptionCode);
	b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
        goto Exception;
      } else {
	b_IfGreater(I_SrcLength,D_AvailableHeapSize) {
	  /* $B%R!<%WJRLL$N%5%$%:$h$jBg$-$$>l9g$ONc30(B */
	  $USE (D_WorkExceptionCode);
	  $USE(D_WorkExcepArgPos);
	  b_SetImmTypeValueMRBoff
	    (INT, _RANGE_OVERFLOW_EXCP, D_WorkExceptionCode);
	  b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
	  goto Exception;
	}
            /* $B;XDj$5$l$?MWAGD9$,(B 0$B0J>e$N;~(B */
        f_ActiveDeref (I_SrcSize, D_Workreg);
        TypeSwitch (I_SrcSize) {
          case INT:
            ValueSwitch (I_SrcSize) {
              case  1:  case  8:  case 16:  case 32:
                f_AllocString (I_DstString, I_SrcLength, I_SrcSize);
                    /* $B%9%H%j%s%0$r3d$jIU$1$k(B */
                b_IfWordEq (I_DstString, D_NULL) {
                    /* $B%R!<%WNN0hITB-$G!"%9%H%j%s%0$r@8@.$G$-$J$+$C$?;~$O!"(B
                     * Dcode $B%4!<%k$r(B enqueue $B$9$k!#(B
                     */
                  f_DcodeEnqueue3Ope_OII
                    (BLT_B_NEW_STRING, I_DstString, I_SrcLength, I_SrcSize);
                  @DEBUG {WARNING ("kblt_b_new_string",
				   "Dcode Goal enqueued"); };
                } else {
		  b_MoveWithImmTypeMRBoff(D_NULL, DNTC, D_Workreg);
                  f_InitializeString (D_Workreg, I_DstString);
                    /* $B%9%H%j%s%0$,$G$-$?$i!"(B(DNTC) 0 $B$G=i4|2=$9$k!#(B
                     * $B$3$N%^%/%m$O!"%9%H%j%s%0$r%o!<%IKh$K(B
                     *  ($B4v$D$+$NMWAG$r$^$H$a$F(B) $B=i4|2=$9$k!#(B
                     */
	        }
		break;
              default:
                $USE (D_WorkExceptionCode);
		$USE(D_WorkExcepArgPos);
                b_SetImmTypeValueMRBoff
		  (INT, _RANGE_OVERFLOW_EXCP, D_WorkExceptionCode);
		b_SetImmTypeValueMRBoff(INT, _TWO, D_WorkExcepArgPos);
                goto Exception;
            } /* end of ValueSwitch () */
  	    break;
          case UnboundGroup ():
            p_MoveWord (D_Workreg, I_SrcSize);
	    f_DcodeEnqueue3Ope_OII (BLT_B_NEW_STRING,
			          I_DstString, I_SrcLength, I_SrcSize);
	    break;
	  case ATOM:
	  case FLT:
	  case StructureGroup ():
	  case RefGroup ():
	  case ControlGroup ():
            $USE (D_WorkExceptionCode);
	    $USE(D_WorkExcepArgPos);
            b_SetImmTypeValueMRBoff
	      (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
	    b_SetImmTypeValueMRBoff (INT, _TWO, D_WorkExcepArgPos);
            goto Exception; break;
	  default: 
	    @DEBUG {VPIM_ERROR ("kblt_b_new_string", "undefined type");};
	    break;
        } /* end of TypeSwitch (I_SrcSize) */
      } /* end of b_IfLessImm () */
      break;
    case UnboundGroup ():
      p_MoveWord (D_Workreg, I_SrcLength);
      f_DcodeEnqueue3Ope_OII (BLT_B_NEW_STRING,
			          I_DstString, I_SrcLength, I_SrcSize); 
      break;
    case ATOM:
    case FLT:
    case StructureGroup ():
    case RefGroup ():
    case ControlGroup ():
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
      goto Exception; break;

    default: 
      @DEBUG {VPIM_ERROR ("kblt_b_new_string", "undefined type");};
      break;
  }
  goto END;

 Exception:
  $USE (D_WorkOpCode);
  b_SetImmTypeValueMRBoff (INT, BLT_B_NEW_STRING, D_WorkOpCode);
  $CALL (f_Exception_3Arg_OII_Sub (D_WorkExceptionCode, D_WorkOpCode, 
		D_WorkExcepArgPos, I_DstString, I_SrcLength, I_SrcSize) ); 
  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
 END:
  $RELEASE (D_Workreg);
  End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
b_string_element A1, A2, A3, A4

       written by ymiyazak@icot22      Fri Jan  6 17:37:48 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |     b_string_element  |     A1    |     A2    |
    +-----------+-----------+-----------+-----------+
    |     A3    |    A4     |     don't care        |
    +-----------+-----------+-----------+-----------+
<Arguments>
  A1   $BF~NO(B  $B%9%H%j%s%0(B ($B%l%8%9%?(B) ($BL$Dj5A$J$i%5%9%Z%s%I!"(B
                                   $B%9%H%j%s%00J30$K6qBN2=$5$l$F$$$?$iNc30(B)
  A2   $BF~NO(B  $BMWAGHV9f(B ($B%l%8%9%?(B)   ($BL$Dj5A$J$i%5%9%Z%s%I!"(B
                                   $BHsIi@0?t0J30$K6qBN2=$5$l$F$$$?$iNc30(B)
  A3   $B=PNO(B  $B%9%H%j%s%0MWAG(B ($B%l%8%9%?(B) ($B@0?t(B)
  A4   $B=PNO(B  $B%9%H%j%s%0(B ($B%l%8%9%?(B) (A1 $B$H%f%K%U%!%$$5$l$k(B)

<Temporally Used Variables>
<Level>    interpreter
<PreCondition>
  $B!&F~NO$H=PNO$N%l%8%9%?$O!"=EJ#$7$J$$!#(B
<Function>
  $B!&(BA1$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B
    $B!&%9%H%j%s%00J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA2$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B
    $B!&HsIi@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA2$B$,(B 0$B0J>e(B A1$B$N%5%$%:L$K~$J$i!"(B
    $B!&(BA1$B$N(BA2$BHVL\$NMWAG$r(BA3$B$KF~$l!"(BA1$B$r(BA4$B$K%3%T!<$9$k!#(B
    $B!&F~NO%9%H%j%s%0$,(B MRB$B!|$G!"?7$7$/%9%H%j%s%0$r3d$jIU$1$k$N$K(B
      $B%R!<%WNN0h$,ITB-$7$?;~$K$O!"(B D$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define  D_WorkStrCheckLength  XXX
#DATA_define  D_WorkStrCheckElmSize  XXX

#OPF_define I_SrcString _IndirectRegField1
#OPF_define I_SrcIndex  _IndirectRegField2
#OPF_define I_DstElem   _IndirectRegField3
#OPF_define I_DstString _IndirectRegField4

#PSL_define kblt_b_string_element () 
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp4ArgVect_IIOO_Sub
	    (D_WorkArgVect,I_SrcString, I_SrcIndex, I_DstElem, I_DstString));
      f_TraceBodyBuiltin(BLT_B_STRING_ELEMENT,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE (D_Workreg);
  f_ActiveDeref (I_SrcString, D_Workreg);
  TypeSwitch (I_SrcString) {
    case StringGrp ():
      f_ActiveDeref (I_SrcIndex, D_Workreg);
      TypeSwitch (I_SrcIndex) {
        case INT: 
          b_IfLess (I_SrcIndex, D_NULL) {
            /* $B;XDj$5$l$?MWAGHV9f$,Ii?t$J$iNc30(B */
            $USE (D_WorkExceptionCode);
	    $USE(D_WorkExcepArgPos);
            b_SetImmTypeValueMRBoff
	      (INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
	    b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
            goto Exception;
          } else {
            /* $B;XDj$5$l$?MWAGHV9f$,HsIi$N;~(B */
            $USE (D_WorkStrCheckLength); $USE (D_WorkStrCheckElmSize);
            s_GetStringType (I_SrcString, D_WorkStrCheckLength,
			                               D_WorkStrCheckElmSize);

            b_IfLess (I_SrcIndex, D_WorkStrCheckLength){
	      s_GetStringElementPosReg
                (I_SrcString, I_SrcIndex, D_WorkStrCheckElmSize, I_DstElem);
	      $RELEASE (D_WorkStrCheckElmSize);
	      $RELEASE (D_WorkStrCheckLength);
              p_MoveWord(I_SrcString, I_DstString);
	    } else {
	        /* $B%9%H%j%s%0%5%$%:0J>e$NMWAGHV9f;XDj$N>l9g$ONc30(B */
              $RELEASE (D_WorkStrCheckElmSize);
	      $RELEASE (D_WorkStrCheckLength);
              $USE (D_WorkExceptionCode);
	      $USE(D_WorkExcepArgPos);
              b_SetImmTypeValueMRBoff
		(INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
	      b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
              goto Exception;
	    }
	  }
	  break;
	case UnboundGroup ():
	  p_MoveWord (D_Workreg, I_SrcIndex);
	  f_DcodeEnqueue4Ope_IIOO (BLT_B_STRING_ELEMENT, 
			 I_SrcString, I_SrcIndex, I_DstElem, I_DstString); 
	  break;
	case ATOM:
	case FLT:
	case StructureGroup ():
	case RefGroup ():
	case ControlGroup ():
          $USE (D_WorkExceptionCode);
	  $USE(D_WorkExcepArgPos);
          b_SetImmTypeValueMRBoff
	    (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
	  b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
          goto Exception; break;
	default: 
          @DEBUG {VPIM_ERROR ("kblt_b_string_element", "undefined type");};
          break;
	}
      break;
    case UnboundGroup ():
      p_MoveWord (D_Workreg, I_SrcString);
      f_DcodeEnqueue4Ope_IIOO (BLT_B_STRING_ELEMENT, 
			 I_SrcString, I_SrcIndex, I_DstElem, I_DstString);
      break;
    case INT:
    case ATOM:
    case FLT:
    case ListGrp ():
    case NullVectorGrp ():
    case ShortVectorGrp ():
    case LongVectorGrp ():
    case RefGroup ():
    case ControlGroup ():
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
      goto Exception; break;

    default:
      @DEBUG {VPIM_ERROR ("kblt_b_string_element", "undefined type");};
      break;
  }
  goto END;

 Exception:
  $USE (D_WorkOpCode);
  b_SetImmTypeValueMRBoff (INT, BLT_B_STRING_ELEMENT, D_WorkOpCode);
  $CALL (f_Exception_4Arg_IIOO_Sub
          (D_WorkExceptionCode, D_WorkOpCode, D_WorkExcepArgPos, 
  	   I_SrcString, I_SrcIndex, I_DstElem, I_DstString) );
  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
 END:
  $RELEASE (D_Workreg);
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
b_set_string_element A1, A2, A3, A4

       written by ymiyazak@icot22      Fri Jan  6 17:37:48 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    | b_set_string_element  |     A1    |     A2    |
    +-----------+-----------+-----------+-----------+
    |    A3     |    A4     |       don't care      |
    +-----------+-----------+-----------+-----------+
<Arguments>
  A1   $BF~NO(B  $B%9%H%j%s%0(B  ($B%l%8%9%?(B) ($BL$Dj5A$J$i%5%9%Z%s%I!"(B
                                     $B%9%H%j%s%00J30$K6qBN2=$5$l$F$$$?$iNc30(B)
  A2   $BF~NO(B  $BMWAGHV9f(B ($B%l%8%9%?(B) ($BL$Dj5A$J$i%5%9%Z%s%I!"(B
                                 $BHsIi@0?t0J30$K6qBN2=$5$l$F$$$?$iNc30(B)
  A3   $BF~NO(B  $B%9%H%j%s%0?7MWAG(B ($B%l%8%9%?(B) ($BL$Dj5A$J$i%5%9%Z%s%I!"(B
                                         $B@0?t0J30$K6qBN2=$5$l$F$$$?$iNc30(B)
  A4   $B=PNO(B  $B%9%H%j%s%0(B  ($B%l%8%9%?(B)
	 
<Temporally Used Variables>
<Level>   interpreter
<PreCondition>
  $B!&F~NO$H=PNO$N%l%8%9%?$O!"=EJ#$7$J$$!#(B
<Function>
  $B!&(BA1$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B
    $B!&%9%H%j%s%00J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA2$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B
    $B!&(B 0$B0J>e(B A1$B$NMWAGD9L$K~$N@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA3$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B
    $B!&(BA1$B$NMWAG%5%$%:L$K~$N@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA1, A2, A3$B$,>r7o$rK~$?$9;~!"(B
    $B!&(BA1 (MRB$B!{(B)$B!"$^$?$O!"(BA1$B$N%3%T!<(B (MRB$B!|(B)
      $B$N(BA2$BHVL\$NMWAG$r(BA3$B$K=q$-49$($?%9%H%j%s%0$r(BA4$B$K=q$-=P$9!#(B
    $B!&F~NO%9%H%j%s%0$,(B MRB$B!|$G!"?7$7$/%9%H%j%s%0$r3d$jIU$1$k$N$K(B
      $B%R!<%WNN0h$,ITB-$7$?;~$K$O!"(B D$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

/* #CONST_define _WORD_SIZE_OF_STRING  32 (defined in str_string.psl.c) */

#OPF_define I_OldStringSrc _IndirectRegField1  /* Old string (src) */
#OPF_define I_IndexSrc     _IndirectRegField2  /* Position (src) */
#OPF_define I_NewElmSrc    _IndirectRegField3  /* New Element (src) */
#OPF_define I_NewStringDst _IndirectRegField4  /* New string (dst) */

#PSL_define kblt_b_set_string_element () 
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp4ArgVect_IIIO_Sub(D_WorkArgVect,
					I_OldStringSrc,
					I_IndexSrc,
					I_NewElmSrc,
					I_NewStringDst)); 
      f_TraceBodyBuiltin(BLT_B_SET_STRING_ELEMENT,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE (D_Workreg);
  f_ActiveDeref (I_OldStringSrc, D_Workreg);
  TypeSwitch (I_OldStringSrc) {
    case StringGrp (): break;
    case UnboundGroup ():   
      p_MoveWord (D_Workreg, I_OldStringSrc);
      f_DcodeEnqueue4Ope_IIIO (BLT_B_SET_STRING_ELEMENT,
		 I_OldStringSrc, I_IndexSrc, I_NewElmSrc, I_NewStringDst); 
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; break;
    case ConstantGroup ():
    case ListGrp ():
    case NullVectorGrp ():
    case ShortVectorGrp ():
    case LongVectorGrp ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
      goto Exception; break;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_set_string_element", "undefined_type");};
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; break;
    }

  f_ActiveDeref (I_IndexSrc, D_Workreg);
  TypeSwitch (I_IndexSrc) {
    case INT:
      b_IfGreaterEq (I_IndexSrc, D_NULL) {              
        $USE (D_WorkStrCheckLength); $USE (D_WorkStrCheckElmSize);
        s_GetStringType (I_OldStringSrc, D_WorkStrCheckLength,
			                             D_WorkStrCheckElmSize);
        b_IfLess (I_IndexSrc, D_WorkStrCheckLength) {
          $RELEASE (D_WorkStrCheckLength);
          break;
        }
        $RELEASE (D_WorkStrCheckLength); $RELEASE (D_WorkStrCheckElmSize);
      }
      /* $B;XDj$5$l$?MWAGHV9f$,Ii$^$?$OMWAGD90J>e$J$i$PNc30(B */
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
      goto Exception; 

    case UnboundGroup ():   
      p_MoveWord (D_Workreg, I_IndexSrc);
      f_DcodeEnqueue4Ope_IIIO (BLT_B_SET_STRING_ELEMENT,
		 I_OldStringSrc, I_IndexSrc, I_NewElmSrc, I_NewStringDst); 
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; 
    case ATOM:
    case FloatingGrp ():
    case StructureGroup ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
      goto Exception;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_set_string_element", "undefined_type");};
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; 
    }

  f_ActiveDeref (I_NewElmSrc, D_Workreg);
  TypeSwitch (I_NewElmSrc) {
    case INT:
      /* $BMWAG$N%S%C%H%5%$%:$N%A%'%C%/(B */
         /* 32$B%S%C%H%9%H%j%s%0$J$i(BOK */
      b_IfEqualImm (D_WorkStrCheckElmSize, _WORD_SIZE_OF_STRG) { break;}

         /* $B$=$l0J30$N;~!"@5$G$+$D%S%C%HI}$r1[$($J$1$l$P(BOK */    
      b_IfGreaterEq (I_NewElmSrc, D_NULL) {
        $USE (D_Workreg2);
        b_ShiftLeftWithDNTC (D_ONE, D_WorkStrCheckElmSize, D_Workreg2);
        b_IfLess (I_NewElmSrc, D_Workreg2) { 
	  $RELEASE (D_Workreg2);
	  break;
        }   
        $RELEASE (D_Workreg2);
      }

         /* $B;XDj$5$l$??7MWAG$,MWAG%5%$%:$N%S%C%HI}$r1[$($?$iNc30(B */
      $RELEASE (D_WorkStrCheckElmSize);
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _TWO, D_WorkExcepArgPos);
      goto Exception;

    case UnboundGroup ():   
      p_MoveWord (D_Workreg, I_NewElmSrc);
      f_DcodeEnqueue4Ope_IIIO (BLT_B_SET_STRING_ELEMENT,
		  I_OldStringSrc, I_IndexSrc, I_NewElmSrc, I_NewStringDst);
      $RELEASE (D_WorkStrCheckElmSize);
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction;
    case ATOM:
    case FloatingGrp ():
    case StructureGroup ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_WorkStrCheckElmSize);
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _TWO, D_WorkExcepArgPos);
      goto Exception;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_set_string_element", "undefined_type");};
      $RELEASE (D_WorkStrCheckElmSize);
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction;
    }

  /* b_set_string_element$B$N<B:]$N=hM}(B */
  f_CopyStringMRB (I_OldStringSrc, I_NewStringDst);

  b_IfWordEq (I_NewStringDst, D_NULL) {
       /* $B%R!<%WNN0hITB-$G!"%9%H%j%s%0$r@8@.$G$-$J$+$C$?;~$O!"(B
        * Dcode $B%4!<%k$r(B enqueue $B$9$k!#(B
        */
    f_DcodeEnqueue4Ope_IIIO
         (BLT_B_SET_STRING_ELEMENT, 
	   I_OldStringSrc, I_IndexSrc, I_NewElmSrc, I_NewStringDst);
    @DEBUG {WARNING ("kblt_b_set_string_element", "Dcode Goal enqueued"); };
  } else {
       /* $B%9%H%j%s%0$r@8@.$G$-$?;~!"?7MWAG$r3JG<$9$k(B */
    s_PutStringElementPosReg
            (I_NewStringDst, I_IndexSrc, D_WorkStrCheckElmSize, I_NewElmSrc);
  }
  $RELEASE (D_WorkStrCheckElmSize);
  $RELEASE (D_Workreg);
  goto End_of_KL1B_Instruction;

 Exception:
  $USE (D_WorkOpCode);
  b_SetImmTypeValueMRBoff (INT, BLT_B_SET_STRING_ELEMENT, D_WorkOpCode);
  $CALL (f_Exception_4Arg_IIIO_Sub(D_WorkExceptionCode, D_WorkOpCode, 
				   D_WorkExcepArgPos, I_OldStringSrc, 
                     I_IndexSrc, I_NewElmSrc, I_NewStringDst) );
  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
 End_of_KL1B_Instruction: ;
}

/******************************************************************** PSL **
kblt_b_binary_string_operation A1, A2, A3, A4, A5, A6, A7, A8

       written by kawai@icot22      on Wed Jul 17 14:43:06 1991

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |   b_binary_string_    |     A1    |     A2    |
    |       operation       |           |           |
    +-----------+-----------+-----------+-----------+
    |    A3     |    A4     |     A5    |     A6    |
    +-----------+-----------+-----------+-----------+
    |    A7     |    A8     |       don't care      |
    +-----------+-----------+-----------+-----------+
<Arguments>
  A1   $BF~NO(B  $B%*%Z%l!<%7%g%s<oJL(B  ($B%l%8%9%?(B)
       ($BL$Dj5A$J$i%5%9%Z%s%I!"@0?t(B0$B!A(B15$B0J30$J$iNc30(B)
  A2   $BF~NO(B  $BBh0l%9%H%j%s%0(B ($B%l%8%9%?(B)
       ($BL$Dj5A$J$i%5%9%Z%s%I!"%9%H%j%s%00J30$J$iNc30(B)
  A3   $BF~NO(B  $BBh0l%9%H%j%s%0$N%*%Z%l!<%7%g%s3+;OMWAG0LCV(B($BCV$-49$((B) ($B%l%8%9%?(B)
       ($BL$Dj5A$J$i%5%9%Z%s%I!"Bh0l%9%H%j%s%0$NMWAGHO0OFb$N@0?t0J30$J$iNc30(B)
  A4   $BF~NO(B  $B%*%Z%l!<%7%g%sBP>]MWAG8D?t(B  ($B%l%8%9%?(B)
       ($BL$Dj5A$J$i%5%9%Z%s%I!"(BA3$B$*$h$S(BA6$B$K$3$NCM$r2C;;$7$?7k2L$,Bh0l$*$h$SBhFs(B
        $B%9%H%j%s%0$NMWAGHO0O$r1[$($?$iNc30(B)
  A5   $BF~NO(B  $BBhFs%9%H%j%s%0(B ($B%l%8%9%?(B)
       ($BL$Dj5A$J$i%5%9%Z%s%I!"%9%H%j%s%00J30$J$iNc30(B)
  A6   $BF~NO(B  $BBhFs%9%H%j%s%0$N%*%Z%l!<%7%g%s3+;OMWAG0LCV(B($BFI$_9~$_(B) ($B%l%8%9%?(B)
       ($BL$Dj5A$J$i%5%9%Z%s%I!"BhFs%9%H%j%s%0$NMWAGHO0OFb$N@0?t0J30$J$iNc30(B)
  A7   $B=PNO(B  $BBh0l%9%H%j%s%0$N=PNO(B  ($B%l%8%9%?(B)
  A8   $B=PNO(B  $BBhFs%9%H%j%s%0$N=PNO(B  ($B%l%8%9%?(B)
	 
<Temporally Used Variables>
<Level>   interpreter
<PreCondition>
  $B!&F~NO$H=PNO$N%l%8%9%?$O!"=EJ#$7$J$$!#(B
<Function>
  $B!&(BA1$B!A(BA6$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B
    $B!&3FF~NO%A%'%C%/$K0z$C3]$+$l$P!"Nc30=hM}!#(B
  $B!&Bh0l%9%H%j%s%0(B(A2)$B$N%*%Z%l!<%7%g%s3+;OMWAG0LCV(B(A3)$B$+$i%*%Z%l!<%7%g%sBP>](B
    $BMWAG8D?t(B(A4)$BJ,$NMWAG$H!"BhFs%9%H%j%s%0(B(A5)$B$N%*%Z%l!<%7%g%s3+;OMWAG0LCV(B(A6)
    $B$+$i%*%Z%l!<%7%g%sBP>]MWAG8D?t(B(A4)$BJ,$NMWAG$H$N4V$G%*%Z%l!<%7%g%s<oJL(B(A1)$B$K(B
    $B1~$8$?1i;;$r9T$$!"$=$N7k2L$GBh0l%9%H%j%s%0$N%*%Z%l!<%7%g%s3+;OMWAG0LCV(B(A3)
    $B$+$i%*%Z%l!<%7%g%sBP>]MWAG8D?t(B(A4)$BJ,$NMWAG$rCV$-49$(!"Bh0l%9%H%j%s%0$N=PNO(B 
    (A7)$B$K%f%K%U%!%$$9$k!#$^$?!"BhFs%9%H%j%s%0$N=PNO(B(A8)$B$K$OBhFs%9%H%j%s%0(B(A5)
    $B$r$=$N$^$^%f%K%U%!%$$9$k!#(B
      $B$J$*!"%*%Z%l!<%7%g%s<oJL(B(A1)$B$O(B0$B!A(B15$B$N@0?t$GM?$($i$l!"Bh0l%9%H%j%s%0$NMWAG(B
    S1$B$HBhFs%9%H%j%s%0$NMWAG(BS2$B$H$N4V$G0J2<$N$h$&$J%S%C%H1i;;$r9T$&!#(B

                                $BF~NO(B(S2,S1)
    $B%*%Z%l!<%7%g%s<oJL(B    (0,0) (0,1) (1,0) (1,1)    $B=PNO(B
           0                0     0     0     0       0
           1                0     0     0     1       S2 AND S1
           2                0     0     1     0       S2 AND (not S1)
           3                0     0     1     1       S2
           4                0     1     0     0       (not S2) AND S1
           5                0     1     0     1       S1
           6                0     1     1     0       S2 XOR S1
           7                0     1     1     1       S2 OR  S1
           8                1     0     0     0       S2 NOR S1
           9                1     0     0     1       S2 not XOR S1
                                                       = not(S2 XOR S1)
          10                1     0     1     0       not S1
          11                1     0     1     1       S2 OR (not S1)
          12                1     1     0     0       not S2
          13                1     1     0     1       (not S2) OR S1
          14                1     1     1     0       S2 NAND S1
          15                1     1     1     1       1

<Examples>
<Test>
<Explanation>
  $BCm0U(B:$BBh0l%9%H%j%s%0$HBhFs%9%H%j%s%0$KF10l$N%9%H%j%s%0$rMQ$$!"Bh0l%9%H%j%s%0$H(B
$B$7$F$NCV$-49$(HO0O$HBhFs%9%H%j%s%0$H$7$F$NFI$_9~$_HO0O$,=EJ#$9$k>l9g!"Bh0l%9%H(B
$B%j%s%0$NMWAG$NCV$-49$($OFI$_9~$_$K1F6A$7$J$$!#(B
 [$BNc(B]
 $B2<$N?^$N$h$&$J>l9g!"(B

          |$BBh0l%9%H%j%s%0$NCV$-49$(HO0O(B |
    +-----+-----+-----+-----+-----+-----+-----+
    |  a  |  b  |  c  |  d  |  e  |  f  |  g  |
    +-----+-----+-----+-----+-----+-----+-----+
    |$BBhFs%9%H%j%s%0$NFI$_9~$_HO0O(B |

 $B1i;;(B(@)$B8e$N3FMWAG$O(B
          |$BBh0l%9%H%j%s%0$NCV$-49$(HO0O(B |
    +-----+-----+-----+-----+-----+-----+-----+
    |  a  | a@b | b@c | c@d | d@e | e@f |  g  |
    +-----+-----+-----+-----+-----+-----+-----+
    |$BBhFs%9%H%j%s%0$NFI$_9~$_HO0O(B |

$B$H$J$j!"2<?^$N$h$&$K$O$J$i$J$$!#(B

          |$BBh0l%9%H%j%s%0$NCV$-49$(HO0O(B ->
    +-----+-------+---------+-------------+-----------------+--\\
    |  a  |  a@b  | (a@b)@c | ((a@b)@c)@d | (((a@b)@c)@d)@e |
    +-----+-------+---------+-------------+-----------------+--\\
    |$BBhFs%9%H%j%s%0$NFI$_9~$_HO0O(B ->

                           ->|
    \\--+--------------------+-----+
        | (((a@b)@c)@d)@e)@f |  g  |
    \\--+--------------------+-----+
      ->|
<ETC>
********************************************************************* PSL **/


#CONST_define _STRING_OPERATION_MIN  0
#CONST_define _STRING_OPERATION_MAX  15

#DATA_define  D_WorkTotalStrLength  XXX
#DATA_define  D_WorkStrCheckElmSize1  XXX

#OPF_define I_OperationSrc  _IndirectRegField1  /* Operation kind(src) */
#OPF_define I_OldStr1Src    _IndirectRegField2  /* Old string1 (src) */
#OPF_define I_Str1PosSrc    _IndirectRegField3  /* String1 position (src) */
#OPF_define I_LengthSrc     _IndirectRegField4  /* Target length (src) */
#OPF_define I_OldStr2Src    _IndirectRegField5  /* Old string2 (src) */
#OPF_define I_Str2PosSrc    _IndirectRegField6  /* String2 position (src) */
#OPF_define I_NewStr1Dst    _IndirectRegField7  /* New string1 (dst) */
#OPF_define I_NewStr2Dst    _IndirectRegField8  /* New string2 (dst) */

#PSL_define kblt_b_binary_string_operation () 
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp8ArgVect_IIIIIIOO_Sub(D_WorkArgVect,
					    I_OperationSrc,
					    I_OldStr1Src,
					    I_Str1PosSrc,
					    I_LengthSrc,
					    I_OldStr2Src,
					    I_Str2PosSrc,
					    I_NewStr1Dst,
					    I_NewStr2Dst) );
	f_TraceBodyBuiltin(BLT_B_BINARY_STRING_OPERATION, D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE (D_Workreg);
  /* $BBh(B0$B0z?t(B($B%9%H%j%s%0%*%Z%l!<%7%g%s<oN`(B)$B$N%A%'%C%/(B */
  f_ActiveDeref (I_OperationSrc, D_Workreg);
  TypeSwitch (I_OperationSrc) {
    case INT:
      b_IfLessImm(I_OperationSrc, _STRING_OPERATION_MIN)
	{
	  $RELEASE (D_Workreg);
	  $USE (D_WorkExceptionCode);
	  $USE(D_WorkExcepArgPos);
	  b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP,
				   D_WorkExceptionCode);
	  b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
	  goto Exception;
	}
      b_IfGreaterImm(I_OperationSrc, _STRING_OPERATION_MAX)
	{
	  $RELEASE (D_Workreg);
	  $USE (D_WorkExceptionCode);
	  $USE(D_WorkExcepArgPos);
	  b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP,
				   D_WorkExceptionCode);
	  b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
	  goto Exception;
	}
      break;
    case UnboundGroup ():   
      p_MoveWord (D_Workreg, I_OperationSrc);
      f_DcodeEnqueue8Ope_IIIIIIOO (BLT_B_BINARY_STRING_OPERATION,
				   I_OperationSrc,
				   I_OldStr1Src,
				   I_Str1PosSrc,
				   I_LengthSrc,
				   I_OldStr2Src,
				   I_Str2PosSrc,
				   I_NewStr1Dst,
				   I_NewStr2Dst);
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; break;
    case ATOM:
    case StringGrp ():
    case FloatingGrp ():
    case ListGrp ():
    case NullVectorGrp ():
    case ShortVectorGrp ():
    case LongVectorGrp ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
      goto Exception; break;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_binary_string_operation",
			  "undefined_type");};
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; break;
    }


  /* $BBh(B1$B0z?t(B(String1)$B$N%A%'%C%/(B */
  f_ActiveDeref (I_OldStr1Src, D_Workreg);
  TypeSwitch (I_OldStr1Src) {
    case StringGrp (): break;   /* $B%9%H%j%s%0$J$iDL$7(B */
    case UnboundGroup ():   
      p_MoveWord (D_Workreg, I_OldStr1Src);
      f_DcodeEnqueue8Ope_IIIIIIOO (BLT_B_BINARY_STRING_OPERATION,
				   I_OperationSrc,
				   I_OldStr1Src,
				   I_Str1PosSrc,
				   I_LengthSrc,
				   I_OldStr2Src,
				   I_Str2PosSrc,
				   I_NewStr1Dst,
				   I_NewStr2Dst);
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; break;
    case ConstantGroup ():
    case ListGrp ():
    case NullVectorGrp ():
    case ShortVectorGrp ():
    case LongVectorGrp ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
      goto Exception; break;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_binary_string_operation",
			  "undefined_type");};
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; break;
    }

  /* $BBh(B2$B0z?t(B(String1$B$N(BPosition1)$B$N%A%'%C%/(B */
  f_ActiveDeref (I_Str1PosSrc, D_Workreg);
  TypeSwitch (I_Str1PosSrc) {
    case INT:
      b_IfGreaterEq (I_Str1PosSrc, D_NULL) {
	/* Position1$B$,Ii$G$J$1$l$P(B */
        $USE (D_WorkStrCheckLength);
        s_GetStringType (I_OldStr1Src, D_WorkStrCheckLength, D_VOID);
        b_IfLessEq (I_Str1PosSrc, D_WorkStrCheckLength) {
          /* Position1$B$,%9%H%j%s%0D90J2<$J$i$PDL$7(B */
	  /* $B<!$N0z?t$N%A%'%C%/$K0\$k(B */
	  /* D_WorkStrCheckLength$B$O<!$N0z?t%A%'%C%/$G$b;H$&$N$G(B
	     $B$^$@%j%j!<%9$7$J$$(B */
          break;
        } else {
	  b_IfEqual(I_Str1PosSrc, D_NULL) {
	    b_IfEqual(D_WorkStrCheckLength, D_NULL) {
	      /* NULLstring$B$G$b!"(BPosition1$B$,(B0$B$J$iDL$7(B */
	      /* $B<!$N0z?t$N%A%'%C%/$K0\$k(B */
	      /* D_WorkStrCheckLength$B$O<!$N0z?t%A%'%C%/$G$b;H$&$N$G(B
		 $B$^$@%j%j!<%9$7$J$$(B */
	      break;
	    }
	  }
	}
        $RELEASE (D_WorkStrCheckLength);
      }
      /* $B;XDj$5$l$?MWAG0LCV$,Ii$^$?$OMWAGD9$h$jD9$1$l$PNc30(B */
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _TWO, D_WorkExcepArgPos);
      goto Exception; 

    case UnboundGroup ():   
      p_MoveWord (D_Workreg, I_Str1PosSrc);
      f_DcodeEnqueue8Ope_IIIIIIOO (BLT_B_BINARY_STRING_OPERATION,
				   I_OperationSrc,
				   I_OldStr1Src,
				   I_Str1PosSrc,
				   I_LengthSrc,
				   I_OldStr2Src,
				   I_Str2PosSrc,
				   I_NewStr1Dst,
				   I_NewStr2Dst);
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; 
    case ATOM:
    case FloatingGrp ():
    case StructureGroup ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _TWO, D_WorkExcepArgPos);
      goto Exception;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_binary_string_operation",
			  "undefined_type");};
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; 
    }

  /* $BBh(B3$B0z?t(B($B%*%Z%l!<%7%g%sBP>]HO0O(B)$B$N%A%'%C%/(B */
  f_ActiveDeref (I_LengthSrc, D_Workreg);
  TypeSwitch (I_LengthSrc) {
    case INT:
      b_IfGreaterEq (I_LengthSrc, D_NULL) {
	$USE (D_WorkTotalStrLength);
	b_AddWithDNTC(I_Str1PosSrc, I_LengthSrc, D_WorkTotalStrLength);
	b_IfLessEq(D_WorkTotalStrLength, D_WorkStrCheckLength) {
	  /* $B%*%Z%l!<%7%g%sBP>]HO0O$,%9%H%j%s%0D9Fb$K<}$^$C$F$$$l$PDL$7(B */
	  $RELEASE (D_WorkStrCheckLength);
	  $RELEASE (D_WorkTotalStrLength);
	  break;
	}
	$RELEASE (D_WorkTotalStrLength);
      }
      /* $B;XDj$5$l$?%*%Z%l!<%7%g%sBP>]HO0O$,Ii$^$?$OMWAGD90J>e$J$i$PNc30(B */
      $RELEASE (D_WorkStrCheckLength);
      $RELEASE (D_Workreg);

      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _THREE, D_WorkExcepArgPos);
      goto Exception; 

    case UnboundGroup ():   
      p_MoveWord (D_Workreg, I_LengthSrc);
      f_DcodeEnqueue8Ope_IIIIIIOO (BLT_B_BINARY_STRING_OPERATION,
				   I_OperationSrc,
				   I_OldStr1Src,
				   I_Str1PosSrc,
				   I_LengthSrc,
				   I_OldStr2Src,
				   I_Str2PosSrc,
				   I_NewStr1Dst,
				   I_NewStr2Dst);
      $RELEASE (D_Workreg);
      $RELEASE (D_WorkStrCheckLength);
      goto End_of_KL1B_Instruction; 
    case ATOM:
    case FloatingGrp ():
    case StructureGroup ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg);
      $RELEASE (D_WorkStrCheckLength);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _THREE, D_WorkExcepArgPos);
      goto Exception;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_binary_string_operation",
			  "undefined_type");};
      $RELEASE (D_Workreg);
      $RELEASE (D_WorkStrCheckLength);
      goto End_of_KL1B_Instruction; 
    }


  /* $BBh(B4$B0z?t(B(String2)$B$N%A%'%C%/(B */
  f_ActiveDeref (I_OldStr2Src, D_Workreg);
  TypeSwitch (I_OldStr2Src) {
    case StringGrp (): break;  /* $B%9%H%j%s%0$J$iDL$7(B */
    case UnboundGroup ():   
      p_MoveWord (D_Workreg, I_OldStr2Src);
      f_DcodeEnqueue8Ope_IIIIIIOO (BLT_B_BINARY_STRING_OPERATION,
				   I_OperationSrc,
				   I_OldStr1Src,
				   I_Str1PosSrc,
				   I_LengthSrc,
				   I_OldStr2Src,
				   I_Str2PosSrc,
				   I_NewStr1Dst,
				   I_NewStr2Dst);
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; break;
    case ConstantGroup ():
    case ListGrp ():
    case NullVectorGrp ():
    case ShortVectorGrp ():
    case LongVectorGrp ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _FOUR, D_WorkExcepArgPos);
      goto Exception; break;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_binary_string_operation",
			  "undefined_type");};
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; break;
    }


  /* $BBh(B5$B0z?t(B(String2$B$N(BPosition2)$B$N%A%'%C%/(B */
  f_ActiveDeref (I_Str2PosSrc, D_Workreg);
  TypeSwitch (I_Str2PosSrc) {
    case INT:
      b_IfGreaterEq (I_Str2PosSrc, D_NULL) {              
        $USE (D_WorkStrCheckLength);
        s_GetStringType (I_OldStr2Src, D_WorkStrCheckLength, D_VOID);
        b_IfLessEq (I_Str2PosSrc, D_WorkStrCheckLength) {
	  /* D_WorkStrCheckLength$B$O8e$G;H$&$?$a!"$3$3$G$O%j%j!<%9$7$J$$(B */
          break;
        } else {
	  b_IfEqual(I_Str2PosSrc, D_NULL) {
	    b_IfEqual(D_WorkStrCheckLength, D_NULL) {
	      /* NULLstring$B$G$b(BPosition2$B$,(B0$B$J$i$PDL$7(B */
	      /* $B<!$N0z?t$N%A%'%C%/$K0\$k(B */
	      /* D_WorkStrCheckLength$B$O<!$N0z?t%A%'%C%/$G$b;H$&$N$G(B
		 $B$^$@%j%j!<%9$7$J$$(B */
	      break;
	    }
	  }
	}
        $RELEASE (D_WorkStrCheckLength);
      }
      /* $B;XDj$5$l$?MWAG0LCV$,Ii$^$?$OMWAGD90J>e$J$i$PNc30(B */
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _FIVE, D_WorkExcepArgPos);
      goto Exception; 

    case UnboundGroup ():   
      p_MoveWord (D_Workreg, I_Str2PosSrc);
      f_DcodeEnqueue8Ope_IIIIIIOO (BLT_B_BINARY_STRING_OPERATION,
				   I_OperationSrc,
				   I_OldStr1Src,
				   I_Str1PosSrc,
				   I_LengthSrc,
				   I_OldStr2Src,
				   I_Str2PosSrc,
				   I_NewStr1Dst,
				   I_NewStr2Dst);
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; 
    case ATOM:
    case FloatingGrp ():
    case StructureGroup ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _FIVE, D_WorkExcepArgPos);
      goto Exception;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_binary_string_operation",
			  "undefined_type");};
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; 
    }
  $RELEASE (D_Workreg);

  /* $BBh(B3$B0z?t(B($B%*%Z%l!<%7%g%sBP>]HO0O(B)$B$N:F%A%'%C%/(B */
  $USE (D_WorkTotalStrLength);
  b_AddWithDNTC(I_Str2PosSrc, I_LengthSrc, D_WorkTotalStrLength);
  b_IfGreater(D_WorkTotalStrLength, D_WorkStrCheckLength) {
    /* $B;XDj$5$l$?%*%Z%l!<%7%g%sBP>]HO0O$N=*C<$,MWAGD9$h$jD9$1$l$PNc30(B */
    $RELEASE (D_WorkStrCheckLength);
    $RELEASE (D_WorkTotalStrLength);

    $USE (D_WorkExceptionCode);
    $USE(D_WorkExcepArgPos);
    b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
    b_SetImmTypeValueMRBoff (INT, _THREE, D_WorkExcepArgPos);
    goto Exception; 
  }
  $RELEASE (D_WorkStrCheckLength);
  $RELEASE (D_WorkTotalStrLength);


  /* $BBh(B1, 4$B0z?t(B($BMWAG%5%$%:F10l@-(B)$B$N%A%'%C%/(B */
  $USE(D_WorkStrCheckElmSize);
  $USE(D_WorkStrCheckElmSize1);

  s_GetStringType (I_OldStr1Src, D_VOID, D_WorkStrCheckElmSize);
  s_GetStringType (I_OldStr2Src, D_VOID, D_WorkStrCheckElmSize1);
  b_IfNotEqual(D_WorkStrCheckElmSize, D_WorkStrCheckElmSize1)
    {
      $RELEASE (D_WorkStrCheckElmSize);
      $RELEASE (D_WorkStrCheckElmSize1);

      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _FOUR, D_WorkExcepArgPos);
      goto Exception; 
    }
  $RELEASE (D_WorkStrCheckElmSize);
  $RELEASE (D_WorkStrCheckElmSize1);


  /***************************************/
  /* binary_string_operation$B$N<B:]$N=hM}(B */
  /***************************************/

  f_CopyStringMRB (I_OldStr1Src, I_NewStr1Dst);

  b_IfWordEq (I_NewStr1Dst, D_NULL) {
    /* $B%R!<%WNN0hITB-$G!"%9%H%j%s%0$r@8@.$G$-$J$+$C$?;~$O!"(B
       Dcode $B%4!<%k$r(B enqueue $B$9$k!#(B */

      f_DcodeEnqueue8Ope_IIIIIIOO (BLT_B_BINARY_STRING_OPERATION,
				   I_OperationSrc,
				   I_OldStr1Src,
				   I_Str1PosSrc,
				   I_LengthSrc,
				   I_OldStr2Src,
				   I_Str2PosSrc,
				   I_NewStr1Dst,
				   I_NewStr2Dst);
    @DEBUG {WARNING ("kblt_b_binary_string_operation",
		     "Dcode Goal enqueued by Heap Shortage"); };
  } else {
    /* $B%9%H%j%s%0$r@8@.$G$-$?;~!"%*%Z%l!<%7%g%s$r9T$&(B */
    $CALL( f_BinaryStringOpe_Sub(I_OperationSrc,
				 I_NewStr1Dst,
				 I_Str1PosSrc,
				 I_LengthSrc,
				 I_OldStr2Src,
				 I_Str2PosSrc) );
    p_MoveWord(I_OldStr2Src, I_NewStr2Dst);
  }

  goto End_of_KL1B_Instruction;

 Exception:
  $USE (D_WorkOpCode);
  b_SetImmTypeValueMRBoff (INT, BLT_B_BINARY_STRING_OPERATION, D_WorkOpCode);
  $CALL (f_Exception_8Arg_IIIIIIOO_Sub(D_WorkExceptionCode, D_WorkOpCode, 
				       D_WorkExcepArgPos,
				       I_OperationSrc,
				       I_OldStr1Src,
				       I_Str1PosSrc,
				       I_LengthSrc,
				       I_OldStr2Src,
				       I_Str2PosSrc,
				       I_NewStr1Dst,
				       I_NewStr2Dst) );

  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
 End_of_KL1B_Instruction: ;
}

/******************************************************************** PSL **
kblt_b_shifting_string_operation A1, A2, A3, A4, A5, A6

       written by kawai@icot22      on Wed Jul 17 14:44:02 1991

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |   b_shifting_string_  |     A1    |     A2    |
    |       operation       |           |           |
    +-----------+-----------+-----------+-----------+
    |    A3     |    A4     |     A5    |     A6    |
    +-----------+-----------+-----------+-----------+
<Arguments>
  A1   $BF~NO(B  $B%*%Z%l!<%7%g%s<oJL(B  ($B%l%8%9%?(B)
       ($BL$Dj5A$J$i%5%9%Z%s%I!"@0?t(B0$B!A(B15$B0J30$J$iNc30(B)
  A2   $BF~NO(B  $B%9%H%j%s%0(B ($B%l%8%9%?(B)
       ($BL$Dj5A$J$i%5%9%Z%s%I!"%9%H%j%s%00J30$J$iNc30(B)
  A3   $BF~NO(B  $B%9%H%j%s%0$N%*%Z%l!<%7%g%s3+;OMWAG0LCV(B($BCV$-49$((B) ($B%l%8%9%?(B)
       ($BL$Dj5A$J$i%5%9%Z%s%I!"%9%H%j%s%0$NMWAGHO0OFb$N@0?t0J30$J$iNc30(B)
  A4   $BF~NO(B  $B%*%Z%l!<%7%g%sBP>]MWAG8D?t(B  ($B%l%8%9%?(B)
       ($BL$Dj5A$J$i%5%9%Z%s%I!"(BA3$B$*$h$S(BA5$B$K$3$NCM$r2C;;$7$?7k2L$,%9%H%j%s%0$N(B
        $BMWAGHO0O$r1[$($?$iNc30(B)
  A5   $BF~NO(B  $B%9%H%j%s%0$N%*%Z%l!<%7%g%s3+;OMWAG0LCV(B($BFI$_9~$_(B) ($B%l%8%9%?(B)
       ($BL$Dj5A$J$i%5%9%Z%s%I!"%9%H%j%s%0$NMWAGHO0OFb$N@0?t0J30$J$iNc30(B)
  A6   $B=PNO(B  $B%9%H%j%s%0$N=PNO(B  ($B%l%8%9%?(B)
	 
<Temporally Used Variables>
<Level>   interpreter
<PreCondition>
  $B!&F~NO$H=PNO$N%l%8%9%?$O!"=EJ#$7$J$$!#(B
<Function>
  $B!&(BA1$B!A(BA5$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B
    $B!&3FF~NO%A%'%C%/$K0z$C3]$+$l$P!"Nc30=hM}!#(B
  $B!&%9%H%j%s%0(B(A2)$B$N%*%Z%l!<%7%g%s3+;OMWAG0LCV(B(A3)$B$+$i%*%Z%l!<%7%g%sBP>](B
    $BMWAG8D?t(B(A4)$BJ,$NMWAG$H!"F10l%9%H%j%s%0(B(A2)$B$N%*%Z%l!<%7%g%s3+;OMWAG0LCV(B(A5)
    $B$+$i%*%Z%l!<%7%g%sBP>]MWAG8D?t(B(A4)$BJ,$NMWAG$H$N4V$G%*%Z%l!<%7%g%s<oJL(B(A1)$B$K(B
    $B1~$8$?1i;;$r9T$$!"$=$N7k2L$G%9%H%j%s%0$N%*%Z%l!<%7%g%s3+;OMWAG0LCV(B(A3)
    $B$+$i%*%Z%l!<%7%g%sBP>]MWAG8D?t(B(A4)$BJ,$NMWAG$rCV$-49$(!"%9%H%j%s%0$N=PNO(B (A6)
    $B$K%f%K%U%!%$$9$k!#(B
      $B$J$*!"%*%Z%l!<%7%g%s<oJL(B(A1)$B$O(B0$B!A(B15$B$N@0?t$GM?$($i$l!"%9%H%j%s%0$NMWAG(B
    (A3$B$+$i;O$^$k(BA4$B8DJ,$N3FMWAG(B)S1$B$HBhFs%9%H%j%s%0$NMWAG(B(A5$B$+$i;O$^$k(BA4$B8DJ,$N(B
    $B3FMWAG(B)S2$B$H$N4V$G0J2<$N$h$&$J%S%C%H1i;;$r9T$&!#(B
    

                                $BF~NO(B(S2,S1)
    $B%*%Z%l!<%7%g%s<oJL(B    (0,0) (0,1) (1,0) (1,1)    $B=PNO(B
           0                0     0     0     0       0
           1                0     0     0     1       S2 AND S1
           2                0     0     1     0       S2 AND (not S1)
           3                0     0     1     1       S2
           4                0     1     0     0       (not S2) AND S1
           5                0     1     0     1       S1
           6                0     1     1     0       S2 XOR S1
           7                0     1     1     1       S2 OR  S1
           8                1     0     0     0       S2 NOR S1
           9                1     0     0     1       S2 not XOR S1
                                                       = not(S2 XOR S1)
          10                1     0     1     0       not S1
          11                1     0     1     1       S2 OR (not S1)
          12                1     1     0     0       not S2
          13                1     1     0     1       (not S2) OR S1
          14                1     1     1     0       S2 NAND S1
          15                1     1     1     1       1

<Examples>
<Test>
<Explanation>
  $BCm0U(B:$B%9%H%j%s%0>e$G$NCV$-49$(HO0O$HFI$_9~$_HO0O$,=EJ#$9$k>l9g!"%9%H%j%s%0$N(B
       $BMWAG$NCV$-49$($OFI$_9~$_$K1F6A$7$J$$!#(B
 [$BNc(B]
 $B2<$N?^$N$h$&$J>l9g!"(B

          |  $B%9%H%j%s%0$NCV$-49$(HO0O(B   |
    +-----+-----+-----+-----+-----+-----+-----+
    |  a  |  b  |  c  |  d  |  e  |  f  |  g  |
    +-----+-----+-----+-----+-----+-----+-----+
    |  $B%9%H%j%s%0$NFI$_9~$_HO0O(B   |

 $B1i;;(B(@)$B8e$N3FMWAG$O(B
          |  $B%9%H%j%s%0$NCV$-49$(HO0O(B   |
    +-----+-----+-----+-----+-----+-----+-----+
    |  a  | a@b | b@c | c@d | d@e | e@f |  g  |
    +-----+-----+-----+-----+-----+-----+-----+
    |  $B%9%H%j%s%0$NFI$_9~$_HO0O(B   |

$B$H$J$j!"2<?^$N$h$&$K$O$J$i$J$$!#(B

          |$B%9%H%j%s%0$NCV$-49$(HO0O(B ->
    +-----+-------+---------+-------------+-----------------+--\\
    |  a  |  a@b  | (a@b)@c | ((a@b)@c)@d | (((a@b)@c)@d)@e |
    +-----+-------+---------+-------------+-----------------+--\\
    |$B%9%H%j%s%0$NFI$_9~$_HO0O(B ->

                           ->|
    \\--+--------------------+-----+
        | (((a@b)@c)@d)@e)@f |  g  |
    \\--+--------------------+-----+
      ->|
<ETC>
********************************************************************* PSL **/

#OPF_define I_OperationSrc  _IndirectRegField1  /* Operation kind(src) */
#OPF_define I_OldStr1Src    _IndirectRegField2  /* Old string1 (src) */
#OPF_define I_Str1PosSrc    _IndirectRegField3  /* String1 position (src) */
#OPF_define I_LengthSrc     _IndirectRegField4  /* Target length (src) */
#OPF_define I_Str2PosSrc    _IndirectRegField5  /* String2 position (src) */
#OPF_define I_NewStr1Dst    _IndirectRegField6  /* New string1 (dst) */

#PSL_define kblt_b_shifting_string_operation () 
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp6ArgVect_IIIIIO_Sub(D_WorkArgVect,
					  I_OperationSrc,
					  I_OldStr1Src,
					  I_Str1PosSrc,
					  I_LengthSrc,
					  I_Str2PosSrc,
					  I_NewStr1Dst) );
	f_TraceBodyBuiltin(BLT_B_SHIFTING_STRING_OPERATION, D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE (D_Workreg);
  /* $BBh(B0$B0z?t(B($B%9%H%j%s%0%*%Z%l!<%7%g%s<oN`(B)$B$N%A%'%C%/(B */
  f_ActiveDeref (I_OperationSrc, D_Workreg);
  TypeSwitch (I_OperationSrc) {
    case INT:
      b_IfLessImm(I_OperationSrc, _STRING_OPERATION_MIN)
	{
	  $RELEASE (D_Workreg);
	  $USE (D_WorkExceptionCode);
	  $USE(D_WorkExcepArgPos);
	  b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP,
				   D_WorkExceptionCode);
	  b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
	  goto Exception;
	}
      b_IfGreaterImm(I_OperationSrc, _STRING_OPERATION_MAX)
	{
	  $RELEASE (D_Workreg);
	  $USE (D_WorkExceptionCode);
	  $USE(D_WorkExcepArgPos);
	  b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP,
				   D_WorkExceptionCode);
	  b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
	  goto Exception;
	}
      break;
    case UnboundGroup ():   
      p_MoveWord (D_Workreg, I_OperationSrc);
      f_DcodeEnqueue6Ope_IIIIIO (BLT_B_SHIFTING_STRING_OPERATION,
				 I_OperationSrc,
				 I_OldStr1Src,
				 I_Str1PosSrc,
				 I_LengthSrc,
				 I_Str2PosSrc,
				 I_NewStr1Dst);
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; break;
    case ATOM:
    case StringGrp ():
    case FloatingGrp ():
    case ListGrp ():
    case NullVectorGrp ():
    case ShortVectorGrp ():
    case LongVectorGrp ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
      goto Exception; break;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_shifting_string_operation",
			  "undefined_type");};
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; break;
    }


  /* $BBh(B1$B0z?t(B(String1)$B$N%A%'%C%/(B */
  f_ActiveDeref (I_OldStr1Src, D_Workreg);
  TypeSwitch (I_OldStr1Src) {
    case StringGrp (): break;  /* $B%9%H%j%s%0$J$iDL$7(B */
    case UnboundGroup ():   
      p_MoveWord (D_Workreg, I_OldStr1Src);
      f_DcodeEnqueue6Ope_IIIIIO (BLT_B_SHIFTING_STRING_OPERATION,
				 I_OperationSrc,
				 I_OldStr1Src,
				 I_Str1PosSrc,
				 I_LengthSrc,
				 I_Str2PosSrc,
				 I_NewStr1Dst);
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; break;
    case ConstantGroup ():
    case ListGrp ():
    case NullVectorGrp ():
    case ShortVectorGrp ():
    case LongVectorGrp ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
      goto Exception; break;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_shifting_string_operation",
			  "undefined_type");};
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; break;
    }

  /* $BBh(B2$B0z?t(B(String1$B$N(BPosition1)$B$N%A%'%C%/(B */
  f_ActiveDeref (I_Str1PosSrc, D_Workreg);
  TypeSwitch (I_Str1PosSrc) {
    case INT:
      b_IfGreaterEq (I_Str1PosSrc, D_NULL) {              
        $USE (D_WorkStrCheckLength);
        s_GetStringType (I_OldStr1Src, D_WorkStrCheckLength, D_VOID);
        b_IfLessEq (I_Str1PosSrc, D_WorkStrCheckLength) {
	  /* $B<!$N0z?t$N%A%'%C%/$K0\$k(B */
	  /* D_WorkStrCheckLength$B$O<!$N0z?t%A%'%C%/$G$b;H$&$N$G(B
	     $B$^$@%j%j!<%9$7$J$$(B */
          break;
        } else {
	  b_IfEqual(I_Str1PosSrc, D_NULL) {
	    b_IfEqual(D_WorkStrCheckLength, D_NULL) {
	      /* NULLstring$B$G$b(BPosition1$B$,(B0$B$J$iDL$7(B */
	      /* $B<!$N0z?t$N%A%'%C%/$K0\$k(B(NULLstring$B$N>l9g(B) */
	      /* D_WorkStrCheckLength$B$O<!$N0z?t%A%'%C%/$G$b;H$&$N$G(B
		 $B$^$@%j%j!<%9$7$J$$(B */
	      break;
	    }
	  }
	}
        $RELEASE (D_WorkStrCheckLength);
      }
      /* $B;XDj$5$l$?MWAG0LCV$,Ii$^$?$OMWAGD90J>e$J$i$PNc30(B */
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _TWO, D_WorkExcepArgPos);
      goto Exception; 

    case UnboundGroup ():   
      p_MoveWord (D_Workreg, I_Str1PosSrc);
      f_DcodeEnqueue6Ope_IIIIIO (BLT_B_SHIFTING_STRING_OPERATION,
				 I_OperationSrc,
				 I_OldStr1Src,
				 I_Str1PosSrc,
				 I_LengthSrc,
				 I_Str2PosSrc,
				 I_NewStr1Dst);
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; 
    case ATOM:
    case FloatingGrp ():
    case StructureGroup ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _TWO, D_WorkExcepArgPos);
      goto Exception;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_shifting_string_operation",
			  "undefined_type");};
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; 
    }

  /* $BBh(B3$B0z?t(B($B%*%Z%l!<%7%g%sBP>]HO0O(B)$B$N%A%'%C%/(B */
  f_ActiveDeref (I_LengthSrc, D_Workreg);
  TypeSwitch (I_LengthSrc) {
    case INT:
      b_IfGreaterEq (I_LengthSrc, D_NULL) {
	$USE (D_WorkTotalStrLength);
	b_AddWithDNTC(I_Str1PosSrc, I_LengthSrc, D_WorkTotalStrLength);
	b_IfLessEq(D_WorkTotalStrLength, D_WorkStrCheckLength) {
	  /* D_WorkStrCheckLength$B$O$^$@%j%j!<%9$5$l$F$$$J$$H&!#(B
             $B$3$N8e$N%A%'%C%/$G$b;H$&$N$G$^$@%j%j!<%9$7$J$$(B */
	  $RELEASE (D_WorkTotalStrLength);
	  break;
	}
	$RELEASE (D_WorkTotalStrLength);
      }
      /* $B;XDj$5$l$?%*%Z%l!<%7%g%sBP>]HO0O$,Ii$^$?$OMWAGD90J>e$J$i$PNc30(B */
      $RELEASE (D_Workreg);  
      $RELEASE (D_WorkStrCheckLength); /* $BNc30=hM}$KHt$V>l9g$O$3$3$G(B */
	                               /* $B%j%j!<%9$9$k(B */

      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _THREE, D_WorkExcepArgPos);
      goto Exception; 

    case UnboundGroup ():   
      p_MoveWord (D_Workreg, I_LengthSrc);
      f_DcodeEnqueue6Ope_IIIIIO (BLT_B_SHIFTING_STRING_OPERATION,
				 I_OperationSrc,
				 I_OldStr1Src,
				 I_Str1PosSrc,
				 I_LengthSrc,
				 I_Str2PosSrc,
				 I_NewStr1Dst);
      $RELEASE (D_Workreg);
      $RELEASE (D_WorkStrCheckLength);
      goto End_of_KL1B_Instruction; 
    case ATOM:
    case FloatingGrp ():
    case StructureGroup ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg);
      $RELEASE (D_WorkStrCheckLength);   /* $BNc30=hM}$KHt$V>l9g$O(B */
                                         /* $B$3$3$G%j%j!<%9$9$k(B */
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _THREE, D_WorkExcepArgPos);
      goto Exception;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_shifting_string_operation",
			  "undefined_type");};
      $RELEASE (D_Workreg);
      $RELEASE (D_WorkStrCheckLength);
      goto End_of_KL1B_Instruction; 
    }


  /* $BBh(B4$B0z?t(B(String2$B$N(BPosition2)$B$N%A%'%C%/(B */
  f_ActiveDeref (I_Str2PosSrc, D_Workreg);
  TypeSwitch (I_Str2PosSrc) {
    case INT:
      b_IfGreaterEq (I_Str2PosSrc, D_NULL) {              
        b_IfLessEq (I_Str2PosSrc, D_WorkStrCheckLength) {
	  /* D_WorkStrCheckLength$B$O8e$G;H$&$?$a!"$3$3$G$O%j%j!<%9$7$J$$(B */
          break;
        } else {
	  b_IfEqual(I_Str2PosSrc, D_NULL) {
	    b_IfEqual(D_WorkStrCheckLength, D_NULL) {
	      /* NULLstring$B$G$b(BPosition2$B$,(B0$B$J$iDL$7(B */
	      /* $B<!$N0z?t$N%A%'%C%/$K0\$k(B */
	      /* D_WorkStrCheckLength$B$O<!$N0z?t%A%'%C%/$G$b;H$&$N$G(B
		 $B$^$@%j%j!<%9$7$J$$(B */
	      break;
	    }
	  }
	}
      }
      /* $B;XDj$5$l$?MWAG0LCV$,Ii$^$?$OMWAGD90J>e$J$i$PNc30(B */
      $RELEASE (D_Workreg);
      $RELEASE (D_WorkStrCheckLength); /* $BNc30=hM}$KHt$V>l9g$O$3$3$G(B */
	                               /* $B%j%j!<%9$9$k(B */

      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _FOUR, D_WorkExcepArgPos);
      goto Exception; 

    case UnboundGroup ():   
      p_MoveWord (D_Workreg, I_Str2PosSrc);
      f_DcodeEnqueue6Ope_IIIIIO (BLT_B_SHIFTING_STRING_OPERATION,
				 I_OperationSrc,
				 I_OldStr1Src,
				 I_Str1PosSrc,
				 I_LengthSrc,
				 I_Str2PosSrc,
				 I_NewStr1Dst);
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; 
    case ATOM:
    case FloatingGrp ():
    case StructureGroup ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg);
      $RELEASE (D_WorkStrCheckLength); /* $BNc30=hM}$KHt$V>l9g$O$3$3$G(B */
	                               /* $B%j%j!<%9$9$k(B */
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _FOUR, D_WorkExcepArgPos);
      goto Exception;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_shifting_string_operation",
			  "undefined_type");};
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; 
    }

  $RELEASE (D_Workreg);


  /* $BBh(B3$B0z?t(B($B%*%Z%l!<%7%g%sBP>]HO0O(B)$B$N:F%A%'%C%/(B */
  $USE (D_WorkTotalStrLength);
  b_AddWithDNTC(I_Str2PosSrc, I_LengthSrc, D_WorkTotalStrLength);
  b_IfGreater(D_WorkTotalStrLength, D_WorkStrCheckLength) {
    /* $B;XDj$5$l$?%*%Z%l!<%7%g%sBP>]HO0O$N=*C<$,MWAGD9$h$jD9$1$l$PNc30(B */
    $RELEASE (D_WorkStrCheckLength);  /* $BNc30=hM}$KHt$V>l9g$O(B */
                                      /* $B$3$3$G%j%j!<%9$9$k(B */
    $RELEASE (D_WorkTotalStrLength);

    $USE (D_WorkExceptionCode);
    $USE(D_WorkExcepArgPos);
    b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
    b_SetImmTypeValueMRBoff (INT, _THREE, D_WorkExcepArgPos);
    goto Exception; 
  }

  $RELEASE (D_WorkStrCheckLength);
  $RELEASE (D_WorkTotalStrLength);


  /*****************************************/
  /* shifting_string_operation$B$N<B:]$N=hM}(B */
  /*****************************************/

  f_CopyStringMRB (I_OldStr1Src, I_NewStr1Dst);

  b_IfWordEq (I_NewStr1Dst, D_NULL) {
    /* $B%R!<%WNN0hITB-$G!"%9%H%j%s%0$r@8@.$G$-$J$+$C$?;~$O!"(B
       Dcode $B%4!<%k$r(B enqueue $B$9$k!#(B */

      f_DcodeEnqueue6Ope_IIIIIO (BLT_B_SHIFTING_STRING_OPERATION,
				 I_OperationSrc,
				 I_OldStr1Src,
				 I_Str1PosSrc,
				 I_LengthSrc,
				 I_Str2PosSrc,
				 I_NewStr1Dst);
    @DEBUG {WARNING ("kblt_b_shifting_string_operation",
		     "Dcode Goal enqueued by Heap Shortage"); };
  } else {
    /* $B%9%H%j%s%0$r@8@.$G$-$?;~!"%*%Z%l!<%7%g%s$r9T$&(B */
    $CALL( f_ShiftingStringOpe_Sub(I_OperationSrc,
				   I_NewStr1Dst,
				   I_Str1PosSrc,
				   I_LengthSrc,
				   I_Str2PosSrc) );
  }
  goto End_of_KL1B_Instruction;

 Exception:
  $USE (D_WorkOpCode);
  b_SetImmTypeValueMRBoff (INT, BLT_B_SHIFTING_STRING_OPERATION, D_WorkOpCode);
  $CALL (f_Exception_6Arg_IIIIIO_Sub(D_WorkExceptionCode, D_WorkOpCode, 
				     D_WorkExcepArgPos,
				     I_OperationSrc,
				     I_OldStr1Src,
				     I_Str1PosSrc,
				     I_LengthSrc,
				     I_Str2PosSrc,
				     I_NewStr1Dst) );

  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
 End_of_KL1B_Instruction: ;
}

/******************************************************************** PSL **
kblt_b_unary_string_operation A1, A2, A3, A4, A5

       written by kawai@icot22      on Wed Jul 17 14:44:45 1991

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |   b_unary_string_     |     A1    |     A2    |
    |       operation       |           |           |
    +-----------+-----------+-----------+-----------+
    |    A3     |    A4     |     A5    | don't care|
    +-----------+-----------+-----------+-----------+
<Arguments>
  A1   $BF~NO(B  $B%*%Z%l!<%7%g%s<oJL(B  ($B%l%8%9%?(B)
       ($BL$Dj5A$J$i%5%9%Z%s%I!"@0?t(B0$B!A(B15$B0J30$J$iNc30(B)
  A2   $BF~NO(B  $B%9%H%j%s%0(B ($B%l%8%9%?(B)
       ($BL$Dj5A$J$i%5%9%Z%s%I!"%9%H%j%s%00J30$J$iNc30(B)
  A3   $BF~NO(B  $B%9%H%j%s%0$N%*%Z%l!<%7%g%s3+;OMWAG0LCV(B  ($B%l%8%9%?(B)
       ($BL$Dj5A$J$i%5%9%Z%s%I!"%9%H%j%s%0$NMWAGHO0OFb$N@0?t0J30$J$iNc30(B)
  A4   $BF~NO(B  $B%*%Z%l!<%7%g%sBP>]MWAG8D?t(B  ($B%l%8%9%?(B)
       ($BL$Dj5A$J$i%5%9%Z%s%I!"(BA3$B$K$3$NCM$r2C;;$7$?7k2L$,%9%H%j%s%0$N(B
        $BMWAGHO0O$r1[$($?$iNc30(B)
  A5   $B=PNO(B  $B%9%H%j%s%0$N=PNO(B  ($B%l%8%9%?(B)
	 
<Temporally Used Variables>
<Level>   interpreter
<PreCondition>
  $B!&F~NO$H=PNO$N%l%8%9%?$O!"=EJ#$7$J$$!#(B
<Function>
  $B!&(BA1$B!A(BA4$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B
    $B!&3FF~NO%A%'%C%/$K0z$C3]$+$l$P!"Nc30=hM}!#(B
  $B!&%9%H%j%s%0(B(A2)$B$N%*%Z%l!<%7%g%s3+;OMWAG0LCV(B(A3)$B$+$i%*%Z%l!<%7%g%sBP>](B
    $BMWAG8D?t(B(A4)$BJ,$NMWAGF1;N$G%*%Z%l!<%7%g%s<oJL(B(A1)$B$K1~$8$?1i;;$r9T$$!"(B
    $B$=$N7k2L$G%9%H%j%s%0$N%*%Z%l!<%7%g%s3+;OMWAG0LCV(B(A3)$B$+$i%*%Z%l!<%7%g%s(B
    $BBP>]MWAG8D?t(B(A4)$BJ,$NMWAG$rCV$-49$(!"%9%H%j%s%0$N=PNO(B(A5)$B$K%f%K%U%!%$$9$k!#(B
      $B$J$*!"%*%Z%l!<%7%g%s<oJL(B(A1)$B$O(B0$B!A(B15$B$N@0?t$GM?$($i$l!"%9%H%j%s%0$NMWAG(B
    $BF1;N$G0J2<$N$h$&$J%S%C%H1i;;$r9T$&!#(B

                                $BF~NO(B(S2,S1)
    $B%*%Z%l!<%7%g%s<oJL(B    (0,0) (0,1) (1,0) (1,1)    $B=PNO(B
           0                0     0     0     0       0
           1                0     0     0     1       S2 AND S1
           2                0     0     1     0       S2 AND (not S1)
           3                0     0     1     1       S2
           4                0     1     0     0       (not S2) AND S1
           5                0     1     0     1       S1
           6                0     1     1     0       S2 XOR S1
           7                0     1     1     1       S2 OR  S1
           8                1     0     0     0       S2 NOR S1
           9                1     0     0     1       S2 not XOR S1
                                                       = not(S2 XOR S1)
          10                1     0     1     0       not S1
          11                1     0     1     1       S2 OR (not S1)
          12                1     1     0     0       not S2
          13                1     1     0     1       (not S2) OR S1
          14                1     1     1     0       S2 NAND S1
          15                1     1     1     1       1

<Examples>
<Test>
<Explanation>
  $BCm0U(B:$B%9%H%j%s%0>e$G$NCV$-49$(HO0O$HFI$_9~$_HO0O$,=EJ#$9$k>l9g!"%9%H%j%s%0$N(B
       $BMWAG$NCV$-49$($OFI$_9~$_$K1F6A$7$J$$!#(B
 [$BNc(B]
 $B2<$N?^$N$h$&$J>l9g!"(B

          |  $B%9%H%j%s%0$NCV$-49$(HO0O(B   |
    +-----+-----+-----+-----+-----+-----+-----+
    |  a  |  b  |  c  |  d  |  e  |  f  |  g  |
    +-----+-----+-----+-----+-----+-----+-----+
    |  $B%9%H%j%s%0$NFI$_9~$_HO0O(B   |

 $B1i;;(B(@)$B8e$N3FMWAG$O(B
          |  $B%9%H%j%s%0$NCV$-49$(HO0O(B   |
    +-----+-----+-----+-----+-----+-----+-----+
    |  a  | a@b | b@c | c@d | d@e | e@f |  g  |
    +-----+-----+-----+-----+-----+-----+-----+
    |  $B%9%H%j%s%0$NFI$_9~$_HO0O(B   |

$B$H$J$j!"2<?^$N$h$&$K$O$J$i$J$$!#(B

          |$B%9%H%j%s%0$NCV$-49$(HO0O(B ->
    +-----+-------+---------+-------------+-----------------+--\\
    |  a  |  a@b  | (a@b)@c | ((a@b)@c)@d | (((a@b)@c)@d)@e |
    +-----+-------+---------+-------------+-----------------+--\\
    |$B%9%H%j%s%0$NFI$_9~$_HO0O(B ->

                           ->|
    \\--+--------------------+-----+
        | (((a@b)@c)@d)@e)@f |  g  |
    \\--+--------------------+-----+
      ->|
<ETC>
********************************************************************* PSL **/

#OPF_define I_OperationSrc  _IndirectRegField1  /* Operation kind(src) */
#OPF_define I_OldStr1Src    _IndirectRegField2  /* Old string1 (src) */
#OPF_define I_Str1PosSrc    _IndirectRegField3  /* String1 position (src) */
#OPF_define I_LengthSrc     _IndirectRegField4  /* Target length (src) */
#OPF_define I_NewStr1Dst    _IndirectRegField5  /* New string1 (dst) */

#PSL_define kblt_b_unary_string_operation () 
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp5ArgVect_IIIIO_Sub(D_WorkArgVect,
					 I_OperationSrc,
					 I_OldStr1Src,
					 I_Str1PosSrc,
					 I_LengthSrc,
					 I_NewStr1Dst) );
	f_TraceBodyBuiltin(BLT_B_UNARY_STRING_OPERATION, D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE (D_Workreg);
  /* $BBh(B0$B0z?t(B($B%9%H%j%s%0%*%Z%l!<%7%g%s<oN`(B)$B$N%A%'%C%/(B */
  f_ActiveDeref (I_OperationSrc, D_Workreg);
  TypeSwitch (I_OperationSrc) {
    case INT:
      b_IfLessImm(I_OperationSrc, _STRING_OPERATION_MIN)
	{
	  $RELEASE (D_Workreg);
	  $USE (D_WorkExceptionCode);
	  $USE(D_WorkExcepArgPos);
	  b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP,
				   D_WorkExceptionCode);
	  b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
	  goto Exception;
	}
      b_IfGreaterImm(I_OperationSrc, _STRING_OPERATION_MAX)
	{
	  $RELEASE (D_Workreg);
	  $USE (D_WorkExceptionCode);
	  $USE(D_WorkExcepArgPos);
	  b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP,
				   D_WorkExceptionCode);
	  b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
	  goto Exception;
	}
      break;
    case UnboundGroup ():   
      p_MoveWord (D_Workreg, I_OperationSrc);
      f_DcodeEnqueue5Ope_IIIIO (BLT_B_UNARY_STRING_OPERATION,
				I_OperationSrc,
				I_OldStr1Src,
				I_Str1PosSrc,
				I_LengthSrc,
				I_NewStr1Dst);
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; break;
    case ATOM:
    case StringGrp ():
    case FloatingGrp ():
    case ListGrp ():
    case NullVectorGrp ():
    case ShortVectorGrp ():
    case LongVectorGrp ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
      goto Exception; break;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_unary_string_operation",
			  "undefined_type");};
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; break;
    }


  /* $BBh(B1$B0z?t(B(String1)$B$N%A%'%C%/(B */
  f_ActiveDeref (I_OldStr1Src, D_Workreg);
  TypeSwitch (I_OldStr1Src) {
    case StringGrp (): break;   /* $B%9%H%j%s%0$J$iDL$7(B */
    case UnboundGroup ():   
      p_MoveWord (D_Workreg, I_OldStr1Src);
      f_DcodeEnqueue5Ope_IIIIO (BLT_B_UNARY_STRING_OPERATION,
				I_OperationSrc,
				I_OldStr1Src,
				I_Str1PosSrc,
				I_LengthSrc,
				I_NewStr1Dst);
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; break;
    case ConstantGroup ():
    case ListGrp ():
    case NullVectorGrp ():
    case ShortVectorGrp ():
    case LongVectorGrp ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
      goto Exception; break;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_unary_string_operation",
			  "undefined_type");};
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; break;
    }

  /* $BBh(B2$B0z?t(B(String1$B$N(BPosition1)$B$N%A%'%C%/(B */
  f_ActiveDeref (I_Str1PosSrc, D_Workreg);
  TypeSwitch (I_Str1PosSrc) {
    case INT:
      b_IfGreaterEq (I_Str1PosSrc, D_NULL) {              
        $USE (D_WorkStrCheckLength);
        s_GetStringType (I_OldStr1Src, D_WorkStrCheckLength, D_VOID);
        b_IfLessEq (I_Str1PosSrc, D_WorkStrCheckLength) {
	  /* $B<!$N0z?t$N%A%'%C%/$K0\$k(B */
	  /* D_WorkStrCheckLength$B$O<!$N0z?t%A%'%C%/$G$b;H$&$N$G(B
	     $B$^$@%j%j!<%9$7$J$$(B */
          break;
        } else {
	  b_IfEqual(I_Str1PosSrc, D_NULL) {
	    b_IfEqual(D_WorkStrCheckLength, D_NULL) {
	      /* NULLstring$B$G$b(BPosition1$B$,(B0$B$J$i$PDL$7(B */
	      /* $B<!$N0z?t$N%A%'%C%/$K0\$k!#(B */
	      /* D_WorkStrCheckLength$B$O<!$N0z?t%A%'%C%/$G$b;H$&$N$G(B
		 $B$^$@%j%j!<%9$7$J$$(B */
	      break;
	    }
	  }
	}
        $RELEASE (D_WorkStrCheckLength);
      }
      /* $B;XDj$5$l$?MWAG0LCV$,Ii$^$?$OMWAGD90J>e$J$i$PNc30(B */
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _TWO, D_WorkExcepArgPos);
      goto Exception; 

    case UnboundGroup ():   
      p_MoveWord (D_Workreg, I_Str1PosSrc);
      f_DcodeEnqueue5Ope_IIIIO (BLT_B_UNARY_STRING_OPERATION,
				I_OperationSrc,
				I_OldStr1Src,
				I_Str1PosSrc,
				I_LengthSrc,
				I_NewStr1Dst);
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; 
    case ATOM:
    case FloatingGrp ():
    case StructureGroup ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _TWO, D_WorkExcepArgPos);
      goto Exception;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_unary_string_operation",
			  "undefined_type");};
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; 
    }

  /* $BBh(B3$B0z?t(B($B%*%Z%l!<%7%g%sBP>]HO0O(B)$B$N%A%'%C%/(B */
  f_ActiveDeref (I_LengthSrc, D_Workreg);
  TypeSwitch (I_LengthSrc) {
    case INT:
      b_IfGreaterEq (I_LengthSrc, D_NULL) {
	$USE (D_WorkTotalStrLength);
	b_AddWithDNTC(I_Str1PosSrc, I_LengthSrc, D_WorkTotalStrLength);
	b_IfLessEq(D_WorkTotalStrLength, D_WorkStrCheckLength) {
	  /* D_WorkStrCheckLength$B$O$^$@%j%j!<%9$5$l$F$$$J$$H&(B */
	  $RELEASE (D_WorkStrCheckLength);
	  $RELEASE (D_WorkTotalStrLength);
	  break;
	}
	$RELEASE (D_WorkTotalStrLength);
      }
      /* $B;XDj$5$l$?%*%Z%l!<%7%g%sBP>]HO0O$,Ii$^$?$OMWAGD90J>e$J$i$PNc30(B */
      $RELEASE (D_Workreg);  
      $RELEASE (D_WorkStrCheckLength); /* $BNc30=hM}$KHt$V>l9g$O(B */
                                       /* $B$3$3$G%j%j!<%9$9$k(B */

      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _THREE, D_WorkExcepArgPos);
      goto Exception; 

    case UnboundGroup ():   
      p_MoveWord (D_Workreg, I_LengthSrc);
      f_DcodeEnqueue5Ope_IIIIO (BLT_B_UNARY_STRING_OPERATION,
				I_OperationSrc,
				I_OldStr1Src,
				I_Str1PosSrc,
				I_LengthSrc,
				I_NewStr1Dst);
      $RELEASE (D_Workreg);
      $RELEASE (D_WorkStrCheckLength);
      goto End_of_KL1B_Instruction; 
    case ATOM:
    case FloatingGrp ():
    case StructureGroup ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg);
      $RELEASE (D_WorkStrCheckLength);   /* $BNc30=hM}$KHt$V>l9g$O(B */
                                         /* $B$3$3$G%j%j!<%9$9$k(B */
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _THREE, D_WorkExcepArgPos);
      goto Exception;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_unary_string_operation",
			  "undefined_type");};
      $RELEASE (D_Workreg);
      $RELEASE (D_WorkStrCheckLength);
      goto End_of_KL1B_Instruction; 
    }

  $RELEASE (D_Workreg);


  /***************************************/
  /* unary_string_operation$B$N<B:]$N=hM}(B */
  /***************************************/

  f_CopyStringMRB (I_OldStr1Src, I_NewStr1Dst);

  b_IfWordEq (I_NewStr1Dst, D_NULL) {
    /* $B%R!<%WNN0hITB-$G!"%9%H%j%s%0$r@8@.$G$-$J$+$C$?;~$O!"(B
       Dcode $B%4!<%k$r(B enqueue $B$9$k!#(B */

      f_DcodeEnqueue5Ope_IIIIO (BLT_B_UNARY_STRING_OPERATION,
				I_OperationSrc,
				I_OldStr1Src,
				I_Str1PosSrc,
				I_LengthSrc,
				I_NewStr1Dst);
    @DEBUG {WARNING ("kblt_b_unary_string_operation",
		     "Dcode Goal enqueued by Heap Shortage"); };
  } else {
    /* $B%9%H%j%s%0$r@8@.$G$-$?;~!"%*%Z%l!<%7%g%s$r9T$&(B */
    $CALL( f_UnaryStringOpe_Sub(I_OperationSrc,
				I_NewStr1Dst,
				I_Str1PosSrc,
				I_LengthSrc) );
  }
  goto End_of_KL1B_Instruction;

 Exception:
  $USE (D_WorkOpCode);
  b_SetImmTypeValueMRBoff (INT, BLT_B_UNARY_STRING_OPERATION, D_WorkOpCode);
  $CALL (f_Exception_5Arg_IIIIO_Sub(D_WorkExceptionCode, D_WorkOpCode, 
				    D_WorkExcepArgPos,
				    I_OperationSrc,
				    I_OldStr1Src,
				    I_Str1PosSrc,
				    I_LengthSrc,
				    I_NewStr1Dst) );

  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
 End_of_KL1B_Instruction: ;
}

/******************************************************************** PSL **
kblt_b_search_character A1, A2, A3, A4, A5, A6

       written by kawai@icot22      on Wed Jul 17 14:45:30 1991

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |   b_search_character  |     A1    |     A2    |
    +-----------+-----------+-----------+-----------+
    |    A3     |    A4     |     A5    |     A6    |
    +-----------+-----------+-----------+-----------+
<Arguments>
  A1   $BF~NO(B  $B%9%H%j%s%0(B ($B%l%8%9%?(B)
       ($BL$Dj5A$J$i%5%9%Z%s%I!"%9%H%j%s%00J30$J$iNc30(B)
  A2   $BF~NO(B  $B%9%H%j%s%0$N8!:w3+;OMWAG0LCV(B  ($B%l%8%9%?(B)
       ($BL$Dj5A$J$i%5%9%Z%s%I!"%9%H%j%s%0$NMWAGHO0OFb$N@0?t0J30$J$iNc30(B)
  A3   $BF~NO(B  $B%9%H%j%s%0$N8!:w=*N;MWAG0LCV(B  ($B%l%8%9%?(B)
       ($BL$Dj5A$J$i%5%9%Z%s%I!"%9%H%j%s%0$NMWAGHO0OFb$N@0?t0J30$J$iNc30(B)
  A4   $BF~NO(B  $B8!:wBP>]J8;z(B  ($B%l%8%9%?(B)
       ($BL$Dj5A$J$i%5%9%Z%s%I!"%9%H%j%s%0$NMWAG%5%$%:$K1~$8$?J8;z%3!<%I0J30(B
        $B$J$iNc30(B)
  A5   $B=PNO(B  $BH/8+MWAG0LCV(B  ($B%l%8%9%?(B)
  A6   $B=PNO(B  $B=PNO%9%H%j%s%0(B  ($B%l%8%9%?(B)
	 
<Temporally Used Variables>
<Level>   interpreter
<PreCondition>
  $B!&F~NO$H=PNO$N%l%8%9%?$O!"=EJ#$7$J$$!#(B
  $B!&%9%H%j%s%0$NMWAG%5%$%:$O!"(B1$B!"(B8$B!"(B16$B!"(B32$B$H$9$k!#(B
<Function>
  $B!&(BA1$B!A(BA4$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B
    $B!&3FF~NO%A%'%C%/$K0z$C3]$+$l$P!"Nc30=hM}!#(B
  $B!&%9%H%j%s%0(B(A1)$B$N8!:w3+;OMWAG0LCV(B(A2)$B$+$i8!:w=*N;MWAG0LCV(B(A3)$B$NHO0O$G(B
    $B8!:wBP>]J8;z(B(A4)$B$rC5$7!":G=i$K8+$D$+$C$?MWAG0LCV$rH/8+MWAG0LCV(B(A5)$B$K(B
    $B%f%K%U%!%$$7!"%9%H%j%s%0(B(A1)$B$r=PNO%9%H%j%s%0(B(A6)$B$K%f%K%U%!%$$9$k!#(B
      $B8!:w3+;OMWAG0LCV(B(A2) < $B8!:w=*N;MWAG0LCV(B(A3)$B$N>l9g$K$O%9%H%j%s%0(B(A1)
    $B$NKvHx$+$i8!:w$9$k!#(B
      $B$^$?!";XDj$5$l$?HO0OFb$G8!:wBP>]J8;z$,8+$D$+$i$J$+$C$?>l9g$K$O!"(B
    $BH/8+MWAG0LCV(B(A5)$B$K(B -1$B$r%f%K%U%!%$$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define  D_WorkSearchDummyArg  XXX

#OPF_define I_OldStrSrc     _IndirectRegField1  /* Old string (src) */
#OPF_define I_StartPosSrc   _IndirectRegField2  /* Start position (src) */
#OPF_define I_EndPosSrc     _IndirectRegField3  /* End position (src) */
#OPF_define I_CharCodeSrc   _IndirectRegField4  /* Character code (src) */
#OPF_define I_FoundPosDst   _IndirectRegField5  /* Found position (dst) */
#OPF_define I_NewStrDst     _IndirectRegField6  /* New string (dst) */

#PSL_define kblt_b_search_character () 
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp6ArgVect_IIIIOO_Sub(D_WorkArgVect,
					  I_OldStrSrc,
					  I_StartPosSrc,
					  I_EndPosSrc,
					  I_CharCodeSrc,
					  I_FoundPosDst,
					  I_NewStrDst) );
      f_TraceBodyBuiltin(BLT_B_SEARCH_CHARACTER, D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE (D_Workreg);

  /* $BBh(B0$B0z?t(B(String)$B$N%A%'%C%/(B */
  f_ActiveDeref (I_OldStrSrc, D_Workreg);

  TypeSwitch (I_OldStrSrc) {
    case StringGrp (): break; /* $B8=:_%5%]!<%H$5$l$F$$$k%9%H%j%s%0$N(B */
                              /* $BMWAG%5%$%:$O(B1$B!"(B8$B!"(B16$B!"(B32$B$N$?$a!"(B   */
                              /* $B%9%H%j%s%0$G$"$l$PDL$7(B */
    case UnboundGroup ():     
      p_MoveWord (D_Workreg, I_OldStrSrc);
      f_DcodeEnqueue6Ope_IIIIOO (BLT_B_SEARCH_CHARACTER,
				 I_OldStrSrc,
				 I_StartPosSrc,
				 I_EndPosSrc,
				 I_CharCodeSrc,
				 I_FoundPosDst,
				 I_NewStrDst);
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; break;
    case ConstantGroup ():
    case ListGrp ():
    case NullVectorGrp ():
    case ShortVectorGrp ():
    case LongVectorGrp ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
      goto Exception; break;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_search_character", "undefined_type");};
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; break;
    }

  /* $BBh(B1$B0z?t(B(StartPosition)$B$N%A%'%C%/(B */
  f_ActiveDeref (I_StartPosSrc, D_Workreg);
  TypeSwitch (I_StartPosSrc) {
    case INT:
      b_IfGreaterEq (I_StartPosSrc, D_NULL) {              
        $USE (D_WorkStrCheckLength);
        $USE (D_WorkStrCheckElmSize);
        s_GetStringType (I_OldStrSrc, D_WorkStrCheckLength,
			                             D_WorkStrCheckElmSize);
        b_IfLess (I_StartPosSrc, D_WorkStrCheckLength) {
	  /* $B<!$N0z?t$N%A%'%C%/$K0\$k(B */
	  /* D_WorkStrCheckLength$B!"(BD_WorkStrCheckElmSize$B$O<!$N0z?t%A%'%C%/(B
	     $B$G$b;H$&$N$G%j%j!<%9$7$J$$(B */
          break;
        }
/* commented out on '92.7.9
      else
	{
	  b_IfEqual(I_StartPosSrc, D_NULL) {
	    b_IfEqual(D_WorkStrCheckLength, D_NULL) {
	      /!* NULLstring$B$G$b(BStartPosition$B$,(B0$B$J$i$PDL$7(B *!/
	      /!* $B<!$N0z?t$N%A%'%C%/$K0\$k!#(B*!/
	      /!* D_WorkStrCheckLength$B$O<!$N0z?t%A%'%C%/$G$b;H$&$N$G(B
		 $B$^$@%j%j!<%9$7$J$$(B *!/
	      break;
	    }
	  }
	}
*/
        $RELEASE (D_WorkStrCheckLength);
        $RELEASE (D_WorkStrCheckElmSize);
      }
      /* $B;XDj$5$l$?C5:w3+;O0LCV$,Ii$^$?$OMWAGD90J>e$J$i$PNc30(B */
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
      goto Exception; 

    case UnboundGroup ():   
      p_MoveWord (D_Workreg, I_StartPosSrc);
      f_DcodeEnqueue6Ope_IIIIOO (BLT_B_SEARCH_CHARACTER,
				 I_OldStrSrc,
				 I_StartPosSrc,
				 I_EndPosSrc,
				 I_CharCodeSrc,
				 I_FoundPosDst,
				 I_NewStrDst);
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; 
    case ATOM:
    case FloatingGrp ():
    case StructureGroup ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
      goto Exception;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_search_string", "undefined_type");};
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; 
    }


  /* $BBh(B2$B0z?t(B(EndPosition)$B$N%A%'%C%/(B */
  f_ActiveDeref (I_EndPosSrc, D_Workreg);
  TypeSwitch (I_EndPosSrc) {
    case INT:
      b_IfGreaterEq (I_EndPosSrc, D_NULL) {              
        b_IfLess (I_EndPosSrc, D_WorkStrCheckLength) {
	  /* $B<!$N0z?t$N%A%'%C%/$K0\$k(B */
	  /* D_WorkStrCheckElmSize$B$O<!$N0z?t%A%'%C%/$G$b;H$&$N$G(B
	     $B%j%j!<%9$7$J$$(B */
	  $RELEASE (D_WorkStrCheckLength);
          break;
        }
/* commented out on '92.7.9
      else
	{
	  b_IfEqual(I_EndPosSrc, D_NULL) {
	    b_IfEqual(D_WorkStrCheckLength, D_NULL) {
	      /!* NULLstring$B$G$b(BEndPosition$B$,(B0$B$J$i$PDL$7(B *!/
	      /!* $B<!$N0z?t$N%A%'%C%/$K0\$k!#(B *!/
	      /!* D_WorkStrCheckElmSize$B$O<!$N0z?t%A%'%C%/$G$b;H$&$N$G(B
		 $B%j%j!<%9$7$J$$(B *!/
	      $RELEASE (D_WorkStrCheckLength);
	      break;
	    }
	  }
	}
*/

      }
      /* $B;XDj$5$l$?C5:w=*N;0LCV$,Ii$^$?$OMWAGD90J>e$J$i$PNc30(B */
      $RELEASE (D_WorkStrCheckLength);
      $RELEASE (D_WorkStrCheckElmSize);
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _TWO, D_WorkExcepArgPos);
      goto Exception; 

    case UnboundGroup ():   
      p_MoveWord (D_Workreg, I_EndPosSrc);
      f_DcodeEnqueue6Ope_IIIIOO (BLT_B_SEARCH_CHARACTER,
				 I_OldStrSrc,
				 I_StartPosSrc,
				 I_EndPosSrc,
				 I_CharCodeSrc,
				 I_FoundPosDst,
				 I_NewStrDst);
      $RELEASE (D_WorkStrCheckLength);
      $RELEASE (D_WorkStrCheckElmSize);
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction;
    case ATOM:
    case FloatingGrp ():
    case StructureGroup ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_WorkStrCheckLength);
      $RELEASE (D_WorkStrCheckElmSize);
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _TWO, D_WorkExcepArgPos);
      goto Exception;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_search_string", "undefined_type");};
      $RELEASE (D_WorkStrCheckLength);
      $RELEASE (D_WorkStrCheckElmSize);
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; 
    }


  /* $BBh(B3$B0z?t(B($BJ8;z%3!<%I(B)$B$N%A%'%C%/(B */
  f_ActiveDeref (I_CharCodeSrc, D_Workreg);
  TypeSwitch (I_CharCodeSrc) {
    case INT:
      /* $BMWAG$N%S%C%H%5%$%:$N%A%'%C%/(B */
         /* 32$B%S%C%H%9%H%j%s%0$J$i(BOK */
      b_IfEqualImm (D_WorkStrCheckElmSize, _WORD_SIZE_OF_STRG) { break;}

         /* $B$=$l0J30$N;~!"@5$G$+$D%S%C%HI}$r1[$($J$1$l$P(BOK */    
      b_IfGreaterEq (I_CharCodeSrc, D_NULL) {
        $USE (D_Workreg2);
        b_ShiftLeftWithDNTC (D_ONE, D_WorkStrCheckElmSize, D_Workreg2);
	/* 1$B$rMWAG%5%$%:J,:8%7%U%H$9$k(B */
        /* $B$3$3$KMh$k$N$O%5%$%:$+(B1$B!"(B8$B!"(B16$B$N;~$@$+$i!"$3$NCM$OMWAG%5%$%:$K(B
           $B$*$1$k:GBgCM(B($B@5$N?t(B) + 1 $B$H$J$k!#(B  */
        b_IfLess (I_CharCodeSrc, D_Workreg2) { 
	  $RELEASE (D_Workreg2);
	  break;
        }   
        $RELEASE (D_Workreg2);
      }

         /* $B;XDj$5$l$??7MWAG$,MWAG%5%$%:$N%S%C%HI}$r1[$($?$iNc30(B */
      $RELEASE (D_WorkStrCheckElmSize);
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _THREE, D_WorkExcepArgPos);
      goto Exception;

    case UnboundGroup ():   
      p_MoveWord (D_Workreg, I_CharCodeSrc);
      f_DcodeEnqueue6Ope_IIIIOO (BLT_B_SEARCH_CHARACTER,
				 I_OldStrSrc,
				 I_StartPosSrc,
				 I_EndPosSrc,
				 I_CharCodeSrc,
				 I_FoundPosDst,
				 I_NewStrDst);
      $RELEASE (D_Workreg);
      $RELEASE (D_WorkStrCheckElmSize);
      goto End_of_KL1B_Instruction; 
    case ATOM:
    case FloatingGrp ():
    case StructureGroup ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg);
      $RELEASE (D_WorkStrCheckElmSize);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _THREE, D_WorkExcepArgPos);
      goto Exception;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_search_string", "undefined_type");};
      $RELEASE (D_Workreg);
      $RELEASE (D_WorkStrCheckElmSize);
      goto End_of_KL1B_Instruction; 
    }

  $RELEASE (D_Workreg);
  $RELEASE (D_WorkStrCheckElmSize);

  /***************************************/
  /* search_character$B$N<B:]$N=hM}(B        */
  /***************************************/

  /* search_character$B$H(Bsearch_characters$B$N=hM}$r(Bf_SearchCharacter$B$K$^$H$a$?(B */
  /* $B$=$l$>$l$N=hM}$N6hJL$O(Bf_SearchCharacter$B$NBh(B4$B0z?t$N%?%0$GH=Dj$9$k!#(B
         Tag = ATOM  ->  search_character
         Tag = INT   ->  search_characters                                  */

  $USE(D_WorkSearchDummyArg);
  b_SetImmTypeValueMRBoff(ATOM, _ZERO, D_WorkSearchDummyArg);

  f_SearchCharacter(I_OldStrSrc,
		    I_StartPosSrc,
		    I_EndPosSrc,
		    I_CharCodeSrc,
		    D_WorkSearchDummyArg, /* Dummy Argument */
		    I_FoundPosDst);

  $RELEASE(D_WorkSearchDummyArg);

  p_MoveWord(I_OldStrSrc, I_NewStrDst);

  goto End_of_KL1B_Instruction;

 Exception:
  $USE (D_WorkOpCode);
  b_SetImmTypeValueMRBoff (INT, BLT_B_SEARCH_CHARACTER, D_WorkOpCode);
  $CALL (f_Exception_6Arg_IIIIOO_Sub(D_WorkExceptionCode, D_WorkOpCode, 
				     D_WorkExcepArgPos,
				     I_OldStrSrc,
				     I_StartPosSrc,
				     I_EndPosSrc,
				     I_CharCodeSrc,
				     I_FoundPosDst,
				     I_NewStrDst) );

  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
 End_of_KL1B_Instruction: ;
}
/******************************************************************** PSL **
kblt_b_search_characters A1, A2, A3, A4, A5, A6, A7, A8

       written by kawai@icot22      on Tue Sep 10 21:03:09 1991

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |  b_search_characters  |     A1    |     A2    |
    +-----------+-----------+-----------+-----------+
    |    A3     |    A4     |     A5    |     A6    |
    +-----------+-----------+-----------+-----------+
    |    A7     |    A8     |      don't care       |
    +-----------+-----------+-----------+-----------+
<Arguments>
  A1   $BF~NO(B  $B%9%H%j%s%0(B ($B%l%8%9%?(B)
       ($BL$Dj5A$J$i%5%9%Z%s%I!"(B8$B!"(B16$B%S%C%H%9%H%j%s%00J30$J$iNc30(B)
  A2   $BF~NO(B  $B%9%H%j%s%0$N8!:w3+;OMWAG0LCV(B  ($B%l%8%9%?(B)
       ($BL$Dj5A$J$i%5%9%Z%s%I!"%9%H%j%s%0$NMWAGHO0OFb$N@0?t0J30$J$iNc30(B)
  A3   $BF~NO(B  $B%9%H%j%s%0$N8!:w=*N;MWAG0LCV(B  ($B%l%8%9%?(B)
       ($BL$Dj5A$J$i%5%9%Z%s%I!"%9%H%j%s%0$NMWAGHO0OFb$N@0?t0J30$J$iNc30(B)
  A4   $BF~NO(B  $B8!:wMQ%^%9%/(B  ($B%l%8%9%?(B)
       ($BL$Dj5A$J$i%5%9%Z%s%I!"@0?t0J30$J$iNc30(B)
  A5   $BF~NO(B  $B8!:wMQ%F!<%V%k(B  ($B%l%8%9%?(B)
       ($BL$Dj5A$J$i%5%9%Z%s%I!"%F!<%V%k$,(B8$B%S%C%H%9%H%j%s%00J30$J$iNc30!#(B
        $B$5$i$K!"%F!<%V%kD9$,(B 2 ^ ($B%9%H%j%s%0$NMWAG%5%$%:(B)$B$KEy$7$/$J$1$l$PNc30(B)
  A6   $B=PNO(B  $BH/8+MWAG0LCV(B  ($B%l%8%9%?(B)
  A7   $B=PNO(B  $B=PNO%9%H%j%s%0(B  ($B%l%8%9%?(B)
  A8   $B=PNO(B  $B=PNO%F!<%V%k(B  ($B%l%8%9%?(B)
	 
<Temporally Used Variables>
<Level>   interpreter
<PreCondition>
  $B!&F~NO$H=PNO$N%l%8%9%?$O!"=EJ#$7$J$$!#(B
  $B!&%9%H%j%s%0$NMWAG%5%$%:$O!"(B1$B!"(B8$B!"(B16$B!"(B32$B$H$9$k!#(B
<Function>
  $B!&(BA1$B!A(BA5$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B
    $B!&3FF~NO%A%'%C%/$K0z$C3]$+$l$P!"Nc30=hM}!#(B
  $B!&%9%H%j%s%0(B(A1)$B$N8!:w3+;OMWAG0LCV(B(A2)$B$+$i8!:w=*N;MWAG0LCV(B(A3)$B$NHO0O$N(B
    $B3FMWAG$NCM$G8!:wMQ%F!<%V%k(B(A5)$B$r0z$-(B($B3FMWAG$NCM$r8!:wMQ%F!<%V%k$NMWAG(B
    $B0LCV$H$7$F$=$NCM$r<h$j=P$7(B)$B!"$=$NCM$H8!:wMQ%^%9%/(B(A4)$B$H$N(BAND$B$r$H$C$?(B
    $B7k2L$,(B 0 $B$G$J$$$b$N$r8!:w$7!":G=i$K8+$D$+$C$?MWAG0LCV$rH/8+MWAG0LCV(B(A6)
    $B$K%f%K%U%!%$$7!"%9%H%j%s%0(B(A1)$B$r=PNO%9%H%j%s%0(B(A7)$B$K%f%K%U%!%$$9$k!#(B
    $B=PNO%F!<%V%k(B(A8)$B$K$O!"8!:wMQ%F!<%V%k(B((A5)$B$,%f%K%U%!%$$5$l$k!#(B
      $B8!:w3+;OMWAG0LCV(B(A2) < $B8!:w=*N;MWAG0LCV(B(A3)$B$N>l9g$K$O%9%H%j%s%0(B(A1)
    $B$NKvHx$+$i8!:w$9$k!#(B
      $B$^$?!";XDj$5$l$?HO0OFb$G8!:wBP>]J8;z$,8+$D$+$i$J$+$C$?>l9g$K$O!"(B
    $BH/8+MWAG0LCV(B(A6)$B$K(B -1$B$r%f%K%U%!%$$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define  D_WorkSearchTableSize  XXX
#DATA_define  D_WorkTableElemSize    XXX

#OPF_define I_OldStrSrc       _IndirectRegField1  /* Old string (src) */
#OPF_define I_StartPosSrc     _IndirectRegField2  /* Start position (src) */
#OPF_define I_EndPosSrc       _IndirectRegField3  /* End position (src) */
#OPF_define I_TableMaskSrc    _IndirectRegField4  /* Table Mask (src) */
#OPF_define I_SearchTableSrc  _IndirectRegField5  /* Table (src) */
#OPF_define I_FoundPosDst     _IndirectRegField6  /* Found position (dst) */
#OPF_define I_NewStrDst       _IndirectRegField7  /* New string (dst) */
#OPF_define I_NewTableDst     _IndirectRegField8  /* New table (dst) */

#PSL_define kblt_b_search_characters ()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp8ArgVect_IIIIIOOO_Sub(D_WorkArgVect,
					    I_OldStrSrc,
					    I_StartPosSrc,
					    I_EndPosSrc,
					    I_TableMaskSrc,
					    I_SearchTableSrc,
					    I_FoundPosDst,
					    I_NewStrDst,
					    I_NewTableDst) );
      f_TraceBodyBuiltin(BLT_B_SEARCH_CHARACTERS, D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE (D_Workreg);

  /* $BBh(B0$B0z?t(B(String)$B$N%A%'%C%/(B */
  f_ActiveDeref (I_OldStrSrc, D_Workreg);

  TypeSwitch (I_OldStrSrc) {
    case StringGrp ():
      $USE(D_WorkStrCheckLength);
      $USE(D_WorkStrCheckElmSize);
      s_GetStringType(I_OldStrSrc, D_WorkStrCheckLength,
		                                      D_WorkStrCheckElmSize);
      b_IfEqualImm(D_WorkStrCheckElmSize, _ELEM_SIZE_OF_STRG8)
	{ /* $BF~NO%9%H%j%s%0$,(B8$B%S%C%H%9%H%j%s%0$J$i!"<!$N0z?t$r%A%'%C%/$9$k(B */
	  /* D_WorkStrCheckLength$B!"(BD_WorkStrCheckElmSize$B$O<!$N0z?t%A%'%C%/$G$b(B
             $B;H$&$?$a!"$^$@%j%j!<%9$7$J$$(B */
	  break;
	}
      b_IfEqualImm(D_WorkStrCheckElmSize, _ELEM_SIZE_OF_STRG16)
	{ /* $BF~NO%9%H%j%s%0$,(B16$B%S%C%H%9%H%j%s%0$J$i!"<!$N0z?t$r%A%'%C%/$9$k(B */
	  /* D_WorkStrCheckLength$B!"(BD_WorkStrCheckElmSize$B$O<!$N0z?t%A%'%C%/$G$b(B
             $B;H$&$?$a!"$^$@%j%j!<%9$7$J$$(B */
	  break;
	}
      $RELEASE (D_Workreg);
      $RELEASE (D_WorkStrCheckLength);
      $RELEASE (D_WorkStrCheckElmSize);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
      goto Exception; break;
    case UnboundGroup ():   
      p_MoveWord (D_Workreg, I_OldStrSrc);
      f_DcodeEnqueue8Ope_IIIIIOOO (BLT_B_SEARCH_CHARACTERS,
				   I_OldStrSrc,
				   I_StartPosSrc,
				   I_EndPosSrc,
				   I_TableMaskSrc,
				   I_SearchTableSrc,
				   I_FoundPosDst,
				   I_NewStrDst,
				   I_NewTableDst);
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; break;
    case ConstantGroup ():
    case ListGrp ():
    case NullVectorGrp ():
    case ShortVectorGrp ():
    case LongVectorGrp ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
      goto Exception; break;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_search_characters", "undefined_type");};
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; break;
    }

  /* $BBh(B1$B0z?t(B(StartPosition)$B$N%A%'%C%/(B */
  f_ActiveDeref (I_StartPosSrc, D_Workreg);
  TypeSwitch (I_StartPosSrc) {
    case INT:
      b_IfGreaterEq (I_StartPosSrc, D_NULL) {              
        b_IfLess (I_StartPosSrc, D_WorkStrCheckLength) {
	  /* D_WorkStrCheckLength$B!"(BD_WorkStrCheckElmSize$B$K$O!"(B
	     $BA0$N0z?t%A%'%C%/$GCM$,FI$_9~$^$l$F$$$k$O$:(B */
	  /* I_StartPosSrc < D_WorkStrCheckLength$B$J$i$P!"<!$N0z?t$r%A%'%C%/(B */
	  /* D_WorkStrCheckLength$B!"(BD_WorkStrCheckElmSize$B$O<!$N0z?t%A%'%C%/(B
	     $B$G$b;H$&$N$G%j%j!<%9$7$J$$(B */
          break;
        }

/* commented out on '92.7.9
      else
	{
	  b_IfEqual(I_StartPosSrc, D_NULL) {
	    b_IfEqual(D_WorkStrCheckLength, D_NULL) {
	      /!* NULLstring$B$G$b(BStartPosition$B$,(B0$B$J$i$PDL$7(B *!/
	      /!* $B<!$N0z?t$N%A%'%C%/$K0\$k!#(B *!/
	      /!* D_WorkStrCheckLength$B!"(BD_WorkStrCheckElmSize$B$O(B
		 $B<!$N0z?t%A%'%C%/$G$b;H$&$N$G$^$@%j%j!<%9$7$J$$(B *!/
	      break;
	    }
	  }
	}
*/

      }
      /* $B;XDj$5$l$?C5:w3+;O0LCV$,Ii$^$?$OMWAGD90J>e$J$i$PNc30(B */
      $RELEASE (D_Workreg);
      $RELEASE (D_WorkStrCheckLength);
      $RELEASE (D_WorkStrCheckElmSize);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
      goto Exception; 
    case UnboundGroup ():   
      p_MoveWord (D_Workreg, I_StartPosSrc);
      f_DcodeEnqueue8Ope_IIIIIOOO (BLT_B_SEARCH_CHARACTERS,
				   I_OldStrSrc,
				   I_StartPosSrc,
				   I_EndPosSrc,
				   I_TableMaskSrc,
				   I_SearchTableSrc,
				   I_FoundPosDst,
				   I_NewStrDst,
				   I_NewTableDst);
      $RELEASE (D_Workreg);
      $RELEASE (D_WorkStrCheckLength);
      $RELEASE (D_WorkStrCheckElmSize);
      goto End_of_KL1B_Instruction; 
    case ATOM:
    case FloatingGrp ():
    case StructureGroup ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg);
      $RELEASE (D_WorkStrCheckLength);
      $RELEASE (D_WorkStrCheckElmSize);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
      goto Exception;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_search_strings", "undefined_type");};
      $RELEASE (D_Workreg);
      $RELEASE (D_WorkStrCheckLength);
      $RELEASE (D_WorkStrCheckElmSize);
      goto End_of_KL1B_Instruction; 
    }


  /* $BBh(B2$B0z?t(B(EndPosition)$B$N%A%'%C%/(B */
  f_ActiveDeref (I_EndPosSrc, D_Workreg);
  TypeSwitch (I_EndPosSrc) {
    case INT:
      b_IfGreaterEq (I_EndPosSrc, D_NULL) {              
        b_IfLess (I_EndPosSrc, D_WorkStrCheckLength) {
	  /* $B<!$N0z?t$N%A%'%C%/$K0\$k(B */
	  /* D_WorkStrCheckElmSize$B$O8e$N0z?t%A%'%C%/$G$b;H$&$N$G(B
	     $B%j%j!<%9$7$J$$(B */
	  $RELEASE (D_WorkStrCheckLength);
          break;
        }

/* commented out on '92.7.9
      else
	{
	  b_IfEqual(I_EndPosSrc, D_NULL) {
	    b_IfEqual(D_WorkStrCheckLength, D_NULL) {
	      /!* NULLstring$B$G$b(BEndPosition$B$,(B0$B$J$i$PDL$7(B *!/
	      /!* $B<!$N0z?t$N%A%'%C%/$K0\$k!#(B *!/
	      /!* D_WorkStrCheckElmSize$B$O8e$N0z?t%A%'%C%/$G$b;H$&$N$G(B
		 $B%j%j!<%9$7$J$$(B *!/
	      $RELEASE (D_WorkStrCheckLength);
	      break;
	    }
	  }
	}
*/

      }
      /* $B;XDj$5$l$?C5:w=*N;0LCV$,Ii$^$?$OMWAGD90J>e$J$i$PNc30(B */
      $RELEASE (D_WorkStrCheckLength);
      $RELEASE (D_WorkStrCheckElmSize);
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _TWO, D_WorkExcepArgPos);
      goto Exception; 
    case UnboundGroup ():   
      p_MoveWord (D_Workreg, I_EndPosSrc);
      f_DcodeEnqueue8Ope_IIIIIOOO (BLT_B_SEARCH_CHARACTERS,
				   I_OldStrSrc,
				   I_StartPosSrc,
				   I_EndPosSrc,
				   I_TableMaskSrc,
				   I_SearchTableSrc,
				   I_FoundPosDst,
				   I_NewStrDst,
				   I_NewTableDst);
      $RELEASE (D_WorkStrCheckLength);
      $RELEASE (D_WorkStrCheckElmSize);
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction;
    case ATOM:
    case FloatingGrp ():
    case StructureGroup ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_WorkStrCheckLength);
      $RELEASE (D_WorkStrCheckElmSize);
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _TWO, D_WorkExcepArgPos);
      goto Exception;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_search_strings", "undefined_type");};
      $RELEASE (D_WorkStrCheckLength);
      $RELEASE (D_WorkStrCheckElmSize);
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; 
    }


  /* $BBh(B3$B0z?t(B($B%F!<%V%k%(%l%a%s%H%^%9%/(B)$B$N%A%'%C%/(B */
  f_ActiveDeref (I_TableMaskSrc, D_Workreg);
  TypeSwitch (I_TableMaskSrc) {
    case INT:
      /* $B@0?t$J$i(BOK */
      /* D_WorkStrCheckElmSize$B$O8e$N0z?t%A%'%C%/$G$b;H$&$N$G%j%j!<%9$7$J$$(B */
      break;
    case UnboundGroup ():   
      p_MoveWord (D_Workreg, I_TableMaskSrc);
      f_DcodeEnqueue8Ope_IIIIIOOO (BLT_B_SEARCH_CHARACTERS,
				   I_OldStrSrc,
				   I_StartPosSrc,
				   I_EndPosSrc,
				   I_TableMaskSrc,
				   I_SearchTableSrc,
				   I_FoundPosDst,
				   I_NewStrDst,
				   I_NewTableDst);
      $RELEASE (D_Workreg);
      $RELEASE (D_WorkStrCheckElmSize);
      goto End_of_KL1B_Instruction; 
    case ATOM:
    case FloatingGrp ():
    case StructureGroup ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg);
      $RELEASE (D_WorkStrCheckElmSize);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _THREE, D_WorkExcepArgPos);
      goto Exception;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_search_strings", "undefined_type");};
      $RELEASE (D_Workreg);
      $RELEASE (D_WorkStrCheckElmSize);
      goto End_of_KL1B_Instruction; 
    }

  /* $BBh(B4$B0z?t(B($B8!:w%F!<%V%k(B)$B$N%A%'%C%/(B */
  f_ActiveDeref (I_SearchTableSrc, D_Workreg);

  TypeSwitch (I_SearchTableSrc) {
    case StringGrp ():
      $USE(D_WorkStrCheckLength);
      $USE(D_WorkTableElemSize);
      s_GetStringType (I_SearchTableSrc, D_WorkStrCheckLength,
			                               D_WorkTableElemSize);
      b_IfNotEqualImm(D_WorkTableElemSize, _SEARCH_CHAR_TBL_ELM_SIZE)
	{ /* $B8!:w%F!<%V%k$,(B8$B%S%C%H%9%H%j%s%00J30$G$"$l$PNc30(B */
	  $RELEASE(D_WorkStrCheckLength);
	  $RELEASE(D_WorkStrCheckElmSize);
	  $RELEASE(D_WorkTableElemSize);
	  $RELEASE(D_Workreg);
	  $USE(D_WorkExceptionCode);
	  $USE(D_WorkExcepArgPos);
	  b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP,
				                       D_WorkExceptionCode);
	  b_SetImmTypeValueMRBoff (INT, _FOUR, D_WorkExcepArgPos);
	  goto Exception; break;
	}

      b_DecrementReg(D_WorkStrCheckElmSize); /* D_WorkStrCheckElmSize$B$K$O(B */
	                            /* $B$^$@8!:wBP>]%9%H%j%s%0$NMWAG%5%$%:$,(B */
                                    /* $BF~$C$F$$$F%j%j!<%9$5$l$F$$$J$$$O$:(B */
      $USE(D_WorkSearchTableSize);
      /* 2^($B%9%H%j%s%0MWAG%5%$%:(B)$B$N7W;;(B */
      p_SetImmediateValue(_TWO, D_WorkSearchTableSize);
      b_ShiftLeftWithDNTC(D_WorkSearchTableSize, D_WorkStrCheckElmSize,
		                                     D_WorkSearchTableSize);
      b_IfNotEqual(D_WorkSearchTableSize, D_WorkStrCheckLength)
	{ /* $B8!:w%F!<%V%k%5%$%:$,(B 2^($B%9%H%j%s%0MWAG%5%$%:(B)$B0J30$G$"$l$PNc30(B */
	  $RELEASE(D_WorkStrCheckLength);
	  $RELEASE(D_WorkStrCheckElmSize);
	  $RELEASE(D_WorkTableElemSize);
	  $RELEASE(D_WorkSearchTableSize);
	  $RELEASE(D_Workreg);
	  $USE(D_WorkExceptionCode);
	  $USE(D_WorkExcepArgPos);
	  b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP,
				                       D_WorkExceptionCode);
	  b_SetImmTypeValueMRBoff (INT, _FOUR, D_WorkExcepArgPos);
	  goto Exception; break;
	}
      $RELEASE(D_WorkStrCheckLength);
      $RELEASE(D_WorkSearchTableSize);
      $RELEASE(D_WorkStrCheckElmSize);
      $RELEASE(D_WorkTableElemSize);
      $RELEASE(D_Workreg);
      break;
    case UnboundGroup ():   
      p_MoveWord (D_Workreg, I_OldStrSrc);
      f_DcodeEnqueue8Ope_IIIIIOOO (BLT_B_SEARCH_CHARACTERS,
				   I_OldStrSrc,
				   I_StartPosSrc,
				   I_EndPosSrc,
				   I_TableMaskSrc,
				   I_SearchTableSrc,
				   I_FoundPosDst,
				   I_NewStrDst,
				   I_NewTableDst);
      $RELEASE(D_Workreg);
      $RELEASE(D_WorkStrCheckElmSize);
      goto End_of_KL1B_Instruction; break;
    case ConstantGroup ():
    case ListGrp ():
    case NullVectorGrp ():
    case ShortVectorGrp ():
    case LongVectorGrp ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE(D_Workreg);
      $RELEASE(D_WorkStrCheckElmSize);
      $USE(D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _FOUR, D_WorkExcepArgPos);
      goto Exception; break;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_search_characters", "undefined_type");};
      $RELEASE (D_Workreg);
      $RELEASE(D_WorkStrCheckElmSize);
      goto End_of_KL1B_Instruction; break;
    }

  /***************************************/
  /* search_characters$B$N<B:]$N=hM}(B        */
  /***************************************/

  /* search_character$B$H(Bsearch_characters$B$N=hM}$r(Bf_SearchCharacter$B$K$^$H$a$?(B */
  /* $B$=$l$>$l$N=hM}$N6hJL$O(Bf_SearchCharacter$B$NBh(B4$B0z?t$N%?%0$GH=Dj$9$k!#(B
         Tag = ATOM  ->  search_character
         Tag = INT   ->  search_characters                                  */

  f_SearchCharacter(I_OldStrSrc,
		    I_StartPosSrc,
		    I_EndPosSrc,
		    I_SearchTableSrc,
		    I_TableMaskSrc,   /* $B$3$N0z?t$N%?%0$G=hM}$rJ,$1$k(B */
		    I_FoundPosDst);

  p_MoveWord(I_OldStrSrc, I_NewStrDst);
  p_MoveWord(I_SearchTableSrc, I_NewTableDst);

  goto End_of_KL1B_Instruction;

 Exception:
  $USE (D_WorkOpCode);
  b_SetImmTypeValueMRBoff (INT, BLT_B_SEARCH_CHARACTERS, D_WorkOpCode);
  $CALL (f_Exception_8Arg_IIIIIOOO_Sub(D_WorkExceptionCode, D_WorkOpCode, 
				       D_WorkExcepArgPos,
				       I_OldStrSrc,
				       I_StartPosSrc,
				       I_EndPosSrc,
				       I_TableMaskSrc,
				       I_SearchTableSrc,
				       I_FoundPosDst,
				       I_NewStrDst,
				       I_NewTableDst) );
  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
 End_of_KL1B_Instruction: ;
}

/******************************************************************** PSL **
kblt_b_change_element_size A1, A2, A3

       written by kawai@icot22      on Wed Jul 17 14:46:04 1991

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    | b_change_element_size |     A1    |     A2    |
    +-----------+-----------+-----------+-----------+
    |    A3     |            don't care             |
    +-----------+-----------+-----------+-----------+

<Arguments>
  A1   $BF~NO(B  $B%9%H%j%s%0(B ($B%l%8%9%?(B)
       ($BL$Dj5A$J$i%5%9%Z%s%I!"%9%H%j%s%00J30$J$iNc30(B)
  A2   $BF~NO(B  $B%9%H%j%s%0$N?7MWAG%5%$%:(B  ($B%l%8%9%?(B)
       ($BL$Dj5A$J$i%5%9%Z%s%I!"(B1$B!"(B8$B!"(B16$B!"(B32$B$N@0?t0J30$J$iNc30(B)
  A3   $B=PNO(B  $B=PNO%9%H%j%s%0(B  ($B%l%8%9%?(B)
	 
<Temporally Used Variables>
<Level>   interpreter
<PreCondition>
  $B!&F~NO$H=PNO$N%l%8%9%?$O!"=EJ#$7$J$$!#(B
  $B!&%9%H%j%s%0$NMWAG%5%$%:$*$h$S?7MWAG%5%$%:$O!"(B1$B!"(B8$B!"(B16$B!"(B32$B$H$9$k!#(B
<Function>
  $B!&(BA1$B!A(BA2$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B
    $B!&3FF~NO%A%'%C%/$K0z$C3]$+$l$P!"Nc30=hM}!#(B
  $B!&%9%H%j%s%0(B(A1)$B$NMWAG%5%$%:$r?7MWAG%5%$%:(B(A2)$B$KJQ49$7!"=PNO%9%H%j%s%0(B(A3)
    $B$K%f%K%U%!%$$9$k!#(B
<Examples>
<Test>
<Explanation>
  $BCm0U(B:
    $BMWAG%5%$%:$rBg$-$/$9$k;~$K!"%9%H%j%s%0$NMWAG?t$,?7MWAG%5%$%:$NMWAG6-3&$K(B
  $B0lCW$7$J$$>l9g!"MWAG?t$r?7MWAG%5%$%:$NMWAG6-3&$K0lCW$9$k$h$&$K@Z$j>e$2!"(B
  $BKvHx$KDI2C$7$?MWAG$O%<%m5M$a$9$k!#(B
<ETC>
********************************************************************* PSL **/

#OPF_define I_OldStrSrc     _IndirectRegField1  /* Old string (src) */
#OPF_define I_StrElmSizeSrc _IndirectRegField2  /* String element size (src) */
#OPF_define I_NewStrDst     _IndirectRegField3  /* New string (dst) */

#PSL_define kblt_b_change_element_size () 
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_IIO_Sub(D_WorkArgVect,
				       I_OldStrSrc,
				       I_StrElmSizeSrc,
				       I_NewStrDst) );
      f_TraceBodyBuiltin(BLT_B_CHANGE_ELEMENT_SIZE, D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE (D_Workreg);

  /* $BBh(B0$B0z?t(B(String)$B$N%A%'%C%/(B */
  f_ActiveDeref (I_OldStrSrc, D_Workreg);

  TypeSwitch (I_OldStrSrc) {
    case StringGrp (): break;
    case UnboundGroup ():   
      p_MoveWord (D_Workreg, I_OldStrSrc);
      f_DcodeEnqueue3Ope_IIO (BLT_B_CHANGE_ELEMENT_SIZE,
			      I_OldStrSrc,
			      I_StrElmSizeSrc,
			      I_NewStrDst);
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; break;
    case ConstantGroup ():
    case ListGrp ():
    case NullVectorGrp ():
    case ShortVectorGrp ():
    case LongVectorGrp ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
      goto Exception; break;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_change_element_size", "undefined_type");};
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; break;
    }


  /* $BBh(B1$B0z?t(B($B%9%H%j%s%0MWAG%5%$%:(B)$B$N%A%'%C%/(B */
  f_ActiveDeref (I_StrElmSizeSrc, D_Workreg);
  TypeSwitch (I_StrElmSizeSrc) {
    case INT:
        ValueSwitch(I_StrElmSizeSrc) {
	  case 1:
	  case 8:
	  case 16:
	  case 32:
	    break;
	  default:
	    /* $B;XDj$5$l$??7MWAG%5%$%:$,(B1$B!"(B8$B!"(B16$B!"(B32$B%S%C%H0J30$@$C$?$iNc30(B */
	    /* $B$3$N>l9g(B _RANGE_OVERFLOW$BNc30$H$J$k!#(B */
	    /* _ILLEGAL_INPUT$BNc30$NJ}$,E,@Z$+$H$b;W$&$,!"(BMulti-PSI$B$K9g$o$;$?(B */
	    $RELEASE (D_Workreg);
	    $USE (D_WorkExceptionCode);
	    $USE(D_WorkExcepArgPos);
	    b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP,
				     D_WorkExceptionCode);
	    b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
	    goto Exception;
	  }
	break;
    case UnboundGroup ():
      p_MoveWord (D_Workreg, I_StrElmSizeSrc);
      f_DcodeEnqueue3Ope_IIO (BLT_B_CHANGE_ELEMENT_SIZE,
			      I_OldStrSrc,
			      I_StrElmSizeSrc,
			      I_NewStrDst);
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; 
    case ATOM:
    case FloatingGrp ():
    case StructureGroup ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
      goto Exception;
    default:  
      @DEBUG {VPIM_ERROR ("kblt_b_change_element_size",
			  "undefined_type");};
      $RELEASE (D_Workreg);
      goto End_of_KL1B_Instruction; 
    }

  $RELEASE (D_Workreg);

  /***************************************/
  /* change_element_size$B$N<B:]$N=hM}(B     */
  /***************************************/

  f_CopyStringMRB (I_OldStrSrc, I_NewStrDst);

  b_IfWordEq (I_NewStrDst, D_NULL) {
    /* $B%R!<%WNN0hITB-$G!"%9%H%j%s%0$r@8@.$G$-$J$+$C$?;~$O!"(B
       Dcode $B%4!<%k$r(B enqueue $B$9$k!#(B */

      f_DcodeEnqueue3Ope_IIO (BLT_B_CHANGE_ELEMENT_SIZE,
			      I_OldStrSrc,
			      I_StrElmSizeSrc,
			      I_NewStrDst);
    @DEBUG {WARNING ("kblt_b_change_element_size",
		     "Dcode Goal enqueued by Heap Shortage"); };
  } else {
    /* $B%9%H%j%s%0$r@8@.$G$-$?;~!"%*%Z%l!<%7%g%s$r9T$&(B */
    $CALL( f_ChangeElementSize_Sub(I_NewStrDst, I_StrElmSizeSrc) );
  }

  goto End_of_KL1B_Instruction;

 Exception:
  $USE (D_WorkOpCode);
  b_SetImmTypeValueMRBoff (INT, BLT_B_CHANGE_ELEMENT_SIZE, D_WorkOpCode);
  $CALL (f_Exception_3Arg_IIO_Sub(D_WorkExceptionCode, D_WorkOpCode, 
				  D_WorkExcepArgPos,
				  I_OldStrSrc,
				  I_StrElmSizeSrc,
				  I_NewStrDst) );

  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
 End_of_KL1B_Instruction: ;
}
