/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/interpreter/klb_body_blt_simple_io.psl.c
   ----- CREATED   : by f-doumae@icot22, on Sat Jun 16 14:32:23 1990
   ----- LAST SAVED: by imai@icot22, on Fri Apr  3 14:14:59 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : interpreter
   ----- ABSTRACT  : $BC1=c2=$7$?(B(PIMOS on VPIM$B$N(B)SCSI$BAH$_9~$_=R8l(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

#DATA_define	D_SimpleScsiFPPtr	XXX
#DATA_define	D_SimpleScsiEnvRecPtr	XXX
#DATA_define	D_SimpleScsiNewData	XXX
#DATA_define	D_SimpleScsiTransLen	XXX
#DATA_define	D_SimpleScsiResult	XXX
#DATA_define	D_SimpleScsiResultForPIMs	XXX
#DATA_define	D_SimpleScsiID		XXX
#DATA_define	D_SimpleScsiRecvIssue	XXX
#DATA_define	D_SimpleScsiRecvString	XXX

#OPF_define I_RegScsi       _IndirectRegField1          /* $BF~NO(B */
#OPF_define I_RegArgVect    _IndirectRegField2          /* $BF~NO0z?t%Y%/%?(B */
                                                       /* MRB$B!{$,A0Ds(B    */
#OPF_define I_RegNewData    _IndirectRegField3          /* $B=PNO(B */
#OPF_define I_RegTransferredLength _IndirectRegField4   /* $B=PNO(B */
#OPF_define I_RegID         _IndirectRegField5          /* $B=PNO(B */
#OPF_define I_RegResult     _IndirectRegField6          /* $B=PNO(B */
#OPF_define I_RegNewScsi    _IndirectRegField7          /* $B=PNO(B */

#PSL_define kblt_b_simple_scsi_command()
{
  @DEBUG{
    i_IfMasterCluster() {
      b_IfEqual(D_PE_Number,D_NULL) {
	goto Okey;
      }
    }
    VPIM_ERROR("kblt_b_simple_scsi_command",
	       "(CL 0, PE 0) can only invoke this!!");
  Okey:;
  };

/**** $BNc30%A%'%C%/(B ****/
  $USE(D_WorkFlagReg);
  $USE(D_WorkExceptionCode);
  $USE(D_WorkExcepArgPos);
  i_SimpleScsiCommandExceptionCheck(I_RegScsi, I_RegArgVect, D_WorkFlagReg, 
				    D_WorkExceptionCode, D_WorkExcepArgPos);
/*------------------------------------------------------------- 
  i_ScsiCommandExceptionCheck $B$G$O0z?t%Y%/%?(BI_RegArgVect$B$N(B
  $B3FMWAG$N%G%l%U%!%l%s%9$H=q$-La$7$r9T$J$C$F$$$k!#(B
  $B%(%/%;%W%7%g%s$,5/$3$C$?>l9g!"(B
      D_WorkFlagReg       : 0$B$G$J$$CM(B
      D_WorkExceptionCode : $B%(%/%;%W%7%g%s%3!<%I(B
      D_WorkExcepArgPos   : $B%(%/%;%W%7%g%s$r5/$3$7$?0z?t0LCV(B
  $B$,JV$k!#(B
---------------------------------------------------------------*/

  b_IfNotZero(D_WorkFlagReg){ /* $B%(%/%;%W%7%g%s$,H/@8$7$?>l9g(B */
      $RELEASE(D_WorkFlagReg);
      $USE(D_WorkOpCode);
      b_SetImmTypeValueMRBoff(INT, BLT_B_SCSI_COMMAND, D_WorkOpCode);
      $CALL (f_Exception_7Arg_IIOOOOO_Sub
	     (D_WorkExceptionCode,D_WorkOpCode, D_WorkExcepArgPos, 
	      I_RegScsi, I_RegArgVect, I_RegNewData, 
	      I_RegTransferredLength, I_RegID, I_RegResult, I_RegNewScsi));
      $RELEASE(D_WorkOpCode);
      $RELEASE(D_WorkExcepArgPos);
      $RELEASE(D_WorkExceptionCode);
      goto End_of_KL1B_Instruction;
  }
  $RELEASE(D_WorkFlagReg);
  $RELEASE(D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);


/**** $BL$B+G{JQ?t%A%'%C%/(B ****/

/*----------------------------------------------------------*/
/* I_RegScsi,I_RegArgVect$B$H$b%G%l%U$NI,MW$O$J$$(B             */
/* $B4{$K(Bi_ScsiCommandExceptionCheck $B$G%G%l%U$5$l$F$$$k!#(B     */
/*----------------------------------------------------------*/
  
/*---------- $BBh(B1$B0z?t$N%A%'%C%/(B -----------------------------*/
  s_IfREF(I_RegScsi){
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }

/*---------- $BBh(B2$B0z?t$N%A%'%C%/(B -----------------------------*/
  s_IfREF(I_RegArgVect){
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }

/*---------- $BBh(B2$B0z?t$N3FMWAG$N%A%'%C%/(B ---------------------*/
/*---------- $BBh(B2$B0z?t(B($BBh(B0$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  $USE(D_WorkUnit);
  p_ReadWithOffset(I_RegArgVect, _SCSI_COMM_UNIT_OFST, D_WorkUnit);
  s_IfREF(D_WorkUnit){
      $RELEASE(D_WorkUnit);
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B1$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  $USE(D_WorkLun);
  p_ReadWithOffset(I_RegArgVect, _SCSI_COMM_LUN_OFST, D_WorkLun);
  s_IfREF(D_WorkLun){
      $RELEASE(D_WorkUnit);$RELEASE(D_WorkLun);
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B2$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  $USE(D_WorkCommand);
  p_ReadWithOffset(I_RegArgVect, _SCSI_COMM_COMMAND_OFST, D_WorkCommand);
  s_IfREF(D_WorkCommand){
      $RELEASE(D_WorkUnit);$RELEASE(D_WorkLun);$RELEASE(D_WorkCommand);
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B3$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  $USE(D_WorkLength);
  p_ReadWithOffset(I_RegArgVect, _SCSI_COMM_LENGTH_OFST, D_WorkLength);
  s_IfREF(D_WorkLength){
      $RELEASE(D_WorkUnit);$RELEASE(D_WorkLun);$RELEASE(D_WorkCommand);
      $RELEASE(D_WorkLength);
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B4$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  $USE(D_WorkDirection);
  p_ReadWithOffset(I_RegArgVect, _SCSI_COMM_DIRECTION_OFST, D_WorkDirection);
  s_IfREF(D_WorkDirection){
      $RELEASE(D_WorkUnit);$RELEASE(D_WorkLun);$RELEASE(D_WorkCommand);
      $RELEASE(D_WorkLength);$RELEASE(D_WorkDirection);
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B5$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  $USE(D_WorkData);
  p_ReadWithOffset(I_RegArgVect, _SCSI_COMM_DATA_OFST, D_WorkData);
  s_IfREF(D_WorkData){
      $RELEASE(D_WorkUnit);$RELEASE(D_WorkLun);$RELEASE(D_WorkCommand);
      $RELEASE(D_WorkLength);$RELEASE(D_WorkDirection);$RELEASE(D_WorkData);
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B6$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  $USE(D_WorkDataPos);
  p_ReadWithOffset(I_RegArgVect, _SCSI_COMM_DATA_POS_OFST, D_WorkDataPos);
  s_IfREF(D_WorkDataPos){
      $RELEASE(D_WorkUnit);$RELEASE(D_WorkLun);$RELEASE(D_WorkCommand);
      $RELEASE(D_WorkLength);$RELEASE(D_WorkDirection);$RELEASE(D_WorkData);
      $RELEASE(D_WorkDataPos);
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }

  $USE(D_WorkData1);
  s_IfMRBon(D_WorkData){
    b_IfEqualImm (D_WorkDirection, _DIR_DATA_IN){
      $USE(D_WorkDesc);
      s_GetStringDesc(D_WorkData, D_WorkDesc);
      $CALL( s_AllocStrgMRBoffWithDesc_Sub(D_WorkData1, D_WorkDesc) );
      $RELEASE(D_WorkDesc);
      b_IfWordNotEq(D_WorkData1, D_NULL) {
	  $CALL(s_CopyWordString_Sub(D_WorkData, D_WorkData1));
      }else{
	  $RELEASE(D_WorkUnit);$RELEASE(D_WorkLun);$RELEASE(D_WorkCommand);
	  $RELEASE(D_WorkLength);$RELEASE(D_WorkDirection);
	  $RELEASE(D_WorkData);$RELEASE(D_WorkDataPos);
       /*------------------------------------------------------
	   $B%R!<%WNN0hITB-$G!"%9%H%j%s%0$r@8@.$G$-$J$+$C$?;~$O!"(B
	   $B%a%b%j%Z!<%8MW5a$r=P$7!"(BDcode $B%4!<%k$r(B enqueue $B$9$k!#(B
        -------------------------------------------------------*/
	$RELEASE(D_WorkData1);
	b_SetEventFlag(_PAGE_ALLOC_FAIL_EVENT, D_PE_Number);
	goto MAKE_DCODE_GOAL_ENQUEUE;
      } /*---- end of b_IfWordEq ----*/
    } else {
      p_MoveWord(D_WorkData, D_WorkData1);
    } /*---- end of b_IfEqualImm ----*/
  } else {
    p_MoveWord(D_WorkData, D_WorkData1);
  } /*---- end of s_IfMRBon ---- */
  $RELEASE(D_WorkData);
  $RELEASE(D_WorkDataPos);
  s_IfMRBoff(I_RegArgVect){
      s_ReclaimVect7(I_RegArgVect);
  }
  /*-------------------------------------------------
   $B%5%9%Z%s%I$9$kMW0x$,$J$/$J$C$?$N$G!"(BMRB$B$,!{$J$i$P!"(B
   $B0z?t%Y%/%?$NH"$O2s<}$9$k!#(B
   --------------------------------------------------*/

  /* $BF~NO%G!<%?$r%3%^%s%I%l%3!<%I$K%3%T!<$9$k(B ($B>JN,(B) */

  /* CDB $B$r8+$F(B test_unit_ready, inquiry $B$N>l9g$NBP1~$r9T$J$&(B */

  i_IfInquiryCDB(D_WorkCommand) {
    i_IfFepIDandLUN(D_WorkUnit,D_WorkLun) {
      i_FillInquiryElements(D_WorkData1);
      /*-- (2)TRANSFERRED LENGTH --*/
/* this would be correct
      b_SetImmTypeValueMRBoff(INT,_FIVE,I_RegTransferredLength);
* the following is due to PIMOS 3.2 bug */
      b_SetImmTypeValueMRBoff(INT,_SIX,I_RegTransferredLength);
      /*-- (3)RESULT (INT!0) --*/
      b_MoveWithImmTypeMRBoff(D_NULL,INT,I_RegResult);
    } else {
      /*-- (2)TRANSFERRED LENGTH --*/
      b_SetImmTypeValueMRBoff(INT,_ZERO,I_RegTransferredLength);
      /*-- (3)RESULT (INT!0) --*/
      b_SetImmTypeValueMRBoff(INT,_SIMPLE_SCSI_TIME_OUT,I_RegResult);
    }
      /*-- (1)NEW DATA --*/
    p_MoveWord(D_WorkData1,I_RegNewData);
      /*-- (4)ID  (INT!0) --*/
    b_MoveWithImmTypeMRBoff(D_NULL,INT,I_RegID);
      /*---(5) SCSI ---*/
    p_MoveWord(I_RegScsi, I_RegNewScsi); 
    $RELEASE(D_WorkCommand); $RELEASE(D_WorkUnit); $RELEASE(D_WorkLun);
    $RELEASE(D_WorkData1); $RELEASE(D_WorkLength); $RELEASE(D_WorkDirection);
    goto End_of_KL1B_Instruction;
  }
  i_IfTestUnitReadyCDB(D_WorkCommand) {
  /*
     test_unit_ready $B$N$H$-$O!"(BUNIT 7, LUN 0 $B$N;~$@$1(B
	Result = 0,
     $B$=$l0J30$O!"(B
        Result  = 0x00020d00
	  $B%(%i!<>\:Y%3!<%I(B(31-16)	TimeOut
	  $B40N;>uBV(B	  (15-8)	00001101 --> 0x0d
     $B$rJV$9(B
   */
    /*-- (1)NEW DATA --*/
    p_MoveWord(D_WorkData1,I_RegNewData);
    /*-- (2)TRANSFERRED LENGTH --*/
    b_MoveWithImmTypeMRBoff(D_NULL,INT,I_RegTransferredLength);
    /* p_MoveWord(D_WorkLength,I_RegTransferredLength); */
    /*-- (3)RESULT  --*/
    i_MakeResultOfTestUnitReady(D_WorkUnit,D_WorkLun,I_RegResult);
    /*-- (4)ID  (INT!0) --*/
    b_MoveWithImmTypeMRBoff(D_NULL,INT,I_RegID);
    /*---(5) SCSI ---*/
    p_MoveWord(I_RegScsi, I_RegNewScsi); 
    $RELEASE(D_WorkCommand); $RELEASE(D_WorkUnit); $RELEASE(D_WorkLun);
    $RELEASE(D_WorkData1); $RELEASE(D_WorkLength); $RELEASE(D_WorkDirection);
    goto End_of_KL1B_Instruction;
  }
  $RELEASE(D_WorkCommand);
  $RELEASE(D_WorkUnit);
  $RELEASE(D_WorkLun);

  /*--------------------------------------------------------------
      $B%3%^%s%I$N<B9T=`Hw$,=*$j!"<!$NM=Ls$,2DG=$K$J$k$H(BNewScsi$B$K<!$N(B
      $BM=Ls$N$?$a$N(BSCSI$B7?%G!<%?$rJV$9!#(B
   ---------------------------------------------------------------*/
  p_MoveWord(I_RegScsi, I_RegNewScsi); 
  
/*------------------------------------------------------------------
   $B$3$3$^$G$G%3%^%s%I%l%3!<%I$N=`Hw$,=*N;!#$3$3$+$i<B:]$N%3%^%s%I$N<B9T$,(B
   $B;n$_$i$l$k!#(B
--------------------------------------------------------------------*/
  b_IfEqualImm (D_WorkDirection, _DIR_DATA_IN){
    /* FEP $B"*(B VPIM $BE>Aw(B */
    @DEBUG{
      b_IfNotZero(D_SimpleScsiRecvIssue) {
	OUT_OF_SPEC("kblt_b_simple_scsi_command","Multiple Issue Data-IN");
      }
    };
    b_SetImmValueDNTC(_ONE,D_SimpleScsiRecvIssue);
    p_MoveWord(D_Current_FP_Ptr,	D_SimpleScsiFPPtr);
    p_MoveWord(D_CurrentEnvRecPtr,	D_SimpleScsiEnvRecPtr);
    p_MoveWord(D_WorkData1,		D_SimpleScsiRecvString);

    $USE(D_WorkNewGR);
    /*-- (1)NEW DATA --*/
    s_AllocVariable(I_RegNewData);
    s_AllocVariable(D_SimpleScsiNewData);
    $CALL( f_MakeUnifier_Sub(D_WorkNewGR, I_RegNewData, D_SimpleScsiNewData) );
    p_Write(D_WorkNewGR,D_SimpleScsiNewData);

    /*-- (2)TRANSFERRED LENGTH --*/
    s_AllocVariable(I_RegTransferredLength);
    s_AllocVariable(D_SimpleScsiTransLen);
    $CALL( f_MakeUnifier_Sub
	  (D_WorkNewGR, I_RegTransferredLength, D_SimpleScsiTransLen));
    p_Write(D_WorkNewGR,D_SimpleScsiTransLen);

    /*-- (3)RESULT (INT!0) --*/
    s_AllocVariable(I_RegResult);
    s_AllocVariable(D_SimpleScsiResult);
    $CALL( f_MakeUnifier_Sub(D_WorkNewGR, I_RegResult, D_SimpleScsiResult));
    p_Write(D_WorkNewGR,D_SimpleScsiResult);

    /*-- (4)ID  (INT!0) --*/
    s_AllocVariable(I_RegID);
    s_AllocVariable(D_SimpleScsiID);
    $CALL( f_MakeUnifier_Sub(D_WorkNewGR, I_RegID, D_SimpleScsiID));
    p_Write(D_WorkNewGR,D_SimpleScsiID);

    $RELEASE(D_WorkNewGR);
    /* Nothing To Do */
  } else {
    /* VPIM $B"*(B FEP $BE>Aw(B */
    send_data_to_fep(D_WorkLength,D_WorkData1);

    /*-- (1)NEW DATA --*/
    p_MoveWord(D_WorkData1,I_RegNewData);
    /*-- (2)TRANSFERRED LENGTH --*/
    p_MoveWord(D_WorkLength, I_RegTransferredLength);
    /*-- (3)RESULT (INT!0) --*/
    b_MoveWithImmTypeMRBoff(D_NULL,INT,I_RegResult);
    /*-- (4)ID  (INT!0) --*/
    b_MoveWithImmTypeMRBoff(D_NULL,INT,I_RegID);
  }
  $RELEASE(D_WorkData1);
  $RELEASE(D_WorkLength);
  $RELEASE(D_WorkDirection);

  goto End_of_KL1B_Instruction;

 MAKE_DCODE_GOAL_ENQUEUE:
  f_DcodeEnqueue7Ope_IIOOOOO
      (BLT_B_SCSI_COMMAND, I_RegScsi, I_RegArgVect,I_RegNewData,
       I_RegTransferredLength, I_RegID, I_RegResult, I_RegNewScsi);
 
 End_of_KL1B_Instruction:;
}


#PSL_define i_SimpleScsiCommandExceptionCheck
                       (scsi, arg_vect, excep_flag, excep_code, excep_arg_pos)
{
  $USE(D_Workreg1);

/*---------- $BBh(B1$B0z?t$N%A%'%C%/(B ----------------*/
  f_ActiveDeref(scsi, D_Workreg1);
  s_IfNotINT(scsi){ 
      s_IfUnbound(scsi){
	  @DEBUG{WARNING("i_ScsiCommandExceptionCheck","scsi");};
	  p_MoveWord(D_Workreg1, scsi);
	  $RELEASE(D_Workreg1);
	  b_SetZero( excep_flag );	/* $BNc30$G$O$J$$(B */
	  goto END;
      }else{
	  $RELEASE(D_Workreg1);
	  b_SetImmTypeValueMRBoff (INT, _ZERO, excep_arg_pos);
	  b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
	  p_MoveWord(D_ONE, excep_flag);
	  goto END;
      }
  }

/*---------- $BBh(B2$B0z?t$N%A%'%C%/(B ----------------*/
  f_ActiveDeref(arg_vect, D_Workreg1);
  s_IfNotVECT7(arg_vect){ 
      s_IfUnbound(arg_vect){
	  @DEBUG{WARNING("i_ScsiCommandExceptionCheck","arg_vect");};
	  p_MoveWord(D_Workreg1, arg_vect);
	  $RELEASE(D_Workreg1);
	  b_SetZero( excep_flag );	/* $BNc30$G$O$J$$(B */
	  goto END;
      }else{
	  $RELEASE(D_Workreg1);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
	  p_MoveWord(D_ONE, excep_flag);
	  goto END;
      }
  }
  $RELEASE(D_Workreg1);

  $USE(D_WorkUnit); $USE(D_WorkLun); $USE(D_WorkCommand); $USE(D_WorkLength);
  $USE(D_WorkDirection); $USE(D_WorkData); $USE(D_WorkDataPos);
  /* $BF~NO0z?t%Y%/%?MWAG$NFI$_=P$7(B */
  s_ReadWithOffsetMRBor(arg_vect, _SCSI_COMM_UNIT_OFST, D_WorkUnit);
  s_ReadWithOffsetMRBor(arg_vect, _SCSI_COMM_LUN_OFST, D_WorkLun);
  s_ReadWithOffsetMRBor(arg_vect, _SCSI_COMM_COMMAND_OFST, D_WorkCommand);
  s_ReadWithOffsetMRBor(arg_vect, _SCSI_COMM_LENGTH_OFST, D_WorkLength);
  s_ReadWithOffsetMRBor(arg_vect, _SCSI_COMM_DIRECTION_OFST, D_WorkDirection);
  s_ReadWithOffsetMRBor(arg_vect, _SCSI_COMM_DATA_OFST, D_WorkData);
  s_ReadWithOffsetMRBor(arg_vect, _SCSI_COMM_DATA_POS_OFST, D_WorkDataPos);

  $USE(D_WorkPos);
  b_SetZero(D_WorkPos);
/*---------- $BBh(B2$B0z?t(B($BBh(B0$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  f_DerefElementReg(arg_vect, D_WorkPos, D_WorkUnit);
  s_IfINT(D_WorkUnit){
      b_IfScsiRangeErr(D_WorkUnit, _SCSI_MIN_UNIT_NUMBER, _SCSI_MAX_UNIT_NUMBER){
	  $RELEASE(D_WorkPos);
	  b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  goto EXCEPTION;
      }
  }else{
      $RELEASE(D_WorkPos);
      s_IfREF(D_WorkUnit){ goto CHECK_END;}
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
      b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
      goto EXCEPTION;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B1$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  b_IncrementAddrReg(D_WorkPos);
  f_DerefElementReg(arg_vect, D_WorkPos, D_WorkLun);
  s_IfINT(D_WorkLun){
      b_IfScsiRangeErr(D_WorkLun, _SCSI_MIN_LUN, _SCSI_MAX_LUN){
	  $RELEASE(D_WorkPos);
	  b_SetImmTypeValueMRBoff 
	      (INT, _RANGE_OVERFLOW_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  goto EXCEPTION;
      }
  }else{
      $RELEASE(D_WorkPos);
      s_IfREF(D_WorkLun){ goto CHECK_END;}
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
      b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
      goto EXCEPTION;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B2$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  b_IncrementAddrReg(D_WorkPos);
  f_DerefElementReg(arg_vect, D_WorkPos, D_WorkCommand);
  s_IfSTRG(D_WorkCommand){
      $USE(D_WorkTypeCheckReg);
      $USE(D_WorkStringLen);
      s_GetStringType(D_WorkCommand, D_WorkStringLen, D_WorkTypeCheckReg);
      b_IfNotEqualImm(D_WorkTypeCheckReg, _ELEM_SIZE_OF_STRG8){
	  $RELEASE(D_WorkPos);
	  $RELEASE(D_WorkTypeCheckReg);
	  $RELEASE(D_WorkStringLen);
	  b_SetImmTypeValueMRBoff (INT,_ILLEGAL_INPUT_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  goto EXCEPTION;
      }
      $RELEASE(D_WorkTypeCheckReg);
      f_IfScsiInvalidPhysicalCommandLength(D_WorkStringLen){
	  $RELEASE(D_WorkPos);
	  $RELEASE(D_WorkStringLen);
	  b_SetImmTypeValueMRBoff 
	      (INT, _RANGE_OVERFLOW_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  goto EXCEPTION;
      }
      $RELEASE(D_WorkStringLen);
      $USE(D_WorkElement);
      $USE(D_WorkElemSize);
      $USE(D_WorkElemPos);
      b_SetImmValueDNTC(_ELEM_SIZE_OF_STRG8, D_WorkElemSize);
      b_SetImmValueDNTC(_ZERO, D_WorkElemPos);
      s_GetStringElement
	  (D_WorkCommand, D_WorkElemPos, D_WorkElemSize, D_WorkElement);
      $RELEASE(D_WorkElemPos);
      $RELEASE(D_WorkElemSize);
      $USE(D_WorkCommLen);
      s_GetScsiCDBLength(D_WorkElement, D_WorkCommLen);
      $RELEASE(D_WorkElement);
      f_IfScsiInvalidLogicalCommandLength(D_WorkCommLen){
	  $RELEASE(D_WorkPos);
	  $RELEASE(D_WorkCommLen);
	  b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  goto EXCEPTION;
      }
      $RELEASE(D_WorkCommLen);
  }else{
      $RELEASE(D_WorkPos);
      s_IfREF(D_WorkCommand){ goto CHECK_END;}
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
      b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
      goto EXCEPTION;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B3$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  b_IncrementAddrReg(D_WorkPos);
  f_DerefElementReg(arg_vect, D_WorkPos, D_WorkLength);
  s_IfINT(D_WorkLength){
	/* $B$3$N"-$N%A%'%C%/$N$_$,!"K\Ev$NAH$_9~$_$H$N0c$$(B */
      b_IfScsiRangeErr(D_WorkLength, _ZERO, _SIMP_SCSI_COMM_REC_BUF_SIZE) {
	  $RELEASE(D_WorkPos);
	  b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  goto EXCEPTION;
      }
  }else{
      $RELEASE(D_WorkPos);
      s_IfREF(D_WorkLength){ goto CHECK_END;}
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
      b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
      goto EXCEPTION;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B4$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  b_IncrementAddrReg(D_WorkPos);
  f_DerefElementReg(arg_vect, D_WorkPos, D_WorkDirection);
  s_IfINT(D_WorkDirection){
      b_IfScsiRangeErr(D_WorkDirection, _ZERO, _TWO){
	  $RELEASE(D_WorkPos);
	  b_SetImmTypeValueMRBoff (INT,_RANGE_OVERFLOW_EXCP,excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  goto EXCEPTION;
      }
  }else{
      $RELEASE(D_WorkPos);
      s_IfREF(D_WorkDirection){ goto CHECK_END;}
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
      b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
      goto EXCEPTION;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B5$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  b_IncrementAddrReg(D_WorkPos);
  f_DerefElementReg(arg_vect, D_WorkPos, D_WorkData);
  s_IfNotSTRG(D_WorkData){
      $RELEASE(D_WorkPos);
      s_IfREF(D_WorkData){ goto CHECK_END;}
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
      b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
      goto EXCEPTION;
  }else{
      $USE(D_WorkTypeCheckReg);
      $USE(D_WorkStringLen);
      s_GetStringType(D_WorkData, D_WorkStringLen, D_WorkTypeCheckReg);
      b_IfNotEqualImm(D_WorkTypeCheckReg, _ELEM_SIZE_OF_STRG8){
	  $RELEASE(D_WorkPos);
	  $RELEASE(D_WorkTypeCheckReg);
	  $RELEASE(D_WorkStringLen);
	  b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  goto EXCEPTION;
      }
      $RELEASE(D_WorkTypeCheckReg);
      b_IfGreater(D_WorkLength, D_WorkStringLen){
	  $RELEASE(D_WorkPos);
	  $RELEASE(D_WorkStringLen);
	  b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  goto EXCEPTION;
      }
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B6$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  b_IncrementAddrReg(D_WorkPos);
  f_DerefElementReg(arg_vect, D_WorkPos, D_WorkDataPos);
  s_IfINT(D_WorkDataPos){
      b_IfLess(D_WorkDataPos, D_NULL){
	  $RELEASE(D_WorkPos);
	  $RELEASE(D_WorkStringLen);
	  b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  goto EXCEPTION;
      }
      b_IfRangeOver(D_WorkDataPos, D_WorkStringLen){
	b_IfNotZero(D_WorkDataPos) {
	  /* $B%9%H%j%s%0D9#0!"%]%8%7%g%s#0$N;~$N$_!"Nc30$G$O$J$$(B */
	  $RELEASE(D_WorkPos);
	  $RELEASE(D_WorkStringLen);
	  b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  goto EXCEPTION;
	}
      }
      b_IfEqualImm(D_WorkDirection, _ZERO){
	  /* <- b_IfNotEqualImm , reviced by f-takei 91.6.24 */
	  $RELEASE(D_WorkStringLen);
	  $RELEASE(D_WorkPos);
	  goto CHECK_END;
      }
      b_SubtractWithDNTC(D_WorkStringLen, D_WorkDataPos, D_WorkStringLen);
      b_IfGreater(D_WorkLength, D_WorkStringLen){
	  $RELEASE(D_WorkPos);
	  $RELEASE(D_WorkStringLen);
	  b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  goto EXCEPTION;
      }
      $RELEASE(D_WorkStringLen);
  }else{
      $RELEASE(D_WorkStringLen);
      $RELEASE(D_WorkPos);
      s_IfREF(D_WorkDataPos){ goto CHECK_END;}
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
      b_SetImmValueDNTC (_ONE, excep_arg_pos);
      goto EXCEPTION;
  }

  $RELEASE(D_WorkPos);
 CHECK_END:
  $RELEASE(D_WorkUnit); $RELEASE(D_WorkLun); $RELEASE(D_WorkCommand); 
  $RELEASE(D_WorkLength); $RELEASE(D_WorkDirection); $RELEASE(D_WorkData); 
  $RELEASE(D_WorkDataPos);

  b_SetZero(excep_flag);
  goto END;

 EXCEPTION:
  $RELEASE(D_WorkUnit); $RELEASE(D_WorkLun); $RELEASE(D_WorkCommand); 
  $RELEASE(D_WorkLength); $RELEASE(D_WorkDirection); $RELEASE(D_WorkData); 
  $RELEASE(D_WorkDataPos);

  p_MoveWord(D_ONE, excep_flag);

 END:
  ;
}

#CONST_define _SIMPLE_SCSI_TEST_UNIT_READY_COMMAND_BYTE	0x00

#CTRL_define   i_IfTestUnitReadyCDB(command_string_reg)
{
  $USE(D_WorkElemSize); $USE(D_WorkElement);
  b_SetImmValueDNTC(_ELEM_SIZE_OF_STRG8,D_WorkElemSize);
  s_GetStringElementPosReg
    (command_string_reg,D_NULL,D_WorkElemSize,D_WorkElement);
  p_CompareImmediate(D_WorkElement, _SIMPLE_SCSI_TEST_UNIT_READY_COMMAND_BYTE);
  $RELEASE(D_WorkElement); $RELEASE(D_WorkElemSize);
  p_IfEQ()
}

#CONST_define _SIMPLE_SCSI_INQUIRY_COMMAND_BYTE	0x12

#CTRL_define   i_IfInquiryCDB(command_string_reg)
{
  $USE(D_WorkElemSize); $USE(D_WorkElement);
  b_SetImmValueDNTC(_ELEM_SIZE_OF_STRG8,D_WorkElemSize);
  s_GetStringElementPosReg
    (command_string_reg,D_NULL,D_WorkElemSize,D_WorkElement);
  p_CompareImmediate(D_WorkElement, _SIMPLE_SCSI_INQUIRY_COMMAND_BYTE);
  $RELEASE(D_WorkElement); $RELEASE(D_WorkElemSize);
  p_IfEQ()
}

#PSL_define i_FillInquiryElements(str_ptr)
{
  $USE(D_WorkElemSize); $USE(D_WorkElement); $USE(D_WorkIndex);
  b_SetImmValueDNTC(_ELEM_SIZE_OF_STRG8,D_WorkElemSize);
  b_SetZero(D_WorkIndex);
  /* $BBh#0MWAG(B 3 */
  b_SetImmValueDNTC(_THREE,D_WorkElement);
  s_PutStringElementPosReg
    (str_ptr,D_WorkIndex,D_WorkElemSize,D_WorkElement);
  b_IncrementReg(D_WorkIndex);
  /* $BBh#1MWAG(B 0 */
  b_SetImmValueDNTC(_ZERO,D_WorkElement);
  s_PutStringElementPosReg
    (str_ptr,D_WorkIndex,D_WorkElemSize,D_WorkElement);
  b_IncrementReg(D_WorkIndex);
  /* $BBh#2MWAG(B 0 */
  s_PutStringElementPosReg
    (str_ptr,D_WorkIndex,D_WorkElemSize,D_WorkElement);
  b_IncrementReg(D_WorkIndex);
  /* $BBh#3MWAG(B 0 */
  s_PutStringElementPosReg
    (str_ptr,D_WorkIndex,D_WorkElemSize,D_WorkElement);
  b_IncrementReg(D_WorkIndex);
  /* $BBh#4MWAG(B 0 */
  s_PutStringElementPosReg
    (str_ptr,D_WorkIndex,D_WorkElemSize,D_WorkElement);
  b_IncrementReg(D_WorkIndex);
  $RELEASE(D_WorkIndex); $RELEASE(D_WorkElement); $RELEASE(D_WorkElemSize);
}

#CONST_define	_SIMPLE_SCSI_FEP_UNIT_NUM	7
#CONST_define	_SIMPLE_SCSI_FEP_LUN_NUM	0
#CONST_define	_SIMPLE_SCSI_TIME_OUT	0x00020d00

#CTRL_define i_IfFepIDandLUN(unit,lun)
{
  b_IfEqualImm(unit,_SIMPLE_SCSI_FEP_UNIT_NUM) {
    b_IfEqualImm(lun,_SIMPLE_SCSI_FEP_LUN_NUM) {
      b_SetSuccess();
    } else {
      b_SetFail();
    }
  } else {
    b_SetFail();
  }
  b_IfSuccess()
}

#PSL_define i_MakeResultOfTestUnitReady(unit,lun,dst_int_reg)
{
  i_IfFepIDandLUN(unit,lun) {
    b_SetImmTypeValueMRBoff(INT,_ZERO,dst_int_reg);
  } else {
    b_SetImmTypeValueMRBoff(INT,_SIMPLE_SCSI_TIME_OUT,dst_int_reg);
  }
}


#PSL_define kblt_b_simple_scsi_transfer()
{
  @DEBUG{OUT_OF_SPEC("kblt_b_simple_scsi_transfer","Not Supported");};
}

#PSL_define kblt_b_simple_scsi_abort()
{
  @DEBUG{OUT_OF_SPEC("kblt_b_simple_scsi_abort","Not Supported");};
}

#PSL_define kblt_b_simple_scsi_reset()
{
  @DEBUG{OUT_OF_SPEC("kblt_b_simple_scsi_reset","Not Supported");};
}

#CONST_define	_SIMP_SCSI_COMM_REC_BUF_SIZE	0x4000	/* 16K */
#CONST_define	_SIMP_SCSI_TRANS_REC_BUF_SIZE	0x1000	/* 4K */

#OPF_define I_RegScsi    _IndirectRegField1 /* $B=PNO(B */
#OPF_define I_RegRepVect _IndirectRegField2 /* $B=PNO(B */
#OPF_define I_RegInfo    _IndirectRegField3 /* $B=PNO(B */

#PSL_define kblt_b_simple_scsi_init()
{
  b_SetZero(D_DeviceNumberOnScsi); /* Tmporary for PIM/s */

  /** SCSI **/
  $USE(D_WorkScsi);
  b_ShiftLeftImmediateWithTag(D_CL_Number, _SHIFT_LEN_16, D_WorkScsi);
  $USE(D_Workreg);
  b_ShiftLeftImmediate(D_PE_Number, _SHIFT_LEN_8, D_Workreg);
  b_BitwiseOrWithTag(D_WorkScsi, D_Workreg, D_WorkScsi);
  $RELEASE(D_Workreg);
  b_BitwiseOrWithTag(D_WorkScsi, D_DeviceNumberOnScsi, I_RegScsi);
  $RELEASE(D_WorkScsi);

  /** ReportVect
	 (imai:$B<h$j4:$($:#3MWAG%Y%/%?$rJV$;$P$$$$$H$N$3$H$J$N$G!"(B{0,0,0}$B$rJV$9(B)
   **/
  s_AllocVect3(I_RegRepVect);
  $USE(D_WorkNIL);
  b_MoveWithImmTypeMRBoff(D_NULL,ATOM,D_WorkNIL);
  s_PutVectElementImmOfst(I_RegRepVect,_ELEM1_OFST_VECT,D_WorkNIL);
  s_PutVectElementImmOfst(I_RegRepVect,_ELEM2_OFST_VECT,D_WorkNIL);
  s_PutVectElementImmOfst(I_RegRepVect,_ELEM3_OFST_VECT,D_WorkNIL);
  $RELEASE(D_WorkNIL);

  /** Info **/
  s_AllocVect4(I_RegInfo);
  $USE(D_Workreg);
     /*** $B%3%^%s%I%l%3!<%IFb$N%G!<%?%P%C%U%!%5%$%:(B ***/
  b_SetImmTypeValueMRBoff(INT, _SIMP_SCSI_COMM_REC_BUF_SIZE, D_Workreg);
  p_WriteWithOffset(D_Workreg, I_RegInfo, _ELEM1_OFST_VECT);
     /*** $BE>Aw%l%3!<%IFb$N%G!<%?%P%C%U%!%5%$%:(B (0) ***/
     /*** PIMOS$B$NET9g$K$h$j!"$H$j$"$($:#0$G$J$$$b$N$rJV$9(B 1991.11.15 */
  b_SetImmTypeValueMRBoff(INT, _SIMP_SCSI_TRANS_REC_BUF_SIZE, D_Workreg);
  p_WriteWithOffset(D_Workreg, I_RegInfo, _ELEM2_OFST_VECT);
     /*** $B3HD%(BIdentify$B%a%C%;!<%8;HMQ2D(B/$BIT2D(B ***/
  b_SetImmTypeValueMRBoff(INT, _ONE,  D_Workreg);
  p_WriteWithOffset(D_Workreg, I_RegInfo, _ELEM3_OFST_VECT);
     /*** $B3d$j9~$_DLCNMQ%9%H%j!<%`(B ***/
  s_AllocVariable(D_Workreg);
  p_WriteWithOffset(D_Workreg, I_RegInfo, _ELEM4_OFST_VECT);
  p_MoveWord(D_Workreg, D_ScsiInterruptStr);
  $RELEASE(D_Workreg);

 End_of_KL1B_Instruction:
  ;
}

#OPF_define I_RegWhere	_IndirectRegField1 /* $B=PNO(B */

#PSL_define kblt_b_simple_scsi_where()
{
  /* [{0,0,0,0}] $B$rJV$9(B */
  s_AllocList(I_RegWhere);
  $USE(D_WorkVectPtr);
  s_AllocVect4(D_WorkVectPtr);
  $USE(D_WorkElement);
  b_SetImmTypeValueMRBoff(INT,_ZERO,D_WorkElement);
  s_PutVectElementImmOfst(D_WorkVectPtr,_ELEM1_OFST_VECT,D_WorkElement);
  s_PutVectElementImmOfst(D_WorkVectPtr,_ELEM2_OFST_VECT,D_WorkElement);
  s_PutVectElementImmOfst(D_WorkVectPtr,_ELEM3_OFST_VECT,D_WorkElement);
  s_PutVectElementImmOfst(D_WorkVectPtr,_ELEM4_OFST_VECT,D_WorkElement);
  $RELEASE(D_WorkElement);
  s_PutCarList(I_RegWhere,D_WorkVectPtr);
  b_SetImmTypeValueMRBoff(ATOM,_ZERO,D_WorkVectPtr);	/* [] */
  s_PutCdrList(I_RegWhere,D_WorkVectPtr);
  $RELEASE(D_WorkVectPtr);
}

#PSL_define kblt_b_simple_scsi_bus_reset()
{
  @DEBUG{OUT_OF_SPEC("kblt_b_simple_scsi_bus_reset","Not Supported");};
}

#PSL_define kblt_b_simple_scsi_terminate()
{
  @DEBUG{OUT_OF_SPEC("kblt_b_simple_scsi_terminate","Not Supported");};
}


/* $B"-(B C $B$N%U%!%s%/%7%g%s$+$i$7$+8F$P$l$J$$(B */

#PSL_define i_OutputUnifyWhenDataIn(length_reg,data_string_reg)
{
  $CALL(f_UnifyRetryInOtherFP_Sub(D_SimpleScsiFPPtr,D_SimpleScsiEnvRecPtr,
				  length_reg,D_SimpleScsiTransLen));
  $CALL(f_UnifyRetryInOtherFP_Sub(D_SimpleScsiFPPtr,D_SimpleScsiEnvRecPtr,
				  data_string_reg,D_SimpleScsiNewData));
  $USE(D_WorkInt);
  b_MoveWithImmTypeMRBoff(D_NULL,INT,D_WorkInt);
  $CALL(f_UnifyRetryInOtherFP_Sub(D_SimpleScsiFPPtr,D_SimpleScsiEnvRecPtr,
				  D_WorkInt,D_SimpleScsiID));
  b_SetImmTypeMRBoff(INT,D_SimpleScsiResultForPIMs);
  $CALL(f_UnifyRetryInOtherFP_Sub(D_SimpleScsiFPPtr,D_SimpleScsiEnvRecPtr,
				  D_SimpleScsiResultForPIMs,
				  D_SimpleScsiResult));
  $RELEASE(D_WorkInt);
  b_SetZero(D_SimpleScsiRecvIssue);
}


#PSL_define i_InitSimpleScsi() 
{
  b_SetZero(D_SimpleScsiRecvIssue);
  b_MoveWithImmTypeMRBoff(D_NULL,INT,D_SimpleScsiFPPtr);
  b_MoveWithImmTypeMRBoff(D_NULL,INT,D_SimpleScsiNewData);
  b_MoveWithImmTypeMRBoff(D_NULL,INT,D_SimpleScsiTransLen);
  b_MoveWithImmTypeMRBoff(D_NULL,INT,D_SimpleScsiResult);
  b_MoveWithImmTypeMRBoff(D_NULL,INT,D_SimpleScsiID);
  b_SetImmValueDNTC(_ZERO,D_SimpleScsiRecvIssue);
}

