
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/interpreter/klb_body_blt_shoen.psl.c
   ----- CREATED   : by yamamoto@icot22, on Mon Jun  4 20:47:19 1990
   ----- LAST SAVED: by yamamoto@icot22, on Thu Jul  9 15:52:12 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : INTERPRETER
   ----- ABSTRACT  : $BAq1`4X78$NAH$_9~$_=R8l(B

  $B$3$N%U%!%$%k$KDj5A$5$l$kAH$_9~$_=R8l$G$O!"Aq1`$N@8@.!"Aq1`$X$N%a%C%;!<(B
$B%8$NAw=P$r9T$J$&!#(B
  $B%$%s%?%W%j%?%l%Y%k$G$O!"AH$_9~$_=R8l$N0z?t$N%A%'%C%/$N$_$r9T$J$$!"Aq(B
$B1`$KBP$9$k<B:]$NA`:n$O(B'f_shoen_control.psl.c'$B$,!"AH$_9~$_=R8l$N(BD$B%3!<%I(B
$B$r;H$C$?%(%s%-%e!<=hM}$O(B'f_reduce_dcode_ope.psl.c'$B$,!"Nc30$N=hM}$O(B
'f_reduce_exception_handler.psl.c'$B$,!"$=$l$>$l9T$J$&!#(B

  $B$3$N%U%!%$%k$GDj5A$5$l$F$$$kAH$_9~$_=R8l(B 
  
#PSL_define kblt_b_create_shoen()
#PSL_define kblt_b_start_shoen() 
#PSL_define kblt_b_abort_shoen()
#PSL_define kblt_b_stop_shoen() 
#PSL_define kblt_b_remove_shoen()
#PSL_define kblt_b_add_shoen_resource()
#PSL_define kblt_b_shoen_statistics()
#PSL_define kblt_b_allow_shoen_resource_report() 
#PSL_define kblt_b_add_shoen_allowed_more_reduction() 

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
#DATA_define
       written by nakase@icot22      on Mon Jan 23 16:15:59 1989
********************************************************************* PSL **/

#DATA_define D_WorkArgnum XXX
#DATA_define D_WorkReport XXX
#DATA_define D_WorkShoen  XXX


/******************************************************************** PSL **
b_create_shoen A1, A2, A3, A4, A5
       written by nakase@icot22      Tue Dec 20 16:21:11 1988

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |      b_create_shoen   |     A1    |     A2    |
    +-----------+-----------+-----------+-----------+
    |    A3     |    A4     |     A5    | don't care|
    +-----------+-----------+-----------+-----------+

<Arguments>

   A1       $B%l%8%9%?(B($BAq1`$G<B9T$5$l$k=i4|%4!<%k$N%3!<%I(B) : I_InitGoalCode
   A2       $B%l%8%9%?(B($BAq1`$G<B9T$5$l$k=i4|%4!<%k$N0z?t%Y%/%?(B) : I_InitArgVect
   A3       $B%l%8%9%?(B($BAq1`$KM?$($k%Q%i%a!<%?$N%Y%/%?(B)     : I_ParamVect
            I_ParamVect = {PrioMin,PrioMax,NodeMin,NodeNum,ExcpMask}
   A4       $B%l%8%9%?(B($B%l%]!<%H%9%H%j!<%`=PNO(B)             : I_ReportStream
   A5       $B%l%8%9%?(B($BAq1`=PNO(B)				 : I_ShoenOutput

<Temporally Used Variables>
<Level>
<PreCondition>

$B!&(BA1 $B$,%3!<%I0J30$J$iNc30!"L$Dj5A$J$i(BD$B%3!<%I%4!<%k$r%(%s%-%e!<(B
$B!&(BA2 $B$,%Y%/%?0J30$J$iNc30!"L$Dj5A$J$i(BD$B%3!<%I%4!<%k$r%(%s%-%e!<(B
$B!&(BA3 $B$,3FMWAG$,@0?t$N(B5$BMWAG%Y%/%?0J30$J$iNc30!"$$$:$l$+$NMWAG$^$?$O(B A3$B<+BN$,(B
  $BL$Dj5A$J$i(BD$B%3!<%I%4!<%k$r%(%s%-%e!<(B

<Function>

$B!&(BA2 $B$,0z?t$N?t$N:GBgCM$r1[$($?$i!"F~NOHO0O30$NNc30$r=P$7!"<!L?Na$X(B
$B!&(BPrioMin $B$,(B 4096 $B0J>e$^$?$O(B 0$B0J2<$J$i$P!"%W%i%$%*%j%F%#HO0O30$NNc30$r=P$7!"(B
  $B<!L?Na$X(B
$B!&(BPrioMax $B$,(B 4096 $B0J>e$^$?$O(B 0$B0J2<$J$i$P!"%W%i%$%*%j%F%#HO0O30$NNc30$r=P$7!"(B
  $B<!L?Na$X(B
$B!&>e5-0J30$J$i!"%W%i%$%*%j%F%#:G>.(B PrioMin$B!":GBg(B PrioMax $B!"%?%0(B ExcpMask $B$NAq1`(B
  $B$r:n$j!"%3!<%I(B A1$B!"0z?t(B A2 $B$N%4!<%k$r%-%e!<$7!"<!L?Na$X(B

<Examples>
<Test>
<Explanation>
$B!&%9%Q%$%b!<%I$G<B9TCf$N;~$O!">o$K%9%Q%$Nc30$rH/@8$9$k!#(B(1991.1.11 by imai)
<ETC>
********************************************************************* PSL **/

/* #CONST_define _PRIORITY_MAX_LIMIT  4096     $B%W%i%$%*%j%F%#$N>e8BCM(B */
/* #CONST_define _PRIORITY_MIN_LIMIT     0     $B%W%i%$%*%j%F%#$N2<8BCM(B */

#CONST_define _PRIORITY_MAX_LIMIT _MAX_LOGICAL_PRIO /*$B%W%i%$%*%j%F%#$N>e8BCM(B*/
#CONST_define _PRIORITY_MIN_LIMIT _MIN_LOGICAL_PRIO /*$B%W%i%$%*%j%F%#$N2<8BCM(B*/

#ADDR_define _CREATE_SHOEN_PRIO_MIN_OFST 0
#ADDR_define _CREATE_SHOEN_PRIO_MAX_OFST 1
#ADDR_define _CREATE_SHOEN_NODE_MIN_OFST 2
#ADDR_define _CREATE_SHOEN_NODE_NUM_OFST 3
#ADDR_define _CREATE_SHOEN_EXCP_MASK_OFST 4

#DATA_define D_WorkCheckFlag XXX
#DATA_define D_WorkPrioMin   XXX
#DATA_define D_WorkPrioMax   XXX
#DATA_define D_WorkNodeMin   XXX
#DATA_define D_WorkNodeNum   XXX
#DATA_define D_WorkExcpMask  XXX
 
#OPF_define I_InitGoalCode 	_IndirectRegField1
#OPF_define I_InitArgVect 	_IndirectRegField2
#OPF_define I_ParamVect 	_IndirectRegField3
#OPF_define I_ReportStream 	_IndirectRegField4
#OPF_define I_ShoenOutput 	_IndirectRegField5

#PSL_define kblt_b_create_shoen()
{
  @SPY{
    f_IfSpyMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp5ArgVect_IIIOO_Sub(D_WorkArgVect,
					  I_InitGoalCode,
					  I_InitArgVect,
					  I_ParamVect,
					  I_ReportStream,
					  I_ShoenOutput));
      f_ReportSpyExceptionBuiltin( BLT_B_CREATE_SHOEN, D_WorkArgVect );
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp5ArgVect_IIIOO_Sub(D_WorkArgVect,
					  I_InitGoalCode,
					  I_InitArgVect,
					  I_ParamVect,
					  I_ReportStream,
					  I_ShoenOutput));
      f_TraceBodyBuiltin(BLT_B_CREATE_SHOEN,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_Workreg1);
  f_ActiveDeref(I_InitGoalCode,D_Workreg1);
  s_IfNotCOD(I_InitGoalCode) {
    s_IfUnbound(I_InitGoalCode) {
      p_MoveWord (D_Workreg1, I_InitGoalCode);
      goto make_dcode_goal; /* D$B%3!<%I%4!<%k$N%(%s%-%e!<(B */
    } else {
      $USE(D_WorkExceptionCode); $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkExcepArgPos);
      goto exception;       /* $BNc30=hM}(B */
    }
  }

  f_ActiveDeref(I_InitArgVect,D_Workreg1);
  s_IfVectors(I_InitArgVect) {
    $USE(D_WorkArgnum);
    s_GetSizeVectType(I_InitArgVect,D_WorkArgnum);
    b_IfGreaterImm(D_WorkArgnum,_MAX_ARGS_LONG_GR) {
      $USE(D_WorkExceptionCode); $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff(INT, _ARITY_MISMATCH_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff(INT, _ONE, D_WorkExcepArgPos);
      goto exception;       /* $BNc30=hM}(B */
    }
    $RELEASE(D_WorkArgnum);
  } else { /* s_IfNotVectors(I_InitArgVect) */
    s_IfUnbound(I_InitArgVect) {
      p_MoveWord (D_Workreg1, I_InitArgVect);
      goto make_dcode_goal; /* D$B%3!<%I%4!<%k$N%(%s%-%e!<(B */
    } else {
      $USE(D_WorkExceptionCode); $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff(INT, _ONE, D_WorkExcepArgPos);
      goto exception;       /* $BNc30=hM}(B */
    }
  }

  f_ActiveDeref(I_ParamVect,D_Workreg1);
  s_IfVECT5(I_ParamVect) {
    $USE(D_WorkPrioMin);
    p_ReadWithOffset(I_ParamVect,_CREATE_SHOEN_PRIO_MIN_OFST,D_WorkPrioMin);
    f_ActiveDeref(D_WorkPrioMin,D_Workreg1);
    s_IfINT(D_WorkPrioMin) {
      $USE(D_WorkCheckFlag);
      i_CheckMinPriorityAndRaiseExption(D_WorkPrioMin, D_WorkCheckFlag);
      b_IfZero(D_WorkCheckFlag){
	$RELEASE(D_WorkPrioMin);	$RELEASE(D_WorkCheckFlag);
        /* $BM?$($i$l$?:G>.%W%i%$%*%j%F%#$,5vMF%W%i%$%*%j%F%#HO0O30$J$iNc30(B */
	$USE(D_WorkExceptionCode); $USE(D_WorkExcepArgPos);
      /* Multi-PSI $B$G$O!"(B_OUT_OF_BOUNDS $B$K$J$C$F$$$k$N$G!"$=$l$K9g$o$;$?$,(B,
         _RANGE_OVERFLOW $B$N$[$&$,E,@Z$+!)(B */
	b_SetImmTypeValueMRBoff(INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
	b_SetImmTypeValueMRBoff(INT, _TWO, D_WorkExcepArgPos);
	goto exception;       /* $BNc30=hM}(B */
      }
      $RELEASE(D_WorkCheckFlag);
    } else {  /* s_IfNotINT() */
      s_IfUnbound(D_WorkPrioMin) {
	$RELEASE(D_WorkPrioMin);
	goto make_dcode_goal; /* D$B%3!<%I%4!<%k$N%(%s%-%e!<(B */
      } else {
	$RELEASE(D_WorkPrioMin);
        $USE(D_WorkExceptionCode); $USE(D_WorkExcepArgPos);
	b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
	b_SetImmTypeValueMRBoff(INT, _TWO, D_WorkExcepArgPos);
	goto exception;       /* $BNc30=hM}(B */
      }
    }

    $USE(D_WorkPrioMax);
    p_ReadWithOffset(I_ParamVect,_CREATE_SHOEN_PRIO_MAX_OFST,D_WorkPrioMax);
    f_ActiveDeref(D_WorkPrioMax,D_Workreg1);
    s_IfINT(D_WorkPrioMax) {
      $USE(D_WorkCheckFlag);
      i_CheckMaxPriorityAndRaiseExption(D_WorkPrioMax, D_WorkCheckFlag);
      b_IfZero(D_WorkCheckFlag){
	$RELEASE(D_WorkPrioMin); 
        $RELEASE(D_WorkPrioMax); $RELEASE(D_WorkCheckFlag);
        /* $BM?$($i$l$?:GBg%W%i%$%*%j%F%#$,5vMF%W%i%$%*%j%F%#HO0O30$J$iNc30(B */
	$USE(D_WorkExceptionCode); $USE(D_WorkExcepArgPos);
      /* Multi-PSI $B$G$O!"(B_OUT_OF_BOUNDS $B$K$J$C$F$$$k$N$G!"$=$l$K9g$o$;$?$,(B,
         _RANGE_OVERFLOW $B$N$[$&$,E,@Z$+!)(B */
	b_SetImmTypeValueMRBoff(INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
	b_SetImmTypeValueMRBoff(INT, _TWO, D_WorkExcepArgPos);
	goto exception;       /* $BNc30=hM}(B */
      }
      $RELEASE(D_WorkCheckFlag);
    } else {  /* s_IfNotINT() */
      s_IfUnbound(D_WorkPrioMax) {
	$RELEASE(D_WorkPrioMin); $RELEASE(D_WorkPrioMax);
	goto make_dcode_goal; /* D$B%3!<%I%4!<%k$N%(%s%-%e!<(B */
      } else {
	$RELEASE(D_WorkPrioMin); $RELEASE(D_WorkPrioMax);
        $USE(D_WorkExceptionCode); $USE(D_WorkExcepArgPos);
	b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
	b_SetImmTypeValueMRBoff(INT, _TWO, D_WorkExcepArgPos);
	goto exception;       /* $BNc30=hM}(B */
      }
    }

    /*---- ($B:G9b%W%i%$%*%j%F%#(B) > ($B:GDc%W%i%$%*%j%F%#(B) $B$N%A%'%C%/(B ----*/
    b_IfLess(D_WorkPrioMax,D_WorkPrioMin) {
      $RELEASE(D_WorkPrioMin); $RELEASE(D_WorkPrioMax);
      $USE(D_WorkExceptionCode); $USE(D_WorkExcepArgPos);
      /* Multi-PSI $B$G$O!"(B_OUT_OF_BOUNDS $B$K$J$C$F$$$k$N$G!"$=$l$K9g$o$;$?$,(B,
         _RANGE_OVERFLOW $B$N$[$&$,E,@Z$+!)(B */
      b_SetImmTypeValueMRBoff(INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff(INT, _TWO, D_WorkExcepArgPos);
      goto exception;       /* $BNc30=hM}(B */
    }

    $USE(D_WorkNodeMin);
    p_ReadWithOffset(I_ParamVect,_CREATE_SHOEN_NODE_MIN_OFST,D_WorkNodeMin);
    f_ActiveDeref(D_WorkNodeMin,D_Workreg1);
    s_IfNotINT(D_WorkNodeMin) {
      s_IfUnbound(D_WorkNodeMin) {
	$RELEASE(D_WorkPrioMin); $RELEASE(D_WorkPrioMax);
	$RELEASE(D_WorkNodeMin);
	goto make_dcode_goal; /* D$B%3!<%I%4!<%k$N%(%s%-%e!<(B */
      } else {
	$RELEASE(D_WorkPrioMin); $RELEASE(D_WorkPrioMax);
	$RELEASE(D_WorkNodeMin);
        $USE(D_WorkExceptionCode); $USE(D_WorkExcepArgPos);
	b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
	b_SetImmTypeValueMRBoff(INT, _TWO, D_WorkExcepArgPos);
	goto exception;       /* $BNc30=hM}(B */
      }
    }

    $USE(D_WorkNodeNum);
    p_ReadWithOffset(I_ParamVect,_CREATE_SHOEN_NODE_NUM_OFST,D_WorkNodeNum);
    f_ActiveDeref(D_WorkNodeNum,D_Workreg1);
    s_IfNotINT(D_WorkNodeNum) {
      s_IfUnbound(D_WorkNodeNum) {
	$RELEASE(D_WorkPrioMin); $RELEASE(D_WorkPrioMax);
	$RELEASE(D_WorkNodeMin); $RELEASE(D_WorkNodeNum);
	goto make_dcode_goal; /* D$B%3!<%I%4!<%k$N%(%s%-%e!<(B */
      } else {
	$RELEASE(D_WorkPrioMin); $RELEASE(D_WorkPrioMax);
	$RELEASE(D_WorkNodeMin); $RELEASE(D_WorkNodeNum);
        $USE(D_WorkExceptionCode); $USE(D_WorkExcepArgPos);
	b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
	b_SetImmTypeValueMRBoff(INT, _TWO, D_WorkExcepArgPos);
	goto exception;       /* $BNc30=hM}(B */
      }
    }

    /* !!! Range check for Space-division of CurrentFP and SH !!! */
    b_IfEqual(D_WorkNodeNum, D_NULL) {
      /* $B$b$7(B NodeNum = 0 $B$J$i$P!"?FN$?F$HF1$8%N!<%IHO0O$K$9$k(B */
      /* D_WorkNodeMin, D_WorkNodeNum $B$r=q$-DY$9$N$GCm0U$9$k$3$H(B */
      s_GetFPMinNode(D_Current_FP_Ptr, D_WorkNodeMin);
      s_GetFPNodeCount(D_Current_FP_Ptr, D_WorkNodeNum);
    }else{
      s_IfNodeAndCountOutOfBounds(D_Current_FP_Ptr, D_WorkNodeMin,
				  D_WorkNodeNum) {
	$RELEASE(D_WorkPrioMin); $RELEASE(D_WorkPrioMax);
	$RELEASE(D_WorkNodeMin); $RELEASE(D_WorkNodeNum);
	$USE(D_WorkExceptionCode); $USE(D_WorkExcepArgPos);
	b_SetImmTypeValueMRBoff(INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
	b_SetImmTypeValueMRBoff(INT, _TWO, D_WorkExcepArgPos);
	goto exception;       /* $BNc30=hM}(B */
      }
    }
    
    $USE(D_WorkExcpMask);
    p_ReadWithOffset(I_ParamVect,_CREATE_SHOEN_EXCP_MASK_OFST,D_WorkExcpMask);
    f_ActiveDeref(D_WorkExcpMask,D_Workreg1);
    s_IfNotINT(D_WorkExcpMask) {
      s_IfUnbound(D_WorkExcpMask) {
	$RELEASE(D_WorkPrioMin); $RELEASE(D_WorkPrioMax);
	$RELEASE(D_WorkNodeMin); $RELEASE(D_WorkNodeNum);
	$RELEASE(D_WorkExcpMask);
	goto make_dcode_goal; /* D$B%3!<%I%4!<%k$N%(%s%-%e!<(B */
      } else {
	$RELEASE(D_WorkPrioMin); $RELEASE(D_WorkPrioMax);
	$RELEASE(D_WorkNodeMin); $RELEASE(D_WorkNodeNum);
	$RELEASE(D_WorkExcpMask);
        $USE(D_WorkExceptionCode); $USE(D_WorkExcepArgPos);
	b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
	b_SetImmTypeValueMRBoff(INT, _TWO, D_WorkExcepArgPos);
	goto exception;       /* $BNc30=hM}(B */
      }
    }
  } else { /* s_IfNotVECT5() */
    s_IfUnbound(I_ParamVect) {
      p_MoveWord (D_Workreg1, I_ParamVect);
      goto make_dcode_goal; /* D$B%3!<%I%4!<%k$N%(%s%-%e!<(B */
    } else {
      $USE(D_WorkExceptionCode); $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff(INT, _TWO, D_WorkExcepArgPos);
      goto exception;       /* $BNc30=hM}(B */
    }
  }

  $USE(D_WorkReport);
  s_AllocVariable(D_WorkReport);
  $USE(D_WorkShoen);
  $CALL( f_CreateShoen_Sub     /* !!! Modified for Space-devision !!! */
    (D_WorkPrioMin,D_WorkPrioMax,D_WorkNodeMin,D_WorkNodeNum,D_WorkExcpMask,
     I_InitGoalCode,I_InitArgVect,D_WorkReport,D_WorkShoen) );
  p_MoveWord(D_WorkReport,I_ReportStream);
  $RELEASE(D_WorkReport);
  p_MoveWord(D_WorkShoen,I_ShoenOutput);
  $RELEASE(D_WorkShoen);
  $RELEASE(D_WorkPrioMin); $RELEASE(D_WorkPrioMax); $RELEASE(D_WorkExcpMask);
  $RELEASE(D_WorkNodeMin); $RELEASE(D_WorkNodeNum);
  goto end;

 exception:
  $USE(D_WorkOpCode);
  b_SetImmTypeValueMRBoff(INT, BLT_B_CREATE_SHOEN, D_WorkOpCode);
  $CALL(f_Exception_5Arg_IIIOO_Sub
        (D_WorkExceptionCode,D_WorkOpCode,D_WorkExcepArgPos,
       I_InitGoalCode,I_InitArgVect,I_ParamVect,I_ReportStream,I_ShoenOutput));

  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
  goto end;
      
/* make D-code goal D$B%3!<%I%4!<%k$r:n$C$F%(%s%-%e!<$9$k(B */
 make_dcode_goal:
  f_DcodeEnqueue5Ope_IIIOO(BLT_B_CREATE_SHOEN,
       I_InitGoalCode,I_InitArgVect,I_ParamVect,I_ReportStream,I_ShoenOutput);

 end:
  $RELEASE(D_Workreg1);
 End_of_KL1B_Instruction: ;
}

#PSL_define i_CheckMaxPriorityAndRaiseExption(max_priority_reg, check_flag)
{
  b_IfLessImm(max_priority_reg, _PRIORITY_MIN_LIMIT) {
    p_MoveWord(D_NULL, check_flag);
  } else {
    b_IfGreaterImm(max_priority_reg, _PRIORITY_MAX_LIMIT) {
      p_MoveWord(D_NULL, check_flag);
    } else {
      p_MoveWord(D_ONE, check_flag);
    }
  }
}

#PSL_define i_CheckMinPriorityAndRaiseExption(min_priority_reg, check_flag)
{
  b_IfLessImm(min_priority_reg, _PRIORITY_MIN_LIMIT) {
    p_MoveWord(D_NULL, check_flag);
  } else {
    b_IfGreaterImm(min_priority_reg, _PRIORITY_MAX_LIMIT) {
      p_MoveWord(D_NULL, check_flag);
    } else { 
      p_MoveWord(D_ONE, check_flag);
    }
  }
}

/******************************************************************** PSL **
b_create_profiling_shoen A1, A2, A3, A4, A5
       written by nakase@icot22      Tue Dec 20 16:21:11 1988

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |b_create_profiling_shoen|    A1    |     A2    |
    +-----------+-----------+-----------+-----------+
    |    A3     |    A4     |     A5    | don't care|
    +-----------+-----------+-----------+-----------+

<Arguments>

   A1       $B%l%8%9%?(B($BAq1`$G<B9T$5$l$k=i4|%4!<%k$N%3!<%I(B) : I_InitGoalCode
   A2       $B%l%8%9%?(B($BAq1`$G<B9T$5$l$k=i4|%4!<%k$N0z?t%Y%/%?(B) : I_InitArgVect
   A3       $B%l%8%9%?(B($BAq1`$KM?$($k%Q%i%a!<%?$N%Y%/%?(B)     : I_ParamVect
            I_ParamVect = {PrioMin,PrioMax,NodeMin,NodeNum,ExcpMask}
   A4       $B%l%8%9%?(B($B%l%]!<%H%9%H%j!<%`=PNO(B)             : I_ReportStream
   A5       $B%l%8%9%?(B($BAq1`=PNO(B)				 : I_ShoenOutput

<Temporally Used Variables>
<Level>
<PreCondition>

$B!&(BA1 $B$,%3!<%I0J30$J$iNc30!"L$Dj5A$J$i(BD$B%3!<%I%4!<%k$r%(%s%-%e!<(B
$B!&(BA2 $B$,%Y%/%?0J30$J$iNc30!"L$Dj5A$J$i(BD$B%3!<%I%4!<%k$r%(%s%-%e!<(B
$B!&(BA3 $B$,3FMWAG$,@0?t$N(B5$BMWAG%Y%/%?0J30$J$iNc30!"$$$:$l$+$NMWAG$^$?$O(B A3$B<+BN$,(B
  $BL$Dj5A$J$i(BD$B%3!<%I%4!<%k$r%(%s%-%e!<(B

<Function>

$B!&(BA2 $B$,0z?t$N?t$N:GBgCM$r1[$($?$i!"F~NOHO0O30$NNc30$r=P$7!"<!L?Na$X(B
$B!&(BPrioMin $B$,(B 4096 $B0J>e$^$?$O(B 0$B0J2<$J$i$P!"%W%i%$%*%j%F%#HO0O30$NNc30$r=P$7!"(B
  $B<!L?Na$X(B
$B!&(BPrioMax $B$,(B 4096 $B0J>e$^$?$O(B 0$B0J2<$J$i$P!"%W%i%$%*%j%F%#HO0O30$NNc30$r=P$7!"(B
  $B<!L?Na$X(B
$B!&>e5-0J30$J$i!"%W%i%$%*%j%F%#:G>.(B PrioMin$B!":GBg(B PrioMax $B!"%?%0(B ExcpMask $B$NAq1`(B
  $B$r:n$j!"%3!<%I(B A1$B!"0z?t(B A2 $B$N%4!<%k$r%-%e!<$7!"<!L?Na$X(B

<Examples>
<Test>
<Explanation>
$B!&%9%Q%$%b!<%I$G<B9TCf$N;~$O!">o$K%9%Q%$Nc30$rH/@8$9$k!#(B(1991.1.11 by imai)
<ETC>
********************************************************************* PSL **/

#OPF_define I_InitGoalCode 	_IndirectRegField1
#OPF_define I_InitArgVect 	_IndirectRegField2
#OPF_define I_ParamVect 	_IndirectRegField3
#OPF_define I_ReportStream 	_IndirectRegField4
#OPF_define I_ShoenOutput 	_IndirectRegField5

#PSL_define kblt_b_create_profiling_shoen()
{
  @SPY{
    f_IfSpyMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp5ArgVect_IIIOO_Sub(D_WorkArgVect,
					  I_InitGoalCode,
					  I_InitArgVect,
					  I_ParamVect,
					  I_ReportStream,
					  I_ShoenOutput));
      f_ReportSpyExceptionBuiltin(BLT_B_CREATE_PROFILING_SHOEN, D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp5ArgVect_IIIOO_Sub(D_WorkArgVect,
					  I_InitGoalCode,
					  I_InitArgVect,
					  I_ParamVect,
					  I_ReportStream,
					  I_ShoenOutput));
      f_TraceBodyBuiltin(BLT_B_CREATE_PROFILING_SHOEN,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_Workreg1);
  f_ActiveDeref(I_InitGoalCode,D_Workreg1);
  s_IfNotCOD(I_InitGoalCode) {
    s_IfUnbound(I_InitGoalCode) {
      p_MoveWord (D_Workreg1, I_InitGoalCode);
      goto make_dcode_goal; /* D$B%3!<%I%4!<%k$N%(%s%-%e!<(B */
    } else {
      $USE(D_WorkExceptionCode); $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkExcepArgPos);
      goto exception;       /* $BNc30=hM}(B */
    }
  }

  f_ActiveDeref(I_InitArgVect,D_Workreg1);
  s_IfVectors(I_InitArgVect) {
    $USE(D_WorkArgnum);
    s_GetSizeVectType(I_InitArgVect,D_WorkArgnum);
    b_IfGreaterImm(D_WorkArgnum,_MAX_ARGS_LONG_GR) {
      $USE(D_WorkExceptionCode); $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff(INT, _ARITY_MISMATCH_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff(INT, _ONE, D_WorkExcepArgPos);
      goto exception;       /* $BNc30=hM}(B */
    }
    $RELEASE(D_WorkArgnum);
  } else { /* s_IfNotVectors(I_InitArgVect) */
    s_IfUnbound(I_InitArgVect) {
      p_MoveWord (D_Workreg1, I_InitArgVect);
      goto make_dcode_goal; /* D$B%3!<%I%4!<%k$N%(%s%-%e!<(B */
    } else {
      $USE(D_WorkExceptionCode); $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff(INT, _ONE, D_WorkExcepArgPos);
      goto exception;       /* $BNc30=hM}(B */
    }
  }

  f_ActiveDeref(I_ParamVect,D_Workreg1);
  s_IfVECT5(I_ParamVect) {
    $USE(D_WorkPrioMin);
    p_ReadWithOffset(I_ParamVect,_CREATE_SHOEN_PRIO_MIN_OFST,D_WorkPrioMin);
    f_ActiveDeref(D_WorkPrioMin,D_Workreg1);
    s_IfINT(D_WorkPrioMin) {
      $USE(D_WorkCheckFlag);
      i_CheckMinPriorityAndRaiseExption(D_WorkPrioMin, D_WorkCheckFlag);
      b_IfZero(D_WorkCheckFlag){
	$RELEASE(D_WorkPrioMin);	$RELEASE(D_WorkCheckFlag);
        /* $BM?$($i$l$?:G>.%W%i%$%*%j%F%#$,5vMF%W%i%$%*%j%F%#HO0O30$J$iNc30(B */
	$USE(D_WorkExceptionCode); $USE(D_WorkExcepArgPos);
      /* Multi-PSI $B$G$O!"(B_OUT_OF_BOUNDS $B$K$J$C$F$$$k$N$G!"$=$l$K9g$o$;$?$,(B,
         _RANGE_OVERFLOW $B$N$[$&$,E,@Z$+!)(B */
	b_SetImmTypeValueMRBoff(INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
	b_SetImmTypeValueMRBoff(INT, _TWO, D_WorkExcepArgPos);
	goto exception;       /* $BNc30=hM}(B */
      }
      $RELEASE(D_WorkCheckFlag);
    } else {  /* s_IfNotINT() */
      s_IfUnbound(D_WorkPrioMin) {
	$RELEASE(D_WorkPrioMin);
	goto make_dcode_goal; /* D$B%3!<%I%4!<%k$N%(%s%-%e!<(B */
      } else {
	$RELEASE(D_WorkPrioMin);
        $USE(D_WorkExceptionCode); $USE(D_WorkExcepArgPos);
	b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
	b_SetImmTypeValueMRBoff(INT, _TWO, D_WorkExcepArgPos);
	goto exception;       /* $BNc30=hM}(B */
      }
    }

    $USE(D_WorkPrioMax);
    p_ReadWithOffset(I_ParamVect,_CREATE_SHOEN_PRIO_MAX_OFST,D_WorkPrioMax);
    f_ActiveDeref(D_WorkPrioMax,D_Workreg1);
    s_IfINT(D_WorkPrioMax) {
      $USE(D_WorkCheckFlag);
      i_CheckMaxPriorityAndRaiseExption(D_WorkPrioMax, D_WorkCheckFlag);
      b_IfZero(D_WorkCheckFlag){
	$RELEASE(D_WorkPrioMin); 
        $RELEASE(D_WorkPrioMax); $RELEASE(D_WorkCheckFlag);
        /* $BM?$($i$l$?:GBg%W%i%$%*%j%F%#$,5vMF%W%i%$%*%j%F%#HO0O30$J$iNc30(B */
	$USE(D_WorkExceptionCode); $USE(D_WorkExcepArgPos);
      /* Multi-PSI $B$G$O!"(B_OUT_OF_BOUNDS $B$K$J$C$F$$$k$N$G!"$=$l$K9g$o$;$?$,(B,
         _RANGE_OVERFLOW $B$N$[$&$,E,@Z$+!)(B */
	b_SetImmTypeValueMRBoff(INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
	b_SetImmTypeValueMRBoff(INT, _TWO, D_WorkExcepArgPos);
	goto exception;       /* $BNc30=hM}(B */
      }
      $RELEASE(D_WorkCheckFlag);
    } else {  /* s_IfNotINT() */
      s_IfUnbound(D_WorkPrioMax) {
	$RELEASE(D_WorkPrioMin); $RELEASE(D_WorkPrioMax);
	goto make_dcode_goal; /* D$B%3!<%I%4!<%k$N%(%s%-%e!<(B */
      } else {
	$RELEASE(D_WorkPrioMin); $RELEASE(D_WorkPrioMax);
        $USE(D_WorkExceptionCode); $USE(D_WorkExcepArgPos);
	b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
	b_SetImmTypeValueMRBoff(INT, _TWO, D_WorkExcepArgPos);
	goto exception;       /* $BNc30=hM}(B */
      }
    }

    /*---- ($B:G9b%W%i%$%*%j%F%#(B) > ($B:GDc%W%i%$%*%j%F%#(B) $B$N%A%'%C%/(B ----*/
    b_IfLess(D_WorkPrioMax,D_WorkPrioMin) {
      $RELEASE(D_WorkPrioMin); $RELEASE(D_WorkPrioMax);
      $USE(D_WorkExceptionCode); $USE(D_WorkExcepArgPos);
      /* Multi-PSI $B$G$O!"(B_OUT_OF_BOUNDS $B$K$J$C$F$$$k$N$G!"$=$l$K9g$o$;$?$,(B,
         _RANGE_OVERFLOW $B$N$[$&$,E,@Z$+!)(B */
      b_SetImmTypeValueMRBoff(INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff(INT, _TWO, D_WorkExcepArgPos);
      goto exception;       /* $BNc30=hM}(B */
    }

    $USE(D_WorkNodeMin);
    p_ReadWithOffset(I_ParamVect,_CREATE_SHOEN_NODE_MIN_OFST,D_WorkNodeMin);
    f_ActiveDeref(D_WorkNodeMin,D_Workreg1);
    s_IfNotINT(D_WorkNodeMin) {
      s_IfUnbound(D_WorkNodeMin) {
	$RELEASE(D_WorkPrioMin); $RELEASE(D_WorkPrioMax);
	$RELEASE(D_WorkNodeMin);
	goto make_dcode_goal; /* D$B%3!<%I%4!<%k$N%(%s%-%e!<(B */
      } else {
	$RELEASE(D_WorkPrioMin); $RELEASE(D_WorkPrioMax);
	$RELEASE(D_WorkNodeMin);
        $USE(D_WorkExceptionCode); $USE(D_WorkExcepArgPos);
	b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
	b_SetImmTypeValueMRBoff(INT, _TWO, D_WorkExcepArgPos);
	goto exception;       /* $BNc30=hM}(B */
      }
    }

    $USE(D_WorkNodeNum);
    p_ReadWithOffset(I_ParamVect,_CREATE_SHOEN_NODE_NUM_OFST,D_WorkNodeNum);
    f_ActiveDeref(D_WorkNodeNum,D_Workreg1);
    s_IfNotINT(D_WorkNodeNum) {
      s_IfUnbound(D_WorkNodeNum) {
	$RELEASE(D_WorkPrioMin); $RELEASE(D_WorkPrioMax);
	$RELEASE(D_WorkNodeMin); $RELEASE(D_WorkNodeNum);
	goto make_dcode_goal; /* D$B%3!<%I%4!<%k$N%(%s%-%e!<(B */
      } else {
	$RELEASE(D_WorkPrioMin); $RELEASE(D_WorkPrioMax);
	$RELEASE(D_WorkNodeMin); $RELEASE(D_WorkNodeNum);
        $USE(D_WorkExceptionCode); $USE(D_WorkExcepArgPos);
	b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
	b_SetImmTypeValueMRBoff(INT, _TWO, D_WorkExcepArgPos);
	goto exception;       /* $BNc30=hM}(B */
      }
    }

    /* !!! Range check for Space-division of CurrentFP and SH !!! */
    b_IfEqual(D_WorkNodeNum, D_NULL) {
      /* $B$b$7(B NodeNum = 0 $B$J$i$P!"?FN$?F$HF1$8%N!<%IHO0O$K$9$k(B */
      /* D_WorkNodeMin, D_WorkNodeNum $B$r=q$-DY$9$N$GCm0U$9$k$3$H(B */
      s_GetFPMinNode(D_Current_FP_Ptr, D_WorkNodeMin);
      s_GetFPNodeCount(D_Current_FP_Ptr, D_WorkNodeNum);
    }else{
      s_IfNodeAndCountOutOfBounds(D_Current_FP_Ptr, D_WorkNodeMin,
				  D_WorkNodeNum) {
	$RELEASE(D_WorkPrioMin); $RELEASE(D_WorkPrioMax);
	$RELEASE(D_WorkNodeMin); $RELEASE(D_WorkNodeNum);
	$USE(D_WorkExceptionCode); $USE(D_WorkExcepArgPos);
	b_SetImmTypeValueMRBoff(INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
	b_SetImmTypeValueMRBoff(INT, _TWO, D_WorkExcepArgPos);
	goto exception;       /* $BNc30=hM}(B */
      }
    }

    $USE(D_WorkExcpMask);
    p_ReadWithOffset(I_ParamVect,_CREATE_SHOEN_EXCP_MASK_OFST,D_WorkExcpMask);
    f_ActiveDeref(D_WorkExcpMask,D_Workreg1);
    s_IfNotINT(D_WorkExcpMask) {
      s_IfUnbound(D_WorkExcpMask) {
	$RELEASE(D_WorkPrioMin); $RELEASE(D_WorkPrioMax);
	$RELEASE(D_WorkNodeMin); $RELEASE(D_WorkNodeNum);
	$RELEASE(D_WorkExcpMask);
	goto make_dcode_goal; /* D$B%3!<%I%4!<%k$N%(%s%-%e!<(B */
      } else {
	$RELEASE(D_WorkPrioMin); $RELEASE(D_WorkPrioMax);
	$RELEASE(D_WorkNodeMin); $RELEASE(D_WorkNodeNum);
	$RELEASE(D_WorkExcpMask);
        $USE(D_WorkExceptionCode); $USE(D_WorkExcepArgPos);
	b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
	b_SetImmTypeValueMRBoff(INT, _TWO, D_WorkExcepArgPos);
	goto exception;       /* $BNc30=hM}(B */
      }
    }
  } else { /* s_IfNotVECT5() */
    s_IfUnbound(I_ParamVect) {
      p_MoveWord (D_Workreg1, I_ParamVect);
      goto make_dcode_goal; /* D$B%3!<%I%4!<%k$N%(%s%-%e!<(B */
    } else {
      $USE(D_WorkExceptionCode); $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff(INT, _TWO, D_WorkExcepArgPos);
      goto exception;       /* $BNc30=hM}(B */
    }
  }

  /* D_WorkNodeMin, D_WorkNodeMax $B$r;H$&$h$&$K=q49$($,I,MW(B */
  $USE(D_WorkReport);
  s_AllocVariable(D_WorkReport);
  $USE(D_WorkShoen);
  $CALL( f_CreateProfilingShoen_Sub  /* !!! Modified for Space-devision !!! */
    (D_WorkPrioMin,D_WorkPrioMax,D_WorkNodeMin,D_WorkNodeNum,D_WorkExcpMask,
     I_InitGoalCode,I_InitArgVect,D_WorkReport,D_WorkShoen) );
  p_MoveWord(D_WorkReport,I_ReportStream);
  $RELEASE(D_WorkReport);
  p_MoveWord(D_WorkShoen,I_ShoenOutput);
  $RELEASE(D_WorkShoen);
  $RELEASE(D_WorkPrioMin); $RELEASE(D_WorkPrioMax); $RELEASE(D_WorkExcpMask);
  $RELEASE(D_WorkNodeMin); $RELEASE(D_WorkNodeNum);
  goto end;

 exception:
  $USE(D_WorkOpCode);
  b_SetImmTypeValueMRBoff(INT, BLT_B_CREATE_PROFILING_SHOEN, D_WorkOpCode);
  $CALL(f_Exception_5Arg_IIIOO_Sub
        (D_WorkExceptionCode,D_WorkOpCode,D_WorkExcepArgPos,
       I_InitGoalCode,I_InitArgVect,I_ParamVect,I_ReportStream,I_ShoenOutput));

  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
  goto end;
      
/* make D-code goal D$B%3!<%I%4!<%k$r:n$C$F%(%s%-%e!<$9$k(B */
 make_dcode_goal:
  f_DcodeEnqueue5Ope_IIIOO(BLT_B_CREATE_PROFILING_SHOEN,
       I_InitGoalCode,I_InitArgVect,I_ParamVect,I_ReportStream,I_ShoenOutput);

 end:
  $RELEASE(D_Workreg1);
 End_of_KL1B_Instruction: ;
}

/******************************************************************** PSL **
b_start_shoen A1, A2

       written by nakase@icot22      Mon Jan  9 17:14:07 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |     b_start_shoen     |     A1    |     A2    | 
    +-----------+-----------+-----------+-----------+

<Arguments>

   A1       $B%l%8%9%?(B
   A2       $B%l%8%9%?(B($BAq1`=PNO(B)

<Temporally Used Variables>
<Level>
<PreCondition>

$B!&(BA1 $B$,Aq1`0J30$J$iNc30!"L$Dj5A$J$i%5%9%Z%s%I(B

<Function>

A1 $B$G<($5$l$kAq1`$r%9%?!<%H$5$;!"(BA2 $B$K(B MRB $B!{(B $B$K$7$?(B A1 $B$r=q$-9~$_!"<!L?Na$X(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_ShoenInput _IndirectRegField1
#OPF_define I_ShoenOutput _IndirectRegField2

#PSL_define kblt_b_start_shoen() 
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp2ArgVect_IO_Sub(D_WorkArgVect,
				      I_ShoenInput,I_ShoenOutput));
      f_TraceBodyBuiltin(BLT_B_START_SHOEN,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  $USE(D_Workreg1);
  f_ActiveDeref(I_ShoenInput,D_Workreg1);
  s_IfSHREC(I_ShoenInput) {
    @DEBUG{ s_IfMRBon(I_ShoenInput) {
      WARNING("kblt_b_start_shoen",
	      "SHRECx is invalid. Maybe KL1 program contains BUG");
    }};
    $RELEASE(D_Workreg1);
    $CALL( f_StartShoen_Sub(I_ShoenInput,I_ShoenOutput) );
  } else { 
    s_IfUnbound(I_ShoenInput) { /* D$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$&(B */
      p_MoveWord(D_Workreg1, I_ShoenInput);
      $RELEASE(D_Workreg1);
      f_DcodeEnqueue2Ope_IO
	(BLT_B_START_SHOEN,I_ShoenInput,I_ShoenOutput);
    } else {
      $USE(D_WorkOpCode);$USE(D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff(INT, BLT_B_START_SHOEN, D_WorkOpCode);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkExcepArgPos);
      $CALL(f_Exception_2Arg_IO_Sub
	    (D_WorkExceptionCode,D_WorkOpCode,D_WorkExcepArgPos,
	     I_ShoenInput, I_ShoenOutput));
      $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
      $RELEASE(D_WorkExcepArgPos);
      $RELEASE(D_Workreg1);
    }
  }
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
b_stop_shoen A1, A2

       written by nakase@icot22      Mon Jan  9 17:15:02 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |       stop_shoen      |     A1    |     A2    |
    +-----------+-----------+-----------+-----------+

<Arguments>

   A1       $B%l%8%9%?(B
   A2       $B%l%8%9%?(B($BAq1`=PNO(B)

<Temporally Used Variables>
<Level>
<PreCondition>

$B!&(BA1 $B$,Aq1`0J30$J$iNc30!"L$Dj5A$J$i%5%9%Z%s%I(B

<Function>

  A1 $B$G<($5$l$kAq1`$r%9%H%C%W$7!"(BA2 $B$K(B MRB $B!{(B $B$K$7$?(B A1 $B$r=q$-9~$_!"<!L?Na$X(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_ShoenInput 	_IndirectRegField1
#OPF_define I_ShoenOutput 	_IndirectRegField2

#PSL_define kblt_b_stop_shoen() 
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp2ArgVect_IO_Sub(D_WorkArgVect,
				      I_ShoenInput,I_ShoenOutput));
      f_TraceBodyBuiltin(BLT_B_STOP_SHOEN,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  $USE(D_Workreg1);
  f_ActiveDeref(I_ShoenInput,D_Workreg1);
  s_IfSHREC(I_ShoenInput) {
    $RELEASE(D_Workreg1);
    @DEBUG{ s_IfMRBon(I_ShoenInput) {
      WARNING("kblt_b_stop_shoen",
	      "SHRECx is invalid. Maybe KL1 program contains BUG");
    }};
    $CALL( f_StopShoen_Sub(I_ShoenInput,I_ShoenOutput) );
  } else {
    s_IfUnbound(I_ShoenInput) {
      p_MoveWord(D_Workreg1, I_ShoenInput);
      $RELEASE(D_Workreg1);
      f_DcodeEnqueue2Ope_IO
	(BLT_B_STOP_SHOEN,I_ShoenInput,I_ShoenOutput);
    } else {
      $RELEASE(D_Workreg1);
      $USE(D_WorkOpCode);$USE(D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff(INT, BLT_B_STOP_SHOEN, D_WorkOpCode);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkExcepArgPos);
      $CALL(f_Exception_2Arg_IO_Sub
       (D_WorkExceptionCode,D_WorkOpCode,D_WorkExcepArgPos,
	I_ShoenInput,I_ShoenOutput));
      $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
      $RELEASE(D_WorkExcepArgPos);
    }
  }
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
b_abort_shoen A1, A2

       written by nakase@icot22      Mon Jan  9 17:15:10 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |    b_abort_shoen      |     A1    |     A2    |
    +-----------+-----------+-----------+-----------+

<Arguments>

   A1       $B%l%8%9%?(B
   A2       $B%l%8%9%?(B($BAq1`=PNO(B)

<Temporally Used Variables>
<Level>
<PreCondition>

$B!&(BA1 $B$,Aq1`0J30$J$iNc30!"L$Dj5A$J$i%5%9%Z%s%I(B

<Function>

A1 $B$G<($5$l$kAq1`$r%"%\!<%H$7!"(BA2 $B$K(B MRB $B!{(B $B$K$7$?(B A1 $B$r=q$-9~$_!"<!L?Na$X(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_ShoenInput 	_IndirectRegField1
#OPF_define I_ShoenOutput 	_IndirectRegField2

#PSL_define kblt_b_abort_shoen() 
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp2ArgVect_IO_Sub(D_WorkArgVect,
				      I_ShoenInput,I_ShoenOutput));
      f_TraceBodyBuiltin(BLT_B_ABORT_SHOEN,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_Workreg1);
  f_ActiveDeref(I_ShoenInput,D_Workreg1);
  s_IfSHREC (I_ShoenInput) {
    $RELEASE(D_Workreg1);
    @DEBUG{ s_IfMRBon(I_ShoenInput) {
      WARNING("kblt_abort_shoen",
	      "SHRECx is invalid. Maybe KL1 program contains BUG");
    }};
    $CALL( f_AbortShoen_Sub(I_ShoenInput,I_ShoenOutput) );
  } else {
    s_IfUnbound(I_ShoenInput) {
      p_MoveWord(D_Workreg1, I_ShoenInput);
      $RELEASE(D_Workreg1);
      f_DcodeEnqueue2Ope_IO
	(BLT_B_ABORT_SHOEN,I_ShoenInput,I_ShoenOutput);
                                /* D$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$&(B */
    } else {
      $RELEASE(D_Workreg1);
      $USE(D_WorkOpCode);$USE(D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff(INT, BLT_B_ABORT_SHOEN, D_WorkOpCode);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkExcepArgPos);
      $CALL(f_Exception_2Arg_IO_Sub
	    (D_WorkExceptionCode,D_WorkOpCode,D_WorkExcepArgPos,
	     I_ShoenInput,I_ShoenOutput));
      $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
      $RELEASE(D_WorkExcepArgPos);
    }
  }
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **

       written by nakase@icot22      Mon Jan  9 17:15:19 1989

<Arguments>
<Temporally Used Variables>

<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  8/30/89  $B:n$i$M$P$J$i$J$$!#(B
  10/3/90  $B:n$C$?!#(B($B@n9g(B)
********************************************************************* PSL **/

#OPF_define I_ShoenInput 	_IndirectRegField1

#PSL_define kblt_b_remove_shoen() 
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp1ArgVect_I_Sub(D_WorkArgVect,I_ShoenInput));
      f_TraceBodyBuiltin(BLT_B_REMOVE_SHOEN,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_Workreg1);
  f_ActiveDeref(I_ShoenInput,D_Workreg1);
  s_IfSHREC (I_ShoenInput) {
    @DEBUG{ s_IfMRBon(I_ShoenInput) {
      WARNING("kblt_b_remove_shoen",
	      "SHRECx is invalid. Maybe KL1 program contains BUG");
    }};
    $RELEASE(D_Workreg1);
    $CALL( f_RemoveShoen_Sub(I_ShoenInput) );
  } else {
    s_IfUnbound(I_ShoenInput) {
      p_MoveWord(D_Workreg1, I_ShoenInput);
      $RELEASE(D_Workreg1);
      f_DcodeEnqueue1Ope_I(BLT_B_REMOVE_SHOEN,I_ShoenInput);
                                /* D$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$&(B */
    } else {
      $RELEASE(D_Workreg1);
      $USE(D_WorkOpCode);$USE(D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff(INT, BLT_B_REMOVE_SHOEN, D_WorkOpCode);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkExcepArgPos);
      $CALL(f_Exception_1Arg_I_Sub
       (D_WorkExceptionCode,D_WorkOpCode,D_WorkExcepArgPos,I_ShoenInput));
      $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
      $RELEASE(D_WorkExcepArgPos);
    }
  }
 End_of_KL1B_Instruction:;
}


/******************************************************************** PSL **
b_shoen_statistics A1, A2, A3

       written by nakase@icot22      Mon Jan  9 17:15:24 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |  b_shoen_statistics   |     A1    |     A2    | 
    +-----------+-----------+-----------+-----------+

<Arguments>

   A1       $B%l%8%9%?(B
   A2       $B%l%8%9%?(B($BAq1`=PNO(B)

<Temporally Used Variables>
<Level>
<PreCondition>

$B!&(BA1 $B$,Aq1`0J30$J$iNc30!"L$Dj5A$J$i%5%9%Z%s%I(B

<Function>

A1 $B$G<($5$l$kAq1`$N%l%]!<%H%9%H%j!<%`$K%j%@%/%7%g%s?t$rJV$7!"(B
A2 $B$K(B MRB $B!{(B $B$K$7$?(B A1 $B$r=q$-9~$_!"<!L?Na$X(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_ShoenInput 	_IndirectRegField1
#OPF_define I_ShoenOutput 	_IndirectRegField2

#PSL_define kblt_b_shoen_statistics() 
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp2ArgVect_IO_Sub(D_WorkArgVect,
				      I_ShoenInput,I_ShoenOutput));
      f_TraceBodyBuiltin(BLT_B_SHOEN_STATISTICS,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_Workreg1);
  f_ActiveDeref(I_ShoenInput,D_Workreg1);
  s_IfSHREC (I_ShoenInput) {
    $RELEASE(D_Workreg1);
    @DEBUG{ s_IfMRBon(I_ShoenInput) {
      WARNING("kblt_b_shoen_statistics",
	      "SHRECx is invalid. Maybe KL1 program contains BUG");
    }};
    $CALL( f_ShoenStatistics_Sub(I_ShoenInput,I_ShoenOutput) );
  } else {
    s_IfUnbound(I_ShoenInput) {
      p_MoveWord(D_Workreg1, I_ShoenInput);
      $RELEASE(D_Workreg1);
      f_DcodeEnqueue2Ope_IO
	(BLT_B_SHOEN_STATISTICS,I_ShoenInput,I_ShoenOutput);
                                /* D$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$&(B */
    } else {
      $RELEASE(D_Workreg1);
      $USE(D_WorkOpCode);$USE(D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff(INT, BLT_B_SHOEN_STATISTICS, D_WorkOpCode);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkExcepArgPos);
      $CALL(f_Exception_2Arg_IO_Sub
	    (D_WorkExceptionCode,D_WorkOpCode,D_WorkExcepArgPos,I_ShoenInput,
	I_ShoenOutput) );
      $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
      $RELEASE(D_WorkExcepArgPos);
    }
  }
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
b_add_shoen_resource A1, A2, A3

       written by nakase@icot22      Mon Jan  9 17:15:35 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |  b_add_shoen          |     A1    |     A2    | 
    |       _resource       |           |           |
    +-----------+-----------+-----------+-----------+
    |    A3     |     A4    |     don't care        |  
    +-----------+-----------+-----------+-----------+

<Arguments>

   A1       $B%l%8%9%?(B($BAq1`F~NO(B)
   A2       $B%l%8%9%?(B($B@0?tF~NO(B),resource upper
   A3       $B%l%8%9%?(B($B@0?tF~NO(B),resource lower
   A4       $B%l%8%9%?(B($BAq1`=PNO(B)

<Temporally Used Variables>
<Level>
<PreCondition>

$B!&(BA1 $B$,Aq1`0J30$J$iNc30!"L$Dj5A$J$i%5%9%Z%s%I(B
$B!&(BA2 $B$,@0?t0J30$J$iNc30!"L$Dj5A$J$i%5%9%Z%s%I(B
$B!&(BA3 $B$,@0?t0J30$J$iNc30!"L$Dj5A$J$i%5%9%Z%s%I(B

<Function>

A1 $B$G<($5$l$kAq1`$K!"(BA2(upper),A3(lower) $B$G<($5$l$k%j%@%/%7%g%s?t$rM?$(!"(B
A4 $B$K(B MRB $B!{(B $B$K$7$?(B A1 $B$r=q$-9~$_!"<!L?Na$X(B

<Examples>
<Test>
<Explanation>
<ETC>
  $BL>A0$r9M$($h$&!J#V#2$K9g$o$;$k$H$+$9$k!K(B
********************************************************************* PSL **/

#OPF_define I_ShoenInput 	_IndirectRegField1
#OPF_define I_ResourceUpper	_IndirectRegField2
#OPF_define I_ResourceLower 	_IndirectRegField3
#OPF_define I_ShoenOutput 	_IndirectRegField4

#PSL_define kblt_b_add_shoen_resource() 
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp4ArgVect_IIIO_Sub(D_WorkArgVect,
					I_ShoenInput,
					I_ResourceUpper,
					I_ResourceLower,
					I_ShoenOutput));
      f_TraceBodyBuiltin(BLT_B_ADD_SHOEN_RESOURCE,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_Workreg1);
  f_ActiveDeref(I_ShoenInput,D_Workreg1);
  s_IfSHREC(I_ShoenInput) {
    @DEBUG{ s_IfMRBon(I_ShoenInput) {
      WARNING("kblt_b_add_shoen_resource",
	      "SHRECx is invalid. Maybe KL1 program contains BUG");
    }};
    f_ActiveDeref(I_ResourceUpper,D_Workreg1);
    s_IfINT(I_ResourceUpper) {
      f_ActiveDeref(I_ResourceLower,D_Workreg1);
      s_IfINT(I_ResourceLower) {
	$RELEASE(D_Workreg1);
	$CALL( f_AddShoenResource_Sub(I_ShoenInput,I_ResourceUpper,
				      I_ResourceLower, I_ShoenOutput) );
      } else {
	s_IfUnbound(I_ResourceLower) {
	  p_MoveWord(D_Workreg1, I_ResourceLower);
	  $RELEASE(D_Workreg1);
	  f_DcodeEnqueue4Ope_IIIO
	    (BLT_B_ADD_SHOEN_RESOURCE,
	     I_ShoenInput, I_ResourceUpper,I_ResourceLower, I_ShoenOutput);
	              /* D$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$&(B */
	} else {
	  $RELEASE(D_Workreg1);
	  $USE(D_WorkOpCode);$USE(D_WorkExceptionCode);
      	  $USE(D_WorkExcepArgPos);
	  b_SetImmTypeValueMRBoff(INT, BLT_B_ADD_SHOEN_RESOURCE, D_WorkOpCode);
	  b_SetImmTypeValueMRBoff(INT,_ILLEGAL_INPUT_EXCP,D_WorkExceptionCode);
	  b_SetImmTypeValueMRBoff(INT, _TWO, D_WorkExcepArgPos);
	  $CALL(f_Exception_4Arg_IIIO_Sub
		(D_WorkExceptionCode,D_WorkOpCode,D_WorkExcepArgPos,
		 I_ShoenInput, 
		 I_ResourceUpper,I_ResourceLower, I_ShoenOutput));
	  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
      	  $RELEASE(D_WorkExcepArgPos);
	}
      }
    } else {
      s_IfUnbound(I_ResourceUpper) {
	p_MoveWord(D_Workreg1, I_ResourceUpper);
	$RELEASE(D_Workreg1);
	f_DcodeEnqueue4Ope_IIIO(BLT_B_ADD_SHOEN_RESOURCE,
	     I_ShoenInput, I_ResourceUpper,I_ResourceLower, I_ShoenOutput);
                                /* D$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$&(B */
      } else {
	$RELEASE(D_Workreg1);
	$USE(D_WorkOpCode);$USE(D_WorkExceptionCode);
	$USE(D_WorkExcepArgPos);
	b_SetImmTypeValueMRBoff(INT, BLT_B_ADD_SHOEN_RESOURCE, D_WorkOpCode);
	b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
	b_SetImmTypeValueMRBoff(INT, _ONE, D_WorkExcepArgPos);
	$CALL(f_Exception_4Arg_IIIO_Sub
	      (D_WorkExceptionCode,D_WorkOpCode,D_WorkExcepArgPos,
	       I_ShoenInput, 
	       I_ResourceUpper,I_ResourceLower, I_ShoenOutput));
	$RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
	$RELEASE(D_WorkExcepArgPos);
      }
    }
  } else {
    s_IfUnbound(I_ShoenInput) {
      p_MoveWord(D_Workreg1, I_ShoenInput);
      $RELEASE(D_Workreg1);
      f_DcodeEnqueue4Ope_IIIO(BLT_B_ADD_SHOEN_RESOURCE,
	 I_ShoenInput,I_ResourceUpper,I_ResourceLower,I_ShoenOutput);
                                /* D$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$&(B */
    } else {
      $RELEASE(D_Workreg1);
      $USE(D_WorkOpCode);$USE(D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff(INT, BLT_B_ADD_SHOEN_RESOURCE, D_WorkOpCode);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkExcepArgPos);
      $CALL(f_Exception_4Arg_IIIO_Sub
	    (D_WorkExceptionCode,D_WorkOpCode,D_WorkExcepArgPos,
	     I_ShoenInput, 
	     I_ResourceUpper,I_ResourceLower, I_ShoenOutput));
      $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
      $RELEASE(D_WorkExcepArgPos);
    }
  }
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **

       written by nakase@icot22      on Wed Mar 14 22:38:09 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_ShoenInput 	_IndirectRegField1
#OPF_define I_ShoenOutput 	_IndirectRegField2

#PSL_define kblt_b_allow_shoen_resource_report()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp2ArgVect_IO_Sub(D_WorkArgVect,
				      I_ShoenInput,I_ShoenOutput));
      f_TraceBodyBuiltin(BLT_B_ALLOW_SHOEN_RESOURCE_REPORT,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_Workreg1);
  f_ActiveDeref(I_ShoenInput,D_Workreg1);
  s_IfSHREC (I_ShoenInput) {
    $RELEASE(D_Workreg1);
    @DEBUG{ s_IfMRBon(I_ShoenInput) {
      WARNING("kblt_b_allow_shoen_resource_report",
	      "SHRECx is invalid. Maybe KL1 program contains BUG");
    }};
    $CALL( f_AllowShoenResourceReport_Sub(I_ShoenInput,I_ShoenOutput) );
  } else {
    s_IfUnbound(I_ShoenInput) {
      p_MoveWord(D_Workreg1, I_ShoenInput);
      $RELEASE(D_Workreg1);
      f_DcodeEnqueue2Ope_IO
	(BLT_B_ALLOW_SHOEN_RESOURCE_REPORT,I_ShoenInput,I_ShoenOutput);
                                /* D$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$&(B */
    } else {
      $RELEASE(D_Workreg1);
      $USE(D_WorkOpCode);$USE(D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff
	(INT, BLT_B_ALLOW_SHOEN_RESOURCE_REPORT, D_WorkOpCode);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkExcepArgPos);
      $CALL(f_Exception_2Arg_IO_Sub
       (D_WorkExceptionCode,D_WorkOpCode,D_WorkExcepArgPos,I_ShoenInput,
	I_ShoenOutput) );
      $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
      $RELEASE(D_WorkExcepArgPos);
    }
  }
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
b_shoen_profile A1, A2

       written by nakase@icot22      Mon Jan  9 17:14:07 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |     b_shoen_profile   |     A1    |     A2    | 
    +-----------+-----------+-----------+-----------+

<Arguments>

   A1       $B%l%8%9%?(B
   A2       $B%l%8%9%?(B($BAq1`=PNO(B)

<Temporally Used Variables>
<Level>
<PreCondition>

$B!&(BA1 $B$,Aq1`0J30$J$iNc30!"L$Dj5A$J$i%5%9%Z%s%I(B

<Function>

  A1 $B$G<($5$l$kAq1`$K(B Profile$BMW5a$r=P$7!"(BA2 $B$K(B MRB $B!{(B $B$K$7$?(B A1 $B$r=q$-9~$_!"(B
$B<!L?Na$X(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_ShoenInput _IndirectRegField1
#OPF_define I_ShoenOutput _IndirectRegField2

#PSL_define kblt_b_shoen_profile() 
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp2ArgVect_IO_Sub(D_WorkArgVect,
				      I_ShoenInput,I_ShoenOutput));
      f_TraceBodyBuiltin(BLT_B_SHOEN_PROFILE,D_WorkArgVect);

      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  $USE(D_Workreg1);
  f_ActiveDeref(I_ShoenInput,D_Workreg1);
  s_IfSHREC(I_ShoenInput) {
    @DEBUG{ s_IfMRBon(I_ShoenInput) {
      WARNING("kblt_b_shoen_profile",
	      "SHRECx is invalid. Maybe KL1 program contains BUG");
    }};
    $RELEASE(D_Workreg1);
    $CALL( f_ShoenProfile_Sub(I_ShoenInput,I_ShoenOutput) );
  } else { 
    s_IfUnbound(I_ShoenInput) { /* D$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$&(B */
      p_MoveWord(D_Workreg1, I_ShoenInput);
      $RELEASE(D_Workreg1);
      f_DcodeEnqueue2Ope_IO
	(BLT_B_SHOEN_PROFILE,I_ShoenInput,I_ShoenOutput);
    } else {
      p_MoveWord(D_Workreg1, I_ShoenInput);
      $USE(D_WorkOpCode);$USE(D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff(INT, BLT_B_SHOEN_PROFILE, D_WorkOpCode);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkExcepArgPos);
      $CALL(f_Exception_2Arg_IO_Sub
	    (D_WorkExceptionCode,D_WorkOpCode,D_WorkExcepArgPos,
	     I_ShoenInput, I_ShoenOutput));
      $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
      $RELEASE(D_WorkExcepArgPos);
      $RELEASE(D_Workreg1);
    }
  }
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
b_consume_resource A1, A2

       written by nakase@icot22      Mon Jan  9 17:15:35 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |  b_consume_resource   |     A1    |     A2    | 
    +-----------+-----------+-----------+-----------+

<Arguments>

   A1       $B%l%8%9%?(B($B@0?tF~NO(B),resource upper
   A2       $B%l%8%9%?(B($B@0?tF~NO(B),resource lower

<Temporally Used Variables>
<Level>
<PreCondition>

$B!&(BA1 $B$,@0?t0J30$J$iNc30!"L$Dj5A$J$i%5%9%Z%s%I(B
$B!&(BA2 $B$,@0?t0J30$J$iNc30!"L$Dj5A$J$i%5%9%Z%s%I(B

<Function>

  A1 $B$G<($5$l$kAq1`$G!"(BA2(upper),A3(lower) $B$G<($5$l$k%j%@%/%7%g%s?t$@$1;q8;$r(B
$B>CHq$7!"(BA4 $B$K(B MRB $B!{(B $B$K$7$?(B A1 $B$r=q$-9~$_!"<!L?Na$X(B

  $B$H;W$C$F$$$?$,!"$=$&$G$O$J$$$3$H$,$o$+$C$?!#(B
  $B$3$NAH9~=R8l$O!"C1$K0z?t$GEO$5$l$?$@$1$N;q8;$r>CHq$9$k%4!<%k$H$7$F(B
$B?6$kIq$&!#$D$^$j!"%+%l%s%H$NN$?F$+$i;XDj$7$?;q8;$r0z$/!#$3$N7k2L!"N$?F$,(B
$B;q8;ITB-$K$J$l$PAq1`$K;q8;MW5a$,=P$k$7!"Aq1`$N%j%_%C%H$r1[$($l$P(B resource_low
$B$,Js9p$5$l$k!#(B
  $B$^$?!";XDjJ,$N;q8;$r>CHq$G$-$J$$4V$O!"(BD$B%3!<%I$H$7$FN$?F$K$D$J$,$l$k!#(B

  $B$J$*!"$3$NAH9~=R8l$O8=:_(BMulti-PSI$B$G$b;H$o$l$F$*$i$:!">-MhE*$J<{MW$b5?Ld(B
$B$N$?$a!"<BAu$K@hN)$C$F!"(BPIMOS$B%0%k!<%W$J$I$K3NG'$9$kI,MW$,$"$k!#(B

  $B<BAu;~$K$O!"(Bklb_debug.psl.c$B$GDj5A$5$l$F$$$k(B $B%F%s%]%i%j%k!<%A%s$r:o=|$9$k(B
$BI,MW$,$"$k!#(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

/* !!! $B0l;~E`7k(B 
#OPF_define I_ShoenInput 	_IndirectRegField1
#OPF_define I_ConsumeRscUpper	_IndirectRegField2
#OPF_define I_ConsumeRscLower 	_IndirectRegField3
#OPF_define I_ShoenOutput 	_IndirectRegField4

#PSL_define kblt_b_consume_resource() 
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp4ArgVect_IIIO_Sub(D_WorkArgVect,
					I_ShoenInput,
					I_ConsumeRscUpper,
					I_ConsumeRscLower,
					I_ShoenOutput));
      f_TraceBodyBuiltin(BLT_B_CONSUME_RESOURCE,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_Workreg1);
  f_ActiveDeref(I_ShoenInput,D_Workreg1);
  s_IfSHREC(I_ShoenInput) {
    @DEBUG{ s_IfMRBon(I_ShoenInput) {
      WARNING("kblt_b_consume_resource",
	      "SHRECx is invalid. Maybe KL1 program contains BUG");
    }};
    f_ActiveDeref(I_ConsumeRscUpper,D_Workreg1);
    s_IfINT(I_ConsumeRscUpper) {
      f_ActiveDeref(I_ConsumeRscLower,D_Workreg1);
      s_IfINT(I_ConsumeRscLower) {
	$RELEASE(D_Workreg1);
	$CALL( f_ConsumeShoenResource_Sub(I_ShoenInput,I_ConsumeRscUpper,
				      I_ConsumeRscLower, I_ShoenOutput) );
			   				
      } else {
	s_IfUnbound(I_ConsumeRscLower) {
	  p_MoveWord(D_Workreg1, I_ConsumeRscLower);
	  $RELEASE(D_Workreg1);
	  f_DcodeEnqueue4Ope_IIIO
	    (BLT_B_CONSUME_RESOURCE,
	     I_ShoenInput, I_ConsumeRscUpper,I_ConsumeRscLower, I_ShoenOutput);
	              /!* D$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$&(B *!/
	} else {
	  $RELEASE(D_Workreg1);
	  $USE(D_WorkOpCode);$USE(D_WorkExceptionCode);
      	  $USE(D_WorkExcepArgPos);
	  b_SetImmTypeValueMRBoff(INT, BLT_B_CONSUME_RESOURCE, D_WorkOpCode);
	  b_SetImmTypeValueMRBoff(INT,_ILLEGAL_INPUT_EXCP,D_WorkExceptionCode);
	  b_SetImmTypeValueMRBoff(INT, _TWO, D_WorkExcepArgPos);
	  $CALL(f_Exception_4Arg_IIIO_Sub
		(D_WorkExceptionCode,D_WorkOpCode,D_WorkExcepArgPos,
		 I_ShoenInput,
		 I_ConsumeRscUpper,I_ConsumeRscLower,I_ShoenOutput));
	  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
      	  $RELEASE(D_WorkExcepArgPos);
	}
      }
    } else {
      s_IfUnbound(I_ConsumeRscUpper) {
	p_MoveWord(D_Workreg1, I_ConsumeRscUpper);
	$RELEASE(D_Workreg1);
	f_DcodeEnqueue4Ope_IIIO(BLT_B_CONSUME_RESOURCE,
	     I_ShoenInput, I_ConsumeRscUpper,I_ConsumeRscLower, I_ShoenOutput);
                                /!* D$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$&(B *!/
      } else {
	$RELEASE(D_Workreg1);
	$USE(D_WorkOpCode);$USE(D_WorkExceptionCode);
	$USE(D_WorkExcepArgPos);
	b_SetImmTypeValueMRBoff(INT, BLT_B_CONSUME_RESOURCE, D_WorkOpCode);
	b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
	b_SetImmTypeValueMRBoff(INT, _ONE, D_WorkExcepArgPos);
	$CALL(f_Exception_4Arg_IIIO_Sub
	      (D_WorkExceptionCode,D_WorkOpCode,D_WorkExcepArgPos,
	       I_ShoenInput,
	       I_ConsumeRscUpper,I_ConsumeRscLower,I_ShoenOutput));
	$RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
	$RELEASE(D_WorkExcepArgPos);
      }
    }
  } else {
    s_IfUnbound(I_ShoenInput) {
      p_MoveWord(D_Workreg1, I_ShoenInput);
      $RELEASE(D_Workreg1);
      f_DcodeEnqueue4Ope_IIIO(BLT_B_CONSUME_RESOURCE,
	 I_ShoenInput,I_ConsumeRscUpper,I_ConsumeRscLower,I_ShoenOutput);
                                /!* D$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$&(B *!/
    } else {
      $RELEASE(D_Workreg1);
      $USE(D_WorkOpCode);$USE(D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff(INT, BLT_B_CONSUME_RESOURCE, D_WorkOpCode);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkExcepArgPos);
      $CALL(f_Exception_4Arg_IIIO_Sub
	    (D_WorkExceptionCode,D_WorkOpCode,D_WorkExcepArgPos,
	       I_ShoenInput,
	       I_ConsumeRscUpper,I_ConsumeRscLower,I_ShoenOutput));
      $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
      $RELEASE(D_WorkExcepArgPos);
    }
  }
 End_of_KL1B_Instruction:;
}
 $B0l;~E`7k(B !!! */


/******************************************************************** PSL **
kblt_b_raise   A1, A2, A3

       written by nakase@icot22      on Tue Feb 13 19:32:49 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |      b_raise          |     A1    |     A2    | 
    +-----------+-----------+-----------+-----------+
    |   A3      |            don't care             |
    +-----------+-----------+-----------+-----------+

<Arguments>
  I_Tag:   $BNc30%?%0!J%f!<%6$,;XDj!K(B
  I_Info:  $B$J$s$G$b$"$j$i$7$$!JC"$79=B$BN$NCf$NMWAG$^$GA4$F6qBN2=$7$F$$$k$3$H!K(B
  I_Data:  $B$J$s$G$b$"$j$i$7$$!JJQ?t$G$b2?$G$b$"$j!K(B 
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  
<ETC>
********************************************************************* PSL **/

#OPF_define I_Tag   _IndirectRegField1
#OPF_define I_Info  _IndirectRegField2
#OPF_define I_Data  _IndirectRegField3

#PSL_define kblt_b_raise()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_III_Sub(D_WorkArgVect,
				       I_Tag, I_Info, I_Data) );
      f_TraceBodyBuiltin(BLT_B_RAISE,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  $USE(D_Workreg1);
  f_ActiveDeref(I_Tag, D_Workreg1);
  s_IfINT(I_Tag){
    $RELEASE(D_Workreg1);
    $CALL(f_Raise_Sub(I_Tag, I_Info, I_Data) );
  } else {
    s_IfUnbound(I_Tag){
      p_MoveWord(D_Workreg1, I_Tag);
      $RELEASE(D_Workreg1);
      f_DcodeEnqueue3Ope_III(BLT_B_RAISE, I_Tag, I_Info, I_Data);
    } else {
      $RELEASE(D_Workreg1);
      $USE(D_WorkOpCode);$USE(D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff(INT, BLT_B_RAISE, D_WorkOpCode);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkExcepArgPos);
      $CALL(f_Exception_3Arg_III_Sub
	    (D_WorkExceptionCode,D_WorkOpCode,D_WorkExcepArgPos,
	     I_Tag, I_Info, I_Data) );
      $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
      $RELEASE(D_WorkExcepArgPos);
    }      
  }
 End_of_KL1B_Instruction:;
}
